<?php

function array_is_associative ($array)
{
    if ( is_array($array) && ! empty($array) )
    {
        for ( $iterator = count($array) - 1; $iterator; $iterator-- )
        {
            if ( ! array_key_exists($iterator, $array) ) { return true; }
        }
        return ! array_key_exists(0, $array);
    }
    return false;
}


function simple_json_encode($value)
{
	$rtval = '';
	if(is_array($value))
	{
		if(array_is_associative($value))
		{
			$data = array();
			foreach($value as $key=>$val)
				$data[] = simple_json_encode($key).": ".simple_json_encode($val);
			$rtval = '{'.implode(',',$data).'}';
		}
		else
		{
			$rtval = '['.implode(',',array_map('simple_json_encode',$value)).']';
		}
		
	}elseif(is_numeric($value))
		$rtval = $value;
	elseif(is_bool($value))
		$rtval = $value?'true':'false';
	elseif(is_string($value))
		//$rtval = '"'.preg_replace('/%([0-9A-F]{2})%([0-9A-F]{2})/i','\u\\1\\2', urlencode((addslashes($value)))).'"';
		$rtval = '"'.(addslashes($value)).'"';
	return $rtval;
}

include "klasy/adcentral.php";
function category_json_encode($id, $_adcentral=null)
{
	if($_adcentral)
		$adcentral = $_adcentral;
	else
		$adcentral = new adcentral();
	if($id==-1)
		die('[]');
	$kategoria = $adcentral->kategoria($id);
	$tmp_dic = array();
	foreach($kategoria->pod_kategorie->item as $kat)
	{
	  $tmp_dic[] = array('id'=>(int)$kat->id, 'nazwa'=>(string)$kat->nazwa, 'opis'=>(string)$kat->opis, 'lisc'=>$kat->lisc=='T');
	}
	
	return simple_json_encode($tmp_dic);
}
?>
