<?php
/**
 * Skrypt sucy do integracji z porwnywark cenow NOKAUT.PL
 *
 * Licencja: GPL
 *
 * Skrypt zosta przetestowany na osCommerce 2.2 bez dodatkowych moduw
 *
 * W przypadku jakichkolwiek problemw z integracj sklepu,
 * prosimy o kontakt pod adresem integracja@nokaut.pl
 *
 * Informacje o integracji dostpne s pod adresem http://www.nokaut.pl/integracja.html
 */
@set_time_limit(3600);
// haso blokujce dostp do danych o ofercie osobom trzecim
define('NOKAUTXMLPASSWORD','0c8b0fab76e6a28d856553315ec310616b233400');
define('PLUGINVER','7');
define('DISPLAY_PRICE_WITH_TAX',true);

function stripnonpt($st) { 
        $st = ereg_replace("[^[:print:]\xb1\xe6\xea\xb3\xf1\xf3\xb6\xbc\xbf\xa1\xc6\xca\xa3\xd1\xd3\xa6\xac\xaf]", "", $st); 
	    return $st;
}
/*
if (NOKAUTXMLPASSWORD!=$_GET['kod']){
    print <<<END
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl" lang="pl">
<head>
<title>Nokaut.pl - wtyczka dla osCommerce</title>
<meta name="Description" content="" />
<meta name="Author" content="Nokaut.pl, www.nokaut.pl" />
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
</head>
<body>
<a href="http://www.nokaut.pl/sprzedawca/" ><img src="http://img1.nokaut.pl/logo/nokaut.png" style="border:0;"></a>
<div style="background-color: white; border: 2px solid blue; padding: 8px">
Wtyczka zostaa zainstalowana poprawnie.<br/> W przypadku pyta prosimy o kontakt z obsug Nokaut.pl.
</div>
END;
$passMD5=MD5(NOKAUTXMLPASSWORD);
$ver=PLUGINVER;
	print <<<END
<div style="background-color: white; border: 2px solid green; padding: 8px">
Informacje diagnostycznie dla pracownikw Nokaut.pl.<br/>
Hash hasa = {$passMD5}<br/>
Wersja wtyczki = {$ver}<br/>
END;
if (isset($_GET['kod'])){
	print <<<END
	Podany kod autoryzacji jest bdny.<br/>
END;
} 

	print <<<END
</div>
END;
	print <<<END
</body>
</html>
END;
	die();
}
*/

$kod_we = 'utf-8';
$kod_wy = 'iso-8859-2';

header('Content-Type: text/xml');

require('includes/application_top.php'); 

$openingTag = '<' . '?';
$closingTag = '?' . '>';

print("{$openingTag}xml version=\"1.0\" encoding=\"ISO-8859-2\"{$closingTag}\n");
print("<!DOCTYPE nokaut SYSTEM \"http://www.nokaut.pl/integracja/nokaut.dtd\">\n");
print("<nokaut>\n");
print("    <version>".PLUGINVER."</version>\n");
print("    <offers>\n");

// POBIERANIE DANYCH O JZYKU
$osLanguage = "pl";
$currency = "PLN";
$sql="SELECT languages_id FROM ".TABLE_LANGUAGES." WHERE code = '".$osLanguage."'";
$osLanguageQuery = tep_db_query($sql);
$_language = tep_db_fetch_array($osLanguageQuery);
$osLanguageId = $_language['languages_id'];
if (!$osLanguageId){
	$osLanguage = "en";
	$currency = "PLN";
	$sql="SELECT languages_id FROM ".TABLE_LANGUAGES." WHERE code = '".$osLanguage."'";
	$osLanguageQuery = tep_db_query($sql);
	$_language = tep_db_fetch_array($osLanguageQuery);
	$osLanguageId = $_language['languages_id'];
}

//POBIERANIE I BUDOWANA DRZEWA KATEGORII
$sql="  
		SELECT c.categories_id,c.parent_id,cd.language_id,cd.categories_name
        FROM ".TABLE_CATEGORIES." c
        INNER JOIN ".TABLE_CATEGORIES_DESCRIPTION." cd ON c.categories_id = cd.categories_id AND cd.language_id=".$osLanguageId;
        
$categoryTreeQuery=tep_db_query($sql);
$categoryArray=array();
while($categoryInfo = tep_db_fetch_array($categoryTreeQuery)){
     $categoryArray[$categoryInfo['language_id']][$categoryInfo['categories_id']]=$categoryInfo;
}
foreach ($categoryArray[$osLanguageId] as $category){
         $categoryParent=$categoryArray[$osLanguageId][$category['categories_id']]['parent_id'];
         $categoryPatch=$categoryArray[$osLanguageId][$category['categories_id']]['categories_name'];
         $counter=0; 
         while ($categoryParent){
                $counter++;
                if ($counter>500) break;
                $categoryPatch=$categoryArray[$osLanguageId][$categoryParent]['categories_name']." / ".$categoryPatch;
                $categoryParent=$categoryArray[$osLanguageId][$categoryParent]['parent_id'];
         }
         $categoryArray[$osLanguageId][$category['categories_id']]['patch']=$categoryPatch;
}

//POBIERANIE INFORMACJI O PODATKU
$sql="SELECT tax_class_id FROM tax_class";
$taxClass = tep_db_query($sql);
$taxArray=array();
if (tep_db_num_rows($taxClass)) {
    while($taxInfo = tep_db_fetch_array($taxClass)){
		$taxArray[$taxInfo['tax_class_id']]=tep_get_tax_rate($taxInfo['tax_class_id']);
    }
}

//POBIERANIE DANYCH O PRODUKTACH
$sql="
		SELECT pd.products_name, p.products_id,  pd.products_description,  p.products_image, p.products_price,p.products_tax_class_id,cd.categories_id,m.manufacturers_name,
        p.products_quantity,p.products_model,s.specials_new_products_price
        FROM ".TABLE_PRODUCTS." p 
        INNER JOIN ".TABLE_PRODUCTS_DESCRIPTION." pd ON pd.products_id = p.products_id AND pd.language_id={$osLanguageId}
        INNER JOIN ".TABLE_PRODUCTS_TO_CATEGORIES." ptc ON p.products_id=ptc.products_id
        INNER JOIN ".TABLE_CATEGORIES_DESCRIPTION." cd ON ptc.categories_id=cd.categories_id AND cd.language_id={$osLanguageId}
        LEFT JOIN ".TABLE_MANUFACTURERS." m ON p.manufacturers_id=m.manufacturers_id
        LEFT JOIN specials s ON p.products_id=s.products_id AND s.status=1 
        WHERE p.products_status = '1'
	 	";
$productQuery = tep_db_query($sql);

if (tep_db_num_rows($productQuery)) {
    while($productInfo = tep_db_fetch_array($productQuery)){

    	    $productInfo['products_name']=iconv($kod_we, $kod_wy, $productInfo['products_name']);
    	    $productInfo['products_description']=iconv($kod_we, $kod_wy, $productInfo['products_description']);
    	  
          $productInfo['category']=iconv($kod_we, $kod_wy, $categoryArray[$osLanguageId][$productInfo['categories_id']]['patch']);
	
	        $productInfo['products_name'] = stripnonpt($productInfo['products_name']);

          $productInfo['products_description'] = stripnonpt($productInfo['products_description']);

          print("        <offer>\n");
          print("            <name><![CDATA[".$productInfo['products_name']."]]></name>\n");
          print("            <id><![CDATA[".$productInfo['products_id']."]]></id>\n");
          print("            <description><![CDATA[".$productInfo['products_description']."]]></description>\n");
          print("            <url><![CDATA[".tep_href_link(FILENAME_PRODUCT_INFO, "products_id=".$productInfo["products_id"],NONSSL,false)."]]></url>\n");
          print("            <price><![CDATA[".($productInfo['specials_new_products_price']?($productInfo['specials_new_products_price']*(1+$taxArray[$productInfo['products_tax_class_id']]/100)):($productInfo['products_price']*(1+$taxArray[$productInfo['products_tax_class_id']]/100)))."]]></price>\n");
          print("            <category><![CDATA[".$productInfo['category']."]]></category>\n");
          print("            <producer><![CDATA[".iconv($kod_we, $kod_wy, $productInfo['manufacturers_name'])."]]></producer>\n");
          print("            <image><![CDATA[".HTTP_SERVER.DIR_WS_HTTP_CATALOG.DIR_WS_IMAGES.$productInfo["products_image"]."]]></image>\n");
          print("            <instock><![CDATA[".$productInfo['products_quantity']."]]></instock>\n");
          print("            <variant><![CDATA[".$productInfo['products_model']."]]></variant>\n");
          
          //POBIERANIE WACIWOCI PRODUKTU
          $sql="
          		SELECT products_options_name,products_options_values_name FROM products_attributes 
				LEFT JOIN products_options ON products_options.products_options_id=options_id 
				LEFT JOIN products_options_values ON products_options_values.products_options_values_id=products_attributes.options_values_id 
				WHERE products_id={$productInfo['products_id']} AND products_options.language_id={$osLanguageId} AND products_options_values.language_id={$osLanguageId}";
		  $productProperty = tep_db_query($sql);
		  if (tep_db_num_rows($productProperty)) {
    	  	 while($productPropertyInfo = tep_db_fetch_array($productProperty)){
    	  	 	print("            <property name=\"".strip_tags(iconv($kod_we, $kod_wy, $productPropertyInfo['products_options_name']))."\"><![CDATA[".$productPropertyInfo['products_options_values_name']."]]></property>\n");	
    	  	 }
		  }
          print("        </offer>\n");
    }
}
print("    </offers>\n");
print("</nokaut>\n");
?>