<?php
/*
  catimagessetup.php
  setup file for existing osCommerce installations installing categories images contribution 
  http://www.oscommerce.com/community/contributions,2409 
  
  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2004 osCommerce
  Copyright (c) 2004 Joseph Passavanti joseph@xtremecorponline.com

  Released under the GNU General Public License

  mod oscGold 2.0 by Jacek Krysiak http://www.oscgold.com
*/

  require('includes/application_top.php');

// data
$this_file_name = 'catimagessetup.php';
$this_file = DIR_FS_ADMIN.$this_file_name;
$main_admin_url = HTTP_SERVER.DIR_WS_ADMIN;
if (isset($HTTP_GET_VARS['step'])) {
$step = $HTTP_GET_VARS['step'];
} else {
$step = '1';
}
if (ini_get('safe_mode')) {
$safe_mode = true;
$safe_mode_message = 'Safe mode appears to be enabled.  This script will not work.  You cannot continue.';
} else {
$safe_mode = false;
$safe_mode_message = 'Safe mode appears to be disabled.  This script should work.  You can continue.';
}
if (is_dir(DIR_FS_CATALOG_IMAGES)) {
$dir_check = '<td class="displayData">Directory is present';
} else {
$dir_check = '<td class="displayDataBad">Directory is not present.  Fix and refresh this page.';
$next_step = true;
}
if (is_writeable(DIR_FS_CATALOG_IMAGES)) {
$dir_write = '<td class="displayData">Directory is writeable';
} else {
$dir_write = '<td class="displayDataBad">Directory is not writeable.  Fix and refresh this page.';
$next_step = true;
}
$prod_results = tep_db_query("select * FROM products limit 1");
$i = 0;
while ($i < mysql_num_fields($prod_results)) {
$meta = mysql_fetch_field($prod_results, $i);
$prod_fields[$i] = $meta->name;
$i++;
}
if (in_array('products_image', $prod_fields)) {
$prod_field = '<td class="displayData">column "products_image" is present';
} else {
$prod_field = '<td class="displayDataBad">column "products_image" is not present.';
$next_step = true;
}
$cat_results = tep_db_query("select * FROM categories limit 1");
$i = 0;
while ($i < mysql_num_fields($cat_results)) {
$meta = mysql_fetch_field($cat_results, $i);
$cat_fields[$i] = $meta->name;
$i++;
}
if (in_array('categories_image', $cat_fields)) {
$cat_field = '<td class="displayData">column "categories_image" is present';
} else {
$cat_field = '<td class="displayDataBad">column "categories_image" is not present.';
$next_step = true;
}
$ptoc_query = tep_db_query("show tables like 'products_to_categories'");
$ptoc_results = tep_db_num_rows($ptoc_query);
if ($ptoc_results > 0) {
$ptoc_field = '<td class="displayData">table "products_to_categories" is present';
} else {
$ptoc_field = '<td class="displayDataBad">table "products_to_categories" is not present.';
$next_step = true;
}
$ref = $HTTP_POST_VARS['ref'];

// constants
$page_title = 'osCommerce Categories/Images contribution setup for existing installations';
$contrib_url = '<a href="http://www.oscommerce.com/community/contributions,2409">http://www.oscommerce.com/community/contributions,2409</a>';
$support = '<strong>Make sure and do your backups, especially the database, as this script changes all your image locations in the database!!!</strong><br><strong>I am not responsible for any loss of data!!!</strong>';

if ($safe_mode == false) {

switch ($step) {

case '1':
// step 1
$display[] = array('1' => '<tr>', '2' => '', '3' => '<td align="center"><strong>'.$safe_mode_message.'</strong></td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '', '3' => '<td align="center" colspan="2"><form method="post" action="catimagessetup.php?step=2"><input type="hidden" name="ref" value="1"><input type="submit" value="Next"></form>', '4' => '</tr>');
break;

case '2':
if ($ref == '1') {
// step 2
$display[] = array('1' => '<tr>', '2' => '', '3' => '<td align="center" colspan="2"><strong>Please verify all information before continuing.</strong></td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center" class="displayDataheading">Setting:&nbsp;&nbsp;&nbsp;&nbsp;</td>', '3' => '<td align="center" class="displayDataheading">Value:&nbsp;&nbsp;&nbsp;&nbsp;</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayData">This File</td>', '3' => '<td class="displayData">'.$this_file.'</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayData">Admin URL</td>', '3' => '<td class="displayData"><a href="">'.$main_admin_url.'</a></td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayData">File System Catalog Images Folder</td>', '3' => '<td class="displayData">'.DIR_FS_CATALOG_IMAGES.'&nbsp;&nbsp;</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td>&nbsp;</td>', '3' => $dir_check.'</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td>&nbsp;</td>', '3' => $dir_write.'</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayData">Website Catalog Images Folder</td>', '3' => '<td class="displayData">'.DIR_WS_CATALOG_IMAGES.'&nbsp;&nbsp;</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayData">Category images field in correct database table</td>', '3' => $cat_field.'</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayData">Product images field in correct database table</td>', '3' => $prod_field.'</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayData">Table: products_to_categories is in database</td>', '3' => $ptoc_field.'</td>', '4' => '</tr>');
if ($next_step == false) {
$display[] = array('1' => '<tr>', '2' => '', '3' => '<td align="center" colspan="2"><form method="post" action="catimagessetup.php?step=3"><input type="hidden" name="ref" value="2"><input type="submit" value="Next"></form>', '4' => '</tr>');
}
} else {
tep_redirect($this_file_name);
}
break;

case '3':
if ($ref == '2') {
// step 3
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2" class="displayDataheading">Below is your category tree:</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td class="displayDataHeading">Category</td>', '3' => '<td class="displayDataHeading">New Folder to be Created</td>', '4' => '</tr>');
$tree = tep_get_category_tree('','','0');
$o = sizeof($tree);
for ($b=0;$b<$o;$b++) {
$display[] = array('1' => '<tr>', '2' => '<td nowrap>'.$tree[$b]['text'].'</td>', '3' => '<td nowrap class="displayData">'.DIR_FS_CATALOG_IMAGES.tep_output_generated_category_path_fs($tree[$b]['id']).'</td>', '4' => '</tr>');
}
$display[] = array('1' => '<tr>', '2' => '', '3' => '<td align="center" colspan="2"><form method="post" action="catimagessetup.php?step=4"><input type="hidden" name="ref" value="3"><input type="submit" value="Next"></form>', '4' => '</tr>');
} else {
tep_redirect($this_file_name);
}
break;

case '4':
if ($ref == '3') {
// step 4
// create folders and move category images
tep_db_query("ALTER TABLE categories CHANGE categories_image categories_image VARCHAR( 120 ) DEFAULT NULL");
$list_output .= '<?php' . "\n";
$tree = tep_get_category_tree('','','0');
$o = sizeof($tree);
for ($b=0;$b<$o;$b++) {
$image_query = tep_db_query("select categories_image as ci from categories where categories_id = '".$tree[$b]['id']."'");
$image_results = tep_db_fetch_array($image_query);
$image_name = $image_results['ci'];
$new_dir = tep_output_generated_category_path_fs($tree[$b]['id']);
$dir_to_make = DIR_FS_CATALOG_IMAGES.$new_dir;
$old_file = DIR_FS_CATALOG_IMAGES.$image_name;
$new_file = $dir_to_make.$image_name;
$new_db_file = $new_dir.$image_name;
mkdir($dir_to_make,0755);
chmod($dir_to_make,0777);
if (($image_name != '') && (file_exists($old_file))) {
copy($old_file, $new_file);
tep_db_query("update categories set categories_image = '".$new_db_file."' where categories_id = '".$tree[$b]['id']."'");
$list_output .= 'image['.$b.'] = ' . $old_file . ';' . "\n";
}
}
$list_output .= '?>';
$output_file = DIR_FS_CATALOG_IMAGES . 'toutput.php';
$fp = fopen($output_file, "w");
fwrite($fp, $list_output);
fclose($fp);
$url = $this_file_name.'?step=5';
tep_redirect($url);
} else {
tep_redirect($this_file_name);
}
break;

case '5':
// display images in new folder tree
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Categories folders created</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Below is a sample (5 categories) of the new images folder tree</td>', '3' => '', '4' => '</tr>');
$image_query = tep_db_query("select categories.categories_image as ci, categories.categories_id as cid, categories_description.categories_name from categories, categories_description where length(categories_image) > 0 and categories.categories_id = categories_description.categories_id and categories_description.language_id = '1' limit 5");
while ($image_results = tep_db_fetch_array($image_query)) {
$image_name = $image_results['ci'];
$cat_name = $image_results['categories_name'];
$display[] = array('1' => '<tr>', '2' => '<td valign="top" class="displayData" nowrap>' . $cat_name . '</td>', '3' => '<td class="displayData" valign="top" align="center">' . DIR_FS_CATALOG_IMAGES.$image_name . '</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td valign="top">&nbsp;</td>', '3' => '<td valign="top" align="center">'.tep_image(DIR_WS_CATALOG_IMAGES.$image_name).'</td>', '4' => '</tr>');
}
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">The last step will move all the products images</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Click either link below to continue<br>(Keep Images = original category images will be kept in '.DIR_FS_CATALOG_IMAGES.')<br>(Delete Images = original category images will be deleted from '.DIR_FS_CATALOG_IMAGES.')</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center"><form method="post" action="catimagessetup.php?step=5a"><input type="hidden" name="ref" value="5"><input type="submit" value="Keep Images"></form></td>', '3' => '<td align="center"><form method="post" action="catimagessetup.php?step=5b"><input type="hidden" name="ref" value="5"><input type="submit" value="Delete Images"></form></td>', '4' => '</tr>');
break;

case '5a':
if ($ref == '5') {
unlink(DIR_FS_CATALOG_IMAGES . 'toutput.php');
$url = $this_file_name.'?step=5c';
tep_redirect($url);
} else {
tep_redirect($this_file_name);
}
break;

case '5b':
if ($ref == '5') {
include(DIR_FS_CATALOG_IMAGES . 'toutput.php');
$o = sizeof($image);
for ($a=0;$a<$o;$a++) {
unlink($image[$a]);
}
unlink(DIR_FS_CATALOG_IMAGES . 'toutput.php');
$url = $this_file_name.'?step=5c';
tep_redirect($url);
} else {
tep_redirect($this_file_name);
}
break;

case '5c':
tep_db_query("ALTER TABLE products CHANGE products_image products_image VARCHAR( 120 ) DEFAULT NULL ");
$list_output = '<?php' . "\n";
$a = 0;
$products_query = tep_db_query("select products_id, products_image from products where length(products_image) > 0");
while ($pid_r = tep_db_fetch_array($products_query)) {
$pid = $pid_r['products_id'];
$pim = $pid_r['products_image'];
$cat_query = tep_db_query("select categories_id from products_to_categories where products_id = '".$pid."' limit 1");
$cat_res = tep_db_fetch_array($cat_query);
$cat_id = $cat_res['categories_id'];
$new_dir = tep_output_generated_category_path_fs($cat_id);
$dir_to_make = DIR_FS_CATALOG_IMAGES.$new_dir;
$old_file = DIR_FS_CATALOG_IMAGES.$pim;
$new_file = $dir_to_make.$pim;
$new_db_file = $new_dir.$pim;
if (file_exists($old_file)) {
copy($old_file, $new_file);
tep_db_query("update products set products_image = '".$new_db_file."' where products_id = '".$pid."'");
$list_output .= 'image['.$a.'] = ' . $old_file . ';' . "\n";
$a++;
}
}
$list_output .= '?>';
$output_file = DIR_FS_CATALOG_IMAGES . 'poutput.php';
$fp = fopen($output_file, "w");
fwrite($fp, $list_output);
fclose($fp);
$url = $this_file_name.'?step=5d';
tep_redirect($url);
break;

case '5d':
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Products images copied</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Below is a sample (5 products) of the new products images</td>', '3' => '', '4' => '</tr>');
$pids_query = tep_db_query("select products.products_id, products_image, products_name from products, products_description where products.products_id = products_description.products_id limit 5");
while ($pids_r = tep_db_fetch_array($pids_query)) {
$display[] = array('1' => '<tr>', '2' => '<td valign="top" class="displayData" nowrap>' . $pids_r['products_id'] . ':' . $pids_r['products_name'] . '</td>', '3' => '<td class="displayData" valign="top" align="center">' . DIR_FS_CATALOG_IMAGES.$pids_r['products_image'] . '</td>', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td valign="top">&nbsp;</td>', '3' => '<td valign="top" align="center">'.tep_image(DIR_WS_CATALOG_IMAGES.$pids_r['products_image']).'</td>', '4' => '</tr>');
}
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Click either link below to finish<br>(Keep Images = original product images will be kept in '.DIR_FS_CATALOG_IMAGES.')<br>(Delete Images = original product images will be deleted from '.DIR_FS_CATALOG_IMAGES.')</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center"><form method="post" action="catimagessetup.php?step=5e"><input type="hidden" name="act" value="keep"><input type="hidden" name="ref" value="5d"><input type="submit" value="Keep Images"></form></td>', '3' => '<td align="center"><form method="post" action="catimagessetup.php?step=5e"><input type="hidden" name="act" value="del"><input type="hidden" name="ref" value="5d"><input type="submit" value="Delete Images"></form></td>', '4' => '</tr>');
break;

case '5e':
if ($ref == '5d') {
switch ($HTTP_POST_VARS['act']) {
case 'keep':
unlink(DIR_FS_CATALOG_IMAGES . 'poutput.php');
break;
case 'del':
include(DIR_FS_CATALOG_IMAGES . 'poutput.php');
$p = sizeof($image);
for ($a=0;$a<$p;$a++) {
unlink($image[$a]);
}
unlink(DIR_FS_CATALOG_IMAGES . 'poutput.php');
break;
}
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Finished!</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">Please delete this file:</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2">'.$this_file.'</td>', '3' => '', '4' => '</tr>');
$display[] = array('1' => '<tr>', '2' => '<td align="center" colspan="2"><a href="'.$main_admin_url.'">Return to store admin</a></td>', '3' => '', '4' => '</tr>');
} else {
tep_redirect($this_file_name);
}
break;
}
} 
else { // safe mode enabled error
$display[] = array('1' => '<tr>', '2' => '', '3' => '<td align="center"><strong>'.$safe_mode_message.'</strong></td>', '4' => '</tr>');
}
?>
<html>
<head>
<title>osCommerce Categories/Images contribution setup for existing installations</title>
<STYLE TYPE="text/css">
<!--
  BODY  { color: black; }
  p.top { font-size: medium; color: blue; }
  td.displayData { font-size: smaller; color: black; background-color: yellow; }
  td.displayDataBad { font-size: smaller; color: black; background-color: red; }  
  td.displayDataheading { font-size: small; font-weight: bold; color: black; }  
-->
</STYLE>
</head>
<body>
<p align="center" class="top"><?php echo $page_title; ?></p>
<p align="center" class="top"><?php echo $contrib_url; ?></p>
<p align="center" class="top"><?php echo $support; ?></p>
<p align="center">&nbsp;</p>
<p><table border="0">
<?php
$n = sizeof($display);
for ($a=0;$a<$n;$a++) {
echo $display[$a]['1'];
echo $display[$a]['2'];
echo $display[$a]['3'];
echo $display[$a]['4'];
}
?>
</table></p>
</body>
</html>