<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

    Listing::postGet(basename($_SERVER['SCRIPT_NAME']));

    $ilosc_wynikow = '30';

    $zapytanie = "SELECT * FROM comparisons";
    $sql = $db->open_query($zapytanie);

    // tworzenie paska do nastepnych okien - obliczanie ile bedzie podstron
    $ile_pozycji = (int)$db->ile_rekordow($sql); // ile jest wszystkich produktow
    $ile_licznika = ($ile_pozycji / $ilosc_wynikow);
    if ($ile_licznika == (int)$ile_licznika) { $ile_licznika = (int)$ile_licznika; } else { $ile_licznika = (int)$ile_licznika+1; }
    $db->close_query($sql);

    // ******************************************************************************************************************************************************************
    // obsluga listingu AJAX
    if (isset($_GET['parametr'])) {

        if ($ile_pozycji > 0) {
            
            // informacje o produktach - zakres
            $zapytanie .= " limit ".$_GET['parametr'];
            $sql = $db->open_query($zapytanie);

            $listing_danych = new Listing();
            
            $tablica_naglowek = array(array('ID','center'),
                                      array(''),
                                      array('Nazwa'),
                                      array('Typ eksportu','center'),
                                      array('Data eksportu','center'),
                                      array('Ilość wyeksportowanych produktów','center'));
                                      
            echo $listing_danych->naglowek($tablica_naglowek);
            
            $tekst = '';
            while ($info = $sql->fetch_assoc()) {
                
                  $wycofana = false;
                  if ( $info['comparisons_name'] == 'Cenuj.pl' ) {
                       $wycofana = true;
                  }
                  if ( $info['comparisons_name'] == 'Oferciak.pl' ) {
                       $wycofana = true;
                  }                  
                  if ( $info['comparisons_name'] == 'ToTu.pl' ) {
                       $wycofana = true;
                  }   
                  if ( $info['comparisons_name'] == 'Alejahandlowa.pl' ) {
                       $wycofana = true;
                  } 
                  
                  if (isset($_GET['id_poz']) && (int)$_GET['id_poz'] == $info['comparisons_id']) {
                     $tekst .= '<tr class="pozycja_on' . (($wycofana == true) ? ' WycofanaKratka' : '') . '" id="sk_'.$info['comparisons_id'].'">';
                   } else {
                     $tekst .= '<tr class="pozycja_off' . (($wycofana == true) ? ' WycofanaKratka' : '') . '" id="sk_'.$info['comparisons_id'].'">';
                  }    

                  if ( $info['comparisons_export_type'] == '1' ) {
                    $tryb_eksportu = 'tylko zaznaczone produkty';
                  } elseif (  $info['comparisons_export_type'] == '2' ) {
                    $tryb_eksportu = 'tylko zaznaczone kategorie';
                  } elseif (  $info['comparisons_export_type'] == '3' ) {
                    $tryb_eksportu = 'tylko wybrani producenci';                    
                  } else {
                    $tryb_eksportu = 'wszystkie produkty';
                  }
                  $tablica = array(array($info['comparisons_id'] . (($wycofana == true) ? '<br /><em class="WycofanaIkona TipChmurka"><b>Porównywarka zawiesiła działalność</b><img src="obrazki/uwaga.png" alt="Wycofana" /></em>' : ''),'center'),
                                   array('<img src="obrazki/porownywarki/'.$info['comparisons_plugin'].'.png" alt="" />','center', 'padding:0px;'),
                                   array($info['comparisons_name']),
                                   array($tryb_eksportu,'center'),
                                   array( ($info['comparisons_last_export'] != '' && $info['comparisons_last_export'] != '0000-00-00 00:00:00' ? date('d-m-Y H:i',strtotime($info['comparisons_last_export'])) : '---' ),'center'),
                                   array( ($info['comparisons_products_exported'] != '0' ? $info['comparisons_products_exported'] : '---'),'center'));
                                   
                  $tekst .= $listing_danych->pozycje($tablica);
                  
                  $tekst .= '<td class="rg_right IkonyPionowo">';
                  
                  $zmienne_do_przekazania = '?id_poz='.$info['comparisons_id'];
                  
                  $tekst .= '<a class="TipChmurka" href="porownywarki/porownywarki_eksport.php'.$zmienne_do_przekazania.'"><b>Wykonanie eksportu do porównywarki</b><img src="obrazki/xml_maly.png" alt="Wykonanie eksportu do porównywarki" /></a>';
                  $tekst .= '<a class="TipChmurka" href="porownywarki/porownywarki_edytuj.php'.$zmienne_do_przekazania.'"><b>Edytuj</b><img src="obrazki/edytuj.png" alt="Edytuj" /></a>';
                  
                  if ( file_exists('../xml/'.$info['comparisons_plugin'].'.xml') ) {
                    $tekst .= '<a class="TipChmurka" href="../xml/'.$info['comparisons_plugin'].'.xml"><b>Przejrzyj plik</b><img src="obrazki/zobacz.png" alt="Przejrzyj plik" /></a>';
                  } else {
                    $tekst .= '<em class="TipChmurka"><b>Przejrzyj plik</b><img src="obrazki/zobacz_off.png" alt="Przejrzyj plik" /></em>';
                  }

                  $tekst .= '</td></tr>';
                  
            } 
            $tekst .= '</table>';
            //
            echo $tekst;
            //
            $db->close_query($sql);
            unset($listing_danych,$tekst,$tablica,$tablica_naglowek);        

        }
    }  
    
    // ******************************************************************************************************************************************************************
    // wyswietlanie listingu
    if (!isset($_GET['parametr'])) { 

        // wczytanie naglowka HTML
        include('naglowek.inc.php');
        ?>

        <div id="caly_listing">
        
            <div id="ajax"></div>
            
            <div id="naglowek_cont">Porównywarki produktów</div>     

            <div id="wynik_zapytania"></div>
            <div id="aktualna_pozycja">1</div>
            <div id="dolny_pasek_stron"></div>
            <div id="pokaz_ile_pozycji"></div>
            <div id="ile_rekordow"><?php echo $ile_pozycji; ?></div>
            
            <script>
            $("#wynik_zapytania").html('<div style="padding:10px">Trwa ładowanie danych ...</div>');
            var skocz = '<?php echo ((isset($_GET['id_poz']) && (int)$_GET['id_poz'] > 0) ? (int)$_GET['id_poz'] : ''); ?>';
            <?php Listing::pokazAjax('porownywarki/porownywarki.php', $zapytanie, $ile_licznika, $ile_pozycji, 'comparisons_id', $ilosc_wynikow); ?>
            </script>                

        </div>
                    
        <?php include('stopka.inc.php'); ?>

    <?php }

} ?>
