<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

    if (isset($_POST['akcja']) && $_POST['akcja'] == 'zapisz') {
        //
        $pola = array(
                array('coupons_status','1'),
                array('coupons_name',$filtr->process($_POST["kod"])),
                array('coupons_description',$filtr->process($_POST["opis"])),
                array('coupons_discount_type',$filtr->process($_POST["rodzaj"])),                
                array('coupons_min_order',$filtr->process($_POST["wartosc"])),
                array('coupons_min_quantity',$filtr->process($_POST["ilosc"])),
                array('coupons_quantity',$filtr->process($_POST["ilosc_kuponow"])),
                array('coupons_specials',$filtr->process($_POST["promocja"])),
                array('coupons_date_added','now()'),
                array('coupons_customers_groups_id',((isset($_POST['grupa_klientow'])) ? implode(',', $_POST['grupa_klientow']) : 0))
        );
        
        if ($filtr->process($_POST["rodzaj"]) == 'fixed') {
            $pola[] = array('coupons_discount_value',$filtr->process($_POST["rabat_kwota"]));
        }
        
        if ($filtr->process($_POST["rodzaj"]) == 'percent') {
            $pola[] = array('coupons_discount_value',$filtr->process($_POST["rabat_procent"]));
        }        
        
        if (!empty($_POST['data_od'])) {
            $pola[] = array('coupons_date_start',date('Y-m-d', strtotime($filtr->process($_POST['data_od']))));
          } else {
            $pola[] = array('coupons_date_start','0000-00-00');            
        }  

        if (!empty($_POST['data_do'])) {
            $pola[] = array('coupons_date_end',date('Y-m-d', strtotime($filtr->process($_POST['data_do']))));
          } else {
            $pola[] = array('coupons_date_end','0000-00-00');            
        }         

        if ($_POST['warunek'] == 'kategoria' && isset($_POST['id_kat']) && count($_POST['id_kat']) > 0) {
            $pola[] = array('coupons_exclusion','kategorie'); 
            //
            $tablica_kat = $_POST['id_kat'];
            $lista = '';
            for ($q = 0, $c = count($tablica_kat); $q < $c; $q++) {
                //
                $lista .= $tablica_kat[$q] . ',';
                //
            } 
            $lista = substr($lista, 0, -1);
            //
            $pola[] = array('coupons_exclusion_id',$lista); 
            unset($tablica_kat, $lista);
        }
        
        if ($_POST['warunek'] == 'producent' && isset($_POST['id_producent']) && count($_POST['id_producent']) > 0) {
            $pola[] = array('coupons_exclusion','producenci'); 
            //
            $tablica_producent = $_POST['id_producent'];
            $lista = '';
            for ($q = 0, $c = count($tablica_producent); $q < $c; $q++) {
                //
                $lista .= $tablica_producent[$q] . ',';
                //
            } 
            $lista = substr($lista, 0, -1);
            //
            $pola[] = array('coupons_exclusion_id',$lista); 
            unset($tablica_producent, $lista);
        }  

        if ($_POST['warunek'] == 'produkt' && isset($_POST['id_produkt']) && count($_POST['id_produkt']) > 0) {
            $pola[] = array('coupons_exclusion','produkty'); 
            //
            $tablica_produkt = $_POST['id_produkt'];
            $lista = '';
            for ($q = 0, $c = count($tablica_produkt); $q < $c; $q++) {
                //
                $lista .= $tablica_produkt[$q] . ',';
                //
            } 
            $lista = substr($lista, 0, -1);
            //
            $pola[] = array('coupons_exclusion_id',$lista); 
            unset($tablica_produkt, $lista);
        }        
        
        //			
        $db->insert_query('coupons' , $pola);	
        $id_dodanej_pozycji = $db->last_id_query();
        
        unset($pola);
        //
        if (isset($id_dodanej_pozycji) && $id_dodanej_pozycji > 0) {
            Funkcje::PrzekierowanieURL('kupony.php?id_poz='.$id_dodanej_pozycji);
        } else {
            Funkcje::PrzekierowanieURL('kupony.php');
        }
    }

    // wczytanie naglowka HTML
    include('naglowek.inc.php');
    ?>
    
    <div id="naglowek_cont">Dodawanie pozycji</div>
    <div id="cont">
          
          <script>
          $(document).ready(function() {
            $("#kuponyForm").validate({
              rules: {
                kod: {
                  required: true,
                  remote: "kupony/kupony_sprawdz.php"
                },
                rabat_kwota: {
                  range: [0.01, 100000],
                  number: true,
                  required: function(element) {
                    if ($("#rodzaj_kwota").css('display') == 'block') {
                        return true;
                      } else {
                        return false;
                    }
                  }               
                },
                rabat_procent: {
                  range: [0.01, 100],
                  number: true,
                  required: function(element) {
                    if ($("#rodzaj_procent").css('display') == 'block') {
                        return true;
                      } else {
                        return false;
                    }
                  } 
                },
                ilosc: {
                  range: [0, 100000],
                  number: true
                },
                wartosc: {
                  range: [1, 100000],
                  number: true
                },
                ilosc_kuponow: {
                  range: [1, 100000],
                  number: true,
                  required: true
                }                
              },
              messages: {
                kod: {
                  required: "Pole jest wymagane.",
                  remote: "Taki kod kuponu jest już w bazie."
                },
                rabat_kwota: {
                  required: "Pole jest wymagane.",
                  range: "Wartość musi być wieksza lub równa 0.01"
                },
                rabat_procent: {
                  required: "Pole jest wymagane.",
                  range: "Wartość musi być wieksza lub równa 0.01"
                },              
                ilosc: {
                  range: "Wartość musi być wieksza lub równa 1."
                },
                wartosc: {
                  range: "Wartość musi być wieksza lub równa 1."
                },
                ilosc_kuponow: {
                  required: "Pole jest wymagane.",
                  range: "Wartość musi być wieksza lub równa 1."
                }                 
              }
            });
            
            $('input.datepicker').Zebra_DatePicker({
               format: 'd-m-Y',
               inside: false,
               readonly_element: false
            });             
            
          });
          
          function rodzaj_rabat(elem) {
             $('#rodzaj_kwota').css('display','none');
             $('#rodzaj_procent').css('display','none');
             //
             if (elem != '' && elem != 'wysylka') {
                $('#rodzaj_' + elem).slideDown();
             }
          }      

          function warun(elem) {
             $('#Kategorie').css('display','none');
             $('#Producenci').css('display','none');
             $('#Produkty').css('display','none');
             //
             if ( elem != 'Produkty' ) {
                  $('#' + elem).slideDown();
                } else {
                  lista_produktow();
             }
          }      

          function lista_produktow() {
            //
            $('#Produkty').show(); 
            $('#Produkty').html('<img src="obrazki/_loader_small.gif">');
            $.get("ajax/lista_produktow_kupony.php",
                { tok: '<?php echo Sesje::Token(); ?>', poczatek: 0 },
                function(data) { 
                    $('#Produkty').hide();
                    $('#Produkty').html(data);     
                    $('#Produkty').slideDown();                    
            }); 
          }       

          function doczytaj(poczatek) {
            //
            $('#ekr_preloader').css('display','block');
            $.get("ajax/lista_produktow_kupony.php",            
                { tok: '<?php echo Sesje::Token(); ?>', poczatek: poczatek },
                function(data) { 
                    $('#ekr_preloader').css('display','none');
                    $('#Doczytaj').remove();                    
                    $('#Produkty').append(data);
            }); 
          }               
          </script>        

          <form action="kupony/kupony_dodaj.php" method="post" id="kuponyForm" class="cmxform">          

          <div class="poleForm">
            <div class="naglowek">Dodawanie danych</div>
            
            <div class="pozycja_edytowana">
            
                <div class="info_content">
            
                <input type="hidden" name="akcja" value="zapisz" />

                    <p>
                      <label class="required" for="kod">Kod kuponu:</label>
                      <input type="text" name="kod" id="kod" value="" size="35" /><em class="TipIkona"><b>Kod kuponu, który zostanie przekazany klientom</b></em>
                    </p>   

                    <p>
                      <label for="opis">Opis kuponu:</label>
                      <input type="text" name="opis" id="opis" value="" size="50" /><em class="TipIkona"><b>Opis kuponu - widoczny tylko dla administratora sklepu</b></em>
                    </p>
                    
                    <p>
                      <label>Rodzaj rabatu:</label>
                      <input type="radio" value="fixed" name="rodzaj" id="rodzaj_kwotowy" onclick="rodzaj_rabat('kwota')" checked="checked" /> <label class="OpisFor" for="rodzaj_kwotowy">kwotowy<em class="TipIkona"><b>Rabat jest stały kwotowy</b></em></label>
                      <input type="radio" value="percent" name="rodzaj" id="rodzaj_procentowy" onclick="rodzaj_rabat('procent')" /> <label class="OpisFor" for="rodzaj_procentowy">procentowy<em class="TipIkona"><b>Rabat obliczany jest procentowo od wartości zamówienia</b></em></label>
                      <input type="radio" value="shipping" name="rodzaj" id="rodzaj_wysylka" onclick="rodzaj_rabat('wysylka')" /> <label class="OpisFor" for="rodzaj_wysylka">darmowa wysyłka<em class="TipIkona"><b>Rabat równy kosztom wysyłki - umożliwia darmową wysyłkę</b></em></label>
                    </p>
                    
                    <div id="rodzaj_kwota">
                      <p>
                          <label class="required" for="rabat_kwota">Wartość rabatu:</label>
                          <input type="text" name="rabat_kwota" id="rabat_kwota" value="" size="10" /><em class="TipIkona"><b>Wartość kwotowa powyżej 0.01</b></em>
                      </p>
                    </div>
                    
                    <div id="rodzaj_procent" style="display:none">
                      <p>
                          <label class="required" for="rabat_procent">Wartość rabatu (w %):</label>
                          <input type="text" name="rabat_procent" id="rabat_procent" value="" size="3" /><em class="TipIkona"><b>Wartość procentowa od 0.01 do 100</b></em>
                      </p>
                    </div>
                    
                    <p>
                        <label for="data_od">Data rozpoczęcia:</label>
                        <input type="text" name="data_od" id="data_od" value="" size="20" class="datepicker" />                                        
                    </p>

                    <p>
                        <label for="data_do">Data zakończenia:</label>
                        <input type="text" name="data_do" id="data_do" value="" size="20" class="datepicker" />                                        
                    </p>
                    
                    <div class="RamkaWarunki">
                    
                        <b>Dodatkowe warunki użycia kuponu</b>
                        
                        <table style="margin-bottom:10px">
                            <tr>
                                <td><label>Dostępny dla grupy klientów:</label></td>
                                <td>
                                    <?php                        
                                    $TablicaGrupKlientow = Klienci::ListaGrupKlientow(false);
                                    foreach ( $TablicaGrupKlientow as $GrupaKlienta ) {
                                        echo '<input type="checkbox" value="' . $GrupaKlienta['id'] . '" name="grupa_klientow[]" id="grupa_klientow_' . $GrupaKlienta['id'] . '" /> <label class="OpisFor" for="grupa_klientow_' . $GrupaKlienta['id'] . '">' . $GrupaKlienta['text'] . '</label><br />';
                                    }               
                                    unset($TablicaGrupKlientow);
                                    ?>
                                </td>
                            </tr>
                        </table> 
                        
                        <div class="ostrzezenie odlegloscRwd" style="margin-bottom:10px">Jeżeli nie zostanie wybrana żadna grupa klientów to kupon będzie dostępny dla wszystkich klientów.</div>

                        <p>
                          <label for="ilosc">Minimalna ilość produktów:</label>
                          <input class="kropkaPusta" type="text" name="ilosc" id="ilosc" value="" size="3" /><em class="TipIkona"><b>Ilość produktów w koszyku od jakiej będzie można zrealizować kupon</b></em>
                        </p> 

                        <p>
                          <label for="wartosc">Minimalna wartość zamówienia:</label>
                          <input class="kropkaPusta" type="text" name="wartosc" id="wartosc" value="" size="10" /><em class="TipIkona"><b>Wartość zamówienia od jakiej będzie można zrealizować kupon</b></em>
                        </p>  
                        
                        <p>
                          <label>Produkty promocyjne:</label>
                          <input type="radio" value="1" name="promocja" id="promocja_tak" checked="checked" /><label class="OpisFor" for="promocja_tak">tak<em class="TipIkona"><b>Czy kuponem mają być objęte produkty promocyjne ?</b></em></label>
                          <input type="radio" value="0" name="promocja" id="promocja_nie" /><label class="OpisFor" for="promocja_nie">nie<em class="TipIkona"><b>Czy kuponem mają być objęte produkty promocyjne ?</b></em></label>
                        </p>                         

                        <p>
                          <label>Dostępny tylko dla:</label>
                          <input type="radio" value="kategoria" name="warunek" id="warunek_kategorie" onclick="warun('Kategorie')" checked="checked" /><label class="OpisFor" for="warunek_kategorie">wybranych kategorii<em class="TipIkona"><b>Kupon będzie można wykorzystać tylko w określnych kategoriach</b></em></label>
                          <input type="radio" value="producent" name="warunek" id="warunek_producenci" onclick="warun('Producenci')" /><label class="OpisFor" for="warunek_producenci">wybranych producentów<em class="TipIkona"><b>Kupon będzie można wykorzystać tylko dla określonych producentów</b></em></label>
                          <input type="radio" value="produkt" name="warunek" id="warunek_produkty" onclick="warun('Produkty')" /><label class="OpisFor" for="warunek_produkty">wybranych produktów<em class="TipIkona"><b>Kupon będzie można wykorzystać tylko dla określonych produktów"</b></em></label>
                        </p>                         
                        
                        <div id="Kategorie">
                        
                            <div id="drzewo" style="margin:0px;">
                                <?php
                                //
                                echo '<table class="pkc">';
                                //
                                $tablica_kat = Kategorie::DrzewoKategorii('0', '', '', '', false, true);
                                for ($w = 0, $c = count($tablica_kat); $w < $c; $w++) {
                                    $podkategorie = false;
                                    if ($tablica_kat[$w]['podkategorie'] == 'true') { $podkategorie = true; }
                                    //
                                    echo '<tr>
                                            <td class="lfp"><input type="checkbox" value="'.$tablica_kat[$w]['id'].'" name="id_kat[]" id="kateg_nr_'.$tablica_kat[$w]['id'].'" /> <label class="OpisFor" for="kateg_nr_'.$tablica_kat[$w]['id'].'">'.$tablica_kat[$w]['text'].(($tablica_kat[$w]['status'] == 0) ? '<div class="wylKat TipChmurka"><b>Kategoria jest nieaktywna</b></div>' : '').'</label></td>
                                            <td class="rgp" '.(($podkategorie) ? 'id="img_'.$tablica_kat[$w]['id'].'"' : '').'>'.(($podkategorie) ? '<img src="obrazki/rozwin.png" alt="Rozwiń" onclick="podkat(\''.$tablica_kat[$w]['id'].'\',\'\',\'checkbox\')" />' : '').'</td>
                                          </tr>
                                          '.(($podkategorie) ? '<tr><td colspan="2"><div id="p_'.$tablica_kat[$w]['id'].'"></div></td></tr>' : '').'';
                                }
                                if ( count($tablica_kat) == 0 ) {
                                     echo '<tr><td colspan="9" style="padding:10px">Brak wyników do wyświetlania</td></tr>';
                                }                                                                
                                echo '</table>';
                                unset($tablica_kat,$podkategorie); 
                                ?>            
                            </div> 
                            
                        </div>
                        
                        <div id="Producenci" style="display:none">
                        
                            <?php
                            $Prd = Funkcje::TablicaProducenci();

                            for ($b = 0, $c = count($Prd); $b < $c; $b++) {
                                //
                                echo '<input type="checkbox" value="'.$Prd[$b]['id'].'" name="id_producent[]" id="id_producent_'.$Prd[$b]['id'].'" /> <label class="OpisFor" for="id_producent_'.$Prd[$b]['id'].'">'.$Prd[$b]['text'] . '</label><br />';
                            }
                            
                            if ( count($Prd) == 0 ) {
                                 echo '<div style="padding:10px">Brak wyników do wyświetlania</div>';
                            }                                

                            unset($Prd);
                            ?>
                            
                        </div>
                        
                        <div id="Produkty" style="display:none"></div>

                        <span class="ostrzezenie odlegloscRwd" style="margin-top:10px;margin-bottom:10px">
                            Jeżeli nie zostanie wybrana żadna kategoria, producent czy produkt - kupon będzie aktywny dla wszystkich kategorii, producentów i produktów.
                        </span>                  

                    </div>

                    <p>
                      <label class="required" for="ilosc_kuponow">Ilość dostępnych kuponów:</label>
                      <input type="text" name="ilosc_kuponow" id="ilosc_kuponow" value="" size="6" /><em class="TipIkona"><b>Wartość określa ile kuponów może zostać wykorzystanych w sklepie</b></em>
                    </p>                    
                    
                </div>
                
            </div>

            <div class="przyciski_dolne">
              <input type="submit" class="przyciskNon" value="Zapisz dane" />
              <button type="button" class="przyciskNon" onclick="cofnij('kupony','<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz')); ?>','kupony');">Powrót</button>   
            </div>            

          </div>                      
          </form>

    </div>    
    
    <?php
    include('stopka.inc.php');

}