<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

    Listing::postGet(basename($_SERVER['SCRIPT_NAME']));

    $allegro = new Allegro();

    if ( isset($_GET['aukcja_id']) && $_GET['aukcja_id'] > 0 ) {
        $warunki_szukania = " AND a.allegro_id = '".$_GET['aukcja_id']."' ";
    } else {
        $warunki_szukania = "";
    }

    if ( $warunki_szukania != '' ) {
      $warunki_szukania = preg_replace('/and/i', 'WHERE', $warunki_szukania, 1);
    }

    $zapytanie = "
      SELECT aso.allegro_auction_id, aso.auction_id, aso.buyer_name, aso.buyer_id, aso.buyer_email_address, aso.auction_postbuy_forms, aso.auction_buy_date, aso.auction_price, aso.auction_quantity, aso.orders_id AS ordersAcution, t.transaction_id, t.post_buy_form_created_date, t.post_buy_form_it_quantity, t.orders_id AS ordersTrans, a.products_name, a.products_id, a.products_stock_attributes, t.post_buy_form_pay_status, aso.auction_comments 
        FROM allegro_auctions_sold aso 
        LEFT JOIN allegro_transactions t ON t.auction_id = aso.auction_id AND aso.buyer_id = t.buyer_id
        LEFT JOIN allegro_auctions a ON a.auction_id = aso.auction_id 
        " . $warunki_szukania;

    $sql = $db->open_query($zapytanie);

    // tworzenie paska do nastepnych okien - obliczanie ile bedzie podstron
    $ile_pozycji = (int)$db->ile_rekordow($sql); // ile jest wszystkich produktow
    $ile_licznika = ($ile_pozycji / ILOSC_WYNIKOW_NA_STRONIE);
    if ($ile_licznika == (int)$ile_licznika) { $ile_licznika = (int)$ile_licznika; } else { $ile_licznika = (int)$ile_licznika+1; }
    $db->close_query($sql);

    // jezeli jest sortowanie
    if (isset($_GET['sort'])) {
        switch ($_GET['sort']) {
            case "sort_a1":
                $sortowanie = 'post_buy_form_created_date ASC';
                break;
            case "sort_a2":
                $sortowanie = 'post_buy_form_created_date DESC';
                break;                 
            case "sort_a3":
                $sortowanie = 'buyer_id desc';
                break;
            case "sort_a4":
                $sortowanie = 'buyer_id asc';
                break;                 
        }            
    } else { $sortowanie = 'post_buy_form_created_date DESC'; }    

    $zapytanie .= " ORDER BY ".$sortowanie;    

    // ******************************************************************************************************************************************************************
    // obsluga listingu AJAX
    if (isset($_GET['parametr'])) {

        if ($ile_pozycji > 0) {
            
            $zapytanie .= " limit ".$_GET['parametr'];   

            $sql = $db->open_query($zapytanie);

            $listing_danych = new Listing();
            
            $tablica_naglowek = array(array('Info', 'center', '', 'class="ListingSchowajMobile"'),
                                      array('Akcja','center'),
                                      array('Numer aukcji','center'),
                                      array('Produkt','center'),
                                      array('Kupujący','center'),
                                      array('E-mail','center', '', 'class="ListingSchowaj"'),
                                      array('Ilość','center'),
                                      array('Data<br />zakupu','center'),
                                      array('Cena','center', '', 'class="ListingSchowaj"'),
                                      array('Formularz','center'),
                                      array('Numer<br />transakcji','center', '', 'class="ListingSchowaj"'),
                                      array('Numer<br />zam.','center'));
                                      
            echo $listing_danych->naglowek($tablica_naglowek);
            
            $tekst = '';
            while ($info = $sql->fetch_assoc()) {
            
                if (isset($_GET['id_poz']) && (int)$_GET['id_poz'] == $info['allegro_auction_id']) {
                   $tekst .= '<tr class="pozycja_on" id="sk_'.$info['allegro_auction_id'].'">';
                 } else {
                   $tekst .= '<tr class="pozycja_off" id="sk_'.$info['allegro_auction_id'].'">';
                }        
                $link = '';

                $numer_zamowienia = '---';
                if ( $info['ordersAcution'] != '' && $info['ordersAcution'] != '0' ) {
                  $numer_zamowienia = '<a href="sprzedaz/zamowienia_szczegoly.php?id_poz='.$info['ordersAcution'].'" >'.$info['ordersAcution'].'</a>';
                } else {
                  $numer_zamowienia = '---';
                }
                if ( $info['ordersTrans'] != '' && $info['ordersTrans'] != '0' ) {
                  $numer_zamowienia = '<a href="sprzedaz/zamowienia_szczegoly.php?id_poz='.$info['ordersTrans'].'" >'.$info['ordersTrans'].'</a>';
                } else {
                  $numer_zamowienia = '---';
                }

                $tablica = Array();

                $tablica[] = array('<div id="aukcja_'.$info['allegro_auction_id'].'_'.$info['transaction_id'].'" class="zmzoom_aukcja"><div class="podglad_zoom"></div><img src="obrazki/info_duze.png" alt="Szczegóły" /></div>','center', '', 'class="ListingSchowajMobile"');

                $dane = array( 'aukcja_id' => $info['auction_id'],
                               'buyer_id' => $info['buyer_id'],
                               'id_poz' => $info['allegro_auction_id'],
                               'postform' => $info['auction_postbuy_forms'],
                               'transaction_id' => ((empty($info['transaction_id'])) ? '0' : $info['transaction_id']) );
                               
                $salt = rand (101,999);

                $tablica[] = array('<input type="checkbox" style="border:0px" name="opcja[]" value="'.htmlspecialchars(serialize($dane), ENT_QUOTES, 'UTF-8').'" id="opcja_'.$info['auction_id'].'_'.$salt.'" /><label class="OpisForPustyLabel" for="opcja_'.$info['auction_id'].'_'.$salt.'"></label>','center');
                unset($dane);
                
                $link = '';
                if ( Allegro::SerwerAllegro() == 'nie' ) {
                  $link = 'http://allegro.pl/item' .  $info['auction_id'] . '_webapi.html';
                } else {
                  $link = 'http://allegro.pl.webapisandbox.pl/show_item.php?item='.$info['auction_id'];
                }                  
                
                $tablica[] = array('<a href="' . $link . '">' . $info['auction_id'] . '</a>','center');
                
                unset($link);
                
                $wyswietl_cechy = '';

                if ( isset($info['products_stock_attributes']) && $info['products_stock_attributes'] != '' ) {

                  $tablica_kombinacji_cech = explode(';', $info['products_stock_attributes']);
                  
                  for ( $t = 0, $c = count($tablica_kombinacji_cech); $t < $c; $t++ ) {
                  
                    $tablica_wartosc_cechy = explode('-', $tablica_kombinacji_cech[$t]);

                    $nazwa_cechy = Funkcje::NazwaCechy( (int)$tablica_wartosc_cechy['0'] );
                    $nazwa_wartosci_cechy = Funkcje::WartoscCechy( (int)$tablica_wartosc_cechy['1'] );

                    $wyswietl_cechy .= '<span class="MaleInfoCecha">'.$nazwa_cechy . ': <b>' . $nazwa_wartosci_cechy . '</b></span>';
                    
                    unset($tablica_wartosc_cechy);
                    
                  }
                  
                  unset($tablica_kombinacji_cech);
                  
                }

                $tablica[] = array('<b><a href="produkty/produkty_edytuj.php?id_poz='.$info['products_id'].'">' . $info['products_name'] . '</a></b>' . ((!empty($wyswietl_cechy)) ? $wyswietl_cechy : '') . '','left');
                $tablica[] = array($info['buyer_name'],'center');
                $tablica[] = array('<a href="mailto:'.$info['buyer_email_address'].'" >'.$info['buyer_email_address'].'</a>','center', '', 'class="ListingSchowaj"');
                $tablica[] = array( round(( $info['auction_postbuy_forms'] == '1' ? $info['post_buy_form_it_quantity'] : $info['auction_quantity'] ),0),'center');

                if ( $info['post_buy_form_created_date'] != '' ) {
                    $tablica[] = array( date('d-m-Y H:i:s',$info['post_buy_form_created_date']),'center');
                } else {
                    $tablica[] = array( date('d-m-Y H:i:s',$info['auction_buy_date']),'center');
                }

                $tablica[] = array($waluty->FormatujCene($info['auction_price']),'center', 'white-space:nowrap', 'class="ListingSchowaj"');

                $stan_tranzakcji = '<em class="TipChmurka"><b>Kupujący nie wypełnił formularza pozakupowego</b><img src="obrazki/aktywny_off.png" alt="Kupujący nie wypełnił formularza pozakupowego" /></em>';
                if ( $info['auction_postbuy_forms'] == '1' ) {
                  $stan_tranzakcji = '<em class="TipChmurka"><b>Kupujący wypełnił formularz pozakupowy</b><img src="obrazki/aktywny_on.png" alt="Kupujący wypełnił formularz pozakupowy" /></em>';
                  if ( $info['post_buy_form_pay_status'] == 'Anulowana' ) {
                    $stan_tranzakcji = '<em class="TipChmurka"><b>Formularz pozakupowy został anulowany</b><img src="obrazki/uwaga.png" alt="Formularz pozakupowy został anulowany" /></em>';
                  }
                }

                $tablica[] = array($stan_tranzakcji,'center');
                $tablica[] = array($info['transaction_id'],'center', '', 'class="ListingSchowaj"');
                $tablica[] = array($numer_zamowienia,'center');
                                 
                $tekst .= $listing_danych->pozycje($tablica);
                
                $tekst .= '<td class="rg_right IkonyPionowo">';
                $postbuyform = $info['auction_postbuy_forms'];

                $zmienne_do_przekazania = '?id_poz='.$info['allegro_auction_id'].'&amp;aukcja_id='.$_GET['aukcja_id'];
                $tekst .= '<a class="TipChmurka" href="allegro/allegro_sprzedaz_szczegoly.php'.$zmienne_do_przekazania. (($info['transaction_id'] != '') ? '&amp;id=' . $info['transaction_id'] : '') . '"><b>Szczegóły aukcji</b><img src="obrazki/zobacz.png" alt="Szczegóły aukcji" /></a>';
                
                //if ( ($info['ordersTrans'] != '' && $info['ordersTrans'] != '0') || ($info['ordersAcution'] != '' && $info['ordersAcution'] != '0') ) {
                //    $tekst .= '<em class="TipChmurka"><b>Zamówienie już było utworzone</b><img src="obrazki/import_off.png" alt="Zamówienie już było utworzonee" /></em>';
                //} else {
                    $tekst .= '<a class="TipChmurka" href="allegro/allegro_utworz_zamowienie.php'.$zmienne_do_przekazania.'&amp;postform='.$postbuyform.($postbuyform == '1' ? '&amp;transaction_id='.$info['transaction_id'] : '').'"><b>Utwórz zamówienie</b><img src="obrazki/import.png" alt="Utwórz zamówienie" /></a>';
                //}
                
                $tekst .= '</td></tr>';
                  
            } 
            $tekst .= '</table>';
            //
            echo $tekst;
            //
            $db->close_query($sql);
            unset($listing_danych,$tekst,$tablica,$tablica_naglowek);        

        }
    }  
    
    // ******************************************************************************************************************************************************************
    // wyswietlanie listingu
    if (!isset($_GET['parametr'])) { 

        // wczytanie naglowka HTML
        include('naglowek.inc.php');
        ?>

        <script>
        $(document).ready(function() {
          $('#akcja_dolna').change(function() {
            if ( this.value == '0' || this.value == '2' ) {
              $("#page").load('allegro/blank.php');
            }
          });

          $('input.datepicker').Zebra_DatePicker({
            format: 'd-m-Y',
            inside: false,
            readonly_element: false
          });                
        });
        </script>

        <div id="caly_listing">
        
            <div id="ajax"></div>
            
            <div id="naglowek_cont">Oferty zakupu w aukcji</div>

            <div class="cl"></div>

            <form action="allegro/allegro_akcja.php" method="post" class="cmxform">

              <div id="sortowanie">
              
                  <span>Sortowanie: </span>
                  
                  <a id="sort_a1" class="sortowanie" href="allegro/allegro_sprzedaz_tranzakcja.php?aukcja_id=<?php echo $_GET['aukcja_id']; ?>&amp;sort=sort_a1">daty zakupu rosnąco</a>
                  <a id="sort_a2" class="sortowanie" href="allegro/allegro_sprzedaz_tranzakcja.php?aukcja_id=<?php echo $_GET['aukcja_id']; ?>&amp;sort=sort_a2">daty zakupu malejąco</a>
                  <a id="sort_a3" class="sortowanie" href="allegro/allegro_sprzedaz_tranzakcja.php?aukcja_id=<?php echo $_GET['aukcja_id']; ?>&amp;sort=sort_a3">kupujący malejąco</a>
                  <a id="sort_a4" class="sortowanie" href="allegro/allegro_sprzedaz_tranzakcja.php?aukcja_id=<?php echo $_GET['aukcja_id']; ?>&amp;sort=sort_a4">kupujący rosnąco</a>
                  
              </div>             

              <div class="sprzedazAllegro">

                  <div id="wynik_zapytania"></div>
                  <div id="aktualna_pozycja">1</div>

                  <div id="akcja">
                  
                    <div class="lf"><img src="obrazki/strzalka.png" alt="" /></div>
                    
                    <div class="lf" style="padding-right:20px">
                      <span onclick="akcja(1)">zaznacz wszystkie</span>
                      <span onclick="akcja(2)">odznacz wszystkie</span>
                    </div>
                    
                    <div id="akc">
                    
                      Wykonaj akcje: 
                      
                      <select name="akcja_dolna" id="akcja_dolna">
                        <option value="0"></option>
                        <option value="2">utwórz zamówienia dla zaznaczonych aukcji</option>
                      </select>
                      
                    </div>
                    
                    <div style="clear:both;"></div>
                    
                  </div>
                  
                  <div id="page"></div>

                  <div id="dolny_pasek_stron"></div>
                  <div id="pokaz_ile_pozycji"></div>
                  <div id="ile_rekordow"><?php echo $ile_pozycji; ?></div>
              
              </div>
              
              <?php if ($ile_pozycji > 0) { ?>
              <div style="text-align:right" id="zapisz_zmiany"><input type="submit" class="przyciskBut" value="Wykonaj" /><input type="hidden" name="aukcja_id" value="<?php echo $_GET['aukcja_id']; ?>" /></div>
              <?php } ?>                

            </form>

            <?php if ((int)$_GET['aukcja_id'] > 0) { ?>
            <button type="button" class="przyciskNon" onclick="cofnij('allegro_aukcje','<?php echo '?id_poz='.$_GET['aukcja_id']; ?>','allegro');">Powrót</button> 
            <?php } ?>
            
            <script>
            $("#wynik_zapytania").html('<div style="padding:10px">Trwa ładowanie danych ...</div>');
            var skocz = '<?php echo ((isset($_GET['id_poz']) && (int)$_GET['id_poz'] > 0) ? (int)$_GET['id_poz'] : ''); ?>';
            <?php Listing::pokazAjax('allegro/allegro_sprzedaz_tranzakcja.php', $zapytanie, $ile_licznika, $ile_pozycji, 'allegro_auction_id'); ?>
            </script>                

        </div>

        <?php include('stopka.inc.php'); ?>

    <?php }

} ?>
