<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:40                                      */
/****************************************************************/

class tax_class { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $tax_class_id=0;
	public $tax_class_title=0;
	public $tax_class_description=0;
	public $last_modified=0;
	public $date_added=0;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert tax_class (tax_class_title, tax_class_description, last_modified, date_added) VALUES (:tax_class_title, :tax_class_description, :last_modified, :date_added) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':tax_class_title', $this->tax_class_title, PDO::PARAM_STR);
		$sth->bindParam(':tax_class_description', $this->tax_class_description, PDO::PARAM_STR);
		$sth->bindParam(':last_modified', $this->last_modified, PDO::PARAM_STR);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update tax_class SET tax_class_title=:tax_class_title, tax_class_description=:tax_class_description, last_modified=:last_modified, date_added=:date_added Where tax_class_id=:tax_class_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':tax_class_title', $this->tax_class_title, PDO::PARAM_STR);
		$sth->bindParam(':tax_class_description', $this->tax_class_description, PDO::PARAM_STR);
		$sth->bindParam(':last_modified', $this->last_modified, PDO::PARAM_STR);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);
		$sth->bindParam(':tax_class_id', $this->tax_class_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from tax_class Where tax_class_id=:tax_class_id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':tax_class_id', $this->tax_class_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista(){
		$query='Select * from tax_class';
		$sth = $this->Conn->prepare($query);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]=trim($v);
			}
			$x++;
		}

		return $tablica;
	}

}
?>
