<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:30                                      */
/****************************************************************/


class orders_status_history { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $orders_status_history_id=0;
	public $orders_id=0;
	public $orders_status_id=0;
	public $date_added=0;
	public $customer_notified=0;
	public $comments=0;
	public $SK=0;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert orders_status_history (orders_id, orders_status_id, date_added, customer_notified, comments, SK) VALUES (:orders_id, :orders_status_id, :date_added, :customer_notified, :comments, :SK) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':orders_id', $this->orders_id, PDO::PARAM_INT);
		$sth->bindParam(':orders_status_id', $this->orders_status_id, PDO::PARAM_INT);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);
		$sth->bindParam(':customer_notified', $this->customer_notified, PDO::PARAM_INT);
		$sth->bindParam(':comments', $this->comments, PDO::PARAM_STR);
		$sth->bindParam(':SK', $this->SK, PDO::PARAM_STR);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update orders_status_history SET orders_id=:orders_id, orders_status_id=:orders_status_id, date_added=:date_added, customer_notified=:customer_notified, comments=:comments, SK=:SK Where orders_status_history_id=:orders_status_history_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':orders_id', $this->orders_id, PDO::PARAM_INT);
		$sth->bindParam(':orders_status_id', $this->orders_status_id, PDO::PARAM_INT);
		$sth->bindParam(':date_added', $this->date_added, PDO::PARAM_STR);
		$sth->bindParam(':customer_notified', $this->customer_notified, PDO::PARAM_INT);
		$sth->bindParam(':comments', $this->comments, PDO::PARAM_STR);
		$sth->bindParam(':SK', $this->SK, PDO::PARAM_STR);
		$sth->bindParam(':orders_status_history_id', $this->orders_status_history_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from orders_status_history Where orders_status_history_id=:orders_status_history_id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':orders_status_history_id', $this->orders_status_history_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista(){
		$query='Select * from orders_status_history Where orders_id=:orders_id';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':orders_id', $this->orders_id, PDO::PARAM_INT);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]=trim($v);
			}
			$x++;
		}

		return $tablica;
	}
	public function GetId(){
		$query='Select orders_status_history_id from orders_status_history Where orders_id=:orders_id and SK=:SK';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':orders_id', $this->orders_id, PDO::PARAM_INT);
		$sth->bindParam(':SK', $this->SK, PDO::PARAM_STR);
		$sth->execute();
		$zwrot = 0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{			
			$zwrot=$row['orders_status_history_id'];
		}

		return $zwrot;
	}

}

?>
