<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:29                                      */
/****************************************************************/

class orders_products { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $orders_products_id=0;
	public $orders_id=0;
	public $products_id=0;
	public $products_model=0;
	public $products_name=0;
	public $products_price=0;
	public $final_price=0;
	public $products_tax=0;
	public $products_quantity=0;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert orders_products (orders_id, products_id, products_model, products_name, products_price, final_price, products_tax, products_quantity) VALUES (:orders_id, :products_id, :products_model, :products_name, :products_price, :final_price, :products_tax, :products_quantity) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':orders_id', $this->orders_id, PDO::PARAM_INT);
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':products_model', $this->products_model, PDO::PARAM_STR);
		$sth->bindParam(':products_name', $this->products_name, PDO::PARAM_STR);
		$sth->bindParam(':products_price', $this->products_price, PDO::PARAM_STR);
		$sth->bindParam(':final_price', $this->final_price, PDO::PARAM_STR);
		$sth->bindParam(':products_tax', $this->products_tax, PDO::PARAM_STR);
		$sth->bindParam(':products_quantity', $this->products_quantity, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update orders_products SET orders_id=:orders_id, products_id=:products_id, products_model=:products_model, products_name=:products_name, products_price=:products_price, final_price=:final_price, products_tax=:products_tax, products_quantity=:products_quantity Where orders_products_id=:orders_products_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':orders_id', $this->orders_id, PDO::PARAM_INT);
		$sth->bindParam(':products_id', $this->products_id, PDO::PARAM_INT);
		$sth->bindParam(':products_model', $this->products_model, PDO::PARAM_STR);
		$sth->bindParam(':products_name', $this->products_name, PDO::PARAM_STR);
		$sth->bindParam(':products_price', $this->products_price, PDO::PARAM_STR);
		$sth->bindParam(':final_price', $this->final_price, PDO::PARAM_STR);
		$sth->bindParam(':products_tax', $this->products_tax, PDO::PARAM_STR);
		$sth->bindParam(':products_quantity', $this->products_quantity, PDO::PARAM_INT);
		$sth->bindParam(':orders_products_id', $this->orders_products_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from orders_products Where orders_products_id=:orders_products_id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':orders_products_id', $this->orders_products_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista($_id){
		$query="SELECT o.orders_products_id as dl_Id, o.orders_id as dl_Dokument, o.products_id as dl_Produkt, o.products_name as dl_Nazwa, o.products_model as dl_Symbol, o.final_price  as dl_CenaNetto, (o.final_price* (1+o.products_tax/100)) as dl_CenaBrutto, 0 as dl_CenaZakupu, o.products_quantity as dl_Ilosc, (o.final_price * o.products_quantity) as dl_Wartosc, 0 as dl_Vat, o.products_tax as dl_VatS, (o.products_tax/100) as dl_VatW, 0 as dl_JM, case when jo.products_jm_name is null then 'szt.' else jo.products_jm_name end as dl_JMs, '0' as dl_Rabat FROM orders_products o Inner JOIN products po on (po.products_id=o.products_id) LEFT JOIN  products_jm jo on (jo.products_jm_id=po.products_jm_id) Where orders_id=:orders_id GROUP BY o.orders_products_id 
		Union ALL SELECT 999999 as dl_Id, r.orders_id as dl_Dokument, -1 as dl_Produkt, 'Koszty Dostawy' as dl_Nazwa, 'Koszty Dostawy' as dl_Symbol, (value/1.23) as dl_CenaNetto, value as dl_CenaBrutto,0 as dl_CenaZakupu, 1 as dl_Ilosc, (value/1.23) as dl_Wartosc, 0 as dl_Vat, 23 as dl_VatS, 0.23 as dl_VatW, 0 dl_JM, 'szt.' as dl_JMs, '0' as dl_Rabat from  orders_total r Where orders_id=:orders_id2 and class='ot_shipping' 
		Union ALL SELECT 999998 as dl_Id, r.orders_id as dl_Dokument, -1 as dl_Produkt,'Platnosc za pobranie' as dl_Nazwa, 'sklepPobranie' as dl_Symbol, (value/1.23) as dl_CenaNetto, value as dl_CenaBrutto,0 as dl_CenaZakupu, 1 as dl_Ilosc, (value/1.23) as dl_Wartosc, 0 as dl_Vat, 23 as dl_VatS, 0.23 as dl_VatW, 0 dl_JM, 'szt.' as dl_JMs, '0' as dl_Rabat from  orders_total r Where orders_id=:orders_id3 and class='ot_pobranieml' 
		Union ALL SELECT 999997 as dl_Id, r.orders_id as dl_Dokument, -1 as dl_Produkt,'Oplata za obsluge platnosci online (3%):' as dl_Nazwa, 'sklepOnline' as dl_Symbol, (value/1.23) as dl_CenaNetto, value as dl_CenaBrutto,0 as dl_CenaZakupu, 1 as dl_Ilosc, (value/1.23) as dl_Wartosc, 0 as dl_Vat, 23 as dl_VatS, 0.23 as dl_VatW, 0 dl_JM, 'szt.' as dl_JMs, '0' as dl_Rabat from  orders_total r Where orders_id=:orders_id3 and class='ot_payment'";
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':orders_id', $_id, PDO::PARAM_INT);
		$sth->bindParam(':orders_id2', $_id, PDO::PARAM_INT);
		$sth->bindParam(':orders_id3', $_id, PDO::PARAM_INT);
		$sth->execute();
		$tablica = array();
		$x=0;
		//print_r($sth->errorInfo());
		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]=htmlspecialchars(trim($v), ENT_QUOTES);
			}
			$x++;
		}

		return $tablica;
	}

}
?>
