<?php 
/****************************************************************/
/*          e-mo.pl © 2017                                      */
/*          http://www.e-mo.com.pl                              */
/*          e-mail: info@e-mo.pl                                */
/*          produkt: Action2osCommerce                          */
/*          wersja: 1.9.7                                       */
/*          webserwis: oscGold                                  */
/*          sciezka: https://www.e-mo.com.pl/plikit,1918,533545b244d7d.php*/
/*          data: 2017-09-25                                    */
/*          godz: 10:45:26                                      */
/****************************************************************/

class languages { 
	public $Conn = 0;
	public $errMsg = '';
	public $errNo= 0;
	public $languages_id=0;
	public $name=0;
	public $code=0;
	public $image=0;
	public $directory=0;
	public $sort_order=0;

	public function Dodaj(){
		$zwrot=true;
		$query="Insert languages (name, code, image, directory, sort_order) VALUES (:name, :code, :image, :directory, :sort_order) ";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':name', $this->name, PDO::PARAM_STR);
		$sth->bindParam(':code', $this->code, PDO::PARAM_STR);
		$sth->bindParam(':image', $this->image, PDO::PARAM_STR);
		$sth->bindParam(':directory', $this->directory, PDO::PARAM_STR);
		$sth->bindParam(':sort_order', $this->sort_order, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Zmien(){
		$zwrot=true;
		$query="Update languages SET name=:name, code=:code, image=:image, directory=:directory, sort_order=:sort_order Where languages_id=:languages_id";
		$sth = $this->Conn->prepare($query);

		$sth->bindParam(':name', $this->name, PDO::PARAM_STR);
		$sth->bindParam(':code', $this->code, PDO::PARAM_STR);
		$sth->bindParam(':image', $this->image, PDO::PARAM_STR);
		$sth->bindParam(':directory', $this->directory, PDO::PARAM_STR);
		$sth->bindParam(':sort_order', $this->sort_order, PDO::PARAM_INT);
		$sth->bindParam(':languages_id', $this->languages_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Usun(){
		$zwrot=true;
		$query="Delete from languages Where languages_id=:languages_id";

		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':languages_id', $this->languages_id, PDO::PARAM_INT);

		$sth->execute();

		if($sth->errorCode() != 0){
			$zwrot=false;
			$this->errMsg = $sth->errorInfo();
			$this->errNo = $sth->errorCode();
		}

		 return $zwrot;
	 } 
	public function Lista(){
		$query='Select * from languages Where name=:name';
		$sth = $this->Conn->prepare($query);
		$sth->bindParam(':name', $this->name, PDO::PARAM_STR);
		$sth->execute();
		$tablica = array();
		$x=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{
			foreach ($row as $k => $v)
			{
				$tablica[$x][$k]=trim($v);
			}
			$x++;
		}

		return $tablica;
	}
	public static function Szukaj($_Conn){
		$query='Select languages_id from languages Where code=\'pl\'';
		$sth = $_Conn->prepare($query);
                
		$sth->execute();
		$zwrot=1;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{			
			$zwrot=$row['languages_id'];		
		}

		return $zwrot;
	}
        public static function Szukaj2($_code, $_Conn){
		$query='Select languages_id from languages Where code=:code';
		$sth = $_Conn->prepare($query);
                $sth->bindParam(':code', $_code, PDO::PARAM_STR);
		$sth->execute();
		$zwrot=0;

		while ($row = $sth->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT))
		{			
			$zwrot=$row['languages_id'];		
		}

		return $zwrot;
	}

}
?>
