<?php
/*
  $Id: make_an_offer.php,v 1.00 2005/03/15

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2005 osCommerce

  Released under the GNU General Public License
*/

  require('includes/application_top.php');

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_MAKE_AN_OFFER);

  // add customer details (1/1) paulm 2004/04/02
  if (tep_session_is_registered('customer_id'))
  {
    $name = $customer_first_name . ' ' . $customer_last_name;
    $email = $customer_email_address;
  }
  // end add customer details

  if (!isset($HTTP_GET_VARS['products_id'])) {
	$productid = $originalproductid;
  } else {
	$productid = $HTTP_GET_VARS['products_id'];
  }

  // Get the product info
  $product_info_query = tep_db_query("select p.products_id, pd.products_name, pd.products_description, p.products_model, p.products_quantity, p.products_image, pd.products_url, p.products_price, p.products_tax_class_id, p.products_date_added, p.products_date_available, p.manufacturers_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_status = '1' and p.products_id = '" . (int)$productid . "' and pd.products_id = p.products_id and pd.language_id = '" . (int)$languages_id . "'");
  $product_info = tep_db_fetch_array($product_info_query);
  $rate = $currencies->currencies[$currency]['value'];

  if ($new_price = tep_get_products_special_price($product_info['products_id'])) {

    $products_price = $currencies->display_price($productid,$new_price, tep_get_tax_rate($product_info['products_tax_class_id']));

	// Price without currency symbols
	$products_price_clean = tep_round(tep_add_tax($new_price * $rate,tep_get_tax_rate($product_info['products_tax_class_id'])),$currencies->currencies[$currency]['decimal_places']);

  } else {
    $products_price = $currencies->display_price($procuctid,$product_info['products_price'], tep_get_tax_rate($product_info['products_tax_class_id']));

	// Price without currency symbols
	$products_price_clean = tep_round(tep_add_tax($product_info['products_price'] * $rate,tep_get_tax_rate($product_info['products_tax_class_id'])),$currencies->currencies[$currency]['decimal_places']);

  }

  $error = false;
  if (isset($HTTP_GET_VARS['action']) && ($HTTP_GET_VARS['action'] == 'send')) {
    $name = tep_db_prepare_input($HTTP_POST_VARS['name']);
    $email_address = tep_db_prepare_input($HTTP_POST_VARS['email']);
    $remarks = tep_db_prepare_input($HTTP_POST_VARS['remarks']);
    $newprice = tep_db_prepare_input($HTTP_POST_VARS['newprice']);
    $originalproductid = tep_db_prepare_input($HTTP_POST_VARS['originalproductid']);
    $originalprice = tep_db_prepare_input($HTTP_POST_VARS['originalprice']);
    $subject = tep_db_prepare_input($HTTP_POST_VARS['subject']);
    $subject2 = tep_db_prepare_input($HTTP_POST_VARS['subject2']);

    if (tep_validate_email($email_address)) {

		// Calculate the lowest offer accepted depending on the percentage setting
		$maxlowoffer = tep_round(($originalprice - ($originalprice * (MAO_MAX_OFFER_PERCENTAGE_ALLOWED/100))),$currencies->currencies[$currency]['decimal_places']);

		// Manipulate the offer price so it always is in US notation before compare
		// This must be done because the INPUT field looses the decimal values
		// when using a comma for decimal seperator
		// Underneath also strips all points and commas from the value typed by
		// the customer to prevent all kind of problems with the calculation

		// First split the $newprice in a part without and with decimal places
		// Check if a decimal point or comma is used at all
		if (substr($newprice,strlen($newprice)-3,1) == '.' || substr($newprice,strlen($newprice)-3,1) == ',') {
			$newprice_before = substr($newprice,0,strlen($newprice)-3);
			$newprice_after = substr($newprice,strlen($newprice)-2);
		} else {
			$newprice_before = $newprice;
			$newprice_after = '00';
		}

		// Remove all commas and points for the non-decimal value given
		$newprice_before = str_replace('.','',$newprice_before);
		$newprice_before = str_replace(',','',$newprice_before);

		// Put all back together again
		$newprice = tep_round($newprice_before . '.' . $newprice_after,$currencies->currencies[$currency]['decimal_places']);

		if ($maxlowoffer <= $newprice) {

			// (Re)create the right format for the email
			$newprice = number_format(tep_round($newprice,$currencies->currencies[$currency]['decimal_places']), $currencies->currencies[$currency]['decimal_places'], $currencies->currencies[$currency]['decimal_point'], $currencies->currencies[$currency]['thousands_point']);


			$subject .= ' ' . $currencies->currencies[$currency]['symbol_left'] .  $newprice . ' ' . $currencies->currencies[$currency]['symbol_right'] . '\n' . EMAIL_DIVIDER . '\n\n' . EMAIL_USER_REMARKS . '\n\n';
			$subject = str_replace('\n',chr(13),$subject);

			$subject2 .=  ' ' . $currencies->currencies[$currency]['symbol_left'] . $newprice . ' ' . $currencies->currencies[$currency]['symbol_right'] . '\n\n' . EMAIL_DIVIDER . '\n' . EMAIL_USER_REMARKS . ' ' . $name . '\n' . EMAIL_DIVIDER . '\n';
			$subject2 = str_replace('\n',chr(13),$subject2);

			tep_mail(MakeUTF(STORE_OWNER), STORE_OWNER_EMAIL_ADDRESS, MakeUTF(EMAIL_SUBJECT_ADMIN), $subject2 . $remarks, MakeUTF($name), $email_address);

			if ($HTTP_POST_VARS['sendemail'] == true) {
			  tep_mail($name, $email_address, MakeUTF(EMAIL_SUBJECT_CUSTOMER), $subject . $remarks, STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS);
			}

			tep_redirect(tep_href_link(FILENAME_MAKE_AN_OFFER, 'action=success'));
		} else {
	    	$error = true;
			// (Re)create the right format for display
			$newprice = number_format(tep_round($newprice,$currencies->currencies[$currency]['decimal_places']), $currencies->currencies[$currency]['decimal_places'], $currencies->currencies[$currency]['decimal_point'], $currencies->currencies[$currency]['thousands_point']);
			$messageStack->add('lowoffer', ENTRY_LOW_OFFER_CHECK_ERROR);
		}
    } else {
		$error = true;

		$messageStack->add('contact', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
    }
  }

  $breadcrumb->add(NAVBAR_TITLE, tep_href_link(FILENAME_MAKE_AN_OFFER));

	$content = 'make_an_offer';

  include (bts_select('main', $content_template)); // BTSv1.5

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>