<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

 class pocztapriorytetowa {
   var $code, $title, $description, $enabled, $num_pocztapriorytetowa;

// class constructor
   function pocztapriorytetowa() {
     global $order;
     $this->code = 'pocztapriorytetowa';
     $this->title = MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TEXT_TITLE;
     $this->description = MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TEXT_DESCRIPTION;
     $this->sort_order = MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_SORT_ORDER;
     $this->icon = '';
     $this->tax_class = MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TAX_CLASS;
     $this->enabled = ((MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_STATUS == 'True') ? true : false);

     // CUSTOMIZE THIS SETTING FOR THE NUMBER OF ZONES NEEDED

      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }

     $this->num_pocztapriorytetowa = 9;
   }

// class methods
   function quote($method = '') {
     global $order, $shipping_weight, $shipping_num_boxes;

     $dest_country = $order->delivery['country']['iso_code_2'];
     $dest_zone = 0;
     $error = false;

     for ($i=1; $i<=$this->num_pocztapriorytetowa; $i++) {
       $countries_table = str_replace(' ','',constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_' . $i));
       $country_pocztapriorytetowa = split("[;]", $countries_table);
       if (in_array($dest_country, $country_pocztapriorytetowa)) {
         $dest_zone = $i;
         break;
       }
     }

     // elari - Added to select default country if not in listing
     if ($dest_zone == 0) {
       $dest_zone = $this->num_pocztapriorytetowa;    // the zone is the lastest zone avalaible
     }
     // elari - Added to select default country if not in listing
     if ($dest_zone == 0) {
       $error = true;      // this can no more achieve since by default the value is set to the max number of zones
     } else {
       $shipping = -1;
       $pocztapriorytetowa_cost = constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_' . $dest_zone);
       $pocztapriorytetowa_table = split("[:,]" , $pocztapriorytetowa_cost);
       $size = sizeof($pocztapriorytetowa_table);
       for ($i=0; $i<$size; $i+=2) {
         if ($shipping_weight <= $pocztapriorytetowa_table[$i]) {
           $shipping = $pocztapriorytetowa_table[$i+1];
           $shipping_method = MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TEXT_WAY . ' ' . $order->delivery['country']['title'] . ': ';
           if ($shipping_num_boxes > 1) {
             $shipping_method .= $shipping_num_boxes . 'x ';
           }
           $shipping_method .= $shipping_weight . ' ' . MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TEXT_UNITS;
           break;
         }
       }

       if ($shipping == -1) {
         $shipping_cost = 0;
         $shipping_method = MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_UNDEFINED_RATE;
		 $brak_mozliwosci = true;
       } else {
         $shipping_cost = ($shipping * $shipping_num_boxes) + constant('MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_' . $dest_zone);
		 $brak_mozliwosci = false;
       }
     }

     $this->quotes = array('id' => $this->code,
                           'module' => MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TEXT_TITLE,
                           'methods' => array(array('id' => $this->code,
                                                    'title' => $shipping_method,
                                                    'cost' => $shipping_cost)));
     if ($this->tax_class > 0) {
       $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
     }

     if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);
     if ($error == true) $this->quotes['error'] = MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_INVALID_ZONE;
	 if (MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_OFF == 'False' && $brak_mozliwosci == true) {
		 return;
	   } else { 
		return $this->quotes;
     }	
   }

   function check() {
     if (!isset($this->_check)) {
       $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_STATUS'");
       $this->_check = tep_db_num_rows($check_query);
     }
     return $this->_check;
   }

   // elari - Added to select default country if not in listing

   function install() {
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Włączenie modułu', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_STATUS', 'True', 'Czy włączyć moduł Przesyłka Priorytetowa ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Grupa VAT', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TAX_CLASS', '0', 'Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Strefa dostawy', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_ZONE', '0', 'Wybierz strefę, dla której ma być stosowany ten sposob dostawy', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sortowanie', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_SORT_ORDER', '0', 'Kolejność wyświetlania wśród innych modułów wysyłki.', '6', '0', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Jeżeli nie można określić kosztów wysyłki ?', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_OFF', 'False', 'Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");		 
     for ($i = 1; $i <= $this->num_pocztapriorytetowa; $i++) {
        $default_countries = '';
       if ($i == 1) {
         $strefa = '<span style=color:ff0000>Polska</span>';
         $default_countries = 'PL'; ///przesylka PRIORYTETOWA krajowa
         $shipping_table = '0.35:4.7,0.5:5.1,1:6.50,2:8,5:9.5, 10:16.00,15:21,20:30,30:33';
       }
       if ($i == 2) {
         $strefa = '<span style=color:ff0000>A1</span>';
         $default_countries = 'AT;BG;HR;DK;EE;NL;LT; LU;LV;SI;CH;UA;VA;HU'; // strefa A1
         $shipping_table = '0.35:15.30,0.5:20.60, 1:34.60,2:64.20,3:80.00,4:92.00,5:102.00, 6:105.00,7:110.00,8:117.00, 9:125.00,10:133.00, 11:139.00,12:145.00,13:155.00,14:162.00,15:171.00, 16:179.00,17:187.00,18:196.00,19:202.00,20:211.00,30:344.0';
       }
       if ($i == 3) {
         $strefa = '<span style=color:ff0000>A2</span>';
         $default_countries = 'BE;CY;FR;FI;GI;GR;ES;IE;IL;MK;MT;MD;DE;NO;RO;SE;TR;IT;RS;XM'; // strefa A2
         $shipping_table = '0.35:15.30,0.5:20.60, 1:34.60,2:64.20,3:98.00,4:102.00,5:114.00, 6:117.00,7:124.00,8:131.00,9:139.00,10:145.00, 11:151.00,12:160.00,13:166.00,14:172.00,15:179.00, 16:187.00,17:196.00,18:204.00,19:211.00,20:221.00,30:366.0';
       }
       if ($i == 4) {
         $strefa = '<span style=color:ff0000>A3</span>';
         $default_countries = 'PT;RU;GB'; //strefa A3
         $shipping_table = '0.35:15.30,0.5:20.60, 1:34.60,2:64.20,3:98.00,4:102.00,5:114.00, 6:117.00,7:124.00,8:131.00,9:139.00,10:145.00, 11:158.00,12:167.00,13:176.00,14:185.00,15:194.00, 16:212.00,17:221.00,18:230.00,19:239.00,20:249.00,30:394.0';
       }
       if ($i == 5) {
        $strefa = '<span style=color:ff0000>A4</span>';
        $default_countries = 'CZ;SK'; //strefa A4
         $shipping_table = '0.35:15.30,0.5:20.60, 1:24.00,2:27.00,3:29.00,4:31.00,5:32.00, 6:40.00,7:42.00, 8:43.00,9:44.00,10:45.00, 11:52.00,12:53.00,13:54.00,14:56.00,15:57.00, 16:67.00,17:69.00,18:70.00,19:71.00,20:73.00,30:118';
       }
       if ($i == 6) {
        $strefa = '<span style=color:ff0000>A5</span>';
        $default_countries = 'BY'; //strefa A5
         $shipping_table = '0.35:15.30,0.5:20.60, 1:28.00,2:36.00,3:43.00,4:49.00,5:55.00, 6:68.00,7:74.00,8:80.00,9:86.00,10:92.00, 11:103.00,12:109.00,13:105.00,14:121.00,15:126.00, 16:141.00,17:147.00,18:153.00,19:159.00,20:165.00,30:257.0';
       }
       if ($i == 7) {
        $strefa = '<span style=color:ff0000>B</span>';
        $default_countries = 'DZ;AO;BJ;BM;BW;BF;BI; CM;CA;TD;KM;CG;DJ;EG; ER;ET;GA;GM;GH;GN;GW; KE;LS;LY;MG;MW;ML;MR; MU;MX;MA;MZ;NA;NE;NG; RW;SN;S.C.;SL;SO;ZA;SH; SD;SZ;TZ;TG;TN;UG;US;ZR;ZM;ZW'; //strefa B
         $shipping_table = '0.35:18.80,0.5:24.60, 1:43.30,2:82.30,3:126.00,4:146.00,5:172.00, 6:184.00,7:203.00,8:222.00,9:240.00,10:258.00, 11:276.00,12:297.00,13:318.00,14:339.00,15:360.00, 16:390.00,17:411.00,18:433.00,19:454.00,20:475.00,30:703.0';
       }
       if ($i == 8) {
        $strefa = '<span style=color:ff0000>C</span>';
        $default_countries = 'AF;AI;AG;AR;AM;AW;AZ;BS; BH;BD;BB;BZ;BT;BO;BR;IO; BN;KH;KY;CL;CN;CO;CR;CU; DM;DO;EC;SV;FK;GF;GE;GD; GP;GT;GY;HT;HN;HK;IN;ID;IR; IQ;JM;JP;JO;KZ;KP;KR;KW; KG;LA;LB;MO;MY;MQ;MN; MM;NP;AN;NI;OM;PK;PA; PY;PE;PH;QA;SA;SG;LK; SR;SY;TW;TJ;TH;TT;TM; AE;UY;UZ;VE;VN;VG;YE'; //strefa C
         $shipping_table = '0.35:21.30,0.5:29.30, 1:50.30,2:100.30,3:140.00,4:170.00,5:205.00, 6:225.00,7:254.00,8:283.00,9:311.00,10:336.00, 11:363.00,12:386.00,13:416.00,14:448.00,15:466.00, 16:500.00,17:514.00,18:538.00,19:561.00,20:586.00,30:922.0';
       }
       if ($i == 9) {
         $strefa = '<span style=color:ff0000>D</span>';
         $default_countries = 'Strefa D i inne niezdefiniowane kraje'; // this must be the lastest zone		strefa D i niezdefiniowane kraje
         $shipping_table = '0.35:28.30,0.5:39.80, 1:73.30,2:152.30,3:188.00,4:231.00,5:272.00, 6:312.00,7:354.00,8:398.00,9:439.00,10:481.00, 11:524.00,12:566.00,13:608.00,14:650.00,15:692.00, 16:723.00,17:755.00,18:772.00,19:807.00,20:840.00,30:1321.0';
       }
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Kraje strefy " . $strefa . " wg cennika Poczty Polskiej', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_" . $i ."', '" . $default_countries . "', 'Oddzielona przecinkami lista dwuznakowych symboli ISO w ramach strafy " . $strefa . ".', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Tablica kosztów strefy " . $strefa . " wg cennika Poczty Polskiej', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_" . $i ."', '" . $shipping_table . "', 'Koszty przesyłki dla strefy " . $strefa . " bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Dodatkowy stały koszt obsługi wysyłki do strefy " . $strefa ."', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_" . $i ."', '0', 'Dodatkowy stały koszt obsługi wysyłki dla strefy', '6', '0', now())");   
     }
   }

   // elari - Added to select default country if not in listing
   function remove() {
     tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
   }

   function keys() {
     $keys = array('MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_STATUS', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_TAX_CLASS', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_SORT_ORDER','MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_ZONE', 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_OFF');

     for ($i=1; $i<=$this->num_pocztapriorytetowa; $i++) {
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COUNTRIES_' . $i;
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_COST_' . $i;
       $keys[] = 'MODULE_SHIPPING_PRZESYLKA_PRIORYTETOWA_HANDLING_' . $i;
     }

     return $keys;
   }
 }
?>