<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

 class kurierpobranie {
   var $code, $title, $description, $enabled, $num_kurier;

// class constructor
   function kurierpobranie() {
     global $order;
     $this->code = 'kurierpobranie';
     $this->title = MODULE_SHIPPING_KURIERPOBRANIE_TEXT_TITLE;
     $this->description = MODULE_SHIPPING_KURIERPOBRANIE_TEXT_DESCRIPTION;
     $this->sort_order = MODULE_SHIPPING_KURIERPOBRANIE_SORT_ORDER;
     $this->icon = '';
     $this->tax_class = MODULE_SHIPPING_KURIERPOBRANIE_TAX_CLASS;
     $this->enabled = ((MODULE_SHIPPING_KURIERPOBRANIE_STATUS == 'True') ? true : false);

     // CUSTOMIZE THIS SETTING FOR THE NUMBER OF ZONES NEEDED
     $this->num_kurier =1;

      if ( ($this->enabled == true) && ((int)MODULE_SHIPPING_KURIERPOBRANIE_ZONE > 0) ) {
        $check_flag = false;
        $check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_SHIPPING_KURIERPOBRANIE_ZONE . "' and zone_country_id = '" . $order->delivery['country']['id'] . "' order by zone_id");
        while ($check = tep_db_fetch_array($check_query)) {
          if ($check['zone_id'] < 1) {
            $check_flag = true;
            break;
          } elseif ($check['zone_id'] == $order->delivery['zone_id']) {
            $check_flag = true;
            break;
          }
        }

        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

// class methods
  function quote($method = '') {
	 global $order, $cart, $shipping_weight, $shipping_num_boxes, $currencies;
	 $order_total = $cart->show_total();	 

     $dest_zone = 1;
     $shipping = -1;
     $kurier_cost = constant('MODULE_SHIPPING_KURIERPOBRANIE_COST_' . $dest_zone);
     $kurier_table = split("[:,]" , $kurier_cost);
     $size = sizeof($kurier_table);
     for ($i=0; $i<$size; $i+=2) {
         if ($shipping_weight <= $kurier_table[$i]) {
           $shipping = $kurier_table[$i+1];
           $shipping_method = MODULE_SHIPPING_KURIERPOBRANIE_TEXT_WAY . ' ' . $order->delivery['country']['title'] . ': ';
           if ($shipping_num_boxes > 1) {
             $shipping_method .= $shipping_num_boxes . 'x ';
           }
           $shipping_method .= $shipping_weight . ' ' . MODULE_SHIPPING_KURIERPOBRANIE_TEXT_UNITS;
           break;
         }
     }

     if ($shipping == -1) {
         $shipping_cost = 0;
         $shipping_method = MODULE_SHIPPING_KURIERPOBRANIE_UNDEFINED_RATE;
		 $brak_mozliwosci = true;
       } else {
         $shipping_cost = ($shipping * $shipping_num_boxes) + constant('MODULE_SHIPPING_KURIERPOBRANIE_HANDLING_' . $dest_zone);
		 $brak_mozliwosci = false;
     }

     $this->quotes = array('id' => $this->code,
                           'module' => MODULE_SHIPPING_KURIERPOBRANIE_TEXT_TITLE,
                           'methods' => array(array('id' => $this->code,
                                                    'title' => $shipping_method,
                                                    'cost' => $shipping_cost)));
     if ($this->tax_class > 0) {
       $this->quotes['tax'] = tep_get_tax_rate($this->tax_class, $order->delivery['country']['id'], $order->delivery['zone_id']);
     }

     if (tep_not_null($this->icon)) $this->quotes['icon'] = tep_image($this->icon, $this->title);
	 if (MODULE_SHIPPING_KURIERPOBRANIE_OFF == 'False' && $brak_mozliwosci == true) {
		 return;
	   } else { 
		if ($order_total > (int)MODULE_SHIPPING_KURIERPOBRANIE_MAKSYMALNIE) {
		 return;
		 } else {
		 return $this->quotes;
		}
     }	
     }

   function check() {
     if (!isset($this->_check)) {
       $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_KURIERPOBRANIE_STATUS'");
       $this->_check = tep_db_num_rows($check_query);
     }
     return $this->_check;
   }

   // elari - Added to select default country if not in listing
   function install() {
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Włączenie modułu', 'MODULE_SHIPPING_KURIERPOBRANIE_STATUS', 'True', 'Czy włączyć moduł Kurier za pobraniem ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Grupa VAT', 'MODULE_SHIPPING_KURIERPOBRANIE_TAX_CLASS', '0', 'Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.', '6', '0', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Strefa dostawy', 'MODULE_SHIPPING_KURIERPOBRANIE_ZONE', '0', 'Wybierz strefę, dla której ma być stosowany ten sposob dostawy', '6', '0', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sortowanie', 'MODULE_SHIPPING_KURIERPOBRANIE_SORT_ORDER', '0', 'Kolejność wyświetlania wśród innych modułów wysyłki.', '6', '0', now())");
     for ($i = 1; $i <= $this->num_kurier; $i++) {
        $default_countries = '';
       if ($i == 1) {
         $strefa = 'Polska';
         $default_countries = 'PL'; ///przesylka ekonomiczna krajowa
         $shipping_table = '9999:25.00';
       }
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Tablica kosztów (wg cennika Kuriera)', 'MODULE_SHIPPING_KURIERPOBRANIE_COST_" . $i ."', '" . $shipping_table . "', 'Koszty przesyłki bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50', '6', '0', now())");
       tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Dodatkowy stały koszt obsługi wysyłki', 'MODULE_SHIPPING_KURIERPOBRANIE_HANDLING_" . $i ."', '0', 'Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ', '6', '0', now())");
     }
     tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Do jakiej wysokości zamówienia obowiązuje wysyłka ?', 'MODULE_SHIPPING_KURIERPOBRANIE_MAKSYMALNIE', '999999', 'Wartość zamówienia do której obowiązuje przesyłka. Powyżej wpisanej wartości przesyłka będzie wyłączona.', '6', '0', now())");	   	 
	 tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Jeżeli nie można określić kosztów wysyłki ?', 'MODULE_SHIPPING_KURIERPOBRANIE_OFF', 'False', 'Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
   }

   // elari - Added to select default country if not in listing
   function remove() {
     tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
   }

   function keys() {
     //$keys = array('MODULE_SHIPPING_KURIERPOBRANIE_STATUS', 'MODULE_SHIPPING_KURIERPOBRANIE_TAX_CLASS', 'MODULE_SHIPPING_KURIERPOBRANIE_SORT_ORDER','MODULE_SHIPPING_KURIERPOBRANIE_KOSZT_POBRANIA');
     $keys = array('MODULE_SHIPPING_KURIERPOBRANIE_STATUS', 'MODULE_SHIPPING_KURIERPOBRANIE_TAX_CLASS', 'MODULE_SHIPPING_KURIERPOBRANIE_SORT_ORDER', 'MODULE_SHIPPING_KURIERPOBRANIE_ZONE', 'MODULE_SHIPPING_KURIERPOBRANIE_MAKSYMALNIE','MODULE_SHIPPING_KURIERPOBRANIE_OFF');
     for ($i=1; $i<=$this->num_kurier; $i++) {
       $keys[] = 'MODULE_SHIPPING_KURIERPOBRANIE_COST_' . $i;
       $keys[] = 'MODULE_SHIPPING_KURIERPOBRANIE_HANDLING_' . $i;
     }
     return $keys;
   }
 }
?>