<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

  class ot_payment_online {
    var $title, $output;

    function ot_payment_online() {
      $this->code = 'ot_payment_online';
      $this->title = MODULE_PAYMENT_ONLINE_TITLE;
      $this->description = MODULE_PAYMENT_ONLINE_DESCRIPTION;
      $this->enabled = MODULE_PAYMENT_ONLINE_STATUS;
      $this->sort_order = MODULE_PAYMENT_ONLINE_SORT_ORDER;
      $this->include_shipping = MODULE_PAYMENT_ONLINE_INC_SHIPPING;
      $this->include_tax = MODULE_PAYMENT_ONLINE_INC_TAX;
      $this->percentage = MODULE_PAYMENT_ONLINE_PERCENTAGE;
      $this->minimum = MODULE_PAYMENT_ONLINE_MINIMUM;
      $this->output = array();
    }

    function process() {
     global $order, $currencies;

      $od_amount = $this->calculate_credit($this->get_order_total());
      if ($od_amount[0]>0) {
	      $this->deduction = $od_amount[0];
	      $this->output[] = array('title' => $this->title . ' ('.$od_amount[1].'%):',
	                              'text' => '+<b>' . $currencies->format($od_amount[0]) . '</b>',
	                              'value' => $od_amount[0]);
	      $order->info['total'] = $order->info['total'] + $od_amount[0];  
	  }
    }
    

  function calculate_credit($amount) {
    global $order, $customer_id, $payment;
    $od_amount = 0;
    $do = false;
    if ($amount > $this->minimum) {
	    $table = explode("," , MODULE_PAYMENT_ONLINE_PERCENTAGE);
	    for ($i = 0; $i < count($table); $i++) {
		    $tabl_nazwa = explode(":" , $table[$i]);
	        if ($payment == trim($tabl_nazwa[0])) {
				$do = true;
				$procent = $tabl_nazwa[1];
	        }
		}
	    if ($do) {
		    $od_amount = $amount * ((int)$procent/100);
	    }
    }
    return array($od_amount,$procent);
  }

   
  function get_order_total() {
    global  $order, $cart;
    $order_total = $order->info['total'];
// Check if gift voucher is in cart and adjust total
    $products = $cart->get_products();
    for ($i=0; $i<sizeof($products); $i++) {
      $t_prid = tep_get_prid($products[$i]['id']);
      $gv_query = tep_db_query("select products_price, products_tax_class_id, products_model from " . TABLE_PRODUCTS . " where products_id = '" . $t_prid . "'");
      $gv_result = tep_db_fetch_array($gv_query);
      if (ereg('^GIFT', addslashes($gv_result['products_model']))) { 
        $qty = $cart->get_quantity($t_prid);
        $products_tax = tep_get_tax_rate($gv_result['products_tax_class_id']);
        if ($this->include_tax =='false') {
           $gv_amount = $gv_result['products_price'] * $qty;
        } else {
          $gv_amount = ($gv_result['products_price'] + tep_calculate_tax($gv_result['products_price'],$products_tax)) * $qty;
        }
        $order_total=$order_total - $gv_amount;
      }
    }
    if ($this->include_tax == 'false') $order_total=$order_total-$order->info['tax'];
    if ($this->include_shipping == 'false') $order_total=$order_total-$order->info['shipping_cost'];
    return $order_total;
  }  

    
    function check() {
      if (!isset($this->check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_ONLINE_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }

      return $this->check;
    }

    function keys() {
      return array('MODULE_PAYMENT_ONLINE_STATUS', 'MODULE_PAYMENT_ONLINE_SORT_ORDER','MODULE_PAYMENT_ONLINE_PERCENTAGE','MODULE_PAYMENT_ONLINE_MINIMUM', 'MODULE_PAYMENT_ONLINE_INC_SHIPPING', 'MODULE_PAYMENT_ONLINE_INC_TAX');
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Koszt za płatność online', 'MODULE_PAYMENT_ONLINE_STATUS', 'true', 'Czy chcesz zastosować dodatkowe koszty za formę płatności online ?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Kolejność wyświetlania', 'MODULE_PAYMENT_ONLINE_SORT_ORDER', '999', 'Na którym miejscu pokazać ?', '6', '2', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function ,date_added) values ('Uwzględniaj kwotę wysyłki', 'MODULE_PAYMENT_ONLINE_INC_SHIPPING', 'true', 'Czy do obliczenia kosztu brać również koszt wysyłki ?', '6', '5', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function ,date_added) values ('Uwzględniaj podatek', 'MODULE_PAYMENT_ONLINE_INC_TAX', 'true', 'Czy dodatkowy koszt obliczać od wartości zamówienia brutto ? Włączone - brutto, wyłączone - netto.', '6', '6','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Narzut procentowy dla modułów', 'MODULE_PAYMENT_ONLINE_PERCENTAGE', 'ppec:3, payu:3, platnosci:3, przelewy24:3, worldpay:3', 'Wielkość kosztu (w procentach). Należy wpisywać w postaci: modul:procent,modul:procent ...', '6', '7', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Minimalne zamówienie', 'MODULE_PAYMENT_ONLINE_MINIMUM', '100', 'Minimalna wartość zamówienia żeby został naliczany koszt', '6', '2', now())");
    }

    function remove() {
      $keys = '';
      $keys_array = $this->keys();
      for ($i=0; $i<sizeof($keys_array); $i++) {
        $keys .= "'" . $keys_array[$i] . "',";
      }
      $keys = substr($keys, 0, -1);

      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in (" . $keys . ")");
    }
  }
?>