<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

////
// Return a product's description
// TABLES: products description

function tep_get_products_description($product_id) {
global $languages_id;

$product_query = tep_db_query("select products_description from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . $product_id . "' and language_id = '" . $languages_id . "'");
$product_description = tep_db_fetch_array($product_query);

return $product_description['products_description'];
}

////
// Stop from parsing any further PHP code
  function tep_exit() {
   tep_session_close();
   exit();
  }

  function tep_redirect($url) {
    $url = str_replace('&amp;', '&', $url);
    if ( (strstr($url, "\n") != false) || (strstr($url, "\r") != false) ) {
      tep_redirect(tep_href_link(FILENAME_DEFAULT, '', 'NONSSL', false));
    }
    if ( (ENABLE_SSL == true) && (getenv('HTTPS') == 'on') ) { // We are loading an SSL page
      if (substr($url, 0, strlen(HTTP_SERVER)) == HTTP_SERVER) { // NONSSL url
        $url = HTTPS_SERVER . substr($url, strlen(HTTP_SERVER)); // Change it to SSL
      }
    }
	  header('Location: ' . $url);
    tep_exit();
  }

////
// Parse the data used in the html tags to ensure the tags will not break
  function tep_parse_input_field_data($data, $parse) {
    return strtr(trim($data), $parse);
  }

  function tep_output_string($string, $translate = false, $protected = false) {
    if ($protected == true) {
      return htmlspecialchars($string);
    } else {
      if ($translate == false) {
        return tep_parse_input_field_data($string, array('"' => '&quot;'));
      } else {
        return tep_parse_input_field_data($string, $translate);
      }
    }
  }

  function tep_output_string_protected($string) {
    return tep_output_string($string, false, true);
  }

  function tep_sanitize_string($string) {
    $string = ereg_replace(' +', ' ', trim($string));

    return preg_replace("/[<>]/", '_', $string);
  }

////
// Return a random row from a database query
  function tep_random_select($query) {
    $random_product = '';
    $random_query = tep_db_query($query);
    $num_rows = tep_db_num_rows($random_query);
    if ($num_rows > 0) {
      $random_row = tep_rand(0, ($num_rows - 1));
      tep_db_data_seek($random_query, $random_row);
      $random_product = tep_db_fetch_array($random_query);
    }

    return $random_product;
  }

////
// Return a product's name
// TABLES: products
  function tep_get_products_name($product_id, $language = '') {
    global $languages_id;

    if (empty($language)) $language = $languages_id;

    $product_query = tep_db_query("select products_name from " . TABLE_PRODUCTS_DESCRIPTION . " where products_id = '" . (int)$product_id . "' and language_id = '" . (int)$language . "'");
    $product = tep_db_fetch_array($product_query);

    return $product['products_name'];
  }


////
// Return a product's stock
// TABLES: products
  function tep_get_products_stock($products_id, $attributes=array()) {
    global $languages_id;
    $products_id = tep_get_prid($products_id);
    if (sizeof($attributes)>0) {
      $all_nonstocked = true;
      $attr_list='';
      $options_list=implode(",",array_keys($attributes));
      $track_stock_query=tep_db_query("select products_options_id, products_options_track_stock from " . TABLE_PRODUCTS_OPTIONS . " where products_options_id in ($options_list) and language_id= '" . (int)$languages_id . "' order by products_options_id");
      while($track_stock_array=tep_db_fetch_array($track_stock_query)) {
        if ($track_stock_array['products_options_track_stock']) {
          $attr_list.=$track_stock_array['products_options_id'] . '-' . $attributes[$track_stock_array['products_options_id']] . ',';
          $all_nonstocked=false;
        }
      }
      $attr_list=substr($attr_list,0,strlen($attr_list)-1);
    }

    if ((sizeof($attributes)==0) | ($all_nonstocked)) {
      $stock_query = tep_db_query("select products_quantity as quantity from " . TABLE_PRODUCTS . " where products_id = '" . (int)$products_id . "'");
    } else {
      $stock_query=tep_db_query("select products_stock_quantity as quantity from " . TABLE_PRODUCTS_STOCK . " where products_id='". (int)$products_id . "' and products_stock_attributes='$attr_list'");
    }
    if (tep_db_num_rows($stock_query)>0) {
      $stock=tep_db_fetch_array($stock_query);
      $quantity=$stock['quantity'];
    } else {
      $quantity = 0;
    }
    return $quantity;
//++++ QT Pro: End Changed Code

//  function tep_get_products_stock($products_id) {
//    $products_id = tep_get_prid($products_id);
//    $stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . (int)$products_id . "'");
//    $stock_values = tep_db_fetch_array($stock_query);
//    return $stock_values['products_quantity'];
  }

////
// Check if the required stock is available
// If insufficent stock is available return an out of stock message
//  function tep_check_stock($products_id, $products_quantity) {
//    $stock_left = tep_get_products_stock($products_id) - $products_quantity;
//    $out_of_stock = '';

//    if ($stock_left < 0) {
//      $out_of_stock = '<span class="markProductOutOfStock">' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . '</span>';
//    }

//    return $out_of_stock;
//  }


  function tep_check_stock($products_id, $products_quantity, $attributes=array()) {
    $stock_left = tep_get_products_stock($products_id, $attributes) - $products_quantity;
    $out_of_stock = '';

    if ($stock_left < 0) {
      $out_of_stock = '<span class="markProductOutOfStock"><br>' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . '</span>';
    }

    return $out_of_stock;
  }

  /*
  function tep_check_stock($products_id, $products_quantity) {
    $stock_available = tep_get_products_stock($products_id);
    if ($stock_available <= 0){
    return '<br><span class="markProductOutOfStock">' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . '<br>' . TEXT_NOT_AVAILABLEINSTOCK . '</span>';
    }
    else {
    $stock_left = $stock_available - $products_quantity;
    $out_of_stock = '';

    if ($stock_left < 0) {
      $out_of_stock = '<br><span class="markProductOutOfStock">' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . '<br>' . TEXT_ONLY_THIS_AVAILABLEINSTOCK1 . $stock_available . TEXT_ONLY_THIS_AVAILABLEINSTOCK2 . '</span>';
    }

    return $out_of_stock;
   }
  }
*/

////
// Break a word in a string if it is longer than a specified length ($len)
  function tep_break_string($string, $len, $break_char = '-') {
    $l = 0;
    $output = '';
    for ($i=0, $n=strlen($string); $i<$n; $i++) {
      $char = substr($string, $i, 1);
      if ($char != ' ') {
        $l++;
      } else {
        $l = 0;
      }
      if ($l > $len) {
        $l = 1;
        $output .= $break_char;
      }
      $output .= $char;
    }

    return $output;
  }

////
// Return all HTTP GET variables, except those passed as a parameter
  function tep_get_all_get_params($exclude_array = '') {
    global $HTTP_GET_VARS;

    if (!is_array($exclude_array)) $exclude_array = array();

    $get_url = '';
    if (is_array($HTTP_GET_VARS) && (sizeof($HTTP_GET_VARS) > 0)) {
      reset($HTTP_GET_VARS);
      while (list($key, $value) = each($HTTP_GET_VARS)) {
        if ( (strlen($value) > 0) && ($key != tep_session_name()) && ($key != 'error') && (!in_array($key, $exclude_array)) && ($key != 'x') && ($key != 'y') ) {
          $get_url .= $key . '=' . rawurlencode(stripslashes($value)) . '&';
        }
      }
    }

    return $get_url;
  }

////
// Returns an array with countries
// TABLES: countries
  function tep_get_countries($countries_id = '', $with_iso_codes = false) {
    $countries_array = array();
    if (tep_not_null($countries_id)) {
      if ($with_iso_codes == true) {
        $countries = tep_db_query("select countries_name, countries_iso_code_2, countries_iso_code_3 from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$countries_id . "' order by countries_name");
        $countries_values = tep_db_fetch_array($countries);
        $countries_array = array('countries_name' => $countries_values['countries_name'],
                                 'countries_iso_code_2' => $countries_values['countries_iso_code_2'],
                                 'countries_iso_code_3' => $countries_values['countries_iso_code_3']);
      } else {
        $countries = tep_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$countries_id . "'");
        $countries_values = tep_db_fetch_array($countries);
        $countries_array = array('countries_name' => $countries_values['countries_name']);
      }
    } else {
      $countries = tep_db_query("select countries_id, countries_name from " . TABLE_COUNTRIES . " order by countries_name");
      while ($countries_values = tep_db_fetch_array($countries)) {
        $countries_array[] = array('countries_id' => $countries_values['countries_id'],
                                   'countries_name' => $countries_values['countries_name']);
      }
    }

    return $countries_array;
  }

////
// Alias function to tep_get_countries, which also returns the countries iso codes
  function tep_get_countries_with_iso_codes($countries_id) {
    return tep_get_countries($countries_id, true);
  }

////
// Generate a path to categories
// changed to do everything without queries and in one query if parent_id or grand_parent_id is not set
    function tep_get_path($current_category_id = '', $parent_id = '', $grand_parent_id = '') {
    global $cPath_array;

    if (tep_not_null($current_category_id)) {
      $cp_size = sizeof($cPath_array);
      if ($cp_size == 0) {
        $cPath_new = $current_category_id;
      } else {
        $cPath_new = '';
	if (!tep_not_null($parent_id) || !tep_not_null($grand_parent_id) ) {
	$parent_query = tep_db_query("select c.parent_id, pcategories.parent_id as grand_parent_id from categories c, categories AS pcategories where c.categories_id = '" . (int)$cPath_array[($cp_size-1)] . "' and pcategories.categories_id = '" . (int)$current_category_id . "'");

	$parent_categories = tep_db_fetch_array($parent_query);
	$grand_parent_id = $parent_categories['grand_parent_id'];
	$parent_id = $parent_categories['parent_id'];
	}
	if ($parent_id == $grand_parent_id) {
          for ($i=0; $i<($cp_size-1); $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        } else {
          for ($i=0; $i<$cp_size; $i++) {
            $cPath_new .= '_' . $cPath_array[$i];
          }
        }
        $cPath_new .= '_' . $current_category_id;

        if (substr($cPath_new, 0, 1) == '_') {
          $cPath_new = substr($cPath_new, 1);
        }
      }
    } else {
      $cPath_new = implode('_', $cPath_array);
    }

    return 'cPath=' . $cPath_new;
  }

########## Start Function ##########
function tep_get_multiple_paths($multiple_category_ids) {
	global $cPath_array;
	static $cats = array();
	$cp_size = sizeof($cPath_array);
	$exploded = explode(',', $multiple_category_ids);
	if (!in_array('"' . $cPath_array[($cp_size-1)] . '"', $exploded)) {
		$multiple_category_ids .= "," . $cPath_array[($cp_size-1)];
	}
	unset($exploded);
	//Mod
	$categories_parents_result = tep_db_query("SELECT parent_id, categories_id from " . TABLE_CATEGORIES . " where categories_id in (" . $multiple_category_ids . ") ");
	while ($categories_parents = tep_db_fetch_array($categories_parents_result)) {
		$category_parent[] = array (
                               'categories_id' => $categories_parents['categories_id'],
                               'parent_id'     => $categories_parents['parent_id']);
		$parent_by_category[$categories_parents['categories_id']] = $categories_parents['parent_id'];
	}
	tep_db_free_result($categories_parents_result); // Housekeeping
	unset($multiple_category_ids); //Housekeeping
	$counted = count($category_parent);
	for($i=0; $i<$counted; $i++) {
		$current_category_id = $category_parent[$i]['categories_id'];
		//End Mod
		if (tep_not_null($current_category_id)) {
			$cp_size = sizeof($cPath_array);
			if ($cp_size == 0) {
				$cPath_new = $current_category_id;
			} else {
				$cPath_new = '';
				if ( !isset($cats[($cp_size-1)]) ){
					$last_category['parent_id'] = $parent_by_category[$cPath_array[($cp_size-1)]];
					$cats[($cp_size-1)] = $last_category['parent_id'];
				} else {
					$last_category['parent_id'] = $cats[($cp_size-1)];
				}

				if ( !isset($cats[(int)$current_category_id]) ){
					$current_category['parent_id'] = $category_parent[$i]['parent_id'];
					$cats[(int)$current_category_id] = $current_category['parent_id'];
				} else {
					$current_category['parent_id'] = (int)$current_category_id;
				}

				if ($last_category['parent_id'] == $current_category['parent_id']) {
					for ($j=0; $j<($cp_size-1); $j++) {
						$cPath_new .= '_' . $cPath_array[$j];
					}
				} else {
					for ($j=0; $j<$cp_size; $j++) {
						$cPath_new .= '_' . $cPath_array[$j];
					}
				}
				$cPath_new .= '_' . $current_category_id;

				if (substr($cPath_new, 0, 1) == '_') {
					$cPath_new = substr($cPath_new, 1);
					$cPath_list[$category_parent[$i]['categories_id']] = 'cPath=' . $cPath_new;
				}
			}
		} else {
			$cPath_new = implode('_', $cPath_array);
			$cPath_list[$category_parent[$i]['categories_id']] = 'cPath=' . $cPath_new;
		}
	}
	unset($counted, $category_parent, $parent_by_category, $cp_size, $cPath_new, $last_category);
	return $cPath_list;
}

########## End Function ##########

////
// Returns the clients browser
  function tep_browser_detect($component) {
// >>> BEGIN REGISTER_GLOBALS
//    global $HTTP_USER_AGENT;

    return stristr($_SERVER['HTTP_USER_AGENT'], $component);
// <<< END REGISTER_GLOBALS
  }

////
// Alias function to tep_get_countries()
  function tep_get_country_name($country_id) {
    $country_array = tep_get_countries($country_id);

    return $country_array['countries_name'];
  }

////
// Returns the zone (State/Province) name
// TABLES: zones
  function tep_get_zone_name($country_id, $zone_id, $default_zone) {
    $zone_query = tep_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' and zone_id = '" . (int)$zone_id . "'");
    if (tep_db_num_rows($zone_query)) {
      $zone = tep_db_fetch_array($zone_query);
      return $zone['zone_name'];
    } else {
      return $default_zone;
    }
  }

////
// Returns the zone (State/Province) code
// TABLES: zones
  function tep_get_zone_code($country_id, $zone_id, $default_zone) {
    $zone_query = tep_db_query("select zone_code from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country_id . "' and zone_id = '" . (int)$zone_id . "'");
    if (tep_db_num_rows($zone_query)) {
      $zone = tep_db_fetch_array($zone_query);
      return $zone['zone_code'];
    } else {
      return $default_zone;
    }
  }

////
// Wrapper function for round()
  function tep_round($number, $precision) {
    if (strpos($number, '.') && (strlen(substr($number, strpos($number, '.')+1)) > $precision)) {
      $number = substr($number, 0, strpos($number, '.') + 1 + $precision + 1);

      if (substr($number, -1) >= 5) {
        if ($precision > 1) {
          $number = substr($number, 0, -1) + ('0.' . str_repeat(0, $precision-1) . '1');
        } elseif ($precision == 1) {
          $number = substr($number, 0, -1) + 0.1;
        } else {
          $number = substr($number, 0, -1) + 1;
        }
      } else {
        $number = substr($number, 0, -1);
      }
    }

    return $number;
  }


////
// Returns the tax rate for a zone / class
// TABLES: tax_rates, zones_to_geo_zones

  function tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1) {
   global $customer_zone_id, $customer_country_id, $osC_Tax;
   return $osC_Tax->getTaxRate($class_id, $country_id, $zone_id);
  }
//  function tep_get_tax_rate($class_id, $country_id = -1, $zone_id = -1) {
//    global $customer_zone_id, $customer_country_id;

//    if ( ($country_id == -1) && ($zone_id == -1) ) {
//      if (!tep_session_is_registered('customer_id')) {
//        $country_id = STORE_COUNTRY;
//        $zone_id = STORE_ZONE;
//      } else {
//        $country_id = $customer_country_id;
//        $zone_id = $customer_zone_id;
//      }
//    }

//   $tax_query = tep_db_query("select sum(tax_rate) as tax_rate from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' group by tr.tax_priority");
//    if (tep_db_num_rows($tax_query)) {
//      $tax_multiplier = 1.0;
//      while ($tax = tep_db_fetch_array($tax_query)) {
//        $tax_multiplier *= 1.0 + ($tax['tax_rate'] / 100);
//      }
//      return ($tax_multiplier - 1.0) * 100;
//    } else {
//      return 0;
//    }
//  }

////
// Return the tax description for a zone / class
// TABLES: tax_rates;
  function tep_get_tax_description($class_id, $country_id, $zone_id) {
    global $osC_Tax;
    return $osC_Tax->getTaxRateDescription($class_id, $country_id, $zone_id);
  }
//  function tep_get_tax_description($class_id, $country_id, $zone_id) {
//    $tax_query = tep_db_query("select tax_description from " . TABLE_TAX_RATES . " tr left join " . TABLE_ZONES_TO_GEO_ZONES . " za on (tr.tax_zone_id = za.geo_zone_id) left join " . TABLE_GEO_ZONES . " tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id = '" . (int)$country_id . "') and (za.zone_id is null or za.zone_id = '0' or za.zone_id = '" . (int)$zone_id . "') and tr.tax_class_id = '" . (int)$class_id . "' order by tr.tax_priority");
//    if (tep_db_num_rows($tax_query)) {
//      $tax_description = '';
//      while ($tax = tep_db_fetch_array($tax_query)) {
//        $tax_description .= $tax['tax_description'] . ' + ';
//      }
//      $tax_description = substr($tax_description, 0, -3);

//      return $tax_description;
//    } else {
//      return TEXT_UNKNOWN_TAX_RATE;
//    }
//  }


////
// Add tax to a products price
  function tep_add_tax($price, $tax, $override = false) {
    if ( ( (DISPLAY_PRICE_WITH_TAX == 'true') || ($override == true) ) && ($tax > 0) ) {
      return $price + tep_calculate_tax($price, $tax);
    } else {
      return $price;
    }
  }

// Add tax to a products price
  function tep_add_tax_invoice($price, $tax) {

    if ( ($tax > 0) ) {
      return $price + tep_calculate_tax($price, $tax);
    } else {
      return $price;
    }
  }

// Calculates Tax rounding the result
  function tep_calculate_tax($price, $tax) {
    return $price * $tax / 100;
  }

////
// Return the number of products in a category
// TABLES: products, products_to_categories, categories
  function tep_count_products_in_category($category_id, $include_inactive = false) {
    $products_count = 0;
    if ($include_inactive == true) {
      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p2c.categories_id = '" . (int)$category_id . "'");
    } else {
//      $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = p2c.products_id and p.products_status = '1' and p2c.categories_id = '" . (int)$category_id . "'");
	  $products_query = tep_db_query("select count(*) as total from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c left join " . TABLE_CATEGORIES . " c on p2c.categories_id = c.categories_id where p.products_id = p2c.products_id and c.categories_status = '1' and p.products_status = '1' and p2c.categories_id = '" . (int)$category_id . "'");
    }
    $products = tep_db_fetch_array($products_query);
    $products_count += $products['total'];

    $child_categories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$category_id . "'");
    if (tep_db_num_rows($child_categories_query)) {
      while ($child_categories = tep_db_fetch_array($child_categories_query)) {
        $products_count += tep_count_products_in_category($child_categories['categories_id'], $include_inactive);
      }
    }

    return $products_count;
  }

////
// Return true if the category has subcategories
// TABLES: categories
  function tep_has_category_subcategories($category_id) {
    $child_category_query = tep_db_query("select count(*) as count from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$category_id . "'");
    $child_category = tep_db_fetch_array($child_category_query);

    if ($child_category['count'] > 0) {
      return true;
    } else {
      return false;
    }
  }

////
// Returns the address_format_id for the given country
// TABLES: countries;
  function tep_get_address_format_id($country_id) {
    $address_format_query = tep_db_query("select address_format_id as format_id from " . TABLE_COUNTRIES . " where countries_id = '" . (int)$country_id . "'");
    if (tep_db_num_rows($address_format_query)) {
      $address_format = tep_db_fetch_array($address_format_query);
      return $address_format['format_id'];
    } else {
      return '1';
    }
  }

function module_download($id_produkt) {
global $customer_id,$languages_id;
if ((tep_session_is_registered('customer_id') && $customer_id != '0') || (DOWNLOAD_LOGIN == '0' || DOWNLOAD_LOGIN == 'false')) {
    //
    $download_query = tep_db_query("select id_download, name_download, file_download, opis_download, status_download from download where status_download = '1' and language_download = '" . (int)$languages_id . "' and products_id = '".(int)$id_produkt."'  order by name_download ");
    if ((int)tep_db_num_rows($download_query) > 0) {
        echo '<tr><td style="padding-top:5px;padding-bottom:8px;"><table width="100%" cellspacing="0" cellpadding="3" border="0" class="TableFrame"><tr><td class="main" align="right" style="padding:5px"><b>Download</b></td></tr>';
        while ($download_x = tep_db_fetch_array($download_query)) {
            echo '<tr>
                    <td class="main" align="left" width="100%">
                       <a class="boxLink" style="font-weight:bold" href="' . tep_href_link('images/'.$download_x['file_download']) . '">' . osc_trunc_string($download_x['name_download'], 50, 1) . '</a>
                    </td>
                  </tr>';
            if ($download_x['opis_download'] != '' && (DOWNLOAD_OPIS == '1' || DOWNLOAD_OPIS == 'true')) {
                echo '<tr>
                        <td class="smallText" align="left" width="100%">' . $download_x['opis_download'] . '
                        </td>
                     </tr>';
            }
        }
        echo '</table></td></tr>';
    }
} }

function module_videos($id_produkt) {
global $customer_id,$languages_id;
$film_query = tep_db_query("select id_film, screen_width, screen_height, full_screen, name_film, film_desc, source, products_id, status, language from film where products_id = " . (int)$id_produkt . " and status = '1' and language = " . (int)$languages_id);
$film = tep_db_fetch_array($film_query);
if ($film['id_film'] != '') {
    echo '<tr><td style="padding-top:3px;padding-bottom:3px">
        <table width="100%" cellspacing="0" cellpadding="0" border="0" class="TableFrame">
            <tr><td class="main" align="center" style="padding:6px"><b>'.VIDEO_2.'<b></td></tr>
            <tr><td class="smallText" align="center" style="padding:6px">
                <script type="text/javascript" src="swfobject.js"></script>
                <div id="film" style="margin-top:0px; margin-left: 0px; width: '.$film['screen_width'].'px; height: '. $film['screen_height'] .'px; z-index: 0; border:2px solid #000">
                </div>
                <script type="text/javascript">
                var film = new SWFObject("player.swf","single","'.$film['screen_width'].'","'.$film['screen_height'].'","7");
                film.addParam("allowfullscreen","'.($film['full_screen']=='true' ? 'true' : 'false').'");
                film.addVariable("width","'.$film['screen_width'].'");
                film.addVariable("height","'.$film['screen_height'].'");
                film.addVariable("movie","images/'.$film['source'].'");
                film.addVariable("bgcolor","0x000000");
                film.addVariable("autoplay","on");
                film.write("film");
                </script>
            </td></tr>
        </table>
    </td></tr>';
} }

////
// Return a formatted address
// TABLES: address_format
  function tep_address_format($address_format_id, $address, $html, $boln, $eoln) {
    global $language;
    $address_format_query = tep_db_query("select address_format as format from " . TABLE_ADDRESS_FORMAT . " where address_format_id = '" . (int)$address_format_id . "'");
    $address_format = tep_db_fetch_array($address_format_query);

    $company = tep_output_string_protected($address['company']);
    $nip = tep_output_string_protected($address['nip']);
    if (isset($address['firstname']) && tep_not_null($address['firstname'])) {
      $firstname = tep_output_string_protected($address['firstname']);
      $lastname = tep_output_string_protected($address['lastname']);
    } elseif (isset($address['name']) && tep_not_null($address['name'])) {
      $firstname = tep_output_string_protected($address['name']);
      $lastname = '';
    } else {
      $firstname = '';
      $lastname = '';
    }
    $street = tep_output_string_protected($address['street_address']);
    $suburb = tep_output_string_protected($address['suburb']);
    $city = tep_output_string_protected($address['city']);
    $state = tep_output_string_protected($address['state']);
    if (isset($address['country_id']) && tep_not_null($address['country_id'])) {
      $country = tep_get_country_name($address['country_id']);

      if (isset($address['zone_id']) && tep_not_null($address['zone_id'])) {
        $state = tep_get_zone_code($address['country_id'], $address['zone_id'], $state);
      }
    } elseif (isset($address['country']) && tep_not_null($address['country'])) {
//      $country = tep_output_string_protected($address['country']);
      $country = tep_output_string_protected($address['country']['title']);
		} else {
      $country = '';
    }
    $postcode = tep_output_string_protected($address['postcode']);
    $zip = $postcode;

    if ($html) {
// HTML Mode
      $HR = '<hr>';
      $hr = '<hr>';
      if ( ($boln == '') && ($eoln == "\n") ) { // Values not specified, use rational defaults
        $CR = '<br>';
        $cr = '<br>';
        $eoln = $cr;
      } else { // Use values supplied
        $CR = $eoln . $boln;
        $cr = $CR;
      }
    } else {
// Text Mode
      $CR = $eoln;
      $cr = $CR;
      $HR = '----------------------------------------';
      $hr = '----------------------------------------';
    }

    $statecomma = '';
    $streets = $street;
    if ($suburb != '') $streets = $street . $cr . $suburb;
    if ($state != '') $statecomma = $state . ', ';

    if ( tep_not_null($company) ) {
       $fmt = str_replace('$firstname','',$address_format['format']);
       $fmt = str_replace('$lastname$cr','',$fmt);
      } else {
       $fmt = $address_format['format'];
    }
    eval("\$address = \"$fmt\";");

    if ( tep_not_null($company) ) {
      if ($language == 'polish') {
          //$address = $company . $cr . $address . $cr . 'NIP: ' . $nip . $cr . 'Kontakt: '.$firstname .' '. $lastname;
          $address = $company . $cr . $address . $cr . (($nip!='') ? 'NIP: ' . $nip : '');
        } else {
          $address = $company . $cr . $address . $cr . $nip . $cr . $firstname .' '. $lastname;
      }
    }

    return $address;
  }

////
// Return a formatted address
// TABLES: customers, address_book
  function tep_address_label($customers_id, $address_id = 1, $html = false, $boln = '', $eoln = "\n") {
		if (is_array($address_id) && !empty($address_id)) {
      return tep_address_format($address_id['address_format_id'], $address_id, $html, $boln, $eoln);
    }

      $address_query = tep_db_query("select entry_firstname as firstname, entry_lastname as lastname, entry_company as company, entry_nip as nip, entry_street_address as street_address, entry_suburb as suburb, entry_city as city, entry_postcode as postcode, entry_state as state, entry_zone_id as zone_id, entry_country_id as country_id from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customers_id . "' and address_book_id = '" . (int)$address_id . "'");
      $address = tep_db_fetch_array($address_query);
    $format_id = tep_get_address_format_id($address['country_id']);

    return tep_address_format($format_id, $address, $html, $boln, $eoln);
  }


  function tep_row_number_format($number) {
    if ( ($number < 10) && (substr($number, 0, 1) != '0') ) $number = '0' . $number;

    return $number;
  }


  function tep_get_categories($categories_array = '', $parent_id = '0', $indent = '', $podkat = true) {
    global $kat_array,$languages_id;
    //
    if (!is_array($kat_array)) {
        $kat_array = array();
        $categoriesc_query = tep_db_query("select c.categories_id, cd.categories_name, c.sort_order, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and c.categories_status = '1' and cd.language_id = '".$languages_id."' order by c.sort_order");
        while ($categories = tep_db_fetch_array($categoriesc_query)) {
        $kat_array[] = array('kat_id' => $categories['categories_id'],
                             'kat_parent_id' => $categories['parent_id'],
                             'kat_sort' => $categories['sort_order'],
                             'kat_name' => $categories['categories_name']);
        }
    }
    //
    if (!is_array($categories_array)) $categories_array = array();
    $tab_tmp = array();
    foreach ($kat_array as $tabs) {
        if ($tabs['kat_parent_id'] == $parent_id) {
            $tab_tmp[] = array('id' => $tabs['kat_id'],
                               'text' => $tabs['kat_name']);
        }
    }
    foreach ($tab_tmp as $tabs) {
        $categories_array[] = array('id' => $tabs['id'],
                                    'text' => $indent . $tabs['text']);
        if ($podkat == true) {
            if ($tabs['id'] != $parent_id) {
                $categories_array = tep_get_categories($categories_array, $tabs['id'], $indent . '&nbsp;&nbsp;', $podkat);
            }
        }
    }
    return $categories_array;
  }



  function old_tep_get_categories($categories_array = '', $parent_id = '0', $indent = '') {
    global $languages_id;

    if (!is_array($categories_array)) $categories_array = array();

//    $categories_query = tep_db_query("select c.categories_id, cd.categories_name from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where parent_id = '" . (int)$parent_id . "' and c.categories_id = cd.categories_id and cd.language_id = '" . (int)$languages_id . "' order by sort_order, cd.categories_name");
    $categories_query = tep_db_query("select c.categories_id, cd.categories_name from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where parent_id = '" . (int)$parent_id . "' and c.categories_id = cd.categories_id and c.categories_status = '1' and cd.language_id = '" . (int)$languages_id . "' order by sort_order, cd.categories_name");

	while ($categories = tep_db_fetch_array($categories_query)) {
      $categories_array[] = array('id' => $categories['categories_id'],
                                  'text' => $indent . $categories['categories_name']);

      if ($categories['categories_id'] != $parent_id) {
        $categories_array = old_tep_get_categories($categories_array, $categories['categories_id'], $indent . '&nbsp;&nbsp;');
      }
    }

    return $categories_array;
  }

  function tep_get_manufacturers($manufacturers_array = '') {
    if (!is_array($manufacturers_array)) $manufacturers_array = array();

    $manufacturers_query = tep_db_query("select distinct m.manufacturers_id, m.manufacturers_name from " . TABLE_MANUFACTURERS . " m left join " . TABLE_PRODUCTS . " p on m.manufacturers_id = p.manufacturers_id left join " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c on p.products_id = p2c.products_id left join " . TABLE_CATEGORIES . " c on p2c.categories_id = c.categories_id where c.categories_status = '1' and p.products_status = '1' order by m.manufacturers_name");
    while ($manufacturers = tep_db_fetch_array($manufacturers_query)) {
      $manufacturers_array[] = array('id' => $manufacturers['manufacturers_id'], 'text' => $manufacturers['manufacturers_name']);
    }

    return $manufacturers_array;
  }

////
// Return all subcategory IDs
// TABLES: categories
  function tep_get_subcategories(&$subcategories_array, $parent_id = 0) {
    $subcategories_query = tep_db_query("select categories_id from " . TABLE_CATEGORIES . " where parent_id = '" . (int)$parent_id . "'");
    while ($subcategories = tep_db_fetch_array($subcategories_query)) {
      $subcategories_array[sizeof($subcategories_array)] = $subcategories['categories_id'];
      if ($subcategories['categories_id'] != $parent_id) {
        tep_get_subcategories($subcategories_array, $subcategories['categories_id']);
      }
    }
  }

// Output a raw date string in the selected locale date format
// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
  function tep_date_long($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;

    $year = (int)substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    return strftime(DATE_FORMAT_LONG, mktime($hour,$minute,$second,$month,$day,$year));
  }

////
// Output a raw date string in the selected locale date format
// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
// NOTE: Includes a workaround for dates before 01/01/1970 that fail on windows servers
  function tep_date_short($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || empty($raw_date) ) return false;

    $year = substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    if (@date('Y', mktime($hour, $minute, $second, $month, $day, $year)) == $year) {
      return date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, $year));
    } else {
      return ereg_replace('2037' . '$', $year, date(DATE_FORMAT, mktime($hour, $minute, $second, $month, $day, 2037)));
    }
  }
  
  // funkcja wykorzystywana przy fakturze
  function tep_date_unix($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || empty($raw_date) ) return false;

    $year = substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    return mktime($hour, $minute, $second, $month, $day, $year);
  }  

////
// Parse search string into indivual objects
  function tep_parse_search_string($search_str = '', &$objects) {
    $search_str = trim($search_str);

// Break up $search_str on whitespace; quoted string will be reconstructed later
    $pieces = split('[[:space:]]+', $search_str);
    $objects = array();
    $tmpstring = '';
    $flag = '';

    for ($k=0; $k<count($pieces); $k++) {
      while (substr($pieces[$k], 0, 1) == '(') {
        $objects[] = '(';
        if (strlen($pieces[$k]) > 1) {
          $pieces[$k] = substr($pieces[$k], 1);
        } else {
          $pieces[$k] = '';
        }
      }

      $post_objects = array();

      while (substr($pieces[$k], -1) == ')')  {
        $post_objects[] = ')';
        if (strlen($pieces[$k]) > 1) {
          $pieces[$k] = substr($pieces[$k], 0, -1);
        } else {
          $pieces[$k] = '';
        }
      }

// Check individual words

      if ( (substr($pieces[$k], -1) != '"') && (substr($pieces[$k], 0, 1) != '"') ) {
        $objects[] = trim($pieces[$k]);

        for ($j=0; $j<count($post_objects); $j++) {
          $objects[] = $post_objects[$j];
        }
      } else {
/* This means that the $piece is either the beginning or the end of a string.
   So, we'll slurp up the $pieces and stick them together until we get to the
   end of the string or run out of pieces.
*/

// Add this word to the $tmpstring, starting the $tmpstring
        $tmpstring = trim(ereg_replace('"', ' ', $pieces[$k]));

// Check for one possible exception to the rule. That there is a single quoted word.
        if (substr($pieces[$k], -1 ) == '"') {
// Turn the flag off for future iterations
          $flag = 'off';

          $objects[] = trim($pieces[$k]);

          for ($j=0; $j<count($post_objects); $j++) {
            $objects[] = $post_objects[$j];
          }

          unset($tmpstring);

// Stop looking for the end of the string and move onto the next word.
          continue;
        }

// Otherwise, turn on the flag to indicate no quotes have been found attached to this word in the string.
        $flag = 'on';

// Move on to the next word
        $k++;

// Keep reading until the end of the string as long as the $flag is on

        while ( ($flag == 'on') && ($k < count($pieces)) ) {
          while (substr($pieces[$k], -1) == ')') {
            $post_objects[] = ')';
            if (strlen($pieces[$k]) > 1) {
              $pieces[$k] = substr($pieces[$k], 0, -1);
            } else {
              $pieces[$k] = '';
            }
          }

// If the word doesn't end in double quotes, append it to the $tmpstring.
          if (substr($pieces[$k], -1) != '"') {
// Tack this word onto the current string entity
            $tmpstring .= ' ' . $pieces[$k];

// Move on to the next word
            $k++;
            continue;
          } else {
/* If the $piece ends in double quotes, strip the double quotes, tack the
   $piece onto the tail of the string, push the $tmpstring onto the $haves,
   kill the $tmpstring, turn the $flag "off", and return.
*/
            $tmpstring .= ' ' . trim(ereg_replace('"', ' ', $pieces[$k]));

// Push the $tmpstring onto the array of stuff to search for
            $objects[] = trim($tmpstring);

            for ($j=0; $j<count($post_objects); $j++) {
              $objects[] = $post_objects[$j];
            }

            unset($tmpstring);

// Turn off the flag to exit the loop
            $flag = 'off';
          }
        }
      }
    }

// add default logical operators if needed
    $temp = array();
    for($i=0; $i<(count($objects)-1); $i++) {
      $temp[] = $objects[$i];
      if ( ($objects[$i] != 'and') &&
           ($objects[$i] != 'or') &&
           ($objects[$i] != '(') &&
           ($objects[$i+1] != 'and') &&
           ($objects[$i+1] != 'or') &&
           ($objects[$i+1] != ')') ) {
        $temp[] = ADVANCED_SEARCH_DEFAULT_OPERATOR;
      }
    }
    $temp[] = $objects[$i];
    $objects = $temp;

    $keyword_count = 0;
    $operator_count = 0;
    $balance = 0;
    for($i=0; $i<count($objects); $i++) {
      if ($objects[$i] == '(') $balance --;
      if ($objects[$i] == ')') $balance ++;
      if ( ($objects[$i] == 'and') || ($objects[$i] == 'or') ) {
        $operator_count ++;
      } elseif ( ($objects[$i]) && ($objects[$i] != '(') && ($objects[$i] != ')') ) {
        $keyword_count ++;
      }
    }

    if ( ($operator_count < $keyword_count) && ($balance == 0) ) {
      return true;
    } else {
      return false;
    }
  }

////
// Check date
  function tep_checkdate($date_to_check, $format_string, &$date_array) {
    $separator_idx = -1;

    $separators = array('-', ' ', '/', '.');
    $month_abbr = array('jan','feb','mar','apr','may','jun','jul','aug','sep','oct','nov','dec');
    $no_of_days = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

    $format_string = strtolower($format_string);

    if (strlen($date_to_check) != strlen($format_string)) {
      return false;
    }

    $size = sizeof($separators);
    for ($i=0; $i<$size; $i++) {
      $pos_separator = strpos($date_to_check, $separators[$i]);
      if ($pos_separator != false) {
        $date_separator_idx = $i;
        break;
      }
    }

    for ($i=0; $i<$size; $i++) {
      $pos_separator = strpos($format_string, $separators[$i]);
      if ($pos_separator != false) {
        $format_separator_idx = $i;
        break;
      }
    }

    if ($date_separator_idx != $format_separator_idx) {
      return false;
    }

    if ($date_separator_idx != -1) {
      $format_string_array = explode( $separators[$date_separator_idx], $format_string );
      if (sizeof($format_string_array) != 3) {
        return false;
      }

      $date_to_check_array = explode( $separators[$date_separator_idx], $date_to_check );
      if (sizeof($date_to_check_array) != 3) {
        return false;
      }

      $size = sizeof($format_string_array);
      for ($i=0; $i<$size; $i++) {
        if ($format_string_array[$i] == 'mm' || $format_string_array[$i] == 'mmm') $month = $date_to_check_array[$i];
        if ($format_string_array[$i] == 'dd') $day = $date_to_check_array[$i];
        if ( ($format_string_array[$i] == 'yyyy') || ($format_string_array[$i] == 'aaaa') ) $year = $date_to_check_array[$i];
      }
    } else {
      if (strlen($format_string) == 8 || strlen($format_string) == 9) {
        $pos_month = strpos($format_string, 'mmm');
        if ($pos_month != false) {
          $month = substr( $date_to_check, $pos_month, 3 );
          $size = sizeof($month_abbr);
          for ($i=0; $i<$size; $i++) {
            if ($month == $month_abbr[$i]) {
              $month = $i;
              break;
            }
          }
        } else {
          $month = substr($date_to_check, strpos($format_string, 'mm'), 2);
        }
      } else {
        return false;
      }

      $day = substr($date_to_check, strpos($format_string, 'dd'), 2);
      $year = substr($date_to_check, strpos($format_string, 'yyyy'), 4);
    }

    if (strlen($year) != 4) {
      return false;
    }

    if (!settype($year, 'integer') || !settype($month, 'integer') || !settype($day, 'integer')) {
      return false;
    }

    if ($month > 12 || $month < 1) {
      return false;
    }

    if ($day < 1) {
      return false;
    }

    if (tep_is_leap_year($year)) {
      $no_of_days[1] = 29;
    }

    if ($day > $no_of_days[$month - 1]) {
      return false;
    }

    $date_array = array($year, $month, $day);

    return true;
  }

////
// Check if year is a leap year
  function tep_is_leap_year($year) {
    if ($year % 100 == 0) {
      if ($year % 400 == 0) return true;
    } else {
      if (($year % 4) == 0) return true;
    }

    return false;
  }

////
// Return table heading with sorting capabilities
  function tep_create_sort_heading($sortby, $colnum, $heading) {
    global $PHP_SELF;

    $sort_prefix = '';
    $sort_suffix = '';

   if ($sortby) {
      $sort_prefix = '<a href="' . tep_href_link(basename($PHP_SELF), tep_get_all_get_params(array('page', 'info', 'sort')) . 'page=1&sort=' . $colnum . ($sortby == $colnum . 'a' ? 'd' : 'a')) . '" title="' . tep_output_string(TEXT_SORT_PRODUCTS . ($sortby == $colnum . 'd' || substr($sortby, 0, 1) != $colnum ? TEXT_ASCENDINGLY : TEXT_DESCENDINGLY) . TEXT_BY . $heading) . '" class="productListing-heading">' ;
      $sort_suffix = (substr($sortby, 0, 1) == $colnum ? (substr($sortby, 1, 1) == 'a' ? '+' : '-') : '') . '</a>';
    }

    return $sort_prefix . $heading . $sort_suffix;
  }

////
// Recursively go through the categories and retreive all parent categories IDs
// TABLES: categories
  function tep_get_parent_categories(&$categories, $categories_id) {
    $parent_categories_query = tep_db_query("select parent_id from " . TABLE_CATEGORIES . " where categories_id = '" . (int)$categories_id . "'");
    while ($parent_categories = tep_db_fetch_array($parent_categories_query)) {
      if ($parent_categories['parent_id'] == 0) return true;
      $categories[sizeof($categories)] = $parent_categories['parent_id'];
      if ($parent_categories['parent_id'] != $categories_id) {
        tep_get_parent_categories($categories, $parent_categories['parent_id']);
      }
    }
  }

////
// Construct a category path to the product
// TABLES: products_to_categories
  function tep_get_product_path($products_id) {
    $cPath = '';

    $category_query = tep_db_query("select p2c.categories_id from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " p2c where p.products_id = '" . (int)$products_id . "' and p.products_status = '1' and p.products_id = p2c.products_id limit 1");
    if (tep_db_num_rows($category_query)) {
      $category = tep_db_fetch_array($category_query);

      $categories = array();
      tep_get_parent_categories($categories, $category['categories_id']);

      $categories = array_reverse($categories);

      $cPath = implode('_', $categories);

      if (tep_not_null($cPath)) $cPath .= '_';
      $cPath .= $category['categories_id'];
    }

    return $cPath;
  }

////
// Return a product ID with attributes
//  function tep_get_uprid($prid, $params) {
//    $uprid = $prid;
//    if ( (is_array($params)) && (!strstr($prid, '{')) ) {
//      while (list($option, $value) = each($params)) {
//        $uprid = $uprid . '{' . $option . '}' . $value;
//      }
//    }
//
//    return $uprid;
//  }

function tep_get_uprid($prid, $params) {
  if (is_numeric($prid)) {
    $uprid = $prid;

    if (is_array($params) && (sizeof($params) > 0)) {
      $attributes_check = true;
      $attributes_ids = '';

      reset($params);
      while (list($option, $value) = each($params)) {
        if (is_numeric($option) && is_numeric($value)) {
          $attributes_ids .= '{' . (int)$option . '}' . (int)$value;
        } else {
          $attributes_check = false;
          break;
        }
      }

      if ($attributes_check == true) {
        $uprid .= $attributes_ids;
      }
    }
  } else {
    $uprid = tep_get_prid($prid);

    if (is_numeric($uprid)) {
      if (strpos($prid, '{') !== false) {
        $attributes_check = true;
        $attributes_ids = '';

// strpos()+1 to remove up to and including the first { which would create an empty array element in explode()
        $attributes = explode('{', substr($prid, strpos($prid, '{')+1));

        for ($i=0, $n=sizeof($attributes); $i<$n; $i++) {
          $pair = explode('}', $attributes[$i]);

          if (is_numeric($pair[0]) && is_numeric($pair[1])) {
            $attributes_ids .= '{' . (int)$pair[0] . '}' . (int)$pair[1];
          } else {
            $attributes_check = false;
            break;
          }
        }

        if ($attributes_check == true) {
          $uprid .= $attributes_ids;
        }
      }
    } else {
      return false;
    }
  }

  return $uprid;
}

////
// Return a product ID from a product ID with attributes
//  function tep_get_prid($uprid) {
//    $pieces = explode('{', $uprid);
//
//    return $pieces[0];
//  }
  function tep_get_prid($uprid) {
    $pieces = explode('{', $uprid);

    if (is_numeric($pieces[0])) {
      return $pieces[0];
    } else {
      return false;
    }
  }

////
// Return a customer greeting
  function tep_customer_greeting() {
    global $customer_id, $customer_first_name;

    if (tep_session_is_registered('customer_first_name') && tep_session_is_registered('customer_id')) {
      $greeting_string = sprintf(TEXT_GREETING_PERSONAL, tep_output_string_protected($customer_first_name), tep_href_link(FILENAME_PRODUCTS_NEW));
    } else {
      $greeting_string = sprintf(TEXT_GREETING_GUEST, tep_href_link(FILENAME_LOGIN, 'act=register', 'SSL'), tep_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));
    }

    return $greeting_string;
  }

////
//! Send email (text/html) using MIME
// This is the central mail function. The SMTP Server should be configured
// correct in php.ini
// Parameters:
// $to_name           The name of the recipient, e.g. "Jan Wildeboer"
// $to_email_address  The eMail address of the recipient,
//                    e.g. jan.wildeboer@gmx.de
// $email_subject     The subject of the eMail
// $email_text        The text of the eMail, may contain HTML entities
// $from_email_name   The name of the sender, e.g. Shop Administration
// $from_email_adress The eMail address of the sender,
//                    e.g. info@mytepshop.com

  function tep_mail($to_name, $to_email_address, $email_subject, $email_text, $from_email_name, $from_email_address, $attachment_file=false, $attachment_name=false, $attachment_type=false) {
    if (SEND_EMAILS != 'true') return false;

    //--bof-addon-anti-spam
    if  (preg_match("[\n]", $to_name)) return false;
    if  (preg_match("[\n]", $to_email_address)) return false;
    if  (preg_match("[\n]", $email_subject)) return false;
    if  (preg_match("[\n]", $from_email_name)) return false;
    if  (preg_match("[\n]", $from_email_address)) return false;
    //--eof-addon-anti-spam

    $message = new email(array('X-Mailer: oscGold Mailer'));

	// CZY MAILE HTML
	if (EMAIL_USE_HTML == 'true') {
		$ArrayLNTargets = array("\r\n", "\n\r", "\n", "\r", "\t");
		$html_email = str_replace($ArrayLNTargets, '<br>', $email_text);
		$html_email = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"></head><body style="margin: 0px; padding: 0px; style="font-family:Tahoma,Arial,Verdana,font-size:10px;color:#000000"><font face="Tahoma,Arial,Verdana,serif">'.$html_email.'</font></body></html>';
		$email_text = $html_email;
	}
	$email_text = str_replace("&nbsp;", ' ', $email_text);
	// Build the text version
	if (EMAIL_USE_HTML == 'true') {
	  $message->add_html($email_text, $text);
	} else {
	  $text = strip_tags($email_text);
	  $message->add_text($text);
	}

    // Add an attachment
    if ($attachment_file != false && $attachment_name != false && $attachment_type != false) {
     $attachments = $message->get_file($attachment_file);
      $message->add_attachment($attachments, $attachment_name, $attachment_type);
    }
    // Build the text version
    //$text = strip_tags($email_text);
    //if (EMAIL_USE_HTML == 'true') {
    //  $message->add_html($email_text, $text);
    //} else {
    //  $message->add_text($text);
    //}

    // Send message
    $message->build_message();
    $message->send($to_name, $to_email_address, $from_email_name, $from_email_address, $email_subject);
  }

////
// Check if product has attributes
  function tep_has_product_attributes($products_id) {
    $attributes_query = tep_db_query("select count(*) as count from " . TABLE_PRODUCTS_ATTRIBUTES . " where products_id = '" . (int)$products_id . "'");
    $attributes = tep_db_fetch_array($attributes_query);

    if ($attributes['count'] > 0) {
      return true;
    } else {
      return false;
    }
  }

////
// Get the number of times a word/character is present in a string
  function tep_word_count($string, $needle) {
    $temp_array = split($needle, $string);

    return sizeof($temp_array);
  }

  function tep_count_modules($modules = '') {
    $count = 0;

    if (empty($modules)) return $count;

    $modules_array = split(';', $modules);

    for ($i=0, $n=sizeof($modules_array); $i<$n; $i++) {
      $class = substr($modules_array[$i], 0, strrpos($modules_array[$i], '.'));

      if (is_object($GLOBALS[$class])) {
        if ($GLOBALS[$class]->enabled) {
          $count++;
        }
      }
    }

    return $count;
  }

  function tep_count_payment_modules() {
    return tep_count_modules(MODULE_PAYMENT_INSTALLED);
  }

  function tep_count_shipping_modules() {
    return tep_count_modules(MODULE_SHIPPING_INSTALLED);
  }

  function tep_count_giftwrap_modules() {
    return tep_count_modules(MODULE_GIFTWRAP_INSTALLED);
  }

  function tep_create_random_value($length, $type = 'mixed') {
    if ( ($type != 'mixed') && ($type != 'chars') && ($type != 'digits')) return false;

    $rand_value = '';
    while (strlen($rand_value) < $length) {
      if ($type == 'digits') {
        $char = tep_rand(0,9);
      } else {
        $char = chr(tep_rand(0,255));
      }
      if ($type == 'mixed') {
        if (eregi('^[a-z0-9]$', $char)) $rand_value .= $char;
      } elseif ($type == 'chars') {
        if (eregi('^[a-z]$', $char)) $rand_value .= $char;
      } elseif ($type == 'digits') {
        if (ereg('^[0-9]$', $char)) $rand_value .= $char;
      }
    }

    return $rand_value;
  }

  function tep_array_to_string($array, $exclude = '', $equals = '=', $separator = '&') {
    if (!is_array($exclude)) $exclude = array();

    $get_string = '';
    if (sizeof($array) > 0) {
      while (list($key, $value) = each($array)) {
        if ( (!in_array($key, $exclude)) && ($key != 'x') && ($key != 'y') ) {
          $get_string .= $key . $equals . $value . $separator;
        }
      }
      $remove_chars = strlen($separator);
      $get_string = substr($get_string, 0, -$remove_chars);
    }

    return $get_string;
  }

  function tep_not_null($value) {
    if (is_array($value)) {
      if (sizeof($value) > 0) {
        return true;
      } else {
        return false;
      }
    } else {
      if (($value != '') && (strtolower($value) != 'null') && (strlen(trim($value)) > 0)) {
        return true;
      } else {
        return false;
      }
    }
  }

////
// Output the tax percentage with optional padded decimals
  function tep_display_tax_value($value, $padding = TAX_DECIMAL_PLACES) {
    if (strpos($value, '.')) {
      $loop = true;
      while ($loop) {
        if (substr($value, -1) == '0') {
          $value = substr($value, 0, -1);
        } else {
          $loop = false;
          if (substr($value, -1) == '.') {
            $value = substr($value, 0, -1);
          }
        }
      }
    }

    if ($padding > 0) {
      if ($decimal_pos = strpos($value, '.')) {
        $decimals = strlen(substr($value, ($decimal_pos+1)));
        for ($i=$decimals; $i<$padding; $i++) {
          $value .= '0';
        }
      } else {
        $value .= '.';
        for ($i=0; $i<$padding; $i++) {
          $value .= '0';
        }
      }
    }

    return $value;
  }

////
// Checks to see if the currency code exists as a currency
// TABLES: currencies
  function tep_currency_exists($code) {
    $code = tep_db_prepare_input($code);

    $currency_query = tep_db_query("select code from " . TABLE_CURRENCIES . " where code = '" . tep_db_input($code) . "' limit 1");
    if (tep_db_num_rows($currency_query)) {
      $currency = tep_db_fetch_array($currency_query);
      return $currency['code'];
    } else {
      return false;
    }
  }

  function tep_string_to_int($string) {
    return (int)$string;
  }

////
// Parse and secure the cPath parameter values
  function tep_parse_category_path($cPath) {
// make sure the category IDs are integers
    $cPath_array = array_map('tep_string_to_int', explode('_', $cPath));

// make sure no duplicate category IDs exist which could lock the server in a loop
    $tmp_array = array();
    $n = sizeof($cPath_array);
    for ($i=0; $i<$n; $i++) {
      if (!in_array($cPath_array[$i], $tmp_array)) {
        $tmp_array[] = $cPath_array[$i];
      }
    }

    return $tmp_array;
  }

////
// Return a random value
  function tep_rand($min = null, $max = null) {
    static $seeded;

    if (!isset($seeded)) {
      mt_srand((double)microtime()*1000000);
      $seeded = true;
    }

    if (isset($min) && isset($max)) {
      if ($min >= $max) {
        return $min;
      } else {
        return mt_rand($min, $max);
      }
    } else {
      return mt_rand();
    }
  }

  function tep_setcookie($name, $value = '', $expire = 0, $path = '/', $domain = '', $secure = 0) {
    setcookie($name, $value, $expire, $path, (tep_not_null($domain) ? $domain : ''), $secure);
  }

  function tep_get_ip_address() {
		global $HTTP_SERVER_VARS;
    if (isset($HTTP_SERVER_VARS)) {
      if (isset($HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'])) {
        $ip = $HTTP_SERVER_VARS['HTTP_X_FORWARDED_FOR'];
      } elseif (isset($HTTP_SERVER_VARS['HTTP_CLIENT_IP'])) {
        $ip = $HTTP_SERVER_VARS['HTTP_CLIENT_IP'];
      } else {
        $ip = $HTTP_SERVER_VARS['REMOTE_ADDR'];
      }
    } else {
      if (getenv('HTTP_X_FORWARDED_FOR')) {
        $ip = getenv('HTTP_X_FORWARDED_FOR');
      } elseif (getenv('HTTP_CLIENT_IP')) {
        $ip = getenv('HTTP_CLIENT_IP');
      } else {
        $ip = getenv('REMOTE_ADDR');
      }
    }

    return $ip;
  }

  function tep_count_customer_orders($id = '', $check_session = true) {
    global $customer_id, $languages_id;;

    if (is_numeric($id) == false) {
      if (tep_session_is_registered('customer_id')) {
        $id = $customer_id;
      } else {
        return 0;
      }
    }

    if ($check_session == true) {
      if ( (tep_session_is_registered('customer_id') == false) || ($id != $customer_id) ) {
        return 0;
      }
    }

    $orders_check_query = tep_db_query("select count(*) as total from " . TABLE_ORDERS . " o, " . TABLE_ORDERS_STATUS . " s where o.customers_id = '" . (int)$id . "' and o.orders_status = s.orders_status_id and s.language_id = '" . (int)$languages_id . "' and s.public_flag = '1'");
    $orders_check = tep_db_fetch_array($orders_check_query);

    return $orders_check['total'];
  }

  function tep_count_customer_address_book_entries($id = '', $check_session = true) {
    global $customer_id;

    if (is_numeric($id) == false) {
      if (tep_session_is_registered('customer_id')) {
        $id = $customer_id;
      } else {
        return 0;
      }
    }

    if ($check_session == true) {
      if ( (tep_session_is_registered('customer_id') == false) || ($id != $customer_id) ) {
        return 0;
      }
    }

    $addresses_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$id . "'");
    $addresses = tep_db_fetch_array($addresses_query);

    return $addresses['total'];
  }

// nl2br() prior PHP 4.2.0 did not convert linefeeds on all OSs (it only converted \n)
  function tep_convert_linefeeds($from, $to, $string) {
    if ((PHP_VERSION < "4.0.5") && is_array($from)) {
      return ereg_replace('(' . implode('|', $from) . ')', $to, $string);
    } else {
      return str_replace($from, $to, $string);
    }
  }

  function tep_output_warning($warning) {
    new errorBox(array(array('text' => tep_image(DIR_WS_TEMPLATES . 'images/misc/icons/warning.gif', ICON_WARNING) . ' ' . $warning)));
  }
    function tep_get_products_availability($products_availability_array = '') {
    if (!is_array($products_availability_array)) $products_availability_array = array();

    $products_availability_query = tep_db_query("select products_availability_id, products_availability_name from " . TABLE_PRODUCTS_AVAILABILITY . " order by products_availability_name");
    while ($products_availability = tep_db_fetch_array($products_availability_query)) {
      $products_availability_array[] = array('id' => $products_availability['products_availability_id'], 'text' => $products_availability['products_availability_name']);
    }

    return $products_availability_array;
  }

// EZier New Fields 5.0 decimal replacer (Noel Latsha)
function osc_ez($number) {
$strlen = strlen($number);
if (NEW_FIELDS_DECIMAL == 0) { ($strlen = ($strlen - 3)); } // Set the decimal places
if (NEW_FIELDS_DECIMAL == 1) { ($strlen = ($strlen - 1)); } // We don't need em here
$number = substr($number, 0, $strlen);
return $number;
}

// ################### Products Description Hack begins ##############
//
// grabs a length from a string, but goes back to the last space if it cut into
// the middle of a string.  If the string is longer than that, cut, then add '...'
// to the end of the string, if the $more == 1
	function osc_trunc_string($str="",$len=150,$more=1)
	{
		if ($str=="") return $str;
		if (is_array($str)) return $str;
		$str = trim($str);
		// if it's les than the size given, then return it
		if (strlen($str) <= $len) return $str;
		// else get that size of text
		$str = substr($str,0,$len);
		// backtrack to the end of a word
		if ($str != "") {
			// check to see if there are any spaces left
			if (!substr_count($str," ")) {
				if ($more) $str .= " ...";
				return $str;
			}
			// backtrack
			while(strlen($str) && ($str[strlen($str)-1] != " ")) {
				$str = substr($str,0,-1);
			}
			$str = substr($str,0,-1);
			if ($more) $str .= " ...";
		}
		return $str;
	}
// ########### Products Description Hack ends #############

// ########### Sprawdzanie NIP Start ######################
function nip($nip) {
  $nip=preg_replace("/[^0-9]/","",$nip);
  if (strlen($nip)<>10) return 0;
  $wagi = array(6,5,7,2,3,4,5,6,7);
  for ($i=0; $i<9;$i++) $suma += $nip[$i]*$wagi[$i];
  if (($suma%11)==$nip[9]) return 1;
  return 0;
}
// ########### Sprawdzanie NIP Koniec #####################

  //TotalB2B start
  function tep_get_customers_groups_id() {
    global $customer_id,$id_klienta_grupa;
    //$customers_groups_query = tep_db_query("select customers_groups_id from " . TABLE_CUSTOMERS . " where customers_id =  '" . $customer_id . "'");
    //$customers_groups_id = tep_db_fetch_array($customers_groups_query);
    //return $customers_groups_id['customers_groups_id'];
    return $id_klienta_grupa;
  }

////
// Return a product's special price (returns nothing if there is no offer)
// TABLES: products
//  function tep_get_products_special_price($product_id) {
//    $product_query = tep_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "' and status");
//    $product = tep_db_fetch_array($product_query);

//    return $product['specials_new_products_price'];
//  }

  function tep_get_products_special_price($product_id) {
	global $customer_id,$czy_sa_promocje;
    if ($czy_sa_promocje == true) {
        $product_query = tep_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "' and status = '1' and customers_id = '" . $customer_id . "' and customers_groups_id = '0'");
        if (!tep_db_num_rows($product_query)) {
          $customer_groups_id = tep_get_customers_groups_id();
          $product_query = tep_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "' and status = '1' and customers_groups_id = '" . $customer_groups_id . "' and customers_id = '0'");
          if (!tep_db_num_rows($product_query)) {
            $product_query = tep_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "' and status = '1' and customers_groups_id = '0' and customers_id = '0'");
          }
        }
       } else {
         $product_query = tep_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . (int)$product_id . "' and status = '1' and customers_groups_id = '0' and customers_id = '0'");
    }
    $product = tep_db_fetch_array($product_query);
    return $product['specials_new_products_price'];
  }

  //TotalB2B end

    //TotalB2B start
  function tep_xppp_getmaxprices() {
    //max prices per product
	return 10;
  }

  function tep_xppp_getpricesnum() {
    $prices = XPRICES_NUM;
	return $prices;
  }

  function tep_xppp_getpricelist($ts) {
    $price_list = '';
    $prices_num = tep_xppp_getpricesnum();
    for ($i=2; $i<=$prices_num; $i++) {
      if ($ts != NULL) $price_list .= $ts . ".products_price_" . $i . ",";
      else $price_list .= "products_price_" . $i . ",";
    }
    if ($ts != NULL) $price_list .= $ts . ".products_price";
    else $price_list .= "products_price";
    return $price_list;
  }

  function tep_xppp_getproductprice($products_id) {
    global $customer_id;
    if (tep_not_null($customer_id) && $customer_id != 0 && !tep_session_is_registered('customer_is_guest')) {
        $customer_query = tep_db_query("select g.customers_groups_price from " . TABLE_CUSTOMERS_GROUPS . " g inner join  " . TABLE_CUSTOMERS  . " c on g.customers_groups_id = c.customers_groups_id and c.customers_id = '" . $customer_id . "'");
        $customer_query_result = tep_db_fetch_array($customer_query);
        $customer_price = $customer_query_result['customers_groups_price'];
       } else {
        $customer_price = '99';
    }
	$products_price_list = tep_xppp_getpricelist("");
    $product_info_query = tep_db_query("select products_id, " . $products_price_list . "  from " . TABLE_PRODUCTS . " where products_id = '" . $products_id . "'");
    $product_info = tep_db_fetch_array($product_info_query);
    if ( isset($product_info['products_price_' . $customer_price]) ) {
      if ($product_info['products_price_' . $customer_price] == NULL) {
          $product_info['products_price_' . $customer_price] = $product_info['products_price'];
      }
    }
    if ( isset($product_info['products_price_' . $customer_price]) ) {
      if ((int)$customer_price != 1) {
         $product_info['products_price'] = $product_info['products_price_' . $customer_price];
      }
    }
  return $product_info['products_price'];
  }
  //TotalB2B end


  function tep_array_values_to_string($array,$separator=',') {
	$get_string = '';
	if (sizeof($array) > 0) {
     while (list($key, $value) = each($array)) {
	  $get_string .= $value . $separator;
	 }
	 $remove_chars = strlen($separator);
	 $get_string = substr($get_string, 0, -$remove_chars);
	}
    return $get_string;
  }

/* BOF: Attributes Sorter/Copier */
////
// Return a product's catagory
// TABLES: products_to_catagories
  function tep_get_products_catagory_id($products_id) {
    global $languages_id;

    $the_products_catagory_query = tep_db_query("select products_id, categories_id from " . TABLE_PRODUCTS_TO_CATEGORIES . " where products_id = '" . $products_id . "'" . " order by products_id,categories_id");
    $the_products_catagory = tep_db_fetch_array($the_products_catagory_query);

    return $the_products_catagory['categories_id'];
  }

////
// WebMakers.com Added: Find a Categories Name
// TABLES: categories_description
  function tep_get_categories_name($who_am_i) {
    global $languages_id;
    $the_categories_name_query= tep_db_query("select categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " where categories_id= '" . $who_am_i . "' and language_id= '" . $languages_id . "'");

    $the_categories_name = tep_db_fetch_array($the_categories_name_query);
    return $the_categories_name['categories_name'];
  }

////
// WebMakers.com Added: Find a Categories image
// TABLES: categories_image
  function tep_get_categories_image($what_am_i) {
    $the_categories_image_query= tep_db_query("select categories_image from " . TABLE_CATEGORIES . " where categories_id= '" . $what_am_i . "'");

    $the_categories_image = tep_db_fetch_array($the_categories_image_query);
    return $the_categories_image['categories_image'];
  }
/* EOF: Attributes Sorter/copier */

// >>> BEGIN REGISTER_GLOBALS
  // Work-around functions to allow disabling of register_globals in php.ini
  // These functions perform a similar operation as the 'link_session_variable'
  // function added to .../functions/sessions.php but for the GET, POST, etc
  // variables
  //
  // Parameters:
  // var_name - Name of session variable
  //
  // Returns:
  // None
  function link_get_variable($var_name)
  {
    // Map global to GET variable
    if (isset($_GET[$var_name]))
    {
      $GLOBALS[$var_name] =& $_GET[$var_name];
    }
  }

  function link_post_variable($var_name)
  {
    // Map global to POST variable
    if (isset($_POST[$var_name]))
    {
      $GLOBALS[$var_name] =& $_POST[$var_name];
    }
  }
// <<< END REGISTER_GLOBALS

function MakeUTF($string){
   $string = preg_replace('/([^a-z ])/ie','sprintf("=%02x",ord(StripSlashes("\\1")))', $string);
   $string = str_replace(' ', '_', $string);
   return "=?utf-8?Q?$string?=";
}

//Wyswietlanie informacji testowych w stopce
function print_array ($array, $exit = false) {
    		print "<pre>";
    		print_r ($array);
		print "</pre>";
	  	if ($exit) exit();
}

################################################
// fwrmedia.co.uk mod to check SEO link validity
function tep_validate_seo_urls() {
global $HTTP_GET_VARS, $request_type;
( $request_type == 'NONSSL' ? $fwr_server_port = HTTP_SERVER : $fwr_server_port = HTTPS_SERVER );
$querystring = str_replace('?', '&', $_SERVER['REQUEST_URI']);
if (isset($HTTP_GET_VARS['products_id']))
$get_id_vars = str_replace(strstr($HTTP_GET_VARS['products_id'], '{'), '', $HTTP_GET_VARS['products_id']); // Remove attributes
$qs_parts = explode('&', $querystring); // explode the querystring into an array
$count = count($qs_parts);
$added_uri = array();
$remove_nasties = array('%3C', '%3E', '<', '>', ':/', 'http', 'HTTP'); // We do tep_sanitize_string() later anyway
for ( $i=0; $i<$count; $i++ ) { // We don't want to introduce vulnerability do we :)
switch($qs_parts[$i]) {
case(false !== strpos($qs_parts[$i], '.html')):
$core = urldecode($qs_parts[$i]); // Found the path
( (strstr($core, '{') !== false) ? ($core = str_replace(strstr($core, '{'), '', $core) . '.html') : NULL ); // Remove attributes
break;
case(false !== strpos($qs_parts[$i], 'osCsid')):
$seo_sid = $qs_parts[$i]; // Found the osCsid
break;
default:
$added_uri[] = ( urldecode(str_replace($remove_nasties, '', $qs_parts[$i])) ); // Found the additional querystring (e.g. &page=3&sort=2a from split_page_results)
}
}
$do_validation = true; // Set to false later if it is not an seo url so that other .html files pass through unhindered
// If -x- is in the querystring create var $querytype which is a string which explodes into an array on -
( strpos($_SERVER['REQUEST_URI'], '-p-') ? ($querytype = 'filename_product_info-products_id=' . $get_id_vars) :
( strpos($_SERVER['REQUEST_URI'], '-c-') ? ($querytype = 'filename_default-cPath=' . $HTTP_GET_VARS['cPath']) :
( strpos($_SERVER['REQUEST_URI'], '-m-') ? ($querytype = 'filename_default-manufacturers_id=' . $HTTP_GET_VARS['manufacturers_id']) :
( strpos($_SERVER['REQUEST_URI'], '-pi-') ? ($querytype = 'filename_popup_image-pID=' . $HTTP_GET_VARS['pID']) :
( strpos($_SERVER['REQUEST_URI'], '-t-') ? ($querytype = 'filename_articles-tPath=' . $HTTP_GET_VARS['tPath']) :
( strpos($_SERVER['REQUEST_URI'], '-a-') ? ($querytype = 'filename_article_info-articles_id=' . $HTTP_GET_VARS['articles_id']) :
( strpos($_SERVER['REQUEST_URI'], '-pr-') ? ($querytype = 'filename_product_reviews-products_id=' . $get_id_vars) :
( strpos($_SERVER['REQUEST_URI'], '-pri-') ? ($querytype = 'filename_product_reviews_info-products_id=' . $get_id_vars) :
( strpos($_SERVER['REQUEST_URI'], '-prw-') ? ($querytype = 'filename_product_reviews_write-products_id=' . $get_id_vars) :
( strpos($_SERVER['REQUEST_URI'], '-i-') ? ($querytype = 'filename_information-info_id=' . $HTTP_GET_VARS['info_id']) :
( strpos($_SERVER['REQUEST_URI'], '-links-') ? ($querytype = 'filename_links-lPath=' . $HTTP_GET_VARS['lPath']) :
( strpos($_SERVER['REQUEST_URI'], '-pm-') ? ($querytype = 'filename_pages-pages_id=' . $HTTP_GET_VARS['pages_id']) :
$do_validation = false ))))))))))) );

if ( true === $do_validation ) { // It's an SEO URL so we will validate it
$validate_array = explode('-', $querytype); // Gives e.g. $validate_array[0] = filename_default, $validate_array[1] = products_id=xx
$linkreturned = tep_href_link(constant(strtoupper($validate_array[0])), $validate_array[1]); // Get a propper new SEO link
// Rebuild the extra querystring
( (strpos($linkreturned, '?') !== false) ? ($seperator = '&') : ($seperator = '?') ); // Is there an osCsid on $linkreturned?
$count = count($added_uri); // Count the extra querystring items
for ($i=0; $i<$count; $i++)
if ($i == 0) $linkreturned = $linkreturned . $seperator . tep_sanitize_string($added_uri[$i]); //add the first using seperator ? or &
else $linkreturned = $linkreturned . '&' . tep_sanitize_string($added_uri[$i]); // Just add "&" this time
$linkreturnedstripped = str_replace( strstr($linkreturned, '?'), '', $linkreturned); // Strip osCsid to allow a match with $core
$linktest = str_replace($fwr_server_port . DIR_WS_HTTP_CATALOG, '', $linkreturned); // Pair the url down to the querystring
if (strpos($linktest, '-') === 0) { // If the link returned by seo.class.php has no text mysite.com/-c-xxx.html
four_o_four_die(); // Product/category does not exist so die here with a 404
exit;
} else if ( $fwr_server_port . $core != $linkreturnedstripped ) { // Link looks bad so 301
$linkreturned = str_replace('&amp;', '&', $linkreturned); // Just in case those sneaky W3C urls tried to throw in an &amp;
header("HTTP/1.0 301 Moved Permanently"); // redirect to the good version
header("Location: $linkreturned"); // 301 redirect
exit;
}
} // We're not doing validation as the -p-, -c- etc was not found
}
function four_o_four_die() { // 404 then redirect doesn't work as Google records a 302 so we need to die here with a 404
echo
header("HTTP/1.0 404 Not Found") .
'<p align="left" style="font-size: large;">&nbsp;&nbsp;404 Page not found!</p>
<div align="center" style="width: 100%; margin-top: 70px;">
<div align="center" style="font-family: verdana; font-size: 0.8em; color: #818181; padding: 90px 10px 90px 10px; width: 60%; border: 1px solid #818181;">
This product/category does not exist it may have been deleted.<p />
To return to ' . STORE_NAME .
'. Please click here <a href="' . tep_href_link(FILENAME_DEFAULT) . '" title="' . STORE_NAME . '">back to ' . STORE_NAME . '</a>
</div></div>';
}
################################################
// END fwrmedia.co.uk mod to check SEO link validity


////
// Return a manufaturer's name
  function tep_get_manufacturers_name($manufacturers_id, $language = '') {
    global $languages_id;

    $manufacturer_query = tep_db_query("select manufacturers_name from " . TABLE_MANUFACTURERS . " where manufacturers_id = '" . (int)$manufacturers_id . "'");
    $manufacturer = tep_db_fetch_array($manufacturer_query);

    return $manufacturer['manufacturers_name'];
  }

// dodatkowe funkcji do przewijanych promocji
function format_specials($tekst) { $tekst = osc_trunc_string($tekst, 50, 1); $tekst = str_replace('"','`',$tekst); $tekst = str_replace("'","`",$tekst); return $tekst; }
function clear_specials($tekst) {
    $tekst = mysql_real_escape_string($tekst);
    $tekst = str_replace('\n','',$tekst);
    $tekst = str_replace('\r','',$tekst);
    $tekst = str_replace('\"','"',$tekst);
    $tekst = str_replace('</a>','<%2Fa>',$tekst);
    $tekst = str_replace('</div>','<%2Fdiv>',$tekst);
    $tekst = str_replace('</td>','<%2Ftd>',$tekst);
    $tekst = str_replace('</tr>','<%2Ftr>',$tekst);
    $tekst = str_replace('</table>','<%2Ftable>',$tekst);
    $tekst = str_replace('</span>','<%2Fspan>',$tekst);
    return $tekst;
}

// START DELETE TEMP PAYPAL IPN ORDER
// This is used in shopping_cart.php when a temporary order needs to be deleted
// after it was cancelled by customer on paypal site.
  function tep_remove_order($order_id, $restock = false) {
    if ($restock == 'on') {
      $order_query = tep_db_query("select products_id, products_quantity from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
      while ($order = tep_db_fetch_array($order_query)) {
        tep_db_query("update " . TABLE_PRODUCTS . " set products_quantity = products_quantity + " . $order['products_quantity'] . ", products_ordered = products_ordered - " . $order['products_quantity'] . " where products_id = '" . (int)$order['products_id'] . "'");
      }
    }

    tep_db_query("delete from " . TABLE_ORDERS . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '" . (int)$order_id . "'");
    tep_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . (int)$order_id . "'");
  }
// END DELETE TEMP PAYPAL IPN ORDER

//Pobranie nazwy jednostki miary
function tep_get_products_jm_name($products_jm_id, $language_id) {
  global $languages_id;
  if (empty($language)) $language = $languages_id;
    $products_jm_query = tep_db_query("select products_jm_name from " . TABLE_PRODUCTS_JM . " where products_jm_id = '" . (int)$products_jm_id . "' and language_id = '" . (int)$language_id . "'");
    $products_jm = tep_db_fetch_array($products_jm_query);

    return $products_jm['products_jm_name'];
}


// DODATKOWE FUNKCJI DO OBSLUGI PROGRAMU LOJALNOSCIOWEGO
function sformatuj_date($cutoff_date, $raw_date) {
	if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;
	$year = (int)substr($raw_date, 0, 4); $month = (int)substr($raw_date, 5, 2);
	$day = (int)substr($raw_date, 8, 2); $hour = (int)substr($raw_date, 11, 2);
	$minute = (int)substr($raw_date, 14, 2); $second = (int)substr($raw_date, 17, 2);
	$order_date_purchased = mktime($hour,$minute,$second,$month,$day,$year);
	if ($order_date_purchased >= $cutoff_date) {return true;}
	else {return false;}
}

function suma_zamowien() {
  global $order, $customer_id;
  // ustalania data
  $rightnow = time();
  $cutoff_date = $rightnow - (60*60*24*(int)MODULE_KLUB_CUMORDER_PERIOD);
  //
  $history_query_raw = "select o.date_purchased, ot.value as order_total from " . TABLE_ORDERS . " o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id) where o.customers_id != '0' and o.customers_id = '" . $customer_id . "' and ot.class = 'ot_total' and o.orders_status >= '".MODULE_KLUB_ORDER_STATUS."' order by date_purchased DESC";
  $history_query = tep_db_query($history_query_raw);
  if (tep_db_num_rows($history_query)) {
	  $cum_order_total = 0;
	  while ($history = tep_db_fetch_array($history_query)) {
		if (sformatuj_date($cutoff_date, $history['date_purchased']) == true){
		$cum_order_total = $cum_order_total + $history['order_total'];
		}
	  }
	  return $cum_order_total;
  }
  else {
	  $cum_order_total = 0;
	  return $cum_order_total;
  }
}

// DODATKOWE FUNKCJE DO FAKTURY PDF
function invoiceNumberFormat($amount, $dig = 2, $dec = ',', $sep = ' ') {
	$value = number_format($amount, $dig, $dec, $sep);
	if ($value == '0,00') {
		return '';
	} else {
		return $value;
	}
}

function slownie ($kw) {
$t_a = array('','sto','dwieście','trzysta','czterysta','pięćset','sześćset','siedemset','osiemset','dziewięćset');
$t_b = array('','dziesięć','dwadzieścia','trzydzieści','czterdzieści','pięćdziesiąt','sześćdziesiąt','siedemdziesiąt','osiemdziesiąt','dziewięćdziesiąt');
$t_c = array('','jeden','dwa','trzy','cztery','pięć','sześć','siedem','osiem','dziewięć');
$t_d = array('dziesięć','jedenaście','dwanaście','trzynaście','czternaście','piętnaście','szesnaście','siednaście','osiemnaście','dziewiętnaście');

$t_kw_15 = array('septyliard','septyliardów','septyliardy');
$t_kw_14 = array('septylion','septylionów','septyliony');
$t_kw_13 = array('sekstyliard','sekstyliardów','sekstyliardy');
$t_kw_12 = array('sekstylion','sekstylionów','sepstyliony');
$t_kw_11 = array('kwintyliard','kwintyliardów','kwintyliardy');
$t_kw_10 = array('kwintylion','kwintylionów','kwintyliony');
$t_kw_9 = array('kwadryliard','kwadryliardów','kwaryliardy');
$t_kw_8 = array('kwadrylion','kwadrylionów','kwadryliony');
$t_kw_7 = array('tryliard','tryliardów','tryliardy');
$t_kw_6 = array('trylion','trylionów','tryliony');
$t_kw_5 = array('biliard','biliardów','biliardy');
$t_kw_4 = array('bilion','bilionów','bilony');
$t_kw_3 = array('miliard','miliardów','miliardy');
$t_kw_2 = array('milion','milionów','miliony');
$t_kw_1 = array('tysiąc','tysięcy','tysiące');
$t_kw_0 = array('złoty','złotych','złote');

if ($kw!='') {
	$kw=(substr_count($kw,',')==0) ? $kw.',00':$kw;
	$tmp=explode(",",$kw);
	$ln=strlen($tmp[0]);
	$tmp_a=($ln%3==0) ? (floor($ln/3)*3):((floor($ln/3)+1)*3);
	for($i = $ln; $i < $tmp_a; $i++) {
	  $l_pad .= '0';
	  $kw_w = $l_pad . $tmp[0];
	}
	$kw_w=($kw_w=='') ? $tmp[0]:$kw_w;
	$paczki=(strlen($kw_w)/3)-1;
	$p_tmp=$paczki;
	for($i=0;$i<=$paczki;$i++) {
	  $t_tmp='t_kw_'.$p_tmp;
	  $p_tmp--;
	  $p_kw=substr($kw_w,($i*3),3);
	  $kw_w_s=($p_kw{1}!=1) ? $t_a[$p_kw{0}].' '.$t_b[$p_kw{1}].' '.$t_c[$p_kw{2}]:$t_a[$p_kw{0}].' '.$t_d[$p_kw{2}];
	  if(($p_kw{0}==0)&&($p_kw{2}==1)&&($p_kw{1}<1)) $ka=${$t_tmp}[0]; //możliwe że $p_kw{1}!=1
	  else if (($p_kw{2}>1 && $p_kw{2}<5)&&$p_kw{1}!=1) $ka=${$t_tmp}[2];
	  else $ka=${$t_tmp}[1];
	  $kw_slow.=$kw_w_s.' '.$ka.' ';
	}
  }
  $text = $kw_slow.' '.$tmp[1].'/100 gr.';
  return $text;
}

function sprawdz_haslo($txt) {
  $licznik = 0;
  for($i=0;$i<strlen($txt);$i++) {
    if (preg_match("/[0-9]/",$txt{$i})) {
		$licznik++;
	}
    if (preg_match("/[a-zA-Z]/",$txt{$i})) {
		$licznik++;
	}
  }
  if ($licznik == strlen($txt)) {
	  return true;
  }
  return false;
}

function optimize_html($ciag) {
$ciag = preg_replace("/\r\n|\n\r|\r|\n/","",$ciag);
$ciag = str_replace("   ","",$ciag);
return $ciag;
}

function zaokr($liczba) {
 $liczba = (int)$liczba;
 if (strlen($liczba) == 1) { $wynik = $liczba; }
 if (strlen($liczba) == 2) { $wynik = $liczba+=(10-($liczba%10)); }
 if (strlen($liczba) == 3) { $wynik = $liczba+=(100-($liczba%100)); }
 if (strlen($liczba) == 4) { $wynik = $liczba+=(1000-($liczba%1000)); }
 if (strlen($liczba) == 5) { $wynik = $liczba+=(10000-($liczba%10000)); }
 return $wynik;
}

// BOF Customers extra fields
function tep_get_extra_fields($customer_id,$languages_id){
  $extra_fields_query = tep_db_query("select ce.fields_id, ce.fields_input_type, ce.fields_input_value, ce.fields_required_status, cei.fields_name, ce.fields_status, ce.fields_input_type from " . TABLE_EXTRA_FIELDS . " ce, " . TABLE_EXTRA_FIELDS_INFO . " cei where ce.fields_status=1 and cei.fields_id=ce.fields_id and cei.languages_id =" . $languages_id);
  $extra_fields_string ='';
  if(tep_db_num_rows($extra_fields_query)>0){
    $extra_fields_string .= '<tr><td><fieldset><legend>' . CATEGORY_EXTRA_FIELDS .'</legend><table border="0" cellspacing="5" cellpadding="0" width="100%">';
    while($extra_fields = tep_db_fetch_array($extra_fields_query)){
      $value='';
      if(isset($customer_id)) {
        $value_query = tep_db_query("select value from " . TABLE_CUSTOMERS_TO_EXTRA_FIELDS . " where customers_id=" . $customer_id . " and fields_id=" . $extra_fields['fields_id']);
        $value_info = tep_db_fetch_array($value_query);
        $value_list = explode("\n", $value_info['value']);
        for ($i = 0, $n = sizeof($value_list); $i < $n; $i++) {
          $value_list[$i] = trim($value_list[$i]);
        }
        $value = $value_list[0];
      }
      $extra_fields_string .='<tr><td width="35%" class="main">' . $extra_fields['fields_name'] . ': </td>
                                  <td width="65%" class="main">';

      $select_values_list = explode("\n", $extra_fields['fields_input_value']);
      $select_values = array();
      foreach($select_values_list as $item) {
        $item = trim($item);
        $select_values[] = array('id' => $item, 'text' => $item);
      }

      switch($extra_fields['fields_input_type']) {
        case  0:
          $extra_fields_string .= tep_draw_input_field('fields_' . $extra_fields['fields_id'],$value, 'size="50"'). (($extra_fields['fields_required_status']==1) ? ' <span class="inputRequirement">*</span>': '');
          break;
          case  1:
            $extra_fields_string .= tep_draw_textarea_field('fields_' . $extra_fields['fields_id'], 'soft', 40, 6,$value,'style="width:320px;"'). (($extra_fields['fields_required_status']==1) ? ' <span class="inputRequirement">*</span>': '');
            break;
          case  2:
            foreach($select_values_list as $item) {
              $item = trim($item);
              $extra_fields_string .= tep_draw_selection_field('fields_' . $extra_fields['fields_id'], 'radio', $item, (($value == $item)?(true):(false))).$item. (($extra_fields['fields_required_status']==1) ? ' <span class="inputRequirement">*</span>': '').'';
              $extra_fields['fields_required_status']  = 0;
            }
            break;
          case  3:
            $cnt = 1;
            foreach($select_values_list as $item) {
              $item = trim($item);
              $extra_fields_string .= tep_draw_selection_field('fields_' . $extra_fields['fields_id'] . '_' . ($cnt++), 'checkbox', $item, ((@in_array($item, $value_list))?(true):(false))).$item. (($extra_fields['fields_required_status']==1) ? ' <span class="inputRequirement">*</span>': '');
              $extra_fields['fields_required_status']  = 0;
            }
            $extra_fields_string .= tep_draw_hidden_field('fields_' . $extra_fields['fields_id'] . '_total' , $cnt);
            break;
          case  4:
            $extra_fields_string .= tep_draw_pull_down_menu('fields_' . $extra_fields['fields_id'], $select_values, $value).(($extra_fields['fields_required_status']==1) ? ' <span class="inputRequirement">*</span>': '');
            break;
          default:
            $extra_fields_string .= tep_draw_input_field('fields_' . $extra_fields['fields_id'],$value). (($extra_fields['fields_required_status']==1) ? ' <span class="inputRequirement">*</span>': '');
            break;
      }

      $extra_fields_string .= '</td></tr>';

    }
    $extra_fields_string .= '</table></fieldset></td></tr>';
  }
  return $extra_fields_string;
}
// EOF Customers extra fields

?>