<?php
/*
  www.oscGold.com (C) Kamelia-Net Jacek Krysiak
  modul oscGold wer 4.0
*/

class wishlist {
  var $wishID;

  function wishlist() {
    $this->reset();
  }

  function restore_wishlist() {
    global $customer_id;

    if (!tep_session_is_registered('customer_id')) return false;

    // merge current wishlist items in database
    if (is_array($this->wishID)) {
      reset($this->wishID);

      while (list($wishlist_id, ) = each($this->wishID)) {
        $wishlist_query = tep_db_query("select products_id from " . TABLE_WISHLIST . " where customers_id = '" . $customer_id . "' and products_id = '" . $wishlist_id . "'");
        if (!tep_db_num_rows($wishlist_query)) {
          tep_db_query("insert into " . TABLE_WISHLIST . " (customers_id, products_id) values ('" . $customer_id . "', '" . $wishlist_id . "')");
          if (isset($this->wishID[$wishlist_id]['attributes'])) {
            reset($this->wishID[$wishlist_id]['attributes']);
            while (list($option, $value) = each($this->wishID[$wishlist_id]['attributes'])) {
              tep_db_query("insert into " . TABLE_WISHLIST_ATTRIBUTES . " (customers_id, products_id, products_options_id , products_options_value_id) values ('" . $customer_id . "', '" . $wishlist_id . "', '" . $option . "', '" . $value . "' )");
            }
          }
        }
      }
    }

    // reset session contents
    unset($this->wishID);

    $wishlist_session = tep_db_query("select products_id from " . TABLE_WISHLIST . " where customers_id = '" . $customer_id . "'");
    while($wishlist = tep_db_fetch_array($wishlist_session)) {
      $this->wishID[$wishlist['products_id']] = array($wishlist['products_id']);
      // attributes
      $attributes_query = tep_db_query("select products_options_id, products_options_value_id from " . TABLE_WISHLIST_ATTRIBUTES . " where customers_id = '" . $customer_id . "' and products_id = '" . $wishlist['products_id'] . "'");
      while ($attributes = tep_db_fetch_array($attributes_query)) {
        $this->wishID[$wishlist['products_id']]['attributes'][$attributes['products_options_id']] = $attributes['products_options_value_id'];
      }
    }
  }

  function add_wishlist($wishlist_id, $attributes_id) {
    global $customer_id;

    if(!$this->in_wishlist($wishlist_id)) {
      $wishlist_id = tep_get_uprid($wishlist_id, $attributes_id);
      // Insert into session
      $this->wishID[$wishlist_id] = array($wishlist_id);

      if (tep_session_is_registered('customer_id')) {
        // Insert into database
        tep_db_query("insert into " . TABLE_WISHLIST . " (customers_id, products_id) values ('" . $customer_id . "', '" . $wishlist_id . "')");
      }

      // Read array of options and values for attributes in id[]
      if (is_array($attributes_id)) {
        reset($attributes_id);
        while (list($option, $value) = each($attributes_id)) {
          $this->wishID[$wishlist_id]['attributes'][$option] = $value;
          // Add to customers_wishlist_attributes table
          if (tep_session_is_registered('customer_id')) {
            tep_db_query("insert into " . TABLE_WISHLIST_ATTRIBUTES . " (customers_id, products_id, products_options_id , products_options_value_id) values ('" . $customer_id . "', '" . $wishlist_id . "', '" . $option . "', '" . $value . "' )");
          }
        }
        tep_session_unregister('attributes_id');
      }
    }
  }

  function remove($wishlist_id) {
    global $customer_id;

    // Remove from session
    unset($this->wishID[$wishlist_id]);

    //remove from database
    if (tep_session_is_registered('customer_id')) {
      tep_db_query("delete from " . TABLE_WISHLIST . " where products_id = '" . $wishlist_id . "' and customers_id = '" . $customer_id . "'");
      tep_db_query("delete from " . TABLE_WISHLIST_ATTRIBUTES . " where products_id = '" . $wishlist_id . "' and customers_id = '" . $customer_id . "'");
    }
  }

  function clear() {
    global $customer_id;

    // Remove all from database
    if (tep_session_is_registered('customer_id')) {
      $wishlist_products_query = tep_db_query("select products_id from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . $customer_id . "'");
      while($wishlist_products = tep_db_fetch_array($wishlist_products_query)) {
        tep_db_query("delete from " . TABLE_WISHLIST . " where products_id = '" . $wishlist_products[products_id] . "' and customers_id = '" . $customer_id . "'");
        tep_db_query("delete from " . TABLE_WISHLIST_ATTRIBUTES . " where products_id = '" . $wishlist_products[products_id] . "' and customers_id = '" . $customer_id . "'");
      }
    }
  }

  function reset($reset_database = false) {
    global $customer_id;

    // Remove all from database
    if (tep_session_is_registered('customer_id') && ($reset_database == true)) {
      tep_db_query("delete from " . TABLE_WISHLIST . " where customers_id = '" . $customer_id . "'");
      tep_db_query("delete from " . TABLE_WISHLIST_ATTRIBUTES . " where customers_id = '" . $customer_id . "'");
    }

    // reset session contents
    unset($this->wishID);
  }

  function in_wishlist($wishlist_id) {
    global $customer_id;

    if (isset($this->wishID[$wishlist_id])) {
      return true;
    } else {
      return false;
    }
  }

  function get_att($wishlist_id) {
    $pieces = explode('{', $wishlist_id);
    return $pieces[0];
  }

  function count_wishlist() {  // get total number of items in wishlist
    $total_items = 0;
    if ( isset($this->wishID) && is_array($this->wishID)) {
      reset($this->wishID);
      while (list($wishlist_id, ) = each($this->wishID)) {
        $total_items++;
      }
    }
    return $total_items;
  }

  function wishlist_attributes_price($wishlist_id, $attributes_price) {

    $prid = $wishlist_id;
    global $customer_id;
    $query_price_to_guest_result = ALLOW_GUEST_TO_SEE_PRICES;
    if (($query_price_to_guest_result=='true') && !(tep_session_is_registered('customer_id'))) {
      $query_guest_discount_result = GUEST_DISCOUNT;
      $customer_discount = $query_guest_discount_result;
    } elseif (tep_session_is_registered('customer_id')) {
      $query_A = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
      $query_B = tep_db_query("select m.manudiscount_discount from " . TABLE_CUSTOMERS  . " c, " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = c.customers_groups_id  and m.manudiscount_customers_id = 0 and c.customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
      $query_C = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = 0 and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
      if ($query_result = tep_db_fetch_array($query_A)) {
        $customer_discount = $query_result['manudiscount_discount'];
      } else if ($query_result = tep_db_fetch_array($query_B)) {
        $customer_discount = $query_result['manudiscount_discount'];
      } else if ($query_result = tep_db_fetch_array($query_C)) {
        $customer_discount = $query_result['manudiscount_discount'];
      } else {
        $query = tep_db_query("select g.customers_groups_discount from " . TABLE_CUSTOMERS_GROUPS . " g inner join  " . TABLE_CUSTOMERS  . " c on g.customers_groups_id = c.customers_groups_id and c.customers_id = '" . $customer_id . "'");
        $query_result = tep_db_fetch_array($query);
        $customers_groups_discount = $query_result['customers_groups_discount'];
        $query = tep_db_query("select customers_discount from " . TABLE_CUSTOMERS . " where customers_id =  '" . $customer_id . "'");
        $query_result = tep_db_fetch_array($query);
        $customer_discount = $query_result['customers_discount'];
        $customer_discount = $customer_discount + $customers_groups_discount;
      }
    }
    if ($customer_discount >= 0) {
      $attribute_price = $attribute_price + $attribute_price * abs($customer_discount) / 100;
    } else {
      $attribute_price = $attribute_price - $attribute_price * abs($customer_discount) / 100;
    }
    return $attributes_price;
  }

    function wishlist_calculate() {
	  global $currencies;

      $this->total = 0;
      $this->total_netto = 0;
      if (is_array($this->wishID)) {
        reset($this->wishID);
        while (list($wishlist_id, ) = each($this->wishID)) {
          $qty = 1;
          $product_id = tep_get_prid($wishlist_id);
          // products price
          $product_query = tep_db_query("select products_id, products_price, products_tax_class_id, products_weight from " . TABLE_PRODUCTS . " where products_id = '" . (int)$wishlist_id . "'");
          if ($product = tep_db_fetch_array($product_query)) {
            $prid = $product['products_id'];
            $products_tax = tep_get_tax_rate($product['products_tax_class_id']);

            //TotalB2B start
            $products_price = tep_xppp_getproductprice($product['products_id']);
            if ($special_price = tep_get_products_special_price($prid)) $products_price = $special_price;
            //TotalB2B end

            //TotalB2B start
            global $customer_id;
            $query_price_to_guest_result = ALLOW_GUEST_TO_SEE_PRICES;
            if (($query_price_to_guest_result=='true') && !(tep_session_is_registered('customer_id'))) {
              $query_guest_discount_result = GUEST_DISCOUNT;
              $customer_discount = $query_guest_discount_result;
            } elseif (tep_session_is_registered('customer_id')) {
              $query_A = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
              $query_B = tep_db_query("select m.manudiscount_discount from " . TABLE_CUSTOMERS  . " c, " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = c.customers_groups_id  and m.manudiscount_customers_id = 0 and c.customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
              $query_C = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = 0 and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
              if ($query_result = tep_db_fetch_array($query_A)) {
                $customer_discount = $query_result['manudiscount_discount'];
              } else if ($query_result = tep_db_fetch_array($query_B)) {
                $customer_discount = $query_result['manudiscount_discount'];
              } else if ($query_result = tep_db_fetch_array($query_C)) {
                  $customer_discount = $query_result['manudiscount_discount'];
              } else {
                $query = tep_db_query("select g.customers_groups_discount from " . TABLE_CUSTOMERS_GROUPS . " g inner join  " . TABLE_CUSTOMERS  . " c on g.customers_groups_id = c.customers_groups_id and c.customers_id = '" . $customer_id . "'");
                $query_result = tep_db_fetch_array($query);
                $customers_groups_discount = $query_result['customers_groups_discount'];
                $query = tep_db_query("select customers_discount from " . TABLE_CUSTOMERS . " where customers_id =  '" . $customer_id . "'");
                $query_result = tep_db_fetch_array($query);
                $customer_discount = $query_result['customers_discount'];
                $customer_discount = $customer_discount + $customers_groups_discount;
              }
            }
            if ($customer_discount >= 0) {
              $products_price = $products_price + $products_price * abs($customer_discount) / 100;
            } else {
              $products_price = $products_price - $products_price * abs($customer_discount) / 100;
            }
            //TotalB2B end

            $this->total += $currencies->calculate_price($products_price, $products_tax, $qty);
            $this->total_netto += $currencies->calculate_price($products_price, 0, $qty);
          }
          // attributes price
          if (isset($this->wishID[$wishlist_id]['attributes'])) {
            reset($this->wishID[$wishlist_id]['attributes']);
            while (list($option, $value) = each($this->wishID[$wishlist_id]['attributes'])) {
              $attribute_price_query = tep_db_query("select options_values_price, price_prefix from " . TABLE_PRODUCTS_ATTRIBUTES . " where products_id = '" . (int)$wishlist_id . "' and options_id = '" . (int)$option . "' and options_values_id = '" . (int)$value . "'");
              $attribute_price = tep_db_fetch_array($attribute_price_query);

              //TotalB2B start
              $prid = $product['products_id'];
              global $customer_id;
              $query_price_to_guest_result = ALLOW_GUEST_TO_SEE_PRICES;
              if (($query_price_to_guest_result=='true') && !(tep_session_is_registered('customer_id'))) {
                $query_guest_discount_result = GUEST_DISCOUNT;
                $customer_discount = $query_guest_discount_result;
              } elseif (tep_session_is_registered('customer_id')) {
                $query_A = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
                $query_B = tep_db_query("select m.manudiscount_discount from " . TABLE_CUSTOMERS  . " c, " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = c.customers_groups_id  and m.manudiscount_customers_id = 0 and c.customers_id = '" . $customer_id . "' and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
                $query_C = tep_db_query("select m.manudiscount_discount from " . TABLE_MANUDISCOUNT .  " m, " . TABLE_PRODUCTS . " p where m.manudiscount_groups_id = 0 and m.manudiscount_customers_id = 0 and p.products_id = '" . $prid . "' and p.manufacturers_id = m.manudiscount_manufacturers_id");
                if ($query_result = tep_db_fetch_array($query_A)) {
                  $customer_discount = $query_result['manudiscount_discount'];
                } else if ($query_result = tep_db_fetch_array($query_B)) {
                  $customer_discount = $query_result['manudiscount_discount'];
                } else if ($query_result = tep_db_fetch_array($query_C)) {
                  $customer_discount = $query_result['manudiscount_discount'];
                } else {
                  $query = tep_db_query("select g.customers_groups_discount from " . TABLE_CUSTOMERS_GROUPS . " g inner join  " . TABLE_CUSTOMERS  . " c on g.customers_groups_id = c.customers_groups_id and c.customers_id = '" . $customer_id . "'");
                  $query_result = tep_db_fetch_array($query);
                  $customers_groups_discount = $query_result['customers_groups_discount'];
                  $query = tep_db_query("select customers_discount from " . TABLE_CUSTOMERS . " where customers_id =  '" . $customer_id . "'");
                  $query_result = tep_db_fetch_array($query);
                  $customer_discount = $query_result['customers_discount'];
                  $customer_discount = $customer_discount + $customers_groups_discount;
                }
              }
              if ($customer_discount >= 0) {
                $attribute_price['options_values_price'] = $attribute_price['options_values_price'] + $attribute_price['options_values_price'] * abs($customer_discount) / 100;
              } else {
                $attribute_price['options_values_price'] = $attribute_price['options_values_price'] - $attribute_price['options_values_price'] * abs($customer_discount) / 100;
              }
              //TotalB2B end

              if ($attribute_price['price_prefix'] == '+') {
                $this->total += $currencies->calculate_price($attribute_price['options_values_price'], $products_tax, $qty);
                $this->total_netto += $currencies->calculate_price($attribute_price['options_values_price'], 0, $qty);
              } else {
                $this->total -= $currencies->calculate_price($attribute_price['options_values_price'], $products_tax, $qty);
                $this->total_netto -= $currencies->calculate_price($attribute_price['options_values_price'], 0, $qty);
              }
            }
          }
        }
      }
    }

    function show_wishlist_total() {
      $this->wishlist_calculate();
      return $this->total;
    }
}
?>