# oscGold
# http://www.oscgold.com
#
# Kopia bazy sklepu Sklep internetowy
# Copyright (c) 2017 oscGold
#
# Nazwa bazy: jotte_oscgold
# Serwr bazy: localhost
#
# Data archiwum: 09/25/2017 11:25:02
# Zarchwizowane tabele: additional_images, address_book, address_format, admin, admin_access_files, admin_files, admin_groups, allegro_config, allegro_kategorie, am_attributes_to_templates, am_templates, anti_robotreg, banners, banners_history, cache, categories, categories_description, configuration, configuration_group, contact, counter, counter_history, countries, currencies, customers, customers_basket, customers_basket_attributes, customers_basket_text_attributes, customers_groups, customers_info, customers_points_pending, customers_to_extra_fields, customers_wishlist, customers_wishlist_attributes, discount_coupons, discount_coupons_to_categories, discount_coupons_to_customers, discount_coupons_to_manufacturers, discount_coupons_to_orders, discount_coupons_to_products, discount_coupons_to_zones, extra_fields, extra_fields_info, faq, faq_description, featured, geo_zones, headertags, headertags_default, invoices_symfonia, languages, mailing, manudiscount, manufacturers, manufacturers_info, modules_configuration, newsdesk, newsdesk_categories, newsdesk_categories_description, newsdesk_configuration, newsdesk_configuration_group, newsdesk_description, newsdesk_reviews, newsdesk_reviews_description, newsdesk_to_categories, newsletters, newsletters_tmp, onet_category_map, optimize_check, orders, orders_products, orders_products_attributes, orders_products_download, orders_status, orders_status_history, orders_text_attributes, orders_total, pages, pages_description, phesis_comments, phesis_poll_check, phesis_poll_config, phesis_poll_data, phesis_poll_desc, porownywarki, products, products_attributes, products_attributes_download, products_availability, products_description, products_extra_fields, products_jm, products_notifications, products_options, products_options_products, products_options_values, products_options_values_to_products_options, products_stock, products_text_attributes, products_text_attributes_enabled, products_to_categories, products_to_products_extra_fields, recently_view, reviews, reviews_description, sessions, ship2pay, specials, star_product, subscribers, swistak_categories, swistak_export_import, swistak_xml_categories, tax_class, tax_rates, templates, theme_configuration, ticket_priority, ticket_reply, ticket_status, ticket_status_history, ticket_ticket, whos_online, zones, zones_to_geo_zones

drop table if exists `additional_images`;
CREATE TABLE `additional_images` (
  `additional_images_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `images_description` varchar(64) DEFAULT NULL,
  `medium_images` varchar(120) DEFAULT NULL,
  `popup_images` varchar(120) DEFAULT NULL,
  PRIMARY KEY (`additional_images_id`),
  KEY `idx_products_id` (`products_id`)
);

drop table if exists `address_book`;
CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_gender` char(1) NOT NULL,
  `entry_company` varchar(256) DEFAULT NULL,
  `entry_nip` varchar(32) DEFAULT NULL,
  `entry_firstname` varchar(32) NOT NULL,
  `entry_lastname` varchar(32) NOT NULL,
  `entry_street_address` varchar(64) NOT NULL,
  `entry_suburb` varchar(32) DEFAULT NULL,
  `entry_postcode` varchar(10) NOT NULL,
  `entry_city` varchar(32) NOT NULL,
  `entry_state` varchar(32) DEFAULT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_book_id`,`customers_id`),
  KEY `idx_customers_id` (`customers_id`)
);

drop table if exists `address_format`;
CREATE TABLE `address_format` (
  `address_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `address_format` varchar(128) NOT NULL,
  `address_summary` varchar(48) NOT NULL,
  PRIMARY KEY (`address_format_id`)
);

insert into `address_format` (`address_format_id`, `address_format`, `address_summary`) values (1,'$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country'),
(2,'$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country'),
(3,'$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$state / $country'),
(4,'$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country','$postcode / $country'),
(5,'$firstname $lastname$cr$streets$cr$postcode $city$cr$country','$city / $country');

drop table if exists `admin`;
CREATE TABLE `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_id` int(11) DEFAULT NULL,
  `admin_firstname` varchar(32) NOT NULL,
  `admin_lastname` varchar(32) DEFAULT NULL,
  `admin_email_address` varchar(96) NOT NULL,
  `admin_password` varchar(40) NOT NULL,
  `admin_created` datetime DEFAULT NULL,
  `admin_modified` datetime NOT NULL,
  `admin_logdate` datetime DEFAULT NULL,
  `admin_lognum` int(11) NOT NULL DEFAULT '0',
  `admin_cat_access` text NOT NULL,
  `admin_right_access` text NOT NULL,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `idx_admin_email_address` (`admin_email_address`)
);

insert into `admin` (`admin_id`, `admin_groups_id`, `admin_firstname`, `admin_lastname`, `admin_email_address`, `admin_password`, `admin_created`, `admin_modified`, `admin_logdate`, `admin_lognum`, `admin_cat_access`, `admin_right_access`) values (1,1,'Admin','Admin','jarek@vancar.pl','f875fadfc83d1e37ec8034f1da3db108:d0','2009-11-30 10:09:19','2009-11-30 23:03:51','2017-09-25 11:46:28',15,'ALL','');

drop table if exists `admin_access_files`;
CREATE TABLE `admin_access_files` (
  `file_access_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_files_id` int(11) NOT NULL DEFAULT '0',
  `admin_id` int(11) NOT NULL DEFAULT '1',
  `admin_access_values` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`file_access_id`)
);

insert into `admin_access_files` (`file_access_id`, `admin_files_id`, `admin_id`, `admin_access_values`) values (1,11,3,3),
(2,110,2,2),
(3,112,2,2);

drop table if exists `admin_files`;
CREATE TABLE `admin_files` (
  `admin_files_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_files_name` varchar(64) NOT NULL,
  `admin_files_is_boxes` tinyint(5) NOT NULL DEFAULT '0',
  `admin_files_to_boxes` int(11) NOT NULL DEFAULT '0',
  `admin_groups_id` set('1','2','3','4','5') NOT NULL DEFAULT '1',
  PRIMARY KEY (`admin_files_id`),
  KEY `idx_admin_files_is_boxes` (`admin_files_is_boxes`),
  KEY `idx_admin_files_name` (`admin_files_name`)
);

insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (1,'administrator.php',1,0,'1'),
(11,'admin_files.php',0,1,'1'),
(10,'admin_members.php',0,1,'1'),
(223,'swistak_assoc_categories.php',0,157,'1'),
(123,'all_customers.php',0,8,'1'),
(110,'attributeManager.php',0,3,'1,3'),
(157,'integracje.php',1,0,'1'),
(34,'banner_manager.php',0,9,'1,2,5'),
(42,'banner_statistics.php',0,9,'1,2,5'),
(35,'cache.php',0,9,'1,5'),
(3,'catalog.php',1,0,'1,2,3'),
(13,'categories.php',0,3,'1,2,3'),
(66,'catimagessetup.php',0,46,'1,3'),
(172,'customers_points.php',0,5,'1'),
(65,'column_controller.php',0,52,'1'),
(47,'configuration.php',0,46,'1,3'),
(46,'configuration.php',1,0,'1,3'),
(22,'countries.php',0,6,'1'),
(112,'coupons.php',0,3,'1,3'),
(119,'coupons_exclusions.php',0,3,'1,3');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (27,'currencies.php',0,7,'1'),
(5,'customers.php',1,0,'1,2'),
(20,'customers.php',0,5,'1,2'),
(71,'customers_groups.php',0,5,'1'),
(109,'default_tax_class.php',0,6,'1'),
(227,'allegro_config_setup.php',0,157,'1'),
(173,'customers_points_pending.php',0,5,'1'),
(113,'easypopulate.php',0,3,'1,3'),
(175,'create_order.php',0,5,'1'),
(124,'exportorders.php',0,8,'1'),
(94,'featured.php',0,3,'1,3'),
(37,'file_manager.php',0,9,'1,5'),
(24,'geo_zones.php',0,6,'1'),
(235,'import.php',0,3,'1'),
(185,'polls.php',0,184,'1'),
(184,'polls.php',1,0,'1'),
(183,'translator.php',0,3,'1,3'),
(182,'header_tags_fill_tags.php',0,180,'1'),
(52,'information.php',1,0,'1'),
(28,'languages.php',0,7,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (7,'localization.php',1,0,'1'),
(38,'mail.php',0,9,'1,5'),
(72,'manudiscount.php',0,5,'1'),
(15,'manufacturers.php',0,3,'1,2,3'),
(4,'modules.php',1,0,'1'),
(19,'modules.php',0,4,'1'),
(81,'newsdesk.php',0,80,'1'),
(80,'newsdesk.php',1,0,'1'),
(82,'newsdesk_configuration.php',0,80,'1'),
(83,'newsdesk_reviews.php',0,80,'1'),
(39,'newsletters.php',0,9,'1,2,5'),
(95,'newsletters.php',1,0,'1'),
(96,'newsletters_extra_default.php',0,95,'1'),
(97,'newsletters_extra_infos.php',0,95,'1'),
(98,'newsletters_subscribers_view.php',0,95,'1'),
(122,'newsletters_update.php',0,95,'1'),
(101,'optimize_db.php',0,1,'1'),
(126,'options_images.php',0,3,'1,3'),
(21,'orders.php',0,5,'1,2'),
(29,'orders_status.php',0,7,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (68,'page_manager.php',0,52,'1'),
(14,'products_attributes.php',0,3,'1,2,3'),
(59,'products_availability.php',0,7,'1'),
(18,'products_expected.php',0,3,'1,2,3'),
(111,'products_multi.php',0,3,'1,3'),
(75,'products_options.php',0,3,'1,3'),
(61,'product_extra_fields.php',0,7,'1,3'),
(74,'protection.php',0,9,'1'),
(99,'quick_attributes_popup.php',0,3,'1,3'),
(100,'quick_products_popup.php',0,3,'1,3'),
(62,'quick_updates.php',0,3,'1,3'),
(8,'reports.php',1,0,'1,2'),
(16,'reviews.php',0,3,'1,2,3'),
(40,'server_info.php',0,9,'1,5'),
(67,'ship2pay.php',0,4,'1'),
(114,'sitemonitor.php',1,0,'1'),
(115,'sitemonitor.php',0,114,'1'),
(116,'sitemonitor_admin.php',0,114,'1'),
(117,'sitemonitor_configure_setup.php',0,114,'1'),
(17,'specials.php',0,3,'1,2,3');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (128,'specials_enhanced.php',0,3,'1,3'),
(58,'star_product.php',0,3,'1,3'),
(32,'stats_customers.php',0,8,'1,2'),
(120,'stats_discount_coupons.php',0,8,'1'),
(57,'stats_low_stock.php',0,8,'1'),
(135,'stats_low_stock_attrib.php',0,8,'1'),
(31,'stats_products_purchased.php',0,8,'1,2'),
(30,'stats_products_viewed.php',0,8,'1,2'),
(133,'stats_sales.php',0,8,'1'),
(56,'stats_sales_csv.php',0,8,'1'),
(121,'stock.php',0,3,'1,3'),
(6,'taxes.php',1,0,'1'),
(25,'tax_classes.php',0,6,'1'),
(26,'tax_rates.php',0,6,'1'),
(9,'tools.php',1,0,'1,2,5'),
(41,'whos_online.php',0,9,'1,5'),
(23,'zones.php',0,6,'1'),
(136,'batch_print.php',0,5,'1'),
(137,'print_batch_invoice.php',0,5,'1'),
(138,'print_batch_process.php',0,5,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (139,'faq.php',0,9,'1'),
(140,'ksiazka_nadawcza.php',0,5,'1'),
(141,'infobox_configuration.php',0,52,'1'),
(142,'products_jm.php',0,7,'1'),
(143,'verify_language.php',0,7,'1'),
(144,'update_currencies.php',0,7,'1'),
(224,'swistak_export_offers.php',0,157,'1'),
(151,'text_attributes.php',0,3,'1,3'),
(160,'backup.php',0,9,'1'),
(197,'oferciak_offers.php',0,157,'1'),
(244,'kupujemy_offers.php',0,157,'1'),
(245,'starcode_offers.php',0,157,'1'),
(246,'smartbay_offers.php',0,157,'1'),
(247,'cenohit_offers.php',0,157,'1'),
(196,'tortura_offers.php',0,157,'1'),
(192,'configurations.php',0,52,'1'),
(193,'cenus_offers.php',0,157,'1'),
(194,'sklepy24_offers.php',0,157,'1'),
(195,'radar_offers.php',0,157,'1'),
(170,'modules_configuration.php',0,52,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (171,'stats_wishlists.php',0,8,'1'),
(174,'customers_points_referral.php',0,5,'1'),
(176,'create_order_process.php',0,5,'1'),
(180,'header_tags_seo.php',1,0,'1'),
(178,'edit_orders_add_product.php',0,5,'1'),
(179,'edit_orders.php',0,5,'1'),
(181,'header_tags_seo.php',0,180,'1'),
(187,'invoice_edit.php',0,5,'1'),
(189,'okazje_offers.php',0,157,'1'),
(190,'ceneo_offers.php',0,157,'1'),
(191,'nokaut_offers.php',0,157,'1'),
(198,'skapiec_offers.php',0,157,'1'),
(211,'change_status.php',0,9,'1'),
(200,'categories_map.php',0,157,'1'),
(201,'export_harmonogram.php',0,157,'1'),
(202,'export_list.php',0,157,'1'),
(203,'export_onet.php',0,157,'1'),
(204,'generuj.php',0,157,'1'),
(205,'harmonogram.php',0,157,'1'),
(206,'make_export.php',0,157,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (207,'save_maped.php',0,157,'1'),
(208,'category_download.php',0,157,'1'),
(209,'deleted_list.php',0,157,'1'),
(210,'stats_kat.php',0,8,'1'),
(212,'statuses.php',0,9,'1'),
(213,'porownywarki_configuration.php',0,157,'1'),
(214,'newsletters_subscribers_view_prod.php',0,95,'1'),
(215,'newsletters_subscribers_view_rej.php',0,95,'1'),
(216,'newsletters_subscribers_view_mailing.php',0,95,'1'),
(217,'totu_offers.php',0,157,'1'),
(222,'swistak_import_categories.php',0,157,'1'),
(225,'swistak_prepare_offers.php',0,157,'1'),
(226,'allegro.php',0,157,'1'),
(228,'header_tags_seo_popup_logotext.php',0,180,'1'),
(229,'header_tags_test.php',0,180,'1'),
(230,'seo_oscgold.php',0,231,'1'),
(231,'seo.php',1,0,'1'),
(232,'seo_pr.php',0,231,'1'),
(233,'seo_pozycja.php',0,231,'1'),
(234,'seo_sites.php',0,231,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (236,'xlsinvoice.php',0,5,'1'),
(237,'ticket.php',1,0,'1'),
(238,'ticket_priority.php',0,237,'1'),
(239,'ticket_reply.php',0,237,'1'),
(248,'exportinvoices.php',0,8,'1'),
(249,'extra_fields.php',0,7,'1'),
(250,'contact.php',0,7,'1'),
(251,'ticket_status.php',0,237,'1'),
(252,'ticket_view.php',0,237,'1'),
(255,'pkt_offers.php',0,157,'1'),
(256,'pokaz_kategorie.php',0,157,'1'),
(258,'tanio_offers.php',0,157,'1');

drop table if exists `admin_groups`;
CREATE TABLE `admin_groups` (
  `admin_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`admin_groups_id`),
  UNIQUE KEY `idx_admin_groups_name` (`admin_groups_name`)
);

insert into `admin_groups` (`admin_groups_id`, `admin_groups_name`) values (1,'Administrator'),
(2,'Marketing'),
(3,'Właściciel'),
(4,'Obsługa reklamacji');

drop table if exists `allegro_config`;
CREATE TABLE `allegro_config` (
  `parametr` varchar(250) NOT NULL,
  `dane` text NOT NULL
);

insert into `allegro_config` (`parametr`, `dane`) values ('hash',''),
('webapi_haslo','xxxxXX'),
('webapi_wersja',''),
('id_allegro','1234567890'),
('kraj',''),
('kod_pocztowy','XX-XXX'),
('czas_trwania','2'),
('rodzaj_aukcji','0'),
('wojewodztwo','2'),
('miejscowosc','Miejscowosc'),
('koszty_transportu','1'),
('bank_account_raz','12345678901234567890123456'),
('bank_account_dwa',''),
('dodatkowe_opcje','null|1|null|null|null|null|null'),
('opcje_transportu','null|null|null|null|4|null'),
('formy_platnosci','0|null|null|null|4|5'),
('dodatkowy_opis','Jakiś tam dodatkowy opis wysyłek i płatności'),
('darmowe_opcje_wysylki','null|null'),
('paczka_pocztowa_ekonomiczna',''),
('list_ekonomiczny','');
insert into `allegro_config` (`parametr`, `dane`) values ('paczka_pocztowa_priorytetowa',''),
('list_priorytetowy',''),
('przesylka_pobraniowa',''),
('list_polecony_ekonomiczny','7.00'),
('przesylka_pobraniowa_priorytetowa',''),
('list_polecony_priorytetowy','8.00'),
('przesylka_kurierska',''),
('przesylka_kurierska_pobraniowa',''),
('szablon','001');

drop table if exists `allegro_kategorie`;
CREATE TABLE `allegro_kategorie` (
  `catid` int(11) NOT NULL,
  `catname` varchar(70) NOT NULL,
  `catparent` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL,
  KEY `cat_id` (`catid`)
);

drop table if exists `am_attributes_to_templates`;
CREATE TABLE `am_attributes_to_templates` (
  `template_id` int(5) unsigned NOT NULL,
  `options_id` int(5) unsigned NOT NULL,
  `option_values_id` int(5) unsigned NOT NULL,
  `products_options_sort_order` int(6) NOT NULL DEFAULT '0',
  `options_values_price` decimal(15,4) DEFAULT '0.0000',
  `price_prefix` char(1) DEFAULT '+',
  `options_values_weight` decimal(6,3) NOT NULL DEFAULT '0.000',
  KEY `idx_template_id` (`template_id`)
);

drop table if exists `am_templates`;
CREATE TABLE `am_templates` (
  `template_id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `template_name` varchar(255) NOT NULL,
  PRIMARY KEY (`template_id`)
);

drop table if exists `anti_robotreg`;
CREATE TABLE `anti_robotreg` (
  `session_id` char(32) NOT NULL,
  `reg_key` char(10) NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`session_id`)
);

insert into `anti_robotreg` (`session_id`, `reg_key`, `timestamp`) values ('3k02ltmkgrlub6p97nhfcn0fb1','KJMN',1505238066);

drop table if exists `banners`;
CREATE TABLE `banners` (
  `banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_title` varchar(64) NOT NULL,
  `banners_url` varchar(255) NOT NULL,
  `banners_image` varchar(64) NOT NULL,
  `banners_group` varchar(32) NOT NULL,
  `banners_html_text` text,
  `expires_impressions` int(7) DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `date_scheduled` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`banners_id`),
  KEY `idx_banners_group` (`banners_group`),
  KEY `idx_banners_status` (`status`),
  KEY `idx_date_scheduled` (`date_scheduled`),
  KEY `idx_expires_date` (`expires_date`)
);

drop table if exists `banners_history`;
CREATE TABLE `banners_history` (
  `banners_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_id` int(11) NOT NULL,
  `banners_shown` int(5) NOT NULL DEFAULT '0',
  `banners_clicked` int(5) NOT NULL DEFAULT '0',
  `banners_history_date` datetime NOT NULL,
  PRIMARY KEY (`banners_history_id`),
  KEY `idx_banners_id` (`banners_id`)
);

drop table if exists `cache`;
CREATE TABLE `cache` (
  `cache_id` varchar(32) NOT NULL,
  `cache_language_id` tinyint(1) NOT NULL DEFAULT '0',
  `cache_name` varchar(255) NOT NULL,
  `cache_data` mediumtext NOT NULL,
  `cache_global` tinyint(1) NOT NULL DEFAULT '1',
  `cache_gzip` tinyint(1) NOT NULL DEFAULT '1',
  `cache_method` varchar(20) NOT NULL DEFAULT 'RETURN',
  `cache_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cache_expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`cache_id`,`cache_language_id`),
  KEY `idx_cache_expires` (`cache_expires`),
  KEY `idx_cache_global` (`cache_global`),
  KEY `idx_cache_id` (`cache_id`),
  KEY `idx_cache_language_id` (`cache_language_id`)
);

insert into `cache` (`cache_id`, `cache_language_id`, `cache_name`, `cache_data`, `cache_global`, `cache_gzip`, `cache_method`, `cache_date`, `cache_expires`) values ('a93b9170a03ff54d81e95917742ea01b',1,'seo_urls_v2_categories','rVpBj+s0EL7zK7gtSESqnbZpxOkJPXECJMSF08qbeLvZpHFIUoXk1zMZ97GzbDMeA8dK843H/r6ZccYt7XPV2m8efvj02+cff/n198efP/30+VEdsofvvn4o7VhXietc+/Dt91+V9033p9X02Y22qeqKM8xXw9bUPbqtTTc0Nnm2zZkBHXbiQA5KbqrlpqncdC83PchNj2LTFLe18jUng7m44sWVbkrc4J7cNBcvzDnr/FGlSNAH+FJd3GQZrJKfptKPSsmPCc3lUlR4VKuiquSPq4G9c1EfIRSv3QgAHpFwBY3a9ecZDEfvHpVGBccACOHhFVDJH+gt3TCaqVgC+kghPCSOc5A0dmwrTit69YPi/x/8oDJYP0HtYjyogv/o527uMPLDhCMCIfkaPMRTjM5PeNpCyaaQn+l9nfxdRcIkr172RMtkb29egtTsibgvbnTFXDdsIdI7QiSRdTjgXLZllTGE5iTcuxv2tEKN2u6lJ8wwIVcnDFpq7Gv0DLneDjZYHfWO5GjpXs0CxZTJa727Xxv+STcU3M3d651MMurA+bifUh/i2G/7UCciI4ZJqNabe1Gn+7XpLQ6vBmgR2z6OpKZ0/WIv88AngDqSyIUIcXfVitATk116F8ouXwq47NK7UHbdfDDZpRXRRtwGCBExQJVhofadRcZHRvJOhtivxZagSKlMemdKRmAIJSHGQFE3pi7s4PrKbC+idyQT/OEljZnsGKzKekdCi0KqnEiVyWCukqiMVDQZExnRuRBBVC1DnMjOhAiiehkiI3KXIXKCuHvet+xMt3WiclK77vq4VUyucudEa5wPzcVBVMf4gI+e7cqdk3zkfOScD6I/zgfTUVUWrZYsWi05QXBxcrxlhHuZ4jLCtAxxRF5FI40j0iczRZZkplgeRKZ4gQ6da/ACjZd5mZoZHWKTIJWNNolhgQsNdy9UiCZKjkOfQnXldqfm6soBtSU69gMuJzI9IjsyU0zC0oz2z6R4sReuW6qjv6cLBm/aj1385SKqPWpF6IxEIpUX2As0/WZOLqav7Vi1Z1YFGhotjP5uX9j1FdDcaEb7OY7cnNSCQeCdFBsoWP4AcP6RhFJKq/eCjMLScRBNA/6SpulQKAZGrhYxMCKNGNhGiof2RnQRsxopamdXm35k5aSpPt7Gor52bFc+rd8L5cs4NYx7LxIxLr1f8YPrpaTLkw4cxhGJROGIRqJwRCRRuA2VBLuPTolQQvNRnRKZhI2JNsLGRBBB4z1RQdiYUB82JnyHjQnJYWPCbNiY0Cko13vCocScsEhLSlgs/iFL3HX2hNS4hfybll8oEknoHq6d7Vd4Ak87y9zyHfhAuI9c8yaE0q1vSkVlFwPdG14LEnMd3dMVLoBMDT3clPEv0VQqb5U72KYPVDMxOCIeUqHC65FqEIVDDXVmgGfW1nR2HbKGZ7P+7rkYmAa2AFw/f4pqWn/ZYmm5Ke0R9XMxDWuEUukd9I85yjkKpXPwTTAGVvCiWCOeE9efTVsttp8TfERmxOS/y+AFuTHlunFXXoeFe3PW/qNvNE9NVYAlPIWOcFrn9b2LPQLUwVDZcqmGmptu+YmrKU0Hl9qZix2pNk1hEszc5LkxI2PvP8S9fQf8moYzRl67yjb23Jri1SSLnVoLe2254DNkenKr/ECEQDe8za8nW7vG9fNyfTUFd0x+4BX6ptF+kkajm0TRYfKXV5YpP2Ht3KVjdeDHBTWY9evAkiPKzyJMO9qWNUM+z20FTyMmmcYZjq13yxmUv1SGl9cJW/yTXeBMIGPZv03o28RvmCo7NpZ9XdUnJHT9vLoA+TOo4AwfaBWjnNsj0u3fG0meHpOa+T+Gvr1QfbFXB7hibc7BtH977HpIOzet+8R6Mk6ubyuvrL8A',1,1,'EVAL','2017-09-25 09:57:31','2017-10-25 09:57:31'),
('ca34fbe5f9a075091ad59abf02c259a7',1,'seo_urls_v2_products','lVhNj+M2DL33V/Q2LVABoixZFnoqdnvsB4r2vFASO/FMJs46M93s/PpSdGxLzpjaniM+yeTj42N2ddOe6h8e/vzrj4//fPj70++//PbrJ3j46fuH7tydvNi99p2AypSmB/Pw48/f7d4LUHPAU33aeaEURZSrEcX/jjAhgp6zOfrt08F/eRK7VklZ4G1XC3L1rnKKDOfBiNrvj3Uuyk5R790HkrmwmkLpQiXAXUvmvEvPg9jU/bPofbur+/BMACYYfxoTQ7dJsXltGn/shDJX9plAdaaUUqQTl23Xbw94aebBQAWfIpWMIqvMpVT5KRSiSxWwZQSdfmgx15H/zJk5h0Zpmys8zHyZzvMXzFRZ5jHDTCCmHLpjfTl0L+L52pe31AtTKKmUePa7epXYQMQ5ti8jmYUppVaOj1JUdtBXKzQSS4BWlQGppd6s3qSi3J8LKaVQEu/qMVermjCnffetIZT5x+61P9VfxbkwpchwQlHq0wheDBSlfI4o8A7sMK6dFaV5DtFV7lkF9WRTY//6Y0iVRfnUW1Fvu3/9SdS9BAHSgbSfRbO1RhRW1hoed6vZLKhoMSIm34jLpTRWNLVFPCUb4zkIatoRAtyg6aLp+ufuzYd3YFWd2xvfrFOuoPYdQRQQCcwSxB94EGLTCAJ2YFIMAvgSeyjZlxC/RhAcOEa+IR9nlI1ViLJ55FGIciMKJsWYvolQ/BuWqt5ifj24NkCJ/vXUHP3LeqmIkyPkFtns960X50ADKlppQ6W4JBNH7xAKQJ4agkDyfF5/APH1Pry4ghrDq/VwvSQvJdYI40x/6QPZlHBGPrKfoJd8vVVnCcIWRyeMxfxpQyVegDzxIOnAiWdVrvF1pHroHJQR5+4LTsd9356F0liNHmfomgDqSACD74gGcwjlIucJtBzpxbXiAheTKLmSDVxYliTQcTcmXAt6EIzi3ISDqHheVEzCuKljCvQvI2GhWCesSbg2hR9fVEHCa1BrNSacQUiIFiPAhCAdirW2vjYF07omZVtc9IJ1NyblGqB28YPMpPRakBNTBz3jGs2CYngd775Mokl302PWSVdlRohJKEOSi10dZhn2dZAXjZbEtay8lAljUBkMKsOabsu23HyDbpfv06iQV1S78EBk0TqFyoRC4avCOJpVMzSCM45XzZLYk/pBJcPuMPhBCM6uXVWcMh2JqJf47jJNrDyyalkm81ABQpDkJsXxGYylKUPLLfklply4MjQ1OXG2CQUO7bM/+q9hzFoas2ikQb+IukE6Obtv2K+2SekjLHRXlEIANWE1GayECBNWu61xkSZ/gazY18FslRmW28RsLaDQNZHU3qAsL7GW5OWC1kV4qWyTa3dLVBrPox3LeGRLvLmdl3lPbYkjET62MOfBLRFkPG+HtZgNIJUZA9Ae8yt4RWyaj2fEtyLC3I4X+A9E0FtGbisiRXQeHQB7niofPwe9D4d/V15+eFRxeQGbjRf/Kq6uRjZkDEwVVzekJ3c+qS7iZ54T11bi6/nR6uLaFoDcJ0ldlVFHxR3+ohg217Fv10Pi+ir8ANQ7jp0urq/U+fNU3ztLf1aDQOFsAnUQpW34xcItBwSt8JNbG/YcI/nFyyUjImxvieWLnUBGlBzRZPwqKMPyheKIFgApI0veArjEkNzvf8M7Nri5uSqzBLrUkVT0jnmTjL+ooh1wlQcgk6l0MyZhnxy+Ca0It/ghZ8J/XFFGhgk+ZoSfuyCJhdEfFS6r2yCJiWnM1E7/AQ==',1,1,'EVAL','2017-09-25 09:57:31','2017-10-25 09:57:31'),
('4404c1df54fdb1291c8dd9bb259f32a9',1,'seo_urls_v2_manufacturers','S0lNy8xL1VD3dfQLdXN0DgkNcg2K93P0dY03VNdRUE8pLcpX17TmSsGpzAikLLOkAL8qY5Cq/IL8vErdtNSc9EzdwtLElPxy/JpMQJqy8kuL8lIr8as0BalMS01JLUrMwa/SDKSyuDQvDaQMAA==',1,1,'EVAL','2017-09-25 09:57:31','2017-10-25 09:57:31');

drop table if exists `categories`;
CREATE TABLE `categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(120) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `categories_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `swistak_categories_id` int(11) NOT NULL DEFAULT '0',
  `action` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`categories_id`),
  UNIQUE KEY `action` (`action`),
  KEY `idx_categories_status` (`categories_status`),
  KEY `idx_parent_id_cat_id` (`parent_id`,`categories_id`),
  KEY `idx_sort_order` (`sort_order`)
);

drop table if exists `categories_description`;
CREATE TABLE `categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(65) NOT NULL,
  `categories_heading_title` varchar(64) DEFAULT NULL,
  `categories_description` text,
  `categories_htc_title_tag` varchar(80) DEFAULT NULL,
  `categories_htc_desc_tag` longtext,
  `categories_htc_keywords_tag` longtext,
  `categories_htc_description` longtext,
  `categories_seo_url` varchar(100) NOT NULL,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_id` (`categories_id`),
  KEY `idx_categories_name` (`categories_name`),
  KEY `idx_language_id` (`language_id`)
);

drop table if exists `configuration`;
CREATE TABLE `configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(255) NOT NULL,
  `configuration_key` varchar(64) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`configuration_id`),
  KEY `idx_configuration_group_id` (`configuration_group_id`),
  KEY `idx_configuration_key` (`configuration_key`),
  KEY `idx_configuration_key_value` (`configuration_key`,`configuration_value`),
  KEY `idx_configuration_value` (`configuration_value`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_sort_order` (`sort_order`)
);

insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1,'Nazwa sklepu','STORE_NAME','Sklep internetowy','Nazwa sklepu',1,1,'2009-03-26 15:33:21','2003-07-29 13:05:38',NULL,NULL),
(2,'Właściciel sklepu','STORE_OWNER','oscGold','Nazwisko właściciela sklepu',1,2,'2009-03-30 10:32:18','2003-07-29 13:05:38',NULL,NULL),
(3,'Adres e-mail','STORE_OWNER_EMAIL_ADDRESS','adres@email.pl','Adres e-mail właściciela sklepu',1,5,'2009-11-30 22:06:18','2003-07-29 13:05:38',NULL,NULL),
(4,'Adres wychodących e-maili','EMAIL_FROM','adres@email.pl','Adres e-mail dla poczty wysyłanej przez sklep',1,6,'2009-11-30 22:06:26','2003-07-29 13:05:38',NULL,NULL),
(5,'Kraj','STORE_COUNTRY','170','Kraj, w którym znajduje się sklep <br><br><b>Uwaga: Trzeba pamiętać o uktualnieniu strefy sklepu.</b>',1,8,'2006-08-11 14:44:00','2003-07-29 13:05:38','tep_get_country_name','tep_cfg_pull_down_country_list('),
(6,'Strefa','STORE_ZONE','2','Strefa, w której znajduje się sklep',1,9,'2005-11-13 07:20:03','2003-07-29 13:05:38','tep_cfg_get_zone_name','tep_cfg_pull_down_zone_list('),
(4106,'Menu edytora HTML WYSIWYG ','DISPLAY_FCKEDITOR_MENU','oscGold','Jakie menu ma używanac edytor HTML WYSIWYG',101,121,'2008-01-24 08:23:06','2007-12-18 20:37:02',NULL,'tep_cfg_select_option(array(\'Default\', \'Basic\',\'oscGold\'),'),
(3333,'Edytor HTML WYSIWYG','HTML_WYSIWYG_DISABLE','Enable','Czy używać edytora HTML podczas wypełniania pól opisowych w formularzach ?',101,120,'2006-09-12 11:19:41','2003-07-24 00:27:47',NULL,'tep_cfg_select_option(array(\'Enable\', \'Disable\'),'),
(10,'Wyślij dodatkowe e-mail z zamówieniami','SEND_EXTRA_ORDER_EMAILS_TO','','Wysłanie dodatkowym e-maili z zamówieniami na adres o następujących formacie: Nazwa1 &lt;email@adres1&gt;, Nazwa2 &lt;email@adres2&gt;',1,7,'2009-11-30 22:06:33','2003-07-29 13:05:38',NULL,NULL),
(5252,'Wyświetlać rozwijaną listę płatności ?','ORDER_EDITOR_PAYMENT_DROPDOWN','true','Wyświetla listę dostępnych metod płatności lub pole tekstowe do wprowadzenia danych',72,1,'2008-12-29 14:36:45','2008-12-29 14:36:45',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1519,'Adres dostawy podczas zamawiania bez rejestracji','PURCHASE_WITHOUT_ACCOUNT_SEPARATE_SHIPPING','true','Czy zezwalać klientom sklepu na podawanie odobnego adresu dostawy podczas zamawiania bez zakładania konta ?',101,101,'2009-10-26 21:34:55','2006-04-18 22:25:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(15,'Adres i telefon sklepu','STORE_NAME_ADDRESS','Ulica\r\r
Kod Miejscowosc\r\r
Telefon','Nazwa, adres i telefon do sklepu, używane na wyświetlanych i drukowanych dokumentach',1,3,'2008-03-10 13:24:13','2003-07-29 13:05:38',NULL,'tep_cfg_textarea('),
(1518,'Zamawianie bez zakładania konta','PURCHASE_WITHOUT_ACCOUNT','true','Czy zezwalać klientom sklepu na dokonywanie zamówień bez zakładania konta ?',101,100,'2006-04-19 15:29:28','2006-04-18 22:25:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(19,'Imię','ENTRY_FIRST_NAME_MIN_LENGTH','2','Minimalna długość imienia.',2,1,NULL,'2003-07-29 13:05:38',NULL,NULL),
(20,'Nazwisko','ENTRY_LAST_NAME_MIN_LENGTH','2','Minimalna długość nazwiska.',2,2,NULL,'2003-07-29 13:05:38',NULL,NULL),
(21,'Data urodzenia','ENTRY_DOB_MIN_LENGTH','10','Minimalna długość daty urodzenia.',2,3,NULL,'2003-07-29 13:05:38',NULL,NULL),
(22,'Adres e-mail','ENTRY_EMAIL_ADDRESS_MIN_LENGTH','6','Minimalna długość adresu e-mail.',2,4,NULL,'2003-07-29 13:05:38',NULL,NULL),
(23,'Nazwa ulicy','ENTRY_STREET_ADDRESS_MIN_LENGTH','5','Minimalna długość nazwy ulicy.',2,5,NULL,'2003-07-29 13:05:38',NULL,NULL),
(24,'Firma','ENTRY_COMPANY_MIN_LENGTH','2','Minimalna długość nazwy firmy.',2,6,NULL,'2003-07-29 13:05:38',NULL,NULL),
(25,'Kod pocztowy','ENTRY_POSTCODE_MIN_LENGTH','5','Minimalna długość kodu pocztowego.',2,8,'2005-10-18 13:54:43','2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (26,'Miasto','ENTRY_CITY_MIN_LENGTH','3','Minimalna długość nazwy miasta.',2,9,NULL,'2003-07-29 13:05:38',NULL,NULL),
(27,'Województwo','ENTRY_STATE_MIN_LENGTH','2','Minimalna długość nazwy województwa/stanu.',2,10,NULL,'2003-07-29 13:05:38',NULL,NULL),
(28,'Numer telefonu','ENTRY_TELEPHONE_MIN_LENGTH','3','Minimalna długość numeru telefonu.',2,11,NULL,'2003-07-29 13:05:38',NULL,NULL),
(29,'Hasło','ENTRY_PASSWORD_MIN_LENGTH','5','Minimalna długość hasła.',2,12,NULL,'2003-07-29 13:05:38',NULL,NULL),
(30,'Nazwisko właściciela karty kredytowej','CC_OWNER_MIN_LENGTH','3','Minimalna długość nazwiska właściciela karty kredytowej.',2,13,NULL,'2003-07-29 13:05:38',NULL,NULL),
(31,'Numer karty kredytowej','CC_NUMBER_MIN_LENGTH','10','Minimalna długość numeru karty kredytowej.',2,14,NULL,'2003-07-29 13:05:38',NULL,NULL),
(32,'Recenzja','REVIEW_TEXT_MIN_LENGTH','50','Minimalna długość recenzji produktu.',2,15,NULL,'2003-07-29 13:05:38',NULL,NULL),
(35,'Pozycje książki adresowej','MAX_ADDRESS_BOOK_ENTRIES','5','Maksymalna liczby pozycji książki adresowej klienta.',3,1,NULL,'2003-07-29 13:05:38',NULL,NULL),
(36,'Wyniki wyszukiwania','MAX_DISPLAY_SEARCH_RESULTS','10','Liczba produktów na liście wyników wyszukiwania.',3,2,'2008-11-18 20:00:33','2003-07-29 13:05:38',NULL,NULL),
(37,'Łącza','MAX_DISPLAY_PAGE_LINKS','5','Liczbą łączy z numerami dla list podzielonych na strony.',3,3,NULL,'2003-07-29 13:05:38',NULL,NULL),
(44,'Nowe recenzje','MAX_DISPLAY_NEW_REVIEWS','6','Maksymalna liczby wyświetlanych nowych recenzji.',3,11,NULL,'2003-07-29 13:05:38',NULL,NULL),
(45,'Wybór losowych recenzji','MAX_RANDOM_SELECT_REVIEWS','10','Z ilu rekordów wybierać jedną losową recenzję produktu.',3,12,NULL,'2003-07-29 13:05:38',NULL,NULL),
(46,'Wybór losowych nowych produktów','MAX_RANDOM_SELECT_NEW','10','Z ilu rekordów wybierać jeden losowy nowy produkt.',3,13,NULL,'2003-07-29 13:05:38',NULL,NULL),
(47,'Wybór losowych produktów w promocji','MAX_RANDOM_SELECT_SPECIALS','10','Z ilu rekordów wybierać jeden losowy produkt w promocji.',3,14,NULL,'2003-07-29 13:05:38',NULL,NULL),
(5704,'Grupa VAT','MODULE_SHIPPING_ODBIOR_OSOBISTY_TAX_CLASS','0','Wybierz podatek stosowany przy wyliczaniu kosztów dostawy',6,0,NULL,'2009-07-14 21:57:33','tep_get_tax_class_title','tep_cfg_pull_down_tax_classes('),
(5702,'Włącz opcję Odbiór osobisty','MODULE_SHIPPING_ODBIOR_OSOBISTY_STATUS','True','Czy chcesz oferować możliwość odbioru osobistego?',6,0,NULL,'2009-07-14 21:57:33',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5703,'Koszt dostawy','MODULE_SHIPPING_ODBIOR_OSOBISTY_COST','0.00','Koszt dostawy dla wszystkich zamówień',6,0,NULL,'2009-07-14 21:57:33',NULL,NULL),
(52,'Okienko historii zamówień','MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX','6','Maksymalna liczba produktów wyświetlanych okienku historii zamówień.',3,18,NULL,'2003-07-29 13:05:38',NULL,NULL),
(53,'Historia zamówień','MAX_DISPLAY_ORDER_HISTORY','10','Maksymalna liczba zamówień wyświetalana na stronie historii zamówień.',3,19,NULL,'2003-07-29 13:05:38',NULL,NULL),
(54,'Szerokość małego obrazka','SMALL_IMAGE_WIDTH','90','Szerokość (w pikselach) małych obrazków',4,1,'2008-10-10 18:16:48','2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (55,'Wysokość małego obrazka','SMALL_IMAGE_HEIGHT','90','Wysokość (w pikselach) małych obrazków',4,2,'2008-10-10 18:16:51','2003-07-29 13:05:38',NULL,NULL),
(56,'Szerokość obrazka w nagłówku','HEADING_IMAGE_WIDTH','80','Szerokość (w pikselach) obrazków nagłówkowych',4,3,'2006-02-05 12:41:05','2003-07-29 13:05:38',NULL,NULL),
(57,'Wysokość obrazka w nagłówku','HEADING_IMAGE_HEIGHT','80','Wysokość (w pikselach) obrazków nagłowkowych',4,4,'2006-02-05 12:41:11','2003-07-29 13:05:38',NULL,NULL),
(58,'Szerokość obrazka podkategorii','SUBCATEGORY_IMAGE_WIDTH','80','Szerokość (w pikselach) obrazków podkategorii',4,5,'2007-02-08 14:47:04','2003-07-29 13:05:38',NULL,NULL),
(59,'Wysokość obrazka podkategorii','SUBCATEGORY_IMAGE_HEIGHT','80','Wysokość (w pikselach) obrazków podkategorii',4,6,'2007-02-08 14:47:10','2003-07-29 13:05:38',NULL,NULL),
(60,'Obliczanie rozmiaru obrazków','CONFIG_CALCULATE_IMAGE_SIZE','true','Czy obliczać rozmiar obrazków?',4,13,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(61,'Wymagane obrazki','IMAGE_REQUIRED','false','Włączenie powoduje próbę wyświetlenia także nieistniejących obrazków. Przydatne przy konfigurowaniu sklepu.',4,14,'2005-10-02 15:14:31','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(62,'Płeć','ACCOUNT_GENDER','false','Czy wyświetlać płeć na koncie klienta?',5,1,'2009-08-22 20:43:25','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(63,'Data urodzenia','ACCOUNT_DOB','false','Czy wyświetlać datę urodzenia na koncie klienta?',5,2,'2008-10-03 15:25:27','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5400,'Automatczyne dodawanie stron','HEADER_TAGS_AUTO_ADD_PAGES','false','Automatyczne dodawanie nowych stron podczas uruchamiania edytora Meta Tagów',543,3,'2009-06-05 21:18:42','2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(65,'Dzielnica','ACCOUNT_SUBURB','false','Czy wyświetlać dzielnicę na koncie klienta?',5,4,'2005-10-16 09:29:48','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(66,'Stan/województwo','ACCOUNT_STATE','true','Czy wyświetlać stan/województwo na koncie klienta?',5,6,'2007-12-19 15:05:43','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(67,'Zainstalowane moduły','MODULE_PAYMENT_INSTALLED','gotowkaprzyodbiorzeosobistym.php;plbanktransfer.php;pobraniekurier.php','Lista nazw plików modułów płacenia, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.',6,0,'2010-03-02 21:57:32','2003-07-29 13:05:38',NULL,NULL),
(68,'Zainstalowane moduły','MODULE_ORDER_TOTAL_INSTALLED','ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php','Lista nazw plików modułów order_total, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.',6,0,'2009-11-17 17:55:25','2003-07-29 13:05:38',NULL,NULL),
(4015,'Podsumowanie','MODULE_ORDER_TOTAL_TOTAL_STATUS','true','Czy chcesz wyświetlić podsumowanie zamówienia ?',6,1,NULL,'2007-12-01 18:36:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(69,'Zainstalowane moduły','MODULE_SHIPPING_INSTALLED','kurierpobranie.php;kurier.php;odbiorosobisty.php','Lista nazw plików modułów przesyłek, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.',6,0,'2010-03-02 21:57:11','2003-07-29 13:05:38',NULL,NULL),
(5911,'Strefa dostawy','MODULE_SHIPPING_KURIERPOBRANIE_ZONE','0','Wybierz strefę, dla której ma być stosowany ten sposob dostawy',6,0,NULL,'2010-03-02 21:57:06','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5912,'Sortowanie','MODULE_SHIPPING_KURIERPOBRANIE_SORT_ORDER','1','Kolejność wyświetlania wśród innych modułów wysyłki.',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(84,'Domyślna waluta','DEFAULT_CURRENCY','PLN','Domyślna waluta',6,0,NULL,'2003-07-29 13:05:38',NULL,NULL),
(85,'Domyślny język','DEFAULT_LANGUAGE','pl','Domyślny język',6,0,NULL,'2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (86,'Domyślny status nowego zamówienia','DEFAULT_ORDERS_STATUS_ID','1','Nowo utworzonemu zamówieniu zostanie przypisany ten status.',6,0,NULL,'2003-07-29 13:05:38',NULL,NULL),
(98,'Kraj pochodzenia','SHIPPING_ORIGIN_COUNTRY','170','Wprowadź kod kraju w którym znajduje się sklep (używane przy wysyłkach).',7,1,'2005-10-16 09:31:08','2003-07-29 13:05:38','tep_get_country_name','tep_cfg_pull_down_country_list('),
(99,'Kod pocztowy','SHIPPING_ORIGIN_ZIP','NONE','Wprowadź kod pocztowy (ZIP) sklepu, używany przy wysyłkach.',7,2,NULL,'2003-07-29 13:05:38',NULL,NULL),
(100,'Maksymalna ciężar wysyłanej paczki','SHIPPING_MAX_WEIGHT','150','Wspólny maksymalny ciężar wysyłanej paczki.',7,3,'2009-11-30 23:40:39','2003-07-29 13:05:38',NULL,NULL),
(101,'Waga opakowania','SHIPPING_BOX_WEIGHT','0','Wprowadź masę typowego opakowania małej do średniej paczki.',7,4,'2009-11-30 23:40:46','2003-07-29 13:05:38',NULL,NULL),
(102,'Procentowe zwiększenie dla dużych pakietów','SHIPPING_BOX_PADDING','10','Chcąc wpisać 10% wpisz 10',7,5,NULL,'2003-07-29 13:05:38',NULL,NULL),
(103,'Wyświetlaj obrazek produktu','PRODUCT_LIST_IMAGE','1','Czy wyświetlać obrazek produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,1,'2009-03-26 23:06:40','2003-07-29 13:05:38',NULL,NULL),
(104,'Wyświetlaj nazwę producenta','PRODUCT_LIST_MANUFACTURER','2','Czy wyświetlać nazwę producenta?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,2,'2009-01-11 16:24:02','2003-07-29 13:05:38',NULL,NULL),
(105,'Wyświetlaj model produktu','PRODUCT_LIST_MODEL','0','Czy wyświetlać model produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,3,'2008-02-25 11:19:42','2003-07-29 13:05:38',NULL,NULL),
(106,'Wyświetlaj nazwę produktu','PRODUCT_LIST_NAME','2','Czy wyświetlać nazwę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,4,'2005-10-30 23:33:00','2003-07-29 13:05:38',NULL,NULL),
(107,'Wyświetlaj cenę produktu','PRODUCT_LIST_PRICE','4','Czy wyświetlać cenę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,5,'2007-02-27 11:41:54','2003-07-29 13:05:38',NULL,NULL),
(108,'Wyświetlaj liczbę produktów','PRODUCT_LIST_QUANTITY','0','Czy wyświetlać ilość produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,7,'2006-03-09 11:16:46','2003-07-29 13:05:38',NULL,NULL),
(109,'Wyświetlaj wagę produktu','PRODUCT_LIST_WEIGHT','0','Czy wyświetlać masę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,8,'2008-03-13 15:15:14','2003-07-29 13:05:38',NULL,NULL),
(110,'Wyświetlaj kolumnę Kup Teraz','PRODUCT_LIST_BUY_NOW','6','Czy wyświetlać kolumnę Kup Teraz?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,10,'2005-12-12 21:43:15','2003-07-29 13:05:38',NULL,NULL),
(112,'Położenia paska nawigacja Poprzedni/Następny','PREV_NEXT_BAR_LOCATION','3','Położenie paska nawigacji Poprzedni/Następny (1-góra, 2-dół, 3-góra i dół).',8,16,'2006-06-23 22:59:37','2003-07-29 13:05:38',NULL,NULL),
(113,'Sprawdzanie zasobów magazynu','STOCK_CHECK','true','Czy sprawdzać ilość produktów w magazynie (na stanie)?',9,1,'2008-12-31 19:52:20','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(114,'Pomniejszanie stanu w magazynie','STOCK_LIMITED','true','Czy po zamówieniu odejmować liczbę produktów ze stanu?',9,2,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(115,'Pozwól na zamówienie mimo braków','STOCK_ALLOW_CHECKOUT','true','Pozwól klientowi zamówić nawet wtedy, jeżeli produktów nie ma na stanie',9,3,'2008-12-31 19:51:08','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(116,'Oznacz produkty niedostępne','STOCK_MARK_PRODUCT_OUT_OF_STOCK','*Aktualnie Brak*','Oznaczenie produktów, których nie ma w wystarczającej ilości.',9,4,'2005-11-05 16:30:26','2003-07-29 13:05:38',NULL,NULL),
(117,'Poziom konieczności uzupełnienia magazynu','STOCK_REORDER_LEVEL','5','Kiedy należy uzupełnić magazyn?',9,5,'2009-03-02 23:53:25','2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (118,'Zapisywanie czasu przetworzenia strony','STORE_PAGE_PARSE_TIME','false','Zachowaj czas przetwarzania stron.',10,1,'2009-07-26 22:22:46','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(119,'Cel logowania','STORE_PAGE_PARSE_TIME_LOG','tmp/page_parse_time.log','Katalog i nazwa pliku z czasem przetwarzania stron.',10,2,'2007-02-28 11:54:24','2003-07-29 13:05:38',NULL,NULL),
(120,'Format daty logu','STORE_PARSE_DATE_TIME_FORMAT','%d/%m/%Y %H:%M:%S','Format daty.',10,3,NULL,'2003-07-29 13:05:38',NULL,NULL),
(121,'Wyświetlanie czasu przetwarzania strony','DISPLAY_PAGE_PARSE_TIME','false','Wyświelaj czas przetworzenia strony (zapisywanie czasu przetworzenia strony musi być włączone)',10,4,'2009-11-17 17:56:05','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(122,'Zapisywanie zapytań SQL','STORE_DB_TRANSACTIONS','false','Zapisz zapytania SQL w pliku z czasami przetwarzania stron (tylko PHP4)',10,5,'2008-02-23 18:54:29','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(123,'Używaj pamięci podręcznej do boxów','USE_CACHE','false','Czy używać pamięci podręcznej dla przetrzymywania boxów ?',26229,7,'2008-04-05 15:59:18','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(124,'Katalog pamięci podręcznej','DIR_FS_CACHE','tmp/cache/','Katalog, w którym mają być przechowywane pliki podręczne.',26229,8,'2007-08-24 21:14:28','2003-07-29 13:05:38',NULL,NULL),
(125,'Sposób wysyłania e-maili','EMAIL_TRANSPORT','sendmail','Czy serwer używa lokalnego programu sendmail, czy połączenia SMTP. Użytkownicy serwerów Windows i MacOS powinni zmienić to ustawienie na SMTP.',12,1,'2008-05-21 23:12:31','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'sendmail\', \'smtp\'),'),
(126,'Końce linii w e-mailu','EMAIL_LINEFEED','LF','Sekwencja znaków używana do oddzielania nagłówków poczty.',12,2,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'LF\', \'CRLF\'),'),
(127,'Używaj MIME HTML przy wysyłaniu e-maili','EMAIL_USE_HTML','true','Czy wysyłać pocztę w formacie HTML?',12,3,'2009-01-20 21:56:15','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(128,'Weryfikuj adresy e-mail przez DNS','ENTRY_EMAIL_ADDRESS_CHECK','false','Czy sprawdzać adresy e-mail za pośrednictwem serwera DNS',12,4,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(129,'Wysyłaj e-maile','SEND_EMAILS','true','Czy wysyłać e-maile?',12,5,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(130,'Włącz pobieranie','DOWNLOAD_ENABLED','true','Czy umożliwić pobieranie produktów?',13,1,'2009-01-11 20:34:39','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(131,'Pobieranie poprzez przekierowanie','DOWNLOAD_BY_REDIRECT','false','Czy używać przekierowania do pobierania. Należy to wyłączyć w serwerach nie Uniksowych.',13,2,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(132,'Czas wygaśnięcia (dni)','DOWNLOAD_MAX_DAYS','7','Liczba dni, po której wygasa łącze do ściągnięcia pliku. 0 oznacza brak ograniczeń.',13,3,NULL,'2003-07-29 13:05:38',NULL,''),
(133,'Maksymalna liczba pobrań','DOWNLOAD_MAX_COUNT','5','Ustaw maksymalną liczbę pobrań. 0 oznacza brak dozwolonych pobrań.',13,4,NULL,'2003-07-29 13:05:38',NULL,''),
(134,'Włącz kompresję GZip','GZIP_COMPRESSION','false','Włącz kompresję HTTP GZip.',14,1,'2006-09-21 19:17:11','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(135,'Poziom kompresji','GZIP_LEVEL','5','Ustaw poziom kompresji 0-9 (0 = minimum, 9 = maksimum).',14,2,NULL,'2003-07-29 13:05:38',NULL,NULL),
(136,'Katalog sesji','SESSION_WRITE_DIRECTORY','tmp','Jeżeli sesja wykorzystuje pliki, w tym katalogu będą one przechowywane.',15,1,'2008-02-09 22:23:24','2003-07-29 13:05:38',NULL,NULL),
(137,'Wymuszaj użycie ciasteczek','SESSION_FORCE_COOKIE_USE','true','Włącz użycie sesji, jeżeli ciasteczka są włączone.',15,2,'2008-02-20 21:03:21','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (138,'Sprawdź ID sesji SSL','SESSION_CHECK_SSL_SESSION_ID','False','Sprawdź SSL_SESSION_ID przy każdym pobieraniu strony przez HTTPS.',15,3,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(139,'Sprawdź rodzaj przeglądarki','SESSION_CHECK_USER_AGENT','False','Sprawdź rodzaj przeglądarki klienta przy kazdym pobieraniu strony.',15,4,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(140,'Sprawdź adres IP','SESSION_CHECK_IP_ADDRESS','False','Sprawdź adres IP klienta przy każdym pobieraniu strony.',15,5,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(141,'Zabroń robotom dostępu','SESSION_BLOCK_SPIDERS','True','Zabronienie znanym robotom rozpoczęcia sesji.',15,6,'2007-07-31 19:55:11','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(142,'Ponowne utworzenie sesji','SESSION_RECREATE','false','Ponowne utworzenie sesji i nowego identyfikatora przy logowaniu klienta lub tworzeniu konta (wymagane PHP >=4.1).',15,7,'2008-02-20 21:03:32','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(153,'Domyślny szablon sklepu','DIR_WS_TEMPLATES_DEFAULT','gold_standard','Katalog (w templates/) gdzie znajdują się pliki szablonu sklepu',99,18,'2017-09-02 01:52:14','2005-10-09 11:58:50',NULL,' tep_cfg_pull_down_template_files('),
(154,'Zmiana szablonów','TEMPLATE_SWITCHING_ALLOWED','true','Czy zezwalać użytkonikom na przełączanie szablonów sklepu ?',99,19,'2008-01-21 21:57:26','2005-10-09 11:58:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(155,'Menu szablonów','TEMPLATE_SWITCHING_MENU','false','Czy pokazywać menu przełączania szablonów (głównie używane do testowania nowych szablonów, wymaga włączenia możliwości zmiany szablonów).',99,20,'2008-02-25 23:57:40','2005-10-09 11:58:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5757,'Domyślny pracownik obsługujący zgłoszenia','TICKET_DEFAULT_ADMIN_ID','1','Domyślnie wybierany pracownik odpowiadający na zgłoszenia reklamacyjne.<br><br>Na liście znajdują się użytkownicy zdefiniowanie w panelu administracyjnym.',69,1,'2009-12-19 16:32:33','2009-01-29 14:29:08','tep_get_admin_reply_name','tep_cfg_pull_down_admin_reply('),
(165,'Numer NIP','ENTRY_NIP_MIN_LENGTH','10','Minimalna długość pola NIP',2,7,'2005-12-26 22:20:43','2003-12-02 10:34:04',NULL,NULL),
(200,'Centrowanie sklepu','CENTER_SHOP_ON','on','Centrowanie sklepu Włącz/Wyłącz',99,1,'2004-02-25 14:34:58','2004-02-25 14:34:58',NULL,'tep_cfg_select_option(array(\'on\', \'off\'),'),
(201,'Szerokość sklepu','CENTER_SHOP_WIDTH','980','Podaj w pixelach (np. 760) lub w procentach (np. 100%) jaką szerokość mają mieć strony WWW sklepu.',99,2,'2009-11-30 22:08:20','2004-02-25 14:34:58',NULL,NULL),
(202,'Odstęp od krawędzi','CENTER_SHOP_PADDING','0','Odstęp sklepu od krawędzi przeglądarki',99,9,'2006-08-07 19:08:21','2004-02-25 14:34:58',NULL,NULL),
(203,'Kolor tła','CENTER_SHOP_BACKGROUND_COLOR_OUT','FFFFFF','Kolor tła na zewnątrz sklepu',99,10,'2007-07-13 12:56:56','2004-02-25 14:34:58',NULL,NULL),
(204,'Grubość ramki','CENTER_SHOP_BORDER','0','Grubość obramowania sklepu',99,11,'2005-11-30 22:52:48','2004-02-25 14:34:58',NULL,NULL),
(205,'Kolor ramki','CENTER_SHOP_BORDERCOLOR','b6b7cb','Kolor obranowania sklepu',99,12,'2005-11-28 13:42:05','2004-02-25 14:34:58',NULL,NULL),
(206,'Odstęp modułów','CENTER_SHOP_CELLSPACING','0','Odstęp pomiędzy komórkami modułów sklepu',99,13,'2004-02-25 14:34:58','2004-02-25 14:34:58',NULL,NULL),
(207,'Odstęp tekstu','CENTER_SHOP_CELLPADDING','0','Odstęp tekstu wewnątrz modułów',99,14,'2007-07-02 10:32:15','2004-02-25 14:34:58',NULL,NULL),
(208,'Kolor tła włączony/wyłączony','CENTER_SHOP_BACKGROUND_ON','on','Czy używać kolorów tła ?',99,15,'2004-02-25 14:34:58','2004-02-25 14:34:58',NULL,'tep_cfg_select_option(array(\'on\', \'off\'),'),
(209,'Kolor pomiędzy obramowaniem','CENTER_SHOP_BACKGROUND_COLOR','FFFFFF','Kolor pomiędzy oobramowaniem i zawartością sklepu',99,16,'2006-08-08 13:30:06','2004-02-25 14:34:58',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (230,'Kontakt e-mail','KONTAKT_EMAIL_1','adres@email.pl','Adres email prezentowany w boxie :Kontakt:',1,11,'2008-03-10 13:25:08','2005-04-02 07:07:39',NULL,NULL),
(232,'Kontakt telefon','KONTAKT_TELEFON_1','xxx xxx xxx','Numer telefonu prezentowany w boxie :Kontakt:',1,13,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(233,'Kontakt GSM','KONTAKT_GSM_1','yyy yyy yyy','Numer telefonu komórkowego prezentowany w boxie :Kontakt:',1,18,'2007-07-02 10:29:28','2005-04-02 07:07:39',NULL,NULL),
(234,'Kontakt nr GG','KONTAKT_NR_GG_1','','Numer GG prezentowany w boxie :Kontakt:',1,24,'2006-03-21 13:47:13','2005-04-02 07:07:39',NULL,NULL),
(235,'Kontakt nr Tlen','KONTAKT_NR_TLEN_1','','Login TLEN prezentowany w boxie :Kontakt:',1,30,'2006-01-05 22:20:51','2005-04-02 07:07:39',NULL,NULL),
(236,'Kontakt nr WP','KONTAKT_NR_WP_1','','Login WP prezentowany w boxie :Kontakt:',1,31,'2005-04-02 07:07:39','2005-04-02 07:07:39',NULL,NULL),
(241,'Kontakt nr SKYPE','KONTAKT_SKYPE_1','','Login SKYPE prezentowany w boxie :Kontakt:',1,32,'2009-11-30 22:06:46','2005-04-02 07:07:39',NULL,NULL),
(242,'Kontakt godziny działania','KONTAKT_GODZINY_1','10-18','Godziny otwarcia/działania prezentowane w boxie :Kontakt:',1,38,'2008-05-18 08:10:39','2005-04-02 07:07:39',NULL,NULL),
(243,'Kontakt fax','KONTAKT_FAX_1','','Numer FAXu prezentowany w boxie :Kontakt:',1,12,'2006-01-05 22:28:22','2005-04-02 07:07:39',NULL,NULL),
(17,'Licza miejsc dziesiętnych podatku','TAX_DECIMAL_PLACES','2','Uzupełnienie wartości podatku do określonej liczby miejsc dziesiętnych.',101,72,'2008-04-18 21:09:43','2003-07-29 13:05:38',NULL,NULL),
(1019,'Liczba miejsc dziesiętnych w module Nasza cena','NEW_FIELDS_DECIMAL','2','Podaj liczbę miejsc dziesiętnych w module Nasza cena - oszczędzasz ...',101,75,'2006-01-05 20:11:36','2005-11-11 10:28:21',NULL,NULL),
(257,'Discount Percentage','MODULE_FIXED_PAYMENT_CHG_AMOUNT','2','Amount of Discount.',6,7,NULL,'2005-10-18 13:59:28',NULL,NULL),
(5705,'Strefa dostawy','MODULE_SHIPPING_ODBIOR_OSOBISTY_ZONE','3','Wybierz strefę, dla której ma być stosowany ten sposob dostawy',6,0,NULL,'2009-07-14 21:57:33','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(259,'Listing produktów: sposób wyświetlania','PRODUCTS_LISTING_DISPLAY_MODE','true','Format wyświetlania listy produktów: <br>włączony = każdy produkt w jednym wierszu <br>wyłączony = tabela wiersze x kolumny (wyświetlanie produktów w oknach)',8,18,'2008-11-25 11:13:53','2005-12-14 21:42:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(260,'Czas wyświetlania Nowych produktów','MAX_DISPLAY_TIME_NEW_PRODUCTS','360','Maksymalny czas wyświetlania nowych produktów od momentu dodania ich do sklepu podany w dniach.',3,22,'2009-05-25 10:37:48','2003-07-29 13:05:38',NULL,NULL),
(255,'Moduł kontroli zawartości Meta Tagów','ALLOW_HEADER_TAGS_CONTROLLER','true','Moduł umozliwiający samodzielne zdefiniowanie znaczników meta (tytuł, opis, słowa kluczowe) dla poszczególnych stron sklepu lub poszczególnych produktów. Jeżeli moduł jest wyłączony Meta Tagi są generowane automatycznie na podstawie zawartoś',101,80,'2009-01-04 10:40:37','2005-12-04 08:21:31',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(554,'Lista dostępności produktów','MAX_DISPLAY_PRODUCTS_AVAILABILITY_IN_A_LIST','1','Gdy ilość opcji dostępności produktów przekracza podaną liczbę wyświetlana jest rozwijana lista wyboru',7,6,NULL,'2005-11-06 10:20:09',NULL,NULL),
(555,'Wielkość pola wyboru dostępności produktów','MAX_PRODUCTS_AVAILABILITY_LIST','3','Gdy wartość ustawiona na \'1\' - używana jest rozwijana lista dostępności produktów. W przeciwnym wypadku jest okno wyboru z ilością wierszy taką jak podana liczba',7,7,'2008-03-06 15:11:04','2005-11-06 10:20:09',NULL,NULL),
(556,'Wyświetlaj dostępność produktów','PRODUCT_LIST_PRODUCTS_AVAILABILITY','0','Czy chcesz wyświetlać dostępność produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,13,'2008-03-13 14:39:18','2005-11-06 10:20:09',NULL,NULL),
(880,'Szerokość obrazka w Liście wszystkich produktów','ALLPROD_IMAGE_WIDTH','100','Szerokość (w pikselach) obrazków',4,7,'2007-11-29 22:49:03','2003-07-24 17:45:15',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (881,'Wysokość obrazka w Liście wszystkich produktów','ALLPROD_IMAGE_HEIGHT','100','Wysokość (w pikselach) obrazków',4,8,'2007-11-29 22:49:08','2003-07-24 17:45:15',NULL,NULL),
(1001,'Pokaż model','DISPLAY_MODEL','true','Włącz/Wyłącz wyświetlanie modelu',300,1,'2003-06-04 05:04:11','2003-06-04 04:18:06',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1002,'Edycja pola model','MODIFY_MODEL','true','Pozwól/Zabroń modyfikować pole model',300,2,'2007-02-14 13:15:36','2003-06-04 04:25:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1003,'Edycja nazwy produktu','MODIFY_NAME','false','Pozwól/Zabroń modyfikować nazwę produktu?',300,3,'2003-06-04 05:04:01','2003-06-04 04:30:31',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1004,'Edycja statusu wyświetlania produktu.','DISPLAY_STATUT','true','Pozwól/Zabroń modyfikować status wyświetlania produktu',300,4,'2003-06-04 05:07:11','2003-06-04 05:00:58',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1005,'Edycja wagi produktu','DISPLAY_WEIGHT','true','Pozwól/Zabroń modyfikować wagę produktu?',300,5,'2003-06-04 05:06:44','2003-06-04 04:33:16',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1006,'Edycja ilości produktu','DISPLAY_QUANTITY','true','Pozwól/Zabroń modyfikować ilość produktu',300,6,'2003-06-04 05:06:48','2003-06-04 04:34:34',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1007,'Edycja zdjęcia produktu','DISPLAY_IMAGE','true','Pozwól/Zabroń modyfikować obrazek produktu',300,7,'2006-09-22 15:04:39','2003-06-04 04:36:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1008,'Edycja pola producenta produktu','MODIFY_MANUFACTURER','true','Pozwól/Zabroń modyfikować producenta produktu',300,9,'2005-11-11 09:39:41','2003-06-04 04:37:40',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1009,'Edycja pola podatek','MODIFY_TAX','true','Pozwól/Zabroń modyfikować podatek',300,11,'2005-11-09 21:26:54','2003-06-04 04:31:53',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1010,'Pokaż cenę z podatkiem po najechaniu myszką na produkt','DISPLAY_TVA_OVER','true','Włącz/Wyłącz pokazywanie ceny z podatkiem po najechaniu myszką na produkt',300,12,'2005-11-09 21:27:07','2003-06-04 04:38:45',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1011,'Pokaż cenę z podatkiem podczas edycji produktu','DISPLAY_TVA_UP','true','Włącz/Wyłącz pokazywanie ceny z podatkiem podczas wprowadzania ceny',300,13,'2005-11-11 09:39:49','2003-06-04 04:40:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1012,'Pokaż link do strony podglądu produktu','DISPLAY_PREVIEW','false','Włącz/Wyłącz pokazywanie linku do strony podglądu produktu',300,14,'2007-02-14 13:15:59','2003-06-04 05:15:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1013,'Pokaż link do strony edycji produktu','DISPLAY_EDIT','true','Włącz/Wyłącz pokazywanie linku do strony, na której można edytować produkt w pełnym zakresie',300,15,'2007-02-14 13:16:03','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1014,'Pokaż pole producent produktu','DISPLAY_MANUFACTURER','true','Pokazywać producenta produktu ?',300,8,'2005-11-11 09:39:36','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1015,'Pokaż podatek','DISPLAY_TAX','true','Pokazywać podatek VAT ?',300,10,'2005-11-09 21:26:47','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1017,'Cena detaliczna','DISPLAY_RETAIL_PRICE','true','Włącz/Wyłącz pokazywanie ceny detalicznej?',300,17,'2005-11-12 07:50:42','2003-06-04 05:19:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(18,'Wyświetlaj ceny z podatkiem','DISPLAY_PRICE_WITH_TAX','true','Wyświetlanie cen z podatkiem VAT (włączone) lub dodanie podatku na końcu zamówienia (wyłączone).',101,71,'2009-03-15 20:19:33','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1046,'Szerokość lewej kolumny','BOX_WIDTH_LEFT','181','Jaka ma być szerokość prawej kolumny (w pixelach) ?',99,6,'2009-08-16 21:49:56','0000-00-00 00:00:00','',''),
(1047,'Szerokość prawej kolumny','BOX_WIDTH_RIGHT','181','Jaka ma być szerokość lewej kolumny (w pixelach) ?',99,5,'2009-08-04 22:25:46','0000-00-00 00:00:00','','');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1048,'Lewa kolumna','COLUMN_LEFT_IS_ON','true','Czy chcesz wyświetlać lewą kolumnę ?',99,4,'2008-06-14 18:09:18','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(1049,'Prawa kolumna','COLUMN_RIGHT_IS_ON','true','Czy chcesz wyświetlać prawą kolumnę ?',99,3,'2008-06-14 18:11:02','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(1050,'Lewa kolumna -> prawa','COLUMN_LEFT_IS_ON_RIGHT','false','Czy chcesz, aby zawartość lewej kolumny była wyświetlana z prawej strony ?',99,7,'0000-00-00 00:00:00','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(1051,'Prawa kolumna -> lewa','COLUMN_RIGHT_IS_ON_LEFT','false','Czy chcesz, aby zawartość prawej kolumny była wyświetlana z lewej strony ?',99,8,'0000-00-00 00:00:00','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(4583,'Status zamówienia','MODULE_PAYMENT_COP_ORDER_STATUS_ID','0','Ustaw status zamówienia dla tej metody płatności',6,0,NULL,'2008-03-04 13:07:01','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(4582,'Kolejność wyświetlania','MODULE_PAYMENT_COP_SORT_ORDER','1','Kolejność wyświetlania',6,0,NULL,'2008-03-04 13:07:01',NULL,NULL),
(4581,'Strefa płatności','MODULE_PAYMENT_COP_ZONE','0','Możesz wybrać strefę dla której będzie obowiązywał ten sposób płatności',6,2,NULL,'2008-03-04 13:07:01','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(4580,'Włącz płatność przy odbiorze osobistym','MODULE_PAYMENT_COP_STATUS','True','Czy chcesz włączyć płatność gotówką przy odbiorze osobistym ?',6,1,NULL,'2008-03-04 13:07:01',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5485,'Pokaż podsumę z rabatem','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_SUBTOTAL','false','<b>true</b> - podsuma w zamówieniu będzie uwzględniała udzielony rabat<br><b>false</b> - podsuma zamówienia nie będzie uwzględniała udzielonego rabatu',615,4,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5486,'Sposób wyświetlania podatku VAT w udzielonym rabacie','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_TAX','Brak','W jaki sposób ma być wyświetlany Podatek VAT od rabatu w podsumowaniu zamówienia',615,5,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'Brak\', \'Pokazuj rabat razem z podatkiem\', \'Pokazuj obniżkę podatku w osobnej linii\'), '),
(5489,'Wyświetlanie rabatu dla każdej grupy podatku','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_LINES','false','<b>true</b> - rabat będzie wyświetlany w osobnej linii dla każdej stawki podatku VATr<br><b>false</b> - rabat będzie wyświetlony łącznie dla wszystkich stawek podatku VAT',615,8,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(1085,'Wyświetlaj opis produktu','PRODUCT_LIST_DESCRIPTION','99','0 - wyłączone, 99 - włączone.<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,11,'2006-02-26 22:44:14','0000-00-00 00:00:00',NULL,NULL),
(1086,'Długość tekstu w listach produktów','PRODUCT_LIST_DESCRIPTION_LENGTH','250','Ile znaków ma być wyświetlane w opisach produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,12,'2005-11-29 23:37:54','2002-03-16 18:51:26',NULL,NULL),
(1294,'Wyświetlaj sugerowaną cenę','PRODUCT_LIST_RETAIL_PRICE','0','Czy wyświetlać cenę sugerowaną ?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,6,'2007-02-27 11:55:23','0000-00-00 00:00:00',NULL,NULL),
(1295,'Wyświetlaj pole oszczędzasz','PRODUCT_LIST_SAVE','0','Czy wyświetlać pole oszczędzasz ? Wartość wyświetlana jest w procentach.<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,9,'2007-02-27 11:55:44','0000-00-00 00:00:00',NULL,NULL),
(1296,'Czy wyświetlać cenę sugerowaną producenta','NEW_FIELDS_WHATS_NEW','true','Czy pokazywać sugerowaną cenę w boxach Nowe Produkty, Promocje, Oczekiwane Produkty ?',8,17,'2005-12-12 23:14:11','2005-12-12 22:14:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1297,'Lista wszystkich produktów','ALL_PRODUCTS','true','Czy włączyć katalog wszystkich produktów ?',29,1,'2005-12-15 20:17:23','2005-12-14 21:42:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1298,'Lista produktów: nazwa pliku','ALL_PRODUCTS_FILENAME','allprods.php','Lista wszystkich produktów domyslna nazwa pliku to allprods.php',29,2,NULL,'2005-12-14 21:42:36',NULL,''),
(1308,'Logo sklepu','STORE_LOGO','naglowek.jpg','Nazwa pliku zawierającego logo sklepu.',1,5,'2008-11-30 21:16:48','0000-00-00 00:00:00',NULL,NULL),
(1309,'Ilość cen dla produktu','XPRICES_NUM','1','Ilość cen dla produktu<br><br><b>UWAGA: Zmiejszenie ilości cen powoduje ich usunięcie z tabeli produktów!</b><br><br><b>Każdej grupie używającej skasowanych cen przypisana zostanie cena domyślna.</b>',401,1,'2009-11-30 01:11:52','0000-00-00 00:00:00','tep_update_prices','tep_cfg_pull_down_prices(');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1310,'Pokazuj ceny wszystkim','ALLOW_GUEST_TO_SEE_PRICES','true','Wyświetlanie cen osobom niezalogowanym',401,2,'2009-10-06 20:11:07','2004-03-15 14:59:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1311,'Narzut ceny dla klientów niezalogowanych','GUEST_DISCOUNT','0','Narzut ceny dla klientów niezalogowanych',401,3,'2008-05-10 22:46:39','2004-03-15 14:59:05',NULL,''),
(1312,'Cena promocyjna (ukrywanie ceny produktu)','SPECIAL_PRICES_HIDE','false','Cena promocyjna (ukrywanie ceny produktu)',401,4,'2009-01-16 00:03:26','2004-03-15 14:59:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1313,'Aktywacja nowych klientów','NEW_CUSTOMERS_ENABLED','true','Czy konto klienta ma być aktywane od razu po rejestracji ?',401,5,'2009-01-12 21:35:54','2004-03-15 14:59:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1314,'Długość sesji klienta','SESSION_LENGHT','600','Długość sesji klienta (w sekundach)',15,8,'2006-03-09 12:55:35','0000-00-00 00:00:00',NULL,NULL),
(1315,'Długość sesji administratora','SESSION_LENGHT_ADM','1800','Długość sesji administratora (w sekundach)',15,9,'2006-01-02 15:02:53','0000-00-00 00:00:00',NULL,NULL),
(1318,'Szerokość wyświetlanego obrazka w opisie produktu','DISPLAY_IMAGE_WIDTH','150','Szerokość w pixelach obrazka wyświetlanego na karcie <b>informacje o produkcie</b>',4,9,'2007-12-08 23:15:10','2006-01-03 11:34:11',NULL,NULL),
(1319,'Wysokość wyświetlanego obrazka w opisie produktu','DISPLAY_IMAGE_HEIGHT','150','Wysokość w pixelach obrazka wyświetlanego na karcie <b>informacje o produkcie</b>',4,10,'2007-12-08 23:15:16','2006-01-03 11:34:11',NULL,NULL),
(1320,'Szerokość obrazka w oknie PopUp','POPUP_IMAGE_WIDTH','600','Szerokość w pixelach obrazka wyświetlanego w oknie PopUp. Aby zachować oryginalne wymiary pozostaw to pole puste!',4,11,'2008-04-24 15:24:19','2006-01-03 11:34:11',NULL,NULL),
(1321,'Wysokość obrazka w oknie PopUp','POPUP_IMAGE_HEIGHT','600','Wysokość w pixelach obrazka wyświetlanego w oknie PopUp. Aby zachować oryginalne wymiary pozostaw to pole puste!',4,12,'2008-04-24 18:39:11','2006-01-03 11:34:11',NULL,NULL),
(5706,'Kolejność wyświetlania','MODULE_SHIPPING_ODBIOR_OSOBISTY_SORT_ORDER','3','Kolejność wyświetlania',6,0,NULL,'2009-07-14 21:57:33',NULL,NULL),
(4446,'Wyświetlaj ceny brutto i netto','DISPLAY_PRICE_BRUTTO_NETTO','false','Wyświetlanie jednocześnie cen netto i brutto (włączone) lub tylko ceny określonej w ustawieniach z podatkiem lub bez (wyłączona).',101,70,'2008-07-06 22:29:46','2008-02-23 14:42:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(7,'Porządek sortowania oczekiwanych','EXPECTED_PRODUCTS_SORT','desc','Sposób sortowania produktów oczekiwanych.',101,61,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'asc\', \'desc\'),'),
(5411,'Maksymalne zamówienie','MAXIMUM_ORDERS','false','Czy chcesz włączyć ograniecznie ilości kupowanych towarów jednego rodzaju ?',9,6,'2009-01-20 23:56:13','2006-05-03 10:17:10',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1523,'Wyświetlaj maksymalną ilość produktów do kupienia','PRODUCT_LIST_MAXORDER','0','Czy chcesz włączyć wyświetlanie max. ilości kupowanych towarów z danego asortymentu ?',8,14,'2007-02-27 11:32:45','2006-05-09 11:54:18',NULL,NULL),
(4016,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER','20','Na którym miejscu pokazać?\r\r
',6,2,NULL,'2007-12-01 18:36:50',NULL,NULL),
(1582,'Pokazuj podsumę','MODULE_ORDER_TOTAL_SUBTOTAL_STATUS','true','Pokazuje podsumę na stronie z zamówieniem',6,1,NULL,'2006-05-09 13:46:29',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1583,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER','1','Na którym miejscu pokazać?',6,2,NULL,'2006-05-09 13:46:29',NULL,NULL),
(3940,'Koszt przesyłki','MODULE_ORDER_TOTAL_SHIPPING_STATUS','true','Czy chcesz wyświetlać koszt przesyłki ?',6,1,NULL,'2007-09-11 11:01:10',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3941,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER','10','Na którym miejscu pokazać ?',6,2,NULL,'2007-09-11 11:01:10',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1586,'Bezpłatna przesyłka','MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING','false','Czy włączyć możliwość przesyłki na koszt sprzedawcy ?',6,3,NULL,'2006-05-09 13:46:41',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1588,'Bezpłatna przesyłka do zamówień','MODULE_ORDER_TOTAL_SHIPPING_DESTINATION','national','Zastosuj przesyłkę na koszt sprzedawcy do zamówień',6,5,NULL,'2006-05-09 13:46:41',NULL,'tep_cfg_select_option(array(\'national\', \'international\', \'both\'),'),
(1606,'SEO Adresy URL przyjazne dla wyszukiwarek','SEO_ENABLED','true','Adresy URL przyjazne dla wyszukiwarek. Czy włączyć globalne ustawienia wyświetlania adresów URL przyjaznych dla wyszukiwarek ?',403,0,'2009-03-30 21:37:01','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1607,'Dodanie cPath do adresu URL produktu','SEO_ADD_CPATH_TO_PRODUCT_URLS','true','Włączenie tej opcji powoduje dodanie cPath na końcu adresu URL produktu (np. - jakis-product-p-1.html?cPath=xx).',403,1,'2009-11-20 23:30:36','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1608,'Dodanie kategorii nadrzędnej na początku adresu produktu','SEO_ADD_CAT_PARENT','false','Włączenie tej opcji powoduje wyświetlenie nazwy kategorii nadrzędnej na początku adresu URL produktu (np. - nadrzedna-category-c-1.html).',403,2,'2007-09-17 09:29:40','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1609,'Filtrowanie krótkich wyrazów','SEO_URLS_FILTER_SHORT_WORDS','3','Opcja umożliwia filtrowanie w adresie wyrazów krótszych niż podana wartość.',403,3,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,NULL),
(1610,'Pamięć cache','USE_SEO_CACHE_GLOBAL','true','Ustawienie globalne umożliwiające całkowite wyłączenie pamięci cache.',403,5,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1611,'Pamięć cache dla produktów','USE_SEO_CACHE_PRODUCTS','true','Włączenie/Wyłączenie pamięci cache dla produktów.',403,6,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1612,'Pamięć cache dla kategorii','USE_SEO_CACHE_CATEGORIES','true','Włączenie/Wyłączenie pamięci cache dla kategorii',403,7,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1613,'Pamięć cache dla producentów','USE_SEO_CACHE_MANUFACTURERS','true','Włączenie/Wyłączenie pamięci cache dla producentów',403,8,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1614,'Pamięć cache dla artykułów','USE_SEO_CACHE_ARTICLES','true','Włączenie/Wyłączenie pamięci cache dla artykułów',403,9,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1615,'Pamięć cache dla tematów','USE_SEO_CACHE_TOPICS','true','Włączenie/Wyłączenie pamięci cache dla tematów',403,10,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1616,'Pamięć cache dla stron informacyjnych','USE_SEO_CACHE_INFO_PAGES','true','Włączenie/Wyłączenie pamięci cache dla stron informacyjnych',403,11,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1617,'Pamięć cache dla linków','USE_SEO_CACHE_LINKS','true','Włączenie/Wyłączenie pamięci cache dla stron categorii',403,12,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1618,'Automatyczne przekierowania','USE_SEO_REDIRECT','true','Opcja właczania automatycznego przekierowania nagłówków ze starych adresów do nowych',403,13,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1619,'Sposób przepisywania adresów','SEO_REWRITE_TYPE','Rewrite','Wybór formatu SEO URL',403,14,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'Rewrite\'),'),
(1620,'Tablica konwersji znaków specjalnych','SEO_CHAR_CONVERT_SET','ą=>a,ę=>e,ć=>c,ś=>s,ł=>l, ń=>n,ó=>o,ż=>z,ź=>z, Ą=>A,Ę=>E,Ć=>C,Ś=>S,Ł=>L, Ń=>N,Ó=>O,Ż=>Z,Ź=>Z','Konwersja znaków specjalnych w adresach<br><br>Należy wprowadzić w nastepującycm formacie :: <br><b>char=>conv,char2=>conv2</b>',403,15,'2009-07-13 23:05:41','2006-05-11 12:24:43',NULL,NULL),
(1621,'Usuwanie znaków specjalnych','SEO_REMOVE_ALL_SPEC_CHARS','false','Usuwanie wszystkich znaków specjalnych z adresów URL.',403,17,'2006-07-16 12:20:59','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1622,'Czyszczenie Cache','SEO_URLS_CACHE_RESET','false','Wyczyszczenie pamięci cache dla przyjaznych adresów SEO URL',403,16,'2009-11-20 23:30:49','2006-05-11 12:24:43','tep_reset_cache_data_seo_urls','tep_cfg_select_option(array(\'reset\', \'false\'),'),
(1623,'Zgodność z zaleceniami W3C','SEO_URLS_USE_W3C_VALID','true','Włączenie tej opcji umożliwia generowanie adresów URL zgodnie z zaleceniami W3C',403,4,'2009-03-06 22:52:53','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (8,'Pola sortowania oczekiwanych','EXPECTED_PRODUCTS_FIELD','date_expected','Pole wyznaczające porządek sortowania produktów oczekiwanych.',101,65,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'products_name\', \'date_expected\'),'),
(2999,'Włącz cache stron','ENABLE_PAGE_CACHE','false','Umożliwia włączenie cache w celu przyspieszenia ładowania stron',26229,1,'2009-07-26 22:25:49','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3000,'Czas przetrzymywania stron','PAGE_CACHE_LIFETIME','5','Jak długo mają być przetrzymywane strony (w minutach) ?',26229,2,NULL,'0000-00-00 00:00:00',NULL,NULL),
(3001,'Debug Mode','PAGE_CACHE_DEBUG_MODE','false','Włączenie opcji debuggowania ? Należy korzystać tylko w celu testowania sklepu!  Można również włączyć tę opcje wpisując \"?debug=1\" w adresie strony',26229,3,'2007-08-24 21:16:50','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3002,'Wyłączenie parametrów URL','PAGE_CACHE_DISABLE_PARAMETERS','false','W niektórych przypadkach (np. używania przyjaznych adresów URL) mogą występować błędy przy zapisie stron.',26229,4,'2007-08-24 21:09:00','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3003,'Kasowanie plików','PAGE_CACHE_DELETE_FILES','false','Włączenie opcji spowoduje usunięcie plików cache i ustawi ponownie wartość na wyłączone.',26229,5,'2009-03-30 22:45:17','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3004,'Config Cache Update File','PAGE_CACHE_UPDATE_CONFIG_FILES','none','Jeżeli jest używana kontrybucja Config Cache Update File należy podać pełną ścieżkę do plików.',26229,6,NULL,'0000-00-00 00:00:00',NULL,NULL),
(3210,'Wyłączenie sklepu','DOWN_FOR_MAINTENANCE','false','Włączenie tej opcji powoduje zamknięcie sklepu dla klientów i wyświetlenie informacji o niedostępności sklepu.',0,0,'2006-11-05 10:34:19','2006-08-14 09:22:04',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3211,'Strona informacyjna','DOWN_FOR_MAINTENANCE_PAGE','index-maint.php','Strona do której będą przekierowani klienci podczas zamknięcia sklepu.',0,0,NULL,'2006-08-14 09:22:04',NULL,NULL),
(3212,'Włączyć ostrzeżenie ?','DOWN_FOR_MAINTENANCE_WARNING','false','Włączenie tej opcji powoduje wyświetlenie na stronach sklepu informacji, że sklep zostanie niebawem wyłączony z powodów administracyjnych.',0,0,'2006-11-05 10:34:24','2006-08-14 09:22:04',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3213,'Informacja','DOWN_FOR_MAINTENANCE_MESSAGE','Sklep zostanie wkrótce wyłączony w celach administracyjnych. Przepraszamy za utrudnienia.','Informacja wyświetlona po włączeniu ostrzeżenia',0,0,'2006-08-17 13:45:18','2006-08-14 09:22:04',NULL,'tep_cfg_textarea('),
(3214,'Administracyjny adres IP','DOWN_FOR_MAINTENANCE_IP_ADDRESS','','Adres, z którego jest dostęp do sklepu podczas jego wyłączenia.',0,0,'2006-08-22 21:54:43','2006-08-14 09:22:04',NULL,NULL),
(5493,'Tryb testowy','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DEBUG','false','Sposób użycia: na stronie potwierdzenia zamówienia, użyj w przeglądarce opcji podgląd źródła. <b>Opcja musi być wyłączona w działającym sklepie.</b>',615,12,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5913,'Tablica kosztów (wg cennika Kuriera)','MODULE_SHIPPING_KURIERPOBRANIE_COST_1','9999:25.00','Koszty przesyłki bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(5914,'Dodatkowy stały koszt obsługi wysyłki','MODULE_SHIPPING_KURIERPOBRANIE_HANDLING_1','0','Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(5915,'Do jakiej wysokości zamówienia obowiązuje wysyłka ?','MODULE_SHIPPING_KURIERPOBRANIE_MAKSYMALNIE','999999','Wartość zamówienia do której obowiązuje przesyłka. Powyżej wpisanej wartości przesyłka będzie wyłączona.',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(5916,'Jeżeli nie można określić kosztów wysyłki ?','MODULE_SHIPPING_KURIERPOBRANIE_OFF','False','Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?',6,0,NULL,'2010-03-02 21:57:06',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(3309,'Znak wodny','IMAGE_WATERMARK','false','Włączenie powoduje wyświetlanie znaku wodnego na obrazkach po ich powiększeniu.<br>Aby funkcja ta działała poprawnie w katalogu /images/ należy umieścić obrazkek w formacie PNG, który będzie tworzył znak wodny.',4,15,'2008-10-30 22:35:11','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3324,'Długość kodu weryfikacyjnego','ENTRY_VALIDATION_LENGTH','4','Określa długość kodu weryfikacyjnego. Domyślnie = 5.',741,50,'2008-12-16 22:17:40','2006-07-30 09:00:00',NULL,NULL),
(3325,'Aktywacja zabezpieczeń antyspamowych','ACCOUNT_VALIDATION','true','Włączenie tej opcji powoduje generowanie kodu, który użytkonik musi wprowadzić podczas wypełniania formularzy. Zabezpiecza to przed automatycznym wypełnianiem przez roboty.',741,1,'2006-09-10 11:10:30','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (3326,'Formularz rejestracji użytkownika ','ACCOUNT_CREATE_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zakładania nowego konta. (OPCJONALNY)',741,20,'2007-05-18 13:34:43','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3327,'Formularz edycji konta ','ACCOUNT_EDIT_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza edycji konta (OPCJONALNY)',741,21,'2009-03-30 20:59:24','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3328,'Formularz zmiany hasła ','ACCOUNT_EDIT_PASSWORD_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zmiany hasła (OPCJONALNY)',741,23,'2007-12-14 08:53:07','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3330,'Formularz kontakt z nami','CONTACT_US_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza kontaktowego (OPCJONALNY)',741,24,'2004-08-08 17:00:00','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5358,'Termin płatności','PAYMENT_PERIOD','10','Maksymalna liczba dni od daty wystawienia faktury, w ciągu których nabywca powinien uregulować fakturę',800,120,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(3332,'Formularz pisania recenzji','ACCOUNT_REVIEWS_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza wpisywania recenzji o produktach (OPCJONALNY)',741,26,'2009-05-05 23:08:52','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3935,'Formularz zapytania o przedmiot','ASKAQUESTION_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zapytania o produkt (OPCJONALNY)',741,27,'2007-08-07 10:35:23','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(13,'Pozwól gościowi powiadomić znajomego','ALLOW_GUEST_TO_TELL_A_FRIEND','true','Umożliwienie gościowi powiadomienia znajomego o produkcie.',101,50,'2005-11-13 22:02:02','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3351,'Wyświetlanie zapytań','DISPLAY_QUERIES','false','Wyświetlanie informacji do celów testowych - COOKIE, SESSION, POST, GET w stopce sklepu',10,6,'2009-11-13 20:33:04','2006-09-13 08:40:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3406,'Domyslna klasa podatku','DEFAULT_PRODUCT_TAX_CLASS','4','Ustawienie domyslnej klasy podatku podczas dopisywania produktow.',6,0,'2017-09-12 12:22:48','2006-11-14 11:43:03','','tep_cfg_pull_down_tax_classes('),
(5613,'Podatek','MODULE_ORDER_TOTAL_TAX_STATUS','true','Czy chcesz wyświetlić podatek w zamówieniu ?',6,1,NULL,'2009-05-06 19:43:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5614,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_TAX_SORT_ORDER','3','Na którym miejscu pokazać?\r\r
',6,2,NULL,'2009-05-06 19:43:57',NULL,NULL),
(3450,'Pokaż pole dostępnosć produktu','DISPLAY_AVAILABILITY','true','Pokazywać pole dostęnosci produktu ?',300,19,'2005-11-11 09:39:36','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5909,'Włączenie modułu','MODULE_SHIPPING_KURIERPOBRANIE_STATUS','True','Czy włączyć moduł Kurier za pobraniem ?',6,0,NULL,'2010-03-02 21:57:06',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5910,'Grupa VAT','MODULE_SHIPPING_KURIERPOBRANIE_TAX_CLASS','0','Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.',6,0,NULL,'2010-03-02 21:57:06','tep_get_tax_class_title','tep_cfg_pull_down_tax_classes('),
(14,'Domyślny operator logiczny wyszukiwania','ADVANCED_SEARCH_DEFAULT_OPERATOR','and','Domyślny operator logiczny wyszukiwania słów kluczowych.',101,60,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'and\', \'or\'),'),
(3572,'Formularz powiadamiania znajomych','TELL_FRIEND_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza powiadamiania znajomych o produktach (OPCJONALNY)',741,25,'2004-08-08 17:00:00','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3573,'Szerokość obrazka','ANTI_ROBOT_IMAGE_WIDTH','100','Szerokość obrazka z kodem do wprowadzenia w pixelach. Wpisanie zero powoduje automatyczne dopasowanie.',741,51,'2007-06-23 21:00:45','2007-03-15 23:24:48',NULL,NULL),
(3574,'Wysokość obrazka','ANTI_ROBOT_IMAGE_HEIGHT','20','Wysokość generowanego obrazka w pixelach. Ustawienie wartości zero powoduje automatyczne dopasowanie.',741,52,'2007-06-23 21:00:25','2007-03-15 23:24:48',NULL,NULL),
(3575,'Odstęp pomiędzy literami','ANTI_ROBOT_IMAGE_WHITESPACE','10','Odstęp w poziomie pomiędzy generowanymi znakami na obrazku.',741,55,'2007-06-23 20:59:24','2007-03-15 23:24:48',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (3576,'Margines pionowy','ANTI_ROBOT_IMAGE_TOP_MARGIN','5','Margines pionowy pomiędzy generowanymi znakami, a brzegiem obrazka.',741,56,'2007-06-23 20:59:33','2007-03-15 23:24:48',NULL,NULL),
(3579,'Wielkość czcionki','ANTI_ROBOT_IMAGE_FONT_SIZE','10','Wielkość czcionki ',741,59,'2008-07-07 15:14:16','2007-03-15 23:24:48',NULL,NULL),
(3580,'Kolor tła','ANTI_ROBOT_IMAGE_BACKGROUND_COLOR','FFFFFF','Kolor tła generowanego obrazka.',741,60,'2008-07-07 15:15:02','2007-03-15 23:24:48',NULL,NULL),
(3581,'Kolor tekstu','ANTI_ROBOT_IMAGE_TEXT_COLOR','191919','Kolor generowanego tekstu.',741,61,'2007-06-23 20:53:42','2007-03-15 23:24:48',NULL,NULL),
(3582,'Filtr - szum','ANTI_ROBOT_IMAGE_FILTER_NOISE','true','Filtr dodający szum na obrazku',741,62,'2007-06-23 20:59:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3583,'Filtr - rozmazanie','ANTI_ROBOT_IMAGE_FILTER_SCATTER','false','Filtr powodujący rozmazanie czcionek.',741,63,'2007-03-15 23:24:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3584,'Filtr - przeplot','ANTI_ROBOT_IMAGE_FILTER_INTERLACE','false','Filtr dodający przeplot na generowanym obrazku.</em>',741,64,'2007-03-15 23:24:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3585,'Filtr - szarość','ANTI_ROBOT_IMAGE_FILTER_GREYSCALE','false','Filtr powodujący generowanie obrazka w odcieniach szarości',741,65,'2007-03-15 23:24:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3772,'Szerokość obrazka nagłówka','PDF_MAX_IMAGE_WIDTH','250','Szerokość obrazka nagłówka w PDF.',200,1,'2008-07-02 12:01:47','0000-00-00 00:00:00',NULL,NULL),
(3773,'Wysokość obrazka nagłówka','PDF_MAX_IMAGE_HEIGHT','250','Wysokość obrazka nagłówka w PDF.',200,2,'2008-07-02 12:01:53','0000-00-00 00:00:00',NULL,NULL),
(3774,'Proporcje obrazka nagłówka','PDF_IMAGE_KEEP_PROPORTIONS','true','Czy zachować proporcje obrazka w nagłówku.',200,3,'2005-06-08 20:47:38','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3776,'Logo sklepu w nagłówku','PDF_SHOW_LOGO','false','Czy wyświetlać logo sklepu na nagłówku arkusza PDF ?',200,6,'2009-11-30 22:07:14','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3777,'Ścieżka do pliku logo','PDF_STORE_LOGO','images/oscgold.jpg','Podaj ścieżkę do pliku zawierającego logo sklepu.',200,7,'2008-03-07 12:24:20','0000-00-00 00:00:00',NULL,NULL),
(5452,'Czy pokazywać nazwę producenta na karcie PDF','UPDF_PRODUCENT','1','Definiuje czy generować w PDF nazwę producenta. ',200,55,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5451,'Czy pokazywać numer katalogowy na karcie PDF','UPDF_NR_KATALOGOWY','1','Definiuje czy generować w PDF numer katalogowy produktu. ',200,54,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5450,'Szerokość obrazka produktu w px','UPDF_OBRAZ_WIDTH','150','Definiuje szerokość obrazka/zdjęcia produktu. Wartość należy podać w pikselach.',200,53,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,''),
(5449,'Czy pokazywać datę utworzenia PDF','UPDF_UTWORZONO','1','Definiuje czy generować w PDF datę utworzenia dokumentu. ',200,52,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(3783,'Kolor tekstu w nagłówku','PDF_HEADER_COLOR_TEXT','FFFFFF','Kolor tekstu nagłówka. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #)',200,11,'2009-01-04 00:19:49','0000-00-00 00:00:00',NULL,NULL),
(3784,'Kolor tekstu opisu przedmiotu','PDF_BODY_COLOR_TEXT','000000','Kolor tekstu opisu przedmiotu. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #)',200,12,'2005-06-10 14:54:36','0000-00-00 00:00:00',NULL,NULL),
(3785,'Kolor tła w nagłówku','PDF_HEADER_COLOR_TABLE','474747','Kolor tła w nagłówku. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #)',200,13,'2005-06-10 15:28:11','0000-00-00 00:00:00',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5490,'Wyświetlanie wartości ujemnej ?','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_ALLOW_NEGATIVE','false','Ustawienie opcji true powoduje wyświetlenie ujemnej wartości sumy zamówienia jeżeli ktowa rabatu przekracza wartość zamówienia.',615,9,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3837,'Moduł wyświetlania dodatkowych cech','PRODINFO_ATTRIBUTE_PLUGIN','multiple_dropdowns','Moduł używany do wyświetlania cech produktów na karcie informacyjnej produktu',888001,1,'2009-03-08 22:13:32','2007-05-08 13:51:17',NULL,'tep_cfg_pull_down_class_files(\'pad_\','),
(3838,'Stan magazynowy','PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK','True','Czy wyświetlać informacje o braku danej opcji produktu w magazynie ?',888001,10,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(3839,'Oznaczenie stanów magazynowych','PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK','Right','W którym miejscu wyświetlać informacje o braku danej opcji w magazynie ?',888001,20,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'None\', \'Right\', \'Left\'),'),
(3840,'Komunikat o braku opcji','PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE','True','Czy wyświetlać dodatkową informację o braku wybranej opcji w magazynie ?.',888001,30,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(3841,'Dodawanie do koszyka','PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK','True','Czy uniemozliwić dodawanie do koszyka towarów, których w wybranej opcji nie ma w magazynie ?',888001,40,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(3843,'Resampling','THUMBNAIL_USE_RESAMPLING','true','Ustawienie tej wartości na włączone powoduje użycie resamplingu (transformacja bitmapy polegająca na zmianie liczby jej pikseli) w wyniku czego miniaturki mają lepszą jakość. (funkcja ta jest niedostepna w biblitece GD < 2.0.1)',100,0,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3844,'True Color','THUMBNAIL_TRUE_COLOUR','true','Tworzenie miniaturek w trybie true color. Zapewnia lepszą jakość tworzonych miniaturek. Ustaw wyłączone, jeżeli posiadasz bibliotekę GD < 2.0.1 lub jeżeli mają być tworzone przeźroczyste obrazki.',100,1,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3845,'Tworzenie GIF jako JPG','THUMBNAIL_OUTPUT_JPEG','false','Tworzenie miniaturek w formacie JPG z plików GIF lub PNG. UWAGA ! Przeźroczystość plików źrodłowych zostanie utracona. Wymagana biblioteka GD > 1.6. Ustaw Kolor tła w następnej opcji jeżeli ta opcja jest ustawiona jako włączona.',100,2,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3846,'Kolor tła (GIF jako JPEG)','THUMBNAIL_BACKGROUND_MATTE','255,255,255','Ustawienie kolorów tła w formacie RGB podczas tworzenia miniaturek JPG z plików GIF w formacie 255,255,255 (oddzielane przecinkami).',100,3,NULL,'2007-05-17 10:54:12',NULL,NULL),
(3847,'Zapisywanie obrazków na serwerze','THUMBNAIL_CACHE_SERVER','true','Zapisywanie obrazków na serwerze. Zalecana wartość - włączone. Tworzone miniaturki są zapisywane na dysku powodując mniejsze obciążenie procesora.',100,4,'2007-05-17 11:32:04','2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3848,'Ścieżka do miniaturek','THUMBNAIL_PATH','thumbnails/','Ścieżka do katalogu, w którym mają być zapisywane miniaturki. Jeżeli miniaturki mają być tworzone bezpośrednio w katalogu /images/ należy pozostawić to pole puste. Wprowadź nazwę katalogu, np. \'thumbnails/\' jeżeli miniaturki mają być zapisywane w podkatal',100,5,'2009-01-12 21:14:13','2007-05-17 10:54:12',NULL,NULL),
(3849,'Cache obrazków w przeglądarce','THUMBNAIL_CACHE_BROWSER','true','Umożliwia zapisywanie obrazków lokalnie w cache przeglądarki. Zapewnia zmniejszenie transferu podczas przeglądania stron. Zalecane ustawienie - włączone.',100,6,'2007-05-17 11:31:57','2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3850,'Komprecja JPEG','THUMBNAIL_JPEG_COMPRESSION','100','Ustawienie jakości generowanych miniaturek w formacie JPEG. Domyślna wartość 100. Wartość zalecana 70.',100,7,'2007-05-17 11:32:56','2007-05-17 10:54:12',NULL,NULL),
(3851,'Powiększanie obrazków','THUMBNAIL_ALLOW_LARGER','false','Tworzenie miniaturek wówczas, gdy obrazek źródłowy jest mniejszy niż docelowa wielkość miniaturki. Utworzona w ten sposób miniaturka może mieć gorszą jakość.',100,8,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3852,'Pokaż oryginał','THUMBNAIL_SHOW_ORIGINAL','true','Jeżeli Powiększanie obrazków jest włączone, umożliwia wyświetlanie oryginalnych obrazków.',100,9,'2008-05-30 14:36:05','2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3930,'Użyj obrazków jako cechy','OPTIONS_AS_IMAGES_ENABLED','false','Włączenie opcji umożliwia wykorzystanie obrazków jako cechy dodatkowe produktów',888001,50,'2008-06-10 12:44:38','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3931,'Ilość obrazków w wierszu','OPTIONS_IMAGES_NUMBER_PER_ROW','3','Maksymalna ilość obrazków wyswietlanych w jednym wierszu',888001,51,'2007-10-10 14:57:50','0000-00-00 00:00:00',NULL,NULL),
(3932,'Szerokość obrazka','OPTIONS_IMAGES_WIDTH','50','Szerokość obrazka wyświetlanego jako cecha produktu',888001,52,'2007-07-03 12:11:10','0000-00-00 00:00:00',NULL,NULL),
(3933,'Wysokość obrazka','OPTIONS_IMAGES_HEIGHT','50','Wysokość obrazka wyświetlanego jako cecha produktu',888001,53,'2007-07-03 12:11:16','0000-00-00 00:00:00',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (3934,'Powiększanie obrazka','OPTIONS_IMAGES_CLICK_ENLARGE','true','Czy włączyć możliwość powiększania obrazka cechy produktu ?',888001,54,'2008-05-02 15:06:13','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3775,'Znak wodny','PDF_SHOW_WATERMARK','true','Czy drukowac znak wodny na arkuszu PDF ?',200,5,'2009-03-06 22:10:11','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(5448,'Kolor tekstów informacyjnych karcie produktu PDF','UPDF_KOLOR_TABELI','3C31A7','Definiuje kolor tekstów informacyjnych na karcie produktu PDF (stan magazynowy, producent, numer katalogowy). Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #).',200,51,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,''),
(5447,'Kolor ceny na karcie produktu PDF','UPDF_KOLOR_CENA','FF0000','Definiuje kolor ceny na karcie produktu PDF. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #).',200,50,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,''),
(3974,'Moduł promocji Polecony-Nagrodzony','PROMO_POLECONY_STATUS','false','Czy włączyć moduł promocji Polecony-Nagrodzony - UWAGA !!! do poprawnego działania modułu musi być również włączony moduł Kuponów rabatowch (w menu Moduły/Podsumowanie zamówienia)',150,1,'2010-03-02 21:58:28','2007-10-31 08:51:01',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3975,'Okres ważności kuponu rabatowego','PROMO_POLECONY_OKRES','60','Okres ważności kuponu rabatowego przyznanego w promocji Polecony-Nagrodzony',150,2,'2006-04-05 09:15:16','2007-10-29 13:05:38',NULL,NULL),
(3976,'Kwota rabatu','PROMO_POLECONY_RABAT','30.00','Kwota rabatu przyznawanego w ramach promocji Polecony-Nagrodzony',150,3,'2009-03-15 18:57:24','2007-10-29 13:05:38',NULL,NULL),
(3977,'Wyświetlanie boxu promocji Polecony-Nagrodzony','BOX_POLECONY_COLUMN','left','W której kolumnie ma być wyświetlany box informacyjny promocji Polecony-Nagrodzony',150,4,'2007-10-31 09:15:16','2007-10-31 09:05:38',NULL,'tep_cfg_select_option(array(\'left\', \'right\'),'),
(3978,'Status zamówienia do promocji Polecony-Nagrodzony','PROMO_POLECONY_ORDER_STATUS_ID','4','Ustaw status zamówienia, który upoważnia do polecenia sklepu w promocji Polecony-Nagrodzony',150,5,'2007-10-31 12:53:52','2007-10-31 09:05:38','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(3979,'Formularz promocji Polecony-Nagrodzony','POLECONY_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza polecającego sklep w promocji Polecony-Nagrodzony (OPCJONALNY)',741,26,'2007-10-31 09:00:00','2007-10-31 09:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(12,'Wyświetl koszyk po dodaniu produktu','DISPLAY_CART','false','Wyświetlanie koszyka po dodaniu do niego produktu (lub powrót do wybieranego produktu).',101,20,'2009-01-24 19:23:31','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(4154,'Włączyć kontrolę poprawności adresów SEO ?','FWR_VALIDATION_ON','true','Włączyć kontrolę poprawności adresów SEO - moduł kontroluje czy są poprawnie generowane adresy SEO',160,1,'2008-02-13 11:37:34','2008-02-13 11:36:19',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(9,'Przełączenie na walutę danego języka','USE_DEFAULT_LANGUAGE_CURRENCY','false','Automatyczne przełączanie na domyślną walutę wybranego języka przy jego zmiane.',101,30,'2006-08-07 22:26:07','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(16,'Pokaż ilość produktów w kategorii','SHOW_COUNTS','false','Rekurencyjne obliczanie liczby produktów w każdej kategorii.',101,40,'2006-06-22 23:02:45','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(4594,'Sklep jako katalog produktów','USE_SHOP_AS_CATALOG','false','Wyłączenie w sklepie możliwości dokonywania zakupów - sklep pełni funkcję katalogu produktów',101,10,'2009-03-26 23:23:34','2008-04-08 12:00:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5349,'Logo','LOGO_FILE','images/oscgold_pdf.jpg','Ścieżka dostępu do pliku z logiem',800,110,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5345,'Rachunek bankowy','NR_RACHUNEK','Nr rachunku bankowego','Nr rachunku bankowego',800,80,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5344,'Bank','BANK_NAZWA','Nazwa banku','Nazwa banku',800,70,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5343,'NIP firmy','NIP_FIRMA','Nip firmy','Nip firmy',800,60,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5342,'Kod pocztowy','KOD_POCZTOWY','Kod pocztowy','Kod pocztowy',800,50,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5341,'Miasto','MIASTO','Miasto - siedziba Twojej firmy','Miasto - siedziba Twojej firmy',800,40,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5339,'Firma','FIRMA','Nazwa Twojej firmy','Nazwa Twojej firmy',800,20,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5340,'Ulica','ULICA','Ulica - siedziba Twojej firmy','Ulica - siedziba Twojej firmy',800,30,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5338,'Dodaj do numeru zamówienia','FIRST_ORDER_NR','99','Liczba, która zawsze będzie dodawana do prawdziwego numeru zamówienia',800,19,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5337,'Dodaj do numeru klienta','FIRST_CLIENT_NR','99','Liczba, która zawsze będzie dodawana do prawdziwego numeru klienta',800,18,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5331,'Prefix','PREFIX_FN','FV/','Prefix drukowany przed numerem faktury',800,1,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5332,'Format numeru faktury','FORMAT_FN','%04d','Wzorzec formatowania numeru faktury (jak dla funkcji sprintf)',800,2,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5333,'Suffix','SUFFIX_FN','/%m/%Y','Suffix drukowany za numerem faktury',800,10,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5334,'Ciaglosc numeracji','CONTINUE_NUMERATION','true','Czy wraz z rozpoczęciem nowego roku kalendarzowego zachować ciągłość numeracji faktur?',800,12,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5335,'Pierwszy nr faktury','FIRST_NR','99','Numer od którego rozpocznie się numeracja faktury',800,15,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5336,'Pierwszy nr faktury PRO FORMA','FIRST_PROFORMA_NR','99','Numer od którego rozpocznie się numeracja faktury PRO FORMA',800,16,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(4638,'Installed Modules','MODULE_GIFTWRAP_INSTALLED','','This is automatically updated. No need to edit.',6,0,'2009-11-17 17:55:35','2008-05-21 09:21:12',NULL,NULL),
(4659,'Wyświetlanie PopUp jako Lytebox','FOTO_OPCJE','true','Wyświetlanie powiększonych obrazków przez Lytebox ',4,16,'2009-03-30 15:06:18','2008-05-23 12:00:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(4658,'Hasło','EMAIL_SMTP_PASSWORD','haslo','Hasło użytkownika jeżeli jest wymagana autentykacja.',12,15,'2008-05-21 23:14:38','2008-05-21 11:42:34',NULL,NULL),
(4657,'Nazwa konta','EMAIL_SMTP_USERNAME','nazwa_konta','Nazwa użytkownika jeżeli jest wymagana autentykacja.',12,14,'2008-05-21 23:14:34','2008-05-21 11:42:34',NULL,NULL),
(4656,'Autentykacja SMTP','EMAIL_SMTP_ACTIVE_PASSWORD','true','Czy serwer SMTP wymaga autentykacji.',12,13,'2008-05-21 23:12:15','2008-05-21 11:42:34',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(4654,'Serwer SMTP EHLO / HELO Name','EMAIL_SMTP_HELO_SERVER','nazwa.pl','Nazwa serwera na jaki będą wysyłane komendy SMTP EHLO / HELO. JEst to adres serwera na którym mamy ustawione SMTP.',12,11,'2008-05-21 23:14:29','2008-05-21 11:42:34',NULL,NULL),
(4655,'Port serwera SMTP','EMAIL_SMTP_PORT_SERVER','25','Numer portu serwera SMTP. W większości przypadków jest to port 25.',12,12,NULL,'2008-05-21 11:42:34',NULL,NULL),
(4653,'Adres serwera SMTP','EMAIL_SMTP_HOST_SERVER','serwer.nazwa.pl','Pelen adres serwera SMTP przez który będzie wysyłana poczta.',12,10,'2008-05-21 23:14:22','2008-05-21 11:42:34',NULL,NULL),
(5774,'Ścieżka do programu GZip','LOCAL_EXE_GZIP','/usr/bin/gzip','Scieżka do programu umożliwiającego kompresję GZip.',14,5,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5920,'Status zamówienia','MODULE_PAYMENT_POBRANIEKURIER_ORDER_STATUS_ID','0','Ustaw status zamówienia dla tej metody płatności.',6,0,NULL,'2010-03-02 21:57:31','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5917,'Włącz płatność za pobraniem','MODULE_PAYMENT_POBRANIEKURIER_STATUS','True','Czy chcesz włączyć płatność przy odbiorze za przesyłkę Kurierem ?',6,1,NULL,'2010-03-02 21:57:31',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5918,'Strefa płatności','MODULE_PAYMENT_POBRANIEKURIER_ZONE','0','Możesz wybrać strefę dla której będzie obowiązywał ten sposób płatności.',6,2,NULL,'2010-03-02 21:57:31','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5919,'Kolejność wyświetlania','MODULE_PAYMENT_POBRANIEKURIER_SORT_ORDER','3','Kolejność w jakiej zostanie wyświetlony moduł.',6,0,NULL,'2010-03-02 21:57:31',NULL,NULL),
(5906,'Jeżeli nie można określić kosztów wysyłki ?','MODULE_SHIPPING_KURIER_OFF','False','Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?',6,0,NULL,'2010-03-02 21:56:55',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5902,'Włączenie modułu','MODULE_SHIPPING_KURIER_STATUS','True','Czy włączyć moduł Kuriera ?',6,0,NULL,'2010-03-02 21:56:55',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5903,'Grupa VAT','MODULE_SHIPPING_KURIER_TAX_CLASS','0','Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.',6,0,NULL,'2010-03-02 21:56:55','tep_get_tax_class_title','tep_cfg_pull_down_tax_classes('),
(5904,'Strefa dostawy','MODULE_SHIPPING_KURIER_ZONE','0','Wybierz strefę, dla której ma być stosowany ten sposob dostawy',6,0,NULL,'2010-03-02 21:56:55','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5905,'Sortowanie','MODULE_SHIPPING_KURIER_SORT_ORDER','2','Kolejność wyświetlania wśród innych modułów wysyłki.',6,0,NULL,'2010-03-02 21:56:55',NULL,NULL),
(5119,'Przelew bankowy','MODULE_PAYMENT_PL_BANKTRANSFER','True','Czy chcesz akceptować zapłatę przelewem bankowym ?',6,3,NULL,'2008-10-22 12:14:02',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5120,'Nazwa Banku','MODULE_PAYMENT_PL_BANKNAME','Tutaj wpisz nazwę banku','Nazwa Banku',6,1,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5121,'Nazwa konta','MODULE_PAYMENT_PL_ACCOUNT_HOLDER','Wpisz nazwę właściciela konta','Nazwa właściciela konta',6,1,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5122,'Numer konta','MODULE_PAYMENT_PL_IBAN','00 0000 0000 0000 0000 0000 000','Numer Twojego konta',6,1,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5123,'Strefa płatności','MODULE_PAYMENT_PL_BANKTRANSFER_ZONE','0','Jeżeli jest wybrana strefa - płatność będzie stosowana tylko do wybranej strefy.',6,2,NULL,'2008-10-22 12:14:02','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5124,'Status zamówienia','MODULE_PAYMENT_PL_BANKTRANSFER_ORDER_STATUS_ID','0','Ustaw Status Zamówienia',6,0,NULL,'2008-10-22 12:14:02','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5125,'Kolejność wyświetlania','MODULE_PAYMENT_PL_BANKTRANSFER_SORT_ORDER','2','Kolejność wyświetlania.',6,0,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5139,'Wersja językowa sklepu','USE_BROWSER_LANG','false','Czy sklep ma się uruchamiać domyślnie w wersji językowej takiej jaką ma przeglądarka (włączone), czy w takiej jak jest ustawiony domyślny język (wyłączone) ?',101,150,'2008-06-18 09:30:06','2008-04-08 12:00:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5413,'Szacunkowa wartość zamówienia','CARTSHIP_SHOWOT','true','Czy wyświetlać na stronie koszyka szacunkową wartość zamówienia wraz z kosztami dostawy ?',19,2,'2009-01-28 23:11:04','2004-06-29 07:10:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5414,'Lista krajów','CARTSHIP_SHOWCDD','false','Czy wyświetlać listę krajów do obliczenia szacunkowych kosztów dostawy ?',19,6,'2009-01-28 23:12:42','2004-06-29 07:10:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5412,'Szacunkowe koszty dostawy','CARTSHIP_ONOFF','true','Czy wyświetlać na stronie koszyka szacunkowe koszty dostawy ?',19,1,'2009-03-08 00:40:38','2004-06-29 07:10:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5046,'Obsługa cookie','COOKIE_TMP','PGI+MjAwNS0yMDEwIEthbWVsaWEtTmV0IC0gbWdyIGluxbwuIEphY2VrIEtyeXNpYWsgJiBKTUs8L2I+PGJyPkNvcHlyaWdodCAmY29weTsgPGEgaHJlZj0iaHR0cDovL3d3dy5vc2Nnb2xkLmNvbSI+d3d3Lm9zY0dvbGQuY29tPC9hPg==','',9999,NULL,NULL,'0000-00-00 00:00:00',NULL,NULL),
(5222,'Produktów w przechowalni','MAX_DISPLAY_WISHLIST_PRODUCTS','12','Ile produktów pokazywać na jednej stronie przechowalni',12954,0,'2008-12-25 23:21:33','2008-12-25 23:21:33',NULL,NULL),
(5223,'Produktów w boksie przechowalni','MAX_DISPLAY_WISHLIST_BOX','1','Ile produktów pokazywać w boksie informacyjnym zanim zmieni się w licznik',12954,0,'2008-12-27 21:20:12','2008-12-25 23:21:33',NULL,NULL),
(5224,'Adresy e-mail','DISPLAY_WISHLIST_EMAILS','3','Ile adresów e-mail wyświetlać, kiedy klienci przesyłają listę życzeń z przechowalni',12954,0,'2008-12-25 23:21:57','2008-12-25 23:21:33',NULL,NULL),
(5225,'Przekierowanie z przechowalni','WISHLIST_REDIRECT','Tak','Czy chcesz przekierowywać do strony produktu, kiedy klient dodaje produkt do przechowalni?',12954,0,'2008-12-25 23:34:07','2008-12-25 23:21:33',NULL,'tep_cfg_select_option(array(\'Tak\', \'Nie\'),'),
(5226,'Włącz System punktów','USE_POINTS_SYSTEM','false','Czy włączyć moduł żeby klienci mogli zbierać punkty za wykonane zakupy ?',16,1,'2009-11-30 22:07:03','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5227,'Włącz realizację punktów','USE_REDEEM_SYSTEM','true','Czy umożliwić klientom możliwość kupowania za punkty ?',16,2,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5228,'Punkt za 1 jednostkę płatniczą (np 1 zł)','POINTS_PER_AMOUNT_PURCHASE','1','Liczba punktów którą otrzymuje klient za każdy wydany 1 zł (lub inną domyślną walutą zgodnie z ustawieniami)',16,3,'2009-07-13 23:17:46','2008-12-29 12:21:42',NULL,NULL),
(5229,'Wartość 1 punktu przy płaceniu przez klienta','REDEEM_POINT_VALUE','0.1','Wartość 1 punktu przy realizacji zamówienia przez klienta np 0.1 - czyli 10 gr (lub inną domyślną walutą zgodnie z ustawieniami)',16,4,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5230,'Ilość miejsc dziesiętnych','POINTS_DECIMAL_PLACES','0','Ilość miejsc dzisiętnych w liczbie punktów. Wartość 0 (zero) będzie powodowała zaokrąglanie sumy punktów do liczby całkowitej.',16,5,'2009-03-26 15:32:49','2008-12-29 12:21:42',NULL,NULL),
(5232,'Automatycznie wygasanie punktów','POINTS_AUTO_EXPIRES','','Ustaw ilość miesięcy przez ile punkty będą ważne. Po tym okresie punkty na koncie klienta zostaną skasowane. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,7,'2009-11-29 22:02:02','2008-12-29 12:21:42',NULL,NULL),
(5233,'Ilość dni do wygaśnięcia punktów','POINTS_EXPIRES_REMIND','30','Ile dni przed wygaśnięciem punktów klient ma zostać poinformowany. Aby opcja działa w połączniu z Automatycznym wygasaniem punktów. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,8,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5234,'Punkty za koszt wysyłki','USE_POINTS_FOR_SHIPPING','false','Czy włączyć naliczanie punktów za koszt przesyłki ?',16,9,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5235,'Punkty za podatek VAT','USE_POINTS_FOR_TAX','true','Czy włączyć naliczanie punktów od kwoty brutto (razem z VAT) ?',16,10,'2009-07-13 23:17:58','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5236,'Punkty za produkty w promocji','USE_POINTS_FOR_SPECIALS','true','Czy włączyć naliczanie punktów za produkty w promocji ?',16,11,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5237,'Punkty za zakupy z płatnością punktami','USE_POINTS_FOR_REDEEMED','true','Czy włączyć naliczanie punktów za zakupy gdzie płatność jest za pomocą punktów ? Kiedy opcja jest wyłączona punkty nie będą naliczne, nawet jeżeli tylko część zamówienia jest płacona punktami.',16,12,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5238,'Punkty za napisanie recenzji do produktu','USE_POINTS_FOR_REVIEWS','50','Liczba punktów którą otrzymuje klient za napisanie recenzji do produktu. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,13,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5239,'Punkty dla Systemu Poleceń','USE_REFERRAL_SYSTEM','100','Liczba punktów jaką otrzymuje klient za polecenie sklepu. Jeżeli nowy klient przy zamówieniu poda adres email polecającego, polecający otrzyma punkty. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,14,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5240,'Punkty tylko za konkretny produkt','RESTRICTION_MODEL','','Ograniczenie kupowania za punkty do produktu o konkretnym numerze katalogowym. Należy podać nr katalogowy produktu. Aby wyłączyć tą opcje należy pozostawić pole puste. ',16,15,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5241,'Punkty dla produktów o ID','RESTRICTION_PID','','Ograniczenie kupowania za punkty do produktów o określonym ID. Należy podać ID produktów oddzielone przecinkami. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,16,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5242,'Punkty dla kategorii o ID','RESTRICTION_PATH','','Ograniczenie kupowania za punkty produktów do kategorii o określonym ID. Należy podać ID kategorii oddzielone przecinkami. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,17,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5243,'Kupowanie produktów w promocji','REDEMPTION_DISCOUNTED','false','Blokada kupowania za punkty produktów które są w promocji. Wyłączenie opcji powoduje, że za punkty można kupić wszystkie produkty.',16,18,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5244,'Minimalna ilość punktów aby zrobić zakupy','POINTS_LIMIT_VALUE','200','Minimalna ilość punktów jaką musi posiadać klient na swoim koncie żeby móc je wykorzystać. Aby wyłączyć tą opcje należy wpisać 0.',16,19,'2009-03-26 15:33:08','2008-12-29 12:21:42',NULL,NULL),
(5245,'Maksymalna ilość punktów do wydania przy zamówieniu ','POINTS_MAX_VALUE','1000','Maksymalna ilość punktów jaką może wykorzystać klient przy zamówieniu. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,20,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5246,'Minimalna wartość zamówienia','POINTS_MIN_AMOUNT','','Minimalna wartość zamówienia jaka musi być żeby można było kupić za punkty. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,21,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5247,'Ilość punktów przyznawana dla nowych klientów po rejestracji','NEW_SIGNUP_POINT_AMOUNT','0','Liczba punktów jaka ma być automatycznie dopisywana do kont nowo zarejestrowanych klientów. Aby wyłączyć tą opcje należy wpisać 0.',16,22,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5248,'Maksymalna ilość pozycji do wyświetlania','MAX_DISPLAY_POINTS_RECORD','20','Maksymalna ilość pozycji jaka ma się wyświetlać na stronie my_points.php - lista operacji klienta w jego koncie.',16,23,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5249,'Informacja o punktach na Karcie Produktu','DISPLAY_POINTS_INFO','true','Czy wyświetlać informację o punktach na karcie produktu ?',16,24,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5250,'Ewidencja zrealizowanych punktów','DISPLAY_POINTS_REDEEMED','true','Czy chcesz prowadzić ewidencją wszystkich zrealizowanych punktów ?',16,25,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5254,'Płatność kartą kredytową','ORDER_EDITOR_CREDIT_CARD','Other','Jeżeli zostanie wybrany ten sposób płatności Edytor Zamówień wyświetli dodatkowe pola do wpisania informacji o karcie kredytowej.',72,5,'2009-01-03 21:56:35','2008-12-29 14:36:45',NULL,'tep_cfg_pull_down_payment_methods('),
(5359,'Test','PDF_INVOICE_TEST','true','Ustawia tryb testowania - tworzone faktury nie mają numeru. Tryb przeznaczony do testowania faktur, pozycjonowania loga, kontroli poprawnosci stałych elementów.',800,130,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5361,'Dostawa','DOSTAWA','true','Czy do faktury automatycznie dopisywac koszt wysyłki, takeij jaką klient wybrał podczas finalizacji zakupów w sklepie?',800,140,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5370,'Archiwum faktur','POLISH_INVOICE_PDF_ARCHIVE','backups/invoices/','Katalog przechowujący faktury PDF',800,190,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5371,'Klient - faktura PRO FORMA','CUSTOMER_PROFORMA','true','Czy klient może wygenerować fakturę PRO FORMA do swojego zamówienia?',800,200,'2009-09-07 19:46:34','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5372,'Klient - faktura DUPLIKAT','CUSTOMER_DUPLIKAT','true','Czy klient może wygenerować fakturę DUPLIKAT do swojego zamówienia?',800,210,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5410,'Minimalna kwota zamówienia','PROMO_POLECONY_MIN_ORDER','50.00','Minimalna kwota zamówienia w celu wykorzystania rabatu przyznawanego w ramach promocji Polecony-Nagrodzony',150,3,'2008-10-05 22:33:30','2007-10-29 13:05:38',NULL,NULL),
(5401,'Sprawdzanie pustych meta tagów','HEADER_TAGS_CHECK_TAGS','false','Czy wyświetlać informacje o pustych meta tagach w produktach, kategoriach i producentach ?',543,4,'2009-06-05 21:36:48','2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5402,'Informacja o błędnych prawach do zapisu','HEADER_TAGS_DIABLE_PERMISSION_WARNING','true','Czy pokazywać informacje o błędnych prawach do zapisu do pliku includes/header_tags.php jeżeli są źlu ustawione ?',543,6,'2009-06-05 21:36:53','2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5403,'Wyświetlanie pomocy','HEADER_TAGS_DISPLAY_HELP_POPUPS','true','Czy wyświetlać pomocnicze opisy pól podczas wprowadzania danych ?',543,7,NULL,'2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5404,'Nasycenie słów kluczowych','HEADER_TAGS_KEYWORD_DENSITY_RANGE','0.01,0.06','Zakres nasycenia występowania słów kluczowych podczas dynamicznego generowania meta tagu keywords. Wprowadź wartości graniczne rozdzielone przecinkiem',543,9,'2009-06-05 23:01:38','2009-01-09 22:39:48',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5405,'Znak rozdzielający opisy','HEADER_TAGS_SEPARATOR_DESCRIPTION','-','Wprowadź znak rozodzielający sekcje w opisie strony. Oddziela np. tytuł - kategoria - produkt.',543,10,NULL,'2009-01-09 22:39:48',NULL,NULL),
(5406,'Znak rozdzielający słowa kluczowe','HEADER_TAGS_SEPARATOR_KEYWORD',',','Znak rozdzielający słowa kluczowe w znaczniku meta keywords.',543,11,NULL,'2009-01-09 22:39:48',NULL,NULL),
(5407,'Status zamówienia wznawiający możliwość pobierania','DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE','5','Status zamówienia, który powoduje zostaje ponownie ustawiony okres i ilość możliwych pobrań plików',13,153,'2009-01-11 22:49:54','0000-00-00 00:00:00','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5408,'Informacja o pobieraniu','DOWNLOADS_CONTROLLER_ON_HOLD_MSG','<font color=\"FF0000\">UWAGA: Pobranie pliku jest niemozliwe przed potwierdzeniem płatności</font>','Informacja o możliwości pobierania pliku',13,155,'2009-01-11 21:50:13','0000-00-00 00:00:00',NULL,NULL),
(5409,'Status zamówienia do pobrania pliku','DOWNLOADS_CONTROLLER_ORDERS_STATUS','3','Status zamówienia umożliwiający pobieranie pliku',13,152,'2009-01-11 21:50:33','0000-00-00 00:00:00','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5453,'Czy pokazywać informacje o dostępności na karcie PDF','UPDF_DOSTEPNOSC','1','Definiuje czy generować w PDF informację o dostępności produktu. ',200,56,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5454,'Czy pokazywać stan magazynowy na karcie PDF','UPDF_STAN_MAGAZYNOWY','1','Definiuje czy generować w PDF informację na temat stanu magazynowego produktu.',200,57,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5455,'Czy pokazywać średnią ocenę na karcie PDF','UPDF_SREDNIA_OCENA','1','Definiuje czy generować w PDF informację na temat oceny produktu. ',200,58,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5456,'Czy pokazywać zdjęcie produktu na karcie PDF','UPDF_OBRAZ_PRODUKTU','1','Definiuje czy generować w PDF zdjęcie produktu. ',200,59,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5457,'Tekst znaku wodnego','UPDF_ZNAK_NAZWA','watermark','Definiuje tekst znaku wodnego. Aby opcja zadziałała musi być właczone wyświetlanie znaku wodnego.',200,60,'2009-11-30 22:07:37','2009-03-06 22:09:03',NULL,''),
(5615,'Identyfikator sklepu Skąpiec.pl','STORE_SKAPIEC_ID','123456','Jest to numer sklepu w serwisie Skapiec.pl.<br>Powinieneś go otrzymać od Skapiec.pl',260,10,'2009-05-09 09:39:04','0000-00-00 00:00:00',NULL,NULL),
(5616,'Nick','ENTRY_NICK_MIN_LENGTH','2','Minimalna długość Nicku.',2,1,NULL,'2009-05-10 13:05:38',NULL,NULL),
(5601,'Kontakt telefon GSM 4','KONTAKT_GSM_5','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,22,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5599,'Kontakt telefon GSM 2','KONTAKT_GSM_3','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,20,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5600,'Kontakt telefon GSM 3','KONTAKT_GSM_4','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,21,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5597,'Kontakt telefon 5','KONTAKT_TELEFON_6','','Numer telefonu prezentowany w boxie :Kontakt:',1,17,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5598,'Kontakt telefon GSM 1','KONTAKT_GSM_2','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,19,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5593,'Kontakt telefon 1','KONTAKT_TELEFON_2','zzz zzz zzz','Numer telefonu prezentowany w boxie :Kontakt:',1,13,'2009-05-03 13:15:27','2005-04-02 07:07:39',NULL,NULL),
(5594,'Kontakt telefon 2','KONTAKT_TELEFON_3','','Numer telefonu prezentowany w boxie :Kontakt:',1,14,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5595,'Kontakt telefon 3','KONTAKT_TELEFON_4','','Numer telefonu prezentowany w boxie :Kontakt:',1,15,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5596,'Kontakt telefon 4','KONTAKT_TELEFON_5','','Numer telefonu prezentowany w boxie :Kontakt:',1,16,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5602,'Kontakt telefon GSM 5','KONTAKT_GSM_6','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,23,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5603,'Kontakt nr GG 1','KONTAKT_NR_GG_2','','Numer GG prezentowany w boxie : Kontakt:',1,25,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5604,'Kontakt nr GG 2','KONTAKT_NR_GG_3','','Numer GG prezentowany w boxie : Kontakt:',1,26,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5605,'Kontakt nr GG 3','KONTAKT_NR_GG_4','','Numer GG prezentowany w boxie : Kontakt:',1,27,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5606,'Kontakt nr GG 4','KONTAKT_NR_GG_5','','Numer GG prezentowany w boxie : Kontakt:',1,28,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5607,'Kontakt nr GG 5','KONTAKT_NR_GG_6','','Numer GG prezentowany w boxie : Kontakt:',1,29,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5608,'Kontakt nr SKYPE 1','KONTAKT_SKYPE_2','','Login SKYPE prezentowany w boxie : Kontakt:',1,33,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5609,'Kontakt nr SKYPE 2','KONTAKT_SKYPE_3','','Login SKYPE prezentowany w boxie : Kontakt:',1,34,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5610,'Kontakt nr SKYPE 3','KONTAKT_SKYPE_4','','Login SKYPE prezentowany w boxie : Kontakt:',1,35,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5611,'Kontakt nr SKYPE 4','KONTAKT_SKYPE_5','','Login SKYPE prezentowany w boxie : Kontakt:',1,36,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5612,'Kontakt nr SKYPE 5','KONTAKT_SKYPE_6','','Login SKYPE prezentowany w boxie : Kontakt:',1,37,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5701,'Wyświetlanie nadrzędnych kategorii w tytule i tagach','HEADER_TAGS_ADD_CATEGORY_PARENTS','Standard','Cała ścieżka kategorii (Full), wszystkie kategorie bież jeżeli produkt jest przypisany do kilku kategorii (Duplicate) lub tylko bieżąca kategoria (Standard). Ustawienia te działają tylko wówczas, jeżeli jest zaznaczona opcja Kategorie w ustawieniach stron',543,5,'2009-06-04 12:45:37','2009-06-04 11:24:59',NULL,'tep_cfg_select_option(array(\'Full Category Path\', \'Duplicate Categories\', \'Standard\'), '),
(5759,'Domyślny status podczas składania zgłoszenia','TICKET_DEFAULT_STATUS_ID','3','Domyślny status, który jest wybrany podczas składania przez klienta zgłoszenia.',69,3,'2009-10-25 19:44:56','2009-01-29 14:29:08','tep_get_ticket_status_name','tep_cfg_pull_down_status('),
(5760,'Domyślny status podczas udzielania odpowiedzi.','TICKET_CUSTOMER_REPLY_STATUS_ID','2','Domyslny status jaki otrzymuje zgłoszenie podczas odpowiedzi klienta.',69,4,NULL,'2009-01-29 14:29:08','tep_get_ticket_status_name','tep_cfg_pull_down_status('),
(5758,'Domyślna treść odpowiedzi','TICKET_DEFAULT_REPLY_ID','2','Domyślna treść wstawiana podczas odpowiedzi do klienta na zgłoszenia.',69,2,'2009-01-31 14:01:53','2009-01-29 14:29:08','tep_get_reply_name','tep_cfg_pull_down_reply('),
(5756,'Nick / login','NICK_VALUE','false','Czy wyświetlać pole NICK w danych klienta?',5,6,'2009-09-08 17:36:52','2009-09-08 17:36:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5761,'Domyślny dział obsługujący zgłoszenia','TICKET_DEFAULT_DEPARTMENT_ID','4','Domyślny dział zajmujący się obsługą zgłoszeń klientów.<br><br>Na liscie znajdują się aktualnie zdefiniowane w panelu administratora grupy użytkowników',69,5,'2009-10-25 19:45:04','2009-01-29 14:29:08','tep_get_departments_name','tep_cfg_pull_down_departments('),
(5762,'Domyślny priorytet zgłoszenia','TICKET_DEFAULT_PRIORITY_ID','3','Domyślny priorytet zgłoszenia przekazywanego przez klienta.',69,6,'2009-10-25 19:45:09','2009-01-29 14:29:08','tep_get_priority_name','tep_cfg_pull_down_priority('),
(5763,'Wyświetlanie statusu zgłoszenia','TICKET_CATALOG_USE_STATUS','true','Czy wyświetlać status zgłoszenia na liście do przeglądania przez klienta ?',69,8,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5764,'Minimalna długość opisu','TICKET_ENTRIES_MIN_LENGTH','10','Minimalna długość opisu do wprowadzenia podczas składania przez klienta zgłoszenia reklamacyjnego',69,7,'2009-11-15 11:20:33','2009-01-29 14:29:08',NULL,NULL),
(5765,'Wyświetlanie statusu zgłoszenia','TICKET_CATALOG_USE_STATUS','true','Czy wyświetlać status zgłoszenia na liście do przeglądania przez klienta ?',69,8,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5766,'Zmiana statusu zgłoszenia','TICKET_ALLOW_CUSTOMER_TO_CHANGE_STATUS','false','Czy zezwalać klientowi na zmiane statusu zgłoszenia podczas odpowiedzi na informację o realizacji zgłoszenia ?',69,9,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5767,'Wyświetlanie działu','TICKET_CATALOG_USE_DEPARTMENT','true','Czy wyświetlać dział do którego zostało przydzielone zgłoszenie na liście do przeglądania przez klienta ?',69,10,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5768,'Zmiana działu','TICKET_ALLOW_CUSTOMER_TO_CHANGE_DEPARTMENT','true','Czy zezwalać klientowi na zmianę działu, do którego ma zostać przesłana odpowiedź na informację o realizacji zgłoszenia ?',69,11,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5769,'Wyświetlanie priorytetu','TICKET_CATALOG_USE_PRIORITY','true','Czy wyświetlać priorytet zgłoszenia na liście do przeglądania przez klienta ?',69,12,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5770,'Zmiana priorytetu','TICKET_ALLOW_CUSTOMER_TO_CHANGE_PRIORITY','true','Czy zezwalać klientowi na zmianę priorytetu, podczas przesyłania odpowiedzi na informację o realizacji zgłoszenia ?',69,13,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5771,'Lista zamówień','TICKET_SHOW_CUSTOMERS_ORDER_IDS','true','Czy pokazywać listę dotychczasowych zamówień klienta podczas obsługi zgłoszeń ?',69,14,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5772,'Przeglądanie zgłoszeń','TICKET_CUSTOMER_LOGIN_REQUIREMENT_DEFAULT','true','Czy zarejestrowany klient musi być zalogowany w celu przeglądania swoich zgłoszeń ?<br><br>1 - włączone<br>0 - wyłączone',69,15,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5775,'Ścieżka do programu GUNZip','LOCAL_EXE_GUNZIP','/usr/bin/gunzip','Scieżka do programu umożliwiającego dekompresję GUNZip.',14,6,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL),
(5776,'Ścieżka do programu Zip','LOCAL_EXE_ZIP','/usr/local/bin/zip','Scieżka do programu umożliwiającego kompresję Zip.',14,7,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL),
(5777,'Ścieżka do programu UNZip','LOCAL_EXE_UNZIP','/usr/local/bin/unzip','Scieżka do programu umożliwiającego dekompresję UNZip.',14,8,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL),
(5841,'Last Database Restore','DB_LAST_RESTORE','db_oscgold-20091125202937.sql','Last database restore file',6,0,'0000-00-00 00:00:00','2009-11-25 20:59:02','',''),
(5833,'Negocjacja ceny produktu','MAO_MAX_OFFER_PERCENTAGE_ALLOWED','20','Maksymalna obniżka ceny jaką może zaproponować klient. Wartość podaje się w procentach od ceny wyjściowej produktu.',101,30,NULL,'2008-07-05 09:14:27',NULL,NULL),
(5908,'Dodatkowy stały koszt obsługi wysyłki','MODULE_SHIPPING_KURIER_HANDLING_1','0','Dodatkowy stały koszt obsługi wysyłki',6,0,NULL,'2010-03-02 21:56:55',NULL,NULL),
(5907,'Tablica kosztów (wg cennika Kuriera)','MODULE_SHIPPING_KURIER_COST_1','9999:20.00','Koszty przesyłki bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50',6,0,NULL,'2010-03-02 21:56:55',NULL,NULL),
(5888,'Wyświetlaj kolumnę PDF','PRODUCT_LIST_PDF','0','Czy wyświetlać kolumnę z możliwością pobrania PDF ?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,10,'2010-01-18 20:24:56','2009-07-29 13:05:38',NULL,NULL),
(5889,'Mod_Negocjacja','PRODUCTS_MAKE_AN_OFFER','false','',9998,0,NULL,'2010-01-01 15:00:00',NULL,NULL),
(5890,'Mod_Wysylka','SHIPPING_METHODS','false','',9998,0,NULL,'2010-01-01 15:00:00',NULL,NULL),
(5891,'Mod_SMS','SMS','false','',9998,0,NULL,'2010-01-01 15:00:00',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5892,'Mod_Znizki','PRODUCTS_DISCOUNT','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5895,'Mod_Gratis','MODS_GRATIS','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5896,'Mod_Download','MODS_DOWNLOAD','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5897,'Mod_Film','MODS_FILM','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5898,'Ceneo - status DOSTĘPNY OD RĘKI','CENEO_STATUS_1','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny od ręki</b>',260,20,'2010-02-25 21:39:49','2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses('),
(5899,'Ceneo - status DOSTĘPNY DO 3 DNI','CENEO_STATUS_3','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny do 3 dni</b>',260,21,'2010-02-25 21:57:29','2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses('),
(5900,'Ceneo - status DOSTĘPNY DO TYGODNIA','CENEO_STATUS_7','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny do tygodnia</b>',260,22,'2010-02-25 21:57:29','2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses('),
(5901,'Ceneo - status DOSTĘPNY POWYŻEJ TYGODNIA','CENEO_STATUS_14','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny powyżej tygodnia</b>',260,23,NULL,'2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses(');

drop table if exists `configuration_group`;
CREATE TABLE `configuration_group` (
  `configuration_group_id` int(11) NOT NULL,
  `configuration_group_title` varchar(64) NOT NULL,
  `configuration_group_description` varchar(255) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`),
  UNIQUE KEY `idx_visible_cfg` (`visible`,`configuration_group_id`),
  KEY `idx_visible` (`visible`)
);

insert into `configuration_group` (`configuration_group_id`, `configuration_group_title`, `configuration_group_description`, `sort_order`, `visible`) values (101,'Ustawienia sklepu','Globalne ustawienia parametrów sklepu',1,1),
(1,'Twój sklep','Ogólne informacje o sklepie',1,1),
(401,'Ustawienia dla hurtowni','Konfiguracja sklepu do obsługi hurtowni',2,1),
(2,'Wartości minimalne','Minimalne wartości funkcji i danych',3,1),
(3,'Wartości maksymalne','Maksymalne wartości fukcji i danych',4,1),
(4,'Obrazki','Parametry obrazków',5,1),
(5,'Klienci','Konfiguracja kont klientów',6,1),
(6,'Opcje modułów','Niewidoczne',7,0),
(7,'Dostawa/Pakowanie','Opcje przesyłek sklepu',8,1),
(8,'Ustawienia listingu produków','Konfiguracja wyświetlania produktów',9,1),
(9,'Magazyn','Konfiguracja dostępnośc produktów',10,1),
(10,'Logi','Konfigruacja logowania',12,1),
(12,'Opcje E-mail','Ogólne ustawienia wysyłania poczty oraz listów w formacie HTML',14,1),
(13,'Pobieranie','Konfiguracja produktów, które można pobrać',15,1),
(14,'Kompresja GZip','Konfiguracja kompresji GZip',16,1),
(15,'Sesje','Konfiguracja sesji',17,1),
(300,'Wyświetlanie pól w szybkich zmianach danych o produktach','Ustawienia modułu wprowadzania szybkich zmian w produktach',3,1),
(99,'Ustawienia wyglądu sklepu (szablony standardowe)','Moduł definiowania ustawień wyglądu sklepu',1,1),
(29,'Katalog wszystkich produktów','Wyświetlanie listy wszystkich produktów',29,1),
(26229,'Ustawienia Cache','Konfiguracja pamięci podręcznej',13,1);
insert into `configuration_group` (`configuration_group_id`, `configuration_group_title`, `configuration_group_description`, `sort_order`, `visible`) values (0,'Wyłączenie sklepu','Wyłączenie dostępu do sklepu dla klientów ze względów administracyjnych',901,1),
(741,'Anti Spambot ','Zabezpieczenie formularzy przed wysyłaniem maili przez roboty',300,1),
(403,'SEO Przyjazne adresy URL','Konfiguracja wyświetlania adresów poprawiających pozycję sklepu w wyszukiwarkach',11,1),
(200,'Konfiguracja wydruków PDF','Konfiguracja ustawień arkusza PDF',200,1),
(888001,'Cechy produktów','Ustawienia parametrów wyświetlania i zakupów produktów z dodatkoymi cechami',8,1),
(100,'Miniaturki zdjęć','Ustawienia tworzenia miniaturek obrazków',5,1),
(150,'Promocja Polecony-Nagrodzony','Ustawienia dla promocji Polecony_Nagrodzony',1,1),
(160,'Kontrola poprawności adresów SEO','Kontorola poprawności stosowanych adresów SEO URLs',902,1),
(800,'Ustawienia Faktury PDF','Wszystkie niezbędne parametry faktury PDF',800,1),
(12954,'Schowek - Konfiguracja','Konfiguracja schowka',25,1),
(16,'System punktów','Konfiguracja systemu punktów',16,1),
(72,'Edytor zamówień','Opcje konfiguracyjne edytora zamówień',72,1),
(543,'Edytor Meta Tagów','Konfiguracja edytora Meta Tagów',20,1),
(19,'Ustawienia strony koszyka','Konfiguracja dostępnych modułów na stronie koszyka',19,1),
(260,'Parametry dla porównywarek','Paramtery konfiguracyjne dla porównywarek cen',910,1),
(69,'Reklamacje - ustawienia','Opcje konfiguracyjne zgłoszeń reklamacyjnych',69,1);

drop table if exists `contact`;
CREATE TABLE `contact` (
  `id_pola` int(5) NOT NULL AUTO_INCREMENT,
  `email` varchar(50) NOT NULL,
  `nazwa` varchar(80) NOT NULL,
  `sort_order` int(4) NOT NULL,
  `languages` int(2) NOT NULL,
  PRIMARY KEY (`id_pola`)
);

drop table if exists `counter`;
CREATE TABLE `counter` (
  `startdate` char(8) DEFAULT NULL,
  `counter` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`counter`),
  KEY `idx_startdate` (`startdate`)
);

insert into `counter` (`startdate`, `counter`) values ('20170901',26);

drop table if exists `counter_history`;
CREATE TABLE `counter_history` (
  `month` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
);

drop table if exists `countries`;
CREATE TABLE `countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_name` varchar(64) NOT NULL,
  `countries_iso_code_2` char(2) NOT NULL,
  `countries_iso_code_3` char(3) NOT NULL,
  `address_format_id` int(11) NOT NULL,
  PRIMARY KEY (`countries_id`),
  KEY `idx_address_format_id` (`address_format_id`),
  KEY `idx_countries_name` (`countries_name`),
  KEY `idx_iso_2` (`countries_iso_code_2`),
  KEY `idx_iso_3` (`countries_iso_code_3`)
);

insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (1,'Afghanistan','AF','AFG',1),
(2,'Albania','AL','ALB',1),
(3,'Algeria','DZ','DZA',1),
(4,'American Samoa','AS','ASM',1),
(5,'Andorra','AD','AND',1),
(6,'Angola','AO','AGO',1),
(7,'Anguilla','AI','AIA',1),
(8,'Antarctica','AQ','ATA',1),
(9,'Antigua and Barbuda','AG','ATG',1),
(10,'Argentina','AR','ARG',1),
(11,'Armenia','AM','ARM',1),
(12,'Aruba','AW','ABW',1),
(13,'Australia','AU','AUS',1),
(14,'Austria','AT','AUT',5),
(15,'Azerbaijan','AZ','AZE',1),
(16,'Bahamas','BS','BHS',1),
(17,'Bahrain','BH','BHR',1),
(18,'Bangladesh','BD','BGD',1),
(19,'Barbados','BB','BRB',1),
(20,'Belarus','BY','BLR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (21,'Belgium','BE','BEL',1),
(22,'Belize','BZ','BLZ',1),
(23,'Benin','BJ','BEN',1),
(24,'Bermuda','BM','BMU',1),
(25,'Bhutan','BT','BTN',1),
(26,'Bolivia','BO','BOL',1),
(27,'Bosnia and Herzegowina','BA','BIH',1),
(28,'Botswana','BW','BWA',1),
(29,'Bouvet Island','BV','BVT',1),
(30,'Brazil','BR','BRA',1),
(31,'British Indian Ocean Territory','IO','IOT',1),
(32,'Brunei Darussalam','BN','BRN',1),
(33,'Bulgaria','BG','BGR',1),
(34,'Burkina Faso','BF','BFA',1),
(35,'Burundi','BI','BDI',1),
(36,'Cambodia','KH','KHM',1),
(37,'Cameroon','CM','CMR',1),
(38,'Canada','CA','CAN',1),
(39,'Cape Verde','CV','CPV',1),
(40,'Cayman Islands','KY','CYM',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (41,'Central African Republic','CF','CAF',1),
(42,'Chad','TD','TCD',1),
(43,'Chile','CL','CHL',1),
(44,'China','CN','CHN',1),
(45,'Christmas Island','CX','CXR',1),
(46,'Cocos (Keeling) Islands','CC','CCK',1),
(47,'Colombia','CO','COL',1),
(48,'Comoros','KM','COM',1),
(49,'Congo','CG','COG',1),
(50,'Cook Islands','CK','COK',1),
(51,'Costa Rica','CR','CRI',1),
(52,'Cote D\'Ivoire','CI','CIV',1),
(53,'Croatia','HR','HRV',1),
(54,'Cuba','CU','CUB',1),
(55,'Cyprus','CY','CYP',1),
(56,'Czech Republic','CZ','CZE',1),
(57,'Denmark','DK','DNK',1),
(58,'Djibouti','DJ','DJI',1),
(59,'Dominica','DM','DMA',1),
(60,'Dominican Republic','DO','DOM',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (61,'East Timor','TP','TMP',1),
(62,'Ecuador','EC','ECU',1),
(63,'Egypt','EG','EGY',1),
(64,'El Salvador','SV','SLV',1),
(65,'Equatorial Guinea','GQ','GNQ',1),
(66,'Eritrea','ER','ERI',1),
(67,'Estonia','EE','EST',1),
(68,'Ethiopia','ET','ETH',1),
(69,'Falkland Islands (Malvinas)','FK','FLK',1),
(70,'Faroe Islands','FO','FRO',1),
(71,'Fiji','FJ','FJI',1),
(72,'Finland','FI','FIN',1),
(73,'France','FR','FRA',1),
(74,'France, Metropolitan','FX','FXX',1),
(75,'French Guiana','GF','GUF',1),
(76,'French Polynesia','PF','PYF',1),
(77,'French Southern Territories','TF','ATF',1),
(78,'Gabon','GA','GAB',1),
(79,'Gambia','GM','GMB',1),
(80,'Georgia','GE','GEO',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (81,'Germany','DE','DEU',5),
(82,'Ghana','GH','GHA',1),
(83,'Gibraltar','GI','GIB',1),
(84,'Greece','GR','GRC',1),
(85,'Greenland','GL','GRL',1),
(86,'Grenada','GD','GRD',1),
(87,'Guadeloupe','GP','GLP',1),
(88,'Guam','GU','GUM',1),
(89,'Guatemala','GT','GTM',1),
(90,'Guinea','GN','GIN',1),
(91,'Guinea-bissau','GW','GNB',1),
(92,'Guyana','GY','GUY',1),
(93,'Haiti','HT','HTI',1),
(94,'Heard and Mc Donald Islands','HM','HMD',1),
(95,'Honduras','HN','HND',1),
(96,'Hong Kong','HK','HKG',1),
(97,'Hungary','HU','HUN',1),
(98,'Iceland','IS','ISL',1),
(99,'India','IN','IND',1),
(100,'Indonesia','ID','IDN',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (101,'Iran (Islamic Republic of)','IR','IRN',1),
(102,'Iraq','IQ','IRQ',1),
(103,'Ireland','IE','IRL',1),
(104,'Israel','IL','ISR',1),
(105,'Italy','IT','ITA',1),
(106,'Jamaica','JM','JAM',1),
(107,'Japan','JP','JPN',1),
(108,'Jordan','JO','JOR',1),
(109,'Kazakhstan','KZ','KAZ',1),
(110,'Kenya','KE','KEN',1),
(111,'Kiribati','KI','KIR',1),
(112,'Korea, Democratic People\'s Republic of','KP','PRK',1),
(113,'Korea, Republic of','KR','KOR',1),
(114,'Kuwait','KW','KWT',1),
(115,'Kyrgyzstan','KG','KGZ',1),
(116,'Lao People\'s Democratic Republic','LA','LAO',1),
(117,'Latvia','LV','LVA',1),
(118,'Lebanon','LB','LBN',1),
(119,'Lesotho','LS','LSO',1),
(120,'Liberia','LR','LBR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (121,'Libyan Arab Jamahiriya','LY','LBY',1),
(122,'Liechtenstein','LI','LIE',1),
(123,'Lithuania','LT','LTU',1),
(124,'Luxembourg','LU','LUX',1),
(125,'Macau','MO','MAC',1),
(126,'Macedonia, The Former Yugoslav Republic of','MK','MKD',1),
(127,'Madagascar','MG','MDG',1),
(128,'Malawi','MW','MWI',1),
(129,'Malaysia','MY','MYS',1),
(130,'Maldives','MV','MDV',1),
(131,'Mali','ML','MLI',1),
(132,'Malta','MT','MLT',1),
(133,'Marshall Islands','MH','MHL',1),
(134,'Martinique','MQ','MTQ',1),
(135,'Mauritania','MR','MRT',1),
(136,'Mauritius','MU','MUS',1),
(137,'Mayotte','YT','MYT',1),
(138,'Mexico','MX','MEX',1),
(139,'Micronesia, Federated States of','FM','FSM',1),
(140,'Moldova, Republic of','MD','MDA',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (141,'Monaco','MC','MCO',1),
(142,'Mongolia','MN','MNG',1),
(143,'Montserrat','MS','MSR',1),
(144,'Morocco','MA','MAR',1),
(145,'Mozambique','MZ','MOZ',1),
(146,'Myanmar','MM','MMR',1),
(147,'Namibia','NA','NAM',1),
(148,'Nauru','NR','NRU',1),
(149,'Nepal','NP','NPL',1),
(150,'Netherlands','NL','NLD',1),
(151,'Netherlands Antilles','AN','ANT',1),
(152,'New Caledonia','NC','NCL',1),
(153,'New Zealand','NZ','NZL',1),
(154,'Nicaragua','NI','NIC',1),
(155,'Niger','NE','NER',1),
(156,'Nigeria','NG','NGA',1),
(157,'Niue','NU','NIU',1),
(158,'Norfolk Island','NF','NFK',1),
(159,'Northern Mariana Islands','MP','MNP',1),
(160,'Norway','NO','NOR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (161,'Oman','OM','OMN',1),
(162,'Pakistan','PK','PAK',1),
(163,'Palau','PW','PLW',1),
(164,'Panama','PA','PAN',1),
(165,'Papua New Guinea','PG','PNG',1),
(166,'Paraguay','PY','PRY',1),
(167,'Peru','PE','PER',1),
(168,'Philippines','PH','PHL',1),
(169,'Pitcairn','PN','PCN',1),
(170,'Poland','PL','POL',5),
(171,'Portugal','PT','PRT',1),
(172,'Puerto Rico','PR','PRI',1),
(173,'Qatar','QA','QAT',1),
(174,'Reunion','RE','REU',1),
(175,'Romania','RO','ROM',1),
(176,'Russian Federation','RU','RUS',1),
(177,'Rwanda','RW','RWA',1),
(178,'Saint Kitts and Nevis','KN','KNA',1),
(179,'Saint Lucia','LC','LCA',1),
(180,'Saint Vincent and the Grenadines','VC','VCT',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (181,'Samoa','WS','WSM',1),
(182,'San Marino','SM','SMR',1),
(183,'Sao Tome and Principe','ST','STP',1),
(184,'Saudi Arabia','SA','SAU',1),
(185,'Senegal','SN','SEN',1),
(186,'Seychelles','SC','SYC',1),
(187,'Sierra Leone','SL','SLE',1),
(188,'Singapore','SG','SGP',4),
(189,'Slovakia (Slovak Republic)','SK','SVK',1),
(190,'Slovenia','SI','SVN',1),
(191,'Solomon Islands','SB','SLB',1),
(192,'Somalia','SO','SOM',1),
(193,'South Africa','ZA','ZAF',1),
(194,'South Georgia and the South Sandwich Islands','GS','SGS',1),
(195,'Spain','ES','ESP',3),
(196,'Sri Lanka','LK','LKA',1),
(197,'St. Helena','SH','SHN',1),
(198,'St. Pierre and Miquelon','PM','SPM',1),
(199,'Sudan','SD','SDN',1),
(200,'Suriname','SR','SUR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (201,'Svalbard and Jan Mayen Islands','SJ','SJM',1),
(202,'Swaziland','SZ','SWZ',1),
(203,'Sweden','SE','SWE',1),
(204,'Switzerland','CH','CHE',1),
(205,'Syrian Arab Republic','SY','SYR',1),
(206,'Taiwan','TW','TWN',1),
(207,'Tajikistan','TJ','TJK',1),
(208,'Tanzania, United Republic of','TZ','TZA',1),
(209,'Thailand','TH','THA',1),
(210,'Togo','TG','TGO',1),
(211,'Tokelau','TK','TKL',1),
(212,'Tonga','TO','TON',1),
(213,'Trinidad and Tobago','TT','TTO',1),
(214,'Tunisia','TN','TUN',1),
(215,'Turkey','TR','TUR',1),
(216,'Turkmenistan','TM','TKM',1),
(217,'Turks and Caicos Islands','TC','TCA',1),
(218,'Tuvalu','TV','TUV',1),
(219,'Uganda','UG','UGA',1),
(220,'Ukraine','UA','UKR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (221,'United Arab Emirates','AE','ARE',1),
(222,'United Kingdom','GB','GBR',1),
(223,'United States','US','USA',2),
(224,'United States Minor Outlying Islands','UM','UMI',1),
(225,'Uruguay','UY','URY',1),
(226,'Uzbekistan','UZ','UZB',1),
(227,'Vanuatu','VU','VUT',1),
(228,'Vatican City State (Holy See)','VA','VAT',1),
(229,'Venezuela','VE','VEN',1),
(230,'Viet Nam','VN','VNM',1),
(231,'Virgin Islands (British)','VG','VGB',1),
(232,'Virgin Islands (U.S.)','VI','VIR',1),
(233,'Wallis and Futuna Islands','WF','WLF',1),
(234,'Western Sahara','EH','ESH',1),
(235,'Yemen','YE','YEM',1),
(236,'Yugoslavia','YU','YUG',1),
(237,'Zaire','ZR','ZAR',1),
(238,'Zambia','ZM','ZMB',1),
(239,'Zimbabwe','ZW','ZWE',1);

drop table if exists `currencies`;
CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `code` char(3) NOT NULL,
  `symbol_left` varchar(12) DEFAULT NULL,
  `symbol_right` varchar(12) DEFAULT NULL,
  `decimal_point` char(1) DEFAULT NULL,
  `thousands_point` char(1) DEFAULT NULL,
  `decimal_places` char(1) DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`currencies_id`),
  KEY `idx_currencies_code` (`code`)
);

insert into `currencies` (`currencies_id`, `title`, `code`, `symbol_left`, `symbol_right`, `decimal_point`, `thousands_point`, `decimal_places`, `value`, `last_updated`) values (1,'Polski Złoty','PLN','','zł',',','.','2','1.00000000','2009-10-06 10:11:21'),
(2,'Euro','EUR','','Euro','.',',','2','0.23716351','2009-10-06 10:11:21'),
(3,'Dolar','USD','','$','.',',','2','0.34660843','2009-10-06 10:11:21'),
(4,'Funt brytyjski','GBP','','£','.',',','2','0.21693386','2009-10-06 10:11:21');

drop table if exists `customers`;
CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `nick` varchar(30) NOT NULL,
  `customers_gender` char(1) DEFAULT NULL,
  `customers_firstname` varchar(32) NOT NULL,
  `customers_lastname` varchar(32) NOT NULL,
  `customers_dob` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customers_email_address` varchar(96) NOT NULL,
  `customers_default_address_id` int(11) DEFAULT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_fax` varchar(32) DEFAULT NULL,
  `customers_password` varchar(40) DEFAULT NULL,
  `customers_newsletter` char(1) DEFAULT NULL,
  `guest_account` tinyint(4) NOT NULL DEFAULT '0',
  `customer_discount` decimal(5,2) NOT NULL DEFAULT '0.00',
  `customers_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customers_groups_id` int(11) NOT NULL DEFAULT '1',
  `customers_status` int(11) NOT NULL DEFAULT '0',
  `customers_agreement` char(1) NOT NULL,
  `customers_polecony` int(11) NOT NULL DEFAULT '0',
  `customers_polecajacy_id` int(11) NOT NULL,
  `customers_shopping_points` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `customers_points_expires` date DEFAULT NULL,
  PRIMARY KEY (`customers_id`),
  KEY `idx_customers_email_address` (`customers_email_address`),
  KEY `idx_customers_firstname` (`customers_firstname`),
  KEY `idx_customers_groups_id` (`customers_groups_id`),
  KEY `idx_customers_lastname` (`customers_lastname`),
  KEY `idx_customers_newsletter` (`customers_newsletter`),
  KEY `idx_customers_password` (`customers_password`)
);

drop table if exists `customers_basket`;
CREATE TABLE `customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `customers_basket_quantity` int(6) NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `customers_basket_date_added` char(8) DEFAULT NULL,
  PRIMARY KEY (`customers_basket_id`),
  KEY `idx_customers_id` (`customers_id`)
);

drop table if exists `customers_basket_attributes`;
CREATE TABLE `customers_basket_attributes` (
  `customers_basket_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL,
  `products_options_value_id` int(11) NOT NULL,
  PRIMARY KEY (`customers_basket_attributes_id`),
  KEY `idx_customers_id` (`customers_id`)
);

drop table if exists `customers_basket_text_attributes`;
CREATE TABLE `customers_basket_text_attributes` (
  `session_id` varchar(255) NOT NULL,
  `products_id` varchar(50) NOT NULL,
  `products_text_attributes_id` int(11) NOT NULL DEFAULT '0',
  `products_text_attributes_text` text NOT NULL,
  `customqty` varchar(255) NOT NULL,
  PRIMARY KEY (`session_id`,`products_id`,`products_text_attributes_id`)
);

drop table if exists `customers_groups`;
CREATE TABLE `customers_groups` (
  `customers_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_groups_name` varchar(32) NOT NULL,
  `customers_groups_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customers_groups_price` int(11) NOT NULL DEFAULT '1',
  `customers_groups_min_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`customers_groups_id`)
);

insert into `customers_groups` (`customers_groups_id`, `customers_groups_name`, `customers_groups_discount`, `customers_groups_price`, `customers_groups_min_amount`) values (1,'Domyślnie','0.00',1,'0.00'),
(2,'Sprzedaż hurtowa','-30.00',1,'0.00');

drop table if exists `customers_info`;
CREATE TABLE `customers_info` (
  `customers_info_id` int(11) NOT NULL,
  `customers_info_date_of_last_logon` datetime DEFAULT NULL,
  `customers_info_number_of_logons` int(5) DEFAULT NULL,
  `customers_info_date_account_created` datetime DEFAULT NULL,
  `customers_info_date_account_last_modified` datetime DEFAULT NULL,
  `global_product_notifications` int(1) DEFAULT '0',
  PRIMARY KEY (`customers_info_id`),
  KEY `idx_customers_info_number_of_logons` (`customers_info_number_of_logons`)
);

drop table if exists `customers_points_pending`;
CREATE TABLE `customers_points_pending` (
  `unique_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `points_pending` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `points_comment` varchar(200) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `points_status` int(1) NOT NULL DEFAULT '1',
  `points_type` varchar(2) NOT NULL DEFAULT 'SP',
  PRIMARY KEY (`unique_id`)
);

drop table if exists `customers_to_extra_fields`;
CREATE TABLE `customers_to_extra_fields` (
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `value` text
);

drop table if exists `customers_wishlist`;
CREATE TABLE `customers_wishlist` (
  `products_id` tinytext NOT NULL,
  `customers_id` int(13) NOT NULL DEFAULT '0'
);

drop table if exists `customers_wishlist_attributes`;
CREATE TABLE `customers_wishlist_attributes` (
  `customers_wishlist_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_value_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_wishlist_attributes_id`)
);

drop table if exists `discount_coupons`;
CREATE TABLE `discount_coupons` (
  `coupons_id` varchar(32) NOT NULL,
  `coupons_description` varchar(64) NOT NULL,
  `coupons_discount_amount` decimal(15,12) NOT NULL DEFAULT '0.000000000000',
  `coupons_discount_type` enum('fixed','percent','shipping') NOT NULL DEFAULT 'percent',
  `coupons_date_start` datetime DEFAULT NULL,
  `coupons_date_end` datetime DEFAULT NULL,
  `coupons_max_use` int(3) NOT NULL DEFAULT '0',
  `coupons_min_order` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `coupons_min_order_type` enum('price','quantity') NOT NULL DEFAULT 'price',
  `coupons_number_available` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`)
);

drop table if exists `discount_coupons_to_categories`;
CREATE TABLE `discount_coupons_to_categories` (
  `coupons_id` varchar(32) NOT NULL,
  `categories_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`categories_id`)
);

drop table if exists `discount_coupons_to_customers`;
CREATE TABLE `discount_coupons_to_customers` (
  `coupons_id` varchar(32) NOT NULL,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`customers_id`)
);

drop table if exists `discount_coupons_to_manufacturers`;
CREATE TABLE `discount_coupons_to_manufacturers` (
  `coupons_id` varchar(32) NOT NULL,
  `manufacturers_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`manufacturers_id`)
);

drop table if exists `discount_coupons_to_orders`;
CREATE TABLE `discount_coupons_to_orders` (
  `discount_coupons_to_orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_id` varchar(32) DEFAULT NULL,
  `orders_id` int(11) DEFAULT '0',
  PRIMARY KEY (`discount_coupons_to_orders_id`),
  KEY `idx_coupons_id` (`coupons_id`)
);

drop table if exists `discount_coupons_to_products`;
CREATE TABLE `discount_coupons_to_products` (
  `coupons_id` varchar(32) NOT NULL,
  `products_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`products_id`)
);

drop table if exists `discount_coupons_to_zones`;
CREATE TABLE `discount_coupons_to_zones` (
  `coupons_id` varchar(32) NOT NULL,
  `geo_zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`geo_zone_id`)
);

drop table if exists `extra_fields`;
CREATE TABLE `extra_fields` (
  `fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `fields_input_type` int(11) NOT NULL DEFAULT '0',
  `fields_input_value` text NOT NULL,
  `fields_status` tinyint(2) NOT NULL DEFAULT '0',
  `fields_required_status` tinyint(2) NOT NULL DEFAULT '0',
  `fields_size` int(5) NOT NULL DEFAULT '0',
  `fields_required_email` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fields_id`)
);

drop table if exists `extra_fields_info`;
CREATE TABLE `extra_fields_info` (
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `fields_name` varchar(32) NOT NULL DEFAULT ''
);

drop table if exists `faq`;
CREATE TABLE `faq` (
  `faq_id` int(11) NOT NULL AUTO_INCREMENT,
  `faq_status` tinyint(1) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`faq_id`)
);

drop table if exists `faq_description`;
CREATE TABLE `faq_description` (
  `faq_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `faq_question` text,
  `faq_answer` text,
  PRIMARY KEY (`faq_id`,`language_id`)
);

drop table if exists `featured`;
CREATE TABLE `featured` (
  `featured_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `featured_date_added` datetime DEFAULT NULL,
  `featured_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`featured_id`),
  KEY `idx_expires_date_zen` (`expires_date`),
  KEY `idx_products_id` (`products_id`),
  KEY `idx_status` (`status`)
);

drop table if exists `geo_zones`;
CREATE TABLE `geo_zones` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_name` varchar(32) NOT NULL,
  `geo_zone_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`geo_zone_id`)
);

insert into `geo_zones` (`geo_zone_id`, `geo_zone_name`, `geo_zone_description`, `last_modified`, `date_added`) values (1,'Polska i kraje EU','Obowiązujący podatek VAT','2007-07-13 13:08:28','2006-05-27 18:49:12'),
(3,'Polska','Polska',NULL,'2007-07-13 13:08:57'),
(4,'Wszystkie kraje','Wszystkie kraje','2008-10-21 21:07:54','2008-06-04 13:40:02'),
(5,'Wszystkie kraje bez PL','Wszystkie kraje bez PL',NULL,'2008-10-21 21:08:13');

drop table if exists `headertags`;
CREATE TABLE `headertags` (
  `page_name` varchar(64) NOT NULL,
  `page_title` varchar(120) NOT NULL,
  `page_description` varchar(255) NOT NULL,
  `page_keywords` varchar(255) NOT NULL,
  `page_logo` varchar(255) NOT NULL,
  `page_logo_1` varchar(255) NOT NULL,
  `page_logo_2` varchar(255) NOT NULL,
  `page_logo_3` varchar(255) NOT NULL,
  `page_logo_4` varchar(255) NOT NULL,
  `append_default_title` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_description` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_keywords` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_logo` tinyint(1) NOT NULL DEFAULT '0',
  `append_category` tinyint(1) NOT NULL DEFAULT '0',
  `append_manufacturer` tinyint(1) NOT NULL DEFAULT '0',
  `append_product` tinyint(1) NOT NULL DEFAULT '1',
  `append_root` tinyint(1) NOT NULL DEFAULT '1',
  `sortorder_title` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_description` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_keywords` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_logo` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_category` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_manufacturer` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_product` tinyint(2) NOT NULL DEFAULT '10',
  `sortorder_root` tinyint(2) NOT NULL DEFAULT '1',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`page_name`,`language_id`)
);

insert into `headertags` (`page_name`, `page_title`, `page_description`, `page_keywords`, `page_logo`, `page_logo_1`, `page_logo_2`, `page_logo_3`, `page_logo_4`, `append_default_title`, `append_default_description`, `append_default_keywords`, `append_default_logo`, `append_category`, `append_manufacturer`, `append_product`, `append_root`, `sortorder_title`, `sortorder_description`, `sortorder_keywords`, `sortorder_logo`, `sortorder_category`, `sortorder_manufacturer`, `sortorder_product`, `sortorder_root`, `language_id`) values ('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,1),
('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,2),
('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,3),
('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,4),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,1),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,2),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,3),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,4),
('product_reviews.php','Komentarze','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),
('product_reviews.php','Comments','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,2),
('product_reviews.php','Comments','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,3),
('product_reviews.php','Comments','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,4),
('product_reviews_write.php','Napisz komentarz','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),
('product_reviews_write.php','Comment Write','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,2),
('product_reviews_write.php','Comment Write','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,3),
('product_reviews_write.php','Comment Write','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,4),
('specials.php','Promocje','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,1),
('specials.php','Specials','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,2),
('specials.php','Specials','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,3),
('specials.php','Specials','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,4);

drop table if exists `headertags_default`;
CREATE TABLE `headertags_default` (
  `default_title` varchar(255) NOT NULL,
  `default_description` varchar(255) NOT NULL,
  `default_keywords` varchar(255) NOT NULL,
  `default_logo_text` varchar(255) NOT NULL,
  `default_logo_append_group` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_category` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_manufacturer` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_product` tinyint(1) NOT NULL DEFAULT '1',
  `meta_google` tinyint(1) NOT NULL DEFAULT '0',
  `meta_language` tinyint(1) NOT NULL DEFAULT '0',
  `meta_noodp` tinyint(1) NOT NULL DEFAULT '1',
  `meta_noydir` tinyint(1) NOT NULL DEFAULT '1',
  `meta_replyto` tinyint(1) NOT NULL DEFAULT '0',
  `meta_revisit` tinyint(1) NOT NULL DEFAULT '0',
  `meta_robots` tinyint(1) NOT NULL DEFAULT '0',
  `meta_unspam` tinyint(1) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`default_title`,`language_id`),
  KEY `idx_language_id` (`language_id`)
);

insert into `headertags_default` (`default_title`, `default_description`, `default_keywords`, `default_logo_text`, `default_logo_append_group`, `default_logo_append_category`, `default_logo_append_manufacturer`, `default_logo_append_product`, `meta_google`, `meta_language`, `meta_noodp`, `meta_noydir`, `meta_replyto`, `meta_revisit`, `meta_robots`, `meta_unspam`, `language_id`) values ('Domyślny tytuł strony','Domyślny opis strony','Domyślne słowa kluczowe','Domyślny tekst alt',0,0,1,0,0,0,1,1,0,0,0,0,1),
('Page Title','Description','Keywords','Store Name',0,1,0,1,0,0,1,1,0,0,0,0,2),
('Page Titel','Beschreibung','Schlagworte','Shop-Name',0,1,0,1,0,0,1,1,0,0,0,0,3),
('Название страницы','Описание','Ключевые слова','Название магазина',0,1,0,1,0,0,1,1,0,0,0,0,4);

drop table if exists `invoices_symfonia`;
CREATE TABLE `invoices_symfonia` (
  `invoice_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) DEFAULT NULL,
  `numer_faktury` int(11) DEFAULT NULL,
  `customers_name` varchar(256) DEFAULT NULL,
  `customers_company` varchar(256) DEFAULT NULL,
  `customers_nip` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) DEFAULT NULL,
  `customers_postcode` varchar(10) DEFAULT NULL,
  `customers_street_address` varchar(64) DEFAULT NULL,
  `invoice_nr` varchar(32) DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `date_printed` datetime DEFAULT NULL,
  `total_netto` decimal(14,2) DEFAULT NULL,
  `total_vat` decimal(14,2) DEFAULT NULL,
  `total_netto_22` decimal(14,2) DEFAULT NULL,
  `total_vat_22` decimal(14,2) DEFAULT NULL,
  `total_netto_7` decimal(14,2) DEFAULT NULL,
  `total_vat_7` decimal(14,2) DEFAULT NULL,
  `total_netto_3` decimal(14,2) DEFAULT NULL,
  `total_vat_3` decimal(14,2) DEFAULT NULL,
  `total_netto_0` decimal(14,2) DEFAULT NULL,
  `total_netto_zw` decimal(14,2) DEFAULT NULL,
  `total_netto_np` decimal(14,2) DEFAULT NULL,
  `total_brutto` decimal(14,2) DEFAULT NULL,
  `date_payment` datetime DEFAULT NULL,
  `filename` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`invoice_id`),
  KEY `idx_orders_id` (`orders_id`)
);

drop table if exists `languages`;
CREATE TABLE `languages` (
  `languages_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `code` char(2) NOT NULL,
  `image` varchar(64) DEFAULT NULL,
  `directory` varchar(32) DEFAULT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`languages_id`),
  KEY `idx_name` (`name`),
  KEY `idx_sort_order` (`sort_order`)
);

insert into `languages` (`languages_id`, `name`, `code`, `image`, `directory`, `sort_order`) values (1,'Polski','pl','icon.gif','polish',1),
(2,'Angielski','en','icon.gif','english',2),
(3,'Niemiecki','de','icon.gif','german',3),
(4,'Rosyjski','ru','icon.gif','russian',4);

drop table if exists `mailing`;
CREATE TABLE `mailing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `email` varchar(80) NOT NULL,
  PRIMARY KEY (`id`)
);

drop table if exists `manudiscount`;
CREATE TABLE `manudiscount` (
  `manudiscount_id` int(11) NOT NULL AUTO_INCREMENT,
  `manudiscount_name` varchar(128) NOT NULL,
  `manudiscount_groups_id` int(11) NOT NULL DEFAULT '0',
  `manudiscount_customers_id` int(11) NOT NULL DEFAULT '0',
  `manudiscount_manufacturers_id` int(11) NOT NULL DEFAULT '0',
  `manudiscount_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`manudiscount_id`),
  KEY `idx_manudiscount_groups_id` (`manudiscount_groups_id`)
);

drop table if exists `manufacturers`;
CREATE TABLE `manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(32) NOT NULL,
  `manufacturers_image` varchar(64) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `action` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`),
  UNIQUE KEY `action` (`action`),
  KEY `idx_manufacturers_name` (`manufacturers_name`)
);

insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (7,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:11','2017-09-25 10:20:11',NULL),
(8,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL),
(9,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL),
(10,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL),
(11,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL),
(12,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL),
(13,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL),
(14,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL),
(15,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL),
(16,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL),
(17,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:14','2017-09-25 10:20:14',NULL),
(18,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:14','2017-09-25 10:20:14',NULL),
(19,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:14','2017-09-25 10:20:14',NULL),
(20,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:15','2017-09-25 10:20:15',NULL),
(21,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:15','2017-09-25 10:20:15',NULL),
(22,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:15','2017-09-25 10:20:15',NULL),
(23,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL),
(24,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL),
(25,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL),
(26,'CARLISLE opony i dętki przemysło','0','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (28,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:18','2017-09-25 10:20:18',NULL),
(29,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:18','2017-09-25 10:20:18',NULL),
(30,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:18','2017-09-25 10:20:18',NULL),
(31,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL),
(32,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL),
(33,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL),
(34,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL),
(35,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:20','2017-09-25 10:20:20',NULL),
(36,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:21','2017-09-25 10:20:21',NULL),
(37,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:21','2017-09-25 10:20:21',NULL),
(38,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL),
(39,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL),
(40,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL),
(41,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL),
(42,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL),
(43,'CARLISLE Semi-Pneumatic Tire&Whe','0','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL),
(44,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL),
(45,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL),
(46,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:24','2017-09-25 10:20:24',NULL),
(47,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:24','2017-09-25 10:20:24',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (48,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:24','2017-09-25 10:20:24',NULL),
(49,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL),
(50,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL),
(51,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL),
(52,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL),
(53,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL),
(54,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL),
(55,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL),
(56,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL),
(57,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL),
(58,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL),
(59,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL),
(60,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL),
(61,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL),
(62,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL),
(63,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:28','2017-09-25 10:20:28',NULL),
(64,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:28','2017-09-25 10:20:28',NULL),
(65,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:28','2017-09-25 10:20:28',NULL),
(66,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:29','2017-09-25 10:20:29',NULL),
(67,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:29','2017-09-25 10:20:29',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (70,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:31','2017-09-25 10:20:31',NULL),
(71,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:31','2017-09-25 10:20:31',NULL),
(72,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:31','2017-09-25 10:20:31',NULL),
(73,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:32','2017-09-25 10:20:32',NULL),
(74,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:32','2017-09-25 10:20:32',NULL),
(75,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:33','2017-09-25 10:20:33',NULL),
(76,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:33','2017-09-25 10:20:33',NULL),
(77,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:33','2017-09-25 10:20:33',NULL),
(78,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL),
(79,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL),
(80,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL),
(81,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL),
(82,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:35','2017-09-25 10:20:35',NULL),
(83,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:35','2017-09-25 10:20:35',NULL),
(84,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:36','2017-09-25 10:20:36',NULL),
(85,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:37','2017-09-25 10:20:37',NULL),
(86,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:37','2017-09-25 10:20:37',NULL),
(87,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:37','2017-09-25 10:20:37',NULL),
(88,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL),
(89,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (90,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL),
(91,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL),
(92,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL),
(93,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL),
(94,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL),
(95,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL),
(96,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL),
(97,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL),
(98,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL),
(99,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL),
(100,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL),
(101,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:41','2017-09-25 10:20:41',NULL),
(102,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:41','2017-09-25 10:20:41',NULL),
(103,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:41','2017-09-25 10:20:41',NULL),
(104,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:42','2017-09-25 10:20:42',NULL),
(105,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:42','2017-09-25 10:20:42',NULL),
(106,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:43','2017-09-25 10:20:43',NULL),
(107,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:43','2017-09-25 10:20:43',NULL),
(108,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:43','2017-09-25 10:20:43',NULL),
(109,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:44','2017-09-25 10:20:44',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (110,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL),
(111,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL),
(112,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL),
(113,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL),
(114,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL),
(115,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL),
(116,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL),
(117,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL),
(118,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL),
(119,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL),
(120,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL),
(121,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL),
(122,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL),
(123,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL),
(124,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL),
(125,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL),
(126,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:48','2017-09-25 10:20:48',NULL),
(127,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:48','2017-09-25 10:20:48',NULL),
(128,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:49','2017-09-25 10:20:49',NULL),
(129,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:49','2017-09-25 10:20:49',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (130,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:49','2017-09-25 10:20:49',NULL),
(131,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL),
(132,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL),
(133,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL),
(134,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL),
(135,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:51','2017-09-25 10:20:51',NULL),
(136,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:51','2017-09-25 10:20:51',NULL),
(137,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:51','2017-09-25 10:20:51',NULL),
(138,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL),
(139,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL),
(140,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL),
(141,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL),
(142,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL),
(143,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL),
(144,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL),
(145,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL),
(146,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:54','2017-09-25 10:20:54',NULL),
(147,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:54','2017-09-25 10:20:54',NULL),
(148,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:20:54','2017-09-25 10:20:54',NULL),
(149,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:55','2017-09-25 10:20:55',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (150,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:55','2017-09-25 10:20:55',NULL),
(151,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL),
(152,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL),
(153,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL),
(154,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL),
(155,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:57','2017-09-25 10:20:57',NULL),
(156,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:57','2017-09-25 10:20:57',NULL),
(157,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:57','2017-09-25 10:20:57',NULL),
(158,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:58','2017-09-25 10:20:58',NULL),
(159,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:58','2017-09-25 10:20:58',NULL),
(160,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL),
(161,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL),
(162,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL),
(163,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL),
(164,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL),
(165,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL),
(166,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL),
(167,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL),
(168,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL),
(169,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (170,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL),
(171,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL),
(172,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL),
(173,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL),
(174,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:02','2017-09-25 10:21:02',NULL),
(175,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:02','2017-09-25 10:21:02',NULL),
(176,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:02','2017-09-25 10:21:02',NULL),
(177,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL),
(178,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL),
(179,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL),
(180,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL),
(181,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:04','2017-09-25 10:21:04',NULL),
(182,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:04','2017-09-25 10:21:04',NULL),
(183,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL),
(184,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL),
(185,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL),
(186,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL),
(187,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:06','2017-09-25 10:21:06',NULL),
(188,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:06','2017-09-25 10:21:06',NULL),
(189,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (190,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL),
(191,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL),
(192,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL),
(193,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL),
(194,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:08','2017-09-25 10:21:08',NULL),
(195,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:08','2017-09-25 10:21:08',NULL),
(196,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:08','2017-09-25 10:21:08',NULL),
(197,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:09','2017-09-25 10:21:09',NULL),
(198,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:09','2017-09-25 10:21:09',NULL),
(199,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:10','2017-09-25 10:21:10',NULL),
(200,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:11','2017-09-25 10:21:11',NULL),
(201,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL),
(202,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL),
(203,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL),
(204,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL),
(205,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL),
(206,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:13','2017-09-25 10:21:13',NULL),
(207,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:13','2017-09-25 10:21:13',NULL),
(208,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:14','2017-09-25 10:21:14',NULL),
(209,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:14','2017-09-25 10:21:14',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (210,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL),
(211,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL),
(212,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL),
(213,'DURO opony samochodowe osobowe, ','0','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL),
(215,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:40','2017-09-25 10:21:40',NULL),
(216,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:40','2017-09-25 10:21:40',NULL),
(217,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:40','2017-09-25 10:21:40',NULL),
(218,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:41','2017-09-25 10:21:41',NULL),
(219,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:41','2017-09-25 10:21:41',NULL),
(220,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:42','2017-09-25 10:21:42',NULL),
(221,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:42','2017-09-25 10:21:42',NULL),
(222,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:43','2017-09-25 10:21:43',NULL),
(223,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:43','2017-09-25 10:21:43',NULL),
(224,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:43','2017-09-25 10:21:43',NULL),
(225,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:44','2017-09-25 10:21:44',NULL),
(226,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:44','2017-09-25 10:21:44',NULL),
(227,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:44','2017-09-25 10:21:44',NULL),
(228,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:45','2017-09-25 10:21:45',NULL),
(229,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:45','2017-09-25 10:21:45',NULL),
(230,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (231,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL),
(232,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL),
(233,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL),
(234,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:47','2017-09-25 10:21:47',NULL),
(235,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:47','2017-09-25 10:21:47',NULL),
(236,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:47','2017-09-25 10:21:47',NULL),
(237,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:48','2017-09-25 10:21:48',NULL),
(238,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:48','2017-09-25 10:21:48',NULL),
(239,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:48','2017-09-25 10:21:48',NULL),
(240,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:49','2017-09-25 10:21:49',NULL),
(241,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:49','2017-09-25 10:21:49',NULL),
(242,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:50','2017-09-25 10:21:50',NULL),
(243,'DURO opony i dętki motocyklowe i','0','2017-09-25 10:21:50','2017-09-25 10:21:50',NULL),
(244,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:51','2017-09-25 10:21:51',NULL),
(245,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:51','2017-09-25 10:21:51',NULL),
(246,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL),
(247,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL),
(248,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL),
(249,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL),
(250,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:53','2017-09-25 10:21:53',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (251,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:53','2017-09-25 10:21:53',NULL),
(252,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL),
(253,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL),
(254,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL),
(255,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL),
(256,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL),
(257,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL),
(258,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL),
(259,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL),
(260,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:56','2017-09-25 10:21:56',NULL),
(261,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:56','2017-09-25 10:21:56',NULL),
(262,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:56','2017-09-25 10:21:56',NULL),
(263,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL),
(264,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL),
(265,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL),
(266,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL),
(267,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:58','2017-09-25 10:21:58',NULL),
(268,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:59','2017-09-25 10:21:59',NULL),
(269,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:59','2017-09-25 10:21:59',NULL),
(270,'DURO opony przemysłowe (traktork','0','2017-09-25 10:21:59','2017-09-25 10:21:59',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (271,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:00','2017-09-25 10:22:00',NULL),
(272,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:00','2017-09-25 10:22:00',NULL),
(273,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:01','2017-09-25 10:22:01',NULL),
(274,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:01','2017-09-25 10:22:01',NULL),
(275,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL),
(276,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL),
(277,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL),
(278,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL),
(279,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL),
(280,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL),
(281,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:03','2017-09-25 10:22:03',NULL),
(282,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:03','2017-09-25 10:22:03',NULL),
(283,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:03','2017-09-25 10:22:03',NULL),
(284,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:04','2017-09-25 10:22:04',NULL),
(285,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL),
(286,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL),
(287,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL),
(288,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL),
(289,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:06','2017-09-25 10:22:06',NULL),
(290,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:06','2017-09-25 10:22:06',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (291,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:06','2017-09-25 10:22:06',NULL),
(292,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:07','2017-09-25 10:22:07',NULL),
(293,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:07','2017-09-25 10:22:07',NULL),
(294,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:07','2017-09-25 10:22:07',NULL),
(295,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:08','2017-09-25 10:22:08',NULL),
(296,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:08','2017-09-25 10:22:08',NULL),
(297,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:09','2017-09-25 10:22:09',NULL),
(298,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:09','2017-09-25 10:22:09',NULL),
(299,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:09','2017-09-25 10:22:09',NULL),
(300,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:10','2017-09-25 10:22:10',NULL),
(301,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:10','2017-09-25 10:22:10',NULL),
(302,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:10','2017-09-25 10:22:10',NULL),
(303,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:11','2017-09-25 10:22:11',NULL),
(304,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:11','2017-09-25 10:22:11',NULL),
(305,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:11','2017-09-25 10:22:11',NULL),
(306,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:12','2017-09-25 10:22:12',NULL),
(307,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:12','2017-09-25 10:22:12',NULL),
(308,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:12','2017-09-25 10:22:12',NULL),
(309,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:13','2017-09-25 10:22:13',NULL),
(310,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:13','2017-09-25 10:22:13',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (311,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:13','2017-09-25 10:22:13',NULL),
(312,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL),
(313,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL),
(314,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL),
(315,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL),
(316,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL),
(317,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL),
(318,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL),
(319,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL),
(320,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL),
(321,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL),
(322,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:16','2017-09-25 10:22:16',NULL),
(323,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:16','2017-09-25 10:22:16',NULL),
(324,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:17','2017-09-25 10:22:17',NULL),
(325,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:17','2017-09-25 10:22:17',NULL),
(326,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:17','2017-09-25 10:22:17',NULL),
(327,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL),
(328,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL),
(329,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL),
(330,'DURO opony przemysłowe (traktork','0','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (331,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:19','2017-09-25 10:22:19',NULL),
(332,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:20','2017-09-25 10:22:20',NULL),
(333,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:20','2017-09-25 10:22:20',NULL),
(334,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL),
(335,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL),
(336,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL),
(337,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL),
(338,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:22','2017-09-25 10:22:22',NULL),
(339,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:22','2017-09-25 10:22:22',NULL),
(340,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:23','2017-09-25 10:22:23',NULL),
(341,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:24','2017-09-25 10:22:24',NULL),
(342,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:24','2017-09-25 10:22:24',NULL),
(343,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:25','2017-09-25 10:22:25',NULL),
(344,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:25','2017-09-25 10:22:25',NULL),
(345,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:25','2017-09-25 10:22:25',NULL),
(346,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:26','2017-09-25 10:22:26',NULL),
(347,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:27','2017-09-25 10:22:27',NULL),
(348,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:27','2017-09-25 10:22:27',NULL),
(349,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:27','2017-09-25 10:22:27',NULL),
(350,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:28','2017-09-25 10:22:28',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (351,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:29','2017-09-25 10:22:29',NULL),
(352,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:29','2017-09-25 10:22:29',NULL),
(353,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL),
(354,'FEDERAL opony samochodowe 4x4 MT','0','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL),
(355,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL),
(356,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL),
(357,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL),
(358,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:31','2017-09-25 10:22:31',NULL),
(359,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:31','2017-09-25 10:22:31',NULL),
(360,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:31','2017-09-25 10:22:31',NULL),
(361,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL),
(362,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL),
(363,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL),
(364,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL),
(365,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:33','2017-09-25 10:22:33',NULL),
(366,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:33','2017-09-25 10:22:33',NULL),
(367,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:33','2017-09-25 10:22:33',NULL),
(368,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:34','2017-09-25 10:22:34',NULL),
(369,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:34','2017-09-25 10:22:34',NULL),
(370,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (371,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL),
(372,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL),
(373,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL),
(374,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL),
(375,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:36','2017-09-25 10:22:36',NULL),
(376,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:36','2017-09-25 10:22:36',NULL),
(377,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:37','2017-09-25 10:22:37',NULL),
(378,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:37','2017-09-25 10:22:37',NULL),
(379,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:37','2017-09-25 10:22:37',NULL),
(380,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:38','2017-09-25 10:22:38',NULL),
(381,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:38','2017-09-25 10:22:38',NULL),
(382,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:38','2017-09-25 10:22:38',NULL),
(383,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:39','2017-09-25 10:22:39',NULL),
(384,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:39','2017-09-25 10:22:39',NULL),
(385,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:39','2017-09-25 10:22:39',NULL),
(386,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:40','2017-09-25 10:22:40',NULL),
(387,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:40','2017-09-25 10:22:40',NULL),
(388,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:41','2017-09-25 10:22:41',NULL),
(389,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:41','2017-09-25 10:22:41',NULL),
(390,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:41','2017-09-25 10:22:41',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (391,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL),
(392,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL),
(393,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL),
(394,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL),
(395,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:43','2017-09-25 10:22:43',NULL),
(396,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:43','2017-09-25 10:22:43',NULL),
(397,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:44','2017-09-25 10:22:44',NULL),
(398,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:44','2017-09-25 10:22:44',NULL),
(399,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:44','2017-09-25 10:22:44',NULL),
(400,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:45','2017-09-25 10:22:45',NULL),
(401,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:45','2017-09-25 10:22:45',NULL),
(402,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:45','2017-09-25 10:22:45',NULL),
(403,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:46','2017-09-25 10:22:46',NULL),
(404,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:46','2017-09-25 10:22:46',NULL),
(405,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:46','2017-09-25 10:22:46',NULL),
(406,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:47','2017-09-25 10:22:47',NULL),
(407,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:47','2017-09-25 10:22:47',NULL),
(408,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:48','2017-09-25 10:22:48',NULL),
(409,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:48','2017-09-25 10:22:48',NULL),
(410,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:49','2017-09-25 10:22:49',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (411,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:49','2017-09-25 10:22:49',NULL),
(412,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:49','2017-09-25 10:22:49',NULL),
(413,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL),
(414,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL),
(415,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL),
(416,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL),
(417,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL),
(418,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL),
(419,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL),
(420,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL),
(421,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL),
(422,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL),
(423,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL),
(424,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL),
(425,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL),
(426,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL),
(427,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL),
(428,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL),
(429,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL),
(430,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (431,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL),
(432,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL),
(433,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL),
(434,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL),
(435,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL),
(436,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL),
(437,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL),
(438,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL),
(439,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL),
(440,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL),
(441,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL),
(442,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL),
(443,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL),
(444,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL),
(445,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL),
(446,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL),
(447,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL),
(448,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL),
(449,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL),
(450,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (451,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL),
(452,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL),
(453,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL),
(454,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL),
(455,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL),
(456,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL),
(457,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL),
(458,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL),
(459,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL),
(460,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL),
(461,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL),
(462,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL),
(463,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL),
(464,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL),
(465,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL),
(466,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL),
(467,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL),
(468,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL),
(469,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL),
(470,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (471,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL),
(472,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL),
(473,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL),
(474,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL),
(475,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL),
(476,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL),
(477,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL),
(478,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL),
(479,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL),
(480,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL),
(481,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL),
(482,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL),
(483,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL),
(484,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL),
(485,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL),
(486,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL),
(487,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL),
(488,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL),
(489,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL),
(490,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (491,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL),
(492,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL),
(493,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL),
(494,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL),
(495,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL),
(496,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL),
(497,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL),
(498,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL),
(499,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL),
(500,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL),
(501,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL),
(502,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL),
(503,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL),
(504,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL),
(505,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL),
(506,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL),
(507,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL),
(508,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL),
(509,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL),
(510,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (511,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL),
(512,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL),
(513,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL),
(514,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL),
(515,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL),
(516,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL),
(517,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL),
(518,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL),
(519,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL),
(520,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL),
(521,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL),
(522,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL),
(523,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL),
(524,'FEDERAL opony samochodowe osobow','0','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL),
(525,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL),
(526,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL),
(527,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL),
(528,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL),
(529,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL),
(530,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (531,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL),
(532,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL),
(533,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL),
(534,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL),
(535,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL),
(536,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL),
(537,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL),
(538,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL),
(539,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL),
(540,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL),
(541,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL),
(542,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL),
(543,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL),
(544,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL),
(545,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL),
(546,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL),
(547,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL),
(548,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL),
(549,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL),
(550,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (551,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(552,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(553,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(554,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(555,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(556,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(557,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(558,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL),
(559,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL),
(560,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL),
(561,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL),
(562,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL),
(563,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL),
(564,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL),
(565,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL),
(566,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL),
(567,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL),
(568,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL),
(569,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL),
(570,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (571,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL),
(572,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL),
(573,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:19','2017-09-25 10:23:19',NULL),
(574,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:19','2017-09-25 10:23:19',NULL),
(575,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:19','2017-09-25 10:23:19',NULL),
(576,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:20','2017-09-25 10:23:20',NULL),
(577,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:21','2017-09-25 10:23:21',NULL),
(578,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:22','2017-09-25 10:23:22',NULL),
(579,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:22','2017-09-25 10:23:22',NULL),
(580,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:22','2017-09-25 10:23:22',NULL),
(581,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:23','2017-09-25 10:23:23',NULL),
(582,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:23','2017-09-25 10:23:23',NULL),
(583,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:24','2017-09-25 10:23:24',NULL),
(584,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:24','2017-09-25 10:23:24',NULL),
(585,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:25','2017-09-25 10:23:25',NULL),
(586,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:25','2017-09-25 10:23:25',NULL),
(587,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:25','2017-09-25 10:23:25',NULL),
(588,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:26','2017-09-25 10:23:26',NULL),
(589,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:27','2017-09-25 10:23:27',NULL),
(590,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:27','2017-09-25 10:23:27',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (591,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:27','2017-09-25 10:23:27',NULL),
(592,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:28','2017-09-25 10:23:28',NULL),
(593,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:28','2017-09-25 10:23:28',NULL),
(594,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:29','2017-09-25 10:23:29',NULL),
(595,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:29','2017-09-25 10:23:29',NULL),
(596,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:30','2017-09-25 10:23:30',NULL),
(597,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:30','2017-09-25 10:23:30',NULL),
(598,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:30','2017-09-25 10:23:30',NULL),
(599,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:31','2017-09-25 10:23:31',NULL),
(600,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:31','2017-09-25 10:23:31',NULL),
(601,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:31','2017-09-25 10:23:31',NULL),
(602,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:32','2017-09-25 10:23:32',NULL),
(603,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:32','2017-09-25 10:23:32',NULL),
(604,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:32','2017-09-25 10:23:32',NULL),
(605,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL),
(606,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL),
(607,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL),
(608,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL),
(609,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL),
(610,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (611,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL),
(612,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL),
(613,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL),
(614,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:35','2017-09-25 10:23:35',NULL),
(615,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:35','2017-09-25 10:23:35',NULL),
(616,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:35','2017-09-25 10:23:35',NULL),
(617,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL),
(618,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL),
(619,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL),
(620,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL),
(621,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL),
(622,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL),
(623,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:37','2017-09-25 10:23:37',NULL),
(624,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:37','2017-09-25 10:23:37',NULL),
(625,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:37','2017-09-25 10:23:37',NULL),
(626,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL),
(627,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL),
(628,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL),
(629,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL),
(630,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:39','2017-09-25 10:23:39',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (631,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:39','2017-09-25 10:23:39',NULL),
(632,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:39','2017-09-25 10:23:39',NULL),
(633,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL),
(634,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL),
(635,'ITP / Carlisle opony i felgi do ','0','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL),
(636,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL),
(637,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL),
(638,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL),
(639,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:42','2017-09-25 10:23:42',NULL),
(640,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:42','2017-09-25 10:23:42',NULL),
(641,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:43','2017-09-25 10:23:43',NULL),
(642,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:43','2017-09-25 10:23:43',NULL),
(643,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:43','2017-09-25 10:23:43',NULL),
(644,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:44','2017-09-25 10:23:44',NULL),
(645,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:44','2017-09-25 10:23:44',NULL),
(646,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:44','2017-09-25 10:23:44',NULL),
(647,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:45','2017-09-25 10:23:45',NULL),
(648,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:46','2017-09-25 10:23:46',NULL),
(652,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL),
(653,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:23:58','2017-09-25 10:23:58',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (654,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:23:58','2017-09-25 10:23:58',NULL),
(655,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL),
(656,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL),
(657,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL),
(658,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL),
(659,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL),
(660,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL),
(661,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL),
(662,'KENDA opony samochodowe 4x4 MT i','0','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL),
(663,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL),
(664,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL),
(665,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL),
(666,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL),
(667,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL),
(668,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL),
(669,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL),
(670,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL),
(671,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL),
(672,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL),
(673,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (674,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL),
(675,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL),
(676,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL),
(677,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL),
(678,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL),
(679,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL),
(680,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL),
(681,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL),
(682,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL),
(683,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL),
(684,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL),
(685,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL),
(686,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL),
(687,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL),
(688,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL),
(689,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL),
(690,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL),
(691,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL),
(692,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL),
(693,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (694,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL),
(695,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL),
(696,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL),
(697,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL),
(698,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL),
(699,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL),
(700,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL),
(701,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL),
(702,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL),
(703,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL),
(704,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL),
(705,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL),
(706,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL),
(707,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL),
(708,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL),
(709,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL),
(710,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL),
(711,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL),
(712,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL),
(713,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (714,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL),
(715,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL),
(716,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL),
(717,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL),
(718,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL),
(719,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL),
(720,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL),
(721,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL),
(722,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL),
(723,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL),
(724,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL),
(725,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL),
(726,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL),
(727,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL),
(728,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL),
(729,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL),
(730,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL),
(731,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL),
(732,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL),
(733,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (734,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL),
(735,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL),
(736,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL),
(737,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL),
(738,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL),
(739,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL),
(740,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL),
(741,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL),
(742,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL),
(743,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL),
(744,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL),
(745,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL),
(746,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL),
(747,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL),
(748,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL),
(749,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL),
(750,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL),
(751,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL),
(752,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL),
(753,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (754,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL),
(756,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:20','2017-09-25 10:24:20',NULL),
(757,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:20','2017-09-25 10:24:20',NULL),
(758,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:20','2017-09-25 10:24:20',NULL),
(759,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL),
(760,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL),
(761,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL),
(762,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL),
(763,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL),
(764,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL),
(765,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL),
(766,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL),
(767,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL),
(768,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL),
(769,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL),
(770,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL),
(771,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL),
(772,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL),
(773,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL),
(774,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (775,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL),
(776,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL),
(777,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL),
(778,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL),
(779,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL),
(780,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL),
(781,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL),
(782,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL),
(783,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL),
(784,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL),
(785,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL),
(786,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL),
(787,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL),
(788,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL),
(789,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL),
(790,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL),
(791,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL),
(792,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL),
(793,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL),
(794,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (795,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL),
(796,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL),
(797,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL),
(798,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL),
(799,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL),
(800,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL),
(801,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL),
(802,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL),
(803,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL),
(804,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL),
(805,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL),
(806,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL),
(807,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL),
(808,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL),
(809,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL),
(810,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL),
(811,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL),
(812,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL),
(813,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL),
(814,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (815,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL),
(816,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL),
(817,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL),
(818,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL),
(819,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL),
(820,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL),
(821,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL),
(822,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL),
(823,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL),
(824,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL),
(825,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL),
(826,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL),
(827,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL),
(828,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL),
(829,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL),
(830,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL),
(831,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL),
(832,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL),
(833,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL),
(834,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (835,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL),
(836,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL),
(837,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL),
(838,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL),
(839,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL),
(840,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL),
(841,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL),
(842,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL),
(843,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL),
(844,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(845,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(846,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(847,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(848,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(849,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(850,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(851,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL),
(852,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL),
(853,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL),
(854,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (855,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL),
(856,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL),
(857,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL),
(858,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(859,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(860,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(861,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(862,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(863,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(864,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(865,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL),
(866,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL),
(867,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL),
(868,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL),
(869,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL),
(870,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL),
(871,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL),
(872,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL),
(873,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL),
(874,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (875,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL),
(876,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL),
(877,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL),
(878,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL),
(879,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(880,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(881,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(882,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(883,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(884,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(885,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(886,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL),
(887,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL),
(888,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL),
(889,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL),
(890,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL),
(891,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL),
(892,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL),
(893,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL),
(894,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (895,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL),
(896,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL),
(897,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL),
(898,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL),
(899,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL),
(900,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL),
(901,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL),
(902,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL),
(903,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL),
(904,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL),
(905,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL),
(906,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(907,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(908,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(909,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(910,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(911,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(912,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(913,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL),
(914,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (915,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL),
(916,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL),
(917,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL),
(918,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL),
(919,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL),
(920,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL),
(921,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL),
(922,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL),
(923,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL),
(924,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL),
(925,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL),
(926,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL),
(927,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL),
(928,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL),
(929,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL),
(930,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL),
(931,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL),
(932,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL),
(933,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL),
(934,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (935,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL),
(936,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL),
(937,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL),
(938,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL),
(939,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL),
(940,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL),
(941,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL),
(942,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL),
(943,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL),
(944,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL),
(945,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL),
(946,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL),
(947,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL),
(948,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL),
(949,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL),
(950,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL),
(951,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL),
(952,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL),
(953,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL),
(954,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (955,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL),
(956,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL),
(957,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL),
(958,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL),
(959,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL),
(960,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL),
(961,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL),
(962,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:53','2017-09-25 10:24:53',NULL),
(963,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:53','2017-09-25 10:24:53',NULL),
(964,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:54','2017-09-25 10:24:54',NULL),
(965,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:55','2017-09-25 10:24:55',NULL),
(966,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:56','2017-09-25 10:24:56',NULL),
(967,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:56','2017-09-25 10:24:56',NULL),
(968,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:56','2017-09-25 10:24:56',NULL),
(969,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL),
(970,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL),
(971,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL),
(972,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL),
(973,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL),
(974,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:58','2017-09-25 10:24:58',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (975,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:58','2017-09-25 10:24:58',NULL),
(976,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:58','2017-09-25 10:24:58',NULL),
(977,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:59','2017-09-25 10:24:59',NULL),
(978,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:24:59','2017-09-25 10:24:59',NULL),
(979,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL),
(980,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL),
(981,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL),
(982,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL),
(983,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:01','2017-09-25 10:25:01',NULL),
(984,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:01','2017-09-25 10:25:01',NULL),
(985,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:02','2017-09-25 10:25:02',NULL),
(986,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:02','2017-09-25 10:25:02',NULL),
(987,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:02','2017-09-25 10:25:02',NULL),
(988,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:03','2017-09-25 10:25:03',NULL),
(989,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:03','2017-09-25 10:25:03',NULL),
(990,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL),
(991,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL),
(992,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL),
(993,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL),
(994,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:05','2017-09-25 10:25:05',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (995,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL),
(996,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL),
(997,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL),
(998,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL),
(999,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL),
(1000,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:07','2017-09-25 10:25:07',NULL),
(1001,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL),
(1002,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL),
(1003,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL),
(1004,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL),
(1005,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL),
(1006,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL),
(1007,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL),
(1008,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL),
(1009,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL),
(1010,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL),
(1011,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL),
(1012,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL),
(1013,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL),
(1014,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1015,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL),
(1016,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL),
(1017,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL),
(1018,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL),
(1019,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL),
(1020,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL),
(1021,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1022,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1023,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1024,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1025,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1026,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1027,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1028,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL),
(1029,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL),
(1030,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL),
(1031,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL),
(1032,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL),
(1033,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL),
(1034,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1035,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL),
(1036,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL),
(1037,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL),
(1038,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL),
(1039,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL),
(1040,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL),
(1041,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL),
(1042,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL),
(1043,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL),
(1044,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL),
(1045,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL),
(1046,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL),
(1047,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL),
(1048,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL),
(1049,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL),
(1050,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL),
(1051,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL),
(1052,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL),
(1053,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL),
(1054,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1055,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL),
(1056,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL),
(1057,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL),
(1058,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL),
(1059,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL),
(1060,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL),
(1061,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL),
(1062,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL),
(1063,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL),
(1064,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL),
(1065,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL),
(1066,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL),
(1067,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL),
(1068,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL),
(1069,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL),
(1070,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL),
(1071,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL),
(1072,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL),
(1073,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL),
(1074,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1075,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL),
(1076,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL),
(1077,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL),
(1078,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL),
(1079,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL),
(1080,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL),
(1081,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL),
(1082,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1083,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1084,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1085,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1086,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1087,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1088,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1089,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1090,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL),
(1091,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL),
(1092,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL),
(1093,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL),
(1094,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1095,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL),
(1096,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL),
(1097,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL),
(1098,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL),
(1099,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL),
(1100,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL),
(1101,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL),
(1102,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL),
(1103,'KENDA opony i dętki motocyklowe ','0','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL),
(1104,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL),
(1105,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL),
(1106,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL),
(1107,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL),
(1108,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL),
(1109,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL),
(1110,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL),
(1111,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL),
(1112,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL),
(1113,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL),
(1114,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1115,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL),
(1116,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL),
(1117,'KENDA opony samochodowe osobowe,','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL),
(1118,'MAXXIS opony samochodowe 4x4 MT ','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL),
(1119,'MAXXIS opony samochodowe 4x4 MT ','0','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL),
(1120,'MAXXIS opony samochodowe 4x4 MT ','0','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL),
(1121,'MAXXIS opony samochodowe 4x4 MT ','0','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL),
(1122,'MAXXIS opony samochodowe 4x4 MT ','0','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL),
(1123,'DURO opony przemysłowe (traktork','0','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL),
(1124,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL),
(1125,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL),
(1126,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1127,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1128,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1129,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1130,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1131,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1132,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1133,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL),
(1134,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1135,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1136,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1137,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1138,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1139,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1140,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1141,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1142,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1143,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL),
(1144,'MAXXIS i NANKANG opony motocyklo','0','2017-09-25 10:25:40','2017-09-25 10:25:40',NULL),
(1145,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1146,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1147,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1148,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1149,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1150,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1151,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1152,'POWERTRAC opony samochodowe 4x4 ','0','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL),
(1153,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL),
(1154,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1155,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL),
(1156,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL),
(1157,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL),
(1158,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL),
(1159,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL),
(1160,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1161,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1162,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1163,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1164,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1165,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1166,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1167,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL),
(1168,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1169,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1170,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1171,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1172,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1173,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1174,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1175,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1176,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL),
(1177,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1178,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1179,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1180,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1181,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1182,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1183,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1184,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1185,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL),
(1186,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1187,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1188,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1189,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1190,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1191,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1192,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1193,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL),
(1194,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1195,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1196,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1197,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1198,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1199,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1200,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1201,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1202,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL),
(1203,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1204,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1205,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1206,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1207,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1208,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1209,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1210,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL),
(1211,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL),
(1212,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL),
(1213,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL),
(1214,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1215,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL),
(1216,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL),
(1217,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL),
(1218,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL),
(1219,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1220,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1221,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1222,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1223,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1224,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1225,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1226,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL),
(1227,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1228,'POWERTRAC opony do samochodów ci','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1229,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1230,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1231,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1232,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1233,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1234,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1235,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL),
(1236,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1237,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1238,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1239,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1240,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1241,'POWERTRAC opony do samochodów za','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1242,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1243,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL),
(1244,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1245,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1246,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1247,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1248,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1249,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1250,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1251,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL),
(1252,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL),
(1253,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL),
(1254,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1255,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL),
(1256,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL),
(1257,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL),
(1258,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1259,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1260,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1261,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1262,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1263,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1264,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1265,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL),
(1266,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1267,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1268,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1269,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1270,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1271,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1272,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1273,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL),
(1274,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1275,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL),
(1276,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL),
(1277,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL),
(1278,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL),
(1279,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL),
(1280,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL),
(1281,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL),
(1282,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL),
(1283,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL),
(1284,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL),
(1285,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL),
(1286,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL),
(1287,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL),
(1288,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL),
(1289,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL),
(1290,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL),
(1291,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL),
(1292,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL),
(1293,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL),
(1294,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1295,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL),
(1296,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1297,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1298,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1299,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1300,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1301,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1302,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1303,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL),
(1304,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL),
(1305,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL),
(1306,'POWERTRAC opony samochodowe osob','0','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL),
(1307,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL),
(1308,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:02','2017-09-25 10:26:02',NULL),
(1309,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:02','2017-09-25 10:26:02',NULL),
(1310,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:02','2017-09-25 10:26:02',NULL),
(1311,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL),
(1312,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL),
(1313,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL),
(1314,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1315,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL),
(1316,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL),
(1317,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL),
(1318,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL),
(1319,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL),
(1320,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL),
(1321,'SILVERSTONE opony samochodowe 4x','0','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL),
(1322,'SILVERSTONE opony samochodowe os','0','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL),
(1323,'SILVERSTONE opony samochodowe os','0','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL),
(1324,'SILVERSTONE opony samochodowe os','0','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL),
(1325,'SILVERSTONE opony samochodowe os','0','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL),
(1326,'SILVERSTONE opony samochodowe os','0','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL),
(1327,'SILVERSTONE opony samochodowe os','0','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL),
(1328,'SILVERSTONE opony samochodowe os','0','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL),
(1330,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL),
(1331,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL),
(1332,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:07','2017-09-25 10:26:07',NULL),
(1333,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:07','2017-09-25 10:26:07',NULL),
(1334,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:07','2017-09-25 10:26:07',NULL),
(1335,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:08','2017-09-25 10:26:08',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1336,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:08','2017-09-25 10:26:08',NULL),
(1337,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:08','2017-09-25 10:26:08',NULL),
(1338,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL),
(1339,'SUNF opony przemysłowe (traktork','0','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL),
(1340,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL),
(1341,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL),
(1342,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL),
(1343,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:10','2017-09-25 10:26:10',NULL),
(1344,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:10','2017-09-25 10:26:10',NULL),
(1345,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:10','2017-09-25 10:26:10',NULL),
(1346,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:11','2017-09-25 10:26:11',NULL),
(1347,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:11','2017-09-25 10:26:11',NULL),
(1349,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:55','2017-09-25 10:26:55',NULL),
(1350,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:55','2017-09-25 10:26:55',NULL),
(1351,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:55','2017-09-25 10:26:55',NULL),
(1352,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL),
(1353,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL),
(1354,'SUNF opony motocyklowe i skutero','0','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL),
(1355,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL),
(1356,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:57','2017-09-25 10:26:57',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1357,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:57','2017-09-25 10:26:57',NULL),
(1358,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:57','2017-09-25 10:26:57',NULL),
(1359,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL),
(1360,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL),
(1361,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL),
(1362,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL),
(1363,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:59','2017-09-25 10:26:59',NULL),
(1364,'CARLISLE paski do quadów Made in','0','2017-09-25 10:26:59','2017-09-25 10:26:59',NULL),
(1365,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:00','2017-09-25 10:27:00',NULL),
(1366,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:00','2017-09-25 10:27:00',NULL),
(1367,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL),
(1368,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL),
(1369,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL),
(1370,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL),
(1371,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL),
(1372,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL),
(1373,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:02','2017-09-25 10:27:02',NULL),
(1374,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:02','2017-09-25 10:27:02',NULL),
(1375,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:02','2017-09-25 10:27:02',NULL),
(1376,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:03','2017-09-25 10:27:03',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1377,'CARLISLE paski do quadów Made in','0','2017-09-25 10:27:04','2017-09-25 10:27:04',NULL),
(1378,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:06','2017-09-25 10:27:06',NULL),
(1379,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:06','2017-09-25 10:27:06',NULL),
(1380,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL),
(1381,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL),
(1382,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL),
(1383,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:08','2017-09-25 10:27:08',NULL),
(1384,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:08','2017-09-25 10:27:08',NULL),
(1385,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:08','2017-09-25 10:27:08',NULL),
(1386,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:09','2017-09-25 10:27:09',NULL),
(1387,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:09','2017-09-25 10:27:09',NULL),
(1388,'WANDA opony do samochodów osobow','0','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL),
(1389,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL),
(1390,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL),
(1391,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:11','2017-09-25 10:27:11',NULL),
(1392,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:11','2017-09-25 10:27:11',NULL),
(1393,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:11','2017-09-25 10:27:11',NULL),
(1394,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:12','2017-09-25 10:27:12',NULL),
(1395,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:12','2017-09-25 10:27:12',NULL),
(1396,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:12','2017-09-25 10:27:12',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1397,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:13','2017-09-25 10:27:13',NULL),
(1398,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:13','2017-09-25 10:27:13',NULL),
(1399,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL),
(1400,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL),
(1401,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL),
(1402,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL),
(1403,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL),
(1404,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL),
(1405,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL),
(1406,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL),
(1407,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL),
(1408,'WANDA opony do samochodów osobow','0','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL),
(1409,'WANDA opony do samochodów osobow','0','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL),
(1410,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL),
(1411,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL),
(1412,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL),
(1413,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:18','2017-09-25 10:27:18',NULL),
(1414,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:18','2017-09-25 10:27:18',NULL),
(1415,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:19','2017-09-25 10:27:19',NULL),
(1416,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:19','2017-09-25 10:27:19',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1417,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:20','2017-09-25 10:27:20',NULL),
(1418,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:20','2017-09-25 10:27:20',NULL),
(1419,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL),
(1420,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL),
(1421,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL),
(1422,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL),
(1423,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:22','2017-09-25 10:27:22',NULL),
(1424,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:22','2017-09-25 10:27:22',NULL),
(1425,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:22','2017-09-25 10:27:22',NULL),
(1426,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL),
(1427,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL),
(1428,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL),
(1429,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL),
(1430,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL),
(1431,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:24','2017-09-25 10:27:24',NULL),
(1432,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:24','2017-09-25 10:27:24',NULL),
(1433,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:24','2017-09-25 10:27:24',NULL),
(1434,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:25','2017-09-25 10:27:25',NULL),
(1435,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL),
(1436,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1437,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL),
(1438,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL),
(1439,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL),
(1440,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL),
(1441,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL),
(1442,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL),
(1443,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL),
(1444,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL),
(1445,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL),
(1446,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL),
(1447,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL),
(1448,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL),
(1449,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL),
(1450,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL),
(1451,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL),
(1452,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL),
(1453,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL),
(1454,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL),
(1455,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL),
(1456,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL);
insert into `manufacturers` (`manufacturers_id`, `manufacturers_name`, `manufacturers_image`, `date_added`, `last_modified`, `action`) values (1457,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL),
(1458,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL),
(1459,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL),
(1460,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL),
(1461,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL),
(1462,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL),
(1463,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL),
(1464,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL),
(1465,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL),
(1466,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL),
(1467,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL),
(1468,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL),
(1469,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL),
(1470,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL),
(1471,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL),
(1472,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL),
(1473,'WANDA/JOURNEY opony przemysłowe ','0','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL);

drop table if exists `manufacturers_info`;
CREATE TABLE `manufacturers_info` (
  `manufacturers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `manufacturers_url` varchar(255) NOT NULL,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  `manufacturers_htc_title_tag` varchar(80) DEFAULT NULL,
  `manufacturers_htc_desc_tag` longtext,
  `manufacturers_htc_keywords_tag` longtext,
  `manufacturers_htc_description` longtext,
  PRIMARY KEY (`manufacturers_id`,`languages_id`),
  KEY `idx_date_last_click` (`date_last_click`),
  KEY `idx_languages_id` (`languages_id`)
);

insert into `manufacturers_info` (`manufacturers_id`, `languages_id`, `manufacturers_url`, `url_clicked`, `date_last_click`, `manufacturers_htc_title_tag`, `manufacturers_htc_desc_tag`, `manufacturers_htc_keywords_tag`, `manufacturers_htc_description`) values (0,1,'',0,'0000-00-00 00:00:00',NULL,NULL,NULL,NULL);

drop table if exists `modules_configuration`;
CREATE TABLE `modules_configuration` (
  `configuration_id` int(4) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(100) NOT NULL,
  `configuration_value` varchar(50) NOT NULL,
  `configuration_description` varchar(50) NOT NULL,
  `location` int(2) NOT NULL,
  `max_display` varchar(3) NOT NULL,
  `info_id` int(2) NOT NULL,
  `header` int(1) NOT NULL,
  PRIMARY KEY (`configuration_id`),
  KEY `idx_configuration_value_location` (`configuration_value`,`location`)
);

insert into `modules_configuration` (`configuration_id`, `configuration_title`, `configuration_value`, `configuration_description`, `location`, `max_display`, `info_id`, `header`) values (7,'default_specials','yes','Promocje statyczne',5,'2',0,0),
(6,'main_categories','no','Kategorie produktów',3,'-',0,0),
(8,'default_specials_scroll','no','Promocje przewijane',6,'5',0,0),
(9,'newsdesk_sticky','no','Ważne informacje',1,'-',0,0),
(10,'star_product','no','Nasz hit',2,'-',0,0),
(12,'newsdesk','no','Aktualności',6,'-',0,0),
(13,'new_products_scroll','no','Nowości przewijane',2,'7',0,0),
(14,'new_products','yes','Nowości statyczne',9,'4',0,0),
(15,'featured','yes','Produkty polecane',4,'2',0,0),
(16,'upcoming_products','no','Produkty oczekiwane',10,'2',0,0),
(18,'info_pages','yes','Witamy w sklepie internetowym',1,'-',7,1),
(20,'advanced_search','yes','Wyszukiwanie',1,'-',0,0);

drop table if exists `newsdesk`;
CREATE TABLE `newsdesk` (
  `newsdesk_id` int(11) NOT NULL AUTO_INCREMENT,
  `newsdesk_image` varchar(64) DEFAULT NULL,
  `newsdesk_image_two` varchar(64) DEFAULT NULL,
  `newsdesk_image_three` varchar(64) DEFAULT NULL,
  `newsdesk_date_added` datetime NOT NULL,
  `newsdesk_last_modified` datetime DEFAULT NULL,
  `newsdesk_date_available` datetime DEFAULT NULL,
  `newsdesk_status` tinyint(1) NOT NULL DEFAULT '0',
  `newsdesk_sticky` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`newsdesk_id`),
  KEY `idx_newsdesk_date_added` (`newsdesk_date_added`),
  KEY `idx_newsdesk_status` (`newsdesk_status`)
);

drop table if exists `newsdesk_categories`;
CREATE TABLE `newsdesk_categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(64) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `sort_order` int(3) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `catagory_status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`categories_id`),
  KEY `idx_catagory_status` (`catagory_status`),
  KEY `idx_parent_id_cat_id` (`parent_id`,`categories_id`),
  KEY `idx_sort_order` (`sort_order`)
);

drop table if exists `newsdesk_categories_description`;
CREATE TABLE `newsdesk_categories_description` (
  `categories_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `categories_name` varchar(32) NOT NULL,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_id` (`categories_id`),
  KEY `idx_categories_name` (`categories_name`),
  KEY `idx_language_id` (`language_id`)
);

drop table if exists `newsdesk_configuration`;
CREATE TABLE `newsdesk_configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(64) NOT NULL,
  `configuration_key` varchar(64) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`configuration_id`),
  KEY `idx_configuration_group_id` (`configuration_group_id`),
  KEY `idx_configuration_key` (`configuration_key`),
  KEY `idx_configuration_key_value` (`configuration_key`,`configuration_value`),
  KEY `idx_configuration_value` (`configuration_value`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_sort_order` (`sort_order`)
);

insert into `newsdesk_configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1,'Wyniki wyszukiwania','MAX_DISPLAY_NEWSDESK_SEARCH_RESULTS','20','Ilość wyszukiwanych artykułów',1,1,NULL,'2003-02-16 02:08:36',NULL,NULL),
(2,'Ilość artykułów na stronie','MAX_DISPLAY_NEWSDESK_PAGE_LINKS','3','Ile pokazać artykułów na pojedyńczej stronie ?',1,2,'2009-05-14 22:13:04','2003-02-16 02:08:36',NULL,NULL),
(3,'Pokazuj tytuł artykułu','NEWSDESK_ARTICLE_NAME','2','Czy pokazać tytuł artykułu ? (0 = nie lub nr do sortowania na liście)',1,3,'2007-02-08 14:06:49','2003-02-16 02:08:36',NULL,NULL),
(4,'Pokazuj wstęp artykułu','NEWSDESK_ARTICLE_SHORTTEXT','3','Czy pokazać wstęp artykułu ? (0 = nie lub nr do sortowania na liście)',1,4,'2006-02-04 16:30:53','2003-02-16 02:08:36',NULL,NULL),
(5,'Pokazuj treść artykułu','NEWSDESK_ARTICLE_DESCRIPTION','0','Czy pokazać treść artykułu ? (0 = nie lub nr do sortowania na liście)',1,5,'2004-05-10 13:28:43','2003-02-16 02:08:36',NULL,NULL),
(6,'Pokazuj datę','NEWSDESK_DATE_AVAILABLE','0','Czy pokazać datę utworzenia artykułu ? (0 = nie lub nr do sortowania na liście)',1,6,'2007-02-08 14:06:25','2003-02-16 02:08:36',NULL,NULL),
(7,'Pokazuj URL artykułu','NEWSDESK_ARTICLE_URL','0','Czy pokazać odnośnik do zewnętrznej strony WWW ? (0 = nie lub nr do sortowania na liście)',1,7,'2004-11-11 12:44:38','2003-02-16 02:08:36',NULL,NULL),
(8,'Pokazuj nazwę URL','NEWSDESK_ARTICLE_URL_NAME','0','Czy pokazać nazwę odnośnika do zewnętrznej strony WWW ? (0 = nie lub nr do sortowania na liście)',1,8,'2004-11-11 12:44:44','2004-05-26 17:07:00',NULL,NULL),
(9,'Pokazuj status artykułu','NEWSDESK_STATUS','0','Czy pokazać status artykułu ? (0 = nie lub nr do sortowania na liście)',1,9,'2004-11-11 12:43:32','2003-02-16 02:08:36',NULL,NULL),
(10,'Pokazuj Zdjęcie nr 1','NEWSDESK_IMAGE','1','Czy pokazać Zdjęcie nr 1 ? (0 = nie lub nr do sortowania na liście)',1,10,'2007-02-08 14:06:40','2003-02-16 02:08:36',NULL,NULL),
(11,'Pokazuj Zdjęcie nr 2','NEWSDESK_IMAGE_TWO','1','Czy pokazać Zdjęcie nr 2 ? (0 = nie lub nr do sortowania na liście)',1,11,'2009-05-14 21:44:11','2003-02-16 02:08:36',NULL,NULL),
(12,'Pokazuj Zdjęcie nr 3','NEWSDESK_IMAGE_THREE','0','Czy pokazać Zdjęcie nr 3 ? (0 = nie lub nr do sortowania na liście)',1,12,'2004-05-10 13:29:06','2003-02-16 02:08:36',NULL,NULL),
(14,'Pasek nawigacyjny Poprzedni/Następny','NEWSDESK_PREV_NEXT_BAR_LOCATION','1','Czy pokazać pasek nawigacyjny Poprzedni/Następny ? (0 - włączone, 1 - wyłączone)',1,14,'2004-11-11 12:54:36','2003-02-16 02:08:36',NULL,NULL),
(15,'Ilość artykułów na stronie głównej','MAX_DISPLAY_NEWSDESK_NEWS','3','Ile artykułów pokazać na stronie głównej sklepu ?',2,1,'2009-05-14 22:54:29','2003-02-16 02:08:36',NULL,NULL),
(16,'Ilość artykułów w boxie Aktualności','LATEST_DISPLAY_NEWSDESK_NEWS','5','Ile artykułów pokazać w boxie Aktualności ?',2,2,NULL,'2003-02-16 02:08:36',NULL,NULL),
(19,'Pokazuj ilość odsłon artykułu','DISPLAY_NEWSDESK_VIEWCOUNT','1','Czy pokazać ilość odsłon artykułu ?',2,3,'2009-05-14 23:39:45','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(20,'Pokazuj odnośnik \"więcej\"','DISPLAY_NEWSDESK_READMORE','1','Czy pokazać odnośnik \"więcej\" ?',2,4,'2006-07-10 14:28:03','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(21,'Pokazuj wstęp artukułu','DISPLAY_NEWSDESK_SUMMARY','1','Czy pokazać wstęp artykułu ?',2,5,'2009-05-14 23:39:51','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(22,'Pokazuj tytuł artykułu','DISPLAY_NEWSDESK_HEADLINE','1','Czy pokazać wstęp artykułu ?',2,6,NULL,'2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(23,'Pokazuj datę','DISPLAY_NEWSDESK_DATE','0','Czy pokazać datę utworzenia artykułu ?',2,7,'2009-05-14 23:01:14','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),');
insert into `newsdesk_configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (24,'Pokazuj Zdjęcie nr 1','DISPLAY_NEWSDESK_IMAGE','1','Czy pokazać Zdjęcie nr 1 ?',2,8,NULL,'2003-03-03 11:59:47',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(25,'Pokazuj Zdjęcie nr 2','DISPLAY_NEWSDESK_IMAGE_TWO','1','Czy pokazać Zdjęcie nr 2 ?',2,9,'2004-11-11 13:27:03','2003-03-03 11:59:47',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(26,'Pokazuj Zdjęcie nr 3','DISPLAY_NEWSDESK_IMAGE_THREE','1','Czy pokazać Zdjęcie nr 3 ?',2,10,'2004-11-11 13:27:08','2003-03-03 11:59:47',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(27,'Pokazuj komentarze','DISPLAY_NEWSDESK_REVIEWS','1','Czy pokazywać komentarze do artykułów ?',3,1,'2009-05-14 22:14:50','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(29,'Pokazuj tytuł artykułu','STICKY_ARTICLE_NAME','1','Czy pokazać tytuł artykułu ?',4,1,NULL,'2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(30,'Pokazuj wstęp do artykułu','STICKY_ARTICLE_SHORTTEXT','1','Czy pokazać wstęp do artykułu ?',4,2,NULL,'2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(31,'Pokazuj treść artukułu','STICKY_ARTICLE_DESCRIPTION','1','Czy pokazać treść artykułu ?',4,3,'2009-05-14 23:39:22','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(32,'Pokazuj ilość odsłon artykułu','STICKY_NEWSDESK_VIEWCOUNT','1','Czy pokazać ilość odsłon artykułu ?',4,4,'2009-05-14 23:39:26','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(33,'Pokazuj odnośnik \"więcej\"','STICKY_NEWSDESK_READMORE','1','Czy pokazać odnośnik \"więcej\" ?',4,5,NULL,'2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(34,'Pokazuj datę','STICKY_DATE_ADDED','1','Czy pokazać datę utworzenia artykułu ?',4,6,'2009-05-14 23:39:31','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(35,'Pokazuj URL artykułu','STICKY_ARTICLE_URL','0','Czy pokazać URL do zewnętrznej strony WWW ?',4,7,'2004-05-26 17:13:50','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(36,'Pokazuj nazwę URL','STICKY_ARTICLE_URL_NAME','1','Czy pokazać nazwę URL do zewnętrznej strony WWW ?',4,8,'2003-03-02 00:51:00','2003-03-02 00:50:00',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(37,'Pokazuj Zdjęcie nr 1','STICKY_IMAGE','1','Czy pokazać Zdjęcie nr 1 ?',4,9,'2003-03-02 00:50:14','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(38,'Pokazuj Zdjęcie nr 2','STICKY_IMAGE_TWO','1','Czy pokazać Zdjęcie nr 2 ?',4,10,NULL,'2003-03-03 23:10:34',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(39,'Pokazuj Zdjęcie nr 3','STICKY_IMAGE_THREE','1','Czy pokazać Zdjęcie nr 3 ?',4,11,NULL,'2003-03-03 23:10:34',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(40,'Pokazuj datę dodania artykułu','NEWS_CZY_DATA','1','Czy pokazywać datę dodania artykułu ?',5,1,'2009-05-14 23:36:21','2009-05-14 22:24:08',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(41,'Pokazuj wstęp do artykułu','NEWS_CZY_WSTEP','1','Czy pokazywać wstęp do artykułu ?',5,2,'2009-05-14 23:36:38','2009-05-14 22:25:56',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(42,'Pokazuj nagłówek artykułu - WSTĘP','NEWS_CZY_WSTEP_NAGL','0','Czy pokazywać nagłowek  artykułu - WSTĘP ?',5,3,'2009-07-14 19:36:09','2009-05-14 22:27:08',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(43,'Pokazuj treść artykułu','NEWS_CZY_TRESC','1','Czy pokazywać treść artykułu ?',5,4,'2009-05-14 22:28:02','2009-05-14 22:28:04',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(44,'Pokazuj nagłowek artykułu - ZAWARTOŚĆ','NEWS_CZY_TRESC_NAGL','0','Czy pokazywać nagłowek  artykułu - ZAWARTOŚĆ ?',5,5,'2009-07-14 19:35:54','2009-05-14 22:28:52',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),');
insert into `newsdesk_configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (45,'Pokazuj dodatkowy link','NEWS_CZY_LINK','1','Czy pokazywać dodatkowy link ?',5,6,'2009-05-14 23:39:04','2009-05-14 22:29:59',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(46,'Pokazuj nagłowek artykułu - LINK','NEWS_CZY_LINK_NAGL','1','Czy pokazywać nagłowek  artykułu - LINK ?',5,7,'2009-05-14 22:30:33','2009-05-14 22:30:35',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(47,'Pokazuj statystyki artykułu','NEWS_CZY_STAT','1','Czy pokazywać statystyki artykułu ?',5,8,'2009-05-14 23:38:20','2009-05-14 22:31:25',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(48,'Pokazuj nagłowek artykułu - STATYSTYKI','NEWS_CZY_STAT_NAGL','1','Czy pokazywać nagłowek  artykułu - STATYSTYKI ?',5,8,'2009-05-14 23:39:08','2009-05-14 22:32:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(49,'Pokazuj zdjęcia artykułu','NEWS_CZY_FOTO','1','Czy pokazywać zdjęcia ?',5,9,'2009-05-14 23:38:52','2009-05-14 22:32:37','','tep_cfg_select_option(array(\'1\', \'0\'),');

drop table if exists `newsdesk_configuration_group`;
CREATE TABLE `newsdesk_configuration_group` (
  `configuration_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_group_title` varchar(64) NOT NULL,
  `configuration_group_description` varchar(255) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`),
  UNIQUE KEY `idx_visible_cfg` (`visible`,`configuration_group_id`),
  KEY `idx_visible` (`visible`)
);

insert into `newsdesk_configuration_group` (`configuration_group_id`, `configuration_group_title`, `configuration_group_description`, `sort_order`, `visible`) values (1,'Wygląd listy artykułów','',2,1),
(2,'Opcje aktualności','',1,1),
(3,'Opcje komentarzy','',3,1),
(4,'Opcje ważnych informacji','',4,1),
(5,'Wygląd pojedyńczego artykułu','',5,1);

drop table if exists `newsdesk_description`;
CREATE TABLE `newsdesk_description` (
  `newsdesk_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `newsdesk_article_name` varchar(64) NOT NULL,
  `newsdesk_article_description` text,
  `newsdesk_article_shorttext` text,
  `newsdesk_article_url` varchar(255) DEFAULT NULL,
  `newsdesk_article_url_name` varchar(255) DEFAULT NULL,
  `newsdesk_article_viewed` int(5) DEFAULT '0',
  `newsdesk_image_text` text,
  `newsdesk_image_text_two` text,
  `newsdesk_image_text_three` text,
  PRIMARY KEY (`newsdesk_id`,`language_id`),
  KEY `idx_newsdesk_article_name` (`newsdesk_article_name`)
);

drop table if exists `newsdesk_reviews`;
CREATE TABLE `newsdesk_reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `newsdesk_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `approved` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`reviews_id`)
);

drop table if exists `newsdesk_reviews_description`;
CREATE TABLE `newsdesk_reviews_description` (
  `reviews_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
);

drop table if exists `newsdesk_to_categories`;
CREATE TABLE `newsdesk_to_categories` (
  `newsdesk_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`newsdesk_id`,`categories_id`)
);

drop table if exists `newsletters`;
CREATE TABLE `newsletters` (
  `newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `module` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `locked` int(1) DEFAULT '0',
  PRIMARY KEY (`newsletters_id`)
);

drop table if exists `newsletters_tmp`;
CREATE TABLE `newsletters_tmp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lastname` varchar(40) DEFAULT NULL,
  `firstname` varchar(40) DEFAULT NULL,
  `email` varchar(80) NOT NULL,
  `subs_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
);

drop table if exists `onet_category_map`;
CREATE TABLE `onet_category_map` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_kategorii_sklepu` int(10) unsigned NOT NULL,
  `id_kategorii_pm` int(10) unsigned NOT NULL,
  `sciezka_kategorii` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
);

drop table if exists `optimize_check`;
CREATE TABLE `optimize_check` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `start_date` date NOT NULL,
  PRIMARY KEY (`counter`)
);

drop table if exists `orders`;
CREATE TABLE `orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_nr` int(11) NOT NULL DEFAULT '0',
  `invoice_date` int(11) NOT NULL DEFAULT '0',
  `invoice_proforma_nr` int(11) NOT NULL DEFAULT '0',
  `invoice_proforma_date` int(11) NOT NULL DEFAULT '0',
  `customers_id` int(11) NOT NULL,
  `customers_name` varchar(256) DEFAULT NULL,
  `customers_company` varchar(256) DEFAULT NULL,
  `customers_nip` varchar(32) DEFAULT NULL,
  `customers_street_address` varchar(64) NOT NULL,
  `customers_suburb` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) NOT NULL,
  `customers_postcode` varchar(10) NOT NULL,
  `customers_state` varchar(32) DEFAULT NULL,
  `customers_country` varchar(32) NOT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_email_address` varchar(96) NOT NULL,
  `customers_address_format_id` int(5) NOT NULL,
  `customers_dummy_account` tinyint(3) unsigned NOT NULL,
  `delivery_name` varchar(256) DEFAULT NULL,
  `delivery_company` varchar(256) DEFAULT NULL,
  `delivery_nip` varchar(32) DEFAULT NULL,
  `delivery_street_address` varchar(64) NOT NULL,
  `delivery_suburb` varchar(32) DEFAULT NULL,
  `delivery_city` varchar(32) NOT NULL,
  `delivery_postcode` varchar(10) NOT NULL,
  `delivery_state` varchar(32) DEFAULT NULL,
  `delivery_country` varchar(32) NOT NULL,
  `delivery_address_format_id` int(5) NOT NULL,
  `billing_name` varchar(256) DEFAULT NULL,
  `billing_company` varchar(256) DEFAULT NULL,
  `billing_nip` varchar(32) DEFAULT NULL,
  `billing_street_address` varchar(64) NOT NULL,
  `billing_suburb` varchar(32) DEFAULT NULL,
  `billing_city` varchar(32) NOT NULL,
  `billing_postcode` varchar(10) NOT NULL,
  `billing_state` varchar(32) DEFAULT NULL,
  `billing_country` varchar(32) NOT NULL,
  `billing_address_format_id` int(5) NOT NULL,
  `payment_method` varchar(255) NOT NULL,
  `payment_info` text,
  `cc_type` varchar(20) DEFAULT NULL,
  `cc_owner` varchar(64) DEFAULT NULL,
  `cc_number` varchar(32) DEFAULT NULL,
  `cc_expires` varchar(4) DEFAULT NULL,
  `giftwrap` varchar(20) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `orders_status` int(5) NOT NULL,
  `orders_date_finished` datetime DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `currency_value` decimal(14,6) DEFAULT NULL,
  `shipping_tax` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `shipping_module` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`orders_id`),
  KEY `idx_date_purchased` (`date_purchased`),
  KEY `idx_orders_status` (`orders_status`),
  KEY `idx_status_orders_cust` (`orders_status`,`orders_id`,`customers_id`)
);

drop table if exists `orders_products`;
CREATE TABLE `orders_products` (
  `orders_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `products_model` varchar(32) DEFAULT NULL,
  `products_pkwiu` varchar(24) NOT NULL DEFAULT '0',
  `products_name` varchar(64) NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `final_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_tax` decimal(7,4) NOT NULL,
  `products_quantity` int(6) NOT NULL,
  `products_stock_attributes` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`orders_products_id`),
  KEY `idx_orders_id_prod_id` (`orders_id`,`products_id`),
  KEY `idx_products_id` (`products_id`),
  KEY `idx_orders_id` (`orders_id`)
);

drop table if exists `orders_products_attributes`;
CREATE TABLE `orders_products_attributes` (
  `orders_products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_options` varchar(32) NOT NULL,
  `products_options_values` varchar(32) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  PRIMARY KEY (`orders_products_attributes_id`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_orders_id_prod_id` (`orders_id`,`orders_products_id`)
);

drop table if exists `orders_products_download`;
CREATE TABLE `orders_products_download` (
  `orders_products_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `orders_products_filename` varchar(255) NOT NULL,
  `download_maxdays` int(2) NOT NULL,
  `download_count` int(2) NOT NULL,
  PRIMARY KEY (`orders_products_download_id`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_orders_products_id` (`orders_products_id`)
);

drop table if exists `orders_status`;
CREATE TABLE `orders_status` (
  `orders_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `orders_status_name` varchar(128) NOT NULL,
  `public_flag` int(11) DEFAULT '1',
  `downloads_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`orders_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`orders_status_name`)
);

insert into `orders_status` (`orders_status_id`, `language_id`, `orders_status_name`, `public_flag`, `downloads_flag`) values (1,1,'Zamówienie otrzymane',1,0),
(1,2,'Order received',1,0),
(1,3,'Auftrag empfangen',1,0),
(1,4,'Полученный заказ',1,0),
(2,1,'Zamówienie przyjęte',1,0),
(2,2,'Order accepted',1,0),
(2,3,'Auftrag angenommen',1,0),
(2,4,'Заказ принял',1,0),
(3,1,'Zamówienie realizowane',1,1),
(3,2,'Order realized',1,1),
(3,3,'Auftrag verwirklichte',1,1),
(3,4,'Заказ осуществил',1,1),
(4,1,'Zamówione towary wysłane',1,1),
(4,2,'Ordered commodities sent',1,1),
(4,3,'Bestellte Gebrauchsgüter gesendet',1,1),
(4,4,'Приказанные товары послали',1,1),
(5,4,'Разрешить Загрузить',1,1),
(5,3,'Lassen Download',1,1),
(5,2,'Allow Download',1,1),
(5,1,'Plik do pobrania',1,1);

drop table if exists `orders_status_history`;
CREATE TABLE `orders_status_history` (
  `orders_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_status_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `customer_notified` int(1) DEFAULT '0',
  `comments` text,
  PRIMARY KEY (`orders_status_history_id`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_orders_id_status_id` (`orders_id`,`orders_status_id`)
);

drop table if exists `orders_text_attributes`;
CREATE TABLE `orders_text_attributes` (
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `products_id` varchar(50) NOT NULL,
  `products_text_attributes_id` int(11) NOT NULL DEFAULT '0',
  `products_text_attributes_text` text NOT NULL,
  PRIMARY KEY (`orders_id`,`products_id`,`products_text_attributes_id`)
);

drop table if exists `orders_total`;
CREATE TABLE `orders_total` (
  `orders_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` varchar(255) NOT NULL,
  `value` decimal(15,4) NOT NULL,
  `class` varchar(32) NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`orders_total_id`),
  KEY `idx_class` (`class`),
  KEY `idx_orders_id` (`orders_id`)
);

drop table if exists `pages`;
CREATE TABLE `pages` (
  `pages_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `page_type` char(1) DEFAULT NULL,
  PRIMARY KEY (`pages_id`),
  KEY `idx_sort_order` (`sort_order`),
  KEY `idx_status` (`status`)
);

insert into `pages` (`pages_id`, `sort_order`, `status`, `page_type`) values (5,1,1,'1'),
(2,2,1,'2'),
(3,3,1,'4'),
(7,1,1,'5');

drop table if exists `pages_description`;
CREATE TABLE `pages_description` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pages_id` int(11) DEFAULT NULL,
  `pages_title` varchar(128) NOT NULL,
  `pages_html_text` text,
  `intorext` char(1) DEFAULT NULL,
  `externallink` varchar(255) DEFAULT NULL,
  `link_target` char(1) DEFAULT NULL,
  `language_id` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_language_id` (`language_id`),
  KEY `idx_pages_id` (`pages_id`)
);

insert into `pages_description` (`id`, `pages_id`, `pages_title`, `pages_html_text`, `intorext`, `externallink`, `link_target`, `language_id`) values (17,5,'Regulamin','Regulamin sklepu<br>','0','','0',1),
(5,2,'Kontakt','<p><strong><br>\r\r
</strong></p>','0','','0',1),
(9,3,'Dostawa','<strong>Wysyłka <br>\r\r
</strong>jest realizowana w dwóch wariantach:<br>\r\r
1. Poczta Polska - przedmioty o standardowych wymiarach, paczka do 25 kg.<br>\r\r
2. Dowolnym kurierem -przedmioty nadwymiarowe i bardzo ciężkie.<br>\r\r
Koszty wysyłki pokrywa kupujący. Przy zakupach powyżej 600 zł koszty przesyłki pokrywa sprzedający. (UWAGA dla przesyłek nadwymiarowych wysyłanych kurierem max. kwota rabatu za przesyłkę to 30zł- reszte pokrywa kupujący) <br>\r\r
<br>\r\r
<strong>Zwroty</strong><br>\r\r
zakupionych towarów są przyjmowane tylko pod warunkiem, że nie były używane, posiadają orginalne opakowanie, są dostarczone w komplecie (wraz z dołączonym osprzętem). Pieniądze za zwrócony towar zostaną wysłane na podane konto lub adres w ciągu 7 dni roboczych. Koszty zwrotów ponosi kupujący<br>\r\r
. Reklamacje dotyczące uszkodzeń mechanicznych powstałych podczas transportu bądź rozpatrywane tylko na podstawie protokołu reklamacyjnego spisanego w obecności doręczyciela. Pokrywamy koszty przesyłek wynikłych z błędnej realizacji zamówienia przez nasz sklep. UWAGA: sprawdź zawartość przesyłki w obecności dostarczajšcej jš osoby! Zwroty i reklamacje powinny być adresowane na adres podany w danych kontaktowych sklepu.','0','','0',1),
(25,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',1),
(66,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',2),
(67,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',3),
(68,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',4),
(69,5,'Regulamin','<br>','0','','0',2),
(70,5,'Regulamin','<br>','0','','0',3),
(71,5,'Regulamin','<br>','0','','0',4),
(72,2,'Kontakt','<br>','0','','0',2),
(73,2,'Kontakt','<br>','0','','0',3),
(74,2,'Kontakt','<br>','0','','0',4),
(75,3,'Dostawa','<br>','0','','0',2),
(76,3,'Dostawa','<br>','0','','0',3),
(77,3,'Dostawa','<br>','0','','0',4);

drop table if exists `phesis_comments`;
CREATE TABLE `phesis_comments` (
  `commentid` int(11) NOT NULL AUTO_INCREMENT,
  `pollid` int(11) DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `date` datetime DEFAULT NULL,
  `name` varchar(60) NOT NULL,
  `host_name` varchar(60) DEFAULT NULL,
  `comment` text NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`commentid`)
);

drop table if exists `phesis_poll_check`;
CREATE TABLE `phesis_poll_check` (
  `ip` varchar(20) NOT NULL,
  `time` varchar(14) NOT NULL,
  `pollID` int(10) NOT NULL DEFAULT '0'
);

drop table if exists `phesis_poll_config`;
CREATE TABLE `phesis_poll_config` (
  `configuration_id` int(5) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(64) NOT NULL,
  `configuration_key` varchar(64) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`configuration_id`)
);

insert into `phesis_poll_config` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `last_modified`, `date_added`) values (1,'Sposób wyświetlania ankiet w sklepie','DISPLAY_POLL_HOW','2','Określa sposób wyświetlania ankiet w sklepie.\r\r
\r\r
0 = losowo\r\r
1 = najnowsze\r\r
2 = najbardziej popularne\r\r
3 = po konkretnym numerze ID','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(2,'Id ankiety','DISPLAY_POLL_ID','','Jeżeli chcesz, aby wyświetlała się tylko jedna sonda wprowadź tutaj jej nr ID.','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(3,'Zezwalaj na komentarze','SHOW_POLL_COMMENTS','1','Włącz lub Wyłącz komentarze.\r\r
\r\r
0 = Wyłączone\r\r
1 = Włączone','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(4,'Informacja zamiast ankiety w boxie','SHOW_NOPOLL','0','Jeżeli nie ma ankiety do wyświetlania, czy wyświetlać komunikat o braku ankiet w danej kategorii ? Komunikat jest wyświetlany w boxie Ankieta zamiast sondy.\r\r
\r\r
0 = Nie pokazywać informacjie\r\r
1 = Pokazywać informacje','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(5,'Głosowanie więcej niż jeden raz przez klienta','POLL_SPAM','0','Pozwól klientom na głosowanie więcej niż raz.\r\r
\r\r
0 = Nie (zalecane)\r\r
1 = Tak (przydatne do testowania)','2009-07-14 10:25:41','2009-02-27 18:22:30');

drop table if exists `phesis_poll_data`;
CREATE TABLE `phesis_poll_data` (
  `pollID` int(11) NOT NULL DEFAULT '0',
  `optionText` varchar(255) NOT NULL,
  `optionCount` int(11) NOT NULL DEFAULT '0',
  `voteID` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  KEY `idx_pollID` (`pollID`,`voteID`)
);

drop table if exists `phesis_poll_desc`;
CREATE TABLE `phesis_poll_desc` (
  `pollID` int(11) NOT NULL AUTO_INCREMENT,
  `timeStamp` datetime DEFAULT NULL,
  `voters` mediumint(9) NOT NULL DEFAULT '0',
  `poll_type` char(1) NOT NULL DEFAULT '0',
  `poll_open` char(1) NOT NULL DEFAULT '0',
  `catID` int(11) NOT NULL DEFAULT '0',
  `prodID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pollID`)
);

drop table if exists `porownywarki`;
CREATE TABLE `porownywarki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nazwa` varchar(30) NOT NULL,
  `kategorie` text,
  PRIMARY KEY (`id`)
);

insert into `porownywarki` (`id`, `nazwa`, `kategorie`) values (1,'okazje',''),
(2,'skapiec',''),
(3,'ceneo',''),
(4,'nokaut',''),
(5,'sklepy24',''),
(6,'cenus',''),
(7,'radar',''),
(8,'oferciak',''),
(9,'torturacen',''),
(10,'totu',''),
(11,'kupujemy',''),
(12,'smartbay',''),
(13,'starcode_xml',''),
(14,'cenohit',''),
(15,'pkt',''),
(16,'taniopl','');

drop table if exists `products`;
CREATE TABLE `products` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` int(5) NOT NULL,
  `products_quantity` int(6) NOT NULL,
  `products_model` varchar(30) DEFAULT NULL,
  `products_pkwiu` varchar(24) NOT NULL DEFAULT '0',
  `products_image` varchar(150) DEFAULT NULL,
  `products_image_pop` varchar(150) DEFAULT NULL,
  `products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_retail_price` decimal(15,4) DEFAULT NULL,
  `products_date_added` datetime NOT NULL,
  `products_last_modified` datetime DEFAULT NULL,
  `products_date_available` datetime DEFAULT NULL,
  `products_weight` decimal(7,4) NOT NULL,
  `products_status` tinyint(1) NOT NULL,
  `products_tax_class_id` int(11) NOT NULL,
  `products_maxorder` int(4) DEFAULT NULL,
  `manufacturers_id` int(11) DEFAULT NULL,
  `products_ordered` int(11) NOT NULL DEFAULT '0',
  `products_availability_id` varchar(255) DEFAULT NULL,
  `products_jm_id` varchar(32) DEFAULT NULL,
  `products_adminnotes` varchar(255) DEFAULT NULL,
  `emo_source` int(11) DEFAULT '0',
  `emo_pn` varchar(65) DEFAULT NULL,
  `emo_paczka` varchar(64) DEFAULT NULL,
  `emo_dostawca` varchar(64) DEFAULT NULL,
  `emo_kreskowy` varchar(64) DEFAULT NULL,
  `emo_nrdostawcy` varchar(64) DEFAULT NULL,
  `emo_uwagi` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`products_id`),
  KEY `idx_manufacturers_id` (`manufacturers_id`),
  KEY `idx_products_date_added` (`products_date_added`),
  KEY `idx_products_date_available` (`products_date_available`),
  KEY `idx_products_model` (`products_model`),
  KEY `idx_products_ordered` (`products_ordered`),
  KEY `idx_products_status` (`products_status`)
);

insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1,0,0,'1856515','',NULL,NULL,'100.0000','0.0000','2017-09-12 13:24:03','2017-09-12 11:45:10',NULL,'0.0000',1,4,NULL,NULL,0,'','','',0,NULL,NULL,NULL,NULL,NULL,NULL),
(2,0,0,'','','',NULL,'200.0000','0.0000','2017-09-12 13:25:29',NULL,NULL,'0.0000',1,4,NULL,0,0,'','','',0,NULL,NULL,NULL,NULL,NULL,NULL),
(3,0,1,'2256516','0',NULL,NULL,'0.0000','0.0000','2017-09-12 11:37:59','2017-09-12 11:45:10',NULL,'0.0000',1,0,NULL,NULL,0,'',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL),
(107,0,4,'227_CAA22711VERSA','0','brak_obrazka.jpg',NULL,'425.2000','0.0000','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL,'14.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAA22711VERSA',''),
(110,0,2,'227_CAA42810VERSA','0','brak_obrazka.jpg',NULL,'443.9000','0.0000','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL,'13.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAA42810VERSA',''),
(106,0,4,'227_CAA2269VERSA_','0','brak_obrazka.jpg',NULL,'361.7900','0.0000','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL,'11.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','070964056009','227_CAA2269VERSA_',''),
(105,0,4,'227_CAA22611VERSA','0','brak_obrazka.jpg',NULL,'421.9500','0.0000','2017-09-25 10:20:11','2017-09-25 10:20:11',NULL,'13.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','070964056016','227_CAA22611VERSA',''),
(108,0,4,'227_CAA2279VERSA_','0','brak_obrazka.jpg',NULL,'370.7300','0.0000','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL,'12.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAA2279VERSA_',''),
(109,0,2,'227_CAA42711VERSA','0','brak_obrazka.jpg',NULL,'452.8500','0.0000','2017-09-25 10:20:12','2017-09-25 10:20:12',NULL,'14.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','070964056030','227_CAA42711VERSA',''),
(111,0,2,'227_CAA42812VERSA','0','brak_obrazka.jpg',NULL,'485.3700','0.0000','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL,'15.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAA42812VERSA',''),
(112,0,50,'227_CAD0900TR150_','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAD0900TR150_',''),
(113,0,35,'227_CAD12812_____','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAD12812_____',''),
(114,0,42,'227_CAD47.5______','0','brak_obrazka.jpg',NULL,'26.0200','0.0000','2017-09-25 10:20:13','2017-09-25 10:20:13',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAD47.5______',''),
(115,0,39,'227_CAD65.5______','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:20:14','2017-09-25 10:20:14',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAD65.5______',''),
(116,0,50,'227_CAD84.80_____','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:20:14','2017-09-25 10:20:14',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAD84.80_____',''),
(117,0,4,'227_CAI0650ULTRA_','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:20:14','2017-09-25 10:20:14',NULL,'12.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI0650ULTRA_',''),
(118,0,2,'227_CAI15SL5IMPL_','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:20:15','2017-09-25 10:20:15',NULL,'5.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI15SL5IMPL_',''),
(119,0,5,'227_CAI2483FARM__','0','brak_obrazka.jpg',NULL,'408.9400','0.0000','2017-09-25 10:20:15','2017-09-25 10:20:15',NULL,'30.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI2483FARM__',''),
(120,0,38,'227_CAI511L-15SL_','0','brak_obrazka.jpg',NULL,'143.0900','0.0000','2017-09-25 10:20:15','2017-09-25 10:20:15',NULL,'14.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI511L-15SL_',''),
(121,0,15,'227_CAI613400XTRA','0','brak_obrazka.jpg',NULL,'39.0200','0.0000','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL,'1.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI613400XTRA','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (122,0,50,'227_CAI614450SLUG','0','brak_obrazka.jpg',NULL,'53.6600','0.0000','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL,'2.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI614450SLUG',''),
(123,0,5,'227_CAI8480GFULTR','0','brak_obrazka.jpg',NULL,'54.4700','0.0000','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI8480GFULTR',''),
(124,0,29,'227_CAI8480SMOOTH','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:20:16','2017-09-25 10:20:16',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CAI8480SMOOTH',''),
(125,0,50,'227_CPAL02_______','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:20:17','2017-09-25 10:20:17',NULL,'1.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','5600488100367','227_CPAL02_______',''),
(126,0,30,'227_CPAL04B4_____','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:20:17','2017-09-25 10:20:17',NULL,'1.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CPAL04B4_____',''),
(127,0,5,'227_CPAL07_______','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:20:17','2017-09-25 10:20:17',NULL,'1.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CPAL07_______',''),
(128,0,38,'227_CPPAL02______','0','brak_obrazka.jpg',NULL,'69.9200','0.0000','2017-09-25 10:20:18','2017-09-25 10:20:18',NULL,'0.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CPPAL02______',''),
(129,0,4,'227_CSP5410301___','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:20:18','2017-09-25 10:20:18',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP5410301___',''),
(130,0,2,'227_CSP541031____','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:20:18','2017-09-25 10:20:18',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP541031____',''),
(131,0,10,'227_CSP70606_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:18','2017-09-25 10:20:18',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70606_____',''),
(132,0,20,'227_CSP70610_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70610_____',''),
(133,0,22,'227_CSP70613_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70613_____',''),
(134,0,5,'227_CSP70623_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70623_____',''),
(135,0,4,'227_CSP70629_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:19','2017-09-25 10:20:19',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70629_____',''),
(136,0,10,'227_CSP70639_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:20','2017-09-25 10:20:20',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70639_____',''),
(137,0,22,'227_CSP70651_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:21','2017-09-25 10:20:21',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70651_____',''),
(138,0,9,'227_CSP70664_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:21','2017-09-25 10:20:21',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70664_____',''),
(139,0,3,'227_CSP70689_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70689_____',''),
(140,0,20,'227_CSP70702_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70702_____',''),
(141,0,10,'227_CSP70720_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70720_____','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (142,0,46,'227_CSP70764_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:22','2017-09-25 10:20:22',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70764_____',''),
(143,0,46,'227_CSP70765_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70765_____',''),
(144,0,3,'227_CSP70767_____','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_CSP70767_____',''),
(145,0,50,'227_DAN980013____','0','brak_obrazka.jpg',NULL,'30.8900','0.0000','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DAN980013____',''),
(146,0,25,'227_DDE27530021__','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:20:23','2017-09-25 10:20:23',NULL,'0.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DDE27530021__',''),
(147,0,4,'227_DDE30035010__','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:20:24','2017-09-25 10:20:24',NULL,'0.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DDE30035010__',''),
(148,0,31,'227_DDE30035018__','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:20:24','2017-09-25 10:20:24',NULL,'0.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DDE30035018__',''),
(149,0,14,'227_DDE35040010__','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:20:24','2017-09-25 10:20:24',NULL,'0.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DDE35040010__',''),
(150,0,38,'227_DDE35040018__','0','brak_obrazka.jpg',NULL,'25.2000','0.0000','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL,'0.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DDE35040018__',''),
(151,0,16,'227_DDE45052018__','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL,'0.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DDE45052018__',''),
(152,0,40,'227_DUDL31557000L','0','brak_obrazka.jpg',NULL,'117.0700','0.0000','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL,'7.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866247','227_DUDL31557000L',''),
(153,0,8,'227_DUDL31657000L','0','brak_obrazka.jpg',NULL,'141.4600','0.0000','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL,'8.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866445','227_DUDL31657000L',''),
(154,0,50,'227_DUDL319550DC7','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:20:25','2017-09-25 10:20:25',NULL,'9.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379585537','227_DUDL319550DC7',''),
(155,0,10,'227_DUDL416570721','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL,'8.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862522','227_DUDL416570721',''),
(156,0,50,'227_DUDL41857000L','0','brak_obrazka.jpg',NULL,'134.1500','0.0000','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866223','227_DUDL41857000L',''),
(157,0,3,'227_DUDL418575721','0','brak_obrazka.jpg',NULL,'191.0600','0.0000','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL,'11.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862546','227_DUDL418575721',''),
(158,0,50,'227_DUDL519570721','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL,'12.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863789','227_DUDL519570721',''),
(159,0,29,'227_DUDL519580721','0','brak_obrazka.jpg',NULL,'167.4800','0.0000','2017-09-25 10:20:26','2017-09-25 10:20:26',NULL,'13.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862676','227_DUDL519580721',''),
(160,0,30,'227_DUDL520570721','0','brak_obrazka.jpg',NULL,'160.1600','0.0000','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL,'13.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862829','227_DUDL520570721',''),
(161,0,50,'227_DUDL521570721','0','brak_obrazka.jpg',NULL,'168.2900','0.0000','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL,'14.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944868678','227_DUDL521570721','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (162,0,3,'227_DUDL618575721','0','brak_obrazka.jpg',NULL,'172.3600','0.0000','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL,'12.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863802','227_DUDL618575721',''),
(163,0,32,'227_DUDL619565721','0','brak_obrazka.jpg',NULL,'154.4700','0.0000','2017-09-25 10:20:27','2017-09-25 10:20:27',NULL,'12.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863796','227_DUDL619565721',''),
(164,0,50,'227_DUDL619575DC7','0','brak_obrazka.jpg',NULL,'170.7300','0.0000','2017-09-25 10:20:28','2017-09-25 10:20:28',NULL,'13.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866254','227_DUDL619575DC7',''),
(165,0,50,'227_DUDL620565721','0','brak_obrazka.jpg',NULL,'167.4800','0.0000','2017-09-25 10:20:28','2017-09-25 10:20:28',NULL,'13.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862836','227_DUDL620565721',''),
(166,0,31,'227_DUDL620575730','0','brak_obrazka.jpg',NULL,'173.9800','0.0000','2017-09-25 10:20:28','2017-09-25 10:20:28',NULL,'15.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866261','227_DUDL620575730',''),
(167,0,17,'227_DUDL621565721','0','brak_obrazka.jpg',NULL,'169.9200','0.0000','2017-09-25 10:20:29','2017-09-25 10:20:29',NULL,'14.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862843','227_DUDL621565721',''),
(168,0,16,'227_DUDL622565721','0','brak_obrazka.jpg',NULL,'207.3200','0.0000','2017-09-25 10:20:29','2017-09-25 10:20:29',NULL,'12.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862850','227_DUDL622565721',''),
(169,0,50,'227_DUG51045242__','0','brak_obrazka.jpg',NULL,'58.5400','0.0000','2017-09-25 10:20:29','2017-09-25 10:20:29',NULL,'1.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379586763','227_DUG51045242__',''),
(170,0,50,'227_DUG51045242B_','0','brak_obrazka.jpg',NULL,'59.3500','0.0000','2017-09-25 10:20:29','2017-09-25 10:20:29',NULL,'1.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379586749','227_DUG51045242B_',''),
(171,0,50,'227_DUG51171242__','0','brak_obrazka.jpg',NULL,'76.4200','0.0000','2017-09-25 10:20:29','2017-09-25 10:20:29',NULL,'2.0150',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379586787','227_DUG51171242__',''),
(172,0,50,'227_DUG51171242B_','0','brak_obrazka.jpg',NULL,'77.2400','0.0000','2017-09-25 10:20:30','2017-09-25 10:20:30',NULL,'1.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379586756','227_DUG51171242B_',''),
(173,0,50,'227_DUKATALOG____','0','brak_obrazka.jpg',NULL,'10.5700','0.0000','2017-09-25 10:20:30','2017-09-25 10:20:30',NULL,'0.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DUKATALOG____',''),
(174,0,50,'227_DUKATALOGATV_','0','brak_obrazka.jpg',NULL,'10.5700','0.0000','2017-09-25 10:20:30','2017-09-25 10:20:30',NULL,'0.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DUKATALOGATV_',''),
(175,0,3,'227_DUMO012070295','0','brak_obrazka.jpg',NULL,'42.2800','0.0000','2017-09-25 10:20:31','2017-09-25 10:20:31',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177163','227_DUMO012070295',''),
(176,0,17,'227_DUMO012070Q02','0','brak_obrazka.jpg',NULL,'42.2800','0.0000','2017-09-25 10:20:31','2017-09-25 10:20:31',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177170','227_DUMO012070Q02',''),
(177,0,2,'227_DUMO027511005','0','brak_obrazka.jpg',NULL,'47.9700','0.0000','2017-09-25 10:20:31','2017-09-25 10:20:31',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869071','227_DUMO027511005',''),
(178,0,7,'227_DUMO1300HF335','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:20:32','2017-09-25 10:20:32',NULL,'3.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588576','227_DUMO1300HF335',''),
(179,0,20,'227_DUMO180100HF_','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:20:32','2017-09-25 10:20:32',NULL,'3.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864533','227_DUMO180100HF_',''),
(180,0,9,'227_DUMO180100HF9','0','brak_obrazka.jpg',NULL,'116.2600','0.0000','2017-09-25 10:20:33','2017-09-25 10:20:33',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864526','227_DUMO180100HF9',''),
(181,0,1,'227_DUMO190901160','0','brak_obrazka.jpg',NULL,'129.2700','0.0000','2017-09-25 10:20:33','2017-09-25 10:20:33',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224176999','227_DUMO190901160','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (182,0,10,'227_DUMO1909HF903','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:20:33','2017-09-25 10:20:33',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864557','227_DUMO1909HF903',''),
(183,0,8,'227_DUMO513090HF2','0','brak_obrazka.jpg',NULL,'196.7500','0.0000','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588606','227_DUMO513090HF2',''),
(184,0,21,'227_DUMO514090HF2','0','brak_obrazka.jpg',NULL,'202.4400','0.0000','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864021','227_DUMO514090HF2',''),
(185,0,31,'227_DUMO515081003','0','brak_obrazka.jpg',NULL,'208.9400','0.0000','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224176975','227_DUMO515081003',''),
(186,0,30,'227_DUMO517080HF2','0','brak_obrazka.jpg',NULL,'237.4000','0.0000','2017-09-25 10:20:34','2017-09-25 10:20:34',NULL,'8.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177781','227_DUMO517080HF2',''),
(187,0,15,'227_DUMO610080DM1','0','brak_obrazka.jpg',NULL,'101.6300','0.0000','2017-09-25 10:20:35','2017-09-25 10:20:35',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177743','227_DUMO610080DM1',''),
(188,0,9,'227_DUMO610080DM7','0','brak_obrazka.jpg',NULL,'104.0700','0.0000','2017-09-25 10:20:35','2017-09-25 10:20:35',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177750','227_DUMO610080DM7',''),
(189,0,25,'227_DUMO610090HF9','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:20:36','2017-09-25 10:20:36',NULL,'3.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864052','227_DUMO610090HF9',''),
(190,0,2,'227_DUMO612070DM2','0','brak_obrazka.jpg',NULL,'121.9500','0.0000','2017-09-25 10:20:37','2017-09-25 10:20:37',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224176913','227_DUMO612070DM2',''),
(191,0,8,'227_DUMO612080DM1','0','brak_obrazka.jpg',NULL,'143.0900','0.0000','2017-09-25 10:20:37','2017-09-25 10:20:37',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177002','227_DUMO612080DM1',''),
(192,0,9,'227_DUMO612080DM7','0','brak_obrazka.jpg',NULL,'152.0300','0.0000','2017-09-25 10:20:37','2017-09-25 10:20:37',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177774','227_DUMO612080DM7',''),
(193,0,3,'227_DUMO612080HF9','0','brak_obrazka.jpg',NULL,'160.9800','0.0000','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864069','227_DUMO612080HF9',''),
(194,0,9,'227_DUMO613090296','0','brak_obrazka.jpg',NULL,'198.3700','0.0000','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL,'6.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864090','227_DUMO613090296',''),
(195,0,31,'227_DUMO616080HF2','0','brak_obrazka.jpg',NULL,'291.8700','0.0000','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864120','227_DUMO616080HF2',''),
(196,0,8,'227_DUMO6250HF308','0','brak_obrazka.jpg',NULL,'50.4100','0.0000','2017-09-25 10:20:38','2017-09-25 10:20:38',NULL,'1.5800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869149','227_DUMO6250HF308',''),
(197,0,33,'227_DUMO6300HF308','0','brak_obrazka.jpg',NULL,'68.2900','0.0000','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL,'2.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177019','227_DUMO6300HF308',''),
(198,0,28,'227_DUMO6350HF319','0','brak_obrazka.jpg',NULL,'107.3200','0.0000','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL,'3.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869217','227_DUMO6350HF319',''),
(199,0,5,'227_DUMO67090348_','0','brak_obrazka.jpg',NULL,'73.1700','0.0000','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL,'2.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864960','227_DUMO67090348_',''),
(200,0,13,'227_DUMO68080314_','0','brak_obrazka.jpg',NULL,'82.9300','0.0000','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL,'2.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177033','227_DUMO68080314_',''),
(201,0,1,'227_DUMO68080348_','0','brak_obrazka.jpg',NULL,'78.8600','0.0000','2017-09-25 10:20:39','2017-09-25 10:20:39',NULL,'2.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864977','227_DUMO68080348_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (202,0,1,'227_DUMO68090348_','0','brak_obrazka.jpg',NULL,'75.6100','0.0000','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL,'2.4100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864984','227_DUMO68090348_',''),
(203,0,10,'227_DUMO710080HF2','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL,'3.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177255','227_DUMO710080HF2',''),
(204,0,21,'227_DUMO71008918_','0','brak_obrazka.jpg',NULL,'112.2000','0.0000','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL,'3.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869378','227_DUMO71008918_',''),
(205,0,50,'227_DUMO711070HF9','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:20:40','2017-09-25 10:20:40',NULL,'3.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864175','227_DUMO711070HF9',''),
(206,0,5,'227_DUMO712080HF2','0','brak_obrazka.jpg',NULL,'143.9000','0.0000','2017-09-25 10:20:41','2017-09-25 10:20:41',NULL,'3.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588620','227_DUMO712080HF2',''),
(207,0,11,'227_DUMO712081003','0','brak_obrazka.jpg',NULL,'140.6500','0.0000','2017-09-25 10:20:41','2017-09-25 10:20:41',NULL,'3.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177262','227_DUMO712081003',''),
(208,0,50,'227_DUMO713070HF9','0','brak_obrazka.jpg',NULL,'171.5400','0.0000','2017-09-25 10:20:41','2017-09-25 10:20:41',NULL,'5.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869248','227_DUMO713070HF9',''),
(209,0,19,'227_DUMO71308904_','0','brak_obrazka.jpg',NULL,'186.9900','0.0000','2017-09-25 10:20:42','2017-09-25 10:20:42',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864205','227_DUMO71308904_',''),
(210,0,46,'227_DUMO714070HF9','0','brak_obrazka.jpg',NULL,'177.2400','0.0000','2017-09-25 10:20:42','2017-09-25 10:20:42',NULL,'5.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864229','227_DUMO714070HF9',''),
(211,0,50,'227_DUMO7225301__','0','brak_obrazka.jpg',NULL,'48.7800','0.0000','2017-09-25 10:20:43','2017-09-25 10:20:43',NULL,'1.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869132','227_DUMO7225301__',''),
(212,0,8,'227_DUMO7225HF303','0','brak_obrazka.jpg',NULL,'45.5300','0.0000','2017-09-25 10:20:43','2017-09-25 10:20:43',NULL,'1.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177279','227_DUMO7225HF303',''),
(213,0,50,'227_DUMO7250HF301','0','brak_obrazka.jpg',NULL,'56.1000','0.0000','2017-09-25 10:20:43','2017-09-25 10:20:43',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869156','227_DUMO7250HF301',''),
(214,0,35,'227_DUMO7250HF319','0','brak_obrazka.jpg',NULL,'60.1600','0.0000','2017-09-25 10:20:44','2017-09-25 10:20:44',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588415','227_DUMO7250HF319',''),
(215,0,4,'227_DUMO7300319__','0','brak_obrazka.jpg',NULL,'72.3600','0.0000','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL,'2.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588521','227_DUMO7300319__',''),
(216,0,50,'227_DUMO7300HF331','0','brak_obrazka.jpg',NULL,'50.4100','0.0000','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL,'2.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179785','227_DUMO7300HF331',''),
(217,0,50,'227_DUMO7325319__','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL,'2.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588682','227_DUMO7325319__',''),
(218,0,50,'227_DUMO7350308__','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL,'3.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177286','227_DUMO7350308__',''),
(219,0,10,'227_DUMO7460333__','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:20:45','2017-09-25 10:20:45',NULL,'5.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869330','227_DUMO7460333__',''),
(220,0,20,'227_DUMO7460HF335','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL,'3.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864168','227_DUMO7460HF335',''),
(221,0,19,'227_DUMO770100HF3','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL,'2.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864168','227_DUMO770100HF3','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (222,0,19,'227_DUMO79090261_','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL,'3.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869231','227_DUMO79090261_',''),
(223,0,10,'227_DUMO810010054','0','brak_obrazka.jpg',NULL,'170.7300','0.0000','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177101','227_DUMO810010054',''),
(224,0,10,'227_DUMO8100100HF','0','brak_obrazka.jpg',NULL,'165.0400','0.0000','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864274','227_DUMO8100100HF',''),
(225,0,1,'227_DUMO810090HF9','0','brak_obrazka.jpg',NULL,'145.5300','0.0000','2017-09-25 10:20:46','2017-09-25 10:20:46',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864267','227_DUMO810090HF9',''),
(226,0,5,'227_DUMO811010053','0','brak_obrazka.jpg',NULL,'184.5500','0.0000','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177804','227_DUMO811010053',''),
(227,0,4,'227_DUMO811010054','0','brak_obrazka.jpg',NULL,'174.8000','0.0000','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177118','227_DUMO811010054',''),
(228,0,20,'227_DUMO8110100HF','0','brak_obrazka.jpg',NULL,'147.1500','0.0000','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864281','227_DUMO8110100HF',''),
(229,0,6,'227_DUMO812090158','0','brak_obrazka.jpg',NULL,'168.2900','0.0000','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177125','227_DUMO812090158',''),
(230,0,6,'227_DUMO812090HF9','0','brak_obrazka.jpg',NULL,'196.7500','0.0000','2017-09-25 10:20:47','2017-09-25 10:20:47',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864335','227_DUMO812090HF9',''),
(231,0,24,'227_DUMO814080115','0','brak_obrazka.jpg',NULL,'199.1900','0.0000','2017-09-25 10:20:48','2017-09-25 10:20:48',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177132','227_DUMO814080115',''),
(232,0,16,'227_DUMO8275HF319','0','brak_obrazka.jpg',NULL,'73.1700','0.0000','2017-09-25 10:20:48','2017-09-25 10:20:48',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588514','227_DUMO8275HF319',''),
(233,0,36,'227_DUMO8300HF333','0','brak_obrazka.jpg',NULL,'100.8100','0.0000','2017-09-25 10:20:49','2017-09-25 10:20:49',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869255','227_DUMO8300HF333',''),
(234,0,50,'227_DUMO8350HF308','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:20:49','2017-09-25 10:20:49',NULL,'3.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588484','227_DUMO8350HF308',''),
(235,0,35,'227_DUMO8400DM123','0','brak_obrazka.jpg',NULL,'140.6500','0.0000','2017-09-25 10:20:49','2017-09-25 10:20:49',NULL,'4.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177149','227_DUMO8400DM123',''),
(236,0,50,'227_DUMO8400HF307','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177156','227_DUMO8400HF307',''),
(237,0,3,'227_DUMO8410HF333','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL,'4.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588453','227_DUMO8410HF333',''),
(238,0,36,'227_DUMO8410HF335','0','brak_obrazka.jpg',NULL,'107.3200','0.0000','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL,'3.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864403','227_DUMO8410HF335',''),
(239,0,17,'227_DUMO8460HF335','0','brak_obrazka.jpg',NULL,'148.7800','0.0000','2017-09-25 10:20:50','2017-09-25 10:20:50',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864427','227_DUMO8460HF335',''),
(240,0,1,'227_DUMO8510333__','0','brak_obrazka.jpg',NULL,'54.4700','0.0000','2017-09-25 10:20:51','2017-09-25 10:20:51',NULL,'6.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588439','227_DUMO8510333__',''),
(241,0,6,'227_DUMO880100261','0','brak_obrazka.jpg',NULL,'103.2500','0.0000','2017-09-25 10:20:51','2017-09-25 10:20:51',NULL,'3.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177040','227_DUMO880100261','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (242,0,19,'227_DUMO89090HF__','0','brak_obrazka.jpg',NULL,'112.2000','0.0000','2017-09-25 10:20:51','2017-09-25 10:20:51',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177057','227_DUMO89090HF__',''),
(243,0,9,'227_DUMO910090HF3','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588644','227_DUMO910090HF3',''),
(244,0,5,'227_DUMO910090HF9','0','brak_obrazka.jpg',NULL,'181.3000','0.0000','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864465','227_DUMO910090HF9',''),
(245,0,2,'227_DUMO911010012','0','brak_obrazka.jpg',NULL,'69.9200','0.0000','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588392','227_DUMO911010012',''),
(246,0,50,'227_DUMO911010032','0','brak_obrazka.jpg',NULL,'69.9200','0.0000','2017-09-25 10:20:52','2017-09-25 10:20:52',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177217','227_DUMO911010032',''),
(247,0,34,'227_DUMO911090296','0','brak_obrazka.jpg',NULL,'153.6600','0.0000','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL,'5.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864502','227_DUMO911090296',''),
(248,0,50,'227_DUMO9350HF307','0','brak_obrazka.jpg',NULL,'122.7600','0.0000','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177224','227_DUMO9350HF307',''),
(249,0,50,'227_DUMO9350HF308','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588712','227_DUMO9350HF308',''),
(250,0,37,'227_DUMO9350HF311','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:20:53','2017-09-25 10:20:53',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588729','227_DUMO9350HF311',''),
(251,0,29,'227_DUMO9400307__','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:20:54','2017-09-25 10:20:54',NULL,'4.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177231','227_DUMO9400307__',''),
(252,0,13,'227_DUMO9400308__','0','brak_obrazka.jpg',NULL,'160.9800','0.0000','2017-09-25 10:20:54','2017-09-25 10:20:54',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588699','227_DUMO9400308__',''),
(253,0,44,'227_DUMO9400DM123','0','brak_obrazka.jpg',NULL,'159.3500','0.0000','2017-09-25 10:20:54','2017-09-25 10:20:54',NULL,'5.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177248','227_DUMO9400DM123',''),
(254,0,30,'227_DUOL314580300','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:20:55','2017-09-25 10:20:55',NULL,'5.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866926','227_DUOL314580300',''),
(255,0,50,'227_DUOL315565300','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:20:55','2017-09-25 10:20:55',NULL,'5.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866933','227_DUOL315565300',''),
(256,0,50,'227_DUOL315580300','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866810','227_DUOL315580300',''),
(257,0,38,'227_DUOL316565300','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL,'6.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866957','227_DUOL316565300',''),
(258,0,50,'227_DUOL316570300','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866834','227_DUOL316570300',''),
(259,0,32,'227_DUOL317560800','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:20:56','2017-09-25 10:20:56',NULL,'6.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379585742','227_DUOL317560800',''),
(260,0,50,'227_DUOL317570300','0','brak_obrazka.jpg',NULL,'93.5000','0.0000','2017-09-25 10:20:57','2017-09-25 10:20:57',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866001','227_DUOL317570300',''),
(261,0,2,'227_DUOL320560300','0','brak_obrazka.jpg',NULL,'143.0900','0.0000','2017-09-25 10:20:57','2017-09-25 10:20:57',NULL,'8.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_DUOL320560300','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (262,0,50,'227_DUOL415565300','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:20:57','2017-09-25 10:20:57',NULL,'6.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862515','227_DUOL415565300',''),
(263,0,38,'227_DUOL416560300','0','brak_obrazka.jpg',NULL,'82.1100','0.0000','2017-09-25 10:20:58','2017-09-25 10:20:58',NULL,'6.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862805','227_DUOL416560300',''),
(264,0,41,'227_DUOL416565300','0','brak_obrazka.jpg',NULL,'80.4900','0.0000','2017-09-25 10:20:58','2017-09-25 10:20:58',NULL,'6.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866964','227_DUOL416565300',''),
(265,0,50,'227_DUOL416570300','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL,'6.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866988','227_DUOL416570300',''),
(266,0,1,'227_DUOL417565300','0','brak_obrazka.jpg',NULL,'96.7500','0.0000','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL,'7.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866292','227_DUOL417565300',''),
(267,0,50,'227_DUOL417565301','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL,'7.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944868609','227_DUOL417565301',''),
(268,0,50,'227_DUOL417570300','0','brak_obrazka.jpg',NULL,'108.1300','0.0000','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL,'7.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863529','227_DUOL417570300',''),
(269,0,28,'227_DUOL418555300','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:20:59','2017-09-25 10:20:59',NULL,'7.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862799','227_DUOL418555300',''),
(270,0,6,'227_DUOL4185603D0','0','brak_obrazka.jpg',NULL,'93.5000','0.0000','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866025','227_DUOL4185603D0',''),
(271,0,50,'227_DUOL418565300','0','brak_obrazka.jpg',NULL,'103.2500','0.0000','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL,'7.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866049','227_DUOL418565300',''),
(272,0,50,'227_DUOL418570301','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL,'7.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866315','227_DUOL418570301',''),
(273,0,26,'227_DUOL418575300','0','brak_obrazka.jpg',NULL,'128.4600','0.0000','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL,'8.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863574','227_DUOL418575300',''),
(274,0,38,'227_DUOL419560300','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:21:00','2017-09-25 10:21:00',NULL,'7.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866063','227_DUOL419560300',''),
(275,0,31,'227_DUOL419565300','0','brak_obrazka.jpg',NULL,'135.7700','0.0000','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL,'8.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866087','227_DUOL419565300',''),
(276,0,32,'227_DUOL419570300','0','brak_obrazka.jpg',NULL,'114.6300','0.0000','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL,'8.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863628','227_DUOL419570300',''),
(277,0,17,'227_DUOL420570300','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863680','227_DUOL420570300',''),
(278,0,1,'227_DUOL420575300','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:21:01','2017-09-25 10:21:01',NULL,'10.2100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863703','227_DUOL420575300',''),
(279,0,35,'227_DUOL515560300','0','brak_obrazka.jpg',NULL,'118.7000','0.0000','2017-09-25 10:21:02','2017-09-25 10:21:02',NULL,'6.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862669','227_DUOL515560300',''),
(280,0,30,'227_DUOL517555300','0','brak_obrazka.jpg',NULL,'103.2500','0.0000','2017-09-25 10:21:02','2017-09-25 10:21:02',NULL,'7.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944868661','227_DUOL517555300',''),
(281,0,10,'227_DUOL517565300','0','brak_obrazka.jpg',NULL,'98.3700','0.0000','2017-09-25 10:21:02','2017-09-25 10:21:02',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863505','227_DUOL517565300','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (282,0,50,'227_DUOL518555300','0','brak_obrazka.jpg',NULL,'117.0700','0.0000','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL,'7.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863581','227_DUOL518555300',''),
(283,0,50,'227_DUOL518560301','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL,'8.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944868623','227_DUOL518560301',''),
(284,0,50,'227_DUOL518565300','0','brak_obrazka.jpg',NULL,'95.9300','0.0000','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL,'8.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866841','227_DUOL518565300',''),
(285,0,2,'227_DUOL518565301','0','brak_obrazka.jpg',NULL,'95.9300','0.0000','2017-09-25 10:21:03','2017-09-25 10:21:03',NULL,'7.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863543','227_DUOL518565301',''),
(286,0,4,'227_DUOL5195503D0','0','brak_obrazka.jpg',NULL,'104.0700','0.0000','2017-09-25 10:21:04','2017-09-25 10:21:04',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866322','227_DUOL5195503D0',''),
(287,0,50,'227_DUOL519550800','0','brak_obrazka.jpg',NULL,'100.0000','0.0000','2017-09-25 10:21:04','2017-09-25 10:21:04',NULL,'8.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866322','227_DUOL519550800',''),
(288,0,50,'227_DUOL519555300','0','brak_obrazka.jpg',NULL,'108.1300','0.0000','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL,'8.8900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866339','227_DUOL519555300',''),
(289,0,50,'227_DUOL519560301','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL,'8.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863604','227_DUOL519560301',''),
(290,0,50,'227_DUOL5195603D0','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866100','227_DUOL5195603D0',''),
(291,0,50,'227_DUOL519565300','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:21:05','2017-09-25 10:21:05',NULL,'8.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866124','227_DUOL519565300',''),
(292,0,50,'227_DUOL519565301','0','brak_obrazka.jpg',NULL,'122.7600','0.0000','2017-09-25 10:21:06','2017-09-25 10:21:06',NULL,'9.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379585735','227_DUOL519565301',''),
(293,0,50,'227_DUOL5195653D0','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:21:06','2017-09-25 10:21:06',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863611','227_DUOL5195653D0',''),
(294,0,33,'227_DUOL520560300','0','brak_obrazka.jpg',NULL,'126.8300','0.0000','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL,'9.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866148','227_DUOL520560300',''),
(295,0,25,'227_DUOL52056030V','0','brak_obrazka.jpg',NULL,'126.8300','0.0000','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863666','227_DUOL52056030V',''),
(296,0,14,'227_DUOL520565300','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL,'10.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866162','227_DUOL520565300',''),
(297,0,50,'227_DUOL520565301','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL,'10.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944868616','227_DUOL520565301',''),
(298,0,14,'227_DUOL520570300','0','brak_obrazka.jpg',NULL,'146.3400','0.0000','2017-09-25 10:21:07','2017-09-25 10:21:07',NULL,'10.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863697','227_DUOL520570300',''),
(299,0,12,'227_DUOL520575300','0','brak_obrazka.jpg',NULL,'160.1600','0.0000','2017-09-25 10:21:08','2017-09-25 10:21:08',NULL,'10.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863710','227_DUOL520575300',''),
(300,0,38,'227_DUOL521560300','0','brak_obrazka.jpg',NULL,'149.5900','0.0000','2017-09-25 10:21:08','2017-09-25 10:21:08',NULL,'10.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866186','227_DUOL521560300',''),
(301,0,6,'227_DUOL521565300','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:21:08','2017-09-25 10:21:08',NULL,'10.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866353','227_DUOL521565300','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (302,0,20,'227_DUOL521570300','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:21:09','2017-09-25 10:21:09',NULL,'10.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863727','227_DUOL521570300',''),
(303,0,26,'227_DUOL521575300','0','brak_obrazka.jpg',NULL,'191.0600','0.0000','2017-09-25 10:21:09','2017-09-25 10:21:09',NULL,'11.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863734','227_DUOL521575300',''),
(304,0,16,'227_DUOL522570300','0','brak_obrazka.jpg',NULL,'171.5400','0.0000','2017-09-25 10:21:10','2017-09-25 10:21:10',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863741','227_DUOL522570300',''),
(305,0,36,'227_DUOL522575300','0','brak_obrazka.jpg',NULL,'193.5000','0.0000','2017-09-25 10:21:11','2017-09-25 10:21:11',NULL,'12.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863758','227_DUOL522575300',''),
(306,0,36,'227_DUOL523575300','0','brak_obrazka.jpg',NULL,'195.9300','0.0000','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL,'12.5800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863765','227_DUOL523575300',''),
(307,0,50,'227_DUOL620555800','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862584','227_DUOL620555800',''),
(308,0,50,'227_DUOL620555801','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL,'11.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944862577','227_DUOL620555801',''),
(309,0,33,'227_DUOL620560300','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL,'10.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866377','227_DUOL620560300',''),
(310,0,50,'227_DUOL62056030H','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:21:12','2017-09-25 10:21:12',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863673','227_DUOL62056030H',''),
(311,0,50,'227_DUOL621555300','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:21:13','2017-09-25 10:21:13',NULL,'10.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866384','227_DUOL621555300',''),
(312,0,50,'227_DUOL621555301','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:21:13','2017-09-25 10:21:13',NULL,'11.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944868654','227_DUOL621555301',''),
(313,0,50,'227_DUOL621560301','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:21:14','2017-09-25 10:21:14',NULL,'11.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944868630','227_DUOL621560301',''),
(314,0,20,'227_DUOL621560302','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:21:14','2017-09-25 10:21:14',NULL,'11.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866209','227_DUOL621560302',''),
(315,0,19,'227_DUOL622560300','0','brak_obrazka.jpg',NULL,'156.9100','0.0000','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL,'11.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866391','227_DUOL622560300',''),
(316,0,50,'227_DUOL720550801','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866551','227_DUOL720550801',''),
(317,0,50,'227_DUOL722545801','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944866285','227_DUOL722545801',''),
(318,0,50,'227_DUOL822540800','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:21:15','2017-09-25 10:21:15',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379585698','227_DUOL822540800',''),
(319,0,13,'227_DUR018102020_','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:21:16','2017-09-25 10:21:16',NULL,'6.4100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174032','227_DUR018102020_',''),
(320,0,18,'227_DUR01962019__','0','brak_obrazka.jpg',NULL,'170.7300','0.0000','2017-09-25 10:21:16','2017-09-25 10:21:16',NULL,'4.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174056','227_DUR01962019__',''),
(321,0,1,'227_DUR0196-42012','0','brak_obrazka.jpg',NULL,'168.2900','0.0000','2017-09-25 10:21:16','2017-09-25 10:21:16',NULL,'4.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174049','227_DUR0196-42012','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (322,0,50,'227_DUR0207K102A_','0','brak_obrazka.jpg',NULL,'59.3500','0.0000','2017-09-25 10:21:17','2017-09-25 10:21:17',NULL,'3.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174063','227_DUR0207K102A_',''),
(323,0,8,'227_DUR0217-22019','0','brak_obrazka.jpg',NULL,'191.8700','0.0000','2017-09-25 10:21:17','2017-09-25 10:21:17',NULL,'5.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589306','227_DUR0217-22019',''),
(324,0,22,'227_DUR0217-42012','0','brak_obrazka.jpg',NULL,'147.1500','0.0000','2017-09-25 10:21:17','2017-09-25 10:21:17',NULL,'4.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174520','227_DUR0217-42012',''),
(325,0,22,'227_DUR0220-22003','0','brak_obrazka.jpg',NULL,'186.1800','0.0000','2017-09-25 10:21:17','2017-09-25 10:21:17',NULL,'5.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589030','227_DUR0220-22003',''),
(326,0,12,'227_DUR0220-22020','0','brak_obrazka.jpg',NULL,'249.5900','0.0000','2017-09-25 10:21:17','2017-09-25 10:21:17',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589320','227_DUR0220-22020',''),
(327,0,23,'227_DUR0220-2247_','0','brak_obrazka.jpg',NULL,'234.9600','0.0000','2017-09-25 10:21:18','2017-09-25 10:21:18',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589245','227_DUR0220-2247_',''),
(328,0,19,'227_DUR0220-42013','0','brak_obrazka.jpg',NULL,'217.8900','0.0000','2017-09-25 10:21:18','2017-09-25 10:21:18',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174070','227_DUR0220-42013',''),
(329,0,11,'227_DUR0221-42011','0','brak_obrazka.jpg',NULL,'213.8200','0.0000','2017-09-25 10:21:18','2017-09-25 10:21:18',NULL,'7.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174537','227_DUR0221-42011',''),
(330,0,18,'227_DUR0227-22003','0','brak_obrazka.jpg',NULL,'186.9900','0.0000','2017-09-25 10:21:18','2017-09-25 10:21:18',NULL,'5.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589078','227_DUR0227-22003',''),
(331,0,28,'227_DUR0227-22015','0','brak_obrazka.jpg',NULL,'185.3700','0.0000','2017-09-25 10:21:19','2017-09-25 10:21:19',NULL,'5.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589351','227_DUR0227-22015',''),
(332,0,20,'227_DUR0227-42012','0','brak_obrazka.jpg',NULL,'145.5300','0.0000','2017-09-25 10:21:19','2017-09-25 10:21:19',NULL,'5.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589214','227_DUR0227-42012',''),
(333,0,10,'227_DUR0227-42019','0','brak_obrazka.jpg',NULL,'211.3800','0.0000','2017-09-25 10:21:19','2017-09-25 10:21:19',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587364','227_DUR0227-42019',''),
(334,0,16,'227_DUR0227-4247_','0','brak_obrazka.jpg',NULL,'183.7400','0.0000','2017-09-25 10:21:20','2017-09-25 10:21:20',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588965','227_DUR0227-4247_',''),
(335,0,30,'227_DUR0237-42010','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:21:20','2017-09-25 10:21:20',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588989','227_DUR0237-42010',''),
(336,0,26,'227_DUR025102010_','0','brak_obrazka.jpg',NULL,'344.7200','0.0000','2017-09-25 10:21:20','2017-09-25 10:21:20',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587357','227_DUR025102010_',''),
(337,0,18,'227_DUR02512025__','0','brak_obrazka.jpg',NULL,'319.5100','0.0000','2017-09-25 10:21:20','2017-09-25 10:21:20',NULL,'11.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174087','227_DUR02512025__',''),
(338,0,3,'227_DUR1238-42010','0','brak_obrazka.jpg',NULL,'210.5700','0.0000','2017-09-25 10:21:20','2017-09-25 10:21:20',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174278','227_DUR1238-42010',''),
(339,0,12,'227_DUR12402010__','0','brak_obrazka.jpg',NULL,'285.3700','0.0000','2017-09-25 10:21:20','2017-09-25 10:21:20',NULL,'10.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587371','227_DUR12402010__',''),
(340,0,38,'227_DUR12402025__','0','brak_obrazka.jpg',NULL,'340.6500','0.0000','2017-09-25 10:21:21','2017-09-25 10:21:21',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174285','227_DUR12402025__',''),
(341,0,30,'227_DUR1248-42010','0','brak_obrazka.jpg',NULL,'221.9500','0.0000','2017-09-25 10:21:21','2017-09-25 10:21:21',NULL,'8.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589160','227_DUR1248-42010','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (342,0,2,'227_DUR1249-42010','0','brak_obrazka.jpg',NULL,'256.1000','0.0000','2017-09-25 10:21:22','2017-09-25 10:21:22',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589177','227_DUR1249-42010',''),
(343,0,50,'227_DUR22302024__','0','brak_obrazka.jpg',NULL,'210.5700','0.0000','2017-09-25 10:21:22','2017-09-25 10:21:22',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174292','227_DUR22302024__',''),
(344,0,50,'227_DUR22382024__','0','brak_obrazka.jpg',NULL,'174.8000','0.0000','2017-09-25 10:21:22','2017-09-25 10:21:22',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174308','227_DUR22382024__',''),
(345,0,12,'227_DUR22412010__','0','brak_obrazka.jpg',NULL,'306.5000','0.0000','2017-09-25 10:21:22','2017-09-25 10:21:22',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587395','227_DUR22412010__',''),
(346,0,5,'227_DUR22482010__','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:21:23','2017-09-25 10:21:23',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174315','227_DUR22482010__',''),
(347,0,2,'227_DUR22482025__','0','brak_obrazka.jpg',NULL,'287.8000','0.0000','2017-09-25 10:21:23','2017-09-25 10:21:23',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174322','227_DUR22482025__',''),
(348,0,50,'227_DUR2250-42013','0','brak_obrazka.jpg',NULL,'228.4600','0.0000','2017-09-25 10:21:24','2017-09-25 10:21:24',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174339','227_DUR2250-42013',''),
(349,0,39,'227_DUR2250-62010','0','brak_obrazka.jpg',NULL,'350.4100','0.0000','2017-09-25 10:21:24','2017-09-25 10:21:24',NULL,'12.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587098','227_DUR2250-62010',''),
(350,0,50,'227_DUR2250-62025','0','brak_obrazka.jpg',NULL,'305.6900','0.0000','2017-09-25 10:21:24','2017-09-25 10:21:24',NULL,'12.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589399','227_DUR2250-62025',''),
(351,0,50,'227_DUR2250-62037','0','brak_obrazka.jpg',NULL,'297.5600','0.0000','2017-09-25 10:21:25','2017-09-25 10:21:25',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588958','227_DUR2250-62037',''),
(352,0,31,'227_DUR2250D2036_','0','brak_obrazka.jpg',NULL,'278.0500','0.0000','2017-09-25 10:21:25','2017-09-25 10:21:25',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174346','227_DUR2250D2036_',''),
(353,0,11,'227_DUR2251-62025','0','brak_obrazka.jpg',NULL,'354.4700','0.0000','2017-09-25 10:21:26','2017-09-25 10:21:26',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174353','227_DUR2251-62025',''),
(354,0,50,'227_DUR22582013F_','0','brak_obrazka.jpg',NULL,'196.7500','0.0000','2017-09-25 10:21:26','2017-09-25 10:21:26',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174360','227_DUR22582013F_',''),
(355,0,1,'227_DUR2258-42019','0','brak_obrazka.jpg',NULL,'268.2900','0.0000','2017-09-25 10:21:26','2017-09-25 10:21:26',NULL,'8.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587418','227_DUR2258-42019',''),
(356,0,12,'227_DUR2258-62010','0','brak_obrazka.jpg',NULL,'260.1600','0.0000','2017-09-25 10:21:27','2017-09-25 10:21:27',NULL,'7.9100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587067','227_DUR2258-62010',''),
(357,0,50,'227_DUR2258-62025','0','brak_obrazka.jpg',NULL,'265.8500','0.0000','2017-09-25 10:21:27','2017-09-25 10:21:27',NULL,'10.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589382','227_DUR2258-62025',''),
(358,0,50,'227_DUR2258-62037','0','brak_obrazka.jpg',NULL,'260.1600','0.0000','2017-09-25 10:21:27','2017-09-25 10:21:27',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588941','227_DUR2258-62037',''),
(359,0,8,'227_DUR2258D2036_','0','brak_obrazka.jpg',NULL,'230.8900','0.0000','2017-09-25 10:21:27','2017-09-25 10:21:27',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174377','227_DUR2258D2036_',''),
(360,0,1,'227_DUR22610HF278','0','brak_obrazka.jpg',NULL,'75.6100','0.0000','2017-09-25 10:21:28','2017-09-25 10:21:28',NULL,'8.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174414','227_DUR22610HF278',''),
(361,0,29,'227_DUR2261-62010','0','brak_obrazka.jpg',NULL,'321.9500','0.0000','2017-09-25 10:21:28','2017-09-25 10:21:28',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589467','227_DUR2261-62010','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (362,0,48,'227_DUR2261-62025','0','brak_obrazka.jpg',NULL,'355.2800','0.0000','2017-09-25 10:21:28','2017-09-25 10:21:28',NULL,'10.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174391','227_DUR2261-62025',''),
(363,0,50,'227_DUR2261-62037','0','brak_obrazka.jpg',NULL,'354.4700','0.0000','2017-09-25 10:21:28','2017-09-25 10:21:28',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174407','227_DUR2261-62037',''),
(364,0,30,'227_DUR2268-62010','0','brak_obrazka.jpg',NULL,'244.7200','0.0000','2017-09-25 10:21:29','2017-09-25 10:21:29',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589450','227_DUR2268-62010',''),
(365,0,50,'227_DUR2269-62025','0','brak_obrazka.jpg',NULL,'303.2500','0.0000','2017-09-25 10:21:29','2017-09-25 10:21:29',NULL,'9.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174421','227_DUR2269-62025',''),
(366,0,50,'227_DUR2269-62037','0','brak_obrazka.jpg',NULL,'311.3800','0.0000','2017-09-25 10:21:29','2017-09-25 10:21:29',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587487','227_DUR2269-62037',''),
(367,0,7,'227_DUR2270-62010','0','brak_obrazka.jpg',NULL,'369.9200','0.0000','2017-09-25 10:21:29','2017-09-25 10:21:29',NULL,'15.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587449','227_DUR2270-62010',''),
(368,0,2,'227_DUR227162038_','0','brak_obrazka.jpg',NULL,'351.2200','0.0000','2017-09-25 10:21:29','2017-09-25 10:21:29',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174438','227_DUR227162038_',''),
(369,0,11,'227_DUR2272-62010','0','brak_obrazka.jpg',NULL,'416.2600','0.0000','2017-09-25 10:21:29','2017-09-25 10:21:29',NULL,'14.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587456','227_DUR2272-62010',''),
(370,0,10,'227_DUR2279-62038','0','brak_obrazka.jpg',NULL,'309.7600','0.0000','2017-09-25 10:21:30','2017-09-25 10:21:30',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174445','227_DUR2279-62038',''),
(371,0,8,'227_DUR228062010_','0','brak_obrazka.jpg',NULL,'447.1500','0.0000','2017-09-25 10:21:30','2017-09-25 10:21:30',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587463','227_DUR228062010_',''),
(372,0,4,'227_DUR228262010_','0','brak_obrazka.jpg',NULL,'500.8100','0.0000','2017-09-25 10:21:30','2017-09-25 10:21:30',NULL,'17.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587470','227_DUR228262010_',''),
(373,0,50,'227_DUR4260-42013','0','brak_obrazka.jpg',NULL,'310.5700','0.0000','2017-09-25 10:21:30','2017-09-25 10:21:30',NULL,'15.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589481','227_DUR4260-42013',''),
(374,0,25,'227_DUR4260-42025','0','brak_obrazka.jpg',NULL,'347.9700','0.0000','2017-09-25 10:21:30','2017-09-25 10:21:30',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174100','227_DUR4260-42025',''),
(375,0,50,'227_DUR4261162010','0','brak_obrazka.jpg',NULL,'358.5400','0.0000','2017-09-25 10:21:30','2017-09-25 10:21:30',NULL,'12.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174124','227_DUR4261162010',''),
(376,0,1,'227_DUR4261-62025','0','brak_obrazka.jpg',NULL,'359.3500','0.0000','2017-09-25 10:21:31','2017-09-25 10:21:31',NULL,'14.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174117','227_DUR4261-62025',''),
(377,0,22,'227_DUR4261-62037','0','brak_obrazka.jpg',NULL,'358.5400','0.0000','2017-09-25 10:21:31','2017-09-25 10:21:31',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588934','227_DUR4261-62037',''),
(378,0,31,'227_DUR4261D2036_','0','brak_obrazka.jpg',NULL,'350.4100','0.0000','2017-09-25 10:21:31','2017-09-25 10:21:31',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174131','227_DUR4261D2036_',''),
(379,0,50,'227_DUR4268-42013','0','brak_obrazka.jpg',NULL,'243.9000','0.0000','2017-09-25 10:21:31','2017-09-25 10:21:31',NULL,'15.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589474','227_DUR4268-42013',''),
(380,0,6,'227_DUR4268-42025','0','brak_obrazka.jpg',NULL,'303.2500','0.0000','2017-09-25 10:21:32','2017-09-25 10:21:32',NULL,'10.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589504','227_DUR4268-42025',''),
(381,0,21,'227_DUR4269-62010','0','brak_obrazka.jpg',NULL,'308.1300','0.0000','2017-09-25 10:21:32','2017-09-25 10:21:32',NULL,'10.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174148','227_DUR4269-62010','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (382,0,1,'227_DUR4269-62025','0','brak_obrazka.jpg',NULL,'310.5700','0.0000','2017-09-25 10:21:32','2017-09-25 10:21:32',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174155','227_DUR4269-62025',''),
(383,0,4,'227_DUR4269D2036_','0','brak_obrazka.jpg',NULL,'288.6200','0.0000','2017-09-25 10:21:32','2017-09-25 10:21:32',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174544','227_DUR4269D2036_',''),
(384,0,14,'227_DUR427162039_','0','brak_obrazka.jpg',NULL,'396.7500','0.0000','2017-09-25 10:21:32','2017-09-25 10:21:32',NULL,'15.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587517','227_DUR427162039_',''),
(385,0,21,'227_DUR427962039_','0','brak_obrazka.jpg',NULL,'366.6700','0.0000','2017-09-25 10:21:33','2017-09-25 10:21:33',NULL,'14.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587500','227_DUR427962039_',''),
(386,0,4,'227_DUR429112039_','0','brak_obrazka.jpg',NULL,'423.5800','0.0000','2017-09-25 10:21:33','2017-09-25 10:21:33',NULL,'14.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174162','227_DUR429112039_',''),
(387,0,6,'227_DUR42992039__','0','brak_obrazka.jpg',NULL,'354.4700','0.0000','2017-09-25 10:21:33','2017-09-25 10:21:33',NULL,'11.1400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174179','227_DUR42992039__',''),
(388,0,11,'227_DUR4301062039','0','brak_obrazka.jpg',NULL,'387.8000','0.0000','2017-09-25 10:21:33','2017-09-25 10:21:33',NULL,'17.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174186','227_DUR4301062039',''),
(389,0,20,'227_DUR529102042_','0','brak_obrazka.jpg',NULL,'428.4600','0.0000','2017-09-25 10:21:34','2017-09-25 10:21:34',NULL,'13.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174254','227_DUR529102042_',''),
(390,0,44,'227_DUR530102042_','0','brak_obrazka.jpg',NULL,'478.8600','0.0000','2017-09-25 10:21:34','2017-09-25 10:21:34',NULL,'14.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174261','227_DUR530102042_',''),
(391,0,22,'227_DUR7166502040','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:21:34','2017-09-25 10:21:34',NULL,'3.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174223','227_DUR7166502040',''),
(392,0,6,'227_DUR7167DI2041','0','brak_obrazka.jpg',NULL,'86.9900','0.0000','2017-09-25 10:21:34','2017-09-25 10:21:34',NULL,'3.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174230','227_DUR7167DI2041',''),
(393,0,6,'227_DUR7168-2240A','0','brak_obrazka.jpg',NULL,'115.4500','0.0000','2017-09-25 10:21:35','2017-09-25 10:21:35',NULL,'3.0740',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863017','227_DUR7168-2240A',''),
(394,0,23,'227_DUR7187-22005','0','brak_obrazka.jpg',NULL,'126.8300','0.0000','2017-09-25 10:21:35','2017-09-25 10:21:35',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174247','227_DUR7187-22005',''),
(395,0,18,'227_DUR7187-2247_','0','brak_obrazka.jpg',NULL,'149.5900','0.0000','2017-09-25 10:21:36','2017-09-25 10:21:36',NULL,'4.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589238','227_DUR7187-2247_',''),
(396,0,8,'227_DUR8180-42011','0','brak_obrazka.jpg',NULL,'184.5500','0.0000','2017-09-25 10:21:36','2017-09-25 10:21:36',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589436','227_DUR8180-42011',''),
(397,0,5,'227_DUR8189-22005','0','brak_obrazka.jpg',NULL,'139.0200','0.0000','2017-09-25 10:21:36','2017-09-25 10:21:36',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589146','227_DUR8189-22005',''),
(398,0,8,'227_DUR8189-22021','0','brak_obrazka.jpg',NULL,'160.9800','0.0000','2017-09-25 10:21:36','2017-09-25 10:21:36',NULL,'5.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174001','227_DUR8189-22021',''),
(399,0,17,'227_DUR8189-2240A','0','brak_obrazka.jpg',NULL,'149.5900','0.0000','2017-09-25 10:21:36','2017-09-25 10:21:36',NULL,'4.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863031','227_DUR8189-2240A',''),
(400,0,28,'227_DUR8189-2247_','0','brak_obrazka.jpg',NULL,'170.7300','0.0000','2017-09-25 10:21:36','2017-09-25 10:21:36',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589139','227_DUR8189-2247_',''),
(401,0,8,'227_DUR8197-22005','0','brak_obrazka.jpg',NULL,'116.2600','0.0000','2017-09-25 10:21:37','2017-09-25 10:21:37',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589153','227_DUR8197-22005','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (402,0,12,'227_DUR8197-22021','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:21:37','2017-09-25 10:21:37',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174018','227_DUR8197-22021',''),
(403,0,1,'227_DUR8197-2247_','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:21:37','2017-09-25 10:21:37',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589122','227_DUR8197-2247_',''),
(404,0,12,'227_DUR8207-2246_','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:21:37','2017-09-25 10:21:37',NULL,'3.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944863062','227_DUR8207-2246_',''),
(405,0,18,'227_DUR8208-4247_','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:21:38','2017-09-25 10:21:38',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174025','227_DUR8208-4247_',''),
(406,0,10,'227_DUR8220-22013','0','brak_obrazka.jpg',NULL,'186.1800','0.0000','2017-09-25 10:21:38','2017-09-25 10:21:38',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174513','227_DUR8220-22013',''),
(407,0,50,'227_DUR9200-42011','0','brak_obrazka.jpg',NULL,'207.3200','0.0000','2017-09-25 10:21:38','2017-09-25 10:21:38',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174193','227_DUR9200-42011',''),
(408,0,33,'227_DUR9201-42011','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:21:39','2017-09-25 10:21:39',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587012','227_DUR9201-42011',''),
(409,0,8,'227_DUR9218HF244_','0','brak_obrazka.jpg',NULL,'75.6100','0.0000','2017-09-25 10:21:39','2017-09-25 10:21:39',NULL,'5.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174216','227_DUR9218HF244_',''),
(410,0,19,'227_DUR9218HF2446','0','brak_obrazka.jpg',NULL,'75.6100','0.0000','2017-09-25 10:21:39','2017-09-25 10:21:39',NULL,'5.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224174209','227_DUR9218HF2446',''),
(411,0,16,'227_DUR9220-42011','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:21:40','2017-09-25 10:21:40',NULL,'7.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379589337','227_DUR9220-42011',''),
(412,0,15,'227_DUSC010080266','0','brak_obrazka.jpg',NULL,'42.2800','0.0000','2017-09-25 10:21:40','2017-09-25 10:21:40',NULL,'2.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177187','227_DUSC010080266',''),
(413,0,21,'227_DUSC011080296','0','brak_obrazka.jpg',NULL,'81.3000','0.0000','2017-09-25 10:21:40','2017-09-25 10:21:40',NULL,'2.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864755','227_DUSC011080296',''),
(414,0,1,'227_DUSC012090DM_','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:21:40','2017-09-25 10:21:40',NULL,'1.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864717','227_DUSC012090DM_',''),
(415,0,10,'227_DUSC012090HF_','0','brak_obrazka.jpg',NULL,'85.3700','0.0000','2017-09-25 10:21:41','2017-09-25 10:21:41',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864700','227_DUSC012090HF_',''),
(416,0,2,'227_DUSC013090DM_','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:21:41','2017-09-25 10:21:41',NULL,'3.4100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864731','227_DUSC013090DM_',''),
(417,0,32,'227_DUSC013090HF9','0','brak_obrazka.jpg',NULL,'92.6800','0.0000','2017-09-25 10:21:42','2017-09-25 10:21:42',NULL,'3.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864724','227_DUSC013090HF9',''),
(418,0,30,'227_DUSC015080DM1','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:21:42','2017-09-25 10:21:42',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588132','227_DUSC015080DM1',''),
(419,0,13,'227_DUSC0350HF290','0','brak_obrazka.jpg',NULL,'70.7300','0.0000','2017-09-25 10:21:43','2017-09-25 10:21:43',NULL,'2.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587890','227_DUSC0350HF290',''),
(420,0,8,'227_DUSC09090H296','0','brak_obrazka.jpg',NULL,'64.2300','0.0000','2017-09-25 10:21:43','2017-09-25 10:21:43',NULL,'2.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587913','227_DUSC09090H296',''),
(421,0,50,'227_DUSC210060DM1','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:21:43','2017-09-25 10:21:43',NULL,'2.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869033','227_DUSC210060DM1','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (422,0,50,'227_DUSC210060DM2','0','brak_obrazka.jpg',NULL,'77.2400','0.0000','2017-09-25 10:21:44','2017-09-25 10:21:44',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224176937','227_DUSC210060DM2',''),
(423,0,23,'227_DUSC210090001','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:21:44','2017-09-25 10:21:44',NULL,'3.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864861','227_DUSC210090001',''),
(424,0,20,'227_DUSC210090908','0','brak_obrazka.jpg',NULL,'79.6700','0.0000','2017-09-25 10:21:44','2017-09-25 10:21:44',NULL,'3.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224176944','227_DUSC210090908',''),
(425,0,11,'227_DUSC211090059','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:21:45','2017-09-25 10:21:45',NULL,'3.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177712','227_DUSC211090059',''),
(426,0,16,'227_DUSC212070109','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:21:45','2017-09-25 10:21:45',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864847','227_DUSC212070109',''),
(427,0,50,'227_DUSC212070DM_','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL,'2.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864809','227_DUSC212070DM_',''),
(428,0,50,'227_DUSC212070DM2','0','brak_obrazka.jpg',NULL,'93.5000','0.0000','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224176951','227_DUSC212070DM2',''),
(429,0,50,'227_DUSC212070HF_','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL,'3.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864793','227_DUSC212070HF_',''),
(430,0,50,'227_DUSC212070HF9','0','brak_obrazka.jpg',NULL,'93.5000','0.0000','2017-09-25 10:21:46','2017-09-25 10:21:46',NULL,'3.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587968','227_DUSC212070HF9',''),
(431,0,50,'227_DUSC213070HF_','0','brak_obrazka.jpg',NULL,'94.3100','0.0000','2017-09-25 10:21:47','2017-09-25 10:21:47',NULL,'3.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864816','227_DUSC213070HF_',''),
(432,0,36,'227_DUSC214070017','0','brak_obrazka.jpg',NULL,'129.2700','0.0000','2017-09-25 10:21:47','2017-09-25 10:21:47',NULL,'4.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864830','227_DUSC214070017',''),
(433,0,19,'227_DUSC2300HF910','0','brak_obrazka.jpg',NULL,'65.0400','0.0000','2017-09-25 10:21:47','2017-09-25 10:21:47',NULL,'2.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179792','227_DUSC2300HF910',''),
(434,0,3,'227_DUSC311090DM1','0','brak_obrazka.jpg',NULL,'117.8900','0.0000','2017-09-25 10:21:48','2017-09-25 10:21:48',NULL,'3.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864885','227_DUSC311090DM1',''),
(435,0,18,'227_DUSC312060DM_','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:21:48','2017-09-25 10:21:48',NULL,'3.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379588101','227_DUSC312060DM_',''),
(436,0,47,'227_DUSC313060HF_','0','brak_obrazka.jpg',NULL,'87.8000','0.0000','2017-09-25 10:21:48','2017-09-25 10:21:48',NULL,'2.9500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864892','227_DUSC313060HF_',''),
(437,0,14,'227_DUSC313070057','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:21:49','2017-09-25 10:21:49',NULL,'4.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864915','227_DUSC313070057',''),
(438,0,19,'227_DUSC314060DM_','0','brak_obrazka.jpg',NULL,'115.4500','0.0000','2017-09-25 10:21:49','2017-09-25 10:21:49',NULL,'3.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944864939','227_DUSC314060DM_',''),
(439,0,32,'227_DUSC314060HF_','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:21:50','2017-09-25 10:21:50',NULL,'3.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177088','227_DUSC314060HF_',''),
(440,0,4,'227_DUSC614070DM1','0','brak_obrazka.jpg',NULL,'178.0500','0.0000','2017-09-25 10:21:50','2017-09-25 10:21:50',NULL,'5.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4710944869026','227_DUSC614070DM1',''),
(441,0,10,'227_DUW010016257_','0','brak_obrazka.jpg',NULL,'464.2300','0.0000','2017-09-25 10:21:51','2017-09-25 10:21:51',NULL,'21.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179228','227_DUW010016257_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (442,0,10,'227_DUW011016257_','0','brak_obrazka.jpg',NULL,'595.9300','0.0000','2017-09-25 10:21:51','2017-09-25 10:21:51',NULL,'29.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179235','227_DUW011016257_',''),
(443,0,1,'227_DUW0201000224','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL,'5.4350',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179655','227_DUW0201000224',''),
(444,0,2,'227_DUW0205505007','0','brak_obrazka.jpg',NULL,'140.6500','0.0000','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL,'4.7850',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179662','227_DUW0205505007',''),
(445,0,8,'227_DUW0205550071','0','brak_obrazka.jpg',NULL,'145.5300','0.0000','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179679','227_DUW0205550071',''),
(446,0,2,'227_DUW020580232_','0','brak_obrazka.jpg',NULL,'182.1100','0.0000','2017-09-25 10:21:52','2017-09-25 10:21:52',NULL,'5.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179693','227_DUW020580232_',''),
(447,0,2,'227_DUW0208001006','0','brak_obrazka.jpg',NULL,'249.5900','0.0000','2017-09-25 10:21:53','2017-09-25 10:21:53',NULL,'6.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179709','227_DUW0208001006',''),
(448,0,20,'227_DUW0450HF251_','0','brak_obrazka.jpg',NULL,'135.7700','0.0000','2017-09-25 10:21:53','2017-09-25 10:21:53',NULL,'5.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179716','227_DUW0450HF251_',''),
(449,0,10,'227_DUW0500HF253_','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL,'4.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179723','227_DUW0500HF253_',''),
(450,0,8,'227_DUW065010282_','0','brak_obrazka.jpg',NULL,'230.0800','0.0000','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL,'10.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179730','227_DUW065010282_',''),
(451,0,10,'227_DUW065016257_','0','brak_obrazka.jpg',NULL,'191.0600','0.0000','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL,'9.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179242','227_DUW065016257_',''),
(452,0,5,'227_DUW09400HF257','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:21:54','2017-09-25 10:21:54',NULL,'5.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177293','227_DUW09400HF257',''),
(453,0,4,'227_DUW2190505009','0','brak_obrazka.jpg',NULL,'103.2500','0.0000','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179389','227_DUW2190505009',''),
(454,0,1,'227_DUW2215405009','0','brak_obrazka.jpg',NULL,'112.2000','0.0000','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL,'4.2950',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179396','227_DUW2215405009',''),
(455,0,4,'227_DUW2231050224','0','brak_obrazka.jpg',NULL,'176.4200','0.0000','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL,'7.7150',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179402','227_DUW2231050224',''),
(456,0,8,'227_DUW2231050255','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:21:55','2017-09-25 10:21:55',NULL,'7.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179419','227_DUW2231050255',''),
(457,0,24,'227_DUW223105025G','0','brak_obrazka.jpg',NULL,'143.0900','0.0000','2017-09-25 10:21:56','2017-09-25 10:21:56',NULL,'11.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179426','227_DUW223105025G',''),
(458,0,1,'227_DUW2231055005','0','brak_obrazka.jpg',NULL,'176.4200','0.0000','2017-09-25 10:21:56','2017-09-25 10:21:56',NULL,'7.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179433','227_DUW2231055005',''),
(459,0,2,'227_DUW223850213_','0','brak_obrazka.jpg',NULL,'158.5400','0.0000','2017-09-25 10:21:56','2017-09-25 10:21:56',NULL,'6.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179440','227_DUW223850213_',''),
(460,0,50,'227_DUW223850224_','0','brak_obrazka.jpg',NULL,'139.8400','0.0000','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL,'6.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179457','227_DUW223850224_',''),
(461,0,38,'227_DUW223850255_','0','brak_obrazka.jpg',NULL,'143.0900','0.0000','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL,'6.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179464','227_DUW223850255_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (462,0,6,'227_DUW2238505005','0','brak_obrazka.jpg',NULL,'151.2200','0.0000','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL,'5.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179471','227_DUW2238505005',''),
(463,0,9,'227_DUW223950224_','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:21:57','2017-09-25 10:21:57',NULL,'5.9850',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179488','227_DUW223950224_',''),
(464,0,1,'227_DUW2241205005','0','brak_obrazka.jpg',NULL,'216.2600','0.0000','2017-09-25 10:21:58','2017-09-25 10:21:58',NULL,'8.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179495','227_DUW2241205005',''),
(465,0,18,'227_DUW2261200213','0','brak_obrazka.jpg',NULL,'340.6500','0.0000','2017-09-25 10:21:59','2017-09-25 10:21:59',NULL,'14.0250',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179501','227_DUW2261200213',''),
(466,0,2,'227_DUW2261200255','0','brak_obrazka.jpg',NULL,'274.8000','0.0000','2017-09-25 10:21:59','2017-09-25 10:21:59',NULL,'10.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179518','227_DUW2261200255',''),
(467,0,3,'227_DUW2261202551','0','brak_obrazka.jpg',NULL,'331.7100','0.0000','2017-09-25 10:21:59','2017-09-25 10:21:59',NULL,'13.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179525','227_DUW2261202551',''),
(468,0,17,'227_DUW2400252B__','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:22:00','2017-09-25 10:22:00',NULL,'3.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379586718','227_DUW2400252B__',''),
(469,0,14,'227_DUW2500252B__','0','brak_obrazka.jpg',NULL,'151.2200','0.0000','2017-09-25 10:22:00','2017-09-25 10:22:00',NULL,'5.2950',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179532','227_DUW2500252B__',''),
(470,0,8,'227_DUW2500HF251_','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:22:01','2017-09-25 10:22:01',NULL,'6.2160',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179549','227_DUW2500HF251_',''),
(471,0,17,'227_DUW2600252B__','0','brak_obrazka.jpg',NULL,'185.3700','0.0000','2017-09-25 10:22:01','2017-09-25 10:22:01',NULL,'7.5650',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179556','227_DUW2600252B__',''),
(472,0,10,'227_DUW2600HF251_','0','brak_obrazka.jpg',NULL,'194.3100','0.0000','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL,'8.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179563','227_DUW2600HF251_',''),
(473,0,8,'227_DUW2600HF253_','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL,'7.1950',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179570','227_DUW2600HF253_',''),
(474,0,14,'227_DUW270014282_','0','brak_obrazka.jpg',NULL,'331.7100','0.0000','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL,'13.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179587','227_DUW270014282_',''),
(475,0,6,'227_DUW452006257A','0','brak_obrazka.jpg',NULL,'222.7600','0.0000','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL,'12.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179617','227_DUW452006257A',''),
(476,0,50,'227_DUW50200HF207','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL,'0.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179594','227_DUW50200HF207',''),
(477,0,5,'227_DUW511400217_','0','brak_obrazka.jpg',NULL,'38.2100','0.0000','2017-09-25 10:22:02','2017-09-25 10:22:02',NULL,'1.1150',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179624','227_DUW511400217_',''),
(478,0,22,'227_DUW511400224_','0','brak_obrazka.jpg',NULL,'40.6500','0.0000','2017-09-25 10:22:03','2017-09-25 10:22:03',NULL,'1.1650',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179631','227_DUW511400224_',''),
(479,0,50,'227_DUW51140A500_','0','brak_obrazka.jpg',NULL,'45.5300','0.0000','2017-09-25 10:22:03','2017-09-25 10:22:03',NULL,'1.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179648','227_DUW51140A500_',''),
(480,0,6,'227_DUW525016HF28','0','brak_obrazka.jpg',NULL,'698.3700','0.0000','2017-09-25 10:22:03','2017-09-25 10:22:03',NULL,'34.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179747','227_DUW525016HF28',''),
(481,0,4,'227_DUW5271205005','0','brak_obrazka.jpg',NULL,'275.6100','0.0000','2017-09-25 10:22:04','2017-09-25 10:22:04',NULL,'11.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179754','227_DUW5271205005','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (482,0,13,'227_DUW5271250051','0','brak_obrazka.jpg',NULL,'310.5700','0.0000','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL,'12.8250',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179761','227_DUW5271250051',''),
(483,0,47,'227_DUW5400201___','0','brak_obrazka.jpg',NULL,'45.5300','0.0000','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL,'1.3350',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179808','227_DUW5400201___',''),
(484,0,2,'227_DUW582514283_','0','brak_obrazka.jpg',NULL,'468.2900','0.0000','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL,'33.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179778','227_DUW582514283_',''),
(485,0,2,'227_DUW610565258_','0','brak_obrazka.jpg',NULL,'249.5900','0.0000','2017-09-25 10:22:05','2017-09-25 10:22:05',NULL,'13.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179259','227_DUW610565258_',''),
(486,0,10,'227_DUW611HF257A_','0','brak_obrazka.jpg',NULL,'540.6500','0.0000','2017-09-25 10:22:06','2017-09-25 10:22:06',NULL,'28.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179266','227_DUW611HF257A_',''),
(487,0,11,'227_DUW613500213_','0','brak_obrazka.jpg',NULL,'47.1500','0.0000','2017-09-25 10:22:06','2017-09-25 10:22:06',NULL,'1.7050',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179280','227_DUW613500213_',''),
(488,0,50,'227_DUW613500224_','0','brak_obrazka.jpg',NULL,'43.0900','0.0000','2017-09-25 10:22:06','2017-09-25 10:22:06',NULL,'1.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179297','227_DUW613500224_',''),
(489,0,50,'227_DUW6135005005','0','brak_obrazka.jpg',NULL,'40.6500','0.0000','2017-09-25 10:22:07','2017-09-25 10:22:07',NULL,'1.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179303','227_DUW6135005005',''),
(490,0,26,'227_DUW6136HF236T','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:22:07','2017-09-25 10:22:07',NULL,'1.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179310','227_DUW6136HF236T',''),
(491,0,11,'227_DUW6140213___','0','brak_obrazka.jpg',NULL,'52.8500','0.0000','2017-09-25 10:22:07','2017-09-25 10:22:07',NULL,'1.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179327','227_DUW6140213___',''),
(492,0,18,'227_DUW614400270_','0','brak_obrazka.jpg',NULL,'55.2800','0.0000','2017-09-25 10:22:08','2017-09-25 10:22:08',NULL,'1.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179334','227_DUW614400270_',''),
(493,0,50,'227_DUW615600217_','0','brak_obrazka.jpg',NULL,'52.8500','0.0000','2017-09-25 10:22:08','2017-09-25 10:22:08',NULL,'1.9350',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179341','227_DUW615600217_',''),
(494,0,10,'227_DUW615600257_','0','brak_obrazka.jpg',NULL,'66.6700','0.0000','2017-09-25 10:22:09','2017-09-25 10:22:09',NULL,'2.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179365','227_DUW615600257_',''),
(495,0,1,'227_DUW6156005005','0','brak_obrazka.jpg',NULL,'57.7200','0.0000','2017-09-25 10:22:09','2017-09-25 10:22:09',NULL,'2.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179372','227_DUW6156005005',''),
(496,0,21,'227_DUW8165650213','0','brak_obrazka.jpg',NULL,'86.1800','0.0000','2017-09-25 10:22:09','2017-09-25 10:22:09',NULL,'2.8950',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177316','227_DUW8165650213',''),
(497,0,4,'227_DUW8165650232','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:22:10','2017-09-25 10:22:10',NULL,'3.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177323','227_DUW8165650232',''),
(498,0,9,'227_DUW8165652321','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:22:10','2017-09-25 10:22:10',NULL,'3.7950',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177330','227_DUW8165652321',''),
(499,0,23,'227_DUW816650213_','0','brak_obrazka.jpg',NULL,'76.4200','0.0000','2017-09-25 10:22:10','2017-09-25 10:22:10',NULL,'2.9850',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177347','227_DUW816650213_',''),
(500,0,50,'227_DUW816650217_','0','brak_obrazka.jpg',NULL,'66.6700','0.0000','2017-09-25 10:22:11','2017-09-25 10:22:11',NULL,'2.4450',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4714379587210','227_DUW816650217_',''),
(501,0,50,'227_DUW816650224_','0','brak_obrazka.jpg',NULL,'65.8500','0.0000','2017-09-25 10:22:11','2017-09-25 10:22:11',NULL,'2.4950',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179815','227_DUW816650224_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (502,0,2,'227_DUW816650224D','0','brak_obrazka.jpg',NULL,'63.4100','0.0000','2017-09-25 10:22:11','2017-09-25 10:22:11',NULL,'1.9500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177354','227_DUW816650224D',''),
(503,0,50,'227_DUW8166505005','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:22:12','2017-09-25 10:22:12',NULL,'3.1250',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177361','227_DUW8166505005',''),
(504,0,50,'227_DUW81675224__','0','brak_obrazka.jpg',NULL,'79.6700','0.0000','2017-09-25 10:22:12','2017-09-25 10:22:12',NULL,'3.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177378','227_DUW81675224__',''),
(505,0,2,'227_DUW817801001_','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:22:12','2017-09-25 10:22:12',NULL,'5.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177385','227_DUW817801001_',''),
(506,0,19,'227_DUW8185852321','0','brak_obrazka.jpg',NULL,'162.6000','0.0000','2017-09-25 10:22:13','2017-09-25 10:22:13',NULL,'5.4550',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179006','227_DUW8185852321',''),
(507,0,11,'227_DUW818650224_','0','brak_obrazka.jpg',NULL,'81.3000','0.0000','2017-09-25 10:22:13','2017-09-25 10:22:13',NULL,'3.3150',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179013','227_DUW818650224_',''),
(508,0,50,'227_DUW8187HF293H','0','brak_obrazka.jpg',NULL,'42.2800','0.0000','2017-09-25 10:22:13','2017-09-25 10:22:13',NULL,'3.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179020','227_DUW8187HF293H',''),
(509,0,50,'227_DUW818850224_','0','brak_obrazka.jpg',NULL,'87.8000','0.0000','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL,'3.8650',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179037','227_DUW818850224_',''),
(510,0,50,'227_DUW8188505005','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL,'4.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179044','227_DUW8188505005',''),
(511,0,14,'227_DUW818950217_','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179068','227_DUW818950217_',''),
(512,0,1,'227_DUW818950224_','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:22:14','2017-09-25 10:22:14',NULL,'3.6250',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179075','227_DUW818950224_',''),
(513,0,1,'227_DUW818950255_','0','brak_obrazka.jpg',NULL,'121.9500','0.0000','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179082','227_DUW818950255_',''),
(514,0,2,'227_DUW8190HF400_','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL,'2.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179105','227_DUW8190HF400_',''),
(515,0,7,'227_DUW8201000224','0','brak_obrazka.jpg',NULL,'110.5700','0.0000','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL,'5.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179112','227_DUW8201000224',''),
(516,0,1,'227_DUW8201005005','0','brak_obrazka.jpg',NULL,'124.3900','0.0000','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL,'5.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179129','227_DUW8201005005',''),
(517,0,28,'227_DUW820800224_','0','brak_obrazka.jpg',NULL,'107.3200','0.0000','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL,'4.3150',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179136','227_DUW820800224_',''),
(518,0,50,'227_DUW8208005005','0','brak_obrazka.jpg',NULL,'115.4500','0.0000','2017-09-25 10:22:15','2017-09-25 10:22:15',NULL,'4.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179143','227_DUW8208005005',''),
(519,0,30,'227_DUW8211100255','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:22:16','2017-09-25 10:22:16',NULL,'6.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179150','227_DUW8211100255',''),
(520,0,3,'227_DUW8215605007','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:22:16','2017-09-25 10:22:16',NULL,'5.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179167','227_DUW8215605007',''),
(521,0,2,'227_DUW8215650071','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:22:17','2017-09-25 10:22:17',NULL,'5.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179174','227_DUW8215650071','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (522,0,14,'227_DUW8221100224','0','brak_obrazka.jpg',NULL,'149.5900','0.0000','2017-09-25 10:22:17','2017-09-25 10:22:17',NULL,'6.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179181','227_DUW8221100224',''),
(523,0,17,'227_DUW8400205___','0','brak_obrazka.jpg',NULL,'50.4100','0.0000','2017-09-25 10:22:17','2017-09-25 10:22:17',NULL,'1.7950',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179198','227_DUW8400205___',''),
(524,0,6,'227_DUW8400HF252_','0','brak_obrazka.jpg',NULL,'65.0400','0.0000','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL,'2.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179204','227_DUW8400HF252_',''),
(525,0,18,'227_DUW85008281__','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL,'5.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179211','227_DUW85008281__',''),
(526,0,10,'227_DUW9400HF253_','0','brak_obrazka.jpg',NULL,'116.2600','0.0000','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL,'5.2240',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224177309','227_DUW9400HF253_',''),
(527,0,22,'227_DUW960010282_','0','brak_obrazka.jpg',NULL,'206.5000','0.0000','2017-09-25 10:22:18','2017-09-25 10:22:18',NULL,'8.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713224179600','227_DUW960010282_',''),
(528,0,30,'227_FEC0371250MT_','0','brak_obrazka.jpg',NULL,'932.5200','0.0000','2017-09-25 10:22:19','2017-09-25 10:22:19',NULL,'34.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004413','227_FEC0371250MT_',''),
(529,0,50,'227_FEC23312.5MT_','0','brak_obrazka.jpg',NULL,'721.1400','0.0000','2017-09-25 10:22:20','2017-09-25 10:22:20',NULL,'27.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000873','227_FEC23312.5MT_',''),
(530,0,3,'227_FEC23512.5MT_','0','brak_obrazka.jpg',NULL,'856.1000','0.0000','2017-09-25 10:22:20','2017-09-25 10:22:20',NULL,'31.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225108','227_FEC23512.5MT_',''),
(531,0,36,'227_FEC523575MT__','0','brak_obrazka.jpg',NULL,'396.7500','0.0000','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL,'15.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224255','227_FEC523575MT__',''),
(532,0,18,'227_FEC5309.5MT__','0','brak_obrazka.jpg',NULL,'430.8900','0.0000','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL,'19.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224309','227_FEC5309.5MT__',''),
(533,0,50,'227_FEC53110.5MT_','0','brak_obrazka.jpg',NULL,'456.1000','0.0000','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL,'21.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959223203','227_FEC53110.5MT_',''),
(534,0,50,'227_FEC53312.5MT_','0','brak_obrazka.jpg',NULL,'543.0900','0.0000','2017-09-25 10:22:21','2017-09-25 10:22:21',NULL,'28.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224330','227_FEC53312.5MT_',''),
(535,0,50,'227_FEC53512.5MT_','0','brak_obrazka.jpg',NULL,'623.5800','0.0000','2017-09-25 10:22:22','2017-09-25 10:22:22',NULL,'29.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000910','227_FEC53512.5MT_',''),
(536,0,42,'227_FEC620580MT__','0','brak_obrazka.jpg',NULL,'417.0700','0.0000','2017-09-25 10:22:22','2017-09-25 10:22:22',NULL,'17.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224224','227_FEC620580MT__',''),
(537,0,2,'227_FEC621585AT__','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:22:23','2017-09-25 10:22:23',NULL,'18.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000958','227_FEC621585AT__',''),
(538,0,6,'227_FEC622575MT__','0','brak_obrazka.jpg',NULL,'444.7200','0.0000','2017-09-25 10:22:24','2017-09-25 10:22:24',NULL,'17.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003676','227_FEC622575MT__',''),
(539,0,16,'227_FEC623585MT__','0','brak_obrazka.jpg',NULL,'480.4900','0.0000','2017-09-25 10:22:24','2017-09-25 10:22:24',NULL,'21.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224262','227_FEC623585MT__',''),
(540,0,15,'227_FEC624575MT__','0','brak_obrazka.jpg',NULL,'518.7000','0.0000','2017-09-25 10:22:25','2017-09-25 10:22:25',NULL,'20.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003683','227_FEC624575MT__',''),
(541,0,50,'227_FEC626575MT__','0','brak_obrazka.jpg',NULL,'505.6900','0.0000','2017-09-25 10:22:25','2017-09-25 10:22:25',NULL,'23.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224293','227_FEC626575MT__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (542,0,24,'227_FEC628575MT__','0','brak_obrazka.jpg',NULL,'562.6000','0.0000','2017-09-25 10:22:25','2017-09-25 10:22:25',NULL,'25.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEC628575MT__',''),
(543,0,50,'227_FEC631575MT__','0','brak_obrazka.jpg',NULL,'686.1800','0.0000','2017-09-25 10:22:26','2017-09-25 10:22:26',NULL,'29.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEC631575MT__',''),
(544,0,1,'227_FEC726570AT1_','0','brak_obrazka.jpg',NULL,'117.0700','0.0000','2017-09-25 10:22:27','2017-09-25 10:22:27',NULL,'20.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228680','227_FEC726570AT1_',''),
(545,0,28,'227_FEC726570MT__','0','brak_obrazka.jpg',NULL,'553.6600','0.0000','2017-09-25 10:22:27','2017-09-25 10:22:27',NULL,'26.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959220288','227_FEC726570MT__',''),
(546,0,44,'227_FEC728570MT__','0','brak_obrazka.jpg',NULL,'634.9600','0.0000','2017-09-25 10:22:27','2017-09-25 10:22:27',NULL,'25.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000781','227_FEC728570MT__',''),
(547,0,15,'227_FEC73512.5MT_','0','brak_obrazka.jpg',NULL,'755.2800','0.0000','2017-09-25 10:22:28','2017-09-25 10:22:28',NULL,'33.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000798','227_FEC73512.5MT_',''),
(548,0,6,'227_FEC7371250MT_','0','brak_obrazka.jpg',NULL,'906.5000','0.0000','2017-09-25 10:22:29','2017-09-25 10:22:29',NULL,'35.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004512','227_FEC7371250MT_',''),
(549,0,18,'227_FEC827565MT__','0','brak_obrazka.jpg',NULL,'640.6500','0.0000','2017-09-25 10:22:29','2017-09-25 10:22:29',NULL,'25.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001382','227_FEC827565MT__',''),
(550,0,42,'227_FEC83512.5MT_','0','brak_obrazka.jpg',NULL,'778.8600','0.0000','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL,'31.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000743','227_FEC83512.5MT_',''),
(551,0,7,'227_FEC8371250MT_','0','brak_obrazka.jpg',NULL,'904.8800','0.0000','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL,'34.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004451','227_FEC8371250MT_',''),
(552,0,2,'227_FED420575ER01','0','brak_obrazka.jpg',NULL,'204.8800','0.0000','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL,'12.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6941995653304','227_FED420575ER01',''),
(553,0,1,'227_FED619565273_','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL,'13.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959208125','227_FED619565273_',''),
(554,0,1,'227_FEL022530FD2X','0','brak_obrazka.jpg',NULL,'289.4300','0.0000','2017-09-25 10:22:30','2017-09-25 10:22:30',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000842','227_FEL022530FD2X',''),
(555,0,6,'227_FEL022535595E','0','brak_obrazka.jpg',NULL,'300.8100','0.0000','2017-09-25 10:22:31','2017-09-25 10:22:31',NULL,'12.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224682','227_FEL022535595E',''),
(556,0,16,'227_FEL022535EST1','0','brak_obrazka.jpg',NULL,'300.0000','0.0000','2017-09-25 10:22:31','2017-09-25 10:22:31',NULL,'10.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL022535EST1',''),
(557,0,2,'227_FEL024530FD2X','0','brak_obrazka.jpg',NULL,'294.3100','0.0000','2017-09-25 10:22:31','2017-09-25 10:22:31',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000668','227_FEL024530FD2X',''),
(558,0,2,'227_FEL024535595_','0','brak_obrazka.jpg',NULL,'294.3100','0.0000','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL,'12.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224378','227_FEL024535595_',''),
(559,0,1,'227_FEL024535595E','0','brak_obrazka.jpg',NULL,'326.0200','0.0000','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL,'13.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224705','227_FEL024535595E',''),
(560,0,6,'227_FEL024535EST1','0','brak_obrazka.jpg',NULL,'334.9600','0.0000','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL,'10.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL024535EST1',''),
(561,0,10,'227_FEL025535EST1','0','brak_obrazka.jpg',NULL,'344.7200','0.0000','2017-09-25 10:22:32','2017-09-25 10:22:32',NULL,'11.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL025535EST1','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (562,0,6,'227_FEL025540EST1','0','brak_obrazka.jpg',NULL,'326.8300','0.0000','2017-09-25 10:22:33','2017-09-25 10:22:33',NULL,'11.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL025540EST1',''),
(563,0,6,'227_FEL028530EST1','0','brak_obrazka.jpg',NULL,'393.5000','0.0000','2017-09-25 10:22:33','2017-09-25 10:22:33',NULL,'15.2100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL028530EST1',''),
(564,0,3,'227_FEL033530595R','0','brak_obrazka.jpg',NULL,'513.0100','0.0000','2017-09-25 10:22:33','2017-09-25 10:22:33',NULL,'16.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001078','227_FEL033530595R',''),
(565,0,2,'227_FEL315565GIO_','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:22:34','2017-09-25 10:22:34',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003744','227_FEL315565GIO_',''),
(566,0,10,'227_FEL315580GIO_','0','brak_obrazka.jpg',NULL,'92.6800','0.0000','2017-09-25 10:22:34','2017-09-25 10:22:34',NULL,'6.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003447','227_FEL315580GIO_',''),
(567,0,6,'227_FEL316565GIO_','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL,'6.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004352','227_FEL316565GIO_',''),
(568,0,8,'227_FEL316570GIO_','0','brak_obrazka.jpg',NULL,'93.5000','0.0000','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL,'6.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003713','227_FEL316570GIO_',''),
(569,0,12,'227_FEL316580657_','0','brak_obrazka.jpg',NULL,'117.0700','0.0000','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6941995636239','227_FEL316580657_',''),
(570,0,3,'227_FEL320560657_','0','brak_obrazka.jpg',NULL,'128.4600','0.0000','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL320560657_',''),
(571,0,4,'227_FEL416560GIO_','0','brak_obrazka.jpg',NULL,'101.6300','0.0000','2017-09-25 10:22:35','2017-09-25 10:22:35',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004604','227_FEL416560GIO_',''),
(572,0,10,'227_FEL416565GIO_','0','brak_obrazka.jpg',NULL,'100.8100','0.0000','2017-09-25 10:22:36','2017-09-25 10:22:36',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004499','227_FEL416565GIO_',''),
(573,0,7,'227_FEL417565GIO_','0','brak_obrazka.jpg',NULL,'104.0700','0.0000','2017-09-25 10:22:36','2017-09-25 10:22:36',NULL,'6.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003294','227_FEL417565GIO_',''),
(574,0,6,'227_FEL417570GIO_','0','brak_obrazka.jpg',NULL,'108.1300','0.0000','2017-09-25 10:22:37','2017-09-25 10:22:37',NULL,'6.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004611','227_FEL417570GIO_',''),
(575,0,2,'227_FEL417580657_','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:22:37','2017-09-25 10:22:37',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6941995636529','227_FEL417580657_',''),
(576,0,8,'227_FEL418560GIO_','0','brak_obrazka.jpg',NULL,'108.9400','0.0000','2017-09-25 10:22:37','2017-09-25 10:22:37',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003317','227_FEL418560GIO_',''),
(577,0,8,'227_FEL418565GIO_','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:22:38','2017-09-25 10:22:38',NULL,'7.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003270','227_FEL418565GIO_',''),
(578,0,10,'227_FEL418570GIO_','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:22:38','2017-09-25 10:22:38',NULL,'7.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004406','227_FEL418570GIO_',''),
(579,0,4,'227_FEL418580657_','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:22:38','2017-09-25 10:22:38',NULL,'7.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6941995636604','227_FEL418580657_',''),
(580,0,10,'227_FEL419560FD2_','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:22:39','2017-09-25 10:22:39',NULL,'7.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225856','227_FEL419560FD2_',''),
(581,0,2,'227_FEL419565GIO_','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:22:39','2017-09-25 10:22:39',NULL,'8.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004437','227_FEL419565GIO_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (582,0,10,'227_FEL419570GIO_','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:22:39','2017-09-25 10:22:39',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004444','227_FEL419570GIO_',''),
(583,0,40,'227_FEL420570657_','0','brak_obrazka.jpg',NULL,'146.3400','0.0000','2017-09-25 10:22:40','2017-09-25 10:22:40',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6941995636697','227_FEL420570657_',''),
(584,0,8,'227_FEL515560AZ01','0','brak_obrazka.jpg',NULL,'134.9600','0.0000','2017-09-25 10:22:40','2017-09-25 10:22:40',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004048','227_FEL515560AZ01',''),
(585,0,6,'227_FEL516555595E','0','brak_obrazka.jpg',NULL,'148.7800','0.0000','2017-09-25 10:22:41','2017-09-25 10:22:41',NULL,'7.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959226051','227_FEL516555595E',''),
(586,0,2,'227_FEL517555AZ01','0','brak_obrazka.jpg',NULL,'139.8400','0.0000','2017-09-25 10:22:41','2017-09-25 10:22:41',NULL,'7.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003935','227_FEL517555AZ01',''),
(587,0,8,'227_FEL517565AZ01','0','brak_obrazka.jpg',NULL,'152.8500','0.0000','2017-09-25 10:22:41','2017-09-25 10:22:41',NULL,'6.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001498','227_FEL517565AZ01',''),
(588,0,4,'227_FEL518565GIO_','0','brak_obrazka.jpg',NULL,'116.2600','0.0000','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL,'8.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004475','227_FEL518565GIO_',''),
(589,0,50,'227_FEL519550595S','0','brak_obrazka.jpg',NULL,'236.5900','0.0000','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL,'9.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228222','227_FEL519550595S',''),
(590,0,8,'227_FEL519550AZ01','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL,'7.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003249','227_FEL519550AZ01',''),
(591,0,2,'227_FEL5195555951','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:22:42','2017-09-25 10:22:42',NULL,'9.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959222572','227_FEL5195555951',''),
(592,0,9,'227_FEL519565657C','0','brak_obrazka.jpg',NULL,'123.5800','0.0000','2017-09-25 10:22:43','2017-09-25 10:22:43',NULL,'8.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6941995637144','227_FEL519565657C',''),
(593,0,4,'227_FEL519565AZ01','0','brak_obrazka.jpg',NULL,'152.0300','0.0000','2017-09-25 10:22:43','2017-09-25 10:22:43',NULL,'9.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002167','227_FEL519565AZ01',''),
(594,0,2,'227_FEL519565FD2_','0','brak_obrazka.jpg',NULL,'167.4800','0.0000','2017-09-25 10:22:44','2017-09-25 10:22:44',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225238','227_FEL519565FD2_',''),
(595,0,48,'227_FEL520550595S','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:22:44','2017-09-25 10:22:44',NULL,'9.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228123','227_FEL520550595S',''),
(596,0,4,'227_FEL520550AZ01','0','brak_obrazka.jpg',NULL,'139.8400','0.0000','2017-09-25 10:22:44','2017-09-25 10:22:44',NULL,'8.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003737','227_FEL520550AZ01',''),
(597,0,8,'227_FEL520565GIO_','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:22:45','2017-09-25 10:22:45',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004420','227_FEL520565GIO_',''),
(598,0,1,'227_FEL520570657_','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:22:45','2017-09-25 10:22:45',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6941995637229','227_FEL520570657_',''),
(599,0,1,'227_FEL521560FD2_','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:22:45','2017-09-25 10:22:45',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225931','227_FEL521560FD2_',''),
(600,0,1,'227_FEL521565FD2_','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:22:46','2017-09-25 10:22:46',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959226495','227_FEL521565FD2_',''),
(601,0,2,'227_FEL522560GIO_','0','brak_obrazka.jpg',NULL,'159.3500','0.0000','2017-09-25 10:22:46','2017-09-25 10:22:46',NULL,'10.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004482','227_FEL522560GIO_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (602,0,4,'227_FEL617560FD2_','0','brak_obrazka.jpg',NULL,'146.3400','0.0000','2017-09-25 10:22:46','2017-09-25 10:22:46',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225139','227_FEL617560FD2_',''),
(603,0,2,'227_FEL618555AZ01','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:22:47','2017-09-25 10:22:47',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001573','227_FEL618555AZ01',''),
(604,0,2,'227_FEL619545EST1','0','brak_obrazka.jpg',NULL,'164.2300','0.0000','2017-09-25 10:22:47','2017-09-25 10:22:47',NULL,'8.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL619545EST1',''),
(605,0,4,'227_FEL619550AZ01','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:22:48','2017-09-25 10:22:48',NULL,'8.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003614','227_FEL619550AZ01',''),
(606,0,2,'227_FEL619555AZ1F','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:22:48','2017-09-25 10:22:48',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002501','227_FEL619555AZ1F',''),
(607,0,8,'227_FEL619555EST1','0','brak_obrazka.jpg',NULL,'175.6100','0.0000','2017-09-25 10:22:49','2017-09-25 10:22:49',NULL,'8.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL619555EST1',''),
(608,0,50,'227_FEL620545595S','0','brak_obrazka.jpg',NULL,'295.9300','0.0000','2017-09-25 10:22:49','2017-09-25 10:22:49',NULL,'9.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228246','227_FEL620545595S',''),
(609,0,4,'227_FEL620545EST1','0','brak_obrazka.jpg',NULL,'182.9300','0.0000','2017-09-25 10:22:49','2017-09-25 10:22:49',NULL,'8.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL620545EST1',''),
(610,0,50,'227_FEL620550595S','0','brak_obrazka.jpg',NULL,'303.2500','0.0000','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228239','227_FEL620550595S',''),
(611,0,8,'227_FEL620550EST1','0','brak_obrazka.jpg',NULL,'173.9800','0.0000','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL,'9.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL620550EST1',''),
(612,0,1,'227_FEL620555595E','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL,'10.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224859','227_FEL620555595E',''),
(613,0,2,'227_FEL620555AZ1F','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:22:50','2017-09-25 10:22:50',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001962','227_FEL620555AZ1F',''),
(614,0,8,'227_FEL620555EST1','0','brak_obrazka.jpg',NULL,'185.3700','0.0000','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL,'9.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL620555EST1',''),
(615,0,3,'227_FEL621540595_','0','brak_obrazka.jpg',NULL,'193.5000','0.0000','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL,'9.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959226358','227_FEL621540595_',''),
(616,0,8,'227_FEL621555EST1','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL621555EST1',''),
(617,0,3,'227_FEL621560GIO_','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004734','227_FEL621560GIO_',''),
(618,0,4,'227_FEL622550AZ01','0','brak_obrazka.jpg',NULL,'230.8900','0.0000','2017-09-25 10:22:51','2017-09-25 10:22:51',NULL,'10.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003065','227_FEL622550AZ01',''),
(619,0,4,'227_FEL622550FD2X','0','brak_obrazka.jpg',NULL,'172.3600','0.0000','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225245','227_FEL622550FD2X',''),
(620,0,1,'227_FEL719540595E','0','brak_obrazka.jpg',NULL,'182.9300','0.0000','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL,'8.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000606','227_FEL719540595E',''),
(621,0,8,'227_FEL720545EST1','0','brak_obrazka.jpg',NULL,'190.2400','0.0000','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL,'9.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL720545EST1','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (622,0,8,'227_FEL720550EST1','0','brak_obrazka.jpg',NULL,'191.8700','0.0000','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL720550EST1',''),
(623,0,6,'227_FEL720555EST1','0','brak_obrazka.jpg',NULL,'205.6900','0.0000','2017-09-25 10:22:52','2017-09-25 10:22:52',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL720555EST1',''),
(624,0,1,'227_FEL720555FD2X','0','brak_obrazka.jpg',NULL,'209.7600','0.0000','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959226068','227_FEL720555FD2X',''),
(625,0,30,'227_FEL721545595S','0','brak_obrazka.jpg',NULL,'304.8800','0.0000','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL,'10.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228116','227_FEL721545595S',''),
(626,0,2,'227_FEL721545EST1','0','brak_obrazka.jpg',NULL,'191.0600','0.0000','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL,'10.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL721545EST1',''),
(627,0,5,'227_FEL721545FD2X','0','brak_obrazka.jpg',NULL,'199.1900','0.0000','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225177','227_FEL721545FD2X',''),
(628,0,2,'227_FEL721550FD2X','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:22:53','2017-09-25 10:22:53',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228628','227_FEL721550FD2X',''),
(629,0,8,'227_FEL721555EST1','0','brak_obrazka.jpg',NULL,'217.0700','0.0000','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL721555EST1',''),
(630,0,2,'227_FEL721555FD2X','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224606','227_FEL721555FD2X',''),
(631,0,4,'227_FEL722545595F','0','brak_obrazka.jpg',NULL,'326.8300','0.0000','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL,'11.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001092','227_FEL722545595F',''),
(632,0,17,'227_FEL722545595S','0','brak_obrazka.jpg',NULL,'343.0900','0.0000','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL,'11.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228147','227_FEL722545595S',''),
(633,0,8,'227_FEL722550EST1','0','brak_obrazka.jpg',NULL,'213.8200','0.0000','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL722550EST1',''),
(634,0,1,'227_FEL7225555951','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:22:54','2017-09-25 10:22:54',NULL,'12.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959223739','227_FEL7225555951',''),
(635,0,2,'227_FEL722555FD2X','0','brak_obrazka.jpg',NULL,'212.2000','0.0000','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224880','227_FEL722555FD2X',''),
(636,0,49,'227_FEL723540595S','0','brak_obrazka.jpg',NULL,'375.6100','0.0000','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL,'11.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228130','227_FEL723540595S',''),
(637,0,6,'227_FEL723545EST1','0','brak_obrazka.jpg',NULL,'205.6900','0.0000','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL723545EST1',''),
(638,0,2,'227_FEL723545FD2X','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:22:55','2017-09-25 10:22:55',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225207','227_FEL723545FD2X',''),
(639,0,1,'227_FEL723550FD2_','0','brak_obrazka.jpg',NULL,'261.7900','0.0000','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225221','227_FEL723550FD2_',''),
(640,0,2,'227_FEL723555FD2X','0','brak_obrazka.jpg',NULL,'226.8300','0.0000','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225061','227_FEL723555FD2X',''),
(641,0,2,'227_FEL724545AZ01','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001740','227_FEL724545AZ01','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (642,0,50,'227_FEL725540595S','0','brak_obrazka.jpg',NULL,'383.7400','0.0000','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL,'12.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228154','227_FEL725540595S',''),
(643,0,1,'227_FEL726540595E','0','brak_obrazka.jpg',NULL,'278.0500','0.0000','2017-09-25 10:22:56','2017-09-25 10:22:56',NULL,'13.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224965','227_FEL726540595E',''),
(644,0,8,'227_FEL821540EST1','0','brak_obrazka.jpg',NULL,'227.6400','0.0000','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL,'10.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL821540EST1',''),
(645,0,1,'227_FEL821545FD2X','0','brak_obrazka.jpg',NULL,'244.7200','0.0000','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225115','227_FEL821545FD2X',''),
(646,0,50,'227_FEL822540595S','0','brak_obrazka.jpg',NULL,'347.1500','0.0000','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL,'11.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228178','227_FEL822540595S',''),
(647,0,2,'227_FEL822540FD2X','0','brak_obrazka.jpg',NULL,'208.9400','0.0000','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959225696','227_FEL822540FD2X',''),
(648,0,3,'227_FEL822560FD2_','0','brak_obrazka.jpg',NULL,'251.2200','0.0000','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001627','227_FEL822560FD2_',''),
(649,0,50,'227_FEL823540595S','0','brak_obrazka.jpg',NULL,'365.8500','0.0000','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL,'12.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228185','227_FEL823540595S',''),
(650,0,2,'227_FEL823540AZ01','0','brak_obrazka.jpg',NULL,'230.0800','0.0000','2017-09-25 10:22:57','2017-09-25 10:22:57',NULL,'11.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002655','227_FEL823540AZ01',''),
(651,0,6,'227_FEL823540EST1','0','brak_obrazka.jpg',NULL,'241.4600','0.0000','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL,'11.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL823540EST1',''),
(652,0,1,'227_FEL824545595_','0','brak_obrazka.jpg',NULL,'218.7000','0.0000','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959222855','227_FEL824545595_',''),
(653,0,4,'227_FEL824545EST1','0','brak_obrazka.jpg',NULL,'265.8500','0.0000','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL824545EST1',''),
(654,0,1,'227_FEL825535595_','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:22:58','2017-09-25 10:22:58',NULL,'12.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224347','227_FEL825535595_',''),
(655,0,10,'227_FEL825535595S','0','brak_obrazka.jpg',NULL,'384.5500','0.0000','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL,'12.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228161','227_FEL825535595S',''),
(656,0,1,'227_FEL825545595_','0','brak_obrazka.jpg',NULL,'203.2500','0.0000','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL,'14.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959223593','227_FEL825545595_',''),
(657,0,2,'227_FEL826535595_','0','brak_obrazka.jpg',NULL,'280.4900','0.0000','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL,'12.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959222152','227_FEL826535595_',''),
(658,0,26,'227_FEL826535595S','0','brak_obrazka.jpg',NULL,'449.5900','0.0000','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL,'12.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228208','227_FEL826535595S',''),
(659,0,8,'227_FEL826535EST1','0','brak_obrazka.jpg',NULL,'281.3000','0.0000','2017-09-25 10:22:59','2017-09-25 10:22:59',NULL,'12.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL826535EST1',''),
(660,0,1,'227_FEL828530595S','0','brak_obrazka.jpg',NULL,'432.5200','0.0000','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL,'13.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959229106','227_FEL828530595S',''),
(661,0,2,'227_FEL922540EST1','0','brak_obrazka.jpg',NULL,'272.3600','0.0000','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL,'12.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL922540EST1','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (662,0,2,'227_FEL923540EST1','0','brak_obrazka.jpg',NULL,'286.1800','0.0000','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL,'11.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL923540EST1',''),
(663,0,6,'227_FEL924535EST1','0','brak_obrazka.jpg',NULL,'313.8200','0.0000','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL,'13.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL924535EST1',''),
(664,0,8,'227_FEL924540EST1','0','brak_obrazka.jpg',NULL,'270.7300','0.0000','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL924540EST1',''),
(665,0,4,'227_FEL925540EST1','0','brak_obrazka.jpg',NULL,'291.0600','0.0000','2017-09-25 10:23:00','2017-09-25 10:23:00',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL925540EST1',''),
(666,0,1,'227_FEL925540FD2X','0','brak_obrazka.jpg',NULL,'286.9900','0.0000','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959224491','227_FEL925540FD2X',''),
(667,0,2,'227_FEL926535595R','0','brak_obrazka.jpg',NULL,'373.9800','0.0000','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL,'12.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001184','227_FEL926535595R',''),
(668,0,4,'227_FEL927540EST1','0','brak_obrazka.jpg',NULL,'310.5700','0.0000','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL,'14.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FEL927540EST1',''),
(669,0,16,'227_FES025540FXXL','0','brak_obrazka.jpg',NULL,'356.1000','0.0000','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL,'15.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003584','227_FES025540FXXL',''),
(670,0,2,'227_FES025545FXXL','0','brak_obrazka.jpg',NULL,'326.0200','0.0000','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL,'15.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003072','227_FES025545FXXL',''),
(671,0,16,'227_FES026545FXXL','0','brak_obrazka.jpg',NULL,'347.1500','0.0000','2017-09-25 10:23:01','2017-09-25 10:23:01',NULL,'18.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003881','227_FES026545FXXL',''),
(672,0,8,'227_FES027540FX__','0','brak_obrazka.jpg',NULL,'395.9300','0.0000','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL,'15.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001061','227_FES027540FX__',''),
(673,0,16,'227_FES028550FXXL','0','brak_obrazka.jpg',NULL,'413.0100','0.0000','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL,'20.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003478','227_FES028550FXXL',''),
(674,0,8,'227_FES029545FXXL','0','brak_obrazka.jpg',NULL,'400.8100','0.0000','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL,'19.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FES029545FXXL',''),
(675,0,7,'227_FES031535FX__','0','brak_obrazka.jpg',NULL,'410.5700','0.0000','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL,'17.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001672','227_FES031535FX__',''),
(676,0,20,'227_FES129535FXXL','0','brak_obrazka.jpg',NULL,'452.8500','0.0000','2017-09-25 10:23:02','2017-09-25 10:23:02',NULL,'14.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FES129535FXXL',''),
(677,0,28,'227_FES129540FXXL','0','brak_obrazka.jpg',NULL,'439.8400','0.0000','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL,'14.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FES129540FXXL',''),
(678,0,1,'227_FES225530SU__','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL,'15.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959228420','227_FES225530SU__',''),
(679,0,8,'227_FES226540FXXL','0','brak_obrazka.jpg',NULL,'420.3300','0.0000','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL,'17.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003959','227_FES226540FXXL',''),
(680,0,1,'227_FES228535FXXL','0','brak_obrazka.jpg',NULL,'418.7000','0.0000','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL,'18.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003973','227_FES228535FXXL',''),
(681,0,2,'227_FES228545FXXL','0','brak_obrazka.jpg',NULL,'442.2800','0.0000','2017-09-25 10:23:03','2017-09-25 10:23:03',NULL,'18.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FES228545FXXL','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (682,0,3,'227_FES229530FXXL','0','brak_obrazka.jpg',NULL,'452.0300','0.0000','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL,'18.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003980','227_FES229530FXXL',''),
(683,0,8,'227_FES230540FX__','0','brak_obrazka.jpg',NULL,'459.3500','0.0000','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL,'19.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001733','227_FES230540FX__',''),
(684,0,12,'227_FES230545FXXL','0','brak_obrazka.jpg',NULL,'457.7200','0.0000','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL,'20.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_FES230545FXXL',''),
(685,0,4,'227_FES520570XUV_','0','brak_obrazka.jpg',NULL,'205.6900','0.0000','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL,'10.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001443','227_FES520570XUV_',''),
(686,0,2,'227_FES522570SU__','0','brak_obrazka.jpg',NULL,'172.3600','0.0000','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL,'13.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959223074','227_FES522570SU__',''),
(687,0,8,'227_FES526570XUV_','0','brak_obrazka.jpg',NULL,'318.7000','0.0000','2017-09-25 10:23:04','2017-09-25 10:23:04',NULL,'16.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002327','227_FES526570XUV_',''),
(688,0,12,'227_FES621565XUV_','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL,'11.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002174','227_FES621565XUV_',''),
(689,0,8,'227_FES621570XUV_','0','brak_obrazka.jpg',NULL,'215.4500','0.0000','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL,'12.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001337','227_FES621570XUV_',''),
(690,0,4,'227_FES622570XUV_','0','brak_obrazka.jpg',NULL,'247.1500','0.0000','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL,'12.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002426','227_FES622570XUV_',''),
(691,0,2,'227_FES623560XUV_','0','brak_obrazka.jpg',NULL,'252.0300','0.0000','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL,'12.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001368','227_FES623560XUV_',''),
(692,0,10,'227_FES625565XUV_','0','brak_obrazka.jpg',NULL,'294.3100','0.0000','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL,'15.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002105','227_FES625565XUV_',''),
(693,0,1,'227_FES626570SUV_','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:23:05','2017-09-25 10:23:05',NULL,'19.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959000927','227_FES626570SUV_',''),
(694,0,8,'227_FES626570XUV_','0','brak_obrazka.jpg',NULL,'306.5000','0.0000','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL,'16.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001665','227_FES626570XUV_',''),
(695,0,1,'227_FES627570SUV_','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL,'19.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001238','227_FES627570SUV_',''),
(696,0,8,'227_FES627570XUV_','0','brak_obrazka.jpg',NULL,'332.5200','0.0000','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL,'17.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001658','227_FES627570XUV_',''),
(697,0,6,'227_FES722560XUV_','0','brak_obrazka.jpg',NULL,'230.8900','0.0000','2017-09-25 10:23:06','2017-09-25 10:23:06',NULL,'12.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002488','227_FES722560XUV_',''),
(698,0,1,'227_FES722565XUV_','0','brak_obrazka.jpg',NULL,'245.5300','0.0000','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL,'13.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001252','227_FES722565XUV_',''),
(699,0,6,'227_FES723560XUV_','0','brak_obrazka.jpg',NULL,'282.1100','0.0000','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL,'13.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001955','227_FES723560XUV_',''),
(700,0,4,'227_FES723565FX__','0','brak_obrazka.jpg',NULL,'293.5000','0.0000','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL,'13.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001016','227_FES723565FX__',''),
(701,0,8,'227_FES723565XUV_','0','brak_obrazka.jpg',NULL,'266.6700','0.0000','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL,'13.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001580','227_FES723565XUV_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (702,0,3,'227_FES724565XUV_','0','brak_obrazka.jpg',NULL,'296.7500','0.0000','2017-09-25 10:23:07','2017-09-25 10:23:07',NULL,'14.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001375','227_FES724565XUV_',''),
(703,0,2,'227_FES725560XUV_','0','brak_obrazka.jpg',NULL,'300.0000','0.0000','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL,'15.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001702','227_FES725560XUV_',''),
(704,0,4,'227_FES726570XUV_','0','brak_obrazka.jpg',NULL,'379.6700','0.0000','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL,'20.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003126','227_FES726570XUV_',''),
(705,0,9,'227_FES822555XUV_','0','brak_obrazka.jpg',NULL,'262.6000','0.0000','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002471','227_FES822555XUV_',''),
(706,0,2,'227_FES822565FX__','0','brak_obrazka.jpg',NULL,'300.0000','0.0000','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL,'15.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003669','227_FES822565FX__',''),
(707,0,12,'227_FES823550FX__','0','brak_obrazka.jpg',NULL,'259.3500','0.0000','2017-09-25 10:23:08','2017-09-25 10:23:08',NULL,'13.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003461','227_FES823550FX__',''),
(708,0,2,'227_FES823555XUV_','0','brak_obrazka.jpg',NULL,'284.5500','0.0000','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL,'13.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001344','227_FES823555XUV_',''),
(709,0,4,'227_FES823560FX__','0','brak_obrazka.jpg',NULL,'268.2900','0.0000','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL,'13.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001009','227_FES823560FX__',''),
(710,0,10,'227_FES824560XUV_','0','brak_obrazka.jpg',NULL,'303.2500','0.0000','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL,'14.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959002044','227_FES824560XUV_',''),
(711,0,2,'227_FES825545FX__','0','brak_obrazka.jpg',NULL,'339.8400','0.0000','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL,'13.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003003','227_FES825545FX__',''),
(712,0,2,'227_FES825555FX__','0','brak_obrazka.jpg',NULL,'345.5300','0.0000','2017-09-25 10:23:09','2017-09-25 10:23:09',NULL,'15.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001023','227_FES825555FX__',''),
(713,0,4,'227_FES826560XUV_','0','brak_obrazka.jpg',NULL,'351.2200','0.0000','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL,'16.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001436','227_FES826560XUV_',''),
(714,0,1,'227_FES828560SUV_','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL,'19.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001214','227_FES828560SUV_',''),
(715,0,4,'227_FES923550FX__','0','brak_obrazka.jpg',NULL,'304.8800','0.0000','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL,'13.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959004703','227_FES923550FX__',''),
(716,0,8,'227_FES923555FXXL','0','brak_obrazka.jpg',NULL,'369.9200','0.0000','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL,'14.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003911','227_FES923555FXXL',''),
(717,0,7,'227_FES925550FX__','0','brak_obrazka.jpg',NULL,'336.5900','0.0000','2017-09-25 10:23:10','2017-09-25 10:23:10',NULL,'16.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959001030','227_FES925550FX__',''),
(718,0,10,'227_FES925555FXXL','0','brak_obrazka.jpg',NULL,'334.1500','0.0000','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL,'17.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003751','227_FES925555FXXL',''),
(719,0,4,'227_FES926550FX__','0','brak_obrazka.jpg',NULL,'411.3800','0.0000','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL,'16.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003546','227_FES926550FX__',''),
(720,0,7,'227_FES927545FXXL','0','brak_obrazka.jpg',NULL,'402.4400','0.0000','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL,'16.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003720','227_FES927545FXXL',''),
(721,0,4,'227_FES927555FX__','0','brak_obrazka.jpg',NULL,'388.6200','0.0000','2017-09-25 10:23:11','2017-09-25 10:23:11',NULL,'16.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4713959003928','227_FES927555FX__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (722,0,12,'227_IF2724110BLAD','0','brak_obrazka.jpg',NULL,'150.4100','0.0000','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL,'5.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2724110BLAD',''),
(723,0,8,'227_IF2724110S212','0','brak_obrazka.jpg',NULL,'264.2300','0.0000','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL,'4.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2724110S212',''),
(724,0,2,'227_IF2734137BLAD','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL,'5.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2734137BLAD',''),
(725,0,16,'227_IF27411025HUR','0','brak_obrazka.jpg',NULL,'251.2200','0.0000','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL,'4.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF27411025HUR',''),
(726,0,8,'227_IF2744156BLAD','0','brak_obrazka.jpg',NULL,'150.4100','0.0000','2017-09-25 10:23:12','2017-09-25 10:23:12',NULL,'5.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2744156BLAD',''),
(727,0,4,'227_IF2744156S212','0','brak_obrazka.jpg',NULL,'316.2600','0.0000','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL,'5.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2744156S212',''),
(728,0,20,'227_IF2754110BLAD','0','brak_obrazka.jpg',NULL,'167.4800','0.0000','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL,'6.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2754110BLAD',''),
(729,0,8,'227_IF2754110HURR','0','brak_obrazka.jpg',NULL,'301.6300','0.0000','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL,'4.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2754110HURR',''),
(730,0,44,'227_IF2754110S212','0','brak_obrazka.jpg',NULL,'316.2600','0.0000','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL,'5.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2754110S212',''),
(731,0,4,'227_IF2754115HURR','0','brak_obrazka.jpg',NULL,'301.6300','0.0000','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL,'4.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2754115HURR',''),
(732,0,12,'227_IF2754137HURR','0','brak_obrazka.jpg',NULL,'360.1600','0.0000','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL,'4.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2754137HURR',''),
(733,0,3,'227_IF2754137S212','0','brak_obrazka.jpg',NULL,'377.2400','0.0000','2017-09-25 10:23:13','2017-09-25 10:23:13',NULL,'5.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF2754137S212',''),
(734,0,11,'227_IF4744156HURR','0','brak_obrazka.jpg',NULL,'359.3500','0.0000','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL,'5.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF4744156HURR',''),
(735,0,1,'227_IF4754110S216','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF4754110S216',''),
(736,0,8,'227_IF574156TSUNA','0','brak_obrazka.jpg',NULL,'535.7700','0.0000','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF574156TSUNA',''),
(737,0,4,'227_IF5744156SDSB','0','brak_obrazka.jpg',NULL,'754.4700','0.0000','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF5744156SDSB',''),
(738,0,9,'227_IF5754110HURR','0','brak_obrazka.jpg',NULL,'400.8100','0.0000','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF5754110HURR',''),
(739,0,4,'227_IF5754110SDSB','0','brak_obrazka.jpg',NULL,'754.4700','0.0000','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF5754110SDSB',''),
(740,0,4,'227_IF5754115HURR','0','brak_obrazka.jpg',NULL,'400.8100','0.0000','2017-09-25 10:23:14','2017-09-25 10:23:14',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF5754115HURR',''),
(741,0,2,'227_IF5754137HURR','0','brak_obrazka.jpg',NULL,'400.8100','0.0000','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF5754137HURR','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (742,0,9,'227_IF5754137SDSB','0','brak_obrazka.jpg',NULL,'754.4700','0.0000','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF5754137SDSB',''),
(743,0,4,'227_IF6744156HURR','0','brak_obrazka.jpg',NULL,'286.9900','0.0000','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL,'8.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF6744156HURR',''),
(744,0,4,'227_IF6754110HURR','0','brak_obrazka.jpg',NULL,'347.9700','0.0000','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL,'8.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF6754110HURR',''),
(745,0,4,'227_IF6754115HURR','0','brak_obrazka.jpg',NULL,'347.9700','0.0000','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL,'8.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF6754115HURR',''),
(746,0,4,'227_IF6754137HURR','0','brak_obrazka.jpg',NULL,'347.9700','0.0000','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL,'8.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF6754137HURR',''),
(747,0,4,'227_IF7744156TORN','0','brak_obrazka.jpg',NULL,'575.6100','0.0000','2017-09-25 10:23:15','2017-09-25 10:23:15',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF7744156TORN',''),
(748,0,4,'227_IF7754110TORN','0','brak_obrazka.jpg',NULL,'575.6100','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF7754110TORN',''),
(749,0,4,'227_IF7754115TORN','0','brak_obrazka.jpg',NULL,'575.6100','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF7754115TORN',''),
(750,0,4,'227_IF7754137TORN','0','brak_obrazka.jpg',NULL,'575.6100','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF7754137TORN',''),
(751,0,2,'227_IF9934110SILV','0','brak_obrazka.jpg',NULL,'99.1900','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'4.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF9934110SILV',''),
(752,0,4,'227_IF9934115SILV','0','brak_obrazka.jpg',NULL,'99.1900','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'4.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IF9934115SILV',''),
(753,0,24,'227_INALUG13BX___','0','brak_obrazka.jpg',NULL,'48.7800','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'0.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_INALUG13BX___',''),
(754,0,50,'227_INALUG14BX___','0','brak_obrazka.jpg',NULL,'55.2800','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'0.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_INALUG14BX___',''),
(755,0,25,'227_INALUG15BX___','0','brak_obrazka.jpg',NULL,'55.2800','0.0000','2017-09-25 10:23:16','2017-09-25 10:23:16',NULL,'0.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_INALUG15BX___',''),
(756,0,16,'227_INALUG16BX___','0','brak_obrazka.jpg',NULL,'54.4700','0.0000','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_INALUG16BX___',''),
(757,0,46,'227_INALUG17BX___','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL,'0.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_INALUG17BX___',''),
(758,0,12,'227_INCLUG14BX___','0','brak_obrazka.jpg',NULL,'30.8900','0.0000','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL,'0.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_INCLUG14BX___',''),
(759,0,12,'227_INSM1300_____','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL,'0.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_INSM1300_____',''),
(760,0,25,'227_IO0196HMXR6__','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO0196HMXR6__',''),
(761,0,6,'227_IO0206HMXR6__','0','brak_obrazka.jpg',NULL,'182.9300','0.0000','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL,'4.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO0206HMXR6__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (762,0,2,'227_IO0227MLSP___','0','brak_obrazka.jpg',NULL,'203.2500','0.0000','2017-09-25 10:23:17','2017-09-25 10:23:17',NULL,'6.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO0227MLSP___',''),
(763,0,3,'227_IO2250MLXL___','0','brak_obrazka.jpg',NULL,'291.8700','0.0000','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL,'11.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2250MLXL___',''),
(764,0,2,'227_IO2250MLXTR__','0','brak_obrazka.jpg',NULL,'447.1500','0.0000','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL,'11.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2250MLXTR__',''),
(765,0,2,'227_IO22510BCR___','0','brak_obrazka.jpg',NULL,'430.8900','0.0000','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL,'13.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22510BCR___',''),
(766,0,2,'227_IO22510MAY___','0','brak_obrazka.jpg',NULL,'321.9500','0.0000','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL,'10.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22510MAY___',''),
(767,0,4,'227_IO22510MLII__','0','brak_obrazka.jpg',NULL,'278.0500','0.0000','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL,'11.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22510MLII__',''),
(768,0,2,'227_IO2258MLII___','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL,'9.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2258MLII___',''),
(769,0,6,'227_IO2258MLXL___','0','brak_obrazka.jpg',NULL,'235.7700','0.0000','2017-09-25 10:23:18','2017-09-25 10:23:18',NULL,'9.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2258MLXL___',''),
(770,0,2,'227_IO2258MLXTR__','0','brak_obrazka.jpg',NULL,'400.8100','0.0000','2017-09-25 10:23:19','2017-09-25 10:23:19',NULL,'9.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2258MLXTR__',''),
(771,0,1,'227_IO22610MLXL__','0','brak_obrazka.jpg',NULL,'325.2000','0.0000','2017-09-25 10:23:19','2017-09-25 10:23:19',NULL,'12.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22610MLXL__',''),
(772,0,2,'227_IO22611BCR___','0','brak_obrazka.jpg',NULL,'453.6600','0.0000','2017-09-25 10:23:19','2017-09-25 10:23:19',NULL,'15.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22611BCR___',''),
(773,0,15,'227_IO22611MLII__','0','brak_obrazka.jpg',NULL,'364.2300','0.0000','2017-09-25 10:23:20','2017-09-25 10:23:20',NULL,'15.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22611MLII__',''),
(774,0,3,'227_IO2261MAY____','0','brak_obrazka.jpg',NULL,'356.9100','0.0000','2017-09-25 10:23:21','2017-09-25 10:23:21',NULL,'12.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2261MAY____',''),
(775,0,6,'227_IO2261MLXTR__','0','brak_obrazka.jpg',NULL,'481.3000','0.0000','2017-09-25 10:23:22','2017-09-25 10:23:22',NULL,'14.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2261MLXTR__',''),
(776,0,2,'227_IO2262MLXLEM_','0','brak_obrazka.jpg',NULL,'389.4300','0.0000','2017-09-25 10:23:22','2017-09-25 10:23:22',NULL,'14.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2262MLXLEM_',''),
(777,0,2,'227_IO2269BAJA___','0','brak_obrazka.jpg',NULL,'429.2700','0.0000','2017-09-25 10:23:22','2017-09-25 10:23:22',NULL,'12.1400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2269BAJA___',''),
(778,0,2,'227_IO2269MAY____','0','brak_obrazka.jpg',NULL,'321.9500','0.0000','2017-09-25 10:23:23','2017-09-25 10:23:23',NULL,'10.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2269MAY____',''),
(779,0,16,'227_IO2269MLII___','0','brak_obrazka.jpg',NULL,'324.3900','0.0000','2017-09-25 10:23:23','2017-09-25 10:23:23',NULL,'12.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2269MLII___',''),
(780,0,8,'227_IO2269MLXTR__','0','brak_obrazka.jpg',NULL,'431.7100','0.0000','2017-09-25 10:23:24','2017-09-25 10:23:24',NULL,'11.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2269MLXTR__',''),
(781,0,16,'227_IO22711MLII__','0','brak_obrazka.jpg',NULL,'405.6900','0.0000','2017-09-25 10:23:24','2017-09-25 10:23:24',NULL,'15.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22711MLII__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (782,0,2,'227_IO22711MLXTR_','0','brak_obrazka.jpg',NULL,'516.2600','0.0000','2017-09-25 10:23:25','2017-09-25 10:23:25',NULL,'15.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO22711MLXTR_',''),
(783,0,4,'227_IO2279MAY____','0','brak_obrazka.jpg',NULL,'353.6600','0.0000','2017-09-25 10:23:25','2017-09-25 10:23:25',NULL,'13.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2279MAY____',''),
(784,0,18,'227_IO2279MLII___','0','brak_obrazka.jpg',NULL,'373.9800','0.0000','2017-09-25 10:23:25','2017-09-25 10:23:25',NULL,'12.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2279MLII___',''),
(785,0,2,'227_IO2279MLXL___','0','brak_obrazka.jpg',NULL,'361.7900','0.0000','2017-09-25 10:23:26','2017-09-25 10:23:26',NULL,'11.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2279MLXL___',''),
(786,0,2,'227_IO2279MLXTR__','0','brak_obrazka.jpg',NULL,'470.7300','0.0000','2017-09-25 10:23:27','2017-09-25 10:23:27',NULL,'12.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2279MLXTR__',''),
(787,0,18,'227_IO2281MEGAMAY','0','brak_obrazka.jpg',NULL,'417.0700','0.0000','2017-09-25 10:23:27','2017-09-25 10:23:27',NULL,'16.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2281MEGAMAY',''),
(788,0,20,'227_IO2289MEGAMAY','0','brak_obrazka.jpg',NULL,'456.1000','0.0000','2017-09-25 10:23:27','2017-09-25 10:23:27',NULL,'15.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO2289MEGAMAY',''),
(789,0,4,'227_IO23010BWE___','0','brak_obrazka.jpg',NULL,'543.9000','0.0000','2017-09-25 10:23:28','2017-09-25 10:23:28',NULL,'16.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO23010BWE___',''),
(790,0,2,'227_IO23012MLXXL_','0','brak_obrazka.jpg',NULL,'622.7600','0.0000','2017-09-25 10:23:28','2017-09-25 10:23:28',NULL,'16.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO23012MLXXL_',''),
(791,0,4,'227_IO4261TERRA__','0','brak_obrazka.jpg',NULL,'423.5800','0.0000','2017-09-25 10:23:29','2017-09-25 10:23:29',NULL,'14.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4261TERRA__',''),
(792,0,6,'227_IO4269TERRA__','0','brak_obrazka.jpg',NULL,'384.5500','0.0000','2017-09-25 10:23:29','2017-09-25 10:23:29',NULL,'11.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4269TERRA__',''),
(793,0,10,'227_IO42710MLXL__','0','brak_obrazka.jpg',NULL,'364.2300','0.0000','2017-09-25 10:23:30','2017-09-25 10:23:30',NULL,'13.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42710MLXL__',''),
(794,0,4,'227_IO42711BCS___','0','brak_obrazka.jpg',NULL,'508.1300','0.0000','2017-09-25 10:23:30','2017-09-25 10:23:30',NULL,'13.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42711BCS___',''),
(795,0,2,'227_IO42711BWE___','0','brak_obrazka.jpg',NULL,'631.7100','0.0000','2017-09-25 10:23:30','2017-09-25 10:23:30',NULL,'14.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42711BWE___',''),
(796,0,18,'227_IO42711MLII__','0','brak_obrazka.jpg',NULL,'397.5600','0.0000','2017-09-25 10:23:31','2017-09-25 10:23:31',NULL,'14.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42711MLII__',''),
(797,0,2,'227_IO42711MLXTR_','0','brak_obrazka.jpg',NULL,'607.3200','0.0000','2017-09-25 10:23:31','2017-09-25 10:23:31',NULL,'15.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42711MLXTR_',''),
(798,0,10,'227_IO42712MLXL__','0','brak_obrazka.jpg',NULL,'379.6700','0.0000','2017-09-25 10:23:31','2017-09-25 10:23:31',NULL,'14.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42712MLXL__',''),
(799,0,2,'227_IO4271MEGAMAY','0','brak_obrazka.jpg',NULL,'398.3700','0.0000','2017-09-25 10:23:32','2017-09-25 10:23:32',NULL,'15.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4271MEGAMAY',''),
(800,0,4,'227_IO4279BCS____','0','brak_obrazka.jpg',NULL,'460.1600','0.0000','2017-09-25 10:23:32','2017-09-25 10:23:32',NULL,'12.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4279BCS____',''),
(801,0,2,'227_IO4279BWATER_','0','brak_obrazka.jpg',NULL,'575.6100','0.0000','2017-09-25 10:23:32','2017-09-25 10:23:32',NULL,'12.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4279BWATER_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (802,0,2,'227_IO4279MEGAMAY','0','brak_obrazka.jpg',NULL,'391.0600','0.0000','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL,'12.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4279MEGAMAY',''),
(803,0,18,'227_IO4279MLII___','0','brak_obrazka.jpg',NULL,'366.6700','0.0000','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL,'12.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4279MLII___',''),
(804,0,10,'227_IO42810MLXL__','0','brak_obrazka.jpg',NULL,'391.8700','0.0000','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL,'12.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42810MLXL__',''),
(805,0,2,'227_IO42811MLII__','0','brak_obrazka.jpg',NULL,'408.1300','0.0000','2017-09-25 10:23:33','2017-09-25 10:23:33',NULL,'16.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42811MLII__',''),
(806,0,9,'227_IO42812MLXL__','0','brak_obrazka.jpg',NULL,'404.8800','0.0000','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL,'14.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42812MLXL__',''),
(807,0,16,'227_IO4281MEGAMAY','0','brak_obrazka.jpg',NULL,'426.0200','0.0000','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL,'15.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4281MEGAMAY',''),
(808,0,16,'227_IO4289MEGAMAY','0','brak_obrazka.jpg',NULL,'419.5100','0.0000','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL,'14.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4289MEGAMAY',''),
(809,0,2,'227_IO4289MLII___','0','brak_obrazka.jpg',NULL,'378.0500','0.0000','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL,'14.4100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4289MLII___',''),
(810,0,2,'227_IO42911BCS___','0','brak_obrazka.jpg',NULL,'543.9000','0.0000','2017-09-25 10:23:34','2017-09-25 10:23:34',NULL,'16.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO42911BCS___',''),
(811,0,1,'227_IO4299BCS____','0','brak_obrazka.jpg',NULL,'514.6300','0.0000','2017-09-25 10:23:35','2017-09-25 10:23:35',NULL,'14.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4299BCS____',''),
(812,0,2,'227_IO43010CRYPTI','0','brak_obrazka.jpg',NULL,'710.5700','0.0000','2017-09-25 10:23:35','2017-09-25 10:23:35',NULL,'19.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO43010CRYPTI',''),
(813,0,2,'227_IO43010MLXXL_','0','brak_obrazka.jpg',NULL,'540.6500','0.0000','2017-09-25 10:23:35','2017-09-25 10:23:35',NULL,'15.8300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO43010MLXXL_',''),
(814,0,2,'227_IO43010MONSTE','0','brak_obrazka.jpg',NULL,'633.3300','0.0000','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL,'17.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO43010MONSTE',''),
(815,0,6,'227_IO43011MLII__','0','brak_obrazka.jpg',NULL,'546.3400','0.0000','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL,'18.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO43011MLII__',''),
(816,0,2,'227_IO43012MLXXL_','0','brak_obrazka.jpg',NULL,'576.4200','0.0000','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL,'17.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO43012MLXXL_',''),
(817,0,6,'227_IO4309MLII___','0','brak_obrazka.jpg',NULL,'500.0000','0.0000','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL,'15.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4309MLII___',''),
(818,0,2,'227_IO4309MONSTER','0','brak_obrazka.jpg',NULL,'521.9500','0.0000','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL,'17.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4309MONSTER',''),
(819,0,9,'227_IO4319.5UCR__','0','brak_obrazka.jpg',NULL,'726.0200','0.0000','2017-09-25 10:23:36','2017-09-25 10:23:36',NULL,'16.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO4319.5UCR__',''),
(820,0,4,'227_IO43210MAMMOT','0','brak_obrazka.jpg',NULL,'589.4300','0.0000','2017-09-25 10:23:37','2017-09-25 10:23:37',NULL,'24.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO43210MAMMOT',''),
(821,0,4,'227_IO53010BWE___','0','brak_obrazka.jpg',NULL,'571.5400','0.0000','2017-09-25 10:23:37','2017-09-25 10:23:37',NULL,'15.4100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO53010BWE___','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (822,0,16,'227_IO53010UCR___','0','brak_obrazka.jpg',NULL,'682.1100','0.0000','2017-09-25 10:23:37','2017-09-25 10:23:37',NULL,'15.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO53010UCR___',''),
(823,0,20,'227_IO531950UCR__','0','brak_obrazka.jpg',NULL,'753.6600','0.0000','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL,'15.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO531950UCR__',''),
(824,0,4,'227_IO53210BWE___','0','brak_obrazka.jpg',NULL,'615.4500','0.0000','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL,'16.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO53210BWE___',''),
(825,0,3,'227_IO53210CRYPTI','0','brak_obrazka.jpg',NULL,'630.0800','0.0000','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL,'22.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO53210CRYPTI',''),
(826,0,4,'227_IO73410BWE___','0','brak_obrazka.jpg',NULL,'731.7100','0.0000','2017-09-25 10:23:38','2017-09-25 10:23:38',NULL,'18.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO73410BWE___',''),
(827,0,4,'227_IO73410CRYPTI','0','brak_obrazka.jpg',NULL,'806.5000','0.0000','2017-09-25 10:23:39','2017-09-25 10:23:39',NULL,'24.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO73410CRYPTI',''),
(828,0,4,'227_IO73410UCR___','0','brak_obrazka.jpg',NULL,'686.1800','0.0000','2017-09-25 10:23:39','2017-09-25 10:23:39',NULL,'19.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO73410UCR___',''),
(829,0,4,'227_IO73610CRYPTI','0','brak_obrazka.jpg',NULL,'859.3500','0.0000','2017-09-25 10:23:39','2017-09-25 10:23:39',NULL,'29.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO73610CRYPTI',''),
(830,0,2,'227_IO91810HMXR6_','0','brak_obrazka.jpg',NULL,'204.8800','0.0000','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL,'4.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO91810HMXR6_',''),
(831,0,2,'227_IO92011HHD___','0','brak_obrazka.jpg',NULL,'300.0000','0.0000','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL,'8.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO92011HHD___',''),
(832,0,50,'227_IO9201HXCR03_','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL,'7.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_IO9201HXCR03_',''),
(833,0,37,'227_JOD0500TR13BU','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD0500TR13BU',''),
(834,0,44,'227_JOD2400TR13BU','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD2400TR13BU',''),
(835,0,45,'227_JOD265080TR13','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:23:41','2017-09-25 10:23:41',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD265080TR13',''),
(836,0,24,'227_JOD428025TR87','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:23:42','2017-09-25 10:23:42',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD428025TR87',''),
(837,0,14,'227_JOD512400TR87','0','brak_obrazka.jpg',NULL,'12.2000','0.0000','2017-09-25 10:23:42','2017-09-25 10:23:42',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD512400TR87',''),
(838,0,29,'227_JOD534030TR87','0','brak_obrazka.jpg',NULL,'11.3800','0.0000','2017-09-25 10:23:43','2017-09-25 10:23:43',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD534030TR87',''),
(839,0,50,'227_JOD613650TR13','0','brak_obrazka.jpg',NULL,'13.8200','0.0000','2017-09-25 10:23:43','2017-09-25 10:23:43',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD613650TR13',''),
(840,0,50,'227_JOD641035TR13','0','brak_obrazka.jpg',NULL,'10.5700','0.0000','2017-09-25 10:23:43','2017-09-25 10:23:43',NULL,'0.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD641035TR13',''),
(841,0,18,'227_JOD835040TR13','0','brak_obrazka.jpg',NULL,'12.2000','0.0000','2017-09-25 10:23:44','2017-09-25 10:23:44',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD835040TR13','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (842,0,40,'227_JOD848040TR13','0','brak_obrazka.jpg',NULL,'13.8200','0.0000','2017-09-25 10:23:44','2017-09-25 10:23:44',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD848040TR13',''),
(843,0,42,'227_JOD848040TR87','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:23:44','2017-09-25 10:23:44',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD848040TR87',''),
(844,0,47,'227_JOD8500TR13BU','0','brak_obrazka.jpg',NULL,'25.2000','0.0000','2017-09-25 10:23:45','2017-09-25 10:23:45',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD8500TR13BU',''),
(845,0,42,'227_JOD8500TR87BU','0','brak_obrazka.jpg',NULL,'21.1400','0.0000','2017-09-25 10:23:46','2017-09-25 10:23:46',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOD8500TR87BU',''),
(846,0,22,'227_JOI020580P815','0','brak_obrazka.jpg',NULL,'123.5800','0.0000','2017-09-25 10:23:46','2017-09-25 10:23:46',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOI020580P815',''),
(847,0,12,'227_JOM260100P262','0','brak_obrazka.jpg',NULL,'39.0200','0.0000','2017-09-25 10:23:46','2017-09-25 10:23:46',NULL,'1.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOM260100P262',''),
(848,0,4,'227_JOM28010P2006','0','brak_obrazka.jpg',NULL,'86.9900','0.0000','2017-09-25 10:23:46','2017-09-25 10:23:46',NULL,'2.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOM28010P2006',''),
(849,0,50,'227_JOU020110P357','0','brak_obrazka.jpg',NULL,'186.9900','0.0000','2017-09-25 10:23:47','2017-09-25 10:23:47',NULL,'7.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU020110P357',''),
(850,0,50,'227_JOU0217P348__','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:23:47','2017-09-25 10:23:47',NULL,'5.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU0217P348__',''),
(851,0,50,'227_JOU0217P356__','0','brak_obrazka.jpg',NULL,'124.3900','0.0000','2017-09-25 10:23:47','2017-09-25 10:23:47',NULL,'5.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU0217P356__',''),
(852,0,50,'227_JOU022100P349','0','brak_obrazka.jpg',NULL,'231.7100','0.0000','2017-09-25 10:23:48','2017-09-25 10:23:48',NULL,'7.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU022100P349',''),
(853,0,42,'227_JOU022100P357','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:23:48','2017-09-25 10:23:48',NULL,'8.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU022100P357',''),
(854,0,50,'227_JOU02210P3364','0','brak_obrazka.jpg',NULL,'189.4300','0.0000','2017-09-25 10:23:48','2017-09-25 10:23:48',NULL,'7.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU02210P3364',''),
(855,0,3,'227_JOU022110P367','0','brak_obrazka.jpg',NULL,'187.8000','0.0000','2017-09-25 10:23:48','2017-09-25 10:23:48',NULL,'7.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU022110P367',''),
(856,0,50,'227_JOU0227P3564_','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:23:48','2017-09-25 10:23:48',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU0227P3564_',''),
(857,0,17,'227_JOU022900P367','0','brak_obrazka.jpg',NULL,'159.3500','0.0000','2017-09-25 10:23:48','2017-09-25 10:23:48',NULL,'7.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU022900P367',''),
(858,0,29,'227_JOU023700P349','0','brak_obrazka.jpg',NULL,'170.7300','0.0000','2017-09-25 10:23:49','2017-09-25 10:23:49',NULL,'6.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU023700P349',''),
(859,0,24,'227_JOU2250P3035_','0','brak_obrazka.jpg',NULL,'278.0500','0.0000','2017-09-25 10:23:49','2017-09-25 10:23:49',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2250P3035_',''),
(860,0,50,'227_JOU2250P3504_','0','brak_obrazka.jpg',NULL,'265.8500','0.0000','2017-09-25 10:23:49','2017-09-25 10:23:49',NULL,'10.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2250P3504_',''),
(861,0,36,'227_JOU2250P354__','0','brak_obrazka.jpg',NULL,'226.8300','0.0000','2017-09-25 10:23:49','2017-09-25 10:23:49',NULL,'9.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2250P354__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (862,0,50,'227_JOU2250P375__','0','brak_obrazka.jpg',NULL,'278.0500','0.0000','2017-09-25 10:23:49','2017-09-25 10:23:49',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2250P375__',''),
(863,0,2,'227_JOU22510P3006','0','brak_obrazka.jpg',NULL,'283.7400','0.0000','2017-09-25 10:23:49','2017-09-25 10:23:49',NULL,'10.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU22510P3006',''),
(864,0,50,'227_JOU22510P377_','0','brak_obrazka.jpg',NULL,'213.8200','0.0000','2017-09-25 10:23:49','2017-09-25 10:23:49',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU22510P377_',''),
(865,0,22,'227_JOU2258P3035_','0','brak_obrazka.jpg',NULL,'230.0800','0.0000','2017-09-25 10:23:50','2017-09-25 10:23:50',NULL,'8.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2258P3035_',''),
(866,0,50,'227_JOU2258P350__','0','brak_obrazka.jpg',NULL,'225.2000','0.0000','2017-09-25 10:23:50','2017-09-25 10:23:50',NULL,'9.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2258P350__',''),
(867,0,41,'227_JOU2258P354__','0','brak_obrazka.jpg',NULL,'199.1900','0.0000','2017-09-25 10:23:50','2017-09-25 10:23:50',NULL,'8.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2258P354__',''),
(868,0,50,'227_JOU2258P375__','0','brak_obrazka.jpg',NULL,'264.2300','0.0000','2017-09-25 10:23:50','2017-09-25 10:23:50',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2258P375__',''),
(869,0,50,'227_JOU2258P377__','0','brak_obrazka.jpg',NULL,'174.8000','0.0000','2017-09-25 10:23:50','2017-09-25 10:23:50',NULL,'8.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2258P377__',''),
(870,0,1,'227_JOU22611P3006','0','brak_obrazka.jpg',NULL,'273.9800','0.0000','2017-09-25 10:23:50','2017-09-25 10:23:50',NULL,'12.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU22611P3006',''),
(871,0,50,'227_JOU22611P350_','0','brak_obrazka.jpg',NULL,'343.9000','0.0000','2017-09-25 10:23:50','2017-09-25 10:23:50',NULL,'12.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU22611P350_',''),
(872,0,38,'227_JOU2262P375__','0','brak_obrazka.jpg',NULL,'286.9900','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2262P375__',''),
(873,0,1,'227_JOU2269P3006_','0','brak_obrazka.jpg',NULL,'224.3900','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'10.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2269P3006_',''),
(874,0,50,'227_JOU2269P350__','0','brak_obrazka.jpg',NULL,'301.6300','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'11.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2269P350__',''),
(875,0,50,'227_JOU2269P375__','0','brak_obrazka.jpg',NULL,'249.5900','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU2269P375__',''),
(876,0,46,'227_JOU426100P349','0','brak_obrazka.jpg',NULL,'269.1100','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU426100P349',''),
(877,0,28,'227_JOU42611P3035','0','brak_obrazka.jpg',NULL,'347.9700','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU42611P3035',''),
(878,0,43,'227_JOU426800P349','0','brak_obrazka.jpg',NULL,'232.5200','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU426800P349',''),
(879,0,18,'227_JOU4269P3035_','0','brak_obrazka.jpg',NULL,'297.5600','0.0000','2017-09-25 10:23:51','2017-09-25 10:23:51',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU4269P3035_',''),
(880,0,30,'227_JOU42711P3036','0','brak_obrazka.jpg',NULL,'430.0800','0.0000','2017-09-25 10:23:52','2017-09-25 10:23:52',NULL,'16.1400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU42711P3036',''),
(881,0,49,'227_JOU42711P3506','0','brak_obrazka.jpg',NULL,'370.7300','0.0000','2017-09-25 10:23:52','2017-09-25 10:23:52',NULL,'12.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU42711P3506','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (882,0,30,'227_JOU4279O3036_','0','brak_obrazka.jpg',NULL,'369.1100','0.0000','2017-09-25 10:23:52','2017-09-25 10:23:52',NULL,'13.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU4279O3036_',''),
(883,0,50,'227_JOU4279P3506_','0','brak_obrazka.jpg',NULL,'313.8200','0.0000','2017-09-25 10:23:52','2017-09-25 10:23:52',NULL,'11.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU4279P3506_',''),
(884,0,40,'227_JOU42810P3036','0','brak_obrazka.jpg',NULL,'434.9600','0.0000','2017-09-25 10:23:52','2017-09-25 10:23:52',NULL,'15.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU42810P3036',''),
(885,0,36,'227_JOU42911P3036','0','brak_obrazka.jpg',NULL,'474.8000','0.0000','2017-09-25 10:23:52','2017-09-25 10:23:52',NULL,'17.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU42911P3036',''),
(886,0,36,'227_JOU4299P3036_','0','brak_obrazka.jpg',NULL,'442.2800','0.0000','2017-09-25 10:23:53','2017-09-25 10:23:53',NULL,'15.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU4299P3036_',''),
(887,0,39,'227_JOU43010P3036','0','brak_obrazka.jpg',NULL,'461.7900','0.0000','2017-09-25 10:23:53','2017-09-25 10:23:53',NULL,'16.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU43010P3036',''),
(888,0,20,'227_JOU43010P3048','0','brak_obrazka.jpg',NULL,'611.3800','0.0000','2017-09-25 10:23:53','2017-09-25 10:23:53',NULL,'22.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU43010P3048',''),
(889,0,8,'227_JOU4301VS3021','0','brak_obrazka.jpg',NULL,'441.4600','0.0000','2017-09-25 10:23:53','2017-09-25 10:23:53',NULL,'18.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU4301VS3021',''),
(890,0,20,'227_JOU52810P3036','0','brak_obrazka.jpg',NULL,'447.9700','0.0000','2017-09-25 10:23:53','2017-09-25 10:23:53',NULL,'16.1400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU52810P3036',''),
(891,0,19,'227_JOU53010P3036','0','brak_obrazka.jpg',NULL,'469.1100','0.0000','2017-09-25 10:23:53','2017-09-25 10:23:53',NULL,'16.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU53010P3036',''),
(892,0,50,'227_JOU614570P319','0','brak_obrazka.jpg',NULL,'43.9000','0.0000','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL,'1.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU614570P319',''),
(893,0,50,'227_JOU614570P361','0','brak_obrazka.jpg',NULL,'50.4100','0.0000','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU614570P361',''),
(894,0,48,'227_JOU6350H8030_','0','brak_obrazka.jpg',NULL,'34.9600','0.0000','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU6350H8030_',''),
(895,0,50,'227_JOU7168P319__','0','brak_obrazka.jpg',NULL,'73.1700','0.0000','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL,'3.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU7168P319__',''),
(896,0,16,'227_JOU7168P322__','0','brak_obrazka.jpg',NULL,'99.1900','0.0000','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL,'2.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU7168P322__',''),
(897,0,38,'227_JOU7168P329__','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL,'3.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU7168P329__',''),
(898,0,47,'227_JOU7168P361__','0','brak_obrazka.jpg',NULL,'84.5500','0.0000','2017-09-25 10:23:54','2017-09-25 10:23:54',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU7168P361__',''),
(899,0,46,'227_JOU8188P340__','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:23:55','2017-09-25 10:23:55',NULL,'4.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU8188P340__',''),
(900,0,50,'227_JOU818950P311','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:23:55','2017-09-25 10:23:55',NULL,'5.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU818950P311',''),
(901,0,17,'227_JOU818950P316','0','brak_obrazka.jpg',NULL,'114.6300','0.0000','2017-09-25 10:23:55','2017-09-25 10:23:55',NULL,'4.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU818950P316','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (902,0,50,'227_JOU818950P343','0','brak_obrazka.jpg',NULL,'143.0900','0.0000','2017-09-25 10:23:55','2017-09-25 10:23:55',NULL,'6.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU818950P343',''),
(903,0,40,'227_JOU819700P311','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:23:55','2017-09-25 10:23:55',NULL,'5.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU819700P311',''),
(904,0,27,'227_JOU819700P315','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:23:55','2017-09-25 10:23:55',NULL,'3.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU819700P315',''),
(905,0,50,'227_JOU819700P327','0','brak_obrazka.jpg',NULL,'94.3100','0.0000','2017-09-25 10:23:55','2017-09-25 10:23:55',NULL,'3.5800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU819700P327',''),
(906,0,21,'227_JOU819700P343','0','brak_obrazka.jpg',NULL,'103.2500','0.0000','2017-09-25 10:23:56','2017-09-25 10:23:56',NULL,'5.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU819700P343',''),
(907,0,1,'227_JOU819950P311','0','brak_obrazka.jpg',NULL,'152.0300','0.0000','2017-09-25 10:23:56','2017-09-25 10:23:56',NULL,'7.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU819950P311',''),
(908,0,50,'227_JOU819950P316','0','brak_obrazka.jpg',NULL,'147.1500','0.0000','2017-09-25 10:23:56','2017-09-25 10:23:56',NULL,'5.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU819950P316',''),
(909,0,9,'227_JOU82011P357_','0','brak_obrazka.jpg',NULL,'191.0600','0.0000','2017-09-25 10:23:56','2017-09-25 10:23:56',NULL,'7.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU82011P357_',''),
(910,0,18,'227_JOU821700P311','0','brak_obrazka.jpg',NULL,'148.7800','0.0000','2017-09-25 10:23:56','2017-09-25 10:23:56',NULL,'6.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU821700P311',''),
(911,0,8,'227_JOU822110P322','0','brak_obrazka.jpg',NULL,'181.3000','0.0000','2017-09-25 10:23:57','2017-09-25 10:23:57',NULL,'6.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU822110P322',''),
(912,0,39,'227_JOU82212P308_','0','brak_obrazka.jpg',NULL,'184.5500','0.0000','2017-09-25 10:23:57','2017-09-25 10:23:57',NULL,'7.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU82212P308_',''),
(913,0,50,'227_JOU822510P303','0','brak_obrazka.jpg',NULL,'160.1600','0.0000','2017-09-25 10:23:57','2017-09-25 10:23:57',NULL,'9.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU822510P303',''),
(914,0,22,'227_JOU9200P336__','0','brak_obrazka.jpg',NULL,'177.2400','0.0000','2017-09-25 10:23:57','2017-09-25 10:23:57',NULL,'6.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU9200P336__',''),
(915,0,7,'227_JOU9200P354__','0','brak_obrazka.jpg',NULL,'173.9800','0.0000','2017-09-25 10:23:57','2017-09-25 10:23:57',NULL,'6.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU9200P354__',''),
(916,0,50,'227_JOU92010P3574','0','brak_obrazka.jpg',NULL,'177.2400','0.0000','2017-09-25 10:23:57','2017-09-25 10:23:57',NULL,'7.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU92010P3574',''),
(917,0,50,'227_JOU9201P537__','0','brak_obrazka.jpg',NULL,'212.2000','0.0000','2017-09-25 10:23:57','2017-09-25 10:23:57',NULL,'8.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU9201P537__',''),
(918,0,50,'227_JOU92211P3574','0','brak_obrazka.jpg',NULL,'216.2600','0.0000','2017-09-25 10:23:58','2017-09-25 10:23:58',NULL,'8.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU92211P3574',''),
(919,0,25,'227_JOU92512P3030','0','brak_obrazka.jpg',NULL,'264.2300','0.0000','2017-09-25 10:23:58','2017-09-25 10:23:58',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_JOU92512P3030',''),
(920,0,6,'227_KEC522575KR28','0','brak_obrazka.jpg',NULL,'245.5300','0.0000','2017-09-25 10:23:58','2017-09-25 10:23:58',NULL,'13.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432028','227_KEC522575KR28',''),
(921,0,24,'227_KEC523575KR29','0','brak_obrazka.jpg',NULL,'366.6700','0.0000','2017-09-25 10:23:58','2017-09-25 10:23:58',NULL,'19.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684262','227_KEC523575KR29','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (922,0,13,'227_KEC532115KR29','0','brak_obrazka.jpg',NULL,'456.9100','0.0000','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL,'24.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684286','227_KEC532115KR29',''),
(923,0,4,'227_KEC622575KR28','0','brak_obrazka.jpg',NULL,'269.1100','0.0000','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL,'17.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954431717','227_KEC622575KR28',''),
(924,0,12,'227_KEC624575KR29','0','brak_obrazka.jpg',NULL,'386.9900','0.0000','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL,'23.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684200','227_KEC624575KR29',''),
(925,0,16,'227_KEC625570KR28','0','brak_obrazka.jpg',NULL,'318.7000','0.0000','2017-09-25 10:23:59','2017-09-25 10:23:59',NULL,'17.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432073','227_KEC625570KR28',''),
(926,0,4,'227_KEC626575KR29','0','brak_obrazka.jpg',NULL,'460.9800','0.0000','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL,'25.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684446','227_KEC626575KR29',''),
(927,0,28,'227_KEC628575KR29','0','brak_obrazka.jpg',NULL,'465.8500','0.0000','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL,'29.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684453','227_KEC628575KR29',''),
(928,0,19,'227_KEC725565KR28','0','brak_obrazka.jpg',NULL,'320.3300','0.0000','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL,'18.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432066','227_KEC725565KR28',''),
(929,0,14,'227_KEC72657029KR','0','brak_obrazka.jpg',NULL,'471.5400','0.0000','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL,'25.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684248','227_KEC72657029KR',''),
(930,0,16,'227_KED214580KR06','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL,'6.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954445172','227_KED214580KR06',''),
(931,0,29,'227_KED215570KR16','0','brak_obrazka.jpg',NULL,'187.8000','0.0000','2017-09-25 10:24:00','2017-09-25 10:24:00',NULL,'6.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954422883','227_KED215570KR16',''),
(932,0,4,'227_KED215580KR33','0','brak_obrazka.jpg',NULL,'108.9400','0.0000','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294981453','227_KED215580KR33',''),
(933,0,24,'227_KED318570KR16','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL,'7.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294687249','227_KED318570KR16',''),
(934,0,31,'227_KED319550KR16','0','brak_obrazka.jpg',NULL,'204.0700','0.0000','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL,'7.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954422890','227_KED319550KR16',''),
(935,0,17,'227_KED419570KR16','0','brak_obrazka.jpg',NULL,'233.3300','0.0000','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL,'10.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294687256','227_KED419570KR16',''),
(936,0,2,'227_KED419575KR06','0','brak_obrazka.jpg',NULL,'207.3200','0.0000','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL,'11.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954445189','227_KED419575KR06',''),
(937,0,12,'227_KED5700KR12__','0','brak_obrazka.jpg',NULL,'286.1800','0.0000','2017-09-25 10:24:01','2017-09-25 10:24:01',NULL,'16.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294986663','227_KED5700KR12__',''),
(938,0,4,'227_KED621560KR06','0','brak_obrazka.jpg',NULL,'180.4900','0.0000','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL,'13.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954443291','227_KED621560KR06',''),
(939,0,10,'227_KED6650KR12__','0','brak_obrazka.jpg',NULL,'297.5600','0.0000','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL,'15.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294986670','227_KED6650KR12__',''),
(940,0,2,'227_KED6700KR12__','0','brak_obrazka.jpg',NULL,'325.2000','0.0000','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL,'18.4100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294986700','227_KED6700KR12__',''),
(941,0,15,'227_KEDD025027JS8','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:24:02','2017-09-25 10:24:02',NULL,'0.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD025027JS8','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (942,0,12,'227_KEDD025027TR4','0','brak_obrazka.jpg',NULL,'25.2000','0.0000','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL,'0.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD025027TR4',''),
(943,0,9,'227_KEDD027530JS8','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL,'0.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD027530JS8',''),
(944,0,4,'227_KEDD027530TR4','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL,'0.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD027530TR4',''),
(945,0,14,'227_KEDD030032JS8','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL,'0.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD030032JS8',''),
(946,0,17,'227_KEDD035040JS8','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:24:03','2017-09-25 10:24:03',NULL,'0.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD035040JS8',''),
(947,0,26,'227_KEDD127530TR4','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL,'0.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD127530TR4',''),
(948,0,4,'227_KEDD130032TR4','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL,'0.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD130032TR4',''),
(949,0,21,'227_KEDD132535TR4','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL,'0.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD132535TR4',''),
(950,0,41,'227_KEDD180100TR6','0','brak_obrazka.jpg',NULL,'59.3500','0.0000','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL,'1.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD180100TR6',''),
(951,0,4,'227_KEDD180903TR4','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL,'0.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD180903TR4',''),
(952,0,24,'227_KEDD212070JS8','0','brak_obrazka.jpg',NULL,'26.0200','0.0000','2017-09-25 10:24:04','2017-09-25 10:24:04',NULL,'0.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD212070JS8',''),
(953,0,25,'227_KEDD21207JS8Y','0','brak_obrazka.jpg',NULL,'26.0200','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD21207JS8Y',''),
(954,0,16,'227_KEDD2250TR4__','0','brak_obrazka.jpg',NULL,'26.0200','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD2250TR4__',''),
(955,0,13,'227_KEDD227530JS8','0','brak_obrazka.jpg',NULL,'18.7000','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD227530JS8',''),
(956,0,10,'227_KEDD227530TR4','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD227530TR4',''),
(957,0,24,'227_KEDD230032JS8','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD230032JS8',''),
(958,0,39,'227_KEDD230032TR4','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD230032TR4',''),
(959,0,23,'227_KEDD2327530TR','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD2327530TR',''),
(960,0,18,'227_KEDD233003TR4','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:24:05','2017-09-25 10:24:05',NULL,'0.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD233003TR4',''),
(961,0,8,'227_KEDD235040TR6','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL,'0.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD235040TR6','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (962,0,14,'227_KEDD313060JS8','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL,'0.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD313060JS8',''),
(963,0,16,'227_KEDD422525TR4','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL,'0.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD422525TR4',''),
(964,0,7,'227_KEDD427530TR4','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL,'0.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD427530TR4',''),
(965,0,17,'227_KEDD430032TR4','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:24:06','2017-09-25 10:24:06',NULL,'0.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD430032TR4',''),
(966,0,12,'227_KEDD432535TR4','0','brak_obrazka.jpg',NULL,'18.7000','0.0000','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL,'0.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD432535TR4',''),
(967,0,13,'227_KEDD436041TR6','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL,'0.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD436041TR6',''),
(968,0,1,'227_KEDD460100TR4','0','brak_obrazka.jpg',NULL,'25.2000','0.0000','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL,'0.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD460100TR4',''),
(969,0,12,'227_KEDD490100TR6','0','brak_obrazka.jpg',NULL,'32.5200','0.0000','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL,'0.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD490100TR6',''),
(970,0,18,'227_KEDD525027TR4','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL,'0.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD525027TR4',''),
(971,0,19,'227_KEDD527530TR4','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL,'0.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD527530TR4',''),
(972,0,19,'227_KEDD59090TR4_','0','brak_obrazka.jpg',NULL,'30.8900','0.0000','2017-09-25 10:24:07','2017-09-25 10:24:07',NULL,'0.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD59090TR4_',''),
(973,0,13,'227_KEDD620022TR4','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL,'0.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD620022TR4',''),
(974,0,20,'227_KEDD622525TR4','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL,'0.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD622525TR4',''),
(975,0,13,'227_KEDD625027TR4','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL,'0.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD625027TR4',''),
(976,0,14,'227_KEDD627530TR4','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL,'0.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD627530TR4',''),
(977,0,12,'227_KEDD632535TR4','0','brak_obrazka.jpg',NULL,'18.7000','0.0000','2017-09-25 10:24:08','2017-09-25 10:24:08',NULL,'0.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD632535TR4',''),
(978,0,20,'227_KEDD6350TR6__','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL,'0.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD6350TR6__',''),
(979,0,17,'227_KEDD642546TR6','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD642546TR6',''),
(980,0,35,'227_KEDD690100TR4','0','brak_obrazka.jpg',NULL,'39.8400','0.0000','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL,'0.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD690100TR4',''),
(981,0,17,'227_KEDD710090TR6','0','brak_obrazka.jpg',NULL,'38.2100','0.0000','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL,'0.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD710090TR6','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (982,0,19,'227_KEDD711010TR6','0','brak_obrazka.jpg',NULL,'41.4600','0.0000','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL,'0.8900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD711010TR6',''),
(983,0,7,'227_KEDD713090TR6','0','brak_obrazka.jpg',NULL,'43.0900','0.0000','2017-09-25 10:24:09','2017-09-25 10:24:09',NULL,'0.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD713090TR6',''),
(984,0,8,'227_KEDD720022TR4','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL,'0.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD720022TR4',''),
(985,0,47,'227_KEDD725275TR4','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL,'0.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD725275TR4',''),
(986,0,27,'227_KEDD727530TR4','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL,'0.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD727530TR4',''),
(987,0,8,'227_KEDD730032TR4','0','brak_obrazka.jpg',NULL,'18.7000','0.0000','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL,'0.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD730032TR4',''),
(988,0,11,'227_KEDD732535TR4','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL,'0.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD732535TR4',''),
(989,0,13,'227_KEDD737542TR6','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:24:10','2017-09-25 10:24:10',NULL,'0.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD737542TR6',''),
(990,0,11,'227_KEDD745050TR6','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL,'0.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD745050TR6',''),
(991,0,17,'227_KEDD770100TR4','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL,'0.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD770100TR4',''),
(992,0,15,'227_KEDD810010TR6','0','brak_obrazka.jpg',NULL,'44.7200','0.0000','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL,'0.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD810010TR6',''),
(993,0,18,'227_KEDD811010TR6','0','brak_obrazka.jpg',NULL,'67.4800','0.0000','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL,'1.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD811010TR6',''),
(994,0,16,'227_KEDD812010TR6','0','brak_obrazka.jpg',NULL,'73.1700','0.0000','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL,'1.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD812010TR6',''),
(995,0,12,'227_KEDD812011TR6','0','brak_obrazka.jpg',NULL,'48.7800','0.0000','2017-09-25 10:24:11','2017-09-25 10:24:11',NULL,'1.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD812011TR6',''),
(996,0,7,'227_KEDD822525TR4','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL,'0.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD822525TR4',''),
(997,0,10,'227_KEDD827530TR4','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL,'0.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD827530TR4',''),
(998,0,25,'227_KEDD830032TR4','0','brak_obrazka.jpg',NULL,'21.1400','0.0000','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL,'0.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD830032TR4',''),
(999,0,19,'227_KEDD8300JS87C','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL,'0.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD8300JS87C',''),
(1000,0,15,'227_KEDD8300TR13_','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL,'0.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD8300TR13_',''),
(1001,0,9,'227_KEDD832535TR4','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:24:12','2017-09-25 10:24:12',NULL,'0.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD832535TR4','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1002,0,20,'227_KEDD835040TR6','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL,'0.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD835040TR6',''),
(1003,0,20,'227_KEDD8350JS87C','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL,'0.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD8350JS87C',''),
(1004,0,9,'227_KEDD8350TR13_','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL,'0.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD8350TR13_',''),
(1005,0,18,'227_KEDD837542TR6','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL,'0.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD837542TR6',''),
(1006,0,21,'227_KEDD840045TR6','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:24:13','2017-09-25 10:24:13',NULL,'0.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD840045TR6',''),
(1007,0,7,'227_KEDD845051TR6','0','brak_obrazka.jpg',NULL,'26.0200','0.0000','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL,'0.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD845051TR6',''),
(1008,0,4,'227_KEDD910090TR6','0','brak_obrazka.jpg',NULL,'45.5300','0.0000','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL,'0.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD910090TR6',''),
(1009,0,12,'227_KEDD911019TR6','0','brak_obrazka.jpg',NULL,'49.5900','0.0000','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL,'1.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD911019TR6',''),
(1010,0,18,'227_KEDD911090TR6','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL,'1.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD911090TR6',''),
(1011,0,39,'227_KEDD920022TR4','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL,'0.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD920022TR4',''),
(1012,0,11,'227_KEDD922525TR4','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL,'0.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD922525TR4',''),
(1013,0,6,'227_KEDD925027TR4','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:24:14','2017-09-25 10:24:14',NULL,'0.3200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD925027TR4',''),
(1014,0,20,'227_KEDD927530TR4','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL,'0.4100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD927530TR4',''),
(1015,0,19,'227_KEDD9275JS87C','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL,'0.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD9275JS87C',''),
(1016,0,19,'227_KEDD930032TR4','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL,'0.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD930032TR4',''),
(1017,0,8,'227_KEDD932535TR4','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL,'0.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD932535TR4',''),
(1018,0,50,'227_KEDD935040TR6','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:24:15','2017-09-25 10:24:15',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD935040TR6',''),
(1019,0,20,'227_KEDD940045TR6','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL,'0.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD940045TR6',''),
(1020,0,15,'227_KEDD945051TR6','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL,'0.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD945051TR6',''),
(1021,0,14,'227_KEDD970100TR4','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL,'0.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDD970100TR4','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1022,0,16,'227_KEDQ01980TR13','0','brak_obrazka.jpg',NULL,'47.1500','0.0000','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL,'0.5800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ01980TR13',''),
(1023,0,9,'227_KEDQ020580TR8','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ020580TR8',''),
(1024,0,20,'227_KEDQ020800TR6','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:24:16','2017-09-25 10:24:16',NULL,'0.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ020800TR6',''),
(1025,0,8,'227_KEDQ021700TR6','0','brak_obrazka.jpg',NULL,'58.5400','0.0000','2017-09-25 10:24:17','2017-09-25 10:24:17',NULL,'0.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ021700TR6',''),
(1026,0,7,'227_KEDQ022110TR6','0','brak_obrazka.jpg',NULL,'65.0400','0.0000','2017-09-25 10:24:17','2017-09-25 10:24:17',NULL,'1.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ022110TR6',''),
(1027,0,2,'227_KEDQ022800TR6','0','brak_obrazka.jpg',NULL,'50.4100','0.0000','2017-09-25 10:24:17','2017-09-25 10:24:17',NULL,'1.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ022800TR6',''),
(1028,0,20,'227_KEDQ123580TR6','0','brak_obrazka.jpg',NULL,'55.2800','0.0000','2017-09-25 10:24:17','2017-09-25 10:24:17',NULL,'1.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ123580TR6',''),
(1029,0,19,'227_KEDQ12490TR6_','0','brak_obrazka.jpg',NULL,'73.1700','0.0000','2017-09-25 10:24:17','2017-09-25 10:24:17',NULL,'1.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ12490TR6_',''),
(1030,0,10,'227_KEDQ223105TR1','0','brak_obrazka.jpg',NULL,'61.7900','0.0000','2017-09-25 10:24:17','2017-09-25 10:24:17',NULL,'1.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ223105TR1',''),
(1031,0,17,'227_KEDQ22385TR13','0','brak_obrazka.jpg',NULL,'60.1600','0.0000','2017-09-25 10:24:18','2017-09-25 10:24:18',NULL,'1.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ22385TR13',''),
(1032,0,38,'227_KEDQ225100TR6','0','brak_obrazka.jpg',NULL,'70.7300','0.0000','2017-09-25 10:24:18','2017-09-25 10:24:18',NULL,'1.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ225100TR6',''),
(1033,0,23,'227_KEDQ22580TR6_','0','brak_obrazka.jpg',NULL,'69.1100','0.0000','2017-09-25 10:24:18','2017-09-25 10:24:18',NULL,'1.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ22580TR6_',''),
(1034,0,19,'227_KEDQ226120TR6','0','brak_obrazka.jpg',NULL,'65.8500','0.0000','2017-09-25 10:24:18','2017-09-25 10:24:18',NULL,'1.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ226120TR6',''),
(1035,0,20,'227_KEDQ716800TR6','0','brak_obrazka.jpg',NULL,'34.1500','0.0000','2017-09-25 10:24:18','2017-09-25 10:24:18',NULL,'0.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ716800TR6',''),
(1036,0,19,'227_KEDQ81665075T','0','brak_obrazka.jpg',NULL,'32.5200','0.0000','2017-09-25 10:24:18','2017-09-25 10:24:18',NULL,'0.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ81665075T',''),
(1037,0,22,'227_KEDQ818700TR6','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'0.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ818700TR6',''),
(1038,0,35,'227_KEDQ8188595T6','0','brak_obrazka.jpg',NULL,'50.4100','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'0.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ8188595T6',''),
(1039,0,9,'227_KEDQ820100TR6','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'1.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ820100TR6',''),
(1040,0,15,'227_KEDQ820700TR6','0','brak_obrazka.jpg',NULL,'46.3400','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'0.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ820700TR6',''),
(1041,0,13,'227_KEDQ82080TR13','0','brak_obrazka.jpg',NULL,'46.3400','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'0.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ82080TR13','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1042,0,14,'227_KEDQ822110TR6','0','brak_obrazka.jpg',NULL,'65.0400','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'1.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ822110TR6',''),
(1043,0,4,'227_KEDQ920100TR6','0','brak_obrazka.jpg',NULL,'58.5400','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'1.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ920100TR6',''),
(1044,0,13,'227_KEDQ922110TR6','0','brak_obrazka.jpg',NULL,'59.3500','0.0000','2017-09-25 10:24:19','2017-09-25 10:24:19',NULL,'1.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ922110TR6',''),
(1045,0,13,'227_KEDQ925120TR6','0','brak_obrazka.jpg',NULL,'67.4800','0.0000','2017-09-25 10:24:20','2017-09-25 10:24:20',NULL,'1.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEDQ925120TR6',''),
(1046,0,2,'227_KEL024535KR20','0','brak_obrazka.jpg',NULL,'303.2500','0.0000','2017-09-25 10:24:20','2017-09-25 10:24:20',NULL,'12.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430888','227_KEL024535KR20',''),
(1047,0,2,'227_KEL025535KR20','0','brak_obrazka.jpg',NULL,'312.2000','0.0000','2017-09-25 10:24:20','2017-09-25 10:24:20',NULL,'12.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423927','227_KEL025535KR20',''),
(1048,0,34,'227_KEL317560KR20','0','brak_obrazka.jpg',NULL,'128.4600','0.0000','2017-09-25 10:24:20','2017-09-25 10:24:20',NULL,'6.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294689922','227_KEL317560KR20',''),
(1049,0,32,'227_KEL318560KR20','0','brak_obrazka.jpg',NULL,'151.2200','0.0000','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL,'7.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423491','227_KEL318560KR20',''),
(1050,0,16,'227_KEL418560KR20','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL,'7.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430949','227_KEL418560KR20',''),
(1051,0,8,'227_KEL418580KR23','0','brak_obrazka.jpg',NULL,'164.2300','0.0000','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL,'9.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423682','227_KEL418580KR23',''),
(1052,0,28,'227_KEL419560KR20','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL,'8.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430956','227_KEL419560KR20',''),
(1053,0,11,'227_KEL419565KR23','0','brak_obrazka.jpg',NULL,'135.7700','0.0000','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL,'8.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423828','227_KEL419565KR23',''),
(1054,0,18,'227_KEL420560KR20','0','brak_obrazka.jpg',NULL,'182.1100','0.0000','2017-09-25 10:24:21','2017-09-25 10:24:21',NULL,'9.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430918','227_KEL420560KR20',''),
(1055,0,2,'227_KEL420570KR23','0','brak_obrazka.jpg',NULL,'141.4600','0.0000','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL,'10.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954429899','227_KEL420570KR23',''),
(1056,0,9,'227_KEL518555KR20','0','brak_obrazka.jpg',NULL,'136.5900','0.0000','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL,'8.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954443284','227_KEL518555KR20',''),
(1057,0,50,'227_KEL519545KR20','0','brak_obrazka.jpg',NULL,'134.1500','0.0000','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL,'7.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954422807','227_KEL519545KR20',''),
(1058,0,20,'227_KEL519550KR20','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL,'8.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423071','227_KEL519550KR20',''),
(1059,0,37,'227_KEL519555KR20','0','brak_obrazka.jpg',NULL,'139.8400','0.0000','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL,'8.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423057','227_KEL519555KR20',''),
(1060,0,1,'227_KEL520560KR23','0','brak_obrazka.jpg',NULL,'61.7900','0.0000','2017-09-25 10:24:22','2017-09-25 10:24:22',NULL,'9.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423835','227_KEL520560KR23',''),
(1061,0,2,'227_KEL618555KR32','0','brak_obrazka.jpg',NULL,'139.8400','0.0000','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL,'8.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685016','227_KEL618555KR32','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1062,0,41,'227_KEL619545KR20','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL,'8.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423200','227_KEL619545KR20',''),
(1063,0,14,'227_KEL619555KR20','0','brak_obrazka.jpg',NULL,'147.9700','0.0000','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL,'9.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423217','227_KEL619555KR20',''),
(1064,0,20,'227_KEL620545KR20','0','brak_obrazka.jpg',NULL,'152.8500','0.0000','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL,'8.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423224','227_KEL620545KR20',''),
(1065,0,6,'227_KEL620550KR20','0','brak_obrazka.jpg',NULL,'165.8500','0.0000','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL,'9.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423156','227_KEL620550KR20',''),
(1066,0,18,'227_KEL620555KR20','0','brak_obrazka.jpg',NULL,'167.4800','0.0000','2017-09-25 10:24:23','2017-09-25 10:24:23',NULL,'9.8900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423064','227_KEL620555KR20',''),
(1067,0,4,'227_KEL620555KR2Z','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL,'9.8900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEL620555KR2Z',''),
(1068,0,17,'227_KEL621555KR20','0','brak_obrazka.jpg',NULL,'182.1100','0.0000','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL,'10.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423088','227_KEL621555KR20',''),
(1069,0,42,'227_KEL622555KR20','0','brak_obrazka.jpg',NULL,'199.1900','0.0000','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL,'12.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423095','227_KEL622555KR20',''),
(1070,0,42,'227_KEL720540KR2Z','0','brak_obrazka.jpg',NULL,'159.3500','0.0000','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL,'8.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423903','227_KEL720540KR2Z',''),
(1071,0,1,'227_KEL720545KR20','0','brak_obrazka.jpg',NULL,'173.9800','0.0000','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL,'9.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423811','227_KEL720545KR20',''),
(1072,0,32,'227_KEL720550KR20','0','brak_obrazka.jpg',NULL,'181.3000','0.0000','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL,'9.8900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423187','227_KEL720550KR20',''),
(1073,0,13,'227_KEL721545KR20','0','brak_obrazka.jpg',NULL,'182.9300','0.0000','2017-09-25 10:24:24','2017-09-25 10:24:24',NULL,'9.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424122','227_KEL721545KR20',''),
(1074,0,3,'227_KEL721550KR20','0','brak_obrazka.jpg',NULL,'196.7500','0.0000','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL,'10.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423804','227_KEL721550KR20',''),
(1075,0,18,'227_KEL721555KR20','0','brak_obrazka.jpg',NULL,'213.8200','0.0000','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL,'11.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430932','227_KEL721555KR20',''),
(1076,0,21,'227_KEL722550KR20','0','brak_obrazka.jpg',NULL,'199.1900','0.0000','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL,'12.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423507','227_KEL722550KR20',''),
(1077,0,15,'227_KEL723545KR20','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL,'11.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423590','227_KEL723545KR20',''),
(1078,0,4,'227_KEL724540KR20','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL,'11.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423613','227_KEL724540KR20',''),
(1079,0,17,'227_KEL724545KR20','0','brak_obrazka.jpg',NULL,'208.9400','0.0000','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL,'12.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423606','227_KEL724545KR20',''),
(1080,0,1,'227_KEL822540KR20','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:24:25','2017-09-25 10:24:25',NULL,'9.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424047','227_KEL822540KR20',''),
(1081,0,10,'227_KEL822545KR20','0','brak_obrazka.jpg',NULL,'228.4600','0.0000','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL,'11.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424009','227_KEL822545KR20','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1082,0,4,'227_KEL823540KR20','0','brak_obrazka.jpg',NULL,'202.4400','0.0000','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL,'11.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423972','227_KEL823540KR20',''),
(1083,0,3,'227_KEL824540KR20','0','brak_obrazka.jpg',NULL,'223.5800','0.0000','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL,'12.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954429769','227_KEL824540KR20',''),
(1084,0,6,'227_KEL824540KR2Z','0','brak_obrazka.jpg',NULL,'248.7800','0.0000','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL,'12.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423910','227_KEL824540KR2Z',''),
(1085,0,7,'227_KEL824545KR20','0','brak_obrazka.jpg',NULL,'252.0300','0.0000','2017-09-25 10:24:26','2017-09-25 10:24:26',NULL,'12.9100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423934','227_KEL824545KR20',''),
(1086,0,4,'227_KEL826535KR20','0','brak_obrazka.jpg',NULL,'267.4800','0.0000','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL,'12.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424153','227_KEL826535KR20',''),
(1087,0,6,'227_KEL921535KR20','0','brak_obrazka.jpg',NULL,'290.2400','0.0000','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL,'9.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430482','227_KEL921535KR20',''),
(1088,0,6,'227_KEL922535KR20','0','brak_obrazka.jpg',NULL,'298.3700','0.0000','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL,'9.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424054','227_KEL922535KR20',''),
(1089,0,2,'227_KEL923535KR20','0','brak_obrazka.jpg',NULL,'247.1500','0.0000','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL,'11.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423484','227_KEL923535KR20',''),
(1090,0,2,'227_KEL924535KR20','0','brak_obrazka.jpg',NULL,'286.9900','0.0000','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL,'11.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430055','227_KEL924535KR20',''),
(1091,0,6,'227_KEL926530KR20','0','brak_obrazka.jpg',NULL,'321.9500','0.0000','2017-09-25 10:24:27','2017-09-25 10:24:27',NULL,'12.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294990240','227_KEL926530KR20',''),
(1092,0,10,'227_KEM0250K785FR','0','brak_obrazka.jpg',NULL,'72.3600','0.0000','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL,'1.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982405','227_KEM0250K785FR',''),
(1093,0,10,'227_KEM0275K78538','0','brak_obrazka.jpg',NULL,'65.0400','0.0000','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL,'1.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294687737','227_KEM0275K78538',''),
(1094,0,1,'227_KEM080100K786','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL,'1.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992039','227_KEM080100K786',''),
(1095,0,20,'227_KEM1275K262__','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL,'2.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEM1275K262__',''),
(1096,0,10,'227_KEM1275K28045','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:24:28','2017-09-25 10:24:28',NULL,'2.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427260','227_KEM1275K28045',''),
(1097,0,8,'227_KEM1300K27051','0','brak_obrazka.jpg',NULL,'99.1900','0.0000','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL,'3.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433995','227_KEM1300K27051',''),
(1098,0,7,'227_KEM1300K28051','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL,'3.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427284','227_KEM1300K28051',''),
(1099,0,6,'227_KEM1325K27057','0','brak_obrazka.jpg',NULL,'100.8100','0.0000','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL,'3.9500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954434008','227_KEM1325K27057',''),
(1100,0,6,'227_KEM180100K775','0','brak_obrazka.jpg',NULL,'160.9800','0.0000','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL,'4.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992176','227_KEM180100K775',''),
(1101,0,9,'227_KEM180100K780','0','brak_obrazka.jpg',NULL,'139.0200','0.0000','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL,'3.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954434060','227_KEM180100K780','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1102,0,9,'227_KEM180100K781','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:24:29','2017-09-25 10:24:29',NULL,'4.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425532','227_KEM180100K781',''),
(1103,0,7,'227_KEM180100K785','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL,'3.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982153','227_KEM180100K785',''),
(1104,0,6,'227_KEM18090K673F','0','brak_obrazka.jpg',NULL,'165.8500','0.0000','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL,'4.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989336','227_KEM18090K673F',''),
(1105,0,3,'227_KEM18090K774P','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL,'3.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989763','227_KEM18090K774P',''),
(1106,0,5,'227_KEM190100K657','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL,'4.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427307','227_KEM190100K657',''),
(1107,0,8,'227_KEM190100K775','0','brak_obrazka.jpg',NULL,'177.2400','0.0000','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL,'4.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992169','227_KEM190100K775',''),
(1108,0,7,'227_KEM190100K785','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:24:30','2017-09-25 10:24:30',NULL,'3.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982726','227_KEM190100K785',''),
(1109,0,19,'227_KEM19090K2705','0','brak_obrazka.jpg',NULL,'95.9300','0.0000','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL,'3.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954434022','227_KEM19090K2705',''),
(1110,0,18,'227_KEM19090K7611','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL,'4.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEM19090K7611',''),
(1111,0,7,'227_KEM19090K776F','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL,'4.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425167','227_KEM19090K776F',''),
(1112,0,7,'227_KEM19090K777F','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL,'4.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425525','227_KEM19090K777F',''),
(1113,0,8,'227_KEM19090K781F','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL,'3.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954434053','227_KEM19090K781F',''),
(1114,0,8,'227_KEM19090K784F','0','brak_obrazka.jpg',NULL,'195.9300','0.0000','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL,'4.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438112','227_KEM19090K784F',''),
(1115,0,20,'227_KEM280100K785','0','brak_obrazka.jpg',NULL,'91.8700','0.0000','2017-09-25 10:24:31','2017-09-25 10:24:31',NULL,'2.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982535','227_KEM280100K785',''),
(1116,0,20,'227_KEM280100K786','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL,'2.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982542','227_KEM280100K786',''),
(1117,0,19,'227_KEM411080K425','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL,'3.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680523','227_KEM411080K425',''),
(1118,0,3,'227_KEM418080K761','0','brak_obrazka.jpg',NULL,'224.3900','0.0000','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL,'8.2100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432943','227_KEM418080K761',''),
(1119,0,14,'227_KEM4275K272__','0','brak_obrazka.jpg',NULL,'57.7200','0.0000','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL,'2.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997157','227_KEM4275K272__',''),
(1120,0,9,'227_KEM4300K262__','0','brak_obrazka.jpg',NULL,'79.6700','0.0000','2017-09-25 10:24:32','2017-09-25 10:24:32',NULL,'2.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997164','227_KEM4300K262__',''),
(1121,0,8,'227_KEM460100K785','0','brak_obrazka.jpg',NULL,'86.1800','0.0000','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL,'1.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982573','227_KEM460100K785','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1122,0,6,'227_KEM513090K657','0','brak_obrazka.jpg',NULL,'199.1900','0.0000','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL,'6.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982597','227_KEM513090K657',''),
(1123,0,10,'227_KEM513090K671','0','brak_obrazka.jpg',NULL,'216.2600','0.0000','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL,'6.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294689090','227_KEM513090K671',''),
(1124,0,4,'227_KEM514090K673','0','brak_obrazka.jpg',NULL,'298.3700','0.0000','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL,'8.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424764','227_KEM514090K673',''),
(1125,0,3,'227_KEM515090K673','0','brak_obrazka.jpg',NULL,'350.4100','0.0000','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL,'9.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424771','227_KEM515090K673',''),
(1126,0,1,'227_KEM517080K671','0','brak_obrazka.jpg',NULL,'307.3200','0.0000','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL,'8.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426645','227_KEM517080K671',''),
(1127,0,8,'227_KEM517080K673','0','brak_obrazka.jpg',NULL,'339.0200','0.0000','2017-09-25 10:24:33','2017-09-25 10:24:33',NULL,'9.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426614','227_KEM517080K673',''),
(1128,0,20,'227_KEM610080K328','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL,'3.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954447015','227_KEM610080K328',''),
(1129,0,18,'227_KEM610080K425','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL,'3.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954447008','227_KEM610080K425',''),
(1130,0,9,'227_KEM610090K671','0','brak_obrazka.jpg',NULL,'147.9700','0.0000','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL,'4.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426669','227_KEM610090K671',''),
(1131,0,13,'227_KEM610090K761','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL,'3.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433094','227_KEM610090K761',''),
(1132,0,18,'227_KEM611070K671','0','brak_obrazka.jpg',NULL,'134.9600','0.0000','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL,'3.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954446117','227_KEM611070K671',''),
(1133,0,2,'227_KEM611090K328','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:24:34','2017-09-25 10:24:34',NULL,'4.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997201','227_KEM611090K328',''),
(1134,0,10,'227_KEM612080K676','0','brak_obrazka.jpg',NULL,'231.7100','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'4.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989282','227_KEM612080K676',''),
(1135,0,20,'227_KEM612090K657','0','brak_obrazka.jpg',NULL,'178.8600','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'5.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438587','227_KEM612090K657',''),
(1136,0,8,'227_KEM613070K671','0','brak_obrazka.jpg',NULL,'188.6200','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'5.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433148','227_KEM613070K671',''),
(1137,0,7,'227_KEM613090K657','0','brak_obrazka.jpg',NULL,'217.8900','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'6.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426782','227_KEM613090K657',''),
(1138,0,10,'227_KEM613090K65R','0','brak_obrazka.jpg',NULL,'215.4500','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'6.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEM613090K65R',''),
(1139,0,6,'227_KEM613090K671','0','brak_obrazka.jpg',NULL,'224.3900','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'6.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426720','227_KEM613090K671',''),
(1140,0,5,'227_KEM613090K673','0','brak_obrazka.jpg',NULL,'269.1100','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'8.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426744','227_KEM613090K673',''),
(1141,0,10,'227_KEM613090K676','0','brak_obrazka.jpg',NULL,'263.4100','0.0000','2017-09-25 10:24:35','2017-09-25 10:24:35',NULL,'7.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989138','227_KEM613090K676','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1142,0,4,'227_KEM61309K673F','0','brak_obrazka.jpg',NULL,'270.7300','0.0000','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL,'7.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426737','227_KEM61309K673F',''),
(1143,0,9,'227_KEM614070K671','0','brak_obrazka.jpg',NULL,'169.1100','0.0000','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL,'5.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433476','227_KEM614070K671',''),
(1144,0,10,'227_KEM614090K657','0','brak_obrazka.jpg',NULL,'236.5900','0.0000','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL,'7.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426805','227_KEM614090K657',''),
(1145,0,10,'227_KEM614090K673','0','brak_obrazka.jpg',NULL,'357.7200','0.0000','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL,'9.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426713','227_KEM614090K673',''),
(1146,0,7,'227_KEM615080K657','0','brak_obrazka.jpg',NULL,'263.4100','0.0000','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL,'7.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989152','227_KEM615080K657',''),
(1147,0,2,'227_KEM615080K673','0','brak_obrazka.jpg',NULL,'230.8900','0.0000','2017-09-25 10:24:36','2017-09-25 10:24:36',NULL,'7.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992107','227_KEM615080K673',''),
(1148,0,6,'227_KEM615080K676','0','brak_obrazka.jpg',NULL,'315.4500','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'7.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989145','227_KEM615080K676',''),
(1149,0,10,'227_KEM6300K20411','0','brak_obrazka.jpg',NULL,'56.9100','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'2.5800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433117','227_KEM6300K20411',''),
(1150,0,9,'227_KEM6300K255__','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'2.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997218','227_KEM6300K255__',''),
(1151,0,13,'227_KEM6300K262__','0','brak_obrazka.jpg',NULL,'87.8000','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'2.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426706','227_KEM6300K262__',''),
(1152,0,22,'227_KEM6325K2554P','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'3.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989121','227_KEM6325K2554P',''),
(1153,0,23,'227_KEM6350K2734P','0','brak_obrazka.jpg',NULL,'100.0000','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'2.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEM6350K2734P',''),
(1154,0,20,'227_KEM67090K425_','0','brak_obrazka.jpg',NULL,'79.6700','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'2.2100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954447039','227_KEM67090K425_',''),
(1155,0,20,'227_KEM68080K425_','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:24:37','2017-09-25 10:24:37',NULL,'2.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680530','227_KEM68080K425_',''),
(1156,0,12,'227_KEM68080K4251','0','brak_obrazka.jpg',NULL,'91.8700','0.0000','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL,'2.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997171','227_KEM68080K4251',''),
(1157,0,12,'227_KEM690100K785','0','brak_obrazka.jpg',NULL,'117.0700','0.0000','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL,'3.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294687744','227_KEM690100K785',''),
(1158,0,9,'227_KEM690100K786','0','brak_obrazka.jpg',NULL,'139.8400','0.0000','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL,'3.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982139','227_KEM690100K786',''),
(1159,0,16,'227_KEM69080K425_','0','brak_obrazka.jpg',NULL,'91.8700','0.0000','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL,'2.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997188','227_KEM69080K425_',''),
(1160,0,18,'227_KEM69080K4251','0','brak_obrazka.jpg',NULL,'94.3100','0.0000','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL,'2.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997195','227_KEM69080K4251',''),
(1161,0,20,'227_KEM710080K492','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL,'3.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997119','227_KEM710080K492','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1162,0,50,'227_KEM710080K674','0','brak_obrazka.jpg',NULL,'108.1300','0.0000','2017-09-25 10:24:38','2017-09-25 10:24:38',NULL,'4.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEM710080K674',''),
(1163,0,8,'227_KEM710080K701','0','brak_obrazka.jpg',NULL,'121.9500','0.0000','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL,'3.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684644','227_KEM710080K701',''),
(1164,0,12,'227_KEM711070K671','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL,'4.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426874','227_KEM711070K671',''),
(1165,0,8,'227_KEM711070K674','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL,'3.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989190','227_KEM711070K674',''),
(1166,0,10,'227_KEM711070K676','0','brak_obrazka.jpg',NULL,'224.3900','0.0000','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL,'3.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997102','227_KEM711070K676',''),
(1167,0,36,'227_KEM711070K701','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL,'3.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684651','227_KEM711070K701',''),
(1168,0,50,'227_KEM711070K711','0','brak_obrazka.jpg',NULL,'122.7600','0.0000','2017-09-25 10:24:39','2017-09-25 10:24:39',NULL,'4.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992282','227_KEM711070K711',''),
(1169,0,18,'227_KEM711080K328','0','brak_obrazka.jpg',NULL,'147.1500','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'4.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997270','227_KEM711080K328',''),
(1170,0,9,'227_KEM711080K671','0','brak_obrazka.jpg',NULL,'189.4300','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'4.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989053','227_KEM711080K671',''),
(1171,0,8,'227_KEM711080K676','0','brak_obrazka.jpg',NULL,'225.2000','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'4.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989213','227_KEM711080K676',''),
(1172,0,20,'227_KEM71108K3281','0','brak_obrazka.jpg',NULL,'167.4800','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'4.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997263','227_KEM71108K3281',''),
(1173,0,20,'227_KEM712080K711','0','brak_obrazka.jpg',NULL,'178.8600','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'5.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEM712080K711',''),
(1174,0,13,'227_KEM712090K673','0','brak_obrazka.jpg',NULL,'243.9000','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'6.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989183','227_KEM712090K673',''),
(1175,0,12,'227_KEM712090K761','0','brak_obrazka.jpg',NULL,'171.5400','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'5.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426881','227_KEM712090K761',''),
(1176,0,4,'227_KEM713070K671','0','brak_obrazka.jpg',NULL,'197.5600','0.0000','2017-09-25 10:24:40','2017-09-25 10:24:40',NULL,'5.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294981941','227_KEM713070K671',''),
(1177,0,30,'227_KEM713070K674','0','brak_obrazka.jpg',NULL,'169.9200','0.0000','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL,'5.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294987127','227_KEM713070K674',''),
(1178,0,10,'227_KEM713070K676','0','brak_obrazka.jpg',NULL,'271.5400','0.0000','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL,'5.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997096','227_KEM713070K676',''),
(1179,0,27,'227_KEM713070K701','0','brak_obrazka.jpg',NULL,'152.8500','0.0000','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684668','227_KEM713070K701',''),
(1180,0,50,'227_KEM713070K711','0','brak_obrazka.jpg',NULL,'172.3600','0.0000','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL,'5.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992329','227_KEM713070K711',''),
(1181,0,5,'227_KEM713080K280','0','brak_obrazka.jpg',NULL,'158.5400','0.0000','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL,'5.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426973','227_KEM713080K280','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1182,0,12,'227_KEM713080K672','0','brak_obrazka.jpg',NULL,'122.7600','0.0000','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL,'5.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433391','227_KEM713080K672',''),
(1183,0,4,'227_KEM713080K701','0','brak_obrazka.jpg',NULL,'205.6900','0.0000','2017-09-25 10:24:41','2017-09-25 10:24:41',NULL,'3.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426942','227_KEM713080K701',''),
(1184,0,4,'227_KEM713080K784','0','brak_obrazka.jpg',NULL,'248.7800','0.0000','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL,'6.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438082','227_KEM713080K784',''),
(1185,0,8,'227_KEM713090K657','0','brak_obrazka.jpg',NULL,'219.5100','0.0000','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL,'6.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982627','227_KEM713090K657',''),
(1186,0,15,'227_KEM713090K760','0','brak_obrazka.jpg',NULL,'197.5600','0.0000','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL,'5.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982634','227_KEM713090K760',''),
(1187,0,18,'227_KEM714060K671','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL,'5.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294689199','227_KEM714060K671',''),
(1188,0,7,'227_KEM714070K671','0','brak_obrazka.jpg',NULL,'190.2400','0.0000','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL,'5.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294689885','227_KEM714070K671',''),
(1189,0,9,'227_KEM714070K674','0','brak_obrazka.jpg',NULL,'190.2400','0.0000','2017-09-25 10:24:42','2017-09-25 10:24:42',NULL,'5.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989206','227_KEM714070K674',''),
(1190,0,50,'227_KEM714070K711','0','brak_obrazka.jpg',NULL,'187.8000','0.0000','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL,'5.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992299','227_KEM714070K711',''),
(1191,0,8,'227_KEM714080K676','0','brak_obrazka.jpg',NULL,'317.8900','0.0000','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL,'7.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989244','227_KEM714080K676',''),
(1192,0,13,'227_KEM715070K671','0','brak_obrazka.jpg',NULL,'232.5200','0.0000','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL,'6.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989237','227_KEM715070K671',''),
(1193,0,10,'227_KEM715070K676','0','brak_obrazka.jpg',NULL,'327.6400','0.0000','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL,'7.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989251','227_KEM715070K676',''),
(1194,0,3,'227_KEM715070K784','0','brak_obrazka.jpg',NULL,'308.9400','0.0000','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL,'7.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438075','227_KEM715070K784',''),
(1195,0,20,'227_KEM716060K671','0','brak_obrazka.jpg',NULL,'217.8900','0.0000','2017-09-25 10:24:43','2017-09-25 10:24:43',NULL,'5.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997287','227_KEM716060K671',''),
(1196,0,9,'227_KEM717060K784','0','brak_obrazka.jpg',NULL,'334.1500','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'8.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989749','227_KEM717060K784',''),
(1197,0,9,'227_KEM7250K252__','0','brak_obrazka.jpg',NULL,'52.8500','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'1.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997232','227_KEM7250K252__',''),
(1198,0,13,'227_KEM7250K262__','0','brak_obrazka.jpg',NULL,'60.1600','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'2.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294687294','227_KEM7250K262__',''),
(1199,0,14,'227_KEM7250K273__','0','brak_obrazka.jpg',NULL,'58.5400','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'2.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997225','227_KEM7250K273__',''),
(1200,0,18,'227_KEM7275K254__','0','brak_obrazka.jpg',NULL,'72.3600','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'2.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997249','227_KEM7275K254__',''),
(1201,0,4,'227_KEM7275K262__','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'2.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424849','227_KEM7275K262__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1202,0,6,'227_KEM7275K265__','0','brak_obrazka.jpg',NULL,'71.5400','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'2.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997065','227_KEM7275K265__',''),
(1203,0,20,'227_KEM7275K422__','0','brak_obrazka.jpg',NULL,'87.8000','0.0000','2017-09-25 10:24:44','2017-09-25 10:24:44',NULL,'2.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294986502','227_KEM7275K422__',''),
(1204,0,12,'227_KEM7275K657F1','0','brak_obrazka.jpg',NULL,'71.5400','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'2.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEM7275K657F1',''),
(1205,0,20,'227_KEM7275K764F_','0','brak_obrazka.jpg',NULL,'103.2500','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'3.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997256','227_KEM7275K764F_',''),
(1206,0,14,'227_KEM7300K25511','0','brak_obrazka.jpg',NULL,'65.8500','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'2.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433254','227_KEM7300K25511',''),
(1207,0,14,'227_KEM7300K262__','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426867','227_KEM7300K262__',''),
(1208,0,14,'227_KEM7300K272__','0','brak_obrazka.jpg',NULL,'77.2400','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'2.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954446643','227_KEM7300K272__',''),
(1209,0,20,'227_KEM7325K764__','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'3.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997072','227_KEM7325K764__',''),
(1210,0,11,'227_KEM7350K27311','0','brak_obrazka.jpg',NULL,'86.9900','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'3.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438617','227_KEM7350K27311',''),
(1211,0,20,'227_KEM7350K764__','0','brak_obrazka.jpg',NULL,'135.7700','0.0000','2017-09-25 10:24:45','2017-09-25 10:24:45',NULL,'4.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997089','227_KEM7350K764__',''),
(1212,0,22,'227_KEM7460K2704P','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL,'4.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433322','227_KEM7460K2704P',''),
(1213,0,8,'227_KEM7460K28061','0','brak_obrazka.jpg',NULL,'134.9600','0.0000','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL,'4.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954445776','227_KEM7460K28061',''),
(1214,0,7,'227_KEM7510K27061','0','brak_obrazka.jpg',NULL,'175.6100','0.0000','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL,'6.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989732','227_KEM7510K27061',''),
(1215,0,16,'227_KEM78090K4881','0','brak_obrazka.jpg',NULL,'100.0000','0.0000','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL,'3.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989169','227_KEM78090K4881',''),
(1216,0,10,'227_KEM8100100K78','0','brak_obrazka.jpg',NULL,'160.1600','0.0000','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL,'5.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433742','227_KEM8100100K78',''),
(1217,0,14,'227_KEM810090K657','0','brak_obrazka.jpg',NULL,'154.4700','0.0000','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL,'4.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426959','227_KEM810090K657',''),
(1218,0,9,'227_KEM810090K676','0','brak_obrazka.jpg',NULL,'231.7100','0.0000','2017-09-25 10:24:46','2017-09-25 10:24:46',NULL,'4.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984348','227_KEM810090K676',''),
(1219,0,12,'227_KEM8110100K71','0','brak_obrazka.jpg',NULL,'185.3700','0.0000','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL,'5.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433650','227_KEM8110100K71',''),
(1220,0,5,'227_KEM8110100K72','0','brak_obrazka.jpg',NULL,'158.5400','0.0000','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL,'5.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438624','227_KEM8110100K72',''),
(1221,0,10,'227_KEM8110100K76','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL,'5.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982641','227_KEM8110100K76','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1222,0,9,'227_KEM8110100K78','0','brak_obrazka.jpg',NULL,'181.3000','0.0000','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL,'5.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433667','227_KEM8110100K78',''),
(1223,0,18,'227_KEM811080K761','0','brak_obrazka.jpg',NULL,'171.5400','0.0000','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL,'5.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427116','227_KEM811080K761',''),
(1224,0,1,'227_KEM811080K774','0','brak_obrazka.jpg',NULL,'169.9200','0.0000','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL,'4.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433674','227_KEM811080K774',''),
(1225,0,3,'227_KEM811090K657','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:24:47','2017-09-25 10:24:47',NULL,'5.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426980','227_KEM811090K657',''),
(1226,0,13,'227_KEM811090K673','0','brak_obrazka.jpg',NULL,'191.0600','0.0000','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL,'4.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426898','227_KEM811090K673',''),
(1227,0,9,'227_KEM811090K676','0','brak_obrazka.jpg',NULL,'249.5900','0.0000','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL,'5.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989220','227_KEM811090K676',''),
(1228,0,10,'227_KEM8120100K76','0','brak_obrazka.jpg',NULL,'226.8300','0.0000','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL,'6.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992114','227_KEM8120100K76',''),
(1229,0,3,'227_KEM8120100K78','0','brak_obrazka.jpg',NULL,'178.0500','0.0000','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL,'5.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438662','227_KEM8120100K78',''),
(1230,0,11,'227_KEM812080K761','0','brak_obrazka.jpg',NULL,'183.7400','0.0000','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL,'5.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427147','227_KEM812080K761',''),
(1231,0,8,'227_KEM812090K657','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL,'6.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427079','227_KEM812090K657',''),
(1232,0,10,'227_KEM812090K673','0','brak_obrazka.jpg',NULL,'240.6500','0.0000','2017-09-25 10:24:48','2017-09-25 10:24:48',NULL,'6.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426409','227_KEM812090K673',''),
(1233,0,9,'227_KEM812090K676','0','brak_obrazka.jpg',NULL,'265.8500','0.0000','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL,'7.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989305','227_KEM812090K676',''),
(1234,0,5,'227_KEM812090K778','0','brak_obrazka.jpg',NULL,'178.8600','0.0000','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL,'5.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424955','227_KEM812090K778',''),
(1235,0,10,'227_KEM813070K671','0','brak_obrazka.jpg',NULL,'208.9400','0.0000','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL,'5.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294981958','227_KEM813070K671',''),
(1236,0,13,'227_KEM813070K673','0','brak_obrazka.jpg',NULL,'280.4900','0.0000','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL,'6.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989268','227_KEM813070K673',''),
(1237,0,10,'227_KEM813080K676','0','brak_obrazka.jpg',NULL,'273.1700','0.0000','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL,'7.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989299','227_KEM813080K676',''),
(1238,0,20,'227_KEM813080K677','0','brak_obrazka.jpg',NULL,'198.3700','0.0000','2017-09-25 10:24:49','2017-09-25 10:24:49',NULL,'6.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997324','227_KEM813080K677',''),
(1239,0,8,'227_KEM813080K761','0','brak_obrazka.jpg',NULL,'194.3100','0.0000','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL,'5.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433612','227_KEM813080K761',''),
(1240,0,6,'227_KEM813080K779','0','brak_obrazka.jpg',NULL,'182.1100','0.0000','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL,'5.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433629','227_KEM813080K779',''),
(1241,0,7,'227_KEM813090K657','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL,'7.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427086','227_KEM813090K657','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1242,0,22,'227_KEM814070K671','0','brak_obrazka.jpg',NULL,'221.9500','0.0000','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL,'6.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982665','227_KEM814070K671',''),
(1243,0,5,'227_KEM814080K778','0','brak_obrazka.jpg',NULL,'194.3100','0.0000','2017-09-25 10:24:50','2017-09-25 10:24:50',NULL,'5.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424535','227_KEM814080K778',''),
(1244,0,9,'227_KEM814080K779','0','brak_obrazka.jpg',NULL,'214.6300','0.0000','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL,'5.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424962','227_KEM814080K779',''),
(1245,0,6,'227_KEM814080K784','0','brak_obrazka.jpg',NULL,'268.2900','0.0000','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL,'6.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438105','227_KEM814080K784',''),
(1246,0,8,'227_KEM815070K784','0','brak_obrazka.jpg',NULL,'291.8700','0.0000','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL,'7.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438099','227_KEM815070K784',''),
(1247,0,11,'227_KEM8275K254__','0','brak_obrazka.jpg',NULL,'72.3600','0.0000','2017-09-25 10:24:51','2017-09-25 10:24:51',NULL,'2.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997126','227_KEM8275K254__',''),
(1248,0,19,'227_KEM8275K764F_','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL,'3.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294688697','227_KEM8275K764F_',''),
(1249,0,8,'227_KEM8300K262__','0','brak_obrazka.jpg',NULL,'91.0600','0.0000','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL,'3.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427024','227_KEM8300K262__',''),
(1250,0,17,'227_KEM8300K27311','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL,'2.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433483','227_KEM8300K27311',''),
(1251,0,15,'227_KEM8350K262__','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:24:52','2017-09-25 10:24:52',NULL,'3.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427031','227_KEM8350K262__',''),
(1252,0,18,'227_KEM8350K26511','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:24:53','2017-09-25 10:24:53',NULL,'3.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433506','227_KEM8350K26511',''),
(1253,0,26,'227_KEM8350K27056','0','brak_obrazka.jpg',NULL,'108.1300','0.0000','2017-09-25 10:24:53','2017-09-25 10:24:53',NULL,'3.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427048','227_KEM8350K27056',''),
(1254,0,14,'227_KEM8350K28056','0','brak_obrazka.jpg',NULL,'118.7000','0.0000','2017-09-25 10:24:54','2017-09-25 10:24:54',NULL,'3.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427055','227_KEM8350K28056',''),
(1255,0,40,'227_KEM8410K27058','0','brak_obrazka.jpg',NULL,'116.2600','0.0000','2017-09-25 10:24:55','2017-09-25 10:24:55',NULL,'4.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424870','227_KEM8410K27058',''),
(1256,0,18,'227_KEM8410K28058','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:24:56','2017-09-25 10:24:56',NULL,'4.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427093','227_KEM8410K28058',''),
(1257,0,20,'227_KEM8460K280__','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:24:56','2017-09-25 10:24:56',NULL,'4.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997133','227_KEM8460K280__',''),
(1258,0,20,'227_KEM8510K27073','0','brak_obrazka.jpg',NULL,'177.2400','0.0000','2017-09-25 10:24:56','2017-09-25 10:24:56',NULL,'6.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433803','227_KEM8510K27073',''),
(1259,0,17,'227_KEM87090K4881','0','brak_obrazka.jpg',NULL,'84.5500','0.0000','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL,'2.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989176','227_KEM87090K4881',''),
(1260,0,9,'227_KEM89090K265_','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL,'3.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997317','227_KEM89090K265_',''),
(1261,0,7,'227_KEM89090K3281','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL,'3.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433414','227_KEM89090K3281','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1262,0,10,'227_KEM89090K671F','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL,'3.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984133','227_KEM89090K671F',''),
(1263,0,11,'227_KEM89090K7632','0','brak_obrazka.jpg',NULL,'98.3700','0.0000','2017-09-25 10:24:57','2017-09-25 10:24:57',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433407','227_KEM89090K7632',''),
(1264,0,12,'227_KEM910090K657','0','brak_obrazka.jpg',NULL,'159.3500','0.0000','2017-09-25 10:24:58','2017-09-25 10:24:58',NULL,'4.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989312','227_KEM910090K657',''),
(1265,0,34,'227_KEM910090K671','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:24:58','2017-09-25 10:24:58',NULL,'4.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427192','227_KEM910090K671',''),
(1266,0,2,'227_KEM910090K673','0','brak_obrazka.jpg',NULL,'207.3200','0.0000','2017-09-25 10:24:58','2017-09-25 10:24:58',NULL,'4.8300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427208','227_KEM910090K673',''),
(1267,0,6,'227_KEM910090K676','0','brak_obrazka.jpg',NULL,'233.3300','0.0000','2017-09-25 10:24:59','2017-09-25 10:24:59',NULL,'4.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989329','227_KEM910090K676',''),
(1268,0,6,'227_KEM910090K677','0','brak_obrazka.jpg',NULL,'156.9100','0.0000','2017-09-25 10:24:59','2017-09-25 10:24:59',NULL,'4.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997355','227_KEM910090K677',''),
(1269,0,2,'227_KEM910090K761','0','brak_obrazka.jpg',NULL,'158.5400','0.0000','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL,'5.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425013','227_KEM910090K761',''),
(1270,0,9,'227_KEM910090K780','0','brak_obrazka.jpg',NULL,'180.4900','0.0000','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL,'5.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433902','227_KEM910090K780',''),
(1271,0,10,'227_KEM910090K781','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL,'5.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992152','227_KEM910090K781',''),
(1272,0,6,'227_KEM910090K782','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:25:00','2017-09-25 10:25:00',NULL,'4.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425501','227_KEM910090K782',''),
(1273,0,7,'227_KEM910090K784','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:25:01','2017-09-25 10:25:01',NULL,'4.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438723','227_KEM910090K784',''),
(1274,0,6,'227_KEM910090K785','0','brak_obrazka.jpg',NULL,'162.6000','0.0000','2017-09-25 10:25:01','2017-09-25 10:25:01',NULL,'5.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438686','227_KEM910090K785',''),
(1275,0,10,'227_KEM910090K786','0','brak_obrazka.jpg',NULL,'200.0000','0.0000','2017-09-25 10:25:02','2017-09-25 10:25:02',NULL,'5.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685788','227_KEM910090K786',''),
(1276,0,7,'227_KEM911080K781','0','brak_obrazka.jpg',NULL,'175.6100','0.0000','2017-09-25 10:25:02','2017-09-25 10:25:02',NULL,'5.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425518','227_KEM911080K781',''),
(1277,0,7,'227_KEM911080K784','0','brak_obrazka.jpg',NULL,'219.5100','0.0000','2017-09-25 10:25:02','2017-09-25 10:25:02',NULL,'5.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438754','227_KEM911080K784',''),
(1278,0,10,'227_KEM911080K785','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:25:03','2017-09-25 10:25:03',NULL,'5.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438693','227_KEM911080K785',''),
(1279,0,10,'227_KEM911080K786','0','brak_obrazka.jpg',NULL,'191.8700','0.0000','2017-09-25 10:25:03','2017-09-25 10:25:03',NULL,'5.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992145','227_KEM911080K786',''),
(1280,0,20,'227_KEM911090K657','0','brak_obrazka.jpg',NULL,'175.6100','0.0000','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL,'5.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427215','227_KEM911090K657',''),
(1281,0,10,'227_KEM911090K673','0','brak_obrazka.jpg',NULL,'209.7600','0.0000','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL,'5.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425020','227_KEM911090K673','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1282,0,10,'227_KEM911090K780','0','brak_obrazka.jpg',NULL,'193.5000','0.0000','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL,'5.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433889','227_KEM911090K780',''),
(1283,0,5,'227_KEM911090K782','0','brak_obrazka.jpg',NULL,'173.9800','0.0000','2017-09-25 10:25:04','2017-09-25 10:25:04',NULL,'5.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425495','227_KEM911090K782',''),
(1284,0,3,'227_KEM911090K785','0','brak_obrazka.jpg',NULL,'173.9800','0.0000','2017-09-25 10:25:05','2017-09-25 10:25:05',NULL,'5.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438709','227_KEM911090K785',''),
(1285,0,10,'227_KEM911090K786','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL,'6.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992121','227_KEM911090K786',''),
(1286,0,8,'227_KEM912070K784','0','brak_obrazka.jpg',NULL,'236.5900','0.0000','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL,'5.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989756','227_KEM912070K784',''),
(1287,0,10,'227_KEM912080K781','0','brak_obrazka.jpg',NULL,'179.6700','0.0000','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL,'5.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433896','227_KEM912080K781',''),
(1288,0,10,'227_KEM912080K786','0','brak_obrazka.jpg',NULL,'211.3800','0.0000','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL,'5.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992138','227_KEM912080K786',''),
(1289,0,11,'227_KEM913080K778','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:25:06','2017-09-25 10:25:06',NULL,'5.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425044','227_KEM913080K778',''),
(1290,0,5,'227_KEM970100K785','0','brak_obrazka.jpg',NULL,'98.3700','0.0000','2017-09-25 10:25:07','2017-09-25 10:25:07',NULL,'2.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294687751','227_KEM970100K785',''),
(1291,0,15,'227_KEQ016570K546','0','brak_obrazka.jpg',NULL,'193.5000','0.0000','2017-09-25 10:25:07','2017-09-25 10:25:07',NULL,'5.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427604','227_KEQ016570K546',''),
(1292,0,9,'227_KEQ0217K546F_','0','brak_obrazka.jpg',NULL,'218.7000','0.0000','2017-09-25 10:25:07','2017-09-25 10:25:07',NULL,'5.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427680','227_KEQ0217K546F_',''),
(1293,0,3,'227_KEQ0217K572__','0','brak_obrazka.jpg',NULL,'226.0200','0.0000','2017-09-25 10:25:08','2017-09-25 10:25:08',NULL,'4.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427697','227_KEQ0217K572__',''),
(1294,0,10,'227_KEQ02210K547_','0','brak_obrazka.jpg',NULL,'275.6100','0.0000','2017-09-25 10:25:08','2017-09-25 10:25:08',NULL,'7.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425259','227_KEQ02210K547_',''),
(1295,0,4,'227_KEQ02210K572_','0','brak_obrazka.jpg',NULL,'282.9300','0.0000','2017-09-25 10:25:08','2017-09-25 10:25:08',NULL,'6.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425266','227_KEQ02210K572_',''),
(1296,0,14,'227_KEQ022540K547','0','brak_obrazka.jpg',NULL,'246.3400','0.0000','2017-09-25 10:25:08','2017-09-25 10:25:08',NULL,'7.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEQ022540K547',''),
(1297,0,16,'227_KEQ02310K299_','0','brak_obrazka.jpg',NULL,'332.5200','0.0000','2017-09-25 10:25:09','2017-09-25 10:25:09',NULL,'8.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989770','227_KEQ02310K299_',''),
(1298,0,16,'227_KEQ02411K299_','0','brak_obrazka.jpg',NULL,'315.4500','0.0000','2017-09-25 10:25:09','2017-09-25 10:25:09',NULL,'8.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425402','227_KEQ02411K299_',''),
(1299,0,10,'227_KEQ12410K299X','0','brak_obrazka.jpg',NULL,'278.8600','0.0000','2017-09-25 10:25:09','2017-09-25 10:25:09',NULL,'7.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEQ12410K299X',''),
(1300,0,6,'227_KEQ1249K299__','0','brak_obrazka.jpg',NULL,'296.7500','0.0000','2017-09-25 10:25:09','2017-09-25 10:25:09',NULL,'9.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427758','227_KEQ1249K299__',''),
(1301,0,20,'227_KEQ22410K299_','0','brak_obrazka.jpg',NULL,'315.4500','0.0000','2017-09-25 10:25:09','2017-09-25 10:25:09',NULL,'8.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294980470','227_KEQ22410K299_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1302,0,34,'227_KEQ2248K299__','0','brak_obrazka.jpg',NULL,'239.0200','0.0000','2017-09-25 10:25:10','2017-09-25 10:25:10',NULL,'6.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992206','227_KEQ2248K299__',''),
(1303,0,20,'227_KEQ22510K299_','0','brak_obrazka.jpg',NULL,'259.3500','0.0000','2017-09-25 10:25:10','2017-09-25 10:25:10',NULL,'9.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427789','227_KEQ22510K299_',''),
(1304,0,12,'227_KEQ22510K547_','0','brak_obrazka.jpg',NULL,'347.9700','0.0000','2017-09-25 10:25:10','2017-09-25 10:25:10',NULL,'9.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEQ22510K547_',''),
(1305,0,14,'227_KEQ22510K572_','0','brak_obrazka.jpg',NULL,'279.6700','0.0000','2017-09-25 10:25:10','2017-09-25 10:25:10',NULL,'8.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954428366','227_KEQ22510K572_',''),
(1306,0,26,'227_KEQ22510K587_','0','brak_obrazka.jpg',NULL,'403.2500','0.0000','2017-09-25 10:25:10','2017-09-25 10:25:10',NULL,'11.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685368','227_KEQ22510K587_',''),
(1307,0,24,'227_KEQ2258K299__','0','brak_obrazka.jpg',NULL,'247.9700','0.0000','2017-09-25 10:25:11','2017-09-25 10:25:11',NULL,'7.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425303','227_KEQ2258K299__',''),
(1308,0,8,'227_KEQ2258K546F_','0','brak_obrazka.jpg',NULL,'314.6300','0.0000','2017-09-25 10:25:11','2017-09-25 10:25:11',NULL,'8.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425594','227_KEQ2258K546F_',''),
(1309,0,11,'227_KEQ2258K572__','0','brak_obrazka.jpg',NULL,'262.6000','0.0000','2017-09-25 10:25:11','2017-09-25 10:25:11',NULL,'7.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954428298','227_KEQ2258K572__',''),
(1310,0,12,'227_KEQ2258K587__','0','brak_obrazka.jpg',NULL,'371.5400','0.0000','2017-09-25 10:25:12','2017-09-25 10:25:12',NULL,'9.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685351','227_KEQ2258K587__',''),
(1311,0,8,'227_KEQ22611K299_','0','brak_obrazka.jpg',NULL,'365.0400','0.0000','2017-09-25 10:25:13','2017-09-25 10:25:13',NULL,'10.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685405','227_KEQ22611K299_',''),
(1312,0,10,'227_KEQ22611K587_','0','brak_obrazka.jpg',NULL,'563.4100','0.0000','2017-09-25 10:25:13','2017-09-25 10:25:13',NULL,'14.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685382','227_KEQ22611K587_',''),
(1313,0,4,'227_KEQ2269K299X_','0','brak_obrazka.jpg',NULL,'307.3200','0.0000','2017-09-25 10:25:13','2017-09-25 10:25:13',NULL,'9.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685399','227_KEQ2269K299X_',''),
(1314,0,6,'227_KEQ2269K587__','0','brak_obrazka.jpg',NULL,'426.0200','0.0000','2017-09-25 10:25:13','2017-09-25 10:25:13',NULL,'11.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685375','227_KEQ2269K587__',''),
(1315,0,50,'227_KEQ227100K299','0','brak_obrazka.jpg',NULL,'320.3300','0.0000','2017-09-25 10:25:14','2017-09-25 10:25:14',NULL,'9.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954428465','227_KEQ227100K299',''),
(1316,0,32,'227_KEQ22710K547_','0','brak_obrazka.jpg',NULL,'379.6700','0.0000','2017-09-25 10:25:14','2017-09-25 10:25:14',NULL,'11.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEQ22710K547_',''),
(1317,0,20,'227_KEQ22711K587_','0','brak_obrazka.jpg',NULL,'539.8400','0.0000','2017-09-25 10:25:14','2017-09-25 10:25:14',NULL,'14.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685467','227_KEQ22711K587_',''),
(1318,0,50,'227_KEQ227120K299','0','brak_obrazka.jpg',NULL,'361.7900','0.0000','2017-09-25 10:25:14','2017-09-25 10:25:14',NULL,'13.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954428489','227_KEQ227120K299',''),
(1319,0,20,'227_KEQ2279K587__','0','brak_obrazka.jpg',NULL,'429.2700','0.0000','2017-09-25 10:25:14','2017-09-25 10:25:14',NULL,'11.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685528','227_KEQ2279K587__',''),
(1320,0,10,'227_KEQ42611K587_','0','brak_obrazka.jpg',NULL,'445.5300','0.0000','2017-09-25 10:25:15','2017-09-25 10:25:15',NULL,'13.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680615','227_KEQ42611K587_',''),
(1321,0,18,'227_KEQ4269K576__','0','brak_obrazka.jpg',NULL,'386.9900','0.0000','2017-09-25 10:25:15','2017-09-25 10:25:15',NULL,'11.5800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294980456','227_KEQ4269K576__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1322,0,4,'227_KEQ4269K587__','0','brak_obrazka.jpg',NULL,'392.6800','0.0000','2017-09-25 10:25:15','2017-09-25 10:25:15',NULL,'12.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680608','227_KEQ4269K587__',''),
(1323,0,16,'227_KEQ42811K587_','0','brak_obrazka.jpg',NULL,'526.0200','0.0000','2017-09-25 10:25:15','2017-09-25 10:25:15',NULL,'15.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685429','227_KEQ42811K587_',''),
(1324,0,18,'227_KEQ4289K587__','0','brak_obrazka.jpg',NULL,'430.8900','0.0000','2017-09-25 10:25:15','2017-09-25 10:25:15',NULL,'12.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294685412','227_KEQ4289K587__',''),
(1325,0,2,'227_KEQ71680K530F','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'3.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425211','227_KEQ71680K530F',''),
(1326,0,28,'227_KEQ7168K290__','0','brak_obrazka.jpg',NULL,'108.9400','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'3.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425228','227_KEQ7168K290__',''),
(1327,0,18,'227_KEQ818950K530','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'4.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427895','227_KEQ818950K530',''),
(1328,0,15,'227_KEQ818950K547','0','brak_obrazka.jpg',NULL,'204.8800','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'6.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427888','227_KEQ818950K547',''),
(1329,0,29,'227_KEQ81895K290_','0','brak_obrazka.jpg',NULL,'132.5200','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'4.9100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427543','227_KEQ81895K290_',''),
(1330,0,11,'227_KEQ8197K546F_','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'4.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425327','227_KEQ8197K546F_',''),
(1331,0,8,'227_KEQ8197K572__','0','brak_obrazka.jpg',NULL,'178.0500','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'4.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEQ8197K572__',''),
(1332,0,22,'227_KEQ8198K547__','0','brak_obrazka.jpg',NULL,'202.4400','0.0000','2017-09-25 10:25:16','2017-09-25 10:25:16',NULL,'5.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427901','227_KEQ8198K547__',''),
(1333,0,18,'227_KEQ8207K546F_','0','brak_obrazka.jpg',NULL,'196.7500','0.0000','2017-09-25 10:25:17','2017-09-25 10:25:17',NULL,'6.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427352','227_KEQ8207K546F_',''),
(1334,0,10,'227_KEQ82110K547_','0','brak_obrazka.jpg',NULL,'274.8000','0.0000','2017-09-25 10:25:17','2017-09-25 10:25:17',NULL,'7.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425297','227_KEQ82110K547_',''),
(1335,0,10,'227_KEQ82110K572_','0','brak_obrazka.jpg',NULL,'247.9700','0.0000','2017-09-25 10:25:17','2017-09-25 10:25:17',NULL,'5.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427970','227_KEQ82110K572_',''),
(1336,0,10,'227_KEQ82210K547_','0','brak_obrazka.jpg',NULL,'295.9300','0.0000','2017-09-25 10:25:17','2017-09-25 10:25:17',NULL,'8.2100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427581','227_KEQ82210K547_',''),
(1337,0,8,'227_KEQ82212K299_','0','brak_obrazka.jpg',NULL,'277.2400','0.0000','2017-09-25 10:25:17','2017-09-25 10:25:17',NULL,'8.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KEQ82212K299_',''),
(1338,0,8,'227_KEQ91895K572_','0','brak_obrazka.jpg',NULL,'195.9300','0.0000','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL,'5.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954427864','227_KEQ91895K572_',''),
(1339,0,22,'227_KEQ92011K547_','0','brak_obrazka.jpg',NULL,'319.5100','0.0000','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954428069','227_KEQ92011K547_',''),
(1340,0,6,'227_KEQ92011K572_','0','brak_obrazka.jpg',NULL,'266.6700','0.0000','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL,'7.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954425372','227_KEQ92011K572_',''),
(1341,0,15,'227_KES010080K413','0','brak_obrazka.jpg',NULL,'69.9200','0.0000','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL,'2.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432158','227_KES010080K413','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1342,0,29,'227_KES010080K701','0','brak_obrazka.jpg',NULL,'78.8600','0.0000','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL,'2.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680257','227_KES010080K701',''),
(1343,0,19,'227_KES010090K413','0','brak_obrazka.jpg',NULL,'74.8000','0.0000','2017-09-25 10:25:18','2017-09-25 10:25:18',NULL,'2.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426331','227_KES010090K413',''),
(1344,0,18,'227_KES010090K415','0','brak_obrazka.jpg',NULL,'77.2400','0.0000','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL,'2.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432141','227_KES010090K415',''),
(1345,0,13,'227_KES010090K433','0','brak_obrazka.jpg',NULL,'70.7300','0.0000','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL,'2.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438419','227_KES010090K433',''),
(1346,0,35,'227_KES010090K701','0','brak_obrazka.jpg',NULL,'86.1800','0.0000','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL,'2.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680264','227_KES010090K701',''),
(1347,0,3,'227_KES011080K413','0','brak_obrazka.jpg',NULL,'67.4800','0.0000','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL,'2.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432493','227_KES011080K413',''),
(1348,0,38,'227_KES012070K701','0','brak_obrazka.jpg',NULL,'91.8700','0.0000','2017-09-25 10:25:19','2017-09-25 10:25:19',NULL,'2.8900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680585','227_KES012070K701',''),
(1349,0,20,'227_KES012090K413','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL,'3.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982511','227_KES012090K413',''),
(1350,0,23,'227_KES012090K415','0','brak_obrazka.jpg',NULL,'86.1800','0.0000','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL,'3.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294981514','227_KES012090K415',''),
(1351,0,7,'227_KES012090K451','0','brak_obrazka.jpg',NULL,'85.3700','0.0000','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL,'3.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982467','227_KES012090K451',''),
(1352,0,44,'227_KES012090K701','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL,'3.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680561','227_KES012090K701',''),
(1353,0,20,'227_KES012090K761','0','brak_obrazka.jpg',NULL,'95.9300','0.0000','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL,'3.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426416','227_KES012090K761',''),
(1354,0,19,'227_KES012090K764','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:25:20','2017-09-25 10:25:20',NULL,'3.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432455','227_KES012090K764',''),
(1355,0,16,'227_KES013070K413','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL,'2.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426430','227_KES013070K413',''),
(1356,0,3,'227_KES013090K413','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL,'3.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982528','227_KES013090K413',''),
(1357,0,2,'227_KES013090K415','0','brak_obrazka.jpg',NULL,'92.6800','0.0000','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL,'3.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984829','227_KES013090K415',''),
(1358,0,10,'227_KES013090K451','0','brak_obrazka.jpg',NULL,'98.3700','0.0000','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL,'3.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982450','227_KES013090K451',''),
(1359,0,49,'227_KES013090K701','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL,'3.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294680578','227_KES013090K701',''),
(1360,0,15,'227_KES013090K761','0','brak_obrazka.jpg',NULL,'99.1900','0.0000','2017-09-25 10:25:21','2017-09-25 10:25:21',NULL,'3.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294982498','227_KES013090K761',''),
(1361,0,17,'227_KES013090K764','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'3.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294994996','227_KES013090K764','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1362,0,15,'227_KES015080K761','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'4.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432387','227_KES015080K761',''),
(1363,0,45,'227_KES0300K303A_','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'1.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KES0300K303A_',''),
(1364,0,46,'227_KES0300K4134P','0','brak_obrazka.jpg',NULL,'56.9100','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'2.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426393','227_KES0300K4134P',''),
(1365,0,12,'227_KES0300K422__','0','brak_obrazka.jpg',NULL,'57.7200','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'2.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989060','227_KES0300K422__',''),
(1366,0,50,'227_KES0300K701__','0','brak_obrazka.jpg',NULL,'78.8600','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'2.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424481','227_KES0300K701__',''),
(1367,0,40,'227_KES0350K318__','0','brak_obrazka.jpg',NULL,'65.8500','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'2.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KES0350K318__',''),
(1368,0,50,'227_KES0350K329__','0','brak_obrazka.jpg',NULL,'69.9200','0.0000','2017-09-25 10:25:22','2017-09-25 10:25:22',NULL,'2.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KES0350K329__',''),
(1369,0,50,'227_KES0350K4134P','0','brak_obrazka.jpg',NULL,'65.0400','0.0000','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL,'2.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424504','227_KES0350K4134P',''),
(1370,0,50,'227_KES0350K415__','0','brak_obrazka.jpg',NULL,'67.4800','0.0000','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL,'2.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432295','227_KES0350K415__',''),
(1371,0,50,'227_KES0350K701__','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL,'2.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424498','227_KES0350K701__',''),
(1372,0,15,'227_KES09090K413B','0','brak_obrazka.jpg',NULL,'65.8500','0.0000','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL,'2.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426355','227_KES09090K413B',''),
(1373,0,18,'227_KES09090K415_','0','brak_obrazka.jpg',NULL,'52.8500','0.0000','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL,'2.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432240','227_KES09090K415_',''),
(1374,0,42,'227_KES211070K413','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL,'2.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424726','227_KES211070K413',''),
(1375,0,20,'227_KES211070K41P','0','brak_obrazka.jpg',NULL,'87.8000','0.0000','2017-09-25 10:25:23','2017-09-25 10:25:23',NULL,'2.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954445691','227_KES211070K41P',''),
(1376,0,6,'227_KES211070K711','0','brak_obrazka.jpg',NULL,'82.9300','0.0000','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL,'2.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992022','227_KES211070K711',''),
(1377,0,14,'227_KES211070K761','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL,'2.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424634','227_KES211070K761',''),
(1378,0,21,'227_KES211080K764','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL,'3.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997058','227_KES211080K764',''),
(1379,0,15,'227_KES211090K413','0','brak_obrazka.jpg',NULL,'91.0600','0.0000','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL,'3.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426522','227_KES211090K413',''),
(1380,0,44,'227_KES211090K41P','0','brak_obrazka.jpg',NULL,'99.1900','0.0000','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL,'3.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992060','227_KES211090K41P',''),
(1381,0,40,'227_KES211090K761','0','brak_obrazka.jpg',NULL,'92.6800','0.0000','2017-09-25 10:25:24','2017-09-25 10:25:24',NULL,'3.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426553','227_KES211090K761','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1382,0,50,'227_KES212070K413','0','brak_obrazka.jpg',NULL,'84.5500','0.0000','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL,'3.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432530','227_KES212070K413',''),
(1383,0,50,'227_KES212070K415','0','brak_obrazka.jpg',NULL,'84.5500','0.0000','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL,'3.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432585','227_KES212070K415',''),
(1384,0,50,'227_KES212070K41P','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL,'3.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432547','227_KES212070K41P',''),
(1385,0,50,'227_KES212070K701','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL,'3.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424627','227_KES212070K701',''),
(1386,0,50,'227_KES212070K761','0','brak_obrazka.jpg',NULL,'93.5000','0.0000','2017-09-25 10:25:25','2017-09-25 10:25:25',NULL,'3.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989091','227_KES212070K761',''),
(1387,0,28,'227_KES212070K764','0','brak_obrazka.jpg',NULL,'100.8100','0.0000','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL,'3.2700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432615','227_KES212070K764',''),
(1388,0,50,'227_KES212070K76F','0','brak_obrazka.jpg',NULL,'79.6700','0.0000','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL,'3.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954445394','227_KES212070K76F',''),
(1389,0,21,'227_KES212080K761','0','brak_obrazka.jpg',NULL,'95.9300','0.0000','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL,'3.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426560','227_KES212080K761',''),
(1390,0,50,'227_KES213070K413','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL,'3.5300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KES213070K413',''),
(1391,0,50,'227_KES213070K415','0','brak_obrazka.jpg',NULL,'91.0600','0.0000','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL,'3.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432639','227_KES213070K415',''),
(1392,0,50,'227_KES213070K41P','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:25:26','2017-09-25 10:25:26',NULL,'3.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432554','227_KES213070K41P',''),
(1393,0,50,'227_KES213070K433','0','brak_obrazka.jpg',NULL,'91.8700','0.0000','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL,'3.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989107','227_KES213070K433',''),
(1394,0,50,'227_KES213070K701','0','brak_obrazka.jpg',NULL,'118.7000','0.0000','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954424733','227_KES213070K701',''),
(1395,0,50,'227_KES213070K761','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL,'3.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989084','227_KES213070K761',''),
(1396,0,50,'227_KES213070K763','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL,'3.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432783','227_KES213070K763',''),
(1397,0,17,'227_KES213070K764','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL,'3.6700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954446919','227_KES213070K764',''),
(1398,0,29,'227_KES213080K761','0','brak_obrazka.jpg',NULL,'115.4500','0.0000','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL,'4.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426515','227_KES213080K761',''),
(1399,0,16,'227_KES214070K413','0','brak_obrazka.jpg',NULL,'100.8100','0.0000','2017-09-25 10:25:27','2017-09-25 10:25:27',NULL,'3.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432608','227_KES214070K413',''),
(1400,0,5,'227_KES214070K41P','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL,'3.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432622','227_KES214070K41P',''),
(1401,0,4,'227_KES214070K711','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL,'4.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992091','227_KES214070K711','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1402,0,13,'227_KES214070K761','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL,'3.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432790','227_KES214070K761',''),
(1403,0,15,'227_KES214070K764','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL,'3.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997041','227_KES214070K764',''),
(1404,0,8,'227_KES311090K76F','0','brak_obrazka.jpg',NULL,'98.3700','0.0000','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL,'3.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432837','227_KES311090K76F',''),
(1405,0,10,'227_KES312070K703','0','brak_obrazka.jpg',NULL,'117.0700','0.0000','2017-09-25 10:25:28','2017-09-25 10:25:28',NULL,'3.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294995443','227_KES312070K703',''),
(1406,0,14,'227_KES312070K711','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL,'3.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992077','227_KES312070K711',''),
(1407,0,50,'227_KES313060K413','0','brak_obrazka.jpg',NULL,'87.8000','0.0000','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL,'3.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432677','227_KES313060K413',''),
(1408,0,11,'227_KES313060K41P','0','brak_obrazka.jpg',NULL,'91.0600','0.0000','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL,'3.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KES313060K41P',''),
(1409,0,50,'227_KES313060K701','0','brak_obrazka.jpg',NULL,'100.0000','0.0000','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL,'3.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954443468','227_KES313060K701',''),
(1410,0,50,'227_KES313060K761','0','brak_obrazka.jpg',NULL,'89.4300','0.0000','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL,'3.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432769','227_KES313060K761',''),
(1411,0,28,'227_KES313060K764','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:25:29','2017-09-25 10:25:29',NULL,'3.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432752','227_KES313060K764',''),
(1412,0,10,'227_KES313070K703','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL,'4.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294993395','227_KES313070K703',''),
(1413,0,5,'227_KES313070K711','0','brak_obrazka.jpg',NULL,'115.4500','0.0000','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL,'4.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992084','227_KES313070K711',''),
(1414,0,1,'227_KES313070K763','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL,'3.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432653','227_KES313070K763',''),
(1415,0,8,'227_KES313070K766','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL,'4.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432660','227_KES313070K766',''),
(1416,0,14,'227_KES314060K413','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:25:30','2017-09-25 10:25:30',NULL,'3.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432738','227_KES314060K413',''),
(1417,0,18,'227_KES314060K41P','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL,'3.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432745','227_KES314060K41P',''),
(1418,0,3,'227_KES314060K761','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL,'3.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432868','227_KES314060K761',''),
(1419,0,25,'227_KES314060K764','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL,'3.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432899','227_KES314060K764',''),
(1420,0,2,'227_KES315070K434','0','brak_obrazka.jpg',NULL,'146.3400','0.0000','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL,'5.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438402','227_KES315070K434',''),
(1421,0,14,'227_KES315070K711','0','brak_obrazka.jpg',NULL,'147.9700','0.0000','2017-09-25 10:25:31','2017-09-25 10:25:31',NULL,'5.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992268','227_KES315070K711','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1422,0,9,'227_KES412070K433','0','brak_obrazka.jpg',NULL,'116.2600','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'4.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954438532','227_KES412070K433',''),
(1423,0,14,'227_KES412070K764','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'3.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954446186','227_KES412070K764',''),
(1424,0,8,'227_KES412070K76F','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'3.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432776','227_KES412070K76F',''),
(1425,0,10,'227_KES412080K433','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'4.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432950','227_KES412080K433',''),
(1426,0,7,'227_KES412080K71F','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'4.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294992275','227_KES412080K71F',''),
(1427,0,2,'227_KES414060K763','0','brak_obrazka.jpg',NULL,'114.6300','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'4.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989077','227_KES414060K763',''),
(1428,0,15,'227_KES414060K764','0','brak_obrazka.jpg',NULL,'135.7700','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'4.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954446162','227_KES414060K764',''),
(1429,0,15,'227_KES414070K764','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'4.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954445783','227_KES414070K764',''),
(1430,0,5,'227_KES415070K434','0','brak_obrazka.jpg',NULL,'168.2900','0.0000','2017-09-25 10:25:32','2017-09-25 10:25:32',NULL,'6.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426591','227_KES415070K434',''),
(1431,0,15,'227_KES48080K425_','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'2.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294989114','227_KES48080K425_',''),
(1432,0,11,'227_KES512070K433','0','brak_obrazka.jpg',NULL,'132.5200','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'4.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954426652','227_KES512070K433',''),
(1433,0,10,'227_KES514070K434','0','brak_obrazka.jpg',NULL,'141.4600','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'5.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954432998','227_KES514070K434',''),
(1434,0,32,'227_KES610080K701','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'3.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684620','227_KES610080K701',''),
(1435,0,7,'227_KES610080K76F','0','brak_obrazka.jpg',NULL,'112.2000','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'3.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433049','227_KES610080K76F',''),
(1436,0,7,'227_KES611070K761','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'3.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954445790','227_KES611070K761',''),
(1437,0,9,'227_KES612070K433','0','brak_obrazka.jpg',NULL,'128.4600','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'4.4500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433155','227_KES612070K433',''),
(1438,0,17,'227_KES612080K701','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:25:33','2017-09-25 10:25:33',NULL,'4.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294684637','227_KES612080K701',''),
(1439,0,1,'227_KES612080K763','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL,'4.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433452','227_KES612080K763',''),
(1440,0,7,'227_KES613080K763','0','brak_obrazka.jpg',NULL,'143.9000','0.0000','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL,'5.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954433056','227_KES613080K763',''),
(1441,0,31,'227_KESWW0300K333','0','brak_obrazka.jpg',NULL,'81.3000','0.0000','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL,'2.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294983860','227_KESWW0300K333','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1442,0,50,'227_KESWW0350K333','0','brak_obrazka.jpg',NULL,'86.1800','0.0000','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL,'2.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294983877','227_KESWW0350K333',''),
(1443,0,50,'227_KESWW212070K4','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL,'3.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294997140','227_KESWW212070K4',''),
(1444,0,10,'227_KEV521565KR15','0','brak_obrazka.jpg',NULL,'209.7600','0.0000','2017-09-25 10:25:34','2017-09-25 10:25:34',NULL,'11.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430871','227_KEV521565KR15',''),
(1445,0,4,'227_KEV523570KR15','0','brak_obrazka.jpg',NULL,'299.1900','0.0000','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL,'14.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430833','227_KEV523570KR15',''),
(1446,0,2,'227_KEV523575KR15','0','brak_obrazka.jpg',NULL,'195.9300','0.0000','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL,'14.8300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954422920','227_KEV523575KR15',''),
(1447,0,1,'227_KEV621565KR15','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL,'11.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954423781','227_KEV621565KR15',''),
(1448,0,1,'227_KEV622570KR15','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL,'13.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954422999','227_KEV622570KR15',''),
(1449,0,4,'227_KEV622570KR50','0','brak_obrazka.jpg',NULL,'188.6200','0.0000','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL,'12.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984669','227_KEV622570KR50',''),
(1450,0,2,'227_KEV723555KR50','0','brak_obrazka.jpg',NULL,'165.8500','0.0000','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL,'12.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294983723','227_KEV723555KR50',''),
(1451,0,12,'227_KEV725560KR50','0','brak_obrazka.jpg',NULL,'237.4000','0.0000','2017-09-25 10:25:35','2017-09-25 10:25:35',NULL,'16.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984737','227_KEV725560KR50',''),
(1452,0,8,'227_KEV727565KR15','0','brak_obrazka.jpg',NULL,'304.8800','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'18.8300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954430857','227_KEV727565KR15',''),
(1453,0,8,'227_KEV727565KR16','0','brak_obrazka.jpg',NULL,'304.8800','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'19.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717954429950','227_KEV727565KR16',''),
(1454,0,6,'227_KEV822565KR50','0','brak_obrazka.jpg',NULL,'294.3100','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'13.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984768','227_KEV822565KR50',''),
(1455,0,1,'227_KEV823560KR50','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'13.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984638','227_KEV823560KR50',''),
(1456,0,8,'227_KEV825560KR50','0','brak_obrazka.jpg',NULL,'268.2900','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'16.9300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984775','227_KEV825560KR50',''),
(1457,0,4,'227_KEV826565KR50','0','brak_obrazka.jpg',NULL,'331.7100','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'17.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717294984744','227_KEV826565KR50',''),
(1458,0,4,'227_KOSCHUSTECL__','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'0.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_KOSCHUSTECL__',''),
(1459,0,1,'227_MAC0351250772','0','brak_obrazka.jpg',NULL,'759.3500','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'34.8300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784322728','227_MAC0351250772',''),
(1460,0,1,'227_MAC523575M764','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:25:36','2017-09-25 10:25:36',NULL,'16.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784272702','227_MAC523575M764',''),
(1461,0,1,'227_MAC628575762A','0','brak_obrazka.jpg',NULL,'488.6200','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'25.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784318028','227_MAC628575762A','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1462,0,2,'227_MAC731570772_','0','brak_obrazka.jpg',NULL,'728.4600','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'34.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784313245','227_MAC731570772_',''),
(1463,0,2,'227_MAC827565M764','0','brak_obrazka.jpg',NULL,'526.0200','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'23.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784314303','227_MAC827565M764',''),
(1464,0,1,'227_MAI81885M7515','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'4.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784700182','227_MAI81885M7515',''),
(1465,0,50,'227_MAMFEKATALOG_','0','brak_obrazka.jpg',NULL,'12.2000','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'0.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAMFEKATALOG_',''),
(1466,0,3,'227_MAMITPCATVO14','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'0.0010',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAMITPCATVO14',''),
(1467,0,50,'227_MAMSILKATALOG','0','brak_obrazka.jpg',NULL,'12.2000','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'0.0010',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAMSILKATALOG',''),
(1468,0,12,'227_MAMTORBAPAPFE','0','brak_obrazka.jpg',NULL,'1.6300','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'0.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAMTORBAPAPFE',''),
(1469,0,1,'227_MAO1801007304','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'3.8900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784505329','227_MAO1801007304',''),
(1470,0,26,'227_MAO460100M731','0','brak_obrazka.jpg',NULL,'58.5400','0.0000','2017-09-25 10:25:37','2017-09-25 10:25:37',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784501666','227_MAO460100M731',''),
(1471,0,11,'227_MAO770100M731','0','brak_obrazka.jpg',NULL,'70.7300','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784501673','227_MAO770100M731',''),
(1472,0,13,'227_MAO970100M730','0','brak_obrazka.jpg',NULL,'62.6000','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'2.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784501246','227_MAO970100M730',''),
(1473,0,1,'227_MAS011080M602','0','brak_obrazka.jpg',NULL,'60.9800','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'2.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784500553','227_MAS011080M602',''),
(1474,0,1,'227_MAS012090M604','0','brak_obrazka.jpg',NULL,'73.1700','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAS012090M604',''),
(1475,0,22,'227_MAS211060M602','0','brak_obrazka.jpg',NULL,'62.6000','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'2.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAS211060M602',''),
(1476,0,49,'227_MAS4140606128','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'4.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAS4140606128',''),
(1477,0,14,'227_MAZ6,512580__','0','brak_obrazka.jpg',NULL,'54.4700','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ6,512580__',''),
(1478,0,2,'227_MAZ712060_M60','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ712060_M60',''),
(1479,0,2,'227_MAZ712070M399','0','brak_obrazka.jpg',NULL,'179.6700','0.0000','2017-09-25 10:25:38','2017-09-25 10:25:38',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ712070M399',''),
(1480,0,2,'227_MAZ712070MAPS','0','brak_obrazka.jpg',NULL,'132.5200','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ712070MAPS',''),
(1481,0,17,'227_MAZ712076M610','0','brak_obrazka.jpg',NULL,'46.3400','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ712076M610','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1482,0,3,'227_MAZ714070M610','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784503370','227_MAZ714070M610',''),
(1483,0,1,'227_MAZ716060M399','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ716060M399',''),
(1484,0,1,'227_MAZ716060MAPS','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784501024','227_MAZ716060MAPS',''),
(1485,0,2,'227_MAZ718055MAPS','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','4717784500843','227_MAZ718055MAPS',''),
(1486,0,5,'227_MAZ718055MAST','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ718055MAST',''),
(1487,0,5,'227_MAZ719050MA3D','0','brak_obrazka.jpg',NULL,'195.1200','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ719050MA3D',''),
(1488,0,10,'227_MAZ719055MA3D','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:25:39','2017-09-25 10:25:39',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ719055MA3D',''),
(1489,0,7,'227_MAZ719055MAPS','0','brak_obrazka.jpg',NULL,'234.1500','0.0000','2017-09-25 10:25:40','2017-09-25 10:25:40',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_MAZ719055MAPS',''),
(1490,0,16,'227_PO45311050MT_','0','brak_obrazka.jpg',NULL,'306.5000','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'18.1400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO45311050MT_',''),
(1491,0,20,'227_PO45331250MT_','0','brak_obrazka.jpg',NULL,'394.3100','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'22.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO45331250MT_',''),
(1492,0,18,'227_PO45351250MT_','0','brak_obrazka.jpg',NULL,'461.7900','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'22.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO45351250MT_',''),
(1493,0,20,'227_PO4623585MT__','0','brak_obrazka.jpg',NULL,'333.3300','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'19.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO4623585MT__',''),
(1494,0,20,'227_PO4624575MT__','0','brak_obrazka.jpg',NULL,'342.2800','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'19.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO4624575MT__',''),
(1495,0,20,'227_PO4726570MT__','0','brak_obrazka.jpg',NULL,'413.8200','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'22.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO4726570MT__',''),
(1496,0,20,'227_PO4728570MT__','0','brak_obrazka.jpg',NULL,'450.4100','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'24.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO4728570MT__',''),
(1497,0,20,'227_PO47351250MT_','0','brak_obrazka.jpg',NULL,'486.9900','0.0000','2017-09-25 10:25:41','2017-09-25 10:25:41',NULL,'27.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PO47351250MT_',''),
(1498,0,20,'227_POD2145VANT__','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POD2145VANT__',''),
(1499,0,1,'227_POD417565VANT','0','brak_obrazka.jpg',NULL,'103.2500','0.0000','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL,'7.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149453330','227_POD417565VANT',''),
(1500,0,50,'227_POD4185VANTOU','0','brak_obrazka.jpg',NULL,'149.5900','0.0000','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL,'9.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450544','227_POD4185VANTOU',''),
(1501,0,1,'227_POD419580VANS','0','brak_obrazka.jpg',NULL,'145.5300','0.0000','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL,'10.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149453125','227_POD419580VANS','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1502,0,50,'227_POD519570VANT','0','brak_obrazka.jpg',NULL,'160.1600','0.0000','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL,'10.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450742','227_POD519570VANT',''),
(1503,0,2,'227_POD519580VANT','0','brak_obrazka.jpg',NULL,'160.9800','0.0000','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL,'11.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450797','227_POD519580VANT',''),
(1504,0,50,'227_POD521570VANT','0','brak_obrazka.jpg',NULL,'187.8000','0.0000','2017-09-25 10:25:42','2017-09-25 10:25:42',NULL,'11.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450230','227_POD521570VANT',''),
(1505,0,34,'227_POD522570VANT','0','brak_obrazka.jpg',NULL,'178.8600','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'12.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451381','227_POD522570VANT',''),
(1506,0,50,'227_POD619575VANT','0','brak_obrazka.jpg',NULL,'171.5400','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'11.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450759','227_POD619575VANT',''),
(1507,0,12,'227_POD620565VANT','0','brak_obrazka.jpg',NULL,'167.4800','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'11.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450957','227_POD620565VANT',''),
(1508,0,17,'227_POD620575VANT','0','brak_obrazka.jpg',NULL,'186.1800','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'12.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450254','227_POD620575VANT',''),
(1509,0,2,'227_POD621565VANT','0','brak_obrazka.jpg',NULL,'169.9200','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'11.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451183','227_POD621565VANT',''),
(1510,0,2,'227_POL317560CITY','0','brak_obrazka.jpg',NULL,'80.4900','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'6.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450292','227_POL317560CITY',''),
(1511,0,6,'227_POL415565CITY','0','brak_obrazka.jpg',NULL,'80.4900','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'5.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149453262','227_POL415565CITY',''),
(1512,0,4,'227_POL416560CITY','0','brak_obrazka.jpg',NULL,'81.3000','0.0000','2017-09-25 10:25:43','2017-09-25 10:25:43',NULL,'5.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450025','227_POL416560CITY',''),
(1513,0,8,'227_POL416565CITY','0','brak_obrazka.jpg',NULL,'85.3700','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'6.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450209','227_POL416565CITY',''),
(1514,0,2,'227_POL416570CIT1','0','brak_obrazka.jpg',NULL,'79.6700','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'6.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450223','227_POL416570CIT1',''),
(1515,0,1,'227_POL416570CITY','0','brak_obrazka.jpg',NULL,'81.3000','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'6.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POL416570CITY',''),
(1516,0,2,'227_POL417565CIT1','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'6.7100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450308','227_POL417565CIT1',''),
(1517,0,2,'227_POL418570CITY','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'7.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450490','227_POL418570CITY',''),
(1518,0,12,'227_POL419560CITY','0','brak_obrazka.jpg',NULL,'104.0700','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'7.5700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450643','227_POL419560CITY',''),
(1519,0,20,'227_POL420560CITY','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'8.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450896','227_POL420560CITY',''),
(1520,0,3,'227_POL420570CITY','0','brak_obrazka.jpg',NULL,'122.7600','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'9.0900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450964','227_POL420570CITY',''),
(1521,0,1,'227_POL421570CITY','0','brak_obrazka.jpg',NULL,'121.1400','0.0000','2017-09-25 10:25:44','2017-09-25 10:25:44',NULL,'9.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451213','227_POL421570CITY','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1522,0,2,'227_POL517560CITY','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450056','227_POL517560CITY',''),
(1523,0,14,'227_POL517565CITY','0','brak_obrazka.jpg',NULL,'100.8100','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450339','227_POL517565CITY',''),
(1524,0,2,'227_POL518560CIT1','0','brak_obrazka.jpg',NULL,'101.6300','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450414','227_POL518560CIT1',''),
(1525,0,10,'227_POL518560CITY','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450438','227_POL518560CITY',''),
(1526,0,8,'227_POL518565CIT1','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POL518565CIT1',''),
(1527,0,2,'227_POL518565CITY','0','brak_obrazka.jpg',NULL,'102.4400','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.5800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450469','227_POL518565CITY',''),
(1528,0,19,'227_POL519550CITR','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450575','227_POL519550CITR',''),
(1529,0,9,'227_POL519560CIT1','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450650','227_POL519560CIT1',''),
(1530,0,8,'227_POL519560CITY','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:25:45','2017-09-25 10:25:45',NULL,'7.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450667','227_POL519560CITY',''),
(1531,0,50,'227_POL519565CITY','0','brak_obrazka.jpg',NULL,'106.5000','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'8.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450698','227_POL519565CITY',''),
(1532,0,3,'227_POL520560CITY','0','brak_obrazka.jpg',NULL,'110.5700','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'8.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450902','227_POL520560CITY',''),
(1533,0,16,'227_POL521560CITY','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'9.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451084','227_POL521560CITY',''),
(1534,0,2,'227_POL522570CITY','0','brak_obrazka.jpg',NULL,'149.5900','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'11.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451374','227_POL522570CITY',''),
(1535,0,20,'227_POL618555RACI','0','brak_obrazka.jpg',NULL,'123.5800','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'8.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POL618555RACI',''),
(1536,0,1,'227_POL619555CITR','0','brak_obrazka.jpg',NULL,'118.7000','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'8.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450636','227_POL619555CITR',''),
(1537,0,7,'227_POL620550CITR','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'9.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450834','227_POL620550CITR',''),
(1538,0,4,'227_POL620555CITR','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:25:46','2017-09-25 10:25:46',NULL,'9.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450889','227_POL620555CITR',''),
(1539,0,2,'227_POL620555CITY','0','brak_obrazka.jpg',NULL,'122.7600','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'8.9100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450865','227_POL620555CITY',''),
(1540,0,1,'227_POL620560CITY','0','brak_obrazka.jpg',NULL,'121.9500','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'9.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450926','227_POL620560CITY',''),
(1541,0,10,'227_POL621560CIT1','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'10.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451114','227_POL621560CIT1','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1542,0,20,'227_POL622550CITR','0','brak_obrazka.jpg',NULL,'158.5400','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'10.3200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POL622550CITR',''),
(1543,0,16,'227_POL622560CITY','0','brak_obrazka.jpg',NULL,'156.9100','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'10.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451329','227_POL622560CITY',''),
(1544,0,3,'227_POL720550CITR','0','brak_obrazka.jpg',NULL,'136.5900','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'9.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450841','227_POL720550CITR',''),
(1545,0,5,'227_POL721540RACI','0','brak_obrazka.jpg',NULL,'139.8400','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'9.2400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POL721540RACI',''),
(1546,0,2,'227_POL721545CITR','0','brak_obrazka.jpg',NULL,'143.0900','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'9.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451015','227_POL721545CITR',''),
(1547,0,10,'227_POL721555CITR','0','brak_obrazka.jpg',NULL,'159.3500','0.0000','2017-09-25 10:25:47','2017-09-25 10:25:47',NULL,'10.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451060','227_POL721555CITR',''),
(1548,0,10,'227_POL721560CITR','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL,'11.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451121','227_POL721560CITR',''),
(1549,0,1,'227_POL722565CITR','0','brak_obrazka.jpg',NULL,'187.8000','0.0000','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL,'12.1600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451367','227_POL722565CITR',''),
(1550,0,1,'227_POL723545CITR','0','brak_obrazka.jpg',NULL,'149.5900','0.0000','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL,'10.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451428','227_POL723545CITR',''),
(1551,0,10,'227_POL723565CITR','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL,'13.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451541','227_POL723565CITR',''),
(1552,0,1,'227_POL823545CITR','0','brak_obrazka.jpg',NULL,'173.1700','0.0000','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL,'10.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451435','227_POL823545CITR',''),
(1553,0,2,'227_POL823560CITR','0','brak_obrazka.jpg',NULL,'218.7000','0.0000','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL,'12.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6924064100626','227_POL823560CITR',''),
(1554,0,3,'227_POL825555CITR','0','brak_obrazka.jpg',NULL,'218.7000','0.0000','2017-09-25 10:25:48','2017-09-25 10:25:48',NULL,'14.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451732','227_POL825555CITR',''),
(1555,0,8,'227_POT2512TRACPR','0','brak_obrazka.jpg',NULL,'767.4800','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'60.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POT2512TRACPR',''),
(1556,0,8,'227_POT2513POWPER','0','brak_obrazka.jpg',NULL,'856.1000','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'64.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454535','227_POT2513POWPER',''),
(1557,0,30,'227_POT2513TRACPR','0','brak_obrazka.jpg',NULL,'815.4500','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'64.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454733','227_POT2513TRACPR',''),
(1558,0,4,'227_POT2527570PLS','0','brak_obrazka.jpg',NULL,'636.5900','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'50.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_POT2527570PLS',''),
(1559,0,8,'227_POT2527570POC','0','brak_obrazka.jpg',NULL,'613.0100','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'50.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149457444','227_POT2527570POC',''),
(1560,0,6,'227_POT2529580COE','0','brak_obrazka.jpg',NULL,'702.4400','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'56.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454344','227_POT2529580COE',''),
(1561,0,8,'227_POT2529580POP','0','brak_obrazka.jpg',NULL,'758.5400','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'60.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454573','227_POT2529580POP','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1562,0,4,'227_POT2529580PPE','0','brak_obrazka.jpg',NULL,'726.8300','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'61.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454542','227_POT2529580PPE',''),
(1563,0,8,'227_POT2529580TRP','0','brak_obrazka.jpg',NULL,'684.5500','0.0000','2017-09-25 10:25:49','2017-09-25 10:25:49',NULL,'56.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149457529','227_POT2529580TRP',''),
(1564,0,6,'227_POT2531570POC','0','brak_obrazka.jpg',NULL,'703.2500','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'54.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454450','227_POT2531570POC',''),
(1565,0,50,'227_POT2531570POP','0','brak_obrazka.jpg',NULL,'744.7200','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'58.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149457444','227_POT2531570POP',''),
(1566,0,26,'227_POT2531580COE','0','brak_obrazka.jpg',NULL,'682.9300','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'60.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454337','227_POT2531580COE',''),
(1567,0,16,'227_POT2531580POP','0','brak_obrazka.jpg',NULL,'719.5100','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'64.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454559','227_POT2531580POP',''),
(1568,0,3,'227_POT2531580TRP','0','brak_obrazka.jpg',NULL,'682.9300','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'60.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454702','227_POT2531580TRP',''),
(1569,0,50,'227_POT2538565CRT','0','brak_obrazka.jpg',NULL,'851.2200','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'69.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149454375','227_POT2538565CRT',''),
(1570,0,4,'227_POT7521575PLU','0','brak_obrazka.jpg',NULL,'382.1100','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'27.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149457475','227_POT7521575PLU',''),
(1571,0,8,'227_POT7521575POC','0','brak_obrazka.jpg',NULL,'360.1600','0.0000','2017-09-25 10:25:50','2017-09-25 10:25:50',NULL,'26.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149457482','227_POT7521575POC',''),
(1572,0,8,'227_POT7523575PLU','0','brak_obrazka.jpg',NULL,'443.9000','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'31.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149457505','227_POT7523575PLU',''),
(1573,0,8,'227_POT7523575POC','0','brak_obrazka.jpg',NULL,'427.6400','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'30.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149457499','227_POT7523575POC',''),
(1574,0,50,'227_PWW3155VANM__','0','brak_obrazka.jpg',NULL,'107.3200','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'6.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW3155VANM__',''),
(1575,0,48,'227_PWW3165VANM__','0','brak_obrazka.jpg',NULL,'126.8300','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'6.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW3165VANM__',''),
(1576,0,44,'227_PWW418580VANM','0','brak_obrazka.jpg',NULL,'191.8700','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'10.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW418580VANM',''),
(1577,0,34,'227_PWW419580VANM','0','brak_obrazka.jpg',NULL,'206.5000','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'11.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW419580VANM',''),
(1578,0,12,'227_PWW420575VANM','0','brak_obrazka.jpg',NULL,'209.7600','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'11.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW420575VANM',''),
(1579,0,31,'227_PWW518580VANM','0','brak_obrazka.jpg',NULL,'202.4400','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'11.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW518580VANM',''),
(1580,0,50,'227_PWW519580VANM','0','brak_obrazka.jpg',NULL,'219.5100','0.0000','2017-09-25 10:25:51','2017-09-25 10:25:51',NULL,'11.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW519580VANM',''),
(1581,0,12,'227_PWW520575ROAD','0','brak_obrazka.jpg',NULL,'206.5000','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'11.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW520575ROAD','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1582,0,41,'227_PWW520575VANM','0','brak_obrazka.jpg',NULL,'226.8300','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'12.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW520575VANM',''),
(1583,0,16,'227_PWW521575ROAD','0','brak_obrazka.jpg',NULL,'216.2600','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'11.6600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW521575ROAD',''),
(1584,0,50,'227_PWW522570ROAD','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'11.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW522570ROAD',''),
(1585,0,2,'227_PWW522575ROAD','0','brak_obrazka.jpg',NULL,'230.8900','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'12.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW522575ROAD',''),
(1586,0,34,'227_PWW523575ROAD','0','brak_obrazka.jpg',NULL,'239.8400','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'13.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PWW523575ROAD',''),
(1587,0,34,'227_PZD521570SNOT','0','brak_obrazka.jpg',NULL,'198.3700','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'11.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452586','227_PZD521570SNOT',''),
(1588,0,16,'227_PZD618575SNOT','0','brak_obrazka.jpg',NULL,'182.1100','0.0000','2017-09-25 10:25:52','2017-09-25 10:25:52',NULL,'10.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452609','227_PZD618575SNOT',''),
(1589,0,39,'227_PZD619565SNOT','0','brak_obrazka.jpg',NULL,'185.3700','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'10.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452616','227_PZD619565SNOT',''),
(1590,0,12,'227_PZD619575SNOT','0','brak_obrazka.jpg',NULL,'203.2500','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'11.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452623','227_PZD619575SNOT',''),
(1591,0,26,'227_PZD620565SNOT','0','brak_obrazka.jpg',NULL,'204.0700','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'11.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452654','227_PZD620565SNOT',''),
(1592,0,4,'227_PZD621565SNOT','0','brak_obrazka.jpg',NULL,'208.1300','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'11.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452678','227_PZD621565SNOT',''),
(1593,0,50,'227_PZD621575SNOT','0','brak_obrazka.jpg',NULL,'228.4600','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'11.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452692','227_PZD621575SNOT',''),
(1594,0,19,'227_PZD623565SNOT','0','brak_obrazka.jpg',NULL,'237.4000','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'14.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452777','227_PZD623565SNOT',''),
(1595,0,2,'227_PZL027540SNOS','0','brak_obrazka.jpg',NULL,'280.4900','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'15.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451916','227_PZL027540SNOS',''),
(1596,0,6,'227_PZL027545SNOS','0','brak_obrazka.jpg',NULL,'291.8700','0.0000','2017-09-25 10:25:53','2017-09-25 10:25:53',NULL,'16.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451930','227_PZL027545SNOS',''),
(1597,0,20,'227_PZL316570SNOS','0','brak_obrazka.jpg',NULL,'92.6800','0.0000','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL,'6.3900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452968','227_PZL316570SNOS',''),
(1598,0,12,'227_PZL317570SNOT','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL,'6.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450353','227_PZL317570SNOT',''),
(1599,0,12,'227_PZL415565SNOT','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL,'6.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL415565SNOT',''),
(1600,0,2,'227_PZL416560SNOT','0','brak_obrazka.jpg',NULL,'100.0000','0.0000','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL,'6.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL416560SNOT',''),
(1601,0,4,'227_PZL416565SNOT','0','brak_obrazka.jpg',NULL,'100.0000','0.0000','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL,'6.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL416565SNOT','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1602,0,6,'227_PZL416570SNOT','0','brak_obrazka.jpg',NULL,'104.0700','0.0000','2017-09-25 10:25:54','2017-09-25 10:25:54',NULL,'6.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450247','227_PZL416570SNOT',''),
(1603,0,10,'227_PZL418560SNOS','0','brak_obrazka.jpg',NULL,'114.6300','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'7.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452951','227_PZL418560SNOS',''),
(1604,0,8,'227_PZL418570SNOT','0','brak_obrazka.jpg',NULL,'123.5800','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'7.9500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450506','227_PZL418570SNOT',''),
(1605,0,2,'227_PZL518555SNOT','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'7.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452548','227_PZL518555SNOT',''),
(1606,0,12,'227_PZL518560SNOT','0','brak_obrazka.jpg',NULL,'128.4600','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'7.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450421','227_PZL518560SNOT',''),
(1607,0,8,'227_PZL518565SNOT','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'7.9800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149450476','227_PZL518565SNOT',''),
(1608,0,40,'227_PZL519555SNOS','0','brak_obrazka.jpg',NULL,'129.2700','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'8.2900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452784','227_PZL519555SNOS',''),
(1609,0,8,'227_PZL519560SNOS','0','brak_obrazka.jpg',NULL,'129.2700','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'8.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149453002','227_PZL519560SNOS',''),
(1610,0,50,'227_PZL519565SNO2','0','brak_obrazka.jpg',NULL,'129.2700','0.0000','2017-09-25 10:25:55','2017-09-25 10:25:55',NULL,'8.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149453064','227_PZL519565SNO2',''),
(1611,0,36,'227_PZL519565SNO3','0','brak_obrazka.jpg',NULL,'135.7700','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'9.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL519565SNO3',''),
(1612,0,50,'227_PZL519565SNOS','0','brak_obrazka.jpg',NULL,'129.2700','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'9.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL519565SNOS',''),
(1613,0,18,'227_PZL520565SNOT','0','brak_obrazka.jpg',NULL,'141.4600','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'9.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452975','227_PZL520565SNOT',''),
(1614,0,18,'227_PZL521570SNOT','0','brak_obrazka.jpg',NULL,'169.1100','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'10.5100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452982','227_PZL521570SNOT',''),
(1615,0,10,'227_PZL619555SNOS','0','brak_obrazka.jpg',NULL,'147.9700','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'8.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL619555SNOS',''),
(1616,0,2,'227_PZL620555SNO2','0','brak_obrazka.jpg',NULL,'146.3400','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'9.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL620555SNO2',''),
(1617,0,50,'227_PZL620555SNOH','0','brak_obrazka.jpg',NULL,'146.3400','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'9.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL620555SNOH',''),
(1618,0,10,'227_PZL620555SNOS','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:25:56','2017-09-25 10:25:56',NULL,'9.7600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452944','227_PZL620555SNOS',''),
(1619,0,40,'227_PZL620555SNOT','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL,'9.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452630','227_PZL620555SNOT',''),
(1620,0,1,'227_PZL621555SNOS','0','brak_obrazka.jpg',NULL,'150.4100','0.0000','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL,'10.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452791','227_PZL621555SNOS',''),
(1621,0,50,'227_PZL621560SNOT','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL,'10.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452999','227_PZL621560SNOT','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1622,0,16,'227_PZL621565SNOT','0','brak_obrazka.jpg',NULL,'178.8600','0.0000','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL,'10.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452661','227_PZL621565SNOT',''),
(1623,0,12,'227_PZL622555SNOS','0','brak_obrazka.jpg',NULL,'179.6700','0.0000','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL,'11.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452807','227_PZL622555SNOS',''),
(1624,0,4,'227_PZL622560SNOT','0','brak_obrazka.jpg',NULL,'178.8600','0.0000','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL,'11.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL622560SNOT',''),
(1625,0,22,'227_PZL622565SNOT','0','brak_obrazka.jpg',NULL,'197.5600','0.0000','2017-09-25 10:25:57','2017-09-25 10:25:57',NULL,'12.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL622565SNOT',''),
(1626,0,20,'227_PZL622570SNOT','0','brak_obrazka.jpg',NULL,'215.4500','0.0000','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL,'13.3700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451398','227_PZL622570SNOT',''),
(1627,0,16,'227_PZL622575SNOT','0','brak_obrazka.jpg',NULL,'278.0500','0.0000','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL,'15.8800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452715','227_PZL622575SNOT',''),
(1628,0,8,'227_PZL623565SNOT','0','brak_obrazka.jpg',NULL,'212.2000','0.0000','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL,'12.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_PZL623565SNOT',''),
(1629,0,12,'227_PZL623570SNOT','0','brak_obrazka.jpg',NULL,'221.9500','0.0000','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL,'13.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452722','227_PZL623570SNOT',''),
(1630,0,2,'227_PZL624570SNOT','0','brak_obrazka.jpg',NULL,'240.6500','0.0000','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL,'14.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451695','227_PZL624570SNOT',''),
(1631,0,2,'227_PZL624575SNOT','0','brak_obrazka.jpg',NULL,'313.0100','0.0000','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL,'18.4800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452739','227_PZL624575SNOT',''),
(1632,0,20,'227_PZL626570SNOT','0','brak_obrazka.jpg',NULL,'266.6700','0.0000','2017-09-25 10:25:58','2017-09-25 10:25:58',NULL,'15.8700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451879','227_PZL626570SNOT',''),
(1633,0,12,'227_PZL721550SNOS','0','brak_obrazka.jpg',NULL,'182.9300','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'10.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451909','227_PZL721550SNOS',''),
(1634,0,6,'227_PZL721555SNOS','0','brak_obrazka.jpg',NULL,'179.6700','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'10.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452821','227_PZL721555SNOS',''),
(1635,0,36,'227_PZL721560SNOT','0','brak_obrazka.jpg',NULL,'189.4300','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452746','227_PZL721560SNOT',''),
(1636,0,10,'227_PZL722545SNOS','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'10.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452838','227_PZL722545SNOS',''),
(1637,0,28,'227_PZL722550SNOS','0','brak_obrazka.jpg',NULL,'180.4900','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'11.3400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452845','227_PZL722550SNOS',''),
(1638,0,18,'227_PZL722555SNOS','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451299','227_PZL722555SNOS',''),
(1639,0,20,'227_PZL722565SNOT','0','brak_obrazka.jpg',NULL,'204.8800','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'12.4600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452760','227_PZL722565SNOT',''),
(1640,0,20,'227_PZL723545SNOS','0','brak_obrazka.jpg',NULL,'181.3000','0.0000','2017-09-25 10:25:59','2017-09-25 10:25:59',NULL,'10.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452852','227_PZL723545SNOS',''),
(1641,0,8,'227_PZL723555SNOS','0','brak_obrazka.jpg',NULL,'204.0700','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'13.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451466','227_PZL723555SNOS','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1642,0,10,'227_PZL723565SNOT','0','brak_obrazka.jpg',NULL,'229.2700','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'13.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451565','227_PZL723565SNOT',''),
(1643,0,12,'227_PZL724565SNOT','0','brak_obrazka.jpg',NULL,'252.0300','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'14.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451664','227_PZL724565SNOT',''),
(1644,0,22,'227_PZL726565SNOT','0','brak_obrazka.jpg',NULL,'281.3000','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'18.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451855','227_PZL726565SNOT',''),
(1645,0,12,'227_PZL726570SNOT','0','brak_obrazka.jpg',NULL,'285.3700','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'16.4400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149451893','227_PZL726570SNOT',''),
(1646,0,12,'227_PZL822540SNOS','0','brak_obrazka.jpg',NULL,'172.3600','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'10.1100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452869','227_PZL822540SNOS',''),
(1647,0,16,'227_PZL823560SNOS','0','brak_obrazka.jpg',NULL,'229.2700','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'14.0300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452890','227_PZL823560SNOS',''),
(1648,0,16,'227_PZL824545SNOS','0','brak_obrazka.jpg',NULL,'216.2600','0.0000','2017-09-25 10:26:00','2017-09-25 10:26:00',NULL,'12.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452876','227_PZL824545SNOS',''),
(1649,0,20,'227_PZL824560SNOS','0','brak_obrazka.jpg',NULL,'259.3500','0.0000','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL,'14.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452906','227_PZL824560SNOS',''),
(1650,0,12,'227_PZL825555SNOS','0','brak_obrazka.jpg',NULL,'257.7200','0.0000','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL,'15.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452913','227_PZL825555SNOS',''),
(1651,0,2,'227_PZL925555SNOS','0','brak_obrazka.jpg',NULL,'298.3700','0.0000','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL,'15.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','6970149452937','227_PZL925555SNOS',''),
(1652,0,15,'227_SARSTRAP_____','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL,'0.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SARSTRAP_____',''),
(1653,0,50,'227_SIC5311050MT_','0','brak_obrazka.jpg',NULL,'569.1100','0.0000','2017-09-25 10:26:01','2017-09-25 10:26:01',NULL,'20.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104621','227_SIC5311050MT_',''),
(1654,0,40,'227_SIC5311050MTS','0','brak_obrazka.jpg',NULL,'402.4400','0.0000','2017-09-25 10:26:02','2017-09-25 10:26:02',NULL,'21.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104140','227_SIC5311050MTS',''),
(1655,0,50,'227_SIC5331050MT_','0','brak_obrazka.jpg',NULL,'657.7200','0.0000','2017-09-25 10:26:02','2017-09-25 10:26:02',NULL,'25.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104638','227_SIC5331050MT_',''),
(1656,0,50,'227_SIC5351150MT_','0','brak_obrazka.jpg',NULL,'851.2200','0.0000','2017-09-25 10:26:02','2017-09-25 10:26:02',NULL,'27.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104645','227_SIC5351150MT_',''),
(1657,0,25,'227_SIC621575MT__','0','brak_obrazka.jpg',NULL,'304.0700','0.0000','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL,'14.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104102','227_SIC621575MT__',''),
(1658,0,46,'227_SIC624575MT__','0','brak_obrazka.jpg',NULL,'358.5400','0.0000','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL,'18.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104164','227_SIC624575MT__',''),
(1659,0,43,'227_SIC627570MT__','0','brak_obrazka.jpg',NULL,'417.8900','0.0000','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL,'21.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104119','227_SIC627570MT__',''),
(1660,0,2,'227_SIC628575MT__','0','brak_obrazka.jpg',NULL,'503.2500','0.0000','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL,'27.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104133','227_SIC628575MT__',''),
(1661,0,14,'227_SIC628585MT__','0','brak_obrazka.jpg',NULL,'476.4200','0.0000','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL,'24.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104584','227_SIC628585MT__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1662,0,4,'227_SIC628585MTTT','0','brak_obrazka.jpg',NULL,'492.6800','0.0000','2017-09-25 10:26:03','2017-09-25 10:26:03',NULL,'27.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SIC628585MTTT',''),
(1663,0,50,'227_SIC6311050MT_','0','brak_obrazka.jpg',NULL,'455.2800','0.0000','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL,'18.9500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104591','227_SIC6311050MT_',''),
(1664,0,50,'227_SIC6331050MT_','0','brak_obrazka.jpg',NULL,'719.5100','0.0000','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL,'23.4300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SIC6331050MT_',''),
(1665,0,34,'227_SIC633950MT__','0','brak_obrazka.jpg',NULL,'611.3800','0.0000','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL,'19.9200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','955541110469','227_SIC633950MT__',''),
(1666,0,50,'227_SIC6351050MT_','0','brak_obrazka.jpg',NULL,'767.4800','0.0000','2017-09-25 10:26:04','2017-09-25 10:26:04',NULL,'28.1300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104652','227_SIC6351050MT_',''),
(1667,0,50,'227_SIC6351150MT_','0','brak_obrazka.jpg',NULL,'839.0200','0.0000','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL,'28.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411104669','227_SIC6351150MT_',''),
(1668,0,7,'227_SIL316560PB__','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SIL316560PB__',''),
(1669,0,18,'227_SIL316575SM3_','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL,'6.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411100036','227_SIL316575SM3_',''),
(1670,0,12,'227_SIL318560SM3_','0','brak_obrazka.jpg',NULL,'120.3300','0.0000','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL,'7.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411100067','227_SIL318560SM3_',''),
(1671,0,2,'227_SIL516550EVOL','0','brak_obrazka.jpg',NULL,'138.2100','0.0000','2017-09-25 10:26:05','2017-09-25 10:26:05',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411100500','227_SIL516550EVOL',''),
(1672,0,20,'227_SIL517559EVOL','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','9555411100753','227_SIL517559EVOL',''),
(1673,0,12,'227_SIS526570EST_','0','brak_obrazka.jpg',NULL,'284.5500','0.0000','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL,'16.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SIS526570EST_',''),
(1674,0,4,'227_SIS924555EST_','0','brak_obrazka.jpg',NULL,'291.8700','0.0000','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL,'15.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SIS924555EST_',''),
(1675,0,50,'227_SUG51171K001_','0','brak_obrazka.jpg',NULL,'61.7900','0.0000','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL,'1.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUG51171K001_',''),
(1676,0,50,'227_SUI4410R015__','0','brak_obrazka.jpg',NULL,'35.7700','0.0000','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL,'0.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI4410R015__',''),
(1677,0,13,'227_SUI613500R015','0','brak_obrazka.jpg',NULL,'51.2200','0.0000','2017-09-25 10:26:06','2017-09-25 10:26:06',NULL,'1.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI613500R015',''),
(1678,0,50,'227_SUI613500R016','0','brak_obrazka.jpg',NULL,'38.2100','0.0000','2017-09-25 10:26:07','2017-09-25 10:26:07',NULL,'1.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI613500R016',''),
(1679,0,35,'227_SUI613650R010','0','brak_obrazka.jpg',NULL,'47.1500','0.0000','2017-09-25 10:26:07','2017-09-25 10:26:07',NULL,'2.0600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI613650R010',''),
(1680,0,45,'227_SUI613650R011','0','brak_obrazka.jpg',NULL,'47.1500','0.0000','2017-09-25 10:26:07','2017-09-25 10:26:07',NULL,'1.9900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI613650R011',''),
(1681,0,50,'227_SUI613650R012','0','brak_obrazka.jpg',NULL,'47.1500','0.0000','2017-09-25 10:26:08','2017-09-25 10:26:08',NULL,'2.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI613650R012','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1682,0,24,'227_SUI616650R016','0','brak_obrazka.jpg',NULL,'54.4700','0.0000','2017-09-25 10:26:08','2017-09-25 10:26:08',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI616650R016',''),
(1683,0,50,'227_SUI6410R015__','0','brak_obrazka.jpg',NULL,'42.2800','0.0000','2017-09-25 10:26:08','2017-09-25 10:26:08',NULL,'1.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI6410R015__',''),
(1684,0,42,'227_SUI818585T005','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL,'5.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI818585T005',''),
(1685,0,20,'227_SUI820800R013','0','brak_obrazka.jpg',NULL,'105.6900','0.0000','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUI820800R013',''),
(1686,0,14,'227_SUM180100B002','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM180100B002',''),
(1687,0,25,'227_SUM180100B003','0','brak_obrazka.jpg',NULL,'91.0600','0.0000','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM180100B003',''),
(1688,0,29,'227_SUM180100B004','0','brak_obrazka.jpg',NULL,'91.0600','0.0000','2017-09-25 10:26:09','2017-09-25 10:26:09',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM180100B004',''),
(1689,0,15,'227_SUM8100100B01','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:26:10','2017-09-25 10:26:10',NULL,'6.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM8100100B01',''),
(1690,0,12,'227_SUM812090B003','0','brak_obrazka.jpg',NULL,'156.9100','0.0000','2017-09-25 10:26:10','2017-09-25 10:26:10',NULL,'6.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM812090B003',''),
(1691,0,17,'227_SUM910090B003','0','brak_obrazka.jpg',NULL,'134.9600','0.0000','2017-09-25 10:26:10','2017-09-25 10:26:10',NULL,'5.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM910090B003',''),
(1692,0,14,'227_SUM911090B001','0','brak_obrazka.jpg',NULL,'152.8500','0.0000','2017-09-25 10:26:11','2017-09-25 10:26:11',NULL,'6.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM911090B001',''),
(1693,0,5,'227_SUM912090B003','0','brak_obrazka.jpg',NULL,'158.5400','0.0000','2017-09-25 10:26:11','2017-09-25 10:26:11',NULL,'5.9500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUM912090B003',''),
(1694,0,22,'227_SUQ019600A021','0','brak_obrazka.jpg',NULL,'139.0200','0.0000','2017-09-25 10:26:11','2017-09-25 10:26:11',NULL,'4.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ019600A021',''),
(1695,0,25,'227_SUQ020.57A021','0','brak_obrazka.jpg',NULL,'135.7700','0.0000','2017-09-25 10:26:11','2017-09-25 10:26:11',NULL,'4.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ020.57A021',''),
(1696,0,29,'227_SUQ02010A004_','0','brak_obrazka.jpg',NULL,'157.7200','0.0000','2017-09-25 10:26:11','2017-09-25 10:26:11',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02010A004_',''),
(1697,0,50,'227_SUQ02010A021_','0','brak_obrazka.jpg',NULL,'181.3000','0.0000','2017-09-25 10:26:12','2017-09-25 10:26:12',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02010A021_',''),
(1698,0,50,'227_SUQ020550A021','0','brak_obrazka.jpg',NULL,'145.5300','0.0000','2017-09-25 10:26:12','2017-09-25 10:26:12',NULL,'4.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ020550A021',''),
(1699,0,28,'227_SUQ02060A031F','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:26:12','2017-09-25 10:26:12',NULL,'4.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02060A031F',''),
(1700,0,34,'227_SUQ02060A035F','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:26:12','2017-09-25 10:26:12',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02060A035F',''),
(1701,0,50,'227_SUQ021700A001','0','brak_obrazka.jpg',NULL,'143.9000','0.0000','2017-09-25 10:26:13','2017-09-25 10:26:13',NULL,'5.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ021700A001','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1702,0,50,'227_SUQ021700A021','0','brak_obrazka.jpg',NULL,'146.3400','0.0000','2017-09-25 10:26:13','2017-09-25 10:26:13',NULL,'4.9400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ021700A021',''),
(1703,0,31,'227_SUQ02170A027F','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:26:14','2017-09-25 10:26:14',NULL,'5.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02170A027F',''),
(1704,0,38,'227_SUQ0217A031F_','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:26:14','2017-09-25 10:26:14',NULL,'5.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ0217A031F_',''),
(1705,0,50,'227_SUQ022100A021','0','brak_obrazka.jpg',NULL,'213.0100','0.0000','2017-09-25 10:26:15','2017-09-25 10:26:15',NULL,'7.1800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ022100A021',''),
(1706,0,50,'227_SUQ02210A001_','0','brak_obrazka.jpg',NULL,'204.0700','0.0000','2017-09-25 10:26:15','2017-09-25 10:26:15',NULL,'7.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02210A001_',''),
(1707,0,16,'227_SUQ02210A006_','0','brak_obrazka.jpg',NULL,'176.4200','0.0000','2017-09-25 10:26:15','2017-09-25 10:26:15',NULL,'6.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02210A006_',''),
(1708,0,15,'227_SUQ02210A008_','0','brak_obrazka.jpg',NULL,'175.6100','0.0000','2017-09-25 10:26:15','2017-09-25 10:26:15',NULL,'6.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02210A008_',''),
(1709,0,50,'227_SUQ02210A027R','0','brak_obrazka.jpg',NULL,'200.8100','0.0000','2017-09-25 10:26:17','2017-09-25 10:26:17',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02210A027R',''),
(1710,0,32,'227_SUQ02210A028_','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:26:17','2017-09-25 10:26:17',NULL,'7.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02210A028_',''),
(1711,0,50,'227_SUQ02211A005_','0','brak_obrazka.jpg',NULL,'218.7000','0.0000','2017-09-25 10:26:17','2017-09-25 10:26:17',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02211A005_',''),
(1712,0,14,'227_SUQ022545A021','0','brak_obrazka.jpg',NULL,'152.0300','0.0000','2017-09-25 10:26:18','2017-09-25 10:26:18',NULL,'5.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ022545A021',''),
(1713,0,50,'227_SUQ022700A021','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:26:18','2017-09-25 10:26:18',NULL,'5.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ022700A021',''),
(1714,0,36,'227_SUQ02270A027F','0','brak_obrazka.jpg',NULL,'152.0300','0.0000','2017-09-25 10:26:18','2017-09-25 10:26:18',NULL,'5.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02270A027F',''),
(1715,0,8,'227_SUQ023700A007','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:26:18','2017-09-25 10:26:18',NULL,'5.3800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ023700A007',''),
(1716,0,50,'227_SUQ02370A021_','0','brak_obrazka.jpg',NULL,'185.3700','0.0000','2017-09-25 10:26:19','2017-09-25 10:26:19',NULL,'5.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02370A021_',''),
(1717,0,50,'227_SUQ02370A027_','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:26:20','2017-09-25 10:26:20',NULL,'5.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02370A027_',''),
(1718,0,18,'227_SUQ02370A028_','0','brak_obrazka.jpg',NULL,'127.6400','0.0000','2017-09-25 10:26:20','2017-09-25 10:26:20',NULL,'5.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02370A028_',''),
(1719,0,1,'227_SUQ02411A033_','0','brak_obrazka.jpg',NULL,'300.0000','0.0000','2017-09-25 10:26:20','2017-09-25 10:26:20',NULL,'11.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02411A033_',''),
(1720,0,20,'227_SUQ02511A033_','0','brak_obrazka.jpg',NULL,'306.5000','0.0000','2017-09-25 10:26:21','2017-09-25 10:26:21',NULL,'10.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ02511A033_',''),
(1721,0,19,'227_SUQ12410A033_','0','brak_obrazka.jpg',NULL,'284.5500','0.0000','2017-09-25 10:26:21','2017-09-25 10:26:21',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ12410A033_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1722,0,17,'227_SUQ12410A041_','0','brak_obrazka.jpg',NULL,'266.6700','0.0000','2017-09-25 10:26:21','2017-09-25 10:26:21',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ12410A041_',''),
(1723,0,11,'227_SUQ223530A034','0','brak_obrazka.jpg',NULL,'171.5400','0.0000','2017-09-25 10:26:22','2017-09-25 10:26:22',NULL,'4.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ223530A034',''),
(1724,0,12,'227_SUQ223530A039','0','brak_obrazka.jpg',NULL,'196.7500','0.0000','2017-09-25 10:26:22','2017-09-25 10:26:22',NULL,'4.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ223530A039',''),
(1725,0,18,'227_SUQ224800A041','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:26:23','2017-09-25 10:26:23',NULL,'7.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ224800A041',''),
(1726,0,1,'227_SUQ22480A001_','0','brak_obrazka.jpg',NULL,'187.8000','0.0000','2017-09-25 10:26:23','2017-09-25 10:26:23',NULL,'7.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22480A001_',''),
(1727,0,20,'227_SUQ22480A033_','0','brak_obrazka.jpg',NULL,'208.9400','0.0000','2017-09-25 10:26:24','2017-09-25 10:26:24',NULL,'7.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22480A033_',''),
(1728,0,50,'227_SUQ22510A010_','0','brak_obrazka.jpg',NULL,'230.8900','0.0000','2017-09-25 10:26:25','2017-09-25 10:26:25',NULL,'9.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A010_',''),
(1729,0,2,'227_SUQ22510A021_','0','brak_obrazka.jpg',NULL,'255.2800','0.0000','2017-09-25 10:26:25','2017-09-25 10:26:25',NULL,'8.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A021_',''),
(1730,0,32,'227_SUQ22510A032_','0','brak_obrazka.jpg',NULL,'262.6000','0.0000','2017-09-25 10:26:27','2017-09-25 10:26:27',NULL,'10.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A032_',''),
(1731,0,50,'227_SUQ22510A033_','0','brak_obrazka.jpg',NULL,'280.4900','0.0000','2017-09-25 10:26:27','2017-09-25 10:26:27',NULL,'11.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A033_',''),
(1732,0,29,'227_SUQ22510A041_','0','brak_obrazka.jpg',NULL,'295.1200','0.0000','2017-09-25 10:26:27','2017-09-25 10:26:27',NULL,'11.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A041_',''),
(1733,0,20,'227_SUQ22510A043_','0','brak_obrazka.jpg',NULL,'324.3900','0.0000','2017-09-25 10:26:28','2017-09-25 10:26:28',NULL,'11.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A043_',''),
(1734,0,50,'227_SUQ22510A048_','0','brak_obrazka.jpg',NULL,'277.2400','0.0000','2017-09-25 10:26:28','2017-09-25 10:26:28',NULL,'11.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A048_',''),
(1735,0,19,'227_SUQ22510A050_','0','brak_obrazka.jpg',NULL,'266.6700','0.0000','2017-09-25 10:26:28','2017-09-25 10:26:28',NULL,'11.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22510A050_',''),
(1736,0,1,'227_SUQ22511A010_','0','brak_obrazka.jpg',NULL,'259.3500','0.0000','2017-09-25 10:26:28','2017-09-25 10:26:28',NULL,'9.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22511A010_',''),
(1737,0,50,'227_SUQ225800A010','0','brak_obrazka.jpg',NULL,'184.5500','0.0000','2017-09-25 10:26:29','2017-09-25 10:26:29',NULL,'6.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ225800A010',''),
(1738,0,34,'227_SUQ225800A041','0','brak_obrazka.jpg',NULL,'247.9700','0.0000','2017-09-25 10:26:29','2017-09-25 10:26:29',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ225800A041',''),
(1739,0,21,'227_SUQ225800A043','0','brak_obrazka.jpg',NULL,'269.9200','0.0000','2017-09-25 10:26:30','2017-09-25 10:26:30',NULL,'9.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ225800A043',''),
(1740,0,50,'227_SUQ225800A048','0','brak_obrazka.jpg',NULL,'248.7800','0.0000','2017-09-25 10:26:30','2017-09-25 10:26:30',NULL,'9.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ225800A048',''),
(1741,0,21,'227_SUQ22580A032_','0','brak_obrazka.jpg',NULL,'201.6300','0.0000','2017-09-25 10:26:30','2017-09-25 10:26:30',NULL,'7.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22580A032_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1742,0,50,'227_SUQ22580A033_','0','brak_obrazka.jpg',NULL,'240.6500','0.0000','2017-09-25 10:26:30','2017-09-25 10:26:30',NULL,'9.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22580A033_',''),
(1743,0,19,'227_SUQ2258A050__','0','brak_obrazka.jpg',NULL,'228.4600','0.0000','2017-09-25 10:26:31','2017-09-25 10:26:31',NULL,'9.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ2258A050__',''),
(1744,0,17,'227_SUQ22610A033_','0','brak_obrazka.jpg',NULL,'330.0800','0.0000','2017-09-25 10:26:31','2017-09-25 10:26:31',NULL,'11.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22610A033_',''),
(1745,0,17,'227_SUQ22611A033_','0','brak_obrazka.jpg',NULL,'353.6600','0.0000','2017-09-25 10:26:31','2017-09-25 10:26:31',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22611A033_',''),
(1746,0,18,'227_SUQ22611A043_','0','brak_obrazka.jpg',NULL,'352.8500','0.0000','2017-09-25 10:26:31','2017-09-25 10:26:31',NULL,'13.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22611A043_',''),
(1747,0,23,'227_SUQ22611A048_','0','brak_obrazka.jpg',NULL,'326.0200','0.0000','2017-09-25 10:26:31','2017-09-25 10:26:31',NULL,'13.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22611A048_',''),
(1748,0,20,'227_SUQ22680A033_','0','brak_obrazka.jpg',NULL,'295.9300','0.0000','2017-09-25 10:26:31','2017-09-25 10:26:31',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22680A033_',''),
(1749,0,23,'227_SUQ226900A033','0','brak_obrazka.jpg',NULL,'299.1900','0.0000','2017-09-25 10:26:32','2017-09-25 10:26:32',NULL,'10.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ226900A033',''),
(1750,0,26,'227_SUQ226900A043','0','brak_obrazka.jpg',NULL,'324.3900','0.0000','2017-09-25 10:26:33','2017-09-25 10:26:33',NULL,'11.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ226900A043',''),
(1751,0,4,'227_SUQ226900A048','0','brak_obrazka.jpg',NULL,'273.1700','0.0000','2017-09-25 10:26:33','2017-09-25 10:26:33',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ226900A048',''),
(1752,0,28,'227_SUQ2269A048__','0','brak_obrazka.jpg',NULL,'290.2400','0.0000','2017-09-25 10:26:33','2017-09-25 10:26:33',NULL,'10.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ2269A048__',''),
(1753,0,25,'227_SUQ22710A050_','0','brak_obrazka.jpg',NULL,'353.6600','0.0000','2017-09-25 10:26:34','2017-09-25 10:26:34',NULL,'14.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22710A050_',''),
(1754,0,23,'227_SUQ22711A048_','0','brak_obrazka.jpg',NULL,'328.4600','0.0000','2017-09-25 10:26:34','2017-09-25 10:26:34',NULL,'15.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22711A048_',''),
(1755,0,3,'227_SUQ22712A033_','0','brak_obrazka.jpg',NULL,'415.4500','0.0000','2017-09-25 10:26:35','2017-09-25 10:26:35',NULL,'15.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22712A033_',''),
(1756,0,29,'227_SUQ22712A050_','0','brak_obrazka.jpg',NULL,'381.3000','0.0000','2017-09-25 10:26:35','2017-09-25 10:26:35',NULL,'15.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22712A050_',''),
(1757,0,12,'227_SUQ22790A033_','0','brak_obrazka.jpg',NULL,'321.1400','0.0000','2017-09-25 10:26:35','2017-09-25 10:26:35',NULL,'12.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22790A033_',''),
(1758,0,28,'227_SUQ2279A048__','0','brak_obrazka.jpg',NULL,'299.1900','0.0000','2017-09-25 10:26:36','2017-09-25 10:26:36',NULL,'12.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ2279A048__',''),
(1759,0,28,'227_SUQ22810A050_','0','brak_obrazka.jpg',NULL,'392.6800','0.0000','2017-09-25 10:26:37','2017-09-25 10:26:37',NULL,'15.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22810A050_',''),
(1760,0,32,'227_SUQ22812A050_','0','brak_obrazka.jpg',NULL,'401.6300','0.0000','2017-09-25 10:26:38','2017-09-25 10:26:38',NULL,'15.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ22812A050_',''),
(1761,0,19,'227_SUQ418530A034','0','brak_obrazka.jpg',NULL,'210.5700','0.0000','2017-09-25 10:26:38','2017-09-25 10:26:38',NULL,'5.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ418530A034','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1762,0,19,'227_SUQ42611A033_','0','brak_obrazka.jpg',NULL,'369.1100','0.0000','2017-09-25 10:26:39','2017-09-25 10:26:39',NULL,'13.2500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ42611A033_',''),
(1763,0,7,'227_SUQ42611A043_','0','brak_obrazka.jpg',NULL,'357.7200','0.0000','2017-09-25 10:26:39','2017-09-25 10:26:39',NULL,'13.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ42611A043_',''),
(1764,0,3,'227_SUQ426800A021','0','brak_obrazka.jpg',NULL,'247.1500','0.0000','2017-09-25 10:26:39','2017-09-25 10:26:39',NULL,'10.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ426800A021',''),
(1765,0,2,'227_SUQ426900A043','0','brak_obrazka.jpg',NULL,'315.4500','0.0000','2017-09-25 10:26:40','2017-09-25 10:26:40',NULL,'11.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ426900A043',''),
(1766,0,15,'227_SUQ42690A033_','0','brak_obrazka.jpg',NULL,'327.6400','0.0000','2017-09-25 10:26:40','2017-09-25 10:26:40',NULL,'10.7500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ42690A033_',''),
(1767,0,3,'227_SUQ427030A034','0','brak_obrazka.jpg',NULL,'280.4900','0.0000','2017-09-25 10:26:40','2017-09-25 10:26:40',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ427030A034',''),
(1768,0,4,'227_SUQ42711A033_','0','brak_obrazka.jpg',NULL,'386.9900','0.0000','2017-09-25 10:26:40','2017-09-25 10:26:40',NULL,'15.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ42711A033_',''),
(1769,0,1,'227_SUQ42790A033_','0','brak_obrazka.jpg',NULL,'330.8900','0.0000','2017-09-25 10:26:42','2017-09-25 10:26:42',NULL,'13.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ42790A033_',''),
(1770,0,7,'227_SUQ42810A047P','0','brak_obrazka.jpg',NULL,'447.1500','0.0000','2017-09-25 10:26:42','2017-09-25 10:26:42',NULL,'16.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ42810A047P',''),
(1771,0,26,'227_SUQ42911A033_','0','brak_obrazka.jpg',NULL,'466.6700','0.0000','2017-09-25 10:26:42','2017-09-25 10:26:42',NULL,'17.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ42911A033_',''),
(1772,0,18,'227_SUQ429900A033','0','brak_obrazka.jpg',NULL,'423.5800','0.0000','2017-09-25 10:26:42','2017-09-25 10:26:42',NULL,'15.6000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ429900A033',''),
(1773,0,2,'227_SUQ43010A045_','0','brak_obrazka.jpg',NULL,'420.3300','0.0000','2017-09-25 10:26:43','2017-09-25 10:26:43',NULL,'15.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ43010A045_',''),
(1774,0,10,'227_SUQ53010A047P','0','brak_obrazka.jpg',NULL,'441.4600','0.0000','2017-09-25 10:26:43','2017-09-25 10:26:43',NULL,'16.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ53010A047P',''),
(1775,0,50,'227_SUQ716800A004','0','brak_obrazka.jpg',NULL,'94.3100','0.0000','2017-09-25 10:26:43','2017-09-25 10:26:43',NULL,'3.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ716800A004',''),
(1776,0,50,'227_SUQ716800A021','0','brak_obrazka.jpg',NULL,'99.1900','0.0000','2017-09-25 10:26:44','2017-09-25 10:26:44',NULL,'3.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ716800A021',''),
(1777,0,50,'227_SUQ71680A011_','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:26:44','2017-09-25 10:26:44',NULL,'3.0200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ71680A011_',''),
(1778,0,22,'227_SUQ81810A031R','0','brak_obrazka.jpg',NULL,'165.0400','0.0000','2017-09-25 10:26:44','2017-09-25 10:26:44',NULL,'5.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ81810A031R',''),
(1779,0,5,'227_SUQ81810A035R','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:26:44','2017-09-25 10:26:44',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ81810A035R',''),
(1780,0,18,'227_SUQ818950A003','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:26:44','2017-09-25 10:26:44',NULL,'5.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ818950A003',''),
(1781,0,20,'227_SUQ818950A016','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:26:44','2017-09-25 10:26:44',NULL,'4.7200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ818950A016','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1782,0,50,'227_SUQ818950A018','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:26:45','2017-09-25 10:26:45',NULL,'4.8200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ818950A018',''),
(1783,0,50,'227_SUQ818950A021','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:26:45','2017-09-25 10:26:45',NULL,'4.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ818950A021',''),
(1784,0,50,'227_SUQ819700A003','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:26:45','2017-09-25 10:26:45',NULL,'4.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ819700A003',''),
(1785,0,50,'227_SUQ819700A021','0','brak_obrazka.jpg',NULL,'130.0800','0.0000','2017-09-25 10:26:46','2017-09-25 10:26:46',NULL,'4.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ819700A021',''),
(1786,0,18,'227_SUQ81970A004_','0','brak_obrazka.jpg',NULL,'102.4400','0.0000','2017-09-25 10:26:46','2017-09-25 10:26:46',NULL,'3.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ81970A004_',''),
(1787,0,44,'227_SUQ819950A003','0','brak_obrazka.jpg',NULL,'160.1600','0.0000','2017-09-25 10:26:47','2017-09-25 10:26:47',NULL,'5.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ819950A003',''),
(1788,0,1,'227_SUQ82010A003_','0','brak_obrazka.jpg',NULL,'161.7900','0.0000','2017-09-25 10:26:47','2017-09-25 10:26:47',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ82010A003_',''),
(1789,0,31,'227_SUQ82011A027_','0','brak_obrazka.jpg',NULL,'203.2500','0.0000','2017-09-25 10:26:47','2017-09-25 10:26:47',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ82011A027_',''),
(1790,0,27,'227_SUQ820700A007','0','brak_obrazka.jpg',NULL,'113.0100','0.0000','2017-09-25 10:26:48','2017-09-25 10:26:48',NULL,'4.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ820700A007',''),
(1791,0,50,'227_SUQ820700A021','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:26:48','2017-09-25 10:26:48',NULL,'4.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ820700A021',''),
(1792,0,1,'227_SUQ820700A029','0','brak_obrazka.jpg',NULL,'113.8200','0.0000','2017-09-25 10:26:48','2017-09-25 10:26:48',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ820700A029',''),
(1793,0,24,'227_SUQ821700A003','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:26:48','2017-09-25 10:26:48',NULL,'5.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ821700A003',''),
(1794,0,50,'227_SUQ822100A021','0','brak_obrazka.jpg',NULL,'185.3700','0.0000','2017-09-25 10:26:49','2017-09-25 10:26:49',NULL,'7.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ822100A021',''),
(1795,0,12,'227_SUQ82210A030_','0','brak_obrazka.jpg',NULL,'156.9100','0.0000','2017-09-25 10:26:49','2017-09-25 10:26:49',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ82210A030_',''),
(1796,0,27,'227_SUQ82211A011_','0','brak_obrazka.jpg',NULL,'209.7600','0.0000','2017-09-25 10:26:50','2017-09-25 10:26:50',NULL,'7.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ82211A011_',''),
(1797,0,50,'227_SUQ920100A021','0','brak_obrazka.jpg',NULL,'179.6700','0.0000','2017-09-25 10:26:51','2017-09-25 10:26:51',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ920100A021',''),
(1798,0,50,'227_SUQ92010A027_','0','brak_obrazka.jpg',NULL,'191.0600','0.0000','2017-09-25 10:26:51','2017-09-25 10:26:51',NULL,'7.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92010A027_',''),
(1799,0,50,'227_SUQ92011A027R','0','brak_obrazka.jpg',NULL,'204.8800','0.0000','2017-09-25 10:26:51','2017-09-25 10:26:51',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92011A027R',''),
(1800,0,36,'227_SUQ92011A031_','0','brak_obrazka.jpg',NULL,'184.5500','0.0000','2017-09-25 10:26:52','2017-09-25 10:26:52',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92011A031_',''),
(1801,0,28,'227_SUQ92011A035R','0','brak_obrazka.jpg',NULL,'163.4100','0.0000','2017-09-25 10:26:53','2017-09-25 10:26:53',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92011A035R','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1802,0,50,'227_SUQ92210A027R','0','brak_obrazka.jpg',NULL,'209.7600','0.0000','2017-09-25 10:26:53','2017-09-25 10:26:53',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92210A027R',''),
(1803,0,36,'227_SUQ92211A027R','0','brak_obrazka.jpg',NULL,'252.0300','0.0000','2017-09-25 10:26:53','2017-09-25 10:26:53',NULL,'6.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92211A027R',''),
(1804,0,41,'227_SUQ92211A031_','0','brak_obrazka.jpg',NULL,'213.0100','0.0000','2017-09-25 10:26:54','2017-09-25 10:26:54',NULL,'6.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92211A031_',''),
(1805,0,28,'227_SUQ92212A028_','0','brak_obrazka.jpg',NULL,'252.8500','0.0000','2017-09-25 10:26:54','2017-09-25 10:26:54',NULL,'12.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ92212A028_',''),
(1806,0,12,'227_SUQ922545A021','0','brak_obrazka.jpg',NULL,'144.7200','0.0000','2017-09-25 10:26:54','2017-09-25 10:26:54',NULL,'5.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUQ922545A021',''),
(1807,0,42,'227_SUS0350D002__','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:26:55','2017-09-25 10:26:55',NULL,'2.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUS0350D002__',''),
(1808,0,39,'227_SUS212070D06X','0','brak_obrazka.jpg',NULL,'76.4200','0.0000','2017-09-25 10:26:55','2017-09-25 10:26:55',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUS212070D06X',''),
(1809,0,6,'227_SUS311090D009','0','brak_obrazka.jpg',NULL,'112.2000','0.0000','2017-09-25 10:26:55','2017-09-25 10:26:55',NULL,'4.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUS311090D009',''),
(1810,0,7,'227_SUS313060D009','0','brak_obrazka.jpg',NULL,'98.3700','0.0000','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUS313060D009',''),
(1811,0,30,'227_SUS313060D06X','0','brak_obrazka.jpg',NULL,'78.8600','0.0000','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUS313060D06X',''),
(1812,0,9,'227_SUS314060D009','0','brak_obrazka.jpg',NULL,'104.0700','0.0000','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_SUS314060D009',''),
(1813,0,14,'227_UA1U66 0005B_','0','brak_obrazka.jpg',NULL,'47.9700','0.0000','2017-09-25 10:26:56','2017-09-25 10:26:56',NULL,'0.2100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA1U66 0005B_',''),
(1814,0,5,'227_UA401________','0','brak_obrazka.jpg',NULL,'264.2300','0.0000','2017-09-25 10:26:57','2017-09-25 10:26:57',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA401________',''),
(1815,0,17,'227_UA412________','0','brak_obrazka.jpg',NULL,'179.6700','0.0000','2017-09-25 10:26:57','2017-09-25 10:26:57',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA412________',''),
(1816,0,9,'227_UA413________','0','brak_obrazka.jpg',NULL,'196.7500','0.0000','2017-09-25 10:26:57','2017-09-25 10:26:57',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA413________',''),
(1817,0,3,'227_UA417________','0','brak_obrazka.jpg',NULL,'261.7900','0.0000','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA417________',''),
(1818,0,17,'227_UA419________','0','brak_obrazka.jpg',NULL,'292.6800','0.0000','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA419________',''),
(1819,0,7,'227_UA420________','0','brak_obrazka.jpg',NULL,'292.6800','0.0000','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL,'0.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA420________',''),
(1820,0,15,'227_UA422________','0','brak_obrazka.jpg',NULL,'270.7300','0.0000','2017-09-25 10:26:58','2017-09-25 10:26:58',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA422________',''),
(1821,0,3,'227_UA424________','0','brak_obrazka.jpg',NULL,'282.9300','0.0000','2017-09-25 10:26:59','2017-09-25 10:26:59',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA424________','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1822,0,15,'227_UA426________','0','brak_obrazka.jpg',NULL,'233.3300','0.0000','2017-09-25 10:26:59','2017-09-25 10:26:59',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA426________',''),
(1823,0,4,'227_UA435________','0','brak_obrazka.jpg',NULL,'260.9800','0.0000','2017-09-25 10:27:00','2017-09-25 10:27:00',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA435________',''),
(1824,0,10,'227_UA437________','0','brak_obrazka.jpg',NULL,'255.2800','0.0000','2017-09-25 10:27:00','2017-09-25 10:27:00',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA437________',''),
(1825,0,1,'227_UA438________','0','brak_obrazka.jpg',NULL,'270.7300','0.0000','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA438________',''),
(1826,0,6,'227_UA441________','0','brak_obrazka.jpg',NULL,'352.0300','0.0000','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL,'0.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA441________',''),
(1827,0,1,'227_UA443________','0','brak_obrazka.jpg',NULL,'264.2300','0.0000','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA443________',''),
(1828,0,7,'227_UA446________','0','brak_obrazka.jpg',NULL,'299.1900','0.0000','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA446________',''),
(1829,0,6,'227_UA448________','0','brak_obrazka.jpg',NULL,'295.1200','0.0000','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA448________',''),
(1830,0,8,'227_UA450________','0','brak_obrazka.jpg',NULL,'259.3500','0.0000','2017-09-25 10:27:01','2017-09-25 10:27:01',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA450________',''),
(1831,0,4,'227_UA453________','0','brak_obrazka.jpg',NULL,'198.3700','0.0000','2017-09-25 10:27:02','2017-09-25 10:27:02',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA453________',''),
(1832,0,2,'227_UA457________','0','brak_obrazka.jpg',NULL,'233.3300','0.0000','2017-09-25 10:27:02','2017-09-25 10:27:02',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA457________',''),
(1833,0,1,'227_UA461________','0','brak_obrazka.jpg',NULL,'312.2000','0.0000','2017-09-25 10:27:02','2017-09-25 10:27:02',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA461________',''),
(1834,0,2,'227_UA480________','0','brak_obrazka.jpg',NULL,'352.0300','0.0000','2017-09-25 10:27:03','2017-09-25 10:27:03',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UA480________',''),
(1835,0,2,'227_UAXS821______','0','brak_obrazka.jpg',NULL,'490.2400','0.0000','2017-09-25 10:27:04','2017-09-25 10:27:04',NULL,'0.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_UAXS821______',''),
(1836,0,50,'227_WAI014580WR68','0','brak_obrazka.jpg',NULL,'133.3300','0.0000','2017-09-25 10:27:05','2017-09-25 10:27:05',NULL,'5.0500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI014580WR68',''),
(1837,0,6,'227_WAI0145H1022_','0','brak_obrazka.jpg',NULL,'126.0200','0.0000','2017-09-25 10:27:06','2017-09-25 10:27:06',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI0145H1022_',''),
(1838,0,6,'227_WAI0145P803__','0','brak_obrazka.jpg',NULL,'84.5500','0.0000','2017-09-25 10:27:06','2017-09-25 10:27:06',NULL,'4.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI0145P803__',''),
(1839,0,28,'227_WAI0181050P32','0','brak_obrazka.jpg',NULL,'119.5100','0.0000','2017-09-25 10:27:06','2017-09-25 10:27:06',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI0181050P32',''),
(1840,0,50,'227_WAI019550P823','0','brak_obrazka.jpg',NULL,'164.2300','0.0000','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL,'6.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI019550P823',''),
(1841,0,50,'227_WAI019555WR68','0','brak_obrazka.jpg',NULL,'134.9600','0.0000','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL,'6.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI019555WR68','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1842,0,26,'227_WAI020100P512','0','brak_obrazka.jpg',NULL,'137.4000','0.0000','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL,'6.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI020100P512',''),
(1843,0,50,'227_WAI020550P825','0','brak_obrazka.jpg',NULL,'140.6500','0.0000','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL,'6.0100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI020550P825',''),
(1844,0,26,'227_WAI020580P825','0','brak_obrazka.jpg',NULL,'165.8500','0.0000','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL,'6.7900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI020580P825',''),
(1845,0,50,'227_WAI02058P815_','0','brak_obrazka.jpg',NULL,'155.2800','0.0000','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL,'7.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI02058P815_',''),
(1846,0,20,'227_WAI020800P332','0','brak_obrazka.jpg',NULL,'121.9500','0.0000','2017-09-25 10:27:07','2017-09-25 10:27:07',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI020800P332',''),
(1847,0,30,'227_WAI020800P512','0','brak_obrazka.jpg',NULL,'131.7100','0.0000','2017-09-25 10:27:08','2017-09-25 10:27:08',NULL,'5.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI020800P512',''),
(1848,0,16,'227_WAI022950P532','0','brak_obrazka.jpg',NULL,'193.5000','0.0000','2017-09-25 10:27:08','2017-09-25 10:27:08',NULL,'8.8400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI022950P532',''),
(1849,0,15,'227_WAI024120P532','0','brak_obrazka.jpg',NULL,'317.8900','0.0000','2017-09-25 10:27:08','2017-09-25 10:27:08',NULL,'12.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI024120P532',''),
(1850,0,2,'227_WAI0400H1021_','0','brak_obrazka.jpg',NULL,'96.7500','0.0000','2017-09-25 10:27:08','2017-09-25 10:27:08',NULL,'3.4900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI0400H1021_',''),
(1851,0,2,'227_WAI0400H8027_','0','brak_obrazka.jpg',NULL,'80.4900','0.0000','2017-09-25 10:27:09','2017-09-25 10:27:09',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI0400H8027_',''),
(1852,0,19,'227_WAI0500H80296','0','brak_obrazka.jpg',NULL,'123.5800','0.0000','2017-09-25 10:27:09','2017-09-25 10:27:09',NULL,'2.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI0500H80296',''),
(1853,0,13,'227_WAI215570WR68','0','brak_obrazka.jpg',NULL,'142.2800','0.0000','2017-09-25 10:27:09','2017-09-25 10:27:09',NULL,'6.5900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI215570WR68',''),
(1854,0,18,'227_WAI216570WR80','0','brak_obrazka.jpg',NULL,'90.2400','0.0000','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL,'5.8100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI216570WR80',''),
(1855,0,50,'227_WAI218560WR68','0','brak_obrazka.jpg',NULL,'175.6100','0.0000','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL,'7.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI218560WR68',''),
(1856,0,50,'227_WAI219560WR68','0','brak_obrazka.jpg',NULL,'173.9800','0.0000','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL,'8.0400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI219560WR68',''),
(1857,0,13,'227_WAI222950P512','0','brak_obrazka.jpg',NULL,'166.6700','0.0000','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL,'6.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI222950P512',''),
(1858,0,10,'227_WAI223105P328','0','brak_obrazka.jpg',NULL,'220.3300','0.0000','2017-09-25 10:27:10','2017-09-25 10:27:10',NULL,'7.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI223105P328',''),
(1859,0,19,'227_WAI223105P512','0','brak_obrazka.jpg',NULL,'213.0100','0.0000','2017-09-25 10:27:11','2017-09-25 10:27:11',NULL,'7.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI223105P512',''),
(1860,0,7,'227_WAI223850P332','0','brak_obrazka.jpg',NULL,'148.7800','0.0000','2017-09-25 10:27:11','2017-09-25 10:27:11',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI223850P332',''),
(1861,0,2,'227_WAI223950P332','0','brak_obrazka.jpg',NULL,'147.9700','0.0000','2017-09-25 10:27:11','2017-09-25 10:27:11',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI223950P332','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1862,0,20,'227_WAI223950P512','0','brak_obrazka.jpg',NULL,'200.0000','0.0000','2017-09-25 10:27:12','2017-09-25 10:27:12',NULL,'7.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI223950P512',''),
(1863,0,7,'227_WAI22612P332_','0','brak_obrazka.jpg',NULL,'250.4100','0.0000','2017-09-25 10:27:12','2017-09-25 10:27:12',NULL,'12.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI22612P332_',''),
(1864,0,16,'227_WAI2400H120__','0','brak_obrazka.jpg',NULL,'101.6300','0.0000','2017-09-25 10:27:12','2017-09-25 10:27:12',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI2400H120__',''),
(1865,0,20,'227_WAI2480P811__','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:27:13','2017-09-25 10:27:13',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI2480P811__',''),
(1866,0,33,'227_WAI25300P811_','0','brak_obrazka.jpg',NULL,'112.2000','0.0000','2017-09-25 10:27:13','2017-09-25 10:27:13',NULL,'4.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI25300P811_',''),
(1867,0,36,'227_WAI265080H803','0','brak_obrazka.jpg',NULL,'148.7800','0.0000','2017-09-25 10:27:13','2017-09-25 10:27:13',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI265080H803',''),
(1868,0,17,'227_WAI2700H8020_','0','brak_obrazka.jpg',NULL,'265.8500','0.0000','2017-09-25 10:27:13','2017-09-25 10:27:13',NULL,'17.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI2700H8020_',''),
(1869,0,50,'227_WAI319550WR68','0','brak_obrazka.jpg',NULL,'165.0400','0.0000','2017-09-25 10:27:14','2017-09-25 10:27:14',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI319550WR68',''),
(1870,0,50,'227_WAI411400P332','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI411400P332',''),
(1871,0,44,'227_WAI411400P512','0','brak_obrazka.jpg',NULL,'29.2700','0.0000','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL,'1.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI411400P512',''),
(1872,0,50,'227_WAI4300P6075_','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL,'0.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI4300P6075_',''),
(1873,0,11,'227_WAI4400H1206P','0','brak_obrazka.jpg',NULL,'125.2000','0.0000','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL,'8.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI4400H1206P',''),
(1874,0,50,'227_WAI4400P6075_','0','brak_obrazka.jpg',NULL,'25.2000','0.0000','2017-09-25 10:27:15','2017-09-25 10:27:15',NULL,'1.1500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI4400P6075_',''),
(1875,0,50,'227_WAI4410350P32','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL,'1.2600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI4410350P32',''),
(1876,0,50,'227_WAI511400P332','0','brak_obrazka.jpg',NULL,'34.9600','0.0000','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI511400P332',''),
(1877,0,50,'227_WAI511400P508','0','brak_obrazka.jpg',NULL,'26.8300','0.0000','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL,'1.0800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI511400P508',''),
(1878,0,50,'227_WAI511400P512','0','brak_obrazka.jpg',NULL,'29.2700','0.0000','2017-09-25 10:27:16','2017-09-25 10:27:16',NULL,'1.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI511400P512',''),
(1879,0,1,'227_WAI519550WR08','0','brak_obrazka.jpg',NULL,'95.1200','0.0000','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL,'7.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI519550WR08',''),
(1880,0,10,'227_WAI519560WR08','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL,'7.7400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI519560WR08',''),
(1881,0,11,'227_WAI531158H802','0','brak_obrazka.jpg',NULL,'259.3500','0.0000','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL,'20.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI531158H802','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1882,0,6,'227_WAI531158H803','0','brak_obrazka.jpg',NULL,'270.7300','0.0000','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL,'21.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI531158H803',''),
(1883,0,16,'227_WAI531158H804','0','brak_obrazka.jpg',NULL,'253.6600','0.0000','2017-09-25 10:27:17','2017-09-25 10:27:17',NULL,'19.2800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI531158H804',''),
(1884,0,9,'227_WAI531158H805','0','brak_obrazka.jpg',NULL,'280.4900','0.0000','2017-09-25 10:27:18','2017-09-25 10:27:18',NULL,'22.3100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI531158H805',''),
(1885,0,30,'227_WAI53175H8020','0','brak_obrazka.jpg',NULL,'192.6800','0.0000','2017-09-25 10:27:18','2017-09-25 10:27:18',NULL,'16.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI53175H8020',''),
(1886,0,12,'227_WAI53175H8022','0','brak_obrazka.jpg',NULL,'228.4600','0.0000','2017-09-25 10:27:19','2017-09-25 10:27:19',NULL,'18.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI53175H8022',''),
(1887,0,17,'227_WAI53175H8023','0','brak_obrazka.jpg',NULL,'253.6600','0.0000','2017-09-25 10:27:19','2017-09-25 10:27:19',NULL,'19.3500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI53175H8023',''),
(1888,0,34,'227_WAI613400P533','0','brak_obrazka.jpg',NULL,'43.0900','0.0000','2017-09-25 10:27:20','2017-09-25 10:27:20',NULL,'1.8500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI613400P533',''),
(1889,0,48,'227_WAI613500P328','0','brak_obrazka.jpg',NULL,'51.2200','0.0000','2017-09-25 10:27:20','2017-09-25 10:27:20',NULL,'2.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI613500P328',''),
(1890,0,50,'227_WAI613500P508','0','brak_obrazka.jpg',NULL,'39.0200','0.0000','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL,'1.6200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI613500P508',''),
(1891,0,46,'227_WAI613500P519','0','brak_obrazka.jpg',NULL,'40.6500','0.0000','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL,'1.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI613500P519',''),
(1892,0,21,'227_WAI613650P332','0','brak_obrazka.jpg',NULL,'47.9700','0.0000','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI613650P332',''),
(1893,0,50,'227_WAI613650P508','0','brak_obrazka.jpg',NULL,'55.2800','0.0000','2017-09-25 10:27:21','2017-09-25 10:27:21',NULL,'2.3600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI613650P508',''),
(1894,0,27,'227_WAI613650P512','0','brak_obrazka.jpg',NULL,'54.4700','0.0000','2017-09-25 10:27:22','2017-09-25 10:27:22',NULL,'2.3300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI613650P512',''),
(1895,0,40,'227_WAI615500P533','0','brak_obrazka.jpg',NULL,'63.4100','0.0000','2017-09-25 10:27:22','2017-09-25 10:27:22',NULL,'2.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI615500P533',''),
(1896,0,27,'227_WAI61555P512A','0','brak_obrazka.jpg',NULL,'56.1000','0.0000','2017-09-25 10:27:22','2017-09-25 10:27:22',NULL,'2.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI61555P512A',''),
(1897,0,50,'227_WAI615600P508','0','brak_obrazka.jpg',NULL,'74.8000','0.0000','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL,'2.9700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI615600P508',''),
(1898,0,50,'227_WAI615600P519','0','brak_obrazka.jpg',NULL,'66.6700','0.0000','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL,'2.6100',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI615600P519',''),
(1899,0,50,'227_WAI61560P5081','0','brak_obrazka.jpg',NULL,'69.1100','0.0000','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL,'2.7700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI61560P5081',''),
(1900,0,50,'227_WAI61560P508A','0','brak_obrazka.jpg',NULL,'75.6100','0.0000','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL,'3.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI61560P508A',''),
(1901,0,15,'227_WAI6156P332__','0','brak_obrazka.jpg',NULL,'67.4800','0.0000','2017-09-25 10:27:23','2017-09-25 10:27:23',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI6156P332__','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1902,0,34,'227_WAI6350H8023_','0','brak_obrazka.jpg',NULL,'43.9000','0.0000','2017-09-25 10:27:24','2017-09-25 10:27:24',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI6350H8023_',''),
(1903,0,45,'227_WAI6350H8030_','0','brak_obrazka.jpg',NULL,'43.9000','0.0000','2017-09-25 10:27:24','2017-09-25 10:27:24',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI6350H8030_',''),
(1904,0,3,'227_WAI6400P301AL','0','brak_obrazka.jpg',NULL,'45.5300','0.0000','2017-09-25 10:27:24','2017-09-25 10:27:24',NULL,'1.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI6400P301AL',''),
(1905,0,20,'227_WAI6400P301AT','0','brak_obrazka.jpg',NULL,'64.2300','0.0000','2017-09-25 10:27:25','2017-09-25 10:27:25',NULL,'1.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI6400P301AT',''),
(1906,0,46,'227_WAI815550P519','0','brak_obrazka.jpg',NULL,'63.4100','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'2.5400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI815550P519',''),
(1907,0,27,'227_WAI816565P815','0','brak_obrazka.jpg',NULL,'100.0000','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'4.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816565P815',''),
(1908,0,28,'227_WAI816565P825','0','brak_obrazka.jpg',NULL,'92.6800','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'3.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816565P825',''),
(1909,0,25,'227_WAI816600P519','0','brak_obrazka.jpg',NULL,'81.3000','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'3.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816600P519',''),
(1910,0,43,'227_WAI816600P533','0','brak_obrazka.jpg',NULL,'96.7500','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'3.6800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816600P533',''),
(1911,0,50,'227_WAI816650P328','0','brak_obrazka.jpg',NULL,'93.5000','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'4.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816650P328',''),
(1912,0,50,'227_WAI816650P332','0','brak_obrazka.jpg',NULL,'75.6100','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816650P332',''),
(1913,0,50,'227_WAI816650P512','0','brak_obrazka.jpg',NULL,'78.8600','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'3.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816650P512',''),
(1914,0,43,'227_WAI816650P533','0','brak_obrazka.jpg',NULL,'98.3700','0.0000','2017-09-25 10:27:26','2017-09-25 10:27:26',NULL,'3.7800',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816650P533',''),
(1915,0,50,'227_WAI81665P508A','0','brak_obrazka.jpg',NULL,'76.4200','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'3.2000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI81665P508A',''),
(1916,0,50,'227_WAI81665P508B','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'3.5600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI81665P508B',''),
(1917,0,50,'227_WAI816750P332','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816750P332',''),
(1918,0,50,'227_WAI816750P512','0','brak_obrazka.jpg',NULL,'86.9900','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'3.9000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816750P512',''),
(1919,0,50,'227_WAI816750P519','0','brak_obrazka.jpg',NULL,'83.7400','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'3.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI816750P519',''),
(1920,0,24,'227_WAI817800P519','0','brak_obrazka.jpg',NULL,'104.0700','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'4.0700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI817800P519',''),
(1921,0,50,'227_WAI818585P815','0','brak_obrazka.jpg',NULL,'118.7000','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'6.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818585P815','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1922,0,50,'227_WAI818650P332','0','brak_obrazka.jpg',NULL,'73.1700','0.0000','2017-09-25 10:27:27','2017-09-25 10:27:27',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818650P332',''),
(1923,0,50,'227_WAI818650P512','0','brak_obrazka.jpg',NULL,'81.3000','0.0000','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL,'3.6900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818650P512',''),
(1924,0,50,'227_WAI818700P332','0','brak_obrazka.jpg',NULL,'94.3100','0.0000','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818700P332',''),
(1925,0,50,'227_WAI818850P332','0','brak_obrazka.jpg',NULL,'88.6200','0.0000','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818850P332',''),
(1926,0,50,'227_WAI818850P508','0','brak_obrazka.jpg',NULL,'121.9500','0.0000','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL,'4.6500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818850P508',''),
(1927,0,50,'227_WAI818850P512','0','brak_obrazka.jpg',NULL,'101.6300','0.0000','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL,'4.3000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818850P512',''),
(1928,0,22,'227_WAI818850P519','0','brak_obrazka.jpg',NULL,'111.3800','0.0000','2017-09-25 10:27:28','2017-09-25 10:27:28',NULL,'4.2200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818850P519',''),
(1929,0,41,'227_WAI818850P533','0','brak_obrazka.jpg',NULL,'145.5300','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'5.5500',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818850P533',''),
(1930,0,29,'227_WAI818950P332','0','brak_obrazka.jpg',NULL,'97.5600','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818950P332',''),
(1931,0,48,'227_WAI818950P508','0','brak_obrazka.jpg',NULL,'101.6300','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'4.4700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818950P508',''),
(1932,0,50,'227_WAI818950P512','0','brak_obrazka.jpg',NULL,'101.6300','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'5.4000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI818950P512',''),
(1933,0,13,'227_WAI820100P328','0','brak_obrazka.jpg',NULL,'165.0400','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'5.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI820100P328',''),
(1934,0,28,'227_WAI820100P512','0','brak_obrazka.jpg',NULL,'141.4600','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'6.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI820100P512',''),
(1935,0,50,'227_WAI82010P332_','0','brak_obrazka.jpg',NULL,'130.8900','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'5.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI82010P332_',''),
(1936,0,20,'227_WAI820800P512','0','brak_obrazka.jpg',NULL,'112.2000','0.0000','2017-09-25 10:27:29','2017-09-25 10:27:29',NULL,'4.7000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI820800P512',''),
(1937,0,48,'227_WAI8208P332__','0','brak_obrazka.jpg',NULL,'109.7600','0.0000','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL,'5.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI8208P332__',''),
(1938,0,16,'227_WAI822510P532','0','brak_obrazka.jpg',NULL,'247.1500','0.0000','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL,'9.4200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI822510P532',''),
(1939,0,16,'227_WAI8350H8023_','0','brak_obrazka.jpg',NULL,'57.7200','0.0000','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI8350H8023_',''),
(1940,0,50,'227_WAI8350P3012_','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL,'0.8600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI8350P3012_',''),
(1941,0,50,'227_WAI8350P3014_','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL,'0.9600',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI8350P3014_','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1942,0,12,'227_WAI8400H8023_','0','brak_obrazka.jpg',NULL,'65.0400','0.0000','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL,'3.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI8400H8023_',''),
(1943,0,27,'227_WAI8480400P32','0','brak_obrazka.jpg',NULL,'50.4100','0.0000','2017-09-25 10:27:30','2017-09-25 10:27:30',NULL,'1.8000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI8480400P32',''),
(1944,0,26,'227_WAI848040H802','0','brak_obrazka.jpg',NULL,'79.6700','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'2.0000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI848040H802',''),
(1945,0,50,'227_WAI84840P3012','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'1.1000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI84840P3012',''),
(1946,0,50,'227_WAI84840P3014','0','brak_obrazka.jpg',NULL,'24.3900','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'1.1200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI84840P3014',''),
(1947,0,36,'227_WAI8570P811__','0','brak_obrazka.jpg',NULL,'104.8800','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'4.1700',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI8570P811__',''),
(1948,0,11,'227_WAI925120P532','0','brak_obrazka.jpg',NULL,'326.8300','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'12.6400',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI925120P532',''),
(1949,0,29,'227_WAI9690P821__','0','brak_obrazka.jpg',NULL,'182.1100','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'6.7300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WAI9690P821__',''),
(1950,0,50,'227_WOS0350P235__','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'2.5000',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WOS0350P235__',''),
(1951,0,50,'227_WOS0350P264__','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:27:31','2017-09-25 10:27:31',NULL,'2.5200',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WOS0350P264__',''),
(1952,0,50,'227_WOS212070P602','0','brak_obrazka.jpg',NULL,'67.4800','0.0000','2017-09-25 10:27:32','2017-09-25 10:27:32',NULL,'3.1900',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WOS212070P602',''),
(1953,0,50,'227_WOS213070P284','0','brak_obrazka.jpg',NULL,'72.3600','0.0000','2017-09-25 10:27:32','2017-09-25 10:27:32',NULL,'3.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WOS213070P284',''),
(1954,0,50,'227_WOS313060P285','0','brak_obrazka.jpg',NULL,'68.2900','0.0000','2017-09-25 10:27:32','2017-09-25 10:27:32',NULL,'3.2300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WOS313060P285',''),
(1955,0,50,'227_WOS313060P297','0','brak_obrazka.jpg',NULL,'73.9800','0.0000','2017-09-25 10:27:32','2017-09-25 10:27:32',NULL,'3.6300',1,4,NULL,0,0,NULL,'4','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','Nowegumy.pl','','227_WOS313060P297',''),
(1966,0,3,'290_43-25','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:27:34','2017-09-25 10:27:34',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5907678843258','290_43-25',''),
(1967,0,3,'290_43-26','0','brak_obrazka.jpg',NULL,'25.2000','0.0000','2017-09-25 10:27:34','2017-09-25 10:27:34',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5907678843265','290_43-26',''),
(1971,0,3,'290_43-79','0','brak_obrazka.jpg',NULL,'5.6900','0.0000','2017-09-25 10:27:35','2017-09-25 10:27:35',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5907678843791','290_43-79',''),
(1979,0,3,'290_9300','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:36','2017-09-25 10:27:36',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593008','290_9300',''),
(1980,0,3,'290_9301','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593015','290_9301',''),
(1981,0,3,'290_9302','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593022','290_9302','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (1982,0,3,'290_9303','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593039','290_9303',''),
(1983,0,3,'290_9304','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593046','290_9304',''),
(1984,0,3,'290_9305','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593053','290_9305',''),
(1985,0,3,'290_9306','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593060','290_9306',''),
(1986,0,3,'290_9307','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593077','290_9307',''),
(1987,0,3,'290_9308','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593084','290_9308',''),
(1988,0,3,'290_9309','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:27:37','2017-09-25 10:27:37',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593091','290_9309',''),
(1989,0,3,'290_9310','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593107','290_9310',''),
(1990,0,3,'290_9311','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593114','290_9311',''),
(1991,0,3,'290_9312','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593121','290_9312',''),
(1992,0,3,'290_9313','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593138','290_9313',''),
(1993,0,3,'290_9314','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593145','290_9314',''),
(1994,0,3,'290_9315','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593152','290_9315',''),
(1995,0,3,'290_9316','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593169','290_9316',''),
(1996,0,3,'290_9317','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:38','2017-09-25 10:27:38',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308593176','290_9317',''),
(1997,0,3,'290_9500','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595002','290_9500',''),
(1998,0,3,'290_9501','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595019','290_9501',''),
(1999,0,3,'290_9502','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595026','290_9502',''),
(2000,0,3,'290_9503','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595033','290_9503',''),
(2001,0,3,'290_9504','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595040','290_9504','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2002,0,3,'290_9505','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595057','290_9505',''),
(2003,0,3,'290_9506','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595064','290_9506',''),
(2004,0,3,'290_9507','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:39','2017-09-25 10:27:39',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308595071','290_9507',''),
(2005,0,3,'290_9600','0','brak_obrazka.jpg',NULL,'33.3300','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596009','290_9600',''),
(2006,0,3,'290_9601','0','brak_obrazka.jpg',NULL,'33.3300','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596016','290_9601',''),
(2007,0,3,'290_9602','0','brak_obrazka.jpg',NULL,'33.3300','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596023','290_9602',''),
(2008,0,3,'290_9603','0','brak_obrazka.jpg',NULL,'33.3300','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596030','290_9603',''),
(2009,0,3,'290_9604','0','brak_obrazka.jpg',NULL,'33.3300','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596047','290_9604',''),
(2010,0,3,'290_9605','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596054','290_9605',''),
(2011,0,3,'290_9606','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596061','290_9606',''),
(2012,0,3,'290_9607','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:40','2017-09-25 10:27:40',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596078','290_9607',''),
(2013,0,3,'290_9608','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596085','290_9608',''),
(2014,0,3,'290_9609','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596092','290_9609',''),
(2015,0,3,'290_9610','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596108','290_9610',''),
(2016,0,3,'290_9611','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596115','290_9611',''),
(2017,0,3,'290_9616','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596160','290_9616',''),
(2018,0,3,'290_9617','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596177','290_9617',''),
(2019,0,3,'290_9618','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596184','290_9618',''),
(2020,0,3,'290_9619','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596191','290_9619',''),
(2021,0,3,'290_9620','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:41','2017-09-25 10:27:41',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596207','290_9620','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2022,0,3,'290_9623','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596238','290_9623',''),
(2023,0,3,'290_9624','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308596245','290_9624',''),
(2024,0,3,'290_9701','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597013','290_9701',''),
(2025,0,3,'290_9702','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597020','290_9702',''),
(2026,0,3,'290_9705','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597051','290_9705',''),
(2027,0,3,'290_9706','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597068','290_9706',''),
(2028,0,2,'290_9708','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597082','290_9708',''),
(2029,0,3,'290_9713','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597136','290_9713',''),
(2030,0,3,'290_9714','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:42','2017-09-25 10:27:42',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597143','290_9714',''),
(2031,0,3,'290_9716','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597167','290_9716',''),
(2032,0,3,'290_9717','0','brak_obrazka.jpg',NULL,'76.8500','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5902308597174','290_9717',''),
(2033,0,8,'290_AA 300120','0','brak_obrazka.jpg',NULL,'6.5000','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,4,NULL,0,0,NULL,'6','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224300122','290_AA 300120',''),
(2034,0,0,'290_AA 300220','0','brak_obrazka.jpg',NULL,'6.5000','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,4,NULL,0,0,NULL,'6','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224300221','290_AA 300220',''),
(2035,0,3,'290_AA 300320','0','brak_obrazka.jpg',NULL,'6.5000','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,4,NULL,0,0,NULL,'6','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224300320','290_AA 300320',''),
(2036,0,3,'290_AA 300420','0','brak_obrazka.jpg',NULL,'6.5000','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,4,NULL,0,0,NULL,'6','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224300429','290_AA 300420',''),
(2037,0,2,'290_AA FLAT 330','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224043005','290_AA FLAT 330',''),
(2038,0,8,'290_AA FLAT 380','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224045009','290_AA FLAT 380',''),
(2039,0,1,'290_AA FLAT 400','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:27:43','2017-09-25 10:27:43',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224046006','290_AA FLAT 400',''),
(2040,0,2,'290_AA FLAT 430','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224047003','290_AA FLAT 430',''),
(2041,0,3,'290_AA FLAT 450','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224048000','290_AA FLAT 450','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2042,0,5,'290_AA FLAT 480','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224049007','290_AA FLAT 480',''),
(2043,0,2,'290_AA FLAT 500','0','brak_obrazka.jpg',NULL,'18.7000','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224050003','290_AA FLAT 500',''),
(2044,0,0,'290_AA FLAT 530','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224051000','290_AA FLAT 530',''),
(2045,0,0,'290_AA FLAT 560','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224052007','290_AA FLAT 560',''),
(2046,0,2,'290_AA FLAT 580','0','brak_obrazka.jpg',NULL,'21.1400','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224053004','290_AA FLAT 580',''),
(2047,0,0,'290_AA FLAT 600','0','brak_obrazka.jpg',NULL,'21.1400','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224054001','290_AA FLAT 600',''),
(2048,0,4,'290_AA FLAT 650','0','brak_obrazka.jpg',NULL,'26.8300','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224056005','290_AA FLAT 650',''),
(2049,0,2,'290_AA FLAT 700','0','brak_obrazka.jpg',NULL,'30.8900','0.0000','2017-09-25 10:27:44','2017-09-25 10:27:44',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224058009','290_AA FLAT 700',''),
(2050,0,7,'290_AA SPEC 280','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224101002','290_AA SPEC 280',''),
(2051,0,5,'290_AA SPEC 330','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224103006','290_AA SPEC 330',''),
(2052,0,2,'290_AA SPEC 350','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224104003','290_AA SPEC 350',''),
(2053,0,0,'290_AA SPEC 380','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224105000','290_AA SPEC 380',''),
(2054,0,0,'290_AA SPEC 400','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224106007','290_AA SPEC 400',''),
(2055,0,0,'290_AA SPEC 430','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224107004','290_AA SPEC 430',''),
(2056,0,0,'290_AA SPEC 450','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224108001','290_AA SPEC 450',''),
(2057,0,0,'290_AA SPEC 480','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224109008','290_AA SPEC 480',''),
(2058,0,0,'290_AA SPEC 500','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224110004','290_AA SPEC 500',''),
(2059,0,0,'290_AA SPEC 530','0','brak_obrazka.jpg',NULL,'10.5700','0.0000','2017-09-25 10:27:45','2017-09-25 10:27:45',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224111001','290_AA SPEC 530',''),
(2060,0,2,'290_AA SPEC 560','0','brak_obrazka.jpg',NULL,'10.5700','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224112008','290_AA SPEC 560',''),
(2061,0,0,'290_AA SPEC 580','0','brak_obrazka.jpg',NULL,'10.5700','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224113005','290_AA SPEC 580','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2062,0,2,'290_AA SPEC 600','0','brak_obrazka.jpg',NULL,'10.5700','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','4028224114002','290_AA SPEC 600',''),
(2063,0,4,'290_CP 03459','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373014394','290_CP 03459',''),
(2064,0,6,'290_CP 07716','0','brak_obrazka.jpg',NULL,'12.2000','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373007716','290_CP 07716',''),
(2065,0,2,'290_CP 16572','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373016572','290_CP 16572',''),
(2066,0,2,'290_CP 16589','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373016589','290_CP 16589',''),
(2067,0,2,'290_CP 16596','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373016596','290_CP 16596',''),
(2068,0,2,'290_CP 16602','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:46','2017-09-25 10:27:46',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373016602','290_CP 16602',''),
(2069,0,3,'290_CP 16626','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373016626','290_CP 16626',''),
(2070,0,8,'290_CP 16633','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373016633','290_CP 16633',''),
(2071,0,3,'290_CP 16640','0','brak_obrazka.jpg',NULL,'8.9400','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373016640','290_CP 16640',''),
(2072,0,2,'290_CP 19283','0','brak_obrazka.jpg',NULL,'12.2000','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373019283','290_CP 19283',''),
(2073,0,0,'290_CP 19887','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373019887','290_CP 19887',''),
(2074,0,2,'290_CP 19900','0','brak_obrazka.jpg',NULL,'35.7700','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373019900','290_CP 19900',''),
(2075,0,1,'290_CP 24737','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373024737','290_CP 24737',''),
(2076,0,2,'290_CP 26342','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373026342','290_CP 26342',''),
(2077,0,2,'290_CP 39809','0','brak_obrazka.jpg',NULL,'13.0100','0.0000','2017-09-25 10:27:47','2017-09-25 10:27:47',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373039809','290_CP 39809',''),
(2078,0,3,'290_CP 39823','0','brak_obrazka.jpg',NULL,'13.0100','0.0000','2017-09-25 10:27:48','2017-09-25 10:27:48',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373039823','290_CP 39823',''),
(2079,0,0,'290_CP 39908','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:27:48','2017-09-25 10:27:48',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373039908','290_CP 39908',''),
(2080,0,2,'290_CP 44872','0','brak_obrazka.jpg',NULL,'12.2000','0.0000','2017-09-25 10:27:48','2017-09-25 10:27:48',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373044872','290_CP 44872',''),
(2081,0,2,'290_CP 45008','0','brak_obrazka.jpg',NULL,'11.3800','0.0000','2017-09-25 10:27:48','2017-09-25 10:27:48',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373045008','290_CP 45008','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2082,0,0,'290_CP 45206','0','brak_obrazka.jpg',NULL,'11.3800','0.0000','2017-09-25 10:27:48','2017-09-25 10:27:48',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373045206','290_CP 45206',''),
(2083,0,3,'290_CP 53928','0','brak_obrazka.jpg',NULL,'37.4000','0.0000','2017-09-25 10:27:48','2017-09-25 10:27:48',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373053928','290_CP 53928',''),
(2084,0,6,'290_CP 57483','0','brak_obrazka.jpg',NULL,'6.5000','0.0000','2017-09-25 10:27:49','2017-09-25 10:27:49',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373057483','290_CP 57483',''),
(2085,0,2,'290_CP 95580','0','brak_obrazka.jpg',NULL,'17.0700','0.0000','2017-09-25 10:27:49','2017-09-25 10:27:49',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5010373895580','290_CP 95580',''),
(2088,0,2,'290_ES 25033','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:27:49','2017-09-25 10:27:49',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898250335','290_ES 25033',''),
(2092,0,3,'290_ES 25318','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:50','2017-09-25 10:27:50',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898253183','290_ES 25318',''),
(2093,0,3,'290_ES 25319','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:50','2017-09-25 10:27:50',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898253190','290_ES 25319',''),
(2094,0,3,'290_ES 25320','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:50','2017-09-25 10:27:50',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898253206','290_ES 25320',''),
(2095,0,3,'290_ES 25322','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:50','2017-09-25 10:27:50',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898253220','290_ES 25322',''),
(2096,0,3,'290_ES 25323','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:50','2017-09-25 10:27:50',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898253237','290_ES 25323',''),
(2097,0,3,'290_ES 25450','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:51','2017-09-25 10:27:51',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898254500','290_ES 25450',''),
(2099,0,3,'290_ES 25522','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:51','2017-09-25 10:27:51',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898255224','290_ES 25522',''),
(2100,0,3,'290_ES 25770','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:51','2017-09-25 10:27:51',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898257709','290_ES 25770',''),
(2103,0,3,'290_ES 27009','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:27:51','2017-09-25 10:27:51',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898270098','290_ES 27009',''),
(2104,0,3,'290_ES 28035','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:27:52','2017-09-25 10:27:52',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898280356','290_ES 28035',''),
(2105,0,3,'290_ES 28207','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:52','2017-09-25 10:27:52',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898282077','290_ES 28207',''),
(2106,0,3,'290_ES 28212','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:27:52','2017-09-25 10:27:52',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898282121','290_ES 28212',''),
(2107,0,3,'290_ES 28307','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:52','2017-09-25 10:27:52',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898283074','290_ES 28307',''),
(2108,0,3,'290_ES 28310','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:27:52','2017-09-25 10:27:52',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898283104','290_ES 28310',''),
(2109,0,3,'290_ES 28402','0','brak_obrazka.jpg',NULL,'21.9500','0.0000','2017-09-25 10:27:52','2017-09-25 10:27:52',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898284026','290_ES 28402','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2112,0,3,'290_ES 80101','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:27:52','2017-09-25 10:27:52',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898801018','290_ES 80101',''),
(2113,0,3,'290_ES 80116','0','brak_obrazka.jpg',NULL,'23.5800','0.0000','2017-09-25 10:27:53','2017-09-25 10:27:53',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8010898801162','290_ES 80116',''),
(2159,0,3,'290_Z 03-23','0','brak_obrazka.jpg',NULL,'32.5200','0.0000','2017-09-25 10:28:01','2017-09-25 10:28:01',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 03-23',''),
(2172,0,2,'290_Z 05-03','0','brak_obrazka.jpg',NULL,'52.0300','0.0000','2017-09-25 10:28:03','2017-09-25 10:28:03',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119605038','290_Z 05-03',''),
(2173,0,0,'290_Z 05-04','0','brak_obrazka.jpg',NULL,'40.6500','0.0000','2017-09-25 10:28:03','2017-09-25 10:28:03',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119605045','290_Z 05-04',''),
(2174,0,0,'290_Z 05-05','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:28:03','2017-09-25 10:28:03',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119605052','290_Z 05-05',''),
(2175,0,1,'290_Z 05-07','0','brak_obrazka.jpg',NULL,'19.5100','0.0000','2017-09-25 10:28:03','2017-09-25 10:28:03',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 05-07',''),
(2176,0,2,'290_Z 05-08','0','brak_obrazka.jpg',NULL,'42.2800','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 05-08',''),
(2177,0,6,'290_Z 05-09','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 05-09',''),
(2178,0,0,'290_Z 05-12','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119605120','290_Z 05-12',''),
(2179,0,3,'290_Z 05-13','0','brak_obrazka.jpg',NULL,'39.0200','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119605137','290_Z 05-13',''),
(2180,0,1,'290_Z 05-14','0','brak_obrazka.jpg',NULL,'78.0500','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119605144','290_Z 05-14',''),
(2181,0,4,'290_Z 05-15','0','brak_obrazka.jpg',NULL,'156.1000','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 05-15',''),
(2182,0,0,'290_Z 05-20','0','brak_obrazka.jpg',NULL,'22.7600','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5905888005206','290_Z 05-20',''),
(2183,0,6,'290_Z 06-02/1','0','brak_obrazka.jpg',NULL,'2.4400','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'6','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 06-02/1',''),
(2184,0,0,'290_Z 06-02/3','0','brak_obrazka.jpg',NULL,'2.4400','0.0000','2017-09-25 10:28:04','2017-09-25 10:28:04',NULL,'0.0000',1,4,NULL,0,0,NULL,'6','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 06-02/3',''),
(2185,0,2,'290_Z 07-22','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5905888007224','290_Z 07-22',''),
(2186,0,3,'290_Z 07-34','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119607346','290_Z 07-34',''),
(2187,0,0,'290_Z 07-36','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5905888007361','290_Z 07-36',''),
(2188,0,10,'290_Z 07-39','0','brak_obrazka.jpg',NULL,'8.1300','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5905888007392','290_Z 07-39','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2189,0,2,'290_Z 07-49','0','brak_obrazka.jpg',NULL,'17.8900','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119607490','290_Z 07-49',''),
(2190,0,10,'290_Z 07-50','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119607506','290_Z 07-50',''),
(2191,0,2,'290_Z 07-51','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 07-51',''),
(2192,0,2,'290_Z 07-52','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:28:05','2017-09-25 10:28:05',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5905888007521','290_Z 07-52',''),
(2202,0,0,'290_Z 10-04','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:28:07','2017-09-25 10:28:07',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5905888010040','290_Z 10-04',''),
(2203,0,2,'290_Z 10-05','0','brak_obrazka.jpg',NULL,'9.7600','0.0000','2017-09-25 10:28:07','2017-09-25 10:28:07',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5905888010057','290_Z 10-05',''),
(2204,0,2,'290_Z 10-33','0','brak_obrazka.jpg',NULL,'5.6900','0.0000','2017-09-25 10:28:07','2017-09-25 10:28:07',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 10-33',''),
(2205,0,0,'290_Z 10-36','0','brak_obrazka.jpg',NULL,'1.6300','0.0000','2017-09-25 10:28:07','2017-09-25 10:28:07',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','5903111401283','290_Z 10-36',''),
(2206,0,5,'290_Z 10-56','0','brak_obrazka.jpg',NULL,'26.0200','0.0000','2017-09-25 10:28:07','2017-09-25 10:28:07',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 10-56',''),
(2207,0,6,'290_Z 10-57','0','brak_obrazka.jpg',NULL,'26.0200','0.0000','2017-09-25 10:28:08','2017-09-25 10:28:08',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 10-57',''),
(2208,0,6,'290_Z 10-58','0','brak_obrazka.jpg',NULL,'16.2600','0.0000','2017-09-25 10:28:08','2017-09-25 10:28:08',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 10-58',''),
(2209,0,6,'290_Z 10-59','0','brak_obrazka.jpg',NULL,'13.0100','0.0000','2017-09-25 10:28:08','2017-09-25 10:28:08',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 10-59',''),
(2210,0,6,'290_Z 10-60','0','brak_obrazka.jpg',NULL,'13.0100','0.0000','2017-09-25 10:28:08','2017-09-25 10:28:08',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 10-60',''),
(2238,0,7,'290_Z 15-21','0','brak_obrazka.jpg',NULL,'30.8900','0.0000','2017-09-25 10:28:13','2017-09-25 10:28:13',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119615211','290_Z 15-21',''),
(2239,0,0,'290_Z 16-07','0','brak_obrazka.jpg',NULL,'4.0700','0.0000','2017-09-25 10:28:13','2017-09-25 10:28:13',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119616072','290_Z 16-07',''),
(2240,0,0,'290_Z 16-08','0','brak_obrazka.jpg',NULL,'4.0700','0.0000','2017-09-25 10:28:13','2017-09-25 10:28:13',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119616089','290_Z 16-08',''),
(2246,0,2,'290_Z 19-05','0','brak_obrazka.jpg',NULL,'61.7900','0.0000','2017-09-25 10:28:14','2017-09-25 10:28:14',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119619059','290_Z 19-05',''),
(2247,0,2,'290_Z 19-10','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:14','2017-09-25 10:28:14',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119619103','290_Z 19-10',''),
(2248,0,1,'290_Z 19-12','0','brak_obrazka.jpg',NULL,'27.6400','0.0000','2017-09-25 10:28:14','2017-09-25 10:28:14',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119619127','290_Z 19-12',''),
(2249,0,7,'290_Z 20-50','0','brak_obrazka.jpg',NULL,'250.0000','0.0000','2017-09-25 10:28:14','2017-09-25 10:28:14',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 20-50','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2250,0,5,'290_Z 20-51','0','brak_obrazka.jpg',NULL,'250.0000','0.0000','2017-09-25 10:28:15','2017-09-25 10:28:15',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 20-51',''),
(2251,0,8,'290_Z 20-52','0','brak_obrazka.jpg',NULL,'182.4100','0.0000','2017-09-25 10:28:15','2017-09-25 10:28:15',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119620529','290_Z 20-52',''),
(2252,0,4,'290_Z 20-53','0','brak_obrazka.jpg',NULL,'182.4100','0.0000','2017-09-25 10:28:15','2017-09-25 10:28:15',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119620536','290_Z 20-53',''),
(2253,0,0,'290_Z 20-54','0','brak_obrazka.jpg',NULL,'43.5200','0.0000','2017-09-25 10:28:15','2017-09-25 10:28:15',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119620543','290_Z 20-54',''),
(2254,0,2,'290_Z 20-55','0','brak_obrazka.jpg',NULL,'43.5200','0.0000','2017-09-25 10:28:15','2017-09-25 10:28:15',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119620550','290_Z 20-55',''),
(2255,0,4,'290_Z 20-58','0','brak_obrazka.jpg',NULL,'182.4100','0.0000','2017-09-25 10:28:15','2017-09-25 10:28:15',NULL,'0.0000',1,0,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119620581','290_Z 20-58',''),
(2262,0,8,'290_Z 25-09','0','brak_obrazka.jpg',NULL,'100.8100','0.0000','2017-09-25 10:28:16','2017-09-25 10:28:16',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 25-09',''),
(2271,0,6,'290_Z 27-02','0','brak_obrazka.jpg',NULL,'231.7100','0.0000','2017-09-25 10:28:18','2017-09-25 10:28:18',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119627023','290_Z 27-02',''),
(2278,0,1,'290_Z 31-05','0','brak_obrazka.jpg',NULL,'252.8500','0.0000','2017-09-25 10:28:19','2017-09-25 10:28:19',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 31-05',''),
(2296,0,0,'290_Z 38-00','0','brak_obrazka.jpg',NULL,'6.5000','0.0000','2017-09-25 10:28:23','2017-09-25 10:28:23',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638005','290_Z 38-00',''),
(2297,0,0,'290_Z 38-03','0','brak_obrazka.jpg',NULL,'4.0700','0.0000','2017-09-25 10:28:23','2017-09-25 10:28:23',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638036','290_Z 38-03',''),
(2298,0,2,'290_Z 38-04','0','brak_obrazka.jpg',NULL,'4.0700','0.0000','2017-09-25 10:28:23','2017-09-25 10:28:23',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638043','290_Z 38-04',''),
(2299,0,0,'290_Z 38-07','0','brak_obrazka.jpg',NULL,'1.6300','0.0000','2017-09-25 10:28:23','2017-09-25 10:28:23',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 38-07',''),
(2300,0,2,'290_Z 38-11','0','brak_obrazka.jpg',NULL,'11.3800','0.0000','2017-09-25 10:28:23','2017-09-25 10:28:23',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638111','290_Z 38-11',''),
(2301,0,2,'290_Z 38-12','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:28:23','2017-09-25 10:28:23',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638128','290_Z 38-12',''),
(2302,0,3,'290_Z 38-16','0','brak_obrazka.jpg',NULL,'7.3200','0.0000','2017-09-25 10:28:23','2017-09-25 10:28:23',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638166','290_Z 38-16',''),
(2303,0,3,'290_Z 38-24','0','brak_obrazka.jpg',NULL,'3.2500','0.0000','2017-09-25 10:28:24','2017-09-25 10:28:24',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638241','290_Z 38-24',''),
(2304,0,3,'290_Z 38-34','0','brak_obrazka.jpg',NULL,'6.5000','0.0000','2017-09-25 10:28:24','2017-09-25 10:28:24',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 38-34',''),
(2305,0,3,'290_Z 38-36','0','brak_obrazka.jpg',NULL,'0.8100','0.0000','2017-09-25 10:28:24','2017-09-25 10:28:24',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 38-36',''),
(2306,0,3,'290_Z 38-37','0','brak_obrazka.jpg',NULL,'1.6300','0.0000','2017-09-25 10:28:24','2017-09-25 10:28:24',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119638371','290_Z 38-37','');
insert into `products` (`products_id`, `sort_order`, `products_quantity`, `products_model`, `products_pkwiu`, `products_image`, `products_image_pop`, `products_price`, `products_retail_price`, `products_date_added`, `products_last_modified`, `products_date_available`, `products_weight`, `products_status`, `products_tax_class_id`, `products_maxorder`, `manufacturers_id`, `products_ordered`, `products_availability_id`, `products_jm_id`, `products_adminnotes`, `emo_source`, `emo_pn`, `emo_paczka`, `emo_dostawca`, `emo_kreskowy`, `emo_nrdostawcy`, `emo_uwagi`) values (2307,0,4,'290_Z 38-80','0','brak_obrazka.jpg',NULL,'20.3300','0.0000','2017-09-25 10:28:24','2017-09-25 10:28:24',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 38-80',''),
(2308,0,0,'290_Z 38-95','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:28:24','2017-09-25 10:28:24',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 38-95',''),
(2309,0,1,'290_Z 38-96','0','brak_obrazka.jpg',NULL,'15.4500','0.0000','2017-09-25 10:28:24','2017-09-25 10:28:24',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 38-96',''),
(2328,0,2,'290_Z 72-00','0','brak_obrazka.jpg',NULL,'11.3800','0.0000','2017-09-25 10:28:27','2017-09-25 10:28:27',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 72-00',''),
(2329,0,1,'290_Z 72-01','0','brak_obrazka.jpg',NULL,'11.3800','0.0000','2017-09-25 10:28:28','2017-09-25 10:28:28',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 72-01',''),
(2330,0,1,'290_Z 72-02','0','brak_obrazka.jpg',NULL,'13.8200','0.0000','2017-09-25 10:28:28','2017-09-25 10:28:28',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 72-02',''),
(2331,0,2,'290_Z 72-03','0','brak_obrazka.jpg',NULL,'14.6300','0.0000','2017-09-25 10:28:28','2017-09-25 10:28:28',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','','290_Z 72-03',''),
(2334,0,0,'290_Z 76-49','0','brak_obrazka.jpg',NULL,'4.8800','0.0000','2017-09-25 10:28:28','2017-09-25 10:28:28',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119676496','290_Z 76-49',''),
(2344,0,2,'290_Z 90-51','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:30','2017-09-25 10:28:30',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690515','290_Z 90-51',''),
(2345,0,2,'290_Z 90-52','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:31','2017-09-25 10:28:31',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690522','290_Z 90-52',''),
(2346,0,2,'290_Z 90-53','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:31','2017-09-25 10:28:31',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690539','290_Z 90-53',''),
(2347,0,2,'290_Z 90-60','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:31','2017-09-25 10:28:31',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690607','290_Z 90-60',''),
(2348,0,0,'290_Z 90-61','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:31','2017-09-25 10:28:31',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690614','290_Z 90-61',''),
(2349,0,4,'290_Z 90-62','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:31','2017-09-25 10:28:31',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690621','290_Z 90-62',''),
(2350,0,2,'290_Z 90-63','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:31','2017-09-25 10:28:31',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690638','290_Z 90-63',''),
(2351,0,4,'290_Z 90-64','0','brak_obrazka.jpg',NULL,'28.4600','0.0000','2017-09-25 10:28:31','2017-09-25 10:28:31',NULL,'0.0000',1,4,NULL,0,0,NULL,'5','',0,NULL,'c3f46d049ad84e30a2fee1dc3f607792','GoDrive','8595119690645','290_Z 90-64','');

drop table if exists `products_attributes`;
CREATE TABLE `products_attributes` (
  `products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `options_id` int(11) NOT NULL,
  `options_values_id` int(11) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  `products_options_sort_order` int(6) unsigned NOT NULL DEFAULT '0',
  `options_values_weight` decimal(6,3) DEFAULT '0.000',
  PRIMARY KEY (`products_attributes_id`),
  KEY `idx_id_options_id_values` (`products_id`,`options_id`,`options_values_id`),
  KEY `idx_opt_sort_order` (`products_options_sort_order`),
  KEY `idx_products_id` (`products_id`)
);

drop table if exists `products_attributes_download`;
CREATE TABLE `products_attributes_download` (
  `products_attributes_id` int(11) NOT NULL,
  `products_attributes_filename` varchar(255) NOT NULL,
  `products_attributes_maxdays` int(2) DEFAULT '0',
  `products_attributes_maxcount` int(2) DEFAULT '0',
  PRIMARY KEY (`products_attributes_id`)
);

drop table if exists `products_availability`;
CREATE TABLE `products_availability` (
  `products_availability_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_availability_name` varchar(255) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`products_availability_id`,`language_id`),
  KEY `idx_products_availability_name` (`products_availability_name`)
);

insert into `products_availability` (`products_availability_id`, `language_id`, `products_availability_name`, `date_added`, `last_modified`) values (1,1,'Dostępny',NULL,NULL),
(1,2,'Available',NULL,NULL),
(1,3,'Vorhanden',NULL,NULL),
(1,4,'Имеющеся',NULL,NULL),
(2,1,'Dostępność - 3 dni',NULL,NULL),
(2,2,'Availability - 3 days',NULL,NULL),
(2,3,'Verwendbarkeit - 3 Tage',NULL,NULL),
(2,4,'Наличие - 3 дня',NULL,NULL),
(3,1,'Na zamówienie',NULL,NULL),
(3,2,'On order',NULL,NULL),
(3,3,'Auf Auftrag',NULL,NULL),
(3,4,'На заказе',NULL,NULL);

drop table if exists `products_description`;
CREATE TABLE `products_description` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_name` varchar(150) NOT NULL,
  `products_description` text,
  `products_short_description` text,
  `products_url` varchar(255) DEFAULT NULL,
  `products_viewed` int(5) DEFAULT '0',
  `products_head_title_tag` varchar(80) DEFAULT NULL,
  `products_head_desc_tag` longtext,
  `products_head_keywords_tag` longtext,
  `products_seo_url` varchar(100) NOT NULL,
  PRIMARY KEY (`products_id`,`language_id`),
  KEY `idx_products_name` (`products_name`)
);

insert into `products_description` (`products_id`, `language_id`, `products_name`, `products_description`, `products_short_description`, `products_url`, `products_viewed`, `products_head_title_tag`, `products_head_desc_tag`, `products_head_keywords_tag`, `products_seo_url`) values (1,1,'Opona DURO 185/65R15','Opona Duro 185/65R15<br>','','',0,'Opona DURO 185/65R15','Opona DURO 185/65R15','Opona DURO 185/65R15',''),
(1,2,'','<br>','','',0,'','','',''),
(1,3,'','<br>','','',0,'','','',''),
(1,4,'','<br>','','',0,'','','',''),
(2,1,'Opona KENDA 225/65R16','Opona KENDA 225/65R16<br>','','',0,'Opona KENDA 225/65R16','Opona KENDA 225/65R16','Opona KENDA 225/65R16',''),
(2,2,'','<br>','','',0,'','','',''),
(2,3,'','<br>','','',0,'','','',''),
(2,4,'','<br>','','',0,'','','',''),
(3,1,'Opona KENDA 225/65R16','',NULL,'',0,NULL,NULL,NULL,''),
(3,2,'','',NULL,'',0,NULL,NULL,NULL,''),
(3,3,'','',NULL,'',0,NULL,NULL,NULL,''),
(3,4,'','',NULL,'',0,NULL,NULL,NULL,''),
(105,4,'CARLISLE Versa Trail 26x11-12 68N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056016 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 68 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0425 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,095 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 26x11-12 </li><li>Typ: quady </li><li>Waga: 13,61 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,''),
(106,1,'CARLISLE Versa Trail 26x9-12 74N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056009 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 74 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0424 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,078 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 26x9-12 </li><li>Typ: quady </li><li>Waga: 11,84 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,''),
(107,1,'CARLISLE Versa Trail 27x11-12 70M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 70 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0269 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-12 </li><li>Typ: quady </li><li>Waga: 14,02 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(106,4,'CARLISLE Versa Trail 26x9-12 74N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056009 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 74 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0424 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,078 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 26x9-12 </li><li>Typ: quady </li><li>Waga: 11,84 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,''),
(105,3,'CARLISLE Versa Trail 26x11-12 68N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056016 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 68 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0425 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,095 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 26x11-12 </li><li>Typ: quady </li><li>Waga: 13,61 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,''),
(105,1,'CARLISLE Versa Trail 26x11-12 68N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056016 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 68 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0425 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,095 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 26x11-12 </li><li>Typ: quady </li><li>Waga: 13,61 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,''),
(105,2,'CARLISLE Versa Trail 26x11-12 68N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056016 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 68 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0425 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,095 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 26x11-12 </li><li>Typ: quady </li><li>Waga: 13,61 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,''),
(106,2,'CARLISLE Versa Trail 26x9-12 74N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056009 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 74 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0424 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,078 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 26x9-12 </li><li>Typ: quady </li><li>Waga: 11,84 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,'');
insert into `products_description` (`products_id`, `language_id`, `products_name`, `products_description`, `products_short_description`, `products_url`, `products_viewed`, `products_head_title_tag`, `products_head_desc_tag`, `products_head_keywords_tag`, `products_seo_url`) values (106,3,'CARLISLE Versa Trail 26x9-12 74N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056009 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 74 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0424 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,078 </li><li>Producent: CARLISLE </li><li>Rozmiar: 26x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 26x9-12 </li><li>Typ: quady </li><li>Waga: 11,84 </li><li>Wysokość: 26 </li></ul>','','',1,NULL,NULL,NULL,''),
(107,2,'CARLISLE Versa Trail 27x11-12 70M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 70 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0269 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-12 </li><li>Typ: quady </li><li>Waga: 14,02 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(107,3,'CARLISLE Versa Trail 27x11-12 70M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 70 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0269 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-12 </li><li>Typ: quady </li><li>Waga: 14,02 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(107,4,'CARLISLE Versa Trail 27x11-12 70M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 70 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0269 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-12 </li><li>Typ: quady </li><li>Waga: 14,02 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(108,1,'CARLISLE Versa Trail 27x9-12 63M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 63 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0268 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,084 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 27x9-12 </li><li>Typ: quady </li><li>Waga: 12,16 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(108,2,'CARLISLE Versa Trail 27x9-12 63M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 63 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0268 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,084 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 27x9-12 </li><li>Typ: quady </li><li>Waga: 12,16 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(108,3,'CARLISLE Versa Trail 27x9-12 63M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 63 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0268 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,084 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 27x9-12 </li><li>Typ: quady </li><li>Waga: 12,16 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(108,4,'CARLISLE Versa Trail 27x9-12 63M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 63 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0268 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,084 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x9-12 </li><li>Rozmiar felgi: 12 </li><li>Sezon: letnie </li><li>Szerokość: 9 </li><li>Tabela: 27x9-12 </li><li>Typ: quady </li><li>Waga: 12,16 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(109,1,'CARLISLE Versa Trail 27x11-14 78N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056030 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 78 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0427 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-14 </li><li>Typ: quady </li><li>Waga: 14,20 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(109,2,'CARLISLE Versa Trail 27x11-14 78N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056030 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 78 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0427 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-14 </li><li>Typ: quady </li><li>Waga: 14,20 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(109,3,'CARLISLE Versa Trail 27x11-14 78N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056030 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 78 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0427 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-14 </li><li>Typ: quady </li><li>Waga: 14,20 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(109,4,'CARLISLE Versa Trail 27x11-14 78N #E','<ul id=\"action2osCommerce\"><li>EAN: 070964056030 </li><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 78 </li><li>Indeks prędkości: N </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6E0427 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,103 </li><li>Producent: CARLISLE </li><li>Rozmiar: 27x11-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 11 </li><li>Tabela: 27x11-14 </li><li>Typ: quady </li><li>Waga: 14,20 </li><li>Wysokość: 27 </li></ul>','','',1,NULL,NULL,NULL,''),
(110,1,'CARLISLE Versa Trail 28x10-14 67M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 67 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0276 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,100 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x10-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 10 </li><li>Tabela: 28x10-14 </li><li>Typ: quady </li><li>Waga: 13,97 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,''),
(110,2,'CARLISLE Versa Trail 28x10-14 67M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 67 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0276 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,100 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x10-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 10 </li><li>Tabela: 28x10-14 </li><li>Typ: quady </li><li>Waga: 13,97 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,''),
(110,3,'CARLISLE Versa Trail 28x10-14 67M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 67 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0276 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,100 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x10-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 10 </li><li>Tabela: 28x10-14 </li><li>Typ: quady </li><li>Waga: 13,97 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,''),
(110,4,'CARLISLE Versa Trail 28x10-14 67M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 67 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0276 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,100 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x10-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 10 </li><li>Tabela: 28x10-14 </li><li>Typ: quady </li><li>Waga: 13,97 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,''),
(111,1,'CARLISLE Versa Trail 28x12-14 73M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 73 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0277 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,121 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x12-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 12 </li><li>Tabela: 28x12-14 </li><li>Typ: quady </li><li>Waga: 15,74 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,''),
(111,2,'CARLISLE Versa Trail 28x12-14 73M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 73 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0277 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,121 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x12-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 12 </li><li>Tabela: 28x12-14 </li><li>Typ: quady </li><li>Waga: 15,74 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,''),
(111,3,'CARLISLE Versa Trail 28x12-14 73M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 73 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0277 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,121 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x12-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 12 </li><li>Tabela: 28x12-14 </li><li>Typ: quady </li><li>Waga: 15,74 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,''),
(111,4,'CARLISLE Versa Trail 28x12-14 73M NHS','<ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Indeks nośności: 73 </li><li>Indeks prędkości: M </li><li>Informacje ogólne: CARLISLE Versa Trail to opona, która dzięki nowej mieszance gumy \"Tough Tread\" chroni przed uderzeniami, przecięciami,  przekłuciami i odrywaniu kawałków bieżnika. Na etapie projektowania opony zespół badawczo-rozwojowy wykorzystywał wspomagane komputerowo obrazy, aby stworzyć optymalny mający 3/4 cala, niekierunkowy wzór bieżnika. 
Versa Trail ATR zwiększają uniwersalność w terenie i optymalizują trakcję bez uszczerbku dla komfortu.

Główne cechy opony:
- bezkierunkowy wzór bieżnika zapewnia płynną jazdę w każdym terenie ,
- trwała konstrukcja o strukturze sześciopiętrowej i tkanina nylonowa zapewniają niezrównaną oporność na przebicie,
- głęboki &#8222;Rim protector&#8221; zaprojektowany w celu ochrony felgi przed uszkodzeniami. </li><li>Kod producenta: 6P0277 </li><li>Nazwa: Versa Trail </li><li>O Carlise: Wiodący amerykański koncern założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii. 
Carlisle Tire and Rubber Company stał się jednym z największych producentów opon specjalistycznych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, pojazdów terenowych oraz innych pojazdów specjalistycznych.
Firma Carlisle jest najczęstszą marką opon używaną przez producentów maszyn rolniczych i ogrodowych do pierwszego montażu. </li><li>Objętość: 0,121 </li><li>Producent: CARLISLE </li><li>Rozmiar: 28x12-14 </li><li>Rozmiar felgi: 14 </li><li>Sezon: letnie </li><li>Szerokość: 12 </li><li>Tabela: 28x12-14 </li><li>Typ: quady </li><li>Waga: 15,74 </li><li>Wysokość: 28 </li></ul>','','',1,NULL,NULL,NULL,'');
insert into `products_description` (`products_id`, `language_id`, `products_name`, `products_description`, `products_short_description`, `products_url`, `products_viewed`, `products_head_title_tag`, `products_head_desc_tag`, `products_head_keywords_tag`, `products_seo_url`) values (112,1,'Dętka CARLISLE 900-10 Tr-150 Tube','<p>Wytrzymała dętka renomowanego producenta z zaworkiem typu TR-150, stosowana do kół maszyn i pojazdów rolniczych oraz przemysłowych.</p><ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Kod producenta: 322302 </li><li>O Carlise: Lider rynku i wiodący amerykański koncern oponiarski, założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii.

Carlisle stał się jednym z największych producentów opon użytkowych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, użytkowych pojazdów terenowych, maszyn rolniczych, ogrodniczych oraz innych pojazdów specjalistycznych.

Carlisle jest chyba najpopularniejszą marką opon profesjonalnych, używaną przez wiodących producentów maszyn  i pojazdów rolniczych i ogrodowych na tzw. pierwszy montaż. </li><li>Objętość: 0,001 </li><li>Producent: CARLISLE </li><li>Producent informuje: Opony stosowane w niektórych maszynach i pojazdach rolniczych, przemysłowych i innych są często przeznaczone do stosowania z dętkami (opony dętkowe). Prawidłowe stosowanie dętek zapobiega nieszczelności i utracie ciśnienia w kole, umożliwia długotrwałe użytkowanie, zmniejsza opory toczenia, ułatwia pracę pod dużym obciążeniem, chroni bieżnik i zwiększa odporność na uszkodzenia związane ze starzeniem 
i oddziaływaniem ciepła. Dętki Carlisle zostały zaprojektowane, aby zapewnić najlepszą szczelność i retencję powietrza wewnątrz, wysoką stabilność wymiarów w trakcie użytkowania 
i zmniejszenie przestojów urządzeń.
Niektóre opony są bezdętkowe, co oznacza, że nie wymagają dętki. Carlisle zaleca, aby opony bezdętkowe były użytkowane bez dętek. Nie należy używać dętki, aby \"naprawić\" nieszczelne koło z oponą bezdętkową. Uszkodzone opony bezdętkowe powinny być sprawdzone i - jeśli to możliwe - naprawione przez specjalistyczny serwis opon.
Podczas używania opon dętkowych, zmianie opony na nową itp., należy zawsze upewnić się, czy zastosowano właściwą dętkę, prawidłowy ochraniacz dętki (tzw. flap) oraz właściwy typ 
i rodzaj zaworu.
(Tłum.własne, tekst oryg.poniżej)

Tires in certain agricultural, industrial and other application segments are designed for use with tubes. Correct use of tire tubes can prevent air leakage, sustain long term use, reduce rolling resistance, support heavy loads, preserve tread life, and offer resistance to age and heat-related failure. Carlisle tubes have been designed for best air retention properties, high dimensional stability during service and reduced equipment downtime.
Some tires are tubeless tires, meaning they don\'t require a tube. Carlisle recommends that tubeless tires be used without tubes. Do not use a tube to \"fix\" a flat tire. Flat tires should be inspected and repaired (if possible) by a tire dealer.
When using a tube-type tire, be sure to use the proper size tube, the proper flap and an appropriate wheel/valve stem style with a new tire.
Źródło:http://www.carlisletransportationproducts.com/product/tires/tubes-flaps) </li><li>Przeznaczenie: Opona SUNF G-002 jest oponą przeznaczoną do traktorków ogrodowych i kosiarek samojezdnych, mini quadów i pojazdów typu melex. </li><li>Rozmiar: 900-10 </li><li>Tabela: Dętka 900-10 </li><li>Typ: przemysłowe </li><li>Waga: 1 </li></ul>','','',1,NULL,NULL,NULL,''),
(112,2,'Dętka CARLISLE 900-10 Tr-150 Tube','<p>Wytrzymała dętka renomowanego producenta z zaworkiem typu TR-150, stosowana do kół maszyn i pojazdów rolniczych oraz przemysłowych.</p><ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Kod producenta: 322302 </li><li>O Carlise: Lider rynku i wiodący amerykański koncern oponiarski, założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii.

Carlisle stał się jednym z największych producentów opon użytkowych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, użytkowych pojazdów terenowych, maszyn rolniczych, ogrodniczych oraz innych pojazdów specjalistycznych.

Carlisle jest chyba najpopularniejszą marką opon profesjonalnych, używaną przez wiodących producentów maszyn  i pojazdów rolniczych i ogrodowych na tzw. pierwszy montaż. </li><li>Objętość: 0,001 </li><li>Producent: CARLISLE </li><li>Producent informuje: Opony stosowane w niektórych maszynach i pojazdach rolniczych, przemysłowych i innych są często przeznaczone do stosowania z dętkami (opony dętkowe). Prawidłowe stosowanie dętek zapobiega nieszczelności i utracie ciśnienia w kole, umożliwia długotrwałe użytkowanie, zmniejsza opory toczenia, ułatwia pracę pod dużym obciążeniem, chroni bieżnik i zwiększa odporność na uszkodzenia związane ze starzeniem 
i oddziaływaniem ciepła. Dętki Carlisle zostały zaprojektowane, aby zapewnić najlepszą szczelność i retencję powietrza wewnątrz, wysoką stabilność wymiarów w trakcie użytkowania 
i zmniejszenie przestojów urządzeń.
Niektóre opony są bezdętkowe, co oznacza, że nie wymagają dętki. Carlisle zaleca, aby opony bezdętkowe były użytkowane bez dętek. Nie należy używać dętki, aby \"naprawić\" nieszczelne koło z oponą bezdętkową. Uszkodzone opony bezdętkowe powinny być sprawdzone i - jeśli to możliwe - naprawione przez specjalistyczny serwis opon.
Podczas używania opon dętkowych, zmianie opony na nową itp., należy zawsze upewnić się, czy zastosowano właściwą dętkę, prawidłowy ochraniacz dętki (tzw. flap) oraz właściwy typ 
i rodzaj zaworu.
(Tłum.własne, tekst oryg.poniżej)

Tires in certain agricultural, industrial and other application segments are designed for use with tubes. Correct use of tire tubes can prevent air leakage, sustain long term use, reduce rolling resistance, support heavy loads, preserve tread life, and offer resistance to age and heat-related failure. Carlisle tubes have been designed for best air retention properties, high dimensional stability during service and reduced equipment downtime.
Some tires are tubeless tires, meaning they don\'t require a tube. Carlisle recommends that tubeless tires be used without tubes. Do not use a tube to \"fix\" a flat tire. Flat tires should be inspected and repaired (if possible) by a tire dealer.
When using a tube-type tire, be sure to use the proper size tube, the proper flap and an appropriate wheel/valve stem style with a new tire.
Źródło:http://www.carlisletransportationproducts.com/product/tires/tubes-flaps) </li><li>Przeznaczenie: Opona SUNF G-002 jest oponą przeznaczoną do traktorków ogrodowych i kosiarek samojezdnych, mini quadów i pojazdów typu melex. </li><li>Rozmiar: 900-10 </li><li>Tabela: Dętka 900-10 </li><li>Typ: przemysłowe </li><li>Waga: 1 </li></ul>','','',1,NULL,NULL,NULL,''),
(112,3,'Dętka CARLISLE 900-10 Tr-150 Tube','<p>Wytrzymała dętka renomowanego producenta z zaworkiem typu TR-150, stosowana do kół maszyn i pojazdów rolniczych oraz przemysłowych.</p><ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Kod producenta: 322302 </li><li>O Carlise: Lider rynku i wiodący amerykański koncern oponiarski, założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii.

Carlisle stał się jednym z największych producentów opon użytkowych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, użytkowych pojazdów terenowych, maszyn rolniczych, ogrodniczych oraz innych pojazdów specjalistycznych.

Carlisle jest chyba najpopularniejszą marką opon profesjonalnych, używaną przez wiodących producentów maszyn  i pojazdów rolniczych i ogrodowych na tzw. pierwszy montaż. </li><li>Objętość: 0,001 </li><li>Producent: CARLISLE </li><li>Producent informuje: Opony stosowane w niektórych maszynach i pojazdach rolniczych, przemysłowych i innych są często przeznaczone do stosowania z dętkami (opony dętkowe). Prawidłowe stosowanie dętek zapobiega nieszczelności i utracie ciśnienia w kole, umożliwia długotrwałe użytkowanie, zmniejsza opory toczenia, ułatwia pracę pod dużym obciążeniem, chroni bieżnik i zwiększa odporność na uszkodzenia związane ze starzeniem 
i oddziaływaniem ciepła. Dętki Carlisle zostały zaprojektowane, aby zapewnić najlepszą szczelność i retencję powietrza wewnątrz, wysoką stabilność wymiarów w trakcie użytkowania 
i zmniejszenie przestojów urządzeń.
Niektóre opony są bezdętkowe, co oznacza, że nie wymagają dętki. Carlisle zaleca, aby opony bezdętkowe były użytkowane bez dętek. Nie należy używać dętki, aby \"naprawić\" nieszczelne koło z oponą bezdętkową. Uszkodzone opony bezdętkowe powinny być sprawdzone i - jeśli to możliwe - naprawione przez specjalistyczny serwis opon.
Podczas używania opon dętkowych, zmianie opony na nową itp., należy zawsze upewnić się, czy zastosowano właściwą dętkę, prawidłowy ochraniacz dętki (tzw. flap) oraz właściwy typ 
i rodzaj zaworu.
(Tłum.własne, tekst oryg.poniżej)

Tires in certain agricultural, industrial and other application segments are designed for use with tubes. Correct use of tire tubes can prevent air leakage, sustain long term use, reduce rolling resistance, support heavy loads, preserve tread life, and offer resistance to age and heat-related failure. Carlisle tubes have been designed for best air retention properties, high dimensional stability during service and reduced equipment downtime.
Some tires are tubeless tires, meaning they don\'t require a tube. Carlisle recommends that tubeless tires be used without tubes. Do not use a tube to \"fix\" a flat tire. Flat tires should be inspected and repaired (if possible) by a tire dealer.
When using a tube-type tire, be sure to use the proper size tube, the proper flap and an appropriate wheel/valve stem style with a new tire.
Źródło:http://www.carlisletransportationproducts.com/product/tires/tubes-flaps) </li><li>Przeznaczenie: Opona SUNF G-002 jest oponą przeznaczoną do traktorków ogrodowych i kosiarek samojezdnych, mini quadów i pojazdów typu melex. </li><li>Rozmiar: 900-10 </li><li>Tabela: Dętka 900-10 </li><li>Typ: przemysłowe </li><li>Waga: 1 </li></ul>','','',1,NULL,NULL,NULL,''),
(112,4,'Dętka CARLISLE 900-10 Tr-150 Tube','<p>Wytrzymała dętka renomowanego producenta z zaworkiem typu TR-150, stosowana do kół maszyn i pojazdów rolniczych oraz przemysłowych.</p><ul id=\"action2osCommerce\"><li>Gwarancja: <a href=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png rel=lightbox[produkt]><img src=http://www.nowegumy.pl/katalogi/gwarancje/gwar_carlisle.png></a> </li><li>Kod producenta: 322302 </li><li>O Carlise: Lider rynku i wiodący amerykański koncern oponiarski, założony w 1917 roku przez Charlesa S. Moomy w Carlisle w Pensylwanii.

Carlisle stał się jednym z największych producentów opon użytkowych. Zatrudnia ponad 4000 pracowników na całym świecie i produkuje wysokiej jakości opony, dętki i kółka do kosiarek, wózków golfowych, przyczep, użytkowych pojazdów terenowych, maszyn rolniczych, ogrodniczych oraz innych pojazdów specjalistycznych.

Carlisle jest chyba najpopularniejszą marką opon profesjonalnych, używaną przez wiodących producentów maszyn  i pojazdów rolniczych i ogrodowych na tzw. pierwszy montaż. </li><li>Objętość: 0,001 </li><li>Producent: CARLISLE </li><li>Producent informuje: Opony stosowane w niektórych maszynach i pojazdach rolniczych, przemysłowych i innych są często przeznaczone do stosowania z dętkami (opony dętkowe). Prawidłowe stosowanie dętek zapobiega nieszczelności i utracie ciśnienia w kole, umożliwia długotrwałe użytkowanie, zmniejsza opory toczenia, ułatwia pracę pod dużym obciążeniem, chroni bieżnik i zwiększa odporność na uszkodzenia związane ze starzeniem 
i oddziaływaniem ciepła. Dętki Carlisle zostały zaprojektowane, aby zapewnić najlepszą szczelność i retencję powietrza wewnątrz, wysoką stabilność wymiarów w trakcie użytkowania 
i zmniejszenie przestojów urządzeń.
Niektóre opony są bezdętkowe, co oznacza, że nie wymagają dętki. Carlisle zaleca, aby opony bezdętkowe były użytkowane bez dętek. Nie należy używać dętki, aby \"naprawić\" nieszczelne koło z oponą bezdętkową. Uszkodzone opony bezdętkowe powinny być sprawdzone i - jeśli to możliwe - naprawione przez specjalistyczny serwis opon.
Podczas używania opon dętkowych, zmianie opony na nową itp., należy zawsze upewnić się, czy zastosowano właściwą dętkę, prawidłowy ochraniacz dętki (tzw. flap) oraz właściwy typ 
i rodzaj zaworu.
(Tłum.własne, tekst oryg.poniżej)

Tires in certain agricultural, industrial and other application segments are designed for use with tubes. Correct use of tire tubes can prevent air leakage, sustain lo