# oscGold
# http://www.oscgold.com
#
# Kopia bazy sklepu Sklep internetowy
# Copyright (c) 2017 oscGold
#
# Nazwa bazy: jotte_oscgold
# Serwr bazy: localhost
#
# Data archiwum: 09/12/2017 11:05:50
# Zarchwizowane tabele: additional_images, address_book, address_format, admin, admin_access_files, admin_files, admin_groups, allegro_config, allegro_kategorie, am_attributes_to_templates, am_templates, anti_robotreg, banners, banners_history, cache, categories, categories_description, configuration, configuration_group, contact, counter, counter_history, countries, currencies, customers, customers_basket, customers_basket_attributes, customers_basket_text_attributes, customers_groups, customers_info, customers_points_pending, customers_to_extra_fields, customers_wishlist, customers_wishlist_attributes, discount_coupons, discount_coupons_to_categories, discount_coupons_to_customers, discount_coupons_to_manufacturers, discount_coupons_to_orders, discount_coupons_to_products, discount_coupons_to_zones, extra_fields, extra_fields_info, faq, faq_description, featured, geo_zones, headertags, headertags_default, invoices_symfonia, languages, mailing, manudiscount, manufacturers, manufacturers_info, modules_configuration, newsdesk, newsdesk_categories, newsdesk_categories_description, newsdesk_configuration, newsdesk_configuration_group, newsdesk_description, newsdesk_reviews, newsdesk_reviews_description, newsdesk_to_categories, newsletters, newsletters_tmp, onet_category_map, optimize_check, orders, orders_products, orders_products_attributes, orders_products_download, orders_status, orders_status_history, orders_text_attributes, orders_total, pages, pages_description, phesis_comments, phesis_poll_check, phesis_poll_config, phesis_poll_data, phesis_poll_desc, porownywarki, products, products_attributes, products_attributes_download, products_availability, products_description, products_extra_fields, products_jm, products_notifications, products_options, products_options_products, products_options_values, products_options_values_to_products_options, products_stock, products_text_attributes, products_text_attributes_enabled, products_to_categories, products_to_products_extra_fields, recently_view, reviews, reviews_description, sessions, ship2pay, specials, star_product, subscribers, swistak_categories, swistak_export_import, swistak_xml_categories, tax_class, tax_rates, templates, theme_configuration, ticket_priority, ticket_reply, ticket_status, ticket_status_history, ticket_ticket, whos_online, zones, zones_to_geo_zones

drop table if exists `additional_images`;
CREATE TABLE `additional_images` (
  `additional_images_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `images_description` varchar(64) DEFAULT NULL,
  `medium_images` varchar(120) DEFAULT NULL,
  `popup_images` varchar(120) DEFAULT NULL,
  PRIMARY KEY (`additional_images_id`),
  KEY `idx_products_id` (`products_id`)
);

drop table if exists `address_book`;
CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_gender` char(1) NOT NULL,
  `entry_company` varchar(256) DEFAULT NULL,
  `entry_nip` varchar(32) DEFAULT NULL,
  `entry_firstname` varchar(32) NOT NULL,
  `entry_lastname` varchar(32) NOT NULL,
  `entry_street_address` varchar(64) NOT NULL,
  `entry_suburb` varchar(32) DEFAULT NULL,
  `entry_postcode` varchar(10) NOT NULL,
  `entry_city` varchar(32) NOT NULL,
  `entry_state` varchar(32) DEFAULT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_book_id`,`customers_id`),
  KEY `idx_customers_id` (`customers_id`)
);

drop table if exists `address_format`;
CREATE TABLE `address_format` (
  `address_format_id` int(11) NOT NULL AUTO_INCREMENT,
  `address_format` varchar(128) NOT NULL,
  `address_summary` varchar(48) NOT NULL,
  PRIMARY KEY (`address_format_id`)
);

insert into `address_format` (`address_format_id`, `address_format`, `address_summary`) values (1,'$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country'),
(2,'$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country'),
(3,'$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$state / $country'),
(4,'$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country','$postcode / $country'),
(5,'$firstname $lastname$cr$streets$cr$postcode $city$cr$country','$city / $country');

drop table if exists `admin`;
CREATE TABLE `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_id` int(11) DEFAULT NULL,
  `admin_firstname` varchar(32) NOT NULL,
  `admin_lastname` varchar(32) DEFAULT NULL,
  `admin_email_address` varchar(96) NOT NULL,
  `admin_password` varchar(40) NOT NULL,
  `admin_created` datetime DEFAULT NULL,
  `admin_modified` datetime NOT NULL,
  `admin_logdate` datetime DEFAULT NULL,
  `admin_lognum` int(11) NOT NULL DEFAULT '0',
  `admin_cat_access` text NOT NULL,
  `admin_right_access` text NOT NULL,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `idx_admin_email_address` (`admin_email_address`)
);

insert into `admin` (`admin_id`, `admin_groups_id`, `admin_firstname`, `admin_lastname`, `admin_email_address`, `admin_password`, `admin_created`, `admin_modified`, `admin_logdate`, `admin_lognum`, `admin_cat_access`, `admin_right_access`) values (1,1,'Admin','Admin','jarek@vancar.pl','f875fadfc83d1e37ec8034f1da3db108:d0','2009-11-30 10:09:19','2009-11-30 23:03:51','2017-09-12 12:18:02',13,'ALL','');

drop table if exists `admin_access_files`;
CREATE TABLE `admin_access_files` (
  `file_access_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_files_id` int(11) NOT NULL DEFAULT '0',
  `admin_id` int(11) NOT NULL DEFAULT '1',
  `admin_access_values` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`file_access_id`)
);

insert into `admin_access_files` (`file_access_id`, `admin_files_id`, `admin_id`, `admin_access_values`) values (1,11,3,3),
(2,110,2,2),
(3,112,2,2);

drop table if exists `admin_files`;
CREATE TABLE `admin_files` (
  `admin_files_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_files_name` varchar(64) NOT NULL,
  `admin_files_is_boxes` tinyint(5) NOT NULL DEFAULT '0',
  `admin_files_to_boxes` int(11) NOT NULL DEFAULT '0',
  `admin_groups_id` set('1','2','3','4','5') NOT NULL DEFAULT '1',
  PRIMARY KEY (`admin_files_id`),
  KEY `idx_admin_files_is_boxes` (`admin_files_is_boxes`),
  KEY `idx_admin_files_name` (`admin_files_name`)
);

insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (1,'administrator.php',1,0,'1'),
(11,'admin_files.php',0,1,'1'),
(10,'admin_members.php',0,1,'1'),
(223,'swistak_assoc_categories.php',0,157,'1'),
(123,'all_customers.php',0,8,'1'),
(110,'attributeManager.php',0,3,'1,3'),
(157,'integracje.php',1,0,'1'),
(34,'banner_manager.php',0,9,'1,2,5'),
(42,'banner_statistics.php',0,9,'1,2,5'),
(35,'cache.php',0,9,'1,5'),
(3,'catalog.php',1,0,'1,2,3'),
(13,'categories.php',0,3,'1,2,3'),
(66,'catimagessetup.php',0,46,'1,3'),
(172,'customers_points.php',0,5,'1'),
(65,'column_controller.php',0,52,'1'),
(47,'configuration.php',0,46,'1,3'),
(46,'configuration.php',1,0,'1,3'),
(22,'countries.php',0,6,'1'),
(112,'coupons.php',0,3,'1,3'),
(119,'coupons_exclusions.php',0,3,'1,3');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (27,'currencies.php',0,7,'1'),
(5,'customers.php',1,0,'1,2'),
(20,'customers.php',0,5,'1,2'),
(71,'customers_groups.php',0,5,'1'),
(109,'default_tax_class.php',0,6,'1'),
(227,'allegro_config_setup.php',0,157,'1'),
(173,'customers_points_pending.php',0,5,'1'),
(113,'easypopulate.php',0,3,'1,3'),
(175,'create_order.php',0,5,'1'),
(124,'exportorders.php',0,8,'1'),
(94,'featured.php',0,3,'1,3'),
(37,'file_manager.php',0,9,'1,5'),
(24,'geo_zones.php',0,6,'1'),
(235,'import.php',0,3,'1'),
(185,'polls.php',0,184,'1'),
(184,'polls.php',1,0,'1'),
(183,'translator.php',0,3,'1,3'),
(182,'header_tags_fill_tags.php',0,180,'1'),
(52,'information.php',1,0,'1'),
(28,'languages.php',0,7,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (7,'localization.php',1,0,'1'),
(38,'mail.php',0,9,'1,5'),
(72,'manudiscount.php',0,5,'1'),
(15,'manufacturers.php',0,3,'1,2,3'),
(4,'modules.php',1,0,'1'),
(19,'modules.php',0,4,'1'),
(81,'newsdesk.php',0,80,'1'),
(80,'newsdesk.php',1,0,'1'),
(82,'newsdesk_configuration.php',0,80,'1'),
(83,'newsdesk_reviews.php',0,80,'1'),
(39,'newsletters.php',0,9,'1,2,5'),
(95,'newsletters.php',1,0,'1'),
(96,'newsletters_extra_default.php',0,95,'1'),
(97,'newsletters_extra_infos.php',0,95,'1'),
(98,'newsletters_subscribers_view.php',0,95,'1'),
(122,'newsletters_update.php',0,95,'1'),
(101,'optimize_db.php',0,1,'1'),
(126,'options_images.php',0,3,'1,3'),
(21,'orders.php',0,5,'1,2'),
(29,'orders_status.php',0,7,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (68,'page_manager.php',0,52,'1'),
(14,'products_attributes.php',0,3,'1,2,3'),
(59,'products_availability.php',0,7,'1'),
(18,'products_expected.php',0,3,'1,2,3'),
(111,'products_multi.php',0,3,'1,3'),
(75,'products_options.php',0,3,'1,3'),
(61,'product_extra_fields.php',0,7,'1,3'),
(74,'protection.php',0,9,'1'),
(99,'quick_attributes_popup.php',0,3,'1,3'),
(100,'quick_products_popup.php',0,3,'1,3'),
(62,'quick_updates.php',0,3,'1,3'),
(8,'reports.php',1,0,'1,2'),
(16,'reviews.php',0,3,'1,2,3'),
(40,'server_info.php',0,9,'1,5'),
(67,'ship2pay.php',0,4,'1'),
(114,'sitemonitor.php',1,0,'1'),
(115,'sitemonitor.php',0,114,'1'),
(116,'sitemonitor_admin.php',0,114,'1'),
(117,'sitemonitor_configure_setup.php',0,114,'1'),
(17,'specials.php',0,3,'1,2,3');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (128,'specials_enhanced.php',0,3,'1,3'),
(58,'star_product.php',0,3,'1,3'),
(32,'stats_customers.php',0,8,'1,2'),
(120,'stats_discount_coupons.php',0,8,'1'),
(57,'stats_low_stock.php',0,8,'1'),
(135,'stats_low_stock_attrib.php',0,8,'1'),
(31,'stats_products_purchased.php',0,8,'1,2'),
(30,'stats_products_viewed.php',0,8,'1,2'),
(133,'stats_sales.php',0,8,'1'),
(56,'stats_sales_csv.php',0,8,'1'),
(121,'stock.php',0,3,'1,3'),
(6,'taxes.php',1,0,'1'),
(25,'tax_classes.php',0,6,'1'),
(26,'tax_rates.php',0,6,'1'),
(9,'tools.php',1,0,'1,2,5'),
(41,'whos_online.php',0,9,'1,5'),
(23,'zones.php',0,6,'1'),
(136,'batch_print.php',0,5,'1'),
(137,'print_batch_invoice.php',0,5,'1'),
(138,'print_batch_process.php',0,5,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (139,'faq.php',0,9,'1'),
(140,'ksiazka_nadawcza.php',0,5,'1'),
(141,'infobox_configuration.php',0,52,'1'),
(142,'products_jm.php',0,7,'1'),
(143,'verify_language.php',0,7,'1'),
(144,'update_currencies.php',0,7,'1'),
(224,'swistak_export_offers.php',0,157,'1'),
(151,'text_attributes.php',0,3,'1,3'),
(160,'backup.php',0,9,'1'),
(197,'oferciak_offers.php',0,157,'1'),
(244,'kupujemy_offers.php',0,157,'1'),
(245,'starcode_offers.php',0,157,'1'),
(246,'smartbay_offers.php',0,157,'1'),
(247,'cenohit_offers.php',0,157,'1'),
(196,'tortura_offers.php',0,157,'1'),
(192,'configurations.php',0,52,'1'),
(193,'cenus_offers.php',0,157,'1'),
(194,'sklepy24_offers.php',0,157,'1'),
(195,'radar_offers.php',0,157,'1'),
(170,'modules_configuration.php',0,52,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (171,'stats_wishlists.php',0,8,'1'),
(174,'customers_points_referral.php',0,5,'1'),
(176,'create_order_process.php',0,5,'1'),
(180,'header_tags_seo.php',1,0,'1'),
(178,'edit_orders_add_product.php',0,5,'1'),
(179,'edit_orders.php',0,5,'1'),
(181,'header_tags_seo.php',0,180,'1'),
(187,'invoice_edit.php',0,5,'1'),
(189,'okazje_offers.php',0,157,'1'),
(190,'ceneo_offers.php',0,157,'1'),
(191,'nokaut_offers.php',0,157,'1'),
(198,'skapiec_offers.php',0,157,'1'),
(211,'change_status.php',0,9,'1'),
(200,'categories_map.php',0,157,'1'),
(201,'export_harmonogram.php',0,157,'1'),
(202,'export_list.php',0,157,'1'),
(203,'export_onet.php',0,157,'1'),
(204,'generuj.php',0,157,'1'),
(205,'harmonogram.php',0,157,'1'),
(206,'make_export.php',0,157,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (207,'save_maped.php',0,157,'1'),
(208,'category_download.php',0,157,'1'),
(209,'deleted_list.php',0,157,'1'),
(210,'stats_kat.php',0,8,'1'),
(212,'statuses.php',0,9,'1'),
(213,'porownywarki_configuration.php',0,157,'1'),
(214,'newsletters_subscribers_view_prod.php',0,95,'1'),
(215,'newsletters_subscribers_view_rej.php',0,95,'1'),
(216,'newsletters_subscribers_view_mailing.php',0,95,'1'),
(217,'totu_offers.php',0,157,'1'),
(222,'swistak_import_categories.php',0,157,'1'),
(225,'swistak_prepare_offers.php',0,157,'1'),
(226,'allegro.php',0,157,'1'),
(228,'header_tags_seo_popup_logotext.php',0,180,'1'),
(229,'header_tags_test.php',0,180,'1'),
(230,'seo_oscgold.php',0,231,'1'),
(231,'seo.php',1,0,'1'),
(232,'seo_pr.php',0,231,'1'),
(233,'seo_pozycja.php',0,231,'1'),
(234,'seo_sites.php',0,231,'1');
insert into `admin_files` (`admin_files_id`, `admin_files_name`, `admin_files_is_boxes`, `admin_files_to_boxes`, `admin_groups_id`) values (236,'xlsinvoice.php',0,5,'1'),
(237,'ticket.php',1,0,'1'),
(238,'ticket_priority.php',0,237,'1'),
(239,'ticket_reply.php',0,237,'1'),
(248,'exportinvoices.php',0,8,'1'),
(249,'extra_fields.php',0,7,'1'),
(250,'contact.php',0,7,'1'),
(251,'ticket_status.php',0,237,'1'),
(252,'ticket_view.php',0,237,'1'),
(255,'pkt_offers.php',0,157,'1'),
(256,'pokaz_kategorie.php',0,157,'1'),
(258,'tanio_offers.php',0,157,'1');

drop table if exists `admin_groups`;
CREATE TABLE `admin_groups` (
  `admin_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`admin_groups_id`),
  UNIQUE KEY `idx_admin_groups_name` (`admin_groups_name`)
);

insert into `admin_groups` (`admin_groups_id`, `admin_groups_name`) values (1,'Administrator'),
(2,'Marketing'),
(3,'Właściciel'),
(4,'Obsługa reklamacji');

drop table if exists `allegro_config`;
CREATE TABLE `allegro_config` (
  `parametr` varchar(250) NOT NULL,
  `dane` text NOT NULL
);

insert into `allegro_config` (`parametr`, `dane`) values ('hash',''),
('webapi_haslo','xxxxXX'),
('webapi_wersja',''),
('id_allegro','1234567890'),
('kraj',''),
('kod_pocztowy','XX-XXX'),
('czas_trwania','2'),
('rodzaj_aukcji','0'),
('wojewodztwo','2'),
('miejscowosc','Miejscowosc'),
('koszty_transportu','1'),
('bank_account_raz','12345678901234567890123456'),
('bank_account_dwa',''),
('dodatkowe_opcje','null|1|null|null|null|null|null'),
('opcje_transportu','null|null|null|null|4|null'),
('formy_platnosci','0|null|null|null|4|5'),
('dodatkowy_opis','Jakiś tam dodatkowy opis wysyłek i płatności'),
('darmowe_opcje_wysylki','null|null'),
('paczka_pocztowa_ekonomiczna',''),
('list_ekonomiczny','');
insert into `allegro_config` (`parametr`, `dane`) values ('paczka_pocztowa_priorytetowa',''),
('list_priorytetowy',''),
('przesylka_pobraniowa',''),
('list_polecony_ekonomiczny','7.00'),
('przesylka_pobraniowa_priorytetowa',''),
('list_polecony_priorytetowy','8.00'),
('przesylka_kurierska',''),
('przesylka_kurierska_pobraniowa',''),
('szablon','001');

drop table if exists `allegro_kategorie`;
CREATE TABLE `allegro_kategorie` (
  `catid` int(11) NOT NULL,
  `catname` varchar(70) NOT NULL,
  `catparent` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL,
  KEY `cat_id` (`catid`)
);

drop table if exists `am_attributes_to_templates`;
CREATE TABLE `am_attributes_to_templates` (
  `template_id` int(5) unsigned NOT NULL,
  `options_id` int(5) unsigned NOT NULL,
  `option_values_id` int(5) unsigned NOT NULL,
  `products_options_sort_order` int(6) NOT NULL DEFAULT '0',
  `options_values_price` decimal(15,4) DEFAULT '0.0000',
  `price_prefix` char(1) DEFAULT '+',
  `options_values_weight` decimal(6,3) NOT NULL DEFAULT '0.000',
  KEY `idx_template_id` (`template_id`)
);

drop table if exists `am_templates`;
CREATE TABLE `am_templates` (
  `template_id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `template_name` varchar(255) NOT NULL,
  PRIMARY KEY (`template_id`)
);

drop table if exists `anti_robotreg`;
CREATE TABLE `anti_robotreg` (
  `session_id` char(32) NOT NULL,
  `reg_key` char(10) NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`session_id`)
);

insert into `anti_robotreg` (`session_id`, `reg_key`, `timestamp`) values ('99uv31kig7elh44h7nu8fum973','YED6',1504310065);

drop table if exists `banners`;
CREATE TABLE `banners` (
  `banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_title` varchar(64) NOT NULL,
  `banners_url` varchar(255) NOT NULL,
  `banners_image` varchar(64) NOT NULL,
  `banners_group` varchar(32) NOT NULL,
  `banners_html_text` text,
  `expires_impressions` int(7) DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `date_scheduled` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `sort_order` int(3) DEFAULT NULL,
  PRIMARY KEY (`banners_id`),
  KEY `idx_banners_group` (`banners_group`),
  KEY `idx_banners_status` (`status`),
  KEY `idx_date_scheduled` (`date_scheduled`),
  KEY `idx_expires_date` (`expires_date`)
);

drop table if exists `banners_history`;
CREATE TABLE `banners_history` (
  `banners_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_id` int(11) NOT NULL,
  `banners_shown` int(5) NOT NULL DEFAULT '0',
  `banners_clicked` int(5) NOT NULL DEFAULT '0',
  `banners_history_date` datetime NOT NULL,
  PRIMARY KEY (`banners_history_id`),
  KEY `idx_banners_id` (`banners_id`)
);

drop table if exists `cache`;
CREATE TABLE `cache` (
  `cache_id` varchar(32) NOT NULL,
  `cache_language_id` tinyint(1) NOT NULL DEFAULT '0',
  `cache_name` varchar(255) NOT NULL,
  `cache_data` mediumtext NOT NULL,
  `cache_global` tinyint(1) NOT NULL DEFAULT '1',
  `cache_gzip` tinyint(1) NOT NULL DEFAULT '1',
  `cache_method` varchar(20) NOT NULL DEFAULT 'RETURN',
  `cache_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cache_expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`cache_id`,`cache_language_id`),
  KEY `idx_cache_expires` (`cache_expires`),
  KEY `idx_cache_global` (`cache_global`),
  KEY `idx_cache_id` (`cache_id`),
  KEY `idx_cache_language_id` (`cache_language_id`)
);

insert into `cache` (`cache_id`, `cache_language_id`, `cache_name`, `cache_data`, `cache_global`, `cache_gzip`, `cache_method`, `cache_date`, `cache_expires`) values ('a93b9170a03ff54d81e95917742ea01b',1,'seo_urls_v2_categories','S0lNy8xL1VB3dgxxdfcPioz3c/R1jTc0UddRUE9JLcnO1M0vyM9T17TmSsGu0pholUZEqzQkWqVJvKEBpmIA',1,1,'EVAL','2017-09-12 11:03:18','2017-10-12 11:03:18'),
('ca34fbe5f9a075091ad59abf02c259a7',1,'seo_urls_v2_products','AwA=',1,1,'EVAL','2017-09-12 11:03:18','2017-10-12 11:03:18'),
('4404c1df54fdb1291c8dd9bb259f32a9',1,'seo_urls_v2_manufacturers','AwA=',1,1,'EVAL','2017-09-12 11:03:18','2017-10-12 11:03:18');

drop table if exists `categories`;
CREATE TABLE `categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(120) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `categories_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `swistak_categories_id` int(11) NOT NULL DEFAULT '0',
  `action` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`categories_id`),
  UNIQUE KEY `action` (`action`),
  KEY `idx_categories_status` (`categories_status`),
  KEY `idx_parent_id_cat_id` (`parent_id`,`categories_id`),
  KEY `idx_sort_order` (`sort_order`)
);

drop table if exists `categories_description`;
CREATE TABLE `categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(65) NOT NULL,
  `categories_heading_title` varchar(64) DEFAULT NULL,
  `categories_description` text,
  `categories_htc_title_tag` varchar(80) DEFAULT NULL,
  `categories_htc_desc_tag` longtext,
  `categories_htc_keywords_tag` longtext,
  `categories_htc_description` longtext,
  `categories_seo_url` varchar(100) NOT NULL,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_id` (`categories_id`),
  KEY `idx_categories_name` (`categories_name`),
  KEY `idx_language_id` (`language_id`)
);

drop table if exists `configuration`;
CREATE TABLE `configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(255) NOT NULL,
  `configuration_key` varchar(64) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`configuration_id`),
  KEY `idx_configuration_group_id` (`configuration_group_id`),
  KEY `idx_configuration_key` (`configuration_key`),
  KEY `idx_configuration_key_value` (`configuration_key`,`configuration_value`),
  KEY `idx_configuration_value` (`configuration_value`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_sort_order` (`sort_order`)
);

insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1,'Nazwa sklepu','STORE_NAME','Sklep internetowy','Nazwa sklepu',1,1,'2009-03-26 15:33:21','2003-07-29 13:05:38',NULL,NULL),
(2,'Właściciel sklepu','STORE_OWNER','oscGold','Nazwisko właściciela sklepu',1,2,'2009-03-30 10:32:18','2003-07-29 13:05:38',NULL,NULL),
(3,'Adres e-mail','STORE_OWNER_EMAIL_ADDRESS','adres@email.pl','Adres e-mail właściciela sklepu',1,5,'2009-11-30 22:06:18','2003-07-29 13:05:38',NULL,NULL),
(4,'Adres wychodących e-maili','EMAIL_FROM','adres@email.pl','Adres e-mail dla poczty wysyłanej przez sklep',1,6,'2009-11-30 22:06:26','2003-07-29 13:05:38',NULL,NULL),
(5,'Kraj','STORE_COUNTRY','170','Kraj, w którym znajduje się sklep <br><br><b>Uwaga: Trzeba pamiętać o uktualnieniu strefy sklepu.</b>',1,8,'2006-08-11 14:44:00','2003-07-29 13:05:38','tep_get_country_name','tep_cfg_pull_down_country_list('),
(6,'Strefa','STORE_ZONE','2','Strefa, w której znajduje się sklep',1,9,'2005-11-13 07:20:03','2003-07-29 13:05:38','tep_cfg_get_zone_name','tep_cfg_pull_down_zone_list('),
(4106,'Menu edytora HTML WYSIWYG ','DISPLAY_FCKEDITOR_MENU','oscGold','Jakie menu ma używanac edytor HTML WYSIWYG',101,121,'2008-01-24 08:23:06','2007-12-18 20:37:02',NULL,'tep_cfg_select_option(array(\'Default\', \'Basic\',\'oscGold\'),'),
(3333,'Edytor HTML WYSIWYG','HTML_WYSIWYG_DISABLE','Enable','Czy używać edytora HTML podczas wypełniania pól opisowych w formularzach ?',101,120,'2006-09-12 11:19:41','2003-07-24 00:27:47',NULL,'tep_cfg_select_option(array(\'Enable\', \'Disable\'),'),
(10,'Wyślij dodatkowe e-mail z zamówieniami','SEND_EXTRA_ORDER_EMAILS_TO','','Wysłanie dodatkowym e-maili z zamówieniami na adres o następujących formacie: Nazwa1 &lt;email@adres1&gt;, Nazwa2 &lt;email@adres2&gt;',1,7,'2009-11-30 22:06:33','2003-07-29 13:05:38',NULL,NULL),
(5252,'Wyświetlać rozwijaną listę płatności ?','ORDER_EDITOR_PAYMENT_DROPDOWN','true','Wyświetla listę dostępnych metod płatności lub pole tekstowe do wprowadzenia danych',72,1,'2008-12-29 14:36:45','2008-12-29 14:36:45',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1519,'Adres dostawy podczas zamawiania bez rejestracji','PURCHASE_WITHOUT_ACCOUNT_SEPARATE_SHIPPING','true','Czy zezwalać klientom sklepu na podawanie odobnego adresu dostawy podczas zamawiania bez zakładania konta ?',101,101,'2009-10-26 21:34:55','2006-04-18 22:25:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(15,'Adres i telefon sklepu','STORE_NAME_ADDRESS','Ulica\r\r
Kod Miejscowosc\r\r
Telefon','Nazwa, adres i telefon do sklepu, używane na wyświetlanych i drukowanych dokumentach',1,3,'2008-03-10 13:24:13','2003-07-29 13:05:38',NULL,'tep_cfg_textarea('),
(1518,'Zamawianie bez zakładania konta','PURCHASE_WITHOUT_ACCOUNT','true','Czy zezwalać klientom sklepu na dokonywanie zamówień bez zakładania konta ?',101,100,'2006-04-19 15:29:28','2006-04-18 22:25:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(19,'Imię','ENTRY_FIRST_NAME_MIN_LENGTH','2','Minimalna długość imienia.',2,1,NULL,'2003-07-29 13:05:38',NULL,NULL),
(20,'Nazwisko','ENTRY_LAST_NAME_MIN_LENGTH','2','Minimalna długość nazwiska.',2,2,NULL,'2003-07-29 13:05:38',NULL,NULL),
(21,'Data urodzenia','ENTRY_DOB_MIN_LENGTH','10','Minimalna długość daty urodzenia.',2,3,NULL,'2003-07-29 13:05:38',NULL,NULL),
(22,'Adres e-mail','ENTRY_EMAIL_ADDRESS_MIN_LENGTH','6','Minimalna długość adresu e-mail.',2,4,NULL,'2003-07-29 13:05:38',NULL,NULL),
(23,'Nazwa ulicy','ENTRY_STREET_ADDRESS_MIN_LENGTH','5','Minimalna długość nazwy ulicy.',2,5,NULL,'2003-07-29 13:05:38',NULL,NULL),
(24,'Firma','ENTRY_COMPANY_MIN_LENGTH','2','Minimalna długość nazwy firmy.',2,6,NULL,'2003-07-29 13:05:38',NULL,NULL),
(25,'Kod pocztowy','ENTRY_POSTCODE_MIN_LENGTH','5','Minimalna długość kodu pocztowego.',2,8,'2005-10-18 13:54:43','2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (26,'Miasto','ENTRY_CITY_MIN_LENGTH','3','Minimalna długość nazwy miasta.',2,9,NULL,'2003-07-29 13:05:38',NULL,NULL),
(27,'Województwo','ENTRY_STATE_MIN_LENGTH','2','Minimalna długość nazwy województwa/stanu.',2,10,NULL,'2003-07-29 13:05:38',NULL,NULL),
(28,'Numer telefonu','ENTRY_TELEPHONE_MIN_LENGTH','3','Minimalna długość numeru telefonu.',2,11,NULL,'2003-07-29 13:05:38',NULL,NULL),
(29,'Hasło','ENTRY_PASSWORD_MIN_LENGTH','5','Minimalna długość hasła.',2,12,NULL,'2003-07-29 13:05:38',NULL,NULL),
(30,'Nazwisko właściciela karty kredytowej','CC_OWNER_MIN_LENGTH','3','Minimalna długość nazwiska właściciela karty kredytowej.',2,13,NULL,'2003-07-29 13:05:38',NULL,NULL),
(31,'Numer karty kredytowej','CC_NUMBER_MIN_LENGTH','10','Minimalna długość numeru karty kredytowej.',2,14,NULL,'2003-07-29 13:05:38',NULL,NULL),
(32,'Recenzja','REVIEW_TEXT_MIN_LENGTH','50','Minimalna długość recenzji produktu.',2,15,NULL,'2003-07-29 13:05:38',NULL,NULL),
(35,'Pozycje książki adresowej','MAX_ADDRESS_BOOK_ENTRIES','5','Maksymalna liczby pozycji książki adresowej klienta.',3,1,NULL,'2003-07-29 13:05:38',NULL,NULL),
(36,'Wyniki wyszukiwania','MAX_DISPLAY_SEARCH_RESULTS','10','Liczba produktów na liście wyników wyszukiwania.',3,2,'2008-11-18 20:00:33','2003-07-29 13:05:38',NULL,NULL),
(37,'Łącza','MAX_DISPLAY_PAGE_LINKS','5','Liczbą łączy z numerami dla list podzielonych na strony.',3,3,NULL,'2003-07-29 13:05:38',NULL,NULL),
(44,'Nowe recenzje','MAX_DISPLAY_NEW_REVIEWS','6','Maksymalna liczby wyświetlanych nowych recenzji.',3,11,NULL,'2003-07-29 13:05:38',NULL,NULL),
(45,'Wybór losowych recenzji','MAX_RANDOM_SELECT_REVIEWS','10','Z ilu rekordów wybierać jedną losową recenzję produktu.',3,12,NULL,'2003-07-29 13:05:38',NULL,NULL),
(46,'Wybór losowych nowych produktów','MAX_RANDOM_SELECT_NEW','10','Z ilu rekordów wybierać jeden losowy nowy produkt.',3,13,NULL,'2003-07-29 13:05:38',NULL,NULL),
(47,'Wybór losowych produktów w promocji','MAX_RANDOM_SELECT_SPECIALS','10','Z ilu rekordów wybierać jeden losowy produkt w promocji.',3,14,NULL,'2003-07-29 13:05:38',NULL,NULL),
(5704,'Grupa VAT','MODULE_SHIPPING_ODBIOR_OSOBISTY_TAX_CLASS','0','Wybierz podatek stosowany przy wyliczaniu kosztów dostawy',6,0,NULL,'2009-07-14 21:57:33','tep_get_tax_class_title','tep_cfg_pull_down_tax_classes('),
(5702,'Włącz opcję Odbiór osobisty','MODULE_SHIPPING_ODBIOR_OSOBISTY_STATUS','True','Czy chcesz oferować możliwość odbioru osobistego?',6,0,NULL,'2009-07-14 21:57:33',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5703,'Koszt dostawy','MODULE_SHIPPING_ODBIOR_OSOBISTY_COST','0.00','Koszt dostawy dla wszystkich zamówień',6,0,NULL,'2009-07-14 21:57:33',NULL,NULL),
(52,'Okienko historii zamówień','MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX','6','Maksymalna liczba produktów wyświetlanych okienku historii zamówień.',3,18,NULL,'2003-07-29 13:05:38',NULL,NULL),
(53,'Historia zamówień','MAX_DISPLAY_ORDER_HISTORY','10','Maksymalna liczba zamówień wyświetalana na stronie historii zamówień.',3,19,NULL,'2003-07-29 13:05:38',NULL,NULL),
(54,'Szerokość małego obrazka','SMALL_IMAGE_WIDTH','90','Szerokość (w pikselach) małych obrazków',4,1,'2008-10-10 18:16:48','2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (55,'Wysokość małego obrazka','SMALL_IMAGE_HEIGHT','90','Wysokość (w pikselach) małych obrazków',4,2,'2008-10-10 18:16:51','2003-07-29 13:05:38',NULL,NULL),
(56,'Szerokość obrazka w nagłówku','HEADING_IMAGE_WIDTH','80','Szerokość (w pikselach) obrazków nagłówkowych',4,3,'2006-02-05 12:41:05','2003-07-29 13:05:38',NULL,NULL),
(57,'Wysokość obrazka w nagłówku','HEADING_IMAGE_HEIGHT','80','Wysokość (w pikselach) obrazków nagłowkowych',4,4,'2006-02-05 12:41:11','2003-07-29 13:05:38',NULL,NULL),
(58,'Szerokość obrazka podkategorii','SUBCATEGORY_IMAGE_WIDTH','80','Szerokość (w pikselach) obrazków podkategorii',4,5,'2007-02-08 14:47:04','2003-07-29 13:05:38',NULL,NULL),
(59,'Wysokość obrazka podkategorii','SUBCATEGORY_IMAGE_HEIGHT','80','Wysokość (w pikselach) obrazków podkategorii',4,6,'2007-02-08 14:47:10','2003-07-29 13:05:38',NULL,NULL),
(60,'Obliczanie rozmiaru obrazków','CONFIG_CALCULATE_IMAGE_SIZE','true','Czy obliczać rozmiar obrazków?',4,13,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(61,'Wymagane obrazki','IMAGE_REQUIRED','false','Włączenie powoduje próbę wyświetlenia także nieistniejących obrazków. Przydatne przy konfigurowaniu sklepu.',4,14,'2005-10-02 15:14:31','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(62,'Płeć','ACCOUNT_GENDER','false','Czy wyświetlać płeć na koncie klienta?',5,1,'2009-08-22 20:43:25','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(63,'Data urodzenia','ACCOUNT_DOB','false','Czy wyświetlać datę urodzenia na koncie klienta?',5,2,'2008-10-03 15:25:27','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5400,'Automatczyne dodawanie stron','HEADER_TAGS_AUTO_ADD_PAGES','false','Automatyczne dodawanie nowych stron podczas uruchamiania edytora Meta Tagów',543,3,'2009-06-05 21:18:42','2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(65,'Dzielnica','ACCOUNT_SUBURB','false','Czy wyświetlać dzielnicę na koncie klienta?',5,4,'2005-10-16 09:29:48','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(66,'Stan/województwo','ACCOUNT_STATE','true','Czy wyświetlać stan/województwo na koncie klienta?',5,6,'2007-12-19 15:05:43','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(67,'Zainstalowane moduły','MODULE_PAYMENT_INSTALLED','gotowkaprzyodbiorzeosobistym.php;plbanktransfer.php;pobraniekurier.php','Lista nazw plików modułów płacenia, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.',6,0,'2010-03-02 21:57:32','2003-07-29 13:05:38',NULL,NULL),
(68,'Zainstalowane moduły','MODULE_ORDER_TOTAL_INSTALLED','ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php','Lista nazw plików modułów order_total, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.',6,0,'2009-11-17 17:55:25','2003-07-29 13:05:38',NULL,NULL),
(4015,'Podsumowanie','MODULE_ORDER_TOTAL_TOTAL_STATUS','true','Czy chcesz wyświetlić podsumowanie zamówienia ?',6,1,NULL,'2007-12-01 18:36:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(69,'Zainstalowane moduły','MODULE_SHIPPING_INSTALLED','kurierpobranie.php;kurier.php;odbiorosobisty.php','Lista nazw plików modułów przesyłek, oddzielonych średnikami. Jest ona automatycznie uaktualniana i nie trzeba jej edytować.',6,0,'2010-03-02 21:57:11','2003-07-29 13:05:38',NULL,NULL),
(5911,'Strefa dostawy','MODULE_SHIPPING_KURIERPOBRANIE_ZONE','0','Wybierz strefę, dla której ma być stosowany ten sposob dostawy',6,0,NULL,'2010-03-02 21:57:06','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5912,'Sortowanie','MODULE_SHIPPING_KURIERPOBRANIE_SORT_ORDER','1','Kolejność wyświetlania wśród innych modułów wysyłki.',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(84,'Domyślna waluta','DEFAULT_CURRENCY','PLN','Domyślna waluta',6,0,NULL,'2003-07-29 13:05:38',NULL,NULL),
(85,'Domyślny język','DEFAULT_LANGUAGE','pl','Domyślny język',6,0,NULL,'2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (86,'Domyślny status nowego zamówienia','DEFAULT_ORDERS_STATUS_ID','1','Nowo utworzonemu zamówieniu zostanie przypisany ten status.',6,0,NULL,'2003-07-29 13:05:38',NULL,NULL),
(98,'Kraj pochodzenia','SHIPPING_ORIGIN_COUNTRY','170','Wprowadź kod kraju w którym znajduje się sklep (używane przy wysyłkach).',7,1,'2005-10-16 09:31:08','2003-07-29 13:05:38','tep_get_country_name','tep_cfg_pull_down_country_list('),
(99,'Kod pocztowy','SHIPPING_ORIGIN_ZIP','NONE','Wprowadź kod pocztowy (ZIP) sklepu, używany przy wysyłkach.',7,2,NULL,'2003-07-29 13:05:38',NULL,NULL),
(100,'Maksymalna ciężar wysyłanej paczki','SHIPPING_MAX_WEIGHT','150','Wspólny maksymalny ciężar wysyłanej paczki.',7,3,'2009-11-30 23:40:39','2003-07-29 13:05:38',NULL,NULL),
(101,'Waga opakowania','SHIPPING_BOX_WEIGHT','0','Wprowadź masę typowego opakowania małej do średniej paczki.',7,4,'2009-11-30 23:40:46','2003-07-29 13:05:38',NULL,NULL),
(102,'Procentowe zwiększenie dla dużych pakietów','SHIPPING_BOX_PADDING','10','Chcąc wpisać 10% wpisz 10',7,5,NULL,'2003-07-29 13:05:38',NULL,NULL),
(103,'Wyświetlaj obrazek produktu','PRODUCT_LIST_IMAGE','1','Czy wyświetlać obrazek produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,1,'2009-03-26 23:06:40','2003-07-29 13:05:38',NULL,NULL),
(104,'Wyświetlaj nazwę producenta','PRODUCT_LIST_MANUFACTURER','2','Czy wyświetlać nazwę producenta?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,2,'2009-01-11 16:24:02','2003-07-29 13:05:38',NULL,NULL),
(105,'Wyświetlaj model produktu','PRODUCT_LIST_MODEL','0','Czy wyświetlać model produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,3,'2008-02-25 11:19:42','2003-07-29 13:05:38',NULL,NULL),
(106,'Wyświetlaj nazwę produktu','PRODUCT_LIST_NAME','2','Czy wyświetlać nazwę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,4,'2005-10-30 23:33:00','2003-07-29 13:05:38',NULL,NULL),
(107,'Wyświetlaj cenę produktu','PRODUCT_LIST_PRICE','4','Czy wyświetlać cenę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,5,'2007-02-27 11:41:54','2003-07-29 13:05:38',NULL,NULL),
(108,'Wyświetlaj liczbę produktów','PRODUCT_LIST_QUANTITY','0','Czy wyświetlać ilość produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,7,'2006-03-09 11:16:46','2003-07-29 13:05:38',NULL,NULL),
(109,'Wyświetlaj wagę produktu','PRODUCT_LIST_WEIGHT','0','Czy wyświetlać masę produktu?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,8,'2008-03-13 15:15:14','2003-07-29 13:05:38',NULL,NULL),
(110,'Wyświetlaj kolumnę Kup Teraz','PRODUCT_LIST_BUY_NOW','6','Czy wyświetlać kolumnę Kup Teraz?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,10,'2005-12-12 21:43:15','2003-07-29 13:05:38',NULL,NULL),
(112,'Położenia paska nawigacja Poprzedni/Następny','PREV_NEXT_BAR_LOCATION','3','Położenie paska nawigacji Poprzedni/Następny (1-góra, 2-dół, 3-góra i dół).',8,16,'2006-06-23 22:59:37','2003-07-29 13:05:38',NULL,NULL),
(113,'Sprawdzanie zasobów magazynu','STOCK_CHECK','true','Czy sprawdzać ilość produktów w magazynie (na stanie)?',9,1,'2008-12-31 19:52:20','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(114,'Pomniejszanie stanu w magazynie','STOCK_LIMITED','true','Czy po zamówieniu odejmować liczbę produktów ze stanu?',9,2,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(115,'Pozwól na zamówienie mimo braków','STOCK_ALLOW_CHECKOUT','true','Pozwól klientowi zamówić nawet wtedy, jeżeli produktów nie ma na stanie',9,3,'2008-12-31 19:51:08','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(116,'Oznacz produkty niedostępne','STOCK_MARK_PRODUCT_OUT_OF_STOCK','*Aktualnie Brak*','Oznaczenie produktów, których nie ma w wystarczającej ilości.',9,4,'2005-11-05 16:30:26','2003-07-29 13:05:38',NULL,NULL),
(117,'Poziom konieczności uzupełnienia magazynu','STOCK_REORDER_LEVEL','5','Kiedy należy uzupełnić magazyn?',9,5,'2009-03-02 23:53:25','2003-07-29 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (118,'Zapisywanie czasu przetworzenia strony','STORE_PAGE_PARSE_TIME','false','Zachowaj czas przetwarzania stron.',10,1,'2009-07-26 22:22:46','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(119,'Cel logowania','STORE_PAGE_PARSE_TIME_LOG','tmp/page_parse_time.log','Katalog i nazwa pliku z czasem przetwarzania stron.',10,2,'2007-02-28 11:54:24','2003-07-29 13:05:38',NULL,NULL),
(120,'Format daty logu','STORE_PARSE_DATE_TIME_FORMAT','%d/%m/%Y %H:%M:%S','Format daty.',10,3,NULL,'2003-07-29 13:05:38',NULL,NULL),
(121,'Wyświetlanie czasu przetwarzania strony','DISPLAY_PAGE_PARSE_TIME','false','Wyświelaj czas przetworzenia strony (zapisywanie czasu przetworzenia strony musi być włączone)',10,4,'2009-11-17 17:56:05','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(122,'Zapisywanie zapytań SQL','STORE_DB_TRANSACTIONS','false','Zapisz zapytania SQL w pliku z czasami przetwarzania stron (tylko PHP4)',10,5,'2008-02-23 18:54:29','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(123,'Używaj pamięci podręcznej do boxów','USE_CACHE','false','Czy używać pamięci podręcznej dla przetrzymywania boxów ?',26229,7,'2008-04-05 15:59:18','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(124,'Katalog pamięci podręcznej','DIR_FS_CACHE','tmp/cache/','Katalog, w którym mają być przechowywane pliki podręczne.',26229,8,'2007-08-24 21:14:28','2003-07-29 13:05:38',NULL,NULL),
(125,'Sposób wysyłania e-maili','EMAIL_TRANSPORT','sendmail','Czy serwer używa lokalnego programu sendmail, czy połączenia SMTP. Użytkownicy serwerów Windows i MacOS powinni zmienić to ustawienie na SMTP.',12,1,'2008-05-21 23:12:31','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'sendmail\', \'smtp\'),'),
(126,'Końce linii w e-mailu','EMAIL_LINEFEED','LF','Sekwencja znaków używana do oddzielania nagłówków poczty.',12,2,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'LF\', \'CRLF\'),'),
(127,'Używaj MIME HTML przy wysyłaniu e-maili','EMAIL_USE_HTML','true','Czy wysyłać pocztę w formacie HTML?',12,3,'2009-01-20 21:56:15','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(128,'Weryfikuj adresy e-mail przez DNS','ENTRY_EMAIL_ADDRESS_CHECK','false','Czy sprawdzać adresy e-mail za pośrednictwem serwera DNS',12,4,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(129,'Wysyłaj e-maile','SEND_EMAILS','true','Czy wysyłać e-maile?',12,5,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(130,'Włącz pobieranie','DOWNLOAD_ENABLED','true','Czy umożliwić pobieranie produktów?',13,1,'2009-01-11 20:34:39','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(131,'Pobieranie poprzez przekierowanie','DOWNLOAD_BY_REDIRECT','false','Czy używać przekierowania do pobierania. Należy to wyłączyć w serwerach nie Uniksowych.',13,2,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(132,'Czas wygaśnięcia (dni)','DOWNLOAD_MAX_DAYS','7','Liczba dni, po której wygasa łącze do ściągnięcia pliku. 0 oznacza brak ograniczeń.',13,3,NULL,'2003-07-29 13:05:38',NULL,''),
(133,'Maksymalna liczba pobrań','DOWNLOAD_MAX_COUNT','5','Ustaw maksymalną liczbę pobrań. 0 oznacza brak dozwolonych pobrań.',13,4,NULL,'2003-07-29 13:05:38',NULL,''),
(134,'Włącz kompresję GZip','GZIP_COMPRESSION','false','Włącz kompresję HTTP GZip.',14,1,'2006-09-21 19:17:11','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(135,'Poziom kompresji','GZIP_LEVEL','5','Ustaw poziom kompresji 0-9 (0 = minimum, 9 = maksimum).',14,2,NULL,'2003-07-29 13:05:38',NULL,NULL),
(136,'Katalog sesji','SESSION_WRITE_DIRECTORY','tmp','Jeżeli sesja wykorzystuje pliki, w tym katalogu będą one przechowywane.',15,1,'2008-02-09 22:23:24','2003-07-29 13:05:38',NULL,NULL),
(137,'Wymuszaj użycie ciasteczek','SESSION_FORCE_COOKIE_USE','true','Włącz użycie sesji, jeżeli ciasteczka są włączone.',15,2,'2008-02-20 21:03:21','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (138,'Sprawdź ID sesji SSL','SESSION_CHECK_SSL_SESSION_ID','False','Sprawdź SSL_SESSION_ID przy każdym pobieraniu strony przez HTTPS.',15,3,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(139,'Sprawdź rodzaj przeglądarki','SESSION_CHECK_USER_AGENT','False','Sprawdź rodzaj przeglądarki klienta przy kazdym pobieraniu strony.',15,4,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(140,'Sprawdź adres IP','SESSION_CHECK_IP_ADDRESS','False','Sprawdź adres IP klienta przy każdym pobieraniu strony.',15,5,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(141,'Zabroń robotom dostępu','SESSION_BLOCK_SPIDERS','True','Zabronienie znanym robotom rozpoczęcia sesji.',15,6,'2007-07-31 19:55:11','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(142,'Ponowne utworzenie sesji','SESSION_RECREATE','false','Ponowne utworzenie sesji i nowego identyfikatora przy logowaniu klienta lub tworzeniu konta (wymagane PHP >=4.1).',15,7,'2008-02-20 21:03:32','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(153,'Domyślny szablon sklepu','DIR_WS_TEMPLATES_DEFAULT','gold_standard','Katalog (w templates/) gdzie znajdują się pliki szablonu sklepu',99,18,'2017-09-02 01:52:14','2005-10-09 11:58:50',NULL,' tep_cfg_pull_down_template_files('),
(154,'Zmiana szablonów','TEMPLATE_SWITCHING_ALLOWED','true','Czy zezwalać użytkonikom na przełączanie szablonów sklepu ?',99,19,'2008-01-21 21:57:26','2005-10-09 11:58:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(155,'Menu szablonów','TEMPLATE_SWITCHING_MENU','false','Czy pokazywać menu przełączania szablonów (głównie używane do testowania nowych szablonów, wymaga włączenia możliwości zmiany szablonów).',99,20,'2008-02-25 23:57:40','2005-10-09 11:58:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5757,'Domyślny pracownik obsługujący zgłoszenia','TICKET_DEFAULT_ADMIN_ID','1','Domyślnie wybierany pracownik odpowiadający na zgłoszenia reklamacyjne.<br><br>Na liście znajdują się użytkownicy zdefiniowanie w panelu administracyjnym.',69,1,'2009-12-19 16:32:33','2009-01-29 14:29:08','tep_get_admin_reply_name','tep_cfg_pull_down_admin_reply('),
(165,'Numer NIP','ENTRY_NIP_MIN_LENGTH','10','Minimalna długość pola NIP',2,7,'2005-12-26 22:20:43','2003-12-02 10:34:04',NULL,NULL),
(200,'Centrowanie sklepu','CENTER_SHOP_ON','on','Centrowanie sklepu Włącz/Wyłącz',99,1,'2004-02-25 14:34:58','2004-02-25 14:34:58',NULL,'tep_cfg_select_option(array(\'on\', \'off\'),'),
(201,'Szerokość sklepu','CENTER_SHOP_WIDTH','980','Podaj w pixelach (np. 760) lub w procentach (np. 100%) jaką szerokość mają mieć strony WWW sklepu.',99,2,'2009-11-30 22:08:20','2004-02-25 14:34:58',NULL,NULL),
(202,'Odstęp od krawędzi','CENTER_SHOP_PADDING','0','Odstęp sklepu od krawędzi przeglądarki',99,9,'2006-08-07 19:08:21','2004-02-25 14:34:58',NULL,NULL),
(203,'Kolor tła','CENTER_SHOP_BACKGROUND_COLOR_OUT','FFFFFF','Kolor tła na zewnątrz sklepu',99,10,'2007-07-13 12:56:56','2004-02-25 14:34:58',NULL,NULL),
(204,'Grubość ramki','CENTER_SHOP_BORDER','0','Grubość obramowania sklepu',99,11,'2005-11-30 22:52:48','2004-02-25 14:34:58',NULL,NULL),
(205,'Kolor ramki','CENTER_SHOP_BORDERCOLOR','b6b7cb','Kolor obranowania sklepu',99,12,'2005-11-28 13:42:05','2004-02-25 14:34:58',NULL,NULL),
(206,'Odstęp modułów','CENTER_SHOP_CELLSPACING','0','Odstęp pomiędzy komórkami modułów sklepu',99,13,'2004-02-25 14:34:58','2004-02-25 14:34:58',NULL,NULL),
(207,'Odstęp tekstu','CENTER_SHOP_CELLPADDING','0','Odstęp tekstu wewnątrz modułów',99,14,'2007-07-02 10:32:15','2004-02-25 14:34:58',NULL,NULL),
(208,'Kolor tła włączony/wyłączony','CENTER_SHOP_BACKGROUND_ON','on','Czy używać kolorów tła ?',99,15,'2004-02-25 14:34:58','2004-02-25 14:34:58',NULL,'tep_cfg_select_option(array(\'on\', \'off\'),'),
(209,'Kolor pomiędzy obramowaniem','CENTER_SHOP_BACKGROUND_COLOR','FFFFFF','Kolor pomiędzy oobramowaniem i zawartością sklepu',99,16,'2006-08-08 13:30:06','2004-02-25 14:34:58',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (230,'Kontakt e-mail','KONTAKT_EMAIL_1','adres@email.pl','Adres email prezentowany w boxie :Kontakt:',1,11,'2008-03-10 13:25:08','2005-04-02 07:07:39',NULL,NULL),
(232,'Kontakt telefon','KONTAKT_TELEFON_1','xxx xxx xxx','Numer telefonu prezentowany w boxie :Kontakt:',1,13,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(233,'Kontakt GSM','KONTAKT_GSM_1','yyy yyy yyy','Numer telefonu komórkowego prezentowany w boxie :Kontakt:',1,18,'2007-07-02 10:29:28','2005-04-02 07:07:39',NULL,NULL),
(234,'Kontakt nr GG','KONTAKT_NR_GG_1','','Numer GG prezentowany w boxie :Kontakt:',1,24,'2006-03-21 13:47:13','2005-04-02 07:07:39',NULL,NULL),
(235,'Kontakt nr Tlen','KONTAKT_NR_TLEN_1','','Login TLEN prezentowany w boxie :Kontakt:',1,30,'2006-01-05 22:20:51','2005-04-02 07:07:39',NULL,NULL),
(236,'Kontakt nr WP','KONTAKT_NR_WP_1','','Login WP prezentowany w boxie :Kontakt:',1,31,'2005-04-02 07:07:39','2005-04-02 07:07:39',NULL,NULL),
(241,'Kontakt nr SKYPE','KONTAKT_SKYPE_1','','Login SKYPE prezentowany w boxie :Kontakt:',1,32,'2009-11-30 22:06:46','2005-04-02 07:07:39',NULL,NULL),
(242,'Kontakt godziny działania','KONTAKT_GODZINY_1','10-18','Godziny otwarcia/działania prezentowane w boxie :Kontakt:',1,38,'2008-05-18 08:10:39','2005-04-02 07:07:39',NULL,NULL),
(243,'Kontakt fax','KONTAKT_FAX_1','','Numer FAXu prezentowany w boxie :Kontakt:',1,12,'2006-01-05 22:28:22','2005-04-02 07:07:39',NULL,NULL),
(17,'Licza miejsc dziesiętnych podatku','TAX_DECIMAL_PLACES','2','Uzupełnienie wartości podatku do określonej liczby miejsc dziesiętnych.',101,72,'2008-04-18 21:09:43','2003-07-29 13:05:38',NULL,NULL),
(1019,'Liczba miejsc dziesiętnych w module Nasza cena','NEW_FIELDS_DECIMAL','2','Podaj liczbę miejsc dziesiętnych w module Nasza cena - oszczędzasz ...',101,75,'2006-01-05 20:11:36','2005-11-11 10:28:21',NULL,NULL),
(257,'Discount Percentage','MODULE_FIXED_PAYMENT_CHG_AMOUNT','2','Amount of Discount.',6,7,NULL,'2005-10-18 13:59:28',NULL,NULL),
(5705,'Strefa dostawy','MODULE_SHIPPING_ODBIOR_OSOBISTY_ZONE','3','Wybierz strefę, dla której ma być stosowany ten sposob dostawy',6,0,NULL,'2009-07-14 21:57:33','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(259,'Listing produktów: sposób wyświetlania','PRODUCTS_LISTING_DISPLAY_MODE','true','Format wyświetlania listy produktów: <br>włączony = każdy produkt w jednym wierszu <br>wyłączony = tabela wiersze x kolumny (wyświetlanie produktów w oknach)',8,18,'2008-11-25 11:13:53','2005-12-14 21:42:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(260,'Czas wyświetlania Nowych produktów','MAX_DISPLAY_TIME_NEW_PRODUCTS','360','Maksymalny czas wyświetlania nowych produktów od momentu dodania ich do sklepu podany w dniach.',3,22,'2009-05-25 10:37:48','2003-07-29 13:05:38',NULL,NULL),
(255,'Moduł kontroli zawartości Meta Tagów','ALLOW_HEADER_TAGS_CONTROLLER','true','Moduł umozliwiający samodzielne zdefiniowanie znaczników meta (tytuł, opis, słowa kluczowe) dla poszczególnych stron sklepu lub poszczególnych produktów. Jeżeli moduł jest wyłączony Meta Tagi są generowane automatycznie na podstawie zawartoś',101,80,'2009-01-04 10:40:37','2005-12-04 08:21:31',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(554,'Lista dostępności produktów','MAX_DISPLAY_PRODUCTS_AVAILABILITY_IN_A_LIST','1','Gdy ilość opcji dostępności produktów przekracza podaną liczbę wyświetlana jest rozwijana lista wyboru',7,6,NULL,'2005-11-06 10:20:09',NULL,NULL),
(555,'Wielkość pola wyboru dostępności produktów','MAX_PRODUCTS_AVAILABILITY_LIST','3','Gdy wartość ustawiona na \'1\' - używana jest rozwijana lista dostępności produktów. W przeciwnym wypadku jest okno wyboru z ilością wierszy taką jak podana liczba',7,7,'2008-03-06 15:11:04','2005-11-06 10:20:09',NULL,NULL),
(556,'Wyświetlaj dostępność produktów','PRODUCT_LIST_PRODUCTS_AVAILABILITY','0','Czy chcesz wyświetlać dostępność produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,13,'2008-03-13 14:39:18','2005-11-06 10:20:09',NULL,NULL),
(880,'Szerokość obrazka w Liście wszystkich produktów','ALLPROD_IMAGE_WIDTH','100','Szerokość (w pikselach) obrazków',4,7,'2007-11-29 22:49:03','2003-07-24 17:45:15',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (881,'Wysokość obrazka w Liście wszystkich produktów','ALLPROD_IMAGE_HEIGHT','100','Wysokość (w pikselach) obrazków',4,8,'2007-11-29 22:49:08','2003-07-24 17:45:15',NULL,NULL),
(1001,'Pokaż model','DISPLAY_MODEL','true','Włącz/Wyłącz wyświetlanie modelu',300,1,'2003-06-04 05:04:11','2003-06-04 04:18:06',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1002,'Edycja pola model','MODIFY_MODEL','true','Pozwól/Zabroń modyfikować pole model',300,2,'2007-02-14 13:15:36','2003-06-04 04:25:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1003,'Edycja nazwy produktu','MODIFY_NAME','false','Pozwól/Zabroń modyfikować nazwę produktu?',300,3,'2003-06-04 05:04:01','2003-06-04 04:30:31',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1004,'Edycja statusu wyświetlania produktu.','DISPLAY_STATUT','true','Pozwól/Zabroń modyfikować status wyświetlania produktu',300,4,'2003-06-04 05:07:11','2003-06-04 05:00:58',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1005,'Edycja wagi produktu','DISPLAY_WEIGHT','true','Pozwól/Zabroń modyfikować wagę produktu?',300,5,'2003-06-04 05:06:44','2003-06-04 04:33:16',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1006,'Edycja ilości produktu','DISPLAY_QUANTITY','true','Pozwól/Zabroń modyfikować ilość produktu',300,6,'2003-06-04 05:06:48','2003-06-04 04:34:34',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1007,'Edycja zdjęcia produktu','DISPLAY_IMAGE','true','Pozwól/Zabroń modyfikować obrazek produktu',300,7,'2006-09-22 15:04:39','2003-06-04 04:36:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1008,'Edycja pola producenta produktu','MODIFY_MANUFACTURER','true','Pozwól/Zabroń modyfikować producenta produktu',300,9,'2005-11-11 09:39:41','2003-06-04 04:37:40',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1009,'Edycja pola podatek','MODIFY_TAX','true','Pozwól/Zabroń modyfikować podatek',300,11,'2005-11-09 21:26:54','2003-06-04 04:31:53',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1010,'Pokaż cenę z podatkiem po najechaniu myszką na produkt','DISPLAY_TVA_OVER','true','Włącz/Wyłącz pokazywanie ceny z podatkiem po najechaniu myszką na produkt',300,12,'2005-11-09 21:27:07','2003-06-04 04:38:45',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1011,'Pokaż cenę z podatkiem podczas edycji produktu','DISPLAY_TVA_UP','true','Włącz/Wyłącz pokazywanie ceny z podatkiem podczas wprowadzania ceny',300,13,'2005-11-11 09:39:49','2003-06-04 04:40:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1012,'Pokaż link do strony podglądu produktu','DISPLAY_PREVIEW','false','Włącz/Wyłącz pokazywanie linku do strony podglądu produktu',300,14,'2007-02-14 13:15:59','2003-06-04 05:15:50',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1013,'Pokaż link do strony edycji produktu','DISPLAY_EDIT','true','Włącz/Wyłącz pokazywanie linku do strony, na której można edytować produkt w pełnym zakresie',300,15,'2007-02-14 13:16:03','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1014,'Pokaż pole producent produktu','DISPLAY_MANUFACTURER','true','Pokazywać producenta produktu ?',300,8,'2005-11-11 09:39:36','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1015,'Pokaż podatek','DISPLAY_TAX','true','Pokazywać podatek VAT ?',300,10,'2005-11-09 21:26:47','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1017,'Cena detaliczna','DISPLAY_RETAIL_PRICE','true','Włącz/Wyłącz pokazywanie ceny detalicznej?',300,17,'2005-11-12 07:50:42','2003-06-04 05:19:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(18,'Wyświetlaj ceny z podatkiem','DISPLAY_PRICE_WITH_TAX','true','Wyświetlanie cen z podatkiem VAT (włączone) lub dodanie podatku na końcu zamówienia (wyłączone).',101,71,'2009-03-15 20:19:33','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1046,'Szerokość lewej kolumny','BOX_WIDTH_LEFT','181','Jaka ma być szerokość prawej kolumny (w pixelach) ?',99,6,'2009-08-16 21:49:56','0000-00-00 00:00:00','',''),
(1047,'Szerokość prawej kolumny','BOX_WIDTH_RIGHT','181','Jaka ma być szerokość lewej kolumny (w pixelach) ?',99,5,'2009-08-04 22:25:46','0000-00-00 00:00:00','','');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1048,'Lewa kolumna','COLUMN_LEFT_IS_ON','true','Czy chcesz wyświetlać lewą kolumnę ?',99,4,'2008-06-14 18:09:18','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(1049,'Prawa kolumna','COLUMN_RIGHT_IS_ON','true','Czy chcesz wyświetlać prawą kolumnę ?',99,3,'2008-06-14 18:11:02','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(1050,'Lewa kolumna -> prawa','COLUMN_LEFT_IS_ON_RIGHT','false','Czy chcesz, aby zawartość lewej kolumny była wyświetlana z prawej strony ?',99,7,'0000-00-00 00:00:00','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(1051,'Prawa kolumna -> lewa','COLUMN_RIGHT_IS_ON_LEFT','false','Czy chcesz, aby zawartość prawej kolumny była wyświetlana z lewej strony ?',99,8,'0000-00-00 00:00:00','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(4583,'Status zamówienia','MODULE_PAYMENT_COP_ORDER_STATUS_ID','0','Ustaw status zamówienia dla tej metody płatności',6,0,NULL,'2008-03-04 13:07:01','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(4582,'Kolejność wyświetlania','MODULE_PAYMENT_COP_SORT_ORDER','1','Kolejność wyświetlania',6,0,NULL,'2008-03-04 13:07:01',NULL,NULL),
(4581,'Strefa płatności','MODULE_PAYMENT_COP_ZONE','0','Możesz wybrać strefę dla której będzie obowiązywał ten sposób płatności',6,2,NULL,'2008-03-04 13:07:01','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(4580,'Włącz płatność przy odbiorze osobistym','MODULE_PAYMENT_COP_STATUS','True','Czy chcesz włączyć płatność gotówką przy odbiorze osobistym ?',6,1,NULL,'2008-03-04 13:07:01',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5485,'Pokaż podsumę z rabatem','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_SUBTOTAL','false','<b>true</b> - podsuma w zamówieniu będzie uwzględniała udzielony rabat<br><b>false</b> - podsuma zamówienia nie będzie uwzględniała udzielonego rabatu',615,4,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5486,'Sposób wyświetlania podatku VAT w udzielonym rabacie','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_TAX','Brak','W jaki sposób ma być wyświetlany Podatek VAT od rabatu w podsumowaniu zamówienia',615,5,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'Brak\', \'Pokazuj rabat razem z podatkiem\', \'Pokazuj obniżkę podatku w osobnej linii\'), '),
(5489,'Wyświetlanie rabatu dla każdej grupy podatku','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DISPLAY_LINES','false','<b>true</b> - rabat będzie wyświetlany w osobnej linii dla każdej stawki podatku VATr<br><b>false</b> - rabat będzie wyświetlony łącznie dla wszystkich stawek podatku VAT',615,8,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(1085,'Wyświetlaj opis produktu','PRODUCT_LIST_DESCRIPTION','99','0 - wyłączone, 99 - włączone.<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,11,'2006-02-26 22:44:14','0000-00-00 00:00:00',NULL,NULL),
(1086,'Długość tekstu w listach produktów','PRODUCT_LIST_DESCRIPTION_LENGTH','250','Ile znaków ma być wyświetlane w opisach produktów?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,12,'2005-11-29 23:37:54','2002-03-16 18:51:26',NULL,NULL),
(1294,'Wyświetlaj sugerowaną cenę','PRODUCT_LIST_RETAIL_PRICE','0','Czy wyświetlać cenę sugerowaną ?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,6,'2007-02-27 11:55:23','0000-00-00 00:00:00',NULL,NULL),
(1295,'Wyświetlaj pole oszczędzasz','PRODUCT_LIST_SAVE','0','Czy wyświetlać pole oszczędzasz ? Wartość wyświetlana jest w procentach.<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,9,'2007-02-27 11:55:44','0000-00-00 00:00:00',NULL,NULL),
(1296,'Czy wyświetlać cenę sugerowaną producenta','NEW_FIELDS_WHATS_NEW','true','Czy pokazywać sugerowaną cenę w boxach Nowe Produkty, Promocje, Oczekiwane Produkty ?',8,17,'2005-12-12 23:14:11','2005-12-12 22:14:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1297,'Lista wszystkich produktów','ALL_PRODUCTS','true','Czy włączyć katalog wszystkich produktów ?',29,1,'2005-12-15 20:17:23','2005-12-14 21:42:36',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1298,'Lista produktów: nazwa pliku','ALL_PRODUCTS_FILENAME','allprods.php','Lista wszystkich produktów domyslna nazwa pliku to allprods.php',29,2,NULL,'2005-12-14 21:42:36',NULL,''),
(1308,'Logo sklepu','STORE_LOGO','naglowek.jpg','Nazwa pliku zawierającego logo sklepu.',1,5,'2008-11-30 21:16:48','0000-00-00 00:00:00',NULL,NULL),
(1309,'Ilość cen dla produktu','XPRICES_NUM','1','Ilość cen dla produktu<br><br><b>UWAGA: Zmiejszenie ilości cen powoduje ich usunięcie z tabeli produktów!</b><br><br><b>Każdej grupie używającej skasowanych cen przypisana zostanie cena domyślna.</b>',401,1,'2009-11-30 01:11:52','0000-00-00 00:00:00','tep_update_prices','tep_cfg_pull_down_prices(');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1310,'Pokazuj ceny wszystkim','ALLOW_GUEST_TO_SEE_PRICES','true','Wyświetlanie cen osobom niezalogowanym',401,2,'2009-10-06 20:11:07','2004-03-15 14:59:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1311,'Narzut ceny dla klientów niezalogowanych','GUEST_DISCOUNT','0','Narzut ceny dla klientów niezalogowanych',401,3,'2008-05-10 22:46:39','2004-03-15 14:59:05',NULL,''),
(1312,'Cena promocyjna (ukrywanie ceny produktu)','SPECIAL_PRICES_HIDE','false','Cena promocyjna (ukrywanie ceny produktu)',401,4,'2009-01-16 00:03:26','2004-03-15 14:59:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1313,'Aktywacja nowych klientów','NEW_CUSTOMERS_ENABLED','true','Czy konto klienta ma być aktywane od razu po rejestracji ?',401,5,'2009-01-12 21:35:54','2004-03-15 14:59:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1314,'Długość sesji klienta','SESSION_LENGHT','600','Długość sesji klienta (w sekundach)',15,8,'2006-03-09 12:55:35','0000-00-00 00:00:00',NULL,NULL),
(1315,'Długość sesji administratora','SESSION_LENGHT_ADM','1800','Długość sesji administratora (w sekundach)',15,9,'2006-01-02 15:02:53','0000-00-00 00:00:00',NULL,NULL),
(1318,'Szerokość wyświetlanego obrazka w opisie produktu','DISPLAY_IMAGE_WIDTH','150','Szerokość w pixelach obrazka wyświetlanego na karcie <b>informacje o produkcie</b>',4,9,'2007-12-08 23:15:10','2006-01-03 11:34:11',NULL,NULL),
(1319,'Wysokość wyświetlanego obrazka w opisie produktu','DISPLAY_IMAGE_HEIGHT','150','Wysokość w pixelach obrazka wyświetlanego na karcie <b>informacje o produkcie</b>',4,10,'2007-12-08 23:15:16','2006-01-03 11:34:11',NULL,NULL),
(1320,'Szerokość obrazka w oknie PopUp','POPUP_IMAGE_WIDTH','600','Szerokość w pixelach obrazka wyświetlanego w oknie PopUp. Aby zachować oryginalne wymiary pozostaw to pole puste!',4,11,'2008-04-24 15:24:19','2006-01-03 11:34:11',NULL,NULL),
(1321,'Wysokość obrazka w oknie PopUp','POPUP_IMAGE_HEIGHT','600','Wysokość w pixelach obrazka wyświetlanego w oknie PopUp. Aby zachować oryginalne wymiary pozostaw to pole puste!',4,12,'2008-04-24 18:39:11','2006-01-03 11:34:11',NULL,NULL),
(5706,'Kolejność wyświetlania','MODULE_SHIPPING_ODBIOR_OSOBISTY_SORT_ORDER','3','Kolejność wyświetlania',6,0,NULL,'2009-07-14 21:57:33',NULL,NULL),
(4446,'Wyświetlaj ceny brutto i netto','DISPLAY_PRICE_BRUTTO_NETTO','false','Wyświetlanie jednocześnie cen netto i brutto (włączone) lub tylko ceny określonej w ustawieniach z podatkiem lub bez (wyłączona).',101,70,'2008-07-06 22:29:46','2008-02-23 14:42:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(7,'Porządek sortowania oczekiwanych','EXPECTED_PRODUCTS_SORT','desc','Sposób sortowania produktów oczekiwanych.',101,61,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'asc\', \'desc\'),'),
(5411,'Maksymalne zamówienie','MAXIMUM_ORDERS','false','Czy chcesz włączyć ograniecznie ilości kupowanych towarów jednego rodzaju ?',9,6,'2009-01-20 23:56:13','2006-05-03 10:17:10',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1523,'Wyświetlaj maksymalną ilość produktów do kupienia','PRODUCT_LIST_MAXORDER','0','Czy chcesz włączyć wyświetlanie max. ilości kupowanych towarów z danego asortymentu ?',8,14,'2007-02-27 11:32:45','2006-05-09 11:54:18',NULL,NULL),
(4016,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER','20','Na którym miejscu pokazać?\r\r
',6,2,NULL,'2007-12-01 18:36:50',NULL,NULL),
(1582,'Pokazuj podsumę','MODULE_ORDER_TOTAL_SUBTOTAL_STATUS','true','Pokazuje podsumę na stronie z zamówieniem',6,1,NULL,'2006-05-09 13:46:29',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1583,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER','1','Na którym miejscu pokazać?',6,2,NULL,'2006-05-09 13:46:29',NULL,NULL),
(3940,'Koszt przesyłki','MODULE_ORDER_TOTAL_SHIPPING_STATUS','true','Czy chcesz wyświetlać koszt przesyłki ?',6,1,NULL,'2007-09-11 11:01:10',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3941,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER','10','Na którym miejscu pokazać ?',6,2,NULL,'2007-09-11 11:01:10',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1586,'Bezpłatna przesyłka','MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING','false','Czy włączyć możliwość przesyłki na koszt sprzedawcy ?',6,3,NULL,'2006-05-09 13:46:41',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1588,'Bezpłatna przesyłka do zamówień','MODULE_ORDER_TOTAL_SHIPPING_DESTINATION','national','Zastosuj przesyłkę na koszt sprzedawcy do zamówień',6,5,NULL,'2006-05-09 13:46:41',NULL,'tep_cfg_select_option(array(\'national\', \'international\', \'both\'),'),
(1606,'SEO Adresy URL przyjazne dla wyszukiwarek','SEO_ENABLED','true','Adresy URL przyjazne dla wyszukiwarek. Czy włączyć globalne ustawienia wyświetlania adresów URL przyjaznych dla wyszukiwarek ?',403,0,'2009-03-30 21:37:01','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1607,'Dodanie cPath do adresu URL produktu','SEO_ADD_CPATH_TO_PRODUCT_URLS','true','Włączenie tej opcji powoduje dodanie cPath na końcu adresu URL produktu (np. - jakis-product-p-1.html?cPath=xx).',403,1,'2009-11-20 23:30:36','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1608,'Dodanie kategorii nadrzędnej na początku adresu produktu','SEO_ADD_CAT_PARENT','false','Włączenie tej opcji powoduje wyświetlenie nazwy kategorii nadrzędnej na początku adresu URL produktu (np. - nadrzedna-category-c-1.html).',403,2,'2007-09-17 09:29:40','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1609,'Filtrowanie krótkich wyrazów','SEO_URLS_FILTER_SHORT_WORDS','3','Opcja umożliwia filtrowanie w adresie wyrazów krótszych niż podana wartość.',403,3,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,NULL),
(1610,'Pamięć cache','USE_SEO_CACHE_GLOBAL','true','Ustawienie globalne umożliwiające całkowite wyłączenie pamięci cache.',403,5,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1611,'Pamięć cache dla produktów','USE_SEO_CACHE_PRODUCTS','true','Włączenie/Wyłączenie pamięci cache dla produktów.',403,6,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1612,'Pamięć cache dla kategorii','USE_SEO_CACHE_CATEGORIES','true','Włączenie/Wyłączenie pamięci cache dla kategorii',403,7,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1613,'Pamięć cache dla producentów','USE_SEO_CACHE_MANUFACTURERS','true','Włączenie/Wyłączenie pamięci cache dla producentów',403,8,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1614,'Pamięć cache dla artykułów','USE_SEO_CACHE_ARTICLES','true','Włączenie/Wyłączenie pamięci cache dla artykułów',403,9,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1615,'Pamięć cache dla tematów','USE_SEO_CACHE_TOPICS','true','Włączenie/Wyłączenie pamięci cache dla tematów',403,10,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1616,'Pamięć cache dla stron informacyjnych','USE_SEO_CACHE_INFO_PAGES','true','Włączenie/Wyłączenie pamięci cache dla stron informacyjnych',403,11,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1617,'Pamięć cache dla linków','USE_SEO_CACHE_LINKS','true','Włączenie/Wyłączenie pamięci cache dla stron categorii',403,12,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1618,'Automatyczne przekierowania','USE_SEO_REDIRECT','true','Opcja właczania automatycznego przekierowania nagłówków ze starych adresów do nowych',403,13,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1619,'Sposób przepisywania adresów','SEO_REWRITE_TYPE','Rewrite','Wybór formatu SEO URL',403,14,'2006-05-11 12:24:43','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'Rewrite\'),'),
(1620,'Tablica konwersji znaków specjalnych','SEO_CHAR_CONVERT_SET','ą=>a,ę=>e,ć=>c,ś=>s,ł=>l, ń=>n,ó=>o,ż=>z,ź=>z, Ą=>A,Ę=>E,Ć=>C,Ś=>S,Ł=>L, Ń=>N,Ó=>O,Ż=>Z,Ź=>Z','Konwersja znaków specjalnych w adresach<br><br>Należy wprowadzić w nastepującycm formacie :: <br><b>char=>conv,char2=>conv2</b>',403,15,'2009-07-13 23:05:41','2006-05-11 12:24:43',NULL,NULL),
(1621,'Usuwanie znaków specjalnych','SEO_REMOVE_ALL_SPEC_CHARS','false','Usuwanie wszystkich znaków specjalnych z adresów URL.',403,17,'2006-07-16 12:20:59','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(1622,'Czyszczenie Cache','SEO_URLS_CACHE_RESET','false','Wyczyszczenie pamięci cache dla przyjaznych adresów SEO URL',403,16,'2009-11-20 23:30:49','2006-05-11 12:24:43','tep_reset_cache_data_seo_urls','tep_cfg_select_option(array(\'reset\', \'false\'),'),
(1623,'Zgodność z zaleceniami W3C','SEO_URLS_USE_W3C_VALID','true','Włączenie tej opcji umożliwia generowanie adresów URL zgodnie z zaleceniami W3C',403,4,'2009-03-06 22:52:53','2006-05-11 12:24:43',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (8,'Pola sortowania oczekiwanych','EXPECTED_PRODUCTS_FIELD','date_expected','Pole wyznaczające porządek sortowania produktów oczekiwanych.',101,65,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'products_name\', \'date_expected\'),'),
(2999,'Włącz cache stron','ENABLE_PAGE_CACHE','false','Umożliwia włączenie cache w celu przyspieszenia ładowania stron',26229,1,'2009-07-26 22:25:49','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3000,'Czas przetrzymywania stron','PAGE_CACHE_LIFETIME','5','Jak długo mają być przetrzymywane strony (w minutach) ?',26229,2,NULL,'0000-00-00 00:00:00',NULL,NULL),
(3001,'Debug Mode','PAGE_CACHE_DEBUG_MODE','false','Włączenie opcji debuggowania ? Należy korzystać tylko w celu testowania sklepu!  Można również włączyć tę opcje wpisując \"?debug=1\" w adresie strony',26229,3,'2007-08-24 21:16:50','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3002,'Wyłączenie parametrów URL','PAGE_CACHE_DISABLE_PARAMETERS','false','W niektórych przypadkach (np. używania przyjaznych adresów URL) mogą występować błędy przy zapisie stron.',26229,4,'2007-08-24 21:09:00','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3003,'Kasowanie plików','PAGE_CACHE_DELETE_FILES','false','Włączenie opcji spowoduje usunięcie plików cache i ustawi ponownie wartość na wyłączone.',26229,5,'2009-03-30 22:45:17','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3004,'Config Cache Update File','PAGE_CACHE_UPDATE_CONFIG_FILES','none','Jeżeli jest używana kontrybucja Config Cache Update File należy podać pełną ścieżkę do plików.',26229,6,NULL,'0000-00-00 00:00:00',NULL,NULL),
(3210,'Wyłączenie sklepu','DOWN_FOR_MAINTENANCE','false','Włączenie tej opcji powoduje zamknięcie sklepu dla klientów i wyświetlenie informacji o niedostępności sklepu.',0,0,'2006-11-05 10:34:19','2006-08-14 09:22:04',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3211,'Strona informacyjna','DOWN_FOR_MAINTENANCE_PAGE','index-maint.php','Strona do której będą przekierowani klienci podczas zamknięcia sklepu.',0,0,NULL,'2006-08-14 09:22:04',NULL,NULL),
(3212,'Włączyć ostrzeżenie ?','DOWN_FOR_MAINTENANCE_WARNING','false','Włączenie tej opcji powoduje wyświetlenie na stronach sklepu informacji, że sklep zostanie niebawem wyłączony z powodów administracyjnych.',0,0,'2006-11-05 10:34:24','2006-08-14 09:22:04',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3213,'Informacja','DOWN_FOR_MAINTENANCE_MESSAGE','Sklep zostanie wkrótce wyłączony w celach administracyjnych. Przepraszamy za utrudnienia.','Informacja wyświetlona po włączeniu ostrzeżenia',0,0,'2006-08-17 13:45:18','2006-08-14 09:22:04',NULL,'tep_cfg_textarea('),
(3214,'Administracyjny adres IP','DOWN_FOR_MAINTENANCE_IP_ADDRESS','','Adres, z którego jest dostęp do sklepu podczas jego wyłączenia.',0,0,'2006-08-22 21:54:43','2006-08-14 09:22:04',NULL,NULL),
(5493,'Tryb testowy','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_DEBUG','false','Sposób użycia: na stronie potwierdzenia zamówienia, użyj w przeglądarce opcji podgląd źródła. <b>Opcja musi być wyłączona w działającym sklepie.</b>',615,12,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5913,'Tablica kosztów (wg cennika Kuriera)','MODULE_SHIPPING_KURIERPOBRANIE_COST_1','9999:25.00','Koszty przesyłki bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(5914,'Dodatkowy stały koszt obsługi wysyłki','MODULE_SHIPPING_KURIERPOBRANIE_HANDLING_1','0','Dodatkowy stały koszt obsługi wysyłki do tego Obszaru ',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(5915,'Do jakiej wysokości zamówienia obowiązuje wysyłka ?','MODULE_SHIPPING_KURIERPOBRANIE_MAKSYMALNIE','999999','Wartość zamówienia do której obowiązuje przesyłka. Powyżej wpisanej wartości przesyłka będzie wyłączona.',6,0,NULL,'2010-03-02 21:57:06',NULL,NULL),
(5916,'Jeżeli nie można określić kosztów wysyłki ?','MODULE_SHIPPING_KURIERPOBRANIE_OFF','False','Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?',6,0,NULL,'2010-03-02 21:57:06',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(3309,'Znak wodny','IMAGE_WATERMARK','false','Włączenie powoduje wyświetlanie znaku wodnego na obrazkach po ich powiększeniu.<br>Aby funkcja ta działała poprawnie w katalogu /images/ należy umieścić obrazkek w formacie PNG, który będzie tworzył znak wodny.',4,15,'2008-10-30 22:35:11','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3324,'Długość kodu weryfikacyjnego','ENTRY_VALIDATION_LENGTH','4','Określa długość kodu weryfikacyjnego. Domyślnie = 5.',741,50,'2008-12-16 22:17:40','2006-07-30 09:00:00',NULL,NULL),
(3325,'Aktywacja zabezpieczeń antyspamowych','ACCOUNT_VALIDATION','true','Włączenie tej opcji powoduje generowanie kodu, który użytkonik musi wprowadzić podczas wypełniania formularzy. Zabezpiecza to przed automatycznym wypełnianiem przez roboty.',741,1,'2006-09-10 11:10:30','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (3326,'Formularz rejestracji użytkownika ','ACCOUNT_CREATE_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zakładania nowego konta. (OPCJONALNY)',741,20,'2007-05-18 13:34:43','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3327,'Formularz edycji konta ','ACCOUNT_EDIT_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza edycji konta (OPCJONALNY)',741,21,'2009-03-30 20:59:24','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3328,'Formularz zmiany hasła ','ACCOUNT_EDIT_PASSWORD_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zmiany hasła (OPCJONALNY)',741,23,'2007-12-14 08:53:07','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3330,'Formularz kontakt z nami','CONTACT_US_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza kontaktowego (OPCJONALNY)',741,24,'2004-08-08 17:00:00','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5358,'Termin płatności','PAYMENT_PERIOD','10','Maksymalna liczba dni od daty wystawienia faktury, w ciągu których nabywca powinien uregulować fakturę',800,120,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(3332,'Formularz pisania recenzji','ACCOUNT_REVIEWS_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza wpisywania recenzji o produktach (OPCJONALNY)',741,26,'2009-05-05 23:08:52','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3935,'Formularz zapytania o przedmiot','ASKAQUESTION_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza zapytania o produkt (OPCJONALNY)',741,27,'2007-08-07 10:35:23','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(13,'Pozwól gościowi powiadomić znajomego','ALLOW_GUEST_TO_TELL_A_FRIEND','true','Umożliwienie gościowi powiadomienia znajomego o produkcie.',101,50,'2005-11-13 22:02:02','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3351,'Wyświetlanie zapytań','DISPLAY_QUERIES','false','Wyświetlanie informacji do celów testowych - COOKIE, SESSION, POST, GET w stopce sklepu',10,6,'2009-11-13 20:33:04','2006-09-13 08:40:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3406,'Domyslna klasa podatku','DEFAULT_PRODUCT_TAX_CLASS','4','Ustawienie domyslnej klasy podatku podczas dopisywania produktow.',6,0,'2017-09-12 12:22:48','2006-11-14 11:43:03','','tep_cfg_pull_down_tax_classes('),
(5613,'Podatek','MODULE_ORDER_TOTAL_TAX_STATUS','true','Czy chcesz wyświetlić podatek w zamówieniu ?',6,1,NULL,'2009-05-06 19:43:57',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5614,'Kolejność wyświetlania','MODULE_ORDER_TOTAL_TAX_SORT_ORDER','3','Na którym miejscu pokazać?\r\r
',6,2,NULL,'2009-05-06 19:43:57',NULL,NULL),
(3450,'Pokaż pole dostępnosć produktu','DISPLAY_AVAILABILITY','true','Pokazywać pole dostęnosci produktu ?',300,19,'2005-11-11 09:39:36','2003-06-04 05:17:05',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5909,'Włączenie modułu','MODULE_SHIPPING_KURIERPOBRANIE_STATUS','True','Czy włączyć moduł Kurier za pobraniem ?',6,0,NULL,'2010-03-02 21:57:06',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5910,'Grupa VAT','MODULE_SHIPPING_KURIERPOBRANIE_TAX_CLASS','0','Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.',6,0,NULL,'2010-03-02 21:57:06','tep_get_tax_class_title','tep_cfg_pull_down_tax_classes('),
(14,'Domyślny operator logiczny wyszukiwania','ADVANCED_SEARCH_DEFAULT_OPERATOR','and','Domyślny operator logiczny wyszukiwania słów kluczowych.',101,60,NULL,'2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'and\', \'or\'),'),
(3572,'Formularz powiadamiania znajomych','TELL_FRIEND_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza powiadamiania znajomych o produktach (OPCJONALNY)',741,25,'2004-08-08 17:00:00','2004-08-08 17:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3573,'Szerokość obrazka','ANTI_ROBOT_IMAGE_WIDTH','100','Szerokość obrazka z kodem do wprowadzenia w pixelach. Wpisanie zero powoduje automatyczne dopasowanie.',741,51,'2007-06-23 21:00:45','2007-03-15 23:24:48',NULL,NULL),
(3574,'Wysokość obrazka','ANTI_ROBOT_IMAGE_HEIGHT','20','Wysokość generowanego obrazka w pixelach. Ustawienie wartości zero powoduje automatyczne dopasowanie.',741,52,'2007-06-23 21:00:25','2007-03-15 23:24:48',NULL,NULL),
(3575,'Odstęp pomiędzy literami','ANTI_ROBOT_IMAGE_WHITESPACE','10','Odstęp w poziomie pomiędzy generowanymi znakami na obrazku.',741,55,'2007-06-23 20:59:24','2007-03-15 23:24:48',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (3576,'Margines pionowy','ANTI_ROBOT_IMAGE_TOP_MARGIN','5','Margines pionowy pomiędzy generowanymi znakami, a brzegiem obrazka.',741,56,'2007-06-23 20:59:33','2007-03-15 23:24:48',NULL,NULL),
(3579,'Wielkość czcionki','ANTI_ROBOT_IMAGE_FONT_SIZE','10','Wielkość czcionki ',741,59,'2008-07-07 15:14:16','2007-03-15 23:24:48',NULL,NULL),
(3580,'Kolor tła','ANTI_ROBOT_IMAGE_BACKGROUND_COLOR','FFFFFF','Kolor tła generowanego obrazka.',741,60,'2008-07-07 15:15:02','2007-03-15 23:24:48',NULL,NULL),
(3581,'Kolor tekstu','ANTI_ROBOT_IMAGE_TEXT_COLOR','191919','Kolor generowanego tekstu.',741,61,'2007-06-23 20:53:42','2007-03-15 23:24:48',NULL,NULL),
(3582,'Filtr - szum','ANTI_ROBOT_IMAGE_FILTER_NOISE','true','Filtr dodający szum na obrazku',741,62,'2007-06-23 20:59:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3583,'Filtr - rozmazanie','ANTI_ROBOT_IMAGE_FILTER_SCATTER','false','Filtr powodujący rozmazanie czcionek.',741,63,'2007-03-15 23:24:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3584,'Filtr - przeplot','ANTI_ROBOT_IMAGE_FILTER_INTERLACE','false','Filtr dodający przeplot na generowanym obrazku.</em>',741,64,'2007-03-15 23:24:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3585,'Filtr - szarość','ANTI_ROBOT_IMAGE_FILTER_GREYSCALE','false','Filtr powodujący generowanie obrazka w odcieniach szarości',741,65,'2007-03-15 23:24:48','2007-03-15 23:24:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3772,'Szerokość obrazka nagłówka','PDF_MAX_IMAGE_WIDTH','250','Szerokość obrazka nagłówka w PDF.',200,1,'2008-07-02 12:01:47','0000-00-00 00:00:00',NULL,NULL),
(3773,'Wysokość obrazka nagłówka','PDF_MAX_IMAGE_HEIGHT','250','Wysokość obrazka nagłówka w PDF.',200,2,'2008-07-02 12:01:53','0000-00-00 00:00:00',NULL,NULL),
(3774,'Proporcje obrazka nagłówka','PDF_IMAGE_KEEP_PROPORTIONS','true','Czy zachować proporcje obrazka w nagłówku.',200,3,'2005-06-08 20:47:38','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3776,'Logo sklepu w nagłówku','PDF_SHOW_LOGO','false','Czy wyświetlać logo sklepu na nagłówku arkusza PDF ?',200,6,'2009-11-30 22:07:14','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3777,'Ścieżka do pliku logo','PDF_STORE_LOGO','images/oscgold.jpg','Podaj ścieżkę do pliku zawierającego logo sklepu.',200,7,'2008-03-07 12:24:20','0000-00-00 00:00:00',NULL,NULL),
(5452,'Czy pokazywać nazwę producenta na karcie PDF','UPDF_PRODUCENT','1','Definiuje czy generować w PDF nazwę producenta. ',200,55,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5451,'Czy pokazywać numer katalogowy na karcie PDF','UPDF_NR_KATALOGOWY','1','Definiuje czy generować w PDF numer katalogowy produktu. ',200,54,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5450,'Szerokość obrazka produktu w px','UPDF_OBRAZ_WIDTH','150','Definiuje szerokość obrazka/zdjęcia produktu. Wartość należy podać w pikselach.',200,53,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,''),
(5449,'Czy pokazywać datę utworzenia PDF','UPDF_UTWORZONO','1','Definiuje czy generować w PDF datę utworzenia dokumentu. ',200,52,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(3783,'Kolor tekstu w nagłówku','PDF_HEADER_COLOR_TEXT','FFFFFF','Kolor tekstu nagłówka. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #)',200,11,'2009-01-04 00:19:49','0000-00-00 00:00:00',NULL,NULL),
(3784,'Kolor tekstu opisu przedmiotu','PDF_BODY_COLOR_TEXT','000000','Kolor tekstu opisu przedmiotu. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #)',200,12,'2005-06-10 14:54:36','0000-00-00 00:00:00',NULL,NULL),
(3785,'Kolor tła w nagłówku','PDF_HEADER_COLOR_TABLE','474747','Kolor tła w nagłówku. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #)',200,13,'2005-06-10 15:28:11','0000-00-00 00:00:00',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5490,'Wyświetlanie wartości ujemnej ?','MODULE_ORDER_TOTAL_DISCOUNT_COUPON_ALLOW_NEGATIVE','false','Ustawienie opcji true powoduje wyświetlenie ujemnej wartości sumy zamówienia jeżeli ktowa rabatu przekracza wartość zamówienia.',615,9,NULL,'2009-03-15 20:42:32',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(3837,'Moduł wyświetlania dodatkowych cech','PRODINFO_ATTRIBUTE_PLUGIN','multiple_dropdowns','Moduł używany do wyświetlania cech produktów na karcie informacyjnej produktu',888001,1,'2009-03-08 22:13:32','2007-05-08 13:51:17',NULL,'tep_cfg_pull_down_class_files(\'pad_\','),
(3838,'Stan magazynowy','PRODINFO_ATTRIBUTE_SHOW_OUT_OF_STOCK','True','Czy wyświetlać informacje o braku danej opcji produktu w magazynie ?',888001,10,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(3839,'Oznaczenie stanów magazynowych','PRODINFO_ATTRIBUTE_MARK_OUT_OF_STOCK','Right','W którym miejscu wyświetlać informacje o braku danej opcji w magazynie ?',888001,20,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'None\', \'Right\', \'Left\'),'),
(3840,'Komunikat o braku opcji','PRODINFO_ATTRIBUTE_OUT_OF_STOCK_MSGLINE','True','Czy wyświetlać dodatkową informację o braku wybranej opcji w magazynie ?.',888001,30,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(3841,'Dodawanie do koszyka','PRODINFO_ATTRIBUTE_NO_ADD_OUT_OF_STOCK','True','Czy uniemozliwić dodawanie do koszyka towarów, których w wybranej opcji nie ma w magazynie ?',888001,40,NULL,'2007-05-08 13:51:17',NULL,'tep_cfg_select_option(array(\'True\', \'False\'),'),
(3843,'Resampling','THUMBNAIL_USE_RESAMPLING','true','Ustawienie tej wartości na włączone powoduje użycie resamplingu (transformacja bitmapy polegająca na zmianie liczby jej pikseli) w wyniku czego miniaturki mają lepszą jakość. (funkcja ta jest niedostepna w biblitece GD < 2.0.1)',100,0,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3844,'True Color','THUMBNAIL_TRUE_COLOUR','true','Tworzenie miniaturek w trybie true color. Zapewnia lepszą jakość tworzonych miniaturek. Ustaw wyłączone, jeżeli posiadasz bibliotekę GD < 2.0.1 lub jeżeli mają być tworzone przeźroczyste obrazki.',100,1,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3845,'Tworzenie GIF jako JPG','THUMBNAIL_OUTPUT_JPEG','false','Tworzenie miniaturek w formacie JPG z plików GIF lub PNG. UWAGA ! Przeźroczystość plików źrodłowych zostanie utracona. Wymagana biblioteka GD > 1.6. Ustaw Kolor tła w następnej opcji jeżeli ta opcja jest ustawiona jako włączona.',100,2,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3846,'Kolor tła (GIF jako JPEG)','THUMBNAIL_BACKGROUND_MATTE','255,255,255','Ustawienie kolorów tła w formacie RGB podczas tworzenia miniaturek JPG z plików GIF w formacie 255,255,255 (oddzielane przecinkami).',100,3,NULL,'2007-05-17 10:54:12',NULL,NULL),
(3847,'Zapisywanie obrazków na serwerze','THUMBNAIL_CACHE_SERVER','true','Zapisywanie obrazków na serwerze. Zalecana wartość - włączone. Tworzone miniaturki są zapisywane na dysku powodując mniejsze obciążenie procesora.',100,4,'2007-05-17 11:32:04','2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3848,'Ścieżka do miniaturek','THUMBNAIL_PATH','thumbnails/','Ścieżka do katalogu, w którym mają być zapisywane miniaturki. Jeżeli miniaturki mają być tworzone bezpośrednio w katalogu /images/ należy pozostawić to pole puste. Wprowadź nazwę katalogu, np. \'thumbnails/\' jeżeli miniaturki mają być zapisywane w podkatal',100,5,'2009-01-12 21:14:13','2007-05-17 10:54:12',NULL,NULL),
(3849,'Cache obrazków w przeglądarce','THUMBNAIL_CACHE_BROWSER','true','Umożliwia zapisywanie obrazków lokalnie w cache przeglądarki. Zapewnia zmniejszenie transferu podczas przeglądania stron. Zalecane ustawienie - włączone.',100,6,'2007-05-17 11:31:57','2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3850,'Komprecja JPEG','THUMBNAIL_JPEG_COMPRESSION','100','Ustawienie jakości generowanych miniaturek w formacie JPEG. Domyślna wartość 100. Wartość zalecana 70.',100,7,'2007-05-17 11:32:56','2007-05-17 10:54:12',NULL,NULL),
(3851,'Powiększanie obrazków','THUMBNAIL_ALLOW_LARGER','false','Tworzenie miniaturek wówczas, gdy obrazek źródłowy jest mniejszy niż docelowa wielkość miniaturki. Utworzona w ten sposób miniaturka może mieć gorszą jakość.',100,8,NULL,'2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3852,'Pokaż oryginał','THUMBNAIL_SHOW_ORIGINAL','true','Jeżeli Powiększanie obrazków jest włączone, umożliwia wyświetlanie oryginalnych obrazków.',100,9,'2008-05-30 14:36:05','2007-05-17 10:54:12',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3930,'Użyj obrazków jako cechy','OPTIONS_AS_IMAGES_ENABLED','false','Włączenie opcji umożliwia wykorzystanie obrazków jako cechy dodatkowe produktów',888001,50,'2008-06-10 12:44:38','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3931,'Ilość obrazków w wierszu','OPTIONS_IMAGES_NUMBER_PER_ROW','3','Maksymalna ilość obrazków wyswietlanych w jednym wierszu',888001,51,'2007-10-10 14:57:50','0000-00-00 00:00:00',NULL,NULL),
(3932,'Szerokość obrazka','OPTIONS_IMAGES_WIDTH','50','Szerokość obrazka wyświetlanego jako cecha produktu',888001,52,'2007-07-03 12:11:10','0000-00-00 00:00:00',NULL,NULL),
(3933,'Wysokość obrazka','OPTIONS_IMAGES_HEIGHT','50','Wysokość obrazka wyświetlanego jako cecha produktu',888001,53,'2007-07-03 12:11:16','0000-00-00 00:00:00',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (3934,'Powiększanie obrazka','OPTIONS_IMAGES_CLICK_ENLARGE','true','Czy włączyć możliwość powiększania obrazka cechy produktu ?',888001,54,'2008-05-02 15:06:13','0000-00-00 00:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3775,'Znak wodny','PDF_SHOW_WATERMARK','true','Czy drukowac znak wodny na arkuszu PDF ?',200,5,'2009-03-06 22:10:11','0000-00-00 00:00:00','','tep_cfg_select_option(array(\'true\', \'false\'),'),
(5448,'Kolor tekstów informacyjnych karcie produktu PDF','UPDF_KOLOR_TABELI','3C31A7','Definiuje kolor tekstów informacyjnych na karcie produktu PDF (stan magazynowy, producent, numer katalogowy). Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #).',200,51,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,''),
(5447,'Kolor ceny na karcie produktu PDF','UPDF_KOLOR_CENA','FF0000','Definiuje kolor ceny na karcie produktu PDF. Wartość należy podać jako kod koloru - np biały - FFFFFF (bez #).',200,50,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,''),
(3974,'Moduł promocji Polecony-Nagrodzony','PROMO_POLECONY_STATUS','false','Czy włączyć moduł promocji Polecony-Nagrodzony - UWAGA !!! do poprawnego działania modułu musi być również włączony moduł Kuponów rabatowch (w menu Moduły/Podsumowanie zamówienia)',150,1,'2010-03-02 21:58:28','2007-10-31 08:51:01',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(3975,'Okres ważności kuponu rabatowego','PROMO_POLECONY_OKRES','60','Okres ważności kuponu rabatowego przyznanego w promocji Polecony-Nagrodzony',150,2,'2006-04-05 09:15:16','2007-10-29 13:05:38',NULL,NULL),
(3976,'Kwota rabatu','PROMO_POLECONY_RABAT','30.00','Kwota rabatu przyznawanego w ramach promocji Polecony-Nagrodzony',150,3,'2009-03-15 18:57:24','2007-10-29 13:05:38',NULL,NULL),
(3977,'Wyświetlanie boxu promocji Polecony-Nagrodzony','BOX_POLECONY_COLUMN','left','W której kolumnie ma być wyświetlany box informacyjny promocji Polecony-Nagrodzony',150,4,'2007-10-31 09:15:16','2007-10-31 09:05:38',NULL,'tep_cfg_select_option(array(\'left\', \'right\'),'),
(3978,'Status zamówienia do promocji Polecony-Nagrodzony','PROMO_POLECONY_ORDER_STATUS_ID','4','Ustaw status zamówienia, który upoważnia do polecenia sklepu w promocji Polecony-Nagrodzony',150,5,'2007-10-31 12:53:52','2007-10-31 09:05:38','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(3979,'Formularz promocji Polecony-Nagrodzony','POLECONY_VALIDATION','true','Zabezpiecza to przed automatycznym wypełnianiem przez roboty formularza polecającego sklep w promocji Polecony-Nagrodzony (OPCJONALNY)',741,26,'2007-10-31 09:00:00','2007-10-31 09:00:00',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(12,'Wyświetl koszyk po dodaniu produktu','DISPLAY_CART','false','Wyświetlanie koszyka po dodaniu do niego produktu (lub powrót do wybieranego produktu).',101,20,'2009-01-24 19:23:31','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(4154,'Włączyć kontrolę poprawności adresów SEO ?','FWR_VALIDATION_ON','true','Włączyć kontrolę poprawności adresów SEO - moduł kontroluje czy są poprawnie generowane adresy SEO',160,1,'2008-02-13 11:37:34','2008-02-13 11:36:19',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(9,'Przełączenie na walutę danego języka','USE_DEFAULT_LANGUAGE_CURRENCY','false','Automatyczne przełączanie na domyślną walutę wybranego języka przy jego zmiane.',101,30,'2006-08-07 22:26:07','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(16,'Pokaż ilość produktów w kategorii','SHOW_COUNTS','false','Rekurencyjne obliczanie liczby produktów w każdej kategorii.',101,40,'2006-06-22 23:02:45','2003-07-29 13:05:38',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(4594,'Sklep jako katalog produktów','USE_SHOP_AS_CATALOG','false','Wyłączenie w sklepie możliwości dokonywania zakupów - sklep pełni funkcję katalogu produktów',101,10,'2009-03-26 23:23:34','2008-04-08 12:00:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5349,'Logo','LOGO_FILE','images/oscgold_pdf.jpg','Ścieżka dostępu do pliku z logiem',800,110,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5345,'Rachunek bankowy','NR_RACHUNEK','Nr rachunku bankowego','Nr rachunku bankowego',800,80,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5344,'Bank','BANK_NAZWA','Nazwa banku','Nazwa banku',800,70,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5343,'NIP firmy','NIP_FIRMA','Nip firmy','Nip firmy',800,60,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5342,'Kod pocztowy','KOD_POCZTOWY','Kod pocztowy','Kod pocztowy',800,50,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5341,'Miasto','MIASTO','Miasto - siedziba Twojej firmy','Miasto - siedziba Twojej firmy',800,40,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5339,'Firma','FIRMA','Nazwa Twojej firmy','Nazwa Twojej firmy',800,20,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5340,'Ulica','ULICA','Ulica - siedziba Twojej firmy','Ulica - siedziba Twojej firmy',800,30,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5338,'Dodaj do numeru zamówienia','FIRST_ORDER_NR','99','Liczba, która zawsze będzie dodawana do prawdziwego numeru zamówienia',800,19,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5337,'Dodaj do numeru klienta','FIRST_CLIENT_NR','99','Liczba, która zawsze będzie dodawana do prawdziwego numeru klienta',800,18,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5331,'Prefix','PREFIX_FN','FV/','Prefix drukowany przed numerem faktury',800,1,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5332,'Format numeru faktury','FORMAT_FN','%04d','Wzorzec formatowania numeru faktury (jak dla funkcji sprintf)',800,2,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5333,'Suffix','SUFFIX_FN','/%m/%Y','Suffix drukowany za numerem faktury',800,10,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5334,'Ciaglosc numeracji','CONTINUE_NUMERATION','true','Czy wraz z rozpoczęciem nowego roku kalendarzowego zachować ciągłość numeracji faktur?',800,12,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5335,'Pierwszy nr faktury','FIRST_NR','99','Numer od którego rozpocznie się numeracja faktury',800,15,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5336,'Pierwszy nr faktury PRO FORMA','FIRST_PROFORMA_NR','99','Numer od którego rozpocznie się numeracja faktury PRO FORMA',800,16,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(4638,'Installed Modules','MODULE_GIFTWRAP_INSTALLED','','This is automatically updated. No need to edit.',6,0,'2009-11-17 17:55:35','2008-05-21 09:21:12',NULL,NULL),
(4659,'Wyświetlanie PopUp jako Lytebox','FOTO_OPCJE','true','Wyświetlanie powiększonych obrazków przez Lytebox ',4,16,'2009-03-30 15:06:18','2008-05-23 12:00:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(4658,'Hasło','EMAIL_SMTP_PASSWORD','haslo','Hasło użytkownika jeżeli jest wymagana autentykacja.',12,15,'2008-05-21 23:14:38','2008-05-21 11:42:34',NULL,NULL),
(4657,'Nazwa konta','EMAIL_SMTP_USERNAME','nazwa_konta','Nazwa użytkownika jeżeli jest wymagana autentykacja.',12,14,'2008-05-21 23:14:34','2008-05-21 11:42:34',NULL,NULL),
(4656,'Autentykacja SMTP','EMAIL_SMTP_ACTIVE_PASSWORD','true','Czy serwer SMTP wymaga autentykacji.',12,13,'2008-05-21 23:12:15','2008-05-21 11:42:34',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(4654,'Serwer SMTP EHLO / HELO Name','EMAIL_SMTP_HELO_SERVER','nazwa.pl','Nazwa serwera na jaki będą wysyłane komendy SMTP EHLO / HELO. JEst to adres serwera na którym mamy ustawione SMTP.',12,11,'2008-05-21 23:14:29','2008-05-21 11:42:34',NULL,NULL),
(4655,'Port serwera SMTP','EMAIL_SMTP_PORT_SERVER','25','Numer portu serwera SMTP. W większości przypadków jest to port 25.',12,12,NULL,'2008-05-21 11:42:34',NULL,NULL),
(4653,'Adres serwera SMTP','EMAIL_SMTP_HOST_SERVER','serwer.nazwa.pl','Pelen adres serwera SMTP przez który będzie wysyłana poczta.',12,10,'2008-05-21 23:14:22','2008-05-21 11:42:34',NULL,NULL),
(5774,'Ścieżka do programu GZip','LOCAL_EXE_GZIP','/usr/bin/gzip','Scieżka do programu umożliwiającego kompresję GZip.',14,5,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5920,'Status zamówienia','MODULE_PAYMENT_POBRANIEKURIER_ORDER_STATUS_ID','0','Ustaw status zamówienia dla tej metody płatności.',6,0,NULL,'2010-03-02 21:57:31','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5917,'Włącz płatność za pobraniem','MODULE_PAYMENT_POBRANIEKURIER_STATUS','True','Czy chcesz włączyć płatność przy odbiorze za przesyłkę Kurierem ?',6,1,NULL,'2010-03-02 21:57:31',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5918,'Strefa płatności','MODULE_PAYMENT_POBRANIEKURIER_ZONE','0','Możesz wybrać strefę dla której będzie obowiązywał ten sposób płatności.',6,2,NULL,'2010-03-02 21:57:31','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5919,'Kolejność wyświetlania','MODULE_PAYMENT_POBRANIEKURIER_SORT_ORDER','3','Kolejność w jakiej zostanie wyświetlony moduł.',6,0,NULL,'2010-03-02 21:57:31',NULL,NULL),
(5906,'Jeżeli nie można określić kosztów wysyłki ?','MODULE_SHIPPING_KURIER_OFF','False','Jeżeli sklep nie może okreslić kosztów wysyłki czy ma wyłączyć moduł (wyłączone) czy pokazać informacje (włączone) o braku możliwości określenia kosztu wysyłki ?',6,0,NULL,'2010-03-02 21:56:55',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5902,'Włączenie modułu','MODULE_SHIPPING_KURIER_STATUS','True','Czy włączyć moduł Kuriera ?',6,0,NULL,'2010-03-02 21:56:55',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5903,'Grupa VAT','MODULE_SHIPPING_KURIER_TAX_CLASS','0','Użyj następującej grupy VAT odnośnie tego kosztu wysyłki.',6,0,NULL,'2010-03-02 21:56:55','tep_get_tax_class_title','tep_cfg_pull_down_tax_classes('),
(5904,'Strefa dostawy','MODULE_SHIPPING_KURIER_ZONE','0','Wybierz strefę, dla której ma być stosowany ten sposob dostawy',6,0,NULL,'2010-03-02 21:56:55','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5905,'Sortowanie','MODULE_SHIPPING_KURIER_SORT_ORDER','2','Kolejność wyświetlania wśród innych modułów wysyłki.',6,0,NULL,'2010-03-02 21:56:55',NULL,NULL),
(5119,'Przelew bankowy','MODULE_PAYMENT_PL_BANKTRANSFER','True','Czy chcesz akceptować zapłatę przelewem bankowym ?',6,3,NULL,'2008-10-22 12:14:02',NULL,'tep_cfg_select_option(array(\'True\', \'False\'), '),
(5120,'Nazwa Banku','MODULE_PAYMENT_PL_BANKNAME','Tutaj wpisz nazwę banku','Nazwa Banku',6,1,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5121,'Nazwa konta','MODULE_PAYMENT_PL_ACCOUNT_HOLDER','Wpisz nazwę właściciela konta','Nazwa właściciela konta',6,1,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5122,'Numer konta','MODULE_PAYMENT_PL_IBAN','00 0000 0000 0000 0000 0000 000','Numer Twojego konta',6,1,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5123,'Strefa płatności','MODULE_PAYMENT_PL_BANKTRANSFER_ZONE','0','Jeżeli jest wybrana strefa - płatność będzie stosowana tylko do wybranej strefy.',6,2,NULL,'2008-10-22 12:14:02','tep_get_zone_class_title','tep_cfg_pull_down_zone_classes('),
(5124,'Status zamówienia','MODULE_PAYMENT_PL_BANKTRANSFER_ORDER_STATUS_ID','0','Ustaw Status Zamówienia',6,0,NULL,'2008-10-22 12:14:02','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5125,'Kolejność wyświetlania','MODULE_PAYMENT_PL_BANKTRANSFER_SORT_ORDER','2','Kolejność wyświetlania.',6,0,NULL,'2008-10-22 12:14:02',NULL,NULL),
(5139,'Wersja językowa sklepu','USE_BROWSER_LANG','false','Czy sklep ma się uruchamiać domyślnie w wersji językowej takiej jaką ma przeglądarka (włączone), czy w takiej jak jest ustawiony domyślny język (wyłączone) ?',101,150,'2008-06-18 09:30:06','2008-04-08 12:00:07',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5413,'Szacunkowa wartość zamówienia','CARTSHIP_SHOWOT','true','Czy wyświetlać na stronie koszyka szacunkową wartość zamówienia wraz z kosztami dostawy ?',19,2,'2009-01-28 23:11:04','2004-06-29 07:10:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5414,'Lista krajów','CARTSHIP_SHOWCDD','false','Czy wyświetlać listę krajów do obliczenia szacunkowych kosztów dostawy ?',19,6,'2009-01-28 23:12:42','2004-06-29 07:10:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5412,'Szacunkowe koszty dostawy','CARTSHIP_ONOFF','true','Czy wyświetlać na stronie koszyka szacunkowe koszty dostawy ?',19,1,'2009-03-08 00:40:38','2004-06-29 07:10:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5046,'Obsługa cookie','COOKIE_TMP','PGI+MjAwNS0yMDEwIEthbWVsaWEtTmV0IC0gbWdyIGluxbwuIEphY2VrIEtyeXNpYWsgJiBKTUs8L2I+PGJyPkNvcHlyaWdodCAmY29weTsgPGEgaHJlZj0iaHR0cDovL3d3dy5vc2Nnb2xkLmNvbSI+d3d3Lm9zY0dvbGQuY29tPC9hPg==','',9999,NULL,NULL,'0000-00-00 00:00:00',NULL,NULL),
(5222,'Produktów w przechowalni','MAX_DISPLAY_WISHLIST_PRODUCTS','12','Ile produktów pokazywać na jednej stronie przechowalni',12954,0,'2008-12-25 23:21:33','2008-12-25 23:21:33',NULL,NULL),
(5223,'Produktów w boksie przechowalni','MAX_DISPLAY_WISHLIST_BOX','1','Ile produktów pokazywać w boksie informacyjnym zanim zmieni się w licznik',12954,0,'2008-12-27 21:20:12','2008-12-25 23:21:33',NULL,NULL),
(5224,'Adresy e-mail','DISPLAY_WISHLIST_EMAILS','3','Ile adresów e-mail wyświetlać, kiedy klienci przesyłają listę życzeń z przechowalni',12954,0,'2008-12-25 23:21:57','2008-12-25 23:21:33',NULL,NULL),
(5225,'Przekierowanie z przechowalni','WISHLIST_REDIRECT','Tak','Czy chcesz przekierowywać do strony produktu, kiedy klient dodaje produkt do przechowalni?',12954,0,'2008-12-25 23:34:07','2008-12-25 23:21:33',NULL,'tep_cfg_select_option(array(\'Tak\', \'Nie\'),'),
(5226,'Włącz System punktów','USE_POINTS_SYSTEM','false','Czy włączyć moduł żeby klienci mogli zbierać punkty za wykonane zakupy ?',16,1,'2009-11-30 22:07:03','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5227,'Włącz realizację punktów','USE_REDEEM_SYSTEM','true','Czy umożliwić klientom możliwość kupowania za punkty ?',16,2,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5228,'Punkt za 1 jednostkę płatniczą (np 1 zł)','POINTS_PER_AMOUNT_PURCHASE','1','Liczba punktów którą otrzymuje klient za każdy wydany 1 zł (lub inną domyślną walutą zgodnie z ustawieniami)',16,3,'2009-07-13 23:17:46','2008-12-29 12:21:42',NULL,NULL),
(5229,'Wartość 1 punktu przy płaceniu przez klienta','REDEEM_POINT_VALUE','0.1','Wartość 1 punktu przy realizacji zamówienia przez klienta np 0.1 - czyli 10 gr (lub inną domyślną walutą zgodnie z ustawieniami)',16,4,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5230,'Ilość miejsc dziesiętnych','POINTS_DECIMAL_PLACES','0','Ilość miejsc dzisiętnych w liczbie punktów. Wartość 0 (zero) będzie powodowała zaokrąglanie sumy punktów do liczby całkowitej.',16,5,'2009-03-26 15:32:49','2008-12-29 12:21:42',NULL,NULL),
(5232,'Automatycznie wygasanie punktów','POINTS_AUTO_EXPIRES','','Ustaw ilość miesięcy przez ile punkty będą ważne. Po tym okresie punkty na koncie klienta zostaną skasowane. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,7,'2009-11-29 22:02:02','2008-12-29 12:21:42',NULL,NULL),
(5233,'Ilość dni do wygaśnięcia punktów','POINTS_EXPIRES_REMIND','30','Ile dni przed wygaśnięciem punktów klient ma zostać poinformowany. Aby opcja działa w połączniu z Automatycznym wygasaniem punktów. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,8,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5234,'Punkty za koszt wysyłki','USE_POINTS_FOR_SHIPPING','false','Czy włączyć naliczanie punktów za koszt przesyłki ?',16,9,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5235,'Punkty za podatek VAT','USE_POINTS_FOR_TAX','true','Czy włączyć naliczanie punktów od kwoty brutto (razem z VAT) ?',16,10,'2009-07-13 23:17:58','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5236,'Punkty za produkty w promocji','USE_POINTS_FOR_SPECIALS','true','Czy włączyć naliczanie punktów za produkty w promocji ?',16,11,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5237,'Punkty za zakupy z płatnością punktami','USE_POINTS_FOR_REDEEMED','true','Czy włączyć naliczanie punktów za zakupy gdzie płatność jest za pomocą punktów ? Kiedy opcja jest wyłączona punkty nie będą naliczne, nawet jeżeli tylko część zamówienia jest płacona punktami.',16,12,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5238,'Punkty za napisanie recenzji do produktu','USE_POINTS_FOR_REVIEWS','50','Liczba punktów którą otrzymuje klient za napisanie recenzji do produktu. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,13,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5239,'Punkty dla Systemu Poleceń','USE_REFERRAL_SYSTEM','100','Liczba punktów jaką otrzymuje klient za polecenie sklepu. Jeżeli nowy klient przy zamówieniu poda adres email polecającego, polecający otrzyma punkty. Aby wyłączyć ta opcje należy pozostawić pole puste.',16,14,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5240,'Punkty tylko za konkretny produkt','RESTRICTION_MODEL','','Ograniczenie kupowania za punkty do produktu o konkretnym numerze katalogowym. Należy podać nr katalogowy produktu. Aby wyłączyć tą opcje należy pozostawić pole puste. ',16,15,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5241,'Punkty dla produktów o ID','RESTRICTION_PID','','Ograniczenie kupowania za punkty do produktów o określonym ID. Należy podać ID produktów oddzielone przecinkami. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,16,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5242,'Punkty dla kategorii o ID','RESTRICTION_PATH','','Ograniczenie kupowania za punkty produktów do kategorii o określonym ID. Należy podać ID kategorii oddzielone przecinkami. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,17,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5243,'Kupowanie produktów w promocji','REDEMPTION_DISCOUNTED','false','Blokada kupowania za punkty produktów które są w promocji. Wyłączenie opcji powoduje, że za punkty można kupić wszystkie produkty.',16,18,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5244,'Minimalna ilość punktów aby zrobić zakupy','POINTS_LIMIT_VALUE','200','Minimalna ilość punktów jaką musi posiadać klient na swoim koncie żeby móc je wykorzystać. Aby wyłączyć tą opcje należy wpisać 0.',16,19,'2009-03-26 15:33:08','2008-12-29 12:21:42',NULL,NULL),
(5245,'Maksymalna ilość punktów do wydania przy zamówieniu ','POINTS_MAX_VALUE','1000','Maksymalna ilość punktów jaką może wykorzystać klient przy zamówieniu. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,20,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5246,'Minimalna wartość zamówienia','POINTS_MIN_AMOUNT','','Minimalna wartość zamówienia jaka musi być żeby można było kupić za punkty. Aby wyłączyć tą opcje należy pozostawić pole puste.',16,21,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5247,'Ilość punktów przyznawana dla nowych klientów po rejestracji','NEW_SIGNUP_POINT_AMOUNT','0','Liczba punktów jaka ma być automatycznie dopisywana do kont nowo zarejestrowanych klientów. Aby wyłączyć tą opcje należy wpisać 0.',16,22,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5248,'Maksymalna ilość pozycji do wyświetlania','MAX_DISPLAY_POINTS_RECORD','20','Maksymalna ilość pozycji jaka ma się wyświetlać na stronie my_points.php - lista operacji klienta w jego koncie.',16,23,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,NULL),
(5249,'Informacja o punktach na Karcie Produktu','DISPLAY_POINTS_INFO','true','Czy wyświetlać informację o punktach na karcie produktu ?',16,24,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5250,'Ewidencja zrealizowanych punktów','DISPLAY_POINTS_REDEEMED','true','Czy chcesz prowadzić ewidencją wszystkich zrealizowanych punktów ?',16,25,'2008-12-29 12:21:42','2008-12-29 12:21:42',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5254,'Płatność kartą kredytową','ORDER_EDITOR_CREDIT_CARD','Other','Jeżeli zostanie wybrany ten sposób płatności Edytor Zamówień wyświetli dodatkowe pola do wpisania informacji o karcie kredytowej.',72,5,'2009-01-03 21:56:35','2008-12-29 14:36:45',NULL,'tep_cfg_pull_down_payment_methods('),
(5359,'Test','PDF_INVOICE_TEST','true','Ustawia tryb testowania - tworzone faktury nie mają numeru. Tryb przeznaczony do testowania faktur, pozycjonowania loga, kontroli poprawnosci stałych elementów.',800,130,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5361,'Dostawa','DOSTAWA','true','Czy do faktury automatycznie dopisywac koszt wysyłki, takeij jaką klient wybrał podczas finalizacji zakupów w sklepie?',800,140,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5370,'Archiwum faktur','POLISH_INVOICE_PDF_ARCHIVE','backups/invoices/','Katalog przechowujący faktury PDF',800,190,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,NULL),
(5371,'Klient - faktura PRO FORMA','CUSTOMER_PROFORMA','true','Czy klient może wygenerować fakturę PRO FORMA do swojego zamówienia?',800,200,'2009-09-07 19:46:34','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5372,'Klient - faktura DUPLIKAT','CUSTOMER_DUPLIKAT','true','Czy klient może wygenerować fakturę DUPLIKAT do swojego zamówienia?',800,210,'2008-12-31 16:44:59','2008-12-31 16:44:59',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5410,'Minimalna kwota zamówienia','PROMO_POLECONY_MIN_ORDER','50.00','Minimalna kwota zamówienia w celu wykorzystania rabatu przyznawanego w ramach promocji Polecony-Nagrodzony',150,3,'2008-10-05 22:33:30','2007-10-29 13:05:38',NULL,NULL),
(5401,'Sprawdzanie pustych meta tagów','HEADER_TAGS_CHECK_TAGS','false','Czy wyświetlać informacje o pustych meta tagach w produktach, kategoriach i producentach ?',543,4,'2009-06-05 21:36:48','2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5402,'Informacja o błędnych prawach do zapisu','HEADER_TAGS_DIABLE_PERMISSION_WARNING','true','Czy pokazywać informacje o błędnych prawach do zapisu do pliku includes/header_tags.php jeżeli są źlu ustawione ?',543,6,'2009-06-05 21:36:53','2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5403,'Wyświetlanie pomocy','HEADER_TAGS_DISPLAY_HELP_POPUPS','true','Czy wyświetlać pomocnicze opisy pól podczas wprowadzania danych ?',543,7,NULL,'2009-01-09 22:39:48',NULL,'tep_cfg_select_option(array(\'true\', \'false\'), '),
(5404,'Nasycenie słów kluczowych','HEADER_TAGS_KEYWORD_DENSITY_RANGE','0.01,0.06','Zakres nasycenia występowania słów kluczowych podczas dynamicznego generowania meta tagu keywords. Wprowadź wartości graniczne rozdzielone przecinkiem',543,9,'2009-06-05 23:01:38','2009-01-09 22:39:48',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5405,'Znak rozdzielający opisy','HEADER_TAGS_SEPARATOR_DESCRIPTION','-','Wprowadź znak rozodzielający sekcje w opisie strony. Oddziela np. tytuł - kategoria - produkt.',543,10,NULL,'2009-01-09 22:39:48',NULL,NULL),
(5406,'Znak rozdzielający słowa kluczowe','HEADER_TAGS_SEPARATOR_KEYWORD',',','Znak rozdzielający słowa kluczowe w znaczniku meta keywords.',543,11,NULL,'2009-01-09 22:39:48',NULL,NULL),
(5407,'Status zamówienia wznawiający możliwość pobierania','DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE','5','Status zamówienia, który powoduje zostaje ponownie ustawiony okres i ilość możliwych pobrań plików',13,153,'2009-01-11 22:49:54','0000-00-00 00:00:00','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5408,'Informacja o pobieraniu','DOWNLOADS_CONTROLLER_ON_HOLD_MSG','<font color=\"FF0000\">UWAGA: Pobranie pliku jest niemozliwe przed potwierdzeniem płatności</font>','Informacja o możliwości pobierania pliku',13,155,'2009-01-11 21:50:13','0000-00-00 00:00:00',NULL,NULL),
(5409,'Status zamówienia do pobrania pliku','DOWNLOADS_CONTROLLER_ORDERS_STATUS','3','Status zamówienia umożliwiający pobieranie pliku',13,152,'2009-01-11 21:50:33','0000-00-00 00:00:00','tep_get_order_status_name','tep_cfg_pull_down_order_statuses('),
(5453,'Czy pokazywać informacje o dostępności na karcie PDF','UPDF_DOSTEPNOSC','1','Definiuje czy generować w PDF informację o dostępności produktu. ',200,56,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5454,'Czy pokazywać stan magazynowy na karcie PDF','UPDF_STAN_MAGAZYNOWY','1','Definiuje czy generować w PDF informację na temat stanu magazynowego produktu.',200,57,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5455,'Czy pokazywać średnią ocenę na karcie PDF','UPDF_SREDNIA_OCENA','1','Definiuje czy generować w PDF informację na temat oceny produktu. ',200,58,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5456,'Czy pokazywać zdjęcie produktu na karcie PDF','UPDF_OBRAZ_PRODUKTU','1','Definiuje czy generować w PDF zdjęcie produktu. ',200,59,'2009-03-06 22:09:03','2009-03-06 22:09:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(5457,'Tekst znaku wodnego','UPDF_ZNAK_NAZWA','watermark','Definiuje tekst znaku wodnego. Aby opcja zadziałała musi być właczone wyświetlanie znaku wodnego.',200,60,'2009-11-30 22:07:37','2009-03-06 22:09:03',NULL,''),
(5615,'Identyfikator sklepu Skąpiec.pl','STORE_SKAPIEC_ID','123456','Jest to numer sklepu w serwisie Skapiec.pl.<br>Powinieneś go otrzymać od Skapiec.pl',260,10,'2009-05-09 09:39:04','0000-00-00 00:00:00',NULL,NULL),
(5616,'Nick','ENTRY_NICK_MIN_LENGTH','2','Minimalna długość Nicku.',2,1,NULL,'2009-05-10 13:05:38',NULL,NULL),
(5601,'Kontakt telefon GSM 4','KONTAKT_GSM_5','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,22,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5599,'Kontakt telefon GSM 2','KONTAKT_GSM_3','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,20,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5600,'Kontakt telefon GSM 3','KONTAKT_GSM_4','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,21,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5597,'Kontakt telefon 5','KONTAKT_TELEFON_6','','Numer telefonu prezentowany w boxie :Kontakt:',1,17,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5598,'Kontakt telefon GSM 1','KONTAKT_GSM_2','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,19,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5593,'Kontakt telefon 1','KONTAKT_TELEFON_2','zzz zzz zzz','Numer telefonu prezentowany w boxie :Kontakt:',1,13,'2009-05-03 13:15:27','2005-04-02 07:07:39',NULL,NULL),
(5594,'Kontakt telefon 2','KONTAKT_TELEFON_3','','Numer telefonu prezentowany w boxie :Kontakt:',1,14,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5595,'Kontakt telefon 3','KONTAKT_TELEFON_4','','Numer telefonu prezentowany w boxie :Kontakt:',1,15,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5596,'Kontakt telefon 4','KONTAKT_TELEFON_5','','Numer telefonu prezentowany w boxie :Kontakt:',1,16,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5602,'Kontakt telefon GSM 5','KONTAKT_GSM_6','','Numer telefonu GSM prezentowany w boxie :Kontakt:',1,23,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5603,'Kontakt nr GG 1','KONTAKT_NR_GG_2','','Numer GG prezentowany w boxie : Kontakt:',1,25,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5604,'Kontakt nr GG 2','KONTAKT_NR_GG_3','','Numer GG prezentowany w boxie : Kontakt:',1,26,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5605,'Kontakt nr GG 3','KONTAKT_NR_GG_4','','Numer GG prezentowany w boxie : Kontakt:',1,27,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5606,'Kontakt nr GG 4','KONTAKT_NR_GG_5','','Numer GG prezentowany w boxie : Kontakt:',1,28,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5607,'Kontakt nr GG 5','KONTAKT_NR_GG_6','','Numer GG prezentowany w boxie : Kontakt:',1,29,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5608,'Kontakt nr SKYPE 1','KONTAKT_SKYPE_2','','Login SKYPE prezentowany w boxie : Kontakt:',1,33,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5609,'Kontakt nr SKYPE 2','KONTAKT_SKYPE_3','','Login SKYPE prezentowany w boxie : Kontakt:',1,34,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5610,'Kontakt nr SKYPE 3','KONTAKT_SKYPE_4','','Login SKYPE prezentowany w boxie : Kontakt:',1,35,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5611,'Kontakt nr SKYPE 4','KONTAKT_SKYPE_5','','Login SKYPE prezentowany w boxie : Kontakt:',1,36,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5612,'Kontakt nr SKYPE 5','KONTAKT_SKYPE_6','','Login SKYPE prezentowany w boxie : Kontakt:',1,37,'2006-08-31 08:27:08','2005-04-02 07:07:39',NULL,NULL),
(5701,'Wyświetlanie nadrzędnych kategorii w tytule i tagach','HEADER_TAGS_ADD_CATEGORY_PARENTS','Standard','Cała ścieżka kategorii (Full), wszystkie kategorie bież jeżeli produkt jest przypisany do kilku kategorii (Duplicate) lub tylko bieżąca kategoria (Standard). Ustawienia te działają tylko wówczas, jeżeli jest zaznaczona opcja Kategorie w ustawieniach stron',543,5,'2009-06-04 12:45:37','2009-06-04 11:24:59',NULL,'tep_cfg_select_option(array(\'Full Category Path\', \'Duplicate Categories\', \'Standard\'), '),
(5759,'Domyślny status podczas składania zgłoszenia','TICKET_DEFAULT_STATUS_ID','3','Domyślny status, który jest wybrany podczas składania przez klienta zgłoszenia.',69,3,'2009-10-25 19:44:56','2009-01-29 14:29:08','tep_get_ticket_status_name','tep_cfg_pull_down_status('),
(5760,'Domyślny status podczas udzielania odpowiedzi.','TICKET_CUSTOMER_REPLY_STATUS_ID','2','Domyslny status jaki otrzymuje zgłoszenie podczas odpowiedzi klienta.',69,4,NULL,'2009-01-29 14:29:08','tep_get_ticket_status_name','tep_cfg_pull_down_status('),
(5758,'Domyślna treść odpowiedzi','TICKET_DEFAULT_REPLY_ID','2','Domyślna treść wstawiana podczas odpowiedzi do klienta na zgłoszenia.',69,2,'2009-01-31 14:01:53','2009-01-29 14:29:08','tep_get_reply_name','tep_cfg_pull_down_reply('),
(5756,'Nick / login','NICK_VALUE','false','Czy wyświetlać pole NICK w danych klienta?',5,6,'2009-09-08 17:36:52','2009-09-08 17:36:52',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5761,'Domyślny dział obsługujący zgłoszenia','TICKET_DEFAULT_DEPARTMENT_ID','4','Domyślny dział zajmujący się obsługą zgłoszeń klientów.<br><br>Na liscie znajdują się aktualnie zdefiniowane w panelu administratora grupy użytkowników',69,5,'2009-10-25 19:45:04','2009-01-29 14:29:08','tep_get_departments_name','tep_cfg_pull_down_departments('),
(5762,'Domyślny priorytet zgłoszenia','TICKET_DEFAULT_PRIORITY_ID','3','Domyślny priorytet zgłoszenia przekazywanego przez klienta.',69,6,'2009-10-25 19:45:09','2009-01-29 14:29:08','tep_get_priority_name','tep_cfg_pull_down_priority('),
(5763,'Wyświetlanie statusu zgłoszenia','TICKET_CATALOG_USE_STATUS','true','Czy wyświetlać status zgłoszenia na liście do przeglądania przez klienta ?',69,8,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),');
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5764,'Minimalna długość opisu','TICKET_ENTRIES_MIN_LENGTH','10','Minimalna długość opisu do wprowadzenia podczas składania przez klienta zgłoszenia reklamacyjnego',69,7,'2009-11-15 11:20:33','2009-01-29 14:29:08',NULL,NULL),
(5765,'Wyświetlanie statusu zgłoszenia','TICKET_CATALOG_USE_STATUS','true','Czy wyświetlać status zgłoszenia na liście do przeglądania przez klienta ?',69,8,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5766,'Zmiana statusu zgłoszenia','TICKET_ALLOW_CUSTOMER_TO_CHANGE_STATUS','false','Czy zezwalać klientowi na zmiane statusu zgłoszenia podczas odpowiedzi na informację o realizacji zgłoszenia ?',69,9,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5767,'Wyświetlanie działu','TICKET_CATALOG_USE_DEPARTMENT','true','Czy wyświetlać dział do którego zostało przydzielone zgłoszenie na liście do przeglądania przez klienta ?',69,10,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5768,'Zmiana działu','TICKET_ALLOW_CUSTOMER_TO_CHANGE_DEPARTMENT','true','Czy zezwalać klientowi na zmianę działu, do którego ma zostać przesłana odpowiedź na informację o realizacji zgłoszenia ?',69,11,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5769,'Wyświetlanie priorytetu','TICKET_CATALOG_USE_PRIORITY','true','Czy wyświetlać priorytet zgłoszenia na liście do przeglądania przez klienta ?',69,12,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5770,'Zmiana priorytetu','TICKET_ALLOW_CUSTOMER_TO_CHANGE_PRIORITY','true','Czy zezwalać klientowi na zmianę priorytetu, podczas przesyłania odpowiedzi na informację o realizacji zgłoszenia ?',69,13,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5771,'Lista zamówień','TICKET_SHOW_CUSTOMERS_ORDER_IDS','true','Czy pokazywać listę dotychczasowych zamówień klienta podczas obsługi zgłoszeń ?',69,14,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5772,'Przeglądanie zgłoszeń','TICKET_CUSTOMER_LOGIN_REQUIREMENT_DEFAULT','true','Czy zarejestrowany klient musi być zalogowany w celu przeglądania swoich zgłoszeń ?<br><br>1 - włączone<br>0 - wyłączone',69,15,'2009-01-31 15:28:35','2009-01-29 14:29:08',NULL,'tep_cfg_select_option(array(\'true\', \'false\'),'),
(5775,'Ścieżka do programu GUNZip','LOCAL_EXE_GUNZIP','/usr/bin/gunzip','Scieżka do programu umożliwiającego dekompresję GUNZip.',14,6,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL),
(5776,'Ścieżka do programu Zip','LOCAL_EXE_ZIP','/usr/local/bin/zip','Scieżka do programu umożliwiającego kompresję Zip.',14,7,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL),
(5777,'Ścieżka do programu UNZip','LOCAL_EXE_UNZIP','/usr/local/bin/unzip','Scieżka do programu umożliwiającego dekompresję UNZip.',14,8,'2009-10-26 19:17:11','2009-10-26 13:05:38',NULL,NULL),
(5841,'Last Database Restore','DB_LAST_RESTORE','db_oscgold-20091125202937.sql','Last database restore file',6,0,'0000-00-00 00:00:00','2009-11-25 20:59:02','',''),
(5833,'Negocjacja ceny produktu','MAO_MAX_OFFER_PERCENTAGE_ALLOWED','20','Maksymalna obniżka ceny jaką może zaproponować klient. Wartość podaje się w procentach od ceny wyjściowej produktu.',101,30,NULL,'2008-07-05 09:14:27',NULL,NULL),
(5908,'Dodatkowy stały koszt obsługi wysyłki','MODULE_SHIPPING_KURIER_HANDLING_1','0','Dodatkowy stały koszt obsługi wysyłki',6,0,NULL,'2010-03-02 21:56:55',NULL,NULL),
(5907,'Tablica kosztów (wg cennika Kuriera)','MODULE_SHIPPING_KURIER_COST_1','9999:20.00','Koszty przesyłki bazujące na maksymalnej wadze sumarycznej zamowienia. Przykład: 3:8.50,7:10.50,... zamowienia do wagi 3 kosztują 8.50, do wagi 7 kosztują 10.50',6,0,NULL,'2010-03-02 21:56:55',NULL,NULL),
(5888,'Wyświetlaj kolumnę PDF','PRODUCT_LIST_PDF','0','Czy wyświetlać kolumnę z możliwością pobrania PDF ?<br>(używane tylko wówczas jeżeli wybrano wywietlanie listy produktów w wierszach)',8,10,'2010-01-18 20:24:56','2009-07-29 13:05:38',NULL,NULL),
(5889,'Mod_Negocjacja','PRODUCTS_MAKE_AN_OFFER','false','',9998,0,NULL,'2010-01-01 15:00:00',NULL,NULL),
(5890,'Mod_Wysylka','SHIPPING_METHODS','false','',9998,0,NULL,'2010-01-01 15:00:00',NULL,NULL),
(5891,'Mod_SMS','SMS','false','',9998,0,NULL,'2010-01-01 15:00:00',NULL,NULL);
insert into `configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (5892,'Mod_Znizki','PRODUCTS_DISCOUNT','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5895,'Mod_Gratis','MODS_GRATIS','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5896,'Mod_Download','MODS_DOWNLOAD','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5897,'Mod_Film','MODS_FILM','false','',9998,0,'2010-01-01 15:00:00','2010-01-01 15:00:00',NULL,NULL),
(5898,'Ceneo - status DOSTĘPNY OD RĘKI','CENEO_STATUS_1','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny od ręki</b>',260,20,'2010-02-25 21:39:49','2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses('),
(5899,'Ceneo - status DOSTĘPNY DO 3 DNI','CENEO_STATUS_3','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny do 3 dni</b>',260,21,'2010-02-25 21:57:29','2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses('),
(5900,'Ceneo - status DOSTĘPNY DO TYGODNIA','CENEO_STATUS_7','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny do tygodnia</b>',260,22,'2010-02-25 21:57:29','2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses('),
(5901,'Ceneo - status DOSTĘPNY POWYŻEJ TYGODNIA','CENEO_STATUS_14','0','Przypisz status dostępności produktu w sklepie odpowiadający statusowi<br><b>Dostępny powyżej tygodnia</b>',260,23,NULL,'2010-02-25 19:27:59','tep_get_products_availabilitys_name','tep_get_products_availability_statuses(');

drop table if exists `configuration_group`;
CREATE TABLE `configuration_group` (
  `configuration_group_id` int(11) NOT NULL,
  `configuration_group_title` varchar(64) NOT NULL,
  `configuration_group_description` varchar(255) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`),
  UNIQUE KEY `idx_visible_cfg` (`visible`,`configuration_group_id`),
  KEY `idx_visible` (`visible`)
);

insert into `configuration_group` (`configuration_group_id`, `configuration_group_title`, `configuration_group_description`, `sort_order`, `visible`) values (101,'Ustawienia sklepu','Globalne ustawienia parametrów sklepu',1,1),
(1,'Twój sklep','Ogólne informacje o sklepie',1,1),
(401,'Ustawienia dla hurtowni','Konfiguracja sklepu do obsługi hurtowni',2,1),
(2,'Wartości minimalne','Minimalne wartości funkcji i danych',3,1),
(3,'Wartości maksymalne','Maksymalne wartości fukcji i danych',4,1),
(4,'Obrazki','Parametry obrazków',5,1),
(5,'Klienci','Konfiguracja kont klientów',6,1),
(6,'Opcje modułów','Niewidoczne',7,0),
(7,'Dostawa/Pakowanie','Opcje przesyłek sklepu',8,1),
(8,'Ustawienia listingu produków','Konfiguracja wyświetlania produktów',9,1),
(9,'Magazyn','Konfiguracja dostępnośc produktów',10,1),
(10,'Logi','Konfigruacja logowania',12,1),
(12,'Opcje E-mail','Ogólne ustawienia wysyłania poczty oraz listów w formacie HTML',14,1),
(13,'Pobieranie','Konfiguracja produktów, które można pobrać',15,1),
(14,'Kompresja GZip','Konfiguracja kompresji GZip',16,1),
(15,'Sesje','Konfiguracja sesji',17,1),
(300,'Wyświetlanie pól w szybkich zmianach danych o produktach','Ustawienia modułu wprowadzania szybkich zmian w produktach',3,1),
(99,'Ustawienia wyglądu sklepu (szablony standardowe)','Moduł definiowania ustawień wyglądu sklepu',1,1),
(29,'Katalog wszystkich produktów','Wyświetlanie listy wszystkich produktów',29,1),
(26229,'Ustawienia Cache','Konfiguracja pamięci podręcznej',13,1);
insert into `configuration_group` (`configuration_group_id`, `configuration_group_title`, `configuration_group_description`, `sort_order`, `visible`) values (0,'Wyłączenie sklepu','Wyłączenie dostępu do sklepu dla klientów ze względów administracyjnych',901,1),
(741,'Anti Spambot ','Zabezpieczenie formularzy przed wysyłaniem maili przez roboty',300,1),
(403,'SEO Przyjazne adresy URL','Konfiguracja wyświetlania adresów poprawiających pozycję sklepu w wyszukiwarkach',11,1),
(200,'Konfiguracja wydruków PDF','Konfiguracja ustawień arkusza PDF',200,1),
(888001,'Cechy produktów','Ustawienia parametrów wyświetlania i zakupów produktów z dodatkoymi cechami',8,1),
(100,'Miniaturki zdjęć','Ustawienia tworzenia miniaturek obrazków',5,1),
(150,'Promocja Polecony-Nagrodzony','Ustawienia dla promocji Polecony_Nagrodzony',1,1),
(160,'Kontrola poprawności adresów SEO','Kontorola poprawności stosowanych adresów SEO URLs',902,1),
(800,'Ustawienia Faktury PDF','Wszystkie niezbędne parametry faktury PDF',800,1),
(12954,'Schowek - Konfiguracja','Konfiguracja schowka',25,1),
(16,'System punktów','Konfiguracja systemu punktów',16,1),
(72,'Edytor zamówień','Opcje konfiguracyjne edytora zamówień',72,1),
(543,'Edytor Meta Tagów','Konfiguracja edytora Meta Tagów',20,1),
(19,'Ustawienia strony koszyka','Konfiguracja dostępnych modułów na stronie koszyka',19,1),
(260,'Parametry dla porównywarek','Paramtery konfiguracyjne dla porównywarek cen',910,1),
(69,'Reklamacje - ustawienia','Opcje konfiguracyjne zgłoszeń reklamacyjnych',69,1);

drop table if exists `contact`;
CREATE TABLE `contact` (
  `id_pola` int(5) NOT NULL AUTO_INCREMENT,
  `email` varchar(50) NOT NULL,
  `nazwa` varchar(80) NOT NULL,
  `sort_order` int(4) NOT NULL,
  `languages` int(2) NOT NULL,
  PRIMARY KEY (`id_pola`)
);

drop table if exists `counter`;
CREATE TABLE `counter` (
  `startdate` char(8) DEFAULT NULL,
  `counter` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`counter`),
  KEY `idx_startdate` (`startdate`)
);

insert into `counter` (`startdate`, `counter`) values ('20170901',12);

drop table if exists `counter_history`;
CREATE TABLE `counter_history` (
  `month` char(8) DEFAULT NULL,
  `counter` int(12) DEFAULT NULL
);

drop table if exists `countries`;
CREATE TABLE `countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_name` varchar(64) NOT NULL,
  `countries_iso_code_2` char(2) NOT NULL,
  `countries_iso_code_3` char(3) NOT NULL,
  `address_format_id` int(11) NOT NULL,
  PRIMARY KEY (`countries_id`),
  KEY `idx_address_format_id` (`address_format_id`),
  KEY `idx_countries_name` (`countries_name`),
  KEY `idx_iso_2` (`countries_iso_code_2`),
  KEY `idx_iso_3` (`countries_iso_code_3`)
);

insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (1,'Afghanistan','AF','AFG',1),
(2,'Albania','AL','ALB',1),
(3,'Algeria','DZ','DZA',1),
(4,'American Samoa','AS','ASM',1),
(5,'Andorra','AD','AND',1),
(6,'Angola','AO','AGO',1),
(7,'Anguilla','AI','AIA',1),
(8,'Antarctica','AQ','ATA',1),
(9,'Antigua and Barbuda','AG','ATG',1),
(10,'Argentina','AR','ARG',1),
(11,'Armenia','AM','ARM',1),
(12,'Aruba','AW','ABW',1),
(13,'Australia','AU','AUS',1),
(14,'Austria','AT','AUT',5),
(15,'Azerbaijan','AZ','AZE',1),
(16,'Bahamas','BS','BHS',1),
(17,'Bahrain','BH','BHR',1),
(18,'Bangladesh','BD','BGD',1),
(19,'Barbados','BB','BRB',1),
(20,'Belarus','BY','BLR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (21,'Belgium','BE','BEL',1),
(22,'Belize','BZ','BLZ',1),
(23,'Benin','BJ','BEN',1),
(24,'Bermuda','BM','BMU',1),
(25,'Bhutan','BT','BTN',1),
(26,'Bolivia','BO','BOL',1),
(27,'Bosnia and Herzegowina','BA','BIH',1),
(28,'Botswana','BW','BWA',1),
(29,'Bouvet Island','BV','BVT',1),
(30,'Brazil','BR','BRA',1),
(31,'British Indian Ocean Territory','IO','IOT',1),
(32,'Brunei Darussalam','BN','BRN',1),
(33,'Bulgaria','BG','BGR',1),
(34,'Burkina Faso','BF','BFA',1),
(35,'Burundi','BI','BDI',1),
(36,'Cambodia','KH','KHM',1),
(37,'Cameroon','CM','CMR',1),
(38,'Canada','CA','CAN',1),
(39,'Cape Verde','CV','CPV',1),
(40,'Cayman Islands','KY','CYM',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (41,'Central African Republic','CF','CAF',1),
(42,'Chad','TD','TCD',1),
(43,'Chile','CL','CHL',1),
(44,'China','CN','CHN',1),
(45,'Christmas Island','CX','CXR',1),
(46,'Cocos (Keeling) Islands','CC','CCK',1),
(47,'Colombia','CO','COL',1),
(48,'Comoros','KM','COM',1),
(49,'Congo','CG','COG',1),
(50,'Cook Islands','CK','COK',1),
(51,'Costa Rica','CR','CRI',1),
(52,'Cote D\'Ivoire','CI','CIV',1),
(53,'Croatia','HR','HRV',1),
(54,'Cuba','CU','CUB',1),
(55,'Cyprus','CY','CYP',1),
(56,'Czech Republic','CZ','CZE',1),
(57,'Denmark','DK','DNK',1),
(58,'Djibouti','DJ','DJI',1),
(59,'Dominica','DM','DMA',1),
(60,'Dominican Republic','DO','DOM',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (61,'East Timor','TP','TMP',1),
(62,'Ecuador','EC','ECU',1),
(63,'Egypt','EG','EGY',1),
(64,'El Salvador','SV','SLV',1),
(65,'Equatorial Guinea','GQ','GNQ',1),
(66,'Eritrea','ER','ERI',1),
(67,'Estonia','EE','EST',1),
(68,'Ethiopia','ET','ETH',1),
(69,'Falkland Islands (Malvinas)','FK','FLK',1),
(70,'Faroe Islands','FO','FRO',1),
(71,'Fiji','FJ','FJI',1),
(72,'Finland','FI','FIN',1),
(73,'France','FR','FRA',1),
(74,'France, Metropolitan','FX','FXX',1),
(75,'French Guiana','GF','GUF',1),
(76,'French Polynesia','PF','PYF',1),
(77,'French Southern Territories','TF','ATF',1),
(78,'Gabon','GA','GAB',1),
(79,'Gambia','GM','GMB',1),
(80,'Georgia','GE','GEO',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (81,'Germany','DE','DEU',5),
(82,'Ghana','GH','GHA',1),
(83,'Gibraltar','GI','GIB',1),
(84,'Greece','GR','GRC',1),
(85,'Greenland','GL','GRL',1),
(86,'Grenada','GD','GRD',1),
(87,'Guadeloupe','GP','GLP',1),
(88,'Guam','GU','GUM',1),
(89,'Guatemala','GT','GTM',1),
(90,'Guinea','GN','GIN',1),
(91,'Guinea-bissau','GW','GNB',1),
(92,'Guyana','GY','GUY',1),
(93,'Haiti','HT','HTI',1),
(94,'Heard and Mc Donald Islands','HM','HMD',1),
(95,'Honduras','HN','HND',1),
(96,'Hong Kong','HK','HKG',1),
(97,'Hungary','HU','HUN',1),
(98,'Iceland','IS','ISL',1),
(99,'India','IN','IND',1),
(100,'Indonesia','ID','IDN',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (101,'Iran (Islamic Republic of)','IR','IRN',1),
(102,'Iraq','IQ','IRQ',1),
(103,'Ireland','IE','IRL',1),
(104,'Israel','IL','ISR',1),
(105,'Italy','IT','ITA',1),
(106,'Jamaica','JM','JAM',1),
(107,'Japan','JP','JPN',1),
(108,'Jordan','JO','JOR',1),
(109,'Kazakhstan','KZ','KAZ',1),
(110,'Kenya','KE','KEN',1),
(111,'Kiribati','KI','KIR',1),
(112,'Korea, Democratic People\'s Republic of','KP','PRK',1),
(113,'Korea, Republic of','KR','KOR',1),
(114,'Kuwait','KW','KWT',1),
(115,'Kyrgyzstan','KG','KGZ',1),
(116,'Lao People\'s Democratic Republic','LA','LAO',1),
(117,'Latvia','LV','LVA',1),
(118,'Lebanon','LB','LBN',1),
(119,'Lesotho','LS','LSO',1),
(120,'Liberia','LR','LBR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (121,'Libyan Arab Jamahiriya','LY','LBY',1),
(122,'Liechtenstein','LI','LIE',1),
(123,'Lithuania','LT','LTU',1),
(124,'Luxembourg','LU','LUX',1),
(125,'Macau','MO','MAC',1),
(126,'Macedonia, The Former Yugoslav Republic of','MK','MKD',1),
(127,'Madagascar','MG','MDG',1),
(128,'Malawi','MW','MWI',1),
(129,'Malaysia','MY','MYS',1),
(130,'Maldives','MV','MDV',1),
(131,'Mali','ML','MLI',1),
(132,'Malta','MT','MLT',1),
(133,'Marshall Islands','MH','MHL',1),
(134,'Martinique','MQ','MTQ',1),
(135,'Mauritania','MR','MRT',1),
(136,'Mauritius','MU','MUS',1),
(137,'Mayotte','YT','MYT',1),
(138,'Mexico','MX','MEX',1),
(139,'Micronesia, Federated States of','FM','FSM',1),
(140,'Moldova, Republic of','MD','MDA',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (141,'Monaco','MC','MCO',1),
(142,'Mongolia','MN','MNG',1),
(143,'Montserrat','MS','MSR',1),
(144,'Morocco','MA','MAR',1),
(145,'Mozambique','MZ','MOZ',1),
(146,'Myanmar','MM','MMR',1),
(147,'Namibia','NA','NAM',1),
(148,'Nauru','NR','NRU',1),
(149,'Nepal','NP','NPL',1),
(150,'Netherlands','NL','NLD',1),
(151,'Netherlands Antilles','AN','ANT',1),
(152,'New Caledonia','NC','NCL',1),
(153,'New Zealand','NZ','NZL',1),
(154,'Nicaragua','NI','NIC',1),
(155,'Niger','NE','NER',1),
(156,'Nigeria','NG','NGA',1),
(157,'Niue','NU','NIU',1),
(158,'Norfolk Island','NF','NFK',1),
(159,'Northern Mariana Islands','MP','MNP',1),
(160,'Norway','NO','NOR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (161,'Oman','OM','OMN',1),
(162,'Pakistan','PK','PAK',1),
(163,'Palau','PW','PLW',1),
(164,'Panama','PA','PAN',1),
(165,'Papua New Guinea','PG','PNG',1),
(166,'Paraguay','PY','PRY',1),
(167,'Peru','PE','PER',1),
(168,'Philippines','PH','PHL',1),
(169,'Pitcairn','PN','PCN',1),
(170,'Poland','PL','POL',5),
(171,'Portugal','PT','PRT',1),
(172,'Puerto Rico','PR','PRI',1),
(173,'Qatar','QA','QAT',1),
(174,'Reunion','RE','REU',1),
(175,'Romania','RO','ROM',1),
(176,'Russian Federation','RU','RUS',1),
(177,'Rwanda','RW','RWA',1),
(178,'Saint Kitts and Nevis','KN','KNA',1),
(179,'Saint Lucia','LC','LCA',1),
(180,'Saint Vincent and the Grenadines','VC','VCT',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (181,'Samoa','WS','WSM',1),
(182,'San Marino','SM','SMR',1),
(183,'Sao Tome and Principe','ST','STP',1),
(184,'Saudi Arabia','SA','SAU',1),
(185,'Senegal','SN','SEN',1),
(186,'Seychelles','SC','SYC',1),
(187,'Sierra Leone','SL','SLE',1),
(188,'Singapore','SG','SGP',4),
(189,'Slovakia (Slovak Republic)','SK','SVK',1),
(190,'Slovenia','SI','SVN',1),
(191,'Solomon Islands','SB','SLB',1),
(192,'Somalia','SO','SOM',1),
(193,'South Africa','ZA','ZAF',1),
(194,'South Georgia and the South Sandwich Islands','GS','SGS',1),
(195,'Spain','ES','ESP',3),
(196,'Sri Lanka','LK','LKA',1),
(197,'St. Helena','SH','SHN',1),
(198,'St. Pierre and Miquelon','PM','SPM',1),
(199,'Sudan','SD','SDN',1),
(200,'Suriname','SR','SUR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (201,'Svalbard and Jan Mayen Islands','SJ','SJM',1),
(202,'Swaziland','SZ','SWZ',1),
(203,'Sweden','SE','SWE',1),
(204,'Switzerland','CH','CHE',1),
(205,'Syrian Arab Republic','SY','SYR',1),
(206,'Taiwan','TW','TWN',1),
(207,'Tajikistan','TJ','TJK',1),
(208,'Tanzania, United Republic of','TZ','TZA',1),
(209,'Thailand','TH','THA',1),
(210,'Togo','TG','TGO',1),
(211,'Tokelau','TK','TKL',1),
(212,'Tonga','TO','TON',1),
(213,'Trinidad and Tobago','TT','TTO',1),
(214,'Tunisia','TN','TUN',1),
(215,'Turkey','TR','TUR',1),
(216,'Turkmenistan','TM','TKM',1),
(217,'Turks and Caicos Islands','TC','TCA',1),
(218,'Tuvalu','TV','TUV',1),
(219,'Uganda','UG','UGA',1),
(220,'Ukraine','UA','UKR',1);
insert into `countries` (`countries_id`, `countries_name`, `countries_iso_code_2`, `countries_iso_code_3`, `address_format_id`) values (221,'United Arab Emirates','AE','ARE',1),
(222,'United Kingdom','GB','GBR',1),
(223,'United States','US','USA',2),
(224,'United States Minor Outlying Islands','UM','UMI',1),
(225,'Uruguay','UY','URY',1),
(226,'Uzbekistan','UZ','UZB',1),
(227,'Vanuatu','VU','VUT',1),
(228,'Vatican City State (Holy See)','VA','VAT',1),
(229,'Venezuela','VE','VEN',1),
(230,'Viet Nam','VN','VNM',1),
(231,'Virgin Islands (British)','VG','VGB',1),
(232,'Virgin Islands (U.S.)','VI','VIR',1),
(233,'Wallis and Futuna Islands','WF','WLF',1),
(234,'Western Sahara','EH','ESH',1),
(235,'Yemen','YE','YEM',1),
(236,'Yugoslavia','YU','YUG',1),
(237,'Zaire','ZR','ZAR',1),
(238,'Zambia','ZM','ZMB',1),
(239,'Zimbabwe','ZW','ZWE',1);

drop table if exists `currencies`;
CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `code` char(3) NOT NULL,
  `symbol_left` varchar(12) DEFAULT NULL,
  `symbol_right` varchar(12) DEFAULT NULL,
  `decimal_point` char(1) DEFAULT NULL,
  `thousands_point` char(1) DEFAULT NULL,
  `decimal_places` char(1) DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  PRIMARY KEY (`currencies_id`),
  KEY `idx_currencies_code` (`code`)
);

insert into `currencies` (`currencies_id`, `title`, `code`, `symbol_left`, `symbol_right`, `decimal_point`, `thousands_point`, `decimal_places`, `value`, `last_updated`) values (1,'Polski Złoty','PLN','','zł',',','.','2','1.00000000','2009-10-06 10:11:21'),
(2,'Euro','EUR','','Euro','.',',','2','0.23716351','2009-10-06 10:11:21'),
(3,'Dolar','USD','','$','.',',','2','0.34660843','2009-10-06 10:11:21'),
(4,'Funt brytyjski','GBP','','£','.',',','2','0.21693386','2009-10-06 10:11:21');

drop table if exists `customers`;
CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `nick` varchar(30) NOT NULL,
  `customers_gender` char(1) DEFAULT NULL,
  `customers_firstname` varchar(32) NOT NULL,
  `customers_lastname` varchar(32) NOT NULL,
  `customers_dob` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customers_email_address` varchar(96) NOT NULL,
  `customers_default_address_id` int(11) DEFAULT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_fax` varchar(32) DEFAULT NULL,
  `customers_password` varchar(40) DEFAULT NULL,
  `customers_newsletter` char(1) DEFAULT NULL,
  `guest_account` tinyint(4) NOT NULL DEFAULT '0',
  `customer_discount` decimal(5,2) NOT NULL DEFAULT '0.00',
  `customers_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customers_groups_id` int(11) NOT NULL DEFAULT '1',
  `customers_status` int(11) NOT NULL DEFAULT '0',
  `customers_agreement` char(1) NOT NULL,
  `customers_polecony` int(11) NOT NULL DEFAULT '0',
  `customers_polecajacy_id` int(11) NOT NULL,
  `customers_shopping_points` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `customers_points_expires` date DEFAULT NULL,
  PRIMARY KEY (`customers_id`),
  KEY `idx_customers_email_address` (`customers_email_address`),
  KEY `idx_customers_firstname` (`customers_firstname`),
  KEY `idx_customers_groups_id` (`customers_groups_id`),
  KEY `idx_customers_lastname` (`customers_lastname`),
  KEY `idx_customers_newsletter` (`customers_newsletter`),
  KEY `idx_customers_password` (`customers_password`)
);

drop table if exists `customers_basket`;
CREATE TABLE `customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `customers_basket_quantity` int(6) NOT NULL,
  `final_price` decimal(15,4) NOT NULL,
  `customers_basket_date_added` char(8) DEFAULT NULL,
  PRIMARY KEY (`customers_basket_id`),
  KEY `idx_customers_id` (`customers_id`)
);

drop table if exists `customers_basket_attributes`;
CREATE TABLE `customers_basket_attributes` (
  `customers_basket_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL,
  `products_options_value_id` int(11) NOT NULL,
  PRIMARY KEY (`customers_basket_attributes_id`),
  KEY `idx_customers_id` (`customers_id`)
);

drop table if exists `customers_basket_text_attributes`;
CREATE TABLE `customers_basket_text_attributes` (
  `session_id` varchar(255) NOT NULL,
  `products_id` varchar(50) NOT NULL,
  `products_text_attributes_id` int(11) NOT NULL DEFAULT '0',
  `products_text_attributes_text` text NOT NULL,
  `customqty` varchar(255) NOT NULL,
  PRIMARY KEY (`session_id`,`products_id`,`products_text_attributes_id`)
);

drop table if exists `customers_groups`;
CREATE TABLE `customers_groups` (
  `customers_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_groups_name` varchar(32) NOT NULL,
  `customers_groups_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customers_groups_price` int(11) NOT NULL DEFAULT '1',
  `customers_groups_min_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`customers_groups_id`)
);

insert into `customers_groups` (`customers_groups_id`, `customers_groups_name`, `customers_groups_discount`, `customers_groups_price`, `customers_groups_min_amount`) values (1,'Domyślnie','0.00',1,'0.00'),
(2,'Sprzedaż hurtowa','-30.00',1,'0.00');

drop table if exists `customers_info`;
CREATE TABLE `customers_info` (
  `customers_info_id` int(11) NOT NULL,
  `customers_info_date_of_last_logon` datetime DEFAULT NULL,
  `customers_info_number_of_logons` int(5) DEFAULT NULL,
  `customers_info_date_account_created` datetime DEFAULT NULL,
  `customers_info_date_account_last_modified` datetime DEFAULT NULL,
  `global_product_notifications` int(1) DEFAULT '0',
  PRIMARY KEY (`customers_info_id`),
  KEY `idx_customers_info_number_of_logons` (`customers_info_number_of_logons`)
);

drop table if exists `customers_points_pending`;
CREATE TABLE `customers_points_pending` (
  `unique_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `points_pending` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `points_comment` varchar(200) DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `points_status` int(1) NOT NULL DEFAULT '1',
  `points_type` varchar(2) NOT NULL DEFAULT 'SP',
  PRIMARY KEY (`unique_id`)
);

drop table if exists `customers_to_extra_fields`;
CREATE TABLE `customers_to_extra_fields` (
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `value` text
);

drop table if exists `customers_wishlist`;
CREATE TABLE `customers_wishlist` (
  `products_id` tinytext NOT NULL,
  `customers_id` int(13) NOT NULL DEFAULT '0'
);

drop table if exists `customers_wishlist_attributes`;
CREATE TABLE `customers_wishlist_attributes` (
  `customers_wishlist_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `products_id` tinytext NOT NULL,
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `products_options_value_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_wishlist_attributes_id`)
);

drop table if exists `discount_coupons`;
CREATE TABLE `discount_coupons` (
  `coupons_id` varchar(32) NOT NULL,
  `coupons_description` varchar(64) NOT NULL,
  `coupons_discount_amount` decimal(15,12) NOT NULL DEFAULT '0.000000000000',
  `coupons_discount_type` enum('fixed','percent','shipping') NOT NULL DEFAULT 'percent',
  `coupons_date_start` datetime DEFAULT NULL,
  `coupons_date_end` datetime DEFAULT NULL,
  `coupons_max_use` int(3) NOT NULL DEFAULT '0',
  `coupons_min_order` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `coupons_min_order_type` enum('price','quantity') NOT NULL DEFAULT 'price',
  `coupons_number_available` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`)
);

drop table if exists `discount_coupons_to_categories`;
CREATE TABLE `discount_coupons_to_categories` (
  `coupons_id` varchar(32) NOT NULL,
  `categories_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`categories_id`)
);

drop table if exists `discount_coupons_to_customers`;
CREATE TABLE `discount_coupons_to_customers` (
  `coupons_id` varchar(32) NOT NULL,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`customers_id`)
);

drop table if exists `discount_coupons_to_manufacturers`;
CREATE TABLE `discount_coupons_to_manufacturers` (
  `coupons_id` varchar(32) NOT NULL,
  `manufacturers_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`manufacturers_id`)
);

drop table if exists `discount_coupons_to_orders`;
CREATE TABLE `discount_coupons_to_orders` (
  `discount_coupons_to_orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_id` varchar(32) DEFAULT NULL,
  `orders_id` int(11) DEFAULT '0',
  PRIMARY KEY (`discount_coupons_to_orders_id`),
  KEY `idx_coupons_id` (`coupons_id`)
);

drop table if exists `discount_coupons_to_products`;
CREATE TABLE `discount_coupons_to_products` (
  `coupons_id` varchar(32) NOT NULL,
  `products_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`products_id`)
);

drop table if exists `discount_coupons_to_zones`;
CREATE TABLE `discount_coupons_to_zones` (
  `coupons_id` varchar(32) NOT NULL,
  `geo_zone_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`geo_zone_id`)
);

drop table if exists `extra_fields`;
CREATE TABLE `extra_fields` (
  `fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `fields_input_type` int(11) NOT NULL DEFAULT '0',
  `fields_input_value` text NOT NULL,
  `fields_status` tinyint(2) NOT NULL DEFAULT '0',
  `fields_required_status` tinyint(2) NOT NULL DEFAULT '0',
  `fields_size` int(5) NOT NULL DEFAULT '0',
  `fields_required_email` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fields_id`)
);

drop table if exists `extra_fields_info`;
CREATE TABLE `extra_fields_info` (
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `fields_name` varchar(32) NOT NULL DEFAULT ''
);

drop table if exists `faq`;
CREATE TABLE `faq` (
  `faq_id` int(11) NOT NULL AUTO_INCREMENT,
  `faq_status` tinyint(1) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`faq_id`)
);

drop table if exists `faq_description`;
CREATE TABLE `faq_description` (
  `faq_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `faq_question` text,
  `faq_answer` text,
  PRIMARY KEY (`faq_id`,`language_id`)
);

drop table if exists `featured`;
CREATE TABLE `featured` (
  `featured_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `featured_date_added` datetime DEFAULT NULL,
  `featured_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`featured_id`),
  KEY `idx_expires_date_zen` (`expires_date`),
  KEY `idx_products_id` (`products_id`),
  KEY `idx_status` (`status`)
);

drop table if exists `geo_zones`;
CREATE TABLE `geo_zones` (
  `geo_zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `geo_zone_name` varchar(32) NOT NULL,
  `geo_zone_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`geo_zone_id`)
);

insert into `geo_zones` (`geo_zone_id`, `geo_zone_name`, `geo_zone_description`, `last_modified`, `date_added`) values (1,'Polska i kraje EU','Obowiązujący podatek VAT','2007-07-13 13:08:28','2006-05-27 18:49:12'),
(3,'Polska','Polska',NULL,'2007-07-13 13:08:57'),
(4,'Wszystkie kraje','Wszystkie kraje','2008-10-21 21:07:54','2008-06-04 13:40:02'),
(5,'Wszystkie kraje bez PL','Wszystkie kraje bez PL',NULL,'2008-10-21 21:08:13');

drop table if exists `headertags`;
CREATE TABLE `headertags` (
  `page_name` varchar(64) NOT NULL,
  `page_title` varchar(120) NOT NULL,
  `page_description` varchar(255) NOT NULL,
  `page_keywords` varchar(255) NOT NULL,
  `page_logo` varchar(255) NOT NULL,
  `page_logo_1` varchar(255) NOT NULL,
  `page_logo_2` varchar(255) NOT NULL,
  `page_logo_3` varchar(255) NOT NULL,
  `page_logo_4` varchar(255) NOT NULL,
  `append_default_title` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_description` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_keywords` tinyint(1) NOT NULL DEFAULT '0',
  `append_default_logo` tinyint(1) NOT NULL DEFAULT '0',
  `append_category` tinyint(1) NOT NULL DEFAULT '0',
  `append_manufacturer` tinyint(1) NOT NULL DEFAULT '0',
  `append_product` tinyint(1) NOT NULL DEFAULT '1',
  `append_root` tinyint(1) NOT NULL DEFAULT '1',
  `sortorder_title` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_description` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_keywords` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_logo` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_category` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_manufacturer` tinyint(2) NOT NULL DEFAULT '0',
  `sortorder_product` tinyint(2) NOT NULL DEFAULT '10',
  `sortorder_root` tinyint(2) NOT NULL DEFAULT '1',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`page_name`,`language_id`)
);

insert into `headertags` (`page_name`, `page_title`, `page_description`, `page_keywords`, `page_logo`, `page_logo_1`, `page_logo_2`, `page_logo_3`, `page_logo_4`, `append_default_title`, `append_default_description`, `append_default_keywords`, `append_default_logo`, `append_category`, `append_manufacturer`, `append_product`, `append_root`, `sortorder_title`, `sortorder_description`, `sortorder_keywords`, `sortorder_logo`, `sortorder_category`, `sortorder_manufacturer`, `sortorder_product`, `sortorder_root`, `language_id`) values ('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,1),
('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,2),
('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,3),
('index.php','','','','','','','','',1,1,1,0,0,0,1,1,5,7,6,0,0,0,10,1,4),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,1),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,2),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,3),
('product_info.php','','','','','','','','',0,0,0,0,1,1,1,1,0,0,0,0,5,15,10,1,4),
('product_reviews.php','Komentarze','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),
('product_reviews.php','Comments','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,2),
('product_reviews.php','Comments','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,3),
('product_reviews.php','Comments','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,4),
('product_reviews_write.php','Napisz komentarz','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,1),
('product_reviews_write.php','Comment Write','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,2),
('product_reviews_write.php','Comment Write','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,3),
('product_reviews_write.php','Comment Write','','','','','','','',0,0,0,0,0,0,1,1,0,0,0,0,0,0,10,1,4),
('specials.php','Promocje','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,1),
('specials.php','Specials','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,2),
('specials.php','Specials','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,3),
('specials.php','Specials','','','','','','','',0,1,1,0,0,0,1,1,0,7,6,0,0,0,10,1,4);

drop table if exists `headertags_default`;
CREATE TABLE `headertags_default` (
  `default_title` varchar(255) NOT NULL,
  `default_description` varchar(255) NOT NULL,
  `default_keywords` varchar(255) NOT NULL,
  `default_logo_text` varchar(255) NOT NULL,
  `default_logo_append_group` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_category` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_manufacturer` tinyint(1) NOT NULL DEFAULT '1',
  `default_logo_append_product` tinyint(1) NOT NULL DEFAULT '1',
  `meta_google` tinyint(1) NOT NULL DEFAULT '0',
  `meta_language` tinyint(1) NOT NULL DEFAULT '0',
  `meta_noodp` tinyint(1) NOT NULL DEFAULT '1',
  `meta_noydir` tinyint(1) NOT NULL DEFAULT '1',
  `meta_replyto` tinyint(1) NOT NULL DEFAULT '0',
  `meta_revisit` tinyint(1) NOT NULL DEFAULT '0',
  `meta_robots` tinyint(1) NOT NULL DEFAULT '0',
  `meta_unspam` tinyint(1) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`default_title`,`language_id`),
  KEY `idx_language_id` (`language_id`)
);

insert into `headertags_default` (`default_title`, `default_description`, `default_keywords`, `default_logo_text`, `default_logo_append_group`, `default_logo_append_category`, `default_logo_append_manufacturer`, `default_logo_append_product`, `meta_google`, `meta_language`, `meta_noodp`, `meta_noydir`, `meta_replyto`, `meta_revisit`, `meta_robots`, `meta_unspam`, `language_id`) values ('Domyślny tytuł strony','Domyślny opis strony','Domyślne słowa kluczowe','Domyślny tekst alt',0,0,1,0,0,0,1,1,0,0,0,0,1),
('Page Title','Description','Keywords','Store Name',0,1,0,1,0,0,1,1,0,0,0,0,2),
('Page Titel','Beschreibung','Schlagworte','Shop-Name',0,1,0,1,0,0,1,1,0,0,0,0,3),
('Название страницы','Описание','Ключевые слова','Название магазина',0,1,0,1,0,0,1,1,0,0,0,0,4);

drop table if exists `invoices_symfonia`;
CREATE TABLE `invoices_symfonia` (
  `invoice_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) DEFAULT NULL,
  `numer_faktury` int(11) DEFAULT NULL,
  `customers_name` varchar(256) DEFAULT NULL,
  `customers_company` varchar(256) DEFAULT NULL,
  `customers_nip` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) DEFAULT NULL,
  `customers_postcode` varchar(10) DEFAULT NULL,
  `customers_street_address` varchar(64) DEFAULT NULL,
  `invoice_nr` varchar(32) DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `date_printed` datetime DEFAULT NULL,
  `total_netto` decimal(14,2) DEFAULT NULL,
  `total_vat` decimal(14,2) DEFAULT NULL,
  `total_netto_22` decimal(14,2) DEFAULT NULL,
  `total_vat_22` decimal(14,2) DEFAULT NULL,
  `total_netto_7` decimal(14,2) DEFAULT NULL,
  `total_vat_7` decimal(14,2) DEFAULT NULL,
  `total_netto_3` decimal(14,2) DEFAULT NULL,
  `total_vat_3` decimal(14,2) DEFAULT NULL,
  `total_netto_0` decimal(14,2) DEFAULT NULL,
  `total_netto_zw` decimal(14,2) DEFAULT NULL,
  `total_netto_np` decimal(14,2) DEFAULT NULL,
  `total_brutto` decimal(14,2) DEFAULT NULL,
  `date_payment` datetime DEFAULT NULL,
  `filename` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`invoice_id`),
  KEY `idx_orders_id` (`orders_id`)
);

drop table if exists `languages`;
CREATE TABLE `languages` (
  `languages_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `code` char(2) NOT NULL,
  `image` varchar(64) DEFAULT NULL,
  `directory` varchar(32) DEFAULT NULL,
  `sort_order` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`languages_id`),
  KEY `idx_name` (`name`),
  KEY `idx_sort_order` (`sort_order`)
);

insert into `languages` (`languages_id`, `name`, `code`, `image`, `directory`, `sort_order`) values (1,'Polski','pl','icon.gif','polish',1),
(2,'Angielski','en','icon.gif','english',2),
(3,'Niemiecki','de','icon.gif','german',3),
(4,'Rosyjski','ru','icon.gif','russian',4);

drop table if exists `mailing`;
CREATE TABLE `mailing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `email` varchar(80) NOT NULL,
  PRIMARY KEY (`id`)
);

drop table if exists `manudiscount`;
CREATE TABLE `manudiscount` (
  `manudiscount_id` int(11) NOT NULL AUTO_INCREMENT,
  `manudiscount_name` varchar(128) NOT NULL,
  `manudiscount_groups_id` int(11) NOT NULL DEFAULT '0',
  `manudiscount_customers_id` int(11) NOT NULL DEFAULT '0',
  `manudiscount_manufacturers_id` int(11) NOT NULL DEFAULT '0',
  `manudiscount_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`manudiscount_id`),
  KEY `idx_manudiscount_groups_id` (`manudiscount_groups_id`)
);

drop table if exists `manufacturers`;
CREATE TABLE `manufacturers` (
  `manufacturers_id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_name` varchar(32) NOT NULL,
  `manufacturers_image` varchar(64) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `action` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`manufacturers_id`),
  UNIQUE KEY `action` (`action`),
  KEY `idx_manufacturers_name` (`manufacturers_name`)
);

drop table if exists `manufacturers_info`;
CREATE TABLE `manufacturers_info` (
  `manufacturers_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `manufacturers_url` varchar(255) NOT NULL,
  `url_clicked` int(5) NOT NULL DEFAULT '0',
  `date_last_click` datetime DEFAULT NULL,
  `manufacturers_htc_title_tag` varchar(80) DEFAULT NULL,
  `manufacturers_htc_desc_tag` longtext,
  `manufacturers_htc_keywords_tag` longtext,
  `manufacturers_htc_description` longtext,
  PRIMARY KEY (`manufacturers_id`,`languages_id`),
  KEY `idx_date_last_click` (`date_last_click`),
  KEY `idx_languages_id` (`languages_id`)
);

drop table if exists `modules_configuration`;
CREATE TABLE `modules_configuration` (
  `configuration_id` int(4) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(100) NOT NULL,
  `configuration_value` varchar(50) NOT NULL,
  `configuration_description` varchar(50) NOT NULL,
  `location` int(2) NOT NULL,
  `max_display` varchar(3) NOT NULL,
  `info_id` int(2) NOT NULL,
  `header` int(1) NOT NULL,
  PRIMARY KEY (`configuration_id`),
  KEY `idx_configuration_value_location` (`configuration_value`,`location`)
);

insert into `modules_configuration` (`configuration_id`, `configuration_title`, `configuration_value`, `configuration_description`, `location`, `max_display`, `info_id`, `header`) values (7,'default_specials','yes','Promocje statyczne',5,'2',0,0),
(6,'main_categories','no','Kategorie produktów',3,'-',0,0),
(8,'default_specials_scroll','no','Promocje przewijane',6,'5',0,0),
(9,'newsdesk_sticky','no','Ważne informacje',1,'-',0,0),
(10,'star_product','no','Nasz hit',2,'-',0,0),
(12,'newsdesk','no','Aktualności',6,'-',0,0),
(13,'new_products_scroll','no','Nowości przewijane',2,'7',0,0),
(14,'new_products','yes','Nowości statyczne',9,'4',0,0),
(15,'featured','yes','Produkty polecane',4,'2',0,0),
(16,'upcoming_products','no','Produkty oczekiwane',10,'2',0,0),
(18,'info_pages','yes','Witamy w sklepie internetowym',1,'-',7,1);

drop table if exists `newsdesk`;
CREATE TABLE `newsdesk` (
  `newsdesk_id` int(11) NOT NULL AUTO_INCREMENT,
  `newsdesk_image` varchar(64) DEFAULT NULL,
  `newsdesk_image_two` varchar(64) DEFAULT NULL,
  `newsdesk_image_three` varchar(64) DEFAULT NULL,
  `newsdesk_date_added` datetime NOT NULL,
  `newsdesk_last_modified` datetime DEFAULT NULL,
  `newsdesk_date_available` datetime DEFAULT NULL,
  `newsdesk_status` tinyint(1) NOT NULL DEFAULT '0',
  `newsdesk_sticky` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`newsdesk_id`),
  KEY `idx_newsdesk_date_added` (`newsdesk_date_added`),
  KEY `idx_newsdesk_status` (`newsdesk_status`)
);

drop table if exists `newsdesk_categories`;
CREATE TABLE `newsdesk_categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(64) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `sort_order` int(3) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `catagory_status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`categories_id`),
  KEY `idx_catagory_status` (`catagory_status`),
  KEY `idx_parent_id_cat_id` (`parent_id`,`categories_id`),
  KEY `idx_sort_order` (`sort_order`)
);

drop table if exists `newsdesk_categories_description`;
CREATE TABLE `newsdesk_categories_description` (
  `categories_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `categories_name` varchar(32) NOT NULL,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_id` (`categories_id`),
  KEY `idx_categories_name` (`categories_name`),
  KEY `idx_language_id` (`language_id`)
);

drop table if exists `newsdesk_configuration`;
CREATE TABLE `newsdesk_configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(64) NOT NULL,
  `configuration_key` varchar(64) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_group_id` int(11) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `use_function` varchar(255) DEFAULT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`configuration_id`),
  KEY `idx_configuration_group_id` (`configuration_group_id`),
  KEY `idx_configuration_key` (`configuration_key`),
  KEY `idx_configuration_key_value` (`configuration_key`,`configuration_value`),
  KEY `idx_configuration_value` (`configuration_value`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_sort_order` (`sort_order`)
);

insert into `newsdesk_configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (1,'Wyniki wyszukiwania','MAX_DISPLAY_NEWSDESK_SEARCH_RESULTS','20','Ilość wyszukiwanych artykułów',1,1,NULL,'2003-02-16 02:08:36',NULL,NULL),
(2,'Ilość artykułów na stronie','MAX_DISPLAY_NEWSDESK_PAGE_LINKS','3','Ile pokazać artykułów na pojedyńczej stronie ?',1,2,'2009-05-14 22:13:04','2003-02-16 02:08:36',NULL,NULL),
(3,'Pokazuj tytuł artykułu','NEWSDESK_ARTICLE_NAME','2','Czy pokazać tytuł artykułu ? (0 = nie lub nr do sortowania na liście)',1,3,'2007-02-08 14:06:49','2003-02-16 02:08:36',NULL,NULL),
(4,'Pokazuj wstęp artykułu','NEWSDESK_ARTICLE_SHORTTEXT','3','Czy pokazać wstęp artykułu ? (0 = nie lub nr do sortowania na liście)',1,4,'2006-02-04 16:30:53','2003-02-16 02:08:36',NULL,NULL),
(5,'Pokazuj treść artykułu','NEWSDESK_ARTICLE_DESCRIPTION','0','Czy pokazać treść artykułu ? (0 = nie lub nr do sortowania na liście)',1,5,'2004-05-10 13:28:43','2003-02-16 02:08:36',NULL,NULL),
(6,'Pokazuj datę','NEWSDESK_DATE_AVAILABLE','0','Czy pokazać datę utworzenia artykułu ? (0 = nie lub nr do sortowania na liście)',1,6,'2007-02-08 14:06:25','2003-02-16 02:08:36',NULL,NULL),
(7,'Pokazuj URL artykułu','NEWSDESK_ARTICLE_URL','0','Czy pokazać odnośnik do zewnętrznej strony WWW ? (0 = nie lub nr do sortowania na liście)',1,7,'2004-11-11 12:44:38','2003-02-16 02:08:36',NULL,NULL),
(8,'Pokazuj nazwę URL','NEWSDESK_ARTICLE_URL_NAME','0','Czy pokazać nazwę odnośnika do zewnętrznej strony WWW ? (0 = nie lub nr do sortowania na liście)',1,8,'2004-11-11 12:44:44','2004-05-26 17:07:00',NULL,NULL),
(9,'Pokazuj status artykułu','NEWSDESK_STATUS','0','Czy pokazać status artykułu ? (0 = nie lub nr do sortowania na liście)',1,9,'2004-11-11 12:43:32','2003-02-16 02:08:36',NULL,NULL),
(10,'Pokazuj Zdjęcie nr 1','NEWSDESK_IMAGE','1','Czy pokazać Zdjęcie nr 1 ? (0 = nie lub nr do sortowania na liście)',1,10,'2007-02-08 14:06:40','2003-02-16 02:08:36',NULL,NULL),
(11,'Pokazuj Zdjęcie nr 2','NEWSDESK_IMAGE_TWO','1','Czy pokazać Zdjęcie nr 2 ? (0 = nie lub nr do sortowania na liście)',1,11,'2009-05-14 21:44:11','2003-02-16 02:08:36',NULL,NULL),
(12,'Pokazuj Zdjęcie nr 3','NEWSDESK_IMAGE_THREE','0','Czy pokazać Zdjęcie nr 3 ? (0 = nie lub nr do sortowania na liście)',1,12,'2004-05-10 13:29:06','2003-02-16 02:08:36',NULL,NULL),
(14,'Pasek nawigacyjny Poprzedni/Następny','NEWSDESK_PREV_NEXT_BAR_LOCATION','1','Czy pokazać pasek nawigacyjny Poprzedni/Następny ? (0 - włączone, 1 - wyłączone)',1,14,'2004-11-11 12:54:36','2003-02-16 02:08:36',NULL,NULL),
(15,'Ilość artykułów na stronie głównej','MAX_DISPLAY_NEWSDESK_NEWS','3','Ile artykułów pokazać na stronie głównej sklepu ?',2,1,'2009-05-14 22:54:29','2003-02-16 02:08:36',NULL,NULL),
(16,'Ilość artykułów w boxie Aktualności','LATEST_DISPLAY_NEWSDESK_NEWS','5','Ile artykułów pokazać w boxie Aktualności ?',2,2,NULL,'2003-02-16 02:08:36',NULL,NULL),
(19,'Pokazuj ilość odsłon artykułu','DISPLAY_NEWSDESK_VIEWCOUNT','1','Czy pokazać ilość odsłon artykułu ?',2,3,'2009-05-14 23:39:45','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(20,'Pokazuj odnośnik \"więcej\"','DISPLAY_NEWSDESK_READMORE','1','Czy pokazać odnośnik \"więcej\" ?',2,4,'2006-07-10 14:28:03','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(21,'Pokazuj wstęp artukułu','DISPLAY_NEWSDESK_SUMMARY','1','Czy pokazać wstęp artykułu ?',2,5,'2009-05-14 23:39:51','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(22,'Pokazuj tytuł artykułu','DISPLAY_NEWSDESK_HEADLINE','1','Czy pokazać wstęp artykułu ?',2,6,NULL,'2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(23,'Pokazuj datę','DISPLAY_NEWSDESK_DATE','0','Czy pokazać datę utworzenia artykułu ?',2,7,'2009-05-14 23:01:14','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),');
insert into `newsdesk_configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (24,'Pokazuj Zdjęcie nr 1','DISPLAY_NEWSDESK_IMAGE','1','Czy pokazać Zdjęcie nr 1 ?',2,8,NULL,'2003-03-03 11:59:47',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(25,'Pokazuj Zdjęcie nr 2','DISPLAY_NEWSDESK_IMAGE_TWO','1','Czy pokazać Zdjęcie nr 2 ?',2,9,'2004-11-11 13:27:03','2003-03-03 11:59:47',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(26,'Pokazuj Zdjęcie nr 3','DISPLAY_NEWSDESK_IMAGE_THREE','1','Czy pokazać Zdjęcie nr 3 ?',2,10,'2004-11-11 13:27:08','2003-03-03 11:59:47',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(27,'Pokazuj komentarze','DISPLAY_NEWSDESK_REVIEWS','1','Czy pokazywać komentarze do artykułów ?',3,1,'2009-05-14 22:14:50','2003-02-16 02:08:36',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(29,'Pokazuj tytuł artykułu','STICKY_ARTICLE_NAME','1','Czy pokazać tytuł artykułu ?',4,1,NULL,'2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(30,'Pokazuj wstęp do artykułu','STICKY_ARTICLE_SHORTTEXT','1','Czy pokazać wstęp do artykułu ?',4,2,NULL,'2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(31,'Pokazuj treść artukułu','STICKY_ARTICLE_DESCRIPTION','1','Czy pokazać treść artykułu ?',4,3,'2009-05-14 23:39:22','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(32,'Pokazuj ilość odsłon artykułu','STICKY_NEWSDESK_VIEWCOUNT','1','Czy pokazać ilość odsłon artykułu ?',4,4,'2009-05-14 23:39:26','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(33,'Pokazuj odnośnik \"więcej\"','STICKY_NEWSDESK_READMORE','1','Czy pokazać odnośnik \"więcej\" ?',4,5,NULL,'2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(34,'Pokazuj datę','STICKY_DATE_ADDED','1','Czy pokazać datę utworzenia artykułu ?',4,6,'2009-05-14 23:39:31','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(35,'Pokazuj URL artykułu','STICKY_ARTICLE_URL','0','Czy pokazać URL do zewnętrznej strony WWW ?',4,7,'2004-05-26 17:13:50','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(36,'Pokazuj nazwę URL','STICKY_ARTICLE_URL_NAME','1','Czy pokazać nazwę URL do zewnętrznej strony WWW ?',4,8,'2003-03-02 00:51:00','2003-03-02 00:50:00',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(37,'Pokazuj Zdjęcie nr 1','STICKY_IMAGE','1','Czy pokazać Zdjęcie nr 1 ?',4,9,'2003-03-02 00:50:14','2003-03-02 00:47:21',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(38,'Pokazuj Zdjęcie nr 2','STICKY_IMAGE_TWO','1','Czy pokazać Zdjęcie nr 2 ?',4,10,NULL,'2003-03-03 23:10:34',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(39,'Pokazuj Zdjęcie nr 3','STICKY_IMAGE_THREE','1','Czy pokazać Zdjęcie nr 3 ?',4,11,NULL,'2003-03-03 23:10:34',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(40,'Pokazuj datę dodania artykułu','NEWS_CZY_DATA','1','Czy pokazywać datę dodania artykułu ?',5,1,'2009-05-14 23:36:21','2009-05-14 22:24:08',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(41,'Pokazuj wstęp do artykułu','NEWS_CZY_WSTEP','1','Czy pokazywać wstęp do artykułu ?',5,2,'2009-05-14 23:36:38','2009-05-14 22:25:56',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(42,'Pokazuj nagłówek artykułu - WSTĘP','NEWS_CZY_WSTEP_NAGL','0','Czy pokazywać nagłowek  artykułu - WSTĘP ?',5,3,'2009-07-14 19:36:09','2009-05-14 22:27:08',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(43,'Pokazuj treść artykułu','NEWS_CZY_TRESC','1','Czy pokazywać treść artykułu ?',5,4,'2009-05-14 22:28:02','2009-05-14 22:28:04',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(44,'Pokazuj nagłowek artykułu - ZAWARTOŚĆ','NEWS_CZY_TRESC_NAGL','0','Czy pokazywać nagłowek  artykułu - ZAWARTOŚĆ ?',5,5,'2009-07-14 19:35:54','2009-05-14 22:28:52',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),');
insert into `newsdesk_configuration` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) values (45,'Pokazuj dodatkowy link','NEWS_CZY_LINK','1','Czy pokazywać dodatkowy link ?',5,6,'2009-05-14 23:39:04','2009-05-14 22:29:59',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(46,'Pokazuj nagłowek artykułu - LINK','NEWS_CZY_LINK_NAGL','1','Czy pokazywać nagłowek  artykułu - LINK ?',5,7,'2009-05-14 22:30:33','2009-05-14 22:30:35',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(47,'Pokazuj statystyki artykułu','NEWS_CZY_STAT','1','Czy pokazywać statystyki artykułu ?',5,8,'2009-05-14 23:38:20','2009-05-14 22:31:25',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(48,'Pokazuj nagłowek artykułu - STATYSTYKI','NEWS_CZY_STAT_NAGL','1','Czy pokazywać nagłowek  artykułu - STATYSTYKI ?',5,8,'2009-05-14 23:39:08','2009-05-14 22:32:03',NULL,'tep_cfg_select_option(array(\'1\', \'0\'),'),
(49,'Pokazuj zdjęcia artykułu','NEWS_CZY_FOTO','1','Czy pokazywać zdjęcia ?',5,9,'2009-05-14 23:38:52','2009-05-14 22:32:37','','tep_cfg_select_option(array(\'1\', \'0\'),');

drop table if exists `newsdesk_configuration_group`;
CREATE TABLE `newsdesk_configuration_group` (
  `configuration_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_group_title` varchar(64) NOT NULL,
  `configuration_group_description` varchar(255) NOT NULL,
  `sort_order` int(5) DEFAULT NULL,
  `visible` int(1) DEFAULT '1',
  PRIMARY KEY (`configuration_group_id`),
  UNIQUE KEY `idx_visible_cfg` (`visible`,`configuration_group_id`),
  KEY `idx_visible` (`visible`)
);

insert into `newsdesk_configuration_group` (`configuration_group_id`, `configuration_group_title`, `configuration_group_description`, `sort_order`, `visible`) values (1,'Wygląd listy artykułów','',2,1),
(2,'Opcje aktualności','',1,1),
(3,'Opcje komentarzy','',3,1),
(4,'Opcje ważnych informacji','',4,1),
(5,'Wygląd pojedyńczego artykułu','',5,1);

drop table if exists `newsdesk_description`;
CREATE TABLE `newsdesk_description` (
  `newsdesk_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `newsdesk_article_name` varchar(64) NOT NULL,
  `newsdesk_article_description` text,
  `newsdesk_article_shorttext` text,
  `newsdesk_article_url` varchar(255) DEFAULT NULL,
  `newsdesk_article_url_name` varchar(255) DEFAULT NULL,
  `newsdesk_article_viewed` int(5) DEFAULT '0',
  `newsdesk_image_text` text,
  `newsdesk_image_text_two` text,
  `newsdesk_image_text_three` text,
  PRIMARY KEY (`newsdesk_id`,`language_id`),
  KEY `idx_newsdesk_article_name` (`newsdesk_article_name`)
);

drop table if exists `newsdesk_reviews`;
CREATE TABLE `newsdesk_reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `newsdesk_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `approved` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`reviews_id`)
);

drop table if exists `newsdesk_reviews_description`;
CREATE TABLE `newsdesk_reviews_description` (
  `reviews_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
);

drop table if exists `newsdesk_to_categories`;
CREATE TABLE `newsdesk_to_categories` (
  `newsdesk_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`newsdesk_id`,`categories_id`)
);

drop table if exists `newsletters`;
CREATE TABLE `newsletters` (
  `newsletters_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `module` varchar(255) NOT NULL,
  `date_added` datetime NOT NULL,
  `date_sent` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `locked` int(1) DEFAULT '0',
  PRIMARY KEY (`newsletters_id`)
);

drop table if exists `newsletters_tmp`;
CREATE TABLE `newsletters_tmp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lastname` varchar(40) DEFAULT NULL,
  `firstname` varchar(40) DEFAULT NULL,
  `email` varchar(80) NOT NULL,
  `subs_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
);

drop table if exists `onet_category_map`;
CREATE TABLE `onet_category_map` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_kategorii_sklepu` int(10) unsigned NOT NULL,
  `id_kategorii_pm` int(10) unsigned NOT NULL,
  `sciezka_kategorii` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
);

drop table if exists `optimize_check`;
CREATE TABLE `optimize_check` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `start_date` date NOT NULL,
  PRIMARY KEY (`counter`)
);

drop table if exists `orders`;
CREATE TABLE `orders` (
  `orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_nr` int(11) NOT NULL DEFAULT '0',
  `invoice_date` int(11) NOT NULL DEFAULT '0',
  `invoice_proforma_nr` int(11) NOT NULL DEFAULT '0',
  `invoice_proforma_date` int(11) NOT NULL DEFAULT '0',
  `customers_id` int(11) NOT NULL,
  `customers_name` varchar(256) DEFAULT NULL,
  `customers_company` varchar(256) DEFAULT NULL,
  `customers_nip` varchar(32) DEFAULT NULL,
  `customers_street_address` varchar(64) NOT NULL,
  `customers_suburb` varchar(32) DEFAULT NULL,
  `customers_city` varchar(32) NOT NULL,
  `customers_postcode` varchar(10) NOT NULL,
  `customers_state` varchar(32) DEFAULT NULL,
  `customers_country` varchar(32) NOT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_email_address` varchar(96) NOT NULL,
  `customers_address_format_id` int(5) NOT NULL,
  `customers_dummy_account` tinyint(3) unsigned NOT NULL,
  `delivery_name` varchar(256) DEFAULT NULL,
  `delivery_company` varchar(256) DEFAULT NULL,
  `delivery_nip` varchar(32) DEFAULT NULL,
  `delivery_street_address` varchar(64) NOT NULL,
  `delivery_suburb` varchar(32) DEFAULT NULL,
  `delivery_city` varchar(32) NOT NULL,
  `delivery_postcode` varchar(10) NOT NULL,
  `delivery_state` varchar(32) DEFAULT NULL,
  `delivery_country` varchar(32) NOT NULL,
  `delivery_address_format_id` int(5) NOT NULL,
  `billing_name` varchar(256) DEFAULT NULL,
  `billing_company` varchar(256) DEFAULT NULL,
  `billing_nip` varchar(32) DEFAULT NULL,
  `billing_street_address` varchar(64) NOT NULL,
  `billing_suburb` varchar(32) DEFAULT NULL,
  `billing_city` varchar(32) NOT NULL,
  `billing_postcode` varchar(10) NOT NULL,
  `billing_state` varchar(32) DEFAULT NULL,
  `billing_country` varchar(32) NOT NULL,
  `billing_address_format_id` int(5) NOT NULL,
  `payment_method` varchar(255) NOT NULL,
  `payment_info` text,
  `cc_type` varchar(20) DEFAULT NULL,
  `cc_owner` varchar(64) DEFAULT NULL,
  `cc_number` varchar(32) DEFAULT NULL,
  `cc_expires` varchar(4) DEFAULT NULL,
  `giftwrap` varchar(20) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_purchased` datetime DEFAULT NULL,
  `orders_status` int(5) NOT NULL,
  `orders_date_finished` datetime DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `currency_value` decimal(14,6) DEFAULT NULL,
  `shipping_tax` decimal(7,4) NOT NULL DEFAULT '0.0000',
  `shipping_module` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`orders_id`),
  KEY `idx_date_purchased` (`date_purchased`),
  KEY `idx_orders_status` (`orders_status`),
  KEY `idx_status_orders_cust` (`orders_status`,`orders_id`,`customers_id`)
);

drop table if exists `orders_products`;
CREATE TABLE `orders_products` (
  `orders_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `products_model` varchar(32) DEFAULT NULL,
  `products_pkwiu` varchar(24) NOT NULL DEFAULT '0',
  `products_name` varchar(64) NOT NULL,
  `products_price` decimal(15,4) NOT NULL,
  `final_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_tax` decimal(7,4) NOT NULL,
  `products_quantity` int(6) NOT NULL,
  `products_stock_attributes` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`orders_products_id`),
  KEY `idx_orders_id_prod_id` (`orders_id`,`products_id`),
  KEY `idx_products_id` (`products_id`),
  KEY `idx_orders_id` (`orders_id`)
);

drop table if exists `orders_products_attributes`;
CREATE TABLE `orders_products_attributes` (
  `orders_products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `products_options` varchar(32) NOT NULL,
  `products_options_values` varchar(32) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  PRIMARY KEY (`orders_products_attributes_id`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_orders_id_prod_id` (`orders_id`,`orders_products_id`)
);

drop table if exists `orders_products_download`;
CREATE TABLE `orders_products_download` (
  `orders_products_download_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_products_id` int(11) NOT NULL,
  `orders_products_filename` varchar(255) NOT NULL,
  `download_maxdays` int(2) NOT NULL,
  `download_count` int(2) NOT NULL,
  PRIMARY KEY (`orders_products_download_id`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_orders_products_id` (`orders_products_id`)
);

drop table if exists `orders_status`;
CREATE TABLE `orders_status` (
  `orders_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `orders_status_name` varchar(128) NOT NULL,
  `public_flag` int(11) DEFAULT '1',
  `downloads_flag` int(11) DEFAULT '0',
  PRIMARY KEY (`orders_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`orders_status_name`)
);

insert into `orders_status` (`orders_status_id`, `language_id`, `orders_status_name`, `public_flag`, `downloads_flag`) values (1,1,'Zamówienie otrzymane',1,0),
(1,2,'Order received',1,0),
(1,3,'Auftrag empfangen',1,0),
(1,4,'Полученный заказ',1,0),
(2,1,'Zamówienie przyjęte',1,0),
(2,2,'Order accepted',1,0),
(2,3,'Auftrag angenommen',1,0),
(2,4,'Заказ принял',1,0),
(3,1,'Zamówienie realizowane',1,1),
(3,2,'Order realized',1,1),
(3,3,'Auftrag verwirklichte',1,1),
(3,4,'Заказ осуществил',1,1),
(4,1,'Zamówione towary wysłane',1,1),
(4,2,'Ordered commodities sent',1,1),
(4,3,'Bestellte Gebrauchsgüter gesendet',1,1),
(4,4,'Приказанные товары послали',1,1),
(5,4,'Разрешить Загрузить',1,1),
(5,3,'Lassen Download',1,1),
(5,2,'Allow Download',1,1),
(5,1,'Plik do pobrania',1,1);

drop table if exists `orders_status_history`;
CREATE TABLE `orders_status_history` (
  `orders_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `orders_status_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `customer_notified` int(1) DEFAULT '0',
  `comments` text,
  PRIMARY KEY (`orders_status_history_id`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_orders_id_status_id` (`orders_id`,`orders_status_id`)
);

drop table if exists `orders_text_attributes`;
CREATE TABLE `orders_text_attributes` (
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `products_id` varchar(50) NOT NULL,
  `products_text_attributes_id` int(11) NOT NULL DEFAULT '0',
  `products_text_attributes_text` text NOT NULL,
  PRIMARY KEY (`orders_id`,`products_id`,`products_text_attributes_id`)
);

drop table if exists `orders_total`;
CREATE TABLE `orders_total` (
  `orders_total_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` varchar(255) NOT NULL,
  `value` decimal(15,4) NOT NULL,
  `class` varchar(32) NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`orders_total_id`),
  KEY `idx_class` (`class`),
  KEY `idx_orders_id` (`orders_id`)
);

drop table if exists `pages`;
CREATE TABLE `pages` (
  `pages_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `page_type` char(1) DEFAULT NULL,
  PRIMARY KEY (`pages_id`),
  KEY `idx_sort_order` (`sort_order`),
  KEY `idx_status` (`status`)
);

insert into `pages` (`pages_id`, `sort_order`, `status`, `page_type`) values (5,1,1,'1'),
(2,2,1,'2'),
(3,3,1,'4'),
(7,1,1,'5');

drop table if exists `pages_description`;
CREATE TABLE `pages_description` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pages_id` int(11) DEFAULT NULL,
  `pages_title` varchar(128) NOT NULL,
  `pages_html_text` text,
  `intorext` char(1) DEFAULT NULL,
  `externallink` varchar(255) DEFAULT NULL,
  `link_target` char(1) DEFAULT NULL,
  `language_id` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_language_id` (`language_id`),
  KEY `idx_pages_id` (`pages_id`)
);

insert into `pages_description` (`id`, `pages_id`, `pages_title`, `pages_html_text`, `intorext`, `externallink`, `link_target`, `language_id`) values (17,5,'Regulamin','Regulamin sklepu<br>','0','','0',1),
(5,2,'Kontakt','<p><strong><br>\r\r
</strong></p>','0','','0',1),
(9,3,'Dostawa','<strong>Wysyłka <br>\r\r
</strong>jest realizowana w dwóch wariantach:<br>\r\r
1. Poczta Polska - przedmioty o standardowych wymiarach, paczka do 25 kg.<br>\r\r
2. Dowolnym kurierem -przedmioty nadwymiarowe i bardzo ciężkie.<br>\r\r
Koszty wysyłki pokrywa kupujący. Przy zakupach powyżej 600 zł koszty przesyłki pokrywa sprzedający. (UWAGA dla przesyłek nadwymiarowych wysyłanych kurierem max. kwota rabatu za przesyłkę to 30zł- reszte pokrywa kupujący) <br>\r\r
<br>\r\r
<strong>Zwroty</strong><br>\r\r
zakupionych towarów są przyjmowane tylko pod warunkiem, że nie były używane, posiadają orginalne opakowanie, są dostarczone w komplecie (wraz z dołączonym osprzętem). Pieniądze za zwrócony towar zostaną wysłane na podane konto lub adres w ciągu 7 dni roboczych. Koszty zwrotów ponosi kupujący<br>\r\r
. Reklamacje dotyczące uszkodzeń mechanicznych powstałych podczas transportu bądź rozpatrywane tylko na podstawie protokołu reklamacyjnego spisanego w obecności doręczyciela. Pokrywamy koszty przesyłek wynikłych z błędnej realizacji zamówienia przez nasz sklep. UWAGA: sprawdź zawartość przesyłki w obecności dostarczajšcej jš osoby! Zwroty i reklamacje powinny być adresowane na adres podany w danych kontaktowych sklepu.','0','','0',1),
(25,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',1),
(66,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',2),
(67,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',3),
(68,7,'Witamy w sklepie internetowym','<div style=\"text-align: center;\">Witamy w sklepie internetowym</div>','0','','0',4),
(69,5,'Regulamin','<br>','0','','0',2),
(70,5,'Regulamin','<br>','0','','0',3),
(71,5,'Regulamin','<br>','0','','0',4),
(72,2,'Kontakt','<br>','0','','0',2),
(73,2,'Kontakt','<br>','0','','0',3),
(74,2,'Kontakt','<br>','0','','0',4),
(75,3,'Dostawa','<br>','0','','0',2),
(76,3,'Dostawa','<br>','0','','0',3),
(77,3,'Dostawa','<br>','0','','0',4);

drop table if exists `phesis_comments`;
CREATE TABLE `phesis_comments` (
  `commentid` int(11) NOT NULL AUTO_INCREMENT,
  `pollid` int(11) DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `date` datetime DEFAULT NULL,
  `name` varchar(60) NOT NULL,
  `host_name` varchar(60) DEFAULT NULL,
  `comment` text NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`commentid`)
);

drop table if exists `phesis_poll_check`;
CREATE TABLE `phesis_poll_check` (
  `ip` varchar(20) NOT NULL,
  `time` varchar(14) NOT NULL,
  `pollID` int(10) NOT NULL DEFAULT '0'
);

drop table if exists `phesis_poll_config`;
CREATE TABLE `phesis_poll_config` (
  `configuration_id` int(5) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(64) NOT NULL,
  `configuration_key` varchar(64) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`configuration_id`)
);

insert into `phesis_poll_config` (`configuration_id`, `configuration_title`, `configuration_key`, `configuration_value`, `configuration_description`, `last_modified`, `date_added`) values (1,'Sposób wyświetlania ankiet w sklepie','DISPLAY_POLL_HOW','2','Określa sposób wyświetlania ankiet w sklepie.\r\r
\r\r
0 = losowo\r\r
1 = najnowsze\r\r
2 = najbardziej popularne\r\r
3 = po konkretnym numerze ID','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(2,'Id ankiety','DISPLAY_POLL_ID','','Jeżeli chcesz, aby wyświetlała się tylko jedna sonda wprowadź tutaj jej nr ID.','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(3,'Zezwalaj na komentarze','SHOW_POLL_COMMENTS','1','Włącz lub Wyłącz komentarze.\r\r
\r\r
0 = Wyłączone\r\r
1 = Włączone','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(4,'Informacja zamiast ankiety w boxie','SHOW_NOPOLL','0','Jeżeli nie ma ankiety do wyświetlania, czy wyświetlać komunikat o braku ankiet w danej kategorii ? Komunikat jest wyświetlany w boxie Ankieta zamiast sondy.\r\r
\r\r
0 = Nie pokazywać informacjie\r\r
1 = Pokazywać informacje','2009-02-27 18:22:30','2009-02-27 18:22:30'),
(5,'Głosowanie więcej niż jeden raz przez klienta','POLL_SPAM','0','Pozwól klientom na głosowanie więcej niż raz.\r\r
\r\r
0 = Nie (zalecane)\r\r
1 = Tak (przydatne do testowania)','2009-07-14 10:25:41','2009-02-27 18:22:30');

drop table if exists `phesis_poll_data`;
CREATE TABLE `phesis_poll_data` (
  `pollID` int(11) NOT NULL DEFAULT '0',
  `optionText` varchar(255) NOT NULL,
  `optionCount` int(11) NOT NULL DEFAULT '0',
  `voteID` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  KEY `idx_pollID` (`pollID`,`voteID`)
);

drop table if exists `phesis_poll_desc`;
CREATE TABLE `phesis_poll_desc` (
  `pollID` int(11) NOT NULL AUTO_INCREMENT,
  `timeStamp` datetime DEFAULT NULL,
  `voters` mediumint(9) NOT NULL DEFAULT '0',
  `poll_type` char(1) NOT NULL DEFAULT '0',
  `poll_open` char(1) NOT NULL DEFAULT '0',
  `catID` int(11) NOT NULL DEFAULT '0',
  `prodID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pollID`)
);

drop table if exists `porownywarki`;
CREATE TABLE `porownywarki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nazwa` varchar(30) NOT NULL,
  `kategorie` text,
  PRIMARY KEY (`id`)
);

insert into `porownywarki` (`id`, `nazwa`, `kategorie`) values (1,'okazje',''),
(2,'skapiec',''),
(3,'ceneo',''),
(4,'nokaut',''),
(5,'sklepy24',''),
(6,'cenus',''),
(7,'radar',''),
(8,'oferciak',''),
(9,'torturacen',''),
(10,'totu',''),
(11,'kupujemy',''),
(12,'smartbay',''),
(13,'starcode_xml',''),
(14,'cenohit',''),
(15,'pkt',''),
(16,'taniopl','');

drop table if exists `products`;
CREATE TABLE `products` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort_order` int(5) NOT NULL,
  `products_quantity` int(6) NOT NULL,
  `products_model` varchar(30) DEFAULT NULL,
  `products_pkwiu` varchar(24) NOT NULL DEFAULT '0',
  `products_image` varchar(150) DEFAULT NULL,
  `products_image_pop` varchar(150) DEFAULT NULL,
  `products_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `products_retail_price` decimal(15,4) DEFAULT NULL,
  `products_date_added` datetime NOT NULL,
  `products_last_modified` datetime DEFAULT NULL,
  `products_date_available` datetime DEFAULT NULL,
  `products_weight` decimal(7,4) NOT NULL,
  `products_status` tinyint(1) NOT NULL,
  `products_tax_class_id` int(11) NOT NULL,
  `products_maxorder` int(4) DEFAULT NULL,
  `manufacturers_id` int(11) DEFAULT NULL,
  `products_ordered` int(11) NOT NULL DEFAULT '0',
  `products_availability_id` varchar(255) DEFAULT NULL,
  `products_jm_id` varchar(32) DEFAULT NULL,
  `products_adminnotes` varchar(255) DEFAULT NULL,
  `emo_source` int(11) DEFAULT '0',
  `emo_pn` varchar(65) DEFAULT NULL,
  `emo_paczka` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`products_id`),
  KEY `idx_manufacturers_id` (`manufacturers_id`),
  KEY `idx_products_date_added` (`products_date_added`),
  KEY `idx_products_date_available` (`products_date_available`),
  KEY `idx_products_model` (`products_model`),
  KEY `idx_products_ordered` (`products_ordered`),
  KEY `idx_products_status` (`products_status`)
);

drop table if exists `products_attributes`;
CREATE TABLE `products_attributes` (
  `products_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `options_id` int(11) NOT NULL,
  `options_values_id` int(11) NOT NULL,
  `options_values_price` decimal(15,4) NOT NULL,
  `price_prefix` char(1) NOT NULL,
  `products_options_sort_order` int(6) unsigned NOT NULL DEFAULT '0',
  `options_values_weight` decimal(6,3) DEFAULT '0.000',
  PRIMARY KEY (`products_attributes_id`),
  KEY `idx_id_options_id_values` (`products_id`,`options_id`,`options_values_id`),
  KEY `idx_opt_sort_order` (`products_options_sort_order`),
  KEY `idx_products_id` (`products_id`)
);

drop table if exists `products_attributes_download`;
CREATE TABLE `products_attributes_download` (
  `products_attributes_id` int(11) NOT NULL,
  `products_attributes_filename` varchar(255) NOT NULL,
  `products_attributes_maxdays` int(2) DEFAULT '0',
  `products_attributes_maxcount` int(2) DEFAULT '0',
  PRIMARY KEY (`products_attributes_id`)
);

drop table if exists `products_availability`;
CREATE TABLE `products_availability` (
  `products_availability_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_availability_name` varchar(255) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`products_availability_id`,`language_id`),
  KEY `idx_products_availability_name` (`products_availability_name`)
);

insert into `products_availability` (`products_availability_id`, `language_id`, `products_availability_name`, `date_added`, `last_modified`) values (1,1,'Dostępny',NULL,NULL),
(1,2,'Available',NULL,NULL),
(1,3,'Vorhanden',NULL,NULL),
(1,4,'Имеющеся',NULL,NULL),
(2,1,'Dostępność - 3 dni',NULL,NULL),
(2,2,'Availability - 3 days',NULL,NULL),
(2,3,'Verwendbarkeit - 3 Tage',NULL,NULL),
(2,4,'Наличие - 3 дня',NULL,NULL),
(3,1,'Na zamówienie',NULL,NULL),
(3,2,'On order',NULL,NULL),
(3,3,'Auf Auftrag',NULL,NULL),
(3,4,'На заказе',NULL,NULL);

drop table if exists `products_description`;
CREATE TABLE `products_description` (
  `products_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_name` varchar(150) NOT NULL,
  `products_description` text,
  `products_short_description` text,
  `products_url` varchar(255) DEFAULT NULL,
  `products_viewed` int(5) DEFAULT '0',
  `products_head_title_tag` varchar(80) DEFAULT NULL,
  `products_head_desc_tag` longtext,
  `products_head_keywords_tag` longtext,
  `products_seo_url` varchar(100) NOT NULL,
  PRIMARY KEY (`products_id`,`language_id`),
  KEY `idx_products_name` (`products_name`)
);

drop table if exists `products_extra_fields`;
CREATE TABLE `products_extra_fields` (
  `products_extra_fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_extra_fields_name` varchar(64) NOT NULL,
  `products_extra_fields_order` int(3) NOT NULL,
  `products_extra_fields_status` tinyint(1) NOT NULL,
  `languages_id` int(11) NOT NULL,
  PRIMARY KEY (`products_extra_fields_id`)
);

drop table if exists `products_jm`;
CREATE TABLE `products_jm` (
  `products_jm_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_jm_name` varchar(255) NOT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`products_jm_id`,`language_id`),
  KEY `idx_products_jm_name` (`products_jm_name`)
);

insert into `products_jm` (`products_jm_id`, `language_id`, `products_jm_name`, `date_added`, `last_modified`) values (1,1,'kg',NULL,NULL),
(1,2,'KG',NULL,NULL),
(1,3,'KG',NULL,NULL),
(1,4,'KG',NULL,NULL),
(2,1,'litr',NULL,NULL),
(2,2,'litr',NULL,NULL),
(2,3,'litr',NULL,NULL),
(2,4,'litr',NULL,NULL),
(3,4,'mb',NULL,NULL),
(3,3,'mb',NULL,NULL),
(3,2,'mb',NULL,NULL),
(3,1,'mb',NULL,NULL);

drop table if exists `products_notifications`;
CREATE TABLE `products_notifications` (
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`products_id`,`customers_id`),
  KEY `idx_date_added` (`date_added`)
);

drop table if exists `products_options`;
CREATE TABLE `products_options` (
  `products_options_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_name` varchar(32) NOT NULL,
  `products_options_track_stock` tinyint(4) NOT NULL DEFAULT '0',
  `products_options_sort_order` int(6) unsigned NOT NULL DEFAULT '0',
  `products_options_images_enabled` varchar(5) NOT NULL DEFAULT 'false',
  PRIMARY KEY (`products_options_id`,`language_id`),
  KEY `idx_language_id` (`language_id`),
  KEY `idx_products_options_name` (`products_options_name`),
  KEY `idx_products_options_sort_order` (`products_options_sort_order`)
);

drop table if exists `products_options_products`;
CREATE TABLE `products_options_products` (
  `pop_id` int(11) NOT NULL AUTO_INCREMENT,
  `pop_products_id_master` int(11) NOT NULL DEFAULT '0',
  `pop_products_id_slave` int(11) NOT NULL DEFAULT '0',
  `pop_order_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pop_id`),
  KEY `pop_products_id_master` (`pop_products_id_master`)
);

drop table if exists `products_options_values`;
CREATE TABLE `products_options_values` (
  `products_options_values_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `products_options_values_name` varchar(64) NOT NULL,
  `products_options_values_thumbnail` varchar(60) NOT NULL,
  PRIMARY KEY (`products_options_values_id`,`language_id`),
  KEY `idx_products_options_values_name` (`products_options_values_name`)
);

drop table if exists `products_options_values_to_products_options`;
CREATE TABLE `products_options_values_to_products_options` (
  `products_options_values_to_products_options_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_options_id` int(11) NOT NULL,
  `products_options_values_id` int(11) NOT NULL,
  `products_options_values_sort_order` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_options_values_to_products_options_id`),
  KEY `idx_products_options_id` (`products_options_id`),
  KEY `idx_products_options_values_id` (`products_options_values_id`)
);

drop table if exists `products_stock`;
CREATE TABLE `products_stock` (
  `products_stock_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_stock_attributes` varchar(255) NOT NULL,
  `products_stock_quantity` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_stock_id`),
  UNIQUE KEY `idx_products_stock_attributes` (`products_id`,`products_stock_attributes`)
);

drop table if exists `products_text_attributes`;
CREATE TABLE `products_text_attributes` (
  `products_text_attributes_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_text_attributes_name` varchar(255) NOT NULL,
  PRIMARY KEY (`products_text_attributes_id`)
);

drop table if exists `products_text_attributes_enabled`;
CREATE TABLE `products_text_attributes_enabled` (
  `products_id` int(11) NOT NULL DEFAULT '0',
  `products_text_attributes_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`products_id`,`products_text_attributes_id`)
);

drop table if exists `products_to_categories`;
CREATE TABLE `products_to_categories` (
  `products_id` int(11) NOT NULL,
  `categories_id` int(11) NOT NULL,
  PRIMARY KEY (`products_id`,`categories_id`),
  UNIQUE KEY `idx_categories_id` (`categories_id`,`products_id`)
);

drop table if exists `products_to_products_extra_fields`;
CREATE TABLE `products_to_products_extra_fields` (
  `products_id` int(11) NOT NULL,
  `products_extra_fields_id` int(11) NOT NULL,
  `products_extra_fields_value` text,
  `sk` varchar(64) NOT NULL,
  PRIMARY KEY (`products_id`,`products_extra_fields_id`)
);

drop table if exists `recently_view`;
CREATE TABLE `recently_view` (
  `rec_v_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `ses_id` int(11) DEFAULT NULL,
  `ses_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`rec_v_id`)
);

drop table if exists `reviews`;
CREATE TABLE `reviews` (
  `reviews_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `customers_id` int(11) DEFAULT NULL,
  `customers_name` varchar(64) NOT NULL,
  `reviews_rating` int(1) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `reviews_read` int(5) NOT NULL DEFAULT '0',
  `approved` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`reviews_id`),
  KEY `idx_approved` (`approved`),
  KEY `idx_customers_id` (`customers_id`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_products_id` (`products_id`)
);

drop table if exists `reviews_description`;
CREATE TABLE `reviews_description` (
  `reviews_id` int(11) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `reviews_text` text NOT NULL,
  PRIMARY KEY (`reviews_id`,`languages_id`)
);

drop table if exists `sessions`;
CREATE TABLE `sessions` (
  `sesskey` varchar(32) NOT NULL,
  `expiry` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`sesskey`)
);

drop table if exists `ship2pay`;
CREATE TABLE `ship2pay` (
  `s2p_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipment` varchar(100) NOT NULL,
  `payments_allowed` varchar(250) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`s2p_id`),
  KEY `idx_status` (`status`)
);

insert into `ship2pay` (`s2p_id`, `shipment`, `payments_allowed`, `status`) values (8,'odbiorosobisty','gotowkaprzyodbiorzeosobistym.php',1),
(7,'kurier','plbanktransfer.php',1),
(6,'kurierpobranie','pobraniekurier.php',1);

drop table if exists `specials`;
CREATE TABLE `specials` (
  `specials_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL,
  `specials_new_products_price` decimal(15,4) NOT NULL,
  `specials_date_added` datetime DEFAULT NULL,
  `specials_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `customers_groups_id` int(11) NOT NULL DEFAULT '0',
  `customers_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`specials_id`),
  KEY `idx_expires_date` (`expires_date`),
  KEY `idx_products_id` (`products_id`),
  KEY `idx_specials_date_added` (`specials_date_added`),
  KEY `idx_status` (`status`)
);

drop table if exists `star_product`;
CREATE TABLE `star_product` (
  `star_product_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `star_product_date_added` datetime DEFAULT NULL,
  `star_product_last_modified` datetime DEFAULT NULL,
  `expires_date` datetime DEFAULT NULL,
  `date_status_change` datetime DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`star_product_id`),
  KEY `idx_products_id` (`products_id`),
  KEY `idx_status` (`status`)
);

drop table if exists `subscribers`;
CREATE TABLE `subscribers` (
  `subscribers_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `subscribers_email_address` varchar(80) NOT NULL,
  `subscribers_firstname` varchar(40) DEFAULT NULL,
  `subscribers_lastname` varchar(40) DEFAULT NULL,
  `language` varchar(30) DEFAULT NULL,
  `subscribers_gender` char(1) DEFAULT NULL,
  `subscribers_email_type` varchar(5) DEFAULT NULL,
  `entry_date` date DEFAULT NULL,
  `undeliverable_count` mediumint(11) DEFAULT '0',
  `mail_details_customers_id` int(5) DEFAULT '0',
  `list_number` int(5) DEFAULT '0',
  `source_import` varchar(70) DEFAULT NULL,
  `date_account_created` datetime DEFAULT NULL,
  `date_account_last_modified` datetime DEFAULT NULL,
  `customers_newsletter` int(4) DEFAULT NULL,
  `subscribers_blacklist` int(2) DEFAULT '0',
  `subscription_date` datetime DEFAULT NULL,
  `status_sent1` int(2) DEFAULT '0',
  `host_name` varchar(25) DEFAULT NULL,
  `hardiness_zone` char(3) DEFAULT NULL,
  PRIMARY KEY (`subscribers_id`),
  KEY `idx_list_number` (`list_number`)
);

drop table if exists `swistak_categories`;
CREATE TABLE `swistak_categories` (
  `node` varchar(32) NOT NULL,
  `categories_id` int(11) NOT NULL,
  `childs` varchar(128) NOT NULL,
  `categories_name` varchar(128) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ids` varchar(128) NOT NULL,
  KEY `categories_id` (`categories_id`)
);

drop table if exists `swistak_export_import`;
CREATE TABLE `swistak_export_import` (
  `id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  `last_exported` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_imported` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_read` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
);

insert into `swistak_export_import` (`id`, `last_exported`, `last_imported`, `last_read`) values (1,'0000-00-00 00:00:00','2009-11-30 22:36:00','2009-11-30 22:37:25');

drop table if exists `swistak_xml_categories`;
CREATE TABLE `swistak_xml_categories` (
  `categories_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `categories_name` varchar(128) NOT NULL,
  `level` int(11) NOT NULL,
  `ids` varchar(128) NOT NULL,
  PRIMARY KEY (`categories_id`)
);

drop table if exists `tax_class`;
CREATE TABLE `tax_class` (
  `tax_class_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_class_title` varchar(32) NOT NULL,
  `tax_class_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_class_id`)
);

insert into `tax_class` (`tax_class_id`, `tax_class_title`, `tax_class_description`, `last_modified`, `date_added`) values (1,'Vat_0','0% podatek VAT',NULL,'2006-05-27 18:50:09'),
(2,'Vat_7','7% podatek VAT',NULL,'2006-05-27 18:50:24'),
(3,'Vat_22','22% podatek VAT',NULL,'2006-05-27 18:50:36'),
(4,'Vat_23','',NULL,'2017-09-12 12:20:08');

drop table if exists `tax_rates`;
CREATE TABLE `tax_rates` (
  `tax_rates_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_zone_id` int(11) NOT NULL,
  `tax_class_id` int(11) NOT NULL,
  `tax_priority` int(5) DEFAULT '1',
  `tax_rate` decimal(7,4) NOT NULL,
  `tax_description` varchar(255) NOT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`tax_rates_id`),
  KEY `idx_tax_class_id` (`tax_class_id`),
  KEY `idx_tax_zone_id_zen` (`tax_zone_id`)
);

insert into `tax_rates` (`tax_rates_id`, `tax_zone_id`, `tax_class_id`, `tax_priority`, `tax_rate`, `tax_description`, `last_modified`, `date_added`) values (1,1,3,3,'22.0000','VAT-22','2017-09-12 12:21:49','2006-05-27 18:51:13'),
(2,1,2,1,'7.0000','VAT-7',NULL,'2006-05-27 18:51:46'),
(3,1,1,2,'0.0000','VAT-0',NULL,'2006-05-27 18:51:59'),
(5,1,4,0,'23.0000','VAT-23','2017-09-12 12:21:35','2017-09-12 12:20:50');

drop table if exists `templates`;
CREATE TABLE `templates` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `rodzaj` varchar(5) DEFAULT NULL,
  `tytul` varchar(80) DEFAULT NULL,
  `tresc` text,
  PRIMARY KEY (`id`)
);

insert into `templates` (`id`, `rodzaj`, `tytul`, `tresc`) values (10,'OSC','templates','OUJ3PUR5Okd5OEd2PEB2NUV1OUF3Okd1Okl5NkhyOUZ5NUR6O{J3Okd3O{Z2OkV4PEZ2OkZ3Okd2NEV1PEN4OkhzPEZ4NUZ5OkZ4NkR6OUB3PUdxOUJ5OEh1Okl5N{V4OUV5OEV3O{N5N{h2O{B5NUh3OkZ2NEh{OUd2Nkh{OUV3O{dzOUR2N{h2OUN5N{hxOUR4NkhyPER2OUd4PEJ3PEd{PEJ5OUhzO{N5OEV1O{V5NkhxOEh3PEd5PEF5NEdzO{B5NUhxO{V5NEdxO{J2Nkh{OEh3Okd2Okl4O{V4PER5NEdxOkl5NkV{O{N5NkdzOUZ5OEhyOUd4O{VzOUN4NUZ6PEF5OEVzOUJ4NUVyOUV3O{V{Okl3PEV1Okl4OkZ5O{F5NUdyO{F1PEh3OkZ2N{dzOUF5NkV2OUV2OEdxOUV5OUdyPEN3OkZ5OUZ2OEZ4Okl4O{Z4O{J5NkhzPER2O{VyPEN3PEh1OEh3PEZ4O{B4O{d3O{h5OEd2OkZ2O{d2OEh5OEd5PEV2N{R6OUN5N{Z4O{V5N{d4OkZ5OkR6OUV2Okd1PER3O{V2OUR5OUdyOkl2OkV{OUZ5OEhyOkd2NUd1OkZ2N{dzPEJ2OER6Okh5N{d{OUZ2OkZ4OUJ1PEh{OUd3PEV2OUN4OkR6O{h2OUd3O{N4NUR5OUB3Okd2PER4PEV{Okl5N{Z4Okh3PER5OUR2OUdyPEN5OkR6PEN2OUV1O{N3PUR6PEZ2OkVxO{Z2Nkd1OEh4NEhxOUV2NUhyOkh1PUV3PEV3PUh3OEh2O{Z6O{R2O{V{PEB2Okh2OUZ4OkhyOUR2OUVzO{J5OUV{OUJ1PEZ5PEV3OkV{OUF3O{d2OUZ5Okd3Okh4OEdyPEZ2OER6PEZ2N{VyO{N5N{Z4PEZ4PEhzO{J5N{dyO{Z3O{d3OUF4OkdxOkl5NUd2OUd1PUdzO{J4NEh1PEV2N{R5PEN5NkdyPER5Okd{O{d5NkV{Okd3O{dyO{B2OEV4PEV3PUV2OUN4PEZ5OUN3PEV4O{Z4Nkd3O{V2Okh3O{h5NEZ4OEh4OEV4OUB2O{VxOkd5OEd4Okh2OEd1O{N5NUdzO{d3PEV{OEh5OUV2O{d3OkdzOUV4OUhzO{F1PUhzO{N3PUh{O{N5NEd4OEl5OkV3O{J4PEZ3O{N4OUd3PEJ5N{dzPEZ2NEZ3OEh3OkdzPEB5OEd2O{F5NEV4O{B5NUZ5Okd2NUZ5O{V5N{V{OUB2OEd3O{F5NUR6O{F5NUd5PEN2OUd{O{F4O{d2PEJ2OUh{OUN2NEh2Okd5OUd2OEh4OEhzOUB5NEdyPER3Okd5PEJ1PUh3OUN5Nkh2OEh2OEd1PEJ5OEhzPEB5NEZ4PEJ1PUh3PER2OEd4O{B5NkVxPEN2OEd5OEl2NUhzPEN5OUV{O{R4NEZ4O{d2OUh{O{J3PEh3PER1PUdzO{B2Okh3O{N4OUhxOkd5NEd{PEB3OkhzOkl2NUhzOkh2O{dxOkZ2OUZ5O{d2Nkh1Okl2Nkd5O{J5Okd2O{h3O{R6OUR5OkV{OUR3OkVxO{F4NUZ4OUJ4NUV1OUN4NUZ6O{V5NEh2OkZ4O{V4PEB2OEVzOUF4NUd5PEJ3PEZ4O{N2NkhzPEN3PUV4OUZ2O{h3OkZ4O{hyPER5Nkh3OEl2NkhzPEB5NEhyO{N5OUh3OUN4PEhyOUF2O{V2O{J4NUhyOUJ2OEV4Okl2OkV3O{h4NEd4O{h3O{h3Okd5NUVyO{N4OEdxOUF3OkV4OUZ3Okh{PER2N{V3PER4Nkd5O{J5NEd2OUZ4N{VzOUF5Okd5OEh4OUdxO{B2NUZ6OkZ2NER6OUV5OEZ4OUV5OUV4PEV2Okh1OUZ2O{V2O{d2O{Z6Okh3O{Z4PEB4N{dxO{d2OkV3O{h5OUZ6O{R3O{V3O{N5N{d5Okd2NkV{Okl3PEd5O{d5NUZ5OUV2OkZ5PER5N{hxOEh5N{dxO{Z4PEhyO{Z5N{Z5Okh5OkV{PEJ2OEh3PEB5NEV1PEB5NUZ6PEN2NUdyOUV5OUd3OkZ4OkV1OUN5NkdxOkd2NEhzO{J4OUh3OUR4OEV3O{d3PEV1PEN2OEZ4O{d2NEh3OUJ3O{Z4PEZ3O{dzO{B3OkhxOUF2OUZ4O{V2N{V3OUR4O{V2O{B2NkV3O{Z2OEd2Okd3PUV2OkZ1PEV{OEh3O{V1PEF2OkVxO{R4O{d5OUR5OUVyPEV2NUdxO{h2OEV1PEZ5NEVxPEJ3Okd2PEF5NER6OUR1PEd3OEh4NUd1OkZ5OkVzOUR4O{h{Okl4PEh3OUF4Okd5O{d4OUhzPEN2NEV2PEN3OkZ5PEF4NEVzOkl3PUhzO{B2OEZ5O{d4OUhyPEB3OkhzPER5NkR6Okh4N{d3Okh5N{hzPER5NkV2O{F2OUhzOkZ4NUh3PEJ2N{d3O{J3O{h2OUd5NkdxOEh2N{h3OUB2N{h2O{J2N{hyOUB2O{d4OEl5N{hzOEh2O{hyPEV1PEd3O{F2N{VxPER2NUV4Okh4NUV3PEZ2NUVyOkh2N{R5OUR5N{h2OUR5N{VyO{R4Nkd1PEB4NUVxOkh4OUR5OUB3PUZ4OUF5N{d4OUF2N{Z4O{h2NUVzOUZ2OEV1OUF5Nkh3OEh3O{VxOEl1PUd2OUV2OEV1PEN3O{h{O{d5NUZ3O{J5NEd5O{F5N{d1O{d5Nkd4O{B4OkR5Okd5NkhxPEN5NER6OUN4NUdzO{B4O{hyO{J4Nkh2OUN3PEh2O{V2Nkd4OUB2NEVxOUB3Okd2OUR3O{d4OUZ2OUh2Okd2NUhxPEV5OER6PEF2NUhyOUJ5OUdzO{d1PUh{OUd3PEdyPEF2OEh1OUF2Nkd2OUZ4OEZ5O{h4NUd{OEl4NUZ6OUN2OEV{O{Z2Okd3Okd4OkV4PEV2OkZ6O{J3PUV2Okl2NEZ3PEF4OEhzOUB2OUZ5OUZ2N{hyOUN4OEZ4PEF3O{h2O{J2NUV4O{J4PEZ3PEB4NUhyOEl1PUVxO{J5OEh3Okd3PUVxOUN2O{d{O{N2NUd2PEJ4OEd5OUd2OkhyPEN4PEd5O{h5NUdyPEZ4OkZ4Okh2OUV{OUR5OkdzOUV4PEZ4Okh2NEV3PEF5OUd1OUd2NEZ3Okl5NUVxOkZ4NkV2PER4NEVxPEN2OEdxOkh4Nkd3O{J3O{V2PEV3O{V4OEl2NEh1O{h2Okd3OUR4O{d5PEN3PEd2PEB2OEd2PEV4NEVzOUB2NUhyO{R4NEdyO{R5Okd4PEV2NUd{PEB3PEh{O{B2O{V{OUJ4OEh3OUJ4PEd4OkZ5OEV3Okd2NkZ5OUV2NEV2PEN2OkR6Okd2O{dyOkZ3PEdzO{N5OUVxPER4N{d1O{N2OkdzOUV4OUV4OUV5OEhzPEJ4OUh2OUR2OUh1O{d2OkR5O{R5NkhyOUJ5OkVxO{V5Nkh{Okd5N{Z6OUN5NEd4Okl5Nkd{OUN4NUd2OUN2N{dyPER4NkVyOUF3PUVxOUN5NkhzO{d2NUd4OUZ4NkVyPEN2NEVzO{N1PEV4OUd3O{h2O{V4OEV2Okh5OEVzOkh5N{R6PEJ4N{d4O{F2Nkd2OUB4OEh2PEV4OUdyO{Z2NUd{PEF4OUVzOUZ2O{h{O{R4NkR5OEh2OER6OEl5NUV{PEZ4O{hzPER4OkZ6PER5OUd3OUV2OEd3O{R2OUh{O{V3OkZ5OUN2OUh1OUR2N{d3PEF5OUVzOEl3Okd5OUR5NkVxPER4N{VzO{Z5OUd4OUJ2O{d5OUN2OkV3PEN5NEZ5O{F4NkZ5OUV2Okd1OUN4OUhxOkd2O{Z5Okh5OkV3OkZ4N{Z3OkZ5N{d4OUZ5N{h{O{V5NUh{O{h4OkZ4Okd1PER5O{N3OkVxOEh5OEh{O{F4NEZ4O{F2O{VzOkh3PEZ5OUJ5OUdxO{F2NkdyOUF4NUd3O{h2OkhxOUF3PEd4O{F2OUdxO{Z4NEZ6OUF2Okh{PEN5OEZ6Okl4N{Z4PER3OkZ4PEB2O{d3OUZ2O{R6O{V5NEV1O{d2O{h1PEZ4PEV2PEJ5OEZ4PEB5OUhyO{h2NkZ3OUd2NEVxOUB5N{dxPEF3OkV{OUR2NEZ6PEV1PEd3OUV4NkdyOUB4PEhxO{B5NUVzOUR3PUd{Okl3PEd{PEV2Nkd1Okh2O{h2OUZ4O{V{O{Z3PEhxO{V5OkdxOEl4N{d5PEB3O{Z4PEZ2NUh1PEV2N{Z5OUV2OkR5O{J3PUd1O{Z4PEZ6O{d5NkdzOEh3PEZ4OUR2NUZ6O{N4NkVxOkd4OUdzO{R2OUV2PEZ3O{h2PER2NkR6PEJ2O{dzO{Z2N{V2Okl2N{V4O{B1PEZ3OUN3PUh{OUF5NEh{O{F5NkR5O{J2N{h{PEZ2OER6OUV5NUR5O{h2OUh2PEV3PEh3OUZ4NkR6O{V2NkhyOkd4PEhyOUV3PEhyO{Z5N{h3OEh4NkV{OEh5NkdzPER1PEVzOUR5NUh1O{B5OUV4PEJ5OUV2O{F2NkVzO{F5Nkd1PEJ3OkVxO{F2OUd5O{N1PEhzOUd4Nkd5O{J1PUV3PEJ5NEdyO{Z5OEZ6PEB4O{VzO{Z2NEV1OUJ3OkhxO{N1PUd1Okh2OkdxO{d3O{Z3O{N2NEh1O{N1PEh2OEl4O{h{OUB1PEd{PEF2NUV{O{B5OkZ5O{B4OEd3PEV4NkZ4O{Z4NEZ3O{F5Okd{O{J3PUR5O{Z3PER5OUJ3O{d1O{F5NEVyOkd2N{V2O{B4NEh2OEl4Nkd4OUB3PEd{OUR4NUdyO{Z5NUdxOEh3PUd1OUd3OkV4Okl2NkdxOUN3O{Z4OUV5Nkd2O{B4N{dzOUZ4NEV3OEh4NUh{OEh5OEd5O{d5OEh2OUN2Nkd1OEl4NUV{O{J4OkZ3OUd4O{R6OEh4N{d{OUZ2NEdxPEB2O{h3O{d4PEV1OUR4PEdyPEV5NUV4OUN5OEZ5O{F4O{Z3PEZ4PEd1OEl5NEdzO{B2OkdyPEJ5NEhxOUB2OEdxOUJ4NkV4PEB5NUd5PEZ2OER6PEB5OEZ3O{N2N{d1Okh3OkV4OEl4NkhyOUF3PUVyO{J2OUhyO{F4OUd2O{V2NUR5O{V5OkV4OUB5NkV3PEB4NEV3OUV4Okh2PEF4O{d1OUB4NkR6Okd2Okh3OUB2OkdyPEJ4NUVzO{J3O{VzOUV4N{d2OUd2NEVxPEF2OUh1O{V4OUV3OUV3O{Z3OUR4OkdyOUZ5NEd5PEF1PUZ6OEh2OEh3PEN2O{VzOEh5OkV3O{F4NEd4Okd5NEV4PEV5OEh{PEN3OkR5OUN3PEd5O{V4OUh1OUN4OUR6OUd4NEV3O{R3Okh3OEh3PUdyPEN2N{V{PEN4NUV1OUR1PUR5PEB5NEd3PEF2O{d3OkZ4OkdxPEF3PEV4O{h4OUhyOUV2NER6PEN2NUV2O{B2OEdxO{R4NkV{PEZ5OEV4PEZ5NUV{Okh1PEh2OUN2OEhyO{V5N{d4O{B4NEZ5OUZ5NkR6Okh5NkV4O{V1PUV1PEF5NEh1O{R5OkdyO{F4NEVyO{R3PUd5PEN2N{dzO{B2N{V3OUF5OkZ4Okd4N{d1O{h2OEV4O{d4OEV{Okd4Okh1PEF2NUd5O{Z4PEd2OkZ5NEdxOUZ5NEh2OUB5NUZ6Okd4Okh1OUZ5Nkd1O{Z4OkV{Okl3PEh2PEF3PUV2OUJ5OEdzPEJ2OEV2OEh4OUd1PEZ1PUh3O{J5N{R5O{V2NUV{OUB4N{V3OUN5OEd1PEB4NUZ3OEl2OEdzOkl5OkZ3PEB5OkZ6O{h1PEh3O{J5N{Z5OkZ4Nkh3O{d4OkV4O{F5NUh{OUF3OkZ5PER3PEV2O{d4OUV1OUN2NkVyO{R5OEV1Okl4N{d3OEh1PEh2PEN3O{h3O{Z4NEVxOEl5N{d{PEZ4O{V1O{h2Nkd1PEB5NEZ6OkZ2Okh{OUZ4NUVyO{F4NUV4O{R4OEV{O{h2OUd{PER4Okd3O{d3OkhxPEZ4O{Z4PER2N{h{PEB3O{d3O{V1PUZ4OUR2OkV3O{N2NkhzOEh2N{dyOUZ4N{dyOkl3OkV3Okh4NkV3OUF2OUh2OUR5OkVzO{Z2NEh2O{F5NUd{OUR2Nkd3O{d2N{d5OEl5N{Z4PEF5OUd2PEN3OkVzOkl4NkdzPEV5OEhxO{h5NUhxPEF2NUZ4O{R3OkR5Okl2OUV2O{R3OkdzO{R2OUdyO{R4OEVyOUZ1PUd3O{F4PEV3OEh1PEV1OUV5Okd1OUR4OkVzPEB2OkV1PER2OEd2O{N2NkVyOUV3O{h1PEF5NkZ4OUB2NUZ6PEF4O{d5PEN2NkZ3OUR3O{V3Okd4NUdxO{V3O{VzOkh4NUd4PEF1PUd2O{R3Okh3O{R2NEVxOEl4NUVxPEJ2N{V4PEV4O{h{O{d4N{hxOUB3O{Z3OUJ2OkV4OUJ2OUVxO{J1PUVyO{Z4PEh1PER4OUh{PEF1PUhyO{d4OEV3PEB5NkZ4OkZ4PEd3O{V2NEV4PEF5NkZ6PEV1PUhyOkZ2O{V2PEV2NUdxOUR2NUdzOUJ5N{Z5O{d3PEV3Okd5NEh2OUB3O{d4OUN4Okd1OEl5NEh3OUR4NEdyOUJ5OkhzO{d4Okd3PEF5Nkd5PEJ5OEV1O{J4NkVyO{N5OEV4O{R5OkR6PEN5NEdxO{d4NEd5O{h2OEZ6OUV4OEh1Okd3O{R5OUJ2O{V2OUB4OEdxPEV2NUh2O{N2OEd1OUR4NEdyPEJ1PEV3O{J2O{VyPEJ2NkV3OUF2OUd3O{N5NEh3OUd2N{h3PEF4O{hzO{J4OER6O{R3O{Z6OkZ4NkV2OUR2NUV4OEl4N{Z3Okd2OUVyOUZ1PUd5PER2N{Z6PEZ5NUV2O{J5N{h{O{J4NUV1O{V4NUh2OUR5N{hzPEZ5OkhxOkh4OEVyO{d4Nkd1Okh5OEZ5PEZ2NEZ6Okd5NkV2OUJ5OEhyO{B5NEZ5OEl4NkdzO{Z2N{R6OUN3PEV4O{h5OEZ6PEF5OEZ5PEB2NEh2O{N5OUVzOUF4NUh2OUF2OEZ4OUd4OEhxOUV4OkVyO{R3Okh1PER2OkZ4OEh4NUh1PER2N{dzO{h4OUd4OUB4NUVzO{F5Nkh{Okl4N{h1PEN2Nkd4OUZ5NEd{PEV1PUd4OEh5NUdzO{J2NUV4OUZ2NUhxO{R2Nkh2OUB3O{d2PEF2OUhyOkh1PEh2PEN4N{V2PEB4NUhyO{F5NUh3O{J2N{dyOkl2NEdzO{d5Okh{O{Z2N{VxOUZ2N{VxO{h3PEhyOUR5NEdzPEJ2O{h2OUJ1PEh3OkZ5OEh2O{J4Okh1OEh2OkhyOUF2OEhzO{d3O{V3O{B5OUV4OUF4N{hxO{d4NUR6O{B4NUR6O{N4OkV2O{B3O{dzPEJ3PEV{Okh2Nkd{PEN5NkR6O{R5NkhyOkh4N{V4PEF2OEhxPEZ4N{dzPER3PUh{Okd4OER5Okl2OUh3PEZ5NER5OUV1PEdzPER4NUZ4O{R4NUR6O{h4OEZ3O{R3OkZ5O{V2NkV3Okd2OUZ4OEh3OkhyOUV3Okd1OUB4NUhxO{h2NEVzO{h4O{d{OUJ3PEZ5PEN5N{V{Okl5NER5O{R4PEh2OUR3PEd{PEJ2OEdxOUJ2NEd{O{J5NUdxPEB2NkZ5PEZ4O{V4OUZ2NEdyPEZ4N{VxO{d4NEd3OUF2NkVxO{h2Nkh3OUF5NUh3OUB2N{d3PER4OEd1O{d4PEd5Okd5NEVyO{Z2NUhzOUJ4N{d5PEF5Nkh2OUd5OUh3OUZ1PUdxPEN5NUR5O{h5OkV4O{d2OUd1O{d4N{Z3O{J3PEVzPEJ5NER6Okl2NkVyOEh2NEd4O{B2OEZ4PER2NEdxO{R5OEdxOkZ5NEZ5PEN4OEhyO{J2N{V{Okh1PEV2PEF5NEd2PEZ4PER5OUJ4N{VzPEV3Okd3OUR4OUd1OEh3O{Z3Okd4OUV2PEB4PEV3O{R5NEdyOUd1PEhxO{d5NEh{PEZ4NEZ5OUN3PEh{PEV2O{d3OEh1PUh{OUF5OkhzO{V2O{V2O{V2OEV3PEF4N{V4OUZ2OEV3O{J4OkZ6PEN4OkZ4O{Z3O{V4OEl2OkV{O{J2Okd5O{V2OkVzOkh5N{h3O{B2NkdzPEJ4Okd{O{h1PUd3O{R2NkZ6PEF5OEh{O{F5Okh2PEN4NUV1O{h5OkdxPEB4NUZ6O{d4OkV1PEF3OkV{O{h5OkV1PEZ3PEdxOUN5OUVxO{J2NEdxOkd4O{VxPEB5N{V2Okd2Okd{O{R2NUhyPEZ5NUdzOkl2NEV3OUB5NER6OUd2O{VyO{R2NEZ3OUB5N{hzOkh4OkV2OUF5OkVzO{J4NUd2OUN3PUVzO{B4O{dxO{Z3O{hxOUZ4N{dyPEN2NEdxOkh5NUhzOUR5N{d5O{h4OkZ6OUB2N{Z4PEV3Okh1OUZ5OUd2OEl2OEdyOUJ1PEhxO{R4OEdzPEF4OUh{PEF2OEh1Okd5NEV1Okl5OUh3O{d2OER6PEB2N{d1OUJ3Okh2PEV5OkZ3OUJ2OkdxOUZ3PEh{OEh4NUdzPEJ4PEV2PEJ3PUdxOkh2NEd5Okd2Okh2O{Z4NUVyPEN3OkhxOUJ4NUd3OUR3Okd2OUF1PEh1O{R5N{h2OUR2N{d5OUN4O{h3OEh4NEhxO{F4O{Z3OUV3O{V{PEN2NkZ6Okl5Okd2O{N3PUh2OEl3OkV3Okh2OUd2O{J3PEd{OUd3O{dxO{J3OkV3PEZ5NkhyOkl5N{h2Okd3O{VzPEN4NkV1OkZ2N{dzO{N4N{dxOUV4NUR6OUd4N{h2Okh4Okd4OEh2O{Z6PER5OUd4O{R4OUhzOUV1PEh1PEV5OER5O{F2NEh2Okh3O{d5OUB4OEZ3Okl2N{Z5Okd3O{h3PEF2Okd4OkZ1PUR5OUd4OkZ6O{d5OUdyPEF2O{d{O{N5NkZ3OUZ5NEZ4O{h2O{VzPEB4OkVxOUR5N{d5OUR4PER5OUB3PUd{Okd4OUd4PEF4OEh2OUF2O{d1O{R5OEVyOEl4PEdzOUF1PUd3PER1PUV4OUR3PEVyOkd4OER6OEl5OEZ5PEN1PUZ4PEJ4NUdyPEJ3PEd2PEZ4NEhxPEZ2N{d1O{Z4NUZ3Okh5NUV1O{F5OEV3O{B4N{V2O{d2Okh{OUJ2OkZ4OEl2NUd{PEZ2NEhxOkh2OUdzOEl4NER6OUJ2OEhyOUN2NUdxO{B2OEhzOUR2OEV2PEN2N{Z3O{J4OEVzOkZ2OUd{O{J2N{dyOUN3PUh3O{F4OUZ3OEl4NUd2O{J4NUdzPEB2Okd3PER2NEV1OEl1PUVxPEF4NkdzOUR5NUd2OUJ3Okd3OUd4PEV{PEF4PEdyO{R5OkVzO{Z3Okd{OUB4OUh2OUF2NUR5PEF5OEZ5OUV5NUVzO{N2OUR5OUR2Nkd5OUZ5N{R5O{d4Okh{OEl2OEZ6O{Z2Nkh{OUV2O{V{PEB3OkV4OEl5NUZ6OEh2O{dxOkl2OEdyO{R4O{V4OUN1PUZ6PEB2OUZ4Okh4OUh{O{V5NUZ5O{Z5NUZ4OUF2NkV3PEV4N{d{O{Z4OEhxOkh3PEd{PEZ5OkVxOUV3PUVxOUB2N{Z4O{Z4PEd4Okl4N{VxOUB4NUZ5Okh1PUV3O{V5NUhxO{F5OUdzO{Z4OER6OEl4OEhxOUd5N{d3PEV4NkhyO{h1PEZ3PEF4NUd2OUN5OEh{OEh4O{d5OUV4NEZ4OUB2NUV{OUN2Nkd{O{F2OUZ4O{J5OUdzO{h3OkdyPEN2Okh{O{d2N{d{OUR5N{V4PEB4NkV1O{F5NUV4Okd2O{R6OkZ4Nkh3Okl3O{VxOUd3PUh3OUJ2O{h2OUN5NEVxO{h5N{Z5PER3PEhxPEF2O{Z4OUF5NEV1O{J2Okd3O{B4O{VyO{V4OUZ6O{d3O{V3OUR2O{VxPEV2OUh1O{h5NUd1O{h5NkdyO{R5N{dxOUN2O{V1OEl5NUZ3OUB5OkVzOUF4PEd5OUR2N{d1Okd2NEd3O{F4O{Z6OUR4NUZ5Okl4NUVzOkZ4OkhzPEN5NUd1OUd2N{R6PER4NUZ6OkZ4O{V{PEV2OUV3O{R1PEVyOkl2OEV2OEl4NUh1O{V5NUd1OUF3PUV{O{Z5NEd4PEN5OEZ3O{Z4PEh1O{d4O{VyPEF5OkZ3PEF2OUVxPEZ4NUR5Okh5NkVyOkl2Okd2PER4OUZ6OUZ2NEd{Okl2NUd3OUB5NEZ5OUJ5NEV4O{B4NkhxPEF5OUR6OUB5OEdxO{V4NEZ3OkZ5N{h1O{h4NkR6O{J4NEh3OEh3O{hyOkh4NEhyPEN2O{V2OUN5OEVzOEl2O{Z4O{h4OkZ6PEF4NkhyOUF4OkZ4OEh2OUdzPEZ4NkZ3OUR4N{d3OEh5N{V1O{Z3PER6Okl3PEdxOUV1PEh1O{Z2OkVyOEh4O{Z5Okl4O{V4OkZ5OUhzO{B3PEV3OUF1PEd2OEl4OkdzO{Z5OEh1O{F4N{VzPEV2OkV4O{h5NUh2OUV3OkR6O{F4O{h1PEV4O{Z5O{d1PUV2O{V3PUZ4O{J2NUR6O{h2OkdxO{B5NkdzOUJ1PEdyPEZ3O{d4Okl2NUh1OUF2NUV{O{d2OUV2OUd2N{R6O{V5N{h1OUN3OkV3PEZ4N{V{PEN4Okd{O{B3PEZ6PEB5NEd{PEJ2OEhxPEB2O{d5PER4O{Z6O{B2OUVzO{V5OEV3Okd5N{hxO{Z5OEh{PEZ2O{Z3PEV4N{hzPEJ3PUd5PEB4OkZ3O{N5NUZ3O{h5OUd5PEB5NkV1PEV4NUV{O{V4OEZ6O{N5OEZ5Okh4NUV3O{F3O{h{Okh5OEVzOUJ2OUdxO{Z2OEhyO{J3PUdyOkZ5OUd5OkZ5Nkd4O{h3O{V2O{Z3O{h3PEV4NUZ6PEF3PUZ5PEV4NkhyO{Z5OkdzO{V5N{dzOUJ4OEh3Okh3O{h2OUN2OUV{OkZ5NkdyPEZ4PEhxPEJ3PEhyOUd3OkhzOUJ4Okd4PER2NUdyO{Z4Okh1PEZ5OUd5OUZ4NEh2O{N4PEVzO{V1PUZ5O{Z2N{d1PEB2OUV{OUR2OUVzPEF4N{d5PEZ4Okh3PER4OkV3PEJ1PUVzOUV2NEhyOEh2O{hzOUF5NUh{OUd5OkdzO{d5OkR5O{h3PEVxO{N4O{VzOkZ5NkZ3PEN2NEd1PER4PEd4O{d4OkZ4OUJ5N{V2O{R5NUZ3OUN4Okd1PEB2NkhxOkd2NUd1OUN2O{d5O{V3OkdyPEJ1PUd1O{N2N{h{O{h5OUh2OUV2NEh{PEJ5N{d5O{B2NUV3OEh4OUVyOkl4O{VzOkl4NkhyO{N4NEd1OUF4O{d5O{B2OEVyOUZ4NUV4OUV3OkdyOUd1PEV4OUR3PEhzO{h3O{h{OEh3OkZ6OUR4OEV4OUN5OkdzOUB2O{d4OUZ2Nkd2O{d3OkV3PEN1PUV2PEZ4NUhxPEJ4OkV2O{V5OUh2PEN5OkVyOUB2NkdzOUF3O{dyOkd2OUV1O{Z5N{h{Okl5NUd4PEZ2NUh2OkZ5OUhzOUR5NER6PEV5OkVxOUB5OkZ6PEV2OUd4O{N5NUZ3O{Z4N{h3O{V2OEVyPER2N{V3O{d2Okd1O{F1PUV1OEh2OEd1OUd4OUR6PEB1PUd{PEV1PEhxOkh5N{d3O{N5OUVzOUd5NEVxOUF5OEhzOUR5Okh3OEl5OkhyO{F5OEhyO{B1PUR6OUZ4O{h1O{N2NUd5OUd2Nkh3PEV5N{V1O{N2N{VyOUF5N{dzPEB2Okh2O{J2OkZ4Okd4OER6O{F4OUV3PEN5Okd1PER2NUh3Okd2NEh3Okh4N{hzO{h4PEh2OUB2O{Z3O{h5Nkh3O{R4PEd3OUd2OEV{OUd5OUd2O{F5OUd5OUJ4OUZ3OEl2OUZ3PEZ1PEV{PEN2O{Z3PEF3OkdzO{F2NUh3OEl2OUhyPEN4OkZ4PEV4Okh{PEN4OUVxO{F5OkhzO{d5OUV4Okd4OkVxO{h5Nkh{O{V2OkhxOUF5NkZ6O{h2OUd5OUR4N{VxO{J5NUd{OUR5OkdzO{F3O{d1OUV3PEV{PEB4OUR6Okh4PEdzOkh4OEh{OUZ2OUd{OEl2NEh1OUR3Okh1OUN4OUh3PEV1PUZ6PEZ5N{h2Okd4N{V2O{J1PEVzO{Z2OkdxPER3O{dxOkd4OEZ3O{R2NEhxOkh5Okh1O{B2OkR5OUV2OUVzOUB3O{hyPEV2OUVxOkh5OUdzO{J3O{d5O{d2Okh3O{N3PUdyOUV4PEhzPEZ3PEdxPER2O{dyO{d4O{d{Okh1PUd2OEl2OEVxOkh4NEhxOEh3PEdxOUN2OER5OUF5OEhyPEV1PEd5PEN4OEh1O{N2OEd4O{h3O{dyOUd4OEVzOUd3PEZ5O{F4NkVzO{R1PUhxPEF2NUhzO{d2OER5O{h5NEV4OUV5NUR6OUZ4Nkd{O{Z1PUdzPEF3O{VxOEh4O{d1O{d4NEV4OUB4O{d5PEJ4OEVxOkl3O{d{O{R4N{VxOkl4N{hyO{d4OEhyPER4NUV1PEV3PEVzO{R3PEVyPEJ4OEd{OUZ3Okh3PEJ2O{dzO{B5OEdxOkl4NEh{O{J5OkhyO{d2NUV{OUN5N{h2PEV3PEd3O{V5OkhzOUZ2OUhzOEh2O{VxO{N5OEh{PEN2NER6O{R2OEZ5OUB4OkV1OUB5OEZ4OUJ4NUdxPEF1PUV3OkZ1PEh1OEl5NkZ4Okl4O{VyPER2Okd3O{J4PEV{OUN5OkV{O{Z5N{Z5O{d4OEd5O{Z4N{hzO{h4NEV4O{J4NEd2PEJ5N{V4O{F4OUZ3OUJ2OkZ4O{F4Okh1OUN2NkVzPEZ2O{V{OUV3PUh1O{Z5OEdyO{Z2OkdxOUN4OkR6OUR5Okh1O{N5NEh1OUJ4OUZ5Okl3PEdxO{J5OkdxPEN4OUd3OUZ3O{dyOUN3OkhyPEZ1PUd1O{h2NUd1PER5OUhyOkd5NUh3PEB3OkV{PEV2OUZ3PEZ2Nkh2OUB2O{V3Okd3PEVzPEZ2Okd2OkZ1PEh1PEZ3PUd1OUZ2NEd3PEN5OkVyOUd3PER5OUJ2NUh3PEV4OEd5O{B2OEd{OkZ4O{V3O{F4N{d1PEV2NkhzPEN4O{h2PEJ4NER5PER1PEdyOkZ4N{d2OUR2NUd2O{N1PUdzPER2NEd{OkZ2NEd1O{J3PUR5PEJ5OUdxOkZ2OUVzOUB4N{VxOUB2OUhxPEN5Nkh1OUF5N{VxOkh2OEh{O{B4Okh2PER1PER6PEZ2NEZ5OUF2OEd3PEZ4N{h1O{F2NUh3PEZ5N{Z4OEl3O{h2PER1PEh3O{R2O{V3O{B2NUd2O{Z4Okd2OUN2Okh2OUB4OkV4PEB4O{R6O{F4NkV4PEB2NEZ4O{J3O{Z4OEh5N{d3O{Z5OEV2O{N5OkZ6PEJ5NkdzOkl2OUd4O{d4N{d2PEV4PER6PEV4NUZ3PEJ3OkVzO{d2N{VxOUF2OkR5O{d4NEh{O{J5NEdzO{N2NUdxO{h5OUd{O{h4OEd4PEV3O{h2O{d1PUZ5O{Z4O{h{O{J2OUh1O{Z2N{dzOkZ3O{R6O{Z4OEh{PEF2OUR6O{F4OEZ3OUV5NEd5O{J2OUZ3OEh4OUV1O{h3O{h1O{R4OUd3Okd5OkV1OUJ4Okd2PEF5OUh1OUR5OUd5O{V2NEd1O{Z2O{Z5OUd2O{V1O{V2NUdzOkh4OEVzPER5NUd5Okh4OUh{PER3PUd2PEJ2Nkh2OUB5Nkd4O{Z2OEVxO{V4PEd{OEh2NUh1OUF4N{h1O{N2OUdyPEN2OUR5Okl3PEd{O{B3PEd4Okh3Okd5OUR2NUd4O{B4PEdxO{N5N{Z4OUV3O{Z5O{d2OUZ5O{V1PUVyPEJ1PEd3Okh4OEhxO{R5NEh{OEh2NEVxOUZ3OkVyO{V5OEhyOUd4OkhxO{h4O{hyO{d5N{hyOUV2OkhxO{h3Okh3OUR1PEh2PEB5NUd3OEh2NkV4PEZ3PUZ5OUd4N{V2PEZ5N{VyPEN4Nkh3O{J2NEd{OkZ5NUh3OkZ2OUh3PEV5OkhyPER4NUdxO{N4OUh3PEV5OkVxO{J2NEV4PER4NUh2O{V3PEhyOUN2OUV3OEl2O{V1O{d4PEd1PEB3PEd1PEJ2NEh3PEB1PUZ3Okl2O{d2OEh4O{V4OUZ3O{VzO{J4PEZ6OUZ3PUd4OUR5N{d4PEV2NUVyPER2NER6Okh5OkV3OUB5OUhxOUN4NUhzOEh2OEhxPER2NkR5PEB5N{V2OUF4OUZ3PEB4PEh1OkZ2NUZ6O{d3PEVxOUF4OUh2Okd4N{hxPEF4NEVzO{h2NEZ5OUd4N{h2OEh2O{h1O{F4OUZ3PEJ4OUhzOEh2O{Z3OUR4NER6OUV4OUd3OUd1PEVzO{h2OEV{PEN4OkV4PEJ5NkV3Okh5OEd1OUJ2NUd3OUF2NUhxOUF4N{VzO{h5OEZ3Okd2NEh2OUV3PUd3O{R4OEdxOUd3PUh3Okh5OUdyOkZ2NUd2O{d4NkdzO{V2NEh2PEB3PUVzOkd4NUdzOEh5NkhzPEF4NUdzO{h2NEd5OUJ1PUdxOUV2Nkd4OUZ1PUV1O{F5N{VxOUR5NEV2O{V5Nkh3PEB1PUd{O{d3PEd2Okh2N{V2O{V4N{d1PEJ3PUZ4OUN3Okh1O{Z4NkV4OUJ2NUhxPEJ5OUd1O{N4NkZ6Okh3O{hzO{F5NEdxO{V5NkR5Okd4O{d2OUd1PER5O{Z5OkV1O{N4NEV2OUV3PEVxO{h4N{dyOEl4OkV2O{N5NEd4PEZ4OEhyO{d2NUh1O{J2O{VyO{N4NUVxPEV5N{VyO{V2NEh{O{N4NUhyPEJ4N{VxOUZ5OEd4PEF5NEV3O{Z4O{hyOkh4OkZ3OUd5N{VzOkZ4PEdxPEV2OEZ6OUF2NUh3O{F5N{dzO{F5OEZ3PEV2NUhzPEZ5N{V4PEN1PUd5Okl2N{d1PEB1PER5O{N2Okd4PER2NUV2Okh3PUVxO{V3O{hyO{N3O{V1PER2OUV{PEJ5OUVyPEV5NkhzOUN3O{hzOkh5NUZ4O{h2Okh3OUd5NUh2Okh3PEh2OkZ4O{Z4OUJ4OUh3PEB4OEhxOUJ5OkV4PER4OUh{OUB1PEZ3O{J5OkV{O{h4NkdxOUB3PEV1O{R5NkZ6OUF4NkhxOUB2O{d2OEh3PUd3OEl2N{hxO{V5NEhxOUN4O{R6OEl5OEd1OUJ5NkZ4O{N5OUZ6OUV4OEdxOUd2N{R5PEN2NUVzOkl2N{h2OUZ5NUh{O{B2NUV{O{V2NkZ6OEl4O{h3O{F4NUd3OkZ4PEdxOkl2O{VxPEV4Okd2O{R5NUh{PEV5OUVzOkh3PEVzO{F4PEV4OUJ2OUd{Okh3PEh2OUB2NEhyPEZ2OkZ6PEF5OER5Okh2O{VyPEV5NkVyPEF4OEd3PEB4O{Z3Okh4O{R6PEZ3Okh1OUR2N{V2OUB1PUVzO{h5NUV4O{N3O{d{OUV2OkR6O{N5Nkh1O{N5OkR5Okd2Okh2PEF4OUh3O{Z2NkV2O{N1PEd3O{F5OEZ6O{d5OUh3O{J4Nkd{PEJ3O{Z6PER2OUd{Okl4OEV1PEN2NUdyPEB2OEhyOkZ4O{d3OUF2OUd3PEJ3PEdzO{B4Nkh{PEB3O{h2OUZ2OkV1O{J2N{V2OUZ2OUd{PEZ4O{dxOkd4O{hyOUJ1PEZ5O{Z4O{d1PEV4OkVxOUd2Okd{OEh5OUh3OkZ3PUh1OEl3PUhxPEB2OkV1O{V4N{Z5O{h5NEV1OUZ4O{hyOUB2N{hzOUF3OkR5O{J4OUZ5OUB4NkV{PEN2OUhzOUZ3PEV{OUV4O{h2Okd4OkVxO{B2OEV4PEF5OUh{OUJ2N{Z3O{Z4N{V2OUZ5NEh2OUZ2NEV2Okh4O{R5OUN2OEVzO{B3Okh{OkZ5OkhzOkZ5OEh1OUB2NUdzO{F2N{Z6OUV2NkV{OUN3PEZ5O{R2OUd1OUZ3PUhxO{V1PUhzO{B4PEZ4PEN3PEd4PEN3OkV2O{h2OEV4Okl3Okd2OUR2O{Z3PEJ3PEV4PEV2NEdxOkd4OUd4OkZ2NEd1PEV2OEV3OEl5NkdxO{B4PEV4OUV3Okh3Okh4NkV4O{B4OUh2Okd5NkZ5OkZ2O{dyOUZ1PUVxO{h2O{d1PEN2OkR6OUd5OUVxOUN5NEZ6O{F4OUV{O{V2OUVyO{J3O{R5O{F4O{d2Okd4NUd3OUN5NUd4PEZ1PEV1OUJ5OUdzO{V1PEZ6O{B5NEZ5PEB5OEZ3PEJ5NUVzOUV4O{V1O{Z2OUh1PEJ2NUV3O{F3O{d1PEF1PEh3PEB4O{dyPEZ2NUVxPEN5OUd{OUR2NkdxOUZ4NUd{OUJ2OEh1PEJ4OEV{PEJ2OEd3OUJ2OUZ4Okl5OEdyOUN4OkhxO{N4PER6OUR5N{h2O{B4NUR5PEB5OEdyO{h2N{V{OUJ2O{h{OEl2OEV{Okd4N{R6PEN5NEV1OUB5OEd{Okh2O{dxO{J4NUV{O{d5N{d4OkZ4NUh2OkZ2OkR5OEh5OUd1O{h5NEhzOUJ2OEVxOUN4NEV2OEl4OkhyOkd5NkdyOEl2NUV1O{Z1PUh2OEh1PEd5Okh3OkV{PEV5Okd4O{h5OUd{OUR1PEd{PEV1PEdyPEB1PEhzOUR3O{V{O{V1PEZ3Okl4PEh{Okl2N{R6OkZ4OUd3PER2NEdxOEh2Okh1OUN3PEdyPER5OEd4PEB4NUd2Okl4NkZ6O{F2NEV4OUN2NkdxPEF5NEd4OUJ5OUd4PEB5Okd4OUd4Nkd4OUB2Nkh2O{V1PEV{OUF5NkhxOUV4O{h2OUF3O{dyOUd5N{hxPEJ2OUhxOkh4NUhyOEl5NEZ6PEZ1PUd1O{B4NEZ4OUB4N{h1Okh2Nkh{OEl1PEd3PEZ4NEV1OEl3PEd1PEV1PUZ6OEl2Okd4OUN2OER5O{N4OUR6PEV4OEh3PEZ2OUd4OUB5OEd3PEF4NEd1OUB2NkdxO{d2OEZ4PEJ4N{h1OEl4NkV1O{V4PEd5OUZ5N{Z5OUB4NEd3OEh1PEdxPEZ1PUVzO{N2NkV1O{V2OUZ4OkZ4NEV4OUB3PUVzOUZ5NEd4O{J3PEh{O{F5NkZ5PEV4OER6O{R2O{VxO{N4O{d1OUB2NEh3OUJ2O{d3O{J2OEh1Okd5OkdxOUV5OkR6OUJ2NkZ5PEZ4OUh2PEF5OUh{PEN4NkhxPEF2OER5OUd2NEhzO{J3PER6Okl4OEd{PER4NUhyOEh4PER6O{Z2NkZ5OUV5NUd1OUd3PUR5O{B1PEhyPER1PEh{Okd3Okh2OUF2O{h{OUV4NEh2Okd2O{dyPEF2Nkd5O{J2OUV3PEZ2OEZ5OUF5OUhzOUd2NEd5OEl4NEV{PER5NEh2O{F2Okd3PEF2NUVxPEB4NUd4OUB4OEhzOkZ4NkV2O{B4PEhzPEN5OEh1PEZ5OUV1OkZ4O{h1PEJ5OUV2OUV4NUd{OEh4NER6PEN2O{d2PEB4N{V2O{R4NkR6OkZ5NUZ5O{h3PUZ6O{F4OEVxPEN5NkVzOkd1PUh2O{V2OUd{PEF4NkZ6PEF4OUdyO{N1PEd5OEh3PUdxPEZ1PEdzPER1PUV4O{d4NkhxOUN4Nkd4OUN5Nkd5OEh1PUV{PEV5NUhyOkZ5OEd2OUZ4Okd{PEV3PEh2OkZ5OEdxPEF5NEh1Okh1PUd4O{F5NEV4OEl2NEV1Okd5NkhzO{J2OUd4O{J4NUd4Okl4PEd1OUB2OUZ5PEF3PUd1OUR2O{hzO{h5NEdxOkZ3PEZ3Okl2O{h1PEZ5OUdxO{V5OEVyOUR5NkV{PEV4OER5OkZ4OUd3O{V3PUh1O{B5OEZ4OUR4PEZ5OUN2OUV{PEJ4PEh{OUN5NUVyO{d4NEdxPEJ3OkR6OEl1PEZ5O{h2OkdyO{h4NEVxOkZ1PUZ5PEV2NEhyOUN5NEZ6OUB5OEh2O{V5Okd{Okl5NEh{PEZ4OkR5PEZ3PUd{O{h2OUZ4PER4NkV1PEF5OEhxO{J5Nkd3OUd2NkdxPEJ2OUV2O{F2NUhxOUJ5NkhxPEZ2NEd4PEV4Okd2OEh2N{V4OUF4N{V2Okl4O{R6O{h2NEVyOUN4NEhxOUJ1PEd1PEV4NEd2O{V4NEd2O{Z5NkZ4O{V4OUh1PER3OkdxO{B2NUd4O{V2O{h{O{R5NUh3PER3O{Z5O{R5NEh{Okh3PUdyOkl4OUV2O{Z2OUd4O{N3OkV3PEB4N{d3Okh2NkdxOkl4Okd{Okh2OEdzOkl2Okd2OkZ2NkhyOUd2O{d3O{V4OEVxO{F4NUVyO{F5OUZ4PEJ4OEdxPEV1PEV1OEh2OER5O{Z3PEh{Okh2N{d1OUV2OUR6PEB4O{VxPEB2Nkh{O{R3PUh2O{F2NEdyOkh4NkV1O{V4OkZ4PEJ1PUhxO{V3PEd4PEB3PEVzO{F4Okh2O{d3PEh1PEZ3Okd2OUN5NUdxO{F2OUV1O{N2N{Z5O{h3PUd4OUF2N{h1OUV4PEVyOEl2Nkd3OUZ4PEdzO{R2O{d4O{F5OkV4OUN4NkVxO{B5N{V3Okh4OEh3O{N5OUR5OUR2N{VyO{Z5NkdxOUV5OUV1OUZ5NEV1PER2O{Z5PEB2OkV4PEN1PEh1OUJ4NUhzOUJ2NEVzOUB2OUR6OEh5OUh{OUd4OEV2OEh3PUd1PEJ2OkZ6Okl5N{h2OUF4PEd{OEl2N{R5Okh4NEZ6PEJ5OEh2OUZ4O{h1Okd5Nkd1OUZ3PEdyOkZ4NEd3OUF5NkZ6OUN5Okd2OUR5NkV3O{V3PUZ3O{d4OkhzO{R4NEd3OEl4OUdyPEJ5NER6O{d5NER5O{F3PUV3Okl5OEdxO{V4PEd2O{N1PUV3OUZ4NUd5O{V2OEd2PEN5Okd1OUN4PEdyOUR3PUhzOkZ2OUh2O{B3PEZ6OEl3PEVyO{Z4N{V4O{h5OkhzO{V3O{d1Okl3O{h2PER4OEd1OUN4NEd1OkZ1PUV4OUF4PEV4OEh2OUR6PEN5OUZ4OUF4NUV4OEh5N{dxOUR5NkdxPEJ5NUR6O{J5OEdyOUd2OUVxPEN2NUdyPEZ2O{Z6OUN2O{V4OUR2N{Z4OUd3PER5O{N5NkV{PEV5N{h2O{N5NUZ3O{J3PEd1O{R4Okd3O{h4O{V{PEV4Nkh1OUN4NUZ6OkZ2N{h1OUJ2OUdzOUJ5NEd4PER4O{h1OkZ4N{h3OUB2OUV{Okl4NUh3O{Z2NUhxO{Z3OkhzOkh4N{d{OUd2O{d5O{J2O{d3OUN1PEd1O{h2OUhzO{V4PEV1OUB3PUhzOUN2O{V1OkZ3PUd{PEV1PER6OEl3PUh{PEV5NkVyOkZ5N{hyPEB3PUhxOkZ2NUV2PEB2O{d1OUF2NEVzOUZ4NEhyOEh4OkR5OUV3OkhxOUJ5NEV4O{h2N{Z3O{V2O{d1OEl4OEd{O{d2NUdzPEZ4OUR6O{Z2OkZ4OEh2NEV{O{Z2N{V2OUN4N{VyOUd3OkdxOUR5NEhxOkd2NUR5O{J2NEd{OUZ3PUdzOUN4OEh{PER4Okh1O{V2N{d2O{F4PEVxOUV1PUZ5OUd1PEdxOUV1PEd4PEB4NUVyO{R5OEdxOUB2NkhzO{Z2OUh1O{N4NER6OEh4OkR6PEJ4Okh{OEl1PUZ3OkZ5Okh3O{R2OEV2Okh4NkV4PEV4O{VzOkZ2NUd1Okl5OUh3PEF4O{Z5PEF4PER6OUd5NkZ4O{d2NER6O{F5NUV1O{R4NEd{PEF5OER6O{B1PUZ5PEJ3O{Z3O{B3O{Z6PER5OUh2PEN5NEhzPEZ2NkhzOEh4NEVzPEJ5NEh{PEZ5OUh3O{F2Okh2OUd2OEVxOkZ2Okh{OkZ5N{dzOEh2Nkd5O{V5OEVxO{Z4N{Z5PEV5OEh{Okh2OkZ6OUN2NUV1O{N3OkZ6O{Z5OUd5OUV3O{V{OUN5NEd2OUZ2O{dyO{J2NUZ4PEB4OkhyOkd3O{hxPEJ2NUh1Okl4OUV4PER2NkR6OUF5OEVyPEJ4NkVzOkh5N{hxOUR3OkdzOUJ2OUd3Okd4NUV1OUZ3PUdzPER5OkV4OUB2O{Z3O{Z4NEdzPEB2NEd{OUZ5OEV3Okd4OEVzO{B2NEdyOkh1PER5PEF5NkV{OUd4NEd1O{V4PEV3OUV4Okd5O{J4OEd1OkZ2NEVzO{Z2NEdxPEB4N{d1PEV4N{d{OUB4O{V1Okd4Nkh2O{d5NkV{OUd4OkVxOUd4NkV1PER2NUR5PER3O{d1OUJ2N{Z6PEZ2OUZ3PEB5N{VzOUB4N{hyOkl1PUd1O{F5Okh2Okh4PEZ3O{h4Okh2O{d5N{d3OUR3Okh1TUM4NjkyVTdUTlFKTlJH');

drop table if exists `theme_configuration`;
CREATE TABLE `theme_configuration` (
  `configuration_id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration_title` varchar(64) NOT NULL,
  `configuration_value` varchar(255) NOT NULL,
  `configuration_description` varchar(255) NOT NULL,
  `configuration_column` varchar(64) NOT NULL DEFAULT 'left',
  `location` int(5) NOT NULL DEFAULT '0',
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `set_function` varchar(255) DEFAULT NULL,
  `dodatkowe_info` text,
  PRIMARY KEY (`configuration_id`),
  UNIQUE KEY `idx_configuration_title` (`configuration_title`),
  KEY `idx_column_location` (`configuration_column`,`location`)
);

insert into `theme_configuration` (`configuration_id`, `configuration_title`, `configuration_value`, `configuration_description`, `configuration_column`, `location`, `last_modified`, `date_added`, `set_function`, `dodatkowe_info`) values (1,'advsearch','yes','Wyszukiwanie','left',3,'2008-02-25 22:49:11','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(48,'banners left multi','no','Bannery - lewa kolumna - kilka bannerów równocześnie','left',99,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(4,'best sellers','yes','Bestsellery','right',8,'2003-04-15 18:16:37','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(5,'best sellers scroll','no','Bestsellery - przewijane','right',8,'2003-04-15 18:16:37','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(6,'categories','yes','Kategorie','left',1,'2008-02-27 19:19:17','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(7,'manufacturers std','yes','Producenci - wersja standardowa','left',4,'2009-03-28 23:58:04','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(8,'categories full','no','Kategorie - wersja rozwinięta','left',1,'2008-02-25 22:50:54','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(9,'categories jsc','no','Kategorie - wersja DHTML','left',1,'2008-02-25 22:51:07','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(60,'categories tigra','no','Kategorie - wersja drzewo','left',1,'2009-11-21 18:04:54','2009-11-21 18:04:54','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(11,'currencies','yes','Waluty','left',5,'2008-02-25 22:49:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(12,'info pages','yes','Strony informacyjne','left',7,'2008-02-25 22:52:31','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(13,'kontakt','yes','Kontakt','left',8,'2008-02-25 22:52:45','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(14,'languages','yes','Języki','left',6,'2008-02-25 22:52:12','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(15,'loginbox','yes','Logowanie','right',2,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(16,'manufacturer info','yes','Informacje o producencie','right',4,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(17,'manufacturers','no','Producenci - wersja rozwinięta','left',2,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(18,'newsdesk','no','Aktualności - kategorie','left',9,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(19,'newsdesk latest','no','Aktualności - ostatnio dodane','left',10,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(20,'newsletter','yes','Biuletyn','right',11,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(21,'order history','yes','Historia zamówień','right',5,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL);
insert into `theme_configuration` (`configuration_id`, `configuration_title`, `configuration_value`, `configuration_description`, `configuration_column`, `location`, `last_modified`, `date_added`, `set_function`, `dodatkowe_info`) values (22,'platnosci','no','Płatności.pl','right',6,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(23,'polecony','no','Promocja Polecony-Nagrodzony','left',12,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(24,'product notifications','yes','Powiadomienia o produktach','right',7,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(25,'recently viewed','yes','Ostatnio oglądane produkty','right',8,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(26,'reviews','yes','Recenzje','right',9,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(27,'shopping cart','yes','Koszyk','right',1,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(28,'specials','yes','Promocje','right',10,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(29,'specials scroll','no','Promocje - przewijany','left',3,'2008-10-09 23:20:00','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(30,'tell a friend','yes','Powiadom znajomego','right',11,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(31,'themes','no','Zmiana wyglądu','left',13,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(32,'whats new','yes','Nowości','right',12,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(33,'whats new scroll','no','Nowości - przewijane','right',12,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(34,'whos online','yes','Kto jest online','left',14,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(39,'specials fade','no','Promocje - fade','right',3,'2008-10-09 23:20:47','0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(40,'categories face','no','Kategorie - wersja face','left',1,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(42,'best sellers thumbs','no','Bestsellery miniaturki','right',8,'2009-11-15 10:35:54','0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',''),
(43,'raty zagiel','no','Raty Żagiel','left',20,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(47,'banners right rotation','no','Bannery - prawa kolumna - rotacyjnie','right',98,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(46,'banners left rotation','no','Bannery - lewa kolumna - rotacyjnie','left',98,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(49,'banners right multi','no','Bannery - prawa kolumna - kilka bannerów równocześnie','right',99,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL);
insert into `theme_configuration` (`configuration_id`, `configuration_title`, `configuration_value`, `configuration_description`, `configuration_column`, `location`, `last_modified`, `date_added`, `set_function`, `dodatkowe_info`) values (50,'wishlist','yes','Schowek','right',1,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(51,'free shipping','no','Darmowa wysylka','right',3,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(52,'polls','no','Ankiety','right',49,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(54,'categories_std','no','Kategorie STD','left',1,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(73,'cennik','no','Cennik','right',1,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(74,'paypal','no','Płatności PayPal','right',99,NULL,'0000-00-00 00:00:00','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(75,'ticket','no','Reklamacje','right',3,'2008-02-25 22:33:43','2003-04-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL),
(76,'whats_new_last_10','no','Reklamacje','right',7,'2010-01-15 22:33:43','2010-01-15 11:01:05','tep_cfg_select_option(array(\'left\', \'right\'),',NULL);

drop table if exists `ticket_priority`;
CREATE TABLE `ticket_priority` (
  `ticket_priority_id` int(11) NOT NULL DEFAULT '0',
  `ticket_priority_name` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`ticket_priority_id`)
);

insert into `ticket_priority` (`ticket_priority_id`, `ticket_priority_name`) values (1,'Wysoki'),
(2,'Niski'),
(3,'Normalny');

drop table if exists `ticket_reply`;
CREATE TABLE `ticket_reply` (
  `ticket_reply_id` int(11) NOT NULL DEFAULT '0',
  `ticket_reply_name` varchar(255) NOT NULL DEFAULT '',
  `ticket_reply_text` text NOT NULL,
  PRIMARY KEY (`ticket_reply_id`)
);

insert into `ticket_reply` (`ticket_reply_id`, `ticket_reply_name`, `ticket_reply_text`) values (1,'Odpowiedź 1','Jakaś standardowa pierwsza odpowiedź do klienta !!!'),
(2,'Odpowiedź 2','Jakaś standardowa druga odpowiedź do klienta !!!');

drop table if exists `ticket_status`;
CREATE TABLE `ticket_status` (
  `ticket_status_id` int(5) NOT NULL DEFAULT '0',
  `ticket_status_name` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`ticket_status_id`)
);

insert into `ticket_status` (`ticket_status_id`, `ticket_status_name`) values (1,'Zgłoszenie zamknięte'),
(2,'Zgłoszenie realizowane'),
(3,'Zgłoszenie przyjęte');

drop table if exists `ticket_status_history`;
CREATE TABLE `ticket_status_history` (
  `ticket_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) NOT NULL DEFAULT '0',
  `ticket_status_id` int(5) NOT NULL DEFAULT '0',
  `ticket_priority_id` int(5) NOT NULL DEFAULT '0',
  `ticket_department_id` int(5) NOT NULL DEFAULT '0',
  `ticket_date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ticket_customer_notified` int(1) DEFAULT '0',
  `ticket_comments` text,
  `ticket_edited_by` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`ticket_status_history_id`)
);

drop table if exists `ticket_ticket`;
CREATE TABLE `ticket_ticket` (
  `ticket_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_link_id` varchar(32) NOT NULL DEFAULT '',
  `ticket_customers_id` int(12) NOT NULL DEFAULT '0',
  `ticket_customers_orders_id` int(11) NOT NULL DEFAULT '0',
  `ticket_customers_email` varchar(96) NOT NULL DEFAULT '',
  `ticket_customers_name` varchar(96) NOT NULL DEFAULT '',
  `ticket_subject` varchar(96) NOT NULL DEFAULT '',
  `ticket_status_id` int(5) NOT NULL DEFAULT '0',
  `ticket_department_id` int(5) NOT NULL DEFAULT '0',
  `ticket_priority_id` int(5) NOT NULL DEFAULT '0',
  `ticket_date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ticket_date_last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ticket_date_last_customer_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ticket_login_required` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ticket_id`)
);

drop table if exists `whos_online`;
CREATE TABLE `whos_online` (
  `customer_id` int(11) NOT NULL,
  `full_name` varchar(64) NOT NULL,
  `session_id` varchar(128) NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `time_entry` varchar(14) NOT NULL,
  `time_last_click` varchar(14) NOT NULL,
  `last_page_url` text NOT NULL,
  `http_referer` varchar(255) NOT NULL,
  `user_agent` varchar(255) NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `idx_customer_id` (`customer_id`),
  KEY `idx_ip_address` (`ip_address`),
  KEY `idx_time_entry` (`time_entry`),
  KEY `idx_time_last_click` (`time_last_click`)
);

drop table if exists `zones`;
CREATE TABLE `zones` (
  `zone_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_code` varchar(32) NOT NULL,
  `zone_name` varchar(32) NOT NULL,
  PRIMARY KEY (`zone_id`),
  KEY `idx_zone_code` (`zone_code`),
  KEY `idx_zone_country_id` (`zone_country_id`),
  KEY `idx_zone_name` (`zone_name`)
);

insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1,170,'DOL','Dolonośląskie'),
(2,170,'KPO','Kujawsko-Pomorskie'),
(3,170,'LUB','Lubelskie'),
(4,170,'LBU','Lubuskie'),
(5,170,'LOD','Łódzkie'),
(6,170,'MAL','Małopolskie'),
(7,170,'MAZ','Mazowieckie'),
(8,170,'OPO','Opolskie'),
(9,170,'KAR','Karpackie'),
(10,170,'POD','Podkarpackie'),
(11,170,'PDL','Podlaskie'),
(12,170,'POM','Pomorskie'),
(13,170,'SLA','Śląskie'),
(14,170,'SWI','Świętokrzyskie'),
(15,170,'WAM','Warmińsko-Mazurskie'),
(16,170,'WIE','Wielkopolskie'),
(17,170,'ZAC','Zachodniopomorskie'),
(809,1,'BDS','Badakhshan'),
(810,1,'BDG','Badghis'),
(811,1,'BGL','Baghlan');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (812,1,'BAL','Balkh'),
(813,1,'BAM','Bamian'),
(814,1,'FRA','Farah'),
(815,1,'FYB','Faryab'),
(816,1,'GHA','Ghazni'),
(817,1,'GHO','Ghowr'),
(818,1,'HEL','Helmand'),
(819,1,'HER','Herat'),
(820,1,'JOW','Jowzjan'),
(821,1,'KAB','Kabul'),
(822,1,'KAN','Kandahar'),
(823,1,'KAP','Kapisa'),
(824,1,'KHO','Khost'),
(825,1,'KNR','Konar'),
(826,1,'KDZ','Kondoz'),
(827,1,'LAG','Laghman'),
(828,1,'LOW','Lowgar'),
(829,1,'NAN','Nangrahar'),
(830,1,'NIM','Nimruz'),
(831,1,'NUR','Nurestan');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (832,1,'ORU','Oruzgan'),
(833,1,'PIA','Paktia'),
(834,1,'PKA','Paktika'),
(835,1,'PAR','Parwan'),
(836,1,'SAM','Samangan'),
(837,1,'SAR','Sar-e Pol'),
(838,1,'TAK','Takhar'),
(839,1,'WAR','Wardak'),
(840,1,'ZAB','Zabol'),
(841,2,'BR','Berat'),
(842,2,'BU','Bulqize'),
(843,2,'DL','Delvine'),
(844,2,'DV','Devoll'),
(845,2,'DI','Diber'),
(846,2,'DR','Durres'),
(847,2,'EL','Elbasan'),
(848,2,'ER','Kolonje'),
(849,2,'FR','Fier'),
(850,2,'GJ','Gjirokaster'),
(851,2,'GR','Gramsh');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (852,2,'HA','Has'),
(853,2,'KA','Kavaje'),
(854,2,'KB','Kurbin'),
(855,2,'KC','Kucove'),
(856,2,'KO','Korce'),
(857,2,'KR','Kruje'),
(858,2,'KU','Kukes'),
(859,2,'LB','Librazhd'),
(860,2,'LE','Lezhe'),
(861,2,'LU','Lushnje'),
(862,2,'MM','Malesi e Madhe'),
(863,2,'MK','Mallakaster'),
(864,2,'MT','Mat'),
(865,2,'MR','Mirdite'),
(866,2,'PQ','Peqin'),
(867,2,'PR','Permet'),
(868,2,'PG','Pogradec'),
(869,2,'PU','Puke'),
(870,2,'SH','Shkoder'),
(871,2,'SK','Skrapar');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (872,2,'SR','Sarande'),
(873,2,'TE','Tepelene'),
(874,2,'TP','Tropoje'),
(875,2,'TR','Tirane'),
(876,2,'VL','Vlore'),
(877,3,'ADR','Adrar'),
(878,3,'ADE','Ain Defla'),
(879,3,'ATE','Ain Temouchent'),
(880,3,'ALG','Alger'),
(881,3,'ANN','Annaba'),
(882,3,'BAT','Batna'),
(883,3,'BEC','Bechar'),
(884,3,'BEJ','Bejaia'),
(885,3,'BIS','Biskra'),
(886,3,'BLI','Blida'),
(887,3,'BBA','Bordj Bou Arreridj'),
(888,3,'BOA','Bouira'),
(889,3,'BMD','Boumerdes'),
(890,3,'CHL','Chlef'),
(891,3,'CON','Constantine');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (892,3,'DJE','Djelfa'),
(893,3,'EBA','El Bayadh'),
(894,3,'EOU','El Oued'),
(895,3,'ETA','El Tarf'),
(896,3,'GHA','Ghardaia'),
(897,3,'GUE','Guelma'),
(898,3,'ILL','Illizi'),
(899,3,'JIJ','Jijel'),
(900,3,'KHE','Khenchela'),
(901,3,'LAG','Laghouat'),
(902,3,'MUA','Muaskar'),
(903,3,'MED','Medea'),
(904,3,'MIL','Mila'),
(905,3,'MOS','Mostaganem'),
(906,3,'MSI','M Sila'),
(907,3,'NAA','Naama'),
(908,3,'ORA','Oran'),
(909,3,'OUA','Ouargla'),
(910,3,'OEB','Oum el-Bouaghi'),
(911,3,'REL','Relizane');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (912,3,'SAI','Saida'),
(913,3,'SET','Setif'),
(914,3,'SBA','Sidi Bel Abbes'),
(915,3,'SKI','Skikda'),
(916,3,'SAH','Souk Ahras'),
(917,3,'TAM','Tamanghasset'),
(918,3,'TEB','Tebessa'),
(919,3,'TIA','Tiaret'),
(920,3,'TIN','Tindouf'),
(921,3,'TIP','Tipaza'),
(922,3,'TIS','Tissemsilt'),
(923,3,'TOU','Tizi Ouzou'),
(924,3,'TLE','Tlemcen'),
(925,4,'E','Eastern'),
(926,4,'M','Manua'),
(927,4,'R','Rose Island'),
(928,4,'S','Swains Island'),
(929,4,'W','Western'),
(930,5,'ALV','Andorra la Vella'),
(931,5,'CAN','Canillo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (932,5,'ENC','Encamp'),
(933,5,'ESE','Escaldes-Engordany'),
(934,5,'LMA','La Massana'),
(935,5,'ORD','Ordino'),
(936,5,'SJL','Sant Julia de L?ria'),
(937,6,'BGO','Bengo'),
(938,6,'BGU','Benguela'),
(939,6,'BIE','Bie'),
(940,6,'CAB','Cabinda'),
(941,6,'CCU','Cuando-Cubango'),
(942,6,'CNO','Cuanza Norte'),
(943,6,'CUS','Cuanza Sul'),
(944,6,'CNN','Cunene'),
(945,6,'HUA','Huambo'),
(946,6,'HUI','Huila'),
(947,6,'LUA','Luanda'),
(948,6,'LNO','Lunda Norte'),
(949,6,'LSU','Lunda Sul'),
(950,6,'MAL','Malange'),
(951,6,'MOX','Moxico');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (952,6,'NAM','Namibe'),
(953,6,'UIG','Uige'),
(954,6,'ZAI','Zaire'),
(955,9,'ASG','Saint George'),
(956,9,'ASJ','Saint John'),
(957,9,'ASM','Saint Mary'),
(958,9,'ASL','Saint Paul'),
(959,9,'ASR','Saint Peter'),
(960,9,'ASH','Saint Philip'),
(961,9,'BAR','Barbuda'),
(962,9,'RED','Redonda'),
(963,10,'AN','Antartida e Islas del Atlantico '),
(964,10,'BA','Buenos Aires'),
(965,10,'CA','Catamarca'),
(966,10,'CH','Chaco'),
(967,10,'CU','Chubut'),
(968,10,'CO','Cordoba'),
(969,10,'CR','Corrientes'),
(970,10,'DF','Distrito Federal'),
(971,10,'ER','Entre Rios');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (972,10,'FO','Formosa'),
(973,10,'JU','Jujuy'),
(974,10,'LP','La Pampa'),
(975,10,'LR','La Rioja'),
(976,10,'ME','Mendoza'),
(977,10,'MI','Misiones'),
(978,10,'NE','Neuquen'),
(979,10,'RN','Rio Negro'),
(980,10,'SA','Salta'),
(981,10,'SJ','San Juan'),
(982,10,'SL','San Luis'),
(983,10,'SC','Santa Cruz'),
(984,10,'SF','Santa Fe'),
(985,10,'SD','Santiago del Estero'),
(986,10,'TF','Tierra del Fuego'),
(987,10,'TU','Tucuman'),
(988,11,'AGT','Aragatsotn'),
(989,11,'ARR','Ararat'),
(990,11,'ARM','Armavir'),
(991,11,'GEG','Gegharkunik');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (992,11,'KOT','Kotayk'),
(993,11,'LOR','Lorri'),
(994,11,'SHI','Shirak'),
(995,11,'SYU','Syunik'),
(996,11,'TAV','Tavush'),
(997,11,'VAY','Vayots Dzor'),
(998,11,'YER','Yerevan'),
(999,13,'ACT','Australian Capitol Territory'),
(1000,13,'NSW','New South Wales'),
(1001,13,'NT','Northern Territory'),
(1002,13,'QLD','Queensland'),
(1003,13,'SA','South Australia'),
(1004,13,'TAS','Tasmania'),
(1005,13,'VIC','Victoria'),
(1006,13,'WA','Western Australia'),
(1007,14,'BUR','Burgenland'),
(1008,14,'KAR','K&auml;rnten'),
(1009,14,'NOS','Nieder&ouml;esterreich'),
(1010,14,'OOS','Ober&ouml;esterreich'),
(1011,14,'SAL','Salzburg');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1012,14,'STE','Steiermark'),
(1013,14,'TIR','Tirol'),
(1014,14,'VOR','Vorarlberg'),
(1015,14,'WIE','Wien'),
(1016,15,'AB','Ali Bayramli'),
(1017,15,'ABS','Abseron'),
(1018,15,'AGC','AgcabAdi'),
(1019,15,'AGM','Agdam'),
(1020,15,'AGS','Agdas'),
(1021,15,'AGA','Agstafa'),
(1022,15,'AGU','Agsu'),
(1023,15,'AST','Astara'),
(1024,15,'BA','Baki'),
(1025,15,'BAB','BabAk'),
(1026,15,'BAL','BalakAn'),
(1027,15,'BAR','BArdA'),
(1028,15,'BEY','Beylaqan'),
(1029,15,'BIL','Bilasuvar'),
(1030,15,'CAB','Cabrayil'),
(1031,15,'CAL','Calilabab');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1032,15,'CUL','Culfa'),
(1033,15,'DAS','Daskasan'),
(1034,15,'DAV','Davaci'),
(1035,15,'FUZ','Fuzuli'),
(1036,15,'GA','Ganca'),
(1037,15,'GAD','Gadabay'),
(1038,15,'GOR','Goranboy'),
(1039,15,'GOY','Goycay'),
(1040,15,'HAC','Haciqabul'),
(1041,15,'IMI','Imisli'),
(1042,15,'ISM','Ismayilli'),
(1043,15,'KAL','Kalbacar'),
(1044,15,'KUR','Kurdamir'),
(1045,15,'LA','Lankaran'),
(1046,15,'LAC','Lacin'),
(1047,15,'LAN','Lankaran'),
(1048,15,'LER','Lerik'),
(1049,15,'MAS','Masalli'),
(1050,15,'MI','Mingacevir'),
(1051,15,'NA','Naftalan');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1052,15,'NEF','Neftcala'),
(1053,15,'OGU','Oguz'),
(1054,15,'ORD','Ordubad'),
(1055,15,'QAB','Qabala'),
(1056,15,'QAX','Qax'),
(1057,15,'QAZ','Qazax'),
(1058,15,'QOB','Qobustan'),
(1059,15,'QBA','Quba'),
(1060,15,'QBI','Qubadli'),
(1061,15,'QUS','Qusar'),
(1062,15,'SA','Saki'),
(1063,15,'SAT','Saatli'),
(1064,15,'SAB','Sabirabad'),
(1065,15,'SAD','Sadarak'),
(1066,15,'SAH','Sahbuz'),
(1067,15,'SAK','Saki'),
(1068,15,'SAL','Salyan'),
(1069,15,'SM','Sumqayit'),
(1070,15,'SMI','Samaxi'),
(1071,15,'SKR','Samkir');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1072,15,'SMX','Samux'),
(1073,15,'SAR','Sarur'),
(1074,15,'SIY','Siyazan'),
(1075,15,'SS','Susa'),
(1076,15,'SUS','Susa'),
(1077,15,'TAR','Tartar'),
(1078,15,'TOV','Tovuz'),
(1079,15,'UCA','Ucar'),
(1080,15,'XA','Xankandi'),
(1081,15,'XAC','Xacmaz'),
(1082,15,'XAN','Xanlar'),
(1083,15,'XIZ','Xizi'),
(1084,15,'XCI','Xocali'),
(1085,15,'XVD','Xocavand'),
(1086,15,'YAR','Yardimli'),
(1087,15,'YEV','Yevlax'),
(1088,15,'ZAN','Zangilan'),
(1089,15,'ZAQ','Zaqatala'),
(1090,15,'ZAR','Zardab'),
(1091,15,'NX','Naxcivan');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1092,16,'ACK','Acklins'),
(1093,16,'BER','Berry Islands'),
(1094,16,'BIM','Bimini'),
(1095,16,'BLK','Black Point'),
(1096,16,'CAT','Cat Island'),
(1097,16,'CAB','Central Abaco'),
(1098,16,'CAN','Central Andros'),
(1099,16,'CEL','Central Eleuthera'),
(1100,16,'FRE','City of Freeport'),
(1101,16,'CRO','Crooked Island'),
(1102,16,'EGB','East Grand Bahama'),
(1103,16,'EXU','Exuma'),
(1104,16,'GRD','Grand Cay'),
(1105,16,'HAR','Harbour Island'),
(1106,16,'HOP','Hope Town'),
(1107,16,'INA','Inagua'),
(1108,16,'LNG','Long Island'),
(1109,16,'MAN','Mangrove Cay'),
(1110,16,'MAY','Mayaguana'),
(1111,16,'MOO','Moores Island');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1112,16,'NAB','North Abaco'),
(1113,16,'NAN','North Andros'),
(1114,16,'NEL','North Eleuthera'),
(1115,16,'RAG','Ragged Island'),
(1116,16,'RUM','Rum Cay'),
(1117,16,'SAL','San Salvador'),
(1118,16,'SAB','South Abaco'),
(1119,16,'SAN','South Andros'),
(1120,16,'SEL','South Eleuthera'),
(1121,16,'SWE','Spanish Wells'),
(1122,16,'WGB','West Grand Bahama'),
(1123,17,'CAP','Capital'),
(1124,17,'CEN','Central'),
(1125,17,'MUH','Muharraq'),
(1126,17,'NOR','Northern'),
(1127,17,'SOU','Southern'),
(1128,18,'BAR','Barisal'),
(1129,18,'CHI','Chittagong'),
(1130,18,'DHA','Dhaka'),
(1131,18,'KHU','Khulna');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1132,18,'RAJ','Rajshahi'),
(1133,18,'SYL','Sylhet'),
(1134,19,'CC','Christ Church'),
(1135,19,'AND','Saint Andrew'),
(1136,19,'GEO','Saint George'),
(1137,19,'JAM','Saint James'),
(1138,19,'JOH','Saint John'),
(1139,19,'JOS','Saint Joseph'),
(1140,19,'LUC','Saint Lucy'),
(1141,19,'MIC','Saint Michael'),
(1142,19,'PET','Saint Peter'),
(1143,19,'PHI','Saint Philip'),
(1144,19,'THO','Saint Thomas'),
(1145,20,'BR','Brestskaya (Brest)'),
(1146,20,'HO','Homyelskaya (Homyel)'),
(1147,20,'HM','Horad Minsk'),
(1148,20,'HR','Hrodzyenskaya (Hrodna)'),
(1149,20,'MA','Mahilyowskaya (Mahilyow)'),
(1150,20,'MI','Minskaya'),
(1151,20,'VI','Vitsyebskaya (Vitsyebsk)');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1152,21,'VAN','Antwerpen'),
(1153,21,'WBR','Brabant Wallon'),
(1154,21,'WHT','Hainaut'),
(1155,21,'WLG','Liege'),
(1156,21,'VLI','Limburg'),
(1157,21,'WLX','Luxembourg'),
(1158,21,'WNA','Namur'),
(1159,21,'VOV','Oost-Vlaanderen'),
(1160,21,'VBR','Vlaams Brabant'),
(1161,21,'VWV','West-Vlaanderen'),
(1162,22,'BZ','Belize'),
(1163,22,'CY','Cayo'),
(1164,22,'CR','Corozal'),
(1165,22,'OW','Orange Walk'),
(1166,22,'SC','Stann Creek'),
(1167,22,'TO','Toledo'),
(1168,23,'AL','Alibori'),
(1169,23,'AK','Atakora'),
(1170,23,'AQ','Atlantique'),
(1171,23,'BO','Borgou');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1172,23,'CO','Collines'),
(1173,23,'DO','Donga'),
(1174,23,'KO','Kouffo'),
(1175,23,'LI','Littoral'),
(1176,23,'MO','Mono'),
(1177,23,'OU','Oueme'),
(1178,23,'PL','Plateau'),
(1179,23,'ZO','Zou'),
(1180,24,'DS','Devonshire'),
(1181,24,'HC','Hamilton City'),
(1182,24,'HA','Hamilton'),
(1183,24,'PG','Paget'),
(1184,24,'PB','Pembroke'),
(1185,24,'GC','Saint George City'),
(1186,24,'SG','Saint Georges'),
(1187,24,'SA','Sandys'),
(1188,24,'SM','Smiths'),
(1189,24,'SH','Southampton'),
(1190,24,'WA','Warwick'),
(1191,25,'BUM','Bumthang');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1192,25,'CHU','Chukha'),
(1193,25,'DAG','Dagana'),
(1194,25,'GAS','Gasa'),
(1195,25,'HAA','Haa'),
(1196,25,'LHU','Lhuntse'),
(1197,25,'MON','Mongar'),
(1198,25,'PAR','Paro'),
(1199,25,'PEM','Pemagatshel'),
(1200,25,'PUN','Punakha'),
(1201,25,'SJO','Samdrup Jongkhar'),
(1202,25,'SAT','Samtse'),
(1203,25,'SAR','Sarpang'),
(1204,25,'THI','Thimphu'),
(1205,25,'TRG','Trashigang'),
(1206,25,'TRY','Trashiyangste'),
(1207,25,'TRO','Trongsa'),
(1208,25,'TSI','Tsirang'),
(1209,25,'WPH','Wangdue Phodrang'),
(1210,25,'ZHE','Zhemgang'),
(1211,26,'BEN','Beni');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1212,26,'CHU','Chuquisaca'),
(1213,26,'COC','Cochabamba'),
(1214,26,'LPZ','La Paz'),
(1215,26,'ORU','Oruro'),
(1216,26,'PAN','Pando'),
(1217,26,'POT','Potosi'),
(1218,26,'SCZ','Santa Cruz'),
(1219,26,'TAR','Tarija'),
(1220,27,'BRO','Brcko district'),
(1221,27,'FUS','Unsko-Sanski Kanton'),
(1222,27,'FPO','Posavski Kanton'),
(1223,27,'FTU','Tuzlanski Kanton'),
(1224,27,'FZE','Zenicko-Dobojski Kanton'),
(1225,27,'FBP','Bosanskopodrinjski Kanton'),
(1226,27,'FSB','Srednjebosanski Kanton'),
(1227,27,'FHN','Hercegovacko-neretvanski Kanton'),
(1228,27,'FZH','Zapadnohercegovacka Zupanija'),
(1229,27,'FSA','Kanton Sarajevo'),
(1230,27,'FZA','Zapadnobosanska'),
(1231,27,'SBL','Banja Luka');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1232,27,'SDO','Doboj'),
(1233,27,'SBI','Bijeljina'),
(1234,27,'SVL','Vlasenica'),
(1235,27,'SSR','Sarajevo-Romanija or Sokolac'),
(1236,27,'SFO','Foca'),
(1237,27,'STR','Trebinje'),
(1238,28,'CE','Central'),
(1239,28,'GH','Ghanzi'),
(1240,28,'KD','Kgalagadi'),
(1241,28,'KT','Kgatleng'),
(1242,28,'KW','Kweneng'),
(1243,28,'NG','Ngamiland'),
(1244,28,'NE','North East'),
(1245,28,'NW','North West'),
(1246,28,'SE','South East'),
(1247,28,'SO','Southern'),
(1248,30,'AC','Acre'),
(1249,30,'AL','Alagoas'),
(1250,30,'AP','Amapa'),
(1251,30,'AM','Amazonas');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1252,30,'BA','Bahia'),
(1253,30,'CE','Ceara'),
(1254,30,'DF','Distrito Federal'),
(1255,30,'ES','Espirito Santo'),
(1256,30,'GO','Goias'),
(1257,30,'MA','Maranhao'),
(1258,30,'MT','Mato Grosso'),
(1259,30,'MS','Mato Grosso do Sul'),
(1260,30,'MG','Minas Gerais'),
(1261,30,'PA','Para'),
(1262,30,'PB','Paraiba'),
(1263,30,'PR','Parana'),
(1264,30,'PE','Pernambuco'),
(1265,30,'PI','Piaui'),
(1266,30,'RJ','Rio de Janeiro'),
(1267,30,'RN','Rio Grande do Norte'),
(1268,30,'RS','Rio Grande do Sul'),
(1269,30,'RO','Rondonia'),
(1270,30,'RR','Roraima'),
(1271,30,'SC','Santa Catarina');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1272,30,'SP','Sao Paulo'),
(1273,30,'SE','Sergipe'),
(1274,30,'TO','Tocantins'),
(1275,31,'PB','Peros Banhos'),
(1276,31,'SI','Salomon Islands'),
(1277,31,'NI','Nelsons Island'),
(1278,31,'TB','Three Brothers'),
(1279,31,'EA','Eagle Islands'),
(1280,31,'DI','Danger Island'),
(1281,31,'EG','Egmont Islands'),
(1282,31,'DG','Diego Garcia'),
(1283,32,'BEL','Belait'),
(1284,32,'BRM','Brunei and Muara'),
(1285,32,'TEM','Temburong'),
(1286,32,'TUT','Tutong'),
(1287,33,'','Blagoevgrad'),
(1288,33,'','Burgas'),
(1289,33,'','Dobrich'),
(1290,33,'','Gabrovo'),
(1291,33,'','Haskovo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1292,33,'','Kardjali'),
(1293,33,'','Kyustendil'),
(1294,33,'','Lovech'),
(1295,33,'','Montana'),
(1296,33,'','Pazardjik'),
(1297,33,'','Pernik'),
(1298,33,'','Pleven'),
(1299,33,'','Plovdiv'),
(1300,33,'','Razgrad'),
(1301,33,'','Shumen'),
(1302,33,'','Silistra'),
(1303,33,'','Sliven'),
(1304,33,'','Smolyan'),
(1305,33,'','Sofia'),
(1306,33,'','Sofia - town'),
(1307,33,'','Stara Zagora'),
(1308,33,'','Targovishte'),
(1309,33,'','Varna'),
(1310,33,'','Veliko Tarnovo'),
(1311,33,'','Vidin');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1312,33,'','Vratza'),
(1313,33,'','Yambol'),
(1314,34,'BAL','Bale'),
(1315,34,'BAM','Bam'),
(1316,34,'BAN','Banwa'),
(1317,34,'BAZ','Bazega'),
(1318,34,'BOR','Bougouriba'),
(1319,34,'BLG','Boulgou'),
(1320,34,'BOK','Boulkiemde'),
(1321,34,'COM','Comoe'),
(1322,34,'GAN','Ganzourgou'),
(1323,34,'GNA','Gnagna'),
(1324,34,'GOU','Gourma'),
(1325,34,'HOU','Houet'),
(1326,34,'IOA','Ioba'),
(1327,34,'KAD','Kadiogo'),
(1328,34,'KEN','Kenedougou'),
(1329,34,'KOD','Komondjari'),
(1330,34,'KOP','Kompienga'),
(1331,34,'KOS','Kossi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1332,34,'KOL','Koulpelogo'),
(1333,34,'KOT','Kouritenga'),
(1334,34,'KOW','Kourweogo'),
(1335,34,'LER','Leraba'),
(1336,34,'LOR','Loroum'),
(1337,34,'MOU','Mouhoun'),
(1338,34,'NAH','Nahouri'),
(1339,34,'NAM','Namentenga'),
(1340,34,'NAY','Nayala'),
(1341,34,'NOU','Noumbiel'),
(1342,34,'OUB','Oubritenga'),
(1343,34,'OUD','Oudalan'),
(1344,34,'PAS','Passore'),
(1345,34,'PON','Poni'),
(1346,34,'SAG','Sanguie'),
(1347,34,'SAM','Sanmatenga'),
(1348,34,'SEN','Seno'),
(1349,34,'SIS','Sissili'),
(1350,34,'SOM','Soum'),
(1351,34,'SOR','Sourou');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1352,34,'TAP','Tapoa'),
(1353,34,'TUY','Tuy'),
(1354,34,'YAG','Yagha'),
(1355,34,'YAT','Yatenga'),
(1356,34,'ZIR','Ziro'),
(1357,34,'ZOD','Zondoma'),
(1358,34,'ZOW','Zoundweogo'),
(1359,35,'BB','Bubanza'),
(1360,35,'BJ','Bujumbura'),
(1361,35,'BR','Bururi'),
(1362,35,'CA','Cankuzo'),
(1363,35,'CI','Cibitoke'),
(1364,35,'GI','Gitega'),
(1365,35,'KR','Karuzi'),
(1366,35,'KY','Kayanza'),
(1367,35,'KI','Kirundo'),
(1368,35,'MA','Makamba'),
(1369,35,'MU','Muramvya'),
(1370,35,'MY','Muyinga'),
(1371,35,'MW','Mwaro');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1372,35,'NG','Ngozi'),
(1373,35,'RT','Rutana'),
(1374,35,'RY','Ruyigi'),
(1375,36,'PP','Phnom Penh'),
(1376,36,'PS','Preah Seihanu (Kompong Som or Si'),
(1377,36,'PA','Pailin'),
(1378,36,'KB','Keb'),
(1379,36,'BM','Banteay Meanchey'),
(1380,36,'BA','Battambang'),
(1381,36,'KM','Kampong Cham'),
(1382,36,'KN','Kampong Chhnang'),
(1383,36,'KU','Kampong Speu'),
(1384,36,'KO','Kampong Som'),
(1385,36,'KT','Kampong Thom'),
(1386,36,'KP','Kampot'),
(1387,36,'KL','Kandal'),
(1388,36,'KK','Kaoh Kong'),
(1389,36,'KR','Kratie'),
(1390,36,'MK','Mondul Kiri'),
(1391,36,'OM','Oddar Meancheay');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1392,36,'PU','Pursat'),
(1393,36,'PR','Preah Vihear'),
(1394,36,'PG','Prey Veng'),
(1395,36,'RK','Ratanak Kiri'),
(1396,36,'SI','Siemreap'),
(1397,36,'ST','Stung Treng'),
(1398,36,'SR','Svay Rieng'),
(1399,36,'TK','Takeo'),
(1400,37,'ADA','Adamawa (Adamaoua)'),
(1401,37,'CEN','Centre'),
(1402,37,'EST','East (Est)'),
(1403,37,'EXN','Extreme North (Extr?me-Nord)'),
(1404,37,'LIT','Littoral'),
(1405,37,'NOR','North (Nord)'),
(1406,37,'NOT','Northwest (Nord-Ouest)'),
(1407,37,'OUE','West (Ouest)'),
(1408,37,'SUD','South (Sud)'),
(1409,37,'SOU','Southwest (Sud-Ouest).'),
(1410,38,'AB','Alberta'),
(1411,38,'BC','British Columbia');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1412,38,'MB','Manitoba'),
(1413,38,'NB','New Brunswick'),
(1414,38,'NL','Newfoundland and Labrador'),
(1415,38,'NT','Northwest Territories'),
(1416,38,'NS','Nova Scotia'),
(1417,38,'NU','Nunavut'),
(1418,38,'ON','Ontario'),
(1419,38,'PE','Prince Edward Island'),
(1420,38,'QC','Qu&eacute;bec'),
(1421,38,'SK','Saskatchewan'),
(1422,38,'YT','Yukon Territory'),
(1423,39,'BV','Boa Vista'),
(1424,39,'BR','Brava'),
(1425,39,'CS','Calheta de Sao Miguel'),
(1426,39,'MA','Maio'),
(1427,39,'MO','Mosteiros'),
(1428,39,'PA','Paul'),
(1429,39,'PN','Porto Novo'),
(1430,39,'PR','Praia'),
(1431,39,'RG','Ribeira Grande');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1432,39,'SL','Sal'),
(1433,39,'CA','Santa Catarina'),
(1434,39,'CR','Santa Cruz'),
(1435,39,'SD','Sao Domingos'),
(1436,39,'SF','Sao Filipe'),
(1437,39,'SN','Sao Nicolau'),
(1438,39,'SV','Sao Vicente'),
(1439,39,'TA','Tarrafal'),
(1440,40,'CR','Creek'),
(1441,40,'EA','Eastern'),
(1442,40,'ML','Midland'),
(1443,40,'ST','South Town'),
(1444,40,'SP','Spot Bay'),
(1445,40,'SK','Stake Bay'),
(1446,40,'WD','West End '),
(1447,40,'WN','Western'),
(1448,41,'BBA','Bamingui-Bangoran'),
(1449,41,'BKO','Basse-Kotto'),
(1450,41,'HKO','Haute-Kotto'),
(1451,41,'HMB','Haut-Mbomou');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1452,41,'KEM','Kemo'),
(1453,41,'LOB','Lobaye'),
(1454,41,'MKD','Mambere-Kade?'),
(1455,41,'MBO','Mbomou'),
(1456,41,'NMM','Nana-Mambere'),
(1457,41,'OMP','Ombella-MPoko'),
(1458,41,'OUK','Ouaka'),
(1459,41,'OUH','Ouham'),
(1460,41,'OPE','Ouham-Pende'),
(1461,41,'VAK','Vakaga'),
(1462,41,'NGR','Nana-Grebizi'),
(1463,41,'SMB','Sangha-Mbaere'),
(1464,41,'BAN','Bangui'),
(1465,42,'BA','Batha'),
(1466,42,'BI','Biltine'),
(1467,42,'BE','Borkou-Ennedi-Tibesti'),
(1468,42,'CB','Chari-Baguirmi'),
(1469,42,'GU','Guera'),
(1470,42,'KA','Kanem'),
(1471,42,'LA','Lac');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1472,42,'LC','Logone Occidental'),
(1473,42,'LR','Logone Oriental'),
(1474,42,'MK','Mayo-Kebbi'),
(1475,42,'MC','Moyen-Chari'),
(1476,42,'OU','Ouaddai'),
(1477,42,'SA','Salamat'),
(1478,42,'TA','Tandjile'),
(1479,43,'AI','Aisen del General Carlos Ibanez '),
(1480,43,'AN','Antofagasta'),
(1481,43,'AR','Araucania'),
(1482,43,'AT','Atacama'),
(1483,43,'BI','Bio-Bio'),
(1484,43,'CO','Coquimbo'),
(1485,43,'LI','Libertador General Bernardo O Hi'),
(1486,43,'LL','Los Lagos'),
(1487,43,'MA','Magallanes y de la Antartica Chi'),
(1488,43,'ML','Maule'),
(1489,43,'RM','Region Metropolitana'),
(1490,43,'TA','Tarapaca'),
(1491,43,'VS','Valparaiso');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1492,44,'AN','Anhui'),
(1493,44,'BE','Beijing'),
(1494,44,'CH','Chongqing'),
(1495,44,'FU','Fujian'),
(1496,44,'GA','Gansu'),
(1497,44,'GU','Guangdong'),
(1498,44,'GX','Guangxi'),
(1499,44,'GZ','Guizhou'),
(1500,44,'HA','Hainan'),
(1501,44,'HB','Hebei'),
(1502,44,'HL','Heilongjiang'),
(1503,44,'HE','Henan'),
(1504,44,'HK','Hong Kong'),
(1505,44,'HU','Hubei'),
(1506,44,'HN','Hunan'),
(1507,44,'IM','Inner Mongolia'),
(1508,44,'JI','Jiangsu'),
(1509,44,'JX','Jiangxi'),
(1510,44,'JL','Jilin'),
(1511,44,'LI','Liaoning');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1512,44,'MA','Macau'),
(1513,44,'NI','Ningxia'),
(1514,44,'SH','Shaanxi'),
(1515,44,'SA','Shandong'),
(1516,44,'SG','Shanghai'),
(1517,44,'SX','Shanxi'),
(1518,44,'SI','Sichuan'),
(1519,44,'TI','Tianjin'),
(1520,44,'XI','Xinjiang'),
(1521,44,'YU','Yunnan'),
(1522,44,'ZH','Zhejiang'),
(1523,46,'D','Direction Island'),
(1524,46,'H','Home Island'),
(1525,46,'O','Horsburgh Island'),
(1526,46,'S','South Island'),
(1527,46,'W','West Island'),
(1528,47,'AMZ','Amazonas'),
(1529,47,'ANT','Antioquia'),
(1530,47,'ARA','Arauca'),
(1531,47,'ATL','Atlantico');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1532,47,'BDC','Bogota D.C.'),
(1533,47,'BOL','Bolivar'),
(1534,47,'BOY','Boyaca'),
(1535,47,'CAL','Caldas'),
(1536,47,'CAQ','Caqueta'),
(1537,47,'CAS','Casanare'),
(1538,47,'CAU','Cauca'),
(1539,47,'CES','Cesar'),
(1540,47,'CHO','Choco'),
(1541,47,'COR','Cordoba'),
(1542,47,'CAM','Cundinamarca'),
(1543,47,'GNA','Guainia'),
(1544,47,'GJR','Guajira'),
(1545,47,'GVR','Guaviare'),
(1546,47,'HUI','Huila'),
(1547,47,'MAG','Magdalena'),
(1548,47,'MET','Meta'),
(1549,47,'NAR','Narino'),
(1550,47,'NDS','Norte de Santander'),
(1551,47,'PUT','Putumayo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1552,47,'QUI','Quindio'),
(1553,47,'RIS','Risaralda'),
(1554,47,'SAP','San Andres y Providencia'),
(1555,47,'SAN','Santander'),
(1556,47,'SUC','Sucre'),
(1557,47,'TOL','Tolima'),
(1558,47,'VDC','Valle del Cauca'),
(1559,47,'VAU','Vaupes'),
(1560,47,'VIC','Vichada'),
(1561,48,'G','Grande Comore'),
(1562,48,'A','Anjouan'),
(1563,48,'M','Moheli'),
(1564,49,'BO','Bouenza'),
(1565,49,'BR','Brazzaville'),
(1566,49,'CU','Cuvette'),
(1567,49,'CO','Cuvette-Ouest'),
(1568,49,'KO','Kouilou'),
(1569,49,'LE','Lekoumou'),
(1570,49,'LI','Likouala'),
(1571,49,'NI','Niari');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1572,49,'PL','Plateaux'),
(1573,49,'PO','Pool '),
(1574,49,'SA','Sangha'),
(1575,50,'PU','Pukapuka'),
(1576,50,'RK','Rakahanga'),
(1577,50,'MK','Manihiki'),
(1578,50,'PE','Penrhyn'),
(1579,50,'NI','Nassau Island'),
(1580,50,'SU','Surwarrow'),
(1581,50,'PA','Palmerston'),
(1582,50,'AI','Aitutaki'),
(1583,50,'MA','Manuae'),
(1584,50,'TA','Takutea'),
(1585,50,'MT','Mitiaro'),
(1586,50,'AT','Atiu'),
(1587,50,'MU','Mauke'),
(1588,50,'RR','Rarotonga'),
(1589,50,'MG','Mangaia'),
(1590,51,'AL','Alajuela'),
(1591,51,'CA','Cartago');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1592,51,'GU','Guanacaste'),
(1593,51,'HE','Heredia'),
(1594,51,'LI','Limon'),
(1595,51,'PU','Puntarenas'),
(1596,51,'SJ','San Jose'),
(1597,52,'ABE','Abengourou'),
(1598,52,'ABI','Abidjan'),
(1599,52,'ABO','Aboisso'),
(1600,52,'ADI','Adiake'),
(1601,52,'ADZ','Adzope'),
(1602,52,'AGB','Agboville'),
(1603,52,'AGN','Agnibilekrou'),
(1604,52,'ALE','Alepe'),
(1605,52,'BOC','Bocanda'),
(1606,52,'BAN','Bangolo'),
(1607,52,'BEO','Beoumi'),
(1608,52,'BIA','Biankouma'),
(1609,52,'BDK','Bondoukou'),
(1610,52,'BGN','Bongouanou'),
(1611,52,'BFL','Bouafle');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1612,52,'BKE','Bouake'),
(1613,52,'BNA','Bouna'),
(1614,52,'BDL','Boundiali'),
(1615,52,'DKL','Dabakala'),
(1616,52,'DBU','Dabou'),
(1617,52,'DAL','Daloa'),
(1618,52,'DAN','Danane'),
(1619,52,'DAO','Daoukro'),
(1620,52,'DIM','Dimbokro'),
(1621,52,'DIV','Divo'),
(1622,52,'DUE','Duekoue'),
(1623,52,'FER','Ferkessedougou'),
(1624,52,'GAG','Gagnoa'),
(1625,52,'GBA','Grand-Bassam'),
(1626,52,'GLA','Grand-Lahou'),
(1627,52,'GUI','Guiglo'),
(1628,52,'ISS','Issia'),
(1629,52,'JAC','Jacqueville'),
(1630,52,'KAT','Katiola'),
(1631,52,'KOR','Korhogo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1632,52,'LAK','Lakota'),
(1633,52,'MAN','Man'),
(1634,52,'MKN','Mankono'),
(1635,52,'MBA','Mbahiakro'),
(1636,52,'ODI','Odienne'),
(1637,52,'OUM','Oume'),
(1638,52,'SAK','Sakassou'),
(1639,52,'SPE','San-Pedro'),
(1640,52,'SAS','Sassandra'),
(1641,52,'SEG','Seguela'),
(1642,52,'SIN','Sinfra'),
(1643,52,'SOU','Soubre'),
(1644,52,'TAB','Tabou'),
(1645,52,'TAN','Tanda'),
(1646,52,'TIE','Tiebissou'),
(1647,52,'TIN','Tingrela'),
(1648,52,'TIA','Tiassale'),
(1649,52,'TBA','Touba'),
(1650,52,'TLP','Toulepleu'),
(1651,52,'TMD','Toumodi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1652,52,'VAV','Vavoua'),
(1653,52,'YAM','Yamoussoukro'),
(1654,52,'ZUE','Zuenoula'),
(1655,53,'BB','Bjelovar-Bilogora'),
(1656,53,'CZ','City of Zagreb'),
(1657,53,'DN','Dubrovnik-Neretva'),
(1658,53,'IS','Istra'),
(1659,53,'KA','Karlovac'),
(1660,53,'KK','Koprivnica-Krizevci'),
(1661,53,'KZ','Krapina-Zagorje'),
(1662,53,'LS','Lika-Senj'),
(1663,53,'ME','Medimurje'),
(1664,53,'OB','Osijek-Baranja'),
(1665,53,'PS','Pozega-Slavonia'),
(1666,53,'PG','Primorje-Gorski Kotar'),
(1667,53,'SI','Sibenik'),
(1668,53,'SM','Sisak-Moslavina'),
(1669,53,'SB','Slavonski Brod-Posavina'),
(1670,53,'SD','Split-Dalmatia'),
(1671,53,'VA','Varazdin');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1672,53,'VP','Virovitica-Podravina'),
(1673,53,'VS','Vukovar-Srijem'),
(1674,53,'ZK','Zadar-Knin'),
(1675,53,'ZA','Zagreb'),
(1676,54,'CA','Camaguey'),
(1677,54,'CD','Ciego de Avila'),
(1678,54,'CI','Cienfuegos'),
(1679,54,'CH','Ciudad de La Habana'),
(1680,54,'GR','Granma'),
(1681,54,'GU','Guantanamo'),
(1682,54,'HO','Holguin'),
(1683,54,'IJ','Isla de la Juventud'),
(1684,54,'LH','La Habana'),
(1685,54,'LT','Las Tunas'),
(1686,54,'MA','Matanzas'),
(1687,54,'PR','Pinar del Rio'),
(1688,54,'SS','Sancti Spiritus'),
(1689,54,'SC','Santiago de Cuba'),
(1690,54,'VC','Villa Clara'),
(1691,55,'F','Famagusta');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1692,55,'K','Kyrenia'),
(1693,55,'A','Larnaca'),
(1694,55,'I','Limassol'),
(1695,55,'N','Nicosia'),
(1696,55,'P','Paphos'),
(1697,56,'U','Ustecky'),
(1698,56,'C','Jihocesky'),
(1699,56,'B','Jihomoravsky'),
(1700,56,'K','Karlovarsky'),
(1701,56,'H','Kralovehradecky'),
(1702,56,'L','Liberecky'),
(1703,56,'T','Moravskoslezsky'),
(1704,56,'M','Olomoucky'),
(1705,56,'E','Pardubicky'),
(1706,56,'P','Plzensky'),
(1707,56,'A','Praha'),
(1708,56,'S','Stredocesky'),
(1709,56,'J','Vysocina'),
(1710,56,'Z','Zlinsky'),
(1711,57,'AR','Arhus');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1712,57,'BH','Bornholm'),
(1713,57,'CO','Copenhagen'),
(1714,57,'FO','Faroe Islands'),
(1715,57,'FR','Frederiksborg'),
(1716,57,'FY','Fyn'),
(1717,57,'KO','Kobenhavn'),
(1718,57,'NO','Nordjylland'),
(1719,57,'RI','Ribe'),
(1720,57,'RK','Ringkobing'),
(1721,57,'RO','Roskilde'),
(1722,57,'SO','Sonderjylland'),
(1723,57,'ST','Storstrom'),
(1724,57,'VK','Vejle'),
(1725,57,'VJ','Vestj&aelig;lland'),
(1726,57,'VB','Viborg'),
(1727,58,'S','Ali Sabih'),
(1728,58,'K','Dikhil'),
(1729,58,'J','Djibouti'),
(1730,58,'O','Obock'),
(1731,58,'T','Tadjoura');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1732,59,'AND','Saint Andrew Parish'),
(1733,59,'DAV','Saint David Parish'),
(1734,59,'GEO','Saint George Parish'),
(1735,59,'JOH','Saint John Parish'),
(1736,59,'JOS','Saint Joseph Parish'),
(1737,59,'LUK','Saint Luke Parish'),
(1738,59,'MAR','Saint Mark Parish'),
(1739,59,'PAT','Saint Patrick Parish'),
(1740,59,'PAU','Saint Paul Parish'),
(1741,59,'PET','Saint Peter Parish'),
(1742,60,'DN','Distrito Nacional'),
(1743,60,'AZ','Azua'),
(1744,60,'BC','Baoruco'),
(1745,60,'BH','Barahona'),
(1746,60,'DJ','Dajabon'),
(1747,60,'DU','Duarte'),
(1748,60,'EL','Elias Pina'),
(1749,60,'SY','El Seybo'),
(1750,60,'ET','Espaillat'),
(1751,60,'HM','Hato Mayor');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1752,60,'IN','Independencia'),
(1753,60,'AL','La Altagracia'),
(1754,60,'RO','La Romana'),
(1755,60,'VE','La Vega'),
(1756,60,'MT','Maria Trinidad Sanchez'),
(1757,60,'MN','Monsenor Nouel'),
(1758,60,'MC','Monte Cristi'),
(1759,60,'MP','Monte Plata'),
(1760,60,'PD','Pedernales'),
(1761,60,'PR','Peravia (Bani)'),
(1762,60,'PP','Puerto Plata'),
(1763,60,'SL','Salcedo'),
(1764,60,'SM','Samana'),
(1765,60,'SH','Sanchez Ramirez'),
(1766,60,'SC','San Cristobal'),
(1767,60,'JO','San Jose de Ocoa'),
(1768,60,'SJ','San Juan'),
(1769,60,'PM','San Pedro de Macoris'),
(1770,60,'SA','Santiago'),
(1771,60,'ST','Santiago Rodriguez');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1772,60,'SD','Santo Domingo'),
(1773,60,'VA','Valverde'),
(1774,61,'AL','Aileu'),
(1775,61,'AN','Ainaro'),
(1776,61,'BA','Baucau'),
(1777,61,'BO','Bobonaro'),
(1778,61,'CO','Cova Lima'),
(1779,61,'DI','Dili'),
(1780,61,'ER','Ermera'),
(1781,61,'LA','Lautem'),
(1782,61,'LI','Liquica'),
(1783,61,'MT','Manatuto'),
(1784,61,'MF','Manufahi'),
(1785,61,'OE','Oecussi'),
(1786,61,'VI','Viqueque'),
(1787,62,'AZU','Azuay'),
(1788,62,'BOL','Bolivar'),
(1789,62,'CAN','Ca&ntilde;ar'),
(1790,62,'CAR','Carchi'),
(1791,62,'CHI','Chimborazo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1792,62,'COT','Cotopaxi'),
(1793,62,'EOR','El Oro'),
(1794,62,'ESM','Esmeraldas'),
(1795,62,'GPS','Gal&aacute;pagos'),
(1796,62,'GUA','Guayas'),
(1797,62,'IMB','Imbabura'),
(1798,62,'LOJ','Loja'),
(1799,62,'LRO','Los Ríos'),
(1800,62,'MAN','Manab&iacute;'),
(1801,62,'MSA','Morona Santiago'),
(1802,62,'NAP','Napo'),
(1803,62,'ORE','Orellana'),
(1804,62,'PAS','Pastaza'),
(1805,62,'PIC','Pichincha'),
(1806,62,'SUC','Sucumb&iacute;os'),
(1807,62,'TUN','Tungurahua'),
(1808,62,'ZCH','Zamora Chinchipe'),
(1809,63,'DHY','Ad Daqahliyah'),
(1810,63,'BAM','Al Bahr al Ahmar'),
(1811,63,'BHY','Al Buhayrah');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1812,63,'FYM','Al Fayyum'),
(1813,63,'GBY','Al Gharbiyah'),
(1814,63,'IDR','Al Iskandariyah'),
(1815,63,'IML','Al Ismailiyah'),
(1816,63,'JZH','Al Jizah'),
(1817,63,'MFY','Al Minufiyah'),
(1818,63,'MNY','Al Minya'),
(1819,63,'QHR','Al Qahirah'),
(1820,63,'QLY','Al Qalyubiyah'),
(1821,63,'WJD','Al Wadi al Jadid'),
(1822,63,'SHQ','Ash Sharqiyah'),
(1823,63,'SWY','As Suways'),
(1824,63,'ASW','Aswan'),
(1825,63,'ASY','Asyut'),
(1826,63,'BSW','Bani Suwayf'),
(1827,63,'BSD','Bur Said'),
(1828,63,'DMY','Dumyat'),
(1829,63,'JNS','Janub Sina'),
(1830,63,'KSH','Kafr ash Shaykh'),
(1831,63,'MAT','Matruh');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1832,63,'QIN','Qina'),
(1833,63,'SHS','Shamal Sina'),
(1834,63,'SUH','Suhaj'),
(1835,64,'AH','Ahuachapan'),
(1836,64,'CA','Cabanas'),
(1837,64,'CH','Chalatenango'),
(1838,64,'CU','Cuscatlan'),
(1839,64,'LB','La Libertad'),
(1840,64,'PZ','La Paz'),
(1841,64,'UN','La Union'),
(1842,64,'MO','Morazan'),
(1843,64,'SM','San Miguel'),
(1844,64,'SS','San Salvador'),
(1845,64,'SV','San Vicente'),
(1846,64,'SA','Santa Ana'),
(1847,64,'SO','Sonsonate'),
(1848,64,'US','Usulutan'),
(1849,65,'AN','Provincia Annobon'),
(1850,65,'BN','Provincia Bioko Norte'),
(1851,65,'BS','Provincia Bioko Sur');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1852,65,'CS','Provincia Centro Sur'),
(1853,65,'KN','Provincia Kie-Ntem'),
(1854,65,'LI','Provincia Litoral'),
(1855,65,'WN','Provincia Wele-Nzas'),
(1856,66,'MA','Central (Maekel)'),
(1857,66,'KE','Anseba (Keren)'),
(1858,66,'DK','Southern Red Sea (Debub-Keih-Bah'),
(1859,66,'SK','Northern Red Sea (Semien-Keih-Ba'),
(1860,66,'DE','Southern (Debub)'),
(1861,66,'BR','Gash-Barka (Barentu)'),
(1862,67,'HA','Harjumaa (Tallinn)'),
(1863,67,'HI','Hiiumaa (Kardla)'),
(1864,67,'IV','Ida-Virumaa (Johvi)'),
(1865,67,'JA','Jarvamaa (Paide)'),
(1866,67,'JO','Jogevamaa (Jogeva)'),
(1867,67,'LV','Laane-Virumaa (Rakvere)'),
(1868,67,'LA','Laanemaa (Haapsalu)'),
(1869,67,'PA','Parnumaa (Parnu)'),
(1870,67,'PO','Polvamaa (Polva)'),
(1871,67,'RA','Raplamaa (Rapla)');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1872,67,'SA','Saaremaa (Kuessaare)'),
(1873,67,'TA','Tartumaa (Tartu)'),
(1874,67,'VA','Valgamaa (Valga)'),
(1875,67,'VI','Viljandimaa (Viljandi)'),
(1876,67,'VO','Vorumaa (Voru)'),
(1877,68,'AF','Afar'),
(1878,68,'AH','Amhara'),
(1879,68,'BG','Benishangul-Gumaz'),
(1880,68,'GB','Gambela'),
(1881,68,'HR','Hariai'),
(1882,68,'OR','Oromia'),
(1883,68,'SM','Somali'),
(1884,68,'SN','Southern Nations - Nationalities'),
(1885,68,'TG','Tigray'),
(1886,68,'AA','Addis Ababa'),
(1887,68,'DD','Dire Dawa'),
(1888,71,'C','Central Division'),
(1889,71,'N','Northern Division'),
(1890,71,'E','Eastern Division'),
(1891,71,'W','Western Division');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1892,71,'R','Rotuma'),
(1893,72,'AL','Ahvenanmaan Laani'),
(1894,72,'ES','Etela-Suomen Laani'),
(1895,72,'IS','Ita-Suomen Laani'),
(1896,72,'LS','Lansi-Suomen Laani'),
(1897,72,'LA','Lapin Lanani'),
(1898,72,'OU','Oulun Laani'),
(1899,73,'AL','Alsace'),
(1900,73,'AQ','Aquitaine'),
(1901,73,'AU','Auvergne'),
(1902,73,'BR','Brittany'),
(1903,73,'BU','Burgundy'),
(1904,73,'CE','Center Loire Valley'),
(1905,73,'CH','Champagne'),
(1906,73,'CO','Corse'),
(1907,73,'FR','France Comte'),
(1908,73,'LA','Languedoc Roussillon'),
(1909,73,'LI','Limousin'),
(1910,73,'LO','Lorraine'),
(1911,73,'MI','Midi Pyrenees');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1912,73,'NO','Nord Pas de Calais'),
(1913,73,'NR','Normandy'),
(1914,73,'PA','Paris / Ill de France'),
(1915,73,'PI','Picardie'),
(1916,73,'PO','Poitou Charente'),
(1917,73,'PR','Provence'),
(1918,73,'RH','Rhone Alps'),
(1919,73,'RI','Riviera'),
(1920,73,'WE','Western Loire Valley'),
(1921,74,'Et','Etranger'),
(1922,74,'01','Ain'),
(1923,74,'02','Aisne'),
(1924,74,'03','Allier'),
(1925,74,'04','Alpes de Haute Provence'),
(1926,74,'05','Hautes-Alpes'),
(1927,74,'06','Alpes Maritimes'),
(1928,74,'07','Ard&egrave;che'),
(1929,74,'08','Ardennes'),
(1930,74,'09','Ari&egrave;ge'),
(1931,74,'10','Aube');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1932,74,'11','Aude'),
(1933,74,'12','Aveyron'),
(1934,74,'13','Bouches du Rh&ocirc;ne'),
(1935,74,'14','Calvados'),
(1936,74,'15','Cantal'),
(1937,74,'16','Charente'),
(1938,74,'17','Charente Maritime'),
(1939,74,'18','Cher'),
(1940,74,'19','Corr&egrave;ze'),
(1941,74,'2A','Corse du Sud'),
(1942,74,'2B','Haute Corse'),
(1943,74,'21','C&ocirc;te dor'),
(1944,74,'22','C&ocirc;tes dArmor'),
(1945,74,'23','Creuse'),
(1946,74,'24','Dordogne'),
(1947,74,'25','Doubs'),
(1948,74,'26','Dr&ocirc;me'),
(1949,74,'27','Eure'),
(1950,74,'28','Eure et Loir'),
(1951,74,'29','Finist&egrave;re');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1952,74,'30','Gard'),
(1953,74,'31','Haute Garonne'),
(1954,74,'32','Gers'),
(1955,74,'33','Gironde'),
(1956,74,'34','H&eacute;rault'),
(1957,74,'35','Ille et Vilaine'),
(1958,74,'36','Indre'),
(1959,74,'37','Indre et Loire'),
(1960,74,'38','Is&eacute;re'),
(1961,74,'39','Jura'),
(1962,74,'40','Landes'),
(1963,74,'41','Loir et Cher'),
(1964,74,'42','Loire'),
(1965,74,'43','Haute Loire'),
(1966,74,'44','Loire Atlantique'),
(1967,74,'45','Loiret'),
(1968,74,'46','Lot'),
(1969,74,'47','Lot et Garonne'),
(1970,74,'48','Loz&egrave;re'),
(1971,74,'49','Maine et Loire');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1972,74,'50','Manche'),
(1973,74,'51','Marne'),
(1974,74,'52','Haute Marne'),
(1975,74,'53','Mayenne'),
(1976,74,'54','Meurthe et Moselle'),
(1977,74,'55','Meuse'),
(1978,74,'56','Morbihan'),
(1979,74,'57','Moselle'),
(1980,74,'58','Ni&egrave;vre'),
(1981,74,'59','Nord'),
(1982,74,'60','Oise'),
(1983,74,'61','Orne'),
(1984,74,'62','Pas de Calais'),
(1985,74,'63','Puy de D&ocirc;me'),
(1986,74,'64','Pyr&eacute;n&eacute;es Atlantiqu'),
(1987,74,'65','Hautes Pyr&eacute;n&eacute;es'),
(1988,74,'66','Pyr&eacute;n&eacute;es Orientale'),
(1989,74,'67','Bas Rhin'),
(1990,74,'68','Haut Rhin'),
(1991,74,'69','Rh&ocirc;ne');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (1992,74,'70','Haute Sa&ocirc;ne'),
(1993,74,'71','Sa&ocirc;ne et Loire'),
(1994,74,'72','Sarthe'),
(1995,74,'73','Savoie'),
(1996,74,'74','Haute Savoie'),
(1997,74,'75','Paris'),
(1998,74,'76','Seine Maritime'),
(1999,74,'77','Seine et Marne'),
(2000,74,'78','Yvelines'),
(2001,74,'79','Deux S&egrave;vres'),
(2002,74,'80','Somme'),
(2003,74,'81','Tarn'),
(2004,74,'82','Tarn et Garonne'),
(2005,74,'83','Var'),
(2006,74,'84','Vaucluse'),
(2007,74,'85','Vend&eacute;e'),
(2008,74,'86','Vienne'),
(2009,74,'87','Haute Vienne'),
(2010,74,'88','Vosges'),
(2011,74,'89','Yonne');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2012,74,'90','Territoire de Belfort'),
(2013,74,'91','Essonne'),
(2014,74,'92','Hauts de Seine'),
(2015,74,'93','Seine St-Denis'),
(2016,74,'94','Val de Marne'),
(2017,74,'95','Val dOise'),
(2018,76,'M','Archipel des Marquises'),
(2019,76,'T','Archipel des Tuamotu'),
(2020,76,'I','Archipel des Tubuai'),
(2021,76,'V','Iles du Vent'),
(2022,76,'S','Iles Sous-le-Vent '),
(2023,77,'C','Iles Crozet'),
(2024,77,'K','Iles Kerguelen'),
(2025,77,'A','Ile Amsterdam'),
(2026,77,'P','Ile Saint-Paul'),
(2027,77,'D','Adelie Land'),
(2028,78,'ES','Estuaire'),
(2029,78,'HO','Haut-Ogooue'),
(2030,78,'MO','Moyen-Ogooue'),
(2031,78,'NG','Ngounie');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2032,78,'NY','Nyanga'),
(2033,78,'OI','Ogooue-Ivindo'),
(2034,78,'OL','Ogooue-Lolo'),
(2035,78,'OM','Ogooue-Maritime'),
(2036,78,'WN','Woleu-Ntem'),
(2037,79,'BJ','Banjul'),
(2038,79,'BS','Basse'),
(2039,79,'BR','Brikama'),
(2040,79,'JA','Janjangbure'),
(2041,79,'KA','Kanifeng'),
(2042,79,'KE','Kerewan'),
(2043,79,'KU','Kuntaur'),
(2044,79,'MA','Mansakonko'),
(2045,79,'LR','Lower River'),
(2046,79,'CR','Central River'),
(2047,79,'NB','North Bank'),
(2048,79,'UR','Upper River'),
(2049,79,'WE','Western'),
(2050,80,'AB','Abkhazia'),
(2051,80,'AJ','Ajaria');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2052,80,'TB','Tbilisi'),
(2053,80,'GU','Guria'),
(2054,80,'IM','Imereti'),
(2055,80,'KA','Kakheti'),
(2056,80,'KK','Kvemo Kartli'),
(2057,80,'MM','Mtskheta-Mtianeti'),
(2058,80,'RL','Racha Lechkhumi and Kvemo Svanet'),
(2059,80,'SZ','Samegrelo-Zemo Svaneti'),
(2060,80,'SJ','Samtskhe-Javakheti'),
(2061,80,'SK','Shida Kartli'),
(2062,81,'BAW','Baden-W&uuml;rttemberg'),
(2063,81,'BAY','Bayern'),
(2064,81,'BER','Berlin'),
(2065,81,'BRG','Brandenburg'),
(2066,81,'BRE','Bremen'),
(2067,81,'HAM','Hamburg'),
(2068,81,'HES','Hessen'),
(2069,81,'MEC','Mecklenburg-Vorpommern'),
(2070,81,'NDS','Niedersachsen'),
(2071,81,'NRW','Nordrhein-Westfalen');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2072,81,'RHE','Rheinland-Pfalz'),
(2073,81,'SAR','Saarland'),
(2074,81,'SAS','Sachsen'),
(2075,81,'SAC','Sachsen-Anhalt'),
(2076,81,'SCN','Schleswig-Holstein'),
(2077,81,'THE','Th&uuml;ringen'),
(2078,82,'AS','Ashanti Region'),
(2079,82,'BA','Brong-Ahafo Region'),
(2080,82,'CE','Central Region'),
(2081,82,'EA','Eastern Region'),
(2082,82,'GA','Greater Accra Region'),
(2083,82,'NO','Northern Region'),
(2084,82,'UE','Upper East Region'),
(2085,82,'UW','Upper West Region'),
(2086,82,'VO','Volta Region'),
(2087,82,'WE','Western Region'),
(2088,84,'AT','Attica'),
(2089,84,'CN','Central Greece'),
(2090,84,'CM','Central Macedonia'),
(2091,84,'CR','Crete');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2092,84,'EM','East Macedonia and Thrace'),
(2093,84,'EP','Epirus'),
(2094,84,'II','Ionian Islands'),
(2095,84,'NA','North Aegean'),
(2096,84,'PP','Peloponnesos'),
(2097,84,'SA','South Aegean'),
(2098,84,'TH','Thessaly'),
(2099,84,'WG','West Greece'),
(2100,84,'WM','West Macedonia'),
(2101,85,'A','Avannaa'),
(2102,85,'T','Tunu '),
(2103,85,'K','Kitaa'),
(2104,86,'A','Saint Andrew'),
(2105,86,'D','Saint David'),
(2106,86,'G','Saint George'),
(2107,86,'J','Saint John'),
(2108,86,'M','Saint Mark'),
(2109,86,'P','Saint Patrick'),
(2110,86,'C','Carriacou'),
(2111,86,'Q','Petit Martinique');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2112,89,'AV','Alta Verapaz'),
(2113,89,'BV','Baja Verapaz'),
(2114,89,'CM','Chimaltenango'),
(2115,89,'CQ','Chiquimula'),
(2116,89,'PE','El Peten'),
(2117,89,'PR','El Progreso'),
(2118,89,'QC','El Quiche'),
(2119,89,'ES','Escuintla'),
(2120,89,'GU','Guatemala'),
(2121,89,'HU','Huehuetenango'),
(2122,89,'IZ','Izabal'),
(2123,89,'JA','Jalapa'),
(2124,89,'JU','Jutiapa'),
(2125,89,'QZ','Quetzaltenango'),
(2126,89,'RE','Retalhuleu'),
(2127,89,'ST','Sacatepequez'),
(2128,89,'SM','San Marcos'),
(2129,89,'SR','Santa Rosa'),
(2130,89,'SO','Solola'),
(2131,89,'SU','Suchitepequez');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2132,89,'TO','Totonicapan'),
(2133,89,'ZA','Zacapa'),
(2134,90,'CNK','Conakry'),
(2135,90,'BYL','Beyla'),
(2136,90,'BFA','Boffa'),
(2137,90,'BOK','Boke'),
(2138,90,'COY','Coyah'),
(2139,90,'DBL','Dabola'),
(2140,90,'DLB','Dalaba'),
(2141,90,'DGR','Dinguiraye'),
(2142,90,'DBR','Dubreka'),
(2143,90,'FRN','Faranah'),
(2144,90,'FRC','Forecariah'),
(2145,90,'FRI','Fria'),
(2146,90,'GAO','Gaoual'),
(2147,90,'GCD','Gueckedou'),
(2148,90,'KNK','Kankan'),
(2149,90,'KRN','Kerouane'),
(2150,90,'KND','Kindia'),
(2151,90,'KSD','Kissidougou');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2152,90,'KBA','Koubia'),
(2153,90,'KDA','Koundara'),
(2154,90,'KRA','Kouroussa'),
(2155,90,'LAB','Labe'),
(2156,90,'LLM','Lelouma'),
(2157,90,'LOL','Lola'),
(2158,90,'MCT','Macenta'),
(2159,90,'MAL','Mali'),
(2160,90,'MAM','Mamou'),
(2161,90,'MAN','Mandiana'),
(2162,90,'NZR','Nzerekore'),
(2163,90,'PIT','Pita'),
(2164,90,'SIG','Siguiri'),
(2165,90,'TLM','Telimele'),
(2166,90,'TOG','Tougue'),
(2167,90,'YOM','Yomou'),
(2168,91,'BF','Bafata Region'),
(2169,91,'BB','Biombo Region'),
(2170,91,'BS','Bissau Region'),
(2171,91,'BL','Bolama Region');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2172,91,'CA','Cacheu Region'),
(2173,91,'GA','Gabu Region'),
(2174,91,'OI','Oio Region'),
(2175,91,'QU','Quinara Region'),
(2176,91,'TO','Tombali Region'),
(2177,92,'BW','Barima-Waini'),
(2178,92,'CM','Cuyuni-Mazaruni'),
(2179,92,'DM','Demerara-Mahaica'),
(2180,92,'EC','East Berbice-Corentyne'),
(2181,92,'EW','Essequibo Islands-West Demerara'),
(2182,92,'MB','Mahaica-Berbice'),
(2183,92,'PM','Pomeroon-Supenaam'),
(2184,92,'PI','Potaro-Siparuni'),
(2185,92,'UD','Upper Demerara-Berbice'),
(2186,92,'UT','Upper Takutu-Upper Essequibo'),
(2187,93,'AR','Artibonite'),
(2188,93,'CE','Centre'),
(2189,93,'GA','Grand Anse'),
(2190,93,'ND','Nord'),
(2191,93,'NE','Nord-Est');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2192,93,'NO','Nord-Ouest'),
(2193,93,'OU','Ouest'),
(2194,93,'SD','Sud'),
(2195,93,'SE','Sud-Est'),
(2196,94,'F','Flat Island'),
(2197,94,'M','McDonald Island'),
(2198,94,'S','Shag Island'),
(2199,94,'H','Heard Island'),
(2200,95,'AT','Atlantida'),
(2201,95,'CH','Choluteca'),
(2202,95,'CL','Colon'),
(2203,95,'CM','Comayagua'),
(2204,95,'CP','Copan'),
(2205,95,'CR','Cortes'),
(2206,95,'PA','El Paraiso'),
(2207,95,'FM','Francisco Morazan'),
(2208,95,'GD','Gracias a Dios'),
(2209,95,'IN','Intibuca'),
(2210,95,'IB','Islas de la Bahia (Bay Islands)'),
(2211,95,'PZ','La Paz');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2212,95,'LE','Lempira'),
(2213,95,'OC','Ocotepeque'),
(2214,95,'OL','Olancho'),
(2215,95,'SB','Santa Barbara'),
(2216,95,'VA','Valle'),
(2217,95,'YO','Yoro'),
(2218,96,'HCW','Central and Western Hong Kong Is'),
(2219,96,'HEA','Eastern Hong Kong Island'),
(2220,96,'HSO','Southern Hong Kong Island'),
(2221,96,'HWC','Wan Chai Hong Kong Island'),
(2222,96,'KKC','Kowloon City Kowloon'),
(2223,96,'KKT','Kwun Tong Kowloon'),
(2224,96,'KSS','Sham Shui Po Kowloon'),
(2225,96,'KWT','Wong Tai Sin Kowloon'),
(2226,96,'KYT','Yau Tsim Mong Kowloon'),
(2227,96,'NIS','Islands New Territories'),
(2228,96,'NKT','Kwai Tsing New Territories'),
(2229,96,'NNO','North New Territories'),
(2230,96,'NSK','Sai Kung New Territories'),
(2231,96,'NST','Sha Tin New Territories');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2232,96,'NTP','Tai Po New Territories'),
(2233,96,'NTW','Tsuen Wan New Territories'),
(2234,96,'NTM','Tuen Mun New Territories'),
(2235,96,'NYL','Yuen Long New Territories'),
(2236,97,'BK','Bacs-Kiskun'),
(2237,97,'BA','Baranya'),
(2238,97,'BE','Bekes'),
(2239,97,'BS','Bekescsaba'),
(2240,97,'BZ','Borsod-Abauj-Zemplen'),
(2241,97,'BU','Budapest'),
(2242,97,'CS','Csongrad'),
(2243,97,'DE','Debrecen'),
(2244,97,'DU','Dunaujvaros'),
(2245,97,'EG','Eger'),
(2246,97,'FE','Fejer'),
(2247,97,'GY','Gyor'),
(2248,97,'GM','Gyor-Moson-Sopron'),
(2249,97,'HB','Hajdu-Bihar'),
(2250,97,'HE','Heves'),
(2251,97,'HO','Hodmezovasarhely');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2252,97,'JN','Jasz-Nagykun-Szolnok'),
(2253,97,'KA','Kaposvar'),
(2254,97,'KE','Kecskemet'),
(2255,97,'KO','Komarom-Esztergom'),
(2256,97,'MI','Miskolc'),
(2257,97,'NA','Nagykanizsa'),
(2258,97,'NO','Nograd'),
(2259,97,'NY','Nyiregyhaza'),
(2260,97,'PE','Pecs'),
(2261,97,'PS','Pest'),
(2262,97,'SO','Somogy'),
(2263,97,'SP','Sopron'),
(2264,97,'SS','Szabolcs-Szatmar-Bereg'),
(2265,97,'SZ','Szeged'),
(2266,97,'SE','Szekesfehervar'),
(2267,97,'SL','Szolnok'),
(2268,97,'SM','Szombathely'),
(2269,97,'TA','Tatabanya'),
(2270,97,'TO','Tolna'),
(2271,97,'VA','Vas');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2272,97,'VE','Veszprem'),
(2273,97,'ZA','Zala'),
(2274,97,'ZZ','Zalaegerszeg'),
(2275,98,'AL','Austurland'),
(2276,98,'HF','Hofuoborgarsvaeoi'),
(2277,98,'NE','Norourland eystra'),
(2278,98,'NV','Norourland vestra'),
(2279,98,'SL','Suourland'),
(2280,98,'SN','Suournes'),
(2281,98,'VF','Vestfiroir'),
(2282,98,'VL','Vesturland'),
(2283,99,'AN','Andaman and Nicobar Islands'),
(2284,99,'AP','Andhra Pradesh'),
(2285,99,'AR','Arunachal Pradesh'),
(2286,99,'AS','Assam'),
(2287,99,'BI','Bihar'),
(2288,99,'CH','Chandigarh'),
(2289,99,'DA','Dadra and Nagar Haveli'),
(2290,99,'DM','Daman and Diu'),
(2291,99,'DE','Delhi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2292,99,'GO','Goa'),
(2293,99,'GU','Gujarat'),
(2294,99,'HA','Haryana'),
(2295,99,'HP','Himachal Pradesh'),
(2296,99,'JA','Jammu and Kashmir'),
(2297,99,'KA','Karnataka'),
(2298,99,'KE','Kerala'),
(2299,99,'LI','Lakshadweep Islands'),
(2300,99,'MP','Madhya Pradesh'),
(2301,99,'MA','Maharashtra'),
(2302,99,'MN','Manipur'),
(2303,99,'ME','Meghalaya'),
(2304,99,'MI','Mizoram'),
(2305,99,'NA','Nagaland'),
(2306,99,'OR','Orissa'),
(2307,99,'PO','Pondicherry'),
(2308,99,'PU','Punjab'),
(2309,99,'RA','Rajasthan'),
(2310,99,'SI','Sikkim'),
(2311,99,'TN','Tamil Nadu');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2312,99,'TR','Tripura'),
(2313,99,'UP','Uttar Pradesh'),
(2314,99,'WB','West Bengal'),
(2315,100,'AC','Aceh'),
(2316,100,'BA','Bali'),
(2317,100,'BT','Banten'),
(2318,100,'BE','Bengkulu'),
(2319,100,'BD','BoDeTaBek'),
(2320,100,'GO','Gorontalo'),
(2321,100,'JK','Jakarta Raya'),
(2322,100,'JA','Jambi'),
(2323,100,'JB','Jawa Barat'),
(2324,100,'JT','Jawa Tengah'),
(2325,100,'JI','Jawa Timur'),
(2326,100,'KB','Kalimantan Barat'),
(2327,100,'KS','Kalimantan Selatan'),
(2328,100,'KT','Kalimantan Tengah'),
(2329,100,'KI','Kalimantan Timur'),
(2330,100,'BB','Kepulauan Bangka Belitung'),
(2331,100,'LA','Lampung');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2332,100,'MA','Maluku'),
(2333,100,'MU','Maluku Utara'),
(2334,100,'NB','Nusa Tenggara Barat'),
(2335,100,'NT','Nusa Tenggara Timur'),
(2336,100,'PA','Papua'),
(2337,100,'RI','Riau'),
(2338,100,'SN','Sulawesi Selatan'),
(2339,100,'ST','Sulawesi Tengah'),
(2340,100,'SG','Sulawesi Tenggara'),
(2341,100,'SA','Sulawesi Utara'),
(2342,100,'SB','Sumatera Barat'),
(2343,100,'SS','Sumatera Selatan'),
(2344,100,'SU','Sumatera Utara'),
(2345,100,'YO','Yogyakarta'),
(2346,101,'TEH','Tehran'),
(2347,101,'QOM','Qom'),
(2348,101,'MKZ','Markazi'),
(2349,101,'QAZ','Qazvin'),
(2350,101,'GIL','Gilan'),
(2351,101,'ARD','Ardabil');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2352,101,'ZAN','Zanjan'),
(2353,101,'EAZ','East Azarbaijan'),
(2354,101,'WEZ','West Azarbaijan'),
(2355,101,'KRD','Kurdistan'),
(2356,101,'HMD','Hamadan'),
(2357,101,'KRM','Kermanshah'),
(2358,101,'ILM','Ilam'),
(2359,101,'LRS','Lorestan'),
(2360,101,'KZT','Khuzestan'),
(2361,101,'CMB','Chahar Mahaal and Bakhtiari'),
(2362,101,'KBA','Kohkiluyeh and Buyer Ahmad'),
(2363,101,'BSH','Bushehr'),
(2364,101,'FAR','Fars'),
(2365,101,'HRM','Hormozgan'),
(2366,101,'SBL','Sistan and Baluchistan'),
(2367,101,'KRB','Kerman'),
(2368,101,'YZD','Yazd'),
(2369,101,'EFH','Esfahan'),
(2370,101,'SMN','Semnan'),
(2371,101,'MZD','Mazandaran');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2372,101,'GLS','Golestan'),
(2373,101,'NKH','North Khorasan'),
(2374,101,'RKH','Razavi Khorasan'),
(2375,101,'SKH','South Khorasan'),
(2376,102,'BD','Baghdad'),
(2377,102,'SD','Salah ad Din'),
(2378,102,'DY','Diyala'),
(2379,102,'WS','Wasit'),
(2380,102,'MY','Maysan'),
(2381,102,'BA','Al Basrah'),
(2382,102,'DQ','Dhi Qar'),
(2383,102,'MU','Al Muthanna'),
(2384,102,'QA','Al Qadisyah'),
(2385,102,'BB','Babil'),
(2386,102,'KB','Al Karbala'),
(2387,102,'NJ','An Najaf'),
(2388,102,'AB','Al Anbar'),
(2389,102,'NN','Ninawa'),
(2390,102,'DH','Dahuk'),
(2391,102,'AL','Arbil');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2392,102,'TM','At Tamim'),
(2393,102,'SL','As Sulaymaniyah'),
(2394,103,'CA','Carlow'),
(2395,103,'CV','Cavan'),
(2396,103,'CL','Clare'),
(2397,103,'CO','Cork'),
(2398,103,'DO','Donegal'),
(2399,103,'DU','Dublin'),
(2400,103,'GA','Galway'),
(2401,103,'KE','Kerry'),
(2402,103,'KI','Kildare'),
(2403,103,'KL','Kilkenny'),
(2404,103,'LA','Laois'),
(2405,103,'LE','Leitrim'),
(2406,103,'LI','Limerick'),
(2407,103,'LO','Longford'),
(2408,103,'LU','Louth'),
(2409,103,'MA','Mayo'),
(2410,103,'ME','Meath'),
(2411,103,'MO','Monaghan');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2412,103,'OF','Offaly'),
(2413,103,'RO','Roscommon'),
(2414,103,'SL','Sligo'),
(2415,103,'TI','Tipperary'),
(2416,103,'WA','Waterford'),
(2417,103,'WE','Westmeath'),
(2418,103,'WX','Wexford'),
(2419,103,'WI','Wicklow'),
(2420,104,'BS','Beer Sheva'),
(2421,104,'BH','Bikaat Hayarden'),
(2422,104,'EA','Eilat and Arava'),
(2423,104,'GA','Galil'),
(2424,104,'HA','Haifa'),
(2425,104,'JM','Jehuda Mountains'),
(2426,104,'JE','Jerusalem'),
(2427,104,'NE','Negev'),
(2428,104,'SE','Semaria'),
(2429,104,'SH','Sharon'),
(2430,104,'TA','Tel Aviv (Gosh Dan)'),
(2431,105,'AB','Abruzzo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2432,105,'BA','Basilicata'),
(2433,105,'CA','Calabria'),
(2434,105,'CP','Campania'),
(2435,105,'ER','Emilia Romagna'),
(2436,105,'FV','Friuli-Venezia Giulia'),
(2437,105,'LA','Lazio (Latium & Rome)'),
(2438,105,'TM','Le Marche (The Marches)'),
(2439,105,'LI','Liguria'),
(2440,105,'LO','Lombardia (Lombardy)'),
(2441,105,'MO','Molise'),
(2442,105,'PI','Piemonte (Piedmont)'),
(2443,105,'AP','Puglia (Apulia)'),
(2444,105,'SA','Sardegna (Sardinia)'),
(2445,105,'SI','Sicilia (Sicily)'),
(2446,105,'TU','Toscana (Tuscany)'),
(2447,105,'TR','Trentino Alto Adige'),
(2448,105,'UM','Umbria'),
(2449,105,'VA','Val dAosta'),
(2450,105,'VE','Veneto'),
(2451,106,'CLA','Clarendon Parish');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2452,106,'HAN','Hanover Parish'),
(2453,106,'KIN','Kingston Parish'),
(2454,106,'MAN','Manchester Parish'),
(2455,106,'POR','Portland Parish'),
(2456,106,'AND','Saint Andrew Parish'),
(2457,106,'ANN','Saint Ann Parish'),
(2458,106,'CAT','Saint Catherine Parish'),
(2459,106,'ELI','Saint Elizabeth Parish'),
(2460,106,'JAM','Saint James Parish'),
(2461,106,'MAR','Saint Mary Parish'),
(2462,106,'THO','Saint Thomas Parish'),
(2463,106,'TRL','Trelawny Parish'),
(2464,106,'WML','Westmoreland Parish'),
(2465,107,'AI','Aichi'),
(2466,107,'AK','Akita'),
(2467,107,'AO','Aomori'),
(2468,107,'CH','Chiba'),
(2469,107,'EH','Ehime'),
(2470,107,'FK','Fukui'),
(2471,107,'FU','Fukuoka');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2472,107,'FS','Fukushima'),
(2473,107,'GI','Gifu'),
(2474,107,'GU','Gumma'),
(2475,107,'HI','Hiroshima'),
(2476,107,'HO','Hokkaido'),
(2477,107,'HY','Hyogo'),
(2478,107,'IB','Ibaraki'),
(2479,107,'IS','Ishikawa'),
(2480,107,'IW','Iwate'),
(2481,107,'KA','Kagawa'),
(2482,107,'KG','Kagoshima'),
(2483,107,'KN','Kanagawa'),
(2484,107,'KO','Kochi'),
(2485,107,'KU','Kumamoto'),
(2486,107,'KY','Kyoto'),
(2487,107,'MI','Mie'),
(2488,107,'MY','Miyagi'),
(2489,107,'MZ','Miyazaki'),
(2490,107,'NA','Nagano'),
(2491,107,'NG','Nagasaki');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2492,107,'NR','Nara'),
(2493,107,'NI','Niigata'),
(2494,107,'OI','Oita'),
(2495,107,'OK','Okayama'),
(2496,107,'ON','Okinawa'),
(2497,107,'OS','Osaka'),
(2498,107,'SA','Saga'),
(2499,107,'SI','Saitama'),
(2500,107,'SH','Shiga'),
(2501,107,'SM','Shimane'),
(2502,107,'SZ','Shizuoka'),
(2503,107,'TO','Tochigi'),
(2504,107,'TS','Tokushima'),
(2505,107,'TK','Tokyo'),
(2506,107,'TT','Tottori'),
(2507,107,'TY','Toyama'),
(2508,107,'WA','Wakayama'),
(2509,107,'YA','Yamagata'),
(2510,107,'YM','Yamaguchi'),
(2511,107,'YN','Yamanashi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2512,108,'AM','Amman'),
(2513,108,'AJ','Ajlun'),
(2514,108,'AA','Al Aqabah'),
(2515,108,'AB','Al Balqa'),
(2516,108,'AK','Al Karak'),
(2517,108,'AL','Al Mafraq'),
(2518,108,'AT','At Tafilah'),
(2519,108,'AZ','Az Zarqa'),
(2520,108,'IR','Irbid'),
(2521,108,'JA','Jarash'),
(2522,108,'MA','Maan'),
(2523,108,'MD','Madaba'),
(2524,109,'AL','Almaty'),
(2525,109,'AC','Almaty City'),
(2526,109,'AM','Aqmola'),
(2527,109,'AQ','Aqtobe'),
(2528,109,'AS','Astana City'),
(2529,109,'AT','Atyrau'),
(2530,109,'BA','Batys Qazaqstan'),
(2531,109,'BY','Bayqongyr City');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2532,109,'MA','Mangghystau'),
(2533,109,'ON','Ongtustik Qazaqstan'),
(2534,109,'PA','Pavlodar'),
(2535,109,'QA','Qaraghandy'),
(2536,109,'QO','Qostanay'),
(2537,109,'QY','Qyzylorda'),
(2538,109,'SH','Shyghys Qazaqstan'),
(2539,109,'SO','Soltustik Qazaqstan'),
(2540,109,'ZH','Zhambyl'),
(2541,110,'CE','Central'),
(2542,110,'CO','Coast'),
(2543,110,'EA','Eastern'),
(2544,110,'NA','Nairobi Area'),
(2545,110,'NE','North Eastern'),
(2546,110,'NY','Nyanza'),
(2547,110,'RV','Rift Valley'),
(2548,110,'WE','Western'),
(2549,111,'AG','Abaiang'),
(2550,111,'AM','Abemama'),
(2551,111,'AK','Aranuka');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2552,111,'AO','Arorae'),
(2553,111,'BA','Banaba'),
(2554,111,'BE','Beru'),
(2555,111,'bT','Butaritari'),
(2556,111,'KA','Kanton'),
(2557,111,'KR','Kiritimati'),
(2558,111,'KU','Kuria'),
(2559,111,'MI','Maiana'),
(2560,111,'MN','Makin'),
(2561,111,'ME','Marakei'),
(2562,111,'NI','Nikunau'),
(2563,111,'NO','Nonouti'),
(2564,111,'ON','Onotoa'),
(2565,111,'TT','Tabiteuea'),
(2566,111,'TR','Tabuaeran'),
(2567,111,'TM','Tamana'),
(2568,111,'TW','Tarawa'),
(2569,111,'TE','Teraina'),
(2570,112,'CHA','Chagang-do'),
(2571,112,'HAB','Hamgyong-bukto');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2572,112,'HAN','Hamgyong-namdo'),
(2573,112,'HWB','Hwanghae-bukto'),
(2574,112,'HWN','Hwanghae-namdo'),
(2575,112,'KAN','Kangwon-do'),
(2576,112,'PYB','Pyongan-bukto'),
(2577,112,'PYN','Pyongan-namdo'),
(2578,112,'YAN','Ryanggang-do (Yanggang-do)'),
(2579,112,'NAJ','Rason Directly Governed City'),
(2580,112,'PYO','Pyongyang Special City'),
(2581,113,'CO','Chungchong-bukto'),
(2582,113,'CH','Chungchong-namdo'),
(2583,113,'CD','Cheju-do'),
(2584,113,'CB','Cholla-bukto'),
(2585,113,'CN','Cholla-namdo'),
(2586,113,'IG','Inchon-gwangyoksi'),
(2587,113,'KA','Kangwon-do'),
(2588,113,'KG','Kwangju-gwangyoksi'),
(2589,113,'KD','Kyonggi-do'),
(2590,113,'KB','Kyongsang-bukto'),
(2591,113,'KN','Kyongsang-namdo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2592,113,'PG','Pusan-gwangyoksi'),
(2593,113,'SO','Soul-tukpyolsi'),
(2594,113,'TA','Taegu-gwangyoksi'),
(2595,113,'TG','Taejon-gwangyoksi'),
(2596,114,'AL','Al Asimah'),
(2597,114,'AA','Al Ahmadi'),
(2598,114,'AF','Al Farwaniyah'),
(2599,114,'AJ','Al Jahra'),
(2600,114,'HA','Hawalli'),
(2601,115,'GB','Bishkek'),
(2602,115,'B','Batken'),
(2603,115,'C','Chu'),
(2604,115,'J','Jalal-Abad'),
(2605,115,'N','Naryn'),
(2606,115,'O','Osh'),
(2607,115,'T','Talas'),
(2608,115,'Y','Ysyk-Kol'),
(2609,116,'VT','Vientiane'),
(2610,116,'AT','Attapu'),
(2611,116,'BK','Bokeo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2612,116,'BL','Bolikhamxai'),
(2613,116,'CH','Champasak '),
(2614,116,'HO','Houaphan'),
(2615,116,'KH','Khammouan'),
(2616,116,'LM','Louang Namtha'),
(2617,116,'LP','Louangphabang'),
(2618,116,'OU','Oudomxai'),
(2619,116,'PH','Phongsali'),
(2620,116,'SL','Salavan'),
(2621,116,'SV','Savannakhet'),
(2622,116,'VI','Vientiane'),
(2623,116,'XA','Xaignabouli'),
(2624,116,'XE','Xekong'),
(2625,116,'XI','Xiangkhoang'),
(2626,116,'XN','Xaisomboun'),
(2627,117,'AIZ','Aizkraukles Rajons'),
(2628,117,'ALU','Aluksnes Rajons'),
(2629,117,'BAL','Balvu Rajons'),
(2630,117,'BAU','Bauskas Rajons'),
(2631,117,'CES','Cesu Rajons');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2632,117,'DGR','Daugavpils Rajons'),
(2633,117,'DOB','Dobeles Rajons'),
(2634,117,'GUL','Gulbenes Rajons'),
(2635,117,'JEK','Jekabpils Rajons'),
(2636,117,'JGR','Jelgavas Rajons'),
(2637,117,'KRA','Kraslavas Rajons'),
(2638,117,'KUL','Kuldigas Rajons'),
(2639,117,'LPR','Liepajas Rajons'),
(2640,117,'LIM','Limbazu Rajons'),
(2641,117,'LUD','Ludzas Rajons'),
(2642,117,'MAD','Madonas Rajons'),
(2643,117,'OGR','Ogres Rajons'),
(2644,117,'PRE','Preilu Rajons'),
(2645,117,'RZR','Rezeknes Rajons'),
(2646,117,'RGR','Rigas Rajons'),
(2647,117,'SAL','Saldus Rajons'),
(2648,117,'TAL','Talsu Rajons'),
(2649,117,'TUK','Tukuma Rajons'),
(2650,117,'VLK','Valkas Rajons'),
(2651,117,'VLM','Valmieras Rajons');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2652,117,'VSR','Ventspils Rajons'),
(2653,117,'DGV','Daugavpils'),
(2654,117,'JGV','Jelgava'),
(2655,117,'JUR','Jurmala'),
(2656,117,'LPK','Liepaja'),
(2657,117,'RZK','Rezekne'),
(2658,117,'RGA','Riga'),
(2659,117,'VSL','Ventspils'),
(2660,119,'BE','Berea'),
(2661,119,'BB','Butha-Buthe'),
(2662,119,'LE','Leribe'),
(2663,119,'MF','Mafeteng'),
(2664,119,'MS','Maseru'),
(2665,119,'MH','Mohales Hoek'),
(2666,119,'MK','Mokhotlong'),
(2667,119,'QN','Qachas Nek'),
(2668,119,'QT','Quthing'),
(2669,119,'TT','Thaba-Tseka'),
(2670,120,'BI','Bomi'),
(2671,120,'BG','Bong');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2672,120,'GB','Grand Bassa'),
(2673,120,'CM','Grand Cape Mount'),
(2674,120,'GG','Grand Gedeh'),
(2675,120,'GK','Grand Kru'),
(2676,120,'LO','Lofa'),
(2677,120,'MG','Margibi'),
(2678,120,'ML','Maryland'),
(2679,120,'MS','Montserrado'),
(2680,120,'NB','Nimba'),
(2681,120,'RC','River Cess'),
(2682,120,'SN','Sinoe'),
(2683,121,'AJ','Ajdabiya'),
(2684,121,'AZ','Al Aziziyah'),
(2685,121,'FA','Al Fatih'),
(2686,121,'JA','Al Jabal al Akhdar'),
(2687,121,'JU','Al Jufrah'),
(2688,121,'KH','Al Khums'),
(2689,121,'KU','Al Kufrah'),
(2690,121,'NK','An Nuqat al Khams'),
(2691,121,'AS','Ash Shati');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2692,121,'AW','Awbari'),
(2693,121,'ZA','Az Zawiyah'),
(2694,121,'BA','Banghazi'),
(2695,121,'DA','Darnah'),
(2696,121,'GD','Ghadamis'),
(2697,121,'GY','Gharyan'),
(2698,121,'MI','Misratah'),
(2699,121,'MZ','Murzuq'),
(2700,121,'SB','Sabha'),
(2701,121,'SW','Sawfajjin'),
(2702,121,'SU','Surt'),
(2703,121,'TL','Tarabulus (Tripoli)'),
(2704,121,'TH','Tarhunah'),
(2705,121,'TU','Tubruq'),
(2706,121,'YA','Yafran'),
(2707,121,'ZL','Zlitan'),
(2708,122,'V','Vaduz'),
(2709,122,'A','Schaan'),
(2710,122,'B','Balzers'),
(2711,122,'N','Triesen');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2712,122,'E','Eschen'),
(2713,122,'M','Mauren'),
(2714,122,'T','Triesenberg'),
(2715,122,'R','Ruggell'),
(2716,122,'G','Gamprin'),
(2717,122,'L','Schellenberg'),
(2718,122,'P','Planken'),
(2719,123,'AL','Alytus'),
(2720,123,'KA','Kaunas'),
(2721,123,'KL','Klaipeda'),
(2722,123,'MA','Marijampole'),
(2723,123,'PA','Panevezys'),
(2724,123,'SI','Siauliai'),
(2725,123,'TA','Taurage'),
(2726,123,'TE','Telsiai'),
(2727,123,'UT','Utena'),
(2728,123,'VI','Vilnius'),
(2729,124,'DD','Diekirch'),
(2730,124,'DC','Clervaux'),
(2731,124,'DR','Redange');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2732,124,'DV','Vianden'),
(2733,124,'DW','Wiltz'),
(2734,124,'GG','Grevenmacher'),
(2735,124,'GE','Echternach'),
(2736,124,'GR','Remich'),
(2737,124,'LL','Luxembourg'),
(2738,124,'LC','Capellen'),
(2739,124,'LE','Esch-sur-Alzette'),
(2740,124,'LM','Mersch'),
(2741,125,'OLF','Our Lady Fatima Parish'),
(2742,125,'ANT','St. Anthony Parish'),
(2743,125,'LAZ','St. Lazarus Parish'),
(2744,125,'CAT','Cathedral Parish'),
(2745,125,'LAW','St. Lawrence Parish'),
(2746,127,'AN','Antananarivo'),
(2747,127,'AS','Antsiranana'),
(2748,127,'FN','Fianarantsoa'),
(2749,127,'MJ','Mahajanga'),
(2750,127,'TM','Toamasina'),
(2751,127,'TL','Toliara');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2752,128,'BLK','Balaka'),
(2753,128,'BLT','Blantyre'),
(2754,128,'CKW','Chikwawa'),
(2755,128,'CRD','Chiradzulu'),
(2756,128,'CTP','Chitipa'),
(2757,128,'DDZ','Dedza'),
(2758,128,'DWA','Dowa'),
(2759,128,'KRG','Karonga'),
(2760,128,'KSG','Kasungu'),
(2761,128,'LKM','Likoma'),
(2762,128,'LLG','Lilongwe'),
(2763,128,'MCG','Machinga'),
(2764,128,'MGC','Mangochi'),
(2765,128,'MCH','Mchinji'),
(2766,128,'MLJ','Mulanje'),
(2767,128,'MWZ','Mwanza'),
(2768,128,'MZM','Mzimba'),
(2769,128,'NTU','Ntcheu'),
(2770,128,'NKB','Nkhata Bay'),
(2771,128,'NKH','Nkhotakota');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2772,128,'NSJ','Nsanje'),
(2773,128,'NTI','Ntchisi'),
(2774,128,'PHL','Phalombe'),
(2775,128,'RMP','Rumphi'),
(2776,128,'SLM','Salima'),
(2777,128,'THY','Thyolo'),
(2778,128,'ZBA','Zomba'),
(2779,129,'JO','Johor'),
(2780,129,'KE','Kedah'),
(2781,129,'KL','Kelantan'),
(2782,129,'LA','Labuan'),
(2783,129,'ME','Melaka'),
(2784,129,'NS','Negeri Sembilan'),
(2785,129,'PA','Pahang'),
(2786,129,'PE','Perak'),
(2787,129,'PR','Perlis'),
(2788,129,'PP','Pulau Pinang'),
(2789,129,'SA','Sabah'),
(2790,129,'SR','Sarawak'),
(2791,129,'SE','Selangor');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2792,129,'TE','Terengganu'),
(2793,129,'WP','Wilayah Persekutuan'),
(2794,130,'THU','Thiladhunmathi Uthuru'),
(2795,130,'THD','Thiladhunmathi Dhekunu'),
(2796,130,'MLU','Miladhunmadulu Uthuru'),
(2797,130,'MLD','Miladhunmadulu Dhekunu'),
(2798,130,'MAU','Maalhosmadulu Uthuru'),
(2799,130,'MAD','Maalhosmadulu Dhekunu'),
(2800,130,'FAA','Faadhippolhu'),
(2801,130,'MAA','Male Atoll'),
(2802,130,'AAU','Ari Atoll Uthuru'),
(2803,130,'AAD','Ari Atoll Dheknu'),
(2804,130,'FEA','Felidhe Atoll'),
(2805,130,'MUA','Mulaku Atoll'),
(2806,130,'NAU','Nilandhe Atoll Uthuru'),
(2807,130,'NAD','Nilandhe Atoll Dhekunu'),
(2808,130,'KLH','Kolhumadulu'),
(2809,130,'HDH','Hadhdhunmathi'),
(2810,130,'HAU','Huvadhu Atoll Uthuru'),
(2811,130,'HAD','Huvadhu Atoll Dhekunu');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2812,130,'FMU','Fua Mulaku'),
(2813,130,'ADD','Addu'),
(2814,131,'GA','Gao'),
(2815,131,'KY','Kayes'),
(2816,131,'KD','Kidal'),
(2817,131,'KL','Koulikoro'),
(2818,131,'MP','Mopti'),
(2819,131,'SG','Segou'),
(2820,131,'SK','Sikasso'),
(2821,131,'TB','Tombouctou'),
(2822,131,'CD','Bamako Capital District'),
(2823,132,'ATT','Attard'),
(2824,132,'BAL','Balzan'),
(2825,132,'BGU','Birgu'),
(2826,132,'BKK','Birkirkara'),
(2827,132,'BRZ','Birzebbuga'),
(2828,132,'BOR','Bormla'),
(2829,132,'DIN','Dingli'),
(2830,132,'FGU','Fgura'),
(2831,132,'FLO','Floriana');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2832,132,'GDJ','Gudja'),
(2833,132,'GZR','Gzira'),
(2834,132,'GRG','Gargur'),
(2835,132,'GXQ','Gaxaq'),
(2836,132,'HMR','Hamrun'),
(2837,132,'IKL','Iklin'),
(2838,132,'ISL','Isla'),
(2839,132,'KLK','Kalkara'),
(2840,132,'KRK','Kirkop'),
(2841,132,'LIJ','Lija'),
(2842,132,'LUQ','Luqa'),
(2843,132,'MRS','Marsa'),
(2844,132,'MKL','Marsaskala'),
(2845,132,'MXL','Marsaxlokk'),
(2846,132,'MDN','Mdina'),
(2847,132,'MEL','Melliea'),
(2848,132,'MGR','Mgarr'),
(2849,132,'MST','Mosta'),
(2850,132,'MQA','Mqabba'),
(2851,132,'MSI','Msida');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2852,132,'MTF','Mtarfa'),
(2853,132,'NAX','Naxxar'),
(2854,132,'PAO','Paola'),
(2855,132,'PEM','Pembroke'),
(2856,132,'PIE','Pieta'),
(2857,132,'QOR','Qormi'),
(2858,132,'QRE','Qrendi'),
(2859,132,'RAB','Rabat'),
(2860,132,'SAF','Safi'),
(2861,132,'SGI','San Giljan'),
(2862,132,'SLU','Santa Lucija'),
(2863,132,'SPB','San Pawl il-Bahar'),
(2864,132,'SGW','San Gwann'),
(2865,132,'SVE','Santa Venera'),
(2866,132,'SIG','Siggiewi'),
(2867,132,'SLM','Sliema'),
(2868,132,'SWQ','Swieqi'),
(2869,132,'TXB','Ta Xbiex'),
(2870,132,'TRX','Tarxien'),
(2871,132,'VLT','Valletta');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2872,132,'XGJ','Xgajra'),
(2873,132,'ZBR','Zabbar'),
(2874,132,'ZBG','Zebbug'),
(2875,132,'ZJT','Zejtun'),
(2876,132,'ZRQ','Zurrieq'),
(2877,132,'FNT','Fontana'),
(2878,132,'GHJ','Ghajnsielem'),
(2879,132,'GHR','Gharb'),
(2880,132,'GHS','Ghasri'),
(2881,132,'KRC','Kercem'),
(2882,132,'MUN','Munxar'),
(2883,132,'NAD','Nadur'),
(2884,132,'QAL','Qala'),
(2885,132,'VIC','Victoria'),
(2886,132,'SLA','San Lawrenz'),
(2887,132,'SNT','Sannat'),
(2888,132,'ZAG','Xagra'),
(2889,132,'XEW','Xewkija'),
(2890,132,'ZEB','Zebbug'),
(2891,133,'ALG','Ailinginae');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2892,133,'ALL','Ailinglaplap'),
(2893,133,'ALK','Ailuk'),
(2894,133,'ARN','Arno'),
(2895,133,'AUR','Aur'),
(2896,133,'BKR','Bikar'),
(2897,133,'BKN','Bikini'),
(2898,133,'BKK','Bokak'),
(2899,133,'EBN','Ebon'),
(2900,133,'ENT','Enewetak'),
(2901,133,'EKB','Erikub'),
(2902,133,'JBT','Jabat'),
(2903,133,'JLT','Jaluit'),
(2904,133,'JEM','Jemo'),
(2905,133,'KIL','Kili'),
(2906,133,'KWJ','Kwajalein'),
(2907,133,'LAE','Lae'),
(2908,133,'LIB','Lib'),
(2909,133,'LKP','Likiep'),
(2910,133,'MJR','Majuro'),
(2911,133,'MLP','Maloelap');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2912,133,'MJT','Mejit'),
(2913,133,'MIL','Mili'),
(2914,133,'NMK','Namorik'),
(2915,133,'NAM','Namu'),
(2916,133,'RGL','Rongelap'),
(2917,133,'RGK','Rongrik'),
(2918,133,'TOK','Toke'),
(2919,133,'UJA','Ujae'),
(2920,133,'UJL','Ujelang'),
(2921,133,'UTK','Utirik'),
(2922,133,'WTH','Wotho'),
(2923,133,'WTJ','Wotje'),
(2924,135,'AD','Adrar'),
(2925,135,'AS','Assaba'),
(2926,135,'BR','Brakna'),
(2927,135,'DN','Dakhlet Nouadhibou'),
(2928,135,'GO','Gorgol'),
(2929,135,'GM','Guidimaka'),
(2930,135,'HC','Hodh Ech Chargui'),
(2931,135,'HG','Hodh El Gharbi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2932,135,'IN','Inchiri'),
(2933,135,'TA','Tagant'),
(2934,135,'TZ','Tiris Zemmour'),
(2935,135,'TR','Trarza'),
(2936,135,'NO','Nouakchott'),
(2937,136,'BR','Beau Bassin-Rose Hill'),
(2938,136,'CU','Curepipe'),
(2939,136,'PU','Port Louis'),
(2940,136,'QB','Quatre Bornes'),
(2941,136,'VP','Vacoas-Phoenix'),
(2942,136,'AG','Agalega Islands'),
(2943,136,'CC','Cargados Carajos Shoals (Saint B'),
(2944,136,'RO','Rodrigues'),
(2945,136,'BL','Black River'),
(2946,136,'FL','Flacq'),
(2947,136,'GP','Grand Port'),
(2948,136,'MO','Moka'),
(2949,136,'PA','Pamplemousses'),
(2950,136,'PW','Plaines Wilhems'),
(2951,136,'PL','Port Louis');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2952,136,'RR','Riviere du Rempart'),
(2953,136,'SA','Savanne'),
(2954,138,'BN','Baja California Norte'),
(2955,138,'BS','Baja California Sur'),
(2956,138,'CA','Campeche'),
(2957,138,'CI','Chiapas'),
(2958,138,'CH','Chihuahua'),
(2959,138,'CZ','Coahuila de Zaragoza'),
(2960,138,'CL','Colima'),
(2961,138,'DF','Distrito Federal'),
(2962,138,'DU','Durango'),
(2963,138,'GA','Guanajuato'),
(2964,138,'GE','Guerrero'),
(2965,138,'HI','Hidalgo'),
(2966,138,'JA','Jalisco'),
(2967,138,'ME','Mexico'),
(2968,138,'MI','Michoacan de Ocampo'),
(2969,138,'MO','Morelos'),
(2970,138,'NA','Nayarit'),
(2971,138,'NL','Nuevo Leon');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2972,138,'OA','Oaxaca'),
(2973,138,'PU','Puebla'),
(2974,138,'QA','Queretaro de Arteaga'),
(2975,138,'QR','Quintana Roo'),
(2976,138,'SA','San Luis Potosi'),
(2977,138,'SI','Sinaloa'),
(2978,138,'SO','Sonora'),
(2979,138,'TB','Tabasco'),
(2980,138,'TM','Tamaulipas'),
(2981,138,'TL','Tlaxcala'),
(2982,138,'VE','Veracruz-Llave'),
(2983,138,'YU','Yucatan'),
(2984,138,'ZA','Zacatecas'),
(2985,139,'C','Chuuk'),
(2986,139,'K','Kosrae'),
(2987,139,'P','Pohnpei'),
(2988,139,'Y','Yap'),
(2989,140,'GA','Gagauzia'),
(2990,140,'CU','Chisinau'),
(2991,140,'BA','Balti');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (2992,140,'CA','Cahul'),
(2993,140,'ED','Edinet'),
(2994,140,'LA','Lapusna'),
(2995,140,'OR','Orhei'),
(2996,140,'SO','Soroca'),
(2997,140,'TI','Tighina'),
(2998,140,'UN','Ungheni'),
(2999,140,'SN','Stânga Nistrului'),
(3000,141,'FV','Fontvieille'),
(3001,141,'LC','La Condamine'),
(3002,141,'MV','Monaco-Ville'),
(3003,141,'MC','Monte-Carlo'),
(3004,142,'1','Ulanbaatar'),
(3005,142,'035','Orhon'),
(3006,142,'037','Darhan uul'),
(3007,142,'039','Hentiy'),
(3008,142,'041','Hovsgol'),
(3009,142,'043','Hovd'),
(3010,142,'046','Uvs'),
(3011,142,'047','Tov');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3012,142,'049','Selenge'),
(3013,142,'051','Suhbaatar'),
(3014,142,'053','Omnogovi'),
(3015,142,'055','Ovorhangay'),
(3016,142,'057','Dzavhan'),
(3017,142,'059','DundgovL'),
(3018,142,'061','Dornod'),
(3019,142,'063','Dornogov'),
(3020,142,'064','Govi-Sumber'),
(3021,142,'065','Govi-Altay'),
(3022,142,'067','Bulgan'),
(3023,142,'069','Bayanhongor'),
(3024,142,'071','Bayan-Olgiy'),
(3025,142,'073','Arhangay'),
(3026,143,'A','Saint Anthony'),
(3027,143,'G','Saint Georges'),
(3028,143,'P','Saint Peter'),
(3029,144,'AGD','Agadir'),
(3030,144,'HOC','Al Hoceima'),
(3031,144,'AZI','Azilal');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3032,144,'BME','Beni Mellal'),
(3033,144,'BSL','Ben Slimane'),
(3034,144,'BLM','Boulemane'),
(3035,144,'CBL','Casablanca'),
(3036,144,'CHA','Chaouen'),
(3037,144,'EJA','El Jadida'),
(3038,144,'EKS','El Kelaa des Sraghna'),
(3039,144,'ERA','Er Rachidia'),
(3040,144,'ESS','Essaouira'),
(3041,144,'FES','Fes'),
(3042,144,'FIG','Figuig'),
(3043,144,'GLM','Guelmim'),
(3044,144,'IFR','Ifrane'),
(3045,144,'KEN','Kenitra'),
(3046,144,'KHM','Khemisset'),
(3047,144,'KHN','Khenifra'),
(3048,144,'KHO','Khouribga'),
(3049,144,'LYN','Laayoune'),
(3050,144,'LAR','Larache'),
(3051,144,'MRK','Marrakech');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3052,144,'MKN','Meknes'),
(3053,144,'NAD','Nador'),
(3054,144,'ORZ','Ouarzazate'),
(3055,144,'OUJ','Oujda'),
(3056,144,'RSA','Rabat-Sale'),
(3057,144,'SAF','Safi'),
(3058,144,'SET','Settat'),
(3059,144,'SKA','Sidi Kacem'),
(3060,144,'TGR','Tangier'),
(3061,144,'TAN','Tan-Tan'),
(3062,144,'TAO','Taounate'),
(3063,144,'TRD','Taroudannt'),
(3064,144,'TAT','Tata'),
(3065,144,'TAZ','Taza'),
(3066,144,'TET','Tetouan'),
(3067,144,'TIZ','Tiznit'),
(3068,144,'ADK','Ad Dakhla'),
(3069,144,'BJD','Boujdour'),
(3070,144,'ESM','Es Smara'),
(3071,145,'CD','Cabo Delgado');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3072,145,'GZ','Gaza'),
(3073,145,'IN','Inhambane'),
(3074,145,'MN','Manica'),
(3075,145,'MC','Maputo (city)'),
(3076,145,'MP','Maputo'),
(3077,145,'NA','Nampula'),
(3078,145,'NI','Niassa'),
(3079,145,'SO','Sofala'),
(3080,145,'TE','Tete'),
(3081,145,'ZA','Zambezia'),
(3082,146,'AY','Ayeyarwady'),
(3083,146,'BG','Bago'),
(3084,146,'MG','Magway'),
(3085,146,'MD','Mandalay'),
(3086,146,'SG','Sagaing'),
(3087,146,'TN','Tanintharyi'),
(3088,146,'YG','Yangon'),
(3089,146,'CH','Chin State'),
(3090,146,'KC','Kachin State'),
(3091,146,'KH','Kayah State');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3092,146,'KN','Kayin State'),
(3093,146,'MN','Mon State'),
(3094,146,'RK','Rakhine State'),
(3095,146,'SH','Shan State'),
(3096,147,'CA','Caprivi'),
(3097,147,'ER','Erongo'),
(3098,147,'HA','Hardap'),
(3099,147,'KR','Karas'),
(3100,147,'KV','Kavango'),
(3101,147,'KH','Khomas'),
(3102,147,'KU','Kunene'),
(3103,147,'OW','Ohangwena'),
(3104,147,'OK','Omaheke'),
(3105,147,'OT','Omusati'),
(3106,147,'ON','Oshana'),
(3107,147,'OO','Oshikoto'),
(3108,147,'OJ','Otjozondjupa'),
(3109,148,'AO','Aiwo'),
(3110,148,'AA','Anabar'),
(3111,148,'AT','Anetan');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3112,148,'AI','Anibare'),
(3113,148,'BA','Baiti'),
(3114,148,'BO','Boe'),
(3115,148,'BU','Buada'),
(3116,148,'DE','Denigomodu'),
(3117,148,'EW','Ewa'),
(3118,148,'IJ','Ijuw'),
(3119,148,'ME','Meneng'),
(3120,148,'NI','Nibok'),
(3121,148,'UA','Uaboe'),
(3122,148,'YA','Yaren'),
(3123,149,'BA','Bagmati'),
(3124,149,'BH','Bheri'),
(3125,149,'DH','Dhawalagiri'),
(3126,149,'GA','Gandaki'),
(3127,149,'JA','Janakpur'),
(3128,149,'KA','Karnali'),
(3129,149,'KO','Kosi'),
(3130,149,'LU','Lumbini'),
(3131,149,'MA','Mahakali');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3132,149,'ME','Mechi'),
(3133,149,'NA','Narayani'),
(3134,149,'RA','Rapti'),
(3135,149,'SA','Sagarmatha'),
(3136,149,'SE','Seti'),
(3137,150,'DR','Drenthe'),
(3138,150,'FL','Flevoland'),
(3139,150,'FR','Friesland'),
(3140,150,'GE','Gelderland'),
(3141,150,'GR','Groningen'),
(3142,150,'LI','Limburg'),
(3143,150,'NB','Noord Brabant'),
(3144,150,'NH','Noord Holland'),
(3145,150,'OV','Overijssel'),
(3146,150,'UT','Utrecht'),
(3147,150,'ZE','Zeeland'),
(3148,150,'ZH','Zuid Holland'),
(3149,152,'L','Iles Loyaute'),
(3150,152,'N','Nord'),
(3151,152,'S','Sud');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3152,153,'AUK','Auckland'),
(3153,153,'BOP','Bay of Plenty'),
(3154,153,'CAN','Canterbury'),
(3155,153,'GIS','Gisborne'),
(3156,153,'HKB','Hawkes Bay'),
(3157,153,'MBH','Marlborough'),
(3158,153,'MWT','Manawatu-Wanganui'),
(3159,153,'NSN','Nelson'),
(3160,153,'NTL','Northland'),
(3161,153,'OTA','Otago'),
(3162,153,'STL','Southland'),
(3163,153,'TAS','Tasman'),
(3164,153,'TKI','Taranaki'),
(3165,153,'WGN','Wellington'),
(3166,153,'WKO','Waikato'),
(3167,153,'WTC','West Coast'),
(3168,154,'AN','Atlantico Norte'),
(3169,154,'AS','Atlantico Sur'),
(3170,154,'BO','Boaco'),
(3171,154,'CA','Carazo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3172,154,'CI','Chinandega'),
(3173,154,'CO','Chontales'),
(3174,154,'ES','Esteli'),
(3175,154,'GR','Granada'),
(3176,154,'JI','Jinotega'),
(3177,154,'LE','Leon'),
(3178,154,'MD','Madriz'),
(3179,154,'MN','Managua'),
(3180,154,'MS','Masaya'),
(3181,154,'MT','Matagalpa'),
(3182,154,'NS','Nuevo Segovia'),
(3183,154,'RS','Rio San Juan'),
(3184,154,'RI','Rivas'),
(3185,155,'AG','Agadez'),
(3186,155,'DF','Diffa'),
(3187,155,'DS','Dosso'),
(3188,155,'MA','Maradi'),
(3189,155,'NM','Niamey'),
(3190,155,'TH','Tahoua'),
(3191,155,'TL','Tillaberi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3192,155,'ZD','Zinder'),
(3193,156,'AB','Abia'),
(3194,156,'CT','Abuja Federal Capital Territory'),
(3195,156,'AD','Adamawa'),
(3196,156,'AK','Akwa Ibom'),
(3197,156,'AN','Anambra'),
(3198,156,'BC','Bauchi'),
(3199,156,'BY','Bayelsa'),
(3200,156,'BN','Benue'),
(3201,156,'BO','Borno'),
(3202,156,'CR','Cross River'),
(3203,156,'DE','Delta'),
(3204,156,'EB','Ebonyi'),
(3205,156,'ED','Edo'),
(3206,156,'EK','Ekiti'),
(3207,156,'EN','Enugu'),
(3208,156,'GO','Gombe'),
(3209,156,'IM','Imo'),
(3210,156,'JI','Jigawa'),
(3211,156,'KD','Kaduna');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3212,156,'KN','Kano'),
(3213,156,'KT','Katsina'),
(3214,156,'KE','Kebbi'),
(3215,156,'KO','Kogi'),
(3216,156,'KW','Kwara'),
(3217,156,'LA','Lagos'),
(3218,156,'NA','Nassarawa'),
(3219,156,'NI','Niger'),
(3220,156,'OG','Ogun'),
(3221,156,'ONG','Ondo'),
(3222,156,'OS','Osun'),
(3223,156,'OY','Oyo'),
(3224,156,'PL','Plateau'),
(3225,156,'RI','Rivers'),
(3226,156,'SO','Sokoto'),
(3227,156,'TA','Taraba'),
(3228,156,'YO','Yobe'),
(3229,156,'ZA','Zamfara'),
(3230,159,'N','Northern Islands'),
(3231,159,'R','Rota');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3232,159,'S','Saipan'),
(3233,159,'T','Tinian'),
(3234,160,'AK','Akershus'),
(3235,160,'AA','Aust-Agder'),
(3236,160,'BU','Buskerud'),
(3237,160,'FM','Finnmark'),
(3238,160,'HM','Hedmark'),
(3239,160,'HL','Hordaland'),
(3240,160,'MR','More og Romdal'),
(3241,160,'NT','Nord-Trondelag'),
(3242,160,'NL','Nordland'),
(3243,160,'OF','Ostfold'),
(3244,160,'OP','Oppland'),
(3245,160,'OL','Oslo'),
(3246,160,'RL','Rogaland'),
(3247,160,'ST','Sor-Trondelag'),
(3248,160,'SJ','Sogn og Fjordane'),
(3249,160,'SV','Svalbard'),
(3250,160,'TM','Telemark'),
(3251,160,'TR','Troms');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3252,160,'VA','Vest-Agder'),
(3253,160,'VF','Vestfold'),
(3254,161,'DA','Ad Dakhiliyah'),
(3255,161,'BA','Al Batinah'),
(3256,161,'WU','Al Wusta'),
(3257,161,'SH','Ash Sharqiyah'),
(3258,161,'ZA','Az Zahirah'),
(3259,161,'MA','Masqat'),
(3260,161,'MU','Musandam'),
(3261,161,'ZU','Zufar'),
(3262,162,'B','Balochistan'),
(3263,162,'T','Federally Administered Tribal Ar'),
(3264,162,'I','Islamabad Capital Territory'),
(3265,162,'N','North-West Frontier'),
(3266,162,'P','Punjab'),
(3267,162,'S','Sindh '),
(3268,163,'AM','Aimeliik'),
(3269,163,'AR','Airai'),
(3270,163,'AN','Angaur'),
(3271,163,'HA','Hatohobei');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3272,163,'KA','Kayangel'),
(3273,163,'KO','Koror'),
(3274,163,'ME','Melekeok'),
(3275,163,'NA','Ngaraard'),
(3276,163,'NG','Ngarchelong'),
(3277,163,'ND','Ngardmau'),
(3278,163,'NT','Ngatpang'),
(3279,163,'NC','Ngchesar'),
(3280,163,'NR','Ngeremlengui'),
(3281,163,'NW','Ngiwal'),
(3282,163,'PE','Peleliu'),
(3283,163,'SO','Sonsorol'),
(3284,164,'BT','Bocas del Toro'),
(3285,164,'CH','Chiriqui'),
(3286,164,'CC','Cocle'),
(3287,164,'CL','Colon'),
(3288,164,'DA','Darien'),
(3289,164,'HE','Herrera'),
(3290,164,'LS','Los Santos'),
(3291,164,'PA','Panama');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3292,164,'SB','San Blas'),
(3293,164,'VG','Veraguas'),
(3294,165,'BV','Bougainville'),
(3295,165,'CE','Central'),
(3296,165,'CH','Chimbu'),
(3297,165,'EH','Eastern Highlands'),
(3298,165,'EB','East New Britain'),
(3299,165,'ES','East Sepik'),
(3300,165,'EN','Enga'),
(3301,165,'GU','Gulf'),
(3302,165,'MD','Madang'),
(3303,165,'MN','Manus'),
(3304,165,'MB','Milne Bay'),
(3305,165,'MR','Morobe'),
(3306,165,'NC','National Capital'),
(3307,165,'NI','New Ireland'),
(3308,165,'NO','Northern'),
(3309,165,'SA','Sandaun'),
(3310,165,'SH','Southern Highlands'),
(3311,165,'WE','Western');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3312,165,'WH','Western Highlands'),
(3313,165,'WB','West New Britain'),
(3314,166,'AG','Alto Paraguay'),
(3315,166,'AN','Alto Parana'),
(3316,166,'AM','Amambay'),
(3317,166,'AS','Asuncion'),
(3318,166,'BO','Boqueron'),
(3319,166,'CG','Caaguazu'),
(3320,166,'CZ','Caazapa'),
(3321,166,'CN','Canindeyu'),
(3322,166,'CE','Central'),
(3323,166,'CC','Concepcion'),
(3324,166,'CD','Cordillera'),
(3325,166,'GU','Guaira'),
(3326,166,'IT','Itapua'),
(3327,166,'MI','Misiones'),
(3328,166,'NE','Neembucu'),
(3329,166,'PA','Paraguari'),
(3330,166,'PH','Presidente Hayes'),
(3331,166,'SP','San Pedro');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3332,167,'AM','Amazonas'),
(3333,167,'AN','Ancash'),
(3334,167,'AP','Apurimac'),
(3335,167,'AR','Arequipa'),
(3336,167,'AY','Ayacucho'),
(3337,167,'CJ','Cajamarca'),
(3338,167,'CL','Callao'),
(3339,167,'CU','Cusco'),
(3340,167,'HV','Huancavelica'),
(3341,167,'HO','Huanuco'),
(3342,167,'IC','Ica'),
(3343,167,'JU','Junin'),
(3344,167,'LD','La Libertad'),
(3345,167,'LY','Lambayeque'),
(3346,167,'LI','Lima'),
(3347,167,'LO','Loreto'),
(3348,167,'MD','Madre de Dios'),
(3349,167,'MO','Moquegua'),
(3350,167,'PA','Pasco'),
(3351,167,'PI','Piura');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3352,167,'PU','Puno'),
(3353,167,'SM','San Martin'),
(3354,167,'TA','Tacna'),
(3355,167,'TU','Tumbes'),
(3356,167,'UC','Ucayali'),
(3357,168,'ABR','Abra'),
(3358,168,'ANO','Agusan del Norte'),
(3359,168,'ASU','Agusan del Sur'),
(3360,168,'AKL','Aklan'),
(3361,168,'ALB','Albay'),
(3362,168,'ANT','Antique'),
(3363,168,'APY','Apayao'),
(3364,168,'AUR','Aurora'),
(3365,168,'BAS','Basilan'),
(3366,168,'BTA','Bataan'),
(3367,168,'BTE','Batanes'),
(3368,168,'BTG','Batangas'),
(3369,168,'BLR','Biliran'),
(3370,168,'BEN','Benguet'),
(3371,168,'BOL','Bohol');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3372,168,'BUK','Bukidnon'),
(3373,168,'BUL','Bulacan'),
(3374,168,'CAG','Cagayan'),
(3375,168,'CNO','Camarines Norte'),
(3376,168,'CSU','Camarines Sur'),
(3377,168,'CAM','Camiguin'),
(3378,168,'CAP','Capiz'),
(3379,168,'CAT','Catanduanes'),
(3380,168,'CAV','Cavite'),
(3381,168,'CEB','Cebu'),
(3382,168,'CMP','Compostela'),
(3383,168,'DNO','Davao del Norte'),
(3384,168,'DSU','Davao del Sur'),
(3385,168,'DOR','Davao Oriental'),
(3386,168,'ESA','Eastern Samar'),
(3387,168,'GUI','Guimaras'),
(3388,168,'IFU','Ifugao'),
(3389,168,'INO','Ilocos Norte'),
(3390,168,'ISU','Ilocos Sur'),
(3391,168,'ILO','Iloilo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3392,168,'ISA','Isabela'),
(3393,168,'KAL','Kalinga'),
(3394,168,'LAG','Laguna'),
(3395,168,'LNO','Lanao del Norte'),
(3396,168,'LSU','Lanao del Sur'),
(3397,168,'UNI','La Union'),
(3398,168,'LEY','Leyte'),
(3399,168,'MAG','Maguindanao'),
(3400,168,'MRN','Marinduque'),
(3401,168,'MSB','Masbate'),
(3402,168,'MIC','Mindoro Occidental'),
(3403,168,'MIR','Mindoro Oriental'),
(3404,168,'MSC','Misamis Occidental'),
(3405,168,'MOR','Misamis Oriental'),
(3406,168,'MOP','Mountain'),
(3407,168,'NOC','Negros Occidental'),
(3408,168,'NOR','Negros Oriental'),
(3409,168,'NCT','North Cotabato'),
(3410,168,'NSM','Northern Samar'),
(3411,168,'NEC','Nueva Ecija');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3412,168,'NVZ','Nueva Vizcaya'),
(3413,168,'PLW','Palawan'),
(3414,168,'PMP','Pampanga'),
(3415,168,'PNG','Pangasinan'),
(3416,168,'QZN','Quezon'),
(3417,168,'QRN','Quirino'),
(3418,168,'RIZ','Rizal'),
(3419,168,'ROM','Romblon'),
(3420,168,'SMR','Samar'),
(3421,168,'SRG','Sarangani'),
(3422,168,'SQJ','Siquijor'),
(3423,168,'SRS','Sorsogon'),
(3424,168,'SCO','South Cotabato'),
(3425,168,'SLE','Southern Leyte'),
(3426,168,'SKU','Sultan Kudarat'),
(3427,168,'SLU','Sulu'),
(3428,168,'SNO','Surigao del Norte'),
(3429,168,'SSU','Surigao del Sur'),
(3430,168,'TAR','Tarlac'),
(3431,168,'TAW','Tawi-Tawi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3432,168,'ZBL','Zambales'),
(3433,168,'ZNO','Zamboanga del Norte'),
(3434,168,'ZSU','Zamboanga del Sur'),
(3435,168,'ZSI','Zamboanga Sibugay'),
(3436,198,'P','Saint Pierre'),
(3437,198,'M','Miquelon'),
(3438,171,'AC','A&ccedil;ores'),
(3439,171,'AV','Aveiro'),
(3440,171,'BE','Beja'),
(3441,171,'BR','Braga'),
(3442,171,'BA','Bragan&ccedil;a'),
(3443,171,'CB','Castelo Branco'),
(3444,171,'CO','Coimbra'),
(3445,171,'EV','&Eacute;vora'),
(3446,171,'FA','Faro'),
(3447,171,'GU','Guarda'),
(3448,171,'LE','Leiria'),
(3449,171,'LI','Lisboa'),
(3450,171,'ME','Madeira'),
(3451,171,'PO','Portalegre');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3452,171,'PR','Porto'),
(3453,171,'SA','Santar&eacute;m'),
(3454,171,'SE','Set&uacute;bal'),
(3455,171,'VC','Viana do Castelo'),
(3456,171,'VR','Vila Real'),
(3457,171,'VI','Viseu'),
(3458,173,'DW','Ad Dawhah'),
(3459,173,'GW','Al Ghuwayriyah'),
(3460,173,'JM','Al Jumayliyah'),
(3461,173,'KR','Al Khawr'),
(3462,173,'WK','Al Wakrah'),
(3463,173,'RN','Ar Rayyan'),
(3464,173,'JB','Jarayan al Batinah'),
(3465,173,'MS','Madinat ash Shamal'),
(3466,173,'UD','Umm Said'),
(3467,173,'UL','Umm Salal'),
(3468,175,'AB','Alba'),
(3469,175,'AR','Arad'),
(3470,175,'AG','Arges'),
(3471,175,'BC','Bacau');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3472,175,'BH','Bihor'),
(3473,175,'BN','Bistrita-Nasaud'),
(3474,175,'BT','Botosani'),
(3475,175,'BV','Brasov'),
(3476,175,'BR','Braila'),
(3477,175,'B','Bucuresti'),
(3478,175,'BZ','Buzau'),
(3479,175,'CS','Caras-Severin'),
(3480,175,'CL','Calarasi'),
(3481,175,'CJ','Cluj'),
(3482,175,'CT','Constanta'),
(3483,175,'CV','Covasna'),
(3484,175,'DB','Dimbovita'),
(3485,175,'DJ','Dolj'),
(3486,175,'GL','Galati'),
(3487,175,'GR','Giurgiu'),
(3488,175,'GJ','Gorj'),
(3489,175,'HR','Harghita'),
(3490,175,'HD','Hunedoara'),
(3491,175,'IL','Ialomita');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3492,175,'IS','Iasi'),
(3493,175,'IF','Ilfov'),
(3494,175,'MM','Maramures'),
(3495,175,'MH','Mehedinti'),
(3496,175,'MS','Mures'),
(3497,175,'NT','Neamt'),
(3498,175,'OT','Olt'),
(3499,175,'PH','Prahova'),
(3500,175,'SM','Satu-Mare'),
(3501,175,'SJ','Salaj'),
(3502,175,'SB','Sibiu'),
(3503,175,'SV','Suceava'),
(3504,175,'TR','Teleorman'),
(3505,175,'TM','Timis'),
(3506,175,'TL','Tulcea'),
(3507,175,'VS','Vaslui'),
(3508,175,'VL','Valcea'),
(3509,175,'VN','Vrancea'),
(3510,176,'AB','Abakan'),
(3511,176,'AG','Aginskoye');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3512,176,'AN','Anadyr'),
(3513,176,'AR','Arkahangelsk'),
(3514,176,'AS','Astrakhan'),
(3515,176,'BA','Barnaul'),
(3516,176,'BE','Belgorod'),
(3517,176,'BI','Birobidzhan'),
(3518,176,'BL','Blagoveshchensk'),
(3519,176,'BR','Bryansk'),
(3520,176,'CH','Cheboksary'),
(3521,176,'CL','Chelyabinsk'),
(3522,176,'CR','Cherkessk'),
(3523,176,'CI','Chita'),
(3524,176,'DU','Dudinka'),
(3525,176,'EL','Elista'),
(3526,176,'GO','Gomo-Altaysk'),
(3527,176,'GA','Gorno-Altaysk'),
(3528,176,'GR','Groznyy'),
(3529,176,'IR','Irkutsk'),
(3530,176,'IV','Ivanovo'),
(3531,176,'IZ','Izhevsk');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3532,176,'KA','Kalinigrad'),
(3533,176,'KL','Kaluga'),
(3534,176,'KS','Kasnodar'),
(3535,176,'KZ','Kazan'),
(3536,176,'KE','Kemerovo'),
(3537,176,'KH','Khabarovsk'),
(3538,176,'KM','Khanty-Mansiysk'),
(3539,176,'KO','Kostroma'),
(3540,176,'KR','Krasnodar'),
(3541,176,'KN','Krasnoyarsk'),
(3542,176,'KU','Kudymkar'),
(3543,176,'KG','Kurgan'),
(3544,176,'KK','Kursk'),
(3545,176,'KY','Kyzyl'),
(3546,176,'LI','Lipetsk'),
(3547,176,'MA','Magadan'),
(3548,176,'MK','Makhachkala'),
(3549,176,'MY','Maykop'),
(3550,176,'MO','Moscow'),
(3551,176,'MU','Murmansk');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3552,176,'NA','Nalchik'),
(3553,176,'NR','Naryan Mar'),
(3554,176,'NZ','Nazran'),
(3555,176,'NI','Nizhniy Novgorod'),
(3556,176,'NO','Novgorod'),
(3557,176,'NV','Novosibirsk'),
(3558,176,'OM','Omsk'),
(3559,176,'OR','Orel'),
(3560,176,'OE','Orenburg'),
(3561,176,'PA','Palana'),
(3562,176,'PE','Penza'),
(3563,176,'PR','Perm'),
(3564,176,'PK','Petropavlovsk-Kamchatskiy'),
(3565,176,'PT','Petrozavodsk'),
(3566,176,'PS','Pskov'),
(3567,176,'RO','Rostov-na-Donu'),
(3568,176,'RY','Ryazan'),
(3569,176,'SL','Salekhard'),
(3570,176,'SA','Samara'),
(3571,176,'SR','Saransk');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3572,176,'SV','Saratov'),
(3573,176,'SM','Smolensk'),
(3574,176,'SP','St. Petersburg'),
(3575,176,'ST','Stavropol'),
(3576,176,'SY','Syktyvkar'),
(3577,176,'TA','Tambov'),
(3578,176,'TO','Tomsk'),
(3579,176,'TU','Tula'),
(3580,176,'TR','Tura'),
(3581,176,'TV','Tver'),
(3582,176,'TY','Tyumen'),
(3583,176,'UF','Ufa'),
(3584,176,'UL','Ulyanovsk'),
(3585,176,'UU','Ulan-Ude'),
(3586,176,'US','Ust-Ordynskiy'),
(3587,176,'VL','Vladikavkaz'),
(3588,176,'VA','Vladimir'),
(3589,176,'VV','Vladivostok'),
(3590,176,'VG','Volgograd'),
(3591,176,'VD','Vologda');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3592,176,'VO','Voronezh'),
(3593,176,'VY','Vyatka'),
(3594,176,'YA','Yakutsk'),
(3595,176,'YR','Yaroslavl'),
(3596,176,'YE','Yekaterinburg'),
(3597,176,'YO','Yoshkar-Ola'),
(3598,177,'BU','Butare'),
(3599,177,'BY','Byumba'),
(3600,177,'CY','Cyangugu'),
(3601,177,'GK','Gikongoro'),
(3602,177,'GS','Gisenyi'),
(3603,177,'GT','Gitarama'),
(3604,177,'KG','Kibungo'),
(3605,177,'KY','Kibuye'),
(3606,177,'KR','Kigali Rurale'),
(3607,177,'KV','Kigali-ville'),
(3608,177,'RU','Ruhengeri'),
(3609,177,'UM','Umutara'),
(3610,178,'CCN','Christ Church Nichola Town'),
(3611,178,'SAS','Saint Anne Sandy Point');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3612,178,'SGB','Saint George Basseterre'),
(3613,178,'SGG','Saint George Gingerland'),
(3614,178,'SJW','Saint James Windward'),
(3615,178,'SJC','Saint John Capesterre'),
(3616,178,'SJF','Saint John Figtree'),
(3617,178,'SMC','Saint Mary Cayon'),
(3618,178,'CAP','Saint Paul Capesterre'),
(3619,178,'CHA','Saint Paul Charlestown'),
(3620,178,'SPB','Saint Peter Basseterre'),
(3621,178,'STL','Saint Thomas Lowland'),
(3622,178,'STM','Saint Thomas Middle Island'),
(3623,178,'TPP','Trinity Palmetto Point'),
(3624,179,'AR','Anse-la-Raye'),
(3625,179,'CA','Castries'),
(3626,179,'CH','Choiseul'),
(3627,179,'DA','Dauphin'),
(3628,179,'DE','Dennery'),
(3629,179,'GI','Gros-Islet'),
(3630,179,'LA','Laborie'),
(3631,179,'MI','Micoud');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3632,179,'PR','Praslin'),
(3633,179,'SO','Soufriere'),
(3634,179,'VF','Vieux-Fort'),
(3635,180,'C','Charlotte'),
(3636,180,'R','Grenadines'),
(3637,180,'A','Saint Andrew'),
(3638,180,'D','Saint David'),
(3639,180,'G','Saint George'),
(3640,180,'P','Saint Patrick'),
(3641,181,'AN','Aana'),
(3642,181,'AI','Aiga-i-le-Tai'),
(3643,181,'AT','Atua'),
(3644,181,'FA','Faasaleleaga'),
(3645,181,'GE','Gagaemauga'),
(3646,181,'GF','Gagaifomauga'),
(3647,181,'PA','Palauli'),
(3648,181,'SA','Satupaitea'),
(3649,181,'TU','Tuamasaga'),
(3650,181,'VF','Vaa-o-Fonoti'),
(3651,181,'VS','Vaisigano');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3652,182,'AC','Acquaviva'),
(3653,182,'BM','Borgo Maggiore'),
(3654,182,'CH','Chiesanuova'),
(3655,182,'DO','Domagnano'),
(3656,182,'FA','Faetano'),
(3657,182,'FI','Fiorentino'),
(3658,182,'MO','Montegiardino'),
(3659,182,'SM','Citta di San Marino'),
(3660,182,'SE','Serravalle'),
(3661,183,'S','Sao Tome'),
(3662,183,'P','Principe'),
(3663,184,'BH','Al Bahah'),
(3664,184,'HS','Al Hudud ash Shamaliyah'),
(3665,184,'JF','Al Jawf'),
(3666,184,'MD','Al Madinah'),
(3667,184,'QS','Al Qasim'),
(3668,184,'RD','Ar Riyad'),
(3669,184,'AQ','Ash Sharqiyah (Eastern)'),
(3670,184,'AS','Asir'),
(3671,184,'HL','Hail');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3672,184,'JZ','Jizan'),
(3673,184,'ML','Makkah'),
(3674,184,'NR','Najran'),
(3675,184,'TB','Tabuk'),
(3676,185,'DA','Dakar'),
(3677,185,'DI','Diourbel'),
(3678,185,'FA','Fatick'),
(3679,185,'KA','Kaolack'),
(3680,185,'KO','Kolda'),
(3681,185,'LO','Louga'),
(3682,185,'MA','Matam'),
(3683,185,'SL','Saint-Louis'),
(3684,185,'TA','Tambacounda'),
(3685,185,'TH','Thies '),
(3686,185,'ZI','Ziguinchor'),
(3687,186,'AP','Anse aux Pins'),
(3688,186,'AB','Anse Boileau'),
(3689,186,'AE','Anse Etoile'),
(3690,186,'AL','Anse Louis'),
(3691,186,'AR','Anse Royale');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3692,186,'BL','Baie Lazare'),
(3693,186,'BS','Baie Sainte Anne'),
(3694,186,'BV','Beau Vallon'),
(3695,186,'BA','Bel Air'),
(3696,186,'BO','Bel Ombre'),
(3697,186,'CA','Cascade'),
(3698,186,'GL','Glacis'),
(3699,186,'GM','Grand Anse (on Mahe)'),
(3700,186,'GP','Grand Anse (on Praslin)'),
(3701,186,'DG','La Digue'),
(3702,186,'RA','La Riviere Anglaise'),
(3703,186,'MB','Mont Buxton'),
(3704,186,'MF','Mont Fleuri'),
(3705,186,'PL','Plaisance'),
(3706,186,'PR','Pointe La Rue'),
(3707,186,'PG','Port Glaud'),
(3708,186,'SL','Saint Louis'),
(3709,186,'TA','Takamaka'),
(3710,187,'E','Eastern'),
(3711,187,'N','Northern');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3712,187,'S','Southern'),
(3713,187,'W','Western'),
(3714,189,'BA','Banskobystricky'),
(3715,189,'BR','Bratislavsky'),
(3716,189,'KO','Kosicky'),
(3717,189,'NI','Nitriansky'),
(3718,189,'PR','Presovsky'),
(3719,189,'TC','Trenciansky'),
(3720,189,'TV','Trnavsky'),
(3721,189,'ZI','Zilinsky'),
(3722,191,'CE','Central'),
(3723,191,'CH','Choiseul'),
(3724,191,'GC','Guadalcanal'),
(3725,191,'HO','Honiara'),
(3726,191,'IS','Isabel'),
(3727,191,'MK','Makira'),
(3728,191,'ML','Malaita'),
(3729,191,'RB','Rennell and Bellona'),
(3730,191,'TM','Temotu'),
(3731,191,'WE','Western');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3732,192,'AW','Awdal'),
(3733,192,'BK','Bakool'),
(3734,192,'BN','Banaadir'),
(3735,192,'BR','Bari'),
(3736,192,'BY','Bay'),
(3737,192,'GA','Galguduud'),
(3738,192,'GE','Gedo'),
(3739,192,'HI','Hiiraan'),
(3740,192,'JD','Jubbada Dhexe'),
(3741,192,'JH','Jubbada Hoose'),
(3742,192,'MU','Mudug'),
(3743,192,'NU','Nugaal'),
(3744,192,'SA','Sanaag'),
(3745,192,'SD','Shabeellaha Dhexe'),
(3746,192,'SH','Shabeellaha Hoose'),
(3747,192,'SL','Sool'),
(3748,192,'TO','Togdheer'),
(3749,192,'WG','Woqooyi Galbeed'),
(3750,193,'EC','Eastern Cape'),
(3751,193,'FS','Free State');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3752,193,'GT','Gauteng'),
(3753,193,'KN','KwaZulu-Natal'),
(3754,193,'LP','Limpopo'),
(3755,193,'MP','Mpumalanga'),
(3756,193,'NW','North West'),
(3757,193,'NC','Northern Cape'),
(3758,193,'WC','Western Cape'),
(3759,195,'CA','A Coru&ntilde;a'),
(3760,195,'AL','&Aacute;lava'),
(3761,195,'AB','Albacete'),
(3762,195,'AC','Alicante'),
(3763,195,'AM','Almeria'),
(3764,195,'AS','Asturias'),
(3765,195,'AV','&Aacute;vila'),
(3766,195,'BJ','Badajoz'),
(3767,195,'IB','Baleares'),
(3768,195,'BA','Barcelona'),
(3769,195,'BU','Burgos'),
(3770,195,'CC','C&aacute;ceres'),
(3771,195,'CZ','C&aacute;diz');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3772,195,'CT','Cantabria'),
(3773,195,'CL','Castell&oacute;n'),
(3774,195,'CE','Ceuta'),
(3775,195,'CR','Ciudad Real'),
(3776,195,'CD','C&oacute;rdoba'),
(3777,195,'CU','Cuenca'),
(3778,195,'GI','Girona'),
(3779,195,'GD','Granada'),
(3780,195,'GJ','Guadalajara'),
(3781,195,'GP','Guip&uacute;zcoa'),
(3782,195,'HL','Huelva'),
(3783,195,'HS','Huesca'),
(3784,195,'JN','Ja&eacute;n'),
(3785,195,'RJ','La Rioja'),
(3786,195,'PM','Las Palmas'),
(3787,195,'LE','Leon'),
(3788,195,'LL','Lleida'),
(3789,195,'LG','Lugo'),
(3790,195,'MD','Madrid'),
(3791,195,'MA','Malaga');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3792,195,'ML','Melilla'),
(3793,195,'MU','Murcia'),
(3794,195,'NV','Navarra'),
(3795,195,'OU','Ourense'),
(3796,195,'PL','Palencia'),
(3797,195,'PO','Pontevedra'),
(3798,195,'SL','Salamanca'),
(3799,195,'SC','Santa Cruz de Tenerife'),
(3800,195,'SG','Segovia'),
(3801,195,'SV','Sevilla'),
(3802,195,'SO','Soria'),
(3803,195,'TA','Tarragona'),
(3804,195,'TE','Teruel'),
(3805,195,'TO','Toledo'),
(3806,195,'VC','Valencia'),
(3807,195,'VD','Valladolid'),
(3808,195,'VZ','Vizcaya'),
(3809,195,'ZM','Zamora'),
(3810,195,'ZR','Zaragoza'),
(3811,196,'CE','Central');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3812,196,'EA','Eastern'),
(3813,196,'NC','North Central'),
(3814,196,'NO','Northern'),
(3815,196,'NW','North Western'),
(3816,196,'SA','Sabaragamuwa'),
(3817,196,'SO','Southern'),
(3818,196,'UV','Uva'),
(3819,196,'WE','Western'),
(3820,197,'A','Ascension'),
(3821,197,'S','Saint Helena'),
(3822,197,'T','Tristan da Cunha'),
(3823,199,'ANL','Aali an Nil'),
(3824,199,'BAM','Al Bahr al Ahmar'),
(3825,199,'BRT','Al Buhayrat'),
(3826,199,'JZR','Al Jazirah'),
(3827,199,'KRT','Al Khartum'),
(3828,199,'QDR','Al Qadarif'),
(3829,199,'WDH','Al Wahdah'),
(3830,199,'ANB','An Nil al Abyad'),
(3831,199,'ANZ','An Nil al Azraq');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3832,199,'ASH','Ash Shamaliyah'),
(3833,199,'BJA','Bahr al Jabal'),
(3834,199,'GIS','Gharb al Istiwaiyah'),
(3835,199,'GBG','Gharb Bahr al Ghazal'),
(3836,199,'GDA','Gharb Darfur'),
(3837,199,'GKU','Gharb Kurdufan'),
(3838,199,'JDA','Janub Darfur'),
(3839,199,'JKU','Janub Kurdufan'),
(3840,199,'JQL','Junqali'),
(3841,199,'KSL','Kassala'),
(3842,199,'NNL','Nahr an Nil'),
(3843,199,'SBG','Shamal Bahr al Ghazal'),
(3844,199,'SDA','Shamal Darfur'),
(3845,199,'SKU','Shamal Kurdufan'),
(3846,199,'SIS','Sharq al Istiwaiyah'),
(3847,199,'SNR','Sinnar'),
(3848,199,'WRB','Warab'),
(3849,200,'BR','Brokopondo'),
(3850,200,'CM','Commewijne'),
(3851,200,'CR','Coronie');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3852,200,'MA','Marowijne'),
(3853,200,'NI','Nickerie'),
(3854,200,'PA','Para'),
(3855,200,'PM','Paramaribo'),
(3856,200,'SA','Saramacca'),
(3857,200,'SI','Sipaliwini'),
(3858,200,'WA','Wanica'),
(3859,202,'H','Hhohho'),
(3860,202,'L','Lubombo'),
(3861,202,'M','Manzini'),
(3862,202,'S','Shishelweni'),
(3863,203,'BL','Blekinge'),
(3864,203,'DA','Dalama'),
(3865,203,'GA','Gavleborg'),
(3866,203,'GO','Gotland'),
(3867,203,'HA','Halland'),
(3868,203,'JA','Jamtland'),
(3869,203,'JO','Jonkping'),
(3870,203,'KA','Kalmar'),
(3871,203,'KR','Kronoberg');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3872,203,'NO','Norrbotten'),
(3873,203,'OR','Orebro'),
(3874,203,'OG','Ostergotland'),
(3875,203,'SK','Skane'),
(3876,203,'SO','Sodermanland'),
(3877,203,'ST','Stockholm'),
(3878,203,'UP','Uppdala'),
(3879,203,'VL','Varmland'),
(3880,203,'VB','Vasterbotten'),
(3881,203,'VN','Vasternorrland'),
(3882,203,'VM','Vastmanland'),
(3883,203,'VG','Vastra Gotaland'),
(3884,204,'AG','Aargau'),
(3885,204,'AR','Appenzell Ausserrhoden'),
(3886,204,'AI','Appenzell Innerrhoden'),
(3887,204,'BS','Basel-Stadt'),
(3888,204,'BL','Basel-Landschaft'),
(3889,204,'BE','Bern'),
(3890,204,'FR','Fribourg'),
(3891,204,'GE','Gen&egrave;ve');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3892,204,'GL','Glarus'),
(3893,204,'GR','Graubünden'),
(3894,204,'JU','Jura'),
(3895,204,'LU','Luzern'),
(3896,204,'NE','Neuchâtel'),
(3897,204,'NW','Nidwald'),
(3898,204,'OW','Obwald'),
(3899,204,'SG','St. Gallen'),
(3900,204,'SH','Schaffhausen'),
(3901,204,'SZ','Schwyz'),
(3902,204,'SO','Solothurn'),
(3903,204,'TG','Thurgau'),
(3904,204,'TI','Ticino'),
(3905,204,'UR','Uri'),
(3906,204,'VS','Valais'),
(3907,204,'VD','Vaud'),
(3908,204,'ZG','Zug'),
(3909,204,'ZH','Z&uuml;rich'),
(3910,205,'HA','Al Hasakah'),
(3911,205,'LA','Al Ladhiqiyah');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3912,205,'QU','Al Qunaytirah'),
(3913,205,'RQ','Ar Raqqah'),
(3914,205,'SU','As Suwayda'),
(3915,205,'DA','Dara'),
(3916,205,'DZ','Dayr az Zawr'),
(3917,205,'DI','Dimashq'),
(3918,205,'HL','Halab'),
(3919,205,'HM','Hamah'),
(3920,205,'HI','Hims'),
(3921,205,'ID','Idlib'),
(3922,205,'RD','Rif Dimashq'),
(3923,205,'TA','Tartus'),
(3924,206,'CH','Chang-hua'),
(3925,206,'CI','Chia-i'),
(3926,206,'HS','Hsin-chu'),
(3927,206,'HL','Hua-lien'),
(3928,206,'IL','I-lan'),
(3929,206,'KH','Kao-hsiung county'),
(3930,206,'KM','Kin-men'),
(3931,206,'LC','Lien-chiang');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3932,206,'ML','Miao-li'),
(3933,206,'NT','Nan-tou'),
(3934,206,'PH','Peng-hu'),
(3935,206,'PT','Ping-tung'),
(3936,206,'TG','Tai-chung'),
(3937,206,'TA','Tai-nan'),
(3938,206,'TP','Tai-pei county'),
(3939,206,'TT','Tai-tung'),
(3940,206,'TY','Tao-yuan'),
(3941,206,'YL','Yun-lin'),
(3942,206,'CC','Chia-i city'),
(3943,206,'CL','Chi-lung'),
(3944,206,'HC','Hsin-chu'),
(3945,206,'TH','Tai-chung'),
(3946,206,'TN','Tai-nan'),
(3947,206,'KC','Kao-hsiung city '),
(3948,206,'TC','Tai-pei city '),
(3949,207,'GB','Gorno-Badakhstan'),
(3950,207,'KT','Khatlon'),
(3951,207,'SU','Sughd');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3952,208,'AR','Arusha'),
(3953,208,'DS','Dar es Salaam'),
(3954,208,'DO','Dodoma'),
(3955,208,'IR','Iringa'),
(3956,208,'KA','Kagera'),
(3957,208,'KI','Kigoma'),
(3958,208,'KJ','Kilimanjaro'),
(3959,208,'LN','Lindi'),
(3960,208,'MY','Manyara'),
(3961,208,'MR','Mara'),
(3962,208,'MB','Mbeya'),
(3963,208,'MO','Morogoro'),
(3964,208,'MT','Mtwara'),
(3965,208,'MW','Mwanza'),
(3966,208,'PN','Pemba North'),
(3967,208,'PS','Pemba South'),
(3968,208,'PW','Pwani'),
(3969,208,'RK','Rukwa'),
(3970,208,'RV','Ruvuma'),
(3971,208,'SH','Shinyanga');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3972,208,'SI','Singida'),
(3973,208,'TB','Tabora'),
(3974,208,'TN','Tanga'),
(3975,208,'ZC','Zanzibar Central/South'),
(3976,208,'ZN','Zanzibar North'),
(3977,208,'ZU','Zanzibar Urban/West'),
(3978,209,'Amnat Charoen','Amnat Charoen'),
(3979,209,'Ang Thong','Ang Thong'),
(3980,209,'Ayutthaya','Ayutthaya'),
(3981,209,'Bangkok','Bangkok'),
(3982,209,'Buriram','Buriram'),
(3983,209,'Chachoengsao','Chachoengsao'),
(3984,209,'Chai Nat','Chai Nat'),
(3985,209,'Chaiyaphum','Chaiyaphum'),
(3986,209,'Chanthaburi','Chanthaburi'),
(3987,209,'Chiang Mai','Chiang Mai'),
(3988,209,'Chiang Rai','Chiang Rai'),
(3989,209,'Chon Buri','Chon Buri'),
(3990,209,'Chumphon','Chumphon'),
(3991,209,'Kalasin','Kalasin');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (3992,209,'Kamphaeng Phet','Kamphaeng Phet'),
(3993,209,'Kanchanaburi','Kanchanaburi'),
(3994,209,'Khon Kaen','Khon Kaen'),
(3995,209,'Krabi','Krabi'),
(3996,209,'Lampang','Lampang'),
(3997,209,'Lamphun','Lamphun'),
(3998,209,'Loei','Loei'),
(3999,209,'Lop Buri','Lop Buri'),
(4000,209,'Mae Hong Son','Mae Hong Son'),
(4001,209,'Maha Sarakham','Maha Sarakham'),
(4002,209,'Mukdahan','Mukdahan'),
(4003,209,'Nakhon Nayok','Nakhon Nayok'),
(4004,209,'Nakhon Pathom','Nakhon Pathom'),
(4005,209,'Nakhon Phanom','Nakhon Phanom'),
(4006,209,'Nakhon Ratchasima','Nakhon Ratchasima'),
(4007,209,'Nakhon Sawan','Nakhon Sawan'),
(4008,209,'Nakhon Si Thammarat','Nakhon Si Thammarat'),
(4009,209,'Nan','Nan'),
(4010,209,'Narathiwat','Narathiwat'),
(4011,209,'Nong Bua Lamphu','Nong Bua Lamphu');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4012,209,'Nong Khai','Nong Khai'),
(4013,209,'Nonthaburi','Nonthaburi'),
(4014,209,'Pathum Thani','Pathum Thani'),
(4015,209,'Pattani','Pattani'),
(4016,209,'Phangnga','Phangnga'),
(4017,209,'Phatthalung','Phatthalung'),
(4018,209,'Phayao','Phayao'),
(4019,209,'Phetchabun','Phetchabun'),
(4020,209,'Phetchaburi','Phetchaburi'),
(4021,209,'Phichit','Phichit'),
(4022,209,'Phitsanulok','Phitsanulok'),
(4023,209,'Phrae','Phrae'),
(4024,209,'Phuket','Phuket'),
(4025,209,'Prachin Buri','Prachin Buri'),
(4026,209,'Prachuap Khiri Khan','Prachuap Khiri Khan'),
(4027,209,'Ranong','Ranong'),
(4028,209,'Ratchaburi','Ratchaburi'),
(4029,209,'Rayong','Rayong'),
(4030,209,'Roi Et','Roi Et'),
(4031,209,'Sa Kaeo','Sa Kaeo');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4032,209,'Sakon Nakhon','Sakon Nakhon'),
(4033,209,'Samut Prakan','Samut Prakan'),
(4034,209,'Samut Sakhon','Samut Sakhon'),
(4035,209,'Samut Songkhram','Samut Songkhram'),
(4036,209,'Sara Buri','Sara Buri'),
(4037,209,'Satun','Satun'),
(4038,209,'Sing Buri','Sing Buri'),
(4039,209,'Sisaket','Sisaket'),
(4040,209,'Songkhla','Songkhla'),
(4041,209,'Sukhothai','Sukhothai'),
(4042,209,'Suphan Buri','Suphan Buri'),
(4043,209,'Surat Thani','Surat Thani'),
(4044,209,'Surin','Surin'),
(4045,209,'Tak','Tak'),
(4046,209,'Trang','Trang'),
(4047,209,'Trat','Trat'),
(4048,209,'Ubon Ratchathani','Ubon Ratchathani'),
(4049,209,'Udon Thani','Udon Thani'),
(4050,209,'Uthai Thani','Uthai Thani'),
(4051,209,'Uttaradit','Uttaradit');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4052,209,'Yala','Yala'),
(4053,209,'Yasothon','Yasothon'),
(4054,210,'K','Kara'),
(4055,210,'P','Plateaux'),
(4056,210,'S','Savanes'),
(4057,210,'C','Centrale'),
(4058,210,'M','Maritime'),
(4059,211,'A','Atafu'),
(4060,211,'F','Fakaofo'),
(4061,211,'N','Nukunonu'),
(4062,212,'H','Haapai'),
(4063,212,'T','Tongatapu'),
(4064,212,'V','Vavau'),
(4065,213,'CT','Couva/Tabaquite/Talparo'),
(4066,213,'DM','Diego Martin'),
(4067,213,'MR','Mayaro/Rio Claro'),
(4068,213,'PD','Penal/Debe'),
(4069,213,'PT','Princes Town'),
(4070,213,'SG','Sangre Grande'),
(4071,213,'SL','San Juan/Laventille');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4072,213,'SI','Siparia'),
(4073,213,'TP','Tunapuna/Piarco'),
(4074,213,'PS','Port of Spain'),
(4075,213,'SF','San Fernando'),
(4076,213,'AR','Arima'),
(4077,213,'PF','Point Fortin'),
(4078,213,'CH','Chaguanas'),
(4079,213,'TO','Tobago'),
(4080,214,'AR','Ariana'),
(4081,214,'BJ','Beja'),
(4082,214,'BA','Ben Arous'),
(4083,214,'BI','Bizerte'),
(4084,214,'GB','Gabes'),
(4085,214,'GF','Gafsa'),
(4086,214,'JE','Jendouba'),
(4087,214,'KR','Kairouan'),
(4088,214,'KS','Kasserine'),
(4089,214,'KB','Kebili'),
(4090,214,'KF','Kef'),
(4091,214,'MH','Mahdia');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4092,214,'MN','Manouba'),
(4093,214,'ME','Medenine'),
(4094,214,'MO','Monastir'),
(4095,214,'NA','Nabeul'),
(4096,214,'SF','Sfax'),
(4097,214,'SD','Sidi'),
(4098,214,'SL','Siliana'),
(4099,214,'SO','Sousse'),
(4100,214,'TA','Tataouine'),
(4101,214,'TO','Tozeur'),
(4102,214,'TU','Tunis'),
(4103,214,'ZA','Zaghouan'),
(4104,215,'ADA','Adana'),
(4105,215,'ADI','Adiyaman'),
(4106,215,'AFY','Afyonkarahisar'),
(4107,215,'AGR','Agri'),
(4108,215,'AKS','Aksaray'),
(4109,215,'AMA','Amasya'),
(4110,215,'ANK','Ankara'),
(4111,215,'ANT','Antalya');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4112,215,'ARD','Ardahan'),
(4113,215,'ART','Artvin'),
(4114,215,'AYI','Aydin'),
(4115,215,'BAL','Balikesir'),
(4116,215,'BAR','Bartin'),
(4117,215,'BAT','Batman'),
(4118,215,'BAY','Bayburt'),
(4119,215,'BIL','Bilecik'),
(4120,215,'BIN','Bingol'),
(4121,215,'BIT','Bitlis'),
(4122,215,'BOL','Bolu'),
(4123,215,'BRD','Burdur'),
(4124,215,'BRS','Bursa'),
(4125,215,'CKL','Canakkale'),
(4126,215,'CKR','Cankiri'),
(4127,215,'COR','Corum'),
(4128,215,'DEN','Denizli'),
(4129,215,'DIY','Diyarbakir'),
(4130,215,'DUZ','Duzce'),
(4131,215,'EDI','Edirne');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4132,215,'ELA','Elazig'),
(4133,215,'EZC','Erzincan'),
(4134,215,'EZR','Erzurum'),
(4135,215,'ESK','Eskisehir'),
(4136,215,'GAZ','Gaziantep'),
(4137,215,'GIR','Giresun'),
(4138,215,'GMS','Gumushane'),
(4139,215,'HKR','Hakkari'),
(4140,215,'HTY','Hatay'),
(4141,215,'IGD','Igdir'),
(4142,215,'ISP','Isparta'),
(4143,215,'IST','Istanbul'),
(4144,215,'IZM','Izmir'),
(4145,215,'KAH','Kahramanmaras'),
(4146,215,'KRB','Karabuk'),
(4147,215,'KRM','Karaman'),
(4148,215,'KRS','Kars'),
(4149,215,'KAS','Kastamonu'),
(4150,215,'KAY','Kayseri'),
(4151,215,'KLS','Kilis');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4152,215,'KRK','Kirikkale'),
(4153,215,'KLR','Kirklareli'),
(4154,215,'KRH','Kirsehir'),
(4155,215,'KOC','Kocaeli'),
(4156,215,'KON','Konya'),
(4157,215,'KUT','Kutahya'),
(4158,215,'MAL','Malatya'),
(4159,215,'MAN','Manisa'),
(4160,215,'MAR','Mardin'),
(4161,215,'MER','Mersin'),
(4162,215,'MUG','Mugla'),
(4163,215,'MUS','Mus'),
(4164,215,'NEV','Nevsehir'),
(4165,215,'NIG','Nigde'),
(4166,215,'ORD','Ordu'),
(4167,215,'OSM','Osmaniye'),
(4168,215,'RIZ','Rize'),
(4169,215,'SAK','Sakarya'),
(4170,215,'SAM','Samsun'),
(4171,215,'SAN','Sanliurfa');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4172,215,'SII','Siirt'),
(4173,215,'SIN','Sinop'),
(4174,215,'SIR','Sirnak'),
(4175,215,'SIV','Sivas'),
(4176,215,'TEL','Tekirdag'),
(4177,215,'TOK','Tokat'),
(4178,215,'TRA','Trabzon'),
(4179,215,'TUN','Tunceli'),
(4180,215,'USK','Usak'),
(4181,215,'VAN','Van'),
(4182,215,'YAL','Yalova'),
(4183,215,'YOZ','Yozgat'),
(4184,215,'ZON','Zonguldak'),
(4185,216,'A','Ahal Welayaty'),
(4186,216,'B','Balkan Welayaty '),
(4187,216,'D','Dashhowuz Welayaty'),
(4188,216,'L','Lebap Welayaty'),
(4189,216,'M','Mary Welayaty'),
(4190,217,'AC','Ambergris Cays'),
(4191,217,'DC','Dellis Cay');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4192,217,'FC','French Cay'),
(4193,217,'LW','Little Water Cay'),
(4194,217,'RC','Parrot Cay'),
(4195,217,'PN','Pine Cay'),
(4196,217,'SL','Salt Cay'),
(4197,217,'GT','Grand Turk'),
(4198,217,'SC','South Caicos'),
(4199,217,'EC','East Caicos'),
(4200,217,'MC','Middle Caicos'),
(4201,217,'NC','North Caicos'),
(4202,217,'PR','Providenciales'),
(4203,217,'WC','West Caicos'),
(4204,218,'NMG','Nanumanga'),
(4205,218,'NLK','Niulakita'),
(4206,218,'NTO','Niutao'),
(4207,218,'FUN','Funafuti'),
(4208,218,'NME','Nanumea'),
(4209,218,'NUI','Nui'),
(4210,218,'NFT','Nukufetau'),
(4211,218,'NLL','Nukulaelae');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4212,218,'VAI','Vaitupu'),
(4213,219,'KAL','Kalangala'),
(4214,219,'KMP','Kampala'),
(4215,219,'KAY','Kayunga'),
(4216,219,'KIB','Kiboga'),
(4217,219,'LUW','Luwero'),
(4218,219,'MAS','Masaka'),
(4219,219,'MPI','Mpigi'),
(4220,219,'MUB','Mubende'),
(4221,219,'MUK','Mukono'),
(4222,219,'NKS','Nakasongola'),
(4223,219,'RAK','Rakai'),
(4224,219,'SEM','Sembabule'),
(4225,219,'WAK','Wakiso'),
(4226,219,'BUG','Bugiri'),
(4227,219,'BUS','Busia'),
(4228,219,'IGA','Iganga'),
(4229,219,'JIN','Jinja'),
(4230,219,'KAB','Kaberamaido'),
(4231,219,'KML','Kamuli');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4232,219,'KPC','Kapchorwa'),
(4233,219,'KTK','Katakwi'),
(4234,219,'KUM','Kumi'),
(4235,219,'MAY','Mayuge'),
(4236,219,'MBA','Mbale'),
(4237,219,'PAL','Pallisa'),
(4238,219,'SIR','Sironko'),
(4239,219,'SOR','Soroti'),
(4240,219,'TOR','Tororo'),
(4241,219,'ADJ','Adjumani'),
(4242,219,'APC','Apac'),
(4243,219,'ARU','Arua'),
(4244,219,'GUL','Gulu'),
(4245,219,'KIT','Kitgum'),
(4246,219,'KOT','Kotido'),
(4247,219,'LIR','Lira'),
(4248,219,'MRT','Moroto'),
(4249,219,'MOY','Moyo'),
(4250,219,'NAK','Nakapiripirit'),
(4251,219,'NEB','Nebbi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4252,219,'PAD','Pader'),
(4253,219,'YUM','Yumbe'),
(4254,219,'BUN','Bundibugyo'),
(4255,219,'BSH','Bushenyi'),
(4256,219,'HOI','Hoima'),
(4257,219,'KBL','Kabale'),
(4258,219,'KAR','Kabarole'),
(4259,219,'KAM','Kamwenge'),
(4260,219,'KAN','Kanungu'),
(4261,219,'KAS','Kasese'),
(4262,219,'KBA','Kibaale'),
(4263,219,'KIS','Kisoro'),
(4264,219,'KYE','Kyenjojo'),
(4265,219,'MSN','Masindi'),
(4266,219,'MBR','Mbarara'),
(4267,219,'NTU','Ntungamo'),
(4268,219,'RUK','Rukungiri'),
(4269,220,'CK','Cherkasy'),
(4270,220,'CH','Chernihiv'),
(4271,220,'CV','Chernivtsi');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4272,220,'CR','Crimea'),
(4273,220,'DN','Dnipropetrovsk'),
(4274,220,'DO','Donetsk'),
(4275,220,'IV','Ivano-Frankivsk'),
(4276,220,'KL','Kharkiv Kherson'),
(4277,220,'KM','Khmelnytskyy'),
(4278,220,'KR','Kirovohrad'),
(4279,220,'KV','Kiev'),
(4280,220,'KY','Kyyiv'),
(4281,220,'LU','Luhansk'),
(4282,220,'LV','Lviv'),
(4283,220,'MY','Mykolayiv'),
(4284,220,'OD','Odesa'),
(4285,220,'PO','Poltava'),
(4286,220,'RI','Rivne'),
(4287,220,'SE','Sevastopol'),
(4288,220,'SU','Sumy'),
(4289,220,'TE','Ternopil'),
(4290,220,'VI','Vinnytsya'),
(4291,220,'VO','Volyn');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4292,220,'ZK','Zakarpattya'),
(4293,220,'ZA','Zaporizhzhya'),
(4294,220,'ZH','Zhytomyr'),
(4295,221,'AZ','Abu Zaby'),
(4296,221,'AJ','Ajman'),
(4297,221,'FU','Al Fujayrah'),
(4298,221,'SH','Ash Shariqah'),
(4299,221,'DU','Dubayy'),
(4300,221,'RK','Ras al Khaymah'),
(4301,221,'UQ','Umm al Qaywayn'),
(4302,222,'ABN','Aberdeen'),
(4303,222,'ABNS','Aberdeenshire'),
(4304,222,'ANG','Anglesey'),
(4305,222,'AGS','Angus'),
(4306,222,'ARY','Argyll and Bute'),
(4307,222,'BEDS','Bedfordshire'),
(4308,222,'BERKS','Berkshire'),
(4309,222,'BLA','Blaenau Gwent'),
(4310,222,'BRI','Bridgend'),
(4311,222,'BSTL','Bristol');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4312,222,'BUCKS','Buckinghamshire'),
(4313,222,'CAE','Caerphilly'),
(4314,222,'CAMBS','Cambridgeshire'),
(4315,222,'CDF','Cardiff'),
(4316,222,'CARM','Carmarthenshire'),
(4317,222,'CDGN','Ceredigion'),
(4318,222,'CHES','Cheshire'),
(4319,222,'CLACK','Clackmannanshire'),
(4320,222,'CON','Conwy'),
(4321,222,'CORN','Cornwall'),
(4322,222,'DNBG','Denbighshire'),
(4323,222,'DERBY','Derbyshire'),
(4324,222,'DVN','Devon'),
(4325,222,'DOR','Dorset'),
(4326,222,'DGL','Dumfries and Galloway'),
(4327,222,'DUND','Dundee'),
(4328,222,'DHM','Durham'),
(4329,222,'ARYE','East Ayrshire'),
(4330,222,'DUNBE','East Dunbartonshire'),
(4331,222,'LOTE','East Lothian');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4332,222,'RENE','East Renfrewshire'),
(4333,222,'ERYS','East Riding of Yorkshire'),
(4334,222,'SXE','East Sussex'),
(4335,222,'EDIN','Edinburgh'),
(4336,222,'ESX','Essex'),
(4337,222,'FALK','Falkirk'),
(4338,222,'FFE','Fife'),
(4339,222,'FLINT','Flintshire'),
(4340,222,'GLAS','Glasgow'),
(4341,222,'GLOS','Gloucestershire'),
(4342,222,'LDN','Greater London'),
(4343,222,'MCH','Greater Manchester'),
(4344,222,'GDD','Gwynedd'),
(4345,222,'HANTS','Hampshire'),
(4346,222,'HWR','Herefordshire'),
(4347,222,'HERTS','Hertfordshire'),
(4348,222,'HLD','Highlands'),
(4349,222,'IVER','Inverclyde'),
(4350,222,'IOW','Isle of Wight'),
(4351,222,'KNT','Kent');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4352,222,'LANCS','Lancashire'),
(4353,222,'LEICS','Leicestershire'),
(4354,222,'LINCS','Lincolnshire'),
(4355,222,'MSY','Merseyside'),
(4356,222,'MERT','Merthyr Tydfil'),
(4357,222,'MLOT','Midlothian'),
(4358,222,'MMOUTH','Monmouthshire'),
(4359,222,'MORAY','Moray'),
(4360,222,'NPRTAL','Neath Port Talbot'),
(4361,222,'NEWPT','Newport'),
(4362,222,'NOR','Norfolk'),
(4363,222,'ARYN','North Ayrshire'),
(4364,222,'LANN','North Lanarkshire'),
(4365,222,'YSN','North Yorkshire'),
(4366,222,'NHM','Northamptonshire'),
(4367,222,'NLD','Northumberland'),
(4368,222,'NOT','Nottinghamshire'),
(4369,222,'ORK','Orkney Islands'),
(4370,222,'OFE','Oxfordshire'),
(4371,222,'PEM','Pembrokeshire');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4372,222,'PERTH','Perth and Kinross'),
(4373,222,'PWS','Powys'),
(4374,222,'REN','Renfrewshire'),
(4375,222,'RHON','Rhondda Cynon Taff'),
(4376,222,'RUT','Rutland'),
(4377,222,'BOR','Scottish Borders'),
(4378,222,'SHET','Shetland Islands'),
(4379,222,'SPE','Shropshire'),
(4380,222,'SOM','Somerset'),
(4381,222,'ARYS','South Ayrshire'),
(4382,222,'LANS','South Lanarkshire'),
(4383,222,'YSS','South Yorkshire'),
(4384,222,'SFD','Staffordshire'),
(4385,222,'STIR','Stirling'),
(4386,222,'SFK','Suffolk'),
(4387,222,'SRY','Surrey'),
(4388,222,'SWAN','Swansea'),
(4389,222,'TORF','Torfaen'),
(4390,222,'TWR','Tyne and Wear'),
(4391,222,'VGLAM','Vale of Glamorgan');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4392,222,'WARKS','Warwickshire'),
(4393,222,'WDUN','West Dunbartonshire'),
(4394,222,'WLOT','West Lothian'),
(4395,222,'WMD','West Midlands'),
(4396,222,'SXW','West Sussex'),
(4397,222,'YSW','West Yorkshire'),
(4398,222,'WIL','Western Isles'),
(4399,222,'WLT','Wiltshire'),
(4400,222,'WORCS','Worcestershire'),
(4401,222,'WRX','Wrexham'),
(4402,223,'AL','Alabama'),
(4403,223,'AK','Alaska'),
(4404,223,'AS','American Samoa'),
(4405,223,'AZ','Arizona'),
(4406,223,'AR','Arkansas'),
(4407,223,'AF','Armed Forces Africa'),
(4408,223,'AA','Armed Forces Americas'),
(4409,223,'AC','Armed Forces Canada'),
(4410,223,'AE','Armed Forces Europe'),
(4411,223,'AM','Armed Forces Middle East');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4412,223,'AP','Armed Forces Pacific'),
(4413,223,'CA','California'),
(4414,223,'CO','Colorado'),
(4415,223,'CT','Connecticut'),
(4416,223,'DE','Delaware'),
(4417,223,'DC','District of Columbia'),
(4418,223,'FM','Federated States Of Micronesia'),
(4419,223,'FL','Florida'),
(4420,223,'GA','Georgia'),
(4421,223,'GU','Guam'),
(4422,223,'HI','Hawaii'),
(4423,223,'ID','Idaho'),
(4424,223,'IL','Illinois'),
(4425,223,'IN','Indiana'),
(4426,223,'IA','Iowa'),
(4427,223,'KS','Kansas'),
(4428,223,'KY','Kentucky'),
(4429,223,'LA','Louisiana'),
(4430,223,'ME','Maine'),
(4431,223,'MH','Marshall Islands');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4432,223,'MD','Maryland'),
(4433,223,'MA','Massachusetts'),
(4434,223,'MI','Michigan'),
(4435,223,'MN','Minnesota'),
(4436,223,'MS','Mississippi'),
(4437,223,'MO','Missouri'),
(4438,223,'MT','Montana'),
(4439,223,'NE','Nebraska'),
(4440,223,'NV','Nevada'),
(4441,223,'NH','New Hampshire'),
(4442,223,'NJ','New Jersey'),
(4443,223,'NM','New Mexico'),
(4444,223,'NY','New York'),
(4445,223,'NC','North Carolina'),
(4446,223,'ND','North Dakota'),
(4447,223,'MP','Northern Mariana Islands'),
(4448,223,'OH','Ohio'),
(4449,223,'OK','Oklahoma'),
(4450,223,'OR','Oregon'),
(4451,223,'PW','Palau');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4452,223,'PA','Pennsylvania'),
(4453,223,'PR','Puerto Rico'),
(4454,223,'RI','Rhode Island'),
(4455,223,'SC','South Carolina'),
(4456,223,'SD','South Dakota'),
(4457,223,'TN','Tennessee'),
(4458,223,'TX','Texas'),
(4459,223,'UT','Utah'),
(4460,223,'VT','Vermont'),
(4461,223,'VI','Virgin Islands'),
(4462,223,'VA','Virginia'),
(4463,223,'WA','Washington'),
(4464,223,'WV','West Virginia'),
(4465,223,'WI','Wisconsin'),
(4466,223,'WY','Wyoming'),
(4467,224,'BI','Baker Island'),
(4468,224,'HI','Howland Island'),
(4469,224,'JI','Jarvis Island'),
(4470,224,'JA','Johnston Atoll'),
(4471,224,'KR','Kingman Reef');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4472,224,'MA','Midway Atoll'),
(4473,224,'NI','Navassa Island'),
(4474,224,'PA','Palmyra Atoll'),
(4475,224,'WI','Wake Island'),
(4476,225,'AR','Artigas'),
(4477,225,'CA','Canelones'),
(4478,225,'CL','Cerro Largo'),
(4479,225,'CO','Colonia'),
(4480,225,'DU','Durazno'),
(4481,225,'FS','Flores'),
(4482,225,'FA','Florida'),
(4483,225,'LA','Lavalleja'),
(4484,225,'MA','Maldonado'),
(4485,225,'MO','Montevideo'),
(4486,225,'PA','Paysandu'),
(4487,225,'RN','Rio Negro'),
(4488,225,'RV','Rivera'),
(4489,225,'RO','Rocha'),
(4490,225,'SL','Salto'),
(4491,225,'SJ','San Jose');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4492,225,'SO','Soriano'),
(4493,225,'TA','Tacuarembo'),
(4494,225,'TT','Treinta y Tres'),
(4495,226,'AN','Andijon'),
(4496,226,'BU','Buxoro'),
(4497,226,'FA','Fargona'),
(4498,226,'JI','Jizzax'),
(4499,226,'NG','Namangan'),
(4500,226,'NW','Navoiy'),
(4501,226,'QA','Qashqadaryo'),
(4502,226,'QR','Qoraqalpogiston Republikasi'),
(4503,226,'SA','Samarqand'),
(4504,226,'SI','Sirdaryo'),
(4505,226,'SU','Surxondaryo'),
(4506,226,'TK','Toshkent City'),
(4507,226,'TO','Toshkent Region'),
(4508,226,'XO','Xorazm'),
(4509,227,'MA','Malampa'),
(4510,227,'PE','Penama'),
(4511,227,'SA','Sanma');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4512,227,'SH','Shefa'),
(4513,227,'TA','Tafea'),
(4514,227,'TO','Torba'),
(4515,229,'AM','Amazonas'),
(4516,229,'AN','Anzoategui'),
(4517,229,'AP','Apure'),
(4518,229,'AR','Aragua'),
(4519,229,'BA','Barinas'),
(4520,229,'BO','Bolivar'),
(4521,229,'CA','Carabobo'),
(4522,229,'CO','Cojedes'),
(4523,229,'DA','Delta Amacuro'),
(4524,229,'DF','Dependencias Federales'),
(4525,229,'DI','Distrito Federal'),
(4526,229,'FA','Falcon'),
(4527,229,'GU','Guarico'),
(4528,229,'LA','Lara'),
(4529,229,'ME','Merida'),
(4530,229,'MI','Miranda'),
(4531,229,'MO','Monagas');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4532,229,'NE','Nueva Esparta'),
(4533,229,'PO','Portuguesa'),
(4534,229,'SU','Sucre'),
(4535,229,'TA','Tachira'),
(4536,229,'TR','Trujillo'),
(4537,229,'VA','Vargas'),
(4538,229,'YA','Yaracuy'),
(4539,229,'ZU','Zulia'),
(4540,230,'AG','An Giang'),
(4541,230,'BG','Bac Giang'),
(4542,230,'BK','Bac Kan'),
(4543,230,'BL','Bac Lieu'),
(4544,230,'BC','Bac Ninh'),
(4545,230,'BR','Ba Ria-Vung Tau'),
(4546,230,'BN','Ben Tre'),
(4547,230,'BH','Binh Dinh'),
(4548,230,'BU','Binh Duong'),
(4549,230,'BP','Binh Phuoc'),
(4550,230,'BT','Binh Thuan'),
(4551,230,'CM','Ca Mau');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4552,230,'CT','Can Tho'),
(4553,230,'CB','Cao Bang'),
(4554,230,'DL','Dak Lak'),
(4555,230,'DG','Dak Nong'),
(4556,230,'DN','Da Nang'),
(4557,230,'DB','Dien Bien'),
(4558,230,'DI','Dong Nai'),
(4559,230,'DT','Dong Thap'),
(4560,230,'GL','Gia Lai'),
(4561,230,'HG','Ha Giang'),
(4562,230,'HD','Hai Duong'),
(4563,230,'HP','Hai Phong'),
(4564,230,'HM','Ha Nam'),
(4565,230,'HI','Ha Noi'),
(4566,230,'HT','Ha Tay'),
(4567,230,'HH','Ha Tinh'),
(4568,230,'HB','Hoa Binh'),
(4569,230,'HC','Ho Chin Minh'),
(4570,230,'HU','Hau Giang'),
(4571,230,'HY','Hung Yen');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4572,232,'C','Saint Croix'),
(4573,232,'J','Saint John'),
(4574,232,'T','Saint Thomas'),
(4575,233,'A','Alo'),
(4576,233,'S','Sigave'),
(4577,233,'W','Wallis'),
(4578,235,'AB','Abyan'),
(4579,235,'AD','Adan'),
(4580,235,'AM','Amran'),
(4581,235,'BA','Al Bayda'),
(4582,235,'DA','Ad Dali'),
(4583,235,'DH','Dhamar'),
(4584,235,'HD','Hadramawt'),
(4585,235,'HJ','Hajjah'),
(4586,235,'HU','Al Hudaydah'),
(4587,235,'IB','Ibb'),
(4588,235,'JA','Al Jawf'),
(4589,235,'LA','Lahij'),
(4590,235,'MA','Marib'),
(4591,235,'MR','Al Mahrah');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4592,235,'MW','Al Mahwit'),
(4593,235,'SD','Sadah'),
(4594,235,'SN','Sana'),
(4595,235,'SH','Shabwah'),
(4596,235,'TA','Taizz'),
(4597,236,'KOS','Kosovo'),
(4598,236,'MON','Montenegro'),
(4599,236,'SER','Serbia'),
(4600,236,'VOJ','Vojvodina'),
(4601,237,'BC','Bas-Congo'),
(4602,237,'BN','Bandundu'),
(4603,237,'EQ','Equateur'),
(4604,237,'KA','Katanga'),
(4605,237,'KE','Kasai-Oriental'),
(4606,237,'KN','Kinshasa'),
(4607,237,'KW','Kasai-Occidental'),
(4608,237,'MA','Maniema'),
(4609,237,'NK','Nord-Kivu'),
(4610,237,'OR','Orientale'),
(4611,237,'SK','Sud-Kivu');
insert into `zones` (`zone_id`, `zone_country_id`, `zone_code`, `zone_name`) values (4612,238,'CE','Central'),
(4613,238,'CB','Copperbelt'),
(4614,238,'EA','Eastern'),
(4615,238,'LP','Luapula'),
(4616,238,'LK','Lusaka'),
(4617,238,'NO','Northern'),
(4618,238,'NW','North-Western'),
(4619,238,'SO','Southern'),
(4620,238,'WE','Western'),
(4621,239,'BU','Bulawayo'),
(4622,239,'HA','Harare'),
(4623,239,'ML','Manicaland'),
(4624,239,'MC','Mashonaland Central'),
(4625,239,'ME','Mashonaland East'),
(4626,239,'MW','Mashonaland West'),
(4627,239,'MV','Masvingo'),
(4628,239,'MN','Matabeleland North'),
(4629,239,'MS','Matabeleland South'),
(4630,239,'MD','Midlands'),
(4631,170,'PL','Polska');

drop table if exists `zones_to_geo_zones`;
CREATE TABLE `zones_to_geo_zones` (
  `association_id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_country_id` int(11) NOT NULL,
  `zone_id` int(11) DEFAULT NULL,
  `geo_zone_id` int(11) DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `date_added` datetime NOT NULL,
  PRIMARY KEY (`association_id`),
  KEY `idx_zones` (`geo_zone_id`,`zone_country_id`,`zone_id`)
);

insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (1,170,NULL,1,'2006-08-11 15:23:09','2006-05-27 18:49:35'),
(2,81,0,1,NULL,'2006-08-12 09:21:54'),
(3,14,0,1,NULL,'2006-08-13 20:26:18'),
(4,21,0,1,NULL,'2006-08-13 20:26:29'),
(5,55,0,1,NULL,'2006-08-13 20:26:38'),
(6,56,0,1,NULL,'2006-08-13 20:26:52'),
(7,57,0,1,NULL,'2006-08-13 20:26:56'),
(8,67,0,1,NULL,'2006-08-13 20:27:08'),
(9,72,0,1,NULL,'2006-08-13 20:27:15'),
(10,73,0,1,NULL,'2006-08-13 20:27:24'),
(11,84,0,1,NULL,'2006-08-13 20:27:31'),
(12,195,0,1,NULL,'2006-08-13 20:27:46'),
(13,150,0,1,NULL,'2006-08-13 20:27:52'),
(14,103,0,1,NULL,'2006-08-13 20:28:02'),
(15,123,0,1,NULL,'2006-08-13 20:28:08'),
(16,124,0,1,NULL,'2006-08-13 20:28:21'),
(17,117,0,1,NULL,'2006-08-13 20:28:28'),
(18,132,0,1,NULL,'2006-08-13 20:28:41'),
(19,171,0,1,NULL,'2006-08-13 20:28:57'),
(20,189,0,1,NULL,'2006-08-13 20:29:06');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (21,190,0,1,NULL,'2006-08-13 20:29:15'),
(22,203,0,1,NULL,'2006-08-13 20:29:35'),
(23,97,0,1,NULL,'2006-08-13 20:29:42'),
(24,222,0,1,NULL,'2006-08-13 20:29:54'),
(25,105,0,1,NULL,'2006-08-13 20:30:01'),
(27,170,0,3,NULL,'2007-07-13 13:09:12'),
(266,239,0,4,NULL,'0000-00-00 00:00:00'),
(265,238,0,4,NULL,'0000-00-00 00:00:00'),
(264,237,0,4,NULL,'0000-00-00 00:00:00'),
(263,236,0,4,NULL,'0000-00-00 00:00:00'),
(262,235,0,4,NULL,'0000-00-00 00:00:00'),
(261,234,0,4,NULL,'0000-00-00 00:00:00'),
(260,233,0,4,NULL,'0000-00-00 00:00:00'),
(259,232,0,4,NULL,'0000-00-00 00:00:00'),
(258,231,0,4,NULL,'0000-00-00 00:00:00'),
(257,230,0,4,NULL,'0000-00-00 00:00:00'),
(256,229,0,4,NULL,'0000-00-00 00:00:00'),
(255,228,0,4,NULL,'0000-00-00 00:00:00'),
(254,227,0,4,NULL,'0000-00-00 00:00:00'),
(253,226,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (252,225,0,4,NULL,'0000-00-00 00:00:00'),
(251,224,0,4,NULL,'0000-00-00 00:00:00'),
(250,223,0,4,NULL,'0000-00-00 00:00:00'),
(249,222,0,4,NULL,'0000-00-00 00:00:00'),
(248,221,0,4,NULL,'0000-00-00 00:00:00'),
(247,220,0,4,NULL,'0000-00-00 00:00:00'),
(246,219,0,4,NULL,'0000-00-00 00:00:00'),
(245,218,0,4,NULL,'0000-00-00 00:00:00'),
(244,217,0,4,NULL,'0000-00-00 00:00:00'),
(243,216,0,4,NULL,'0000-00-00 00:00:00'),
(242,215,0,4,NULL,'0000-00-00 00:00:00'),
(241,214,0,4,NULL,'0000-00-00 00:00:00'),
(240,213,0,4,NULL,'0000-00-00 00:00:00'),
(239,212,0,4,NULL,'0000-00-00 00:00:00'),
(238,211,0,4,NULL,'0000-00-00 00:00:00'),
(237,210,0,4,NULL,'0000-00-00 00:00:00'),
(236,209,0,4,NULL,'0000-00-00 00:00:00'),
(235,208,0,4,NULL,'0000-00-00 00:00:00'),
(234,207,0,4,NULL,'0000-00-00 00:00:00'),
(233,206,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (232,205,0,4,NULL,'0000-00-00 00:00:00'),
(231,204,0,4,NULL,'0000-00-00 00:00:00'),
(230,203,0,4,NULL,'0000-00-00 00:00:00'),
(229,202,0,4,NULL,'0000-00-00 00:00:00'),
(228,201,0,4,NULL,'0000-00-00 00:00:00'),
(226,200,0,4,NULL,'0000-00-00 00:00:00'),
(225,199,0,4,NULL,'0000-00-00 00:00:00'),
(224,198,0,4,NULL,'0000-00-00 00:00:00'),
(223,197,0,4,NULL,'0000-00-00 00:00:00'),
(222,196,0,4,NULL,'0000-00-00 00:00:00'),
(221,195,0,4,NULL,'0000-00-00 00:00:00'),
(220,194,0,4,NULL,'0000-00-00 00:00:00'),
(219,193,0,4,NULL,'0000-00-00 00:00:00'),
(218,192,0,4,NULL,'0000-00-00 00:00:00'),
(217,191,0,4,NULL,'0000-00-00 00:00:00'),
(216,190,0,4,NULL,'0000-00-00 00:00:00'),
(215,189,0,4,NULL,'0000-00-00 00:00:00'),
(214,188,0,4,NULL,'0000-00-00 00:00:00'),
(213,187,0,4,NULL,'0000-00-00 00:00:00'),
(212,186,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (211,185,0,4,NULL,'0000-00-00 00:00:00'),
(210,184,0,4,NULL,'0000-00-00 00:00:00'),
(209,183,0,4,NULL,'0000-00-00 00:00:00'),
(208,182,0,4,NULL,'0000-00-00 00:00:00'),
(207,181,0,4,NULL,'0000-00-00 00:00:00'),
(206,180,0,4,NULL,'0000-00-00 00:00:00'),
(205,179,0,4,NULL,'0000-00-00 00:00:00'),
(204,178,0,4,NULL,'0000-00-00 00:00:00'),
(203,177,0,4,NULL,'0000-00-00 00:00:00'),
(202,176,0,4,NULL,'0000-00-00 00:00:00'),
(201,175,0,4,NULL,'0000-00-00 00:00:00'),
(200,174,0,4,NULL,'0000-00-00 00:00:00'),
(199,173,0,4,NULL,'0000-00-00 00:00:00'),
(198,172,0,4,NULL,'0000-00-00 00:00:00'),
(197,171,0,4,NULL,'0000-00-00 00:00:00'),
(196,170,0,4,NULL,'0000-00-00 00:00:00'),
(195,169,0,4,NULL,'0000-00-00 00:00:00'),
(194,168,0,4,NULL,'0000-00-00 00:00:00'),
(193,167,0,4,NULL,'0000-00-00 00:00:00'),
(192,166,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (191,165,0,4,NULL,'0000-00-00 00:00:00'),
(190,164,0,4,NULL,'0000-00-00 00:00:00'),
(189,163,0,4,NULL,'0000-00-00 00:00:00'),
(188,162,0,4,NULL,'0000-00-00 00:00:00'),
(187,161,0,4,NULL,'0000-00-00 00:00:00'),
(186,160,0,4,NULL,'0000-00-00 00:00:00'),
(185,159,0,4,NULL,'0000-00-00 00:00:00'),
(184,158,0,4,NULL,'0000-00-00 00:00:00'),
(183,157,0,4,NULL,'0000-00-00 00:00:00'),
(182,156,0,4,NULL,'0000-00-00 00:00:00'),
(181,155,0,4,NULL,'0000-00-00 00:00:00'),
(180,154,0,4,NULL,'0000-00-00 00:00:00'),
(179,153,0,4,NULL,'0000-00-00 00:00:00'),
(178,152,0,4,NULL,'0000-00-00 00:00:00'),
(177,151,0,4,NULL,'0000-00-00 00:00:00'),
(176,150,0,4,NULL,'0000-00-00 00:00:00'),
(175,149,0,4,NULL,'0000-00-00 00:00:00'),
(174,148,0,4,NULL,'0000-00-00 00:00:00'),
(173,147,0,4,NULL,'0000-00-00 00:00:00'),
(172,146,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (171,145,0,4,NULL,'0000-00-00 00:00:00'),
(227,144,0,4,NULL,'0000-00-00 00:00:00'),
(170,143,0,4,NULL,'0000-00-00 00:00:00'),
(169,142,0,4,NULL,'0000-00-00 00:00:00'),
(168,141,0,4,NULL,'0000-00-00 00:00:00'),
(167,140,0,4,NULL,'0000-00-00 00:00:00'),
(166,139,0,4,NULL,'0000-00-00 00:00:00'),
(165,138,0,4,NULL,'0000-00-00 00:00:00'),
(164,137,0,4,NULL,'0000-00-00 00:00:00'),
(163,136,0,4,NULL,'0000-00-00 00:00:00'),
(162,135,0,4,NULL,'0000-00-00 00:00:00'),
(161,134,0,4,NULL,'0000-00-00 00:00:00'),
(160,133,0,4,NULL,'0000-00-00 00:00:00'),
(159,132,0,4,NULL,'0000-00-00 00:00:00'),
(158,131,0,4,NULL,'0000-00-00 00:00:00'),
(157,130,0,4,NULL,'0000-00-00 00:00:00'),
(156,129,0,4,NULL,'0000-00-00 00:00:00'),
(155,128,0,4,NULL,'0000-00-00 00:00:00'),
(154,127,0,4,NULL,'0000-00-00 00:00:00'),
(153,126,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (152,125,0,4,NULL,'0000-00-00 00:00:00'),
(151,124,0,4,NULL,'0000-00-00 00:00:00'),
(150,123,0,4,NULL,'0000-00-00 00:00:00'),
(149,122,0,4,NULL,'0000-00-00 00:00:00'),
(148,121,0,4,NULL,'0000-00-00 00:00:00'),
(147,120,0,4,NULL,'0000-00-00 00:00:00'),
(146,119,0,4,NULL,'0000-00-00 00:00:00'),
(145,118,0,4,NULL,'0000-00-00 00:00:00'),
(144,117,0,4,NULL,'0000-00-00 00:00:00'),
(143,116,0,4,NULL,'0000-00-00 00:00:00'),
(142,115,0,4,NULL,'0000-00-00 00:00:00'),
(141,114,0,4,NULL,'0000-00-00 00:00:00'),
(140,113,0,4,NULL,'0000-00-00 00:00:00'),
(139,112,0,4,NULL,'0000-00-00 00:00:00'),
(138,111,0,4,NULL,'0000-00-00 00:00:00'),
(137,110,0,4,NULL,'0000-00-00 00:00:00'),
(136,109,0,4,NULL,'0000-00-00 00:00:00'),
(135,108,0,4,NULL,'0000-00-00 00:00:00'),
(134,107,0,4,NULL,'0000-00-00 00:00:00'),
(133,106,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (132,105,0,4,NULL,'0000-00-00 00:00:00'),
(131,104,0,4,NULL,'0000-00-00 00:00:00'),
(130,103,0,4,NULL,'0000-00-00 00:00:00'),
(129,102,0,4,NULL,'0000-00-00 00:00:00'),
(128,101,0,4,NULL,'0000-00-00 00:00:00'),
(126,100,0,4,NULL,'0000-00-00 00:00:00'),
(125,99,0,4,NULL,'0000-00-00 00:00:00'),
(124,98,0,4,NULL,'0000-00-00 00:00:00'),
(123,97,0,4,NULL,'0000-00-00 00:00:00'),
(122,96,0,4,NULL,'0000-00-00 00:00:00'),
(121,95,0,4,NULL,'0000-00-00 00:00:00'),
(120,94,0,4,NULL,'0000-00-00 00:00:00'),
(119,93,0,4,NULL,'0000-00-00 00:00:00'),
(118,92,0,4,NULL,'0000-00-00 00:00:00'),
(117,91,0,4,NULL,'0000-00-00 00:00:00'),
(116,90,0,4,NULL,'0000-00-00 00:00:00'),
(115,89,0,4,NULL,'0000-00-00 00:00:00'),
(114,88,0,4,NULL,'0000-00-00 00:00:00'),
(113,87,0,4,NULL,'0000-00-00 00:00:00'),
(112,86,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (111,85,0,4,NULL,'0000-00-00 00:00:00'),
(110,84,0,4,NULL,'0000-00-00 00:00:00'),
(109,83,0,4,NULL,'0000-00-00 00:00:00'),
(108,82,0,4,NULL,'0000-00-00 00:00:00'),
(107,81,0,4,NULL,'0000-00-00 00:00:00'),
(106,80,0,4,NULL,'0000-00-00 00:00:00'),
(105,79,0,4,NULL,'0000-00-00 00:00:00'),
(104,78,0,4,NULL,'0000-00-00 00:00:00'),
(103,77,0,4,NULL,'0000-00-00 00:00:00'),
(102,76,0,4,NULL,'0000-00-00 00:00:00'),
(101,75,0,4,NULL,'0000-00-00 00:00:00'),
(100,74,0,4,NULL,'0000-00-00 00:00:00'),
(99,73,0,4,NULL,'0000-00-00 00:00:00'),
(98,72,0,4,NULL,'0000-00-00 00:00:00'),
(97,71,0,4,NULL,'0000-00-00 00:00:00'),
(96,70,0,4,NULL,'0000-00-00 00:00:00'),
(95,69,0,4,NULL,'0000-00-00 00:00:00'),
(94,68,0,4,NULL,'0000-00-00 00:00:00'),
(93,67,0,4,NULL,'0000-00-00 00:00:00'),
(92,66,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (91,65,0,4,NULL,'0000-00-00 00:00:00'),
(90,64,0,4,NULL,'0000-00-00 00:00:00'),
(89,63,0,4,NULL,'0000-00-00 00:00:00'),
(88,62,0,4,NULL,'0000-00-00 00:00:00'),
(87,61,0,4,NULL,'0000-00-00 00:00:00'),
(86,60,0,4,NULL,'0000-00-00 00:00:00'),
(85,59,0,4,NULL,'0000-00-00 00:00:00'),
(84,58,0,4,NULL,'0000-00-00 00:00:00'),
(83,57,0,4,NULL,'0000-00-00 00:00:00'),
(82,56,0,4,NULL,'0000-00-00 00:00:00'),
(81,55,0,4,NULL,'0000-00-00 00:00:00'),
(80,54,0,4,NULL,'0000-00-00 00:00:00'),
(79,53,0,4,NULL,'0000-00-00 00:00:00'),
(78,52,0,4,NULL,'0000-00-00 00:00:00'),
(77,51,0,4,NULL,'0000-00-00 00:00:00'),
(76,50,0,4,NULL,'0000-00-00 00:00:00'),
(75,49,0,4,NULL,'0000-00-00 00:00:00'),
(74,48,0,4,NULL,'0000-00-00 00:00:00'),
(73,47,0,4,NULL,'0000-00-00 00:00:00'),
(72,46,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (71,45,0,4,NULL,'0000-00-00 00:00:00'),
(127,44,0,4,NULL,'0000-00-00 00:00:00'),
(70,43,0,4,NULL,'0000-00-00 00:00:00'),
(69,42,0,4,NULL,'0000-00-00 00:00:00'),
(68,41,0,4,NULL,'0000-00-00 00:00:00'),
(67,40,0,4,NULL,'0000-00-00 00:00:00'),
(66,39,0,4,NULL,'0000-00-00 00:00:00'),
(65,38,0,4,NULL,'0000-00-00 00:00:00'),
(64,37,0,4,NULL,'0000-00-00 00:00:00'),
(63,36,0,4,NULL,'0000-00-00 00:00:00'),
(62,35,0,4,NULL,'0000-00-00 00:00:00'),
(61,34,0,4,NULL,'0000-00-00 00:00:00'),
(60,33,0,4,NULL,'0000-00-00 00:00:00'),
(59,32,0,4,NULL,'0000-00-00 00:00:00'),
(58,31,0,4,NULL,'0000-00-00 00:00:00'),
(57,30,0,4,NULL,'0000-00-00 00:00:00'),
(56,29,0,4,NULL,'0000-00-00 00:00:00'),
(55,28,0,4,NULL,'0000-00-00 00:00:00'),
(54,27,0,4,NULL,'0000-00-00 00:00:00'),
(53,26,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (52,25,0,4,NULL,'0000-00-00 00:00:00'),
(51,24,0,4,NULL,'0000-00-00 00:00:00'),
(50,23,0,4,NULL,'0000-00-00 00:00:00'),
(49,22,0,4,NULL,'0000-00-00 00:00:00'),
(48,21,0,4,NULL,'0000-00-00 00:00:00'),
(47,20,0,4,NULL,'0000-00-00 00:00:00'),
(46,19,0,4,NULL,'0000-00-00 00:00:00'),
(45,18,0,4,NULL,'0000-00-00 00:00:00'),
(44,17,0,4,NULL,'0000-00-00 00:00:00'),
(43,16,0,4,NULL,'0000-00-00 00:00:00'),
(42,15,0,4,NULL,'0000-00-00 00:00:00'),
(41,14,0,4,NULL,'0000-00-00 00:00:00'),
(40,13,0,4,NULL,'0000-00-00 00:00:00'),
(39,12,0,4,NULL,'0000-00-00 00:00:00'),
(38,11,0,4,NULL,'0000-00-00 00:00:00'),
(37,10,0,4,NULL,'0000-00-00 00:00:00'),
(36,9,0,4,NULL,'0000-00-00 00:00:00'),
(35,8,0,4,NULL,'0000-00-00 00:00:00'),
(34,7,0,4,NULL,'0000-00-00 00:00:00'),
(33,6,0,4,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (32,5,0,4,NULL,'0000-00-00 00:00:00'),
(31,4,0,4,NULL,'0000-00-00 00:00:00'),
(30,3,0,4,NULL,'0000-00-00 00:00:00'),
(29,2,0,4,NULL,'0000-00-00 00:00:00'),
(28,1,0,4,NULL,'0000-00-00 00:00:00'),
(267,239,0,5,NULL,'0000-00-00 00:00:00'),
(268,238,0,5,NULL,'0000-00-00 00:00:00'),
(269,237,0,5,NULL,'0000-00-00 00:00:00'),
(270,236,0,5,NULL,'0000-00-00 00:00:00'),
(271,235,0,5,NULL,'0000-00-00 00:00:00'),
(272,234,0,5,NULL,'0000-00-00 00:00:00'),
(273,233,0,5,NULL,'0000-00-00 00:00:00'),
(274,232,0,5,NULL,'0000-00-00 00:00:00'),
(275,231,0,5,NULL,'0000-00-00 00:00:00'),
(276,230,0,5,NULL,'0000-00-00 00:00:00'),
(277,229,0,5,NULL,'0000-00-00 00:00:00'),
(278,228,0,5,NULL,'0000-00-00 00:00:00'),
(279,227,0,5,NULL,'0000-00-00 00:00:00'),
(280,226,0,5,NULL,'0000-00-00 00:00:00'),
(281,225,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (282,224,0,5,NULL,'0000-00-00 00:00:00'),
(283,223,0,5,NULL,'0000-00-00 00:00:00'),
(284,222,0,5,NULL,'0000-00-00 00:00:00'),
(285,221,0,5,NULL,'0000-00-00 00:00:00'),
(286,220,0,5,NULL,'0000-00-00 00:00:00'),
(287,219,0,5,NULL,'0000-00-00 00:00:00'),
(288,218,0,5,NULL,'0000-00-00 00:00:00'),
(289,217,0,5,NULL,'0000-00-00 00:00:00'),
(290,216,0,5,NULL,'0000-00-00 00:00:00'),
(291,215,0,5,NULL,'0000-00-00 00:00:00'),
(292,214,0,5,NULL,'0000-00-00 00:00:00'),
(293,213,0,5,NULL,'0000-00-00 00:00:00'),
(294,212,0,5,NULL,'0000-00-00 00:00:00'),
(295,211,0,5,NULL,'0000-00-00 00:00:00'),
(296,210,0,5,NULL,'0000-00-00 00:00:00'),
(297,209,0,5,NULL,'0000-00-00 00:00:00'),
(298,208,0,5,NULL,'0000-00-00 00:00:00'),
(299,207,0,5,NULL,'0000-00-00 00:00:00'),
(300,206,0,5,NULL,'0000-00-00 00:00:00'),
(301,205,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (302,204,0,5,NULL,'0000-00-00 00:00:00'),
(303,203,0,5,NULL,'0000-00-00 00:00:00'),
(304,202,0,5,NULL,'0000-00-00 00:00:00'),
(305,201,0,5,NULL,'0000-00-00 00:00:00'),
(306,200,0,5,NULL,'0000-00-00 00:00:00'),
(307,199,0,5,NULL,'0000-00-00 00:00:00'),
(308,198,0,5,NULL,'0000-00-00 00:00:00'),
(309,197,0,5,NULL,'0000-00-00 00:00:00'),
(310,196,0,5,NULL,'0000-00-00 00:00:00'),
(311,195,0,5,NULL,'0000-00-00 00:00:00'),
(312,194,0,5,NULL,'0000-00-00 00:00:00'),
(313,193,0,5,NULL,'0000-00-00 00:00:00'),
(314,192,0,5,NULL,'0000-00-00 00:00:00'),
(315,191,0,5,NULL,'0000-00-00 00:00:00'),
(316,190,0,5,NULL,'0000-00-00 00:00:00'),
(317,189,0,5,NULL,'0000-00-00 00:00:00'),
(318,188,0,5,NULL,'0000-00-00 00:00:00'),
(319,187,0,5,NULL,'0000-00-00 00:00:00'),
(320,186,0,5,NULL,'0000-00-00 00:00:00'),
(321,185,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (322,184,0,5,NULL,'0000-00-00 00:00:00'),
(323,183,0,5,NULL,'0000-00-00 00:00:00'),
(324,182,0,5,NULL,'0000-00-00 00:00:00'),
(325,181,0,5,NULL,'0000-00-00 00:00:00'),
(326,180,0,5,NULL,'0000-00-00 00:00:00'),
(327,179,0,5,NULL,'0000-00-00 00:00:00'),
(328,178,0,5,NULL,'0000-00-00 00:00:00'),
(329,177,0,5,NULL,'0000-00-00 00:00:00'),
(330,176,0,5,NULL,'0000-00-00 00:00:00'),
(331,175,0,5,NULL,'0000-00-00 00:00:00'),
(332,174,0,5,NULL,'0000-00-00 00:00:00'),
(333,173,0,5,NULL,'0000-00-00 00:00:00'),
(334,172,0,5,NULL,'0000-00-00 00:00:00'),
(335,171,0,5,NULL,'0000-00-00 00:00:00'),
(337,169,0,5,NULL,'0000-00-00 00:00:00'),
(338,168,0,5,NULL,'0000-00-00 00:00:00'),
(339,167,0,5,NULL,'0000-00-00 00:00:00'),
(340,166,0,5,NULL,'0000-00-00 00:00:00'),
(341,165,0,5,NULL,'0000-00-00 00:00:00'),
(342,164,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (343,163,0,5,NULL,'0000-00-00 00:00:00'),
(344,162,0,5,NULL,'0000-00-00 00:00:00'),
(345,161,0,5,NULL,'0000-00-00 00:00:00'),
(346,160,0,5,NULL,'0000-00-00 00:00:00'),
(347,159,0,5,NULL,'0000-00-00 00:00:00'),
(348,158,0,5,NULL,'0000-00-00 00:00:00'),
(349,157,0,5,NULL,'0000-00-00 00:00:00'),
(350,156,0,5,NULL,'0000-00-00 00:00:00'),
(351,155,0,5,NULL,'0000-00-00 00:00:00'),
(352,154,0,5,NULL,'0000-00-00 00:00:00'),
(353,153,0,5,NULL,'0000-00-00 00:00:00'),
(354,152,0,5,NULL,'0000-00-00 00:00:00'),
(355,151,0,5,NULL,'0000-00-00 00:00:00'),
(356,150,0,5,NULL,'0000-00-00 00:00:00'),
(357,149,0,5,NULL,'0000-00-00 00:00:00'),
(358,148,0,5,NULL,'0000-00-00 00:00:00'),
(359,147,0,5,NULL,'0000-00-00 00:00:00'),
(360,146,0,5,NULL,'0000-00-00 00:00:00'),
(361,145,0,5,NULL,'0000-00-00 00:00:00'),
(362,144,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (363,143,0,5,NULL,'0000-00-00 00:00:00'),
(364,142,0,5,NULL,'0000-00-00 00:00:00'),
(365,141,0,5,NULL,'0000-00-00 00:00:00'),
(366,140,0,5,NULL,'0000-00-00 00:00:00'),
(367,139,0,5,NULL,'0000-00-00 00:00:00'),
(368,138,0,5,NULL,'0000-00-00 00:00:00'),
(369,137,0,5,NULL,'0000-00-00 00:00:00'),
(370,136,0,5,NULL,'0000-00-00 00:00:00'),
(371,135,0,5,NULL,'0000-00-00 00:00:00'),
(372,134,0,5,NULL,'0000-00-00 00:00:00'),
(373,133,0,5,NULL,'0000-00-00 00:00:00'),
(374,132,0,5,NULL,'0000-00-00 00:00:00'),
(375,131,0,5,NULL,'0000-00-00 00:00:00'),
(376,130,0,5,NULL,'0000-00-00 00:00:00'),
(377,129,0,5,NULL,'0000-00-00 00:00:00'),
(378,128,0,5,NULL,'0000-00-00 00:00:00'),
(379,127,0,5,NULL,'0000-00-00 00:00:00'),
(380,126,0,5,NULL,'0000-00-00 00:00:00'),
(381,125,0,5,NULL,'0000-00-00 00:00:00'),
(382,124,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (383,123,0,5,NULL,'0000-00-00 00:00:00'),
(384,122,0,5,NULL,'0000-00-00 00:00:00'),
(385,121,0,5,NULL,'0000-00-00 00:00:00'),
(386,120,0,5,NULL,'0000-00-00 00:00:00'),
(387,119,0,5,NULL,'0000-00-00 00:00:00'),
(388,118,0,5,NULL,'0000-00-00 00:00:00'),
(389,117,0,5,NULL,'0000-00-00 00:00:00'),
(390,116,0,5,NULL,'0000-00-00 00:00:00'),
(391,115,0,5,NULL,'0000-00-00 00:00:00'),
(392,114,0,5,NULL,'0000-00-00 00:00:00'),
(393,113,0,5,NULL,'0000-00-00 00:00:00'),
(394,112,0,5,NULL,'0000-00-00 00:00:00'),
(395,111,0,5,NULL,'0000-00-00 00:00:00'),
(396,110,0,5,NULL,'0000-00-00 00:00:00'),
(397,109,0,5,NULL,'0000-00-00 00:00:00'),
(398,108,0,5,NULL,'0000-00-00 00:00:00'),
(399,107,0,5,NULL,'0000-00-00 00:00:00'),
(400,106,0,5,NULL,'0000-00-00 00:00:00'),
(401,105,0,5,NULL,'0000-00-00 00:00:00'),
(402,104,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (403,103,0,5,NULL,'0000-00-00 00:00:00'),
(404,102,0,5,NULL,'0000-00-00 00:00:00'),
(405,101,0,5,NULL,'0000-00-00 00:00:00'),
(406,100,0,5,NULL,'0000-00-00 00:00:00'),
(407,99,0,5,NULL,'0000-00-00 00:00:00'),
(408,98,0,5,NULL,'0000-00-00 00:00:00'),
(409,97,0,5,NULL,'0000-00-00 00:00:00'),
(410,96,0,5,NULL,'0000-00-00 00:00:00'),
(411,95,0,5,NULL,'0000-00-00 00:00:00'),
(412,94,0,5,NULL,'0000-00-00 00:00:00'),
(413,93,0,5,NULL,'0000-00-00 00:00:00'),
(414,92,0,5,NULL,'0000-00-00 00:00:00'),
(415,91,0,5,NULL,'0000-00-00 00:00:00'),
(416,90,0,5,NULL,'0000-00-00 00:00:00'),
(417,89,0,5,NULL,'0000-00-00 00:00:00'),
(418,88,0,5,NULL,'0000-00-00 00:00:00'),
(419,87,0,5,NULL,'0000-00-00 00:00:00'),
(420,86,0,5,NULL,'0000-00-00 00:00:00'),
(421,85,0,5,NULL,'0000-00-00 00:00:00'),
(422,84,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (423,83,0,5,NULL,'0000-00-00 00:00:00'),
(424,82,0,5,NULL,'0000-00-00 00:00:00'),
(425,81,0,5,NULL,'0000-00-00 00:00:00'),
(426,80,0,5,NULL,'0000-00-00 00:00:00'),
(427,79,0,5,NULL,'0000-00-00 00:00:00'),
(428,78,0,5,NULL,'0000-00-00 00:00:00'),
(429,77,0,5,NULL,'0000-00-00 00:00:00'),
(430,76,0,5,NULL,'0000-00-00 00:00:00'),
(431,75,0,5,NULL,'0000-00-00 00:00:00'),
(432,74,0,5,NULL,'0000-00-00 00:00:00'),
(433,73,0,5,NULL,'0000-00-00 00:00:00'),
(434,72,0,5,NULL,'0000-00-00 00:00:00'),
(435,71,0,5,NULL,'0000-00-00 00:00:00'),
(436,70,0,5,NULL,'0000-00-00 00:00:00'),
(437,69,0,5,NULL,'0000-00-00 00:00:00'),
(438,68,0,5,NULL,'0000-00-00 00:00:00'),
(439,67,0,5,NULL,'0000-00-00 00:00:00'),
(440,66,0,5,NULL,'0000-00-00 00:00:00'),
(441,65,0,5,NULL,'0000-00-00 00:00:00'),
(442,64,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (443,63,0,5,NULL,'0000-00-00 00:00:00'),
(444,62,0,5,NULL,'0000-00-00 00:00:00'),
(445,61,0,5,NULL,'0000-00-00 00:00:00'),
(446,60,0,5,NULL,'0000-00-00 00:00:00'),
(447,59,0,5,NULL,'0000-00-00 00:00:00'),
(448,58,0,5,NULL,'0000-00-00 00:00:00'),
(449,57,0,5,NULL,'0000-00-00 00:00:00'),
(450,56,0,5,NULL,'0000-00-00 00:00:00'),
(451,55,0,5,NULL,'0000-00-00 00:00:00'),
(452,54,0,5,NULL,'0000-00-00 00:00:00'),
(453,53,0,5,NULL,'0000-00-00 00:00:00'),
(454,52,0,5,NULL,'0000-00-00 00:00:00'),
(455,51,0,5,NULL,'0000-00-00 00:00:00'),
(456,50,0,5,NULL,'0000-00-00 00:00:00'),
(457,49,0,5,NULL,'0000-00-00 00:00:00'),
(458,48,0,5,NULL,'0000-00-00 00:00:00'),
(459,47,0,5,NULL,'0000-00-00 00:00:00'),
(460,46,0,5,NULL,'0000-00-00 00:00:00'),
(461,45,0,5,NULL,'0000-00-00 00:00:00'),
(462,44,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (463,43,0,5,NULL,'0000-00-00 00:00:00'),
(464,42,0,5,NULL,'0000-00-00 00:00:00'),
(465,41,0,5,NULL,'0000-00-00 00:00:00'),
(466,40,0,5,NULL,'0000-00-00 00:00:00'),
(467,39,0,5,NULL,'0000-00-00 00:00:00'),
(468,38,0,5,NULL,'0000-00-00 00:00:00'),
(469,37,0,5,NULL,'0000-00-00 00:00:00'),
(470,36,0,5,NULL,'0000-00-00 00:00:00'),
(471,35,0,5,NULL,'0000-00-00 00:00:00'),
(472,34,0,5,NULL,'0000-00-00 00:00:00'),
(473,33,0,5,NULL,'0000-00-00 00:00:00'),
(474,32,0,5,NULL,'0000-00-00 00:00:00'),
(475,31,0,5,NULL,'0000-00-00 00:00:00'),
(476,30,0,5,NULL,'0000-00-00 00:00:00'),
(477,29,0,5,NULL,'0000-00-00 00:00:00'),
(478,28,0,5,NULL,'0000-00-00 00:00:00'),
(479,27,0,5,NULL,'0000-00-00 00:00:00'),
(480,26,0,5,NULL,'0000-00-00 00:00:00'),
(481,25,0,5,NULL,'0000-00-00 00:00:00'),
(482,24,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (483,23,0,5,NULL,'0000-00-00 00:00:00'),
(484,22,0,5,NULL,'0000-00-00 00:00:00'),
(485,21,0,5,NULL,'0000-00-00 00:00:00'),
(486,20,0,5,NULL,'0000-00-00 00:00:00'),
(487,19,0,5,NULL,'0000-00-00 00:00:00'),
(488,18,0,5,NULL,'0000-00-00 00:00:00'),
(489,17,0,5,NULL,'0000-00-00 00:00:00'),
(490,16,0,5,NULL,'0000-00-00 00:00:00'),
(491,15,0,5,NULL,'0000-00-00 00:00:00'),
(492,14,0,5,NULL,'0000-00-00 00:00:00'),
(493,13,0,5,NULL,'0000-00-00 00:00:00'),
(494,12,0,5,NULL,'0000-00-00 00:00:00'),
(495,11,0,5,NULL,'0000-00-00 00:00:00'),
(496,10,0,5,NULL,'0000-00-00 00:00:00'),
(497,9,0,5,NULL,'0000-00-00 00:00:00'),
(498,8,0,5,NULL,'0000-00-00 00:00:00'),
(499,7,0,5,NULL,'0000-00-00 00:00:00'),
(500,6,0,5,NULL,'0000-00-00 00:00:00'),
(501,5,0,5,NULL,'0000-00-00 00:00:00'),
(502,4,0,5,NULL,'0000-00-00 00:00:00');
insert into `zones_to_geo_zones` (`association_id`, `zone_country_id`, `zone_id`, `geo_zone_id`, `last_modified`, `date_added`) values (503,3,0,5,NULL,'0000-00-00 00:00:00'),
(504,2,0,5,NULL,'0000-00-00 00:00:00'),
(505,1,0,5,NULL,'0000-00-00 00:00:00');

