<?php
/* utf-8 marker: äöü
************************************
FotoGalerie_XH plugin for CMSimple
Developed by: ge-webdesign.de
Version: FotoGalerie_XH v6.6
Released: 11/2012

Based on:  
- kissGallery: 			Claus Højberg (alias Softly)
- Shutter Reloaded:		digitalia.be
- TableSort:			javascript.jstruebig.de
************************************
License:  
Linkware License (private websites)
Remove Link License (private websites)
Commercial License (commercial websites)

For Licenses see: http://www.ge-webdesign.de/cmsimpleplugins/
************************************
*/

// FUNCTIONS 

include_once('fogafuncs.php');


// MAIN FUNCTION

function foga($fogasel) 
{
 	GLOBAL $plugin_cf,$plugin_tx, $sn, $su, $pth, $hjs, $sl, $i, $s, $u, $fogalayout, $fogathumbsalign, $fogathumbcols, $fogathumbheight, $fogathumbclick, $fogaslide_align, $fogaslide_imgheight, $fogaslide_thumbheight, $fogashowname, $fogashowdesc,$fogaslide_showdesc,$foga_bigpic_padding,$foga_thumbs_padding,$foga_pics_background,$foga_pics_border,$grec,$co_author_folder;
	
	$fngroup='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_data'].'album.txt';
	$fnfile='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_data'].'photo.txt';
	$plugin=basename(dirname(__FILE__),"/");
    $filepath='./'.@$co_author_folder.$plugin_cf['fotogalerie']['filepath_images'];

	$groups=fogaRFile($fngroup);
	$files=fogaRFile($fnfile);
	
//	echo 'von Foga: ' . $co_author_folder . '<br>';

	if (!isset($hjs)) { $hjs=''; }
	
	if($plugin_cf['fotogalerie']['activate_lightbox'] == 'true')
	{
		include_once($pth['folder']['plugins'].'fotogalerie/loadlightbox.php');
	}
	
	if ($fogasel!=0) 
	{
		$tarr=array();
		foreach ($files as $num => $rec) 
		{
			if ($rec[2]==$fogasel) 
			{
				$tarr[]=$rec;
			}
		}
		$files=$tarr;
	}
	
	$txt="\n".'<div class="foga_main">';

	if ($fogasel!=0) 
	{
		foreach ($groups as $gnum => $grec) 
		{
			if ($grec[0]==$fogasel) 
			{
				$gname=str_replace(' ', '', $grec[2]);
				$gallery_h4=$grec[2];
				$fogashowname=$grec[3];
				$gdesc=$grec[4];
				$fogashowdesc=$grec[5];
				$fogalayout=$grec[6];
				$fogathumbsalign=$grec[7];
				$fogathumbcols=$grec[8];
				$fogathumbheight=$grec[9];
				$fogathumbclick=$grec[10];
				$fogaslide_align=$grec[11];
				$fogaslide_imgheight=$grec[12];
				$fogaslide_thumbheight=$grec[13];
				$fogaslide_showthumbs=$grec[14];
				$fogaslide_showdesc=$grec[15];
				$foga_bigpic_padding=$grec[16];
				$foga_thumbs_padding=$grec[17];
				$foga_pics_background=$grec[18];
				$foga_pics_border=$grec[19];
			}
		}
		
		
//		gallery header		
		
		$txt.="\n\n".'<div id="' . $gname . '" class="fotogalerie_head">'."\n";
		
		if (fogaIsTrue($fogashowname)) 
		{
			$txt.='<h4>'.$gallery_h4.'</h4>'."\n";
		}
		if (fogaIsTrue($fogashowdesc)) 
		{
			$txt.='<p>'.$gdesc.'</p>'."\n";
		}
		
		$txt.='</div>'."\n";
	}
	
	
//	preview table layout

	if($fogalayout=='table' && $fogasel!='0')
	{
	
		$txt.='<div class="fotogalerie_table" style="text-align: '.$fogathumbsalign.'">'."\n";
	
		if($fogathumbheight=='auto')
		{
			$thumb_style='style="background: ' . $foga_pics_background . '; padding: ' . $foga_thumbs_padding . 'px; border: ' . $foga_pics_border . ';"';
		}
		else
		{
			$thumb_style='style="height: '.$fogathumbheight.'px; background: ' . $foga_pics_background . '; padding: ' . $foga_thumbs_padding . 'px; border: ' . $foga_pics_border . ';"';
		}

		if (sizeof($files)>0) 
		{
			$txt.='<table style="border-spacing: ' . $plugin_cf['fotogalerie']['thumb_table_cellspacing'] . 'px">'."\n".'<tr><td colspan="'.$fogathumbcols.'"> </td>';
			foreach ($files as $num => $pics) 
			{
				if (($num % $fogathumbcols) == 0)
				{
					$txt.='</tr>'."\n\n".'<tr>'."\n";
				}
				
				$picarr[$num] = $pics[0];
				$descarr[$num] = $pics[6];
				$txt.='<td>' . "\n";
			
				if($fogathumbclick=='lightbox')
				{
					$txt.='<a href="'.$filepath.$picarr[$num].'.jpg" class="shutterset_'.$fogasel.'" title="'.$descarr[$num].'">' . tag('img src="'.$filepath.'thumbs/'.$picarr[$num].'t.jpg" ' . $thumb_style . ' alt="' . $descarr[$num] . '"') . "\n" . '</a>';
				}
				else
				{
				$txt.='<a href="?'.$su.'&amp;slide&amp;imgid='.$num.'&amp;heading='.$gname.'#'.$gname.'" title="'.$descarr[$num].'">' . tag('img src="'.$filepath.'thumbs/'.$picarr[$num].'t.jpg" ' . $thumb_style . ' alt="' . $descarr[$num] . '"') . "\n" . '</a>';
				}
			
				$txt.="\n" . '</td>'."\n";
			
			}
			$num=$num+1;
			if (($num % $fogathumbcols)>0) 
			{
				for ($j=1;$j<=($fogathumbcols-($num % $fogathumbcols));$j++) 
				{
					$txt.='<td>&nbsp;</td>';
				}
			}
			$txt.='</tr>'."\n".'</table>'."\n";
// LEGAL LINK
// You are not allowed to remove the legal link without purchase a license:
// Dieser Link darf nicht entfernt werden, ohne eine Lizenz zu erwerben:
// http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen/Commercial_Licence
				$txt.='<p class="fotogalerie_legal">Powered by <a href="http://www.ge-webdesign.de/cmsimpleplugins/?Eigene_Plugins/FotoGalerie_XH">FotoGalerie_XH</a></p>'."\n";
// END LEGAL LINK
		}
		else 
		{
			$txt.='<p class="nopicmessage">'.$plugin_tx['fotogalerie']['message_no_images'].'</p>';
		}
		$txt.='</div>'."\n";
	}


//	preview float layout

	if($fogalayout=='float' || $fogasel==0)
	{
		if($fogasel==0) // shows all images
		{
			$fogathumbsalign=$plugin_cf['fotogalerie']['default_gallery_thumbs_align'];
			$fogathumbheight=$plugin_cf['fotogalerie']['thumb_size_all_gallerys'];
			$fogathumbclick='lightbox';
			$foga_pics_background='#fff';
			$foga_pics_border=$plugin_cf['fotogalerie']['default_pics_border'];
			$foga_pics_background=$plugin_cf['fotogalerie']['default_pics_background'];
			$foga_thumbs_padding=$plugin_cf['fotogalerie']['default_slideshow_thumbs_padding'];
		}
	
		$txt.='<div class="fotogalerie_float" style="text-align: '.$fogathumbsalign.'">'."\n";
	
		if($fogathumbheight=='auto')
		{
			$thumb_style='style="background: ' . $foga_pics_background . '; padding: ' . $foga_thumbs_padding . 'px; border: ' . $foga_pics_border . ';"';
		}
		else
		{
			$thumb_style='style="height: '.$fogathumbheight.'px; background: ' . $foga_pics_background . '; padding: ' . $foga_thumbs_padding . 'px; border: ' . $foga_pics_border . ';"';
		}

		if (sizeof($files)>0) 
		{
			foreach ($files as $num => $pics) 
			{
				$picarr[$num] = $pics[0];
				$descarr[$num] = $pics[6];
			
				if($fogathumbclick=='lightbox')
				{
					$txt.='<a href="'.$filepath.$picarr[$num].'.jpg" class="shutterset_'.$fogasel.'" title="'.$descarr[$num].'">' . tag('img src="'.$filepath.'thumbs/'.$picarr[$num].'t.jpg" ' . $thumb_style . ' alt="' . $descarr[$num] . '"') . "\n" . '</a>'."\n";
				}
				else
				{
					$txt.='<a href="?'.$su.'&amp;slide&amp;imgid='.$num.'&amp;heading='.$gname.'#'.$gname.'" title="'.$descarr[$num].'">' . tag('img src="'.$filepath.'thumbs/'.$picarr[$num].'t.jpg" ' . $thumb_style . ' alt="' . $descarr[$num] . '"') . "\n" . '</a>'."\n";
				}
			}
			$num=$num+1;
// LEGAL LINK
// You are not allowed to remove the legal link without purchase a license:
// Dieser Link darf nicht entfernt werden, ohne eine Lizenz zu erwerben:
// http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen/Commercial_Licence
			$txt.='<p class="fotogalerie_legal">Powered by <a href="http://www.ge-webdesign.de/cmsimpleplugins/?Eigene_Plugins/FotoGalerie_XH">FotoGalerie_XH</a></p>'."\n";
// END LEGAL LINK
		} 
		else 
		{
		$txt.='<p class="nopicmessage">'.$plugin_tx['fotogalerie']['message_no_images'].'</p>'."\n";
		}
	$txt.='</div>'."\n";
	}

		
//	Array Test
/*
print_r ($files[4][0]);
echo ('<br><br>');
print_r ($files);
echo ('<br><br>');

print_r($picarr[1]);
echo ('<br><br>');
print_r ($descarr);
*/
	
//	SLIDESHOW
	
	if(isset($_REQUEST['slide']) && ($gname==$_REQUEST['heading']))
	{
		$prev=$_REQUEST['imgid'] - 1;
		$next=$_REQUEST['imgid'] + 1;
		$summe=count($picarr);
		
		$txt="\n".'<div class="foga_main">'."\n";
		$txt.="\n".'<div class="fotogalerie_slideshow" style="text-align: '.$fogaslide_align.'">'."\n\n";
		if(fogaIsTrue($fogashowname))
		{
			$txt.='<h4>'.$gallery_h4.'</h4>'."\n";
		}
		if (fogaIsTrue($fogashowdesc)) 
		{
			$txt.='<p>'.$gdesc.'</p>'."\n";
		}
		$txt.='<p id="' . $gname . '">' . $plugin_tx['fotogalerie']['lightbox_image'] . ' ' . ($_REQUEST['imgid']+1) . ' / '.$summe.'</p>' . "\n";
		$txt.='<p class="slideshownav">'."\n";

		if($prev > (-1))
		{
			$txt.='<a href="?'.$su.'&amp;slide&amp;imgid='.$prev.'&amp;heading='.$_REQUEST['heading'].'#'.$gname.'">&lArr;</a>'."\n";
		}
		
		$txt.='&nbsp;<a href="?'.$su.'#'.$gname.'">&nbsp;&uArr;&nbsp;</a>&nbsp;'."\n";
		
		if($next < $summe)
		{
			$txt.='<a href="?'.$su.'&amp;slide&amp;imgid='.$next.'&amp;heading='.$_REQUEST['heading'].'#'.$gname.'">&rArr;</a>'."\n";
		}
		
		$txt.='</p>'."\n";
		
		if($plugin_cf['fotogalerie']['slideshow_use_slimbox']=='true')
		{
			$txt.="\n" . '<a href="'.$filepath.$picarr[$_REQUEST['imgid']].'.jpg" class="shutterset_'.$fogasel.'" title="'.$descarr[$num].'">';
		}
			
		$txt.=tag('img src="'.$filepath.$picarr[$_REQUEST['imgid']].'.jpg" style="height: ' . $fogaslide_imgheight . 'px;  background: ' . $foga_pics_background . '; padding: ' . $foga_bigpic_padding . 'px; border: ' . $foga_pics_border . ';" alt="'.$descarr[$_REQUEST['imgid']].'"  title="'.$descarr[$_REQUEST['imgid']].'"')."\n";
		
		if($plugin_cf['fotogalerie']['slideshow_use_slimbox']=='true')
		{
			$txt.='</a>';
		}

		if($fogaslide_showdesc=='true')
		{
			$txt.='<p>'.$descarr[$_REQUEST['imgid']].'</p>'."\n";
		}
		else
		{
		$txt.=tag('br')."\n".tag('br')."\n";
		}
		
		// Slideshow thumbs	
	
		if($fogaslide_showthumbs=='true')
		{
			foreach ($files as $num => $pics) 
			{
				$picarr[$num] = $pics[0];
				$descarr[$num] = $pics[6];
				$txt.="\n" . '<a href="?'.$su.'&amp;slide&amp;imgid='.$num.'&amp;heading='.$gname.'#'.$gname.'" title="'.$descarr[$num].'">'."\n" . tag('img src="'.$filepath.'thumbs/'.$picarr[$num].'t.jpg" style="height: ' . $fogaslide_thumbheight . 'px;  background: ' . $foga_pics_background . '; border: ' . $foga_pics_border . '; padding: ' . $foga_thumbs_padding . 'px;" alt="' . $descarr[$num] . '"') . "\n" . '</a>'."\n";
			}
		}

// LEGAL LINK
// You are not allowed to remove the legal link without purchase a license:
// Dieser Link darf nicht entfernt werden, ohne eine Lizenz zu erwerben:
// http://www.ge-webdesign.de/cmsimpleplugins/?Nutzungsbedingungen/Commercial_Licence
		$txt.='<p class="fotogalerie_legal">Powered by <a href="http://www.ge-webdesign.de/cmsimpleplugins/?Eigene_Plugins/FotoGalerie_XH">FotoGalerie_XH</a></p>'."\n";
		$txt.="\n".'</div>'."\n";
		
// END LEGAL LINK
	}
	$txt.='</div>'."\n";
	return $txt;

}
?>