<?php

 /**
 * @file plikBackend.php 
 * @author Damian Świstowski <dswistowski@gery.firma.pl>
 * @brief plik backend zapewniający zachowanie trwałości danych używając zwykłych plików
 * 
 * @license http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * 
 */

/**
 * @brief cachowanie obiektów używając systemu plików
 * 
 * Klasa backendu do cachowania obiektów w plikach.
 */
class plikBackend extends backend
{
	public function pobierz($model, $id, $waznosc)
	{
		$plik = $this->getSciezka($model, $id);
		if(!file_exists($plik))
			return null;
		if(filectime($plik)<time()-$waznosc)
			return null;
		
		return file_get_contents($plik);
	}
	
	private function getSciezka($model, $id)
	{
		$plik_md5 =  md5($model.$id);
		$sciezka = $this->opcje['sciezka'].$model.'/'.$plik_md5[0].'/'.$plik_md5[1];
		if(!file_exists($sciezka))
			mkdir($sciezka, 0700, true);
		return $sciezka.'/'.$plik_md5; 
	}
	
	public function zapisz($model, $id, $dane)
	{
		$plik = $this->getSciezka($model, $id);
		file_put_contents($plik, $dane);
	}
}
?>