<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

    if (isset($_POST['akcja']) && $_POST['akcja'] == 'zapisz') {

      $wartosc_towarow_brutto = 0;

      // dodanie rekordu do tablicy invoices
      $pola = array(
              array('orders_id',$filtr->process($_POST['zamowienie_id'])),
              array('invoices_type',$filtr->process($_POST['rodzaj_faktury'])),
              array('invoices_nr',$filtr->process($_POST['faktura_numer'])),
              array('invoices_date_sell',date('Y-m-d', strtotime($filtr->process($_POST['data_sprzedazy'])))),
              array('invoices_date_generated',date('Y-m-d', strtotime($filtr->process($_POST['data_wystawienia'])))),
              array('invoices_date_modified','now()'),
              array('invoices_billing_name',$filtr->process($_POST['klient_nazwa'])),
              array('invoices_billing_company_name',$filtr->process($_POST['klient_firma'])),
              array('invoices_billing_nip',$filtr->process($_POST['klient_nip'])),
              array('invoices_billing_pesel',$filtr->process($_POST['klient_pesel'])),
              array('invoices_billing_street_address',$filtr->process($_POST['klient_ulica'])),
              array('invoices_billing_city',$filtr->process($_POST['klient_miasto'])),
              array('invoices_billing_postcode',$filtr->process($_POST['klient_kod_pocztowy'])),
              array('invoices_billing_country',$filtr->process($_POST['klient_panstwo'])),
              array('invoices_payment_type',$filtr->process($_POST['platnosc'])),
              array('invoices_payment_status', ( isset($_POST['rozliczona']) && $_POST['rozliczona'] == '1' ? $_POST['rozliczona'] : '0') ),
              array('invoices_date_payment',( isset($_POST['rozliczona']) && $_POST['rozliczona'] == '1' ? date('Y-m-d', strtotime($filtr->process($_POST['data_wystawienia']))) : date('Y-m-d', strtotime($filtr->process($_POST['data_platnosci']))) )),
              array('invoices_comments',$filtr->process($_POST['komentarz'])));
              
      $db->insert_query('invoices' , $pola);
      unset($pola);
      
      $id_dodanej_pozycji = $db->last_id_query();

      // aktualizacja zapisow w tablicy orders_products
      foreach ( $_POST['produkt'] as $produkt ) {

        $pola = array(
                array('products_invoice_name',$filtr->process($produkt['nazwa'])),
                array('products_pkwiu',$filtr->process($produkt['pkwiu'])),
                array('products_quantity',$filtr->process($produkt['ilosc'])),
                array('products_price',$filtr->process($produkt['cena_netto']) - $filtr->process($produkt['cecha_cena_netto'])),
                array('products_price_tax',$filtr->process($produkt['cena_brutto']) - $filtr->process($produkt['cecha_cena_brutto'])),
                array('final_price',$filtr->process($produkt['cena_netto'])),
                array('final_price_tax',$filtr->process($produkt['cena_brutto'])));
                
        //
        $stawka_vat = explode('|', $produkt['vat']);
        $pola[] = array('products_tax',$stawka_vat[0]);
        $pola[] = array('products_tax_class_id',$stawka_vat[1]);   
        unset($stawka_vat);                
        //                 
                
        $db->update_query('orders_products' , $pola, " orders_products_id = '".$filtr->process($produkt['orders_products_id'])."' AND orders_id = '".$filtr->process($_POST['zamowienie_id'])."'");
        unset($pola);
        
        // wartosc produktow
        $wartosc_towarow_brutto = $wartosc_towarow_brutto + ( $produkt['cena_brutto'] * $produkt['ilosc']);

        // aktualizacja stanow magazynowych produktu
        if ( MAGAZYN_SPRAWDZ_STANY == 'tak' ) {

            $Ilosc = $produkt['ilosc_org'] - $produkt['ilosc'];

            if ( $produkt['ilosc_org'] != $produkt['ilosc'] ) {

                $zapytanie_sprzedane = "SELECT products_ordered, products_quantity FROM products WHERE products_id = '".(int)$produkt['products_id']."'";
                $sql_sprzedane = $db->open_query($zapytanie_sprzedane);
                $sprzedane = $sql_sprzedane->fetch_assoc();

                if ( $Ilosc > 0 ) {
                    $sprzedane_akt = $sprzedane['products_ordered'] - $Ilosc;
                    $stanMagazynu_akt = $sprzedane['products_quantity'] + $Ilosc;
                } elseif ( $Ilosc < 0 ) {
                    $IloscProd = abs($Ilosc);
                    $sprzedane_akt = $sprzedane['products_ordered'] + $Ilosc;
                    $stanMagazynu_akt = $sprzedane['products_quantity'] - $IloscProd;
                }

                if ( $Ilosc != 0 ) {

                    $pola = array(
                            array('products_ordered',$sprzedane_akt),
                            array('products_quantity',$stanMagazynu_akt));

                    $db->update_query('products' , $pola, "products_id = '" . (int)$produkt['products_id'] . "'");

                }

                $db->close_query($sql_sprzedane);         
                unset($zapytanie_sprzedane, $sprzedane, $pola);

                if ( CECHY_MAGAZYN == 'tak' ) {

                    if ( $produkt['cechy_kombinacja'] != '' ) {

                        // cechy przeslane w formularzu
                        $TablicaKombinacji = explode(',', $produkt['cechy_kombinacja'] );
                        natsort($TablicaKombinacji);

                        // wybranie stanow magazynowych cech dla modyfikowanego produktu
                        $zapytanie_cechy_sprzedane = "SELECT products_stock_quantity, products_stock_id, products_stock_attributes FROM products_stock WHERE products_id = '".(int)$produkt['products_id']."'";
                        $sql_cechy_sprzedane = $db->open_query($zapytanie_cechy_sprzedane);

                        if ( (int)$db->ile_rekordow($sql_cechy_sprzedane) > 0 ) {

                            while ( $cechy_sprzedane = $sql_cechy_sprzedane->fetch_assoc() ) {

                                $TablicaKombinacjiBaza = array();
                                $TablicaKombinacjiBaza = explode(',', $cechy_sprzedane['products_stock_attributes'] );

                                natsort($TablicaKombinacjiBaza);

                                if ( !array_diff($TablicaKombinacji, $TablicaKombinacjiBaza) && !array_diff($TablicaKombinacjiBaza, $TablicaKombinacji) ) {

                                    if ( $Ilosc > 0 ) {
                                        $cechyMagazyn_akt = $cechy_sprzedane['products_stock_quantity'] + $Ilosc;
                                    } else {
                                        $IloscCech = abs($Ilosc);
                                        $cechyMagazyn_akt = $cechy_sprzedane['products_stock_quantity'] - $IloscCech;
                                    }

                                    $pola = array(
                                            array('products_stock_quantity',$cechyMagazyn_akt));

                                    $db->update_query('products_stock' , $pola, "products_id = '" . (int)$produkt['products_id'] . "' AND products_stock_id = '".(int)$cechy_sprzedane['products_stock_id']."'");

                                    unset($pola);

                                  }

                                  unset($TablicaKombinacjiBaza, $IloscCech);

                              }

                          }

                          $db->close_query($sql_cechy_sprzedane);         
                          unset($zapytanie_cechy_sprzedane, $cechy_sprzedane, $cechyMagazyn_akt);

                    }
                }

            }

        }

      }

      // aktualizacja wpisow w tablicy orders_total
      foreach ( $_POST['podsuma'] as $podsuma ) {

        $pola = array(
                array('title',$filtr->process($podsuma['nazwa'])),
                array('text',$waluty->FormatujCene($filtr->process($podsuma['wartosc_brutto']),false, $filtr->process($_POST['waluta_zamowienia']))),
                array('value',$filtr->process($podsuma['wartosc_brutto'])));
                
        if ( isset($podsuma['vat']) ) {
            //
            $stawka_vat = explode('|', $podsuma['vat']);
            $pola[] = array('tax',$stawka_vat[0]);
            $pola[] = array('tax_class_id',$stawka_vat[1]);   
            unset($stawka_vat);                
            //
        }
        
        $db->update_query('orders_total' , $pola, " orders_total_id = '".$filtr->process($podsuma['orders_total_id'])."'");
        unset($pola);
      }

      $pola = array(
              array('text',$waluty->FormatujCene($_POST['total_brutto'],false, $filtr->process($_POST['waluta_zamowienia']))),
              array('value',$filtr->process($_POST['total_brutto'])));
              
      $db->update_query('orders_total' , $pola, " orders_id = '".(int)$_POST['zamowienie_id']."' AND class='ot_total'");
      unset($pola);

      $pola = array(
              array('text',$waluty->FormatujCene($wartosc_towarow_brutto,false, $filtr->process($_POST['waluta_zamowienia']))),
              array('value',$filtr->process($wartosc_towarow_brutto)));
              
      $db->update_query('orders_total' , $pola, " orders_id = '".(int)$_POST['zamowienie_id']."' AND class='ot_subtotal'");
      unset($pola);

      if ( isset($_POST['ot_loyalty_discount']) ) {
          $pola = array(
                  array('text',$waluty->FormatujCene($_POST['ot_loyalty_discount'],false, $filtr->process($_POST['waluta_zamowienia']))),
                  array('value',$filtr->process($_POST['ot_loyalty_discount'])));
                  
          $db->update_query('orders_total' , $pola, " orders_id = '".(int)$_POST['zamowienie_id']."' AND class='ot_loyalty_discount'");
          unset($pola);
      }

      if ( isset($_POST['ot_redemptions']) ) {
          $pola = array(
                  array('text',$waluty->FormatujCene($_POST['ot_redemptions'],false, $filtr->process($_POST['waluta_zamowienia']))),
                  array('value',$filtr->process($_POST['ot_redemptions'])));
                  
          $db->update_query('orders_total' , $pola, " orders_id = '".(int)$_POST['zamowienie_id']."' AND class='ot_redemptions'");
          unset($pola);
      }

      if ( isset($_POST['ot_discount_coupon']) ) {
          $pola = array(
                  array('text',$waluty->FormatujCene($_POST['ot_discount_coupon'],false, $filtr->process($_POST['waluta_zamowienia']))),
                  array('value',$filtr->process($_POST['ot_discount_coupon'])));
                  
          $db->update_query('orders_total' , $pola, " orders_id = '".(int)$_POST['zamowienie_id']."' AND class='ot_discount_coupon'");
          unset($pola);
      }

      if ( isset($_POST['ot_shopping_discount']) ) {
          $pola = array(
                  array('text',$waluty->FormatujCene($_POST['ot_shopping_discount'],false, $filtr->process($_POST['waluta_zamowienia']))),
                  array('value',$filtr->process($_POST['ot_shopping_discount'])));
                  
          $db->update_query('orders_total' , $pola, " orders_id = '".(int)$_POST['zamowienie_id']."' AND class='ot_shopping_discount'");
          unset($pola);
      }

      if ( isset($_POST['total_rabat_brutto']) ) {
          $pola = array(
                  array('text',$waluty->FormatujCene($_POST['total_rabat_brutto'],false, $filtr->process($_POST['waluta_zamowienia']))),
                  array('value',$filtr->process($_POST['total_rabat_brutto'])));
                  
          $db->update_query('orders_total' , $pola, " orders_id = '".(int)$_POST['zamowienie_id']."' AND class='ot_total'");
          unset($pola);
      }

      Funkcje::PrzekierowanieURL('zamowienia_szczegoly.php?id_poz='.(int)$_POST["zamowienie_id"].'&zakladka='.$filtr->process($_POST["zakladka"]).'');

    }

    // wczytanie naglowka HTML
    include('naglowek.inc.php');

    $zamowienie          = new Zamowienie((int)$_GET['id_poz']);
    $tablica_jm          = array();
    $tablica_jm          = Produkty::TablicaJednostekMiaryProduktow();
    $tablica_vat         = array();
    $domyslny_vat        = '';

    $stawki_tablica       = Array();
    $podsumowanie_tablica = Array();

    $sql_tmp = $db->open_query("select * from tax_rates order by sort_order");
    
    while ($stawki_vat = $sql_tmp->fetch_assoc()) {
    
        $stawki_tablica[] = $stawki_vat['tax_rate'] . '|' . $stawki_vat['tax_rates_id'];
        $tablica_vat[] = array('id' => $stawki_vat['tax_rate'] . '|' . $stawki_vat['tax_rates_id'], 'text' => $stawki_vat['tax_short_description']);
        
        if ( $stawki_vat['tax_default'] == '1' ) {
          $domyslny_vat = $stawki_vat['tax_rate'].'|'.$stawki_vat['tax_short_description'];
        }
        
    }
    $db->close_query($sql_tmp);

    $numer_faktury = Sprzedaz::WygenerujNumerFaktury( '2' ); 
    ?>
    
    <div id="naglowek_cont">Faktura</div>

    <script type="text/javascript" src="javascript/faktura.js"></script>
    
    <script>
    <?php include('faktura.js.php'); ?>
    </script>

    <div id="cont">

      <?php
      if (count($zamowienie) > 0) {
        ?>
        
        <script>
        $(document).ready(function() {

          $("#fakturaForm").validate({
            rules: {
              faktura_numer: {required: true, remote: "ajax/sprawdz_numer_faktury.php?typ=2"},
              <?php if ( trim($zamowienie->platnik['firma']) != '' ) { ?>
              klient_firma: {required: true},
              <?php } else { ?>
              klient_nazwa: {required: true},
              <?php } ?>
              klient_ulica: {required: true},
              klient_miasto: {required: true},
              klient_kod_pocztowy: {required: true}
            },
            messages: {
              faktura_numer: {required: "Pole jest wymagane.", remote: "Taki numer faktury już istnieje."}
            }
          });

          $('input.datepicker').Zebra_DatePicker({
            format: 'd-m-Y',
            inside: false,
            readonly_element: true
          });

        });
        </script>
            
        <form action="sprzedaz/zamowienia_faktura_generuj.php" method="post" id="fakturaForm" class="cmxform">          

          <div class="poleForm">
            <div class="naglowek">Faktura do zamówienia nr: <?php echo $_GET['id_poz']; ?></div>
                
            <div class="pozycja_edytowana">
            
              <div class="info_content">
                    
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="zamowienie_id" value="<?php echo $filtr->process((int)$_GET['id_poz']); ?>" />
                <input type="hidden" name="zakladka" value="<?php echo $filtr->process((int)$_GET['zakladka']); ?>" />
                <input type="hidden" name="rodzaj_faktury" value="2" />
                <input type="hidden" name="waluta_zamowienia" value="<?php echo $zamowienie->info['waluta']; ?>" />

                <p>
                    <label class="required">Numer faktury:</label>
                    <input type="text" name="faktura_numer" id="faktura_numer" size="10" value="<?php echo $numer_faktury; ?>" /> <span class="RokFaktury">/<?php echo ROK_KSIEGOWY_FAKTUROWANIA; ?></span>
                    <label style="display:none" class="error" for="faktura_numer" generated="true"></label>
                </p> 

                <p>
                    <label>Data sprzedaży:</label>
                    <input type="text" name="data_sprzedazy" id="data_sprzedazy" size="20" value="<?php echo date('d-m-Y', strtotime($zamowienie->info['data_zamowienia'])); ?>" class="datepicker" />
                </p> 

                <p>
                    <label>Data wystawienia:</label>
                    <input type="text" name="data_wystawienia" id="data_wystawienia" size="20" value="<?php echo date("d-m-Y"); ?>" class="datepicker" />
                </p> 
                
                <hr style="color:#82b4cd;border-top: 1px dashed #c0d9e6;border-bottom:none;border-left:none;border-right:none;width:98%;" />

                <p>
                    <label class="required">Nabywca:</label>
                    <?php if ( trim($zamowienie->platnik['firma']) != '' ) { ?>
                        <input type="text" name="klient_firma" id="klient_firma" size="120" value="<?php echo Funkcje::formatujTekstInput($zamowienie->platnik['firma']); ?>" />
                        <input type="hidden" name="klient_nazwa" value="" />
                    <?php } else { ?>
                        <input type="text" name="klient_nazwa" id="klient_nazwa" size="120" value="<?php echo Funkcje::formatujTekstInput($zamowienie->platnik['nazwa']); ?>" />
                        <input type="hidden" name="klient_firma" value="" />
                    <?php } ?>
                </p> 

                <p>
                    <label>NIP:</label>
                    <input type="text" name="klient_nip" id="klient_nip" size="30" value="<?php echo $zamowienie->platnik['nip']; ?>" />
                    <label style="padding-left:20px;width:45px;">PESEL:</label>
                    <input type="text" name="klient_pesel" id="pesel" size="20" value="<?php echo $zamowienie->platnik['pesel']; ?>" />
                </p> 

                <p>
                    <label class="required">Adres:</label>
                    <input type="text" name="klient_ulica" id="klient_ulica" size="120" value="<?php echo Funkcje::formatujTekstInput($zamowienie->platnik['ulica']); ?>" />
                </p> 

                <p>
                    <label class="required">Miejscowość:</label>
                    <input type="text" name="klient_miasto" id="klient_miasto" size="80" value="<?php echo Funkcje::formatujTekstInput($zamowienie->platnik['miasto']); ?>" />
                </p> 

                <p>
                    <label class="required">Kod pocztowy:</label>
                    <input type="text" name="klient_kod_pocztowy" id="klient_kod_pocztowy" size="53" value="<?php echo $zamowienie->platnik['kod_pocztowy']; ?>" />
                </p> 
                
                <p>
                    <label>Kraj:</label>
                    <input type="text" name="klient_panstwo" id="klient_panstwo" size="53" value="<?php echo $zamowienie->platnik['kraj']; ?>" />
                </p> 

                <hr style="color:#82b4cd;border-top: 1px dashed #c0d9e6;border-bottom:none;border-left:none;border-right:none;width:98%;" />

                <?php
                $tablica = array();
                $tablica = Sprzedaz::TablicaTypowPlatnosci();
                ?>
                <p>
                    <label>Rodzaj płatności:</label>
                    <?php echo Funkcje::RozwijaneMenu('platnosc', $tablica, ''); ?>
                </p> 

                <p>
                  <label>Zapłacona:</label>
                  <input type="radio" value="1" name="rozliczona" id="rozliczona_tak" onclick="$('#data').slideUp()" /> <label class="OpisFor" for="rozliczona_tak">tak</label>
                  <input type="radio" value="0" name="rozliczona" id="rozliczona_nie" onclick="$('#data').slideDown()" checked="checked" /> <label class="OpisFor" for="rozliczona_nie">nie</label>
                </p> 

                <p id="data">
                    <label>Data płatności:</label>
                    <input type="text" name="data_platnosci" id="data_platnosci" size="20" value="<?php echo date('d-m-Y', time()); ?>" class="datepicker" />
                </p> 

              </div>

              <div class="RamkaFaktura">
              
                <table style="width:100%" id="items">
                
                  <tr class="div_naglowek NaglowekCentruj">
                      <td>Nazwa</td>
                      <td>PKWIU</td>
                      <td>j.m.</td>
                      <td>Ilość</td>
                      <td>Cena jedn. brutto</td>
                      <td>Cena jedn. netto</td>
                      <td>Wartość netto</td>
                      <td>Stawka VAT</td>
                      <td>Wartość VAT</td>
                      <td>Wartość brutto</td>
                  </tr>
                  
                  <?php

                  $podsumowanie_tablica['razem'] = array('razem_wartosc_brutto' => 0,
                                                         'razem_wartosc_netto' => 0,
                                                         'razem_wartosc_vat' => 0);
                                                         
                  for ( $x = 0, $cnt = count($stawki_tablica); $x < $cnt; $x++ ) {
                  
                    $podsumowanie_tablica[$stawki_tablica[$x]] = array('razem_wartosc_brutto' => 0,
                                                                       'razem_wartosc_netto' => 0,
                                                                       'razem_wartosc_vat' => 0);
                                                                       
                  }

                  $i = 1;
                  $lp = 1;
                  
                  $domyslna_jm = Funkcje::domyslnaJednostkaMiary();

                  foreach ( $zamowienie->produkty as $produkt ) {

                    $ilosc                = $produkt['ilosc'];
                    $cena_brutto          = $produkt['cena_koncowa_brutto'];
                    $cena_netto           = $produkt['cena_koncowa_netto'];
                    $vat                  = $produkt['tax'];
                    $vat_id               = $produkt['tax_id'];
                    $vat_info             = $produkt['tax_info'];                     
                    $wartosc_brutto       = $waluty->FormatujCeneBezSymbolu($cena_brutto * $ilosc);
                    $wartosc_vat          = $waluty->FormatujCeneBezSymbolu(($wartosc_brutto * ( $vat / ( 100 + $vat ) )) );
                    $wartosc_netto        = $waluty->FormatujCeneBezSymbolu($wartosc_brutto - $wartosc_vat);

                    $podsumowanie_tablica['razem'] = array('razem_wartosc_brutto' => $podsumowanie_tablica['razem']['razem_wartosc_brutto']+$wartosc_brutto);

                    for ( $x = 0, $cnt = count($stawki_tablica); $x < $cnt; $x++ ) {
                    
                      if ( $vat_id == substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1) ) {
                      
                        $podsumowanie_tablica[$stawki_tablica[$x]] = array('razem_wartosc_brutto' => $podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_brutto']+$wartosc_brutto);
                        
                      }
                        
                    }

                    $szczegoly = $produkt['nazwa']."\n";

                    $wyswietl_cechy = '';
                    $wartosc_netto_cechy = 0;
                    $wartosc_brutto_cechy = 0;
                    $wartosc_vat_cechy = 0;
                    $kombinacja_cechy_tablica = array();
                    $kombinacja_cechy = '';
                    
                    if (isset($produkt['attributes']) && (count($produkt['attributes']) > 0)) {
                    
                      foreach ($produkt['attributes'] as $cecha ) {
                      
                        $wartosc_netto_cechy = $wartosc_netto_cechy + $cecha['cena_netto'];
                        $wartosc_brutto_cechy = $wartosc_brutto_cechy + $cecha['cena_brutto'];
                        $wartosc_vat_cechy = $wartosc_vat_cechy + $cecha['podatek'];
                        $kombinacja_cechy_tablica[] = $cecha['id_cechy'] . '-' . $cecha['id_wartosci'];
                        if ( FAKTURA_NAZWA_CECHY == 'tak' ) {
                          $wyswietl_cechy .= '- ' . $cecha['cecha'] . ': ' . $cecha['wartosc'] . "\n";
                        }
                        
                      }
                      natsort($kombinacja_cechy_tablica);
                      $kombinacja_cechy = implode(',',$kombinacja_cechy_tablica);
                      
                    }

                    if ( FAKTURA_NAZWA_NUMER_KATALOGOWY == 'tak' ) {
                      if (trim($produkt['model']) != '') {
                        $szczegoly .= '- ' . $produkt['model']."\n";
                      }
                    }
                    
                    if ( FAKTURA_NAZWA_KOD_PRODUCENTA == 'tak' ) {
                      if (trim($produkt['kod_producenta']) != '') {
                        $szczegoly .= '- ' . $produkt['kod_producenta']."\n";
                      }
                    }                     

                    if ( FAKTURA_NAZWA_PRODUCENT == 'tak' ) {
                      if (trim($produkt['producent']) != '') {                        
                        $szczegoly .= '- ' . $produkt['producent']."\n";
                      }
                    }
                    // wyswietlenie cech produktu
                    if (!empty($wyswietl_cechy)) {                     
                      $szczegoly .= $wyswietl_cechy;
                    }
                    
                    // jezeli byla zapisana nazwa faktury
                    if ( trim($produkt['nazwa_faktura']) != '' ) {
                    
                        $szczegoly = $produkt['nazwa_faktura']."\n";

                    }                    

                    echo '<tr class="item-row FakturaEdycja">';
                    
                    echo '<td class="FakturaProdukt">
                          <input type="hidden" value="'.$lp.'" name="produkt['.$produkt['orders_products_id'].'][lp]" class="lp" />
                          <input type="hidden" value="'.$produkt['orders_products_id'].'" name="produkt['.$produkt['orders_products_id'].'][orders_products_id]" />
                          <input type="hidden" value="'.$wartosc_netto_cechy.'" name="produkt['.$produkt['orders_products_id'].'][cecha_cena_netto]" />
                          <input type="hidden" value="'.$wartosc_brutto_cechy.'" name="produkt['.$produkt['orders_products_id'].'][cecha_cena_brutto]" />
                          <input type="hidden" value="'.$wartosc_vat_cechy.'" name="produkt['.$produkt['orders_products_id'].'][cecha_podatek]" />';
                         if ( MAGAZYN_SPRAWDZ_STANY == 'tak' ) {
                            echo '<input type="hidden" value="'.$produkt['id_produktu'].'" name="produkt['.$produkt['orders_products_id'].'][products_id]" />';
                            echo '<input type="hidden" value="'.$ilosc.'" name="produkt['.$produkt['orders_products_id'].'][ilosc_org]" />';
                            if ( CECHY_MAGAZYN == 'tak' ) {
                                echo '<input type="hidden" value="'.$kombinacja_cechy.'" name="produkt['.$produkt['orders_products_id'].'][cechy_kombinacja]" />';
                            }
                         }
                    echo '<textarea cols="30" rows="3" name="produkt['.$produkt['orders_products_id'].'][nazwa]">'.trim($szczegoly).'</textarea></td>';
                    echo '<td class="FakturaProdukt"><input type="text" value="'.$produkt['pkwiu'].'" size="6" name="produkt['.$produkt['orders_products_id'].'][pkwiu]" class="pkwiu" style="text-align:right;" /></td>';
                    echo '<td class="FakturaProdukt">';
                    echo Funkcje::RozwijaneMenu('jm[]', $tablica_jm, ( $produkt['jm'] != '0' ? $produkt['jm'] : $domyslna_jm ) );
                    echo '</td>';
                    echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$ilosc.'" size="5" name="produkt['.$produkt['orders_products_id'].'][ilosc]" class="ilosc" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" /></td>';
                    echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$cena_brutto.'" size="6" name="produkt['.$produkt['orders_products_id'].'][cena_brutto]" class="cena_brutto" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" /></td>';
                    echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$cena_netto.'" size="6" name="produkt['.$produkt['orders_products_id'].'][cena_netto]" class="cena_netto" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" /></td>';
                    echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$wartosc_netto.'" size="8" name="produkt['.$produkt['orders_products_id'].'][wartosc_netto]" class="wartosc_netto readonly" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" readonly="readonly" /></td>';
                    echo '<td class="FakturaProdukt" style="text-align:right">';
                    
                    echo Funkcje::RozwijaneMenu('produkt['.$produkt['orders_products_id'].'][vat]', $tablica_vat, round($vat,0) . '|' . $vat_id, 'class="vat"');
                    
                    echo '</td>';
                    echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$wartosc_vat.'" size="10" name="produkt['.$produkt['orders_products_id'].'][wartosc_vat]" class="wartosc_vat readonly" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" readonly="readonly" /></td>';
                    echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$wartosc_brutto.'" size="10" name="produkt['.$produkt['orders_products_id'].'][wartosc_brutto]" class="wartosc_brutto readonly" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" readonly="readonly" /></td>';

                    echo '</tr>';
                    $i++;
                    $lp++;
                  }
                  
                  unset($domyslna_jm);

                  $dostawa_cena_brutto = 0;
                  $dostawa_cena_netto  = 0;
                  $dostawa_nazwa = 'Dostawa';

                  foreach ( $zamowienie->podsumowanie as $dodatki ) {

                    if ( $dodatki['klasa'] != 'ot_subtotal' && $dodatki['prefix'] != '9' && $dodatki['prefix'] != '0' ) {

                        $ilosc                = '1';
                        $cena_brutto          = $dodatki['wartosc'];
                        $vat                  = $dodatki['vat_stawka'];
                        $vat_id               = $dodatki['vat_id'];
                        $cena_netto           = $waluty->FormatujCeneBezSymbolu($dodatki['wartosc'] - ($dodatki['wartosc'] * ( $vat / ( 100 + $vat ) )));
                        $wartosc_brutto       = $waluty->FormatujCeneBezSymbolu($cena_brutto * $ilosc);
                        $wartosc_vat          = $waluty->FormatujCeneBezSymbolu($wartosc_brutto * ( $vat / ( 100 + $vat ) ));
                        $wartosc_netto        = $waluty->FormatujCeneBezSymbolu($wartosc_brutto - $wartosc_vat);

                        $podsumowanie_tablica['razem'] = array('razem_wartosc_brutto' => $podsumowanie_tablica['razem']['razem_wartosc_brutto']+$wartosc_brutto);
                                                        
                        for ( $x = 0, $cnt = count($stawki_tablica); $x < $cnt; $x++ ) {
                      
                            if ( $vat_id == substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1) ) {
                            
                                $podsumowanie_tablica[$stawki_tablica[$x]] = array('razem_wartosc_brutto' => $podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_brutto']+$wartosc_brutto);
                                
                            }
                        
                        }

                        if ($dodatki['klasa'] != 'ot_shipping' && $dodatki['klasa'] != 'ot_payment' ) {

                          echo '<tr class="item-row FakturaEdycja">';
                          echo '<td class="FakturaProdukt"><input type="hidden" value="'.$lp.'" name="podsuma['.$dodatki['orders_total_id'].'][lp]" class="lp" /><input type="hidden" value="'.$dodatki['orders_total_id'].'" name="podsuma['.$dodatki['orders_total_id'].'][orders_total_id]" />';
                          echo '<textarea cols="30" rows="3" name="podsuma['.$dodatki['orders_total_id'].'][nazwa]">'.$dodatki['tytul'].'</textarea></td>';
                          echo '<td class="FakturaProdukt"><input type="text" value="" size="6" name="podsuma['.$dodatki['orders_total_id'].'][pkwiu]" class="pkwiu readonly" style="text-align:right;" disabled="disabled" /></td>';
                          echo '<td class="FakturaProdukt">';
                          echo Funkcje::RozwijaneMenu('jm[]', $tablica_jm, '4', ' class="readonly" disabled="disabled"');
                          echo '</td>';
                          echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$ilosc.'" size="5" name="podsuma['.$dodatki['orders_total_id'].'][ilosc]" class="ilosc readonly" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" disabled="disabled" /></td>';
                          echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$cena_brutto.'" size="6" name="podsuma['.$dodatki['orders_total_id'].'][cena_brutto]" class="cena_brutto" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" /></td>';
                          echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$cena_netto.'" size="6" name="podsuma['.$dodatki['orders_total_id'].'][cena_netto]" class="cena_netto" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" /></td>';
                          echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$wartosc_netto.'" size="8" name="podsuma['.$dodatki['orders_total_id'].'][wartosc_netto]" class="wartosc_netto readonly" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" readonly="readonly" /></td>';
                          echo '<td class="FakturaProdukt" style="text-align:right">';

                          echo Funkcje::RozwijaneMenu('podsuma[' . $dodatki['orders_total_id'] . '][vat]', $tablica_vat, round($vat,0) . '|' . $vat_id, 'class="vat"');
                            
                          echo '</td>';
                          echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$wartosc_vat.'" size="10" name="podsuma['.$dodatki['orders_total_id'].'][wartosc_vat]" class="wartosc_vat readonly" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" readonly="readonly" /></td>';
                          echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$wartosc_brutto.'" size="10" name="podsuma['.$dodatki['orders_total_id'].'][wartosc_brutto]" class="wartosc_brutto readonly" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2)" readonly="readonly" /></td>';

                          echo '</tr>';
                          
                        } else {
                        
                          if ( $dodatki['klasa'] == 'ot_shipping' ) {
                               $dostawa_id = $dodatki['orders_total_id'];
                               $dostawa_nazwa = $dodatki['tytul'];
                               $dostawa_vat_id = $dodatki['vat_id'];
                               $dostawa_vat_stawka = $dodatki['vat_stawka'];  
                               // sama wartosc dostawy - bez platnosci
                               $dostawa_tylko_cena_brutto = $dodatki['wartosc'];                               
                          }
                          $dostawa_cena_brutto += $dodatki['wartosc'];
                        }
                        
                        $lp++;
                        
                    }
                    
                  }

                  if ( $dostawa_cena_brutto > 0 ) {
                  
                      $dostawa_cena_netto           = $waluty->FormatujCeneBezSymbolu($dostawa_cena_brutto - ($dostawa_cena_brutto * ( $dostawa_vat_stawka / ( 100 + $dostawa_vat_stawka ) )));
                      $dostawa_wartosc_brutto       = $waluty->FormatujCeneBezSymbolu($dostawa_cena_brutto * 1);
                      $dostawa_wartosc_vat          = $waluty->FormatujCeneBezSymbolu($dostawa_wartosc_brutto * ( $dostawa_vat_stawka / ( 100 + $dostawa_vat_stawka ) ));
                      $dostawa_wartosc_netto        = $waluty->FormatujCeneBezSymbolu($dostawa_wartosc_brutto - $dostawa_wartosc_vat);

                      echo '<tr class="item-row FakturaEdycja">';
                      echo '<td class="FakturaProdukt"><input type="hidden" value="'.$lp.'" name="podsuma['.$dostawa_id.'][lp]" class="lp" /><input type="hidden" value="'.$dostawa_id.'" name="podsuma['.$dostawa_id.'][orders_total_id]" />';
                      echo '<textarea cols="30" rows="3" name="podsuma['.$dostawa_id.'][nazwa]">'.$dostawa_nazwa.'</textarea></td>';
                      echo '<td class="FakturaProdukt"><input type="text" value="" size="6" name="podsuma['.$dostawa_id.'][pkwiu]" class="pkwiu readonly" style="text-align:right;" disabled="disabled" /></td>';
                      echo '<td class="FakturaProdukt">';
                      echo Funkcje::RozwijaneMenu('jm[]', $tablica_jm, '4', ' class="readonly" disabled="disabled"');
                      echo '</td>';
                      echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="1" size="5" name="podsuma['.$dostawa_id.'][ilosc]" class="ilosc readonly" style="text-align:right;" disabled="disabled" /></td>';
                      echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$waluty->FormatujCeneBezSymbolu($dostawa_cena_brutto).'" size="6" name="podsuma['.$dostawa_id.'][cena_brutto]" class="cena_brutto readonly" style="text-align:right;" disabled="disabled" /></td>';
                      echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$dostawa_cena_netto.'" size="6" name="podsuma['.$dostawa_id.'][cena_netto]" class="cena_netto readonly" style="text-align:right;" disabled="disabled" /></td>';
                      echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$dostawa_wartosc_netto.'" size="8" name="podsuma['.$dostawa_id.'][wartosc_netto]" class="wartosc_netto readonly" style="text-align:right;" disabled="disabled" /></td>';
                      echo '<td class="FakturaProdukt" style="text-align:right">';

                      echo Funkcje::RozwijaneMenu('podsuma['.$dostawa_id.'][vat]', $tablica_vat, round($dostawa_vat_stawka,0) . '|' . $dostawa_vat_id, ' class="vat readonly" disabled="disabled"');
                                
                      echo '</td>';
                      echo '<td class="FakturaProdukt" style="text-align:right"><input type="text" value="'.$dostawa_wartosc_vat.'" size="10" name="podsuma['.$dostawa_id.'][wartosc_vat]" class="wartosc_vat readonly" style="text-align:right;" disabled="disabled" /></td>';
                      echo '<td class="FakturaProdukt" style="text-align:right">
                                <input type="text" value="'.$dostawa_wartosc_brutto.'" size="10" name="podsuma['.$dostawa_id.'][wartosc_brutto]" class="wartosc_brutto readonly" style="text-align:right;" disabled="disabled" />
                                <input type="hidden" value="'.$dostawa_tylko_cena_brutto.'" name="podsuma['.$dostawa_id.'][wartosc_brutto]" />
                            </td>';

                      echo '</tr>';
                      
                      unset($dostawa_vat_id, $dostawa_vat_stawka);
                      
                  }

                  ?>
                  <tr id="razem" class="FakturaEdycja">
                      <td colspan="6"></td>
                      <td class="FakturaProdukt" style="text-align:center">RAZEM</td>
                      <td class="FakturaProdukt" style="text-align:center"></td>
                      <td class="FakturaProdukt" style="text-align:right"></td>
                      <td class="FakturaProdukt" style="text-align:right"></td>
                  </tr>

                  <?php
                  for ( $x = 0, $cnt = count($stawki_tablica); $x < $cnt; $x++ ) {
                  
                      $podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_vat'] = round($podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_brutto'] * ( substr($stawki_tablica[$x],0,strpos($stawki_tablica[$x], '|')) / ( 100 + substr($stawki_tablica[$x],0,strpos($stawki_tablica[$x], '|')) ) ),2);
                      $podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_netto'] = $podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_brutto'] - $podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_vat'];

                  ?>
                  
                  <tr id="razem<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" <?php echo ( $podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_netto'] == 0 ? 'style="display:none;"' : '' ); ?> class="FakturaEdycja">
                      <td colspan="6"></td>
                      <td class="FakturaProdukt" style="text-align:right"><input type="text" value="<?php echo $waluty->FormatujCeneBezSymbolu($podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_netto']); ?>" size="10" name="subtotal_netto_vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" id="subtotal_netto_vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" style="text-align:right;" class="readonly" disabled="disabled" /></td>
                      
                      <?php
                      $wyswietl_stawka = '';
                      foreach ( $tablica_vat as $stawka ) {
                          //
                          if ( $stawki_tablica[$x] == $stawka['id'] ) {
                               $wyswietl_stawka = $stawka['text'];
                          }
                          //
                      }
                      ?>
                      
                      <td class="FakturaProdukt" style="text-align:right"><input type="text" value="<?php echo $wyswietl_stawka; ?>" size="5" name="vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" id="vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" style="text-align:right;" /></td>
                      <td class="FakturaProdukt" style="text-align:right"><input type="text" value="<?php echo $waluty->FormatujCeneBezSymbolu($podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_vat']); ?>" size="10" name="subtotal_vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" id="subtotal_vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" style="text-align:right;" /></td>
                      <td class="FakturaProdukt" style="text-align:right"><input type="text" value="<?php echo $waluty->FormatujCeneBezSymbolu($podsumowanie_tablica[$stawki_tablica[$x]]['razem_wartosc_brutto']); ?>" size="10" name="subtotal_brutto_vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" id="subtotal_brutto_vat<?php echo substr($stawki_tablica[$x],strpos($stawki_tablica[$x], '|')+1); ?>" style="text-align:right;" /></td>
                      
                      <?php
                      unset($wyswietl_stawka);
                      ?>
                  </tr>
                  
                  <?php } ?>

                  <?php
                  $WartoscRabatu = 0;
                  
                  foreach ( $zamowienie->podsumowanie as $dodatki ) {

                      if ( $dodatki['prefix'] == '0' ) {

                          $vatDomyslny          = Funkcje::domyslnyPodatekVat();
                          $rabat_vat            = $vatDomyslny['stawka'];
                          unset($vatDomyslny);          
                          
                          $rabat_ilosc          = '1.00';
                          $rabat_cena_brutto    = $dodatki['wartosc'];
                          $rabat_cena_netto     = $waluty->FormatujCeneBezSymbolu($dodatki['wartosc'] - ($dodatki['wartosc'] * ( $rabat_vat / ( 100 + $rabat_vat ) )));
                          
                          $rabat_wartosc_brutto = $waluty->FormatujCeneBezSymbolu($rabat_cena_brutto * $rabat_ilosc);
                          $rabat_wartosc_vat    = $waluty->FormatujCeneBezSymbolu($rabat_wartosc_brutto * ( $rabat_vat / ( 100 + $rabat_vat ) ));
                          $rabat_wartosc_netto  = $waluty->FormatujCeneBezSymbolu($rabat_wartosc_brutto - $rabat_wartosc_vat);

                          $WartoscRabatu += $rabat_wartosc_brutto;

                          echo '<tr class="FakturaEdycja">
                            <td style="padding:4px;text-align:right" colspan="9">'.$dodatki['tytul'].'</td>
                            <td style="text-align:right;padding:4px;"><input type="text" name="'.$dodatki['klasa'].'" id="'.$dodatki['klasa'].'" value="'.$waluty->FormatujCeneBezSymbolu($rabat_wartosc_brutto).'" size="10" style="text-align:right;" onchange="this.value=roundLiczba(this.value,2);aktualizuj_calosc()" /></td></tr>';
                      }
                  }
                  
                  $kwotaDoZaplaty = $podsumowanie_tablica['razem']['razem_wartosc_brutto'] - $WartoscRabatu;

                  echo '<tr class="FakturaEdycja"><td style="padding:4px;text-align:right" colspan="9">Do zapłaty</td><td style="text-align:right;padding:4px;"><input type="text" value="'.$waluty->FormatujCeneBezSymbolu($kwotaDoZaplaty).'" size="10" style="text-align:right;" name="total_rabat_brutto" id="total_rabat_brutto" /></td></tr>';
                  ?>

                </table>
              </div>

              <span class="maleInfo">Koszt wysyłki jest sumą łączną kosztu wysyłki i płatności</span>

              <p>
                  <label style="padding-left:0px">Komentarz:</label>
                  <textarea cols="70" class="KomentarzFaktury" rows="5" name="komentarz" id="komentarz"><?php echo ( FAKTURA_KOMENTARZ_TEKST == 'tak' ? 'Zamówienie numer ' . $_GET['id_poz'] : ''); ?></textarea>
              </p> 
                
            </div>

            <div class="przyciski_dolne">
                <input type="submit" class="przyciskNon" value="Zapisz dane" />
                <button type="button" class="przyciskNon" onclick="cofnij('zamowienia_szczegoly','<?php echo Funkcje::Zwroc_Get(array('typ','x','y')); ?>','sprzedaz');">Powrót</button>           
            </div>
          </div>

        </form>

        <?php

      } else {

        echo '<div class="pozycja_edytowana">Brak danych do wyświetlenia</div>';

      }

      ?>

    </div>
    
    <?php
    include('stopka.inc.php');

}

?>