<?php
chdir('../');            

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

    if (isset($_POST['akcja']) && $_POST['akcja'] == 'zapisz') {

      $lista_kategorii = '';
      if ( $_POST['typ'] == '2' ) {
        $lista_kategorii = implode(',', $_POST['id_kat'] );
      }
      
      $lista_producentow = '';
      if ( $_POST['typ'] == '3' ) {
        $lista_producentow = implode(',', $_POST['id_producent'] );
      }      

      $lista_pol = '';
      if ( $_POST['format'] == '1' ) {
        if ( count($_POST['id_extra_field']) > 0 ) {
          foreach ( $_POST['id_extra_field'] as $val ) {
            if ( $_POST['desc_extra_field'][$val] != '' ) {
              $lista_pol .= $val . ':' . $filtr->process($_POST['desc_extra_field'][$val]) . ',';
            }
          }

        }
        $lista_pol = substr($lista_pol, 0, -1);
      }
      
      $lista_cech = '';
      if ( $_POST['format'] == '1' ) {
        if ( count($_POST['id_attributes']) > 0 ) {
          foreach ( $_POST['id_attributes'] as $val ) {
            if ( $_POST['desc_attributes'][$val] != '' ) {
              $lista_cech .= $val . ':' . $filtr->process($_POST['desc_attributes'][$val]) . ',';
            }
          }

        }
        $lista_cech = substr($lista_cech, 0, -1);
      }   

      $lista_rodzajow = '';
      if ( isset($_POST['rodzaj_produktu'])  ) {
        $lista_rodzajow = implode(',', $_POST['rodzaj_produktu'] );
      }

      $pola = array(
              array('comparisons_availability',$filtr->process($_POST['dostepnosc'])),
              array('comparisons_conditions',$filtr->process($_POST['stan'])),
              array('comparisons_products_type',$lista_rodzajow),
              array('comparisons_export_type',$filtr->process($_POST['typ'])),
              array('comparisons_export_quantity',$filtr->process($_POST['stan_magazynu'])),
              array('comparisons_categories',$lista_kategorii),
              array('comparisons_manufacturers',$lista_producentow),
              array('comparisons_extra_fields',$lista_pol),
              array('comparisons_attributes',$lista_cech),
              array('comparisons_name_info',(int)$_POST['dodatkowa_nazwa'])
      );

      $sql = $db->update_query('comparisons', $pola, " comparisons_id = '".(int)$_POST["id"]."'");	
      unset($pola);

      Funkcje::PrzekierowanieURL('porownywarki.php?id_poz='.(int)$_POST["id"]);

    }

    // wczytanie naglowka HTML
    include('naglowek.inc.php');
    ?>

    <div id="naglowek_cont">Konfiguracja parametrów eksportu dla porównywarek</div>
    <div id="cont">

      <form action="porownywarki/porownywarki_edytuj.php" method="post" id="porownywarkiForm" class="cmxform">
        <div class="poleForm">

            <?php
            
            if ( !isset($_GET['id_poz']) ) {
                 $_GET['id_poz'] = 0;
            } 

            $zapytanie = "SELECT * FROM comparisons WHERE comparisons_id = '".(int)$_GET['id_poz']."'";
            $sql = $db->open_query($zapytanie);
            
            if ( $db->ile_rekordow($sql) > 0 )  {
                
                $info = $sql->fetch_assoc();

                // fragment do mapowania kategorii dla Google Shopping
                if ( $info['comparisons_plugin'] == 'googleshopping' ) {

                    if ( $info['comparisons_conditions'] == '0' ) {
                        $info['comparisons_conditions'] = '1';
                    }

                    // adres pliku kaktegorii w serwisie Google
                    $DomyslnyJezykKod = strtolower($_SESSION['domyslny_jezyk']['kod']) . '-'. strtoupper($_SESSION['domyslny_jezyk']['kod']);

                    $url  = 'http://www.google.com/basepages/producttype/taxonomy.'.$DomyslnyJezykKod.'.txt';
                    // lokalny plik kategorii
                    $path = 'cache/taxonomy.'.$DomyslnyJezykKod.'.txt';

                    // pobiera date modyfikacji pliku z kategoriami
                    if (file_exists($path)) {
                        $dataPliku = filemtime($path);

                        // jezeli plik jest starszy niz 1 dzien, to pobiera nowy
                        if ( time() - $dataPliku > 3600 *24 ) { 

                            $blad = '';

                            $czyJestPlikZdalny= Funkcje::remoteFileExists($url);

                            if ($czyJestPlikZdalny) {
                                if (is_writeable($path)) {

                                    $fp = fopen($path, 'w');
                                     
                                    $ch = curl_init($url);
                                    curl_setopt($ch, CURLOPT_FILE, $fp);
                                     
                                    $data = curl_exec($ch);
                                     
                                    curl_close($ch);
                                    fclose($fp);
                                } else {
                                    $blad = 'brak praw do zapisu do pliku kategorii Google : ' . $path;
                                }
                            }
                        }

                    } else {

                        $blad = '';

                        $czyJestPlikZdalny= Funkcje::remoteFileExists($url);

                        if ($czyJestPlikZdalny) {

                            if (is_writeable('cache')) {

                                $fp = fopen($path, 'w');
                                     
                                $ch = curl_init($url);
                                curl_setopt($ch, CURLOPT_FILE, $fp);
                                     
                                $data = curl_exec($ch);
                                     
                                curl_close($ch);
                                fclose($fp);
                            } else {
                                    $blad = 'brak praw do zapisu do pliku kategorii Google : ' . $path;
                            }
                        }

                    }

                    unset($DomyslnyJezykKod);

                    // zapytanie sql wyciągające categorie i tworzace tablice
                    $zapytanie_kategorie = "
                          SELECT cd.categories_name, c.categories_id, c.parent_id, ga.categories_google 
                            FROM categories AS c
                            LEFT JOIN categories_description AS cd ON cd.categories_id=c.categories_id
                            LEFT JOIN google_categories ga ON ga.categories_id = c.categories_id
                            WHERE cd.language_id= '" . $_SESSION['domyslny_jezyk']['id'] . "'
                            ORDER BY c.sort_order";

                    $sql_kategorie = $db->open_query($zapytanie_kategorie);

                    while ($info_kategorie = $sql_kategorie->fetch_assoc()) {
                        $tablica_kategorii[$info_kategorie['categories_id']] = array ('id' => $info_kategorie['categories_id'], 'nadrzedna' => $info_kategorie['parent_id'], 'nazwa_kategorii' => $info_kategorie['categories_name'], 'kategoria_google' => $info_kategorie['categories_google']);
                    }

                    $db->close_query($sql_kategorie);
                    unset($zapytanie_kategorie, $info_kategorie);    

                    //przeksztalcenie tablicy kategorii na tablice z pokategoriami
                    $tree = Kategorie::kategorieNaDrzewo($tablica_kategorii);
                    unset($tablica_kategorii);    
                }

                $tablicaDostepnosci = array();
                $tablicaDostepnosci = Porownywarki::TablicaDostepnosciNiezdefiniowanych($info['comparisons_plugin']);
                if ( $info['comparisons_plugin'] == 'starcode' ) {
                    $tablicaDostepnosci = Porownywarki::TablicaDostepnosciNiezdefiniowanych('nokaut');
                }
                ?>
                
                <div class="naglowek">Edycja danych <?php echo $info['comparisons_name']; ?></div>

                <div class="pozycja_edytowana">
                
                  <div class="info_content">

                  <?php echo ( $blad != '' ? '<div class="ostrzezenie" style="margin:10px 0 10px 10px;">' . $blad .'</div>' : '' ); ?>

                  <input type="hidden" name="akcja" value="zapisz" />
                  <input type="hidden" name="id" value="<?php echo $filtr->process((int)$_GET['id_poz']); ?>" />

                  <?php
                  if ( count($tablicaDostepnosci) > 0 ) {
                      ?>
                      <p>
                        <label>Domyślna dostępność:</label>
                        <?php
                        echo Funkcje::RozwijaneMenu('dostepnosc', $tablicaDostepnosci, $info['comparisons_availability'], 'style="width:300px;"');
                        unset($tablicaDostepnosci);
                        ?><em class="TipIkona"><b>Dostępność produktu - jeżeli nie została zdefiniowana bezpośrednio dla towaru. Musi być zgodna ze specyfikacją porównywarki</b></em>
                      </p>
                      <?php
                  } else {
                    echo '<input type="hidden" name="dostepnosc" value="1" />';
                  }
                  ?>

                  <p>
                    <label>Domyślny stan produktu:</label>
                    <input type="radio" value="1" name="stan" id="stan_nowy" <?php echo (($info['comparisons_conditions'] == '1') ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="stan_nowy">nowy<em class="TipIkona"><b>Produkt jest nowy i fabrycznie zapakowany</b></em></label>
                    <input type="radio" value="2" name="stan" id="stan_uzywany" <?php echo (($info['comparisons_conditions'] == '2') ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="stan_uzywany">używany<em class="TipIkona"><b>Produkt był używany, nie ma fabrycznego opakowania,itp.</b></em></label>
                    <input type="radio" value="3" name="stan" id="stan_odnowiony" <?php echo (($info['comparisons_conditions'] == '3') ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="stan_odnowiony">odnowiony<em class="TipIkona"><b>Produkt był używany ale jest po regeneracji, np. cartridże do drukarek</b></em></label>
                  </p>

                  <p>
                    <label>Czy eksportować tylko produkty ze stanem więszym od 0:</label>
                    <input type="radio" value="0" name="stan_magazynu" id="export_nie" <?php echo ($info['comparisons_export_quantity'] == '0' ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="export_nie">nie<em class="TipIkona"><b>Eksportowane będą produkty niezależnie od ilości w magazynie</b></em></label>
                    <input type="radio" value="1" name="stan_magazynu" id="export_tak" <?php echo ($info['comparisons_export_quantity'] == '1' ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="export_tak">tak<em class="TipIkona"><b>Eksportowane będą tylko produkty, których stan magazynowy jest większy od 0</b></em></label>
                  </p>                   

                  <p>
                    <label>Czy przy eksporcie dodawać <b>Dodatkową nazwę</b> produktu:</label>
                    <input type="radio" value="0" name="dodatkowa_nazwa" id="dod_nazwa_nie" <?php echo ($info['comparisons_name_info'] == '0' ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="dod_nazwa_nie">nie<em class="TipIkona"><b>Dodatkowa nazwa produktu nie będzie dodawana</b></em></label>
                    <input type="radio" value="1" name="dodatkowa_nazwa" id="dod_nazwa_tak" <?php echo ($info['comparisons_name_info'] == '1' ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="dod_nazwa_tak">tak<em class="TipIkona"><b>Do nazw produktów będzie dodawana Dodatkowa nazwa produktu zdefiniowana podczas edycji produktu</b></em></label>
                  </p>  

                  <?php
                  $TablicaRodzajow = Produkty::TablicaRodzajProduktow();
                  ?>
                  <table class="WyborCheckbox">
                    <tr>
                        <td><label>Jakie rodzaje produktów eksportować:</label></td>
                        <td>
                            <?php                        
                            foreach ( $TablicaRodzajow as $Rodzaj ) {
                                echo '<input type="checkbox" value="' . $Rodzaj['id'] . '" name="rodzaj_produktu[]" id="rodzaj_produktu_' . $Rodzaj['id'] . '" ' . ((in_array($Rodzaj['id'], explode(',', $info['comparisons_products_type']))) ? 'checked="checked" ' : '') . ' /><label class="OpisFor" for="rodzaj_produktu_' . $Rodzaj['id'] . '">' . $Rodzaj['text'] . '</label><br />';
                            }              
                            ?>
                        </td>
                    </tr>
                    <tr><td></td><td><div class="maleInfo" style="marign-left:0px;">Jeżeli nie zostanie wybrany żaden rodzaj to będą eksportowane wszystkie produkty</div></td></tr>
                  </table>
                  

                  <script>
                  function typ_export(nr) {
                      if ( nr == 0 || nr == 1 ) {
                           $('#drzewo_kategorii').slideUp();
                           $('#drzewo').slideUp();
                      }
                      if ( nr == 2 ) {
                           $('#drzewo').slideUp( function() {
                              $('#drzewo_kategorii').slideDown();                       
                           });
                      }
                      if ( nr == 3 ) {
                           $('#drzewo_kategorii').slideUp( function() {
                              $('#drzewo').slideDown();                           
                           });
                      }                      
                  }
                  </script>

                  <div style="margin:3px 10px 4px 10px">
                  
                      <table>
                        <tr>
                            <td><label>Typ eksportu:</label></td>
                            <td style="padding:3px">
                                <input type="radio" value="0" name="typ" id="typ_wszystkie" onclick="typ_export(0)" <?php echo (($info['comparisons_export_type'] == '0') ? 'checked="checked"' : ''); ?> /> <label class="OpisFor" for="typ_wszystkie">wszystkie produkty<em class="TipIkona"><b>Typ eksportu - wszystkie produkty - eksport wszystkich produktów z bazy danych</b></em></label> <br />
                                <input type="radio" value="1" name="typ" id="typ_produkty" onclick="typ_export(1)" <?php echo (($info['comparisons_export_type'] == '1') ? 'checked="checked"' : ''); ?> /> <label class="OpisFor" for="typ_produkty">tylko zaznaczone produkty<em class="TipIkona"><b>Typ eksportu - tylko zaznaczone produkty - eksport produktów z zaznaczoną opcją Do porownywarek</b></em></label> <br />
                                <input type="radio" value="2" name="typ" id="typ_kategorie" onclick="typ_export(2)" <?php echo (($info['comparisons_export_type'] == '2') ? 'checked="checked"' : ''); ?> /> <label class="OpisFor" for="typ_kategorie">tylko zaznaczone kategorie<em class="TipIkona"><b>Typ eksportu - tylko zaznaczone kategorie - eksport produktów z wybranych kategorii</b></em></label> <br />
                                <input type="radio" value="3" name="typ" id="typ_producenci" onclick="typ_export(3)" <?php echo (($info['comparisons_export_type'] == '3') ? 'checked="checked"' : ''); ?> /> <label class="OpisFor" for="typ_producenci">tylko wybrani producenci<em class="TipIkona"><b>Typ eksportu - tylko wybrani producenci - eksport produktów z wybranych producentów</b></em></label> <br />
                            </td>
                        </tr>
                      </table> 
                      
                  </div>
                  
                  <div id="drzewo_kategorii" <?php echo ( $info['comparisons_export_type'] != '2' ? 'style="display:none;margin:10px;width:95%;max-width:650px"' : 'style="margin:10px;width:95%;max-width:650px"' ); ?> >
                  
                    <p class="NaglowekKategorie">Kategorie eksportowane do porównywarki</p>                           

                    <?php
                    $przypisane_kategorie = explode(',', $info['comparisons_categories']);
                    //
                    if ( count($przypisane_kategorie) > 10 && $info['comparisons_export_type'] == '2' ) {
                        //
                        echo '<ul id="drzewoKategorii">';
                        foreach(Kategorie::DrzewoKategoriiZarzadzanie() as $IdKategorii => $Tablica) {
                            //
                            echo Kategorie::WyswietlDrzewoKategoriiCheckbox($IdKategorii, $Tablica, $przypisane_kategorie);
                            //
                        }    
                        echo '</ul>';
                        //
                    } else {
                        //
                        echo '<table class="pkc">';
                        //
                        $tablica_kat = Kategorie::DrzewoKategorii('0', '', '', '', false, true);
                        for ($w = 0, $c = count($tablica_kat); $w < $c; $w++) {
                            $podkategorie = false;
                            if ($tablica_kat[$w]['podkategorie'] == 'true') { $podkategorie = true; }
                            //
                            $check = '';
                            if ( in_array($tablica_kat[$w]['id'], $przypisane_kategorie) ) {
                                $check = 'checked="checked"';
                            }
                            //  
                            echo '<tr>
                                    <td class="lfp"><input type="checkbox" value="'.$tablica_kat[$w]['id'].'" name="id_kat[]" id="kat_nr_'.$tablica_kat[$w]['id'].'" '.$check.' /> <label class="OpisFor" for="kat_nr_'.$tablica_kat[$w]['id'].'">'.$tablica_kat[$w]['text'].(($tablica_kat[$w]['status'] == 0) ? '<em class="TipChmurka"><b>Kategoria jest nieaktywna</b><span class="wylKat"></span></em>' : '').'</label></td>
                                    <td class="rgp" '.(($podkategorie) ? 'id="img_'.$tablica_kat[$w]['id'].'"' : '').'>'.(($podkategorie) ? '<img src="obrazki/rozwin.png" alt="Rozwiń" onclick="podkat(\''.$tablica_kat[$w]['id'].'\',\'\',\'checkbox\')" />' : '').'</td>
                                  </tr>
                                  '.(($podkategorie) ? '<tr><td colspan="2"><div id="p_'.$tablica_kat[$w]['id'].'"></div></td></tr>' : '').'';
                                  
                            unset($check);
                        }
                        echo '</table>';
                        unset($tablica_kat,$podkategorie);

                        if ( count($przypisane_kategorie) > 0 ) {

                          foreach ( $przypisane_kategorie as $val ) {
                              
                              $sciezka = Kategorie::SciezkaKategoriiId($val, 'categories');
                              $cSciezka = explode("_",$sciezka);                    
                              if (count($cSciezka) > 1) {
                                  //
                                  $ostatnie = strRpos($sciezka,'_');
                                  $analiza_sciezki = str_replace("_",",",substr($sciezka,0,$ostatnie));
                                  ?>
                                  
                                  <script>          
                                  podkat('<?php echo $analiza_sciezki; ?>', '<?php echo $cSciezka[count($cSciezka)-1]; ?>','checkbox','<?php echo $info['comparisons_categories']; ?>');
                                  </script>
                                  
                              <?php
                              unset($sciezka,$cSciezka);
                              }
                            
                          } 

                        }
                    }
                    unset($KategorieRabaty, $przypisani_producenci);
                    ?>
                  </div>
                  
                  <div id="drzewo" <?php echo ( $info['comparisons_export_type'] != '3' ? 'style="display:none;margin:10px;width:95%;max-width:650px"' : 'style="margin:10px;width:95%;max-width:650px"' ); ?> >

                      <p class="NaglowekKategorie">Producenci eksportowani do porównywarki</p>

                      <?php
                      $przypisani_producenci = explode(',', $info['comparisons_manufacturers']);
                      //
                      $tablica_prod = Funkcje::TablicaProducenci();
                      //
                      if (count($tablica_prod) > 0) {
                          //
                          echo '<table class="pkc">';
                          //
                          for ($b = 0, $c = count($tablica_prod); $b < $c; $b++) {
                              //
                              $check = '';
                              if ( in_array($tablica_prod[$b]['id'], $przypisani_producenci) ) {
                                  $check = 'checked="checked"';
                              }                              
                              //
                              echo '<tr>                                
                                      <td class="lfp">
                                          <input type="checkbox" value="'.$tablica_prod[$b]['id'].'" name="id_producent[]" id="id_producent_'.$tablica_prod[$b]['id'].'" ' . $check . ' /> <label class="OpisFor" for="id_producent_' . $tablica_prod[$b]['id'].'">' . $tablica_prod[$b]['text'] . '</label>
                                      </td>                                
                                    </tr>';
                                    
                              unset($chec);
                          }
                          echo '</table>';
                          //
                      }
                      unset($tablica_prod, $przypisani_producenci);
                      ?> 

                  </div>                    

                  <p>
                    <label>Format pliku:</label>
                    <input type="radio" value="0" name="format" id="format_standardowy" onclick="$('#pola').slideUp();$('#cechy').slideUp()" <?php echo ($info['comparisons_extra_fields'] == '' && $info['comparisons_attributes'] == '' ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="format_standardowy">standardowy<em class="TipIkona"><b>Format eksportowanego pliku - standardowy plik porównywarki</b></em></label>
                    <input type="radio" value="1" name="format" id="format_wlasny" onclick="$('#pola').slideDown();$('#cechy').slideDown()" <?php echo ($info['comparisons_extra_fields'] != '' || $info['comparisons_attributes'] != '' ? 'checked="checked"' : ''); ?> /><label class="OpisFor" for="format_wlasny">własny<em class="TipIkona"><b>Format eksportowanego pliku - uwzględnia dodatkowe pola i cechy do produktów</b></em></label>
                  </p> 

                  <div id="pola" class="DodatkowePola" <?php echo ( ($info['comparisons_extra_fields'] == '' && $info['comparisons_attributes'] == '') ? 'style="display:none;margin:10px;width:95%;max-width:650px"' : 'style="margin:10px;width:95%;max-width:650px"' ); ?> >
                  
                    <p class="NaglowekKategorie">Dodatkowe pola eksportowane do porównywarki</p>                           

                    <?php
                    $zapytanie_pola = "SELECT * FROM products_extra_fields ORDER BY products_extra_fields_order";
                    $sql_pola = $db->open_query($zapytanie_pola);
                    
                    if ( $db->ile_rekordow($sql_pola) > 0 )  {

                        $tablica_pol = array();
                        
                        if ( $info['comparisons_extra_fields'] != '' ) {
                          $dodatkowe_pola_tablica = explode(',', $info['comparisons_extra_fields']);
                          for ( $i = 0, $c = count($dodatkowe_pola_tablica); $i < $c; $i++ ) {
                            $podtablica = explode(':', $dodatkowe_pola_tablica[$i]);
                            $tablica_pol[$podtablica['0']] = $podtablica['1'];
                          }
                        }
                        
                        echo '<table class="pkc">';
                        
                        while ( $info_pola = $sql_pola->fetch_assoc() ) {
                          $check = '';
                          $wartosc = '';
                          if ( isset($tablica_pol[$info_pola['products_extra_fields_id']]) ) {
                            $check = 'checked="checked"';
                            $wartosc = $tablica_pol[$info_pola['products_extra_fields_id']];
                          }
                          echo '<tr>
                                  <td><input type="checkbox" value="'.$info_pola['products_extra_fields_id'].'" name="id_extra_field['.$info_pola['products_extra_fields_id'].']" id="pole_'.$info_pola['products_extra_fields_id'].'" '.$check.' /> <label class="OpisFor" for="pole_'.$info_pola['products_extra_fields_id'].'">'.$info_pola['products_extra_fields_name'].'</label></td><td style="text-align:right"><input type="text" name="desc_extra_field['.$info_pola['products_extra_fields_id'].']"  value="'.$wartosc.'" size="50" /><em class="TipIkona"><b>Nazwa pola w generowanym pliku XML - powinna być zgodna z dokumentacją integracji danej porównywarki.<br />W razie wątpliwości należy się zwrócić do obsługi serwisu porównywarki</b></em></td>
                                </tr>';
                        }
                        
                        echo '</table>';
                        
                    } else {
                      
                      echo '<div class="ostrzezenie" style="margin-left:15px">Nie ma zdefiniowanych dodatkowych pól do produktów - nie można dodać własnych pól do pliku XML</div>';
                      
                    }
                    $db->close_query($sql_pola);
                    unset($zapytanie_pola, $info_pola);

                    ?>
                  </div>
                  
                  <div id="cechy" class="DodatkowePola" <?php echo ( ($info['comparisons_extra_fields'] == '' && $info['comparisons_attributes'] == '') ? 'style="display:none;margin:10px;width:95%;max-width:650px"' : 'style="margin:10px;width:95%;max-width:650px"' ); ?> >
                  
                    <p class="NaglowekKategorie">Cechy produktów eksportowane do porównywarki</p>                           

                    <?php
                    $zapytanie_cechy = "SELECT * FROM products_options where language_id = '" . $_SESSION['domyslny_jezyk']['id'] . "' ORDER BY products_options_sort_order";
                    $sql_cechy = $db->open_query($zapytanie_cechy);
                    
                    if ( $db->ile_rekordow($sql_cechy) > 0 )  {

                        $tablica_cech = array();
                        
                        if ( $info['comparisons_attributes'] != '' ) {
                          $cechy_tablica = explode(',', $info['comparisons_attributes']);
                          for ( $i = 0, $c = count($cechy_tablica); $i < $c; $i++ ) {
                            $podtablica = explode(':', $cechy_tablica[$i]);
                            $tablica_cech[$podtablica['0']] = $podtablica['1'];
                          }
                        }
                        
                        echo '<table class="pkc">';
                        
                        while ( $info_cechy = $sql_cechy->fetch_assoc() ) {
                          $check = '';
                          $wartosc = '';
                          if ( isset($tablica_cech[$info_cechy['products_options_id']]) ) {
                            $check = 'checked="checked"';
                            $wartosc = $tablica_cech[$info_cechy['products_options_id']];
                          }
                          echo '<tr>
                                  <td><input type="checkbox" value="'.$info_cechy['products_options_id'].'" name="id_attributes['.$info_cechy['products_options_id'].']" id="cecha_'.$info_cechy['products_options_id'].'" '.$check.' /> <label class="OpisFor" for="cecha_'.$info_cechy['products_options_id'].'">'.$info_cechy['products_options_name'].'</label></td><td style="text-align:right"><input type="text" name="desc_attributes['.$info_cechy['products_options_id'].']"  value="'.$wartosc.'" size="50" /><em class="TipIkona"><b>Nazwa cechy w generowanym pliku XML - powinna być zgodna z dokumentacją integracji danej porównywarki.<br />W razie wątpliwości należy się zwrócić do obsługi serwisu porównywarki</b></em></td>
                                </tr>';
                        }
                        
                        echo '</table>';
                        
                    } else {
                      
                      echo '<div class="ostrzezenie" style="margin-left:15px">Nie ma zdefiniowanych cechy do produktów - nie można dodać własnych cech do pliku XML</div>';
                      
                    }
                    $db->close_query($sql_cechy);
                    unset($zapytanie_cechy, $info_cechy);

                    ?>
                  </div>                  
                  
                  <?php
                  // mapowanie kategorii Google Shopping
                  if ( $info['comparisons_plugin'] == 'googleshopping' ) {
                      ?>
                      <script>
                      function mapuj_kategorie(id_kategorii) {
                          $(function() {
                              var id = id_kategorii;
                              $.colorbox({
                                  title: "Przypisanie kategorii Google zakupy do kategorii sklepu",
                                  ajax:true,
                                  data: true,
                                  scrolling: false,
                                  overlayClose: false,
                                  initialWidth:50,
                                  initialHeight:50,
                                  href:"ajax/google_mapowanie_kategorii.php?id="+id,
                              });

                          });
                      }
                      function mapuj_kategorie_usun(id) {
                          var id = id;
                          $('#ekr_preloader').css('display','block');
                          $.post('ajax/google_zapisanie_kategorii.php', { akcja: "usun", id: id }, 
                              function(data) {}
                          );
                          $("#wartosc_" + id).html('');
                          $('#ekr_preloader').fadeOut();
                          $("#usun_" + id).hide();
                      }
                      </script>

                      <div style="padding:3px 10px 4px">

                        <div class="poleForm">

                            <div class="naglowek">
                                Kategorie sklepu -> Google shopping
                            </div>
                            
                            <div class="ostrzezenie" style="margin:10px">Żeby sklep wyeksportował dane do porównywarki MUSZĄ być powiązane kategorie sklepu z kategoriami porównywarki</div>

                            <div id="Mapowanie">
                                <?php
                                echo '<table>';
                                echo Porownywarki::TablicaNaWierszeGoogle($tree);
                                echo '</table>';
                                ?>
                            </div>

                        </div>
                      </div>

                      <?php
                  }
                  ?>

                  </div>

                </div>
                
                <div class="przyciski_dolne">
                    <input type="submit" class="przyciskNon" value="Zapisz dane" />
                    <button type="button" class="przyciskNon" onclick="cofnij('porownywarki','<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz')); ?>','porownywarki');">Powrót</button> 
                </div>            
            
            <?php 
            
            $db->close_query($sql);
            unset($zapytanie, $info);
                    
            } else {
            
                echo '<div class="naglowek">Edycja danych</div><div class="pozycja_edytowana">Brak danych do wyświetlenia</div>';
            
            }
            ?>
        </div>
      </form>
    </div>

    
    <?php
    include('stopka.inc.php');    
    
} 


?>
