<?php
chdir('../../');

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

if (isset($_POST['plugin']) && !empty($_POST['plugin']) && isset($_POST['offset']) && (int)$_POST['offset'] > -1 && Sesje::TokenSpr()) {

    $porownywarki = new Porownywarki($_POST['plugin'], $_POST['offset'], $_POST['limit']);

    if ( count($porownywarki->produkty) > 0 ) {

        $tablica_dostepnosci = Porownywarki::TablicaDostepnosci( $_POST['plugin'] );

        $CoDoZapisania = '';
        $DoZapisaniaXML = '';
        $plik = KATALOG_SKLEPU . 'xml/' . $filtr->process($_POST['plugin']) . '.xml';

        // uchwyt pliku, otwarcie do dopisania
        $fp = fopen($plik, "a");
        // blokada pliku do zapisu
        flock($fp, 2);

        //dane do zapisania do pliku START

        for ( $i = 0, $c = count($porownywarki->produkty); $i < $c; $i++ ) {

            $KategoriaProduktu = explode('/', $porownywarki->produkty[$i]['kategoria_produktu']);

            //Pobranie i sprawdzenie ustawienia dostepnosci produktu - specyficzne dla porownywarki
            $dostepnosc = $porownywarki->produkty[$i]['dostepnosc_produktu'];

            if ( $porownywarki->produkty[$i]['dostepnosc_produktu'] != '0' && $porownywarki->produkty[$i]['dostepnosc_produktu'] != '') {
                $dostepnosc = $tablica_dostepnosci[$porownywarki->produkty[$i]['dostepnosc_produktu']];
            } else {
                $dostepnosc = $porownywarki->dotepnosc_domyslna;
            }

            $DoZapisaniaXML .= "     <item>\n";
            $DoZapisaniaXML .= "     <compid>".$porownywarki->produkty[$i]['id_produktu']."</compid>\n";
            $DoZapisaniaXML .= "     <catpath><![CDATA[".$porownywarki->produkty[$i]['kategoria_produktu']."]]></catpath>\n";
            $DoZapisaniaXML .= "     <catname><![CDATA[".array_pop((array_slice($KategoriaProduktu, -1)))."]]></catname>\n";
            $DoZapisaniaXML .= "     <photo>".$porownywarki->produkty[$i]['zdjecie_produktu']."</photo>\n";

            // dodatkowe zdjecia
            if ( count($porownywarki->produkty[$i]['dodatkowe_zdjecia']) > 0 ) {
                 //
                 $DodatkoweZdjecia = $porownywarki->produkty[$i]['dodatkowe_zdjecia'];
                 //
                 foreach ( $DodatkoweZdjecia as $Zdjecie ) {
                    //
                    $DoZapisaniaXML .= "     <photo>".$Zdjecie."</photo>\n";
                    //
                 }
                 //
                 unset($DodatkoweZdjecia);
                 //
            }             

            $DoZapisaniaXML .= "     <url>".$porownywarki->produkty[$i]['url_produktu']."</url>\n";
            $DoZapisaniaXML .= "     <vendor>".Porownywarki::TekstZamienEncje($porownywarki->produkty[$i]['producent_produktu'])."</vendor>\n";
            $DoZapisaniaXML .= "     <name><![CDATA[".Porownywarki::TekstZamienEncje($porownywarki->produkty[$i]['nazwa_produktu'])."]]></name>\n";
            $DoZapisaniaXML .= "     <price>".$porownywarki->produkty[$i]['cena_brutto_produktu']."</price>\n";
            $DoZapisaniaXML .= "     <desclong><![CDATA[".Porownywarki::TekstZamienEncje($porownywarki->produkty[$i]['opis_produktu'])."]]></desclong>\n";
            $DoZapisaniaXML .= "     <ean>".Porownywarki::TekstZamienEncje($porownywarki->produkty[$i]['numer_ean_produktu'])."</ean>\n";
            $DoZapisaniaXML .= "     <partnr>".$porownywarki->produkty[$i]['numer_katalogowy_produktu']."</partnr>\n";
            $DoZapisaniaXML .= "     <availability>".$dostepnosc."</availability>\n";

            $DoZapisaniaXML .= "     </item>\n";

        }
        //dane do zapisania do pliku END

        // jezeli poczatek pliku
        if ((int)$_POST['offset'] == 0) {
            ///
            $CoDoZapisania    = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            $CoDoZapisania .= "<XMLDATA>\n";
            $CoDoZapisania   .= "<version>13.0</version>\n";
            $CoDoZapisania   .= "<time>".date('Y-m-d-H-i',time())."</time>\n";
            $CoDoZapisania   .= "<data>\n";

            $CoDoZapisania .= $DoZapisaniaXML;
            //
        } else {
            //
            $CoDoZapisania = $DoZapisaniaXML;
            //
        }
        //
        // koniec pliku
        if (isset($_POST['limit_max']) && (int)$_POST['limit_max'] <= (int)$_POST['offset'] + (int)$_POST['limit']) {
            $CoDoZapisania .= "</data>\n";
            $CoDoZapisania .= "</XMLDATA>\n";
        }
    }
 
    fwrite($fp, $CoDoZapisania);

    // zapisanie danych do pliku
    flock($fp, 3);
    // zamkniecie pliku
    fclose($fp);       

    unset($CoDoZapisania);    

}
echo 'OK';

?>