<?php
chdir('../../');

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

if (isset($_POST['plugin']) && !empty($_POST['plugin']) && isset($_POST['offset']) && (int)$_POST['offset'] > -1 && Sesje::TokenSpr()) {

    $porownywarki = new Porownywarki($_POST['plugin'], $_POST['offset'], $_POST['limit']);

    $tablica_stawek_podatku = $porownywarki->TablicaStawekPodatkowych();

    if ( count($porownywarki->produkty) > 0 ) {

        $CoDoZapisania = '';
        $DoZapisaniaXML = '';
        $plik = KATALOG_SKLEPU . 'xml/' . $filtr->process($_POST['plugin']) . '.xml';

        // uchwyt pliku, otwarcie do dopisania
        $fp = fopen($plik, "a");
        // blokada pliku do zapisu
        flock($fp, 2);

        //dane do zapisania do pliku START

        for ( $i = 0, $c = count($porownywarki->produkty); $i < $c; $i++ ) {
        
            $KategoriaProduktu = explode('/', $porownywarki->produkty[$i]['kategoria_produktu']);

            $waga = '';
            if ( $porownywarki->produkty[$i]['waga_produktu'] > 0 ) {
                $waga = number_format($porownywarki->produkty[$i]['waga_produktu'], 0, '.', ' ');
            }

            $DoZapisaniaXML .= "<product>\n";

            $DoZapisaniaXML .= "    <vendor_ext_id>".$porownywarki->produkty[$i]['id_produktu']."</vendor_ext_id>\n";
            $DoZapisaniaXML .= "    <category><![CDATA[".array_pop((array_slice($KategoriaProduktu, -1)))."]]></category>\n";
            $DoZapisaniaXML .= "    <name><![CDATA[".Porownywarki::TekstZamienEncje($porownywarki->produkty[$i]['nazwa_produktu'])."]]></name>\n";
            $DoZapisaniaXML .= "    <ean>".$porownywarki->produkty[$i]['numer_ean_produktu']."</ean>\n";
            $DoZapisaniaXML .= "    <part_number>".$porownywarki->produkty[$i]['numer_katalogowy_produktu']."</part_number>\n";
            $DoZapisaniaXML .= "    <brand><![CDATA[".$porownywarki->produkty[$i]['producent_produktu']."]]></brand>\n";
            $DoZapisaniaXML .= "    <main_image_url>".$porownywarki->produkty[$i]['zdjecie_produktu']."</main_image_url>\n";

            // dodatkowe zdjecia
            if ( count($porownywarki->produkty[$i]['dodatkowe_zdjecia']) > 0 ) {
                 //
                 $DodatkoweZdjecia = $porownywarki->produkty[$i]['dodatkowe_zdjecia'];
                 //
                 $licznik = 1;
                 foreach ( $DodatkoweZdjecia as $Zdjecie ) {
                    //
                    if ( $licznik < 6 ) {
                        $DoZapisaniaXML .= "     <images_url_".$licznik.">".$Zdjecie."</images_url_".$licznik.">\n";
                    }
                    //
                    $licznik++;
                 }
                 //
                 unset($DodatkoweZdjecia);
                 //
            }             
            $DoZapisaniaXML .= "    <url>".$porownywarki->produkty[$i]['url_produktu']."</url>\n";
            $DoZapisaniaXML .= "    <description><![CDATA[".$porownywarki->produkty[$i]['opis_produktu']."]]></description>\n";
            $DoZapisaniaXML .= "    <sale_price>".$porownywarki->produkty[$i]['cena_netto_produktu']."</sale_price>\n";
            $DoZapisaniaXML .= "    <vat_rate>".number_format($tablica_stawek_podatku[$porownywarki->produkty[$i]['stawka_podatku_id']]/100, 2, '.', ' ')."</vat_rate>\n";
            $DoZapisaniaXML .= "    <weight>".$waga."</weight>\n";
            $DoZapisaniaXML .= "    <stock>".number_format($porownywarki->produkty[$i]['ilosc_produktu'], 2, '.', ' ')."</stock>\n";

            // cechy produktu
            if ( count($porownywarki->produkty[$i]['cechy']) > 0 ) {

                foreach ( $porownywarki->produkty[$i]['cechy'] as $key => $value ) {
                    //
                    $wartosc_txt = array();
                    $wartosci = explode(',', $value[1]);
                    foreach ( $wartosci as $wartosc ) {
                        //
                        $wartosc_txt[] = Porownywarki::TekstZamienEncje(Funkcje::WartoscCechy($wartosc));
                        //
                    }
                    //
                    if ( count($wartosc_txt) > 0 ) {
                         $DoZapisaniaXML .= "    <property name=\"" . $key . "\">" . implode(';', $wartosc_txt) . "</property>\n";            
                    }            
                    //
                    unset($wartosc_txt, $wartosci);
                    //
                }
                //
            }

            // dodatkowe pola do produktu
            if ( count($porownywarki->produkty[$i]['pola']) > 0 ) {
                //
                foreach ( $porownywarki->produkty[$i]['pola'] as $key => $value ) {
                    //        
                    if ( !empty($value) ) {
                         $DoZapisaniaXML .= "    <property name=\"" . $key . "\">" . Porownywarki::TekstZamienEncje($value) . "</property>\n";
                    }
                    //
                }
                //
            }  


            $DoZapisaniaXML .= "</product>\n";

        }
        //dane do zapisania do pliku END

        // jezeli poczatek pliku
        if ((int)$_POST['offset'] == 0) {
            ///
            $CoDoZapisania = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
            $CoDoZapisania .= "<shop>\n";

            $CoDoZapisania .= $DoZapisaniaXML;
            //
        } else {
            //
            $CoDoZapisania = $DoZapisaniaXML;
            //
        }
        //
        // koniec pliku
        if (isset($_POST['limit_max']) && (int)$_POST['limit_max'] <= (int)$_POST['offset'] + (int)$_POST['limit']) {
            $CoDoZapisania .= "</shop>";
        }
    }
 
    fwrite($fp, $CoDoZapisania);

    // zapisanie danych do pliku
    flock($fp, 3);
    // zamkniecie pliku
    fclose($fp); 

    unset($CoDoZapisania);    

}
echo 'OK';

?>