<?php
chdir('../');            

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

    $wynik  = '';
    $system = ( isset($_POST['system']) ? $_POST['system'] : '' );

    if (isset($_POST['akcja']) && $_POST['akcja'] == 'zapisz') {

      reset($_POST);
      while (list($key, $value) = each($_POST)) {
        if ( $key != 'akcja' ) {
          $pola = array(
                  array('value',$filtr->process($value))
          );
          $db->update_query('settings' , $pola, " code = '".strtoupper($key)."'");	
          unset($pola);
        }
      }

      $wynik = '<div id="'.$system.'" class="maleSukces" style="margin-left:20px;margin-top:10px;">dane zostały zmienione</div>';

    }

    $zapytanie = "SELECT * FROM settings WHERE type = 'afiliacja' ORDER BY sort ";
    $sql = $db->open_query($zapytanie);

    $parametr = array();

    if ( $db->ile_rekordow($sql) > 0 ) {
      while ($info = $sql->fetch_assoc()) {
        $parametr[$info['code']] = array($info['value'], $info['limit_values'], $info['description'], $info['form_field_type']);
      }
    }
    $db->close_query($sql);
    unset($zapytanie, $info);

    // wczytanie naglowka HTML
    include('naglowek.inc.php');
    ?>

    <div id="naglowek_cont">Konfiguracja parametrów systemów afiliacyjnych</div>
    <div id="cont">

      <div class="poleForm">
        <div class="naglowek">Edycja danych</div>

        <div class="pozycja_edytowana">  

          <script>
          $(document).ready(function() {
            $("#webepartnersForm").validate({
              rules: {
                integracja_webepartners_mid: {required: function() {var wynik = true; if ( $("input[name='integracja_webepartners_zamowienia_wlaczony']:checked", "#webepartnersForm").val() == "nie" ) { wynik = false; } return wynik; }}
              }
            });
            
            $("#fblogowanieForm").validate({
              rules: {
                integracja_fb_logowanie_identyfikator: {required: function() {var wynik = true; if ( $("input[name='integracja_fb_logowanie_wlaczony']:checked", "#fblogowanieForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_fb_logowanie_secret: {required: function() {var wynik = true; if ( $("input[name='integracja_fb_logowanie_wlaczony']:checked", "#fblogowanieForm").val() == "nie" ) { wynik = false; } return wynik; }}
              }
            });            
            
            $("#freshmailForm").validate({
              rules: {
                integracja_freshmail_key: {required: function() {var wynik = true; if ( $("input[name='integracja_freshmail_wlaczony']:checked", "#freshmailForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_freshmail_sekret: {required: function() {var wynik = true; if ( $("input[name='integracja_freshmail_wlaczony']:checked", "#freshmailForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_domyslna_lista: {required: function() {var wynik = true; if ( $("input[name='integracja_freshmail_wlaczony']:checked", "#freshmailForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_freshmail_produkty_prefix: {required: function() {var wynik = true; if ( $("input[name='integracja_freshmail_wlaczony_produkty']:checked", "#freshmailForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_freshmail_kupujacy_prefix: {required: function() {var wynik = true; if ( $("input[name='integracja_freshmail_wlaczony_kupujacy']:checked", "#freshmailForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_freshmail_rejestracja_prefix: {required: function() {var wynik = true; if ( $("input[name='integracja_freshmail_wlaczony_rejestracja']:checked", "#freshmailForm").val() == "nie" ) { wynik = false; } return wynik; }}
              }
            });  
            
            $("#getallForm").validate({
              rules: {
                integracja_getall_apikey: {required: function() {var wynik = true; if ( $("input[name='integracja_getall_wlaczony']:checked", "#getallForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_getall_domyslna_lista: {required: function() {var wynik = true; if ( $("input[name='integracja_getall_wlaczony']:checked", "#getallForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_getall_produkty_prefix: {required: function() {var wynik = true; if ( $("input[name='integracja_getall_wlaczony_produkty']:checked", "#getallForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_getall_kupujacy_prefix: {required: function() {var wynik = true; if ( $("input[name='integracja_getall_wlaczony_kupujacy']:checked", "#getallForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_getall_rejestracja_prefix: {required: function() {var wynik = true; if ( $("input[name='integracja_getall_wlaczony_rejestracja']:checked", "#getallForm").val() == "nie" ) { wynik = false; } return wynik; }}
              }
            });             

            $("#klikochronForm").validate({
              rules: {
                integracja_klikochron_partnerid: {required: function() {var wynik = true; if ( $("input[name='integracja_klikochron_wlaczony']:checked", "#klikochronForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_klikochron_shopid: {required: function() {var wynik = true; if ( $("input[name='integracja_fb_logowanie_wlaczony']:checked", "#klikochronForm").val() == "nie" ) { wynik = false; } return wynik; }}
              }
            });               
            
            $("#trustedshopsForm").validate({
              rules: {
                integracja_trustedshops_partnerid: {required: function() {var wynik = true; if ( $("input[name='integracja_trustedshops_wlaczony']:checked", "#trustedshopsForm").val() == "nie" ) { wynik = false; } return wynik; }},
                integracja_trustedshops_przesuniecie: { 
                    range: [0, 250],
                    number: true
                }
              }
            });               

            <?php if ( $system != '' ) { ?>
            
            $.scrollTo('#<?php echo $system; ?>Form',400);

            setTimeout(function() {
              $('#<?php echo $system; ?>').fadeOut();
            }, 3000);
            
            <?php } ?>
          });
          </script> 

          <!-- Portale spolecznosciowe na karcie produktu -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="podzielForm" class="cmxform">
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="podziel" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Podziel się na karcie produktu - ikonki z odnośnikami do portali społecznościowych</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Dzięki wtyczce umieścisz na swojej stronie internetowej odnośniki, prosto z której użytkownicy będą mogli podzielić się linkiem do produktu.</div>
                      <img src="obrazki/logo/logo_podziel_sie.png" alt="" />
                    </td></tr>                  
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz moduł "Podziel się":</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_PODZIEL_SIE_WLACZONY']['1'], $parametr['INTEGRACJA_PODZIEL_SIE_WLACZONY']['0'], 'integracja_podziel_sie_wlaczony', $parametr['INTEGRACJA_PODZIEL_SIE_WLACZONY']['2'], '', $parametr['INTEGRACJA_PODZIEL_SIE_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>

                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'podziel' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                  </table>

              </div>
            </form>
            
          </div>          
          
          
          <!-- Facebook - logowanie -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="fblogowanieForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="fblogowanie" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Facebook - logowanie do sklepu poprzez konto Facebook</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Dzięki tej funkcji klienci będą mogli połączyć swoje konto w sklepie z kontem na Facebook i logować się do sklepu bez podawania loginu i hasła do sklepu (wystarczy samo zalogowanie się do Facebook).</div>
                      <img src="obrazki/logo/logo_lubie_to.png" alt="" />
                    </td></tr>                   
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz logowanie poprzez Facebook:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_LOGOWANIE_WLACZONY']['1'], $parametr['INTEGRACJA_FB_LOGOWANIE_WLACZONY']['0'], 'integracja_fb_logowanie_wlaczony', $parametr['INTEGRACJA_FB_LOGOWANIE_WLACZONY']['2'], '', $parametr['INTEGRACJA_FB_LOGOWANIE_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_fb_logowanie_identyfikator">Identyfikator aplikacji Facebook:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_fb_logowanie_identyfikator" id="integracja_fb_logowanie_identyfikator" value="'.$parametr['INTEGRACJA_FB_LOGOWANIE_IDENTYFIKATOR']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_FB_LOGOWANIE_IDENTYFIKATOR']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_fb_logowanie_secret">Numer App Secret:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_fb_logowanie_secret" id="integracja_fb_logowanie_secret" value="'.$parametr['INTEGRACJA_FB_LOGOWANIE_SECRET']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_FB_LOGOWANIE_SECRET']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>                    
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'fblogowanie' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                    
                  </table>

              </div>
            </form>
          </div>          


          <!-- Przycisk FB "Lubie to" na karcie produktu -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="facebookForm" class="cmxform">
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="facebook" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Facebook - Lubię to na karcie produktu</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Przycisk „Lubię to” pozwala użytkownikowi podzielić się zawartością sklepu internetowego (produktami) z jego przyjaciółmi na Facebooku. Kiedy użytkownik klika na przycisk „Lubię to”, to w aktualnościach jego przyjaciół pojawia się wątek z odnośnikiem do danego produktu w sklepie internetowym.</div>
                      <img src="obrazki/logo/logo_lubie_to.png" alt="" />
                    </td></tr>                  
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz przycisk "Lubię to":</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_LUBIETO_WLACZONY']['1'], $parametr['INTEGRACJA_FB_LUBIETO_WLACZONY']['0'], 'integracja_fb_lubieto_wlaczony', $parametr['INTEGRACJA_FB_LUBIETO_WLACZONY']['2'], '', $parametr['INTEGRACJA_FB_LUBIETO_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_fb_lubieto_styl">Format przycisku:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_LUBIETO_STYL']['1'], $parametr['INTEGRACJA_FB_LUBIETO_STYL']['0'], 'integracja_fb_lubieto_styl', $parametr['INTEGRACJA_FB_LUBIETO_STYL']['2'], '', $parametr['INTEGRACJA_FB_LUBIETO_STYL']['3'], '', '', 'id="integracja_fb_lubieto_styl"' );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Schemat kolorów:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_LUBIETO_KOLOR']['1'], $parametr['INTEGRACJA_FB_LUBIETO_KOLOR']['0'], 'integracja_fb_lubieto_kolor', $parametr['INTEGRACJA_FB_LUBIETO_KOLOR']['2'], '', $parametr['INTEGRACJA_FB_LUBIETO_KOLOR']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'facebook' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                  </table>

              </div>
            </form>
            
          </div>
          

          <!-- Przycisk FB "Wyslij" na karcie produktu -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="wyslijForm" class="cmxform">
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="wyslij" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Facebook - przycisk Wyślij na karcie produktu</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Przycisk ten umożliwia użytkownikom w łatwy sposób przesłać odnośnik do danej strony swoim znajomym. Istnieje również możliwość wpisania adresu e-mail do konkretnej osoby, a wiadomość do niej zostanie automatycznie wysłana. Wiadomość będzie zawierać link do adresu URL określonego w przycisku „Wyślij”, wraz z tytułem, obrazkiem i krótkim opisem linku.</div>
                      <img src="obrazki/logo/fb_wyslij.png" alt="" />
                    </td></tr>                  
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz przycisk "Wyślij":</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_WYSLIJ_WLACZONY']['1'], $parametr['INTEGRACJA_FB_WYSLIJ_WLACZONY']['0'], 'integracja_fb_wyslij_wlaczony', $parametr['INTEGRACJA_FB_WYSLIJ_WLACZONY']['2'], '', $parametr['INTEGRACJA_FB_WYSLIJ_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Schemat kolorów:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_WYSLIJ_KOLOR']['1'], $parametr['INTEGRACJA_FB_WYSLIJ_KOLOR']['0'], 'integracja_fb_wyslij_kolor', $parametr['INTEGRACJA_FB_WYSLIJ_KOLOR']['2'], '', $parametr['INTEGRACJA_FB_WYSLIJ_KOLOR']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'wyslij' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                  </table>

              </div>
            </form>
            
          </div>          
          
          
          <!-- recenzje FB na karcie produktu -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="facebookOpinieForm" class="cmxform">
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="facebookOpinie" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Facebook - komentarze (opinie) na karcie produktu</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Wtyczka Komentarze Facebook pozwala opiniować klientom za pomocą swojego profilu na Facebooku produkty oferowane w sklepie. <br /><br />
                      <span class="ostrzezenie">Wtyczka jest powiązana z recenzjami sklepu. Wtyczka jest wyświetlana w zakładce Recenzje na karcie produktu.
                      Aby wtyczka była aktywna muszą być w sklepie włączone recenzje produktu (menu Konfiguracja / Konfiguracja sklepu / Ustawienia produktów).</span>
                      </div>
                      <img src="obrazki/logo/logo_komentarze.png" alt="" />
                    </td></tr>                  
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz Komentarze Facebook:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_OPINIE_WLACZONY']['1'], $parametr['INTEGRACJA_FB_OPINIE_WLACZONY']['0'], 'integracja_fb_opinie_wlaczony', $parametr['INTEGRACJA_FB_OPINIE_WLACZONY']['2'], '', $parametr['INTEGRACJA_FB_OPINIE_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_fb_opinie_szerokosc">Szerokość pola komentarzy:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_OPINIE_SZEROKOSC']['1'], $parametr['INTEGRACJA_FB_OPINIE_SZEROKOSC']['0'], 'integracja_fb_opinie_szerokosc', $parametr['INTEGRACJA_FB_OPINIE_SZEROKOSC']['2'], '', $parametr['INTEGRACJA_FB_OPINIE_SZEROKOSC']['3'], 5, '', 'id="integracja_fb_opinie_szerokosc"' );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_fb_opinie_ilosc_postow">Ilość wyświetlanych komentarzy:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_OPINIE_ILOSC_POSTOW']['1'], $parametr['INTEGRACJA_FB_OPINIE_ILOSC_POSTOW']['0'], 'integracja_fb_opinie_ilosc_postow', $parametr['INTEGRACJA_FB_OPINIE_ILOSC_POSTOW']['2'], '', $parametr['INTEGRACJA_FB_OPINIE_ILOSC_POSTOW']['3'], '', '', 'id="integracja_fb_opinie_ilosc_postow"' );
                        ?>
                      </td>
                    </tr>                    
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Schemat kolorów:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FB_OPINIE_KOLOR']['1'], $parametr['INTEGRACJA_FB_OPINIE_KOLOR']['0'], 'integracja_fb_opinie_kolor', $parametr['INTEGRACJA_FB_OPINIE_KOLOR']['2'], '', $parametr['INTEGRACJA_FB_OPINIE_KOLOR']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'facebookOpinie' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                  </table>

              </div>
            </form>
            
          </div>          
          
          
          <!-- Przycisk Nasza klasa na karcie produktu -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="nkForm" class="cmxform">
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="nk" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Nasza klasa - Fajne na karcie produktu</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Dodanie na Twoją stronę widżetu "Fajne!" pozwala użytkownikom NK przyznawać gwiazdki materiałom, które zamieszczasz na tej stronie. Jeśli ktoś wyróżni gwiazdką daną informację, powiadomienie o tym pojawi się na NK, co sprawi, że kolejne osoby będą mogły zainteresować się Twoją publikacją.</div>
                      <img src="obrazki/logo/logo_nk.png" alt="" />
                    </td></tr>                  
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz przycisk "Fajne!":</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_NK_FAJNE_WLACZONY']['1'], $parametr['INTEGRACJA_NK_FAJNE_WLACZONY']['0'], 'integracja_nk_fajne_wlaczony', $parametr['INTEGRACJA_NK_FAJNE_WLACZONY']['2'], '', $parametr['INTEGRACJA_NK_FAJNE_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_nk_fajne_styl">Format przycisku:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_NK_FAJNE_STYL']['1'], $parametr['INTEGRACJA_NK_FAJNE_STYL']['0'], 'integracja_nk_fajne_styl', $parametr['INTEGRACJA_NK_FAJNE_STYL']['2'], '', $parametr['INTEGRACJA_NK_FAJNE_STYL']['3'], '', '', 'id="integracja_nk_fajne_styl"' );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Schemat kolorów:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_NK_FAJNE_KOLOR']['1'], $parametr['INTEGRACJA_NK_FAJNE_KOLOR']['0'], 'integracja_nk_fajne_kolor', $parametr['INTEGRACJA_NK_FAJNE_KOLOR']['2'], '', $parametr['INTEGRACJA_NK_FAJNE_KOLOR']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'nk' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                  </table>

              </div>
            </form>
            
          </div>          


          <!-- Przycisk Google +1 na karcie produktu -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="plusoneForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="plusone" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">GOOGLE - +1 na karcie produktu</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Przycisk +1 ułatwia użytkownikom znalezienie odpowiednich treści – witryn, wyników wyszukiwania Google albo reklam – dzięki opiniom osób, które znają i którym ufają. Przycisk +1 jest widoczny w wyszukiwarce Google, w witrynach oraz reklamach. Może się on na przykład znaleźć obok wyniku wyszukiwania w witrynie Google, reklamy Google lub artykułu w Twojej ulubionej witrynie informacyjnej.</div>
                      <img src="obrazki/logo/logo_plusone.png" alt="" />
                    </td></tr> 

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz przycisk PlusOne:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_PLUSONE_WLACZONY']['1'], $parametr['INTEGRACJA_PLUSONE_WLACZONY']['0'], 'integracja_plusone_wlaczony', $parametr['INTEGRACJA_PLUSONE_WLACZONY']['2'], '', $parametr['INTEGRACJA_PLUSONE_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_plusone_rozmiar">Rozmiar przycisku:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_PLUSONE_ROZMIAR']['1'], $parametr['INTEGRACJA_PLUSONE_ROZMIAR']['0'], 'integracja_plusone_rozmiar', $parametr['INTEGRACJA_PLUSONE_ROZMIAR']['2'], '', $parametr['INTEGRACJA_PLUSONE_ROZMIAR']['3'], '', '', 'id="integracja_plusone_rozmiar"' );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_plusone_adnotacja">Wyświetlanie opisu:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_PLUSONE_ADNOTACJA']['1'], $parametr['INTEGRACJA_PLUSONE_ADNOTACJA']['0'], 'integracja_plusone_adnotacja', $parametr['INTEGRACJA_PLUSONE_ADNOTACJA']['2'], '', $parametr['INTEGRACJA_PLUSONE_ADNOTACJA']['3'], '', '', 'id="integracja_plusone_adnotacja"' );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_plusone_szerokosc">Szerokość wraz z opisem:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_plusone_szerokosc" id="integracja_plusone_szerokosc" value="'.$parametr['INTEGRACJA_PLUSONE_SZEROKOSC']['0'].'" size="20" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_PLUSONE_SZEROKOSC']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'plusone' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                  </table>
                  
              </div>

            </form>
            
          </div>

          
          <!-- System afiliacyjny WebePartners -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="webepartnersForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="webepartners" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Program afiliacyjny WebePartners</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Sieć WebePartners specjalizuje się w profesjonalnej obsłudze programów partnerskich sklepów internetowych. Rozlicza kampanie marketingowe w efektywnościowym modelu współpracy Cost Per Sale. Poprzez sieć wydawców zwiększa sprzedaż w sklepach internetowych w zamian za prowizję od sprzedaży.</div>
                      <img src="obrazki/logo/logo_webepartners.png" alt="" />
                    </td></tr>                   
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Śledzenie zamówień:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_WEBEPARTNERS_ZAMOWIENIA_WLACZONY']['1'], $parametr['INTEGRACJA_WEBEPARTNERS_ZAMOWIENIA_WLACZONY']['0'], 'integracja_webepartners_zamowienia_wlaczony', $parametr['INTEGRACJA_WEBEPARTNERS_ZAMOWIENIA_WLACZONY']['2'], '', $parametr['INTEGRACJA_WEBEPARTNERS_ZAMOWIENIA_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_webepartners_mid">Identyfikator sprzedawcy (MID):</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_webepartners_mid" id="integracja_webepartners_mid" value="'.$parametr['INTEGRACJA_WEBEPARTNERS_MID']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_WEBEPARTNERS_MID']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'webepartners' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                    
                  </table>

              </div>
            </form>
          </div>
          
          
          <!-- System afiliacyjny cash4free Openrate -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="openrateForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="openrate" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Program afiliacyjny cas4free Openrate</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Program prowadzony jest przez OpenRate poprzez serwis internetowy pod adresem www.cash4free.pl, w którym OpenRate zamieści aktywne linki do stron sklepów internetowych Partnerów wraz ze wskazaniem wartości Cashback określonej kwotowo lub procentowo.</div>
                      <img src="obrazki/logo/logo_openrate.png" alt="" />
                    </td></tr>                   
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz integrację:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_OPENRATE_WLACZONY']['1'], $parametr['INTEGRACJA_OPENRATE_WLACZONY']['0'], 'integracja_openrate_wlaczony', $parametr['INTEGRACJA_OPENRATE_WLACZONY']['2'], '', $parametr['INTEGRACJA_OPENRATE_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'openrate' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                    
                  </table>

              </div>
            </form>
          </div>
          
          
          <!-- Integracja z FreshMail -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="freshmailForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="freshmail" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">FreshMail email marketing to intuicyjny program do wysyłania newsletterów, mailingów i autoresponderów.</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>FreshMail to nowoczesne narzędzie do tworzenia oraz wysyłki newsletterów i mailingów do własnej bazy klientów. Pozwala w pełni zautomatyzować budowanie listy odbiorców oraz wysyłkę newsletterów. Wystarczy skorzystać z jeden z dziesiątek szablonów, uzupełnić go własną treścią i już można pozyskać nowych klientów na swoje produkty i usługi. Wysyłaj newslettery i informuj swoich klientów o nowościach oraz ofertach specjalnych.</div>                      
                      <img src="obrazki/logo/logo_freshmail.png" alt="" />
                      <span class="maleSukces" style="margin:0px 10px 15px 10px">Integracja sklepu z FreshMail pozwala na automatyzację przenoszenia adresów email ze sklepu do FreshMail. Klient zapisując się w sklepie do newslettera jest również automatycznie dodawany do listy odbiorców w systemie FreshMail. </span>
                    </td></tr>                   
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz integrację:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FRESHMAIL_WLACZONY']['1'], $parametr['INTEGRACJA_FRESHMAIL_WLACZONY']['0'], 'integracja_freshmail_wlaczony', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY']['2'], '', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_freshmail_key">Klucz API:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_freshmail_key" id="integracja_freshmail_key" value="'.$parametr['INTEGRACJA_FRESHMAIL_KEY']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_FRESHMAIL_KEY']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>                    
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_freshmail_sekret">Klucz API sekret:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_freshmail_sekret" id="integracja_freshmail_sekret" value="'.$parametr['INTEGRACJA_FRESHMAIL_SEKRET']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_FRESHMAIL_SEKRET']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>  
                    
                    <tr>
                      <td colspan="2" class="NaglowekAfiliacja">
                        <strong>Automatyczna subskrypcja wszystkich klientów którzy wyrazili zgodę na otrzymywanie newslettera</strong>
                        <span class="maleInfo">
                            Funkcja ułatwiająca tworzenie list mailingowych klientów, którzy wyrazili zgodę na otrzymywanie newslettera. Po zapisaniu się klienta do newslettera (poprzez box, przy rejestracji czy module newslettera) jego adres email 
                            jest dodawany do domyślnej (zdefiniowanej poniżej) listy odbiorców. Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona.
                        </span>
                      </td>
                    </tr>                     
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_domyslna_lista">Domyślna lista odbiorców:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_domyslna_lista" id="integracja_domyslna_lista" value="'.$parametr['INTEGRACJA_DOMYSLNA_LISTA']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_DOMYSLNA_LISTA']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>          

                    <tr>
                      <td colspan="2" class="NaglowekAfiliacja">
                        <strong>Dodatkowa lista odbiorców dla klientów przy rejestracji konta</strong>
                        <span class="maleInfo">
                            Funkcja ułatwiająca tworzenie list mailingowych klientów, którzy dokonali rejestracji konta w sklepie. Dzięki temu można wysłać maile tylko do klientów, którzy założyli w sklepie konto.
                            Po założeniu przez klienta konta jego adres email jest dodawany oprócz domyślnej listy odbiorców także do dodatkowej listy, której nazwa jest tworzona na podstawie ustalonej nazwy listy.
                            Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona. Warunkiem zapisu adresu klienta do list jest wyrażenie przez klienta zgody na otrzymywanie newslettera.
                        </span>
                      </td>
                    </tr>    

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz subskrypcję klientów:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FRESHMAIL_WLACZONY_REJESTRACJA']['1'], $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_REJESTRACJA']['0'], 'integracja_freshmail_wlaczony_rejestracja', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_REJESTRACJA']['2'], '', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_REJESTRACJA']['3'] );
                        ?>
                      </td>
                    </tr>      

                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_freshmail_rejestracja_prefix">Nazwa listy odbiorców:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_freshmail_rejestracja_prefix" id="integracja_freshmail_rejestracja_prefix" value="'.$parametr['INTEGRACJA_FRESHMAIL_REJESTRACJA_PREFIX']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_FRESHMAIL_REJESTRACJA_PREFIX']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>                       
                    
                    <tr>
                      <td colspan="2" class="NaglowekAfiliacja">
                        <strong>Automatyczna subskrypcja zakupionych produktów</strong>
                        <span class="maleInfo">
                            Funkcja ułatwiająca tworzenie list mailingowych klientów w oparciu o zakupione przez klientów produkty. Dzięki temu można wysłać maile tylko do klientów, którzy zakupili określone produkty.
                            Po złożeniu przez klienta zamówienia jego adres email jest dodawany do listy odbiorców, której nazwa jest tworzona na podstawie ustalonego prefiksu oraz id produktu np. Produkt 55
                            Jeżeli klient dokona zakupu kilku produktów zostanie zapisany do kilku list odpowiadających poszczególnym produktom. Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona.
                            Warunkiem zapisu adresu klienta do list jest wyrażenie przez klienta zgody na otrzymywanie newslettera.
                        </span>
                      </td>
                    </tr>    

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz subskrypcję produktów:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FRESHMAIL_WLACZONY_PRODUKTY']['1'], $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_PRODUKTY']['0'], 'integracja_freshmail_wlaczony_produkty', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_PRODUKTY']['2'], '', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_PRODUKTY']['3'] );
                        ?>
                      </td>
                    </tr>      

                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_freshmail_produkty_prefix">Prefix listy odbiorców:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_freshmail_produkty_prefix" id="integracja_freshmail_produkty_prefix" value="'.$parametr['INTEGRACJA_FRESHMAIL_PRODUKTY_PREFIX']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_FRESHMAIL_PRODUKTY_PREFIX']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>                    
                    
                    <tr>
                      <td colspan="2" class="NaglowekAfiliacja">
                        <strong>Automatyczna subskrypcja klientów dokonujących zakupy</strong>
                        <span class="maleInfo">
                            Funkcja ułatwiająca tworzenie list mailingowych klientów, którzy złożyli w sklepie zamówienia. Dzięki temu można wysłać maile tylko do klientów, którzy dokonali w sklepie zakupów.
                            Po złożeniu przez klienta zamówienia jego adres email jest dodawany do listy odbiorców, której nazwa jest tworzona na podstawie ustalonej nazwy listy. Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona.
                            Warunkiem zapisu adresu klienta do list jest wyrażenie przez klienta zgody na otrzymywanie newslettera.
                        </span>
                      </td>
                    </tr>    

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz subskrypcję kupujących klientów:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_FRESHMAIL_WLACZONY_KUPUJACY']['1'], $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_KUPUJACY']['0'], 'integracja_freshmail_wlaczony_kupujacy', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_KUPUJACY']['2'], '', $parametr['INTEGRACJA_FRESHMAIL_WLACZONY_KUPUJACY']['3'] );
                        ?>
                      </td>
                    </tr>      

                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_freshmail_kupujacy_prefix">Nazwa listy odbiorców:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_freshmail_kupujacy_prefix" id="integracja_freshmail_kupujacy_prefix" value="'.$parametr['INTEGRACJA_FRESHMAIL_KUPUJACY_PREFIX']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_FRESHMAIL_KUPUJACY_PREFIX']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>                      
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'freshmail' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                    
                  </table>

              </div>
            </form>
          </div>
          
          
          <!-- Integracja z Getall -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="getallForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="getall" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">GetAll to program do newslettera i kompleksowy pakiet profesjonalnych narzędzi do email marketingu.</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                    <div>GetAll to kompleksowy zestaw narzędzi do email marketingu i reklamy w Internecie. Jest to profesjonalna platforma marketingowa i całościowy system do skutecznego budowania internetowych biznesów przy zastosowaniu wysokiego poziomu automatyzacji.</div>                      
                      <img src="obrazki/logo/logo_getall.png" alt="" />
                      <span class="maleSukces" style="margin:0px 10px 15px 10px">Integracja sklepu z GetAll pozwala na automatyzację przenoszenia adresów email ze sklepu do GetAll. Klient zapisując się w sklepie do newslettera jest również automatycznie dodawany do listy odbiorców w systemie GetAll. </span>
                      <div style="color:#ff0000;float:none;width:auto;padding:0px;margin:0px 10px 15px 35px">WAŻNE !! Do działania integracji wymagany jest kontakt z GetAll w celu aktywowania funkcji ResponderAddSubscriber() - http://api.getall.pl/responderaddsubscriber/ <i>(Metoda wymaga ręcznej aktywacji na koncie użytkownika. Aby aktywować napisz na info@getall.pl)</i></div>
                    </td></tr>                   
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz integrację:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_GETALL_WLACZONY']['1'], $parametr['INTEGRACJA_GETALL_WLACZONY']['0'], 'integracja_getall_wlaczony', $parametr['INTEGRACJA_GETALL_WLACZONY']['2'], '', $parametr['INTEGRACJA_GETALL_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_getall_key">Klucz API:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_getall_apikey" id="integracja_getall_apikey" value="'.$parametr['INTEGRACJA_GETALL_APIKEY']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_GETALL_APIKEY']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>  

                </table>
                
                <?php
                // sprawdzi czy pokazac dodatkowe opcje
                $zapytanie_getall = "select code, value from settings where code LIKE '%INTEGRACJA_GETALL%'";
                $sql_getall = $db->open_query($zapytanie_getall);
                //
                $getall_stale = array();
                //
                while ($info_getall = $sql_getall->fetch_assoc()) {
                       $getall_stale[$info_getall['code']] = $info_getall['value'];
                }
                //
                $db->close_query($sql_getall);
                
                $tablica_list = array();
                $blad = '';
                
                if ( $getall_stale['INTEGRACJA_GETALL_WLACZONY'] == 'tak' && $getall_stale['INTEGRACJA_GETALL_APIKEY'] != '' ) {
                     //
                     $getall = new GetAll($getall_stale['INTEGRACJA_GETALL_APIKEY']);   
                     $tablica_list = $getall->PobierzListy();
                     //
                     if ( !is_array($tablica_list) ) {
                          //
                          $blad = $tablica_list;
                          //
                     }
                     //
                }
                ?>
                
                <?php if ( $getall_stale['INTEGRACJA_GETALL_WLACZONY'] == 'tak' && !is_array($tablica_list) ) { ?>
                
                    <table>
                        
                            <tr>
                              <td colspan="2" class="NaglowekAfiliacja">
                                <strong style="color:#ff0000">BŁĄD !! Nie można pobrać danych o dostępnych listach klientów</strong>
                                <span class="maleInfo">
                                    Sprawdź czy masz utworzone listy klientów w Getall oraz czy klucz API jest poprawny.
                                    <?php
                                    if ( !empty($blad) ) {
                                        echo '<div style="margin-top:8px"><b>Błąd zwracany przez system Getall: <span style="color:#ff0000">' . $blad . '</span></div>';
                                    }
                                    ?>
                                </span>
                              </td>
                            </tr>   

                    </table>

                <?php } ?>
                
                <div <?php echo (($getall_stale['INTEGRACJA_GETALL_WLACZONY'] == 'tak' && count($tablica_list) > 0 && $blad == '') ? '' : 'style="display:none"'); ?>>
                
                    <table>

                        <tr>
                          <td colspan="2" class="NaglowekAfiliacja">
                            <strong>Automatyczna subskrypcja wszystkich klientów którzy wyrazili zgodę na otrzymywanie newslettera</strong>
                            <span class="maleInfo">
                                Funkcja ułatwiająca tworzenie list mailingowych klientów, którzy wyrazili zgodę na otrzymywanie newslettera. Po zapisaniu się klienta do newslettera (poprzez box, przy rejestracji czy module newslettera) jego adres email 
                                jest dodawany do domyślnej (zdefiniowanej poniżej) listy odbiorców. Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona.
                            </span>
                          </td>
                        </tr>                     
                        
                        <tr class="SledzeniePozycja">
                          <td>
                            <label class="required" for="integracja_domyslna_lista">Domyślna lista odbiorców:</label>
                          </td>
                          <td>
                            <?php
                            if ( is_array($tablica_list) && count($tablica_list) > 0 ) {
                                 //
                                 echo '<select name="integracja_getall_domyslna_lista" id="integracja_getall_domyslna_lista">';
                                 foreach ( $tablica_list as $lista ) {
                                    //
                                    echo '<option value="' . $lista['id'] . '" ' . (($parametr['INTEGRACJA_GETALL_DOMYSLNA_LISTA']['0'] == $lista['id']) ? 'selected="selected"' : '') . '>' . $lista['nazwa'] . '</option>';
                                    //
                                 }
                                 //
                                 echo '</select>';
                                 //
                            }
                            ?>
                          </td>
                        </tr>          

                        <tr>
                          <td colspan="2" class="NaglowekAfiliacja">
                            <strong>Dodatkowa lista odbiorców dla klientów przy rejestracji konta</strong>
                            <span class="maleInfo">
                                Funkcja ułatwiająca tworzenie list mailingowych klientów, którzy dokonali rejestracji konta w sklepie. Dzięki temu można wysłać maile tylko do klientów, którzy założyli w sklepie konto.
                                Po założeniu przez klienta konta jego adres email jest dodawany oprócz domyślnej listy odbiorców także do dodatkowej listy, której nazwa jest tworzona na podstawie ustalonej nazwy listy.
                                Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona. Warunkiem zapisu adresu klienta do list jest wyrażenie przez klienta zgody na otrzymywanie newslettera.
                            </span>
                          </td>
                        </tr>    

                        <tr class="SledzeniePozycja">
                          <td>
                            <label>Włącz subskrypcję klientów:</label>
                          </td>
                          <td>
                            <?php
                            echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_GETALL_WLACZONY_REJESTRACJA']['1'], $parametr['INTEGRACJA_GETALL_WLACZONY_REJESTRACJA']['0'], 'integracja_getall_wlaczony_rejestracja', $parametr['INTEGRACJA_GETALL_WLACZONY_REJESTRACJA']['2'], '', $parametr['INTEGRACJA_GETALL_WLACZONY_REJESTRACJA']['3'] );
                            ?>
                          </td>
                        </tr>      

                        <tr class="SledzeniePozycja">
                          <td>
                            <label class="required" for="integracja_getall_rejestracja_prefix">Nazwa listy odbiorców:</label>
                          </td>
                          <td>
                            <?php
                            if ( is_array($tablica_list) && count($tablica_list) > 0 ) {
                                 //
                                 echo '<select name="integracja_getall_rejestracja_prefix" id="integracja_getall_rejestracja_prefix">';
                                 foreach ( $tablica_list as $lista ) {
                                    //
                                    echo '<option value="' . $lista['id'] . '" ' . (($parametr['INTEGRACJA_GETALL_REJESTRACJA_PREFIX']['0'] == $lista['id']) ? 'selected="selected"' : '') . '>' . $lista['nazwa'] . '</option>';
                                    //
                                 }
                                 //
                                 echo '</select>';
                                 //
                            }
                            ?>                          
                          </td>
                        </tr>                       
                        
                        <tr>
                          <td colspan="2" class="NaglowekAfiliacja">
                            <strong>Automatyczna subskrypcja zakupionych produktów</strong>
                            <span class="maleInfo">
                                Funkcja ułatwiająca tworzenie list mailingowych klientów w oparciu o zakupione przez klientów produkty. Dzięki temu można wysłać maile tylko do klientów, którzy zakupili określone produkty.
                                Po złożeniu przez klienta zamówienia jego adres email jest dodawany do listy odbiorców, której nazwa jest tworzona na podstawie ustalonego prefiksu oraz id produktu np. Produkt 55
                                Jeżeli klient dokona zakupu kilku produktów zostanie zapisany do kilku list odpowiadających poszczególnym produktom. Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona.
                                Warunkiem zapisu adresu klienta do list jest wyrażenie przez klienta zgody na otrzymywanie newslettera.
                            </span>
                          </td>
                        </tr>    

                        <tr class="SledzeniePozycja">
                          <td>
                            <label>Włącz subskrypcję produktów:</label>
                          </td>
                          <td>
                            <?php
                            echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_GETALL_WLACZONY_PRODUKTY']['1'], $parametr['INTEGRACJA_GETALL_WLACZONY_PRODUKTY']['0'], 'integracja_getall_wlaczony_produkty', $parametr['INTEGRACJA_GETALL_WLACZONY_PRODUKTY']['2'], '', $parametr['INTEGRACJA_GETALL_WLACZONY_PRODUKTY']['3'] );
                            ?>
                          </td>
                        </tr>      

                        <tr class="SledzeniePozycja">
                          <td>
                            <label class="required" for="integracja_getall_produkty_prefix">Prefix listy odbiorców:</label>
                          </td>
                          <td>
                            <?php
                            if ( is_array($tablica_list) && count($tablica_list) > 0 ) {
                                 //
                                 echo '<select name="integracja_getall_produkty_prefix" id="integracja_getall_produkty_prefix">';
                                 foreach ( $tablica_list as $lista ) {
                                    //
                                    echo '<option value="' . $lista['id'] . '" ' . (($parametr['INTEGRACJA_GETALL_PRODUKTY_PREFIX']['0'] == $lista['id']) ? 'selected="selected"' : '') . '>' . $lista['nazwa'] . '</option>';
                                    //
                                 }
                                 //
                                 echo '</select>';
                                 //
                            }
                            ?>                          
                          </td>
                        </tr>                    
                        
                        <tr>
                          <td colspan="2" class="NaglowekAfiliacja">
                            <strong>Automatyczna subskrypcja klientów dokonujących zakupy</strong>
                            <span class="maleInfo">
                                Funkcja ułatwiająca tworzenie list mailingowych klientów, którzy złożyli w sklepie zamówienia. Dzięki temu można wysłać maile tylko do klientów, którzy dokonali w sklepie zakupów.
                                Po złożeniu przez klienta zamówienia jego adres email jest dodawany do listy odbiorców, której nazwa jest tworzona na podstawie ustalonej nazwy listy. Jeżeli lista nie istnieje w systemie FreshMail - zostanie utworzona.
                                Warunkiem zapisu adresu klienta do list jest wyrażenie przez klienta zgody na otrzymywanie newslettera.
                            </span>
                          </td>
                        </tr>    

                        <tr class="SledzeniePozycja">
                          <td>
                            <label>Włącz subskrypcję kupujących klientów:</label>
                          </td>
                          <td>
                            <?php
                            echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_GETALL_WLACZONY_KUPUJACY']['1'], $parametr['INTEGRACJA_GETALL_WLACZONY_KUPUJACY']['0'], 'integracja_getall_wlaczony_kupujacy', $parametr['INTEGRACJA_GETALL_WLACZONY_KUPUJACY']['2'], '', $parametr['INTEGRACJA_GETALL_WLACZONY_KUPUJACY']['3'] );
                            ?>
                          </td>
                        </tr>      

                        <tr class="SledzeniePozycja">
                          <td>
                            <label class="required" for="integracja_getall_kupujacy_prefix">Nazwa listy odbiorców:</label>
                          </td>
                          <td>
                            <?php
                            if ( is_array($tablica_list) && count($tablica_list) > 0 ) {
                                 //
                                 echo '<select name="integracja_getall_kupujacy_prefix" id="integracja_getall_kupujacy_prefix">';
                                 foreach ( $tablica_list as $lista ) {
                                    //
                                    echo '<option value="' . $lista['id'] . '" ' . (($parametr['INTEGRACJA_GETALL_KUPUJACY_PREFIX']['0'] == $lista['id']) ? 'selected="selected"' : '') . '>' . $lista['nazwa'] . '</option>';
                                    //
                                 }
                                 //
                                 echo '</select>';
                                 //
                            }
                            ?>                            
                          </td>
                        </tr> 

                    </table>
                      
                </div>
                    
                <table>
                
                  <tr>
                    <td colspan="2">
                      <div class="przyciski_dolne">
                        <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'getall' ? $wynik : '' ); ?>
                      </div>
                    </td>
                  </tr>
                  
                </table>

                <?php unset($getall_stale, $info_getall, $zapytanie_getall); ?>

              </div>
            </form>
          </div>          

          
          <!-- Klikochron -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="klikochronForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="klikochron" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Klikochron - ubezpieczenia produktów dla e-commerce</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Klienci mogą za pośrednictwem Klikochron po kilku kliknięciach w internecie zawierać umowy o ubezpieczenie produktów elektroniki mobilnej i stacjonarnej, mebli, okularów i rowerów. Nieistotne, czy chodzi o uszkodzenie, błąd obsługi lub utratę na skutek kradzieży.</div>
                      <img src="obrazki/logo/klikochron.png" alt="" />
                    </td></tr>                   
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz integrację:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_KLIKOCHRON_WLACZONY']['1'], $parametr['INTEGRACJA_KLIKOCHRON_WLACZONY']['0'], 'integracja_klikochron_wlaczony', $parametr['INTEGRACJA_KLIKOCHRON_WLACZONY']['2'], '', $parametr['INTEGRACJA_KLIKOCHRON_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_klikochron_partnerid">Identyfikator partnera (partnerID):</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_klikochron_partnerid" id="integracja_klikochron_partnerid" value="'.$parametr['INTEGRACJA_KLIKOCHRON_PARTNERID']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_KLIKOCHRON_PARTNERID']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_klikochron_shopid">Identyfikator sklepu (shopId):</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_klikochron_shopid" id="integracja_klikochron_shopid" value="'.$parametr['INTEGRACJA_KLIKOCHRON_SHOPID']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_KLIKOCHRON_SHOPID']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr> 

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Aktywuj eksport kategorii (wyrażam zgodę na eksport kategorii sklepu):</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_KLIKOCHRON_KATEGORIE']['1'], $parametr['INTEGRACJA_KLIKOCHRON_KATEGORIE']['0'], 'integracja_klikochron_kategorie', $parametr['INTEGRACJA_KLIKOCHRON_KATEGORIE']['2'], '', $parametr['INTEGRACJA_KLIKOCHRON_KATEGORIE']['3'] );
                        ?>
                      </td>
                    </tr>   

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Aktywuj tryb debug:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_KLIKOCHRON_DEBUG']['1'], $parametr['INTEGRACJA_KLIKOCHRON_DEBUG']['0'], 'integracja_klikochron_debug', $parametr['INTEGRACJA_KLIKOCHRON_DEBUG']['2'], '', $parametr['INTEGRACJA_KLIKOCHRON_DEBUG']['3'] );
                        ?>
                      </td>
                    </tr>  

                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Aktywuj tryb testowy:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_KLIKOCHRON_TEST']['1'], $parametr['INTEGRACJA_KLIKOCHRON_TEST']['0'], 'integracja_klikochron_test', $parametr['INTEGRACJA_KLIKOCHRON_TEST']['2'], '', $parametr['INTEGRACJA_KLIKOCHRON_TEST']['3'] );
                        ?>
                      </td>
                    </tr>                       
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'klikochron' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                    
                  </table>

              </div>
            </form>
          </div>  

          <!-- TrustedShops -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="trustedshopsForm" class="cmxform"> 
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="trustedshops" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Trusted Shops - wiodący znak jakości dla sklepów internetowych w Europie</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Trusted Shops to wiodący znak jakości dla sklepów internetowych w Europie oferujący klientom porównanie cen i ochronę kupującego. Dzięki znakowi jakości zwiększasz wiarygodność w oczach klientów. Oferujesz im także dodatkowe zabezpieczenie w postaci ochrony kupującego.</div>
                      <img src="obrazki/logo/trustedshops.png" alt="" />
                    </td></tr>                   
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz integrację:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_TRUSTEDSHOPS_WLACZONY']['1'], $parametr['INTEGRACJA_TRUSTEDSHOPS_WLACZONY']['0'], 'integracja_trustedshops_wlaczony', $parametr['INTEGRACJA_TRUSTEDSHOPS_WLACZONY']['2'], '', $parametr['INTEGRACJA_TRUSTEDSHOPS_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label class="required" for="integracja_trustedshops_partnerid">Identyfikator Trusted Shops:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_trustedshops_partnerid" id="integracja_trustedshops_partnerid" value="'.$parametr['INTEGRACJA_TRUSTEDSHOPS_PARTNERID']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_TRUSTEDSHOPS_PARTNERID']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label for="integracja_trustedshops_przesuniecie">Przesunięcie trustbadge do góry:</label>
                      </td>
                      <td>
                        <?php
                        echo '<input type="text" name="integracja_trustedshops_przesuniecie" id="integracja_trustedshops_przesuniecie" value="'.$parametr['INTEGRACJA_TRUSTEDSHOPS_PRZESUNIECIE']['0'].'" size="53" /><em class="TipIkona"><b>'. $parametr['INTEGRACJA_TRUSTEDSHOPS_PRZESUNIECIE']['2'].'</b></em>';
                        ?>
                      </td>
                    </tr>
                    
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Format wyświetlania:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_TRUSTEDSHOPS_FORMAT']['1'], $parametr['INTEGRACJA_TRUSTEDSHOPS_FORMAT']['0'], 'integracja_trustedshops_format', $parametr['INTEGRACJA_TRUSTEDSHOPS_FORMAT']['2'], '', $parametr['INTEGRACJA_TRUSTEDSHOPS_FORMAT']['3'] );
                        ?>
                      </td>
                    </tr>
                    
                    
                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'klikochron' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                    
                  </table>

              </div>
            </form>
          </div>  

          
          <?php
          /*
          // aktualnie nieuzywane
          
          <!-- chceto -->
          <div class="Sledzenie">
          
            <form action="integracje/konfiguracja_afiliacja.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="chcetoForm" class="cmxform">
            
              <div>
                <input type="hidden" name="akcja" value="zapisz" />
                <input type="hidden" name="system" value="chceto" />
              </div>
              
              <div class="ObramowanieForm">
              
                  <table>
                  
                    <tr class="DivNaglowek">
                      <td colspan="2">Chce.to - odnośnik, który umożliwia jednym kliknięciem dodawać produkty na swoje chcelisty.</td>
                    </tr>
                    
                    <tr><td colspan="2" class="SledzenieOpis">
                      <div>Chce.to - serwis internetowy umożliwiający tworzenie chcelist, czyli list rzeczy, jakie chcemy mieć. Serwis ma na celu ułatwienie użytkownikom prostą z pozoru czynność dawania i dostawania prezentów.</div>
                      <img src="obrazki/logo/logo_chceto.png" alt="" />
                    </td></tr>                  
                  
                    <tr class="SledzeniePozycja">
                      <td>
                        <label>Włącz przycisk +chce.to:</label>
                      </td>
                      <td>
                        <?php
                        echo Konfiguracja::Dopuszczalne_Wartosci_Auto($parametr['INTEGRACJA_CHCE_TO_WLACZONY']['1'], $parametr['INTEGRACJA_CHCE_TO_WLACZONY']['0'], 'integracja_chce_to_wlaczony', $parametr['INTEGRACJA_CHCE_TO_WLACZONY']['2'], '', $parametr['INTEGRACJA_CHCE_TO_WLACZONY']['3'] );
                        ?>
                      </td>
                    </tr>

                    <tr>
                      <td colspan="2">
                        <div class="przyciski_dolne">
                          <input type="submit" class="przyciskNon" value="Zapisz dane" /><?php echo ( $system == 'chceto' ? $wynik : '' ); ?>
                        </div>
                      </td>
                    </tr>
                  </table>

              </div>
            </form>
            
          </div>      
          */
          ?>
        
        </div>
      </div>
    </div>

    
    <?php
    include('stopka.inc.php');    
    
} ?>
