# shopGold
# http://www.shopgold.pl
# Wersja sklepu: 1.3955
#
# Copyright (c) 2017 shopGold
#
# Data archiwum: 21-09-2017

DROP TABLE IF EXISTS `additional_images`;
CREATE TABLE `additional_images` (
  `additional_images_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` int(11) NOT NULL DEFAULT '0',
  `images_description` varchar(255) DEFAULT NULL,
  `popup_images` varchar(255) DEFAULT NULL,
  `sort_order` int(5) NOT NULL,
  PRIMARY KEY (`additional_images_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `address_book`;
CREATE TABLE `address_book` (
  `address_book_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `entry_company` varchar(256) DEFAULT NULL,
  `entry_nip` varchar(32) DEFAULT NULL,
  `entry_regon` varchar(9) NOT NULL,
  `entry_pesel` varchar(32) DEFAULT NULL,
  `entry_firstname` varchar(32) NOT NULL,
  `entry_lastname` varchar(32) NOT NULL,
  `entry_street_address` varchar(64) NOT NULL,
  `entry_postcode` varchar(10) NOT NULL,
  `entry_city` varchar(32) NOT NULL,
  `entry_country_id` int(11) NOT NULL DEFAULT '0',
  `entry_zone_id` int(11) NOT NULL DEFAULT '0',
  `entry_telephone` varchar(32) NOT NULL,
  PRIMARY KEY (`address_book_id`,`customers_id`),
  KEY `idx_customers_id` (`customers_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `address_book` (`address_book_id`, `customers_id`, `entry_company`, `entry_nip`, `entry_regon`, `entry_pesel`, `entry_firstname`, `entry_lastname`, `entry_street_address`, `entry_postcode`, `entry_city`, `entry_country_id`, `entry_zone_id`, `entry_telephone`) VALUES ("1","1","","","","","Jarosław","Bednarski","1 Maja 5","46-053","Chrząstowice","170","8","");

DROP TABLE IF EXISTS `admin`;
CREATE TABLE `admin` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_id` int(11) DEFAULT NULL,
  `admin_firstname` varchar(32) NOT NULL,
  `admin_lastname` varchar(32) DEFAULT NULL,
  `admin_email_address` varchar(96) NOT NULL,
  `admin_password` varchar(40) NOT NULL,
  `admin_created` datetime DEFAULT NULL,
  `admin_modified` datetime NOT NULL,
  `admin_logdate` datetime DEFAULT NULL,
  `admin_lastlogdate` datetime DEFAULT NULL,
  `admin_lognum` int(11) NOT NULL DEFAULT '0',
  `admin_adres_ip` varchar(32) DEFAULT '*.*.*.*',
  `admin_sessionid` char(50) DEFAULT NULL,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `idx_admin_email_address` (`admin_email_address`),
  KEY `idx_admin_lastname` (`admin_lastname`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `admin` (`admin_id`, `admin_groups_id`, `admin_firstname`, `admin_lastname`, `admin_email_address`, `admin_password`, `admin_created`, `admin_modified`, `admin_logdate`, `admin_lastlogdate`, `admin_lognum`, `admin_adres_ip`, `admin_sessionid`) VALUES ("1","1","Jarosław","Bednarski","sklep@okdrive.pl","d0e1ee6c97d123e2de159f85195c3ee9:c9","2017-09-14 16:33:22","2017-09-14 16:33:22","2017-09-21 16:35:30","2017-09-21 16:33:34","22","*.*.*.*","nckecrdlp3k75bbuaqcoftrtg6");

DROP TABLE IF EXISTS `admin_acces`;
CREATE TABLE `admin_acces` (
  `menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_nazwa` varchar(100) NOT NULL,
  `plik` varchar(100) NOT NULL,
  `nadrzedna` int(3) NOT NULL,
  `sortowanie` int(3) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `ikona` int(1) NOT NULL DEFAULT '0',
  `grupa_id_upraw_1` tinyint(1) NOT NULL DEFAULT '1',
  `grupa_id_upraw_2` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`menu_id`),
  KEY `idx_sortowanie` (`sortowanie`),
  KEY `idx_status` (`status`),
  KEY `idx_plik` (`plik`)
) ENGINE=InnoDB AUTO_INCREMENT=253 DEFAULT CHARSET=utf8;

INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("1","Konfiguracja","","0","10","1","0","1","0"),
("2","Wygląd","","0","9","1","0","1","0"),
("3","Asortyment","","0","1","1","0","1","0"),
("4","Dane firmy","konfiguracja/konfiguracja.php?typ=firma","160","5","1","0","1","0"),
("5","Ustawienia sklepu","konfiguracja/konfiguracja.php?typ=sklep","1","2","1","0","0","0"),
("6","Ustawienia dla hurtowni","konfiguracja/konfiguracja.php?typ=hurtownia","163","4","1","0","1","0"),
("7","Obrazki - ustawienia ogólne","konfiguracja/konfiguracja.php?typ=obrazki","164","1","1","0","1","0"),
("8","Ustawienia wyglądu","wyglad/wyglad.php","2","1","1","0","1","0"),
("9","Boxy","wyglad/boxy.php","2","2","1","0","1","0"),
("10","Moduły środkowe","wyglad/srodek.php","2","3","1","0","1","0"),
("12","Kategorie","kategorie/kategorie.php","3","1","1","0","1","1"),
("13","Produkty","produkty/produkty.php","3","2","1","0","1","1"),
("14","Cechy produktów","cechy/cechy.php","3","4","1","0","1","1"),
("15","Producenci","producenci/producenci.php","3","5","1","0","1","1"),
("16","Słowniki","","1","4","1","0","1","0"),
("17","Stawki VAT","slowniki/podatek_vat.php","16","1","1","0","1","0"),
("18","Kraje i regiony","slowniki/kraje.php","16","2","1","0","1","0"),
("19","Terminy wysyłek","slowniki/terminy_wysylek.php","16","5","1","0","1","0"),
("20","Dostępności produktów","slowniki/dostepnosci.php","16","6","1","0","1","0"),
("22","Grupy użytkowników","system/grupy.php","78","1","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("24","Dodatkowe pola do produktów","slowniki/dodatkowe_pola.php","171","1","1","0","1","0"),
("25","Języki","slowniki/jezyki.php","16","4","1","0","1","0"),
("26","Waluty","slowniki/waluty.php","16","3","1","0","1","1"),
("27","Grupy klientów","klienci/grupy_klienci.php","91","2","1","0","1","1"),
("28","Dodatkowe pola do klientów","slowniki/dodatkowe_pola_klienci.php","171","3","1","0","1","0"),
("29","Sprzedaż","","0","2","1","0","1","0"),
("30","Klienci","klienci/klienci.php","91","1","1","0","1","1"),
("31","Ustawienia SMS","konfiguracja/konfiguracja.php?typ=sms","162","5","1","0","1","0"),
("32","Ustawienia pól klientów","konfiguracja/konfiguracja.php?typ=klienci","163","7","1","0","1","0"),
("33","Ustawienia magazynu","konfiguracja/konfiguracja.php?typ=magazyn","163","8","1","0","1","0"),
("34","Ustawienia e-mail","konfiguracja/konfiguracja.php?typ=email","162","1","1","0","1","0"),
("35","Statusy zamówień","sprzedaz/zamowienia_statusy.php","90","5","1","0","1","1"),
("36","Tłumaczenia","slowniki/tlumaczenia.php","1","11","1","0","1","1"),
("37","Szablony emaili","slowniki/emaile_szablony.php","16","11","1","0","1","0"),
("38","Jednostki miary","slowniki/jednostki_miary.php","16","10","1","0","1","0"),
("40","Wyłączenie sklepu","konfiguracja/konfiguracja.php?typ=wylaczenie","78","49","1","0","1","0"),
("41","Treści wiadomości email","slowniki/emaile_tresci.php","16","12","1","0","1","0"),
("42","Magazyn produktów","produkty_magazyn/produkty_magazyn.php","3","3","1","0","1","1"),
("43","Zarządzanie zamówieniami","sprzedaz/zamowienia.php","90","1","1","0","1","1"),
("44","Promocje","promocje/promocje.php","3","6","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("46","Nasz hit","nasz_hit/nasz_hit.php","3","7","1","0","1","1"),
("47","Produkty polecane","polecane/polecane.php","3","8","1","0","1","1"),
("49","Produkty podobne","podobne/podobne.php","3","10","1","0","1","1"),
("50","Moduły","","0","12","1","0","1","0"),
("51","Podsumowanie zamówienia","moduly/podsumowanie.php","50","3","1","0","1","1"),
("53","Gratisy","gratisy/gratisy.php","3","12","1","0","1","1"),
("55","Rabaty indywidualne klientów","klienci/rabaty_klientow.php","201","3","1","0","1","0"),
("56","Wysyłki","moduly/wysylka.php","50","1","1","0","1","1"),
("58","Konfiguracja ankiet","konfiguracja/konfiguracja.php?typ=ankiety","240","2","1","0","1","0"),
("59","Formularze","formularze/formularze.php","2","6","1","0","1","0"),
("60","Galerie","galerie/galerie.php","2","7","1","0","1","0"),
("69","Strony informacyjne","","2","8","1","0","1","0"),
("70","Dokumenty PDF","konfiguracja/konfiguracja.php?typ=pdf","164","12","1","0","1","0"),
("72","Zarządzanie aktualnościami","aktualnosci/aktualnosci.php","185","1","1","0","1","0"),
("73","Newsletter","newsletter/newsletter.php","92","1","1","0","1","0"),
("74","Newsletter - subskrybenci","newsletter/newsletter_subskrybenci.php","92","2","1","0","1","0"),
("75","Newsletter - mailing","newsletter/newsletter_mailing.php","92","3","1","0","1","0"),
("76","Ustawienia faktur VAT i paragonów","konfiguracja/konfiguracja.php?typ=faktura","163","13","1","0","1","0"),
("77","Obsługa plików CSV","import_danych/obsluga_csv.php","96","1","1","0","1","1"),
("78","Narzędzia","","0","17","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("79","Allegro","","93","1","1","0","1","1"),
("80","Konfiguracja połączenia z Allegro","allegro/konfiguracja_polaczenia.php","79","1","1","0","1","0"),
("81","Kupony rabatowe","kupony/kupony.php","3","14","1","0","1","1"),
("82","Konfiguracja wystawiania aukcji","allegro/konfiguracja_wystawiania.php","79","2","1","0","1","0"),
("83","Archiwizacja danych","narzedzia/archiwizacja.php","78","12","1","0","1","0"),
("84","Obsługa plików XML","import_danych/obsluga_xml.php","96","2","1","0","1","1"),
("85","Konfiguracja szablonów aukcji","allegro/szablony.php","79","3","1","0","1","0"),
("86","Szablony importu XML","narzedzia/szablony_importu_xml.php","96","3","1","0","1","1"),
("87","Import zewnętrzny XML","import_danych/xml_import_zewnetrzny.php","96","4","1","0","1","1"),
("88","Zarządzanie aukcjami","allegro/allegro_aukcje.php","79","5","1","0","1","0"),
("90","Zamówienia","","29","1","1","0","1","1"),
("91","Klienci","","29","2","1","0","1","1"),
("92","Newsletter","","29","6","1","0","1","0"),
("93","Integracje","","0","14","1","0","1","1"),
("94","Statystyki","","0","15","1","0","1","1"),
("96","Import i eksport danych","","78","2","1","0","1","1"),
("97","Rabaty dla producentów","klienci/rabaty_producentow.php","201","4","1","0","1","0"),
("98","Rabaty dla kategorii","klienci/rabaty_kategorii.php","201","5","1","0","1","0"),
("99","Rabaty dla produktów","klienci/rabaty_produktow.php","201","6","1","0","1","0"),
("101","Ustawienia rabatów i zniżek","konfiguracja/konfiguracja.php?typ=rabaty","163","10","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("102","Reklamacje","","29","4","1","0","1","1"),
("103","Zarządzanie reklamacjami","reklamacje/reklamacje.php","102","1","1","0","1","1"),
("104","Statusy reklamacji","reklamacje/reklamacje_statusy.php","102","2","1","0","1","1"),
("105","Sprzedaż","allegro/allegro_sprzedaz.php","79","6","1","0","1","0"),
("116","Porównywarki","porownywarki/porownywarki.php","93","3","1","0","1","0"),
("118","Import i eksport klientów","import_danych/obsluga_klientow.php","96","6","1","0","1","1"),
("121","Systemy śledzące","integracje/konfiguracja_sledzenie.php","93","5","1","0","1","0"),
("123","Sprzedaż","","94","1","1","0","1","1"),
("124","Klienci","","94","2","1","0","1","1"),
("125","Asortyment","","94","3","1","0","1","1"),
("126","Systemy afiliacyjne","integracje/konfiguracja_afiliacja.php","93","6","1","0","1","0"),
("127","Formy płatności","statystyki/formy_platnosci.php","123","1","1","0","1","1"),
("128","Formy dostawy","statystyki/formy_dostawy.php","123","2","1","0","1","1"),
("129","Wykres sprzedaży","statystyki/wykres_sprzedazy.php","123","3","1","0","1","1"),
("130","Raport sprzedaży produktów dla kategorii","statystyki/raport_kategorii.php","123","4","1","0","1","1"),
("131","Raport sprzedaży produktów w przedziale czasowym","statystyki/raport_okresowy.php","123","5","1","0","1","1"),
("132","Raport sprzedaży produktów wg cech","statystyki/raport_produktow_cechy.php","123","6","1","0","1","1"),
("133","Zamówienia wg typu","statystyki/zamowienia_wg_typu.php","123","7","1","0","1","1"),
("134","Rejestracje klientów","statystyki/rejestracje_klientow.php","124","1","1","0","1","1"),
("135","Klienci wg zamówień","statystyki/klienci_zamowienia.php","124","2","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("136","Wyświetlenia produktów","statystyki/wyswietlenia_produktow.php","125","1","1","0","1","1"),
("137","Najczęściej kupowane produkty","statystyki/najczesciej_kupowane.php","125","2","1","0","1","1"),
("138","Wyszukiwane frazy","statystyki/wyszukiwane_frazy.php","125","5","1","0","1","1"),
("139","Kończące się produkty","statystyki/niskie_stany.php","125","3","1","0","1","1"),
("140","Kończące się cechy produktów","statystyki/niskie_stany_cechy.php","125","4","1","0","1","1"),
("141","Firmy wysyłkowe","","93","9","1","0","1","0"),
("142","Statusy punktów klientów","klienci/punkty_statusy.php","16","8","1","0","1","1"),
("143","Program partnerski","","29","5","1","0","1","0"),
("144","Konfiguracja PP","konfiguracja/konfiguracja.php?typ=program_partnerski","143","3","1","0","1","0"),
("145","Partnerzy","program_partnerski/partnerzy.php","143","1","1","0","1","0"),
("146","Bannery reklamowe","program_partnerski/bannery.php","143","2","1","0","1","0"),
("148","Bannery","","2","10","1","0","1","0"),
("149","Grupy bannerów","wyglad/bannery_grupy.php","148","1","1","0","1","0"),
("150","Zarządzenie bannerami","wyglad/bannery_zarzadzanie.php","148","2","1","0","1","0"),
("151","KurJerzy.pl","integracje/konfiguracja_wysylki_kurjerzy.php","141","4","1","0","1","0"),
("152","Paczkomaty InPost","integracje/konfiguracja_wysylki_inpost.php","141","2","1","0","1","0"),
("153","Przeglądarka plików","narzedzia/przegladarka.php","78","4","1","0","1","0"),
("154","Kurier Siódemka","integracje/konfiguracja_wysylki_siodemka.php","141","3","1","0","1","0"),
("155","Masowa zmiana parametrów produktów","","78","1","1","0","1","1"),
("156","Zmiana cen produktów","narzedzia/masowa_zmiana_cen.php","155","1","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("157","Zmiana statusu produktów","narzedzia/masowa_zmiana_statusu.php","155","2","1","0","1","1"),
("158","Pozycjonowanie","","0","18","1","0","1","1"),
("159","Mapa XML dla Google","pozycjonowanie/mapa_strony.php","158","1","1","0","1","0"),
("160","Dane teleadresowe","","1","1","1","0","1","0"),
("161","Dane kontaktowe","konfiguracja/konfiguracja.php?typ=kontakt","160","6","1","0","1","0"),
("162","Komunikacja","","1","6","1","0","1","0"),
("163","Konfiguracja sklepu","","1","2","1","0","1","0"),
("164","Obrazki i dokumenty","","1","10","1","0","1","0"),
("165","Meta Tagi / Open Graph","","158","2","1","0","1","1"),
("166","Wartości domyślne","pozycjonowanie/meta_tagi_domyslne.php","165","1","1","0","1","1"),
("167","Wartości dla podstron","pozycjonowanie/meta_tagi_podstrony.php","165","1","1","0","1","1"),
("168","Punkty do zatwierdzenia","klienci/punkty_do_zatwierdzenia.php","91","8","1","0","1","1"),
("169","Automatyczne wypełnianie META","pozycjonowanie/meta_tagi_automat.php","165","5","1","0","1","1"),
("171","Dodatkowe pola","","1","5","1","0","1","0"),
("172","Książka nadawcza PP","sprzedaz/zamowienia_ksiazka_nadawcza.php","243","2","1","0","1","1"),
("173","Inwentaryzacja","statystyki/inwentaryzacja.php","125","6","1","0","1","1"),
("174","Etykiety adresowe","sprzedaz/zamowienia_etykiety_adresowe.php","90","4","1","0","1","1"),
("175","Definicje etykiet adresowych","slowniki/etykiety.php","16","9","1","0","1","0"),
("176","DHL - ustawienia do exportu XML","integracje/konfiguracja_wysylki_dhl.php","141","5","1","0","1","0"),
("177","Ustawienia cen","konfiguracja/konfiguracja.php?typ=ceny","163","6","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("178","Obrazki - znak wodny","konfiguracja/konfiguracja.php?typ=watermark","164","2","1","0","1","0"),
("179","Grupy stron informacyjnych","strony_informacyjne/strony_informacyjne_grupy.php","69","1","1","0","1","0"),
("180","Zarządzanie stronami","strony_informacyjne/strony_informacyjne.php","69","2","1","0","1","0"),
("181","Obrazki - ikony na zdjęciach","konfiguracja/konfiguracja.php?typ=ikony","164","2","1","0","1","0"),
("184","Konfiguracja stron","konfiguracja/konfiguracja.php?typ=strony_info","69","3","1","0","1","0"),
("185","Aktualności","","2","9","1","0","1","0"),
("186","Konfiguracja aktualności","konfiguracja/konfiguracja.php?typ=aktualnosci","185","2","1","0","1","0"),
("187","Ustawienia systemu punktów","konfiguracja/konfiguracja.php?typ=punkty","163","9","1","0","1","0"),
("188","Konfiguracja recenzji","konfiguracja/konfiguracja.php?typ=recenzje","238","2","1","0","1","0"),
("189","Ustawienia SSL","konfiguracja/konfiguracja.php?typ=ssl","163","14","1","0","1","0"),
("190","Ustawienia listingu produktów, kategorii i producentów","konfiguracja/konfiguracja.php?typ=listing","163","15","1","0","1","0"),
("191","Ustawienia produktów","konfiguracja/konfiguracja.php?typ=produkt","163","16","1","0","1","0"),
("192","Konfiguracja newslettera","konfiguracja/konfiguracja.php?typ=newsletter","92","5","1","0","1","0"),
("193","Ustawienia bannerów PopUp","konfiguracja/konfiguracja.php?typ=popup","148","3","1","0","1","0"),
("194","Płatności","moduly/platnosc.php","50","2","1","0","1","1"),
("195","Wysuwane zakładki","integracje/konfiguracja_zakladki.php","93","7","1","0","1","1"),
("196","Ustawienia cache i kompresji","konfiguracja/konfiguracja.php?typ=cache","163","17","1","0","1","0"),
("197","Harmonogram zadań","narzedzia/harmonogram.php","78","13","1","0","1","0"),
("198","Moduły stałe","wyglad/srodek_stale.php","2","4","1","0","1","0"),
("199","Grupy klientów newslettera","newsletter/newsletter_grupy.php","92","5","1","0","1","0");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("200","Przekierowania URL","narzedzia/przekierowania.php","78","14","1","0","1","0"),
("201","Rabaty","","29","3","1","0","1","0"),
("202","Faktury VAT","sprzedaz/zamowienia_faktury.php","29","10","1","0","1","1"),
("203","Kto jest w sklepie ?","narzedzia/klienci_online.php","78","15","1","0","1","1"),
("204","Elektroniczny nadawca PP","integracje/konfiguracja_wysylki_en.php","141","1","1","0","1","0"),
("205","Zestawienie wysyłek EN","sprzedaz/zamowienia_wysylki_zestawienie.php","243","3","1","0","1","1"),
("206","Eksport zamówień do CSV","import_danych/obsluga_zamowien.php","96","7","1","0","1","1"),
("207","SendIt","integracje/konfiguracja_wysylki_sendit.php","141","6","1","0","1","0"),
("208","Dodatkowe pola tekstowe do produktów","slowniki/dodatkowe_pola_tekstowe.php","171","2","1","0","1","1"),
("209","Menadżer produktów","narzedzia/menadzer_produktow.php","155","3","1","0","1","0"),
("210","Ustawienia panelu zarządzania","konfiguracja/konfiguracja.php?typ=panel","163","18","1","0","1","1"),
("211","Raport sprzedaży wybranego produktu w przedziale czasowym","statystyki/raport_okresowy_produktu.php","123","5","1","0","1","1"),
("212","Eksport CSV dla DPD","sprzedaz/zamowienia_eksport_dpd.php","243","6","1","0","1","1"),
("213","Ustawienia sprzedaży elektronicznej","konfiguracja/konfiguracja.php?typ=online","163","17","1","0","1","1"),
("214","Kurier K-EX","integracje/konfiguracja_wysylki_kex.php","141","7","1","0","1","0"),
("215","Konfiguracja eksportu CSV i XML","import_danych/konfiguracja_exportu.php","96","3","1","0","1","1"),
("216","Koszty wysyłek","statystyki/koszty_wysylek.php","123","2","1","0","1","1"),
("217","Stan produktów","slowniki/stan_produktu.php","16","5","1","0","1","0"),
("218","Gwarancje produktów","slowniki/gwarancje.php","16","5","1","0","1","0"),
("219","Dodatkowe pola do zamówień","slowniki/dodatkowe_pola_zamowienia.php","171","4","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("220","Serwis Furgonetka.pl","integracje/konfiguracja_wysylki_furgonetka.php","141","8","1","0","1","1"),
("221","Paragony","sprzedaz/zamowienia_paragony.php","29","11","1","0","1","1"),
("222","Kurier InPost","integracje/konfiguracja_wysylki_kurier_inpost.php","141","9","1","0","1","0"),
("223","Indywidualne ceny produktów dla klientów","klienci/indywidualne_ceny_produktow.php","201","7","1","0","1","1"),
("224","Logowania klientów","statystyki/logowania_klientow.php","124","3","1","0","1","1"),
("229","Opinie o sklepie","","29","5","1","0","1","1"),
("230","Zarządzanie opiniami o sklepie","opinie/opinie.php","229","1","1","0","1","1"),
("231","Konfiguracja opinii o sklepie","konfiguracja/konfiguracja.php?typ=opinie","229","2","1","0","1","1"),
("232","Zarządzanie zamówieniami do kontaktu","sprzedaz/zamowienia_kontakt.php","90","2","1","0","1","1"),
("233","Oferty PDF","oferty/oferty.php","29","12","1","0","1","0"),
("234","Ustawienia podstron sklepu","konfiguracja/konfiguracja.php?typ=podstrony","163","17","1","0","1","1"),
("235","Kurier DPD","integracje/konfiguracja_wysylki_dpd.php","141","10","1","0","1","0"),
("236","Zestawienie wysyłek DPD","sprzedaz/zamowienia_wysylki_dpd.php","243","3","1","0","1","1"),
("237","Konfiguracja wysyłek / płatności","konfiguracja/konfiguracja.php?typ=wysylkiplatnosci","50","5","1","0","1","1"),
("238","Recenzje","","3","5","1","0","1","0"),
("239","Zarządzanie recenzjami","recenzje/recenzje.php","238","1","1","0","1","1"),
("240","Ankiety","","2","5","1","0","1","0"),
("241","Zarządzanie ankietami","ankiety/ankiety.php","240","1","1","0","1","1"),
("242","Paczka w RUCHU","integracje/konfiguracja_wysylki_paczka_w_ruchu.php","141","11","1","0","1","0"),
("243","Zestawienia wysyłek","","29","7","1","0","1","1");
INSERT INTO `admin_acces` (`menu_id`, `menu_nazwa`, `plik`, `nadrzedna`, `sortowanie`, `status`, `ikona`, `grupa_id_upraw_1`, `grupa_id_upraw_2`) VALUES ("244","Zestawienie wysyłek Paczka w RUCHU","sprzedaz/zamowienia_wysylki_ruch.php","243","3","1","0","1","1"),
("245","Powiadomienia o produktach","klienci/klienci_powiadomienia.php","29","6","1","0","1","1"),
("246","Integracje własne","integracje/integracje_wlasne.php","93","8","1","0","1","0"),
("247","Rabaty dla kategorii oraz producenta","klienci/rabaty_kategorii_producenta.php","201","6","1","0","1","1"),
("248","Zestawienie protokołów GLS","sprzedaz/zamowienia_wysylki_gls_protocol.php","243","5","1","0","1","1"),
("249","Kurier GLS","integracje/konfiguracja_wysylki_gls.php","141","12","1","0","1","0"),
("250","Akcesoria dodatkowe","","3","11","1","0","1","1"),
("251","Akcesoria dodatkowe dla produktów","akcesoria_dodatkowe/akcesoria_dodatkowe.php","250","1","1","0","1","1"),
("252","Akcesoria dodatkowe dla kategorii","akcesoria_dodatkowe/akcesoria_dodatkowe_kategorie.php","250","2","1","0","1","1");

DROP TABLE IF EXISTS `admin_groups`;
CREATE TABLE `admin_groups` (
  `admin_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_groups_name` varchar(64) DEFAULT NULL,
  `admin_groups_description` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`admin_groups_id`),
  UNIQUE KEY `idx_admin_groups_name` (`admin_groups_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `admin_groups` (`admin_groups_id`, `admin_groups_name`, `admin_groups_description`) VALUES ("1","Administratorzy","Wbudowana grupa administratorów systemu."),
("2","Obsługa sprzedaży","");

DROP TABLE IF EXISTS `allegro_auctions`;
CREATE TABLE `allegro_auctions` (
  `allegro_id` int(11) NOT NULL AUTO_INCREMENT,
  `auction_id` varchar(24) NOT NULL DEFAULT '',
  `products_id` int(11) NOT NULL,
  `products_name` varchar(64) NOT NULL,
  `products_image` varchar(255) NOT NULL,
  `allegro_category` int(11) DEFAULT NULL,
  `allegro_category_shop` int(11) DEFAULT NULL,
  `allegro_options` varchar(50) DEFAULT NULL,
  `products_quantity` decimal(4,0) NOT NULL DEFAULT '0',
  `products_stock_attributes` varchar(255) DEFAULT NULL,
  `products_date_start` datetime DEFAULT NULL,
  `products_date_end` datetime DEFAULT NULL,
  `allegro_server` varchar(3) NOT NULL,
  `allegro_sandbox` int(1) NOT NULL DEFAULT '1',
  `auction_source` tinyint(1) NOT NULL DEFAULT '1',
  `auction_type` tinyint(1) NOT NULL DEFAULT '0',
  `auction_date_start` datetime DEFAULT NULL,
  `auction_date_end` datetime DEFAULT NULL,
  `auction_price` decimal(15,2) NOT NULL,
  `auction_seller` varchar(64) NOT NULL,
  `auction_quantity` int(4) NOT NULL DEFAULT '1',
  `auction_status` tinyint(4) NOT NULL DEFAULT '1',
  `auction_buy_now` tinyint(4) NOT NULL DEFAULT '1',
  `products_start_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `products_now_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `products_min_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `products_buy_now_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `auction_bids` int(4) NOT NULL DEFAULT '0',
  `auction_hits` int(6) NOT NULL DEFAULT '0',
  `auction_watching` int(6) NOT NULL DEFAULT '0',
  `products_sold` int(4) NOT NULL DEFAULT '0',
  `synchronization` int(1) NOT NULL DEFAULT '1',
  `variants` tinyint(1) NOT NULL DEFAULT '0',
  `archiwum_allegro` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`allegro_id`),
  KEY `idx_auction_id_prod_id` (`auction_id`,`products_id`),
  KEY `idx_products_id` (`products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `allegro_auctions_sold`;
CREATE TABLE `allegro_auctions_sold` (
  `allegro_auction_id` int(11) NOT NULL AUTO_INCREMENT,
  `auction_id` varchar(24) NOT NULL DEFAULT '',
  `orders_id` int(11) NOT NULL,
  `buyer_id` varchar(24) NOT NULL,
  `buyer_name` varchar(32) NOT NULL,
  `buyer_email_address` varchar(64) DEFAULT NULL,
  `buyer_first_name` varchar(32) NOT NULL,
  `buyer_last_name` varchar(32) NOT NULL,
  `buyer_company` varchar(32) NOT NULL,
  `buyer_street` varchar(32) NOT NULL,
  `buyer_postcode` varchar(32) NOT NULL,
  `buyer_city` varchar(32) NOT NULL,
  `buyer_phone` varchar(32) NOT NULL,
  `buyer_state_id` int(11) NOT NULL,
  `buyer_country` varchar(32) DEFAULT NULL,
  `buyer_shipping_first_name` varchar(32) NOT NULL,
  `buyer_shipping_last_name` varchar(32) NOT NULL,
  `buyer_shipping_company` varchar(32) NOT NULL,
  `buyer_shipping_street` varchar(32) NOT NULL,
  `buyer_shipping_postcode` varchar(32) NOT NULL,
  `buyer_shipping_city` varchar(32) NOT NULL,
  `buyer_shipping_country` varchar(32) DEFAULT NULL,
  `buyer_status` tinyint(1) NOT NULL DEFAULT '0',
  `auction_quantity` tinyint(4) NOT NULL DEFAULT '1',
  `auction_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `auction_buy_date` varchar(32) NOT NULL,
  `auction_status` tinyint(1) NOT NULL DEFAULT '1',
  `auction_lost_date` varchar(32) NOT NULL,
  `auction_lost_status` tinyint(1) NOT NULL DEFAULT '0',
  `auction_lost_text` text,
  `auction_postbuy_forms` tinyint(1) NOT NULL DEFAULT '0',
  `auction_comments` tinyint(1) NOT NULL DEFAULT '0',
  `date_last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`allegro_auction_id`),
  KEY `idx_auction_orders_id` (`auction_id`,`orders_id`),
  KEY `idx_orders_id` (`orders_id`),
  KEY `idx_buyer_id` (`buyer_id`),
  KEY `idx_auction_id` (`auction_id`),
  KEY `idx_date_end` (`auction_buy_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `allegro_categories`;
CREATE TABLE `allegro_categories` (
  `cat_id` int(11) NOT NULL,
  `cat_name` text NOT NULL,
  `cat_parent` int(11) NOT NULL DEFAULT '0',
  `cat_position` int(11) NOT NULL,
  `cat_is_product_catalogue_enabled` int(11) NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `idex_parent_id` (`cat_parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `allegro_connect`;
CREATE TABLE `allegro_connect` (
  `params` varchar(100) NOT NULL,
  `value` text,
  PRIMARY KEY (`params`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `allegro_connect` (`params`, `value`) VALUES ("CONF_CATEGORIES_WER","1.0.1"),
("CONF_COUNTRY","1"),
("CONF_CURL","nie"),
("CONF_DEFAULT_TEMPLATE","shop_allegro_standardowy"),
("CONF_DODATKOWE_FOTO","zdjecia"),
("CONF_FIELDS_WER","1.0.2"),
("CONF_FOTO_HEIGHT","300"),
("CONF_FOTO_LOCALIZATION","0"),
("CONF_FOTO_WIDTH","500.00"),
("CONF_GALLERY_BIG_IMAGE_WIDTH","500"),
("CONF_GALLERY_SMALL_IMAGE_WIDTH","50"),
("CONF_IMAGE_WATERMARK","nie"),
("CONF_IMAGE_WATERMARK_FILE","watermark/watermark-allegro.png"),
("CONF_INVOICE_PRODUCTS_NAME","tak"),
("CONF_LAST_SYNCHRONIZATION","1376569592"),
("CONF_LOGIN","login"),
("CONF_LOGIN_2",""),
("CONF_LOGIN_3",""),
("CONF_MANUFACTURERS_IMAGE_WIDTH","120"),
("CONF_NEW_DESCRIPTION","nie");
INSERT INTO `allegro_connect` (`params`, `value`) VALUES ("CONF_ORDERS_STATUS","1"),
("CONF_OTHER_IMAGE_COUNT","10"),
("CONF_PASS","xxxxxx"),
("CONF_PASSWORD",""),
("CONF_PASS_2",""),
("CONF_PASS_3",""),
("CONF_SANDBOX","nie"),
("CONF_STANDARD_COMMENTS","Transakcja przebiegła pomyślnie. Polecam."),
("CONF_USER_2_STATUS","nie"),
("CONF_USER_3_STATUS","nie"),
("CONF_USER_ID","1234567890"),
("CONF_USER_ID_2",""),
("CONF_USER_ID_3",""),
("CONF_WEBAPI_KEY",""),
("CONF_WEBAPI_KEY_2",""),
("CONF_WEBAPI_KEY_3","");

DROP TABLE IF EXISTS `allegro_fields`;
CREATE TABLE `allegro_fields` (
  `sell_form_id` int(11) NOT NULL,
  `sell_form_title` text NOT NULL,
  `sell_form_cat` int(11) NOT NULL DEFAULT '0',
  `sell_form_type` int(11) NOT NULL,
  `sell_form_res_type` int(11) NOT NULL,
  `sell_form_def_value` int(11) NOT NULL,
  `sell_form_opt` int(11) NOT NULL,
  `sell_form_pos` int(11) NOT NULL,
  `sell_form_length` int(11) NOT NULL,
  `sell_min_value` text NOT NULL,
  `sell_max_value` text NOT NULL,
  `sell_form_desc` text NOT NULL,
  `sell_form_opts_values` text NOT NULL,
  `sell_form_field_desc` text NOT NULL,
  `sell_form_param_id` int(11) NOT NULL DEFAULT '0',
  `sell_form_param_values` text NOT NULL,
  `sell_form_parent_id` int(11) NOT NULL DEFAULT '0',
  `sell_form_parent_value` text NOT NULL,
  `sell_form_unit` text NOT NULL,
  `sell_form_options` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sell_form_id`),
  KEY `idx_categories_id` (`sell_form_cat`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `allegro_settings`;
CREATE TABLE `allegro_settings` (
  `params` varchar(100) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`params`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `allegro_settings` (`params`, `value`) VALUES ("10","2"),
("11","Włocławek"),
("12","1"),
("13","16"),
("14","33"),
("27","Dodatkowe info"),
("28","0"),
("29","0"),
("32","87-800"),
("33",""),
("34",""),
("340","24"),
("35","1"),
("4","3"),
("5","1.00"),
("9","1");

DROP TABLE IF EXISTS `allegro_shipping`;
CREATE TABLE `allegro_shipping` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(250) NOT NULL,
  `template_description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `allegro_shipping` (`id`, `template_name`, `template_description`) VALUES ("1","Podstawowy szablon wysyłek","Podstawowy, definiowalny szablon wysyłek - domyślny dla wystawianych na Allegro produktów");

DROP TABLE IF EXISTS `allegro_shipping_params`;
CREATE TABLE `allegro_shipping_params` (
  `id` int(5) NOT NULL,
  `params` varchar(100) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`,`params`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `allegro_shipping_params` (`id`, `params`, `value`) VALUES ("1","136","15.00"),
("1","137",""),
("1","138",""),
("1","139",""),
("1","140",""),
("1","141",""),
("1","142",""),
("1","143",""),
("1","144",""),
("1","145",""),
("1","146",""),
("1","147",""),
("1","148",""),
("1","149",""),
("1","150",""),
("1","151",""),
("1","152",""),
("1","153",""),
("1","154",""),
("1","155","");
INSERT INTO `allegro_shipping_params` (`id`, `params`, `value`) VALUES ("1","156",""),
("1","157",""),
("1","158",""),
("1","159",""),
("1","160",""),
("1","161",""),
("1","162",""),
("1","236","5.00"),
("1","237",""),
("1","238",""),
("1","239",""),
("1","240",""),
("1","241",""),
("1","242",""),
("1","243",""),
("1","244",""),
("1","245",""),
("1","246",""),
("1","247",""),
("1","248","");
INSERT INTO `allegro_shipping_params` (`id`, `params`, `value`) VALUES ("1","249",""),
("1","250",""),
("1","251",""),
("1","252",""),
("1","253",""),
("1","254",""),
("1","255",""),
("1","256",""),
("1","257",""),
("1","258",""),
("1","259",""),
("1","260",""),
("1","261",""),
("1","262",""),
("1","36","10.00"),
("1","37",""),
("1","38",""),
("1","39",""),
("1","40",""),
("1","41","");
INSERT INTO `allegro_shipping_params` (`id`, `params`, `value`) VALUES ("1","42",""),
("1","43",""),
("1","44",""),
("1","45",""),
("1","46",""),
("1","47",""),
("1","48",""),
("1","49",""),
("1","50",""),
("1","51",""),
("1","52",""),
("1","53",""),
("1","54",""),
("1","55",""),
("1","56",""),
("1","57",""),
("1","58",""),
("1","59",""),
("1","60",""),
("1","61","");
INSERT INTO `allegro_shipping_params` (`id`, `params`, `value`) VALUES ("1","62","");

DROP TABLE IF EXISTS `allegro_transactions`;
CREATE TABLE `allegro_transactions` (
  `allegro_transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `auction_id` varchar(64) DEFAULT NULL,
  `transaction_id` varchar(32) NOT NULL,
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `buyer_id` varchar(24) NOT NULL,
  `post_buy_form_it_quantity` decimal(6,2) NOT NULL DEFAULT '0.00',
  `post_buy_form_it_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `post_buy_form_created_date` varchar(32) DEFAULT NULL,
  `post_buy_form_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `post_buy_form_postage_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `post_buy_form_invoice_option` tinyint(1) NOT NULL DEFAULT '0',
  `post_buy_form_msg_to_seller` text,
  `billing_post_buy_form_adr_country` int(11) NOT NULL,
  `billing_post_buy_form_adr_street` varchar(64) NOT NULL,
  `billing_post_buy_form_adr_postcode` varchar(16) NOT NULL,
  `billing_post_buy_form_adr_city` varchar(64) NOT NULL,
  `billing_post_buy_form_adr_full_name` varchar(132) NOT NULL,
  `billing_post_buy_form_adr_company` varchar(132) NOT NULL,
  `billing_post_buy_form_adr_phone` varchar(32) NOT NULL,
  `billing_post_buy_form_adr_nip` varchar(32) NOT NULL,
  `billing_post_buy_form_adr_type` int(4) NOT NULL,
  `shipping_post_buy_form_adr_country` int(11) NOT NULL,
  `shipping_post_buy_form_adr_street` varchar(64) NOT NULL,
  `shipping_post_buy_form_adr_postcode` varchar(16) NOT NULL,
  `shipping_post_buy_form_adr_city` varchar(64) NOT NULL,
  `shipping_post_buy_form_adr_full_name` varchar(132) NOT NULL,
  `shipping_post_buy_form_adr_company` varchar(132) NOT NULL,
  `shipping_post_buy_form_adr_phone` varchar(32) NOT NULL,
  `shipping_post_buy_form_adr_nip` varchar(32) NOT NULL,
  `shipping_post_buy_form_adr_type` int(4) NOT NULL,
  `post_buy_form_pay_type` varchar(64) NOT NULL,
  `post_buy_form_pay_id` varchar(64) NOT NULL,
  `post_buy_form_pay_status` varchar(64) NOT NULL,
  `post_buy_form_date_init` datetime DEFAULT NULL,
  `post_buy_form_date_recv` datetime DEFAULT NULL,
  `post_buy_form_date_cancel` datetime DEFAULT NULL,
  `post_buy_form_payment_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `post_buy_form_shipment_id` varchar(254) DEFAULT NULL,
  PRIMARY KEY (`allegro_transaction_id`),
  KEY `idx_transaction_id` (`transaction_id`),
  KEY `idx_auction_id` (`auction_id`),
  KEY `idx_buyer_id` (`buyer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `banners`;
CREATE TABLE `banners` (
  `banners_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_title` varchar(64) NOT NULL,
  `banners_url` varchar(255) NOT NULL,
  `banners_image` varchar(128) NOT NULL,
  `banners_image_text` text NOT NULL,
  `banners_group` varchar(255) NOT NULL,
  `languages_id` int(11) NOT NULL,
  `banners_html_text` text,
  `banners_clicked` int(5) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `sort_order` int(3) DEFAULT NULL,
  `only_categories_id` varchar(100) NOT NULL,
  PRIMARY KEY (`banners_id`),
  KEY `idx_banners_group` (`banners_group`),
  KEY `idx_banners_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `banners_group`;
CREATE TABLE `banners_group` (
  `banners_group_id` int(11) NOT NULL AUTO_INCREMENT,
  `banners_group_code` varchar(64) NOT NULL,
  `banners_group_title` varchar(255) NOT NULL,
  PRIMARY KEY (`banners_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `banners_group` (`banners_group_id`, `banners_group_code`, `banners_group_title`) VALUES ("5","ANIMACJA_MALA","Bannery do małych animacji rozmiar 100x100"),
("7","POPUP","Bannery wyświetlane w oknie"),
("8","STATYCZNE","Bannery do środkowego modułu bannerów statycznych"),
("11","ANIMACJA_SRODKOWA","Bannery do środkowej animacji"),
("12","MALE","Małe bannery do boxu");

DROP TABLE IF EXISTS `basket_save`;
CREATE TABLE `basket_save` (
  `basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `basket_code` int(20) NOT NULL,
  `basket_name` varchar(100) NOT NULL,
  `basket_description` text NOT NULL,
  `basket_date_added` datetime DEFAULT NULL,
  PRIMARY KEY (`basket_id`),
  KEY `idx_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `basket_save_products`;
CREATE TABLE `basket_save_products` (
  `basket_products_id` int(11) NOT NULL AUTO_INCREMENT,
  `basket_id` int(11) NOT NULL,
  `products_id` varchar(150) NOT NULL,
  `basket_quantity` decimal(8,2) NOT NULL DEFAULT '0.00',
  `products_comments` text NOT NULL,
  `products_text_fields` text NOT NULL,
  PRIMARY KEY (`basket_products_id`,`basket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `blacklist`;
CREATE TABLE `blacklist` (
  `blacklist_id` int(11) NOT NULL AUTO_INCREMENT,
  `blacklist_customers_id` int(11) NOT NULL,
  `blacklist_company` varchar(256) DEFAULT NULL,
  `blacklist_nip` varchar(32) DEFAULT NULL,
  `blacklist_firstname` varchar(32) DEFAULT NULL,
  `blacklist_lastname` varchar(32) DEFAULT NULL,
  `blacklist_street_address` varchar(64) DEFAULT NULL,
  `blacklist_postcode` varchar(10) DEFAULT NULL,
  `blacklist_city` varchar(32) DEFAULT NULL,
  `blacklist_ip` varchar(100) DEFAULT NULL,
  `blacklist_email_address` varchar(100) DEFAULT NULL,
  `blacklist_telephone` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`blacklist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `categories_id` int(11) NOT NULL AUTO_INCREMENT,
  `categories_image` varchar(120) DEFAULT NULL,
  `categories_icon` varchar(120) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `sort_order` int(3) DEFAULT NULL,
  `categories_status` int(1) NOT NULL DEFAULT '1',
  `categories_view` int(1) NOT NULL DEFAULT '1',
  `categories_color` varchar(15) NOT NULL,
  `categories_color_status` int(1) NOT NULL,
  `categories_background_color` varchar(15) NOT NULL,
  `categories_background_color_status` int(1) NOT NULL,
  PRIMARY KEY (`categories_id`),
  KEY `idx_categories_status` (`categories_status`),
  KEY `idx_parent_id_cat_id` (`parent_id`,`categories_id`),
  KEY `idx_sort_order` (`sort_order`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

INSERT INTO `categories` (`categories_id`, `categories_image`, `categories_icon`, `parent_id`, `sort_order`, `categories_status`, `categories_view`, `categories_color`, `categories_color_status`, `categories_background_color`, `categories_background_color_status`) VALUES ("1","","","0","0","1","1","","0","","0"),
("2","","","0","4","1","1","","0","","0"),
("3","","","0","5","1","1","","0","","0"),
("4","","","0","6","1","1","","0","","0"),
("5","","","0","2","1","1","","0","","0"),
("6","","","0","3","1","1","","0","","0"),
("7","","","0","1","1","1","","0","","0"),
("8","","","1","0","1","1","","0","","0"),
("9","","","1","2","1","1","","0","","0"),
("12","","","1","1","1","1","","0","","0"),
("13","","","1","3","1","1","","0","","0"),
("14","","","1","5","1","1","","0","","0"),
("15","","","1","4","1","1","","0","","0"),
("16","","","1","9","1","1","","0","","0"),
("17","","","1","10","1","1","","0","","0"),
("18","","","1","6","1","1","","0","","0"),
("19","","","1","8","1","1","","0","","0"),
("20","","","1","7","1","1","","0","","0"),
("21","","","5","0","1","1","","0","","0"),
("22","","","5","1","1","1","","0","","0");
INSERT INTO `categories` (`categories_id`, `categories_image`, `categories_icon`, `parent_id`, `sort_order`, `categories_status`, `categories_view`, `categories_color`, `categories_color_status`, `categories_background_color`, `categories_background_color_status`) VALUES ("23","","","5","2","1","1","","0","","0");

DROP TABLE IF EXISTS `categories_description`;
CREATE TABLE `categories_description` (
  `categories_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `categories_name` varchar(128) NOT NULL,
  `categories_description` text,
  `categories_description_bottom` text NOT NULL,
  `categories_meta_title_tag` varchar(80) DEFAULT NULL,
  `categories_meta_desc_tag` text,
  `categories_meta_keywords_tag` text,
  `categories_seo_url` varchar(255) NOT NULL,
  `categories_info_text` text NOT NULL,
  `categories_info_name` varchar(255) NOT NULL,
  PRIMARY KEY (`categories_id`,`language_id`),
  KEY `idx_categories_id` (`categories_id`),
  KEY `idx_categories_name` (`categories_name`),
  KEY `idx_language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `categories_description` (`categories_id`, `language_id`, `categories_name`, `categories_description`, `categories_description_bottom`, `categories_meta_title_tag`, `categories_meta_desc_tag`, `categories_meta_keywords_tag`, `categories_seo_url`, `categories_info_text`, `categories_info_name`) VALUES ("1","1","Opony","Opis nad listingiem","Opis pod listingiem","","","","","",""),
("1","2","Opony","","","","","","","",""),
("2","1","Akcesoria","","","","","","","",""),
("3","1","Foteliki","","","","","","","",""),
("4","1","Pielęgnacja","","","","","","","",""),
("5","1","Felgi ATV","","","","","","","",""),
("6","1","Paski napędowe ATV","","","","","","","",""),
("7","1","Dętki","","","","","","","",""),
("8","1","Opony do samochodów osobowych","","","","","","","",""),
("9","1","Opony do samochodów 4x4 / SUV","","","","","","","",""),
("12","1","Opony do samochodów dostawczych","","","","","","","",""),
("13","1","Opony motocyklowe","","","","","","","",""),
("14","1","Opony do quadów ATV","","","","","","","",""),
("15","1","Opony do skuterów","","","","","","","",""),
("16","1","Opony dojazdowe","","","","","","","",""),
("17","1","Opony przemysłowe","","","","","","","",""),
("18","1","Opony do lawet i przyczep","","","","","","","",""),
("19","1","Opony do go-kartów","","","","","","","",""),
("20","1","Opony do samochodów ciężarowych","","","","","","","",""),
("21","1","Felgi do quadów ATV","","","","","","","","");
INSERT INTO `categories_description` (`categories_id`, `language_id`, `categories_name`, `categories_description`, `categories_description_bottom`, `categories_meta_title_tag`, `categories_meta_desc_tag`, `categories_meta_keywords_tag`, `categories_seo_url`, `categories_info_text`, `categories_info_name`) VALUES ("22","1","Nakrętki i kapsle do felg ATV","","","","","","","",""),
("23","1","Dystanse do quadów ATV","","","","","","","","");

DROP TABLE IF EXISTS `comparisons`;
CREATE TABLE `comparisons` (
  `comparisons_id` int(11) NOT NULL AUTO_INCREMENT,
  `comparisons_name` varchar(32) NOT NULL,
  `comparisons_plugin` varchar(32) DEFAULT NULL,
  `comparisons_availability` int(4) DEFAULT NULL,
  `comparisons_conditions` int(4) NOT NULL DEFAULT '1',
  `comparisons_export_type` tinyint(1) NOT NULL DEFAULT '0',
  `comparisons_export_quantity` tinyint(1) NOT NULL DEFAULT '0',
  `comparisons_last_export` datetime DEFAULT NULL,
  `comparisons_products_exported` int(11) NOT NULL DEFAULT '0',
  `comparisons_categories` text,
  `comparisons_manufacturers` text NOT NULL,
  `comparisons_extra_fields` text,
  `comparisons_name_info` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`comparisons_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO `comparisons` (`comparisons_id`, `comparisons_name`, `comparisons_plugin`, `comparisons_availability`, `comparisons_conditions`, `comparisons_export_type`, `comparisons_export_quantity`, `comparisons_last_export`, `comparisons_products_exported`, `comparisons_categories`, `comparisons_manufacturers`, `comparisons_extra_fields`, `comparisons_name_info`) VALUES ("1","Ceneo.pl","ceneo","99","0","0","0","0000-00-00 00:00:00","0","","","","1"),
("2","Nokaut.pl","nokaut","99","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("3","Okazje.info","okazje","99","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("4","Sklepy24","sklepy24","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("5","Skąpiec.pl","skapiec","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("6","Alejahandlowa.pl","pkt","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("7","Radar.pl","radar","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("8","Szoker.pl","szoker","1","0","0","0","0000-00-00 00:00:00","0","","","","1"),
("9","Smartbay.pl","smartbay","0","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("10","Kupujemy.pl","kupujemy","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("11","ToTu.pl","totu","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("12","Cenuj.pl","cenuj","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("13","Oferciak.pl","oferciak","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("16","WebePartners.pl","webepartners","1","1","0","0","0000-00-00 00:00:00","0","","","","1"),
("17","Zakupy Google","googleshopping","1","0","0","0","0000-00-00 00:00:00","0","","","","1"),
("18","StarCode XML","starcode","0","0","0","0","0000-00-00 00:00:00","0","","","","1"),
("19","aleo.pl","aleo","99","1","0","1","0000-00-00 00:00:00","0","","","","1"),
("20","Domodi.pl","domodi","99","1","0","1","0000-00-00 00:00:00","0","","","","1"),
("21","Arena.pl","arena","99","1","0","1","0000-00-00 00:00:00","0","","","","1"),
("22","Alleceny.pl","alleceny","99","1","0","1","0000-00-00 00:00:00","0","","","","1");

DROP TABLE IF EXISTS `complaints`;
CREATE TABLE `complaints` (
  `complaints_id` int(11) NOT NULL AUTO_INCREMENT,
  `complaints_rand_id` varchar(32) NOT NULL,
  `complaints_customers_id` int(12) NOT NULL DEFAULT '0',
  `complaints_customers_orders_id` int(11) NOT NULL DEFAULT '0',
  `complaints_customers_email` varchar(96) NOT NULL,
  `complaints_customers_name` varchar(255) NOT NULL,
  `complaints_customers_address` varchar(255) NOT NULL,
  `complaints_subject` varchar(96) NOT NULL,
  `complaints_status_id` int(5) NOT NULL DEFAULT '0',
  `complaints_date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `complaints_date_modified` datetime NOT NULL,
  `complaints_service` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`complaints_id`),
  KEY `idx_complaints_status_id` (`complaints_status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `complaints_status`;
CREATE TABLE `complaints_status` (
  `complaints_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `public_flag` int(11) DEFAULT '1',
  `complaints_status_default` int(1) NOT NULL,
  `complaints_status_type` int(1) NOT NULL,
  `complaints_status_color` varchar(6) NOT NULL DEFAULT '474747',
  PRIMARY KEY (`complaints_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `complaints_status` (`complaints_status_id`, `public_flag`, `complaints_status_default`, `complaints_status_type`, `complaints_status_color`) VALUES ("1","1","1","2","9C0000"),
("2","0","0","2","0000A8"),
("3","0","0","3","138501");

DROP TABLE IF EXISTS `complaints_status_description`;
CREATE TABLE `complaints_status_description` (
  `complaints_status_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `complaints_status_name` varchar(120) NOT NULL,
  PRIMARY KEY (`complaints_status_id`,`language_id`),
  KEY `idx_orders_status_name` (`complaints_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `complaints_status_description` (`complaints_status_id`, `language_id`, `complaints_status_name`) VALUES ("1","2","A complaint received"),
("3","2","Ticket closed"),
("2","2","Ticket implemented"),
("1","1","Zgłoszenie przyjęte"),
("2","1","Zgłoszenie realizowane"),
("3","1","Zgłoszenie zamknięte");

DROP TABLE IF EXISTS `complaints_status_history`;
CREATE TABLE `complaints_status_history` (
  `complaints_status_history_id` int(11) NOT NULL AUTO_INCREMENT,
  `complaints_id` int(11) NOT NULL,
  `complaints_status_id` int(11) NOT NULL,
  `date_added` datetime NOT NULL,
  `customer_notified` int(1) DEFAULT '0',
  `comments` text,
  PRIMARY KEY (`complaints_status_history_id`),
  KEY `idx_date_added` (`date_added`),
  KEY `idx_complaints_id` (`complaints_id`),
  KEY `idx_complaints_id_status_id` (`complaints_id`,`complaints_status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `countries_id` int(11) NOT NULL AUTO_INCREMENT,
  `countries_default` int(1) NOT NULL DEFAULT '0',
  `countries_iso_code_2` char(2) NOT NULL,
  `countries_iso_code_3` char(3) NOT NULL,
  PRIMARY KEY (`countries_id`),
  KEY `idx_iso_2` (`countries_iso_code_2`),
  KEY `idx_iso_3` (`countries_iso_code_3`)
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8;

INSERT INTO `countries` (`countries_id`, `countries_default`, `countries_iso_code_2`, `countries_iso_code_3`) VALUES ("13","0","AU","AUS"),
("14","0","AT","AUT"),
("21","0","BE","BEL"),
("33","0","BG","BGR"),
("38","0","CA","CAN"),
("53","0","HR","HRV"),
("55","0","CY","CYP"),
("56","0","CZ","CZE"),
("57","0","DK","DNK"),
("67","0","EE","EST"),
("72","0","FI","FIN"),
("73","0","FR","FRA"),
("81","0","DE","DEU"),
("84","0","GR","GRC"),
("97","0","HU","HUN"),
("98","0","IS","ISL"),
("103","0","IE","IRL"),
("105","0","IT","ITA"),
("117","0","LV","LVA"),
("123","0","LT","LTU");
INSERT INTO `countries` (`countries_id`, `countries_default`, `countries_iso_code_2`, `countries_iso_code_3`) VALUES ("124","0","LU","LUX"),
("132","0","MT","MLT"),
("150","0","NL","NLD"),
("160","0","NO","NOR"),
("170","1","PL","POL"),
("171","0","PT","PRT"),
("175","0","RO","ROM"),
("176","0","RU","RUS"),
("189","0","SK","SVK"),
("190","0","SI","SVN"),
("195","0","ES","ESP"),
("203","0","SE","SWE"),
("204","0","CH","CHE"),
("215","0","TR","TUR"),
("220","0","UA","UKR"),
("222","0","GB","GBR"),
("223","0","US","USA");

DROP TABLE IF EXISTS `countries_description`;
CREATE TABLE `countries_description` (
  `countries_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `countries_name` varchar(120) NOT NULL,
  PRIMARY KEY (`countries_id`,`language_id`),
  KEY `idx_countries_name` (`countries_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `countries_description` (`countries_id`, `language_id`, `countries_name`) VALUES ("13","1","Australia"),
("13","2","Australia"),
("14","1","Austria"),
("14","2","Austria"),
("21","1","Belgia"),
("21","2","Belgium"),
("33","2","Bulgaria"),
("33","1","Bułgaria"),
("38","2","Canada"),
("53","1","Chorwacja"),
("53","2","Croatia"),
("55","1","Cypr"),
("55","2","Cyprus"),
("56","2","Czech Republic"),
("56","1","Czechy"),
("57","1","Dania"),
("57","2","Denmark"),
("67","1","Estonia"),
("67","2","Estonia"),
("72","2","Finland");
INSERT INTO `countries_description` (`countries_id`, `language_id`, `countries_name`) VALUES ("72","1","Finlandia"),
("73","2","France"),
("73","1","Francja"),
("81","2","Germany"),
("84","1","Grecja"),
("84","2","Greece"),
("195","1","Hiszpania"),
("150","1","Holandia"),
("97","2","Hungary"),
("98","2","Iceland"),
("103","2","Ireland"),
("103","1","Irlandia"),
("98","1","Islandia"),
("105","2","Italy"),
("38","1","Kanada"),
("117","2","Latvia"),
("123","2","Lithuania"),
("123","1","Litwa"),
("124","1","Luksemburg"),
("124","2","Luxembourg");
INSERT INTO `countries_description` (`countries_id`, `language_id`, `countries_name`) VALUES ("132","1","Malta"),
("132","2","Malta"),
("150","2","Netherlands"),
("81","1","Niemcy"),
("160","2","Norway"),
("160","1","Norwegia"),
("170","2","Poland"),
("170","1","Polska"),
("171","2","Portugal"),
("171","1","Portugalia"),
("175","2","Romania"),
("176","1","Rosja"),
("175","1","Rumunia"),
("176","2","Russia"),
("189","2","Slovakia"),
("190","2","Slovenia"),
("195","2","Spain"),
("223","1","Stany Zjednoczone"),
("203","2","Sweden"),
("204","2","Switzerland");
INSERT INTO `countries_description` (`countries_id`, `language_id`, `countries_name`) VALUES ("204","1","Szwajcaria"),
("203","1","Szwecja"),
("189","1","Słowacja"),
("190","1","Słowenia"),
("215","1","Turcja"),
("215","2","Turkey"),
("220","1","Ukraina"),
("220","2","Ukraine"),
("222","2","United Kingdom"),
("223","2","United States"),
("97","1","Węgry"),
("222","1","Wielka Brytania"),
("105","1","Włochy"),
("117","1","Łotwa");

DROP TABLE IF EXISTS `coupons`;
CREATE TABLE `coupons` (
  `coupons_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_name` varchar(64) NOT NULL,
  `coupons_description` varchar(255) NOT NULL,
  `coupons_discount_type` enum('fixed','percent','shipping') NOT NULL DEFAULT 'percent',
  `coupons_discount_value` decimal(15,2) NOT NULL DEFAULT '0.00',
  `coupons_date_start` date DEFAULT NULL,
  `coupons_date_end` date DEFAULT NULL,
  `coupons_min_order` decimal(15,2) NOT NULL DEFAULT '0.00',
  `coupons_min_quantity` int(11) NOT NULL DEFAULT '0',
  `coupons_exclusion` varchar(20) NOT NULL,
  `coupons_exclusion_id` text NOT NULL,
  `coupons_customers_groups_id` varchar(100) NOT NULL,
  `coupons_specials` int(11) NOT NULL DEFAULT '1',
  `coupons_quantity` int(11) NOT NULL DEFAULT '1',
  `coupons_status` int(11) NOT NULL,
  `coupons_date_added` date NOT NULL,
  `coupons_email` char(255) NOT NULL,
  `coupons_pp_id` int(11) DEFAULT '0',
  PRIMARY KEY (`coupons_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `coupons_to_customers`;
CREATE TABLE `coupons_to_customers` (
  `coupons_id` varchar(32) NOT NULL,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupons_id`,`customers_id`,`orders_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `coupons_to_orders`;
CREATE TABLE `coupons_to_orders` (
  `coupons_to_orders_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_id` varchar(32) DEFAULT NULL,
  `orders_id` int(11) DEFAULT '0',
  PRIMARY KEY (`coupons_to_orders_id`),
  KEY `idx_coupons_id` (`coupons_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `currencies`;
CREATE TABLE `currencies` (
  `currencies_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) NOT NULL,
  `code` char(3) NOT NULL,
  `symbol` varchar(12) DEFAULT NULL,
  `decimal_point` char(1) DEFAULT NULL,
  `value` float(13,8) DEFAULT NULL,
  `currencies_marza` int(2) NOT NULL DEFAULT '0',
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`currencies_id`),
  KEY `idx_currencies_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `currencies` (`currencies_id`, `title`, `code`, `symbol`, `decimal_point`, `value`, `currencies_marza`, `last_updated`) VALUES ("1","Polski Złoty","PLN","zł",",","1.00000000","0","2013-11-22 19:52:30"),
("2","Euro","EUR","Euro",".","0.23812360","0","2013-11-22 19:52:30"),
("3","Dolar","USD","$",".","0.32178137","0","2013-11-22 19:52:30"),
("4","Funt brytyjski","GBP","£",".","0.19860579","0","2013-11-22 19:52:30");

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `customers_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id_private` varchar(50) NOT NULL,
  `customers_nick` varchar(30) NOT NULL,
  `customers_gender` char(1) DEFAULT NULL,
  `customers_firstname` varchar(32) NOT NULL,
  `customers_lastname` varchar(32) NOT NULL,
  `customers_dob` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `customers_email_address` varchar(96) NOT NULL,
  `customers_default_address_id` int(11) DEFAULT NULL,
  `customers_telephone` varchar(32) NOT NULL,
  `customers_fax` varchar(32) DEFAULT NULL,
  `customers_password` varchar(40) DEFAULT NULL,
  `customers_newsletter` tinyint(1) DEFAULT '0',
  `customers_newsletter_group` varchar(255) NOT NULL,
  `customers_guest_account` tinyint(4) NOT NULL DEFAULT '0',
  `customers_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customers_groups_id` int(11) NOT NULL DEFAULT '1',
  `customers_status` int(11) NOT NULL DEFAULT '0',
  `customers_agreement` tinyint(1) NOT NULL DEFAULT '0',
  `customers_przetwarzanie` tinyint(1) NOT NULL DEFAULT '0',
  `customers_polecony` int(11) NOT NULL DEFAULT '0',
  `customers_polecajacy_id` int(11) NOT NULL,
  `customers_shopping_points` int(15) NOT NULL DEFAULT '0',
  `customers_dod_info` text,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `pp_statistics` int(11) NOT NULL DEFAULT '0',
  `pp_id_customers` int(11) NOT NULL,
  `pp_code` varchar(50) DEFAULT NULL,
  `fb_id` varchar(50) NOT NULL DEFAULT '0',
  `customers_ip` varchar(100) DEFAULT NULL,
  `customers_black_list` int(1) DEFAULT '0',
  `vat_netto` int(1) NOT NULL DEFAULT '0',
  `service` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customers_id`),
  KEY `idx_customers_email_address` (`customers_email_address`),
  KEY `idx_customers_firstname` (`customers_firstname`),
  KEY `idx_customers_groups_id` (`customers_groups_id`),
  KEY `idx_customers_lastname` (`customers_lastname`),
  KEY `idx_customers_newsletter` (`customers_newsletter`),
  KEY `idx_customers_password` (`customers_password`),
  KEY `idx_customers_guest_account` (`customers_guest_account`),
  KEY `idx_customers_nick` (`customers_nick`),
  KEY `idx_customers_status` (`customers_status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `customers` (`customers_id`, `customers_id_private`, `customers_nick`, `customers_gender`, `customers_firstname`, `customers_lastname`, `customers_dob`, `customers_email_address`, `customers_default_address_id`, `customers_telephone`, `customers_fax`, `customers_password`, `customers_newsletter`, `customers_newsletter_group`, `customers_guest_account`, `customers_discount`, `customers_groups_id`, `customers_status`, `customers_agreement`, `customers_przetwarzanie`, `customers_polecony`, `customers_polecajacy_id`, `customers_shopping_points`, `customers_dod_info`, `language_id`, `pp_statistics`, `pp_id_customers`, `pp_code`, `fb_id`, `customers_ip`, `customers_black_list`, `vat_netto`, `service`) VALUES ("1","","","","Jarosław","Bednarski","0000-00-00 00:00:00","jarek@vancar.pl","1","609474949","","9a15fe9e88dcc8eb945a02d38d7f55b6:e4","1","","0","-5.00","1","1","0","0","0","0","0","","1","0","0","","0","","0","0","0");

DROP TABLE IF EXISTS `customers_account_fields`;
CREATE TABLE `customers_account_fields` (
  `customers_account_fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `customers_account_fields_type` int(1) NOT NULL,
  PRIMARY KEY (`customers_account_fields_id`),
  UNIQUE KEY `customers_account_fields_id` (`customers_account_fields_id`),
  KEY `idx_customers_id` (`customers_account_fields_id`,`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_account_fields_description`;
CREATE TABLE `customers_account_fields_description` (
  `customers_account_fields_id` int(11) NOT NULL,
  `customers_account_fields_name` varchar(255) NOT NULL,
  `customers_account_fields_text` text NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `customers_id` int(11) NOT NULL,
  UNIQUE KEY `customers_account_fields_id` (`customers_account_fields_id`,`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_basket`;
CREATE TABLE `customers_basket` (
  `customers_basket_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `products_id` tinytext NOT NULL,
  `customers_basket_quantity` decimal(8,2) NOT NULL DEFAULT '0.00',
  `products_price` decimal(15,2) NOT NULL,
  `products_price_tax` decimal(15,2) NOT NULL,
  `products_tax` decimal(15,2) NOT NULL,
  `products_weight` decimal(7,4) NOT NULL,
  `products_comments` text NOT NULL,
  `products_text_fields` text NOT NULL,
  `products_model` varchar(50) NOT NULL,
  `products_ean` varchar(32) NOT NULL,
  `customers_basket_date_added` date DEFAULT NULL,
  `price_type` char(50) NOT NULL DEFAULT 'baza',
  PRIMARY KEY (`customers_basket_id`),
  KEY `idx_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_extra_fields`;
CREATE TABLE `customers_extra_fields` (
  `fields_id` int(11) NOT NULL AUTO_INCREMENT,
  `fields_input_type` int(11) NOT NULL DEFAULT '0',
  `fields_status` tinyint(1) NOT NULL DEFAULT '0',
  `fields_required_status` tinyint(1) NOT NULL DEFAULT '0',
  `fields_order` int(5) NOT NULL DEFAULT '0',
  `fields_type` varchar(10) NOT NULL,
  PRIMARY KEY (`fields_id`),
  KEY `idx_fields_status` (`fields_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_extra_fields_info`;
CREATE TABLE `customers_extra_fields_info` (
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `languages_id` int(11) NOT NULL DEFAULT '0',
  `fields_name` varchar(255) NOT NULL,
  `fields_input_value` text,
  PRIMARY KEY (`fields_id`,`languages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_groups`;
CREATE TABLE `customers_groups` (
  `customers_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_groups_name` varchar(32) NOT NULL,
  `customers_groups_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customers_groups_price` int(11) NOT NULL DEFAULT '1',
  `customers_groups_min_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customers_groups_description` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`customers_groups_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `customers_groups` (`customers_groups_id`, `customers_groups_name`, `customers_groups_discount`, `customers_groups_price`, `customers_groups_min_amount`, `customers_groups_description`) VALUES ("1","Podstawowa","0.00","1","0.00",""),
("2","Sprzedaż hurtowa","0.00","1","0.00","");

DROP TABLE IF EXISTS `customers_info`;
CREATE TABLE `customers_info` (
  `customers_info_id` int(11) NOT NULL,
  `customers_info_date_of_last_logon` datetime DEFAULT NULL,
  `customers_info_number_of_logons` int(5) DEFAULT NULL,
  `customers_info_date_account_created` datetime DEFAULT NULL,
  `customers_info_date_account_last_modified` datetime DEFAULT NULL,
  PRIMARY KEY (`customers_info_id`),
  KEY `idx_customers_info_number_of_logons` (`customers_info_number_of_logons`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `customers_info` (`customers_info_id`, `customers_info_date_of_last_logon`, `customers_info_number_of_logons`, `customers_info_date_account_created`, `customers_info_date_account_last_modified`) VALUES ("1","2017-09-15 22:56:27","1","2017-09-15 00:07:44","2017-09-15 00:07:44");

DROP TABLE IF EXISTS `customers_points`;
CREATE TABLE `customers_points` (
  `unique_id` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `orders_id` int(11) NOT NULL DEFAULT '0',
  `reviews_id` int(11) NOT NULL DEFAULT '0',
  `points` int(15) NOT NULL DEFAULT '0',
  `points_comment` text,
  `date_added` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_confirm` datetime NOT NULL,
  `points_status` int(1) NOT NULL DEFAULT '1',
  `points_type` varchar(2) NOT NULL DEFAULT 'SP',
  PRIMARY KEY (`unique_id`),
  KEY `idx_customers_id` (`customers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_points_status`;
CREATE TABLE `customers_points_status` (
  `points_status_id` int(11) NOT NULL AUTO_INCREMENT,
  `points_status_color` varchar(6) NOT NULL DEFAULT '474747',
  PRIMARY KEY (`points_status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `customers_points_status` (`points_status_id`, `points_status_color`) VALUES ("1","E60B29"),
("2","3D3C61"),
("3","64BF5A"),
("4","5656C7"),
("5","D97338"),
("6","AD51B0");

DROP TABLE IF EXISTS `customers_points_status_description`;
CREATE TABLE `customers_points_status_description` (
  `points_status_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `points_status_name` varchar(120) NOT NULL,
  PRIMARY KEY (`points_status_id`,`language_id`),
  KEY `idx_points_status_name` (`points_status_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `customers_points_status_description` (`points_status_id`, `language_id`, `points_status_name`) VALUES ("3","1","Anulowane"),
("2","2","Approved"),
("3","2","Cancelled"),
("6","2","During the analysis"),
("1","1","Oczekujące"),
("5","2","Suspended"),
("4","2","Used"),
("6","1","W trakcie analizy"),
("1","2","Waiting"),
("4","1","Wykorzystane"),
("2","1","Zatwierdzone"),
("5","1","Zawieszone");

DROP TABLE IF EXISTS `customers_price`;
CREATE TABLE `customers_price` (
  `cp_id` int(11) NOT NULL AUTO_INCREMENT,
  `cp_groups_id` int(11) NOT NULL DEFAULT '0',
  `cp_customers_id` int(11) NOT NULL DEFAULT '0',
  `cp_products_id` int(11) NOT NULL,
  `cp_price` decimal(15,2) NOT NULL DEFAULT '0.00',
  `cp_price_tax` decimal(15,2) NOT NULL DEFAULT '0.00',
  `cp_tax` decimal(15,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`cp_id`),
  KEY `idx_cp_groups_id` (`cp_groups_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_searches`;
CREATE TABLE `customers_searches` (
  `search_id` int(10) NOT NULL AUTO_INCREMENT,
  `search_key` varchar(255) DEFAULT NULL,
  `freq` int(10) unsigned DEFAULT '0',
  `language_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`search_id`),
  KEY `lang` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_to_extra_fields`;
CREATE TABLE `customers_to_extra_fields` (
  `customers_id` int(11) NOT NULL DEFAULT '0',
  `fields_id` int(11) NOT NULL DEFAULT '0',
  `value` text,
  `language_id` int(11) NOT NULL DEFAULT '1',
  KEY `idx_customers_id` (`customers_id`),
  KEY `idx_fields_id` (`fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `customers_wishlist`;
CREATE TABLE `customers_wishlist` (
  `customers_wishlist_id` int(11) NOT NULL AUTO_INCREMENT,
  `products_id` tinytext NOT NULL,
  `customers_id` int(13) NOT NULL DEFAULT '0',
  `customers_wishlist_date_added` date DEFAULT NULL,
  PRIMARY KEY (`customers_wishlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `discount_categories`;
CREATE TABLE `discount_categories` (
  `discount_id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_name` varchar(128) NOT NULL,
  `discount_groups_id` int(11) NOT NULL DEFAULT '0',
  `discount_customers_id` int(11) NOT NULL DEFAULT '0',
  `discount_categories_id` text NOT NULL,
  `discount_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`discount_id`),
  KEY `idx_categorydiscount_groups_id` (`discount_groups_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `discount_categories_manufacturers`;
CREATE TABLE `discount_categories_manufacturers` (
  `discount_id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_name` varchar(128) NOT NULL,
  `discount_groups_id` int(11) NOT NULL DEFAULT '0',
  `discount_customers_id` int(11) NOT NULL DEFAULT '0',
  `discount_categories_id` int(11) NOT NULL DEFAULT '0',
  `discount_manufacturers_id` int(11) NOT NULL DEFAULT '0',
  `discount_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`discount_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `discount_manufacturers`;
CREATE TABLE `discount_manufacturers` (
  `discount_id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_name` varchar(128) NOT NULL,
  `discount_groups_id` int(11) NOT NULL DEFAULT '0',
  `discount_customers_id` int(11) NOT NULL DEFAULT '0',
  `discount_manufacturers_id` text NOT NULL,
  `discount_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`discount_id`),
  KEY `idx_manudiscount_groups_id` (`discount_groups_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `discount_products`;
CREATE TABLE `discount_products` (
  `discount_id` int(11) NOT NULL AUTO_INCREMENT,
  `discount_name` varchar(128) NOT NULL,
  `discount_groups_id` int(11) NOT NULL DEFAULT '0',
  `discount_customers_id` int(11) NOT NULL DEFAULT '0',
  `discount_products_id` text NOT NULL,
  `discount_discount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`discount_id`),
  KEY `idx_productsdiscount_groups_id` (`discount_groups_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `email_templates`;
CREATE TABLE `email_templates` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `template_name` varchar(128) NOT NULL,
  `template_default` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `idx_nazwa_szablonu` (`template_name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `email_templates` (`template_id`, `template_name`, `template_default`) VALUES ("1","Standardowy szablon sklepu","1"),
("4","Prosty szablon sklepu bez podpisu z obrazkiem loga","0");

DROP TABLE IF EXISTS `email_templates_description`;
CREATE TABLE `email_templates_description` (
  `template_id` int(11) NOT NULL,
  `description` text,
  `language_id` int(11) NOT NULL,
  PRIMARY KEY (`template_id`,`language_id`),
  KEY `idx_language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `email_templates_description` (`template_id`, `description`, `language_id`) VALUES ("1","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html lang=\"pl\" xml:lang=\"pl\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head>\r\n	<title>{INFO_NAZWA_SKLEPU}</title>\r\n	<meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\" />\r\n	<style type=\"text/css\">body { margin:0; padding:0; font-size:12px; font-style:normal; font-family:Arial, Tahoma, Verdana, Helvetica, sans-serif; }\r\nhtml * { margin:0; padding:0; font-size:12px; font-style:normal; font-family:Arial, Tahoma, Verdana, Helvetica, sans-serif; }\r\np { margin-bottom: 0.5em;}\r\na:link, a:visited { color: #191b1d; text-decoration: none; }\r\na:active, a:focus { text-decoration: underline; }\r\na:link:hover, a:visited:hover { text-decoration: underline; }\r\na img { border: 0; }\r\n\#page { margin:0px auto; min-width: 700px; max-width:80%; padding:10px; }\r\n\#header { border-bottom:2px solid #b91a1a; border-top:2px solid #b91a1a; margin:10px 0p 10px 0px; padding:8px; background:#5e5e5e; font-weight: normal; color: #fff; font-size: 15px; }\r\n\#cont { padding:15px; margin:10px 0px 10px 0px; background:#fcfcfc; border: 1px solid #e4e4e5; font-size:12px; font-style:normal; font-family:Arial, Tahoma, Verdana, Helvetica, sans-serif; }\r\np.grey { color: #cccccc; font-size: 0.8em; }\r\n\#footer { padding:15px; background:#f8f8f8; border: 1px solid #e4e4e5; }	\r\n\#line { height:1px; border-top:1px dotted #b91a1a; margin-top:2px }\r\n	</style>\r\n</head>\r\n<body>\r\n<div id=\"page\">\r\n<div id=\"header\">Sklep internetowy {INFO_NAZWA_SKLEPU}</div>\r\n\r\n<div id=\"cont\">{CONTENT}</div>\r\n\r\n<div id=\"footer\"><strong>{DANE_NAZWA_FIRMY_PELNA}</strong><br />\r\n{DANE_ADRES_LINIA_1}, {DANE_KOD_POCZTOWY} {DANE_MIASTO}<br />\r\nAdres email: {INFO_EMAIL_SKLEPU}<br />\r\nNIP: {DANE_NIP}<br />\r\n{DANE_NAZWA_BANKU}: {DANE_NUMER_KONTA_BANKOWEGO}</div>\r\n\r\n<div id=\"line\">&nbsp;</div>\r\n</div>\r\n</body>\r\n</html>\r\n","1"),
("1","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html lang=\"pl\" xml:lang=\"pl\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n	<head>\r\n		<title>{INFO_NAZWA_SKLEPU}</title>\r\n		<meta content=\"text/html; charset=utf-8\" http-equiv=\"Content-Type\" />\r\n		<style type=\"text/css\">\r\nbody { margin:0; padding:0; font-size:12px; font-style:normal; font-family:Arial, Tahoma, Verdana, Helvetica, sans-serif; }\r\nhtml * { margin:0; padding:0; font-size:12px; font-style:normal; font-family:Arial, Tahoma, Verdana, Helvetica, sans-serif; }\r\np { margin-bottom: 0.5em;}\r\na:link, a:visited { color: #191b1d; text-decoration: none; }\r\na:active, a:focus { text-decoration: underline; }\r\na:link:hover, a:visited:hover { text-decoration: underline; }\r\na img { border: 0; }\r\n\#page { margin:0px auto; min-width: 700px; max-width:80%; padding:10px; }\r\n\#header { border-bottom:2px solid #b91a1a; border-top:2px solid #b91a1a; margin:10px 0p 10px 0px; padding:8px; background:#5e5e5e; font-weight: normal; color: #fff; font-size: 15px; }\r\n\#cont { padding:15px; margin:10px 0px 10px 0px; background:#fcfcfc; border: 1px solid #e4e4e5; font-size:12px; font-style:normal; font-family:Arial, Tahoma, Verdana, Helvetica, sans-serif; }\r\np.grey { color: #cccccc; font-size: 0.8em; }\r\n\#footer { padding:15px; background:#f8f8f8; border: 1px solid #e4e4e5; }	\r\n\#line { height:1px; border-top:1px dotted #b91a1a; margin-top:2px }		</style>\r\n	</head>\r\n	<body>\r\n		<div id=\"page\">\r\n			<div id=\"header\">\r\n				Shop online {INFO_NAZWA_SKLEPU}</div>\r\n			<div id=\"cont\">\r\n				{CONTENT}</div>\r\n			<div id=\"footer\">\r\n				<strong>{DANE_NAZWA_FIRMY_PELNA}</strong><br />\r\n				{DANE_ADRES_LINIA_1}, {DANE_KOD_POCZTOWY} {DANE_MIASTO}<br />\r\n				Address e-mail: {INFO_EMAIL_SKLEPU}<br />\r\n				{DANE_NAZWA_BANKU}: {DANE_NUMER_KONTA_BANKOWEGO}</div>\r\n			<div id=\"line\">\r\n				 </div>\r\n		</div>\r\n	</body>\r\n</html>\r\n","2"),
("4","<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body><br />\r\n{CONTENT}</body>\r\n</html>\r\n","1"),
("4","<html>\r\n	<head>\r\n		<title></title>\r\n	</head>\r\n	<body>\r\n		<br />\r\n		<br />\r\n		{CONTENT}</body>\r\n</html>\r\n","2");

DROP TABLE IF EXISTS `email_text`;
CREATE TABLE `email_text` (
  `email_text_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_var_id` varchar(50) NOT NULL,
  `text_name` varchar(128) NOT NULL,
  `sender_name` varchar(128) NOT NULL,
  `sender_email` varchar(128) NOT NULL,
  `dw` varchar(128) NOT NULL,
  `email_group` varchar(128) NOT NULL,
  `template_id` int(1) NOT NULL DEFAULT '0',
  `email_file` varchar(256) NOT NULL,
  PRIMARY KEY (`email_text_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `email_text` (`email_text_id`, `email_var_id`, `text_name`, `sender_name`, `sender_email`, `dw`, `email_group`, `template_id`, `email_file`) VALUES ("1","EMAIL_PRZYPOMNIENIE_HASLA","Przypomnienie hasła","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile administratora","1",""),
("2","EMAIL_ZMIANA_STATUSU_ZAMOWIENIA","Zmiana statusu zamówienia","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("3","EMAIL_ZMIANA_STATUSU_REKLAMACJI","Zmiana statusu reklamacji","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("4","EMAIL_ZMIANA_STATUSU_PUNKTOW","Zmiana statusu punktów","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("5","EMAIL_DODANIE_RECZNE_PUNKTOW","Ręczna zmiana punktów","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("6","EMAIL_PRZYPOMNIENIE_HASLA_KLIENTA","Przypomnienie hasła klienta","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("7","EMAIL_REJESTRACJA_KLIENTA_KONTO_AKTYWNE","Rejestracja klienta - konto aktywne","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("8","EMAIL_REJESTRACJA_KLIENTA_KONTO_NIEAKTYWNE","Rejestracja klienta - konto nieaktywne","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("9","EMAIL_POTWIERDZENIE_EMAIL_NEWSLETTERA","Potwierdzenie subskrypcji biuletynu","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("10","EMAIL_REKLAMACJA_ZGLOSZENIE","Zgłoszenie reklamacji","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","{INFO_EMAIL_SKLEPU}","E-maile do klientów sklepu","1",""),
("11","EMAIL_ZAMOWIENIE","Nowe zamówienie","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","{INFO_EMAIL_SKLEPU}","E-maile do klientów sklepu","1",""),
("13","EMAIL_NOWY_KLIENT","Informacja o rejestracji nowego klienta","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile administratora","1",""),
("14","OPINIA_O_SKLEPIE","Opinia o sklepie","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("15","EMAIL_ZAMOWIENIE_KONTAKT","Nowe zamówienie do kontaktu","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile administratora","1",""),
("16","RECENZJA_O_PRODUKTACH","Recenzja o produktach","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("17","EMAIL_AKTYWACJA_KONTA","Aktywacja konta klienta w panelu zarządzania","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1",""),
("18","EMAIL_POWIADOMIENIE_O_PRODUKCIE","Powiadomienie o dostępności produktu","{INFO_NAZWA_SKLEPU}","{INFO_EMAIL_SKLEPU}","","E-maile do klientów sklepu","1","");

DROP TABLE IF EXISTS `email_text_description`;
CREATE TABLE `email_text_description` (
  `email_text_id` int(11) NOT NULL,
  `email_title` varchar(128) NOT NULL,
  `description` text,
  `description_sms` text,
  `language_id` int(11) NOT NULL,
  PRIMARY KEY (`email_text_id`,`language_id`),
  KEY `idx_language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `email_text_description` (`email_text_id`, `email_title`, `description`, `description_sms`, `language_id`) VALUES ("1","Link potwierdzający zmianę hasła w sklepie {INFO_NAZWA_SKLEPU}","<h3>\r\n	Zapomniałeś hasła ?</h3>\r\n<br />\r\nAby wygenerować nowe hasło kliknij w następujący link:<br />\r\n{LINK}<br />\r\n<br />\r\nJeżeli nie chcesz zmieniać hasła zignoruj tę wiadomość lub to nie Ty występowałeś o zmianę hasła poinformuj o tym obsługę sklepu.<br />\r\n<p class=\"grey\">\r\n	Ta wiadomość została wygenerowana automatycznie - nie odpowiadaj na nią</p>\r\n","","1"),
("1","The confirmation link to change your password in the store {INFO_NAZWA_SKLEPU}","<h3>\r\n	Forgot your password ?</h3>\r\n<br />\r\nClick on link to create new password:<br />\r\n{LINK}<br />\r\n<br />\r\nIf you do not want to change your password please ignore this message.<br />\r\n<p class=\"grey\">\r\n	This message was generated automatically - do not reply to it</p>\r\n","","2"),
("2","Status zamówienia Nr: {NUMER_ZAMOWIENIA} został zmieniony","<h3>\r\n	Zmiana statusu zamówienia</h3>\r\n<br />\r\nStatus zamówienia Nr: {NUMER_ZAMOWIENIA} został zmieniony. Data złożenia zamówienia: {DATA_ZAMOWIENIA}<br />\r\n<br />\r\nNowy status: {STATUS_ZAMOWIENIA}<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nSzczegóły dotyczące zamówienia : {LINK}<br />\r\n<br />\r\n<p class=\"grey\">\r\n	Jeżeli masz jakiekolwiek pytania odpowiedz na ten email.</p>\r\n","Status zamowienia : {NUMER_ZAMOWIENIA} zostal zmieniony. Nowy status : {STATUS_ZAMOWIENIA}","1"),
("2","The status of order No: {NUMER_ZAMOWIENIA} has been changed","<h3>Order Status</h3>\r\n<br />\r\nThe status of order No: {NUMER_ZAMOWIENIA} has been changed.<br />\r\n<br />\r\nThe new status: {STATUS_ZAMOWIENIA}<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nOrder details : {LINK}<br />\r\n<br />\r\nIf you have any questions please reply to this email.\r\n","Order status : {NUMER_ZAMOWIENIA} has been changed. New status : {STATUS_ZAMOWIENIA}","2"),
("3","Status reklamacji Nr: {NUMER_REKLAMACJI} został zmieniony","Status reklamacji Nr: {NUMER_REKLAMACJI} z dnia {DATA_REKLAMACJI} został zmieniony.<br />\r\n<br />\r\nNowy status: {STATUS_REKLAMACJI}<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nSzczegóły dotyczące reklamacji : {LINK}<br />\r\n<br />\r\nJeżeli masz jakiekolwiek pytania odpowiedz na ten email.","","1"),
("3","Status of complaint No {NUMER_REKLAMACJI} has been changed","Status complaint no: {NUMER_REKLAMACJI} of {DATA_REKLAMACJI} has been changed.<br />\r\n<br />\r\nNew status: {STATUS_REKLAMACJI}<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nDetails of the complaint : {LINK}<br />\r\n<br />\r\nIf you have any questions please reply to this email.","","2"),
("4","Stan Twoich punktów został zmieniony","<h3>\r\n	Zmiana stanu punktów</h3>\r\n<br />\r\nInformujemy, iż stan Twoich punktów w naszym sklepie internetowym {INFO_NAZWA_SKLEPU} został zaktualizowany.<br />\r\n<br />\r\nStatus punktów z dnia {DATA_PUNKTOW} został zmieniony.<br />\r\nNowy status: {STATUS_PUNKTOW}<br />\r\nIlość punktów: {ILOSC_PUNKTOW}<br />\r\n<br />\r\nSuma Twoich punktów w naszym sklepie to: {OGOLNA_ILOSC_PUNKTOW}.<br />\r\n<br />\r\nSzczegóły dotyczące Twojego stanu punktów oraz ich wartości kwotowej możesz sprawdzić pol zalogowaniu się na swoje konto w naszym sklepie.<br />\r\nZebrane punkty możesz wykorzystać płacąc nimi za przyszłe zamówienia w naszym sklepie.<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nJeżeli masz jakiekolwiek pytania odpowiedz na ten email.","","1"),
("4","The status of your points has been changed","<h3>\r\n	Points changed</h3>\r\n<br />\r\nPlease be advised that the state of your points in our online shop {INFO_NAZWA_SKLEPU} has been updated.<br />\r\n<br />\r\nStatus points of {DATA_PUNKTOW} has been changed.<br />\r\nNew status: {STATUS_PUNKTOW}<br />\r\nNumber of points: {ILOSC_PUNKTOW}<br />\r\n<br />\r\nTotal your points in our store is: {OGOLNA_ILOSC_PUNKTOW}.<br />\r\n<br />\r\nDetails of your state points and their total dollar value you can see half log in to your account with us.<br />\r\nThe collected points can be used by paying them for future orders in our store.<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nIf you have any questions please reply to this email.","","2"),
("5","Stan Twoich punktów został zmieniony","<h3>\r\n	Zmiana stanu punktów</h3>\r\n<br />\r\nInformujemy, iż stan Twoich punktów w naszym sklepie internetowym {INFO_NAZWA_SKLEPU} został zaktualizowany.<br />\r\n<br />\r\nTwoje konto zostało zaktualizowane o {ILOSC_PUNKTOW} pkt.<br />\r\nStatus nowych punktów: {STATUS_PUNKTOW}<br />\r\n<br />\r\nSuma Twoich punktów w naszym sklepie to: {OGOLNA_ILOSC_PUNKTOW}.<br />\r\n<br />\r\nSzczegóły dotyczące Twojego stanu punktów oraz ich wartości kwotowej możesz sprawdzić pol zalogowaniu się na swoje konto w naszym sklepie.<br />\r\nZebrane punkty możesz wykorzystać płacąc nimi za przyszłe zamówienia w naszym sklepie.<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nJeżeli masz jakiekolwiek pytania odpowiedz na ten email.","","1"),
("5","The status of your points has been changed","<h3>\r\n	Points changed</h3>\r\n<br />\r\nPlease be advised that the state of your points in our online shop {INFO_NAZWA_SKLEPU} has been updated.<br />\r\n<br />\r\nYour account has been updated with {ILOSC_PUNKTOW}.<br />\r\nStatus of new points: {STATUS_PUNKTOW}<br />\r\n<br />\r\nTotal your points in our store is: {OGOLNA_ILOSC_PUNKTOW}.<br />\r\n<br />\r\nDetails of your state points and their total dollar value you can see half log in to your account with us.<br />\r\nThe collected points can be used by paying them for future orders in our store.<br />\r\n<br />\r\n{KOMENTARZ}<br />\r\n<br />\r\nIf you have any questions please reply to this email.","","2"),
("6","Mail potwierdzający zmianę hasła w sklepie {INFO_NAZWA_SKLEPU}","<h3>\r\n	Zmiana hasła</h3>\r\n<br />\r\nNowe hasło w sklepie {INFO_NAZWA_SKLEPU} : {HASLO}<br />\r\n<br />\r\nJeżeli to nie Ty występowałeś o zmianę hasła poinformuj o tym obsługę sklepu.<br />\r\n<br />\r\n<p class=\"grey\">\r\n	Otrzymałeś tego maila, ponieważ został wypełniony formularz zmiany hasła w sklepie internetowym {INFO_NAZWA_SKLEPU}.<br />\r\n	Formularz został wysłany {BIEZACA_DATA} z komputera o adresie IP {KLIENT_IP}.<br />\r\n	Jeżeli nie wysyłałeś tego formularza, zignoruj ten list.</p>\r\n","","1"),
("6","Your new password in {INFO_NAZWA_SKLEPU}","<h3>\r\n	New password</h3>\r\n<br />\r\nNew Password in the shop {INFO_NAZWA_SKLEPU} : {HASLO}<br />\r\n<br />\r\nIf it does not you been performing to change your password, inform the service shop.<br />\r\n<br />\r\n<p class=\"grey\">\r\n	You received this email because it was filled in the password forgotten form online store {INFO_NAZWA_SKLEPU}.<br />\r\n	The form has been sent {BIEZACA_DATA} from computer with an IP address {KLIENT_IP}.<br />\r\n	If you have not you sent this form, please ignore this letter.</p>\r\n","","2"),
("7","Rejestracja konta w sklepie internetowym","<h3>\r\n	Dziękujemy za rejestrację</h3>\r\n<br />\r\nTwoje konto jest teraz aktywne. Teraz możesz kupować w naszym sklepie i korzystać z oferowanych w nim usług.<br />\r\n<br />\r\nLogin: {LOGIN}<br />\r\nHasło: {HASLO}<br />\r\n<br />\r\nLink do Twojego konta: {LINK}<br />\r\n<br />\r\nMail został wysłany do użytkownika serwisu {INFO_NAZWA_SKLEPU} zgodnie z regulaminem korzystania z <a href=\"{ADRES_URL_SKLEPU}\">serwisu</a><br />\r\n<br />\r\n<p class=\"grey\">\r\n	Otrzymałeś tego maila, ponieważ został wypełniony formularz rejestracyjny w sklepie internetowym {INFO_NAZWA_SKLEPU}.<br />\r\n	Formularz został wysłany {BIEZACA_DATA} z komputera o adresie IP {KLIENT_IP}.<br />\r\n	Jeżeli nie wysyłałeś tego formularza, zignoruj ten list.</p>\r\n","","1"),
("7","Create an Account","<h3>\r\n	Your Account Has Been Created.</h3>\r\n<br />\r\nYour account is active. You can now take advantage of member priviledges to enhance your online shopping experience with us.<br />\r\n<br />\r\nLogin: {LOGIN}<br />\r\nPass: {HASLO}<br />\r\n<br />\r\nLink to Your account: {LINK}","","2"),
("8","Rejestracja konta w sklepie internetowym","<h3>\r\n	Dziękujemy za rejestrację</h3>\r\n<br />\r\nTwoje konto jest teraz nieaktywne.<br />\r\n<br />\r\nLogin: {LOGIN}<br />\r\nHasło: {HASLO}<br />\r\n<br />\r\nAby uzyskać dostęp do zaawansowanych opcji sklepu dostępnych dla naszych partnerów prosimy o kontakt z nami ! Odpowiedź zostanie wysłana na adres podany w trakcie rejestracji.<br />\r\n<br />\r\nKonto musi zostać aktywowane przez Administratora.<br />\r\n<br />\r\nMail został wysłany do użytkownika serwisu {INFO_NAZWA_SKLEPU} zgodnie z regulaminem korzystania z <a href=\"{ADRES_URL_SKLEPU}\">serwisu</a><br />\r\n<br />\r\n<p class=\"grey\">\r\n	Otrzymałeś tego maila, ponieważ został wypełniony formularz rejestracyjny w sklepie internetowym {INFO_NAZWA_SKLEPU}.<br />\r\n	Formularz został wysłany {BIEZACA_DATA} z komputera o adresie IP {KLIENT_IP}.<br />\r\n	Jeżeli nie wysyłałeś tego formularza, zignoruj ten list.</p>\r\n","","1"),
("8","Your account has been created","<h3>\r\n	Your Account has been created</h3>\r\n<br />\r\nYour account is inactive.<br />\r\n<br />\r\nLogin: {LOGIN}<br />\r\nPass: {HASLO}<br />\r\n<br />\r\nA confirmation has been sent to the provided email address.<br />\r\n<br />\r\nYour account must be activated by us, before you can use it.","","2"),
("9","Link potwierdzający subskrypcję biuletynu {INFO_NAZWA_SKLEPU}","<h3>\r\n	Subskrypcja newslettera</h3>\r\n<br />\r\nDziękujemy za subskrypcję naszego newslettera.<br />\r\n<br />\r\nOtrzymałeś ten e-mail ponieważ Ty lub ktoś nieupoważniony podał ten adres w formularzu rejestracyjnym newslettera naszego sklepu.<br />\r\n<br />\r\nJeżeli zgadzasz się na otrzymywanie newslettera prosimy o potwierdzenie poprzez kliknięcie w {LINK} <strong>link</strong> {/LINK}","","1"),
("9","Newsletter confirmation in {INFO_NAZWA_SKLEPU","<h3>\r\n	Newsletter subscription</h3>\r\n<br />\r\nThank you for your subscription to our newsletter.<br />\r\n<br />\r\nYou received this email because you or someone unauthorized gave the email address on the registration form our store newsletter.<br />\r\n<br />\r\nIf you agree to receive the newsletter, please confirm by clicking on {LINK} <strong>link</strong> {/LINK}","","2"),
("10","Potwierdzenie zgłoszenia reklamacji","<h3>\r\n	Potwierdzenie przyjęcia zgłoszenia reklamacji</h3>\r\n<br />\r\nZgłoszenie reklamacji zostało przyjęte i zarejestrowane w naszym systemie.<br />\r\n<br />\r\nOsoba zgłaszająca: {KLIENT}<br />\r\nNumer zamówienia: {NUMER_ZAMOWIENIA}<br />\r\nNumer przyjętego zgłoszenia: {NUMER_REKLAMACJI}<br />\r\nTytuł przyjętego zgłoszenia: {TYTUL_REKLAMACJI}<br />\r\nOpis przyjętego zgłoszenia:<br />\r\n{OPIS_REKLAMACJI}<br />\r\n<br />\r\nLink do szczegółów zgłoszenia: {LINK}<br />\r\n<br />\r\nMail został wysłany do użytkownika serwisu {INFO_NAZWA_SKLEPU} zgodnie z regulaminem korzystania z <a href=\"{ADRES_URL_SKLEPU}\">serwisu</a><br />\r\n<br />\r\n<p class=\"grey\">\r\n	Otrzymałeś tego maila, ponieważ został wypełniony formularz rejestracyjny w sklepie internetowym {INFO_NAZWA_SKLEPU}.<br />\r\n	Formularz został wysłany {BIEZACA_DATA} z komputera o adresie IP {KLIENT_IP}.<br />\r\n	Jeżeli nie wysyłałeś tego formularza, zignoruj ten list.</p>\r\n","","1"),
("10","Confirmation of the complaint","<h3>	Confirmation of the complaint</h3><br />Filing a complaint has been received and registered in our system.<br /><br />The person submitting: {KLIENT}<br />Order number: {NUMER_ZAMOWIENIA}<br />The number of applications accepted: {NUMER_REKLAMACJI}<br /><br />Link to details of the notification: {LINK}<br /><br />Mail has been sent to the service user {INFO_NAZWA_SKLEPU} in accordance with the rules of use <a href=\"{ADRES_URL_SKLEPU}\">store</a><br /><br /><p class=\"grey\">	You received this email because it has been completed registration form online store {INFO_NAZWA_SKLEPU}.<br />	The form was sent {BIEZACA_DATA} a computer address IP {KLIENT_IP}.<br />	If you did not send this form, please ignore this letter.</p>","","2");
INSERT INTO `email_text_description` (`email_text_id`, `email_title`, `description`, `description_sms`, `language_id`) VALUES ("11","Nowe zamówienie Nr: {NUMER_ZAMOWIENIA}","<strong style=\"font-size:120%\">Szanowny Panie/Pani {IMIE_NAZWISKO_KUPUJACEGO}</strong><br /><br />Dziękujemy za dokonanie zakupów w naszym sklepie internetowym {INFO_NAZWA_SKLEPU}. Twoje zamówienie zostało złożone. Otrzymaliśmy je i przyjmujemy do realizacji.<br /><br /><div style=\"line-height:1.7\">	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;margin-bottom:10px\">		<strong>Numer zamówienia:</strong> {NUMER_ZAMOWIENIA}<br />		<strong>Szczegóły zamówienia:</strong> {LINK}<br />		<strong>Data zamówienia:</strong> {DATA_ZAMOWIENIA}</div>	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;margin-bottom:10px\">		<strong>Forma płatności:</strong>  {FORMA_PLATNOSCI}<br />		<font face=\"Tahoma,Arial,Verdana,serif\">{OPIS_FORMY_PLATNOSCI}</font></div>	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;margin-bottom:10px\">		<strong>Sposób wysyłki:</strong>  {FORMA_WYSYLKI}<br />		{OPIS_FORMY_WYSYLKI}</div>	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;\">		<strong>Dokument sprzedaży:</strong>  {DOKUMENT_SPRZEDAZY}</div></div><br />Na zamówienie składa się:<br /><br /><table style=\"border-collapse:collapse;border-spacing:0;border-width:1px;border-style:solid;border-color:#bdbdbd;;width:100%;\">	<tbody>		<tr>			<td style=\"padding:5px;background:#dddddd;width:50%\">				Produkt / usługa</td>			<td style=\"padding:5px;background:#dddddd;width:15%;text-align:center;\">				Nr katalogowy</td>			<td style=\"padding:5px;background:#dddddd;width:15%;text-align:center;white-space:nowrap;\">				Cena jednostkowa (brutto)</td>			<td style=\"padding:5px;background:#dddddd;width:5%;text-align:center;\">				Ilość</td>			<td style=\"padding:5px;background:#dddddd;width:15%;text-align:center;white-space:nowrap;\">				Wartość brutto</td>		</tr>		<tr>			<td colspan=\"5\">				{LISTA_PRODUKTOW}</td>		</tr>	</tbody></table><br /><div style=\"line-height:1.7\">{MODULY_PODSUMOWANIA}<br /></div><div style=\"line-height:1.2\">{LINK_PLIKOW_ELEKTRONICZNYCH}<br /><div>{KOMENTARZ_DO_ZAMOWIENIA}<br /><table style=\"border-collapse:collapse;border-spacing:0;border-width:1px;border-style:solid;border-color:#bdbdbd;width:60%;\">	<tbody>		<tr>			<td style=\"padding:5px;padding-left:10px;background:#dddddd;width:50%\">				Adres zamawiającego</td>			<td style=\"padding:5px;padding-left:10px;background:#dddddd;width:50%\">				Adres dostawy</td>		</tr>		<tr>			<td style=\"border:0px;padding:10px;line-height:1.5;border-right-width:1px;border-style:solid;border-color:#dddddd\" valign=\"top\">				{ADRES_ZAMAWIAJACEGO}</td>			<td style=\"padding:10px;line-height:1.5\" valign=\"top\">				{ADRES_DOSTAWY}</td>		</tr>	</tbody></table><br /><strong>Dodatkowe informacje:</strong><br />Treść maila stanowi potwierdzenie, że sklep otrzymał złożone przez Panią/Pana zamówienie i jest tożsama z informacją wyświetlającą się na stronie internetowej naszego sklepu. Wszystkie informacje dotyczące statusu zamówienia otrzymają Państwo e-mailem lub sms-em. <br /><br /><div style=\"font-size:80%\">	UWAGA: Ten adres został podany przez osobę dokonującą zakupów w naszym sklepie. Jeżeli to nie Ty podałeś ten adres prosimy o pilny kontakt z nami w celu anulowania transakcji.Jeśli zaś wszystkie dane transakcji się zgadzają, serdecznie dziękujemy Ci za dokonanie zakupów w naszym sklepie internetowym</div>","Nowe zamowienie : {NUMER_ZAMOWIENIA}","1"),
("11","New Order Number: {NUMER_ZAMOWIENIA}","<strong style=\"font-size:120%\">Dear Mrs/Mr {IMIE_NAZWISKO_KUPUJACEGO}</strong><br /><br />Thanks for shopping with us online! {INFO_NAZWA_SKLEPU}. Your order has been placed. Received them and accept to be implemented.<br /><br /><div style=\"line-height:1.7\">	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;margin-bottom:10px\">		<strong>Order number:</strong> {NUMER_ZAMOWIENIA}<br />		<strong>Order details:</strong> {LINK}<br />		<strong>Orde date:</strong> {DATA_ZAMOWIENIA}</div>	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;margin-bottom:10px\">		<strong>Payment:</strong>  {FORMA_PLATNOSCI}<br />		<font face=\"Tahoma,Arial,Verdana,serif\">{OPIS_FORMY_PLATNOSCI}</font></div>	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;margin-bottom:10px\">		<strong>Shipping:</strong>  {FORMA_WYSYLKI}<br />		{OPIS_FORMY_WYSYLKI}</div>	<div style=\"border-width:1px;border-style:solid;border-color:#bdbdbd;padding:5px;\">		<strong>Document:</strong>  {DOKUMENT_SPRZEDAZY}</div></div><br />The order consists of:<br /><br /><table style=\"border-collapse:collapse;border-spacing:0;border-width:1px;border-style:solid;border-color:#bdbdbd;;width:100%;\">	<tbody>		<tr>			<td style=\"padding:5px;background:#dddddd;width:50%\">				Product</td>			<td style=\"padding:5px;background:#dddddd;width:15%;text-align:center;\">				Part number</td>			<td style=\"padding:5px;background:#dddddd;width:15%;text-align:center;white-space:nowrap;\">				Price (width TAX)</td>			<td style=\"padding:5px;background:#dddddd;width:5%;text-align:center;\">				Quantity</td>			<td style=\"padding:5px;background:#dddddd;width:15%;text-align:center;white-space:nowrap;\">				Total (with TAX)</td>		</tr>		<tr>			<td colspan=\"5\">				{LISTA_PRODUKTOW}</td>		</tr>	</tbody></table><br /><div style=\"line-height:1.7\">{MODULY_PODSUMOWANIA}<br /></div><div style=\"line-height:1.2\">{LINK_PLIKOW_ELEKTRONICZNYCH}<br /><div>{KOMENTARZ_DO_ZAMOWIENIA}<br /><table style=\"border-collapse:collapse;border-spacing:0;border-width:1px;border-style:solid;border-color:#bdbdbd;width:60%;\">	<tbody>		<tr>			<td style=\"padding:5px;padding-left:10px;background:#dddddd;width:50%\">				Address</td>			<td style=\"padding:5px;padding-left:10px;background:#dddddd;width:50%\">				Shipping Address</td>		</tr>		<tr>			<td style=\"border:0px;padding:10px;line-height:1.5;border-right-width:1px;border-style:solid;border-color:#dddddd\" valign=\"top\">				{ADRES_ZAMAWIAJACEGO}</td>			<td style=\"padding:10px;line-height:1.5\" valign=\"top\">				{ADRES_DOSTAWY}</td>		</tr>	</tbody></table><br /><strong>Additional Information:</strong><br />The agreement will be considered concluded only in the case of confirmation of an order by the shop.<br /><br /><div style=\"font-size:80%\">	NOTE: This address was given by the person making the purchase in our store. If that does not address you entered is urgent, please contact us to cancel transaction. If all transaction data are correct, we thank You for shopping at our online store.</div>","New Order : {NUMER_ZAMOWIENIA}","2"),
("13","Informacja o rejestracji nowego klienta","W sklepie zarejestrował się nowy klient.<br />\r\n<br />\r\nDane klienta:<br />\r\n<strong>{DANE_KLIENTA}</strong><br />\r\n<br />\r\nAdres email: <strong>{EMAIL_KLIENTA}</strong><br />\r\n<br />\r\nCzy konto klienta jest aktywne ?: <strong>{STATUS_KLIENTA}</strong>","","1"),
("13","Information about registering a new customer","The store has registered a new customer.<br />\r\n<br />\r\nCustomer data:<br />\r\n<strong>{DANE_KLIENTA}</strong><br />\r\n<br />\r\nE-mail address: <strong>{EMAIL_KLIENTA}</strong><br />\r\n<br />\r\nIs the customer\'s account is active ?: <strong>{STATUS_KLIENTA}</strong>","","2"),
("14","Opinie o sklepie","<h3>Prośba o opinię na temat sklepu internetowego {INFO_NAZWA_SKLEPU}</h3>\r\nSzanowny Kliencie. Minęło już trochę czasu od Twoich zakupów w naszym sklepie. Chcielibyśmy poprosić Cię abyś wyraził swoją opinię na temat naszego sklepu. Wystarczy, że klikniesz w poniższy przycisk i zostaniesz przeniesiony na stronę naszego sklepu gdzie będziesz mógł wypełnić krótką ankietę. Zajmie Ci to chwilę, a Twoja opinia może być bardzo przydatna dla innych kupujących.<br />\r\n<br />\r\n<a href=\"{LINK_DO_FORMULARZA_OPINII}\"><span style=\"color:#ffffff;background-color: rgb(169, 169, 169);display:inline-block; padding:10px\">OCEŃ NASZ SKLEP</span></a><br />\r\n<br />\r\nTwoje dane na naszej stronie będą w pełni anonimowe (w tym adres email) i nie będą wyświetlane dla innych klientów.","","1"),
("14","Opinions about shop","<h3>The request for an opinion on online store {INFO_NAZWA_SKLEPU}</h3>\r\nDear Customer. It\'s been a while since your purchases in our store. We would like to ask you that you expressed your opinion on our store. Just click on the button below and you will be redirected to our online store where you can fill in a short questionnaire. The process takes a while, and feedback can be very useful for other buyers.<br />\r\n<br />\r\n<a href=\"{LINK_DO_FORMULARZA_OPINII}\"><span style=\"color:#ffffff;background-color: rgb(169, 169, 169);display:inline-block; padding:10px\">RATE OUR SHOP</span></a><br />\r\n<br />\r\nYour data on our website will be fully anonymous (including email address) and will not be shown to other customers.","","2"),
("15","Nowe zamówienie do kontaktu Nr: {NUMER_ZAMOWIENIA}","<h3>Nowe zamówienie do kontaktu.</h3>\r\n<br />\r\nImię i nazwisko: <strong>{IMIE_NAZWISKO_KLIENTA}</strong><br />\r\n<br />\r\nAdres email: <strong>{EMAIL_KLIENTA}</strong><br />\r\n<br />\r\nNumer telefonu: <strong>{TELEFON_KLIENTA}</strong><br />\r\n<br />\r\nZamówiony produkt: <strong>{NAZWA_PRODUKTU}</strong><br />\r\n<br />\r\nKomentarz do zamówienia: <strong>{KOMENTARZ_DO_ZAMOWIENIA}</strong>","","1"),
("15","New Order from Contact Number: {NUMER_ZAMOWIENIA}","<h3>New order for contact.</h3>\r\n<br />\r\nName: <strong>{IMIE_NAZWISKO_KLIENTA}</strong><br />\r\n<br />\r\nE-mail address: <strong>{EMAIL_KLIENTA}</strong><br />\r\n<br />\r\nPhone number: <strong>{TELEFON_KLIENTA}</strong><br />\r\n<br />\r\nOrdered product: <strong>{NAZWA_PRODUKTU}</strong><br />\r\n<br />\r\nComments to the order:<strong> {KOMENTARZ}</strong>","","2"),
("16","Recenzja o produktach","<h3>Prośba o wystawienie recenzji dla produktów zakupionych w sklepie {INFO_NAZWA_SKLEPU}</h3><br />Szanowny Kliencie. Dziękujemy za dokonanie zakupów w naszym sklepie. Zapraszamy Cię do wyrażenia swojej opinii na temat zakupionych produktów. Za każdą zatwierdzoną opinie przyznamy Ci {ILOSC_PKT_ZA_RECENZJE} pkt w naszym programie lojalnościowym.<br /><br />Żeby dodać opinię do zakupionych produktów skorzystaj z poniższych linków:<br /><br />{LINKI_DO_RECENZJI}","","1"),
("16","Review Product","<h3>Request for issuance of reviews for products purchased in store {INFO_NAZWA_SKLEPU}</h3><br />Dear Customer. Thank you for shopping at our store. We invite you to express its opinion on the products purchased. For every approved opinions give you {ILOSC_PKT_ZA_RECENZJE} points in our loyalty program.<br /><br />To add reviews to products purchased please use the following links:<br /><br />{LINKI_DO_RECENZJI}","","2"),
("17","Aktywacja konta","Twoje konto jest teraz aktywne. Teraz możesz kupować w naszym sklepie i korzystać z oferowanych w nim usług.<br /> <br /> Link do Twojego konta: {LINK}","","1"),
("17","Account activation","Your account is active. You can now take advantage of member priviledges to enhance your online shopping experience with us.<br /> <br /> Link to Your account: {LINK}","","2"),
("18","Powiadomienie o dostępności produktu {NAZWA_PRODUKTU}","<h3>Informacja o dostępności produktu w sklepie {INFO_NAZWA_SKLEPU} </h3> <br /> Produkt {NAZWA_PRODUKTU} jest już dostępny w naszym sklepie. <br /> <br /> Produkt można zakupić na stronie: {LINK}","","1"),
("18","Notification of the availability of the product {NAZWA_PRODUKTU}","<h3>Information about the availability of the product in the store {INFO_NAZWA_SKLEPU} </h3> <br /> Product {NAZWA_PRODUKTU} is already available in our store. <br /> <br /> The product can be purchased at: {LINK}","","2");

DROP TABLE IF EXISTS `export_configuration`;
CREATE TABLE `export_configuration` (
  `code` varchar(50) NOT NULL,
  `description` varchar(255) NOT NULL,
  `status` int(1) NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `export_configuration` (`code`, `description`, `status`) VALUES ("Akcesoria","Akcesoria dodatkowe","1"),
("Allegro","Allegro - dane do aukcji Allegro (opis, nazwa produktu, cena, zdjęcie, id kategorii Allegro)","0"),
("Cechy_produktu","Cechy produktu","1"),
("Cena_brutto","Cena brutto","1"),
("Cena_brutto_x","Pozostałe poziomy ceny brutto (jeżeli produkt ma więcej niż jedną cenę)","1"),
("Cena_katalogowa","Cena katalogowa","1"),
("Cena_katalogowa_x","Pozostałe poziomy ceny katalogowej (jeżeli produkt ma więcej niż jedną cenę)","1"),
("Cena_poprzednia","Cena poprzednia","1"),
("Cena_poprzednia_x","Pozostałe poziomy ceny poprzedniej (jeżeli produkt ma więcej niż jedną cenę)","1"),
("Cena_zakupu","Cena zakupu","1"),
("Darmowa_dostawa","Status czy produkt ma Darmową dostawę","1"),
("Dodatkowa_nazwa_produktu","Dodatkowa nazwa produktu","1"),
("Dodatkowe_pola","Dodatkowe pola opisowe produktu","1"),
("Dodatkowe_zakladki","Dodatkowe zakładki opisowe","1"),
("Dostepnosc","Dostępność produktu","1"),
("Do_porownywarek","Status czy produkt jest przesyłany Do porównywarek","1"),
("Filmy_FLV","Filmy FLV i MP4 przypisane do produktu","1"),
("Gabaryt","Gabaryt","1"),
("Gwarancja","Gwarancja produktu","1"),
("Id_produktu_magazyn","Id produktu w programie magazynowym","1");
INSERT INTO `export_configuration` (`code`, `description`, `status`) VALUES ("Ilosc_produktow","Stan magazynowy produktu","1"),
("Jednostka_miary","Jednostka miary produktu","1"),
("Kategoria","Dane kategorii do jakiej jest przypisany produkt","1"),
("Kod_ean","Kod EAN","1"),
("Kod_producenta","Kod producenta","1"),
("Kontrola_magazynu","Kontrola magazynowa produktu","1"),
("Linki","Linki produktu (zakładka Linki)","1"),
("Link_kanoniczny","Link kanoniczny produktu","0"),
("Max_ilosc_zakupu","Maksymalna ilość zakupu","1"),
("Meta_opis","Meta tagi - opis","1"),
("Meta_slowa","Meta tagi - słowa kluczowe","1"),
("Meta_tytul","Meta tagi - tytuł","1"),
("Min_ilosc_zakupu","Minimalna ilość zakupu","1"),
("Nasz_hit","Status czy produkt jest Hitem","1"),
("Nazwa_produktu","Nazwa produktu","1"),
("Negocjacja","Status czy produkt ma opcję Negocjacji ceny","1"),
("Nowosc","Status czy produkt jest Nowością","1"),
("Opis","Opis pełny produktu","1"),
("Opis_krotki","Opis krótki produktu","1"),
("Paczkomaty","Paczkomaty - gabaryt oraz ilość produktów w paczce","0");
INSERT INTO `export_configuration` (`code`, `description`, `status`) VALUES ("Pliki","Pliki produktu (zakładka Pliki)","1"),
("Pliki_elektroniczne","Pliki elektroniczne (do sprzedaży elektronicznej)","1"),
("Pliki_mp3","Pliki MP3 przypisane do produktu","1"),
("Podatek_Vat","Podatek VAT","1"),
("Polecany","Status czy produkt jest Polecany","1"),
("Producent","Producent","1"),
("Promocja","Status czy produkt jest Promocją","1"),
("Przyrost_ilosci","Przyrost ilości produktu","1"),
("Sortowanie","Sortowanie (kolejność produktu)","1"),
("Stan_produktu","Stan produktu","1"),
("Stary_URL","Adres URL do produktu w poprzednim sklepie","1"),
("Status","Status produktu (włączony/wyłączony)","1"),
("Tagi_szukania","Tagi (słowa kluczowe) wyszukiwania","0"),
("Termin_wysylki","Czas wysyłki produktu","1"),
("Waga","Waga produktu","1"),
("Waluta","Waluta","1"),
("Youtube","Filmy Youtube przypisane do produktu","1"),
("Zdjecia_dodatkowe","Dodatkowe zdjęcia produktu","1"),
("Zdjecia_url","Czy dodawać adres sklepu (link) przy zdjęciach produktów ?","0"),
("Zdjecie_glowne","Zdjęcie główne produktu","1");

DROP TABLE IF EXISTS `form`;
CREATE TABLE `form` (
  `id_form` int(4) NOT NULL AUTO_INCREMENT,
  `form_status` int(1) NOT NULL,
  `form_captcha` tinyint(1) NOT NULL DEFAULT '1',
  `form_customers_group_id` varchar(100) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_form`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `form` (`id_form`, `form_status`, `form_captcha`, `form_customers_group_id`) VALUES ("1","1","1","0"),
("2","1","1","0"),
("3","1","1","0"),
("4","1","1","0");

DROP TABLE IF EXISTS `form_description`;
CREATE TABLE `form_description` (
  `id_form` int(11) NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `form_name` varchar(255) NOT NULL,
  `form_title_email` varchar(255) NOT NULL,
  `form_text_email` text NOT NULL,
  `template_email_id` int(2) NOT NULL,
  `form_description` text NOT NULL,
  `form_email_1` varchar(100) NOT NULL,
  `form_email_name_1` varchar(150) NOT NULL,
  `form_email_2` varchar(100) NOT NULL,
  `form_email_name_2` varchar(150) NOT NULL,
  `form_email_3` varchar(100) NOT NULL,
  `form_email_name_3` varchar(150) NOT NULL,
  `form_email_4` varchar(100) NOT NULL,
  `form_email_name_4` varchar(150) NOT NULL,
  `form_email_5` varchar(100) NOT NULL,
  `form_email_name_5` varchar(150) NOT NULL,
  `form_meta_title_tag` varchar(80) NOT NULL,
  `form_meta_desc_tag` text NOT NULL,
  `form_meta_keywords_tag` text NOT NULL,
  PRIMARY KEY (`id_form`,`language_id`),
  KEY `idx_form_name` (`form_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `form_description` (`id_form`, `language_id`, `form_name`, `form_title_email`, `form_text_email`, `template_email_id`, `form_description`, `form_email_1`, `form_email_name_1`, `form_email_2`, `form_email_name_2`, `form_email_3`, `form_email_name_3`, `form_email_4`, `form_email_name_4`, `form_email_5`, `form_email_name_5`, `form_meta_title_tag`, `form_meta_desc_tag`, `form_meta_keywords_tag`) VALUES ("1","1","Kontakt","Kontakt ze sklepu okDrive.pl","","1","&nbsp;\r\n<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 500px;\">\r\n	<tbody>\r\n		<tr>\r\n			<td><strong><span style=\"font-size:16px;\">Sklep internetowy okDrive.pl</span><br />\r\n			<br />\r\n			VANCAR Jarosław Bednarski</strong><br />\r\n			ul. Prószkowska 11/10<br />\r\n			45-710 Opole<br />\r\n			NIP 7542508649<br />\r\n			<strong>tel. 609474949</strong></td>\r\n			<td style=\"text-align: right;\"><span style=\"font-size:11px;\"><strong>Adres korespondencyjny</strong><br />\r\n			Jarosław Bednarski<br />\r\n			ul. 1 Maja 5<br />\r\n			46-053 Chrząstowice</span><br />\r\n			&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n","","","","","","","","","","","Formularz kontaktowy sklepu okDrive.pl","Kontakt","kontakt"),
("1","2","Contact","Contact the shop","","1","","","","","","","","","","","","Use the contact form","Contact","Contact"),
("2","1","Zapytanie o produkt {PRODUKT}","Zapytanie o produkt","Zapytanie klienta o produkt {PRODUKT}","1","Jeżeli macie Państwo pytania dotyczące produktu zapraszamy do skorzystania z formularza. Postaramy się odpowiedzieć na Państwa pytanie w najkrótszym możliwym terminie.","","","","","","","","","","","Formularz zapytania o szczegóły produktu {PRODUKT} ","Zapytanie o produkt {PRODUKT}","kontakt, zapytaj o produkt, produkt"),
("2","2","Request a product {PRODUKT}","Request a product","Customer request for product {PRODUKT}","1","<span id=\"result_box\" lang=\"en\"><span class=\"hps\">If</span> <span class=\"hps\">you have any questions</span> <span class=\"hps\">about the product</span> <span class=\"hps\">please use</span> <span class=\"hps\">this form.</span> <span class=\"hps\">We will try to</span> <span class=\"hps\">answer your</span> <span class=\"hps\">question</span> <span class=\"hps\">as soon as possible</span><span>.</span></span>","","","","","","","","","","","Inquiry form for product details {PRODUKT}","Request a product {PRODUKT}","contact, ask about the product, the product"),
("3","1","Poleć znajomemu {PRODUKT}","Polecam Ci produkt","Pomyślałem że możesz być zainteresowany produktem {PRODUKT} ze sklepu {INFO_NAZWA_SKLEPU}. Kliknij poniżej na link, aby zobaczyć szczegóły produktu.","1","Jeżeli chcecie Państwo przesłać do swojego znajomego link do produktu {PRODUKT} zapraszamy do skorzystania z formularza. Państwa znajomy będzie mógł szybko sprawdzić produkt w naszym sklepie oraz zapoznać się z Państwa opinią.","","","","","","","","","","","Formularz polecenia znajomemu produktu {PRODUKT} ","Poleć znajomemu {PRODUKT}","kontakt, produkt, polecam znajomemu produkt"),
("3","2","Tell a friend {PRODUKT}","I recommend you a product","I thought you might be interested in the item {PRODUKT} from the store {INFO_NAZWA_SKLEPU}. Click on the link below to see the details of the product.","1","<span id=\"result_box\" lang=\"en\"><span class=\"hps\">If you want to</span> <span class=\"hps\">send</span> <span class=\"hps\">your friend</span> <span class=\"hps\">a link</span> <span class=\"hps\">to the product {PRODUKT}</span><span>, please use</span> <span class=\"hps\">this form.</span> <span class=\"hps\">Your</span> <span class=\"hps\">friend</span> <span class=\"hps\">will be able to</span> <span class=\"hps\">quickly find</span> <span class=\"hps\">a product</span> <span class=\"hps\">in our store</span><span>, and</span> <span class=\"hps\">know your</span> <span class=\"hps\">opinion.</span></span>","","","","","","","","","","","Friend request form of {PRODUKT}","Tell a friend {PRODUKT}","contact, the product, tell a friend"),
("4","1","Wyślij nam Twoją propozycję cenową {PRODUKT}","Negocjacja ceny produktu","Negocjacja ceny produktu {PRODUKT}","1","Jeżeli znaleźliście Państwo tańszą ofertę na oferowany przez nas produkt lub uważacie Państwo, że oferowana przez nas cena jest za wysoka, zachęcamy do przesłania do nas Państwa propozycji cenowej. Postaramy się odpowiedzieć na Państwa pytanie w najkrótszym możliwym terminie.","","","","","","","","","","","Formularz negocjacji ceny produktu {PRODUKT} ","Negocjuj cenę produktu {PRODUKT}","kontakt, produkt, negocjacja ceny, propozycja cenowa"),
("4","2","Send us an offer price {PRODUKT}","Negotiate the price of the product","Negotiate the price of the product {PRODUKT}","1","<span id=\"result_box\" lang=\"en\"><span class=\"hps\">If</span> <span class=\"hps\">you find</span> <span class=\"hps\">a</span> <span class=\"hps\">cheaper</span> <span class=\"hps\">offer for the</span> <span class=\"hps\">product we offer</span><span>, or</span> <span class=\"hps\">you believe</span> <span class=\"hps\">that</span> <span class=\"hps\">we offer</span> <span class=\"hps\">the price is</span> <span class=\"hps\">too high,</span> <span class=\"hps\">feel free to</span> <span class=\"hps\">send us</span> <span class=\"hps\">your</span> <span class=\"hps\">price proposal</span><span>.</span> <span class=\"hps\">We will try to</span> <span class=\"hps\">answer your</span> <span class=\"hps\">question</span> <span class=\"hps\">as soon as possible</span><span>.</span></span>","","","","","","","","","","","Your Price of {PRODUKT}","Negotiate the price of the product {PRODUKT}","contact, product, price negotiation, proposal pricing");

DROP TABLE IF EXISTS `form_field`;
CREATE TABLE `form_field` (
  `id_field` int(11) NOT NULL AUTO_INCREMENT,
  `id_form` int(4) NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `form_field_sort` int(11) NOT NULL,
  `form_field_name` varchar(255) NOT NULL,
  `form_field_typ` varchar(255) NOT NULL,
  `form_field_value` varchar(255) NOT NULL,
  `form_field_required` int(1) NOT NULL DEFAULT '0',
  `form_field_length` int(3) DEFAULT NULL,
  `form_field_input_length` int(3) NOT NULL DEFAULT '20',
  `form_field_input_limit` char(32) NOT NULL DEFAULT 'tekst',
  `form_field_email` int(1) NOT NULL DEFAULT '0',
  `form_field_email_header` int(1) NOT NULL DEFAULT '0',
  `form_field_file_type` varchar(200) NOT NULL,
  `form_field_file_size` int(5) NOT NULL,
  PRIMARY KEY (`id_field`,`id_form`,`language_id`,`form_field_sort`)
) ENGINE=InnoDB AUTO_INCREMENT=310 DEFAULT CHARSET=utf8;

INSERT INTO `form_field` (`id_field`, `id_form`, `language_id`, `form_field_sort`, `form_field_name`, `form_field_typ`, `form_field_value`, `form_field_required`, `form_field_length`, `form_field_input_length`, `form_field_input_limit`, `form_field_email`, `form_field_email_header`, `form_field_file_type`, `form_field_file_size`) VALUES ("243","3","1","1","Imię osoby polecającej","0","","1","5","20","tekst","0","0","","0"),
("244","3","1","2","Adres email osoby polecającej","0","","1","5","35","email","0","0","","0"),
("245","3","1","3","Adres e-mail znajomego","0","","1","5","35","email","1","0","","0"),
("246","3","1","4","Komentarz","1","","0","10","20","tekst","0","0","","0"),
("247","3","2","1","Name of the person recommending","0","","1","5","20","tekst","0","0","","0"),
("248","3","2","2","E-mail address recruiter","0","","1","5","35","email","0","0","","0"),
("249","3","2","3","E-mail a friend","0","","1","5","35","email","1","0","","0"),
("250","3","2","4","Comment","1","","0","10","20","tekst","0","0","","0"),
("270","4","1","1","Imię i nazwisko","0","","1","5","20","tekst","0","0","","0"),
("271","4","1","2","Adres email","0","","1","5","35","email","0","1","","0"),
("272","4","1","3","Zaproponuj swoją cenę","0","","1","1","10","waluta","0","0","","0"),
("273","4","1","4","Komentarz do propozycji ceny","1","","1","10","20","tekst","0","0","","0"),
("274","4","2","1","Name","0","","1","5","20","tekst","0","0","","0"),
("275","4","2","2","E-mail address","0","","1","5","35","email","0","1","","0"),
("276","4","2","3","Suggest a price","0","","1","10","20","waluta","0","0","","0"),
("277","4","2","4","Comment on the proposed rates","1","","1","10","20","tekst","0","0","","0"),
("278","2","1","1","Imię i nazwisko","0","","1","5","30","tekst","0","0","","0"),
("279","2","1","2","Numer telefonu","0","","0","0","20","liczby","0","0","","0"),
("280","2","1","3","Adres e-mail","0","","1","5","35","email","0","1","","0"),
("281","2","1","4","Zapytanie","1","","1","10","20","tekst","0","0","","0");
INSERT INTO `form_field` (`id_field`, `id_form`, `language_id`, `form_field_sort`, `form_field_name`, `form_field_typ`, `form_field_value`, `form_field_required`, `form_field_length`, `form_field_input_length`, `form_field_input_limit`, `form_field_email`, `form_field_email_header`, `form_field_file_type`, `form_field_file_size`) VALUES ("282","2","2","1","Name","0","","1","5","30","tekst","0","0","","0"),
("283","2","2","2","Phone Number","0","","0","0","20","liczby","0","0","","0"),
("284","2","2","3","E-mail","0","","1","5","35","email","0","1","","0"),
("285","2","2","4","Question","1","","1","10","20","tekst","0","0","","0"),
("302","1","1","1","Imię i nazwisko","0","","1","5","30","tekst","0","0","","0"),
("303","1","1","2","Numer telefonu","0","","0","0","20","tekst","0","0","","0"),
("304","1","1","3","Adres e-mail","0","","1","5","35","email","0","1","","0"),
("305","1","1","4","Treść wiadomości","1","","1","10","20","tekst","0","0","","0"),
("306","1","2","1","Name","0","","1","5","30","tekst","0","0","","0"),
("307","1","2","2","Phone Number","0","","0","0","20","tekst","0","0","","0"),
("308","1","2","3","E-mail","0","","1","5","35","email","0","1","","0"),
("309","1","2","4","Message","1","","1","10","20","tekst","0","0","","0");

DROP TABLE IF EXISTS `gallery`;
CREATE TABLE `gallery` (
  `id_gallery` int(4) NOT NULL AUTO_INCREMENT,
  `gallery_status` int(1) NOT NULL,
  `gallery_width_image` int(3) NOT NULL DEFAULT '100',
  `gallery_height_image` int(3) NOT NULL DEFAULT '100',
  `gallery_cols` int(2) NOT NULL DEFAULT '2',
  `gallery_customers_group_id` char(100) NOT NULL DEFAULT '0',
  `gallery_pages` int(1) NOT NULL DEFAULT '0',
  `gallery_pages_quantity` int(5) NOT NULL DEFAULT '10',
  PRIMARY KEY (`id_gallery`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `gallery_description`;
CREATE TABLE `gallery_description` (
  `id_gallery` int(11) NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `gallery_name` varchar(255) NOT NULL,
  `gallery_description` text NOT NULL,
  `gallery_meta_title_tag` varchar(80) NOT NULL,
  `gallery_meta_desc_tag` text NOT NULL,
  `gallery_meta_keywords_tag` text NOT NULL,
  PRIMARY KEY (`id_gallery`,`language_id`),
  KEY `idx_gallery_name` (`gallery_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `gallery_image`;
CREATE TABLE `gallery_image` (
  `id_image` int(11) NOT NULL AUTO_INCREMENT,
  `id_gallery` int(4) NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  `gallery_image` varchar(255) NOT NULL,
  `gallery_image_sort` int(11) NOT NULL,
  `gallery_image_description` text NOT NULL,
  `gallery_image_alt` varchar(255) NOT NULL,
  PRIMARY KEY (`id_image`,`id_gallery`,`language_id`,`gallery_image_sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `google_categories`;
CREATE TABLE `google_categories` (
  `categories_id` int(11) NOT NULL,
  `categories_google` text NOT NULL,
  PRIMARY KEY (`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `headertags`;
CREATE TABLE `headertags` (
  `page_id` int(11) NOT NULL DEFAULT '0',
  `page_name` varchar(64) NOT NULL,
  `page_title` varchar(255) NOT NULL,
  `page_description` varchar(255) NOT NULL,
  `page_keywords` varchar(255) NOT NULL,
  `append_default` tinyint(1) NOT NULL DEFAULT '0',
  `sortorder` tinyint(1) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`page_id`,`language_id`),
  KEY `idx_page_name` (`page_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `headertags_default`;
CREATE TABLE `headertags_default` (
  `default_title` varchar(255) NOT NULL,
  `default_description` varchar(255) NOT NULL,
  `default_keywords` varchar(255) NOT NULL,
  `default_index_title` varchar(255) NOT NULL,
  `default_index_description` varchar(255) NOT NULL,
  `default_index_keywords` varchar(255) NOT NULL,
  `og_title` varchar(255) DEFAULT NULL,
  `og_site_name` varchar(255) DEFAULT NULL,
  `og_description` text,
  `og_image` varchar(255) DEFAULT NULL,
  `language_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`default_title`,`language_id`),
  KEY `idx_language_id` (`language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `headertags_default` (`default_title`, `default_description`, `default_keywords`, `default_index_title`, `default_index_description`, `default_index_keywords`, `og_title`, `og_site_name`, `og_description`, `og_image`, `language_id`) VALUES ("Online Store","Default Description","default, keywords","Online Store","Default Description","default, keywords","","","","","2"),
("Sklep internetowy","domyślny opis strony","domyślne, słowa, kluczowe","Sklep internetowy","domyślny opis strony","domyślne, słowa, kluczowe","","","","","1");

DROP TABLE IF EXISTS `help_instruction`;
CREATE TABLE `help_instruction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` int(5) NOT NULL,
  `submenu` int(1) NOT NULL,
  `type` varchar(20) NOT NULL,
  `title` varchar(255) NOT NULL,
  `info` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=utf8;

INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("1","0","0","pytanie","Jak usunąć plik graficzny, zdjęcie - które zostało wgrane na serwer i nie jest już potrzebne ?","Dodane do produktu, kategorii, producenta zdjęcia (obrazki, grafiki) można usunąć z poziomu panelu administracyjnego sklepu używając narzędzia <strong>Przeglądarka plików</strong> która znajduje się w menu <strong>Narzędzia</strong>. Przeglądarka wyświetla listę plików które znajdują się z określonych folderach (katalogach) na serwerze. Jednym z folderów jest katalog który zawiera zdjęcia produktów o nazwie zdjęcia. Z tego poziomu można dokonać podglądu zdjęcia oraz usunąć (skasować) wybrany plik lub folder (katalog). <img alt=\"alt\" src=\"obrazki/pomoc/przegladarka_zdjec.jpg\" style=\"float:left; height:102px; margin-bottom:15px; margin-right:15px; margin-top:15px; width:600px\" />Kasowanie odbywa się poprzez kliknięcie na <strong>czerwony krzyżyk</strong> który znajduje się przy wybranym pliku lub folderze. Usunięcie pliku z serwera nie powoduje usunięcie danych o zdjęciu z produktów (jeżeli w jakimś produkcie jest odniesienie do usuwanego zdjęcia)."),
("2","0","0","pytanie","Po wybraniu strony w sklepie wyświeta się komunikat: 404 - Nie znaleziono strony","Po wprowadzeniu nowej kategorii, produktów lub innej stronie informacyjnej i próbie wejścia w nie z poziomu sklepu pojawia się komunikat: 404 - Nie znaleziono strony ..... Taka sytuacja może wystąpić w nastepujących przypadkach:\r\n<ol>\r\n	<li>\r\n		nie został wgrany plik .htaccess - w tym pliku są reguły związane z adresami SEO (plik musi znajdować się w główym katalogu sklepu)</li>\r\n	<li>\r\n		serwer nie obsługuje parametru mod_rewrite - w tym celu należy skontaktować się z administratorem serwera</li>\r\n</ol>\r\n"),
("3","0","0","pytanie","Jak włączyć znak wodny na zdjęciach ?","<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_znak_wodny.jpg\" style=\"width: 488px; height: 88px; float: left; margin-right: 15px;\" />Znak wodny wyświetlany na zdjęciach można włączyć w menu <strong> Konfiguracja / Obrazki i dokumenty / Obrazki</strong> - znak wodny. W tym menu można zdefinować poszczególne parametry znaku wodnego oraz wybrać czy ma być widoczny na wszystkich zdjęciach - czy tylko na dużych zdjęciach bądź miniaturkach zdjęć."),
("4","0","0","pytanie","Jak dodać nową promocję do sklepu ? Jak ustawić produkt jako promocyjny ?","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/promocja_listing.jpg\" style=\"float: left; margin-right: 15px; margin-bottom: 15px; height: 127px; width: 200px;\" />Produkt jako promocję można ustawić w menu <strong> Asortyment / Produkty</strong> - w liście produktów w opcjach można zaznaczyć, że produkt ma być promocją. Przy zaznaczeniu trzeba dodatkowo wpisać<strong> cenę poprzednią</strong> - jest to cena która będzie w sklepie wyświetlała się jako przekreślona (cena przed promocją). Po wpisaniu danych należy zatwierdzić dane (zapisać) wciskając na dole listy produktów przycisk Zapisz zmiany. Edytując produkt w w/w menu także można zaznaczyć, że produkt ma być wyświetlany jako promocja. Promocje w sklepie mogą mieć dodatkowo okresy ważności - daty od jakiego do jakiego czasu obowiązują.<br />\r\n<br />\r\nDla przykładu: <em>cena produktu to 100 zł brutto. Chcemy zrobić promocję produktu.<br />\r\n<br />\r\n<strong>Opcja 1. </strong>Główna cena produktu nie zmienia się. W tym przypadku wpisujemy tylko <strong>cenę poprzednią</strong> np 110 zł - jako informację jaka cena produktu była przed promocją - w sklepie przy produkcie będzie wyświetlała się cena 100 zł a nad nią przekreślona cena 110 zł<br />\r\n<br />\r\n<strong>Opcja 2.</strong> Jeżeli ma być obniżona cena produktu to trzeba zmienić cenę w pozycji <strong>cena brutto</strong> na np: 80 zł, a w pozycji <strong>cena poprzednia </strong>należy wpisać 100 zł - wtedy w sklepie przy produkcie będzie wyświetlała się cena 80 zł, a nad nią przekreślona cena 100 zł. </em><br />\r\n<br />\r\nProdukt jako promocję można także ustawić w menu <strong> Asortyment / Promocje</strong> . Jest to moduł do zarządzania promocjami w sklepie. Można utworzyć w tym miejscu nową promocję lub dokonać edycji istniejącej promocji. Można także w tym module tworzyć masowe promocje - czyli jednocześnie dla wielu produktów na raz.</div>\r\n"),
("5","0","0","pytanie","Jak ustawić produkt jako nowość ?","<img alt=\"alt\" src=\"obrazki/pomoc/promocja_listing.jpg\" style=\"float: left; margin-right: 15px; margin-bottom: 15px; width: 200px; height: 127px;\" />Produkt jako nowość można ustawić w menu <strong> Asortyment / Produkty</strong> - w liście produktów w opcjach można zaznaczyć, że produkt ma być nowością. Po zaznaczeniu które produkty mają być nowościami należy zatwierdzić dane (zapisać) wciskając na dole listy produktów przycisk Zapisz zmiany. Edytując produkt w w/w menu także można zaznaczyć, że produkt ma być wyświetlany jako nowość. Nowości w sklepie nie mają ograniczeń czasowych - produkty będą wyświetlane jako nowości dopóki nie zostanie w nich wyłączona opcja nowości."),
("6","0","0","pytanie","Jak dodać / przypisać produkt do kilku kategorii ?","<img alt=\"alt\" src=\"obrazki/pomoc/przypisane_kategorie.jpg\" style=\"width: 390px; height: 159px; margin-right: 15px; float: left;\" />Każdy produkt musi być przypisany do co najmniej jednej kategorii. Można także produkt przypisać do kliku kategorii - będzie wtedy widoczny w sklepie w kilku kategoriach. Przypisania produktu do kilku kategorii można dokonać w podczas dodawania lub edycji produktu w menu <strong> Asortyment / Produkty</strong> . W zakładce <strong>Przypisane kategorie</strong> wyświetlana jest lista dostępnych w sklepie kategorii - należy zaznaczyć do jakich kategorii ma należeć produkt."),
("7","0","0","pytanie","Czy integracja z Allegro aktualizuje stany magazynowe w sklepie ?","Tak, importowanie zamówień z Allegro do sklepu są automatycznie aktualizuje stany magazynowe produktów i cech produktów w sklepie. Sklep podczas wystawiania aukcji zapisuje jaki produkt, z jakimi parametrami został wystawiony jako aukcja i po sprzedaży aktualizuje stan magazynowy danego produktu."),
("8","1","0","instrukcja","Pierwsze kroki","<div style=\"text-align: justify;\">Niniejszy poradnik jest dedykowany wszystkim, którzy rozpoczynają swoją działalność w branży e-commerce zakładając sklep na platformie shopGold. Co jest potrzebne, aby rozpocząć sprzedaż w sklepie ? Na co zwrócić szczególną uwagę, chcąc sukcesywnie zwiększać swoje obroty ? Krótki przewodnik po programie shopGold pozwala na zapoznanie się z konfiguracją i funkcjami dostępnymi w sklepie i panelu administracyjnym.<br />\r\n<br />\r\nPo zainstalowaniu sklepu na serwerze zgodnie z opisem zamieszczonym w instrukcji instalacji, która jest zamieszczona na płycie na której jest dostarczane oprogramowanie należy wykona czynności konfiguracyjne, które umożliwiają jego personalizację oraz dostosowanie do własnych potrzeb. Wszystkie czynności konfiguracyjne można wykonać po zalogowaniu się do panelu administracyjnego sklepu.<br />\r\n<br />\r\nZastanawiając się nad konfiguracją różnych opcji w sklepie, warto pamiętać, że ciągle wśród połowy Internautów panuje ograniczone zaufanie do e-zakupów. Urządzając sklep należy zatem uczynić wszystko, by był on odbierany jako wiarygodny. Pomóc może z pewnością dbałość o odpowiedni opis działalności, regulamin czy udostępnienie różnych opcji kontaktu ze sklepem. Nie mniej ważny jest także szeroki wachlarz form płatności i dostawy.<br />\r\n<br />\r\n<strong>Regulamin</strong> jest podstawowym dokumentem, regulującym działalność sklepu internetowego. Istnienie regulaminu w sklepie internetowym jest wymagane przez obowiązujące prawo. Regulamin powinien zawierać wszystkie istotne z punktu widzenia potencjalnego Kupującego informacje. Należy także zwrócić szczególną uwagę na to, aby regulamin pozostawał w zgodzie z wszystkimi przepisami aktualnie obowiązującego prawa i nie zawierał klauzul niedozwolonych, których wykaz można znaleźć na stronach UOKIK.<br />\r\n<br />\r\n<strong>Kontakty</strong> - obok opisu działalności dobrym sprzymierzeńcem w pozyskaniu zaufania Klienta jest także informacja o formach kontaktu ze sklepem. Należy dodać tylko te opcje kontaktu, które faktycznie będą obsługiwane. Podając telefon kontaktowy, warto wpisać numer telefonu stacjonarnego, jest on bardziej wiarygodny dla Klientów.<br />\r\n<br />\r\n<strong>Formy płatności</strong> - sklep powinien obsługiwać minimum trzy najpopularniejsze formy: pobranie, przelew bankowy i płatności elektroniczne (karty kredytowe, przelewy natychmiastowe). Jeśli jest taka możliwość, sklep może udostępnić także opcję płatności gotówką przy odbiorze osobistym &ndash; ma to korzystny wpływ na budowanie jego wiarygodności w sieci. O ile do takich forma jak pobranie czy przelewy - wystarczy włączenie odpowiednich opcji w programie, o tyle w przypadku chęci korzystania z elektronicznych forma płatności konieczne jest podpisanie umowy z firmą, która takie płatności obsługuje. Program posiada możliwość integracji z takimi platformami jak PayU, DotPay, PayPal, itp. a także z serwisami umożliwiającymi obsługę płatności ratalnych.<br />\r\n<br />\r\n<strong>Formy dostawy</strong> - szeroki wachlarz form dostawy to podstawa w e-sklepie. Pozwala na uatrakcyjnienie oferty oraz minimalizuje niebezpieczeństwo, że Klienci nie znajdując interesującej ich opcji zrezygnują z zakupu. Zastanawiając się nad doborem form dostawy, warto przemyśleć udostępnienie odbioru osobistego. Potęguje ono wiarygodność<br />\r\nsklepu, pozwala zobaczyć produkt przed zakupem i zmniejszyć koszty po stronie Kupującego.</div>\r\n"),
("9","100","0","instrukcja","Kategorie produktów","<div style=\"text-align:justify;\">Każdy produkt w sklepie <u><strong>musi być przypisany do kategorii produktów</strong></u> - w sklepie nie są wyświetlane produkty, które nie należą do żadnej kategorii. Dlatego ważnym elementem sklepu, który należy zdefiniować są kategorie produktów.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/kategorie_produktow_lista.jpg\" style=\"width: 550px; height: 178px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Kategoriami produktów zarządza się w menu <strong> Asortyment / Kategorie</strong>. W module tym są wyświetlane wszystkie kategorie produktów w postaci rozwijanego drzewa. Na głównej stronie widoczne są główne kategorie produktów z opcją rozwinięcia podkategorii (pozycja <strong>Rozwiń</strong>). Kliknięcie na zieloną ikonkę z plusem powoduje rozwinięcie drzewa podkategorii dla danej głównej kategorii. Z poziomu tego menu można dodawać nowe kategorie, edytować istniejące kategorie, kasować (usuwać) lub przenosić kategorie do innych kategorii. Można także ustawić kolejność wyświetlania kategorii po stronie sklepu (pozycja <strong>Sort</strong>). Żeby ustawić odpowiednią kolejność należy wpisać w pole tekstowe odpowiednie liczby w ustalonej przez siebie kolejności, a następnie należy zatwierdzić zmianę wciskając przycisk <strong>Zapisz zmiany</strong> na dole strony.<br />\r\n<br />\r\nNad listą kategorii znajduje się ilość wszystkich kategorii oraz dane ile z nich jest aktywne, a ile pozostaje nieaktywne. W listingu kategorii w każdej pozycji jest także wyświetlana informacje ile w danej kategorii znajduje się produktów oraz ile z nich jest aktywnych. Kolumna <strong>Status</strong> określa status kategorii w sklepie - czy jest ona aktywna w sklepie czy też nie. Zielona ikonka oznacza, że kategoria jest wyświetlana w sklepie, szara, że jest nieaktywna. Zmianę aktywności (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę aktywności. Jeżeli zostaje zmieniana aktywność danej kategorii, a posiada ona podkategorie to w podkategoriach zostanie także zmieniony status na taki jak kategorii nadrzędnej. Jeżeli kategoria jest nieaktywna w sklepie nie są wyświetlane także produkty należące do tej kategorii (nawet jeżeli same mają produkt aktywnych).<br />\r\n<br />\r\nObok kolumny Status jest wyświetlana kolumna o nazwie <strong>Widoczność</strong>. Jej działanie jest zbliżone do statusu kategorii - z tą różnicą - że zmiana widoczności kategorii na nieaktywną powoduje, że dana kategoria nie jest wyświetlana w sklepie w boxie kategorii, w listingach podkategorii etc - ale w sklepie jej produkty są widoczne i można wejść bezpośrednio w daną kategorię (np linkiem bezpośrednim). Czyli opcja nie wyłącza kategorii, a tylko ukrywa jej wyświetlanie w elementach sklepu - gdzie wyświetlane są kategorie. Opcja widoczności może być przydatna np dla produktów które są dodane jako akcesoria dodatkowe, których nie można zakupić bez połączenia z innymi produktami. Zmianę widoczności kategorii (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę widoczności.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong><span style=\"color:#ff0000;\">WAŻNE</span> Usuwanie / kasowanie kategorii</strong> - z poziomu tego modułu można usunąć kategorię. Jeżeli kategoria zawiera podkategorie one również zostaną <strong>skasowane</strong> razem z wybraną kategorią. Z produktów które miały przypisaną usuwaną kategorię (lub jej podkategorie) zostaną usunięte informacje o kasowanej kategorii (jeżeli produkt miał przypisaną tylko jedną kategorię to produkt pozostanie bez kategorii i nie będzie wyświetlany w sklepie). Jeżeli zostanie zaznaczona opcja <strong>usuń całkowicie z bazy produkty przypisane do danej kategorii</strong> produkty które miały przypisaną daną kategorię (lub jej podkategorie) zostaną całkowicie usunięte z bazy. Należy ostrożnie używać opcji kasowania kategorii, gdyż nie ma opcji przywrócenia (wycofania) opcji kasowania (np tak jak w Windowsie).</div>\r\n"),
("10","0","0","pytanie","Jak usunąć ze sklepu produkty z wybranej kategorii ?","<img alt=\"alt\" src=\"obrazki/pomoc/usuniecie_produktow.jpg\" style=\"width: 550px; height: 96px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Produkty z wybranej kategorii można usunąć poprzez menu <strong>Asortyment / Produkty</strong> - po wejściu w moduł należy wybrać z <strong>drzewa kategorii</strong> po lewej stronie kategorię z której mają zostać usunięte produkty, następnie należy <strong>zaznaczyć</strong> produkty. Po tym należy wybrać opcję<strong> zaznacz wszystkie</strong> na dole ekranu oraz wybrać z opcji akcja: <strong>usuń zaznaczone produkty</strong> - po wciśnięciu <strong>Zapisz zmiany</strong> produkty zostaną usunięte. Można także skasować całą kategorię wraz z produktami w menu <strong>Asortyment / Kategorie</strong> - w tym celu po wejściu w moduł należy wcisnąć przycisk <strong>usunięcia wybranej kategorii</strong> oraz przy usuwaniu zaznaczyć opcję: <strong>usuń całkowicie z bazy produkty przypisane do danej kategorii</strong> - po zatwierdzeniu zostanie usunięta cała kategoria wraz z produktami."),
("11","110","0","instrukcja","Produkty","<div style=\"text-align:justify;\">Produkty w sklepie to jeden z najważniejszych elementów. Produktami w panelu zarządzania zarządza się poprzez menu <strong>Asortyment / Produkty</strong>. W module tym są wyświetlane wszystkie produkty w postaci listy z możliwością złożonego filtrowania - tak aby łatwo można było dodać nowy produkt lub wyszukać i zmodyfikować istniejący produkt.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W oknie po prawej stronie wyświetlane są <strong>wszystkie produkty</strong> znajdujące się w bazie sklepu. Domyślnie produkty są posortowane wg nr id nadawanego automatycznie przy dodawaniu produktu do bazy sklepu. W oknie po lewej stronie wyświetlane są <strong>kategorie produktów</strong>. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko produkty z danej kategorii. Powyżej okien z produktami i kategoriami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych produktów które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii produktów - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania produktów w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowego produktu który otwiera formularz dodawania nowego produktu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkt.jpg\" style=\"width: 580px; height: 264px; margin-bottom: 15px; margin-right: 15px; float: left;\" />W liście produktów każdy produkt jest wyświetlany w osobnym wierszu. Pierwsza kolumna umożliwia zaznaczenie produktu (kilku produktów z listy) i dokonanie na nich określonej operacji, np. usunięcia - zadanie do wykonania można wybrać na dole listy produktów, a zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Kolejna kolumna to id produktu - nr id jest nadawany automatycznie przez sklep podczas dodawania produktu do bazy. Jest on zawsze unikalny. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu, kategorie do jakich produkt jest przypisany, nr katalogowy oraz nazwa producenta. Korzystając z górnych filtrów można wyświetlić w liście np. produkty tylko określonego producenta i wykonać na nich określone operacje - np wszystkie ustawić jako nowości. Kolejna kolumna produktu umożliwia szybką zmianę cen - można ustawić główną cenę produktu oraz cenę poprzednią (cena wyświetlana w sklepie jako przekreślona jeżeli produkt jest ustawiony jako promocja). Ikonka HOT obok ceny oznacza, że produkt jest promocją. Dodatkowo pod polem zmiany ceny produktu jest wyświetlana informacja o stawce podatku VAT jaka jest przypisana do produktu oraz waluta w jakiej podana jest cena produktu. Jeżeli produkt ma włączoną możliwość kupowania za punkty to dodatkowo jest wyświetlana (na niebieskim tle) jego cena w punktach. Po wpisaniu nowych wartości cen - zatwierdzenie następuje poprzez naciśnięcie przycisku <strong>Zapisz zmiany</strong> na dole strony. Poprzez taką edycję można zmienić jednorazowo ceny w kilku produktach w listingu - nie trzeba za każdym razem zapisywać po kolei produktów oraz wchodzić w szczegóły edycji produktu. Kolejna kolumna to opcje jakie może posiadać produkt. Dla przykładu można zaznaczyć, że produkt ma być nowością lub promocją (jeżeli zostanie zaznaczona promocja dodatkowo należy wpisać cenę poprzednią - bez tego produkt nie będzie wyświetlany jako promocja). Zmiany zatwierdza się podobnie jak przy zmianie cen przyciskiem <strong>Zapisz zmiany</strong> na dole strony. Kolejna kolumna to ilość produktu w magazynie - wyświetlana jest całkowita ilość produktu (łącznie z cechami jeżeli mają włączony stan magazynowy). Następna kolumna wyświetla pole do wpisania numeru sortowania - wpisując odpowiednie wartości można ustawić kolejność wyświetlania produktów w sklepie. W kolejnej kolumnie zaznaczone jest czy produkt jest aktywny czy wyłączony. Tą wartość także można zmienić odznaczając lub zaznaczając pole wyboru. Zmiany z dwóch ostatnich kolumn zatwierdza się przyciskiem <strong>Zapisz zmiany</strong> na dole strony. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję produktu, usunięcie, podgląd produktu w sklepie, duplikowanie produktu (zostanie z produktu stworzona identyczna kopia) oraz możliwość wystawienia produktu na Allegro (do wystawiania produktów należy najpierw zalogować się do Allegro).<br />\r\n<br />\r\nJedna z ikon nawigacyjnych umożliwia skopiowanie parametrów danego produktu do innych produktów. Po kliknięciu w ikonę zostanie otworzona dodatkowa podstrona - na której można wybrać jakie opcje produktu mają być kopiowane. Po wyborze zakresu kopiowania danych należy wybrać do jakich produktów mają być skopiowane dane z produktu źródłowego. Dzięki tej opcji można skopiować np ustawienia cech produktu czy pól opisowych do innych produktów (bez konieczności edycji np cech w każdym produkcie z osobna).<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"al\" src=\"obrazki/pomoc/produkt_ikona_allegro.jpg\" style=\"width: 420px; height: 194px; margin-bottom: 15px; margin-left: 15px; float: right;\" />W liście produktów w kolumnie w której wyświetlana jest nazwa produktu może być wyświetlana ikona (logo) allegro. Jeżeli taka ikona jest wyświetlana oznacza to, że dany produkt został wystawiony w serwisie Allegro i posiada aktywne aukcje. Po najechaniu kursorem myszy na logo allegro zostanie wyświetlone okno z danymi aukcji produktu. Wyświetlona tabelka zawiera: numer aukcji (który jest linkiem bezpośrednim do aukcji w Allegro), cechy z jakimi został wystawiony produkt do sprzedaży w Allegro (jeżeli produkt nie posiada cech będzie wyświetlany znak minusa), datę zakończenia aukcji oraz ilość sprzedanych przedmiotów. Jeżeli dany produkt ma wystawione więcej aukcji - wszystkie będą wyświetlone w tabeli. Powyżej tabeli wyświetlana jest informacja na jaki dzień dane są aktualne. Aktualność danych zależy od ostatniej synchronizacji z systemem Allegro, którą przeprowadza się w menu <strong>Integracje / Allegro / Zarządzanie aukcjami</strong> - przycisk na dole strony <strong>Pobierz aktualne dane o aukcjach z Allegro</strong>.<br />\r\n<br />\r\n<img alt=\"al\" src=\"obrazki/pomoc/produkt_ikona_szybkiej_edycji_form.jpg\" style=\"width: 220px; height: 246px; margin-bottom: 15px; margin-left: 15px; float: right;\" /><img alt=\"al\" src=\"obrazki/pomoc/produkt_ikona_szybkiej_edycji.jpg\" style=\"width: 300px; height: 132px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Jeżeli zachodzi potrzeba szybkiej edycji nazwy produktu, numeru katalogowego czy zmiany producenta produktu można dokonać takiej edycji bez wchodzenia w szczegółową edycję produktu. Po kliknięciu w ikonę zaznaczoną na obrazku po lewej stronie zostanie wyświetlony formularz gdzie szybko można dokonać zmiany podstawowych parametrów produktu. W ten sposób można zmienić nazwę produktu, nr katalogowy, nr producenta, zmienić producenta produktu lub główne zdjęcie produktu. Zapisanie danych odbywa się poprzez wciśnięcie przycisku <strong>Zapisz dane</strong> znajdującego się nad polami edycji.</div>\r\n"),
("12","111","1","instrukcja","Dodawanie / edycja - zakładka Podstawowe dane","<div style=\"text-align:justify;\"><img alt=\"\" src=\"obrazki/pomoc/zakladki_produktu.jpg\" style=\"float: left; margin-right: 15px; margin-bottom: 15px; width: 450px; height: 355px;\" />W trybie edycji czy dodawania produktu dane o produkcie wyświetlane są w formie zakładek. Przełączając między zakładkami z lewej strony można wprowadzić poszczególne pozycje produktu. Pierwsza główna zakładka produktu to <strong>Podstawowe dane</strong>. Zawiera ona podstawowe dane produktu w tym nazwę produktu i cenę. Poszczególne pozycje zakładki definiują wyświetlanie produktu w sklepie oraz jego właściwości. Z poziomu zakładki można ustawić pozycje:<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Nazwa produktu</strong> - tekst określający nazwę produktu jaka będzie wyświetlana w sklepie. Tekst należy wprowadzić we wszystkich językach jakie są włączone w sklepie - przełączenie na inną wersję językową następuje poprzez kliknięcie na zakładkę z nazwą języka. Pole nazwy produktu jest obowiązkowe. Jeżeli nie zostanie uzupełniona nazwa produktu w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\n<strong>Dodatkowa nazwa</strong> - jest to dodatkowy tekst do nazwy produktu. Tekst nie jest wyświetlany w sklepie przy nazwie produktu. Jest dodawany do nazwy produktu np przy eksporcie do porównywarek. Tekst może być dowolny - np Szybka Wysyłka !! Dostawa tylko 10 zł. Dodatkowa nazwa ma za zadanie uatrakcyjnić nazwę produktu dla potencjalnego klienta. Pole dodatkowej nazwy nie jest obowiązkowe do wypełnienia.<br />\r\n<br />\r\n<strong>Czy produkt jest aktywny ?</strong> - umożliwia wyłączenie produktu. Jeżeli zostanie zaznaczona opcja <strong>nie</strong> to produkt nie będzie widoczny po stronie sklepu. Produkt będzie dalej można wyszukać i edytować w panelu zarządzania sklepu ale nie będzie widoczny dla klientów sklepu.<br />\r\n<br />\r\n<strong>Rodzaj produktu</strong> - ta opcja umożliwia określenie rodzaju oferowanego produktu. Do wyboru są 4 możliwości: standardowy, niestandardowy, usługa oraz treść cyfrowa. Wybór rodzaju produktu jest istotny przy realizacji zamówienia klienta. W zależności od wybranego rodzaju produktu w ostatnim kroku zamówienia klient będzie musiał wyrazić dodatkową zgodę na realizację zamówienia.<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/zakladki_produktu_rodzaj_produktu.jpg\" style=\"float: left; margin-right: 15px; margin-bottom: 15px; margin-top: 15px; width: 400px; height: 368px;\" /><br />\r\nRodzaj produktu <strong>Standardowy</strong> - dotyczy wszystkich gotowych produktów, oferowanych w standardowej formie, np: odzież, sprzęt elektroniczny, AGD i inne produkty, które nie są tworzone na indywidualne zamówienie klienta. Przy takim rodzaju produktu, klient ma prawo zwrócić zakupiony towar zgodnie z ustawą w określonym czasie i podczas procesu składania zamówienia nie jest wymagana dodatkowa informacja - wystarczy akceptacja regulaminu sklepu.<br />\r\n<br />\r\nRodzaj produktu <strong>Niestandardowy</strong> - dotyczy produktów niestandardowych, niefabrykowanych, wyprodukowanych według specyfikacji klienta czyli produktów przygotowanych na specjalne zamówienie klienta, które posiadają indywidualne, unikalne zamówione przez klienta cechy / parametry. Jeżeli w koszyku będzie znajdował się produkt z takim rodzajem zostanie dodatkowo wyświetlona informacja&nbsp;dotycząca utraty prawa odstąpienia od umowy po dostarczeniu produktu. Klient będzie musiał wyrazić zgodę aby móc zrealizować zamówienie.<br />\r\n<br />\r\nRodzaj produktu <strong>Usługa</strong> - dotyczy produktów, które są usługą - czyli nie mają materialnej postaci, która może być wysyłana do klienta i którą klient może zwrócić. Jeżeli do koszyka zostanie dodany taki produkt, to klient musi wyrazić zgodę na rozpoczęcie świadczenia usługi przed upływem ustawowego terminu zwrotu produktu, w trakcie którego klient nie będzie miał możliwości odstąpienia od umowy. Zabezpiecza to właściciela sklepu przez żądaniem zwrotu w przypadku jeżeli usługa została już wykonana, a nie minął jeszcze ustawowy termin dotyczący możliwości zwrotu zakupionego towaru.<br />\r\n<br />\r\nRodzaj produktu <strong>Treść cyfrowa</strong> - podobnie jak w przypadku usług, produkt nie ma postaci materialnej, którą można wysłać klientowi i którą klient może ewentualnie zwrócić. Produkt jest dostępny w formie elektronicznej, np: plik mp3, film z kursem czy inna treść niematerialna przekazywana w formie elektronicznej. Jeżeli do koszyka zostanie dodany taki produkt, to klient musi wyrazić zgodę na dostarczenie treści cyfrowych oraz brak możliwości odstąpienia od umowy. Zabezpiecza to właściciela sklepu przed żądaniem zwrotu w przypadku jeżeli towar został już dostarczony klientowi, a nie minął jeszcze ustawowy termin dotyczący możliwości zwrotu zakupionego towaru.<br />\r\n<br />\r\nZaznaczanie w/w opcji (rodzajów) nie jest konieczne, wszystkie produkty w sklepie mogą mieć opcję Standardowy - taki rodzaj jest przyjmowany jako domyślny dla wszystkich produktów - jednak w przypadku produktów innych niż standardowe właściciel sklepu może poprzez odpowiedni wybór rodzaju produktu dodatkowo zabezpieczyć się przed ewentualnym zwrotem towarów.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\n<strong>Czy produkt można kupować ?</strong> - funkcja umożliwia wyłączenie opcji kupowania produktu - produkt będzie wyświetlany w sklepie ale nie będzie można go kupić.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/produkt_tylko_za_pkt.jpg\" style=\"float: right; margin-left: 15px; margin-bottom: 15px; margin-top: 15px; width: 180px; height: 143px;\" /><strong>Czy produkt będzie można kupić tylko za punkty ?</strong> - funkcja umożliwia włączenie kupowania produktu za punkty. Jest ona powiązana z Systemem punktów, który konfiguruje się w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia systemu punktów</strong>. Produkt będzie można kupić w sklepie za punkty tylko jeżeli będzie włączony system punktów. Jeżeli system punktów będzie wyłączony lub dostępny tylko dla wybranych grup klientów produkt w sklepie będzie się wyświetlał w normalnej cenie. Zaznaczenie opcji kupowania produktu za punkty - na <strong>tak</strong> - spowoduje wyświetlenie poniżej tej opcji dodatkowych pól gdzie należy wpisać wartość produktu w punktach oraz stałą wartość kwotową. Produkt nie może być dostępny tylko za same punkty - na jego wartość składa się ilość punktów oraz stała wartość kwotowa np 1 grosz, która będzie widoczna na dokumentach sprzedaży - np fakturze. Jeżeli w produkcie zostanie włączona opcja kupowania za punkty to w sklepie w miejscu ceny produktu będzie wyświetlana ilość punktów oraz wartość kwotowa (jak na obrazku obok). Klient może w sklepie kupować takie produkty jeżeli posiada na swoim koncie wystarczającą ilość punktów. Jeżeli doda do koszyka produkty o wartości punktowej większej niż zgromadzona przez niego ilość punktów w miejscu przycisku <strong>Do kasy</strong> - będzie wyświetlony komunikat o braku wystarczającej ilości punktów do złożenia zamówienia. Jeżeli produkt posiada cechy - i cechy mają wartości kwotowe lub procentowe - to po włączeniu opcji zakupu za punkty wartości te nie są uwzględniane przy produkcie w sklepie oraz wyświetlane na karcie produktu. Produkt ma stałą cenę w pkt niezależnie od wybranej opcji - nie można definiować różnych cen w punktach dla różnych cech produktu. Dla takiego produktu nie jest także dostępna po stronie sklepu opcja negocjacji ceny.<br />\r\n<br />\r\n<strong>Czy produkt ma mieć kontrolę stanu magazynowego ?</strong> - funkcja ta umożliwia wyłączenie kontroli stanu magazynowego danego produktu. Jeżeli w sklepie jest włączona kontrola stanu magazynowego produktów (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu</strong>) to wszystkie produkty w sklepie są objęte kontrolą magazynową przy sprzedaży w sklepie. Oznacza to, że klienci nie mogą zakupić danego produktu więcej niż jest go aktualnie na stanie. Wyłączenie kontroli stanu magazynowego dla danego produktu, umożliwia wyłączenie go z ogólnego systemu kontroli magazynu, dzięki czemu klienci będą mogli kupować dowolne ilości danego produktu.<br />\r\n<br />\r\n<strong>Czy produkt będzie dostępny tylko jako akcesoria dodatkowe ?</strong> - funkcja umożliwia zaznaczeni, że dany produkt będzie dostępny w sklepie tylko jako akcesoria dodatkowe. Jeżeli zostanie wybrana opcja - <strong>tak</strong> - to produktu nie będzie można w sklepie zakupić jako samego produktu. Będzie on dostępny tylko w powiązaniu z innymi produktami dla których będzie przypisany jako <strong>akcesoria dodatkowe</strong> w menu <strong>Asortyment / Akcesoria dodatkowe</strong>.<br />\r\n<br />\r\n<strong>Produkt niewidoczny dla grupy</strong> - umożliwia <strong>wyłączenie</strong> widoczności produktu dla określonej grupy klientów - klienci przypisani grupy NIE będą po zalogowaniu widzieli produktu.</div>\r\n<br />\r\n<strong>Kolejność wyświetlania</strong> - ustawia kolejność wyświetlania w listingu kategorii.<br />\r\n<br />\r\n<strong>Data dodania</strong> - określa datę dodania produktu do sklepu. Data jest używana przy określaniu czy produkt jest nowością (w zależności od ustawień w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia produktów</strong>).<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Nr katalogowy, Kod producenta, Kod EAN, PKWIU</strong> - dane identyfikujące produkt - nr katalogowy musi być unikalny jeżeli w sklepie będzie używana opcja importu / eksportu plików csv / xml - po numerze katalogowym identyfikowany jest produkt i każdy numer musi być unikalny.<br />\r\n<br />\r\n<strong>Id produktu w programie magazynowym</strong> - unikalny id produktu w zewnętrznym programie magazynowym lub fakturującym. Pole może być użyte do powiązania sklepu z programem magazynowym / fakturującym w którym produkty mają inne id niż w sklepie.</div>\r\n<br />\r\n<strong>Waga produktu</strong> - jest istotna przy obliczaniu kosztów wysyłki dla wysyłek bazujących na wadze produktu.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Dostępny od dnia</strong> - można ustawić datę od jakiej produkt będzie dostępny - jest to tylko informacja - nie wyłącza automatycznie opcji zakupu produktu - produkty z datą dostępności są wyświetlane w module - wkrótce w ofercie.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Producent</strong> - umożliwia przypisanie do produktu określonego producenta, po wybraniu w sklepie przez klienta producenta zostaną wyświetlone wszystkie produkty do których producent był przypisany. Producentów definiuje się w menu <strong>Asortyment / Producenci</strong>.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Stan dostępności</strong> - przypisuje do produktu dostępność produktu - dostępność może być stała lub automatyczna. Przypisanie do produktu stałej dostępności powoduje, że niezależnie od stanu magazynowego produkt ma zawsze wyświetlaną tą samą dostępność. Dostępność automatyczna powoduje, że zależnie od stanu magazynowego dostępność jest różna. Dostępności produktów definiuje się w menu <strong> Konfiguracja / Słowniki / Dostępności produktów</strong>.</div>\r\n<br />\r\n<strong>Wysyłka</strong> - określa w jakim czasie produkt będzie wysłany do klienta - wartość wyświetlana jest na karcie produktu oraz w podsumowaniu zamówienia (w liście produktów dodanych przez klienta do koszyka). Dostępne czasy wysyłek definiuje się w menu <strong>Konfiguracja / Słowniki / Terminy wysyłek</strong>.<br />\r\n<br />\r\n<strong>Stan produktu</strong> - określa stan produktu - standardowo w sklepie są dodane trzy stany produktu: nowy, używany oraz regenerowany. Dodatkowe stany produktu można zdefiniować w menu <strong>Konfiguracja / Słowniki / Stan produktów</strong>. Stan produktu wyświetlany jest na karcie produktu oraz w podsumowaniu zamówienia (w liście produktów dodanych przez klienta do koszyka).<br />\r\n<br />\r\n<strong>Gwarancja</strong> - umożliwia przypisanie do produktu informacji o gwarancji udzielanej na produkt. Dostępne gwarancje definiuje się w menu <strong>Konfiguracja / Słowniki / Gwarancje produktów</strong>. Informacja o gwarancji wyświetlana jest na karcie produktu oraz w podsumowaniu zamówienia (w liście produktów dodanych przez klienta do koszyka). Informacja o gwarancji może być także linkiem np do pliku pdf z gwarancją danego produktu lub do strony informacyjnej zawierającej informacje o warunkach gwarancji.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Ilość w magazynie</strong> - określa całkowitą ilość magazynową produktu (jeżeli w sklepie włączona jest kontrola stanu magazynowego cech - menu <strong> Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu</strong>) to liczba określa sumę stanów magazynowych poszczególnych cech - jest ona obliczana automatycznie przy zapisie na podstawie sumy cech. Jeżeli kontrola stanu cech jest wyłączona wartość można uzupełnić ręcznie.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Jednostka miary</strong> - określa nazwę jednostki miary w jakiej jest sprzedawany produkt. Wybranie odpowiedniej jednostki miary umożliwia zakup produktów w ilościach całkowitych lub ułamkowych. Np 1 szt komputera lub 0.5 kg jabłek. Jednostki miary definiuje się w menu <strong> Konfiguracja / Słowniki / Jednostki miary</strong> . Przy definiowaniu jednostki miary określa się czy można dokonywać zakupu na ułamki czy tylko wartości całkowite.</div>\r\n<br />\r\n<strong>Minimalna ilość zakupu</strong> - określa ilość produktu jaką klient może zakupić minimalnie - jeżeli pole jest puste standardowo przyjmowana jest wartość 1.<br />\r\n<br />\r\n<strong>Maksymalna ilość zakupu</strong> - określa maksymalną ilość produktu jaką klient może zakupić jednorazowo.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Przyrost ilości</strong> - określa jaką wielokrotność ilości jaką klient może zakupić, np podanie liczby 2 spowoduje, że klient będzie mógł zakupić tylko 2, 4, 6 itd szt. Pozostawienie pola pustego powoduje, że klient może zakupić dowolną ilość.<br />\r\n&nbsp;</div>\r\nPrzy wprowadzaniu powyższych 3 pól należy ustawiać je w sposób logiczny. Jeżeli zostanie podana minimalna ilość zakupu 3 to przyrost ilości nie powinien być ustawiony np na 2 bo klient nigdy nie będzie mógł zakupić 2 szt.<br />\r\n<br />\r\n<strong>Produkt gabarytowy</strong> - określa czy produkt jest wielkogabarytowy czy normalny - informacja jest używana w modułach wysyłek.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Indywidualny koszt wysyłki</strong> - umożliwia przypisanie do produktu indywidualnego kosztu wysyłki. Korzystanie z tej opcji wymaga włączenia w menu <strong>Moduły / Wysyłki</strong> - <strong>Indywidualnej wysyłki zależnej od produktu</strong>. Jeżeli klient posiada w koszyku <strong>przynajmniej jeden</strong> produkt ze zdefiniowanym indywidualnym kosztem wysyłki, to wówczas wszystkie inne włączone w sklepie wysyłki stają się <span style=\"color:#FF0000;\"><strong>niedostępne</strong></span> dla tego zamówienia (z wyjątkiem odbioru osobistego). Całkowity koszt wysyłki zamówienia jest w takim przypadku obliczany na podstawie sumy kosztów wysyłki poszczególnych produktów. Dla przykładu: indywidualny koszt wysyłki produktu X to 10 zł, produktu Y to 8 zł - w przypadku dodania obu produktów do koszyka ogólny koszt wysyłki będzie wynosił 18 zł. Jeżeli produktu Y zostaną dodane 2 szt to koszt będzie wynosił 26 zł (10 zł + 2 x 8 zł). W przypadku indywidualnych kosztów wysyłek produktów ważne jest żeby każdy produkt miał wpisany koszt wysyłki. Jeżeli nie będzie miał wpisanej wartości to sklep będzie to traktował jako wartość 0.<br />\r\n<br />\r\n<strong>Koszt pobrania do indywidualnego kosztu wysyłki </strong>- jest to opcja połączona z w/w opcją. Określa koszt dopłaty do kosztu wysyłki jeżeli klient wybierze formę płatności za pobraniem. Korzystanie z tej opcji wymaga włączenia w menu <strong>Moduły / Płatności</strong> - <strong>Płatność przy odbiorze (indywidualny koszt wysyłki)</strong> oraz przypisanie tej formy płatności jako dostępnej podczas edycji <strong>Modułu indywidualnej wysyłki </strong>w menu <strong>Moduły / Wysyłki</strong>.<br />\r\n<br />\r\n<strong>Komentarze do produktu</strong> - włączenie tej opcji umożliwia wpisanie przez klienta dowolnej informacji podczas dodawania produktu do koszyka - na karcie produktu wyświetlane jest pole tekstowe do wpisania tekstu. Wpisany tekst jest dołączany do produktu i jest widoczny w zamówieniu klienta. Ta opcja przydatna jest np dla firm jubilerskich gdzie klient może wpisać tekst grawerunku lub dla firm produkujących nadruki na koszulkach czy kalendarzach.</div>\r\n<br />\r\n<strong>Notatki do produktu</strong> - jest to pole widoczne tylko dla obsługi sklepu - zawiera notatki właściciela sklepu.<br />\r\n<br />\r\n<strong>Stawka VAT</strong> - określa jaka stawka VAT będzie przypisana do produktu. W sklepie wszystkie ceny w bazie zapisywany są w cenach brutto.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Cena produktu</strong> - określa cenę produktu - każdy produkt może mieć do 10 różnych cen - ilość cen można określić w menu <strong> Konfiguracja / Ustawienia sklepu / Ustawienia dla hurtowni</strong> . Różne poziomy cen produktu umożliwiają przypisanie różnych cen do różnych grup klientów - np grupa klientów hurtownych może mieć inny poziom cen niż detaliści.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Ceny podane w walucie</strong> - określa w jakiej walucie została podana cena. Jeżeli cena będzie podana w innej walucie niż domyślna w sklepie zostanie ona przeliczona na walutę domyślną. Czyli np w sklepie walutą domyślną jest ZŁ - cena podana przy produkcie to 100 EURO - kurs euro do złotego to 4 zł za 1 euro - przy takim przeliczniku w sklepie produkt będzie wyświetlany ze ceną 400 zł brutto.<br />\r\n<br />\r\n<strong>Cena zakupu</strong> - określa cenę zakupu produktu. Cena ma charakter informacyjny dla właściciela sklepu i nie jest wyświetlana klientom. Przy pomocy ceny zakupu można wykonywać operacje na cenach produktów (np dodając do ceny zakupu marżę dzięki czemu można wyliczyć cenę końcową) - operacji dokonuje się w menu <strong>Narzędzia / Masowa zmiana parametrów produktów / Zmiana cen produktów</strong>.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/produkt_cena_katalogowa.jpg\" style=\"float: right; margin-left: 15px; margin-bottom: 15px; width: 160px; height: 81px;\" /><strong>Cena katalogowa</strong> - określa cenę katalogową / cenę producenta produktu. Jest to cena która ma wyłącznie charakter informacyjny i ma wykazać, że cena oferowana w sklepie jest niższa niż cena katalogowa produktu. Cena jest standardowo wyświetlana na karcie produktu pod ceną główną produktu. Dodatkowo jeżeli produkt ma wpisaną cenę katalogową - na karcie produktu może być wyświetlana informacja ile klient oszczędza na zakupie w stosunku do ceny katalogowej. Wartość oszczędzasz może być kwotowa lub procentowa - w zależności od ustawień w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia produktu</strong>. Uzupełnienie ceny katalogowej nie jest obowiązkowe, produkt nie musi mieć wpisanej tej ceny. Cena katalogowa na karcie produktu będzie wyświetlana tylko dla produktów, które mają wpisaną cenę katalogową. Cena katalogowa może być różna dla różnych poziomów cen produktu. <span style=\"color:#FF0000;\"><strong>Cena katalogowa musi być wyższa od ceny głównej produktu.</strong></span><br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Produkt widoczny w modułach</strong> - te opcje umożliwiają ustawienie produktu np jako nowości, hitu czy produktu polecanego. Część opcji ma także możliwość ustawienia dat w jakim przedziale czasowym np produkt będzie hitem. Przypisanie produktu np do produktów polecanych będzie powodowało, że produkt będzie wyświetlany w sklepie dodatkowo w module produktów polecanych - przez co można bardziej promować wybrane produkty. W opcji promocja dodatkowym wymaganym parametrem jest podanie ceny poprzedniej - jest to wartość jaka będzie wyświetlana w sklepie jako przekreślona. Kolejną opcją jest eksport do porównywarek - opcja umożliwia wybranie określonych produktów które będą eksportowane do porównywarek cen - opcja nie musi być zaznaczona jeżeli w opcjach eksportu do porównywarek nie będzie wybrana opcja - tylko zaznaczone produkty - dokładny opis opcji eksportu znajduje się w instrukcji dotyczącej porównywarek cen. Ostatnią opcją jest włączenie negocjacji cen - włączenie tej opcji spowoduje, że na karcie produktu będzie widoczny dodatkowy przycisk z przekierowaniem do formularze gdzie klient będzie mógł wysłać własną propozycję cenową produktu.<br />\r\n<br />\r\n<span style=\"color:#FF0000;\"><strong>UWAGA</strong></span> Opcja nowości będzie aktywna w zależności od ustawień w menu Konfiguracja / Konfiguracja sklepu / Ustawienia produktów - tylko jeżeli mechanizm określania nowości będzie ustawiony na tryb ręczny. W przeciwnym wypadku opcja nie będzie aktywna i nowości będą określane na podstawie daty dodania produktu.<br />\r\n<br />\r\n<strong>Produkt objęty DARMOWĄ DOSTAWĄ</strong> - zaznaczenie tej opcji ma wpływ na wyświetlanie ikonki na zdjęciach informującej o darmowej dostawie produktu (wyświetlanie ikonki jest dodatkowo zależne od ustawień w menu <strong>Konfiguracja / Obrazki i dokumenty / Obrazki - ikonki na zdjęciach</strong>). <span style=\"color:#FF0000;\"><strong>Dodatkowo zaznaczenie tej opcji powoduje, że sklep nie będzie naliczał kosztów wysyłki jeżeli produkt zostanie dodany do koszyka.</strong></span> Jeżeli do koszyka zostanie dodany produkt, który będzie miał zaznaczoną tą opcję to do wszystkich dostępnych dla danego produktu wysyłek zostanie przypisany koszt wysyłki 0. Koszt wysyłki nie będzie naliczany - niezależnie od ustawień kosztów wysyłek w konfiguracji modułów wysyłek. Zasada wyzerowania kosztów wysyłki będzie obowiązywała dla wszystkich produktów, które mają zaznaczoną tą opcję. Jeżeli do koszyka zostaną dodane dwa, trzy lub więcej produktów z zaznaczoną opcją darmowej wysyłki - koszt wysyłki dla wszystkich produktów będzie wynosił 0 zł. Opcja ta jest powiązana z menu <strong>Moduły / Konfiguracja wysyłek i płatności</strong>. Znajduje się tam opcja: <strong>Jeżeli do koszyka zostanie dodany min. jeden produkt z opcją darmowej dostawy to czy inne produkty w koszyku też mają być wysyłane za darmo ?</strong> - włączenie tej opcji na - <strong>tak</strong> - powoduje, że dodanie produktu z darmową wysyłką do koszyka <u>zeruje koszty wysyłki dla wszystkich produktów</u> dodanych do koszyka. Opcja na - <strong>nie</strong> - powoduje, że w przypadku jeżeli do koszyka zostanie dodany chociaż jeden produkt bez opcji darmowej dostawy - <u>koszt wysyłki przestaje być zerowy</u> i będzie liczony dla wszystkich produktów wg standardowych kosztów skonfigurowanych w modułach wysyłek.<br />\r\n<br />\r\nW opcji Darmowej dostawy znajduje się dodatkowa możliwość <span style=\"color:#FF0000;\"><strong>wykluczenia</strong></span> z darmowej dostawy określonych grup klientów. Jeżeli żadna grupa klientów nie jest wybrana to darmowa dostawa dotyczy wszystkich klientów. Wybranie określonych grup powoduje, że dla klientów przypisanej do danej grupy klientów darmowa wysyłka nie będzie dostępna.<br />\r\n<br />\r\n<strong>Produkt <span style=\"color:#ff0000\">wykluczony</span> z DARMOWEJ DOSTAWY</strong> - zaznaczenie tej opcji powoduje, że dany produkt nie będzie objęty darmową dostawą. Jeżeli do koszyka zostanie dodany produkt, który będzie miał zaznaczoną tą opcję to niezależnie od ustawień modułów wysyłek - koszt wysyłki nie będzie darmowy i będzie obliczany zgodnie z ustalonym cennikiem.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/produkt_paczkomaty.jpg\" style=\"width: 200px; height: 128px; float: left; margin-bottom: 15px; margin-right: 15px;\" /><strong>Paczkomaty - rozmiar paczki oraz ilość sztuk w paczce</strong> - umożliwia przypisanie do produktu rozmiaru paczki (gabarytu) wg paczkomatów w jakiej może zostać wysłany dany produkt. Dodatkowo można wybrać ile sztuk danego produktu mieści się w danym gabarycie. Moduł jest powiązany z modułem wysyłki paczkomatów w menu <strong>Moduły / Wysyłki</strong>. Na podstawie wprowadzonych danych sklep będzie obliczał jaki rozmiar paczki musi być użyty do wysłania zakupionych produktów. W zależności od rozmiaru gabarytu (A, B lub C) koszt wysyłki paczkomatami może mieć różną cenę.</div>\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/znizki_od_ilosci.jpg\" style=\"width: 400px; height: 206px; float: right; margin-bottom: 15px; margin-left: 15px;\" />\r\n<div style=\"text-align:justify;\"><strong>Zniżki zależne od ilości produktów w koszyku</strong> - jest to opcja umożliwiająca przypisanie do produktu określonych rabatów w zależności od zakupionej przez klienta ilości sztuk produktu. W tabelce określa się od jakiej do jakiej ilości obowiązuje dany rabat. Dla przykładu wg pokazanej obok tabelki przy zakupie od 2 do 5 szt produktu produkt będzie tańszy o 10%, od 6 do 10 szt o 15%. Zniżki mogą być w formie procentowej lub można określić cenę produktu w zależności od ilości zakupionych produktów. Do przełączenia sposobu naliczania zniżki służy opcja <strong>Rodzaj zniżki</strong>. Po wybraniu rodzaju - procentowa - będzie można określić zniżkę procentową w zależności od ilości produktów. Po wyborze - kwotowa - podaje się jaką produkt będzie miał cenę przy określonych ilościach dodanych do koszyka.<br />\r\n<br />\r\nZniżki można dodatkowo skonfigurować w menu <strong> Konfiguracja / Konfiguracja sklepu / Ustawienia rabatów i zniżek</strong> . Można wyłączyć ze zniżek produkty promocyjne oraz sumowanie zniżek z innymi rabatami.</div>\r\n"),
("13","112","1","instrukcja","Dodawanie / edycja - zakładka Przypisanie kategorie","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/przypisane_kategorie.jpg\" style=\"width: 390px; height: 159px; margin-right: 15px; margin-bottom: 15px; float: left;\" />Zakładka Przypisane kategorie umożliwia przypisanie do produktu wybranych kategorii produktowych. Każdy produkt musi być przypisany do co najmniej <strong>jednej</strong> kategorii. Można także produkt przypisać do kliku kategorii - będzie wtedy widoczny w sklepie w kilku kategoriach.<br />\r\n<br />\r\nPrzypisanie do kategorii odbywa się poprzez zaznaczenie pola wielokrotnego wyboru (pole kwadracika). Poprzez zaznaczenie wybiera się do jakich kategorii ma być przypisany edytowany produkt.<br />\r\n<br />\r\nPole przed polem wielokrotnego wyboru (pole w formie kółka) umożliwia wybranie, która kategoria będzie <strong>główną kategorią produktu</strong>. Wybranie głównej kategorii nie jest obowiązkowe - jednak jest przydatne jeżeli produkt jest przypisany do kilku kategorii i dane produktu są eksportowane np do porównywarek. Wtedy do porównywarek będzie przesyłana nazwa kategorii wybranej jako główna.<br />\r\n<br />\r\nW przypadku jeżeli kategoria nie jest aktywna (jest wyłączona w menu <strong>Asortyment / Kategorie</strong>) obok nazwy kategorii jest wyświetlana czerwona ikonka ze znakiem wykrzyknika - oznacza ona, że kategoria nie jest aktywna i nie jest wyświetlana w sklepie.</div>\r\n"),
("14","113","1","instrukcja","Dodawanie / edycja - zakładki Opis i Krótki opis","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkt_opis.jpg\" style=\"width:420px;height:149px;float:left;margin-right:15px;margin-bottom:15px;\" />Zakładki Opis i Opis krótki umożliwiają dodanie do produktu opisu. Opis do produktu wpisuje się w edytorze tekstu. Wpisywany tekst można dowolnie formatować, wstawić obrazki, pogrubić tekst, zmienić kolor czy rozmiar czcionki. Tekst opisu produktu można wprowadzić indywidualnie dla każdej wersji językowej sklepu - przełączenie na edytor innej wersji językowej następuje poprzez kliknięcie na zakładkę z nazwą języka. Pełny opis produktu jest wyświetlany na karcie produktu w zakładce opis. Krótki opis jest wykorzystywany w modułach wyświetlających produkty na stronie głównej sklepu które mają w opcjach wyświetlanie opisu skróconego. Jeżeli opis skrócony nie zostanie uzupełniony w w/w modułach będzie wyświetlana określona część (standardowo 250 pierwszych znaków) opisu pełnego.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Podczas tworzenia opisu produktu można wykorzystać możliwości jakie daje edytor tekstu.&nbsp; Jest to rozbudowane narzędzie które umożliwia stworzenie atrakcyjnego pod względem wyglądu opisu. W treści opisu można tworzyć odnośniki do innych stron. Tworzenie linku odbywa się poprzez ikonę <img alt=\"alt\" src=\"obrazki/pomoc/ikona_link.jpg\" style=\"width:27px;height:24px;\" />. W celu utworzenia linku należy wpisać w edytorze tekst który ma być linkiem, następnie należy zaznaczyć tekst kursorem myszy trzymając na tekście wciśnięty lewy przycisk myszy i przejechać kursorem w lewą lub prawą stronę (zależy którą cześć tekstu zaznaczmy). Po zaznaczeniu tekstu należy kliknąć pokazaną powyżej ikonę. Po tym pojawi się dodatkowe okno w którym w polu Adres URL należy wpisać adres strony do jakiej ma się odnosić link. Edytor umożliwia także wstawienie do tekstu obrazków. W tym celu należy kliknąć ikonę <img alt=\"alt\" src=\"obrazki/pomoc/ikona_obrazek.jpg\" style=\"width:24px;height:18px;\" />. Po kliknięciu otworzy się dodatkowe okienko w którym będzie można wstawić obrazek. Przycisk <strong>Przeglądaj</strong> umożliwia otworzenie przeglądarki plików i wybranie z katalogu (folderu) zdjęć na serwerze pliku graficznego który ma być wyświetlany. Przeglądarka umożliwia także wgranie nowego obrazka z komputera klienta. Dokładny opis przeglądarki znajduje się w kolejnych rozdziałach. Po wybraniu obrazka istotne jest uzupełnienie pola Tekst zastępczy - jest to wartość która wyświetla się zanim obrazek zostanie załadowany do przeglądarki WWW klienta - jest ona również ważna dla google i odpowiednie dopasowanie tekstu opisu obrazka do zdjęcia powoduje lepsze pozycjonowanie sklepu. Przy dodawaniu obrazka automatycznie wstawiana jest jego wielkość w pikselach. W polach szerokość oraz wysokość można zmienić wielkość obrazka - tak, że rozmiar wyświetlany w sklepie może być mniejszy niż rzeczywiście wgrana wielkość (wyświetlany obrazek można skalować). Opcje wyrównywania obrazka są istotne jeżeli obrazek ma być wstawiony w tekst. Wybranie wyrównania do lewej czy prawej strony spowoduje, że tekst będzie oblewał obrazek. Jeżeli wyrównanie nie zostanie wybrane obrazek będzie zajmował całą szerokość opisu i tekst będzie wyświetlany pod obrazkiem. W opisie produktu można wstawić także animację flash. Kliknięcie w ikonę <img alt=\"alt\" src=\"obrazki/pomoc/ikona_flash.jpg\" style=\"width:20px;height:20px;\" /> spowoduje otworzenie okna dodawania animacji flash. Dodając animację należy wybrać plik animacji (korzystając z przeglądarki zdjęć podobnie jak przy dodawaniu zdjęcia) oraz określić wysokość i szerokość animacji w pikselach. Na podobnej zasadzie można dodać do opisu film z YouTube - w tym celu trzeba kliknąć na ikonę <img alt=\"alt\" src=\"obrazki/pomoc/ikona_youtube.jpg\" style=\"width:26px;height:22px;\" />. Kliknięcie spowoduje otworzenie okna dodawania filmów YouTube. W parametrach trzeba podać link do filmu oraz jego wielkość - szerokość oraz wysokość w pikselach.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">W opisie krótkim nie powinno stosować się formatowania tekstu, dodawania obrazków, linków gdyż te opisy są wyświetlane wyłącznie w modułach na stronie głównej jako krótkie charakterystyki produktów (ewentualne użyte formatowania zostają usunięte podczas wyświetlania).</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>WAŻNE:</strong></span> Podczas tworzenia opisu produktu należy pamiętać żeby tekst został zoptymalizowany pod kątem wyszukiwarek ale również był czytelny dla klienta. Tekst powinien być interesujący, logiczny, przejrzysty i napisany poprawną polszczyzną. Tworzony tekst powinien zawierać odpowiednie słowa kluczowe dopasowane do produktu, nie można jednak dopuścić żeby słów kluczowych było zbyt wiele. Już dwu lub trzykrotne wystąpienie słowa kluczowego w&nbsp;treści w&nbsp;zupełności wystarczy. W internecie znajduje się wiele ciekawych opisów jak tworzyć opisy produktów, co powinny zawierać, co zrobić żeby były unikalne - największym błędem jest kopiowanie tekstów z innych stron czy wstawiania gotowych opisów. Google może szybko zbanować stronę co objawia się brakiem strony w wynika wyszukiwania. Istnieje wiele narzędzi, które pozwalają na sprawdzenie unikalności tekstu. Ciekawy, własny tekst napewno zagwarantuje lepszą pozycję strony w wynikach wyszukiwania - niż gotowy skopiowany tekst.</div>\r\n"),
("15","114","1","instrukcja","Dodawanie / edycja - zakładka Zdjęcia produktu","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkt_dodatkowe_zdjecia.jpg\" style=\"width: 600px; height: 171px; float: left; margin-right: 15px;\" />Zakładka Zdjęcia produktu umożliwia przypisanie do produktu zdjęć. Każdy produkt jest atrakcyjniejszy dla klienta jeżeli posiada zdjęcia - w internecie klient chce najpierw zobaczyć jak wygląda produkt zanim go zakupi. Dlatego im lepiej zostanie zaprezentowany produkt w sklepie, im więcej zdjęć będzie posiadał, tym klient będzie mógł lepiej poznać produkt i przekonać się do jego zakupu. Sklep umożliwia dodanie nieokreślonej ilości zdjęć do każdego produktu. Zaleca się aby wielkość zdjęcia nie była zbyt duża - dodanie zdjęcia o rozdzielczości np 4000 x 4000 pikseli i wadze 5mb nie ma sensu ponieważ takie zdjęcie będzie się u końcowego klienta bardzo długo otwierało. Co prawda sklep przy wyświetlaniu produktów tworzy miniaturki ale zdjęcie przy powiększeniu na karcie produktu jest wyświetlane w oryginale - przy wolniejszym łączu internetowym klienta duże zdjęcie będzie otwierało się długo. Zaleca się żeby wielkość obrazków oscylowała w granicach 1000 - 1500 pikseli i waga ok 100 - 150 kb - format najlepiej jpg.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Dodawanie nowego zdjęcia odbywa się poprzez kliknięcie w przycisk <strong>dodaj kolejne zdjęcie</strong>. Kliknięcie powoduje wyświetlenie się pól do dodania kolejnego zdjęcia. Przy dodawaniu zdjęć w zakładce należy wybrać zdjęcie poprzez 2-krotne kliknięcie w pole Ścieżka zdjęcia - po tym otworzy się przeglądarka zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta. Po wybraniu zdjęcia należy wpisać także opis zdjęcia - jest to wartość która wyświetla się zanim obrazek zostanie załadowany do przeglądarki WWW klienta - jest ona również ważna dla google i odpowiednie dopasowanie tekstu opisu obrazka do zdjęcia powoduje lepsze pozycjonowanie sklepu - pozostawienie pola pustego spowoduje, że w kodzie sklepu będzie wyświetlana wartość pusta - nie jest to błąd ale nie jest to wskazane.<br />\r\n<br />\r\nPrzy dodawaniu zdjęć w polu <strong>Sort</strong> można wpisać także kolejność wyświetlania zdjęć. Zdjęcia będą wyświetlane w ustalonej kolejności przy prezentacji na karcie produktu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>WAŻNE:</strong></span> Pierwsze zdjęcie na liście jest przyjmowane jako zdjęcie główne produktu. Tzn, że zdjęcie to będzie wyświetlało się w sklepie w listingach produktów, wynikach wyszukiwania, modułach produktowych. Pozostałe zdjęcia będą wyświetlane na karcie produktu po wejściu przez klienta w szczegóły produktu.</div>\r\n"),
("16","115","1","instrukcja","Dodawanie / edycja - zakładka Dodatkowe pola opisowe","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkt_dodatkowe_pola.jpg\" style=\"width: 500px; height: 294px; float: left; margin-bottom: 15px; margin-right: 15px;\" />Zakładkę Dodatkowe pola opisowe można traktować jako część opisu produktu. Czym są dodatkowe pola opisowe ? Są to wartości które są definiowane i wspólne dla niektórych produktów. Dodatkowe pola opisowe definiuje się w menu <strong> Konfiguracja / Dodatkowe pola / Dodatkowe pola dla produktów</strong>. Przykładem dodatkowych pól w branży komputerowej może być specyfikacja komputera. Mając w ofercie sklepu np laptopy można stworzyć dodatkowe pola opisowe które są wspólne dla laptopów, np procesor, pamięć, rozmiar ekranu, wielkość dysku itd. Podczas dodawania czy edycji produktu nie trzeba w opisie wpisywać poszczególnych nazw parametrów, a można skorzystać z dodatkowych pól i wypełnić tylko odpowiednie wartości dla poszczególnych pól. Dodatkowe pola mogą być w formie tekstu lub obrazków. Mogą być także odnośnikiem do innych stron.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dodatkowe_pola_sklep.jpg\" style=\"width:180px;float:right;margin-left:15px;height:74px;margin-top:10px;margin-bottom:10px;\" />Zaletą dodatkowych pól (tylko w formie tekstowej) jest możliwość filtrowania produktów przez klientów po stronie sklepu. Tzn, klient po wejściu np w kategorię laptopy może wyświetlić tylko produkty które mają pamięć RAM np 2GB. Dzięki temu szybciej będzie w stanie znaleźć interesujące go produkty.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dodatkowe_pola_zdjecie.jpg\" style=\"width:240px;height:107px;margin:10px;float:left;\" /><img alt=\"alt\" src=\"obrazki/pomoc/dodatkowe_pola_opis.jpg\" style=\"width:240px;height:117px;margin:10px;float:left;\" />Po stronie sklepu dodatkowe pola (w zależności od ustawienia pola) mogą wyświetlać się na karcie produktu obok zdjęcia lub pod opisem produktu. Mogą być one zarówno uzupełnieniem opisu jak i zupełnie inną informacją (np mogą definiować stan produktu - w przypadku gier na konsole można dodać pole stan okładki czy wersję językową gry - oraz ustawić wyświetlanie takich pól obok zdjęcia produktu razem z dostępnością i nr katalogowym).<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Dodatkowe pola podczas definiowania mogą być przypisane do określonego języka lub być uniwersalne i wspólne dla wszystkich języków. Najczęściej zależy to od nazwy pola która może być wspólna dla wszystkich języków.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/dodatkowe_pola_dodawanie_lista.jpg\" style=\"float: left; width: 400px; height: 105px; margin-bottom: 15px; margin-right: 15px;\" />Podczas edycji czy dodawania produktu aby dodać nowe pole do produktu należy wybrać je z listy zdefiniowanych w sklepie pól i dodać poprzez ikonę dodawania (zielona ikonka z plusikiem). Po dodaniu pola zostanie ono wyświetlone poniżej listy wyboru pól wraz w polami do uzupełnienia - wpisania <strong>Wartości</strong> pola - czyli tekstu lub wybrania obrazka jaki ma wyświetlać dodatkowe pola. Dodatkowo będzie wyświetlone pole <strong>Adres URL</strong>, które umożliwia utworzenie z dodatkowego pola linku. Definiując adres linku należy podać pełen adres z http:// .... Jeżeli dodatkowe pole jest wyświetlane w formie obrazka to w pole - wartość - wstawia się ścieżkę do obrazka. 2-krotne kliknięcie w pole - wartość - otworzy przeglądarkę zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta. Obrazki przypisane do dodatkowych pól produktu <strong>nie są skalowane</strong> po stronie sklepu - wyświetlane są w oryginalnym rozmiarze jakim zostały wgrane - dlatego należy pamiętać, żeby nie były to duże obrazy ponieważ mogą spowodować złe wyświetlanie sklepu.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/dodatkowe_pola_dodawanie_lista_slownik.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 400px; height: 101px;\" />Dodatkowo przy każdym polu wartości dodanego pola wyświetlana jest ikona rozwinięcia słownika dla danego pola. Po kliknięciu w ikonę zostanie rozwinięty słownik dodatkowe pola (jeżeli był wcześniej zdefiniowany w menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola produktów</strong>) i z listy słownika będzie można wybrać pozycję, która zostanie wstawiona w pole wartości dodatkowego pola. Wykorzystanie słownika ułatwia i przyspiesza dodawanie pól, gdyż nie trzeba ręcznie wpisywać tekstu treści pola czy wybierać obrazka jaki ma wyświetlać.<br />\r\n<br />\r\nPod polem wyboru nazwy pola znajduje się opcja <strong>dodania nowego pola opisowego</strong>. Kliknięcie w ten link powoduje otworzenie dodatkowego okna, które umożliwia dodanie nowego pola do sklepu. Funkcja ta umożliwia szybkie dodanie nowego pola, którego nie ma w sklepie bez konieczności tworzenia osobno pola w menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola dla produktów</strong>.</div>\r\n"),
("17","116","1","instrukcja","Dodawanie / edycja - zakładka Cechy produktu","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkt_cechy.jpg\" style=\"width: 600px; height: 351px; float: left; margin-bottom: 15px; margin-right: 15px;\" />Zakładka Cechy produktu definiuje w sklepie jeden z najbardziej złożonych parametrów produktów. Cechy produktu to opcje (atrybuty) jakie może posiadać produkt. Np w przypadku ubrań - cechami mogą być rozmiar czy kolor. Dzięki cechom nie trzeba dodawać do sklepu kilku takich samych produktów np w różnych kolorach, a wystarczy dodać jeden produkt i przypisać do niego cechę Kolor oraz zdefiniować kolory w jakich występuje produkt.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Do produktu można dodać nieograniczoną ilość cech, a każda może mieć dowolną ilość wartości. Dodatkowo cechy produktu mogą wpływać na wartość produktu - zwiększając lub zmniejszając jego ceną oraz wagę (ten parametr jest istotny w przypadku wysyłek opartych o wagę). Cechy produktu definiuje się w menu <strong> Asortyment / Cechy produktów</strong> .</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align: justify;\">W górnej części zakładki Cechy produktu znajduje się okno wyboru, w którym trzeba wybrać w jaki sposób cechy będą wpływały na cenę produktu. Sklep daje pod tym względem dwie możliwości:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align: justify;\"><strong>cena produktu obliczana wg wartości cech</strong> - przy tej opcji definiuje się poszczególne wartości cech jakie wpływają na cenę produktu przy wartościach cech. Cechy mogą być w tym przypadku zarówno kwotowe jak i procentowe. Jeżeli cecha ma wartość procentową należy wpisać ilość procent. W przypadku prefixu + (plus) oraz - (minus) wartość cechy będzie obliczana na podstawie ilości procent od ceny bazowej produktu (bez uwzględnienia innych cech). Czyli np cena produktu to 400 zł - cecha kolor czerwony ma wartość 10% to po wyborze przez klienta danej cechy - cena produktu zmieni się na 440 zł. Jeżeli dana cecha nie wpływa na wartość produktu oraz wagę należy pozostawić pola puste. Wartości kwotowe cech mają taką samą stawkę podatku VAT jak cena główna produktu. Przy takim rozwiązaniu niezależnie od zmian ceny bazowej produktu wartość cech będzie miała zawsze stałą wartość (procentową od ceny produktu lub stałą kwotową). Przy tej opcji jeżeli cechy wpływają na cenę produktu należy uzupełnić pola: prefix, cena netto oraz brutto cechy lub wartość procentowa. W przypadku prefixu + (plus) oraz - (minus) wartość cechy jest obliczana od wartości bazowej produktu. W przypadku prefixu (*) poszczególne wartości są mnożone. Dla przykładu: produkt X posiada cechę A o wartości + 20 zł oraz cechę B o wartości * 1.5 oraz cechę C o wartości * 1.3. Cena bazowa produktu to 100 zł. Wartość końcowa produktu to ( ( 100 * 1.5 * 1.3 ) + 20 ) = 215 zł</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/produkt_cechy_cena.jpg\" style=\"float: right; margin: 15px; width: 550px; height: 186px;\" />cena produktu przypisana na stałe do kombinacji cech</strong> - przy tej opcji nie definiuje się wartości dla poszczególnych cech - tylko definiuje się końcową cenę produktu z danymi cechami. Po wybraniu tej opcji z listy cech znikają pola: prefix, cena netto oraz brutto. Wyświetlane są za to dodatkowe pola do <strong>wpisania ceny</strong> w liście poniżej cech gdzie wyświetlane są dostępne opcje produktu (wszystkie kombinacje wybranych cech produktu). Dodatkowe pola to cena netto oraz cena brutto. W polach tych można ustalić jaką cenę będzie miał produkt z danymi cechami. Dla przykładu można ustawić, że produkt z kartą pamięci 128mb będzie kosztował 120 zł, a z kartą 256 zł - 150 zł. Dla każdej kombinacji cech można wprowadzić inne ceny, dodatkowo ilość cen jest zależna od ilości poziomów cen włączonych w sklepie. Ta funkcja sklepu jest przydatna dla firm, które sprzedają produkty w różnych wariantach ale nie da się w prosty sposób ustalić o ile dany wariant podnosi cenę i występuje konieczność wpisania całkowitej wartości produktu. W takim przypadku trudniej jest aktualizować ceny produktu. Każda aktualizacja wymaga oprócz zmiany głównej ceny produktu, także aktualizację cen dla poszczególnych wariantów (cech). Ceny dla kombinacji cech można także aktualizować przy pomocy plików CSV lub XML - opcja: <strong>tylko aktualizacja stanów magazynowych, cen i dostępności cech produktów</strong> w menu <strong>Narzędzia / Import i eksport danych</strong>. Przy takiej aktualizacji można poprzez zewnętrzne pliki XML i CSV aktualizować ceny produktów z poszczególnymi cechami - warunkiem jest to, że każda kombinacja cech musi posiadać indywidualny numer katalogowy - po tym sklep rozpoznaje gdzie trzeba wstawić importowaną wartość (podobnie jak przy aktualizacji stanu magazynowego oraz dostępności cech). W przypadku jeżeli cena dalej kombinacji cech jest taka sama jak cena podstawowa produktu można nie wypełniać ceny cechy. Jeżeli pole pozostanie puste sklep będzie przy takiej kombinacji cech wyświetlał cenę podstawową produktu.</li>\r\n</ol>\r\n\r\n<div style=\"text-align: justify;\">Powyższe opcje są istotne dla produktów, które posiadają cechy i cechy mają wpływ na wartość końcową produktu - tzn obniżają ją lub podwyższają. Dla produktów, które mają cechy ale bez wpływu na cenę nie ma znaczenia wybrana powyżej opcja - gdyż cena produktu zawsze jest taka sama - niezależnie od wybranej cechy (opcji) produktu.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Poniżej pola wyboru określania sposobu wyboru cen cech produktu - znajduje się pole dodawania cech do produktu. Przy dodawaniu cech do produktu należy wybrać jaką cechę będziemy dodawać oraz wybrane wartości cechy. Poprzez kliknięcia w przycisk <strong>plusa </strong>można przypisać nowe cechy do produktu oraz nowe wartości cech.<br />\r\n<br />\r\nDodatkowo pod polem wyboru nazwy cechy oraz nazwy wartości znajdują się opcje dodania nowej cechy lub wartości. Kliknięcie w te linki powoduje otworzenie dodatkowe okna, które umożliwia dodanie nowej cechy do sklepu lub nowej wartości do istniejącej już cechy. Funkcja ta umożliwia szybkie dodanie nowej cechy lub wartości, której nie ma w sklepie, a jest potrzebna dla danego produktu. Dzięki temu nie ma konieczności tworzenia osobno cechy czy wartości w menu <strong>Asortyment / Cechy produktu</strong>.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkt_cechy_magazyn.jpg\" style=\"width: 500px; height: 138px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Poniżej listy cech przypisanych do produktu wyświetlane są&nbsp; wszystkie możliwe kombinacje cech danego produktu. Są tam wszystkie kombinacje cech w jakich może występować produkt. W tabeli tej można zdefiniować ilość stanu magazynowego danej kombinacji (np ile w magazynie jest T-shirtów w kolorze białym i rozmiarze XL), określić dostępność danej kombinacji (podobnie jak w głównej dostępności produktu może być ona automatyczna lub stała) oraz wpisać nr katalogowy - tylko jeżeli dana kombinacja cech ma własny numer katalogowy. Pozostawienie pola dostępności jako <strong>-- brak --</strong> spowoduje, że przy wyświetlaniu danej cechy na karcie produktu w sklepie będzie wyświetlana wartość główna dostępności produktu zdefiniowana w zakładce Podstawowe dane. Podobnie pozostawienie pustego pola nr katalogowy spowoduje, że będzie wyświetlany główny numer katalogowy produktu. Pole ilość wyświetla się tylko jeżeli włączona jest opcja <strong>powiązania cech z magazynem produktu</strong> - menu <strong> Konfiguracja / Ustawienia sklepu / Ustawienia magazynu</strong> . Jeżeli opcja jest wyłączona cechy nie mają własnych stanów magazynowych i do sprzedaży brany jest pod uwagę ogólny stan magazynowy produktu z zakładki Podstawowe dane. Jeżeli jednak opcja jest włączona, a pole ilość nie będzie wypełnione przy danej kombinacji - to jeżeli klient w sklepie wybierze przy zakupie produktu daną kombinacje cech - nie będzie mógł dokonać zakupu, gdyż sklep przyjmie stan magazynowy danej kombinacji jako 0 i nie wyświetli przycisku dodania do koszyka. W zależności od ustawień sposobu w jaki cechy wpływają na cenę produktu mogą być dodatkowo w liście wyświetlane pola do wpisania ceny netto i brutto produktu - opisane powyżej w instrukcji.<br />\r\n<br />\r\nW tym miejscu można także przypisać <strong>indywidualne zdjęcie do danej kombinacji cech produktu</strong>. Po kliknięciu w ikonkę obrazka w ostatniej kolumnie oznaczonej jako - Foto - zostanie wyświetlone pole wyboru obrazka dla danej kombinacji cech. Po dwukrotnym kliknięciu w pole zostanie otworzona przeglądarka zdjęć z której będzie można wybrać indywidualne zdjęcie kombinacji cech. Po wyborze zdjęcia należy zapisać zmianę poprzez kliknięciu w ikonę dyskietki. Jeżeli dana kombinacja cech będzie miała przypisane indywidualne zdjęcie to na karcie produktu w sklepie - jeżeli klient wybierze określoną kombinację cech zmieni się główne zdjęcie produktu na przypisane do danej kombinacji.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span>: W przypadku edycji produktu wszystkie operacje na cechach są zapisywane bezpośrednio do bazy i nie wymagają zapisania poprzez zatwierdzenie przyciskiem <b>Zapisz dane</b> - na dole strony. Należy o tym pamiętać przy edytowaniu czy kasowaniu cech - ponieważ nie ma możliwości <strong>wycofania</strong> dokonanych zmian.</div>\r\n"),
("18","117","1","instrukcja","Dodawanie / edycja - zakładka Pozycjonowanie / tagi","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zakladka_pozycjonowanie.jpg\" style=\"width: 500px; height: 353px; float: left; margin-bottom: 15px; margin-right: 15px;\" />Zakładka Pozycjonowanie / tagi umożliwia przypisanie do produktu indywidualnych opisów meta tagów, tagów, tagów open&nbsp; graph które znajdują sie w kodzie sklepu podczas wyświetlania karty produktu.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Metatagi to dane na temat strony zawarte w jej kodzie w sekcji head (kod strony jest podzielony na określone części które odczytują przeglądarki WWW). Nie są one wyświetlane przez przeglądarkę, ale są widoczne dla robotów np Google. Obecnie są one potrzebne do pozycjonowania strony. Kiedyś były one dużo ważniejsze niż jest teraz - ale warto poświęcić trochę czasu na ich stosowanie.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Tytuł:</strong> Jego zawartość jest zazwyczaj wyświetlana na liście wyników wyszukiwania jako tytuł strony (i pojawia się też w przeglądarce użytkownika w górnym pasku przeglądarki). Jest to najważniejszy tag, gdyż wyszukiwarka właśnie na jego podstawie określa pozycję strony (oczywiście jest jeszcze wiele innych czynników) .</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Opis:</strong> Ten tag zapewnia krótki opis strony. <img alt=\"alt\" src=\"obrazki/pomoc/meta_tagi_opis.jpg\" style=\"width:300px;height:46px;float:right;margin:10px;\" />Czasami tekst ten jest wykorzystywany jako część krótkiego opisu strony pokazywanego na stronie z wynikami wyszukiwania w Google (pod nazwą strony oraz adresem sklepu). Jest to drugi w kolejności ważności tag. Powinien zawierać słowa kluczowe (słowa, frazy które są zawiązane z danym produktem) i musi być zrozumiały dla normalnego człowieka.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Słowa kluczowe:</strong> Zawiera tylko słowa kluczowe oddzielone przecinkiem. Meta tag pomijany przez roboty Google, cały czas ma pozytywny wpływ na pozycje w wyszukiwarkach takich jak onet czy netsprint. Obecnie ten meta tag nie jest już tak ważny jak kiedyś, lecz z pewnością nie zaszkodzi, a jedynie może pomóc. Ten tag jest przeznaczony tylko i wyłącznie dla wyszukiwarek, więc wpisanie słów kluczowych w tym wypadku jest wskazane. Mniej więcej od 3 do 7 fraz.<br />\r\n<br />\r\n<strong>Tagi Open Graph</strong> - protokół&nbsp;<strong>Open Graph</strong> pozwala na integrację serwisów internetowych z <strong>Facebookiem</strong>. Umożliwia kontrolę nad prezentacją&nbsp; treści w tym serwisie społecznościowym, a jednocześnie na lepszą ich interakcję z użytkownikami. Jest to w praktyce zestaw specjalnych znaczników, które umieszcza się w kodzie strony internetowej i które mają na celu dokładne opisanie tego, co się na tej stronie znajduje. Przekazywane w ten sposób informacje są później wyświetlane na tablicy użytkownika, który kliknął <strong>Lubię to</strong>, a także odpowiednio umieszczane w jego profilu - ogólnie rzecz biorąc opisują sposób, w jaki dana strona będzie widoczna w Facebooku. Więcej informacji na ten temat można znaleźć w <a href=\"https://developers.facebook.com/docs/opengraphprotocol/\">dokumentacji Facebooka</a>. W sklepie dla każdego produktu można zdefiniować dla tagów Open Graph tytuł oraz krótki opis, który będzie wyświetlany w opisanych tagach. W tagach będzie wyświetlane również zdjęcie, które będzie pobrane z zakładki zdjęcia (główne zdjęcie produktu).<br />\r\n<br />\r\n<strong>Link kanoniczny</strong>. Umożliwia ustawienie dla danego produktu linku kanonicznego.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/chmura_tagow_produkt.jpg\" style=\"width: 300px; height: 71px; float: left; margin-bottom: 15px; margin-right: 15px;\" /><strong>Tagi</strong>. Są to specjalne słowa kluczowe - po których w sklepie można wyszukiwać produkty. Nie są one wyświetlane w meta tagach i są osobną pozycją. Wpisując tagi - należy każdy tag rozdzielić przecinkiem. W przypadku wyszukiwania produktów przez klientów - wyszukiwarka szuka także szukanego ciągu znaków po wpisanych tagach. Dodatkowo w menu menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia produktów</strong>&nbsp; można włączyć wyświetlanie wpisanych tagów na karcie produktu - w formie chmury linków tagów z możliwością wyszukiwania.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Pozycja to <strong>Adres URL</strong>. Umożliwia ona przygotowanie indywidualnego adresu URL dla produktu. Sklep podczas tworzenia linków do produktów korzysta z tzw SEO - co oznacza przyjazne linki dla wyszukiwarek - nazwa linku do produktu zawiera w sobie nazwę produktu - dla przykładu produkt o nazwie: Kolczyki Szklane oczko bursztynowe będzie w sklepie miał link w postaci: kolczyki-szklane-oczko-bursztynowe-p-35.html - w treści linku wpisana jest nazwa produktu oraz na końcu nr id produktu dla identyfikacji w sklepie. Wpisując inną nazwę w pole Adres URL jako link będzie wyświetlana inna nazwa - sam produkt w sklepie będzie dalej nazywał się tak jak powyżej ale np po wpisaniu w pole Adres URL: Kolczyki oczko zlote - link do produktu będzie wyglądał tak: kolczyki-oczko-zlote-p-35.html - czyli będzie inny niż nazwa produktu. Taka zmiana jest często stosowana przy pozycjonowaniu sklepu w wyszukiwarkach.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE:</strong></span> Jeżeli pozycje meta tagów nie zostaną wypełnione (tytuł, opis i słowa kluczowe) - sklep automatycznie przyjmie jako wartości nazwę produktu.<br />\r\n<br />\r\nOstatnia pozycja <strong>Adres URL do produktu w poprzednim sklepie</strong> jest przeznaczona dla klientów, którzy posiadali wcześniej sklep na innej platformie sklepowej i przenoszą produkty do platformy shopGold. Dzięki tej opcji możliwe jest przekierowanie starych linków z poprzedniego sklepu na nową platformę sklepu. W polu adresu trzeba wpisać adres produktu jaki był w starym sklepie (sam link - bez adresu sklepu). Dzięki temu linki, które są dostępne np w wyszukiwarce google nie stracą swojej wartości, gdyż po ich kliknięciu w wynikach wyszukiwania klient zostanie przeniesiony na nowy adres w nowym sklepie. Do poprawnego działania przekierowań musi być włączony moduł przekierowań w menu Narzędzia / Przekierowanie URL.</div>\r\n"),
("19","118","1","instrukcja","Dodawanie / edycja - zakładki Dodatkowe zakładki","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/dodatkowe_zakladki.jpg\" style=\"width:187px;height:161px;margin-bottom:15px;margin-right:15px;float:left;\" />Dodatkowe zakładki są uzupełnieniem opisu głównego produktu. Jednak nie są one wyświetlane w sklepie jako część opisu - ich zawartość jest wyświetlana na karcie produktu w osobnych zakładkach. Przy definiowaniu dodatkowych zakładek należy podać ich nazwę (we wszystkich dostępnych językach) oraz treść zakładki. W sklepie można dodać do czterech dodatkowych zakładek do każdego produktu.<br />\r\n	 </div>\r\n<div style=\"text-align:justify;\">\r\n	Treść zakładki podobnie jak opis główny produktu może być dowolna - może zawierać tekst, zdjęcia, grafiki, filmy, tabele itd. Przykładem dodatkowej zakładki może być zakładka zawierająca dane techniczne produktu - jak na pokazanym poniżej przykładzie.</div>\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/dodatkowe_zakladki_sklep.jpg\" style=\"width:438px;height:195px;\" />"),
("20","119","1","instrukcja","Dodawanie / edycja - zakładka Linki","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/zakladka_linki.jpg\" style=\"width:350px;height:235px;float:left;margin-bottom:15px;margin-right:15px;\" />Zakładka Linki umożliwia stworzenie na karcie produktu dodatkowej zakładki zawierającej linki do stron WWW. Zakładka może zawierać maksymalnie cztery linki. Przykładem linku może być np link do strony producenta. Nazwy linków oraz opis są indywidualne w każdej wersji językowej - pole adres linku jest wspólny dla każdego języka i definiuje się go tylko w języku domyślnym. Ważne jest uzupełnienie nazwy linku - bez nazwy odnośnik nie będzie wyświetlany. Pole opis nie jest obowiązkowe i bez wypełniania link będzie się wyświetlał. Wpisując adres URL należy podawać jego pełną scieżkę razem z http:// ....</div>\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zakladka_linki_sklep.jpg\" style=\"width:450px;height:88px;\" />");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("21","120","1","instrukcja","Dodawanie / edycja - zakładka Pliki","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zakladka_pliki.jpg\" style=\"width:350px;height:163px;float:left;margin-bottom:50px;margin-right:15px;\" />Zakładka Pliki umożliwia stworzenie na karcie produktu dodatkowej zakładki zawierającej linki do pobrania plików. Zakładka może zawierać maksymalnie pięć odnośników do plików. Zakładka ta może być używana np do udostępniania klientom sterowników do sprzedawanego urządzenia lub instrukcji PDF. Nie ma ograniczenia jaki format plików zostanie udostępniony. Nazwy plików oraz opis są indywidualne dla każdej wersji językowej - sam odnośnik do pliku oraz widoczność (dla wszystkich klientów lub tylko zalogowanych) jest wspólne dla każdego języka i definiuje się je tylko w języku domyślnym. Przy dodawaniu plików należy wybrać plik poprzez 2-krotne kliknięcie w pole Plik - po tym otworzy się przeglądarka plików z możliwością wybrania pliku lub wgrania nowego z komputera klienta. Pliki do udostępniania są zapisane na serwerze w katalogu (folderze) o nazwie <strong>pobieranie</strong>. Ważne jest uzupełnienie pola nazwy do wyświetlania - bez nazwy odnośnik nie będzie wyświetlany. Pole opis nie jest obowiązkowe i bez wypełniania link będzie się wyświetlał. <img alt=\"alt\" src=\"obrazki/pomoc/zakladka_pliki_sklep.jpg\" style=\"width:501px;height:144px;float:right;margin-top:15px;margin-right:15px;\" /></div>\r\n"),
("22","122","1","instrukcja","Dodawanie / edycja - zakładka Filmy YouTube","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zakladka_youtube.jpg\" style=\"width:350px;height:195px;float:left;margin-bottom:50px;margin-right:15px;\" />Zakładka YouTube umożliwia stworzenie na karcie produktu dodatkowej zakładki zawierającej filmy z portalu YouTube. Zakładka może zawierać maksymalnie 4 filmy. W sklepie filmy z YouTube można wstawić także bezpośrednio w opisie produktu (sposób został opisany przy zakładce Opis) - jednak czasem klient chce mieć możliwość prezentowania filmów w osobnej zakładce - co umożliwia opisywana opcja.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Nazwy filmów oraz opis są indywidualne dla każdej wersji językowej - pola adres url oraz szerokość i wysokość są wspólne dla każdego języka i definiuje się je tylko w języku domyślnym. Przy dodawaniu adresu URL należy wkleić tylko nr <strong>id filmu</strong>, np. z linku http://www.youtube.com/watch?v=BvtXXXAF8 będzie to BvtXXXAF8. Przy definiowaniu szerokości i wysokości należy pamiętać, żeby podane wartości nie były większe od kolumny sklepu w której będą prezentowane ponieważ może to spowodować złe wyświetlanie sklepu - pola należy uzupełnić dla poprawnego wyświetlania filmu. Jeżeli pola nie zostaną wypełnione sklep przyjmie wartości domyślne 300x300 pikseli. Ważne jest uzupełnienie nazwy filmu - bez nazwy film nie będzie wyświetlany. Pole opis nie jest obowiązkowe i bez wypełniania film będzie się wyświetlał. <img alt=\"alt\" src=\"obrazki/pomoc/zakladka_youtube_sklep.jpg\" style=\"width:459px;height:311px;float:right;margin-top:15px;margin-right:15px;\" /></div>\r\n"),
("23","123","1","instrukcja","Dodawanie / edycja - zakładka Filmy FLV i MP4","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zakladka_flv.jpg\" style=\"width:400px;height:230px;float:left;margin-bottom:15px;margin-right:15px;\" />Zakładka Filmy FLV i MP4 umożliwia stworzenie na karcie produktu dodatkowej zakładki zawierającej filmy w formacie FLV lub MP4. Zakładka może zawierać maksymalnie 4 filmy. Filmy FLV i MP4 są przechowywane na serwerze gdzie znajduje się sklep - w przeciwieństwie do filmów YouTube które znajdują się na portalu YouTube. Format wideo FLV jest używany do dystrybucji plików wideo przez internet. Plik FLV można odtworzyć za pomocą zwykłej przeglądarki internetowej z wtyczką Adobe Flash Player lub Flash (praktycznie każda przeglądarka internetowa ma dodaną wtyczkę Adobe Flash - technologia flash nie jest obsługiwana przez urządzenia Apple oraz urządzenia mobilne oparte o system Android). Przy dodawaniu nowych filmów nazwy oraz opis są indywidualne dla każdej wersji językowej - pole plik oraz szerokość i wysokość są wspólne dla każdego języka i definiuje się je tylko w języku domyślnym. Przy dodawaniu filmów należy wybrać plik filmu poprzez 2-krotne kliknięcie w pole Plik filmu - po tym otworzy się przeglądarka plików z możliwością wybrania pliku wideo lub wgrania nowego z komputera klienta. Filmy FLV i MP4 są przechowywane na serwerze w tym samym katalogu (folderze) co zdjęcia produktów. Przy definiowaniu szerokości i wysokości należy pamiętać, żeby podane wartości nie były większe od kolumny sklepu w której będą prezentowane ponieważ może to spowodować złe wyświetlanie sklepu - pola należy uzupełnić dla poprawnego wyświetlania filmu. Jeżeli pola nie zostaną wypełnione sklep przyjmie wartości domyślne 300x300 pikseli. Ważne jest uzupełnienie nazwy filmu - bez nazwy film nie będzie wyświetlany. Pole opis nie jest obowiązkowe i bez wypełniania film będzie się wyświetlał. Do wyświetlania filmów FLV sklep wykorzystuje wbudowany odtwarzacz filmów wykonany w technologii Flash. <img alt=\"alt\" src=\"obrazki/pomoc/zakladka_flv_sklep.jpg\" style=\"width: 400px; height: 166px; float: right; margin-top: 15px; margin-left:15px;\" /> Dla filmów w formacie MP4 jest wykorzystywany odtwarzacz wbudowany w przeglądarkę internetową obsługujący tag html oznaczony jako video (film będzie również poprawnie wyświetlany na urządzeniach mobilnych). W przypadku jeżeli przeglądarka nie będzie obsługiwała znacznika html - video - będzie uruchamiany odtwarzacz flash.</div>\r\n"),
("24","124","1","instrukcja","Dodawanie / edycja - zakładka Pliki MP3","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zakladka_mp3.jpg\" style=\"width:700px;height:157px;float:left;margin-bottom:15px;margin-right:15px;\" />Zakładka Pliki MP3 umożliwia stworzenie na karcie produktu dodatkowej zakładki zawierającej pliki w formacie MP3. Do zakładki można dodać maksymalnie 100 plików mp3. Poszczególne pozycje (pliki mp3) dodaje się poprzez kliknięcie w przycisk <strong>dodaj kolejny utwór</strong>. Kliknięcie w przycisk powoduje wyświetlenie się pól do dodania kolejnego utworu. Przy dodawaniu nowych utworów - tytuł oraz opis są obowiązkowe. Jeżeli jedna z wartości nie będzie wypełniona utwór nie będzie wyświetlany w sklepie. W zakładce tej nie są rozróżnione tytuły dla różnych wersji językowych - tytuł utworu jest wspólny dla wszystkich języków. Wybór pliku następuje poprzez 2-krotne kliknęcie w pole Nazwa pliku - po tym otworzy się przeglądarka plików z możliwością wybrania pliku mp3 lub wgrania nowego z komputera klienta. Utwory MP3 są przechowywane na serwerze w tym samym katalogu (folderze) co zdjęcia produktów. Do odtwarzania plików MP3 sklep wykorzystuje wbudowany w odtwarzacz Dewplayer.</div>\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zakladka_mp3_sklep.jpg\" style=\"width:602px;height:113px;float:right;margin:15px;\" />"),
("25","125","1","instrukcja","Dodawanie / edycja - zakładka Dostępne wysyłki","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zakladka_wysylki.jpg\" style=\"width: 450px; height: 208px; float: left; margin-bottom: 15px; margin-right: 15px;\" />Zakładka Dostępne wysyłki umożliwia przypisanie do produktu określonych form wysyłki produktu. W przypadku niektórych produktów może występować sytuacja, że nie każdą formą dostawy da się przesłać do klienta produkt. Taka sytuacja może występować np w przypadku produktów gabarytowych, których nie da się wysłać za pośrednictem Poczty Polskiej. Jjeżeli produkt chcemy wysyłać tylko określonymi formami dostawy należy kliknąć na daną formę dostawy w oknie <strong>Lista wyboru</strong> po czym zostanie ona przeniesiona do okna <strong>Wybrane pozycje</strong>. Po wybraniu określonych form produkt będzie można wysłać tylko wybranymi formami dostawy. Jeżeli nie będzie wybrana żadna forma dostawy - domyślnie produkt będzie można wysłać każdą formą. W oknie Lista wyboru wyświetlane są wszystkie włączone w sklepie moduły wysyłek - menu <strong> Moduły / Wysyłki</strong> .</div>\r\n\r\n<div style=\"text-align:justify;\">Co w sytuacji jeżeli klient doda do koszyka 2 produkty które będą miały wybrane różne formy wysyłek ? W takiej sytacji klient nie będzie mógł zakupić produktu. Dlatego ważne jest żeby wszystkie produkty miały chociaż jedną wspólną formę wysyłki - np odbiór osobisty. Jeżeli do koszyka klient doda produkt który będzie miał przypisane tylko wysyłki kurierem, a drugi produkt który doda będzie miał dostępne wszystkie formy wysyłki to sklep wyświetli tylko formę dostawy kuriera - czyli takie które są wspólne dla obu produktów.</div>\r\n"),
("26","130","0","instrukcja","Produkty - duplikowanie produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkt_duplikowanie.jpg\" style=\"width: 600px; height: 278px; margin-bottom: 15px; margin-left: 15px; float: right;\" />Duplikowanie produktu jest podobne do dodawania nowego produktu w połączeniu z edycją produktu. Po kliknięciu w ikonę duplikowania produktu otwierane jest okno duplikowania - jest on identyczne jak w przypadku edycji produktu. W poszczególne pola i zakładki wstawione są wszystkie dane jakie znajdują się w źródłowym produkcie. Przed zapisaniem produktu można dokonać edycji / modyfikacji poszczególnych wartości - np nazwy produkty, ceny, cech itd. Po zapisaniu jest tworzony nowy produkt który posiada nowy unikalny nr ID.</div>\r\n"),
("27","130","0","instrukcja","Magazyn produktów","<div style=\"text-align:justify;\">Magazyn produktów ma podobną strukturę jak lista produktów. Jest jednak odrębnym modułem umożliwiającym szybsze i łatwiejsze zarządzanie magazynem produktów. W module tym podobnie jak w module produktów w oknie po prawej stronie wyświetlane są<strong> wszystkie produkty</strong> znajdujące się w bazie sklepu. Domyślnie produkty są posortowane wg nr id nadawanego automatycznie przy dodawaniu produktu do bazy sklepu. W oknie po lewej stronie wyświetlane są <strong>kategorie produktów</strong>. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko produkty z danej kategorii. Powyżej okien z produktami i kategoriami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych produktów które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii produktów - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania produktów w listingu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/magazyn_produktow.jpg\" style=\"width: 650px; height: 247px; float: left; margin-bottom: 15px; margin-right: 15px;\" />W liście produktów każdy produkt jest wyświetlany&nbsp;w osobnym wierszu. Pierwsza kolumna umożliwia zaznaczenie produktu (kilku produktów z listy) i dokonanie na nich określonej operacji, np. zmiany statu dostępności - zadanie do wykonania można wybrać na dole listy produktów, a zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Dzięki temu można szybko zmienić stan dostępności czy czas wysyłki wybranych produktów. Kolejna kolumna to id produktu. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu, kategorie do jakich produkt jest przypisany, nr katalogowy oraz nazwa producenta. Korzystając z górnych filtrów można wyświetlić w liście np. produkty tylko określonego producenta. Kolejna kolumna to stan magazynowy produktu. W polu tym można wpisać aktualny stan magazynowy produktu. <img alt=\"alt\" src=\"obrazki/pomoc/magazyn_produktow_cechy.jpg\" style=\"width:450px;height:107px;float:right;margin:15px;\" /> Jeżeli pole jest nieaktywne i przy polu wyświetla się znak wykrzyknika - oznacza to, że w sklepie włączona jest kontrola stanu magazynowego cech produktów - menu <strong> Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu</strong> . Wartości takiego pola nie można zmienić z poziomu listingu gdyż jest ono sumą stanów magazynowych poszczególnych cech produktu - żeby dokonać edycji należy wejść w edycję i wpisać stany magazynowe poszczególnych cech produktu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Kolejną kolumną w listingu jest stan dostępności oraz czas wysyłki - te pola można zmienić indywidualnie dla każdego produktu i zapisać poprzez naciśnięcie przycisku Zapisz zmiany na dole strony. Podobnie można z poziomu listingu zmienić status produktu odznaczając lub zaznaczając pole Status i zapisując zmiany.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycje magazynu produktu lub przejście do modułu produktów i edycję całego produktu. Po wciśnięciu edycji magazynu otwiera się podstrona która umożliwia wpisanie poszczególnych stanów magazynowych produktów oraz stanu dostępności produktu i czasu wysyłki. W zależności czy produkt ma cechy oraz wyświetlą sie opcje uzupełnienia parametrów cech lub nie (możliwość wpisania indywidualnej dostępności dla kombinacji cech czy numeru katalogowego).<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/magazyn_produktow_edycja_bez_cech.jpg\" style=\"width:220px;height:109px;float:left;margin-right:15px;margin-bottom:15px;\" /><img alt=\"alt\" src=\"obrazki/pomoc/magazyn_produktow_edycja_z_cechami.jpg\" style=\"float:right;width:350px;height:263px;margin-left:15px;margin-bottom:15px;\" />Obok po lewej stronie pokazany jest wygląd okna edycji dla produktu bez cech - można zmienić ilość produktu w magazynie, stan dostępności oraz czas wysyłki. Jeżeli produkt posiada cechy (przykład po prawej stronie) - okno edycji jest bardziej rozbudowane. Wyświetlane są dodatkowo cechy produktu we wszystkich możliwych kombinacjach - w każdej pozycji można zmienić stan magazynowy, dostępność oraz numer katalogowy. Pozostawienie pola dostępności jako <strong>-- brak --</strong> spowoduje, że przy wyświetlaniu danej cechy na karcie produktu w sklepie będzie wyświetlana wartość główna dostępności produktu zdefiniowana na dole okna edycji. Podobnie pozostawienie pustego pola nr katalogowy spowoduje, że będzie wyświetlany główny numer katalogowy produktu. Pole ilość wyświetla się tylko jeżeli włączona jest opcja <strong>powiązania cech z magazynem produktu</strong> - menu <strong> Konfiguracja / Ustawienia sklepu / Ustawienia magazynu</strong>. Jeżeli opcja jest wyłączona cechy nie mają własnych stanów magazynowych i do sprzedaży brany jest pod uwagę ogólny stan magazynowy produktu.</div>\r\n"),
("28","131","0","instrukcja","Cechy produktów","<div style=\"text-align:justify;\">Cechy produktu - często nazywane przez klientów także <strong>atrybutami</strong> lub <strong>wariantami</strong> produktu. Cechy (atrybuty, warianty) definiuje się w sklepie poprzez menu <strong> Asortyment / Cechy produktów</strong>. W przypadku sprzedaży internetowej częstym wyzwaniem dla sprzedającego jest organizacja produktów które oferowane są w różnych odmianach, wariantach. W sklepie można rozwiązać to w dwojaki sposób - <strong>dodać do sklepu kilka produktów</strong> - każdy taki sam lecz w innej odmianie - lub co jest lepszym rozwiązaniem <strong>dodać do sklepu jeden produkt</strong> i do produktu dodać odpowiednie cechy. Cechy produktu najłatwiej jest zrozumieć na przykładzie. Przyjmijmy, że sklep sprzedaje piżamy. Każda piżama występuje w kilku kolorach i rozmiarach. Załóżmy, że piżama nazywa się Piżama Party i występuje w kolorze czerwonym oraz niebieskim i rozmiarach S, L, XL. Jedynym z rozwiązań jest stworzenie kilku produktów z wariantami np Piżama Party czerwona S, Piżama Party czerwona L, Piżama Party niebieska S itd - czym więcej wariantów produktu tym więcej produktów trzeba by stworzyć - wadą tego rozwiązania jest to, że praktycznie każdy produkt jest taki sam, będzie miał ten sam opis - będzie się tylko różnił wariantem koloru i rozmiaru. Przy wielu produktach o różnych wariantach może być trudne zapanowanie nad magazynem takiego sklepu. Dlatego lepszym rozwiązaniem jest stworzenie cechy kolor oraz rozmiar które przy dodawaniu produktu będzie można przypisać do produktu, wskazując jakie warianty i wartości posiada dany produkt. Cechy w sklepie składają się z <strong>cech (wariantów)</strong> oraz <strong>wartości cech (wariantów)</strong>. Nazwą cechy będzie np kolor czy rozmiar, a wartościami np: czerwony, niebieski czy zielony.</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/cechy_produktu.jpg\" style=\"width: 600px; height: 232px; float: left; margin-top: 15px; margin-right: 15px; margin-bottom: 5px;\" />Przy dodawaniu cech w sklepie należy najpierw zdefiniować nazwy cech. Przy definiowaniu nowej nazwy cechy należy wprowadzić jej nazwę (osobno dla każdej wersji językowej - przełączenie na pole innej wersji językowej następuje poprzez kliknięcie na zakładkę z nazwą języka). Jeżeli nie zostanie uzupełniona nazwa cechy w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka. Poniżej pola z nazwą znajduje się pole edytora, w którym można wpisać opis cechy. Opis będzie wyświetlany na karcie produktu w dodatkowym oknie - po kliknięciu w nazwę danej cechy. Opis cechy może być przydatny w przypadku niektórych cech - np rozmiarów ubrań - gdzie jako opis można wpisać informacje na temat rozmiarówki. Opis cechy nie jest obowiązkowy, jeżeli cecha nie będzie miała uzupełnionego opisu na karcie produktu nie będzie wyświetlana ikona informacyjna obok nazwy cechy i nie będzie można wyświetlić opisu. <img alt=\"\" src=\"obrazki/pomoc/karta_produktu_cecha_z_opisem.jpg\" style=\"float: right; margin: 15px; width: 350px; height: 105px;\" />Kolejne pola do uzupełnienia to typ wyświetlania po stronie sklepu - cecha może być wyświetlana w formie obrazków lub jako tekst. Przy formie tekstowej należy dodatkowo wybrać czy będzie to lista rozwijana <img alt=\"alt\" src=\"obrazki/pomoc/cecha_select.jpg\" style=\"width:100px;height:23px;\" /> czy pola wyboru <img alt=\"alt\" src=\"obrazki/pomoc/cecha_radio.jpg\" style=\"width:196px;height:20px;\" />. Dalej można wybrać czy cecha ma być używana w filtrowaniu produktów w listingu produktów (np listingu z kategorii produktów). Klient będzie dzięki temu mógł filtrować produkty wybierając tylko te, które spełniają określone parametry. Przy dodawaniu cechy należy także określić jaka będzie wartość cechy - <strong>procentowa</strong> czy <strong>kwotowa</strong>. <img alt=\"alt\" src=\"obrazki/pomoc/cechy_produktu_sklep.jpg\" style=\"width:290px;height:133px;float:right;margin-top:15px;margin-left:15px;margin-bottom:15px;\" />Jest to istotne jeżeli cecha produktu ma wpływ na wartość końcową produktu. Jeżeli cecha ma wartość procentową - wartość cechy będzie obliczana na podstawie ilości procent od ceny bazowej produktu (bez uwzględnienia innych cech). Czyli np cena produktu to 400 zł - cecha kolor czerwony ma wartość 10% to po wyborze przez klienta danej cechy - cena produktu zmieni się na 440 zł. Jeżeli cecha ma wartość kwotową to zdefiniowana przy produkcie wartość kwotowa cechy będzie dodawana lub odejmowana do ceny bazowej produktu. Jeżeli dana cecha nie będzie wpływała na wartość produktu to nie ma znaczenia jaka opcja zostanie wybrana. Cechy mogą być wyświetlane w sklepie w określonej kolejności - należy w tym celu wypełnić pole sortowania (kolejność wyświetlania).<br />\r\n<br />\r\n<strong>UWAGA</strong> Cechy produktów będą wyświetlane w filtrach listingu dopiero po włączeniu wyświetlania filtrów cech w menu <strong>Konfiguracja / Ustawienia listingu produktów, kategorii i producentów</strong>.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Po zdefiniowaniu nazw cech można zdefiniować wartości poszczególnych cech. W tym celu należy kliknąć na wybrany wiersz w liście cech. Po kliknięciu wyświetli się w oknie po prawej stronie ramka z możliwością definiowania wartości dla wybranej cechy. Przy definiowaniu wartości należy podać jej nazwę (osobno dla każdej wersji językowej - tutaj podobnie jak przy nazwach cech - jeżeli nie zostanie uzupełniona nazwa w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka) oraz numer sortowania (kolejność wyświetlania) - wartości będą wyświetlane w odpowiedniej kolejności. Jeżeli cecha jest ceną obrazkową dodatkowo będzie wyświetlone pole do wybrania obrazka jaki ma być wartością cechy. Dodatkowo można określić czy dana wartość cechy ma być wyświetlana w sklepie. Jeżeli dana cecha nie będzie już występowała w produktach można wyłączyć jej wartość do wyświetlania w sklepie.</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/cechy_obrazki.jpg\" style=\"width: 250px; height: 91px; float: left; margin: 15px;\" /><br />\r\nPo zdefiniowaniu cech i ich wartości można przypisać poszczególne cechy do produktów - dodając nowy lub edytując istniejący produkt w menu <strong> Asortyment / Produkty</strong> . Po dodaniu cech - są one wyświetlane w sklepie na karcie produktu. Klient przed dokonaniem zakupu może wybrać interesujący go wariant.</div>\r\n"),
("29","133","0","instrukcja","Producenci","<div style=\"text-align:justify;\"><img alt=\"\" src=\"obrazki/pomoc/producenci.jpg\" style=\"margin-right: 15px; margin-bottom: 15px; float: left; width: 550px; height: 213px;\" />Moduł producentów umożliwia dodanie do sklepu danych producentów produktów. Producenci pozwalają grupować produkty podobnie jak kategorie produktów. Klient poruszając się po sklepie może wybrać wyświetlanie tylko produktów interesującego go producenta. Ważne jest żeby producentów dodać przed <strong>dodawaniem</strong> produktów ponieważ podczas dodawania produktu wybiera się z listy producenta produktu. Przy dodawaniu nowego producenta podaje się nazwę producenta - jest to pole wymagane i jest wspólne dla wszystkich wersji językowych. Dodatkowymi - nie wymaganymi polami są - zdjęcie (logo) producenta, znaczniki meta tagów oraz opis (ostatnie wartości są indywidualne dla różnych wersji językowych). Zalecamy żeby dodawać logo producenta gdyż jest ono używane w niektórych modułach wyświetlających produkty na stronie głównej oraz na karcie produktu - forma graficzna producenta jest bardziej atrakcyjna dla klienta. Opis producenta jest wyświetlany wraz z logotypem w listingu produktów po stronie sklepu - jeżeli klient wybierze wyświetlanie produktów dane producenta. Ważne jest także dodanie indywidualnych meta tagów dla producenta - tytułu, opisu i słów kluczowych - dodanie tych elementów ułatwi pozycjonowanie strony - jeżeli dane nie będą wypełnione sklep wstawi domyślne wartości meta tagów zdefiniowane w menu <strong> Pozycjonowanie / Meta Tagi / Wartości domyślne</strong>.<br />\r\n<br />\r\nPozycja <strong>Adres URL do producenta w poprzednim sklepie</strong> jest przeznaczona dla klientów, którzy posiadali wcześniej sklep na innej platformie sklepowej i przenoszą produkty do platformy shopGold. Dzięki tej opcji możliwe jest przekierowanie starych linków z poprzedniego sklepu na nową platformę sklepu. W polu adresu trzeba wpisać adres producenta jaki był w starym sklepie (sam link - bez adresu sklepu). Dzięki temu linki, które są dostępne np w wyszukiwarce google nie stracą swojej wartości, gdyż po ich kliknięciu w wynikach wyszukiwania klient zostanie przeniesiony na nowy adres w nowym sklepie. Do poprawnego działania przekierowań musi być włączony moduł przekierowań w menu Narzędzia / Przekierowanie URL.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/producenci_zakladka.jpg\" style=\"margin-left: 15px; margin-right: 15px; float: right; width: 340px; height: 146px;\" />Podczas dodawania lub edycji istniejącego producenta można także stworzyć <strong>dodatkową zakładkę </strong>dla produktów, która będzie wyświetlana na karcie produktu dla wszystkich produktów przypisanych dla danego producenta. Dzięki temu można w prosty sposób przypisać identyczny opis dla wszystkich produktów danego producenta. Żeby zakładka była wyświetlana w produktach musi być uzupełniona nazwa zakładki oraz treść zakładki.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Usuwanie / kasowanie producentów</strong> - z poziomu tego modułu można usunąć producenta. Z produktów które miały przypisanego producenta zostaną usunięte informacje o kasowanym producencie. Jeżeli zostanie zaznaczona opcja <strong>usuń całkowicie z bazy produkty przypisane do danego producenta</strong> produkty które miały przypisanego danego producenta zostaną całkowicie usunięte z bazy. Należy ostrożnie używać opcji kasowania, gdyż nie ma opcji przywrócenia (wycofania) opcji kasowania (np tak jak w Windowsie).</div>\r\n"),
("30","134","0","instrukcja","Promocje","<div style=\"text-align:justify;\">Promocje w sklepie są to produkty które mają 2 ceny - aktualną oraz poprzednią (przekreślona). Utworzenie w sklepie promocji ma na celu zachęcenie klienta do zakupu określonych produktów poprzez wskazanie, że produkt jest przeceniony i kiedyś był droższy niż aktualnie - czyli cenowo jest bardziej atrakcyjny. Produkty oznaczone jako promocje mogą mieć wyświetlaną na zdjęciu informację graficzną informującą, że są promocją. Ustawienie ikon na zdjęciach produktów definiuje się w menu <strong> Konfiguracja / Obrazki i dokumenty / Obrazki - ikony na zdjęciach</strong> .<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Moduł promocji w obsłudze jest zbliżony do modułu produktów czy magazynu produktów. Jest on powiązany z modułem produktów - wyświetla jednak tylko produkty promocyjne i umożliwia zarządzenie produktami promocyjnymi. W module tym po prawej stronie wyświetlane są<strong> wszystkie produkty oznaczone jako promocja</strong>. Domyślnie produkty są posortowane wg nr id nadawanego automatycznie przy dodawaniu produktu do bazy sklepu. W oknie po lewej stronie wyświetlane są <strong>kategorie produktów</strong>. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko produkty z danej kategorii. Powyżej okien z produktami i kategoriami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych produktów które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii produktów - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania produktów w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowego produktu jako promocji który otwiera formularz dodawania nowej pozycji.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/promocje.jpg\" style=\"width: 600px; height: 223px; float: left; margin-bottom: 15px; margin-right: 15px;\" />W liście produktów każdy produkt jest wyświetlany w osobnym wierszu.&nbsp; Pierwsza kolumna umożliwia zaznaczenie produktu (kilku produktów z listy) i dokonanie na nich określonej operacji, np. zmianę daty obowiązywania promocji czy zmianę ceny. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejna kolumna to id produktu. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu, kategorie do jakich produkt jest przypisany, nr katalogowy oraz nazwa producenta. Korzystając z górnych filtrów można wyświetlić w liście np. produkty tylko określonego producenta. Kolejne kolumny to datę rozpoczęcia obowiązywania promocji oraz data zakończenia. Jeżeli w miejscu daty jest znak &quot;minus&quot; to oznacza to, że data jest bezterminowa. W kolejnej kolumnie wyświetlana jest cena produktu (cena poprzednia oraz cena aktualna). <span style=\"color:#008000;\">Następna kolumna wyświetla w postaci ikonki informację czy dana promocja jest widoczna w sklepie. Ikona w kolorze szarym informuje, że produkt nie jest wyświetlany jako promocja, kolor zielony informuje, że promocja jest aktywna. Promocja nie będzie wyświetlana jeżeli data jej obowiązywania nie będzie obejmowała aktualnego czasu. Promocja zostanie aktywowana dopiero w momencie kiedy zacznie mieścić się w zdefiniowanym przedziale czasowym. Przy promocjach czasowych jeżeli promocja nie jest aktywna jako główna cena produktu jest wyświetlana <strong>cena poprzednia</strong>.</span> Dopiero jak promocja zostanie aktywowana będzie wyświetlana cena promocyjna. W kolejnej kolumnie wyświetlane jest pole statusu w którym można zmienić status produktu odznaczając lub zaznaczając pole i zapisując zmiany przyciskiem Zapisz zmiany na dole strony.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/promocja_edycja.jpg\" style=\"width: 425px; height: 187px; float: right; margin-left: 15px; margin-bottom: 15px;\" />W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję promocji lub usunięcie z produktu promocji oraz przejście do modułu produktów i edycję całego produktu. Po wciśnięciu edycji otwiera się podstrona która umożliwia zmianę parametrów promocji, w tym: datę rozpoczęcia lub zakończenia, cenę poprzednią - jest to wartość jaka będzie wyświetlana w sklepie jako przekreślona oraz wstawienie nowej ceny brutto produktu. Cena poprzednia powinna być większa od ceny głównej produktu i jest to pole wymagane - bez podania ceny poprzedniej promocja nie będzie wyświetlała się w sklepie. Pola daty mogą pozostać puste - wtedy produkt będzie wyświetlany cały czas jako promocja - dopóki administrator sklepu ręcznie nie wyłączy statusu promocji. Podczas edycji jeżeli w sklepie jest jest ustawiona większa ilość cen niż jedna - będzie można zdefiniować różne wartości ceny poprzedniej dla różnych poziomów cen produktu.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dodawanie_lista.jpg\" style=\"width:600px;height:130px;float:right;margin-left:15px;margin-bottom:15px;\" />Podczas dodawania nowej promocji wyświetla się formularz dodawania nowej pozycji - w pierwszym kroku zostanie wyświetlona lista kategorii produktów. Należy wybrać z której kategorii będzie dodawany produkt.&nbsp;Można także wyszukać produkty korzystając z wyszukiwarki produktów. Po wybraniu kategorii lub wpisaniu nazwy produktu w wyszukiwarce - po prawej stronie w oknie wyświetli się lista znalezionych produktów.&nbsp; Jest to skrócona forma listingu - zawiera podstawowe dane: id, zdjęcie, ceną, nr katalogowy oraz nazwę - wyświetla także stan produktu - czy produkt jest aktywny czy wyłączony. Z listy należy wybrać produkt który będzie dodawany jako promocja. Po kliknięciu w produkt poniżej listy produktów wyświetli się dodatkowy formularz który należy wypełnić. Formularz jest identyczny jak w przypadku edycji promocji.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>WAŻNE:</strong></span> Jeżeli podczas edycji czy dodawania nowej promocji data rozpoczęcia promocji będzie większa od daty bieżącej lub data zakończenia mniejsza od daty bieżącej to produkt po zapisaniu n<strong>ie będzie wyświetlany jako promocja, a jako cena produktu będzie wyświetlana cena poprzednia.</strong> Podczas działania sklepu - sklep sprawdza jakie daty promocji mają produkty. Jeżeli data rozpoczęcia zrówna się z bieżącą produkt zostanie <strong>włączony</strong> jako promocja. Jeżeli data zakończenia będzie mniejsza niż bieżąca sklep automatycznie <strong>wyłączy</strong> promocję i będzie wyświetlał produkt z ceną poprzednią jako ceną główną produktu.</div>\r\n"),
("31","251","0","instrukcja","Klienci","<div style=\"text-align:justify;\">Moduł Klienci umożliwia zarządzanie bazą wszystkich klientów, którzy są zarejestrowani w sklepie. Pozwala na przeglądanie danych, edycję oraz dodawanie nowych klientów przez obsługę sklepu.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klienci.jpg\" style=\"border-width: 0px; border-style: solid; margin-right: 15px; margin-bottom: 15px; width: 650px; height: 136px; float: left;\" />Po wybraniu z menu opcji<strong> Sprzedaż / Klienci</strong> wyświetlana jest lista wszystkich klientów sklepu. Lista pozwala na filtrowanie i wyszukiwanie określonych danych według zadanych parametrów. Na liście wyświetlane są kolejno informacje o każdym kliencie: jego id w bazie danych, dane adresowe (jeżeli jest to klient, który dokonywał zakupu bez rejestracji, to przy jego danych pojawia się odpowiednia ikonka informująca o tym fakcie) i dane kontaktowe. Jeżeli klient złożył więcej niż dwa zamówienia jest traktowany jako stały klient - wyświetlana jest dodatkowa ikonka&nbsp;<img alt=\"alt\" src=\"obrazki/pomoc/staly_klient.png\" style=\"width:16px;height:16px;\" />. Następnie są wyświetlane informacje o tym do jakiej grupy jest przypisany dany klient, kiedy dokonał w sklepie rejestracji, ile złożył dotychczas zamówień. Są także informacje o tym, czy klient aktualnie posiada jakieś produkty w koszyku lub schowku (po wejściu w szczegółowe informacje o wybranym kliencie jest możliwość szczegółowego podglądu zawartości koszyka i schowka). Jeżeli w sklepie jest włączony system punktów - mamy od razu informację o punktach, które dotychczas klient zgromadził na swoim koncie.<br />\r\n<br />\r\nW przedostatniej kolumnie wyświetlana jest ikona informująca czy dany klient ma aktywne konto czy jest nieaktywne. Zielony kolor ikonki oznacza, że konto jest aktywne i klient może dokonywać w sklepie zakupów. Szary kolor oznacza, że konto nie jest aktywne i klient nie ma możliwości zalogowania się w sklepie. Kliknięcie w ikonkę powoduje aktywacje / dezaktywację konta. W przypadku jeżeli konto nie jest aktywne - obok ikonki statusu wyświetlana jest ikonka maila. Umożliwia ona aktywację konta klienta wraz z wysłaniem do niego wiadomości email o aktywacji. Z wysyłaniem maila do klienta o aktywacji konta, powiązany mail w menu <strong>Konfiguracja / Słowniki / Treści wiadomości email</strong> o nazwie <strong>Aktywacja konta klienta w panelu zarządzania</strong>. W tym miejscu zdefiniowana jest treść maila jaka jest wysyłana do klienta.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję danych klienta, wyświetlenie listy wszystkich jego dotychczasowych zamówień, wysłania bezpośrednio wiadomości e-mail lub SMS (pod warunkiem ze klient podał poprawny numer telefonu GSM i w sklepie jest aktywna opcja wysyłania powiadomień SMS). Można także ręcznie zmienić klientowi hasło lub usunąć jego konto.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klient_wyslij_email.jpg\" style=\"width:400px;height:355px;margin-right:15px;margin-left:15px;float:right;\" />Po wybraniu ikonki wysłania do klienta wiadomości e-mail wyświetlany jest formularz umożliwiający wysłanie maila bezpośrednio ze sklepu do klienta. Do każdej wiadomości można wybrać wcześniej zdefiniowany szablon, a także dołączyć pliki w formie załączników. W menu <strong> Konfiguracja / Komunikacja / Opcje e-mail</strong> można zdefiniować maksymalną ilość załączników jakie można dodać do wysyłanej wiadomości oraz dopuszczalny format plików.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Jeżeli w sklepie jest włączona opcja korzystania z powiadomień SMS, to po kliknięciu w ikonkę telefonu administrator sklepu ma możliwość wysłania do klienta wiadomości SMS o dowolnie wpisanej treści. Warunkiem jest wpisanie w danych klienta poprawnego numeru telefonu GSM. Do korzystania z opcji wysyłania wiadomości SMS jest niezbędne posiadanie konta w serwisie smsAPI.pl - koszty wysyłanych wiadomości są według cennika smsAPI.pl</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Pozostałe ikonki umożliwiają wykonywanie takich działań jak: zmiana hasła klienta, wyświetlenie listy wszystkich jego zamówień, podgląd schowka, koszyka czy zapisanych koszyków klienta oraz całkowite usunięcie konta z bazy danych.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/klienci_czarna_lista_dodawanie.jpg\" style=\"margin-bottom: 10px; margin-right: 15px; float: left; width: 380px; height: 365px;\" />Dodatkowo jest dostępna ikona dodania klienta do tzw &quot;czarnej listy klientów&quot;. Po kliknięciu w ikonkę zostanie otworzona nowa podstrona gdzie można dodać klienta do czarnej listy oraz wybrać jakie dane mają do tej listy dodane.<br />\r\n<br />\r\nDane klienta zostaną dodane do klientów czarnej listy i nowych zamówieniach sklep będzie sprawdzał czy dane zamówienie nie jest &quot;podejrzane&quot; i powiązane z klientem, który znajduje się na czarnej liście. Podczas dodawania klienta do czarnej listy sklep proponuje jakie dane mają zostać dodane. Można usunąć część danych - np imię. Można także zmienić dane ulicy - pozostawiając samą nazwę ulicy bez numeru domu i mieszkania.<br />\r\n<br />\r\nPodczas składania zamówienia sklep sprawdzi czy na &quot;czarnej liście&quot; nie znajduję się klient o podobnych danych jak w złożonym zamówieniu. Sklep sprawdza: id klienta w bazie, imię i nazwisko, firmę, nip, adres, email, nr telefonu oraz&nbsp; adres IP klienta. Jeżeli zostanie znaleziony klient o takim samym id, email lub adresie IP - zamówienie zostanie oznaczone jako &quot;podejrzane&quot;. Jeżeli id, email i adres IP będą inne ale zostaną znalezione 3 inne wspólne parametry - np ulica, miasto i nazwisko - wtedy także zamówienie zostanie oznaczone jako &quot;podejrzane&quot; - umożliwia to wychwytywanie zamówień klientów, którzy zmienili adres email, założyli nowe konto lub korzystają ze zmiennego adresu IP. Dlatego podczas dodawania danych klienta do czarnej listy zalecamy wpisywanie samej nazwy ulicy (bez nr), nr telefonu i kodu pocztowego w formie liczbowej (bez spacji, myślników) - maksymalnie uproszczony format zapisu zwiększa prawdopodobieństwo wyszukania poprawnych powiązań.<br />\r\n<br />\r\nKlient dodany do &quot;czarnej listy&quot; w listingu produktów jest wyświetlany z ikoną czarnego, przekreślonego kółka oraz tło jest w postaci szarych kresek. Umożliwia to łatwe odróżnienie klientów, którzy zostali przypisani do &quot;czarnej listy&quot;.<br />\r\n<br />\r\nJeżeli klient ma zostać wypisany z &quot;czarnej listy&quot; trzeba kliknąć w tą samą ikonkę, która służy do dodania klienta do &quot;czarnej listy&quot;.</div>\r\n"),
("32","135","0","instrukcja","Nasz hit","<div style=\"text-align:justify;\">Moduł hitów umożliwia ustawienie wybranych produktów jako hity. Takie produkty są wyświetlane w sklepie w modułach <strong>HITY</strong> przez co mogą być bardziej eksponowane na stronie sklepu niż inne produkty. Generalnie na stronie powinnien być 1 - 2 hity - należy wybierać jako hit produkt od którego oczekujemy największej sprzedaży. Dodatkowo hit można połączyć z promocją - dodając produkt również do promocji. Produkty oznaczone jako hity mogą mieć wyświetlaną na zdjęciu informację graficzną - informującą, że są hitem. Ustawienie ikon na zdjęciach produktów definiuje się w menu <strong> Konfiguracja / Obrazki i dokumenty / Obrazki - ikony na zdjęciach</strong> .<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Moduł nasz hit jest podobny w obsłudze do modułu produktów czy promocji. Jest on powiązany z modułem produktów - wyświetla jednak tylko produkty oznaczone jako hity i umożliwia zarządzenie nimi. W module tym w oknie po prawej stronie wyświetlane są<strong> wszystkie produkty które są oznaczone jako hit</strong>. Domyślnie produkty są posortowane wg nr id nadawanego automatycznie przy dodawaniu produktu do bazy sklepu. W oknie po lewej stronie wyświetlane są <strong>kategorie produktów</strong>. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko produkty z danej kategorii. Powyżej okien z produktami i kategoriami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych produktów które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii produktów - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania produktów w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowego produktu jako hitu który otwiera formularz dodawania nowej pozycji.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/hity.jpg\" style=\"width: 600px; height: 243px; float: left; margin-bottom: 15px; margin-right: 15px;\" />W liście produktów każdy produkt jest wyświetlany w osobnym wierszu. Pierwsza kolumna umożliwia zaznaczenie produktu (kilku produktów z listy) i dokonanie na nich określonej operacji, np. zmianę daty obowiązywania hitu. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejna kolumna to id produktu. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu, kategorie do jakich produkt jest przypisany, nr katalogowy oraz nazwa producenta. Korzystając z górnych filtrów można wyświetlić w liście np. produkty tylko określonego producenta. Kolejne kolumny to data rozpoczęcia obowiązywania hitu oraz data zakończenia. Jeżeli w miejscu daty jest znak &quot;minus&quot; to oznacza to, że data jest bezterminowa. W kolejnej kolumnie wyświetlana jest cena produktu. Kolejna kolumna to Widok. Obrazuje ona czy produkt jest w sklepie wyświetlany jako hit. Jeżeli ikona ma kolor zielony, znaczy to, że produkt jest wyświetlany jako hit, jeżeli szary - produkt nie jest wyświetlany jako hit. Wyłączenie wyświetlania następuje jeżeli data rozpoczęcia jest większa od daty bieżącej lub data zakończenia jest mniejsza od bieżącej. Podczas działania sklepu - sklep sprawdza jakie daty hitów mają produkty. Jeżeli data rozpoczęcia zrówna się z bieżącą wyświetlanie produktu jako hitu zostanie <strong>włączone</strong>. Jeżeli data zakończenia będzie mniejsza niż bieżąca sklep automatycznie <strong>wyłączy</strong> wyświetlanie produktu jako hitu.W kolejnej kolumnie wyświetlane jest pole statusu w którym można zmienić status produktu odznaczając lub zaznaczając pole i zapisując zmiany przyciskiem Zapisz zmiany na dole strony.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję hitu lub usunięcie z produktu statusu hitu oraz przejście do modułu produktów i edycję całego produktu. Po wciśnięciu edycji otwiera się podstrona która umożliwia zmianę parametrów hitu: datę rozpoczęcia lub zakończenia. Jeżeli pola pozostaną puste produkt będzie wyświetlany jako hit cały czas - dopóki administrator sklepu ręcznie nie wyłączy statusu hit.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dodawanie_lista.jpg\" style=\"width:600px;height:130px;float:right;margin-left:15px;margin-bottom:15px;\" /> Podczas dodawania nowego hitu wyświetla się formularz dodawania nowej pozycji - w pierwszym kroku zostanie wyświetlona lista kategorii produktów. Należy wybrać z której kategorii będzie dodawany produkt.&nbsp;Można także wyszukać produkty korzystając z wyszukiwarki produktów. Po wybraniu kategorii lub wpisaniu nazwy produktu w wyszukiwarce - po prawej stronie w oknie wyświetli się lista znalezionych produktów. Jest to skrócona forma listingu - zawiera podstawowe dane: id, zdjęcie, ceną, nr katalogowy oraz nazwę - wyświetla także stan produktu - czy produkt jest aktywny czy wyłączony. Z listy należy wybrać produkt który będzie dodawany jako hit. Po kliknięciu w produkt poniżej listy produktów wyświetli się dodatkowy formularz który należy wypełnić. Formularz jest identyczny jak w przypadku edycji hitu.</div>\r\n"),
("33","136","0","instrukcja","Produkty polecane","<div style=\"text-align:justify;\">Moduł produkty polecane umożliwia ustawienie wybranych produktów jako polecane. Jest on praktycznie identyczny jak hity - z tą rożnicą ze produkty zostają przypisane do grupy polecanych, a nie hitów. Produkty oznaczone w sklepie jako polecane są wyświetlane w modułach<strong> PRODUKTY POLECANE</strong> przez co mogą być bardziej eksponowane na stronie sklepu niż inne produkty. W porównaniu z hitami produktów polecanych może być więcej niż 1 - 2, chociaż także nie powinno być ich za dużo - żeby klienci nie odnieśli wrażenia, że każdy produkt ma taki status. Dodatkowo produkt polecany można połączyć z promocją - dodając produkt również do promocji. Produkty oznaczone jako polecane mogą mieć wyświetlaną na zdjęciu informację graficzną - informującą, że są polecane. Ustawienie ikon na zdjęciach produktów definiuje się w menu <strong> Konfiguracja / Obrazki i dokumenty / Obrazki - ikony na zdjęciach</strong> .</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Moduł produkty polecane jest podobny w obsłudze do modułu produktów czy hitów. Jest on powiązany z modułem produktów - wyświetla jednak tylko produkty oznaczone jako polecane i umożliwia zarządzenie nimi. W module tym w oknie po prawej stronie wyświetlane są<strong> wszystkie produkty które są oznaczone jako produkty polecane</strong>. Domyślnie produkty są posortowane wg nr id nadawanego automatycznie przy dodawaniu produktu do bazy sklepu. W oknie po lewej stronie wyświetlane są <strong>kategorie produktów</strong>. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko produkty z danej kategorii. Powyżej okien z produktami i kategoriami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych produktów które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii produktów - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania produktów w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowego produktu jako polecanego który otwiera formularz dodawania nowej pozycji.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/hity.jpg\" style=\"width: 600px; height: 243px; float: left; margin-bottom: 15px; margin-right: 15px;\" />W liście produktów każdy produkt jest wyświetlany w osobnym wierszu.&nbsp; Pierwsza kolumna umożliwia zaznaczenie produktu (kilku produktów z listy) i dokonanie na nich określonej operacji, np. zmianę daty obowiązywania produktu poleconego. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejna kolumna to id produktu. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu, kategorie do jakich produkt jest przypisany, nr katalogowy oraz nazwa producenta. Korzystając z górnych filtrów można wyświetlić w liście np. produkty tylko określonego producenta. Kolejne kolumny to data rozpoczęcia obowiązywania produktu poleconego oraz data zakończenia. Jeżeli w miejscu daty jest znak &quot;minus&quot; to oznacza to, że data jest bezterminowa. W kolejnej kolumnie wyświetlana jest cena produktu. Kolejna kolumna to Widok. Obrazuje ona czy produkt jest w sklepie wyświetlany jako polecany. Jeżeli ikona ma kolor zielony, znaczy to, że produkt jest wyświetlany jako polecany, jeżeli szary - produkt nie jest wyświetlany jako polecany. Wyłączenie wyświetlania następuje jeżeli data rozpoczęcia jest większa od daty bieżącej lub data zakończenia jest mniejsza od bieżącej. Podczas działania sklepu - sklep sprawdza jakie daty mają produkty polecane. Jeżeli data rozpoczęcia zrówna się z bieżącą wyświetlanie produktu jako polecanego zostanie <strong>włączone</strong>. Jeżeli data zakończenia będzie mniejsza niż bieżąca sklep automatycznie <strong>wyłączy</strong> wyświetlanie produktu jako polecanego.W kolejnej kolumnie wyświetlane jest pole statusu w którym można zmienić status produktu odznaczając lub zaznaczając pole i zapisując zmiany przyciskiem Zapisz zmiany na dole strony.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję produktu polecanego, usunięcie statusu produktu polecanego oraz przejście do modułu produktów i edycję całego produktu. Po wciśnięciu edycji otwiera się podstrona która umożliwia zmianę parametrów: datę rozpoczęcia lub zakończenia. Jeżeli pola pozostaną puste produkt będzie wyświetlany jako produkt polecany cały czas - dopóki administrator sklepu ręcznie nie wyłączy statusu polecany.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dodawanie_lista.jpg\" style=\"width:600px;height:130px;float:right;margin-left:15px;margin-bottom:15px;\" /> Podczas dodawania nowego produktu polecanego wyświetla się formularz dodawania nowej pozycji - w pierwszym kroku zostanie wyświetlona lista kategorii produktów. Należy wybrać z której kategorii będzie dodawany produkt.&nbsp;Można także wyszukać produkty korzystając z wyszukiwarki produktów. Po wybraniu kategorii lub wpisaniu nazwy produktu w wyszukiwarce - po prawej stronie w oknie wyświetli się lista znalezionych produktów. Jest to skrócona forma listingu - zawiera podstawowe dane: id, zdjęcie, ceną, nr katalogowy oraz nazwę - wyświetla także stan produktu - czy produkt jest aktywny czy wyłączony. Z listy należy wybrać produkt który będzie dodawany jako polecany. Po kliknięciu w produkt poniżej listy produktów wyświetli się dodatkowy formularz który należy wypełnić. Formularz jest identyczny jak w przypadku edycji.</div>\r\n"),
("34","137","0","instrukcja","Recenzje","<div style=\"text-align:justify;\">Recenzje produktów (opinie o produkcie) są istotnym elementem zachęcającym klientów do zakupu produktów. Opinie innych użytkowników często mają istotny wpływ na zakup danego produktu przez potencjalnego klienta. Dlatego warto w sklepie zachęcać klientów do pisania recenzji o produktach. Sklep daje możliwość nagradzania klientów którzy napiszą recenzję dla produktu określoną ilością punktów z systemu punktów - menu <strong> Sprzedaż / Klienci / Konfiguracja systemu punktów</strong> . W menu tym można określić jaką ilość punktów otrzyma użytkownik sklepu za napisanie recenzji do produktu. W ten sposób można zachęcić klientów do pisania nowych recenzji co z pewnością przełoży się na sprzedaż opiniowanych produktów.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Sam moduł recenzji umożliwia zarządzanie napisanymi przez klientów recenzjami. Zarządzanie recenzjami odbywa się poprzez menu <strong>Asortyment / Recenzje / Zarządzanie recenzjami</strong>. Moduł recenzje jest w obsłudze podobny do innych modułów z menu <strong> Asortyment</strong> . W module tym w oknie po prawej stronie wyświetlane są<strong> wszystkie recenzje (produkty które które mają recenzje)</strong>. Domyślnie recenzje są posortowane wg daty dodania recenzji. W oknie po lewej stronie wyświetlane są <strong>kategorie produktów</strong>. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko recenzje (produkty z recenzjami) z danej kategorii. Powyżej okien z recenzjami i kategoriami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych recenzji które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii produktów - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania recenzji w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowej recenzji. Jest to przydatny moduł jeżeli chcemy dodać własne opinie o produktach lub wstawić opinie o produkcie z innych źródeł.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/recenzje.jpg\" style=\"width: 600px; height: 177px; float: left; margin-bottom: 15px; margin-right: 15px; margin-top: 15px;\" />W liście recenzji każda recenzja jest wyświetlana w osobnym wierszu.&nbsp; Pierwsza kolumna umożliwia zaznaczenie recenzji (kilku recenzji z listy) i dokonanie na nich określonej operacji, np. usunięcie recenzji. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejne dwie kolumny wyświetlają id - pierwsza id recenzji, druga to id produktu. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu, kategorie do jakich produkt jest przypisany, nr katalogowy oraz nazwa producenta. Korzystając z górnych filtrów można wyświetlić w liście np. produkty tylko określonego producenta. Kolejna kolumna jest dość rozbudowana i zawiera dane o recenzji: datę dodania, autora recenzji (jeżeli przy autorze znajduję się ikona <img alt=\"alt\" src=\"obrazki/pomoc/klient.png\" style=\"width:16px;height:16px;\" /> oznacza to, że autorem recenzji jest klient który jest zarejestrowany w sklepie i automatycznie nazwa takiego klienta staje się linkiem do jego konta). Poniżej autora znajduje się jego ocena produktu oraz treść recenzji. Kolejna kolumna to Zatwierdzona. Obrazuje ona czy dana recenzja została zatwierdzona przez obsługę sklepu i jest wyświetlana w sklepie, czy nie jest zatwierdzona i jest nieaktywna. Każda nowo napisana przez klienta recenzja otrzymuje status <strong>niezatwierdzona</strong>. Jest to zabezpieczenie przed pisaniem przez klientów tekstów i opinii których właściciel sklepu nie życzy sobie na stronie. Dlatego każda recenzja musi być przeczytana przez właściciela sklepu i ręcznie zaakceptowana. W kolejnej kolumnie wyświetlane jest pole statusu w którym można zmienić status produktu odznaczając lub zaznaczając pole i zapisując zmiany przyciskiem Zapisz zmiany na dole strony.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję recenzji, usunięcie recenzji oraz przejście do modułu produktów i edycję całego produktu. Po wciśnięciu edycji otwiera się podstrona która umożliwia zmianę parametrów: autora, daty dodania, języka recenzji oraz treści opinii i samej oceny produktu.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dodawanie_lista.jpg\" style=\"width:600px;height:130px;float:right;margin-left:15px;margin-bottom:15px;\" />Podczas dodawania nowej recenzji w pierwszym kroku zostanie wyświetlona lista kategorii produktów. Należy wybrać z której kategorii będzie recenzowany produkt.&nbsp;Można także wyszukać produkty korzystając z wyszukiwarki produktów. Po wybraniu kategorii lub wpisaniu nazwy produktu w wyszukiwarce - po prawej stronie w oknie wyświetli się lista znalezionych produktów. Jest to skrócona forma listingu - zawiera podstawowe dane: id, zdjęcie, ceną, nr katalogowy oraz nazwę - wyświetla także stan produktu - czy produkt jest aktywny czy wyłączony. Z listy należy wybrać produkt który będzie recenzowany. Po kliknięciu w produkt poniżej listy produktów wyświetli się dodatkowy formularz który należy wypełnić. Formularz jest identyczny jak w przypadku edycji recenzji. Po zapisaniu nowo dodana recenzja automatycznie otrzymuje status - <strong>zatwierdzona</strong>.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>WAŻNE:</strong></span> Podczas zatwierdzania recenzji (jeżeli w systemie jest włączone nagradzanie klientów punktami za napisanie recenzji) automatycznie zostaną zatwierdzone punkty klienta który napisał daną recenzję (tylko punkty za napisanie zatwierdzanej opinii) i punkty zostaną dodane do jego konta punktów.<br />\r\n<br />\r\nW menu <strong>Asortyment / Recenzje / Konfiguracja recenzji</strong> dokonuje się ustawień i konfiguracji modułu. Można w tym miejscu włączyć moduł recenzji o produktach. Można wybrać czy recenzje o sklepie mogą dodawać tylko klienci zalogowani czy wszyscy klienci. Jedną z opcji modułu jest możliwość automatycznego wysyłania do klientów, którzy złożyli zamówienia w sklepie - prośby o wystawienie recenzji do zakupionych produktów. W konfiguracji modułu można ustawić czy maile mają być wysyłane, po ilu dniach od złożenia zamówienia ma zostać wysłany mail oraz dla zamówień o jakich statusach maja być wysyłane maile.<br />\r\n<br />\r\nZ wysyłaniem maili do klientów z prośbą o wystawienie opinii jest powiązany mail w menu <strong>Konfiguracja / Słowniki / Treści wiadomości email</strong> o nazwie <strong>Recenzja o produktach</strong>. W tym miejscu zdefiniowana jest treść maila jaka jest wysyłana do klienta z prośbą o napisanie recenzji. W treści maila jest zawarte są linki, które przenoszą bezpośrednio do strony umożliwiającej wystawienie recenzji do produktów.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/recenzje_zamowienia.jpg\" style=\"margin-top: 10px; margin-left: 15px; margin-bottom: 10px; float: right; width: 650px; height: 208px;\" />Informacja o wysłaniu do klienta maila z prośba o recenzje o produktach jest widoczna w liście zamówień w menu <strong>Sprzedaż / Zamówienie / Zarządzanie zamówieniami</strong>. Znajdują się tam dodatkowe ikonki informacyjne w kolumnie tabeli o nazwie Opinia / Recenzje. Ikonka w kolorze zielonym oznacza, że do tego zamówienia został wysłany mail z prośbą o napisanie recenzji. Najechanie kursorem myszy na ikonę powoduje wyświetlenie informacji - kiedy mail został wysłany. Ikonka obok umożliwia wysłanie do klienta maila z prośbą o napisanie recenzji. Po kliknięciu w ikonkę otwiera się nowa podstrona z wygenerowaną treścią maila i możliwością wysłania do klienta wiadomości.<br />\r\n<br />\r\nIkonki recenzji są widoczne tylko jeżeli jest w sklepie włączony moduł Recenzji w menu <strong>Asortyment / Recenzje / Konfiguracja opinii o sklepie</strong> .</div>\r\n"),
("35","251","1","instrukcja","Dodawanie / edycja - zakładka Podstawowe dane","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klient_dane_podstawowe.jpg\" style=\"width: 550px; height: 550px; margin-right: 15px; margin-bottom: 15px; float: left;\" />W trybie edycji czy dodawania klienta dane o kliencie wyświetlane są w formie zakładek. Przełączając między zakładkami z lewej strony można wprowadzić poszczególne pozycje dotyczące danego klienta, a także w trybie edycji przejrzeć jego statystyki. Jeżeli edytuje się dane klienta bez rejestracji to ilość zakładek jest ograniczona - nie ma np zakładki z koszykiem czy schowkiem. Takie zakładki są zarezerwowane wyłącznie dla klientów zarejestrowanych w sklepie.<br />\r\n<br />\r\nPierwsza główna zakładka klienta to <strong>Podstawowe dane</strong>. Zawiera ona podstawowe dane klienta związane z jego kontem. Z poziomu tej zakładki wpisujemy następujące dane:</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Status konta</strong> - określa czy konto jest w sklepie aktywne i klient może się za jego pośrednictwem zalogować i wykonywać zakupy. Administrator sklepu może w każdej chwili zmienić status konta. W przypadku gdy w sklepie jest ustawiona opcja ręcznej aktywacji klientów (w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia dla hurtowni</strong> - Czy konto nowego klienta ma być aktywne od razu po rejestracji) wówczas każdy nowo zarejestrowany klient wymaga ręcznej aktywacji konta w trybie edycji danych.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Adres e-mail</strong> - jest to podstawowy identyfikator klienta w sklepie. Adres ten służy zarówno do logowania klienta do sklepu jak i do korespondencji mailowej związanej z realizacją zamówień biuletynami, itp.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Login</strong> - to pole jest opcjonalne i nie jest wymagane. Jeżeli jest wypełnione, to wówczas może być wykorzystywane do logowania zamiennie z adresem e-mail.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Data urodzenia</strong> - pole opcjonalne, które można włączyć/wyłączyć w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia pól klientów</strong>.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Grupa klientów</strong> - Każdy klient może być przypisany do określonej grupy. Każda grupa klientów (definiowana w menu <strong>Sprzedaż /Klienci / Rabaty grup klientów - grupy klientów</strong> - może mieć ustalony ogólny rabat na wszystkie produkty bądź indywidualne ceny). Przypisanie wybranego klienta do określonej grupy powoduje, iż po zalogowaniu w sklepie obowiązują go ceny oraz zasady obowiązujące do grupy, do której on należy.<br />\r\n<br />\r\n<strong>Id klienta w programie magazynowym</strong> - unikalny id klienta w zewnętrznym programie magazynowym lub fakturującym. Pole może być użyte do powiązania sklepu z programem magazynowym / fakturującym w którym klienci mają inne id niż w sklepie.<br />\r\n<br />\r\n<strong>Opiekun klienta</strong> - w tym miejscu można przypisać do klienta opiekuna - osobę odpowiedzialną w sklepie za obsługę zamówień tego klienta (opiekunami zamówień mogą być osoby - administratorzy - dodane w panelu zarządzania do grupy <span style=\"color:#FF0000;\"><strong>Obsługa sprzedaży</strong></span> w menu <strong>Narzędzia / Grupy użytkowników</strong>). W przypadku przypisania do klienta opiekuna - automatycznie do wszystkich zamówień danego klienta będzie przypisywany dany opiekun.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Subskrypcja biuletynu</strong> - opcja określająca czy dany klient będzie otrzymywał biuletyn rozsyłany ze sklepu. Klient może otrzymywać wszystkie wysyłane biuletyny, jak również można zdefiniować określone grupy i wówczas będzie otrzymywał tylko biuletyny wysyłane do danych grup.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Dodatkowe pola</strong> - jest to element, który można samodzielnie zdefiniować w menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do klientów</strong>. Administrator sklepu może zdefiniować dowolne pola wg własnych potrzeb. Mogą to być pola typu tekstowego, listy wyboru, itp. Można zdefiniować czy pola mają być wymagane podczas rejestracji klienta czy nie. Opcja ta jest szczegółowo opisana w instrukcji w części dotyczącej definiowania własnych pól dla klientów..</div>\r\n"),
("36","252","1","instrukcja","Dodawanie / edycja - zakładka Dane adresowe","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klient_dane_adresowe.jpg\" style=\"width: 550px; height: 419px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Zawartość tej zakładki umożliwia wprowadzenie danych dotyczących wysyłki zamawianych produktów. Standardowo są to dane zarówno do wysyłki jak i dokumentu sprzedaży.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Podczas dopisywania zamówienia można jednak wprowadzić inne dane dotyczące płatnika, jeżeli jest taka potrzeba.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Zawartość tego formularza jest zmienna w zależności od tego czy wprowadzany klient jest osobą fizyczną czy firma. Zależnie od wybranej osobowości prawnej wyświetlane są pola na wprowadzenie numeru PESEL lub danych firmy (NIP i nazwa).<br />\r\n<br />\r\nJeżeli klient ma zdefiniowanych kilka adresów dostaw - pod formularzem edycji danych są wyświetlane dodatkowo zdefiniowane adresy dostaw. Każdy dodatkowy adres można edytować lub usunąć z konta klienta. Klient na swoim koncie ma możliwość zdefiniowania dowolnej ilości adresów dostaw - podczas składania zamówienia w sklepie może dzięki temu wybrać inny adres dostawy (bez konieczności wpisywania danych) niż adres podstawowy klienta.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Pole określające województwo może być wyłączone w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia pól klientów</strong>.</div>\r\n"),
("37","252","1","instrukcja","Edycja - zakładka Zawartość koszyka / schowka","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klient_zawartosc_koszyka.jpg\" style=\"width:700px;height:145px;margin-left:15px;margin-bottom:15px;float:right;\" />Zakładki <strong>Zawartość koszyka</strong> oraz <strong>Zawartość schowka</strong> widoczne podczas edycji klienta realizują analogiczne funkcje. Pozwalają one sprawdzić co dany klient ma zapisane w koszyku lub schowku. Dotyczy to tylko zarejestrowanych klientów. Każdy klient, który posiada konto w sklepie i jest zalogowany - jeżeli dodaje coś do koszyka lub schowka, to jest to zapisywane w bazie danych.</div>\r\n\r\n<div style=\"text-align:center;\">&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Wyświetlane są tutaj podstawowe dane o produkcie takie jak jego zdjęcie, nazwa, ilość ile klient ma w koszyku danego produktu oraz jego aktualny status - to znaczy czy produkt jest włączony czy wyłączony. Klikając na nazwę produktu można przejść bezpośrednio do jego edycji.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klient_zawartosc_schowka.jpg\" style=\"width: 240px; height: 137px; float: right; margin-left: 15px; margin-right: 15px;\" />Administrator sklepu ma możliwość przeglądania tych pozycji jak również może je usunąć z bazy (np. w przypadku gdy produktu już nie ma na stanie lub gdy klient dodał go dawno i od tamtego czasu się nie logował).</div>\r\n\r\n<div>&nbsp;</div>\r\n"),
("38","254","1","instrukcja","Edycja - zakładka Zniżki klienta","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klient_znizki.jpg\" style=\"width:600px;height:147px;margin-right:15px;margin-bottom:15px;float:left;\" />W tej zakładce znajduje się zestawienie wszystkich aktualnie posiadanych przez danego klienta zniżek w sklepie. Administrator sklepu może szybko sprawdzić wszystkie zniżki jakie ma przyznane wybrany klient.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Zasady przyznawania możliwych zniżek - na określone kategorie produktów, na produkty wybranych producentów oraz wszystkie inne są szczegółowo opisane w części instrukcji dotyczącej rabatów, jakie można w sklepie definiować.</div>\r\n"),
("39","256","1","instrukcja","Edycja - zakładka System punktów","<div style=\"text-align:justify;\">Zakładka ta pozwala na zarządzanie punktami zgromadzonymi przez danego klienta. Wyświetlana jest łączna suma wszystkich punktów oraz szczegółowa lista zawierająca <img alt=\"alt\" src=\"obrazki/pomoc/klient_system_punktow.jpg\" style=\"margin-top:15px;margin-right:15px;width:600px;height:205px;float:left;\" />poszczególne operacje związane z pozyskiwaniem jak również wydawaniem punktów.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Poszczególne kolumny wyświetlają informacje jaka była wykonywana operacja związana z punktami, jaki posiada ona obecnie status, datę operacji oraz ilość punktów z nią związanych.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Użytkownik może definiować własne statusy punktów w menu <strong>Sprzedaż / Klienci / Statusy punktów klientów</strong>. Większość operacji związanych z punktami wymaga ręcznej zmiany statusu przez administratora sklepu. Wyjątkiem jest tutaj wykorzystanie punktów za zakupy - które są automatycznie zatwierdzane i odejmowane z konta klienta w momencie złożenia zamówienia.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Szczegóły dotyczące konfiguracji systemu punktów są opisane w odrębnej części instrukcji. W tym miejscu zajmujemy się tylko obsługą punktów dla konkretnego klienta.</div>\r\n<br />\r\nDla każdej operacji można wykonać kilka akcji:<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Usuń pozycję</strong> - umożliwia skasowanie z bazy zapisu dotyczącego wybranej operacji.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong><img alt=\"alt\" src=\"obrazki/pomoc/klient_system_punktow_edycja.jpg\" style=\"float: right; width: 500px; height: 143px; margin-left: 15px; margin-bottom: 15px;\" />Edytuj ilość punktów</strong> - pozwala na ręczną zmianę ilości punktów dla danej operacji. W tym miejscu można skorygować ilość punktów decydując równocześnie czy wykonana zmiana ma dotyczyć tylko tej wybranej operacji, czy ma mieć wpływ na aktualne saldo punktów klienta.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\">Dla przykładu: w danej operacji klient otrzymał 4769 punktów. Administrator sklepu chce mu tę ilość zmniejszyć do 4000 z jednoczesnym pomniejszeniem całkowitego salda. Wówczas jeżeli zostanie w pole <strong>Ilość punktów</strong> wpisana wartość 4000 i jednocześnie zostanie zaznaczona opcja <strong>dodaj lub odejmij punkty klientowi</strong> - to wówczas łączne saldo wszystkich punktów klienta zostanie pomniejszone od 769 punktów.&nbsp; </span><br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Jeżeli natomiast wybierze opcję nie <strong>zmieniaj ilości punktów</strong> - wówczas wprowadzona zmiana będzie dotyczyła tylko tej operacji i nie będzie miała wpływu na całkowite saldo punktów klienta.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Wybranie poszczególnych opcji zależy od tego czy wykonujemy edycję na zapisach już zatwierdzonych, czy tych, które dopiero oczekują na zatwierdzenie.</div>\r\n<strong><img alt=\"alt\" src=\"obrazki/pomoc/klient_system_punktow_status.jpg\" style=\"margin-top: 15px; margin-right: 15px; float: left; width: 404px; height: 300px;\" /></strong>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\n<strong>Zmień status</strong> - w tym miejscu wykonuje się zmianę aktualnego statusu dla wybranej pozycji. Domyślnie dla większości operacji początkowy status punktów jest <span style=\"color:#ff0000;\">Oczekujące</span> i operacja taka nie ma wpływu na ogólne saldo punktów klienta - dopiero od decyzji administratora sklepu zależy czy dana operacja zostanie zatwierdzona i punkty zostaną klientowi naliczone. Zmiana statusu operacji na <span style=\"color:#0000cd;\">Zatwierdzone</span> nie spowoduje, że punkty zostaną dodane do salda klienta. Żeby punkty zostały dodane trzeba dodatkowo zaznaczyć opcję dodania punktów.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Po wybraniu opcji zmiany statusu punktów dla danej operacji wyświetlany jest formularz w którym administrator sklepu ma możliwość ręcznego skorygowania ilości punktów, zmiany aktualnego statusu.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">O każdej zmianie statusu punktów można powiadomić mailowo klienta. Poza standardową treścią wiadomości e-mail zdefiniowanej w menu <strong>Konfiguracja / Słowniki / Szablony treści wiadomości</strong> - można również dopisać indywidualną treść przesyłaną do klienta.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W indywidualnych przypadkach administrator sklepu może ręcznie dodać nową operację klikając w opcje <strong>dodaj nową pozycję</strong>. W tym wypadku wyświetlany jest formularz analogiczny do tego, który jest podczas zmiany statusu punktów. Dodatkowo można w nim wprowadzić tytuł operacji (np. super punkty w nagrodę). Podczas dodawania nowej pozycji można wybrać czy punkty mają być dodane czy odjęte od ogólnego stanu konta. Dzięki takiemu rozwiązaniu system punktów może służyć także do rozliczeń gotówkowych. Można ręcznie klientowi usunąć cześć punktów, które posiada i w zamian za nie wypłacić klientowi określoną sumę pieniężną. Przez takie rozwiązanie system punktów jest bardziej elastyczny i nie ogranicza się tylko do płacenia punktami za produkty w sklepie.</div>\r\n"),
("40","258","1","instrukcja","Edycja - zakładka Recenzje","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klient_recenzje.jpg\" style=\"width:650px;height:207px;margin-left:15px;margin-bottom:15px;float:right;\" />W zakładce tej administrator sklepu ma podgląd wszystkich napisanych przez danego klienta recenzji do produktów.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Wyświetlone są informacji jakiego produktu dotyczy wystawiona recenzja, treść napisana przez klienta oraz wystawiona przez niego ocena i data jej wystawienia.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Klikając w nazwę produktu można przejść bezpośrednio do edycji konkretnej recenzji. Administrator sklepu ma możliwość wprowadzenia zmian, całkowitego wyłączenia wyświetlania lub usunięcia jej z bazy danych.</div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("41","260","0","instrukcja","Grupy klientów","<div style=\"text-align:justify;\"><img alt=\"alt\" height=\"99\" src=\"obrazki/pomoc/grupy_klientow.jpg\" style=\"margin-left:15px;margin-right:15px;float:right;\" width=\"672\" />Grupy klientów umożliwiają zdefiniowanie przez obsługę sklepu kryteriów sprzedaży jakie będą obowiązywały dla klientów, którzy są przypisani do określonej grupy.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">W sklepie można definiować dowolne grupy klientów pamiętając o tym, iż musi być zawsze utworzona i aktywna przynajmniej jedna grupa. Standardowo jest to grupa o nazwie Podstawowa - tej grupy nie można usunąć z poziomu panelu administracyjnego sklepu. Każdy nowo zarejestrowany w sklepie klient jest automatycznie przypisywany do tej grupy. W późniejszym czasie administrator sklepu może zmienić przynależność klienta do innej grupy.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\">Po przypisaniu do wybranej grupy - klient przejmuje wszystkie ustawienia cen oraz rabatów obowiązujące dla tej właśnie grupy klientów.</span></div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/grupy_klientow_edycja.jpg\" style=\"width:400px;height:264px;margin-bottom:15px;margin-right:15px;float:left;\" />Po wybraniu opcji dodania nowej grupy lub edycji istniejącej wyświetlany jest formularz, a którym można wprowadzić dane dotyczące cen oraz rabatów i zasad realizacji zamówień:</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\n<strong>Nazwa grupy</strong> - pole informacyjne, niewidoczne dla klientów w sklepie, identyfikujące ją dla obsługującego sklep.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Rabat</strong> - liczba z przedziału -100 do 0 określająca procentowy upust cen produktów dla określonej grupy. Rabat jest liczony dla wszystkich produktów w sklepie. Klient po zalogowaniu się na swoje konto widzi wszystkie ceny już z uwzględnionym rabatem.</div>\r\n\r\n<div style=\"text-align:justify;\"><strong><img alt=\"alt\" src=\"obrazki/pomoc/grupy_klientow_ceny.jpg\" style=\"margin-left:15px;margin-top:15px;float:right;width:271px;height:100px;\" /><br />\r\nGrupa cenowa</strong> - jeżeli w sklepie ustawiona została większa ilość poziomów cen dla produktów w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia dla hurtowni</strong>, to wówczas dla poszczególnych grup klientów można przypisać określony poziom cen, które są definiowane podczas dodawania/edycji produktów.&nbsp; Jeżeli jakis produkt nie ma wpisanej żadnej wartości dla cen innych niż Cena nr 1 - wówczas klient widzi Cenę nr 1 pomimo, iż grupa do której należy ma przypisany np. poziom Cen 2.</div>\r\n<br />\r\n<strong>Minimalne zamówienie</strong> - określa minimalną wartość zamówienia od której klient należący do określonej grupy będzie mógł je zrealizować. Zamówienia, których wartość nie przekroczy zdefiniowanej kwoty nie będą mogły zostać zrealizowane. Jako wartość zamówienia jest przyjmowana wartość produktów dodanych do koszyka - bez kosztów wysyłki i innych rabatów lub zwyżek."),
("42","302","0","instrukcja","Rabaty indywidualne klientów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klienci_rabaty_indywidualne.jpg\" style=\"width:650px;height:101px;margin-right:15px;margin-bottom:15px;float:left;\" />Każdemu klientowi można przypisać indywidualny rabat na wszystkie produkty w sklepie.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W tej pozycji menu są zestawione wszystkie indywidualne zniżki przyznane poszczególnym klientom. Administrator sklepu ma możliwość wyszukiwania i sortowania danych wg podanych kryteriów. Kliknięcie w ikonkę edycji umożliwia zmianę wysokości przyznanej zniżki.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Edycji tej samej zniżki można dokonać bezpośrednio w edycji danych konkretnego klienta w menu <strong>Sprzedaż / Klienci / Klienci - dodawanie/edycja</strong>. Jest to ta sama zniżka przypisana klientowi.</div>\r\n<br />\r\n<span style=\"color:#ff0000;\">Zniżka ta obowiązuje dla danego klienta na wszystkie produkty znajdujące się w sklepie.</span>&nbsp;<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\">Dodatkowo należy pamiętać o ustawieniu ogólnych zasad naliczania rabatów (czy dotyczą produktów w promocji, czy mają się sumować, jaki może być naliczony maksymalny rabat, itp.) w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia rabatów i zniżek</strong>.</div>\r\n"),
("43","303","0","instrukcja","Rabaty dla producentów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klienci_rabaty_producentow.jpg\" style=\"width: 450px; height: 483px; margin-left: 15px; margin-bottom: 15px; float: right;\" />W sklepie można również zdefiniować rabaty tylko na produkty wybranego producenta - np. w przypadku okresowej promocji organizowanej przez wybranego producenta towarów sprzedawanych w sklepie.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Rabat dla producenta może zostać przyznany, dla wybranej grupy klientów lub indywidualnie dla pojedynczego klienta. Po kliknięciu na <strong>dodanie nowego rabatu</strong> wyświetlany jest formularz, w którym wprowadzamy odpowiednie informacje i parametry:</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Nazwa -</strong> indywidualna nazwa wpisanego rabatu, po której administrator sklepu będzie mógł w prosty sposób określić jaki to jest rabat.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><strong>Rabat </strong>- liczba z przedziału -100 do 0 określająca wielkość rabatu w procentach.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Producent</strong> - na produkty jakich producentów ma być naliczany rabat.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Przypisanie rabatu</strong> -&nbsp; pole, w którym określa się czy rabat ma obowiązywać dla wybranej grupy klientów czy dla konkretnego klienta. Zależnie od wybranej opcji wyświetlana jest rozwijana lista zdefiniowanych w sklepie grup klientów lub lista poszczególnych klientów.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W sklepie można zdefiniować dowolną ilość rabatów dla producentów co daje bardzo duże możliwości dla administratora sklepu w ich przyznawaniu w zależności od aktualnych potrzeb.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Dodatkowo należy pamiętać o ustawieniu ogólnych zasad naliczania rabatów (czy dotyczą produktów w promocji, czy mają się sumować, jaki może być naliczony maksymalny rabat, itp.) w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia rabatów i zniżek</strong>.</div>\r\n"),
("44","304","0","instrukcja","Rabaty dla kategorii","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klienci_rabaty_kategorii.jpg\" style=\"width: 450px; height: 361px; margin-left: 15px; margin-bottom: 15px; float: right;\" />W sklepie można zdefiniować rabaty tylko na produkty należące do określonej kategorii - np. w przypadku okresowej promocji.<br />\r\n<br />\r\nRabat dla kategorii może zostać przyznany, dla wybranej grupy klientów lub indywidualnie dla pojedynczego klienta. Po kliknięciu na <strong>dodanie nowego rabatu</strong> wyświetlany jest formularz, w którym wprowadzamy odpowiednie informacje i parametry:<br />\r\n<br />\r\n<strong>Nazwa -</strong> indywidualna nazwa wpisanego rabatu, po której administrator sklepu będzie mógł w prosty sposób określić jaki to jest rabat.<br />\r\n<br />\r\n<strong>Rabat </strong>- liczba z przedziału -100 do 0 określająca wielkość rabatu w procentach.<br />\r\n<br />\r\n<strong>Kategoria</strong> - dostępna jest rozwijana lista wszystkich zdefiniowanych w sklepie kategorii. Po rozwinięciu listy, wybieramy kategorie dla których ma być ustalony rabat.<br />\r\n<br />\r\n<strong>Przypisanie rabatu</strong> -&nbsp; pole, w którym określa się czy rabat ma obowiązywać dla wybranej grupy klientów czy dla konkretnego klienta. Zależnie od wybranej opcji wyświetlana jest rozwijana lista zdefiniowanych w sklepie grup klientów lub lista poszczególnych klientów.<br />\r\n<br />\r\nW sklepie można zdefiniować dowolną ilość rabatów dla kategorii co daje bardzo duże możliwości dla administratora sklepu w ich przyznawaniu w zależności od aktualnych potrzeb.<br />\r\n<br />\r\nDodatkowo należy pamiętać o ustawieniu ogólnych zasad naliczania rabatów&nbsp; czy dotyczą produktów w promocji, czy mają się sumować, jaki może być naliczony maksymalny rabat, itp.) w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia rabatów i zniżek</strong>.</div>\r\n"),
("45","305","0","instrukcja","Rabaty dla produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/klienci_rabaty_produktow.jpg\" style=\"margin-bottom: 15px; margin-left: 15px; float: right; width: 580px; height: 278px;\" />W sklepie można również zdefiniować rabaty tylko na wybrany produkt.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>Opcja ta jest przydatna np. w przypadku gdy jakiś klient negocjuje z właścicielem sklepu cenę wybranego towaru. W takim przypadku właściciel sklepu po uzgodnieniu z klientem ostatecznego rabatu jaki może przyznać na negocjowany produkt - może ustawić indywidualny rabat dla określonego klienta. Po ustawieniu takiego rabatu, klient w sklepie widzi wszystkie ceny w standardowych wartościach, a tylko na ten jeden produkt ma ustalony rabat.</strong></span><br />\r\n<br />\r\nRabat dla produktu może - tak samo jak większość innych rabatów w sklepie - zostać przyznany, dla wybranej grupy klientów lub indywidualnie dla pojedynczego klienta. Po kliknięciu na <strong>dodanie nowego rabatu</strong> wyświetlany jest formularz, w którym wprowadzamy odpowiednie informacje i parametry:<br />\r\n<br />\r\n<strong>Nazwa -</strong> indywidualna nazwa wpisanego rabatu, po której operator będzie mógł w prosty sposób określić jaki to jest rabat.<br />\r\n<br />\r\n<strong>Rabat </strong>- liczba z przedziału -100 do 0 określająca wielkość rabatu w procentach.<br />\r\n<br />\r\n<strong>Produkt </strong>- dostępna jest rozwijana lista wszystkich zdefiniowanych w sklepie kategorii. Po rozwinięciu listy, wybieranej kategorii wyświetlane jest okno zawierające listę produktów, które się w niej znajdują. W tym miejscu można wybrać produkt, na który zostanie udzielony rabat.<br />\r\n<br />\r\n<strong>Przypisanie rabatu</strong> -&nbsp; pole, w którym określa się czy rabat ma obowiązywać dla wybranej grupy klientów czy dla konkretnego klienta. Zależnie od wybranej opcji wyświetlana jest rozwijana lista zdefiniowanych w sklepie grup klientów lub lista poszczególnych klientów.<br />\r\n<br />\r\nW sklepie można zdefiniować dowolną ilość rabatów dla produktów co daje bardzo duże możliwości dla administratora sklepu w ich przyznawaniu w zależności od aktualnych potrzeb.<br />\r\n<br />\r\nDodatkowo należy pamiętać o ustawieniu ogólnych zasad naliczania rabatów (czy dotyczą produktów w promocji, czy mają się sumować, jaki może być naliczony maksymalny rabat, itp.) w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia rabatów i zniżek</strong>.</div>\r\n"),
("46","301","0","instrukcja","Rabaty","<div style=\"text-align:justify;\">\r\n	Program oferuje rozbudowany system rabatów. Zniżki można definiować dla pojedynczych klientów lub dla całych grup. Ponadto można podzielić rabaty według producentów, kategorii produktów lub pojedynczych towarów sprzedawanych w sklepie.<br />\r\n	<br />\r\n	Rabaty mogą być wykorzystywane w wielu sytuacjach, takich jak np. okresowe promocje oferowane przez konkretnego producenta, promocje świąteczne, czy tez zaoferowanie konkretnego produktu dla wybranego klienta w niższej cenie.<br />\r\n	<br />\r\n	W menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia rabatów i zniżek</strong> należy zdefiniować zasady według których będą obliczane rabaty w przypadku gdy wystąpi ich kumulacja. Poprawne ich zdefiniowanie ma na celu zapobiegnięcie sytuacjom, w których końcowa cena produktu mogłaby okazać się niższa niż cena za którą produkt został w ogóle zakupiony do dalszej sprzedaży.<br />\r\n	<br />\r\n	Dobrze przemyślane i poustawiane rabaty mogą być bardzo dobrą zachętą dla klientów - tych już kupujących w sklepie jak i potencjalnych nowych nabywców - do dokonywania zakupów w naszym sklepie.</div>\r\n"),
("47","140","0","instrukcja","Produkty podobne","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkty_podobne.jpg\" style=\"width:450px;height:255px;float:right;margin-left:15px;margin-bottom:15px;\" />Moduł produktów podobnych umożliwia przypisanie do produktu, które mają podobne cechy do danego produktu lub np razem stanowią określony komplet. Dla przykładu do produktu Koszulka Adidas można przypisać inne koszulki (np innych firm) którymi potencjalny klient może być zainteresowany. Można także przypisać np spodenki jeżeli pochodzą z tej samej serii produktów - i razem stanowią komplet. Standardowo produkty podobne są wyświetlane na karcie produktu pod opisem produktu. Ilość produktów podobnych&nbsp; wyświetlanych jednocześnie na karcie produktu można zdefiniować w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia produktów</strong>.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Moduł zarządzania produktami podobnymi w obsłudze jest podobny do innych modułów z menu <strong>Asortyment</strong>. W module tym w oknie po prawej stronie wyświetlane są<strong> produkty które mają przypisane produkty podobne</strong>. Domyślnie produkty są posortowane wg nazw od A do Z. W oknie po lewej stronie wyświetlane są <strong>kategorie produktów</strong>. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko produkty z danej kategorii. Powyżej okien z produktami i kategoriami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych produktów które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii produktów - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania produktów w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowej pozycji.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkty_podobne_listing.jpg\" style=\"width: 550px; height: 136px; float: left; margin-right: 15px; margin-bottom: 15px;\" />W liście produktów każdy produkt jest wyświetlany w osobnym wierszu.&nbsp; Pierwsza kolumna umożliwia zaznaczenie produktu (kilku produktów z listy) i dokonanie na nich określonej operacji, np. usunięcie z produktów przypisanych do niego produktów jako podobne. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejna kolumna to id produktu. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu, kategorie do jakich produkt jest przypisany, nr katalogowy oraz nazwa producenta. Korzystając z górnych filtrów można wyświetlić w liście np. produkty tylko określonego producenta. Kolejna kolumna wyświetla <strong>ilość przypisanych do danego produktu produktów podobnych</strong>.W kolejnej kolumnie wyświetlane jest pole statusu w którym można zmienić status produktu odznaczając lub zaznaczając pole i zapisując zmiany przyciskiem Zapisz zmiany na dole strony.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/produkty_podobne_edycja.jpg\" style=\"width: 600px; height: 289px; float: right; margin-left: 15px; margin-bottom: 15px;\" />W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję produktu, usunięcie produktów podobnych z produktu oraz przejście do modułu produktów i edycję całego produktu. Po wciśnięciu edycji otwiera się podstrona która umożliwia przypisanie nowych lub usunięcie istniejących produktów oznaczonych jako podobne do edytowanego produktu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Na samej górze podstrony znajdują się dane produktu który jest edytowany i do którego są przypisane produkty podobne.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Poniżej znajduje się lista produktów przypisanych do danego produktu jako podobne. Listing ma formę skróconą, zawiera podstawowe dane produktów: id, zdjęcie, cenę, nr katalogowy, nazwę oraz stan produktu - czy produkt jest aktywny czy wyłączony. W listingu pierwsza kolumna oznaczona jest jako <strong>krzyżowo</strong>. Jeżeli przy danych produkcie jest zaznaczona opcja krzyżowo oznacza to, że po zapisaniu zostanie on dodany do produktu jako podobny - ale także aktualnie edytowany produkt zostanie przypisany do zaznaczonego jako podobny. Dla przykładu: edytujemy produkt o nazwie A - do tego produktu jako podobne przypisujemy produkty B, C, D. Jeżeli opcja krzyżowo przy produkcie B nie zostanie zaznaczona zostanie on przypisany do produktu A jako podobny - ale produkt A nie będzie przypisany do produktu B jako podobny. Zaznaczając krzyżowo - produkt A zostanie zapisany do produktu B jako podobny. Dzięki temu nie trzeba podwójnie dodawać produktów - tylko wystarczy przy edycji produktu A zaznaczyć przy produkcie B opcję krzyżowo. W kolejnej kolumnie oznaczonej jako <strong>wybierz</strong> - zaznaczenie produktu powoduje, że jest on przypisany do edytowanego produktu jako podobny. Odznaczenie opcji powoduje usunięcie produktu z listy.<br />\r\n<br />\r\nPoniżej listy produktów przypisanych jako podobne znajduje się opcja <strong>krzyżowo wszystkie produkty A do B,C, B do A,C, C do A,B itd. </strong>Zaznaczenie tej opcji powoduje, że poszczególne zaznaczenia &quot;krzyżowo&quot; w liście produktów przypisanych jako podobne nie będą brane pod uwagę przy zapisie - ale wszystkie wybrane produkty będą podobne do siebie wzajemnie. Dla przykładu - produkt główny A będzie podobny do produktu podobnego B i C, B będzie podobny do A i C, C będzie podobny do A i B.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"\" src=\"obrazki/pomoc/produkty_podobne_dodawanie.jpg\" style=\"margin-bottom: 10px; margin-right: 10px; float: left; width: 700px; height: 225px;\" />Dodając (przypisując) kolejny produkt jako podobny - należy wybrać z której kategorii będzie dodawany produkt.&nbsp;Można także wyszukać produkty korzystając z wyszukiwarki produktów. Po wybraniu kategorii lub wpisaniu nazwy produktu w wyszukiwarce - po prawej stronie w oknie wyświetli się lista znalezionych produktów. Jest to skrócona forma listingu - zawiera podstawowe dane: id, zdjęcie, ceną, nr katalogowy oraz nazwę - wyświetla także stan produktu - czy produkt jest aktywny czy wyłączony. Z listy należy wybrać produkty które będą dodane jako podobne. Po zaznaczeniu wybranych produktów należy kliknąć w przycisk <strong>Dodaj zaznaczone jako produkty podobne</strong> - po czym wybrane produkty zostaną dodane do listy produktów podobnych. Opcje <strong>krzyżowo</strong> oraz <strong>wybrany</strong> zostaną domyślnie zaznaczone. Po wybraniu produktów, które będą przypisane jako podobne należy zapisać całość poprzez zatwierdzenie przyciskiem<strong> Zapisz dane</strong>.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Dodawanie nowego produktu i następnie przypisywanie do niego produktów podobnych odbywa się podobnie jak edycja produktu z produktami podobnym. Jedyna różnica jest taka, że najpierw wyświetli się drzewo kategorii z której należy wybrać z której kategorii będzie dodawany produkt.&nbsp;Można także wyszukać produkty korzystając z wyszukiwarki produktów. Po wybraniu kategorii lub wpisaniu nazwy produktu w wyszukiwarce - po prawej stronie w oknie wyświetli się lista znalezionych produktów (forma skrócona jak w opisie powyżej). Po wybraniu produktu zostanie on przypisany jako <strong><span class=\"wynik_naglowek_dodanie\">produkt do przypisania do niego produktów podobnych</span></strong> i dalsza procedura przypisywania do niego produktów podobnych wygląda identycznie jak podczas edycji.</div>\r\n"),
("48","162","1","instrukcja","Akcesoria dodatkowe dla kategorii","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/akcesoria_dodatkowe_kategorie.jpg\" style=\"width: 550px; height: 121px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Moduł akcesoria dodatkowe dla kategorii umożliwia podobnie jak moduł akcesoria dla produktów - przypisanie do produktów akcesoriów dodatkowych. Różnica w działaniu obu modułów jest taka - że o ile w przypadku modułu akcesoria dla produktów przypisywane są akcesoria dla poszczególnych produktów - w tym module przypisuje się akcesoria dla całych kategorii - dzięki czemu wszystkie produkty należące do danej kategorii będą miały przypisane wybrane akcesoria dodatkowe.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W module wyświetlane są<strong> kategorie które mają przypisane akcesoria dodatkowe</strong>. W liście każda kategoria jest wyświetlana w osobnym wierszu.&nbsp; Pierwsza kolumna umożliwia zaznaczenie kategorii (kilku kategorii z listy) i dokonanie na nich określonej operacji, np. usunięcie z kategorii akcesoriów dodatkowych. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejna kolumna to id kategorii. W kolejnej kolumnie wyświetlana jest nazwa kategorii. Kolejna kolumna wyświetla <strong>ilość przypisanych produktów jako akcesoria dodatkowe</strong>. W kolejnej kolumnie wyświetlane jest pole statusu danej kategorii. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję oraz usunięcie akcesoriów dodatkowych z kategorii.</div>\r\n"),
("49","280","0","instrukcja","Punkty do zatwierdzenia","<div style=\"text-align:justify;\">Program posiada możliwość stosowania systemu punktów, które klienci mogą pozyskiwać w sklepie na kilka różnych sposobów. Punkty mogą być przyznawane za zarejestrowanie się klienta w sklepie, za napisanie opinii o jakimś produkcie, a przede wszystkim za dokonywane zakupy. Zebranymi punktami klient może w przyszłości zapłacić za kolejne realizowane zamówienia. Ma możliwość decydowania, czy chce wykorzystać wszystkie zgromadzone punkty, czy tylko ich cześć w czasie realizowania konkretnego zamówienia. Wszystkie parametry punktów, takie jak wartość, ilość czy akcje za które są przyznawane można zdefiniować w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia systemu punktów</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/klienci_punkty_do_zatwierdzenia.jpg\" style=\"width: 650px; height: 173px; margin-left: 15px; margin-bottom: 15px; float: right;\" />W menu <strong>Punkty do zatwierdzenia</strong> znajduje się lista wszystkich operacji związanych z naliczaniem, które oczekują na zatwierdzenie przez administratora sklepu.<br />\r\n<br />\r\nKażdy wiersz dotyczy jednej konkretnej operacji związanej z punktami. W polu Tytuł punktów znajduje się opis za co punkty zostały przyznane. Jeżeli dotyczy to punktów za dokonane zakupy wówczas jest podany numer zamówienia złożonego przez klienta. Klikając na tytuł można przejść bezpośrednio do edycji operacji która była związana z naliczeniem punktów (edycja zamówienia, edycja recenzji) . Kolejne wyświetlone informacje do data wykonanej operacji, nazwa użytkownika, ilość przyznanych punktów oraz ich status, a także status recenzji lub zamówienia.<br />\r\n<br />\r\nOstatnia kolumna zawiera ikonki, które umożliwiają wykonanie poszczególnych akcji.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/klienci_punkty_edytuj.jpg\" style=\"width: 300px; height: 94px; margin-left: 15px; margin-bottom:15px; float: right;\" />Kliknięcie w ikonkę edycji - umożliwia administratorowi sklepu wprowadzenie ręcznej korekty ilości przyznanych punktów w danej operacji. Korekta w tym miejscu nie ma wpływu na całkowite saldo punktów klienta.\r\n<div style=\"clear:both\">&nbsp;</div>\r\n<img alt=\"alt\" src=\"obrazki/pomoc/klient_system_punktow_status.jpg\" style=\"margin-bottom: 15px; margin-right: 15px; float: left; width: 404px; height: 300px;\" />W tym miejscu administrator sklepu może usunąć w ogóle zapis dotyczący danej operacji lub dokonać zmiany statusu. Po kliknięciu ikonki zmiany statusu wyświetlany jest formularz, w którym administrator sklepu ma możliwość ręcznego skorygowania ilości punktów oraz zmiany aktualnego statusu.<br />\r\n<br />\r\nO każdej zmianie statusu punktów można powiadomić mailowo klienta. Poza standardową treścią wiadomości e-mail zdefiniowanej w menu <strong>Konfiguracja / Słowniki / Szablony treści wiadomości</strong> - można również dopisać indywidualną treść przesyłaną do klienta.<br />\r\n<br />\r\nW tej pozycji menu nie ma możliwości zmniejszenia ogólnego salda punktów klienta ponieważ wszystkie operacje, które są wyświetlone na liście związane są z pozyskiwaniem punktów przez klientów automatycznie - zgodnie z ustalonymi zasadami w menu <strong>Ustawienia punktów klientów</strong>.<br />\r\n<br />\r\nJeżeli zachodzi potrzeba zmniejszenia salda punktów, np. klient już po złożeniu zamówienia i zatwierdzeniu jego punktów rozmyślił się i dokonał zwrotu towaru przez co nie powinien mieć przyznanych punktów za jego zakup, to można to wykonać w karcie edycji klienta w zakładce System punktów poprzez dopisanie nowej pozycji, i zaznaczenie opcji pomniejszenia salda punktów klienta.</div>\r\n"),
("50","166","0","instrukcja","Gratisy","<div style=\"text-align:justify;\">Moduł gratisy umożliwia definiowanie w sklepie produktów, które po spełnieniu określonych warunków zamówienia będzie można kupić w niższej cenie lub otrzymać za darmo (lub po niższej cenie) jako gratis. Definiowanie takich produktów i odpowiednie ich zareklamowanie po stronie sklepu zachęca potencjalnych klientów do większych zakupów - gdyż przy określonym poziomie mogą otrzymać określone profity.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/gratisy_koszyk.jpg\" style=\"width: 550px; height: 252px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Gratisami w sklepie mogą być tylko produkty które znajdują się w ofercie sklepu i są dodane jako normalne produkty w menu <strong>Asortyment / Produkty</strong> oraz nie posiadają <strong>cech</strong>. Wynika to z tego, że produkty gratisowe są wyświetlane bezpośrednio w koszyku i klient może je szybko dodać do koszyka - bez wybierania dodatkowych opcji.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Jeżeli koszyk klienta spełni określone kryteria i przekroczy określony poziom kwotowy to w koszyku zostanie wyświetlona dodatkowa lista produktów w preferencyjnych cenach. Klient może dodać do koszyka tylko jedną sztukę danego gratisu. Czyli jak w przykładzie pokazanym na grafice obok: może dodać do koszyka produkt Ferguson FK 6900 CR za 1 zł - ale jeżeli będzie chciał dodać kolejny produkt Ferguson FK 6900 CR to kolejne produkty będą już w standardowej cenie.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" br=\"br\" src=\"obrazki/pomoc/gratisy_koszyk_normalny.jpg\" style=\"width: 520px; height: 121px; float: left; margin-right: 15px; margin-bottom: 15px;\" />Po dodaniu wybranego gratisu do koszyka znika on z listy gratisów do wyboru. Klient może dodać do koszyka wszystkie gratisy jakie oferuje sklep. Gratisy tak jak wszystkie produkty w sklepie są objęte kontrolą stanu magazynowego i po zakupie jest zmieniany stan magazynowy danego produktu (tylko jeżeli w sklepie jest włączona kontrola stanu magazynowego).</div>\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/gratisy.jpg\" style=\"width: 600px; height: 109px; float: right; margin-left: 15px; margin-bottom: 15px;\" />\r\n<div style=\"text-align:justify;\">Po stronie panelu zarządzania moduł gratis wyświetla w oknie listę zdefiniowanych produktów gratisowych wraz z informacją dla jakich wartości obowiązują. Domyślnie produkty są posortowane wg nazw od A do Z. Powyżej okna z produktami znajduje się okno wyszukiwania. Poniżej pola szukania znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania produktów w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowego gratisu. W liście produktów każdy produkt jest wyświetlany w osobnym wierszu.&nbsp; Pierwsza kolumna umożliwia zaznaczenie produktu (kilku produktów z listy) i dokonanie na nich określonej operacji, np. usunięcie gratisów. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejna kolumna to id gratisu, a następna id produktu. W kolejnej kolumnie wyświetlana jest miniaturka głównego zdjęcia produktu - po najechaniu kursorem myszy na zdjęcie zostaje ono powiększone - opcja jest przydatna przy produktach o takich samych nazwach. Kolejna kolumna to nazwa produktu. W kolejnej kolumnie wyświetlana jest informacja jaką cenę ma produkt gratisowy - czy jest on darmowy czy ma własną cenę - niższą od standardowej. Kolejna kolumna wyświetla informację dla jakich wartości koszyka dany gratis obowiązuje oraz dodatkowe warunki otrzymania gratisu. Można zdefiniować gratisy tak, że przy różnych wartościach koszyka klient będzie miał do wyboru różne produkty. Nie można zdefiniować różnych cen dla jednego produktu - dla różnych wartości koszyka. Każdy produkt można dodać tylko raz jako gratis. W następnej kolumnie jest wyświetlana informacja czy dany gratis może być dodany wyłącznie jako jeden czy klient może być kilka gratisów. Kolor zielony ikonki oznacza, że klient może wybrać tylko ten jeden gratis i po jego dodaniu do koszyka inne gratisy przestaną być dostępne. Ikona szara oznacza, że klient będzie mógł wybrać dany gratis oraz inne gratisy. Jeżeli klient doda do koszyka gratis, który ma aktywną opcję (ikonka zielona) inne gratisy przestają być dostępne i jeżeli były dodane do koszyka - zostaną z niego usunięte. Dowolną ilość gratisów do koszyka - można dodać jeżeli opcja jest nieaktywna. W kolejnej kolumnie wyświetlana jest nazwa grupy klientów dla jakiej dostępny jest gratis - jeżeli wyświetlany jest znak minusa to oznacza to, że produkt nie jest przypisany do żadnej grupy klientów i będzie dostępny dla wszystkich klientów. Jeżeli jednak gratis zostanie przypisany do konkretnej grupy klientów będzie widoczny i dostępny tylko dla danej grupy klientów. Kolejna kolumna wyświetla ikonę aktywności produktu - kolor zielony oznacza, że produkt jest aktywny i będzie wyświetlany, kolor szary oznacza, że produkt jest wyłączony i pomimo aktywnego statusu gratisu - nie będzie wyświetlany w sklepie. W kolejnej kolumnie wyświetlane jest pole statusu gratisu w którym można zmienić status gratisu odznaczając lub zaznaczając pole i zapisując zmiany przyciskiem Zapisz zmiany na dole strony.&nbsp; W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję gratisu oraz jego usunięcie.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/gratis_dodawanie.jpg\" style=\"width: 600px; height: 534px; float: right; margin-bottom: 15px; margin-left: 15px;\" />Dodając nowy gratis należy w pierwszym kroku wybrać jaki produkt będzie gratisem. W tym celu należy najpierw wybrać kategorię z jakiej będzie dodawany produkt lub wyszukać produkt korzystając z wyszukiwarki. Po kliknięciu w wybraną kategorię lub wpisaniu nazwy produktu w wyszukiwarce - po prawej stronie w oknie wyświetli się lista znalezionych produktów. Jest to skrócona forma listingu - zawiera podstawowe dane: id, zdjęcie, ceną, nr katalogowy oraz nazwę - wyświetla także stan produktu - czy produkt jest aktywny czy wyłączony. Z listy należy wybrać produkt który będzie gratisem poprzez zaznaczenie produktu w kolumnie o nazwie <strong>Wybór</strong>.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Następnie można wybrać dla jakiej grupy klientów będzie widoczny gratis, ustawić czy produkt będzie darmowy czy będzie miał cenę (jeżeli będzie miał cenę należy podać cenę brutto produktu). Kolejne pozycje to kwota od i do jakiej wartości koszyka produkt będzie widoczny. Można także ustawić minimalną ilość produktów jaka musi być w koszyku aby produkt był dostępny jako gratis. Można także ustawić dostępność produktu tylko dla wybranych kategorii, producentów lub produktów. Wybranie tych elementów spowoduje, że gratis będzie dostępny tylko wtedy jeżeli w koszyku znajdzie się produkt z wybranej kategorii, producenta lub z zaznaczonych produktów.<br />\r\n<br />\r\nDla przykładu: jeżeli zostaną zaznaczone kategorie: Biżuteria oraz Telefony to gratis będzie dostępny tylko wtedy jeżeli do koszyka zostanie dodany chociaż jeden produkt w w/w kategorii oraz będzie spełniony warunek wartości kwotowej koszyka od-do. Jeżeli zostanie wpisania dodatkowo minimalna ilość produktów (np 2) to gratis będzie widoczny dopiero wtedy jeżeli zostaną dodane do koszyka minimum 2 produkty z w/w kategorii. Podobnie wygląda to w przypadku producenta czy wybranych produktów. Jeżeli zostanie wybrany np produkt o nazwie A i wpisana minimalna ilość np 5 to gratis będzie widoczny dopiero wtedy jeżeli klient doda do koszyka minimum 5 szt produktu A.<br />\r\n<br />\r\nJeżeli nie zostanie wybrana żadna kategoria, producent oraz produkt, a będzie wpisana minimalna ilość produktów - będzie ona dotyczyła ogólnej liczby produktów dodanych do koszyka. W przypadku zaznaczenia kategorii, producenta lub produktów - minimalna ilość produktów jest obliczana dla zaznaczonych pozycji.<br />\r\n<br />\r\nFormularz edycji jest identyczny jak w przypadku dodawania nowego gratisu - z tą różnicą, że nie można zdefiniować produktu jaki będzie gratisem oraz nie można wybrać kategorii, producentów i produktów - pozostałe pola można dowolnie zmodyfikować.</div>\r\n"),
("51","172","0","instrukcja","Kupony rabatowe","<div style=\"text-align:justify;\">Kupony rabatowe są jedną z dodatkowych propozycji uatrakcyjnienia oferty sklepu internetowego. Umożliwiają one obniżenie wartości zamówienia klienta przez podanie odpowiedniego kodu podczas składania zamówienia. Dzięki kuponom rabatowym właściciel sklepu otrzymuje możliwość uruchomienia w sklepie internetowym bonów podarunkowych, które można wykupić w sklepie i przekazać w formie prezentu wybranej osobie. Osoba otrzymująca taki bon może go wykorzystać w sklepie w podczas dokonywania zakupów.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">Sklep przewiduje trzy rodzaje kuponów - kwotowe, procentowe oraz o wartości kosztów wysyłki. Kupony kwotowe mają stałą kwotę rabatu i podczas składania przez klienta zamówienia - jego wartość jest obniżana o stałą kwotę. W przypadku kuponu procentowego wartość kuponu jest zależna od wartości zamówienia i stanowi określony procent wartości produktów zamówienia. Kupony dotyczące kosztów wysyłki nie mają stałej wartości i jego wartość jest równa wartości kosztów wysyłki danego zamówienia klienta, dzięki czemu wysyłka staje się darmowa. <img alt=\"alt\" src=\"obrazki/pomoc/kupon_koszyk.jpg\" style=\"width:300px;height:77px;float:right;margin:15px;margin-right:0px;\" />Kod kuponu rabatowego klient sklepu wpisuje się w koszyku - znajduje się tam dodatkowe pole do wpisania posiadanego kuponu rabatowego. Po wpisaniu kodu kuponu należy aktywować kupon - po czym wyświetlana jest informacja o aktywowaniu danego kuponu rabatowego. Podczas jednego zamówienia - klient może wykorzystać tylko jeden kupon. <img alt=\"alt\" src=\"obrazki/pomoc/kupon_zestawienie.jpg\" style=\"width:200px;height:80px;float:left;margin:15px;margin-left:0px\" />Po aktywacji kuponu zostaje on dodany do podsumowania zamówienia, a wartość zamówienia zostaje obniżona o wartość kuponu. W podsumowaniu widoczna jest wartość kuponu oraz jego kod. Jeżeli klient chciałby zrezygnować z użycia kuponu rabatowego w miejscu gdzie wcześniej kupon był aktywowany wyświetla się przycisk do rezygnacji z kuponu - <strong>Zrezygnuj z użycia kuponu rabatowego</strong>. Jeżeli kupon posiada dodatkowe warunki użycia, np tylko wybrane produkty, kategorie czy producenta i w koszyku znajdują się produkty, które nie są objęte danym kuponem rabatowym to podczas aktywacji kuponu wyświetlana jest dodatkowa informacja, że nie wszystkie produkty są objęte kuponem i kupon zostanie wykorzystany tylko na produkty spełniające warunki. Dzięki temu klient może zrealizować kupon częściowo - tylko na produkty objęte danym kuponem - po wykorzystaniu częściowym kuponu - przy kolejnych zakupach klient nie będzie mógł ponownie skorzystać z tego kuponu, aby wykorzystać pozostałą część.</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe.jpg\" style=\"width: 600px; height: 137px; margin-left: 15px; margin-bottom: 15px; margin-top: 15px; float: right;\" /><br />\r\nModuł zarządzania kuponami rabatowymi wyświetla w oknie wszystkie dostępne kupony rabatowe. Domyślnie kupony są posortowane wg kodu od A do Z. Powyżej okna z kuponami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych kuponów które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nPoniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania kuponów rabatowych w listingu. Poniżej znajdują się przyciski <strong>dodawania</strong> nowych kuponów oraz <strong>importu i eksportu</strong>.<br />\r\n<br />\r\nW liście kuponów każdy kupon jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla ikonę informacji - po najechaniu na nią kursorem myszy wyświetlane są informacje na temat kuponu: ilość dostępnych kuponów oraz dodatkowe warunki użycia kuponu. Kolejna kolumna umożliwia zaznaczenie kuponu (kilku kuponów z listy) i dokonanie na nich określonej operacji, np. usunięcia. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. W operacjach dostępnych na dole listingu w porównaniu z innymi modułami dostępne są operacje, które wykonywane są na wszystkich pozycjach - nie tylko zaznaczonych w liście - można np usunąć wszystkie kupony ze sklepu - lub usunąć wszystkie z określonym prefixem. Następna kolumna to id kuponu (nie jest to kod kuponu, tylko unikalny nr id zapisany w bazie sklepu - niewidoczny dla klientów). W kolejnej kolumnie wyświetlany jest właściwy <strong>kod kuponu</strong>. Jest to kod, który klient podaje podczas dokonywania zakupów. Następna kolumna to opis kuponu - jest to opis widoczny tylko dla administratora sklepu. W kolejnej kolumnie wyświetlany jest rodzaj kuponu: kwota (wartość kuponu jest kwotowa - stała), procent (wartość kuponu jest procentowa i zależna od wartości zamówienia) lub darmowa wysyłka (wartość kuponu jest zależna od kosztów dostawy w danym zamówieniu). Następna kolumna wyświetla wartość kuponu (kwotowo lub w procentach). Kolejne kolumny wyświetlają daty: datę utworzenia kuponu oraz datę ważności od - do (od kiedy do kiedy kupon będzie obowiązywał). Kupony nie muszą posiadać daty ważności - jeżeli nie posiadają takich dat to wyświetlany jest znak minusa. W kolejnej kolumnie wyświetlana jest ilość użyć kuponu. Liczba określa ile razy kupon był użyty. Przedostatnia kolumna wyświetla stan kuponu - kolor zielony oznacza, że nie wszystkie kupony zostały wykorzystane i kupon jest aktywny - co oznacza, że będzie można go użyć, kolor szary oznacza, że kupon nie jest już aktywny - wszystkie kupony zostały wykorzystane. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję kuponu, jego usunięcie lub przejście do statystyk.</div>\r\n"),
("52","175","0","instrukcja","Statystyki kuponów rabatowych","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_statystyka.jpg\" style=\"width:600px;height:158px;float:right;margin-left:15px;margin-bottom:15px;\" />Jeżeli kupon został wykorzystany przez klientów podczas realizacji zamówień można klikając na ikonę statystyk sprawdzić przy jakich zamówieniach i przez kogo został wykorzystany. Jeżeli kupon miał w opcjach tylko jedno użycie będzie widoczne jedno zamówienie. Jeżeli jednak miał więcej użyć i był wykorzystany w większej ilości zamówień - będzie widoczna lista zamówień w jakich został użyty.<br />\r\n	 </div>\r\n<div style=\"text-align:justify;\">\r\n	Lista zamówień zawiera: nr zamówienia, datę złożenia zamówienia, wartość całkowitą zamówienia, wartość użytego kuponu, dane klienta oraz aktualny status zamówienia. Jeżeli generowane kupony były wysłane mailem i indywidualnie przypisywane do klientów, można w łatwy sposób sprawdzić czy kupon został zrealizowany faktycznie przez osobę do której miał trafić.<br />\r\n	 </div>\r\n<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_office.jpg\" style=\"width:550px;height:71px;float:left;margin-bottom:15px;margin-right:15px;\" />W statystykach kuponu pod listą zamówień znajduje się opcja eksportu zamówień danego kuponu do pliku CSV. Po wykonaniu eksportu można pobrać i zapisać na dysku wygenerowany plik statystyk. Po otworzeniu pliku np w OpenOffice (zalecamy ten pakiet do obórki plików csv) można edytować pobrane dane. Eksportowany plik zawiera 6 kolumn z danymi - odpowiedników kolumn z listingu statystyki kuponu. Eksportowany plik posiada kodowanie polskich znaków w standardzie UTF-8, a pola są rozdzielone znakiem średnika (separator pól).</div>\r\n"),
("53","200","0","instrukcja","Zamówienia","Zamówienia to podstawowy moduł w panelu administracyjnym sklepu umożliwiający prowadzenie sprzedaży w sklepie.<br />\r\n<br />\r\nZamówienia mogą być w sklepie tworzone na kilka sposobów:\r\n<ol>\r\n	<li>zamówienia składane przez klientów bezpośrednio poprzez sklep</li>\r\n	<li>zamówienia dopisywane ręcznie przez obsługę sklepu bezpośrednio w panelu administracyjnym</li>\r\n	<li>zamówienia automatycznie tworzone podczas importowania aukcji z serwisu Allegro</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienia_lista.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 600px; height: 355px;\" />W menu <strong>Sprzedaż / Zamówienia / Zarządzanie</strong> zamówieniami jest wyświetlana lista <strong>wszystkich</strong> znajdujących się w sklepie zamówień. Domyślnie zamówienia są posortowane wg daty złożenia od najnowszych do najstarszych. Powyżej okna z zamówieniami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych zamówień, które spełniają określone parametry. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania zamówień w listingu oraz poniżej znajduje się przycisk <strong>dodawania</strong> nowego zamówienia który otwiera formularz dodawania nowego zamówienia.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W liście zamówień każde zamówienie jest wyświetlane w osobnym wierszu. Pierwsza kolumna z ikonką umożliwia szybki podgląd podstawowych informacji o zamówieniu. Najechanie na ikonkę myszką powoduje wyświetlenie &quot;chmurki&quot; z informacjami o kupującym oraz zamówionych produktach bez konieczności wchodzenia w szczegóły zamówienia.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"\" src=\"obrazki/pomoc/zamowienia_masowa_zmiana_statusow.jpg\" style=\"width: 400px; height: 248px; float: left; margin-bottom: 15px; margin-right: 15px;\" />Kolejna kolumna zawiera pola wyboru umożliwiające zaznaczenie jednego lub kilku zamówień z listy i dokonanie w nich zmiany statusu zamówienia. Opcje tą można wybrać na dole listy produktów w polu <strong>Wykonaj akcję</strong>.<br />\r\n<br />\r\nPo wyborze zmiany statusu zamówień wyświetlą się dodatkowe pola do uzupełnienia (zaznaczenia). Trzeba wybrać jaki status mają mieć zaznaczone zamówienia, czy poinformować klienta e-mailem i sms-em o zmianie statusu zamówienia oraz dodatkowo w polu edytora można wpisać komentarz do zamówienia (taki sam dla wszystkich zaznaczonych zamówień). Jeżeli jest włączony System punktów - można także dla wszystkich zaznaczonych pozycji zatwierdzić punkty, które klient otrzymał za zakupy (zostanie zmieniony status punktów na zatwierdzone oraz zostaną dodane punkty do konta klienta, zwiększając jego ogólną ilość posiadanych punktów). Zatwierdzone zostaną tylko punkty związane z Systemem punktów - przy masowej zmianie statusów nie będą zatwierdzane punkty z Programu partnerskiego, które trzeba zatwierdzić osobno np w menu <strong>Sprzedaż / Klienci / Punkty do zatwierdzenia</strong>.<br />\r\n<br />\r\nZatwierdzenie wykonania zmiany statusów wybranych zamówień następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Po zatwierdzeniu zostanie zmieniony status zamówień oraz wysłana do klientów informacja (w zależności od wybranej formy poinformowania klienta).<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Kolejna kolumna wyświetla informację o wystawionej do danego zamówienia fakturze / paragonie. Następna kolumna, to dane klienta, który złożył zamówienie. Poza danymi kontaktowymi może być wyświetlona dodatkowa ikonka informująca o tym, że klient złożył zamówienie bez zakładania konta lub, że jest to klient, który już po raz kolejny składa w naszym sklepie zamówienie (stały klient). W dalszych kolumnach są informacje dotyczące szczegółów zamówienia takie jak: dokładna data jego złożenia, wartość całkowita zamówienia, wybrany rodzaj płatności oraz dostawy. Kolejna kolumna wyświetla aktualny status zamówienia. Status jest wyświetlany w formie rozwijanej listy gdzie w szybki sposób można zmienić status wybranych zamówień - wybierając z listy nowy status. Poniżej wyboru statusu można zaznaczyć, czy ze zmianą statusu zamówienia ma zostać do klienta wysłana informacja mailowa lub sms informująca o zmianie statusu danego zamówienia. W następnej kolumnie określony może być typ zamówienia jeżeli zamówienie nie zostało złożone przez klienta w sklepie. Dostępne inne typy zamówień, to zamówienie pochodzące z Allegro oraz zmówienie dopisane ręcznie przez obsługę sklepu.<br />\r\n<br />\r\nPrzed ostatnią kolumną zawierającą ikony nawigacyjne może być dodatkowo widoczna kolumna o nazwie Opinie, która będzie wyświetlała informacje na temat wysłanych do klientów maili z prośbą o opinie o sklepie. Ikonki opinii są widoczne tylko jeżeli jest w sklepie włączony moduł Opinie o sklepie w menu <strong>Sprzedaż / Opinie o sklepie / Konfiguracja opinii o sklepie</strong>. Ikonka w kolorze zielonym oznacza, że do tego zamówienia został wysłany mail z prośbą o wystawienie opinii o sklepie. Najechanie kursorem myszy na ikonę powoduje wyświetlenie informacji - kiedy mail został wysłany. Ikonka poniżej umożliwia wysłanie do klienta maila z prośbą o napisanie opinii. Po kliknięciu w ikonkę otwiera się nowa podstrona z wygenerowaną treścią maila i możliwością wysłania do klienta wiadomości.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\">W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję zamówienia (podgląd szczegółowych informacji, korespondencje do klienta), usunięcie oraz możliwość wygenerowania dokumentu PDF z zamówieniem lub faktury proforma. Z tego poziomu można także wysłać do klienta maila z zamówieniem - opcja szczególnie przydatna np w przypadku ręcznych zamówień. Ostatnia z ikon to zielona ikonka z plusem. Jej wciśnięcie rozwija poniżej danego zamówienia listę produktów z danego zamówienia. Lista zawiera id produktu, zdjęcie, nazwę produktu, nr katalogowy, cenę, zakupioną ilość. Po kliknięciu w zdjęcie produktu zostaje ono powiększone i wyświetlone w oknie popup.<br />\r\n<br />\r\nJeżeli w liście zamówień - zamówienie jest oznaczone czarną ikonką w formie przekreślonego koła - oraz tło danego zamówienia jest w formie szarych pasków oznacza to, że zamówienie zostało oznaczone jako &quot;podejrzane&quot; - czyli sklep wyszukał dane klienta z zamówienia w klientach dodanych do &quot;czarnej listy&quot;. Po wejściu w szczegóły takiego zamówienia wyświetlane są informacje - na jakiej podstawie sklep określił, że zamówienie jest &quot;podejrzane&quot;.</div>\r\n"),
("54","201","1","instrukcja","Edycja - zakładka Podstawowe dane","<div style=\"text-align: justify;\">W tej zakładce wyświetlane są wszystkie dane dotyczące klienta składającego zamówienie, dotyczące wybranego rodzaju wysyłki i płatności oraz zbiorcze podsumowanie całego zamówienia.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align: justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka1_czesc1_podsumowanie.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 540px; height: 82px;\" />Na samej górze zakładki wyświetlane jest zbiorcze podsumowanie zamówienia, uwzględniające wszystkie składniki składające się na łączną jego wartość. Są to takie elementy jak wartość produktów, koszt dostawy, udzielone zniżki czy wykorzystane kupony rabatowe.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka1_podsumowanie_edycja.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 600px; height: 171px;\" />Klikając w edycję podsumowania zamówienia przechodzimy do formularza, w którym są wyświetlone wszystkie elementy składające się na łączną sumę zamówienia. W tym miejscu obsługa sklepu ma możliwość dodania dowolnej nowej pozycji do podsumowania zamówienia lub usunięcia (poza wartością zamówionych produktów oraz łączną wartości zamówienia. Można także zmodyfikować treść opisu danej pozycji. Po zapisaniu danych całkowita wartość zamówienia zostaje automatycznie przez program przeliczona i zapisana w danych zamówienia.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka1_czesc1.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 560px; height: 306px;\" />W kolejnym oknie prezentowane są informacje o dacie złożenia zamówienia, dacie ostatniej modyfikacji, danych kontaktowych klienta. Jeżeli klient podczas składania zamówienia zawarł swoje uwagi, to są one wyświetlane w tej właśnie części. Tutaj również można przypisać do zamówienia opiekuna - osobę odpowiedzialną w sklepie za obsługę tego właśnie zamówienia (opiekunami zamówień mogą być osoby - administratorzy - dodane w panelu zarządzania do grupy <span style=\"color:#FF0000;\"><strong>Obsługa sprzedaży</strong></span> w menu <strong>Narzędzia / Grupy użytkowników</strong>). Po kliknięciu w ikonkę edycji w wierszu dotyczącym opiekuna zostanie wyświetlona rozwijana lista zdefiniowanych w sklepie pracowników mających dostęp do panelu administracyjnego sklepu.</div>\r\n<img alt=\"alt\" height=\"50\" src=\"obrazki/pomoc/zamowienie_zakladka1_opiekun.jpg\" style=\"margin:15px;float:left;\" width=\"286\" />\r\n<div style=\"text-align:justify;\"><br />\r\nW części tej jest również informacja o dokumencie sprzedaży jaki chce otrzymać klient. Jeżeli klient trafił do sklepu z określonej innej strony www jest także w tym miejscu wyświetlany adres strony oraz nr IP z jakiego klient złożył zamówienie.</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka1_faktura_edycja.jpg\" style=\"width: 620px; height: 504px; margin: 10px; float: right;\" /></div>\r\n\r\n<div style=\"text-align:justify;\">W ostatnim wierszu tej części zakładki zawarte są informacje o wygenerowanych dokumentach sprzedaży, o tym czy są one zapłacone, czy płatność jest już przeterminowana. Klikając w ikonkę edycji można dokonać edycji generowanej faktury. Kliknięcie w ikonki oznaczone znakami PDF powoduje wygenerowanie dokumentów PDF - zamówienia PDF, faktury proforma w formacie PDF lub faktury głównej PDF - o ile została utworzona dla danego zamówienia. Można także utworzyć dokument Paragon PDF jeżeli klient nie chce otrzymać faktury.<br />\r\n<br />\r\nPodczas edycji faktury administrator sklepu ma możliwość wprowadzenia modyfikacji do danych, które będą generowane na fakturze - w tym: danych klienta, rodzaju płatności oraz danych produktów - nazwy, ceny itd. Jeżeli modyfikowane są pozycje faktury: zakupione produkty, pozycje dodatkowe jak koszt wysyłki itp to dane te po zapisie są również zmieniane w pozycjach podsumowania zamówienia.</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n\r\n<div style=\"text-align:center;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka1_dane_adresowe.jpg\" style=\"width:600px;height:194px;margin-left:15px;margin-bottom:15px;float:right;\" />\r\n<div style=\"text-align:justify;\"><strong>Kolejnym elementem tej zakładki</strong> są informacje o danych do wysyłki towaru oraz o płatniku, które mają się znaleźć na fakturze. Po kliknięciu w ikonkę edycji wyświetlany jest formularz, w którym można wprowadzić zmiany danych adresowych. Dotyczy to zarówno danych do wysyłki towaru jak również danych, które mają się znaleźć na dokumencie sprzedaży.</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Kolejne elementy zakładki</strong> z podstawowymi danymi o zamówieniu są to informacje na temat wybranego przez klienta rodzaju wysyłki oraz sposobu płatności. Tutaj również istnieje możliwość ręcznej modyfikacji wszystkich elementów przez obsługę sklepu.</div>\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka1_podsumowanie.jpg\" style=\"margin-right:15px;margin-top:15px;margin-bottom:15px;float: left; width: 544px; height: 95px;\" />\r\n<div style=\"text-align:justify;\"><br />\r\nKlikając w poszczególne ikonki edycji mamy możliwość zmiany poszczególnych informacji. W przypadku dostawy i płatności po kliknięciu w edycję wyświetlane są rozwijane listy zawierające odpowiednio zdefiniowane w sklepie rodzaje wysyłek lub płatności.</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align: justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka1_czesc1_dod_pola.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 600px; height: 99px;\" />Ostatnim elementem, który może być wyświetlany w opisywanej zakładce są dodatkowe pola do zamówienia. Są to elementy, które można samodzielnie zdefiniować w menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do zamówień</strong>. Administrator sklepu może zdefiniować dowolne pola wg własnych potrzeb. Mogą to być pola typu tekstowego, listy wyboru, itp. Można zdefiniować czy pola mają być wymagane przy składaniu zamówienia czy nie. Opcja ta jest szczegółowo opisana w instrukcji w części dotyczącej definiowania własnych pól do zamówień.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/zamowienia_czarna_lista.jpg\" style=\"margin-bottom: 15px; margin-right: 15px; float: left; width: 420px; height: 197px;\" />Jeżeli zamówienie zostało przez sklep zakwalifikowane jako &quot;podejrzane&quot; nad informacją o podsumowaniu zamówienia jest wyświetlana dodatkowa informacja o danych na podstawie jakich zamówienie zostało określone jako &quot;podejrzane&quot;. Zamówienia są sprawdzane w powiązaniu z listą klientów, którzy zostali dodani do tzw &quot;czarnej listy klientów&quot; w menu <strong>Sprzedaż / Klienci / Klienci</strong>.<br />\r\n<br />\r\nPodczas składania zamówienia sklep sprawdza czy na &quot;czarnej liście&quot; nie znajduję się klient o podobnych danych jak w złożonym zamówieniu. Sklep sprawdza: id klienta w bazie, imię i nazwisko, firmę, nip, adres, email, nr telefonu oraz&nbsp; adres IP klienta. Jeżeli zostanie znaleziony klient o takim samym id, email lub adresie IP - zamówienie zostanie oznaczone jako &quot;podejrzane&quot;. Jeżeli id, email i adres IP będą inne ale zostaną znalezione 3 inne wspólne parametry - np ulica, miasto i nazwisko - wtedy także zamówienie zostanie oznaczone jako &quot;podejrzane&quot; - umożliwia to wychwytywanie zamówień klientów, którzy zmienili adres email, założyli nowe konto lub korzystają ze zmiennego adresu IP.&nbsp;<br />\r\n<br />\r\nZ poziomu tego okna można przejść do edycji klienta na podstawie którego sklep określił, że dane zamówienie jest &quot;podejrzane&quot;. Można także usunąć status zamówienia &quot;podejrzanego&quot; i wtedy informacje o tym statusie dla danego zamówienia zostaną usunięte.</div>\r\n</div>\r\n"),
("55","177","0","instrukcja","Dodawanie / edycja pojedynczego kuponu rabatowego","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie.jpg\" style=\"width:350px;height:130px;margin-bottom:15px;margin-right:15px;float:left;\" />Aby dodać nowy kupon rabatowy należy kliknąć w przycisk: dodaj nowy kupon, który znajduje się nad listą wszystkich kuponów.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Po kliknięciu otworzy się formularz dodawania nowego kuponu rabatowego. W formularzu należy wypełnić poszczególne pola. Najważniejsze pole przy dodawaniu nowego kuponu pojedynczego to pole Kod kuponu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>Kod kuponu</strong> - jest to pole w którym należy wpisać kod kuponu jaki klient będzie podawał przy składaniu zamówienia. Zaleca się, żeby kod składał się z liter oraz cyfr. Proszę nie używać znaków typu przecinek, wykrzyknik, nawiasy. Ważne jest także, żeby kod kuponu nie był za krótki - dzięki czemu zachowa się unikalność kodu kuponu. Nie można dodać do sklepu dwóch kuponów z takim samym kodem. Sklep przy wprowadzaniu kodu - sprawdza czy dany kod nie istnieje już w bazie - jeżeli istnieje wyświetli stosowny komunikat.</div>\r\n<br />\r\n<strong>Opis kuponu</strong> - jest to pole widoczne tylko dla administratora sklepu - pole opisowe służące do identyfikacji kuponu przez administratora sklepu.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><strong>Rodzaj kuponu</strong> - należy wybrać czy kupon będzie procentowy, kwotowy czy będzie dotyczył darmowej wysyłki. Jeżeli wartość kuponu będzie <strong>kwotowa</strong> należy wpisać poniżej w polu <strong>Wartość rabatu</strong> - wartość kwotową rabatu (wartość w domyślnej walucie sklepu). Taki kupon będzie miał stałą wartość, niezależnie od wartości zamówienia. Jeżeli zostanie wybrana opcja <strong>procentowa </strong>to poniżej w polu <strong>Wartość rabatu</strong> należy wpisać ilość procent. Taki kupon będzie zależny od wartości zamówienia i jego wartość będzie różna w zależności od wartości zamówienia. Dla przykładu jeżeli zostanie wpisana wartość 10%, a wartość zamówienia będzie to 100 zł to kupon będzie miał wartość 10 zł. W przypadku wyboru darmowej wysyłki nie wpisuje się wartości kuponu (jest ona pobierana z kosztów wysyłki zamówienia klienta).<br />\r\n<br />\r\n<strong>Pole data rozpoczęcia oraz data zakończenia</strong> - pola umożliwiają ustawienie daty rozpoczęcia oraz zakończenia działania kuponu. Jeżeli daty zostaną wprowadzone to kupon będzie aktywny tylko w zakresie podanych dat. Można zdefiniować tylko datę rozpoczęcia lub tylko datę zakończenia. Jeżeli kupon ma być aktywny cały czas należy pozostawić pola dat puste.<br />\r\n<br />\r\n<strong>Dodatkowe warunki wykluczające użycie kuponu</strong>. W tym miejscu można wstawić dodatkowe warunki użycia kuponu. Klient sklepu będzie mógł użyć danego kuponu tylko jeżeli będą spełnione dodatkowe warunki.<br />\r\n<br />\r\n<strong>Dostępny dla grupy klientów.</strong> Opcja umożliwia ograniczenie możliwości wykorzystania kuponu rabatowego dla określonej grupy klientów. Klienci tylko z wybranej grupy / grup będą mogli skorzystać z kuponu. Dotyczy grup klientów definiowanych w menu <strong>Sprzedaż / Klienci / Grupy klientów</strong>.<br />\r\n<br />\r\n<strong>Minimalna ilość produktów</strong> - określa minimalną ilość produktów w koszyku jaką klient musi posiadać, żeby móc użyć kuponu. Liczy się ogólna ilość produktów - może to być np 3 szt produktu X lub suma produktów 2 szt X i 1 szt Y. Do sumy nie są uwzględniane produkty dodane do koszyka dodatkowo np gratisy.<br />\r\n<br />\r\n<strong>Minimalna wartość zamówienia</strong> - określa minimalną wartość zamówienia przy jakiej będzie można użyć kuponu. Do wartości zamówienia nie są uwzględniane produkty dodane do koszyka dodatkowo np gratisy.<br />\r\n<br />\r\n<strong>Produkty promocyjne</strong> - określa czy kuponem mają być również objęte produkty promocyjne. Jeżeli opcja jest włączona to kupon można zrealizować dla wszystkich produktów. Jeżeli opcja jest wyłączona to produkty promocyjne nie będą objęte kuponem rabatowym.<br />\r\n<br />\r\n<strong>Warunki użycia kuponu: wybrane kategorie, wybrani producenci, wybrane produkty</strong> - opcja umożliwia przypisanie kuponów do np konkretnych produktów. Zdefiniowany tak kupon będzie można wykorzystać tylko na wybrane kategorie, producentów czy produkty. W miejscu tym, można zaznaczyć tylko albo kategorie, albo producentów, albo produkty - nie można połączyć np kategorii i produktu.<br />\r\n<br />\r\nOstatnia pozycja to <strong>Ilość dostępnych kuponów</strong> - określa ile kuponów o takim kodzie jest dostępnych - tzn ile razy można użyć kupon o podanym kodzie. Jeżeli zostanie wpisana wartość 1 to będzie to oznaczało, że jest tylko jeden kupon o danym kodzie. Przy wpisaniu np wartości 3 - będzie to oznaczało, że o podanym kodzie są dostępne 3 kupony i kupon będzie mógł być użyty 3-krotnie - przez różnych klientów lub jednego klienta.<br />\r\n<br />\r\nPodczas edycji istniejącego kuponu formularz edycji zawiera takie same pola jak formularz dodawania nowego kuponu. Jedynie pola kod kuponu oraz wykluczenia kategorii, producentów oraz produktów są wyświetlane - są bez możliwości edycji - te wartości można definiować wyłącznie podczas dodawania kuponu. Pozostałe parametry można dowolnie zmodyfikować.</div>\r\n"),
("56","178","0","instrukcja","Dodawanie / edycja serii kuponów z prefixem","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_prefix.jpg\" style=\"width:450px;height:102px;float:right;margin-left:15px;margin-bottom:15px;\" />Dodawanie serii nowych kuponów z prefixem umożliwia dodanie wielu kuponów na raz o określonych kodach. Moduł ułatwia pracę dodając jednorazowo określoną ilość kuponów z różnymi kodami - nie trzeba ręcznie dodawać każdego kuponu osobno.<br />\r\n	<br />\r\n	Po kliknięciu w ikonę dodawania serii kuponów z prefixem otworzy się formularz dodawania nowego kuponu rabatowego. W formularzu należy wypełnić poszczególne pola. Pola w większości są identyczne z formularzem dodawania pojedynczego kuponu. Różnica jest w części górnej formularza - przy definiowaniu kodu kuponu. Przy dodawaniu pojedynczego kuponu trzeba wpisać unikalny kod kuponu. Przy dodawaniu serii kuponów z prefixem nie podaje się kodu, a parametry do utworzenia serii kodów.<br />\r\n	<br />\r\n	<strong>Prefix do kodu kuponu</strong> - jest to ciąg znaków który będzie znajdował się na początku kodu kuponu rabatowego. Zaleca się, żeby składał się wyłącznie z liter.<br />\r\n	<br />\r\n	<strong>Zakres liczbowy od - do</strong> - tutaj określa się jaki zakres liczbowy mają mieć kupony. Wartość od powinna być większa od wartości do. Ilość kuponów jaka będzie utworzona jest różnicą wartości do minus od.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_prefix_zakres.jpg\" style=\"width:220px;height:82px;float:left;margin-bottom:15px;margin-right:15px;\" />Przykład dodawania nowej serii kuponów z prefixem. W polu prefix została wpisana wartość ABC. W zakresie od - cyfra 1, w zakresie do - liczba 10. Takie dane utworzą w sklepie 10 nowych kuponów rabatowych. Będą to kody: ABC1, ABC2, ABC3, ABC4, ABC5, ABC6, ABC7, ABC8, ABC9, ABC10. Każdy kod będzie unikalny.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_prefix_usuwanie.jpg\" style=\"width:220px;height:81px;float:right;margin-left:15px;margin-bottom:15px;\" />Jeżeli podczas dodawania kuponu sklep sprawdzi, że nowo dodawany kod już istnieje w sklepie - kupon nie zostanie dodany. Dodane przez opisany moduł kupony można usunąć masowo poprzez akcje na stronie listingu kuponów rabatowych (pod listingiem produktu). Jedna z dostępnych akcji umożliwia usunięcie kuponów o określonym prefixie. Po wybraniu opcji wyświetli się dodatkowe pole do wpisania prefixu. Po zatwierdzeniu usunięcia przyciskiem Zapisz zmiany - kupony o podanym prefixie zostaną usunięte.</div>\r\n<br />\r\n<div style=\"text-align:justify;\">\r\n	Edycja istniejącego kuponu wygenerowanego przy pomocy serii z prefixem jest identyczna jak przy edycji pojedynczego kuponu. Po zapisaniu serii z prefixem są w bazie tworzone pojedyncze kupony i każdy jest osobnym kupnem. Formularz edycji zawiera takie same pola jak formularz dodawania nowego kuponu. Jedynie pola kod kuponu oraz wykluczenia kategorii, producentów oraz produktów są wyświetlane - są bez możliwości edycji - te wartości można definiować wyłącznie podczas dodawania kuponu. Pozostałe parametry można dowolnie zmodyfikować.</div>\r\n"),
("57","179","0","instrukcja","Dodawanie / edycja serii kuponów losowych","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_losowe.jpg\" style=\"width:440px;height:98px;float:right;margin-left:15px;margin-bottom:15px;\" />Dodawanie nowych kuponów losowych umożliwia dodanie wielu kuponów na raz o losowych kodach. Moduł ułatwia pracę dodając jednorazowo określoną ilość kuponów z różnymi kodami - nie trzeba ręcznie dodawać każdego kuponu osobno.<br />\r\n	<br />\r\n	Po kliknięciu w ikonę dodawania serii kuponów losowych otworzy się formularz dodawania nowego kuponu rabatowego. W formularzu należy wypełnić poszczególne pola. Pola w większości są identyczne z formularzem dodawania pojedynczego kuponu. Różnica jest w części górnej formularza - przy definiowaniu kodu kuponu. Przy dodawaniu pojedynczego kuponu trzeba wpisać unikalny kod kuponu. Przy dodawaniu serii kuponów losowych nie podaje się kodu, a parametry do utworzenia serii kodów.<br />\r\n	<br />\r\n	<strong>Prefix do kodu kuponu</strong> - jest to ciąg znaków który będzie znajdował się na początku kodu kuponu rabatowego. Zaleca się, żeby składał się wyłącznie z liter. Pomimo tego, że kody kuponów będą losowymi wartościami muszą posiadać wspólny prefix. Jest to koniczne, żeby można było łatwo zarządzać dodanymi kuponami, np wyszukać kupony o określonym prefixie lub usunąć.<br />\r\n	<br />\r\n	<strong>Z ilu znaków ma mieć kupon ?</strong> - tutaj określa się z ilu znaków ma być wygenerowany losowy ciąg. Zaleca się, żeby ilość znaków nie była mniejsza niż 5 - czym większa ilość znaków tym kod kuponu będzie bardziej unikalny.<br />\r\n	<br />\r\n	<strong>Ile kuponów wygenerować ?</strong> - określa ile kuponów ma być wygenerowanych. W odróżnieniu od dodawania kuponów z prefixem gdzie podaje się zakres liczb od - do i ilość kuponów to różnica pomiędzy wartościami od a do - w tym module podaje się ilość kuponów do wygenerowania ponieważ każdy kod będzie miał kod losowy.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_losowe_zakres.jpg\" style=\"width:240px;height:85px;float:left;margin-bottom:15px;margin-right:15px;\" />Przykład dodawania nowej serii kuponów losowych. W polu prefix została wpisana wartość ABC. W polu z ilu znaków ma się składać kupon wartość 10. Ilość kuponów do wygenerowania to 2. Po zapisaniu sklep wygenerował kody: ABCB0G7LMFML09 oraz ABCL4PBLYM7S31. Jak widać ciąg tekstu poza ABC jest losowy. Ciąg losowy składa się z dużych liter oraz cyfr. Każdy kod będzie unikalny.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_prefix_usuwanie.jpg\" style=\"width:220px;height:81px;float:right;margin-left:15px;margin-bottom:15px;\" />Jeżeli podczas dodawania kuponu sklep sprawdzi, że nowo dodawany kod już istnieje w sklepie - kupon nie zostanie dodany. Dodane przez opisany moduł kupony można usunąć masowo poprzez akcje na stronie listingu kuponów rabatowych (pod listingiem produktu). Jedna z dostępnych akcji umożliwia usunięcie kuponów o określonym prefixie. Po wybraniu opcji wyświetli się dodatkowe pole do wpisania prefixu. Po zatwierdzeniu usunięcia przyciskiem Zapisz zmiany - kupony o podanym prefixie zostaną usunięte.</div>\r\n<br />\r\n<div style=\"text-align:justify;\">\r\n	Edycja istniejącego kuponu wygenerowanego przy pomocy serii kuponów losowych jest identyczna jak przy edycji pojedynczego kuponu. Po zapisaniu serii kuponów są w bazie tworzone pojedyncze kupony i każdy jest osobnym kupnem. Formularz edycji zawiera takie same pola jak formularz dodawania nowego kuponu. Jedynie pola kod kuponu oraz wykluczenia kategorii, producentów oraz produktów są wyświetlane - są bez możliwości edycji - te wartości można definiować wyłącznie podczas dodawania kuponu. Pozostałe parametry można dowolnie zmodyfikować.</div>\r\n"),
("58","180","0","instrukcja","Dodawanie / edycja serii kuponów losowych z wysłaniem na maila","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_losowe_mail.jpg\" style=\"width:440px;height:126px;float:right;margin-left:15px;margin-bottom:15px;\" />Dodawanie nowych kuponów losowych z możliwością wysłania informacji o kuponie na e-maila umożliwia dodanie wielu kuponów na raz o losowych kodach. Dodatkowo generowane kody są wysyłane mailowo na wybrane adresy e-mail. Moduł ułatwia pracę dodając jednorazowo określoną ilość kuponów z różnymi kodami - nie trzeba ręcznie dodawać każdego kuponu osobno oraz wysyłać indywidualnie maili do klientów.<br />\r\n	<br />\r\n	Po kliknięciu w ikonę dodawania serii kuponów losowych z wysyłaniem na maila otworzy się formularz dodawania nowego kuponu rabatowego. W formularzu należy wypełnić poszczególne pola. Pola w większości są identyczne z formularzem dodawania pojedynczego kuponu. Różnica jest w części górnej formularza - przy definiowaniu kodu kuponu. Przy dodawaniu pojedynczego kuponu trzeba wpisać unikalny kod kuponu. Przy dodawaniu serii kuponów losowych nie podaje się kodu, a parametry do utworzenia serii kodów.<br />\r\n	<br />\r\n	<strong>Prefix do kodu kuponu</strong> - jest to ciąg znaków który będzie znajdował się na początku kodu kuponu rabatowego. Zaleca się, żeby składał się wyłącznie z liter. Pomimo tego, że kody kuponów będą losowymi wartościami muszą posiadać wspólny prefix. Jest to koniczne, żeby można było łatwo zarządzać dodanymi kuponami, np wyszukać kupony o określonym prefixie lub usunąć. W porównaniu z modułem generowania kodów bez wysyłania maila nie ma tutaj możliwości określania z ilu znaków ma się składać generowany kod. Kod będzie składał się z prefixu oraz 15 losowych znaków.<br />\r\n	<br />\r\n	Dodatkową opcją przy dodawaniu kuponów są <strong>dane maila</strong>. W polu Dane maila należy wybrać tytuł newslettera (newsletter), który będzie używany do wysyłania wiadomości. Od wybrania odpowiedniego newslettera będzie zależało do kogo kody zostaną wysłane. Jeżeli zostanie wybrany newsletter powiązany np z grupą mailingu - maile zostaną wysłane do klientów, którzy są dodani w sklepie do mailingu. Od ilości odbiorów wiadomości e-mail będzie zależała ilość utworzonych kuponów. Do każdego e-maila zostanie utworzony indywidualny kod kuponu.<br />\r\n	<br />\r\n	<span style=\"color:#ff0000;\"><strong>WAŻNE:</strong></span> Przed wygenerowaniem kuponów należy najpierw <strong>utworzyć newsletter</strong>, który będzie wykorzystywany do wysyłania maili z kodem kuponu. Wykorzystanie do wysyłania wiadomości z kodem kuponu newslettera pozwala na zdefiniowanie dowolnej treści maila jaki będzie wysyłany. Nowy newsletter można utworzyć w menu <strong>Sprzedaż / Newsletter / Newsletter</strong>. Dokładny opis tworzenia newslettera znajduje się w dalszej części instrukcji. Najważniejszym elementem przy tworzeniu newslettera do wysyłania kodów rabatowych jest użycie odpowiedniego znacznika w treści maila, który będzie wysyłany. Znacznik ten to: <b>{KUPON_RABATOWY}</b> - przy wysyłaniu maila w miejsce tego znacznika będzie wstawiony kod wygenerowanego kuponu. Bez tego znacznika maile zostaną wysłane, klienci otrzymają maila z treścią - ale bez kodu kuponu - czyli takie maile będą bezwartościowe.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_dodawanie_losowe_mail_wysylanie.jpg\" style=\"width:300px;height:96px;float:left;margin-bottom:15px;margin-right:15px;\" />Po uzupełnieniu formularza kuponów rabatowych oraz wybraniu odpowiedniego newslettera należy wcisnąć przycisk <strong>Przejdź dalej</strong>. W porównaniu z pozostałymi modułami dodawania kuponów - kupony nie zostaną zapisane - ale otworzy się kolejne okno gdzie widoczne będzie podsumowanie dodawania kuponów: tytuł wiadomości, odbiorcy maila, ilość maili do wysłania oraz prefix kuponów rabatowych jakie będą generowane. Z tego miejsca można jeszcze powrócić i generowanie oraz wysyłanie wiadomości zostanie przerwane. Wciśnięcie przycisku <strong>Wyślij wiadomości</strong> spowoduje rozpoczęcie wysyłania wiadomości. Rozwinie się dalsza część okna z paskiem postępu pokazującym ile wiadomości zostało wysłanych. Po wysłaniu wszystkich wiadomości wyświetli się komunikat informujący, że maile zostały wysłane. Podczas wysyłania maili nie wolno odświeżać ani zamykać okna przeglądarki. Takie operacje spowodują przerwanie procesu wysyłania maili i tylko częściowe wysłanie wiadomości.<br />\r\n	<br />\r\n	Edycja istniejącego kuponu wygenerowanego przy pomocy serii kuponów losowych z wysyłaniem na maila jest identyczna jak przy edycji pojedynczego kuponu. Podczas wysyłania wiadomości, dane kuponów są zapisywane w bazie i są tworzone pojedyncze kupony gdzie każdy jest osobnym kupnem. Formularz edycji zawiera takie same pola jak formularz dodawania nowego kuponu. Jedynie pola kod kuponu oraz wykluczenia kategorii, producentów oraz produktów są wyświetlane - są bez możliwości edycji - te wartości można definiować wyłącznie podczas dodawania kuponu. Pozostałe parametry można dowolnie zmodyfikować.<br />\r\n	<br />\r\n	<span style=\"color:#ff0000;\"><strong>WAŻNE: </strong></span>Przy generowaniu kuponów przy pomocy opisywanego modułu - dodatkowo w kuponach zapisywana jest informacja na jaki adres dany kupon został wysłany. Informacja jaki to mail jest widoczna podczas edycji kuponu oraz po najechaniu kursorem myszy na ikonę <strong>info</strong> (pierwsza kolumna w listingu kuponów rabatowych).</div>\r\n"),
("59","202","1","instrukcja","Edycja - zakładka Wysyłki","<div style=\"text-align:justify;\">W zakładce edycji jest możliwość generowania automatycznie wysyłek do firmy wysyłkowych lub pośredniczących w obsłudze kurierów. Obecnie w programie dostępna jest możliwość automatycznego generowania przesyłek do firm: kurJerzy, Siódemka, DHL oraz InPost.<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka2.jpg\" style=\"width: 700px; height: 298px; margin-left: 15px; margin-bottom: 15px; margin-top: 15px; float: right;\" /><br />\r\nWarunkiem skorzystania z opcji generowania przesyłek jest posiadanie konta w wybranej firmie wysyłkowej lub firmie pośredniczącej.<br />\r\n<br />\r\nDo każdego zamówienia można utworzyć dowolną ilość wysyłek, chociaż z reguły ogranicza się to do jednej pozycji.<br />\r\n<br />\r\n<strong>Na liście utworzonych wysyłek</strong> w pierwszej kolumnie znajduje się nazwa firmy, w drugiej numer dokumentu, który został wygenerowany w firmie kurierskiej. Następnie jest data utworzenia wysyłki, ilość paczek, aktualny status i data ostatniej aktualizacji. W ostatniej kolumnie znajdują się ikony nawigacyjne. Mogą one być różne w zależności od tego do jakiej firmy była generowana wysyłka.<br />\r\n<br />\r\nNa dole zakładki umieszczone są ikony firm kurierskich. Kliknięcie w wybraną ikonę otwiera formularz, który umożliwia wygenerowanie przesyłki. Żeby można było skorzystać z funkcji generowania przesyłek, należy najpierw zdefiniować dane dostępowe do konta API w wybranych firmach. Parametry te definiuje się w menu <strong>Integracje / Firmy wysyłkowe</strong>. Obecnie opisane zostanie tworzenie wysyłki na podstawie firmy kurierskiej Siódemka.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka2_siodemka.jpg\" style=\"margin-right: 15px; margin-bottom: 15px; float: left; width: 617px; height: 483px;\" />Po kliknięciu w logo firmy, otwiera się formularz, w którym należy wprowadzić dane niezbędne do utworzenia wysyłki.<br />\r\n<br />\r\nFormularz składa się z kilku części, w których należy wprowadzić dane dotyczące tworzonej wysyłki. Parametry te są uzależnione od konkretnej firmy wysyłkowej.<br />\r\n<br />\r\nW przypadku Siódemki należy wprowadzić informacje takie jak typ przesyłki, kto będzie płacił za przesyłkę, jaka jest forma płatności.<br />\r\n<br />\r\nW przypadku przesyłki pobraniowej można wprowadzić kwotę pobrania oraz formę zwrotu należności. W prawej części formularza są wyświetlane szczegółowe informacje dotyczące zamówienia dla którego jest tworzona przesyłka, które mogą być pomocne podczas wypełniania danych.<br />\r\n<br />\r\nW ostatniej części formularza jest pole przeznaczone na wprowadzenie szczegółów dotyczących wysyłanych paczek.&nbsp; Każda wysyłka może składać się z kilku paczek. Należy wprowadzić informacje dotyczące wymiarów oraz wagi każdej paczki osobno. W formularzu można wiele paczek. Można również usunąć paczkę jeżeli została błędnie wprowadzona.<br />\r\n<br />\r\nPo wypełnieniu wszystkich pól formularza można utworzyć przesyłkę klikając w przycisk <strong>utwórz przesyłkę</strong>.<br />\r\n<br />\r\nPo zatwierdzeniu formularza utworzona właśnie przesyłka pojawia się na liście szczegółów. Numer dokumentu jest nadawany automatycznie przez firmę kurierską. Po wygenerowaniu przesyłki można od razu wydrukować etykietę wygenerowaną w firmie kurierskiej poprzez API. Można także sprawdzać aktualny status przesyłki.<br />\r\n<br />\r\nW przypadku kuriera DHL podczas tworzenia przesyłki jest generowany plik XML, który następnie można wczytać w aplikacji DHL eCAS. Program eCAS posiada możliwość wczytywania danych z plików xml o określonej strukturze. Jeden plik xml odpowiada jednej przesyłce.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka2_lista.jpg\" style=\"width:700px;height:185px;margin-right:15px;float:left;\" />Przykład zawartości listy dla różnych utworzonych wysyłek</div>\r\n"),
("60","181","0","instrukcja","Eksport kuponów rabatowych","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_eksport.jpg\" style=\"width: 550px; height: 187px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Ważną funkcją umożliwiającą zarządzanie kuponami rabatowymi jest możliwość wyeksportowania wygenerowanych kuponów. Służy do tego opcja <strong>eksportuj dane do pliku</strong>. Po wybraniu tej opcji wyświetli się formularz generowania eksportu.<br />\r\n<br />\r\nPierwsze trzy pola umożliwiają ograniczenie eksportu kuponów do kuponów o określonym prefixie (trzeba wpisać prefix z jakim mają być eksportowane kupony) oraz o określonych datach dodania. Jeżeli pola pozostaną puste wygenerowane zostaną wszystkie kupony.<br />\r\n<br />\r\nPoniżej w/w pól znajdują się opcje do zaznaczenia - jakie dane mają zostać wyeksportowane. Można wybrać, które pozycje mają być zapisane w eksportowanym pliku.<br />\r\n<br />\r\nPo wciśnięciu przycisku <strong>Wygeneruj dane</strong> zostanie wygenerowany plik csv, który można pobrać i zapisać na dysku. Po otworzeniu pliku np w OpenOffice (zalecamy ten pakiet do obórki plików csv) można edytować pobrane dane. Plik posiada kodowanie polskich znaków w standardzie UTF-8, a pola są rozdzielone znakiem średnika (separator pól).<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_eksport_excel.jpg\" style=\"width:650px;height:65px;float:left;margin-bottom:15px;margin-right:15px;\" />Wygenerowany plik po otworzeniu w arkuszu kalkulacyjnym wyświetla dane w formie kolumn. Ilość kolumn jest zależna od zaznaczonych danych do eksportu Każda zaznaczona opcja to osobna kolumna. W przypadku wykluczenia produktów promocyjnych kolumna <strong>Promocja</strong> wyświetla słowo <strong>tak</strong> lub <strong>nie</strong>. Słowo <strong>tak</strong> oznacza, że produkty promocyjne są objęte danym kuponem rabatowym, słowo - <strong>nie</strong> - że nie są objęte. Kolumna <strong>ograniczenia typ</strong> - wyświetla dodatkowe warunki ograniczenia - możliwe warianty to: <strong>kategorie, producent </strong>lub<strong> produkt</strong>. Jeżeli kolumna nie jest pusta i zawiera jeden z wariantów oznacza to, że dany kupon jest dostępny tylko dla np wybranych kategorii. W kolejnej kolumnie wyświetlane są numery id ograniczeń np kategorii dla których kupon rabatowy jest dostępny.</div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("61","182","0","instrukcja","Import kuponów rabatowych","Istotnym modułem w kuponach rabatowych jest możliwość importu kuponów z zewnętrznych plików. Jest to przydatna opcja, kiedy właściciel sklepu chce skorzystać z oferty kuponów innych podmiotów - np z groupona. Otrzymaną listę kodów kuponów rabatowych można w łatwy sposób zaimportować do sklepu. Można także przygotować własny plik z kodami kuponów w arkuszu kalkulacyjnym i zapisany w arkuszu plik csv zaimportować do sklepu.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/kupony_rabatowe_import.jpg\" style=\"width: 330px; height: 421px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Moduł importu danych kuponów w głównej części składa się z pol, które określają jakie dane będą importowane.&nbsp; Należy zaznaczyć te pola, które zawiera importowany plik. Przy każdym zaznaczonym polu należy również podać <strong>kolejność pola w pliku</strong> - tzn w której kolumnie się znajduje.<br />\r\n<br />\r\nMożliwe pola do importu oraz dopuszczalne wartości:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>kod kuponu</strong> - unikalny kod kuponu jaki klient będzie wpisywał podczas dokonywania zakupu - dopuszczalne wartości do litery oraz cyfry</li>\r\n	<li style=\"text-align:justify;\"><strong>opis</strong> - jest to pole opisowe służące do identyfikacji kuponu przez administratora sklepu - dopuszczalne wartości - dowolny tekst</li>\r\n	<li style=\"text-align:justify;\"><strong>rodzaj kuponu</strong> - określa czy kupon będzie miał wartość procentową, kwotową lub darmowej wysyłki - dopuszczalne wartości to słowa: <strong>kwota</strong> lub <strong>procent</strong> lub <strong>wysylka</strong></li>\r\n	<li style=\"text-align:justify;\"><strong>zniżka</strong> - wartość liczbowa określająca wartość kuponu, jako separator ułamkowy należy stosować kropkę (nie przecinek - czyli np 1,5 należy zapisać jako 1.5)</li>\r\n	<li style=\"text-align:justify;\"><strong>ważność od lub do </strong>- pola umożliwiają ustawienie daty rozpoczęcia oraz zakończenia działania kuponu - dopuszczalne wartości do format daty w postaci dzien-miesiac-rok np 01-01-2015 oznacza 1 styczeń 2015 roku</li>\r\n	<li style=\"text-align:justify;\"><strong>id grupy klientów</strong> - pole umożliwia ograniczenie możliwości wykorzystania kuponu rabatowego dla określonej grupy klientów. Klienci tylko z wybranej grupy będą mogli skorzystać z kuponu. Dotyczy grup klientów definiowanych w menu <strong>Sprzedaż / Klienci / Grupy klientów</strong> - w tym menu można także sprawdzić jakie id mają poszczególne grupy, w polu musi znajdować się id grupy, a nie nazwa</li>\r\n	<li style=\"text-align:justify;\"><strong>minimalna ilość produktów</strong> - określa minimalną ilość produktów w koszyku jaką klient musi posiadać, żeby móc użyć kuponu - dopuszczalne wartości: liczba od 0 wzwyż</li>\r\n	<li style=\"text-align:justify;\"><strong>minimalna wartość zamówienia</strong> - określa minimalną wartość zamówienia przy jakiej będzie można użyć kuponu - dopuszczalne wartości: liczba od 0 wzwyż</li>\r\n	<li style=\"text-align:justify;\"><strong>ilość dostępnych kuponów</strong> - określa ile kuponów o takim kodzie jest dostępnych - dopuszczalne wartości: liczba od 1 wzwyż</li>\r\n	<li style=\"text-align:justify;\"><strong>produkty promocyjne</strong> - określa czy kuponem mają być również objęte produkty promocyjne - dopuszczalne wartości to słowa: tak lub nie</li>\r\n	<li style=\"text-align:justify;\"><strong>ograniczenia typ</strong> - opcja umożliwia przypisanie kuponów do np konkretnych produktów, kategorii lub producenta - dopuszczalne wartości to słowa: kategorie, producenci, produkty</li>\r\n	<li style=\"text-align:justify;\"><strong>ograniczenia id</strong> - określa numery id ograniczeń np kategorii dla których kupon rabatowy jest dostępny - dopuszczalne wartości - liczby rozdzielone przecinkami</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Po zaznaczeniu odpowiednich opcji i wpisaniu kolejności pól, należy wybrać separator pól (jakim znakiem są rozdzielone pola / kolumny w pliku) oraz wybrać plik do importu. Po kliknięciu w przycisk <strong>Przeglądaj</strong> -&nbsp; otworzy się okno z możliwością wybrania pliku który będzie importowany. Po wybraniu pliku - import danych rozpoczyna się po kliknięciu w przycisk <strong>Importuj dane</strong>.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nPrzykład importu: plik csv który zawiera jeden wiersz z danymi i wygląda następująco:<br />\r\n<br />\r\nTEST1;procent;10;1<br />\r\n<br />\r\nPo rozbiciu na poszczególne kolumny (rozdzieleniu średnikiem) uzyskamy dane:<br />\r\n<br />\r\nTEST1<br />\r\nprocent<br />\r\n10<br />\r\n1<br />\r\n<br />\r\nPierwsza pozycja to <strong>kod kuponu</strong>, druga określa <strong>rodzaj kuponu</strong> (rodzaj rabatu), trzecia <strong>wartość kuponu</strong>, a ostatnia<strong> ilość dostępnych kuponów</strong>. Wg tego przykładu należy w formularzu zaznaczyć pola: kod kuponu, rodzaj kuponu, zniżka oraz ilość dostępnych kuponów. W polu kod kuponu należy wpisać - kolejność 1, w polu rodzaj kuponu - kolejność 2, w polu zniżka - kolumna 3, a w polu ilość dostępnych kuponów - kolejność 4.<br />\r\n<br />\r\nPrzy takim rozpisaniu kolumn i zaznaczeniu poszczególnych opcji sklep będzie wiedział w jakich kolumnach znajdują się jakie dane. Dzięki temu będzie wiedział gdzie ma zapisać importowane dane.<br />\r\n<br />\r\nW importowanym pliku jeżeli będzie importowana większa ilość kuponów - każdy kupon musi być jako osobna linia. Każdy nowo dodawany kupon musi posiadać kod kuponu - wiersze bez kodu kuponu nie zostaną dodane. Jeżeli w bazie będzie istniał kupon o importowanym numerze - import danego kuponu nie zostanie wykonany. Jeżeli nie będzie podany rodzaj kuponu sklep przyjmie domyślnie, że rabat kuponu jest kwotowy, a nie procentowy. Jeżeli nie będzie podana ilość dostępnych kuponów system wstawi domyślne 1. Jako data dodania zostanie wstawiona data importu kuponów. Jeżeli jest dodawany typ ograniczenia użycia kuponu (kategorie, producenci lub produkty) muszą być podane również id (kategorii, producentów lub produktów) dla ograniczenia. Podane id muszą odpowiadać konkretnym id w sklepie, czyli jeżeli np będą podawane id produktów muszą się one pokrywać z id produktów w sklepie których mają dotyczyć.</div>\r\n"),
("62","321","0","instrukcja","Reklamacje","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_sklep.jpg\" style=\"width:196px;height:100px;float:right;margin-left:15px;margin-bottom:15px;\" />Moduł umożliwia klientom którzy złożyli w sklepie zamówienia - złożenie reklamacji na zakupione produkty. Klienci którzy mają założone konto w sklepie mogą z poziomu swojego konta złożyć reklamację dotyczącą zamówienia. Opcja składania reklamacji jest widoczna w panelu klienta tylko jeżeli klient złożył w sklepie chociaż jedno zamówienie. Dodatkowo może być włączony box <strong>reklamacje</strong>, który będzie wyświetlał się po zalogowaniu klienta do sklepu. Box zawiera linki do napisania nowego zgłoszenia oraz przeglądania istniejących zgłoszeń.<br />\r\n<br />\r\nReklamacje z poziomu sklepu mogą napisać wyłącznie klienci, którzy są zarejestrowani w sklepie i podczas składania zamówienia założyli lub posiadali konto w sklepie. Reklamacji z poziomu sklepu nie może napisać osoba, która kupowała produkty bez zakładania konta. Taka osoba może złożyć reklamację wysyłając do właściciela maila - lub w dowolny inny sposób. Reklamacje z poziomu sklepu w tym przypadku są przywilejem dla osób, które złożyły konto w sklepie. Wynika to z faktu, że klient który nie zakłada konta, nie może się zalogować do sklepu. Przez to nie ma obsługi panelu klienta w którym zapisane są zamówienia klienta oraz możliwości składania reklamacji.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_listing.jpg\" style=\"width:650px;height:175px;float:right;margin-left:15px;margin-bottom:15px;\" />Moduł reklamacji po stronie panelu zarządzania sklepu wyświetla w oknie wszystkie zgłoszone reklamacje. Domyślnie zgłoszenia są posortowane wg daty zgłoszenia reklamacji. Powyżej okna z reklamacjami znajdują się opcje filtrowania. Poszczególne opcje umożliwiają wyświetlenie tylko tych zgłoszeń które spełniają określone parametry lub wyszukanie określonego zgłoszenia. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu.<br />\r\n<br />\r\nPoniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania reklamacji w listingu. Poniżej znajduje się przycisk <strong>dodania nowej reklamacji</strong>. Opcja ta jest użyteczna jeżeli klient zgłasza reklamację nie przez stronę sklepu. Dotyczy to np klientów, którzy nie założyli w sklepie konta i po dokonaniu zakupu nie mają możliwości zgłoszenia reklamacji z poziomu sklepu.<br />\r\n<br />\r\nW liście reklamacji każda reklamacja jest wyświetlana&nbsp;w osobnym wierszu. Pierwsza kolumna wyświetla nr id reklamacji - ten numer służy wyłącznie do obsługi po stronie panelu zarządzania i nie jest podawany klientowi. Nr zgłoszenia, który jest wyświetlany w drugiej kolumnie jest numerem, który otrzymuje klient po zgłoszeniu reklamacji i tym kodem powinien się posługiwać w kontaktach z obsługą sklepu. Kolejna kolumna zawiera dane klienta, który złożył reklamację. W kolejnej kolumnie wyświetlany jest tytuł zgłoszenia - czego dotyczy reklamacja. Następna kolumna wyświetla datę zgłoszenia reklamacji. Kolejna kolumna zawiera nr id zamówienia jakiego dotyczy reklamacja. W następnej kolumnie wyświetlany jest aktualny status zgłoszenia. Nowo napisana reklamacja przyjmuje domyślny status (definiowany w menu <strong>Sprzedaż / Reklamacje / Statusy reklamacji</strong>). W trakcie obsługi reklamacji przez administratora sklepu - statusy reklamacji zmieniają się. Przedostatnia kolumna wyświetla nazwę opiekuna reklamacji - osobę odpowiedzialną w sklepie za obsługę danej reklamacji. Każda reklamacja może mieć przypisanego innego opiekuna, dzięki temu w przypadku wielu reklamacji i osób obsługujących reklamacje po stronie sklepu - można łatwo wyszukiwać tylko reklamacje danego opiekuna. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję reklamacji, jej usunięcie lub wygenerowanie dokumentu PDF z reklamacją.</div>\r\n"),
("63","322","1","instrukcja","Edycja - zakładka Podstawowe dane","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_edycja.jpg\" style=\"width: 600px; height: 252px; float: right; margin-left: 15px; margin-bottom: 15px;\" />W tej zakładce wyświetlane są wszystkie dane dotyczące szczegółów reklamacji.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><strong>W pierwszej części tej zakładki</strong> prezentowane są informacje o dacie zgłoszenia reklamacji, tytule reklamacji, dacie ostatniej modyfikacji (wysłania ostatniej wiadomości do klienta), dane klienta zgłaszającego reklamację, nr zamówienia jakiego dotyczy reklamacja oraz dane opiekuna reklamacji (osoby odpowiedzialnej w sklepie za obsługę tej właśnie reklamacji - opiekunami reklamacji mogą być osoby - administratorzy - dodane w panelu zarządzania do grupy Obsługa sprzedaży w menu <strong>Narzędzia / Grupy użytkowników</strong>). Z tego poziomu można także wygenerować dokument reklamacji w formacie PDF.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_edycja_dane.jpg\" style=\"width: 400px; height: 134px; float: left; margin: 15px;\" />W prawym górnym narożniku okna znajduje się przycisk <strong>edycji</strong>. Umożliwia on zmianę danych reklamacji. Po kliknięciu na przycisk edycji zostanie wyświetlony formularz z możliwością edycji danych reklamacji.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Podczas edycji można zmienić tytuł reklamacji. Można także zmienić dane klienta. Można wybrać czy klient zgłaszający reklamację jest klientem sklepu (wtedy wybiera się klienta z listy klientów sklepu) lub klient nie jest zapisany w bazie sklepu (np klient który kupił bez zakładania konta). Wtedy można ręcznie wpisać dane klienta. Dalej można zmienić nr zamówienia jakiego dotyczy reklamacja oraz przypisać opiekuna reklamacji.</div>\r\n"),
("64","323","1","instrukcja","Edycja - zakładka Historia reklamacji","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_historia.jpg\" style=\"width: 620px; height: 288px; float: right; margin-left: 15px; margin-bottom: 15px;\" />W tej zakładce wyświetlane są informacje dotyczące historii reklamacji - historia statusów reklamacji oraz treść poszczególnych wiadomości.<br />\r\n<br />\r\nW ramce na górze strony znajduje się lista / historia poszczególnych statusów reklamacji wg daty dodania. Zawiera ona informację o dacie dodania / zmiany statusu, informację czy mail był wysłany do klienta (zielona ikona oznacza, że mail z wiadomością był wysłany, szara - nie był wysyłany). Kolejna kolumna wyświetla status jaki był nadany w danej operacji oraz treść komentarza. Jeżeli zostanie zmieniony status reklamacji lub wysłana do klienta wiadomość w historii reklamacji doda się kolejna pozycja.<br />\r\n<br />\r\nPoniżej listy historii znajduje się formularz dodawania / zmiany statusu reklamacji. W formularzu można wybrać nowy status reklamacji oraz wpisać komentarz do zmienianego statusu. Można także zaznaczyć czy klient ma być poinformowany o zmianie statusu oraz czy treść komentarza ma być dołączona do maila.<br />\r\n<br />\r\nPrzy zmianie statusu reklamacji można skorzystać z opcji standardowych komentarzy. Do konkretnych statusów reklamacji można przypisać standardowe treści komentarzy (w liście statusów reklamacji w menu <strong>Sprzedaż / Reklamacje / Statusy reklamacji</strong>). Dzięki temu jeżeli dany status będzie miał przypisane standardowe teksty to po wybraniu określonego statusu - w pozycji standardowe komentarze wyświetli się lista pozycji - po wybraniu danego komentarza treść zostanie automatycznie wstawiona w pole edytora. Takie rozwiązanie pozwala na szybszą obsługę komentarzy - nie trzeba wpisywać od nowa tekstów w edytorze, jeżeli teksty są standardowe do każdej reklamacji.<br />\r\n<br />\r\n<strong>Po wybraniu nowego statusu</strong> reklamacji <strong>wyświetli się</strong> pod edytorem tekstu - przycisk Zapisz dane. Wciśnięcie przycisku spowoduje zapisanie nowej pozycji i jeżeli była zaznaczona opcja - wysłanie do klienta wiadomości e-mail.</div>\r\n"),
("65","325","0","instrukcja","Dodawanie ręczne reklamacji","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/reklamacja_dodawanie_ikona.jpg\" style=\"width:306px;height:99px;float:right;margin-left:15px;margin-bottom:15px;\" />Podstawowym sposobem dodawania reklamacji jest ich zgłaszanie przez klientów z poziomu sklepu. Klienci po zalogowaniu się na swoje konto mogą napisać reklamację do złożonego zamówienia z poziomu panelu konta klienta. Podczas zgłaszania reklamacji klient musi wybrać numer zamówienia jakiego dotyczy zgłoszenie reklamacji, wpisać tytuł reklamacji oraz opis reklamacji. Po zapisaniu danych reklamacja jest automatycznie dodawana do systemu reklamacji w sklepie. Jednak co w przypadku jeżeli reklamację zgłasza klient, który nie jest zarejestrowany w sklepie ? W tym przypadku można dodać ręcznie nową reklamację z poziomu panelu zarządzania sklepu. W menu <strong>Sprzedaż / Reklamacje / Zarządzanie reklamacjami</strong> - nad listą złożonych reklamacji wyświetlany jest przycisk <strong>dodawania nowej reklamacji</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/reklamacja_dodawanie.jpg\" style=\"width: 550px; height: 441px; float: left; margin-right: 15px; margin-bottom: 15px;\" />Po kliknięciu w link otworzy się formularz dodawania nowej reklamacji.<br />\r\n<br />\r\nPierwsza pozycja do nr zgłoszenia reklamacji - jest on generowany automatycznie i jest unikalny. W kolejnych polach należy wpisać tytuł reklamacji, wybrać klienta którego dotyczy reklamacja - klient może być zarejestrowany w sklepie (zapisany w bazie sklepu) - wtedy można wybrać klienta z rozwijanej listy lub reklamacja może dotyczyć dla klienta, który nie jest klientem sklepu. Wtedy należy zaznaczyć opcję rodzaj klienta - z poza bazy sklepu - wyświetlą się pola do ręcznego wpisania danych klienta. Kolejna pozycja to nr zamówienia jakiego dotyczy reklamacja oraz przypisanie opiekuna do reklamacji. Należy także wybrać jaki status będzie miała nowo dodawana reklamacja oraz wpisać jej opis.<br />\r\n<br />\r\nDalsza obsługa dodanej w ten sposób reklamacji odbywa się identycznie jak reklamacji standardowej dodanej bezpośrednio przez klienta w sklepie.</div>\r\n"),
("66","327","0","instrukcja","Statusy reklamacji i standardowe komentarze do statusów","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_statusy.jpg\" style=\"width:650px;height:122px;float:right;margin-left:15px;margin-bottom:15px;\" />Podczas zarządzania reklamacjami jedną z opcji jest zmiana statusu reklamacji - tzn na jakim etapie w procesie reklamacyjnym dana reklamacja się znajduje.  W menu <strong>Sprzedaż / Reklamacje / Statusy reklamacji</strong> - administrator sklepu może zarządzać statusami reklamacji - definiować jakie statusy będzie można stosować podczas obsługi reklamacji.<br />\r\n	<br />\r\n	Standardowo w sklepie są zdefiniowane najczęściej stosowane statusy reklamacji. Administrator sklepu może dodać własne - nowe statusy - lub zmodyfikować już istniejące. Listing statusów reklamacji wyświetla wszystkie zdefiniowane statusy reklamacji. Pierwsza kolumna listingu wyświetla id danego statusu w bazie, druga kolumna to nazwa statusu. W kolejnej kolumnie wyświetlany jest kolor - w poszczególnych statusach można definiować kolory w jakich będą się wyświetlać (tylko w panelu zarządzania) - dzięki temu podczas przeglądania historii reklamacji - dane są bardziej czytelne i łatwo można rozróżnić poszczególne statusy. Kolejna kolumna wyświetla typ statusu. Jest to pole informacyjne obrazujące stan zaawansowania reklamacji. Są cztery typy: nowe, w realizacji, zamknięte (zrealizowane), zamknięte (niezrealizowane). Każdy typ może być przypisany do kliku statusów. W kolejnej kolumnie zaznaczony jest zieloną ikoną domyślny status - taki status otrzymuje domyślnie reklamacja złożona przez klienta. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję statusu, usunięcie lub przejście do listy komentarzy standardowych przypisanych do danego statusu. Statusu nie można usunąć jeżeli był użyty w reklamacjach klientów. Usunąć można tylko statusy, które nie były nigdzie wykorzystane.<br />\r\n	<br />\r\n	Dodawanie i edycja statusu to prosty formularz, który wyświetla pola do wypełnienia. Pierwsze pole to nazwa statusu (nazwa jaka będzie widoczna dla klienta). Nazwę należy wprowadzić we wszystkich językach jakie są włączone w sklepie - przełączenie na inną wersję językową następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa statusu w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka. Następnie należy wybrać typ statusu, kolor (po kliknięciu w pole koloru wyświetli się tablica kolorów) oraz zaznaczyć czy dodawany bądź edytowany status ma być domyślnym.<br />\r\n	<br />\r\n	Opcja usuwania statusów jest nieaktywna w przypadku statusu domyślnego. Aby usunąć status ustawiony jako domyślny trzeba najpierw ustawić inny status jako domyślny - po tym będzie można usunąć dany status.<br />\r\n	W listingu statusów - w ikonach nawigacyjnych znajduje się ikona standardowych komentarzy <img alt=\"alt\" src=\"obrazki/pomoc/standardowe_komentarze.jpg\" style=\"width:20px;height:22px;\" />. Po kliknięciu w ikonę otworzy się kolejna podstrona z listą zdefiniowanych standardowych komentarzy do danego statusu.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_standardowe_komentarze.jpg\" style=\"width:500px;height:97px;float:left;margin-bottom:15px;margin-right:15px;\" /><strong>Komentarze standardowe</strong> są używane podczas edycji lub dodawania nowej reklamacji. Są one widoczne po wybraniu z listy statusu reklamacji - pod statusem wyświetli się lista przypisanych do tego statusu standardowych komentarzy. <img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_edycja_komentarze.jpg\" style=\"width:250px;height:59px;float:right;margin:10px;margin-right:0px\" />Po wyborze z listy komentarza - jego treść wstawi się automatycznie w pole edytora tekstu. Takie rozwiązanie ułatwia pracę administratora sklepu, gdyż za każdym razem nie musi on wpisywać tekstu do edytora, a może przygotować standardowe - najczęściej używane teksty dla poszczególnych statusów reklamacji.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_standardowe_komentarze_edycja.jpg\" style=\"width:250px;height:255px;margin-left:15px;margin-bottom:15px;float:right;\" />Sam moduł standardowych komentarzy umożliwia dodawanie nowych treści, edycję istniejących oraz usunięcie niepotrzebnych komentarzy. Podczas edycji lub dodawania nowej pozycji w standardowych komentarzach do reklamacji należy w edytorze wpisać tekst, który będzie wstawiany po wybraniu danego komentarza, wpisać nazwę komentarza (będzie widoczna w formie rozwijanej listy pod statusem podczas edycji reklamacji) oraz wpisać kolejność wyświetlania (kolejność wyświetlania w rozwijanej liście).<br />\r\n	<br />\r\n	Nie ma ograniczenia ilości dodawanych komentarzy do zamówień. Statusy zamówień nie muszą mieć także przypisanych żadnych standardowych komentarzy - ta forma stanowi tylko ułatwienie obsługi reklamacji.</div>\r\n"),
("67","204","1","instrukcja","Edycja - zakładka Produkty","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka3.jpg\" style=\"width: 650px; height: 205px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Po przejściu do zakładki Produkty w edycji zamówienia wyświetlana jest lista produktów, które składają się na to zamówienie. W każdym wierszu listy opisane są dokładne informacje na temat zakupionego towaru.<br />\r\n<br />\r\nW pierwszej kolumnie znajduje się id produktu. Następnie zdjęcie. W trzeciej kolumnie zawarte są szczegółowe informacje takie jak: nazwa produktu, numer katalogowy oraz producent. Jeżeli zamówiony produkt posiada dodatkowe cechy, to są one również wypisane w tym miejscu - czyli dokładna konfiguracja jaką klient zamówił.<br />\r\n<br />\r\nNastępna kolumna zawiera pole rabatu produktu. Jeżeli klient kupił produkt z rabatem to w polu będzie wpisany rabat jaki klient otrzymał na dany produkt. Dodatkowo można zmienić wartość rabatu danego produktu wpisując pole nową wartość rabatu. Po wpisaniu nowej wartości rabatu sklep przeliczy na nowo cenę produktu dla tego zamówienia.<br />\r\n<br />\r\nKolejne kolumny to cena produktu netto, stawka podatku VAT, cena brutto, ilość produktów z danego asortymentu i wartość zamówionych produktów z danego asortymentu. W ostatniej kolumnie znajdują się ikony nawigacyjne.<br />\r\n<br />\r\nPoniżej listy produktów danego zamówienia wyświetlana jest informacja o wartości produktów w danym zamówieniu w rozbiciu na wartość brutto oraz netto.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"333\" src=\"obrazki/pomoc/zamowienie_zakladka3_edycja.jpg\" style=\"margin-right:15px;margin-bottom:15px;float:left;\" width=\"459\" />Przy użyciu ikon nawigacyjnych przy produktach w listingu obsługa sklepu może usunąć dany produkt z zamówienia lub dokonać jego modyfikacji.&nbsp; Po kliknięciu w ikonę edycji produktu, wyświetlany jest formularz umożliwiający wprowadzenie następujących modyfikacji. przedstawionych na screenie. Można zmienić nazwę produktu, jego ilość w zamówieniu oraz cenę. W przypadku, gdy produkt posiada dodatkowe cechy można również je zmienić - zarówno treść jak i cenę. Wszystkie zamiany wprowadzane w tym miejscu dotyczą tylko i wyłącznie produktu znajdującego się w tym zamówieniu. Nie mają żadnego wpływu na towar, który znajduje się w bazie w sklepie.\r\n<div style=\"clear:both\">Poza edycją produktów, które już znajdują się w zamówieniu obsługa sklepu ma możliwość dodania kolejnych (np. jeśli klient już po złożeniu zamówienia zadzwonił że chce jeszcze jakiś produkt). Kliknięcie w link <strong>dodaj nową pozycję</strong> otwiera formularz dodania nowego produktu do zamówienia. W pierwszej kolejności należy wybrać kategorię w której znajduje się dodawany produkt lub wyszukać produkt poprzez wyszukiwarkę.</div>\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka3_dodanie.jpg\" style=\"margin-right: 15px; margin-bottom: 15px; float: left; width: 535px; height: 206px;\" />Następnie zostaną wyświetlone produkty. Kliknięcie opcji <strong>Wybór</strong> otwiera formularz analogiczny jak podczas edycji produktów już znajdujących się w zamówieniu. Program wstawia automatycznie ceny takie jakie obowiązują w sklepie na dany produkt. Obsługa sklepu ma możliwość ręcznego skorygowania wszystkich parametrów dodawanego produktu.<br />\r\n<br />\r\nPo zapisaniu produktu, program powraca do zakładki z listą produktów w edytowanym zamówieniu. W tym czasie automatycznie jest przeliczana i aktualizowana całkowita wartość zamówienia.<br />\r\n<br />\r\nPodczas dodawania nowego produktu do zamówienia istnieje możliwość dodania produktu z poza bazy sklepu. Pod listą kategorii produktów znajduje się przycisk do dodania do zamówienia produktu z poza bazy: <strong>dodaj produkt z poza bazy sklepu</strong>. Po wciśnięciu tego przycisku zostanie wyświetlony pusty formularz identyczny jak w przypadku standardowych produktów, gdzie należy wprowadzić nazwę produktu, cenę, ilość. Dodany w ten sposób produkt będzie widoczny tylko w danym zamówieniu i nie będzie powiązany z bazą produktową sklepu. W liście produktów zamówienia dla takiego produktu nie będzie wyświetlany nr ID oraz zdjęcie produktu.</div>\r\n"),
("68","205","1","instrukcja","Edycja - zakładka Historia zamówienia","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka4.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 613px; height: 114px;\" />W tej zakładce wyświetlane są informacje dotyczące historii zamówienia - historia statusów zamówienia oraz treść poszczególnych wiadomości.<br />\r\n<br />\r\nW ramce na górze strony znajduje się lista/historia poszczególnych statusów zamówienia wg daty dodania. Zawiera ona informację o dacie dodania / zmiany statusu, informację czy mail był wysłany do klienta (zielona ikona oznacza, że mail z wiadomością był wysłany, szara - nie był wysyłany). Jeżeli w sklepie jest włączona opcja powiadomień SMS jest również wyświetlana informacja czy zostało takie powiadomienie do klienta wysłane. Kolejna kolumna wyświetla status jaki był nadany w danej operacji oraz treść komentarza. Jeżeli zostanie zmieniony status zamówienia lub wysłana do klienta wiadomość w historii zamówienia doda się kolejna pozycja. W ostatniej kolumnie istnieje możliwość usunięcia statusu zamówienia.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zakladka4_powiadomienie.jpg\" style=\"margin-right: 15px; margin-bottom: 15px; float: left; width: 560px; height: 583px;\" />Poniżej listy historii znajduje się formularz dodawania / zmiany statusu zamówienia. W formularzu można wybrać nowy status zamówienia oraz wpisać komentarz do zmienianego statusu. Można także zaznaczyć czy klient ma być poinformowany o zmianie statusu oraz czy treść komentarza ma być dołączona do maila. Można także dodać załącznik, które zostaną dodane do wysyłanego maila. Informacja o wysłanych załącznikach zostanie automatycznie dodana w treści historii zamówienia.<br />\r\n<br />\r\nPrzy zmianie statusu zamówienia można skorzystać z opcji standardowych komentarzy. Do konkretnych statusów zamówień można przypisać standardowe treści komentarzy (w liście statusów zamówień w menu <strong>Sprzedaż / Zamówienia / Statusy reklamacji</strong>). Dzięki temu jeżeli dany status będzie miał przypisane standardowe teksty to po wybraniu określonego statusu - w pozycji standardowe komentarze wyświetli się lista pozycji - po wybraniu danego komentarza treść zostanie automatycznie wstawiona w pole edytora. Takie rozwiązanie pozwala na szybszą obsługę komentarzy - nie trzeba wpisywać od nowa tekstów w edytorze, jeżeli teksty są standardowe do każdego zamówienia.<br />\r\n<br />\r\nPo wybraniu nowego statusu zamówienia wyświetli się pod edytorem tekstu przycisk <strong>Zapisz dane</strong>. Wciśnięcie przycisku spowoduje zapisanie nowej pozycji i jeżeli była zaznaczona opcja - wysłanie do klienta wiadomości e-mail i SMS jeżeli był zaznaczony. Treść wysyłanej wiadomości o zmianie statusu zamówienia (nie samego komentarza do zamówienia) można modyfikować w menu <strong>Konfiguracja / Słowniki / Treści wiadomości e-mail / Zmiana statusu zamówienia</strong>.\r\n<div style=\"clear:both\"><img alt=\"alt\" src=\"obrazki/pomoc/zamowienie_zmiana_punktow.jpg\" style=\"width: 480px; height: 71px; margin-left: 15px; margin-top:15px;margin-bottom: 15px; float: right;\" /><br />\r\nJeżeli w sklepie jest włączona obsługa punktów za zakupy i w danym zamówieniu klientowi przysługują za zamówione produkty punkty do naliczenia, to w trakcie zmiany statusu zamówienia obsługa sklepu ma od razu możliwość ich zatwierdzenia.&nbsp; Po zatwierdzeniu punktów pozycja ta znika z formularza i przy kolejnych zamianach statusów zamówienia jest już niedostępna. Od tej chwili również nie występuje już ta pozycja na liście punktów do zatwierdzenia w menu <strong>Sprzedaż / Klienci / Punkty do zatwierdzenia</strong>. Dodatkowo jeżeli w sklepie jest aktywny Program partnerski i w danym zamówieniu zostały naliczone punkty Programu partnerskiego - podczas zmiany statusu zamówienia można także zatwierdzić punkty Programu partnerskiego.</div>\r\n</div>\r\n"),
("69","371","0","instrukcja","Newsletter ","<div style=\"text-align:justify;\">Newsletter - inaczej nazwany biuletynem - to forma elektroniczna reklamy / biuletynu - rozsyłanego za pomocą poczty elektronicznej do subskrybentów lub innych osób z bazy mailingowej. Newsletter został stworzony dla firm które poprzez e-mail chcą dotrzeć ze swoją ofertą produktową do potencjalnych klientów. Moduł newslettera umożliwia wysyłanie nieograniczonej ilości wiadomości e-mail. Wiadomość może mieć dowolny wygląd i może być wykonana w formacie html. Poprawnie przeprowadzona akcja e-marketingu może bardzo skutecznie zwiększyć obroty w firmie.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/newsletter.jpg\" style=\"width: 650px; height: 160px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Moduł newslettera w sklepie jest prosty w obsłudze - ale jednocześnie pozwala na bardzo dużą konfigurację wysyłanych wiadomości. Po stronie panelu zarządzania sklepu obsługa newslettera (tworzenia i wysyłania wiadomości) odbywa się poprzez menu <strong>Sprzedaż / Newsletter / Newsletter</strong>. Moduł newslettera wyświetla w oknie wszystkie stworzone przez administratora sklepu biuletyny. W liście newsletterów - kolejne pozycje są domyślnie posortowane wg nazwy. Powyżej okna z biuletynami znajdują się opcje filtrowania. Umożliwiają one wyszukanie wybranego newslettera lub wyświetlenie newsletterów przypisanych do określonych grup odbiorców. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu.<br />\r\n<br />\r\nPoniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania biuletynów w listingu. Poniżej znajdują się przyciski <strong>dodawania nowego newslettera</strong>.<br />\r\n<br />\r\nW liście każdy newsletter jest wyświetlany&nbsp;w osobnym wierszu. Pierwsza kolumna wyświetla nr id newslettera. W kolejnej kolumnie wyświetlany jest tytuł newslettera. Jest to tytuł jaki będzie miał wysyłany do klientów e-mail. Następna kolumna wyświetla odbiorców newslettera - czyli do jakiej grupy klientów zostanie wysłany dany biuletyn. Kolejna kolumna to data dodania (utworzenia) newslettera. W kolejnej kolumnie wyświetlane są dodatkowe warunki wysłania wiadomości jakie może posiadać newsletter - dodatkowe warunki ograniczające wysłanie wiadomości tylko o odbiorców newslettera spełniających określone parametry. Następna kolumna wyświetla liczbę maili jaka zostanie wysłana przy pomocy danego newslettera - czyli ilość osób jaka otrzyma daną wiadomość. Przedostatnia kolumna wyświetla datę wysłania newslettera - jeżeli był wysłany. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję newslettera, jego usunięcie oraz wysłanie biuletynu do klientów. Pierwsza z ikon umożliwia wysłanie testowego biuletynu - testowy biuletyn jest wysyłany tylko na adres e-mail właściciela sklepu podany w menu <strong>Konfiguracja / Dane teleadresowe / Dane sklepu</strong>. Wysłanie testowego biuletynu daje możliwość sprawdzenia jak będzie wyglądał wysłany mail bezpośrednio u klienta. Wysłanie testowego biuletynu nie powoduje zapisania daty wysłania biuletynu (w liście pole wysłania pozostanie puste - dopóki newsletter nie zostanie wysłany do właściwych odbiorców).<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/newsletter_eksport_freshmail.jpg\" style=\"width: 320px; height: 148px; margin-right: 15px; margin-bottom: 15px; float: left;\" />Dodatkowo w ikonach nawigacyjnych może wyświetlać się ikona wysłania danych subskrybentów do systemu FreshMail. Ikona ta jest dostępna jeżeli w sklepie jest włączona integracja z FreshMail w menu <strong>Integracje / Systemy afiliacyjne</strong>. Po kliknięciu w ikonę zostanie wyświetlone nowa strona, na której trzeba podać nazwę listy mailingowej do jakiej mają zostać wyeksportowane adresy mailowe.<br />\r\n<br />\r\nDzięki tej funkcji można do systemu FreshMail wyeksportować tylko wybrane adresy mailowe, które spełniają określone warunki podane przy tworzeniu newslettera.</div>\r\n"),
("70","372","0","instrukcja","Dodawanie / edycja newslettera","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/newsletter_dodawanie.jpg\" style=\"width: 500px; height: 404px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Nowy newsletter dodaje się poprzez kliknięcie w przycisk <strong>dodaj nowy newsletter</strong>. Po kliknięciu zostanie wyświetlony formularz dodawania nowego biuletynu.<br />\r\n<br />\r\nW pierwszej części formularza należy wybrać jaki szablon e-mail będzie używany do wysyłania wiadomości. Sklep wszystkie wiadomości wysyła w oparciu o przygotowane szablony ogólnego wyglądu maila. Szablony maili można zdefiniować w menu <strong>Konfiguracja / Słowniki / Szablony e-maili</strong>. Od wybrania odpowiedniego szablonu będzie zależało jak będzie wyglądał nagłówek, stopka oraz ogólny wygląd wysyłanej wiadomości. Poniżej znajduje się wybór wersji językowej szablonu - w zależności od wybranej wersji zostanie załadowana odpowiednia wersją językowa wybranego szablonu e-maila.<br />\r\n<br />\r\nPoniżej wyboru szablonu maila oraz wersji językowej znajduje się sekcja wyboru odbiorców newslettera oraz możliwość ustalenia dodatkowych warunków dla odbiorców newslettera. Dodatkowe warunki są różne w zależności od wybranej grupy odbiorców.<br />\r\n<br />\r\nOdbiorcami newslettera mogą być:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Wszyscy zarejestrowani klienci sklepu</strong> - po wybraniu tej opcji biuletyn zostanie wysłany do wszystkich klientów, którzy mają założone w sklepie konto i ich konto jest aktywne (bez względu na to czy wyrazili zgodę na otrzymywanie newslettera czy też nie). Przy wybraniu tej grupy odbiorców można zastosować dodatkowe warunki: data zamówienia od - do - czyli newsletter zostanie wysłany tylko do klientów, którzy mają konto w sklepie oraz złożyli zamówienie w sklepie w zakresie podanych dat, status zamówienia - jak powyżej plus zamówienie musi mieć określony status, wartość zamówienia - jak poprzednio - z tym, że wartość zamówienia musi mieć określoną wartość. Dzięki temu można wysłać maile do klientów, którzy złożyli w sklepie zamówienie w określonym czasie, o określonej wartości i np zamówienie ma status opłaconego.</li>\r\n	<li style=\"text-align:justify;\"><strong>Tylko zarejestrowani klienci sklepu którzy wyrazili zgodę na newsletter</strong> - klient podczas rejestracji ma możliwość zaznaczenia (wybrania opcji) czy zgadza się na otrzymywanie sklepowych biuletynów - ta grupa dotyczy właśnie tych klientów, którzy wyrazili zgodę na otrzymywanie wiadomości. Dodatkowe warunki dotyczące zamówień są identyczne jak w wyżej opisywanej grupie. Dodatkową opcją jest możliwość wybrania grup newslettera do jakich mają być wysłane wiadomości. Administrator sklepu może stworzyć dodatkowe grupy tematyczne newslettera (menu <strong>Sprzedaż / Newsletter / Grupy klientów newslettera</strong>) i do poszczególnych grup przypisać poszczególnych klientów. Np sprzedając odzież można utworzyć dwie grupy: odzież męska i odzież damska. Jeżeli klient wyrazi zgodę na otrzymywanie biuletynu można go przypisać do wybranej grupy tematycznej (przypisanie do grup wykonuje się podczas edycji danych klienta w menu <strong>Sprzedaż / Klienci / Klienci</strong>). Można przypisać np kobiety tylko do odzieży damskiej, a mężczyzn do odzieży męskiej. Tworząc newsletter dotyczący oferty odzieży damskiej - można wybrać tylko odbiorców przypisanych do grupy tematycznej - odzież damska. Nie jest w tym wypadku celowe wysyłanie wiadomości z ofertą odzieży damskiej do mężczyzn - dlatego dzięki grupom można dokonać ograniczenia wysyłania maili do określonej grupy docelowej.</li>\r\n	<li style=\"text-align:justify;\"><strong><img alt=\"alt\" src=\"obrazki/pomoc/newsletter_box.jpg\" style=\"width:150px;height:130px;float:right;margin:10px;border-width:0px;border-style:solid;\" />Tylko klienci którzy zapisali się do newslettera, a nie są klientami sklepu</strong> - dotyczy to osób (niekoniecznie klientów sklepu), którzy zapisali się do newslettera poprzez box newslettera w sklepie. Jeżeli box newslettera jest włączony w sklepie, to do newslettera może zapisać się każda osoba - wystarczy tylko podać adres e-mail. W ten sposób można zbudować bazę mailingową klientów, którzy w przyszłości mogą dokonać zakupów w sklepie jeżeli zaciekawi ich oferta z wysyłanych biuletynów. Często spotykanym sposobem zachęcenia klientów do zapisania się do newslettera jest oferowanie w zamian za zapisanie się - otrzymanie np kuponu rabatowego o określonej wartości. Dodatkowe warunki jakie można zastosować przy tej grupie klientów to data aktywacji konta. W zależności od ustawień aktywacji konta newslettera (menu <strong>Sprzedaż / Newsletter / Konfiguracja newslettera</strong>) - konto może być aktywne zaraz po zapisaniu się do newslettera. Data aktywacji jest w tym przypadku taka jak data zapisania się do newslettera. Druga możliwość to wysłanie przez sklep na e-mail klienta, który zapisał się do newslettera wiadomości z linkiem aktywacyjnym, którym musi potwierdzić zapisanie się do newslettera - data aktywacji równa się wtedy dacie kliknięcia przez klienta w link i potwierdzeniu aktywacji. Stosując dodatkowy warunek daty aktywacji można np wysyłać do klientów, którzy zapisali się do newslettera w określonym czasie - wiadomości z kuponami rabatowymi w ramach promocji za zapisanie się do newslettera.</li>\r\n	<li style=\"text-align:justify;\"><strong>Do wszystkich którzy zapisali się do newslettera</strong> - po wybraniu tej opcji biuletyn zostanie wysłany do wszystkich klientów, którzy zapisali się do newslettera - zarówno podczas rejestracji konta w sklepie jak i poprzez box newslettera na stronie głównej. Ta grupa nie posiada dodatkowych warunków filtrowania.</li>\r\n	<li style=\"text-align:justify;\"><strong>Mailing</strong> - jest to grupa osób / klientów pozyskana z innych źródeł niż sklep - np zakupiona baza adresów e-maili. Maile do tej grupy - administrator sklepu dodaje z poziomu panelu zarządzania w menu <strong>Sprzedaż / Newsletter / Newsletter - mailing</strong>. Ta grupa nie posiada dodatkowych warunków filtrowania.</li>\r\n	<li style=\"text-align:justify;\"><strong>Tylko do określonej grupy klientów</strong> - moduł jest zbliżony do grupy <strong>wszyscy zarejestrowani klienci sklepu</strong> - dotyczy on klientów zarejestrowanych w sklepie i ma takie same dodatkowe warunki jak w/w grupa. Jedyna różnica jest taka, że można dodatkowo wybrać grupę klientów do jakiej będzie wysłany newsletter (nie jest to grupa tematyczna newslettera, a grupa klientów definiowana w menu <strong>Sprzedaż / Klienci / Grupy klientów</strong>). Przy pomocy tej opcji można wysłać newsletter tylko do określonej grupy klientów np hurtowników i w mailu zawrzeć informacje dotyczące oferty tylko dla tej grupy klientów - np specjalne promocje.</li>\r\n	<li style=\"text-align:justify;\"><strong>Tylko klienci z porzuconymi koszykami</strong> - dotyczy on klientów zarejestrowanych w sklepie, którzy dodali produkt / produkty do koszyka i nie złożyli zamówienia. Dane produktów jakie klient dodał do koszyka zostają zapisane na jego koncie. Podglądu koszyka można dokonać w menu <strong>Sprzedaż / Klienci</strong> podczas edycji konta klienta. Wykorzystując tą opcję można wysłać do takich klientów newsletter zachęcający do złożenia zamówienia w sklepie. Opcja zwraca wszystkie adresy email klientów, którzy mają dodane produkty do koszyka, niezależnie czy zapisali się do otrzymywania newslettera czy nie.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Ostatnia część formularza newslettera to tytuł oraz opis. Tytuł to tekst, który będzie przesyłany jako tytuł maila. Mail który zostanie przesłany do klientów będzie miał taki tytuł - należy zadbać, żeby był w miarę krótki ale i ciekawy. Pole tytuł jest obowiązkowe. Ostatnim polem w formularzu jest pole treści newslettera. Treść można zredagować przy pomocy edytora tekstu. Może ona zawierać tekst, grafikę, odnośniki. Zalecane jest aby szerokość przygotowywanego biuletynu w pikselach nie była szersza niż 600-700px. Szersze wiadomości mogą źle wyglądać po przesłaniu do klientów (cała wiadomość może nie być widoczna w programie pocztowym klienta i będzie wyświetlał się dodatkowo pasek poziomy przesuwania treści). <img alt=\"alt\" src=\"obrazki/pomoc/newsletter_znaczniki.jpg\" style=\"width:300px;height:113px;margin:15px;float:right;\" />Ważnym elementem przy tworzeniu newslettera jest możliwość używania w treści wiadomości <strong>znaczników</strong>. Znaczniki to ciągi znaków, które podczas wysyłania newslettera są zamieniane na odpowiednie wartości (inne teksty). Dla przykładu jeżeli w treści tekstu wpiszemy znacznik {ADRES_URL_SKLEPU} to podczas wysyłania maila zostanie ten ciąg znaków zamieniony na adres internetowy naszego sklepu. Po edytorem tekstu znajdują się wszystkie znaczniki jakie można użyć w tworzonej wiadomości - łącznie z opisem co poszczególne oznaczają.<br />\r\n<br />\r\nWażnym znacznikiem jest {LINK .... } - tworzy on w wiadomości link służący do wypisania się danego klienta z newslettera. Jeżeli newsletter jest wysyłany do grupy klientów którzy świadomie zapisali się do newslettera (przy rejestracji lub w boxie newslettera) - treść newslettera powinna zawierać link do wypisania się z otrzymywania kolejnych wiadomości.<br />\r\n<br />\r\nPo wypełnieniu wymaganych pól w formularzu oraz stworzeniu treści wiadomości - należy zapisać nowy newsletter poprzez kliknięcie w przycisk Zapisz dane. Po tym nowy newsletter zostanie zapisany w bazie sklepu i będzie można wysłać biuletyn do klientów.<br />\r\n<br />\r\nPodczas edycji istniejącego newslettera - pola do edycji są identyczne jak w przypadku dodawania nowego newslettera. Można dowolnie zmienić treść wiadomości, odbiorców newslettera oraz dodatkowe warunki.</div>\r\n"),
("71","373","0","instrukcja","Wysyłanie newslettera","<div style=\"text-align:justify;\">\r\n	Wysyłanie newslettera jest możliwe z poziomu listingu wszystkich newsletterów (menu <strong>Sprzedaż / Newsletter / Newsletter</strong>). Aby wysłać przygotowany newsletter należy kliknąć w liście na ikonę koperty <img alt=\"alt\" src=\"obrazki/pomoc/newsletter_koperty.jpg\" style=\"width:35px;height:15px;\" />. Pierwszy link (ikonka ze strzałką) umożliwia wysłanie testowej wiadomości na adres właściciela sklepu. Testowy biuletyn jest wysyłany tylko na adres e-mail właściciela sklepu podany w menu <strong>Konfiguracja / Komunikacja / Ustawienia e-mail</strong>. Wysłanie testowego biuletynu daje możliwość sprawdzenia jak będzie wyglądał wysłany mail bezpośrednio u klienta. Wysłanie testowego biuletynu nie powoduje zapisania daty wysłania biuletynu (w liście pole wysłania pozostanie puste - dopóki newsletter nie zostanie wysłany do właściwych odbiorców). Kolejna ikona umożliwia wysłanie newslettera do odbiorców danego newslettera. <img alt=\"alt\" src=\"obrazki/pomoc/newsletter_wysylanie.jpg\" style=\"width:300px;height:77px;margin:10px;margin-right:0px;float:right;\" />Po kliknięciu w ikonę wysyłania zostanie wyświetlone okno ze szczegółami wysyłanej wiadomości. Wyświetlany jest tytuł newslettera, odbiorcy newslettera - do jakiej grupy klientów zostanie wysłana wiadomość oraz informacja ile maili zostanie wysłanych. Po kliknięciu w przycisk <strong>Wyślij newsletter</strong> rozwinie się dalsza część okna wysyłania i rozpocznie się proces wysyłania maili. <img alt=\"alt\" src=\"obrazki/pomoc/newsletter_wysylanie_pasek.jpg\" style=\"width:300px;height:99px;float:left;margin:10px;margin-left:0px\" />Czas wysyłania newslettera do klientów jest zależny od ilości maili do wysłania - na ekranie będzie wyświetlany pasek postępu obrazujący ile maili zostało wysłanych, a ile pozostało do wysłania. Po wysłaniu wszystkich wiadomości wyświetli się komunikat informujący, że maile zostały wysłane. Podczas wysyłania maili nie wolno odświeżać ani zamykać okna przeglądarki. Takie operacje spowodują przerwanie procesu wysyłania maili i tylko częściowe wysłanie wiadomości.</div>\r\n"),
("72","374","0","instrukcja","Newsletter subskrybenci","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/newsletter_subskrybenci.jpg\" style=\"width: 650px; height: 118px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Newsletter jest wysyłany do określonej grupy odbiorców. Żeby było łatwiej zarządzać osobami, które zapisały się do newslettera przygotowany jest dodatkowy moduł obsługi kont newslettera. Znajduje się w menu <strong>Sprzedaż / Newsletter / Newsletter subskrybenci</strong>. Moduł wyświetla w oknie wszystkie konta użytkowników newslettera. Powyżej okna z listingiem znajdują się opcje filtrowania. Umożliwiają one wyszukanie wybranego klienta lub wyświetlenie klientów z określonej grupy. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu.<br />\r\n<br />\r\nPoniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania klientów newslettera w listingu. Poniżej znajdują się przyciski <strong>dodawania nowej pozycji</strong>.<br />\r\n<br />\r\nW liście każdy klient newslettera jest wyświetlany&nbsp;w osobnym wierszu. Pierwsza kolumna umożliwia zaznaczenie poszczególnych pozycji i dokonanie na nich określonej operacji, np. usunięcia lub zmiany aktywności konta. Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Druga kolumna wyświetla nr id danego klienta w bazie newslettera. W kolejnej kolumnie wyświetlany jest adres e-mail danego klienta. Jeżeli dany klient jest klientem sklepu (tzn że jest zarejestrowany i zgodę na otrzymywanie newslettera wyraził podczas rejestracji konta) w kolejnej kolumnie będzie widoczne jego imię i nazwisko (dane będą linkiem do konta klienta w menu <strong>Asortyment / Klienci / Klienci</strong>).&nbsp; Następne dwie kolumny wyświetlają datę aktywacji konta oraz datę zapisania do newslettera. Kolejna kolumna wyświetla nr ip z jakiego była dokonana aktywacja. Data aktywacji oraz nr ip są wyświetlane tylko w przypadku klientów zapisanych do newslettera poprzez box. Dane te nie wyświetlają się dla klientów zarejestrowanych w sklepie. Przedostatnia kolumna wyświetla status konta - kolor zielony ikony oznacza, że konto jest aktywne i klient będzie otrzymywał biuletyn,&nbsp; kolor szary oznacza, że konto nie jest aktywne. Klikając na ikonę aktywności przy danym kliencie można zmienić aktywność konta. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję konta oraz jego usunięcie.<br />\r\n<br />\r\nModuł subskrybentów newslettera umożliwia także edycję danych. Podczas edycji można zmienić tylko adres e-mail danego klienta. Także podczas dodawania ręcznie nowego konta podaje się tylko adres e-mail. W przypadku dodawania nowego konta po zapisaniu danych automatycznie jest wstawiana bieżąca data jak data aktywacji.<br />\r\n<br />\r\nZ poziomu opisywanego modułu można również wyeksportować adresy e-mail. Po kliknięciu w<strong> eksportuj dane do pliku</strong> zostanie wygenerowany plik txt, który można pobrać i zapisać na dysku. W pliku każdy adres e-mail będzie zapisany w osobnym wierszu. Możliwe są dwie wersje eksportu - tylko klientów którzy zapisali się do newslettera lub wszystkich klientów (subskrybentów) niezależnie od tego czy są zapisani czy wypisani z newslettera.</div>\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/newsletter_eksport_freshmail.jpg\" style=\"width: 320px; height: 148px; margin-right: 15px; margin-bottom: 15px; float: left;\" />Dodatkowo jeżeli w sklepie jest włączona integracja z FreshMail w menu <strong>Integracje / Systemy afiliacyjne</strong> istnieje możliwość eksportu adresów mailowych do systemu FreshMail. Podobnie jak w przypadku eksportu do pliku tekstowego możliwe są dwie opcje eksportu - tylko klientów którzy zapisali się do newslettera lub wszystkich klientów (subskrybentów) niezależnie od tego czy są zapisani czy wypisani z newslettera.&nbsp; Po kliknięciu w link eksportu do FreshMail zostanie wyświetlone nowa strona, na której trzeba podać nazwę listy mailingowej do jakiej mają zostać wyeksportowane adresy mailowe."),
("73","375","0","instrukcja","Mailing","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/newsletter_mailing.jpg\" style=\"width: 600px; height: 109px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Mailing w odróżnieniu od innych modułów dotyczy nie klientów sklepu oraz osób które zapisały się do newslettera poprzez box. Do modułu mailingu administrator ręcznie importuje dane - adresy e-mail - np pozyskane poprzez zakup bazy mailingowej z innej firmy. Wysyłając ofertę mailingu można zainteresować ofertą sklepu osoby, które nie były dotąd klientami sklepu i nie znają oferty sklepu.<br />\r\n<br />\r\nObsługa danych mailingu jest bardzo prosta. Generalnie każda pozycja w mailingu składa się tylko z adresu e-mail. Nie ma tutaj danych klienta, aktywacji itp. W liście wyświetlana jest tylko możliwość zaznaczenia wybranych pozycji i wykonania określonej akcji (usunięcia pozycji). Zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Druga kolumna w listingu to id danego wpisu w bazie. Kolejna kolumna to adres e-mail na który będzie wysyłany newsletter. Ostatnia kolumna to ikony nawigacyjne, które umożliwiają edycję adresu e-mail lub jego usunięcie z bazy. Moduł zawiera także podobnie jak inne moduły możliwość wyszukania adresu e-mail poprzez wyszukiwarkę oraz ustawienie sortowania adresów. Można także z tego poziomu dodać nowy adres e-mail do bazy mailingowej.<br />\r\n<br />\r\nPrzy tworzeniu nowego newslettera można wybrać grupę odbiorców <strong>mailing</strong> - przy takim wyborze przy wysyłaniu newslettera - będzie on wysyłany do osób dodanych w opisywanym module.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/newsletter_mailing_import.jpg\" style=\"width:380px;height:132px;margin-right:15px;margin-bottom:15px;float:left;\" />Ważnym elementem jest możliwość importu danych. Ponieważ ręczne dodawanie po kolei poszczególnych adresów e-mail byłoby zbyt czasochłonne - można zaimportować plik tekstowy zawierający adresy e-mail. Wystarczy przygotować plik tekstowy, który będzie zawierał adresy e-mail do importu. Każdy adres e-mail musi być zapisany w osobnym wierszu. Dzięki importowi można w krótkim czasie dodać dużą ilość maili. Po kliknięciu w przycisk <strong>Przeglądaj</strong> - otworzy się okno z możliwością wybrania pliku który będzie importowany. Po wybraniu pliku - import danych rozpoczyna się po kliknięciu w przycisk <strong>Importuj dane</strong>.<br />\r\n<br />\r\nOdwrotnością importu jest możliwość eksportu adresów e-mail, którą udostępnia moduł mailingu. Po kliknięciu w<strong> eksportuj dane do pliku</strong> zostanie wygenerowany plik txt, który można pobrać i zapisać na dysku. W pliku każdy adres e-mail będzie zapisany w osobnym wierszu.<br />\r\n&nbsp;</div>\r\n"),
("74","376","0","instrukcja","Grupy klientów newslettera","<div style=\"text-align:justify;\">Dodatkową opcją newslettera jest możliwość tworzenia tematycznych grup newslettera. Grupy takie można tworzyć w menu <strong>Sprzedaż / Newsletter / Grupy klientów newslettera</strong>. Mają one za zadanie podzielić / posegregować dodatkowo klientów sklepu, którzy wyrazili zgodę na otrzymywanie newslettera. Dzięki temu można wysyłać newslettery tylko do określonej grupy docelowej klientów. Np sprzedając odzież można utworzyć dwie grupy: odzież męska i odzież damska. Jeżeli klient wyrazi zgodę na otrzymywanie biuletynu można go przypisać do wybranej grupy tematycznej. Np klientów płci żeńskiej można przypisać tylko do odzieży damskiej, a mężczyzn do odzieży męskiej. Tworząc newsletter dotyczący tylko oferty odzieży damskiej - można wybrać tylko odbiorców przypisanych do grupy tematycznej o nazwie odzież damska. Nie jest w tym wypadku celowe wysyłanie wiadomości z ofertą odzieży damskiej do mężczyzn - dlatego dzięki grupom można dokonać ograniczenia wysyłania maili do określonej grupy docelowej.<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/newsletter_grupy_tematyczne.jpg\" style=\"width: 500px; height: 103px; float: left; margin: 15px 15px 15px 0px;\" /><br />\r\nWyboru do jakich grup tematycznych ma być przypisany konkretny klient dokonuje się w edycji konta klienta w menu <strong>Sprzedaż / Klienci / Klienci</strong>. Wysyłany ze sklepu newsletter będzie wysyłany tylko do klientów którzy mają zaznaczone poszczególne grupy.<br />\r\n&nbsp;\r\n<div style=\"clear:both\">&nbsp;</div>\r\nObsługa modułu grup tematycznych - dodawania / edycji nowych grup jest bardzo prosta. Moduł umożliwia dodanie nowej grupy - gdzie należy podać nazwę dodawanej grupy (będzie wyświetlana podczas edycji danych klienta) oraz opis grupy (żeby można było łatwiej rozróżniać grupy). Podczas edycji pola są identyczne.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/newsletter_dodawanie_grupy_tematyczne.jpg\" style=\"width: 450px; height: 199px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Zdefiniowane grupy są używane przy wysyłaniu newslettera do grupy <strong>tylko zarejestrowani klienci sklepu którzy wyrazili zgodę na newsletter</strong>. Podczas dodawania nowego newslettera i wybraniu tej grupy klientów - w opcji dodatkowe warunki będzie dostępna lista grup tematycznych newslettera - gdzie będzie można zaznaczyć do jakich grup tematycznych newsletter ma być wysłany.</div>\r\n"),
("75","210","0","instrukcja","Książka nadawcza PP","<div style=\"text-align:justify;\">Moduł Książka nadawcza PP umożliwia wygenerowanie w formacie PDF książki nadawczej zgodnej z wymogami Poczty Polskiej. Moduł można również wykorzystywać do tworzenia zestawień wysyłek niekoniecznie dla potrzeb Poczty.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"262\" src=\"obrazki/pomoc/ksiazka_nadawcza.jpg\" style=\"margin-left:15px;margin-bottom:15px;float:right;\" width=\"638\" />Po wybraniu tej pozycji z menu wyświetlany jest formularz, w którym można ustawić parametry według jakich mają zostać wybrane zamówienia do wydruku.<br />\r\n<br />\r\nW pierwszym oknie można wybrać rodzaj wysyłki, a w drugim rodzaj płatności według których mają być wyszukiwane zamówienia. Można wybrać równocześnie kilka metod - klikając myszką na określonej wysyłce bądź płatności pojawia się ona w prawej części okienka.<br />\r\n<br />\r\nDodatkowymi kryteriami wyboru są status zamówienia oraz przedział dat, w którym ten status został ustawiony.<br />\r\n<br />\r\nPo ustawieniu odpowiednich kryteriów wyboru zamówień, które mają zostać wydrukowane klikamy przycisk <strong>Wybierz zamówienia</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/ksiazka_nadawcza_lista.jpg\" style=\"margin-right: 15px; margin-bottom: 15px; float: left; width: 647px; height: 169px;\" />W wyniku tego wygenerowane zostanie zestawienie wszystkich zamówień, które spełniają ustalone kryteria.<br />\r\n<br />\r\nPrzed wygenerowaniem pliku PDF zawierającego książkę nadawczą obsługa sklepu może wprowadzić korekty. W każdej pozycji można zmodyfikować adresata, miejsce doręczenia, deklarowaną wartość przesyłki. Na podstawie zamówienia program automatycznie zaznacza opcję czy jest to wysyłka ekonomiczna czy priorytetowa.<br />\r\n<br />\r\nDodatkowo można zaznaczyć opcję czy wysyłka jest wartościowa i czy jest za pobraniem.<br />\r\n<br />\r\nKażda wygenerowana pozycja ma możliwość usunięcia jej z wydruku. Jeżeli chcemy dodać kolejne pozycje, które nie zostały automatycznie wygenerowane, to wystarczy na dole listy kliknąć link <strong>Dodaj pozycje</strong> - wówczas zostanie dodany kolejny pusty wiersz do zestawienia, w którym można wprowadzić dowolne własne dane.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/ksiazka_nadawcza_drukuj.jpg\" style=\"margin-right: 15px; margin-bottom: 15px; float: left; width: 489px; height: 92px;\" />Jeżeli już całe zestawienie jest gotowe do wydrukowania, należy kliknąć na dole przycisk: Wydrukuj książkę nadawczą. W wyniku tego zostanie wygenerowany dokument w formacie PDF, który można od razu wydrukować lub zapisać na komputerze w celu późniejszego wydrukowania.</div>\r\n"),
("76","220","0","instrukcja","Etykiety adresowe","<div style=\"text-align:justify;\">Moduł Etykiety adresowe umożliwia wygenerowanie w formacie PDF etykiet z adresami do wysyłki dla wybranych zamówień.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"258\" src=\"obrazki/pomoc/etykiety_adresowe.jpg\" style=\"margin-left:15px;margin-bottom:15px;float:right;\" width=\"625\" />Po wybraniu tej pozycji z menu wyświetlany jest formularz, w którym można ustawić parametry według jakich mają zostać wybrane zamówienia do wydruku.<br />\r\n<br />\r\nW pierwszym oknie można wybrać rodzaj wysyłki, a w drugim rodzaj płatności według których mają być wyszukiwane zamówienia. Można wybrać równocześnie kilka metod - klikając myszką na określonej wysyłce bądź płatności pojawia się ona w prawej części okienka.<br />\r\n<br />\r\nDodatkowymi kryteriami wyboru są status zamówienia oraz przedział dat, w którym ten status został ustawiony.<br />\r\n<br />\r\nPo ustawieniu odpowiednich kryteriów wyboru zamówień, które mają zostać wydrukowane klikamy przycisk <strong>Wybierz zamówienia</strong>.<br />\r\n<br />\r\nW wyniku tego wygenerowane zostanie zestawienie wszystkich zamówień, które spełniają ustalone kryteria.<br />\r\n<br />\r\nPrzed wygenerowaniem pliku PDF zawierającego etykiety adresowe obsługa sklepu może wprowadzić korekty. W każdej pozycji można zmodyfikować adresata.<br />\r\n<br />\r\nKażda wygenerowana pozycja ma możliwość usunięcia jej z wydruku. Jeżeli chcemy dodać kolejne pozycje, które nie zostały automatycznie wygenerowane, to wystarczy na dole listy kliknąć link <strong>Dodaj pozycje</strong> - wówczas zostanie dodany kolejny pusty wiersz do zestawienia, w którym można wprowadzić dowolne własne dane.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"308\" src=\"obrazki/pomoc/etykiety_adresowe_wydruk.jpg\" style=\"margin-right:15px;margin-bottom:15px;float:left;\" width=\"591\" />W programie zostały predefiniowane gotowe etykiety (rozmiar, ilość wierszy, ilość kolumn). Etykiety, które są zdefiniowane w programie są według parametrów firmy AVERY.<br />\r\n<br />\r\nDodatkowo można zdefiniować dowolne inne parametry w menu <strong>Konfiguracja / Słowniki / Definiowanie etykiet adresowych</strong>. Znając wymiary posiadanych etykiet, obsługa sklepu może zdefiniować swoje własne wzorce.<br />\r\n<br />\r\nRodzaj etykiety wybiera się przed wygenerowaniem dokumentu PDF.<br />\r\n<br />\r\nDodatkową opcją jest ustawienie od jakiej pozycji rozpocząć drukowanie. Dotyczy to sytuacji, gdy arkusz na którym maja być drukowane etykiety był już wcześniej używany i część naklejek z niego została już wykorzystana. Wówczas można podać pozycję od której ma sę rozpocząć drukowanie. Kolejność pozycji jest liczona po kolei wierszami od prawej do lewej strony i z góry na dół.<br />\r\n<br />\r\nJeżeli wiec mamy przykładowo arkusz etykiet składający się z 3 kolumn i 7 wierszy, a wcześniej zostały z niego już wykorzystane etykiety z dwóch pierwszych wierszy, to należy podać żeby program rozpoczął drukowanie od pozycji 7. Będzie to wówczas pierwsza etykieta w trzecim rzędzie.<br />\r\n<br />\r\nJeżeli już całe zestawienie jest gotowe do wydrukowania, należy kliknąć na dole przycisk: Wydrukuj etykiety adresowe. W wyniku tego zostanie wygenerowany dokument w formacie PDF, który można od razu wydrukować lub zapisać na komputerze w celu późniejszego wydrukowania.<br />\r\n<br />\r\n&nbsp;</div>\r\n"),
("77","225","0","instrukcja","Statusy zamówień i standardowe komentarze do zamówień","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/statusy_zamowienia.jpg\" style=\"float:right;margin-left:15px;margin-bottom:15px;width:560px;height:149px;\" />Podczas zarządzania zamówieniami jedną z opcji jest zmiana statusu zamówienia - tzn. na jakim etapie w procesie realizacji dane zamówienie się znajduje.  W menu <strong>Sprzedaż / Zamówienia / Statusy zamówień</strong> - obsługa sklepu może zarządzać statusami zamówień - definiować jakie statusy będzie można stosować podczas obsługi zamówienia.<br />\r\n	<br />\r\n	Standardowo w sklepie są zdefiniowane najczęściej stosowane statusy zamówień. Administrator sklepu może dodać własne - nowe statusy - lub zmodyfikować już istniejące. Listing statusów zamówienia wyświetla wszystkie zdefiniowane statusy zamówień. Pierwsza kolumna listingu wyświetla id danego statusu w bazie, druga kolumna to nazwa statusu. W kolejnej kolumnie wyświetlany jest kolor - w poszczególnych statusach można definiować kolory w jakich będą się wyświetlać (tylko w panelu zarządzania) - dzięki temu podczas przeglądania historii zamówienia - dane są bardziej czytelne i łatwo można rozróżnić poszczególne statusy. Kolejna kolumna wyświetla typ statusu. Jest to pole informacyjne obrazujące stan zaawansowania zamówienia. Są cztery typy: nowe, w realizacji, zamknięte (zrealizowane), zamknięte (niezrealizowane). Każdy typ może być przypisany do kliku statusów. W kolejnej kolumnie zaznaczony jest zieloną ikoną domyślny status - taki status otrzymuje domyślnie zamówienie złożone przez klienta. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję statusu, usunięcie lub przejście do listy komentarzy standardowych przypisanych do danego statusu. Statusu nie można usunąć jeżeli był użyty w zamówieniach klientów. Usunąć można tylko statusy, które nie były nigdzie wykorzystane.<br />\r\n	<br />\r\n	Dodawanie i edycja statusu to prosty formularz, który wyświetla pola do wypełnienia. Pierwsze pole to nazwa statusu (nazwa jaka będzie widoczna dla klienta). Nazwę należy wprowadzić we wszystkich językach jakie są włączone w sklepie - przełączenie na inną wersję językową następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa statusu w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka. Następnie należy wybrać typ statusu, kolor (po kliknięciu w pole koloru wyświetli się tablica kolorów) oraz zaznaczyć czy dodawany bądź edytowany status ma być domyślnym.<br />\r\n	<br />\r\n	Opcja usuwania statusów jest nieaktywna w przypadku statusu domyślnego. Aby usunąć status ustawiony jako domyślny trzeba najpierw ustawić inny status jako domyślny - po tym będzie można usunąć dany status.<br />\r\n	W listingu statusów - w ikonach nawigacyjnych znajduje się ikona standardowych komentarzy <img alt=\"alt\" src=\"obrazki/pomoc/standardowe_komentarze.jpg\" style=\"width:20px;height:22px;\" />. Po kliknięciu w ikonę otworzy się kolejna podstrona z listą zdefiniowanych standardowych komentarzy do danego statusu.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/zamowienia_standardowe_komentarze.jpg\" style=\"margin-right:15px;margin-bottom:15px;float:left;width:515px;height:96px;\" /><strong>Komentarze standardowe</strong> są używane podczas edycji lub dodawania nowego statusu zamówienia. Są one widoczne po wybraniu z listy statusu zamówienia - pod statusem wyświetli się lista przypisanych do tego statusu standardowych komentarzy. <img alt=\"alt\" src=\"obrazki/pomoc/reklamacje_edycja_komentarze.jpg\" style=\"width:250px;height:59px;float:right;margin:10px;margin-right:0px\" />Po wyborze z listy komentarza - jego treść wstawi się automatycznie w pole edytora tekstu. Takie rozwiązanie ułatwia pracę administratora sklepu, gdyż za każdym razem nie musi on wpisywać tekstu do edytora, a może przygotować standardowe - najczęściej używane teksty dla poszczególnych statusów zamówień.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/zamowienia_standardowe_komentarze_edycja.jpg\" style=\"margin-bottom:15px;margin-left:15px;float:right;width:327px;height:307px;\" />Sam moduł standardowych komentarzy umożliwia dodawanie nowych treści, edycję istniejących oraz usunięcie niepotrzebnych komentarzy. Podczas edycji lub dodawania nowej pozycji w standardowych komentarzach do zamówień należy w edytorze wpisać tekst, który będzie wstawiany po wybraniu danego komentarza, wpisać nazwę komentarza (będzie widoczna w formie rozwijanej listy pod statusem podczas edycji zamówienia) oraz wpisać kolejność wyświetlania (kolejność wyświetlania w rozwijanej liście).<br />\r\n	<br />\r\n	Nie ma ograniczenia ilości dodawanych komentarzy do zamówień. Statusy zamówień nie muszą mieć także przypisanych żadnych standardowych komentarzy - ta forma stanowi tylko ułatwienie obsługi statusów zamówień.</div>\r\n"),
("78","551","0","instrukcja","Wysyłki","<div style=\"text-align:justify;\">Moduł wysyłek , to jeden z podstawowych modułów działających w sklepie od strony klienta. Umożliwia on w trakcie realizacji zamówienia wybranie klientowi sposobu w jaki zostanie do niego dostarczony zamówiony towar. Moduł ten łączy się w sposób nierozerwalny z modułem płatności. W tym rozdziale zostanie omówiony sposób działania modułu umożliwiającego realizację wysyłek.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 620px; height: 220px;\" />Po wybraniu w menu pozycji <strong>Moduły / Wysyłki</strong> wyświetlona zostanie lista wszystkich zdefiniowanych w programie modułów wysyłek.<br />\r\n<br />\r\nLista zawiera podstawowe informacje o każdej zdefiniowanej wysyłce. W pierwszej kolumnie jest numer id jaki dany moduł posiada w bazie danych. W drugiej kolumnie wyświetlana jest robocza nazwa modułu (widoczna tylko w panelu administracyjnym sklepu). Trzecia kolumna to opis według jakiego sposobu są obliczane koszty wysyłki - szczegółowo zostało to opisane w instrukcji w części dotyczącej dodawani/edycji modułu wysyłki. Kolejne kolumny przedstawiają odpowiednio maksymalną wagę całego zamówienia do jakiej dana wysyłka jest dostępna, maksymalną wartość zamówienia, kwotę od jakiej dana wysyłka jest bezpłatna (jeżeli została taka kwota zdefiniowana). Dalej jest informacja czy przesyłka może być dostępna dla produktów zdefiniowanych jako gabarytowe, obrazek wysyłki, jej kolejność wyświetlania na liście wysyłek oraz aktualny status - to znaczy czy wysyłka jest włączona i dostępna w sklepie, czy jest wyłączona. Ostatnia kolumna zawiera ikony nawigacyjne, które pozwalają na wykonywanie określonych akcji związanych z dana przesyłką. Wysyłkę można edytować, duplikować (czyli stworzyć dokładną kopię danej metody wysyłki) .<br />\r\n<br />\r\nDzięki możliwości duplikowania wysyłek, można stworzyć w sklepie bardzo wiele wariantów różnych dostaw. Dotyczy to zwłaszcza sytuacji, gdy towar jest wysyłany za granicę i w związku z tym są zróżnicowane koszty dostawy. W skrajnym przypadku można stworzyć praktycznie wysyłki do każdego kraju oddzielnie i z innymi kosztami.</div>\r\n"),
("79","552","1","instrukcja","Edycja","<div style=\"text-align:justify;\">Klikając w ikonę edycji wysyłki przechodzimy do rozbudowanego formularza, a którym można ustawić wszelkie parametry związane z daną wysyłką.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki_edycja1.jpg\" style=\"margin-bottom:15px;margin-right:15px;float:left;width:593px;height:222px;\" />W pierwszej część tego formularza są informacje tekstowe, które widoczne są dla klienta robiącego zakupy w sklepie. W pierwszym polu wpisana jest robocza nazwa danej wysyłki - widoczna tylko w panelu administracyjnym.<br />\r\n<br />\r\nKolejne pola (które należy wypełniać we wszystkich językach, które są obsługiwane w sklepie) to:<br />\r\n<br />\r\n<strong>Treść wyświetlana w sklepie</strong> pod taką nazwą jaka zostanie w tym miejscu wpisana wysyłka jest wyświetlana klientowi podczas zamówienia.<br />\r\n<br />\r\n<strong>Treść objaśnienia w sklepie</strong> to pole nie jest obowiązkowe do wypełnienia. Jeżeli zostanie tu wpisana treść, to będzie ona w sklepie wyświetlana w chmurce po najechaniu myszką przez klienta na daną wysyłkę w zamówieniu. <img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki_chmurka.jpg\" style=\"width:200px;height:138px;margin-right:15px;margin-top:15px;margin-bottom:15px;float:left;\" />Ostatnim z pól tekstowych, które można wprowadzić dla wysyłki jest <strong>Dodatkowa informacja wyświetlana w potwierdzeniu zamówienia</strong>. Jest to również nie obowiązkowe pole, które jeżeli jest wypełnione to jego treść jest wyświetlana w dodatkowych informacjach o wysyłce na stronie potwierdzenia zamówienia. Można tu wprowadzić dowolną treść, którą chcemy przekazać klientowi w procesie składania zamówienia.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki_edycja2.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 450px; height: 346px; margin-top: 15px;\" />Kolejne pola formularza dotyczą już szczegółów związanych z funkcjonowaniem i zasadami ustalania dostępności danej metody wysyłki. Dostępne są tutaj takie informacje jak: kolejność wyświetlania wysyłki w koszyku klienta, status - czy wysyłka jest włączona w sklepie czy nie, czy przesyłka jest dostępna dla produktów oznaczonych jako gabarytowe, czy do kosztu przesyłki ma być naliczany podatek VAT. Można tutaj także określić jaka może być maksymalna waga przesyłki (oraz co ma się dziać z wysyłką jeżeli waga zostanie przekroczona - czy wysyłka ma być wyłączona czy ma być podzielona na kolejne paczki wg wzoru - liczba_calkowita(waga zamówienia / waga maksymalna) * koszt wysyłki dla wagi maksymalnej), do jakiej wartości zamówienia przesyłka ma być dostępna oraz od jakiej kwoty wartości zamówienia przesyłka będzie dla klienta bezpłatna (dodatkowo można wykluczyć produkty promocyjne z obliczeń do darmowej wysyłki). Dodatkowo można wpisać maksymalną ilości produktów w paczce - po przekroczeniu podanej ilości jest tworzona kolejna paczka. Jeżeli, któreś z tych pól pozostanie puste, to automatycznie nie będzie sprawdzany warunek i wysyłka nie będzie miała żadnych ograniczeń. Można także zdefiniować grafikę dla danej wysyłki (będzie ona wyświetlana na stronie koszyka sklepu przy wyborze sposobu wysyłki i płatności).<br />\r\n<br />\r\nKolejna część formularza to ustalanie kosztu wysyłki. Koszt wysyłki może być obliczany wg kilku różnych kryteriów, które administrator może w tym miejscu ustalić. Wysyłka może być obliczana według następujących kryteriów:<img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki_edycja3.jpg\" style=\"width:400px;height:102px;margin:15px;float:right;\" /></div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Opłata stała</strong> - nie zależy od żadnych parametrów zamówienia - jest zawsze taka sama, niezależnie od tego co klient zamawia.</li>\r\n	<li style=\"text-align:justify;\"><strong>Zależna od wagi zamówienia</strong> - opłata zależy od łącznej wagi wszystkich zamawianych przez klienta produktów. Można zdefiniować dowolne przedziały wagowe z różnymi wartościami opłat.</li>\r\n	<li style=\"text-align:justify;\"><strong>Zależna od wartości zamówienia</strong> - opłata zależy od łącznego kosztu wszystkich zamawianych przez klienta produktów. Można zdefiniować dowolne przedziały kwotowe z różnymi wartościami opłat.</li>\r\n	<li style=\"text-align:justify;\"><strong>Zależna od ilości produktów</strong> - opłata zależy od łącznej ilości wszystkich zamawianych przez klienta produktów. Można zdefiniować dowolne przedziały kwotowe z różnymi wartościami opłat.</li>\r\n	<li style=\"text-align:justify;\"><strong>Wg rozmiaru paczki</strong> - opłata jest zależna od gabarytu przesyłki (A, B lub C) - ta opcja jest dostępna tylko dla modułu Paczkomatów.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki_edycja4.jpg\" style=\"margin-right:15px;margin-bottom:15px;float:left;width:467px;height:115px;\" />W zależności od tego jakie zostanie wybrane z listy kryterium - zmienia się treść pól, w które należy wprowadzić koszty wysyłki. Dla przykładu, jeżeli zostanie jako kryterium wybrana opcja kosztów zależnych od wagi zamówienia, to wyświetlone zostaną pola umożliwiające wprowadzenie przedziałów wagowych i odpowiadających im kosztów.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align: justify;\">W podanym obok przykładzie koszt przesyłki zostały ustawione w sposób następujący: dla zamówień o łącznej wadze do 10 kg - koszt przesyłki wynosi 10,00 zł. Dla zamówień o wadze od 10 do 15 kg - koszt wynosi 15,00 zł. Natomiast przy wadze od 15 do 30 kg - koszt to 20,00 zł. W razie konieczności można dodawać kolejne przedziały lub usuwać istniejące.</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki_edycja5.jpg\" style=\"margin: 15px; float: right; width: 550px; height: 595px;\" /><br />\r\nKolejnym elementem formularza edycji wysyłki jest lista grup klientów do których można ograniczyć dostępność wysyłek. Dostępne są 2 opcje: <strong>dostępna dla grup klientów</strong>&nbsp; - można w tym miejscu wybrać dla jakich grup klientów wysyłka ma być dostępna - np można ograniczyć dostępność wysyłki tylko dla wybranej grupy klientów - np hurtowników oraz druga opcja <strong>nie dostępna dla grup klientów</strong> - która jest odwrotnością poprzedniej opcji. Umożliwia ona wybranie grup klientów dla których dana wysyłka ma nie być dostępna. Np wszyscy klienci mają mieć dostępną daną wysyłkę - ale np klienci przypisani do grupy hurtowników już nie.<br />\r\n<br />\r\nNastępne opcje to powiązanie edytowanej formy wysyłki z dostępnymi w sklepie płatnościami oraz krajami. Poprzez odpowiedni wybór można zaznaczyć jakie formy płatności mają być dostępne dla danej wysyłki, np tylko przelew oraz payu. Można także ograniczyć dla jakich krajów ma być dostępna dana wysyłka.<br />\r\n<br />\r\nW oknach można wybierać kilka elementów równocześnie. W podanym obok przykładzie kryterium dostępności wysyłki zostało ograniczone tylko dla klientów którzy jako adres wysyłki podadzą adres z terytorium Polski. Dla wszystkich innych wysyłka ta będzie niewidoczna w sklepie.<br />\r\n<br />\r\n<strong>W przypadku pola wyboru grup klientów jeżeli nie zostanie zaznaczona żadna grupa klientów to moduł wysyłki będzie dostępny dla wszystkich klientów sklepu.</strong><br />\r\n<br />\r\n<span style=\"color:#ff0000;\">Uwaga: dodatkowym kosztem dodawanym do wysyłki może być również koszt płatności, który można ustalić podczas ustawiania w sklepie modułów płatności. Dotyczy to zwłaszcza kosztów obsługi płatności elektronicznych lub ratalnych</span>.<br />\r\n<br />\r\nW takim przypadku klient jako łączny koszt dostawy w sklepie widzi koszt wysyłki + ustalony koszt obsługi płatności.</div>\r\n"),
("80","400","0","instrukcja","Ustawienia wyglądu","<div style=\"text-align:justify;\">Sklep poza sprzedażą produktów musi także odpowiednio wyglądać. Za ustawienia wyglądu - odpowiada menu <strong>Wygląd</strong>. W zakres tego menu wchodzą opcje umożliwiające zarządzanie wyglądem sklepu. Nie wszystkie ustawienia wyglądu da się zmienić z poziomu panelu zarządzania - wiele ustawień można zmienić tylko poprzez edycję plików css oraz plików szablonu. Struktura plików css i plików szablonu jest opisana w dalszej części w dziele modyfikacji szablonów.&nbsp; Z poziomu panelu zarządzania można jednakże zmienić wiele elementów - ustawić odpowiednią konfigurację modułów wyświetlania czy włączyć odpowiednie moduły.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/wyglad_sklepu.jpg\" style=\"width:650px;height:229px;margin-bottom:15px;margin-right:15px;float:left;\" />Przedstawiony obok szkic prezentuje najczęstszą budowę (układ) jaką mają sklepy internetowe. Najczęściej spotykanym (chociaż już przestarzałym) jest układ: nagłówek, lewa i prawa kolumna z boxami - pomiędzy kolumnami moduły środkowe, a poniżej tych elementów - stopka. Taki układ był stosowany w sklepach kilka lat temu - aktualnie najczęściej odchodzi się od tego układu na rzecz rozwiązania z jedną kolumną z boxami i obok moduły środkowe. Jednakże układ z 2 kolumnami boxów daje możliwość przedstawienia większej ilości danych niż układ 2-kolumnowy. Spotykany jest także układ, gdzie na stronie głównej wyświetlane są tylko: nagłówek, moduły środkowe oraz stopka - a kolumna z boxami jest dopiero wyświetlana na podstronach sklepu. Z poziomu panelu zarządzania można wyłączyć wyświetlanie kolumn z boxami, zdefiniować pozycje menu, ustawić kolejność boxów, modułów, pozycji menu. Nie można jednak dodać wyświetlania np górnego menu czy stopki. Takie elementy muszą być dodane bezpośrednio w kodzie szablonu w postaci kodu html. Wynika to z szybkości działania sklepu - każda dodatkowa konfiguracja ma istotny wpływ na szybkość działania sklepu - dlatego cała struktura wyglądu sklepu jest zapisana w kodzie poszczególnych szablonów.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/ustawienia_wygladu.jpg\" style=\"width: 600px; height: 260px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Pierwszą opcją w menu Wygląd są <strong>Ustawienia wyglądu</strong>. Jest to najważniejsza część umożliwiająca zarządzenie położeniem modułów, boxów, ustawieniem kolorów sklepu, tła oraz ustawieniem opcji menu.<br />\r\n<br />\r\nModuł ustawień wyglądu składa się z <strong>zakładek</strong>. W każdej zakładce definiuje się poszczególne elementy sklepu.<br />\r\n<br />\r\nPierwsza zakładka to <strong>podstawowe dane</strong>. Umożliwia ona ustawienie szerokości sklepu (w pikselach), szerokości kolumn z boxami (w pikselach) oraz ustawienie czy ma być wyświetlana lewa czy prawa kolumna z boxami. W zakładce można wybrać także domyślny szablon sklepu. Podczas wyboru (np zmiany szerokości) dane są zapisywane w bazie natychmiast - nie trzeba po wprowadzeniu danych wciskać przyciski Zapisz - tak jak w innych modułach. Taki zapis jest stosowany w każdej zakładce w opisywanym menu. Dane definiowane w tej zakładce dotyczą szablonów standardowych. W projektach indywidualnych szerokość sklepu oraz ilość kolumn z boxami może być ustalona na stałe i parametry z tej zakładki nie będą działać.<br />\r\n<br />\r\nW zakładce podstawowe dane można także zdefiniować ikonkę w pasku przeglądarki (tzw favicon). Po wybraniu pliku ikonki sklep wgra plik na serwer i zmieni jego nazwę na favicon.ico Dopuszczalny format ikonki to ICO - inne pliki nie mogą być używane jako ikonka paska przeglądarki.<br />\r\n<br />\r\nJedną z opcji w tej zakładce jest także możliwość wybrania podstron sklepu na których mają się nie wyświetlać kolumny z boxami. Dzięki temu można np włączyć wyświetlanie strony logowanie czy karty produktu na całą szerokość sklepu (na pozostałych podstronach kolumna z boxami będzie widoczna). Ta funkcja jest także przydatna przy szablonach mobilnych - należy tak skonfigurować wyświetlanie kolumn z boxami, żeby przy małych rozdzielczościach nie zajmowały niepotrzebnie miejsca - np na podstronie wyszukiwania produktów.<br />\r\n<br />\r\nDruga zakładka to <strong>tło sklepu</strong>. W zakładce tej można zdefiniować czy tło sklepu ma mieć jednolity kolor (kolor można wybrać z palety kolorów) czy ma być to tło obrazkowe. Jeżeli zaznaczy się, że tło sklepu ma być w formie obrazka w polu <strong>ścieżka zdjęcia</strong> można wybrać jaki obrazek ma być tłem sklepu. 2-krotne kliknięcie w pole <strong>ścieżka zdjęcia</strong> otworzy przeglądarkę zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta. Jako opcję można wybrać czy tło obrazkowe ma być w formie jednego obrazka bez powtarzania czy obrazek ma się powtarzać (czyli jeden obok drugiego, żeby zapełnić cały ekran). Jeżeli tło będzie bez powtarzania zostanie wyśrodkowane na ekranie w poziomie oraz będzie nieruchome przy przesuwaniu całości sklepu w dół i górę (sam sklep będzie się przesuwał, a tło będzie nieruchome). Przy wyborze obrazka bez powtarzania powinien to być duży obraz (w pikselach) - jeżeli będzie węższy niż sklep nie będzie go widać bo zostanie przykryty przez sklep - więc minimalna szerokość to szerokość sklepu. Jeżeli będzie wybrana opcja powtarzania - obrazki mogą być mniejsze - będą wyświetlane obok siebie, aż zapełnią cały ekran.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/wyglad_gorne_menu.jpg\" style=\"width: 500px; height: 354px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Trzecia zakładka to <strong>górne menu</strong>. W standardowych szablonach można zdefiniować jakie pozycje (linki) mają się wyświetlać - tworząc górne menu sklepu (opcja ta działa tylko jeżeli szablon sklepu posiada funkcję górnego menu). Górne menu może zawierać linki do stron informacyjnych, grup stron informacyjnych, aktualności, kategorii aktualności, kategorii produktów, formularzy lub galerii. Dodatkowo górne menu może być w formie rozwijanej - rozwijane mogą być strony informacyjne z określonej grupy stron informacyjnych, artykuły z wybranej kategorii aktualności lub podkategorie z wybranej głównej kategorii produktów (tylko pierwsze drzewo podkategorii). Górne menu może także zawierać link zewnętrzny do tzn prowadzący do dowolnej innej strony zdefiniowanej przez obsługę sklepu. Linki takie tworzy się poprzez strony informacyjne. Dokładne tworzenie jest opisane w dziale Stron informacyjnych. W opisywanej zakładce wyświetlane są pozycje menu jakie zostały dodane (tytuły poszczególnych pozycji) - będą się one składać na górne menu. Nowo dodana pozycja trafia zawsze na początek listy. Zmiany kolejności poszczególnych pozycji dokonuje się poprzez kliknięcie na wybraną pozycję, przytrzymanie kursora myszki i przeciągnięcie elementu niżej lub wyżej. Kolejność można także zmieniać strzałkami góra / dół. Zmiana kolejności jest automatycznie zapisywana w bazie sklepu. Poszczególne pozycje mają przypisane ikonki, które informują jakiego rodzaju jest dana pozycja - dokładna legenda znajduje się pod listą pozycji menu. Pod listą znajduje się także link do dodawania nowej pozycji. Po kliknięciu w link otworzy się dodatkowe okienko z możliwością wyboru nowej pozycji do menu. Z rozwijanej listy należy wybrać pozycję jaką chcemy dodać do menu. Przy każdej pozycji po prawej stronie znajdują się dwie ikonki: edycji oraz kasowania. Kliknięcie w ikonkę kasowania (czerwony krzyżyk) powoduję usunięcie danej pozycji z wyświetlania w menu. Kliknięcie w edycję spowoduje przeniesienie do modułu w którym można dokonać edycji danej pozycji.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/wyglad_boxy.jpg\" style=\"width: 550px; height: 270px; float: right; margin-left: 15px; margin-right: 15px;\" />Kolejna zakładka to<strong> boxy w kolumnach</strong>. W tej zakładce definiuje się jakie boxy, w jakiej kolejności oraz w której kolumnie mają się wyświetlać. Boxy dostępne w sklepie definiuje się w menu Wygląd / Boxy (moduł szczegółowo opisany w dalszej części instrukcji). W zakładce wyświetlane są 2 kolumny, które reprezentują kolumny z boxami w sklepie. W kolumnach wyświetlane są boxy jakie zostały dodane do poszczególnych kolumn. W każdej pozycji wyświetlana jest nazwa boxu, informacja co dany box wyświetla oraz gdzie będzie się wyświetlał (czy na każdej stronie, czy tylko na stronie głównej, czy tylko na podstronach). Podobnie jak przy definiowaniu górnego menu nowo dodany box w kolumnie trafia na początek listy. Zmiany kolejności poszczególnych boxów dokonuje się poprzez kliknięcie na wybrany box, przytrzymanie kursora myszki i przeciągnięcie elementu niżej lub wyżej. Kolejność można także zmieniać strzałkami góra / dół. Zmiany położenia (lewa / prawa kolumna) dokonuje się poprzez kliknięcie na zieloną strzałkę (lewa lub prawa). W sklepie są trzy rodzaje boxów: 1. w formie skryptów języka php, które wyświetlają określone dane pobrane z bazy sklepu, 2. stworzone ze strony informacyjnej (box może wyświetlać treść przygotowaną podczas tworzenie strony informacyjnej), 3. boxy wykonujące jakiś zewnętrzny skrypt (np wyświetlające box facebooka). W każdym boxie wyświetlana jest ikonka informująca, jakiego rodzaju jest dany box - dokładna legenda znajduje się pod listą boxów. Dodawanie nowego boxu do wyświetlania w sklepie odbywa się poprzez kliknięcie w przycisk dodaj nowy box (pod kolumną do której chcemy dodać box). Po kliknięciu w link otworzy się dodatkowe okienko z możliwością wyboru nowego boxu. Z rozwijanej listy należy wybrać box jaki chcemy dodać. Przy każdej pozycji po prawej stronie znajdują się dodatkowo dwie ikonki (oprócz zielonej strzałki do zmiany kolumny wyświetlania boxu): edycji oraz kasowania. Kliknięcie w ikonkę kasowania (czerwony krzyżyk) powoduję usunięcie wyświetlania danego boxu w kolumnie. Kliknięcie w edycję spowoduje przeniesienie do modułu w którym można dokonać edycji danego boxu.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/wyglad_moduly.jpg\" style=\"width: 500px; height: 334px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Zakładka <strong>moduły środkowe</strong> definiuje elementy, które wyświetlane są w części środkowej sklepu pomiędzy kolumnami z boxami oraz moduły, które mogą być wyświetlane nad lub pod kolumnami boxów. Moduły środkowe mogą wyświetlać: promocje, kategorie produktów, informacje, bannery itd. Moduły środkowe dostępne w sklepie definiuje się w menu <strong>Wygląd / Moduły środkowe</strong> (moduł szczegółowo opisany w dalszej części instrukcji). W zakładce wyświetlane są widoczne w sklepie moduły. W każdej pozycji wyświetlana jest nazwa modułu oraz informacja co dany moduł wyświetla. Podobnie jak w boxach nowo dodana pozycja trafia zawsze na początek listy. Zmiany kolejności poszczególnych pozycji dokonuje się poprzez kliknięcie na wybraną pozycję, przytrzymanie kursora myszki i przeciągnięcie elementu niżej lub wyżej. Kolejność można także zmieniać strzałkami góra / dół. Podobnie również jak w boxach moduły środkowe występują w trzech rodzajach: skrypt php, strona informacyjna lub zewnętrzny skrypt. W każdym module wyświetlana jest ikonka informująca, jakiego rodzaju jest dany moduł - dokładna legenda znajduje się pod listą modułów. Dodawanie nowego modułu odbywa się poprzez kliknięcie w przycisk dodaj nowy moduł. Po kliknięciu w link otworzy się dodatkowe okienko z możliwością wyboru nowego modułu. Z rozwijanej listy należy wybrać moduł jaki chcemy dodać. Przy każdej pozycji po prawej stronie znajdują się dwie ikonki: edycji oraz kasowania. Kliknięcie w ikonkę kasowania (czerwony krzyżyk) powoduję usunięcie wyświetlania danego modułu. Kliknięcie w edycję spowoduje przeniesienie do modułu w którym można dokonać edycji danego modułu.<br />\r\n<br />\r\nCała zakładka modułów środkowych jest podzielona na 3 części:</div>\r\n\r\n<ul>\r\n	<li style=\"text-align: justify;\"><strong>moduły wyświetlane nad częścią główną sklepu</strong> - w tej części dodaje się moduły, które mają być wyświetlane nad częścią z kolumnami boxów. W tym miejscu najczęściej umieszczany jest np moduł bannerów - w takim przypadku bannery są wyświetlane na całą szerokość sklepu co pozwala na lepszą prezentację grafik.</li>\r\n	<li style=\"text-align: justify;\"><strong>moduły w części głównej sklepu</strong> - są to moduły, które są wyświetlane pomiędzy kolumnami boxów. W tej części są umieszczane wszystkie moduły mające za zadanie prezentację produktów, informacji etc.</li>\r\n	<li style=\"text-align: justify;\"><strong>moduły wyświetlane pod częścią główną sklepu</strong> - w tej części dodaje się moduły, które mają być wyświetlane pod częścią z kolumnami boxów. Może to być np moduł newslettera czy logotypów producentów - takie moduły będą wyświetlane na całą szerokość sklepu.</li>\r\n</ul>\r\n\r\n<div style=\"text-align: justify;\">W każdej z sekcji można dodać po kilka modułów. Poprzez dodawanie modułów w różnych miejscach można osiągnąć ciekawy i niestandardowy układ sklepu, który będzie bardziej atrakcyjny dla klientów.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nZakładka <strong>dolne menu</strong> jest identyczna w działaniu jak zakładka górne menu. Definiuje ona jednak wygląd dolnego menu w sklepie (opcja ta działa tylko jeżeli szablon sklepu posiada funkcję dolnego menu).<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/wyglad_stopka_sklep.jpg\" style=\"width: 450px; height: 79px; margin-bottom: 15px; margin-right: 15px; float: left;\" /><img alt=\"alt\" src=\"obrazki/pomoc/wyglad_stopka.jpg\" style=\"width: 400px; height: 218px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Kolejne zakładki definiują <strong>linki stopki</strong>. W szablonach sklepów - w zależności od budowy szablonu -&nbsp; jest możliwość definiowania linków informacyjnych w stopce. Są one wyświetlane w formie kolumn. Sklep umożliwia zdefiniowanie w stopce do 5 kolumn linków. Każda kolumna może mieć indywidualną nazwę oraz dowolną ilość linków. Każda kolumna jest definiowana w osobnej zakładce <strong>Stopka ... kolumna</strong>. Po wejściu w wybraną zakładkę trzeba zdefiniować nazwę nagłówka stopki. Jest to nazwa które będzie wyświetlała się jako tytuł kolumny z linkami. Tekst należy wprowadzić we wszystkich językach jakie są włączone w sklepie - przełączenie na inną wersję językową następuje poprzez kliknięcie na zakładkę z nazwą języka. Poniżej tytułu znajduje się dodatkowe pola tekstowe, gdzie można wpisać tekst, który będzie wyświetlany nad linkami w danej kolumnie stopki. Poniżej pola tekstowego dodaje się linki jakie ma zawierać kolumna stopki. Sama zasada dodawania nowych linków, zmiany kolejności oraz typów linków jest identyczna jak w przypadku górnego czy dolnego menu.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/wyglad_mobilny.jpg\" style=\"width: 280px; height: 250px; float: left; margin-bottom: 10px; margin-right: 10px;\" />Ostatnia zakładka to<strong> szablon mobilny</strong>. W zakładce tej definiuje się ustawienia szablonu jaki będzie wyświetlał się na urządzeniach mobilnych, tzn telefonach komórkowych i tabletach. Ze względu na małe rozdzielczości tych urządzeń i brak obsługi niektórych elementów sklepu dla urządzeń tych przewidziane są w sklepie osobne szablony graficzne. W konfiguracji szablonu mobilnego można wybrać osobny nagłówek dla urządzeń mobilnych, ustawić jakie moduły z produktami mają się wyświetlać lub ile produktów ma być widocznych na stronie. Szablon mobilny jest dużo prostszy niż jego odpowiednik na urządzenia stacjonarne. Szablon mobilny posiada na stałe wbudowane dwa boxy: kategorii i producentów. Nie są dostępne inne boxy - zdefiniowane w menu <strong>Wygląd / Boxy</strong>. Wynika to z budowy szablonu, który musi być prosty i czytelny przy małych rozdzielczościach ekranów. Podobnie nie są dostępne moduły środkowe definiowane w menu <strong>Wygląd / Moduły środkowe</strong>. Szablon mobilny ma wbudowane (z możliwością wyłączenia) proste moduły wyświetlania nowości, promocji. polecanych oraz hitów. Można także wyświetlić ostatnio dodane aktualności. Dostępne jest także górne oraz dolne menu z linkami definiowane w menu <strong>Wygląd / Ustawienia wyglądu</strong>. W szablonie mobilnym nie są dostępne kolumny stopki z linkami - gdyż zajmowałby zbyt dużo miejsca. Dodatkowo dostępny jest formularz zapisania do newslettera. Klient z poziomu szablonu mobilnego ma możliwość przełączenia się na szablon główny sklepu. Sam sklep w wersji mobilnej posiada takie same funkcje i podstrony jak w wersji dla urządzeń stacjonarnych, działa koszyk, schowek, wyszukiwarka. Ograniczona jest ilość filtrów w listingach. Wszystko aby maksymalnie ułatwić nawigowanie na urządzeniach mobilnych. W ustawieniach szablonu mobilnego można wybrać czy sklep ma automatycznie rozpoznawać na jakim urządzeniu został uruchomiony i uruchamiać się w mobilnym lub standardowym szablonie. Dodatkowo można całkowicie wyłączyć używanie szablonów mobilnych. Każdy szablon w sklepie może mieć swój odpowiednik mobilny - musi mieć on rozszerzenie .mobile Dla przykładu szablon o nazwie <strong>standardowy</strong> dla wersji mobilnej będzie się nazywał <strong>standardowy.mobile</strong> Jeżeli jest włączone rozpoznawanie urządzeń mobilnych i w sklepie jest ustawiony szablon, który nie ma swojej wersji mobilnej to po uruchomieniu sklepu na urządzeniu mobilnym zostanie uruchomiony standardowy szablon mobilny o nazwie<strong> standardowy.mobile</strong></div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("81","401","0","instrukcja","Boxy","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/boxy.jpg\" style=\"width: 160px; height: 708px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Jednym z elementów, które wyświetlane są w sklepie są <strong>boxy</strong>. Boxy to małe elementy (moduły), które mogą wyświetlać różne informacje - produkty, kategorie produktów, informacje kontaktowe, aktualności itd. Boxy wyświetlane są w kolumnach - jeden pod drugim. W sklepie może być jedna lub dwie kolumny z boxami. Kolumny są umiejscowione po lewej lub prawej stronie sklepu. Boxy mogą mieć także indywidualny wygląd - w zależności od przygotowanego szablonu. Standardowo każdy box składa się z nagłówka w którym wyświetlany jest tytuł / nazwa boxu, a poniżej wyświetlana jest zawartość boxu. Sklep zawiera standardowo ok 50 różnego rodzaju boxów. Boxami zarządza się poprzez menu <strong>Wygląd / Boxy</strong>. Po wejściu w opisywane menu wyświetli się lista dostępnych w sklepie boxów.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/boxy_lista.jpg\" style=\"width: 500px; height: 193px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Każdy box jest wyświetlany w osobnym wierszu. Pierwsza kolumna listy wyświetla id boxu w bazie sklepu. Druga kolumna wyświetla nazwę boxu. Jest to nazwa jaka jest wyświetlana w sklepie w nagłówku boxu. Kolejna kolumna wyświetla rodzaj boxu. Poszczególne pozycje mają przypisane ikonki, które informują jakiego rodzaju jest dany box - dokładna legenda znajduje się pod listą boxów. W sklepie są trzy rodzaje boxów: 1. w formie skryptów języka php, które wyświetlają określone dane pobrane z bazy sklepu (np produkty, kategorie), 2. stworzone ze strony informacyjnej (box może wyświetlać treść przygotowaną podczas tworzenie strony informacyjnej), 3. boxy wykonujące jakiś zewnętrzny skrypt (np wyświetlające box facebooka). W kolejnej kolumnie wyświetlana jest informacja czy w boxie jest wyświetlany nagłówek. Przy dodawaniu czy edycji boxu można zaznaczyć, żeby nagłówek boxu nie był wyświetlany - wtedy w sklepie będzie wyświetlana wyłącznie treść / zawartość boxu. Następna kolumna wyświetla informację <strong>co wyświetla box</strong> - jest to tylko informacja dla administratora sklepu, ułatwiająca odnalezienie boxu w liście oraz identyfikacje co wyświetla dany box. Podobne dane zawiera kolejna kolumna - opis boxu - ma ona także charakter informacyjny - jest ona także widoczna przy dodawaniu boxu w wyglądzie sklepu (menu <strong>Wygląd / Ustawienia wyglądu</strong>) i ułatwia wybranie / znalezienie odpowiedniego boxu. Następna kolumna pokazuje miejsce wyświetlania boxu. Box może być wyświetlany tylko na stronie głównej sklepu, tylko na podstronach lub na wszystkich stronach. W kolejnej kolumnie wyświetlana jest w formie ikonki informacja czy dany box może być wyświetlany w szablonach RWD*. Jeżeli przy danym boxie jest wyświetlana ikonka oznacza to, że dany box będzie wyświetlany w szablonach o budowie RWD. Przedostatnia kolumna wyświetla informacje czy box jest wyświetlany w sklepie (czy został dodany do wyświetlania w menu <strong>Wygląd / Ustawienia wyglądu sklepu</strong> - zakładka <strong>boxy w kolumnach</strong>) - kolor zielony ikonki oznacza, że box jest aktywny i będzie wyświetlany w sklepie, kolor szary oznacza, że box nie został wybrany do wyświetlania. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję boxu lub jego usunięcie.<br />\r\n<br />\r\nRWD - Responsive Web Design - technika projektowania strony www, tak aby jej wygląd i układ dostosowywał się automatycznie do rozmiaru okna urządzenia, na którym jest wyświetlany (np. przeglądarki, smartfonów czy tabletów. Strona tworzona w takiej technice jest uniwersalna i wyświetla się dobrze zarówno na wielkich ekranach (np. Full HD), jak i na ekranach smartfonów czy tabletów - źródło http://pl.wikipedia.org/wiki/Responsive_Web_Design</div>\r\n"),
("82","402","1","instrukcja","Dodawanie / edycja","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/box_dodawanie.jpg\" style=\"width: 500px; height: 484px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Nowy box do sklepu dodaje się w menu <strong>Wygląd / Boxy</strong> poprzez kliknięcie w przycisk <strong>dodaj nowy box</strong>. Po kliknięciu otworzy się strona z formularzem dodawania nowego boxu. Pierwszym i obowiązkowym pole do wypełnienia jest nazwa boxu. Jest to tekst jaki będzie się wyświetlał w nagłówku boxu w sklepie. Tekst należy wprowadzić we wszystkich językach jakie są włączone w sklepie - przełączenie na inną wersję językową następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa boxu w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\nPoniżej trzeba wybrać rodzaj boxu. Dostępne są 3 warianty:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Plik php</strong> - po wybraniu tej opcji w polu <strong>nazwa pliku</strong> należy wpisać nazwę pliku / skryptu php jaki będzie odpowiadał z działanie boxu. Pliki php boxów są w sklepie wgrywane do katalogu <strong>boxy</strong> w głównym katalogu sklepu. Każdy box musi mieć osobny plik odpowiadający za jego działanie. Nie można wykorzystywać tego samego pliku do różnych boxów.</li>\r\n	<li style=\"text-align:justify;\"><strong>Strona informacyjna</strong> - box może wyświetlać także <strong>treść</strong> strony zdefiniowanej w module stron informacyjnych (menu <strong>Wygląd / Strony informacyjne / Zarządzanie stronami</strong>). Po wybraniu tej opcji zniknie pole nazwy pliku, a w tym miejscu pokaże się pole <strong>wybierz stronę informacyjną</strong> z możliwością wybrania strony jaka ma się wyświetlać (tytuły stron są pobierane ze zdefiniowanych stron w w/w menu). Po zapisaniu takiego boxu będzie on wyświetlał treść strony jaka została wpisana podczas tworzenia czy edycji istniejącej strony informacyjnej.</li>\r\n	<li style=\"text-align:justify;\"><strong>Dowolny skrypt</strong> - box może wyświetlać także treść która jest generowana przez dowolny zewnętrzny kod. Po wybraniu tej opcji pole nazwy pliku zniknie i w jego miejscu pokaże się pole do wstawienia kodu. Przykładem do czego można wykorzystać takie rozwiązanie jest stworzenie kodu facebooka czy gg. Wystarczy wstawić wygenerowany na danym portalu kod, żeby box wyświetlał np okno komunikatora gg.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Kolejnym polem jest pole wyboru <strong>nagłówek boxu</strong>. Opcja ta umożliwia wyłączenie lub włączenie wyświetlania nagłówka boxu. Jeżeli nagłówek jest wyłączony wyświetlana w sklepie będzie tylko sama treść / zawartość boxu. Ta opcja jest najczęściej używana przy stronach informacyjnych oraz skrypcie w boxie.<br />\r\n<br />\r\nNastępne pole to <strong>wygląd boxu</strong>. Standardowo wszystkie boxy są wyświetlane w wyglądzie zdefiniowanym w pliku o nazwie box.tp, który znajduje się w katalogu szablonu w podkatalogu /boxy_wyglad. Ten plik definiuje wygląd standardowego boxu w szablonie. Plik jest zbiorem komend języka html, które generują odpowiedni wygląd boxu. W dalszej części instrukcji opisany jest dokładny sposób modyfikacji plików szablonu. Jeżeli box ma mieć inny wygląd niż boxy standardowe można przy dodawaniu wskazać jaki plik będzie odpowiadał za wygląd boxu. Po wybraniu opcji <strong>indywidualny </strong>rozwinie się dodatkowe okno gdzie będzie można wpisać nazwę pliku jaka będzie odpowiedzialna za wygląd danego boxu. Plik który będzie obsługiwał box musi się znajdować w katalogu /boxy_wyglad w katalogu szablonu. Jeżeli podczas działania sklepu - sklep nie znajdzie podanego pliku - wyświetli box w standardowym wyglądzie z pliku box.tp.<br />\r\n<br />\r\nKolejne pole to <strong>wyświetlanie boxu</strong>. Box może się wyświetlać tylko na stronie głównej sklepu, tylko na podstronach lub na wszystkich stronach sklepu. Od wybrania odpowiedniej opcji będzie zależało gdzie będzie wyświetlany dany box.<br />\r\n<br />\r\nOstatnie pola w tej sekcji to <strong>opis boxu</strong> i <strong>co wyświetla</strong>. Są to pola informacyjne dla administratora sklepu, ułatwiające odnalezienie boxu w liście oraz identyfikujące co wyświetla dany box. Opis boxu jest widoczny przy dodawaniu boxu w wyglądzie sklepu (menu <strong>Wygląd / Ustawienia wyglądu</strong>) i ułatwia wybranie / znalezienie odpowiedniego boxu.<br />\r\n<br />\r\nOstatnia część modułu dodawania nowego boxu to <strong>Ustawienia RWD</strong>. W tej części można ustawić czy dany box może być wyświetlany w szablonach RWD (czasami budowa boxu uniemożliwia jego poprawne działania z technologii RWD i taki box należy wyłączyć dla szablonów RWD) oraz co ma się dziać z boxem przy małych rozdzielczościach w takich szablonach (poniżej 760px szerokości ekranu). Jeżeli box może działać w szablonach RWD to przy małych rozdzielczościach może być ukrywany, być minimalizowany (będzie widoczny tylko nagłówek boxu z możliwością rozwinięcia treści boxu lub może pozostawać bez zmian. Przy dużej ilości włączonych boxów warto jest odpowiednio skonfigurować wygląd boxów dla małych rozdzielczości - żeby np ma małym ekranie telefonu komórkowego nie wyświetlało się za dużo niepotrzebnych informacji.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/box_edycja.jpg\" style=\"width:450px;height:133px;margin-bottom:15px;margin-right:15px;float:left;\" />Edycja istniejącego boxu jest zbliżona do dodawania nowego boxu. Jednak podczas edycji nie ma możliwości wybrania rodzaju boxu. Jest to parametr nieedytowalny. Dodatkowo podczas edycji niektóre boxy mają dodatkowe parametry do wyboru. Dodatkowe parametry są widoczne tylko podczas edycji boxu. Są one wyświetlane pomiędzy polem nazwa pliku, a opisem boxu.</div>\r\n"),
("83","405","0","instrukcja","Moduły środkowe","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_srodkowe.jpg\" style=\"width: 400px; height: 395px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Kolejnym elementem wyglądu sklepu są <strong>moduły środkowe</strong>. Moduły środkowe w swojej zasadzie działania wyświetlają podobne elementy jak boxy - tylko w innej formie - ze względu na to, że z reguły są dużo szersze od kolumn z boxami. Mogą tak jak boxy wyświetlać: produkty, kategorie produktów, aktualności, bannery itd. Moduły środkowe jak sama nazwa wskazuje znajdują się w części środkowej sklepu pomiędzy kolumnami z boxami. Mogą być także wyświetlane nad lub pod kolumnami z boxami. Od wyglądu głównej strony sklepu zależy pierwsze wrażenie klienta - dlatego ważne jest żeby moduły jakie zostaną włączone zachęcały klienta do zakupów i dobrze prezentowały produkty sklepu. Sklep zawiera standardowo ponad 20 różnego rodzaju modułów. Mogą mieć one indywidualny wygląd - w zależności od przygotowanego szablonu. Standardowo każdy moduł składa się z nagłówka w którym wyświetlany jest tytuł / nazwa, a poniżej wyświetlana jest zawartość którą generuje dany moduł. Modułami środkowymi zarządza się poprzez menu <strong>Wygląd / Moduły środkowe</strong>. Po wejściu w opisywane menu wyświetli się lista dostępnych w sklepie modułów.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_srodkowe_lista.jpg\" style=\"width: 500px; height: 215px; margin-left: 15px; margin-bottom: 15px; margin-top: 10px; float: right;\" />Każdy moduł w listingu jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla id modułu w bazie sklepu. Druga kolumna wyświetla nazwę modułu. Jest to nazwa jaka jest wyświetlana w sklepie w nagłówku modułu (nad treścią którą wyświetla moduł). Kolejna kolumna wyświetla rodzaj modułu. Tutaj zasada działania jest identyczna jak w przypadku boxów, poszczególne pozycje mają przypisane ikonki, które informują jakiego rodzaju jest dany moduł - dokładna legenda znajduje się pod listą. W sklepie są trzy rodzaje modułów 1. w formie skryptów języka php, które wyświetlają określone dane pobrane z bazy sklepu (np produkty, kategorie), 2. stworzone ze strony informacyjnej (moduł może wyświetlać treść przygotowaną podczas tworzenie strony informacyjnej), 3. moduły wykonujące jakiś zewnętrzny skrypt (np wyświetlające kod facebooka). W kolejnej kolumnie wyświetlana jest informacja czy w module jest wyświetlany nagłówek. Przy dodawaniu czy edycji modułu można zaznaczyć, żeby nagłówek nie był wyświetlany - wtedy w sklepie będzie wyświetlana wyłącznie treść / zawartość modułu. Następna kolumna wyświetla informację <strong>co wyświetla moduł</strong> - jest to tylko informacja dla administratora sklepu, ułatwiająca odnalezienie modułu w liście oraz identyfikacje co wyświetla dany moduł. Podobne dane zawiera kolejna kolumna - opis modułu - ma ona także charakter informacyjny - jest ona także widoczna przy dodawaniu modułu w wyglądzie sklepu (menu <strong>Wygląd / Ustawienia wyglądu</strong>) i ułatwia wybranie / znalezienie odpowiedniego modułu.<br />\r\n<br />\r\nNastępna kolumna pokazuje miejsce wyświetlania modułu. Moduł może być wyświetlany tylko na stronie głównej sklepu, tylko na podstronach lub na wszystkich stronach. Dodatkowo w formie ikon jest prezentowane miejsce wyświetlania modułu na stronie sklepu:<br />\r\n&nbsp;</div>\r\n\r\n<table>\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"vertical-align: middle;\"><img alt=\"alt\" src=\"obrazki/wyswietlanie_modul_gora.png\" style=\"width: 16px; height: 26px; margin-right: 5px;\" /></td>\r\n			<td style=\"vertical-align: middle;\">oznacza, że moduł będzie wyświetlany nad częścią z kolumnami boxów</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align: middle;\"><img alt=\"alt\" src=\"obrazki/wyswietlanie_modul_srodek.png\" style=\"width: 16px; height: 26px; margin-right: 5px;\" /></td>\r\n			<td style=\"vertical-align: middle;\">oznacza, że moduł będzie wyświetlany pomiędzy kolumnami z boxami - w tzw części środkowej sklepu</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align: middle;\"><img alt=\"alt\" src=\"obrazki/wyswietlanie_modul_gora.png\" style=\"width: 16px; height: 26px; margin-right: 5px;\" /></td>\r\n			<td style=\"vertical-align: middle;\">oznacza, że moduł będzie wyświetlany pod częścią z kolumnami boxów</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nW kolejnej kolumnie wyświetlana jest w formie ikonki informacja czy dany moduł może być wyświetlany w szablonach RWD*. Jeżeli przy danym module jest wyświetlana ikonka oznacza to, że dany moduł będzie wyświetlany w szablonach o budowie RWD. Przedostatnia kolumna wyświetla informacje czy moduł jest wyświetlany w sklepie (czy został dodany do wyświetlania w menu <strong>Wygląd / Ustawienia wyglądu sklepu</strong> - zakładka <strong>moduły środkowe</strong>) - kolor zielony ikonki oznacza, że moduł jest aktywny i będzie wyświetlany w sklepie, kolor szary oznacza, że moduł nie został wybrany do wyświetlania. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję modułu lub jego usunięcie.<br />\r\n<br />\r\nRWD - Responsive Web Design - technika projektowania strony www, tak aby jej wygląd i układ dostosowywał się automatycznie do rozmiaru okna urządzenia, na którym jest wyświetlany (np. przeglądarki, smartfonów czy tabletów. Strona tworzona w takiej technice jest uniwersalna i wyświetla się dobrze zarówno na wielkich ekranach (np. Full HD), jak i na ekranach smartfonów czy tabletów - źródło http://pl.wikipedia.org/wiki/Responsive_Web_Design</div>\r\n"),
("84","406","1","instrukcja","Dodawanie / edycja","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_srodkowe_dodawanie.jpg\" style=\"width: 500px; height: 485px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Nowy moduł środkowy dodaje się w menu <strong>Wygląd / Moduły środkowe</strong> poprzez kliknięcie w przycisk <strong>dodaj nowy moduł</strong>. Po kliknięciu otworzy się strona z formularzem dodawania nowego modułu. Pierwszym i obowiązkowym pole do wypełnienia jest nazwy modułu. Jest to tekst jaki będzie się wyświetlał w nagłówku modułu w sklepie. Tekst należy wprowadzić we wszystkich językach jakie są włączone w sklepie - przełączenie na inną wersję językową następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa modułu w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nPoniżej trzeba wybrać rodzaj modułu. Dostępne są 3 warianty:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Plik php</strong> - po wybraniu tej opcji w polu <strong>nazwa pliku</strong> należy wpisać nazwę pliku / skryptu php jaki będzie odpowiadał z działanie modułu. Pliki php modułów środkowych są w sklepie wgrywane do katalogu <strong>moduly</strong> w głównym katalogu sklepu.</li>\r\n	<li style=\"text-align:justify;\"><strong>Strona informacyjna</strong> - moduł może wyświetlać także <strong>treść</strong> strony zdefiniowanej w module stron informacyjnych (menu <strong>Wygląd / Strony informacyjne / Zarządzanie stronami</strong>). Po wybraniu tej opcji zniknie pole nazwy pliku, a w tym miejscu pokaże się pole <strong>wybierz stronę informacyjną</strong> z możliwością wybrania strony jaka ma się wyświetlać (tytuły stron są pobierane ze zdefiniowanych stron w w/w menu). Po zapisaniu takiego modułu będzie on wyświetlał treść strony jaka została wpisana podczas tworzenia czy edycji istniejącej strony informacyjnej.</li>\r\n	<li style=\"text-align:justify;\"><strong>Dowolny skrypt</strong> - moduł może wyświetlać także treść która jest generowana przez dowolny zewnętrzny kod. Po wybraniu tej opcji pole nazwy pliku zniknie i w jego miejscu pokaże się pole do wstawienia kodu. Przykładem do czego można wykorzystać takie rozwiązanie jest stworzenie kodu facebooka.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Kolejnym polem jest pole wyboru <strong>nagłówek modułu</strong>. Opcja ta umożliwia wyłączenie lub włączenie wyświetlania nagłówka modułu. Jeżeli nagłówek jest wyłączony wyświetlana w sklepie będzie tylko sama treść / zawartość modułu. Ta opcja jest najczęściej używana przy stronach informacyjnych oraz skrypcie w module. Używana jest także w systemie bannerów animowanych - gdzie nie jest konieczne wyświetlanie treści nagłówka.<br />\r\n<br />\r\nNastępne pole to <strong>wygląd modułu</strong>. Standardowo wszystkie moduły są wyświetlane w wyglądzie zdefiniowanym w pliku o nazwie modul.tp, który znajduje się w katalogu szablonu w podkatalogu /moduly_wyglad. Ten plik definiuje wygląd standardowego modułu w szablonie. Plik jest zbiorem komend języka html, które generują odpowiedni wygląd modułu. W dalszej części instrukcji opisany jest dokładny sposób modyfikacji plików szablonu. Jeżeli moduł ma mieć inny wygląd niż moduły standardowe można przy dodawaniu wskazać jaki plik będzie odpowiadał za wygląd modułu. Po wybraniu opcji <strong>indywidualny </strong>rozwinie się dodatkowe okno gdzie będzie można wpisać nazwę pliku jaka będzie odpowiedzialna za wygląd danego modułu. Plik który będzie obsługiwał moduł musi się znajdować w katalogu /moduly_wyglad w katalogu szablonu. Jeżeli podczas działania sklepu - sklep nie znajdzie podanego pliku - wyświetli moduł w standardowym wyglądzie z pliku modul.tp.<br />\r\n<br />\r\nKolejne pole to <strong>wyświetlanie modułu</strong>. Moduł podobnie jak boxy może się wyświetlać tylko na stronie głównej sklepu, tylko na podstronach lub na wszystkich stronach sklepu. Od wybrania odpowiedniej opcji będzie zależało gdzie będzie wyświetlany dany moduł.<br />\r\n<br />\r\nOstatnie pola to <strong>opis modułu</strong> i <strong>co wyświetla</strong>. Są to pola informacyjne dla administratora sklepu, ułatwiające odnalezienie modułu w liście oraz identyfikujące co wyświetla dany moduł. Opis modułu jest widoczny przy dodawaniu modułu w wyglądzie sklepu (menu <strong>Wygląd / Ustawienia wyglądu</strong>) i ułatwia wybranie / znalezienie odpowiedniego modułu.<br />\r\n<br />\r\nOstatnia część formularza dodawania nowego modułu to <strong>Ustawienia RWD</strong>. W tej części można ustawić czy dany moduł może być wyświetlany w szablonach RWD (czasami budowa modułu uniemożliwia jego poprawne działania z technologii RWD i taki moduł należy wyłączyć dla szablonów RWD) oraz co ma się dziać z modułem przy małych rozdzielczościach w takich szablonach (poniżej 760px szerokości ekranu). Jeżeli moduł może działać w szablonach RWD to przy małych rozdzielczościach może być ukrywany lub może pozostawać bez zmian. Przy dużej ilości włączonych modułów warto jest odpowiednio skonfigurować wygląd modułów dla małych rozdzielczości - żeby np ma małym ekranie telefonu komórkowego nie wyświetlało się za dużo niepotrzebnych informacji - np bannerów, które przy małych rozdzielczościach są słabo widoczne.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_srodkowe_edycja.jpg\" style=\"width:450px;height:202px;margin-bottom:15px;margin-right:15px;float:left;\" />Edycja istniejącego modułu jest zbliżona do dodawania nowego modułu. Jednak podczas edycji nie ma możliwości wybrania rodzaju modułu Jest to parametr nieedytowalny. Dodatkowo podczas edycji niektóre moduły mają dodatkowe parametry do wyboru. Dodatkowe parametry są widoczne tylko podczas edycji modułu. Są one wyświetlane pomiędzy polem nazwa pliku, a opisem modułu.</div>\r\n"),
("85","407","0","instrukcja","Moduły stałe","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_stale.jpg\" style=\"width:450px;height:307px;margin-left:15px;margin-bottom:15px;float:right;\" />Moduły stałe w odróżnieniu od modułów środkowych są wyświetlane na każdej podstronie sklepu - nie tylko na stronie głównej. Poprzez swoją budowę - są tak jakby oderwane od całości układu sklepu i zachowują się niezależnie od innych elementów wyglądu sklepu. Tzn dzięki budowie zawsze znajdują się w tym samym miejscu ekranu - niezależnie od tego jak przewinięty zostanie sklep. Ich głównym zadaniem jest informowanie klienta i wyświetlanie określonych komunikatów. Standardowo w sklepie jest zainstalowane pięć modułów stałych.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\">Moduł <strong>Blokada 18+</strong> powoduje, że po wejściu na stronę wyświetla się komunikat z informacją, że strona przeznaczona jest dla osób dorosłych i aby wejść na stronę należy potwierdzić że jest się osobą pełnoletnią. Treść wyświetlanej informacji można zmienić w menu <strong>Konfiguracja / Tłumaczenia</strong> - sekcje MODULY_STALE. Moduł jest przewidziany dla sklepów które zgodnie z prawem muszą zamieszczać informację, że produkty w sklepie są przewidziane tylko dla osób pełnoletnich.</li>\r\n	<li style=\"text-align:justify;\">Moduł <strong>Informacja na górze sklepu</strong> - wyświetla informację o aktualizacji sklepu. Informacja jest wyświetlana na górze strony i nie można jej wyłączyć. Treść wyświetlanej informacji można zmienić w menu <strong>Konfiguracja / Tłumaczenia</strong> - sekcje MODULY_STALE - moduł jest przydatny jeżeli właściciel sklepu nie chce wyłączać sklepu ale także nie chce żeby klienci składali zamówienia.</li>\r\n	<li style=\"text-align:justify;\">Moduł <strong>Informacja o ciasteczkach (cookie)</strong> - wyświetla informację, że sklep korzysta z ciasteczek (cookies). Informacja jest wyświetlana na dole strony. Treść wyświetlanej informacji można zmienić w menu <strong>Konfiguracja / Tłumaczenia</strong> - sekcje MODULY_STALE. Taka informacja jest aktualnie wymagana przepisami polskiego prawa. Dodatkowo do wyświetlanej informacji zalecamy przygotowanie strony informacyjnej z opisem &quot;cookies&quot;. Treść przykładowej strony została umieszczona w instrukcji w rozdziale Standardowe treści stron informacyjnych. Tekst możecie Państwo skopiować i umieścić w sklepie,</li>\r\n	<li style=\"text-align:justify;\">Moduł <strong>Ostatnio oglądane produkty</strong> - wyświetlanie ostatnio oglądane przez klienta produkty - lista jest na stałe widoczna na dole ekranu. Listę można zwijać oraz rozwijać, żeby zobaczyć szczegóły nazw produktów,</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/newsletter_popup.jpg\" style=\"width:350px;height:193px;margin-bottom:15px;margin-left:15px;float:right;\" />Moduł <strong>Newsletter popup</strong> - wyświetla okno z możliwością zapisania się do newslettera. Klient w zamian za zapisanie się do newslettera otrzymuje kupon rabatowy o określonej wartości. Kupon rabatowy jest wysyłany na maila którego klient podał pod przy zapisywaniu się do newslettera. Kupon jest generowany losowo - jego długość to 10 znaków - kod kuponu może składać się z cyfr i dużych liter. Wygenerowany i wysłany do klienta kupon jest dodawany do kuponów rabatowych w menu <strong>Asortyment / Kupony rabatowe</strong> z informacją:&nbsp;Kupon za zapisanie do newslettera, email: .... Treść wyświetlanych w oknie newslettera informacji można zmienić w menu <strong>Konfiguracja / Tłumaczenia</strong> - sekcje MODULY_STALE. Ten moduł w odróżnieniu od pozostałych modułów stałych, oprócz możliwości włączenia i wyłączenia posiada dodatkowe opcje konfiguracyjne. Umożliwiają one zdefiniowanie poszczególnych parametrów modułu:\r\n	<ol>\r\n		<li style=\"text-align:justify;\"><strong>Newsletter który ma być użyty do wysłania maila</strong> - w tym miejscu z rozwijanej listy należy wybrać, który newsletter będzie używany do wysyłania maili do klientów. Kod rabatowy jest wysyłany w sklepie przy pomocy modułu newslettera. Kod kuponu rabatowego, który otrzyma klient zostanie umieszczony w treści newslettera. W liście rozwijanej widoczne są wszystkie newslettery stworzone w menu <strong>Sprzedaż / Newsletter / Newsletter</strong>. Stworzony newsletter może mieć dowolną treść, <span style=\"color:#FF0000;\">ważne jest tylko żeby w treści zawierał znacznik</span> <b>{KUPON_RABATOWY}</b> w miejsce którego zostanie wstawiony wygenerowany kod rabatowy. Dzięki takiemu rozwiązaniu można w dowolny sposób zdefiniować wygląd maila, który otrzyma klient po zapisaniu do newslettera,</li>\r\n		<li style=\"text-align:justify;\"><strong>Czy kupon ma mieć wartość kwotową czy procentową ?</strong> - w tym miejscu określa się czy kupon rabatowy ma mieć wartość procentową czy kwotową,</li>\r\n		<li style=\"text-align:justify;\"><strong>Wartość kuponu rabatowego</strong> - określa wartość kuponu rabatowego. Można w tym miejscu wpisać tylko wartości całkowite, kupon rabatowy nie może mieć wartości ułamkowej,</li>\r\n		<li style=\"text-align:justify;\"><strong>Minimalna wartość zamówienia od jakiej będzie mógł być zrealizowany kupon</strong> - określa minimalną wartość zamówienia od jakiej klient będzie mógł wykorzystać kupon rabatowy. Pozostawienie pola pustego spowoduje, że kupon rabatowy będzie można zrealizować dla dowolnej wartości zamówienia. Informacja o minimalnej wartości zamówienia będzie wyświetlana w treści okna zapisania się do newslettera,</li>\r\n		<li style=\"text-align:justify;\"><strong>Czy po zamknięciu okna newslettera minimalizować moduł do zakładki ?</strong> - włączenie opcji na - <strong>tak</strong> - powoduje, że po zamknięciu przez klienta okna popup newslettera jest on minimalizowany do bocznej zakładki (lewego dolnego narożnika) - dzięki temu klient w dowolnym momencie może kliknąć w ikonę zakładki i ponownie otworzyć okno popup newslettera.</li>\r\n	</ol>\r\n	</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_stale_lista.jpg\" style=\"width:550px;height:131px;margin-bottom:15px;margin-right:15px;float:left;\" />Moduły stałe są to skrypty / pliki języka programowania php i składają się z kodu który wyświetla określone dane / informacje. Pliki modułów stałych znajdują się w katalogu o nazwie /moduly_stale w głównym katalogu sklepu. Jeżeli do sklepu będzie dodawany nowy moduł musi być także wgrany do tego katalogu.<br />\r\n<br />\r\nModułami stałymi zarządza się poprzez menu <strong>Wygląd / Moduły stałe</strong>. Po wejściu w opisywane menu wyświetli się lista dostępnych w sklepie modułów. Każdy moduł w listingu jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla id modułu w bazie sklepu. Druga kolumna wyświetla nazwę modułu. W przeciwieństwie do modułów środkowych, nazwa ma tylko charakter informacyjny i nie jest wyświetlana w sklepie. Jest to wyłącznie informacja dla administratora sklepu. Podobnie kolejna kolumna - opis modułu - ma tylko charakter informacyjny dla administratora sklepu. Przedostatnia kolumna wyświetla informacje czy moduł jest wyświetlany w sklepie - kolor zielony ikonki oznacza, że moduł jest aktywny i będzie wyświetlany w sklepie, kolor szary oznacza, że moduł nie został wybrany do wyświetlania. Włączenia wyświetlania modułu dokonuje się podczas edycji modułu. Jest to istotna różnica w stosunku do modułów środkowych które włącza się do wyświetlania w menu <strong>Wygląd / Ustawienia wyglądu</strong>. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję modułu lub jego usunięcie.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_stale_dodawanie.jpg\" style=\"width: 440px; height: 266px; float: left; margin-bottom: 15px; margin-right: 15px;\" />Nowy moduł stały dodaje się w menu <strong>Wygląd / Moduły stałe</strong> poprzez kliknięcie w przycisk <strong>dodaj nowy moduł</strong>. Po kliknięciu otworzy się strona z formularzem dodawania nowego modułu. Pierwszym i obowiązkowym pole do wypełnienia jest nazwy modułu. Ponieważ nazwa nie jest wyświetlana po stronie sklepu - wpisuje się ją tylko w języku domyślnym sklepu. Podobnie opis modułu. Kolejne pole to nazwa pliku modułu - w polu tym trzeba wpisać nazwę pliku php jaki będzie odpowiedzialny za działanie modułu. Plik musi się znajdować w katalogu /moduly_stale w głównym katalogu sklepu. Ostatnie pole to opcja - czy dany moduł ma być wyświetlany w sklepie czy ma być wyłączony ? Formularz edycji jest identyczny jak w przypadku dodawania nowego modułu.</div>\r\n"),
("86","553","1","instrukcja","Kopiowanie","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/moduly_wysylki_duplikuj.jpg\" style=\"width:323px;height:113px;float:right;margin-left:15px;margin-bottom:15px;\" />Opcja duplikowania modułu wysyłki umożliwia utworzenie dokładnej kopii, wybranej metody wysyłki. W wyniku tej operacji zostanie utworzony kolejny moduł wysyłki z ustalonymi z góry wszystkimi parametrami tak jak to było w module, który był duplikowany.<br />\r\n	<br />\r\n	Po utworzeniu kopii modułu można go edytować wprowadzając niezbędne zmiany w ustawieniach, np. zmienić tekst wyświetlany klientowi, zmienić listę krajów do których dana wysyłka będzie dostępna, itp.<br />\r\n	<br />\r\n	Dzięki możliwości kopiowania modułów wysyłek można niemalże dowolnie skonfigurować w sklepie dostępne wysyłki, stawki za przesyłkę itp. ustawienia. W programie nie ma ograniczenia ilości utworzonych modułów wysyłek.</div>\r\n"),
("87","560","0","instrukcja","Płatności","<div style=\"text-align:justify;\">Moduł płatności, to jeden z podstawowych obok wysyłek modułów działających w sklepie od strony klienta. Umożliwia on w trakcie realizacji zamówienia wybranie klientowi sposobu w jaki dokona płatności za zamówiony towar. Moduł ten łączy się w sposób nierozerwalny z modułem wysyłek. Dostępne dla klienta płatności są zależne od tego jaką w danym momencie wybiera formę dostawy. W tym rozdziale zostanie omówiony sposób działania modułu umożliwiającego obsługę płatności.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci.jpg\" style=\"float:right;width:642px;height:315px;margin-left:15px;margin-bottom:15px;\" />Po wybraniu w menu pozycji <strong>Moduły / Płatności</strong> wyświetlona zostanie lista wszystkich zdefiniowanych w programie modułów płatności.<br />\r\n<br />\r\nLista zawiera podstawowe informacje o każdej zdefiniowanej metodzie płatności. W pierwszej kolumnie jest <strong>id</strong> jaki dany moduł posiada w bazie danych. W drugiej kolumnie wyświetlana jest robocza nazwa modułu (widoczna tylko w panelu administracyjnym sklepu). Trzecia kolumna to opis według jakiego sposobu są obliczane koszty płatności - szczegółowo zostało to opisane w instrukcji w części dotyczącej edycji modułu płatności. Kolejne kolumny przedstawiają odpowiednio minimalny koszt płatności, minimalną wartość zamówienia od której dana płatność jest dostępna, maksymalną wartość zamówienia, kwotę do jakiej dana płatność jest dostępna. Dalej jest jej kolejność wyświetlania na liście płatności oraz aktualny status - to znaczy czy płatność jest włączona i dostępna w sklepie, czy jest wyłączona. Ostatnia kolumna zawiera ikony nawigacyjne, które pozwalają na wykonywanie określonych akcji związanych z dana płatnością. Wysyłkę można tylko edytować - nie ma możliwości jej usunięcia ani powielenia .</div>\r\n"),
("88","561","1","instrukcja","Edycja - ustawienia ogólne","<div style=\"text-align:justify;\">Klikając w ikonę edycji płatności przechodzimy do rozbudowanego formularza, a którym można ustawić wszelkie parametry związane z daną płatnością. W zależności od edytowanej formy płatności formularz może zawierać nieco odmienne pola specyficzne dla danej metody płatności.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_edycja1.jpg\" style=\"float:left;width:504px;height:363px;margin-right:15px;margin-bottom:15px;\" />W pierwszej część tego formularza są informacje tekstowe, które widoczne są dla klienta robiącego zakupy w sklepie. W pierwszym polu wpisana jest robocza nazwa danej płatności - widoczna tylko w panelu administracyjnym.<br />\r\n<br />\r\nKolejne pola (które należy wypełniać we wszystkich językach, które są obsługiwane w sklepie) to:<br />\r\n<br />\r\n<strong>Treść wyświetlana w sklepie</strong> pod taką nazwą jaka zostanie w tym miejscu wpisana płatność jest wyświetlana klientowi podczas zamówienia.<br />\r\n<br />\r\n<strong>Treść objaśnienia w sklepie</strong> to pole nie jest obowiązkowe do wypełnienia. Jeżeli zostanie tu wpisana treść, to będzie ona w sklepie wyświetlana w chmurce po najechaniu myszką przez klienta na daną płatność w zamówieniu. <img alt=\"alt\" height=\"109\" src=\"obrazki/pomoc/moduly_platnosci_chmurka.jpg\" style=\"float:right;margin-left:15px;margin-top:15px;margin-bottom:15px;\" width=\"254\" />Ostatnim z pól tekstowych, które można wprowadzić dla płatności jest <strong>Opis wyświetlany w przed potwierdzeniem zamówienia</strong>. Jest to również nie obowiązkowe pole, które jeżeli jest wypełnione to jego treść jest wyświetlana w dodatkowych informacjach o płatności na stronie potwierdzenia zamówienia. Można tu wprowadzić dowolną treść, którą chcemy przekazać klientowi w procesie składania zamówienia. Informacja ta jest również w mailu, który jest wysyłany do klienta z potwierdzeniem złożenia zamówienia. W przypadku płatności przelewem można tutaj np. wpisać szczegóły dotyczące rachunku, na który klient ma wpłacić pieniądze za złożone zamówienie.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_edycja2.jpg\" style=\"float: right; width: 554px; height: 234px; margin-left: 15px; margin-bottom: 15px;\" />Kolejne pola formularza dotyczą już szczegółów związanych z funkcjonowaniem i zasadami ustalania dostępności danej metody płatności. Dostępne są tutaj takie informacje jak: kolejność wyświetlania płatności w koszyku klienta, status - czy płatność jest włączona w sklepie czy nie. Można ustawić progi wartości zamówienia od jakiej i do jakiej wartości dana metoda płatności będzie dostępna. Jeżeli wartość zamówienia nie zawiera się w zdefiniowanym przedziale, to wówczas dana płatność jest niewidoczna dla klienta.<br />\r\n<br />\r\nDla każdego rodzaju płatności można również zdefiniować związany z nią koszt. Szczególnie dotyczy to płatności on-line lub płatności ratalny, w których obsługa sklepu chce przerzucić koszty związane z obsługą tych płatności (prowizja, koszty dostarczenia wniosków, itp.) na klienta sklepu.<br />\r\n<br />\r\nKoszt płatności może mieć różne formy - może to być stała opłata, wartość procentowa lub też może zostać wyliczana według wzoru matematycznego. Poniżej znajduje się tabelka opisująca możliwe sposoby ustalania kosztu płatności.<br />\r\n&nbsp;\r\n<table>\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"text-align:center;\"><strong><span>Wartość pola</span></strong></td>\r\n			<td style=\"text-align:center;\"><strong><span>Format</span></strong></td>\r\n			<td style=\"text-align:center;\"><strong><span>Opis</span></strong></td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:center;\">&nbsp;</td>\r\n			<td style=\"text-align:center;\">pole puste lub 0</td>\r\n			<td style=\"text-align:center;\">koszt płatności wynosi 0</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:center;\"><code>11.50</code></td>\r\n			<td style=\"text-align:center;\">liczba</td>\r\n			<td style=\"text-align:center;\">koszt płatności wynosi 11,50, niezależnie od wartości zamówienia</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:center;\"><code>x*0.035</code></td>\r\n			<td style=\"text-align:center;\">x, znak mnożenia, liczba</td>\r\n			<td style=\"text-align:center;\">koszt płatności zostanie wyliczony wg wzoru:<br />\r\n			<code>(wartosc_produktow + koszt_dostawy) * 0,035</code></td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:center;\"><code>x*0.035+11.50</code></td>\r\n			<td style=\"text-align:center;\">x, znak mnożenia, liczba, znak plus, liczba</td>\r\n			<td style=\"text-align:center;\">koszt płatności zostanie wyliczony wg wzoru:<br />\r\n			<code>(wartosc_produktow + koszt_dostawy) * 0,035 + 11,50</code></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<span style=\"color:#ff0000;\">Uwaga: Płatność może być dodatkowym kosztem dodawanym do wysyłki. Dotyczy to zwłaszcza kosztów obsługi płatności elektronicznych lub ratalnych</span>.<br />\r\n<br />\r\nW takim przypadku klient jako łączny koszt dostawy w sklepie widzi koszt wysyłki + ustalony koszt obsługi płatności.</div>\r\n"),
("89","562","1","instrukcja","Edycja - płatności PayU","W przypadku modułu płatności obsługiwanego przez serwis PayU należy wprowadzić dodatkowe specyficzne parametry w ustawieniach modułu.<br />\r\n<br />\r\nPrzed rozpoczęciem konfiguracji modułu w sklepie należy:\r\n<ol>\r\n	<li>Posiadać podpisaną umowę z serwisem PayU i aktywne konto</li>\r\n	<li>W serwisie PayU należy utworzy nowy punkt płatności, który będzie obsługiwał sklep</li>\r\n</ol>\r\nPodczas definiowania punktu płatności w serwisie PayU należy wprowadzić następujące parametry :\r\n\r\n<ol>\r\n	<li>Wariant współpracy: Protected Payment</li>\r\n	<li>Kodowanie danych: UTF-8</li>\r\n	<li>Adres powrotu - błąd: http://www.adres.sklepu.pl/platnosc_koniec.php?typ=payu&amp;status=FAIL&amp;error=%error%&amp;zamowienie_id=%orderId%</li>\r\n	<li><span id=\"posEditForm:posEncodingPanel\"><span id=\"posEditForm:posUrlPanel\">Adres powrotu - poprawnie: </span></span>http://www.adres.sklepu.pl/platnosc_koniec.php?typ=payu&amp;status=OK&amp;zamowienie_id=%orderId%</li>\r\n	<li><span id=\"posEditForm:posEncodingPanel\"><span id=\"posEditForm:posUrlPanel\">Adres raportów: </span></span>http://www.adres.sklepu.pl/moduly/platnosc/raporty/payu/raport.php</li>\r\n	<li>Należy zaznaczyć kanały płatności, które mają być dostępne dla klientów. <span style=\"color:#ff0000;\">W celu przetestowania poprawności działania modułu w sklepie można w ustawieniach punkt płatności włączyć kanał TESTOWY - wówczas wszystkie tranzkacje dokonane za pośrednictwem tego kanału nie będą rzeczywiście realizowane przez serwis PayU.</span></li>\r\n</ol>\r\n&nbsp;\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_payu.jpg\" style=\"float: left; width: 469px; height: 425px;\" />Po utworzeniu punktu płatności można przystąpić do konfigurowania modułu w sklepie. Po wybraniu edycji tego modułu - poza standardowymi polami w formularzu znajdują się dodatkowe pola specyficzne dla tego modułu płatności.<br />\r\n<br />\r\nDane: pos_id, pos_auth_key, key1 oraz key2 należy dokładnie przepisać z ustawień punktu płatności w serwisie PayU.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_payu_historia.jpg\" style=\"float:right;margin-top:15px;width:201px;height:112px;margin-left:15px;\" /></div>\r\n\r\n<div style=\"text-align:justify;\">Dodatkowo można ustawić status zamówienia jaki zostanie automatycznie ustawiony po otrzymaniu z serwisu PayU informacji o zakończeniu płatności. W takim przypadku jeśli serwis PayU przekaże tę informacje, to status zamówienia zostanie ustawiony na zdefiniowany w konfiguracji.<br />\r\n<br />\r\nSzczegóły dotyczące całej historii transakcji są zapisywane w komentarzu do zamówienia.</div>\r\n"),
("90","415","0","instrukcja","Ankiety","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/box_ankieta.jpg\" style=\"width:200px;height:189px;float:left;margin-bottom:15px;margin-right:15px;\" />Jednym ze sposobów poznania czego oczekują od sklepu klienci są ankiety. Umożliwiają one zebranie niezbędnych informacji, które mają wpływ na sprzedaż w sklepie. Można zapytać klientów co sądzą o obsłudze sklepu, o produktach, jakich zmian oczekiwaliby w sklepie ? W sklepie ankiety są wyświetlane w formie boxu. <img alt=\"alt\" src=\"obrazki/pomoc/ankieta_sklep.jpg\" style=\"width:300px;height:111px;margin:10px;float:right;\" />W boxie wyświetlane jest pytanie oraz możliwe do wyboru odpowiedzi. Klient może wybrać jeden wariant i zagłosować. Po oddaniu głosu klient może przejść do szczegółów ankiety i zobaczyć jakie są wyniki głosowań.<br />\r\n<br />\r\nW sklepie można dodać wiele ankiet - po stronie sklepu jest wyświetlana w boxie tylko jedna ankieta. Ankiety mogą wyświetlać się w boxie losowo lub wg daty dodania. Konfiguracja ankiet w sklepie znajduje się w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia ankiet</strong>. Oprócz wyboru sposobu wyświetlania ankiet z boxie można wybrać czy klient może zagłosować w ankiecie tylko raz czy może wielokrotnie.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/ankiety_lista.jpg\" style=\"width:550px;height:190px;margin-left:15px;margin-bottom:15px;float:right;\" />W panelu zarządzania ankiety obsługuje się w menu <strong>Wygląd / Ankiety</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu ankiet. W liście ankiety są domyślnie posortowane wg daty dodania. Powyżej okna z biuletynami znajduje się pole wyszukiwania. Umożliwia ono wyszukanie wybranej ankiety.<br />\r\n<br />\r\nPoniżej wyszukiwarki znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania ankiet w listingu. Poniżej znajduje się przycisk <strong>dodawania nowej ankiety</strong>.&nbsp;<br />\r\n<br />\r\nW liście każda ankieta jest wyświetlana jako w osobnym wierszu. Pierwsza kolumna wyświetla nr id ankiety. W kolejnej kolumnie wyświetlana jest nazwa ankiety (jest ona wyświetlana w boxie jako pytanie oraz jako nagłówek na stronie wyników ankiety). Następna kolumna to data dodania ankiety. Wg tego pola można sortować ankiety w listingu. Kolejna kolumna jest bardziej rozbudowana i wyświetla wyniki ankiety. Wyświetlane są odpowiedzi jakie zawiera ankieta oraz wyniki głosowań. Dane są prezentowane w formie graficznej oraz liczbowej (ilość oddanych głosów oraz udział procentowy w całości oddanych głosów). Kolejna kolumna określa czy ankieta ma być widoczna dla wszystkich klientów. Kolor zielony ikonki oznacza, że ankieta jest widoczna dla wszystkich klientów, kolor szary oznacza, że tylko dla klientów zalogowanych. Zmiany widoczności ankiety dla klientów dokonuje się poprzez kliknięcie na ikonkę - jeżeli ma status dla wszystkich -&nbsp; to po kliknięciu zostanie zmieniona na widoczna tylko dla zalogowanych i odwrotnie jeżeli ma status - tylko dla zalogowanych - po kliknięciu będzie widoczna dla wszystkich. Przedostatnia kolumna wyświetla status ankiety - czy jest wyświetlana w sklepie czy nie. Zielona ikonka oznacza, że ankieta jest wyświetlana w sklepie, szara, że jest nieaktywna. Zmianę aktywności (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę aktywności. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję ankiety, jej usunięcie lub wyświetlanie szczegółów ankiety. Ikona szczegółów ankiety (zielona ikonka z literką i) wyświetla podstronę ze szczegółowymi wynikami ankiety we wszystkich wersjach językowych. Dane podobnie jak w listingu są prezentowane w formie graficznej oraz liczbowej.</div>\r\n"),
("91","563","1","instrukcja","Edycja - płatności DotPay","W przypadku modułu płatności obsługiwanego przez serwis DotPay należy wprowadzić dodatkowe specyficzne parametry w ustawieniach modułu.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"240\" src=\"obrazki/pomoc/moduly_platnosci_dotpay_URLC.jpg\" style=\"margin-left:15px;margin-bottom:15px;float:right;\" width=\"386\" />Przed rozpoczęciem konfiguracji modułu w sklepie należy:\r\n<ol>\r\n	<li>Posiadać podpisaną umowę z serwisem DotPay i aktywne konto</li>\r\n	<li>W serwisie DotPay należy w ustawieniach Ustawienia / Parametry URLC wpisać 16 znakowy PIN dla potwierdzeń</li>\r\n	<li>W serwisie DotPay należy w ustawieniach Ustawienia / Parametry URLC zaznaczyć opcję &quot;Zezwól na przyjęcie parametru URLC z zewnętrznego serwisu&quot;. Jednocześnie należy pozostawić puste pole na wpisanie adresu URLC.</li>\r\n</ol>\r\nPo utworzeniu Takim skonfigurowaniu opcji w serwisie DotPay można przystąpić do konfigurowania modułu w sklepie. Po wybraniu edycji tego modułu - poza standardowymi polami w formularzu znajdują się dodatkowe pola specyficzne dla tego modułu płatności.\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nDane: ID w serwisie DotPay, PIN do potwierdzeń należy dokładnie przepisać z ustawień w serwisie DotPay.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" height=\"89\" src=\"obrazki/pomoc/moduly_platnosci_dotpay.jpg\" style=\"margin-bottom:15px;margin-right:15px;float:left;\" width=\"422\" />Dodatkowo można ustawić status zamówienia jaki zostanie automatycznie ustawiony po otrzymaniu z serwisu DotPay informacji o zakończeniu płatności. W takim przypadku jeśli serwis DotPay przekaże tę informacje, to status zamówienia zostanie ustawiony na zdefiniowany w konfiguracji.<br />\r\n<br />\r\nSzczegóły dotyczące całej historii transakcji są zapisywane w komentarzu do zamówienia.&nbsp;</div>\r\n"),
("92","564","1","instrukcja","Edycja - płatności Przelewy24","<div style=\"text-align:justify;\">W przypadku modułu płatności obsługiwanego przez serwis Przelewy24 należy wprowadzić dodatkowe specyficzne parametry w ustawieniach modułu.<br />\r\n<br />\r\nPrzed rozpoczęciem konfiguracji modułu w sklepie należy posiadać podpisaną umowę z serwisem Przelewy24 i aktywne konto.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_przelewy24.jpg\" style=\"margin-bottom: 15px; margin-top: 15px; margin-right: 15px; float: left; width: 403px; height: 260px;\" />Moduł obsługujący płatności za pośrednictwem serwisu Przelewy24 umożliwia przed jego produkcyjnym uruchomieniem przetestowanie w warunkach symulujących rzeczywiste operacje.<br />\r\n<br />\r\nW tym celu należy w serwisie Przelewy24 przejść do zakładki &quot;Moje dane&quot; -&gt; &quot;Konto w SANDBOX&quot; gdzie znajdą Państwo wskazówki, jak utworzyć konto testowe. Konto testowe otrzyma te same dane do logowania, co konto produkcyjne. Jeśli chcą Państwo zmienić hasło logowania w systemie sandbox, proszę się tam zalogować i w zakładce &quot;moje dane&quot; -&gt; &quot;zmiana hasła&quot; dokonać modyfikacji hasła. Do przetestowania działania płatności należy w ustawieniach modułu w sklepie zaznaczyć opcje <strong>Tryb testowy - Tak</strong>. W środowisku testowym każda transakcja zostaje automatycznie uznana za prawidłową. <span style=\"color:#ff0000;\">Środowisko testowe nie może być wykorzystywane do realizacji transakcji produkcyjnych</span>.<br />\r\n<br />\r\nDodatkowe pola, które należy uzupełnić w trakcie edycji modułu w sklepie to ID posiadany w serwisie Przelewy24 oraz klucz potwierdzający CRC. W panelu transakcyjnym, w zakładce &quot;Moje dane&quot; jest ciąg o nazwie &bdquo;Klucz do CRC&rdquo;. Wartość z tego pola (16 znaków alfanumerycznych) należy wpisać w ustawieniach modułu w sklepie.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"216\" src=\"obrazki/pomoc/moduly_platnosci_przelewy24_historia.jpg\" style=\"float:right;margin-left:15px;\" width=\"507\" />Dodatkowo można ustawić status zamówienia jaki zostanie automatycznie ustawiony po otrzymaniu z serwisu Przelewy24 informacji o zakończeniu płatności. W takim przypadku jeśli serwis Przelewy24 przekaże tę informacje, to status zamówienia zostanie ustawiony na zdefiniowany w konfiguracji.<br />\r\n<br />\r\nSzczegóły dotyczące całej historii transakcji są zapisywane w komentarzu do zamówienia.</div>\r\n"),
("93","416","0","instrukcja","Dodawanie / edycja ankiety","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/ankiety_dodawanie.jpg\" style=\"width:450px;height:524px;float:right;margin-left:15px;margin-bottom:15px;\" />Nową ankietę dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową ankietą</strong>. Po kliknięciu zostanie wyświetlony formularz dodawania nowej ankiety.<br />\r\n<br />\r\nPrzy dodawaniu nowej ankiety są osobne formularze dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka.<br />\r\n<br />\r\nPrzy dodawaniu nowej ankiety - dana ankieta może mieć różne pytania i odpowiedzi dla poszczególnych języków. Ankiety w poszczególnych językach mogą mieć także różną ilość głosów - poszczególne odpowiedzi z języków nie muszą się pokrywać.<br />\r\n<br />\r\nW pierwszej części formularza należy podać nazwę ankiety (jest ona wyświetlana w boxie jako pytanie oraz jako nagłówek na stronie wyników ankiety). Jeżeli nie zostanie uzupełniona nazwa ankiety w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka. Kolejne pola to pola meta tagów - każda ankieta może mieć indywidualne meta tagi. Dalej znajduje się pole edytora do wpisania opisu ankiety - nie jest to pole wymagane ale dobrze jeżeli ankieta będzie miała opis. Opis jest wyświetlany w sklepie po wejściu w szczegóły ankiety (wyniki ankiety).<br />\r\n<br />\r\nPoniżej znajdują się pola możliwych odpowiedzi. Każda ankieta może mieć do 10 odpowiedzi. Przy każdej odpowiedzi można wpisać także ilość oddanych głosów. Tworząc ankietę można wpisać do każdej odpowiedzi określoną ilość głosów - dzięki czemu klienci w sklepie będą sądzili, że wielu klientów już zagłosowało w ankiecie i może zachęcić to klientów do oddania głosu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Edycja istniejącego formularza jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu. Można dowolnie modyfikować nazwę ankiety oraz pola.</div>\r\n"),
("94","565","1","instrukcja","Edycja - płatności PayByNet","<div style=\"text-align:justify;\">W przypadku modułu płatności obsługiwanego przez serwis PayByNet należy wprowadzić dodatkowe specyficzne parametry w ustawieniach modułu.<br />\r\n<br />\r\nPrzed rozpoczęciem konfiguracji modułu w sklepie należy posiadać podpisaną umowę z serwisem PayByNet i aktywne konto.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_pbn.jpg\" style=\"margin-bottom: 15px; margin-top: 15px; margin-right: 15px; float: left; width: 420px; height: 496px;\" />Moduł obsługujący płatności za pośrednictwem serwisu PayByNet umożliwia przed jego produkcyjnym uruchomieniem przetestowanie w warunkach symulujących rzeczywiste operacje.<br />\r\n<br />\r\nW tym celu należy w ustawieniach modułu zaznaczyć opcję <strong>Czy włączyć tryb testowy - Tak</strong>. <span style=\"color:#ff0000;\">Środowisko testowe nie może być wykorzystywane do realizacji transakcji produkcyjnych</span>.<br />\r\n<br />\r\nDane wykorzystywane w środowisku testowym są następujące:<br />\r\n<br />\r\n<font face=\"sans-serif\" size=\"2\">Po przejściu do serwisu PayByNet trzeba wybrać bank testowy i podać dane do logowanie takie jak poniżej:</font><br />\r\n<br />\r\n<font face=\"sans-serif\" size=\"2\">login: Adam</font><br />\r\n<font face=\"sans-serif\" size=\"2\">hasło: 123</font><br />\r\n<font face=\"sans-serif\" size=\"2\">kod: 2222</font><br />\r\n<br />\r\nDodatkowe pola, które należy uzupełnić w trakcie edycji modułu w sklepie to Identyfikator klienta - jest nim numer NIP zapisany bez spacji i myślników, hasło w serwisie PayByNet oraz dane sprzedawcy towarów, który podpisał z Izbą umowę o świadczenie usługi PayByNet. Należy także podać czas w minutach przez jaki dana transakcja jest ważna (na tej podstawie jest wyliczana dokładna data i godzina, do której należy dokonać płatności pod rygorem odstąpienia przez Sprzedawcę od umowy kupna-sprzedaży).<br />\r\n<br />\r\nDodatkowo można ustawić status zamówienia jaki zostanie automatycznie ustawiony po otrzymaniu z serwisu <font face=\"sans-serif\" size=\"2\">PayByNet </font>informacji o zakończeniu płatności. W takim przypadku jeśli serwis <font face=\"sans-serif\" size=\"2\">PayByNet </font>przekaże tę informacje, to status zamówienia zostanie ustawiony na zdefiniowany w konfiguracji.<br />\r\n&nbsp;</div>\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_pbn_historia.jpg\" style=\"width:322px;height:173px;float:right;margin-left:15px;margin-right:15px;\" /> <strong>WAŻNE: W celu uruchomienia koniecznej jest przekazanie do KIR adresu URL na który mają być wysyłane statusy transakcji</strong> - jest następujący adres:<br />\r\n&nbsp;\r\n<div style=\"text-align:center;\">http://www.adres.sklepu.pl/moduly/platnosc/raporty/pbn/raport.php</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nSzczegóły dotyczące całej historii transakcji są zapisywane w komentarzu do zamówienia.</div>\r\n"),
("95","566","1","instrukcja","Edycja - płatności PayPal","<div style=\"text-align:justify;\">W przypadku modułu płatności obsługiwanego przez serwis PayPal należy wprowadzić dodatkowe specyficzne parametry w ustawieniach modułu.<br />\r\n<br />\r\nPrzed rozpoczęciem konfiguracji modułu w sklepie należy posiadać podpisaną umowę z serwisem PayPal i aktywne konto. Jeżeli nie posiadają Państwo jeszcze konta w serwisie PayPal, to można je założyć klikając w ten <strong><a href=\"http://www.paypal.com/pl/webapps/mpp/referral/paypal-business-account2?partner_id=Z2VRCMMKFCYRU\" target=\"_blank\"><span style=\"color:#FF0000;\">link</span></a></strong>.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nModuł obsługujący płatności za pośrednictwem serwisu PayPal umożliwia przed jego produkcyjnym uruchomieniem przetestowanie w warunkach symulujących rzeczywiste operacje.<br />\r\n<br />\r\nW tym celu należy w ustawieniach modułu zaznaczyć opcję <strong>Czy włączyć tryb testowy - Tak</strong>. Ponadto należy utworzyć testowe konto w serwisie PayPal. Konto takie można utworzyć pod adresem - https://www.sandbox.paypal.com/pl/webapps/mpp/home<br />\r\n<br />\r\nUWAGA: Konto utworzone w serwisie SANDBOX nie powoduje żadnych faktycznych operacji finansowych i nie może być używane do rzeczywistego realizowania transakcji.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/moduly_platnosci_paypal.jpg\" style=\"float: left; margin: 10px; width: 410px; height: 321px;\" />Dodatkowe pola, które należy uzupełnić w trakcie edycji modułu w sklepie to dane umożliwiające dostęp użytkownika do API w serwisie PayPal.<br />\r\n<br />\r\nDodatkowo można ustawić status zamówienia jaki zostanie automatycznie ustawiony po otrzymaniu z serwisu PayPal informacji o zakończeniu płatności. W takim przypadku jeśli serwis PayPal przekaże tę informacje, to status zamówienia zostanie ustawiony na zdefiniowany w konfiguracji.<br />\r\nMożna także podać obrazek logo, który będzie wyświetlany na stronie serwisu PayPal podczas dokonywania płatności.<br />\r\n<br />\r\nSzczegóły dotyczące całej historii transakcji są zapisywane w komentarzu do zamówienia.<br />\r\n<br />\r\n<span style=\"color:#FF0000;\"><strong>W celu zapewnienia poprawności funkcjonowania odbierania potwierdzeń o płatnościach należy w serwisie PayPal ustawić domyślną stronę kodową UTF-8.</strong></span><br />\r\n<br />\r\n<strong>Ustawienie strony kodowej w panelu PayPal.</strong><br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/moduly_platnosci_paypal_kodowanie.jpg\" style=\"float: left; margin: 15px; width: 382px; height: 191px;\" />1. Zalogować się do serwisu PayPal.<br />\r\n2. Kliknąć zakładkę <em>Profil</em>.<br />\r\n3. Następnie wybrać opcję <em>Moje narzędzia sprzedaży</em>.<br />\r\n4. Na dole strony kliknąć w link <em>Kodowanie języka przycisków PayPal</em>.<br />\r\n5. Kliknąć przycisk <em>Więcej opcji</em>.<br />\r\n6. Po wybraniu tej opcji wyświetlony zostanie formularz, na którym można ustawić kodowanie w jakim będą przesyłane dane.<br />\r\n7. Po ustawieniu poprawnych wartości należy zapisać informacje.<br />\r\n<br />\r\n<br />\r\n<br />\r\n<strong>Uzyskiwanie danych do API w serwisie PayPal.</strong><br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/moduly_platnosci_paypal_api.jpg\" style=\"margin: 10px; float: right;\" />W celu uzyskania danych umożliwiających korzystanie z płatności w serwisie PayPal należy zalogować się na swoje konto na stronie www.paypal.pl<br />\r\nNastępnie w menu należy wybrać opcję <strong>Profil &gt; Więcej opcji</strong>. Na wyświetlonej stronie w menu po lewej stronie klikamy pozycję <strong>Moje narzędzia sprzedaży</strong>.<br />\r\nPo kliknięciu w link <strong>Dostęp do API </strong><em>Zaktualizuj</em> wyświetlona zostanie strona na której użytkownik mado wyboru dwie opcje.<br />\r\nWybieramy opcję numer 2 - <strong>Opcja 2 </strong>- Zażądaj uprawnień dostępu do API, aby utworzyć własną nazwę użytkownika oraz hasło API.<br />\r\nWystarczy kliknąć w link <strong>Wyświetl podpis API</strong>. Zostaną wówczas wyświetlone informacje, które umożliwiają realizację płatności ze sklepu poprzez API serwisu PayPal. Dane te należy wprowadzić w ustawieniach modułu płatności w sklepie w menu <strong>Moduły / Płatności / PayPal</strong>.<br />\r\n<br />\r\nStrona zawierająca dane do konfiguracji modułu płatności w sklepie.<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/moduly_platnosci_paypal_api1.jpg\" style=\"margin: 10px; float: left;\" /></div>\r\n"),
("96","425","0","instrukcja","Formularze","<div style=\"text-align:justify;\">Formularze są w sklepie bardzo istotnym elementem. Służą one do komunikowania się klienta z obsługą sklepu przy pomocy e-maili. W sklepie klient przy pomocy formularza można wypełnić określone w formularzu pola i wysłać do administratora sklepu wiadomość.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/formularze_lista.jpg\" style=\"width: 550px; height: 188px; margin-left: 15px; margin-bottom: 15px; float: right;\" />W sklepie można dodać wiele formularzy. Obsługa formularzy w panelu zarządzania odbywa się poprzez menu <strong>Wygląd / Formularze</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu formularzy. W liście formularze są domyślnie posortowane wg nazwy. Powyżej okna z formularzami znajduje się pole wyszukiwania. Umożliwia ono wyszukanie wybranego formularza. Dodatkowo można wybrać z listy grupę klientów - wyświetlone zostaną wtedy tylko formularze dostępne dla danej grupy klientów.<br />\r\n<br />\r\nPoniżej wyszukiwarki znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania formularzy w listingu. Poniżej znajduje się przycisk <strong>dodawania nowego formularza</strong>.<br />\r\n<br />\r\nW liście każdy formularz jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla nr id formularza. W kolejnej kolumnie wyświetlana jest nazwa formularza (jest ona wyświetlana jako nagłówek na stronie formularza w sklepie). Kolejna kolumna wyświetla nazwy grup klientów dla jakich dostępny jest dany formularz. Jeżeli wyświetlany jest znak - minusa - oznacza to, że formularz jest dostępny dla wszystkich klientów. Przedostatnia kolumna wyświetla status formularza - czy jest wyświetlany w sklepie czy nie. Zielona ikonka oznacza, że formularz jest wyświetlany w sklepie, szara, że jest nieaktywny. Zmianę aktywności (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę aktywności. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję formularza lub jego usunięcie.<br />\r\n<br />\r\nPo stronie sklepu linki do formularzy mogą być widoczne w górnym i dolnym menu oraz linkach stopki. Podczas dodawania tych elementów można wybrać link do formularza.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Standardowo w sklepie są zdefiniowane na stałe 4 formularze. Nie można ich usunąć ze sklepu - można jedynie dokonać edycji pól formularzy. Standardowo w sklepie są zdefiniowane formularze:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Kontakt</strong> - jest to formularz kontaktowy - umożliwia przesłanie do administratora sklepu dowolnej wiadomości.</li>\r\n	<li style=\"text-align:justify;\"><strong>Poleć znajomemu</strong> - jest to formularz, który umożliwia przesłanie przez klienta sklepu innej osobie wiadomości na temat produktu. Link do formularza jest wyświetlany na karcie produktu. Klient do którego jest wysyłana wiadomość otrzymuje w treści maila link do danego produktu oraz opis klienta, który wysyłał wiadomość.</li>\r\n	<li style=\"text-align:justify;\"><strong>Wyślij nam Twoją propozycję cenową</strong> - jest to formularz, który umożliwia przesłanie przez klienta do właściciela sklepu własnej oferty cenowej na dany produkt. Ten formularz jest powiązany z opcją negocjacji cen przy produktach. Jeżeli produkt ma włączoną możliwość negocjacji cen - to klient może przy pomocy tego formularza wysłać swoją propozycję cenową na produkt. Link do formularza jest wyświetlany na karcie produktu.</li>\r\n	<li style=\"text-align:justify;\"><strong>Zapytanie o produkt</strong> - formularz który jest również wyświetlany na karcie produktu. Umożliwia on przesłanie przez klienta zapytania dotyczącego określonego produktu.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">W/w formularze mają określone działanie - nie zalecamy kasowania z formularzy pól, które są w nich przypisane - gdyż może to spowodować błędne działanie formularzy.&nbsp; Oczywiście można zdefiniować nowe pola lub zmienić treść istniejących.</div>\r\n"),
("97","569","1","instrukcja","Edycja - płatności ratalne Credit Agricole","<div style=\"text-align:justify;\">W przypadku modułu płatności ratalnych obsługiwanego przez serwis Credit Agricole należy wprowadzić dodatkowe specyficzne parametry w ustawieniach modułu.<br />\r\n<br />\r\nPrzed rozpoczęciem konfiguracji modułu w sklepie należy posiadać podpisaną umowę z serwisem Credit Agricole i aktywne konto.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_platnosci_lukas.jpg\" style=\"margin-bottom: 15px; margin-right: 15px; float: left; width: 566px; height: 448px;\" />Poza standardowymi danymi takie ja ID klienta w serwisie czy hasło lub dostępność płatności dla produktów, których cena mieści się w podanym przedziale wartości - w przypadku serwisu Credit Agricole należy jeszcze zaznaczyć kategorie produktów, które zgodnie z regulaminem banku nie mogą podlegać kredytowaniu.<br />\r\n<br />\r\nW tym celu po przejściu do edycji modułu należy w oknie z rozwijaną listą kategorii pozaznaczać te dla których nie będzie dostępna płatność ratalna za pośrednictwem Credit Agricole.<br />\r\n<br />\r\nInformacje o kategoriach które nie podlegają kredytowaniu należy pobrać z serwisu CA.<br />\r\n<br />\r\nPo poprawnym skonfigurowaniu modułu należy w serwisie Credit Agricole podać adresy, które pozwolą na obsługę wniosku ratalnego :<br />\r\n<br />\r\nAdres sklepu - http://www.adres.sklepu.pl<br />\r\nAdres powrotu pozytywnego: http://www.adres.sklepu.pl/platnosc_koniec.php?typ=agricole&amp;status=OK<br />\r\nAdres powrotu negatywnego: http://www.adres.sklepu.pl/platnosc_koniec.php?typ=agricole&amp;status=FAIL</div>\r\n"),
("98","574","0","instrukcja","Podsumowanie zamówienia","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_podsumowanie.jpg\" style=\"width: 650px; height: 214px; margin-bottom: 15px; margin-right: 15px; float: left;\" />W tej opcji można ustawić moduły, które będą miały wpływa na łączną wartość zamówienia i będą wyświetlane w podsumowaniu przez zakończeniem przez klienta procesu zakupu.<br />\r\n<br />\r\nPo wybraniu w menu opcji <strong>Moduły / Podsumowanie zamówienia</strong> wyświetlana jest lista dostępnych w programie modułów, które mogą zostać uwzględnione w podsumowaniu zamówienia.<br />\r\n<br />\r\nW pierwszej kolumnie jest wyświetlane id modułu w bazie danych. W drugiej kolumnie nazwa modułu, w następnej jak dany moduł wpływa na wartość zamówienia. Możliwe są trzy opcje: zwiększa wartość zamówienia, zmniejsza wartość lub nie wpływa.<br />\r\n<br />\r\nModułami, które są najistotniejsze&nbsp; punktu działania sklepu są: Wartość produktów, Koszt wysyłki oraz Całkowita wartość zamówienia. Te moduły powinny być zawsze włączone i ustawione w takiej kolejności jak podano powyżej. Moduł Całkowita wartość zamówienia jest sumą wszystkich wcześniej występujących i włączonych modułów.</div>\r\n"),
("99","576","1","instrukcja","Edycja - zniżki dla stałych klientów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_podsumowanie_dla_stalych.jpg\" style=\"margin-bottom:15px;margin-right:15px;float:left;width:338px;height:152px;\" />Moduł zniżek dla stałych klientów pozwala na udzielnie klientowi w sklepie dodatkowej zniżki od wartości całego zamówienia w przypadku, gdy dokonuje on po raz kolejny zakupu. Jeżeli moduł jest włączony i klient spełnia warunki otrzymania zniżki dla stałych klientów - wówczas w koszyku w podsumowaniu zamówienia występuje dodatkowa pozycja i określona kwota zostaje odjęta od wartości zamawianych produktów.<br />\r\n<br />\r\nPo przejściu do edycji modułu wyświetlony zostaje formularza, w którym można zdefiniować wszystkie parametry niezbędne do działania modułu. W pierwszej części formularza są informacje tekstowe, które są wyświetlane po stronie sklepu. Należy wprowadzić we wszystkich językach, które są włączone w sklepie.<br />\r\n<br />\r\nW kolejnej części formularza są do zdefiniowania kryteria według których będą naliczane zniżki.<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/moduly_podsumowanie_dla_stalych_edycja.jpg\" style=\"margin: 15px; float: right; width: 604px; height: 561px;\" />Przy wypełnianiu pola <strong>Kolejność wyświetlania</strong> należy zwrócić uwagę aby wartość ta była większa od kolejności wyświetlania w sklepie wartości produktów i mniejsza od podsumowania całego zamówienia - w przeciwnym razie zniżki nie będą poprawnie wyświetlane.<br />\r\n<br />\r\nPole <strong>Okres naliczania zniżek</strong> określa z jakiego przedziału czasowego mają być brane zamówienia do wyliczenia wartości zniżki. Możliwe są do wyboru trzy opcje: kwartalnie, rocznie, wszystkie zamówienia. Zależnie od tego parametru będą wybierane zamówienia, które klient złożył w zadanym przedziale czasowym.<br />\r\n<br />\r\nKolejnym parametrem niezbędnym do ustalania zniżek dla stałych klientów jest <strong>Status zamówienia</strong> - tylko zamówienia posiadające określony status będą brane pod uwagę przy wyliczaniu wielkości zniżki. Sugerujemy ustawić taki status jaki w sklepie posiadają zamówienie, które już zostały na pewno zakończone. Zapobiegnie to sytuacjom, gdy do zniżki mogłyby być brane zamówienia, które klient złożył a ich nie zrealizował (np. zamówienie otrzymane, przyjęte, itp.)<br />\r\n<br />\r\nNastępna pozycja w formularzu, to przedziały wartości złożonych przez klienta zamówień oraz procent zniżki jaki przysługuje. W podanym na rysunku przykładzie klient, który dotychczas złożył zamówienia o łącznej wartości powyżej 1000,00 zł, a nie przekroczył jeszcze 1500,00 - otrzyma dodatkowy rabat w wysokości 5% od wartości bieżącego zamówienia. Klient, którego łączna wartość wszystkich zakupów wyniosła więcej niż 1500,00 ale mniej niż 2000,00 otrzyma 10% rabatu od wartości bieżącego zamówienia. Natomiast klient, który dokonał zakupów za łączną kwotę ponad 2000,00 zl otrzyma 20% zniżki na bieżące oraz wszystkie kolejne zamówienia. W razie potrzeby przedziały można usuwać lub dodawać kolejne.<br />\r\n<br />\r\nW ostatniej części formularza można zadecydować czy zniżka dla stałych klientów będzie dotyczyła wszystkich grup czy tylko określonych - może to być np. zniżka tylko dla grupy hurtowników.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>UWAGA:</strong> Zniżki dla stałych klientów nie obejmują tych, którzy kupowali w sklepie bez rejestracji - nawet jeżeli składali kilka zamówień na łączną kwotę, która by uprawniała do uzyskania zniżki.</span></div>\r\n"),
("100","426","0","instrukcja","Dodawanie / edycja formularza","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/formularz_dodawanie.jpg\" style=\"width: 550px; height: 992px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Nowy formularz dodaje się poprzez kliknięcie w przycisk <strong>dodaj nowy formularz</strong>. Po kliknięciu zostanie wyświetlona strona z polami do dodania nowego formularza. Strona dodawania jest dość złożona i pozwala na tworzenie bardzo indywidualnych formularzy.<br />\r\n<br />\r\nW części górnej modułu znajdują się pola dotyczące wszystkich wersji językowych formularza. Są to dwie opcje: włączenie CAPTCHA (zabezpieczenie tekstowe, które zabezpiecza formularz przed wysyłaniem przez roboty - przy wysłaniu formularza przez klienta musi on dodatkowo przepisać wyświetlone na obrazku znaki) oraz możliwość przypisania wyświetlania formularza dla wybranych grup klientów.<br />\r\n<br />\r\nPrzy dodawaniu nowego formularza podobnie jak w przypadku ankiety - są osobne formularze dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Formularze w poszczególnych językach mogą mieć różną budowę - poszczególne pola nie muszą być identyczne w każdej wersji językowej.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W części górnej formularza dodawania znajduje się pole nazwy formularza. Jest to pole obowiązkowe do wypełnienia - nazwa formularza jest wyświetlana jako nagłówek na stronie formularza w sklepie. Jeżeli nie zostanie uzupełniona nazwa formularza w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\nKolejne pole to tytuł e-maila. Tytuł e-maila to tekst, który będzie przesyłany jako tytuł maila. Mail który zostanie przesłany do klientów będzie miał taki tytuł.<br />\r\n<br />\r\nNastępne pole to dodatkowy tekst w mailu. Zdefiniowany w tym miejscu tekst będzie dołączony do maila oprócz wypełnionych pól formularza. Będzie on dodawany na początku treści maila - przed polami. Może on zawierać dowolną treść - nie może jednak zawierać tagów języka html. W tekście można użyć dodatkowe znaczniki {PRODUKT} oraz {INFO_NAZWA_SKLEPU}. Znaczniki to ciągi znaków, które podczas wysyłania maila są zamieniane na odpowiednie wartości (inne teksty). Znacznik {PRODUKT} jest np używany w formularzu <strong>Poleć znajomemu ... </strong>gdzie w miejsce znacznika jest wstawiana nazwa produktu. Znaczniki mogą być użyte we wszystkich polach formularza oprócz definiowanych pól formularza poniżej edytora opisu.<br />\r\n<br />\r\nKolejne pole to wybór szablonu e-mail jaki będzie używany do wysyłania wiadomości. Sklep wszystkie wiadomości wysyła w oparciu o przygotowane szablony ogólnego wyglądu maila. Szablony maili można zdefiniować w menu <strong>Konfiguracja / Słowniki / Szablony e-maili</strong>. Od wybrania odpowiedniego szablonu będzie zależało jak będzie wyglądał nagłówek, stopka oraz ogólny wygląd wysyłanej wiadomości.<br />\r\n<br />\r\nPoniżej szablonu maila znajdują się pola meta tagów - każdy formularz podczas wyświetlania w sklepie może mieć indywidualne meta tagi.<br />\r\n<br />\r\nDalej znajdują się pola odbiorcy formularza. <img alt=\"alt\" src=\"obrazki/pomoc/formularz_adresat.jpg\" style=\"width:120px;height:66px;margin:10px;margin-left:0px;float:left;\" />W każdym formularzu można zdefiniować do pięciu odbiorców formularza. Po stronie sklepu jeżeli będą zdefiniowani odbiorcy wyświetli się w formularzu dodatkowe pole wyboru gdzie klient będzie mógł wybrać do kogo chce wysłać wiadomość. Można np zdefiniować odbiorców o nazwach: reklamacje, obsługa klienta, marketing itd. Do każdego odbiorcy można przypisać osobny adres e-mail. Taka opcja jest przydatna w formularzu kontaktowym gdzie klient może wybrać z jakim działem sklepu chce się skontaktować. Definiowanie odbiorców nie jest konieczne przy dodawaniu formularza - jeżeli żaden odbiorca nie jest zdefiniowany sklep domyślnie wyśle wiadomość z formularz na adres e-mail sklepu zdefiniowany w menu <strong>Konfiguracja / Dane teleadresowe / Dane sklepu</strong>.<br />\r\n<br />\r\nPoniżej definiowania odbiorców znajduje się pole edytora do wpisania opisu formularza - nie jest to pole wymagane ale dobrze jeżeli formularz będzie miał opis. Opis jest wyświetlany w sklepie po wejściu w formularz.<br />\r\n<br />\r\nPoniżej edytora opisu znajduje się główna część tworzenia nowego formularza - czyli definiowanie pól formularza. Podczas tworzenia formularza administrator ma do wyboru pięć typów formularza:<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/formularz_pola.jpg\" style=\"width:360px;height:274px;float:right;margin-left:15px;margin-right:15px;\" /></div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Input</strong> - jest to jednowierszowe pole tekstowe do którego klient może wpisać tekst. Po wybraniu takiego pola trzeba wpisać jego nazwę jaka będzie wyświetlana w sklepie oraz długość pola jakie ma się wyświetlać (długość w znakach - np 15 będzie oznaczało, że pole będzie miało długość taką jak 15 liter napisanych obok siebie). Dodatkowym parametrem jest minimalna ilość znaków jaką musi wpisać klient, żeby pole było poprawnie wypełnione. W tym typie pola jest także dodatkowa opcja - dopuszczalne dane. W opcji tej można wybrać czy w pole będzie można wpisać tylko:\r\n\r\n	<ol>\r\n		<li>adres e-mail - oznacza, że w polu będzie można wpisać tylko adres e-mail - jeżeli zostanie wybrane to pole - dodatkowo rozwinie się opcja czy na podany adres e-mail ma być również wysłana zawartość formularza - jest to używane przy formularzu poleć znajomemu ... gdzie e-mail jest również wysyłany na adres &quot;znajomego&quot;. Dodatkową opcją w opcji adresu e-mail jest pytanie czy adres ma być ustawiony jako nadawca maila. Jest to istotne w przypadku np formularza kontaktowego. Jeżeli zostanie wybrana opcja - <strong>tak</strong> - to w mailu z formularza kontaktowego jaki otrzyma administrator sklepu - jako nadawca będzie adres mailowy podany przez klienta. Dzięki temu w programie pocztowym przy odpowiedzi na maila - jako adres odbiorcy automatycznie wstawi się adres klienta</li>\r\n		<li>tylko liczby - w polu będzie można wpisać tylko wartości liczbowe - litery i inne znaki nie będą przyjmowane</li>\r\n		<li>waluta (tylko liczby) - podobnie jak powyżej - z tym, że wpisana liczba będzie formatowana do postaci waluty (ze znakiem waluty)</li>\r\n		<li>data (kalendarz) - po kliknięciu w pole zostanie wyświetlony kalendarz z którego klient będzie mógł wybrać datę - przy tym rodzaju danych nie jest definiowana minimalna ilość znaków jaką musi mieć pole Input</li>\r\n		<li>dowolna wartość - będzie można wpisać dowolne znaki</li>\r\n	</ol>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><strong>Textarea</strong> - jest to pole tekstowe do którego można wpisać tekst - ale jest to pole wielowierszowe - co odróżnia je od pola input. Po wybraniu takiego pola trzeba wpisać jego nazwę jaka będzie wyświetlana w sklepie. Opcją jest minimalna ilość znaków jaką musi wpisać klient, żeby pole było poprawnie wypełnione</li>\r\n	<li style=\"text-align:justify;\"><strong>Radio button</strong> - są to pola jednokrotnego wyboru - tzn, że klient może wybrać tylko jedną opcję ze wszystkich możliwych. Po wybraniu takiego pola trzeba wpisać jego nazwę jaka będzie wyświetlana w sklepie oraz wyświetli się dodatkowe okno, gdzie trzeba wpisać możliwe opcje wyboru. Każda opcja musi być w osobnej linii.</li>\r\n	<li style=\"text-align:justify;\"><strong>Checkbox</strong> - są to pola wielokrotnego wyboru - tzn, że klient może wybrać wiele opcji ze wszystkich możliwych. Po wybraniu takiego pola trzeba wpisać jego nazwę jaka będzie wyświetlana w sklepie oraz wyświetli się dodatkowe okno, gdzie trzeba wpisać możliwe opcje wyboru. Każda opcja musi być w osobnej linii.</li>\r\n	<li style=\"text-align:justify;\"><strong>Drap down menu</strong> - jest to rozwijana lista wyboru opcji - klient może wybrać tylko jedną opcję z rozwijanej listy. Po wybraniu takiego pola trzeba wpisać jego nazwę jaka będzie wyświetlana w sklepie oraz wyświetli się dodatkowe okno, gdzie trzeba wpisać możliwe opcje wyboru. Każda opcja musi być w osobnej linii.</li>\r\n	<li style=\"text-align:justify;\"><strong>Wgranie pliku</strong> - jest to pole z przyciskiem dzięki któremu klient może dołączyć do wysyłanej wiadomości załącznik w formie pliku. Po wybraniu tego pola trzeba wpisać jego nazwę jaka będzie wyświetlana w sklepie oraz wyświetlą się dodatkowo dwie opcje: <strong>dopuszczalne formaty plików</strong> - gdzie można wpisać jakie pliki klient może załączyć / wgrać - rozszerzenia plików należy wymienić rozdzielając przecinkami np jpg,gif,bmp oraz drugie pole to <strong>maksymalny rozmiar pliku</strong> - gdzie określa się jaką maksymalną wielkość może mieć załączany przez klienta plik. Wielkości podaje się w MB (megabajtach). Oba dodatkowe pola nie są obowiązkowe ale zalecamy ich uzupełnianie - ze względów bezpieczeństwa.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Dodatkowo w każdym polu trzeba wybrać czy pole ma być obowiązkowe do wypełnienia przez klienta czy też nie (nie dotyczy pola <strong>wgrania pliku</strong>, które nie jest obowiązkowe). Trzeba także wpisać kolejność wyświetlania pola w formularzu - poprzez sortowanie można ustalić w jakiej kolejności mają wyświetlać się pola.<br />\r\n<br />\r\nPrzy tworzeniu formularza można dodać dowolną ilość pól. Nowe pole dodaje się poprzez kliknięcie w przycisk <strong>dodaj nowe pole formularza</strong>. Po kliknięciu wyświetlą się pozycje do dodania nowego pola. Nie ma ograniczenia ilości dodawanych pól do formularza.<br />\r\n<br />\r\nEdycja istniejącego formularza jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.</div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("101","435","0","instrukcja","Galerie","<div style=\"text-align:justify;\">Sklep oprócz typowej funkcji sprzedażowej może posiadać także funkcję informacyjno - prezentacyjną. Jednym z elementów składających się na taką funkcję sklepu jest tworzenie galerii zdjęć. Sklep umożliwia tworzenie galerii - prezentacje zdjęć wraz z opisami.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/galerie_lista.jpg\" style=\"width: 550px; height: 124px; margin-left: 15px; margin-bottom: 15px; float: right;\" />W sklepie można dodać wiele galerii. Obsługa galerii w panelu zarządzania odbywa się poprzez menu <strong>Wygląd / Galerie</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu galerii. W liście galerie są domyślnie posortowane wg nazwy. Powyżej okna z listą galerii znajduje się pole wyszukiwania. Umożliwia ono wyszukanie wybranej galerii. Dodatkowo można wybrać z listy grupę klientów - wyświetlone zostaną wtedy tylko galerie dostępne dla danej grupy klientów.<br />\r\n<br />\r\nPoniżej wyszukiwarki znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania galerii w listingu. Poniżej znajduje się przycisk <strong>dodawania nowej galerii</strong>.<br />\r\n<br />\r\nW liście każda galeria jest wyświetlana w osobnym wierszu. Pierwsza kolumna wyświetla nr id galerii. W kolejnej kolumnie wyświetlana jest nazwa galerii (jest ona wyświetlana jako nagłówek na stronie galerii w sklepie). Kolejna kolumna wyświetla nazwy grup klientów dla jakich dostępna jest dana galeria. Jeżeli wyświetlany jest znak - minusa - oznacza to, że galeria jest dostępna dla wszystkich klientów. Następna kolumna wyświetla status galerii - czy jest wyświetlana w sklepie czy nie. Zielona ikonka oznacza, że galeria jest wyświetlana w sklepie, szara, że jest nieaktywna. Zmianę aktywności (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę aktywności. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję galerii lub jej usunięcie.<br />\r\n<br />\r\nPo stronie sklepu linki do galerii mogą być widoczne w górnym i dolnym menu oraz linkach stopki. Podczas dodawania tych elementów można wybrać link do galerii.</div>\r\n"),
("102","436","0","instrukcja","Dodawanie / edycja galerii","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/galeria_dodawanie.jpg\" style=\"width: 550px; height: 961px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Nową galerię dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową galerię</strong>. Po kliknięciu zostanie wyświetlona strona strona z formularzem do dodania nowej galerii.<br />\r\n<br />\r\nPrzy dodawaniu nowej galerii podobnie jak w przypadku ankiety - są osobne formularze dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Galerie w poszczególnych językach mogą mieć różną budowę - może być różna ilość zdjęć w poszczególnych wersjach językowych.<br />\r\n<br />\r\nCzęścią wspólną dla wszystkich języków jest część górna formularza dotycząca szerokości oraz wysokości zdjęć, a także przypisania wyświetlania galerii dla określonych grup klientów. Pola szerokość oraz wysokość te definiują jaki rozmiar będą miał miniatury zdjęć galerii po stronie sklepu oraz pole ilość kolumn - określa w ilu kolumnach maja się wyświetlać zdjęcia. Poniżej screen z układem dwóch kolumn.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/galeria_sklep.jpg\" style=\"width:170px;height:141px;float:left;margin-top:10px;margin-right:10px;margin-bottom:10px;\" />Kolejne pola są już indywidualne dla poszczególnych języków sklepu. Pierwsze pole to nazwa galerii - jest to pole obowiązkowe do wypełnienia - nazwa galerii jest wyświetlana jako nagłówek na stronie galerii w sklepie. Jeżeli nie zostanie uzupełniona nazwa galerii w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\nPoniżej nazwy galerii znajdują się pola meta tagów - każda galeria podczas wyświetlania w sklepie może mieć indywidualne meta tagi.<br />\r\n<br />\r\nDalej znajduje się pole edytora do wpisania opisu galerii - nie jest to pole wymagane ale dobrze jeżeli galeria będzie miał opis. Opis jest wyświetlany w sklepie po wejściu w galerię.<br />\r\n<br />\r\nPoniżej edytora opisu znajduje się główna część tworzenia nowej galerii. Do każdej galerii można dodać nieograniczoną ilość zdjęć. W każdej sekcji należy wypełnić poszczególne pola dotyczące danego zdjęcia. Pierwsze pole to - ścieżka zdjęcia. 2-krotne kliknięcie w to pole spowoduje otworzenie się przeglądarki zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta. Kolejne pole to opis zdjęcia. Nie jest to pole wymagane jeżeli zdjęcia nie mają mieć opisów. Następne pole to opis znacznika ALT. Jest to wartość która wyświetla się zanim obrazek zostanie załadowany do przeglądarki WWW klienta - jest ona również ważna dla google i odpowiednie dopasowanie tekstu opisu obrazka do zdjęcia powoduje lepsze pozycjonowanie sklepu - pozostawienie pola pustego spowoduje, że w kodzie sklepu będzie wyświetlana wartość pusta - nie jest to błąd ale nie jest to wskazane. Ostatnie pole do kolejność wyświetlania. Poprzez sortowanie można ustalić w jakiej kolejności mają wyświetlać się zdjęcia w galerii.<br />\r\n<br />\r\nPrzy tworzeniu galerii można dodać dowolną ilość zdjęć. Nowe zdjęcie dodaje się poprzez kliknięcie w przycisk <strong>dodaj nowe zdjęcie</strong>. Po kliknięciu wyświetlą się pozycje do dodania nowego zdjęcia. Nie ma ograniczenia ilości dodawanych zdjęć do galerii.<br />\r\n<br />\r\nEdycja istniejącej galerii jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.</div>\r\n"),
("103","445","0","instrukcja","Strony informacyjne - informacje ogólne","<div style=\"text-align:justify;\">Strony informacyjne są jednym z najważniejszych elementów zarządzania treścią w sklepie. Dzięki temu modułowi można wyświetlić w sklepie dowolną treść - teksty, grafiki, filmy youtube, zdjęcia i&nbsp; inne elementy które można wstawić w edytorze tekstu. Treści, które są dodawane podczas tworzenia stron informacyjnych mogą być wyświetlane jako osobne strony informacyjne (linki do stron mogą być umieszczane w górnym oraz dolnym menu, a także w stopce). Treść może być także wyświetlana w formie boxu w kolumnach z boxami&nbsp; lub jako moduł w części środkowej sklepu. Dodana strona może także - zamiast wyświetlania treści - być odnośnikiem do innych stron - w tym adresów z poza sklepu.<br />\r\n<br />\r\nPoniżej przestawione są przykłady zastosowań stron informacyjnych.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_menu.jpg\" style=\"width:400px;height:71px;margin-left:15px;margin-bottom:15px;float:right;\" /><strong>Strona informacyjna w górnym menu.</strong> W przykładzie została stworzona strona informacyjna o nazwie Regulamin, która zawiera regulamin sklepu - została ona dodana do wyświetlania w górnym menu - poprzez opcje w menu <strong>Wygląd / Ustawienia wyglądu</strong> - zakładka górne menu. Klient po kliknięciu w link zostanie przeniesiony do strony z regulaminem.\r\n\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_stopka.jpg\" style=\"width:350px;height:101px;float:right;margin-left:15px;margin-bottom:15px;\" /><strong>Strony informacyjne w stopce.</strong> W kolumnach stopki również można dodawać linki do stron informacyjnych - poprzez panel zarządzania - menu jak w punkcie powyżej - zakładki Stopka X kolumna. Generalnie cała stopka (linki) są z reguły tworzone w oparciu o strony informacyjne - głównym zadaniem linków w stopce jest wyświetlanie danych informacyjnych.\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_box.jpg\" style=\"width: 180px; height: 204px; margin-left: 15px; margin-bottom: 15px; float: right;\" /><strong>Treść strony informacyjnej w boxie.</strong> Zawartość strony informacyjnej można wyświetlić w boxie. W tym celu należy stworzyć nowy box w menu <strong>Wygląd / Boxy</strong> (podczas dodawania należy wybrać, że box ma być stworzony ze strony informacyjnej). W boxie może być wyświetlana część tekstu (tekst skrócony) oraz link do przeczytania całości tekstu (tylko jeżeli jest wypełnione w stronie informacyjnej pole tekstu skróconego) lub cała treść strony informacyjnej.\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_modul_srodkowy.jpg\" style=\"width:550px;height:89px;margin-left:15px;margin-bottom:15px;float:right;\" /><strong>Treść strony informacyjnej w module środkowym.</strong> Zawartość strony informacyjnej można wyświetlić w module środkowym. W tym celu należy stworzyć nowy moduł w menu <strong>Wygląd / Moduły środkowe</strong> (podczas dodawania należy wybrać, że moduł ma być stworzony ze strony informacyjnej). W module może być wyświetlana część tekstu (tekst skrócony) oraz link do przeczytania całości tekstu (tylko jeżeli jest wypełnione w stronie informacyjnej pole tekstu skróconego) lub cała treść strony informacyjnej.\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><strong>Link zewnętrzny stworzony przy pomocy strony informacyjnej.</strong> Link będzie wyglądał tak samo jak w przypadku strony w górnym menu czy stopce - ale będzie odnośnikiem do innej wewnętrznej strony sklepu (np promocji czy nowości) lub do strony z poza sklepu. Adres strony do jakiej ma przenosić definiuje się podczas tworzenia strony informacyjnej.\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n</ol>\r\n"),
("104","446","0","instrukcja","Grupy stron informacyjnych","<div style=\"text-align:justify;\">Aby ułatwić zarządzanie stronami informacyjnymi zostały w sklepie stworzone <strong>grupy stron informacyjnych</strong>. Dzięki temu można poszczególne strony informacyjne pogrupować i przypisać poszczególne pozycje do określonych grup. Grupy stron informacyjnych mogą być wykorzystywane np do wyświetlania w boxie stron tylko z określonej grupy. <img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_grupy_box.jpg\" style=\"width:400px;height:74px;margin-left:15px;margin-bottom:15px;margin-top:15px;float:right;\" /> W sklepie dodany jest box o nazwie <strong>Informacje</strong> - gdzie podczas edycji boxu (menu <strong>Wygląd / Boxy</strong>) można wybrać z jakiej grupy ma wyświetlić strony informacyjne. Grupując strony informacje można je także wyświetlić w postaci rozwijanego menu w <strong>górnym menu sklepu</strong>, które definiuje się w menu <strong>Wygląd / Ustawienia wyglądu</strong> zakładka Górne menu.<br />\r\n<br />\r\nGrupy stron informacyjnych obsługuje się w menu <strong>Wygląd / Strony informacyjne / Grupy stron informacyjnych</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu grup stron informacyjnych. Powyżej listy znajduje się przycisk <strong>dodawania nowej grupy</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_grupy_lista.jpg\" style=\"width: 500px; height: 74px; margin-bottom: 15px; margin-right: 15px; float: left;\" />W liście każda grupa jest wyświetlana w osobnym wierszu. Sam listing jest bardzo prosty. Zawiera: id grupy, kod grupy, nazwę grupy oraz opis. Przy każdej pozycji wyświetlane są ikony nawigacyjne które umożliwiają usunięcie grupy lub jej edycję.<br />\r\n<br />\r\nDodawanie nowej grupy jest również bardzo proste. Ogranicza się do wpisania kodu nowo dodawanej grupy, nazwy grupy oraz opisu. Kod grupy nie może zawierać spacji i polskich znaków - musi być unikalny - np STRONY_INFORMACYJNE_STOPKA. Podczas edycji grupy modyfikować można wyłącznie opis oraz nazwę grupy, kod grupy jest nieedytowalny.<br />\r\n<br />\r\nPole nazwa grupy jest używane do wyświetlania w górnym menu sklepu. Jeżeli do górnego menu zostanie dodane wyświetlanie (w formie rozwijanej listy) stron informacyjnych z danej grupy to jako pozycja menu będzie wyświetlana zdefiniowana nazwa. Pole jest obowiązkowe do wypełnienia. Jeżeli nie zostanie uzupełniona nazwa grupy w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\n<strong><span style=\"color:#ff0000;\">UWAGA</span></strong> W przypadku usuwania grupy zostają również usunięte strony informacyjne do niej przypisane.</div>\r\n"),
("105","447","0","instrukcja","Obsługa stron informacyjnych","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_listing.jpg\" style=\"width: 550px; height: 210px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Strony informacyjne w panelu zarządzania obsługuję się w menu <strong>Wygląd / Strony informacyjne / Zarządzanie stronami</strong>. Moduł wyświetla w oknie wszystkie strony informacyjne jakie zostały dodane do sklepu. Powyżej okna z listingiem znajdują się opcje filtrowania. Umożliwiają one wyszukanie wybranej strony lub wyświetlenie stron z określonej grupy. Po wybraniu określonych filtrów (lub pola wyszukiwania) obok filtrów zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie wybranych filtrów i przywrócenie podstawowych opcji wyświetlania listingu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania stron w listingu. Domyślnie strony są wyświetlane wg ustalonej kolejności sortowania. Poniżej znajduje się przycisk <strong>dodawania nowej strony</strong>.<br />\r\n<br />\r\nW liście każda strona jest wyświetlana w osobnym wierszu. Pierwsza kolumna wyświetla nr id strony w bazie sklepu. W kolejnej kolumnie wyświetlany jest tytuł strony (jest on wykorzystywany jako nagłówek podczas wyświetlania strony w sklepie lub jako nazwa linku w menu lub stopce). Następna kolumna wyświetla grupę do jakiej jest przypisana dana strona. Nie każda strona musi być przypisana do grupy - jeżeli nie jest powiązana z żadną grupą wyświetlany jest znak minusa. W następnej kolumnie jest wyświetlona kolejność wyświetlania jaka została ustalona dla danej strony informacyjnej. Kolejna kolumna wyświetla informację czy dana strona jest linkiem zewnętrznym tzn - nie wyświetla treści tylko przenosi do innej strony. Jeżeli strona służy tylko do przekierowania na inną stronę wtedy ikona ma kolor zielony - jeżeli jest to strona, która wyświetla określoną treść to kolor szary. Dodatkowo o typie strony informuje ikona, która znajduje się przed tytułem strony (w drugiej kolumnie listingu). Legenda oznaczeń ikonek znajduje się pod listingiem. Kolejna kolumna wyświetla w formie ikony miejsce wyświetlania treści strony informacyjnej. Jeżeli wyświetlany jest znak - minusa - oznacza to, że strona jest wyświetlana jako standardowa strona informacyjną, której treść można wyświetlić poprzez link w sklepie. Jeżeli wyświetlana jest ikona oznacza to, że treść strony wyświetlana jest w boxie lub module środkowym. Jeżeli strona informacyjna jest wyświetlana w boxie lub module środkowym wtedy nie można zawartości takiej strony wyświetlić poprzez link bezpośrednio w sklepie, a jej treść wyświetla się tylko w boxie lub module.<br />\r\n&nbsp;\r\n<table>\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"vertical-align: middle;\"><img alt=\"alt\" src=\"obrazki/wyswietlanie_box.png\" style=\"width: 16px; height: 16px; margin-right: 5px;\" /></td>\r\n			<td style=\"vertical-align: middle;\">oznacza, że treść strony informacyjnej wyświetlana jest w boxie</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"vertical-align: middle;\"><img alt=\"alt\" src=\"obrazki/wyswietlanie_modul.png\" style=\"width: 16px; height: 16px; margin-right: 5px;\" /></td>\r\n			<td style=\"vertical-align: middle;\">oznacza, że treść strony informacyjnej wyświetlana jest w module środkowym</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\nKolejna kolumna wyświetla nazwy grup klientów dla jakich dostępna jest dana strona informacyjna. Jeżeli wyświetlany jest znak - minusa - oznacza to, że strona jest dostępna dla wszystkich klientów. Przedostatnia kolumna wyświetla status strony informacyjnej - czy ma być wyświetlana w sklepie czy nie. Zielona ikonka oznacza, że strona może być wyświetlana w sklepie, szara, że jest nieaktywna. Zmianę aktywności (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę aktywności. Zmiana na nieaktywną powoduje, że strona przestaje się wyświetlać we wszystkich miejscach do jakich została przypisana np: menu, linki w stopce, treść boxie itp W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję strony lub jej usunięcie.</div>\r\n"),
("106","448","0","instrukcja","Dodawanie / edycja strony informacyjnej","<div style=\"text-align:justify;\">Nową stronę informacyjną dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową stronę</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej strony informacyjnej. Formularz dodawania nowej strony jest podzielony na zakładki - w każdej zakładce definiuje się odpowiednie parametry. Zakładki dodawania nowej strony różnią się w zależności od wyboru czy strona będzie linkiem zewnętrznym czy zwykłą stroną informacyjną. Formę wybiera się w pierwszej zakładce <strong>Podstawowe dane</strong>.<br />\r\n<br />\r\nJeżeli strona będzie <span style=\"color:#ff0000;\"><strong>wyświetlała tekst</strong></span> (dowolną treść - opcja link zewnętrzny na - <strong>nie</strong>) przy dodawaniu strony będą dostępne trzy zakładki.<img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_dodawanie.jpg\" style=\"width: 550px; height: 403px; float: right; margin-left: 15px; margin-top: 15px; margin-bottom: 15px;\" /></div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\">Zakładka <strong>Podstawowe dane</strong> - w zakładce tej należy wybrać do jakiej grupy będzie należała strona, wpisać jej tytuł oraz treść strony. Tekst wpisywany w edytorze może mieć dowolną treść oraz może zawierać dowolne formatowania, obrazki itp. W edytorze należy wpisać pełną treść jaka ma być wyświetlana przez stronę. Tytuł strony oraz treść wpisuje się osobno dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniony tytuł strony w innych wersjach językowych - zostanie w te pola wstawiony tytuł z domyślnego języka. Dodatkowo w opisywanej zakładce można wybrać dla jakich grup klientów strona ma być widoczna oraz wybrać czy strona ma być linkiem zewnętrznym (opis poniżej) lub jej treść ma się wyświetlać w boxie lub module środkowym (opis poniżej). Przy edycji strony informacyjnej można wybrać także czy link do danej strony po stronie sklepie ma mieć atrybut <strong>nofollow</strong>. Wybranie opcji na <strong>tak</strong> spowoduje, że do linku w sklepie będzie dodawany atrybut <strong>nofollow</strong>, który powoduje, że dany link nie będzie indeksowany przez wyszukiwarki internetowe (zalecamy ostrożne stosowanie tej opcji, gdyż zbyt duża ilość linków z tym atrybutem może wpłynąć negatywnie na pozycję w wyszukiwarkach - opcje jest najczęściej używana np w przypadku strony z regulaminem sklepu w celu uniemożliwienia jej analizy przez roboty). Ostatnią opcją jest możliwość wybrania czy strona będzie wyświetlana jak kod. Domyślnie wyświetlany jest edytor tekstu, który umożliwia wpisanie tekstu, dodanie grafik, formatowanie tekstu. Czasami jednak zachodzi konieczność wyświetlania (stworzenia) strony w formie kodu (np javascript). Niektóre firmy oferujące regulaminy przekazują do wyświetlania - nie tekst regulaminu - a kod, który należy wstawić na stronie i który to kod powoduje wyświetlanie regulaminu. W takim przypadku należy wybrać opcję na - tak - po czym zostanie ukryte okno edytora tekstu i wyświetli się okno gdzie będzie można wstawić kod.</li>\r\n	<li style=\"text-align:justify;\">Zakładka <strong>Tekst skrócony</strong> - w tej zakładce można wpisać tekst skrócony treści strony. <img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_box.jpg\" style=\"width: 180px; height: 204px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Może to być albo streszczenie albo początek tekstu. Jeżeli dana strona będzie wyświetlana np w boxie - zostanie wyświetlony tylko tekst skrócony, a całość zostanie wyświetlona po przejściu do szczegółów strony (poprzez kliknięcie na link <strong>przeczytaj całość</strong>). Po przejściu do wyświetlania strony w sklepie w zależności od ustawień konfiguracyjnych stron (menu <strong>Wygląd / Strony informacyjne / Konfiguracja stron</strong>) - tekst skrócony może być wyświetlany na początku tekstu lub też nie - wtedy będzie widoczny tylko tekst pełny. Pole tekst skrócony nie jest wymagane. Jeżeli pole nie będzie uzupełnione strona zawsze będzie wyświetlała tylko pełną treść wpisaną w pierwszej zakładce.</li>\r\n	<li style=\"text-align:justify;\">Zakładka <strong>Pozycjonowanie</strong> - każda strona podczas wyświetlania w sklepie może mieć indywidualne meta tagi. Zakładka umożliwia zdefiniowanie indywidualnych meta tagów dla strony informacyjnej. Meta tagi definiowane są dla każdej wersji językowej sklepu.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Jeżeli podczas definiowania strony zostanie wybrane, żeby strona była <span style=\"color:#ff0000;\"><strong>linkiem zewnętrznym</strong></span> przy dodawaniu strony zmieni się ilość zakładek oraz zawartość zakładki Podstawowe dane.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_dodawanie_link.jpg\" style=\"width: 550px; height: 309px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Zakładka <strong>Podstawowe dane</strong> - podobnie jak w przypadku strony, która wyświetla treść - także i podczas dodawania strony będącej linkiem należy wybrać do jakiej grupy będzie należała strona. W porównaniu jednak z w/w stroną znika opcja wpisywania treści, a pokazuje się opcja wyboru linku do jakiego ma prowadzić strona. Dostępne są dwie opcje - <strong>link wewnętrzny</strong> - w tym miejscu wyświetlana jest lista dostępnych w sklepie podstron do jakich może prowadzić strona lub druga opcja to <strong>link zewnętrzny</strong> - gdzie można wpisać dowolny adres www. Adres musi być wpisany w pełnej postaci razem z http://...... Dodatkowo należy uzupełnić pole tytułu strony. Tytuł strony oraz treść wpisuje się osobno dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniony tytuł strony w innych wersjach językowych - zostanie w te pola wstawiony tytuł z domyślnego języka.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">W przypadku strony jako linku zewnętrznego nie ma dostępnych innych zakładek - ponieważ nie występuje tutaj opis i nie jest potrzebne pole tekstu skróconego oraz meta tagów.<br />\r\n<br />\r\nJeżeli podczas definiowania strony zostanie wybrane, żeby treść strony informacyjnej <span style=\"color:#FF0000;\"><strong>wyświetlała się w boxie lub module</strong></span> podobnie jak w przypadku linku zewnętrznego zmieni się ilość zakładek oraz zawartość zakładki Podstawowe dane.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align: justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_dodawanie_modul_box.jpg\" style=\"width: 600px; height: 540px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Zakładka <strong>Podstawowe dane</strong> - podobnie jak w przypadku strony, która wyświetla treść - także i podczas dodawania strony, której treść będzie wyświetlana w module lub boxie należy wybrać do jakiej grupy będzie należała strona. Znikają jednak opcje kolejności wyświetlania oraz możliwość przypisania grup klientów. Pojawiają się za to nowe opcje do wyboru, które są związane z wyświetlaniem treści w boxie lub module środkowym. Pierwsza nowa opcja to <strong>Nagłówek modułu / boxu</strong>. Opcja ta umożliwia wyłączenie lub włączenie wyświetlania nagłówka modułu / boxu. Jeżeli nagłówek jest wyłączony wyświetlana w sklepie będzie tylko sama treść strony informacyjnej. Kolejna opcja to <strong>wyświetlanie modułu / boxu</strong>. Moduł czy box może się wyświetlać tylko na stronie głównej sklepu, tylko na podstronach lub na wszystkich stronach sklepu. Od wybrania odpowiedniej opcji będzie zależało gdzie będzie wyświetlany utworzony moduł / box. Następną opcją jest pole <strong>Opisu modułu</strong> oraz <strong>Co wyświetla</strong>. Są to pola informacyjne dla administratora sklepu, ułatwiające odnalezienie modułu / boxu w liście oraz identyfikujące co wyświetla dany moduł / box. Opis jest widoczny przy dodawaniu modułu / boxu w wyglądzie sklepu (menu <strong>Wygląd / Ustawienia wyglądu</strong>) i ułatwia wybranie / znalezienie odpowiedniego modułu / boxu. Ostatnie dwie opcje są związane z obsługą szablonów RWD. W tej części można ustawić czy dany moduł / box może być wyświetlany w szablonach RWD oraz co ma się dziać z modułem / boxem przy małych rozdzielczościach w takich szablonach (poniżej 760px szerokości ekranu). Jeżeli moduł może działać w szablonach RWD to przy małych rozdzielczościach może być ukrywany lub może pozostawać bez zmian.</li>\r\n	<li style=\"text-align: justify;\">Zakładka <strong>Tekst skrócony</strong> - w przypadku utworzenia strony informacyjnej, która jest wyświetlana w module lub boxie wstawienie tekstu w zakładce Tekst skrócony spowoduje, że ta treść będzie wyświetlana w boxie lub module. Dodatkowo będzie wyświetlany przycisk o nazwie <strong>przeczytaj całość</strong>. Kliknięcie w przycisk spowoduje przejście do podstrony, na której będzie wyświetlana treść pełna strony plus ewentualnie dodatkowo tekst skrócony w zależności od ustawień konfiguracyjnych stron (menu <strong>Wygląd / Strony informacyjne / Konfiguracja stron</strong>). Pole tekst skrócony nie jest wymagane. Jeżeli pole nie będzie uzupełnione moduł / box zawsze będzie wyświetlał tylko pełną treść wpisaną w pierwszej zakładce (tekst główny strony). Poniżej przedstawiamy przykłady dodanych w sklepie stron informacyjnych - wyświetlanych w boxie lub module środkowym.</li>\r\n</ol>\r\n<img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_sklep_box.jpg\" style=\"width: 600px; height: 287px; margin: 10px; float: left;\" />\r\n<div style=\"text-align: justify;\"><br />\r\nObok przedstawiony jest przykład wyświetlania treści strony informacyjnej w boxie. W tym przykładzie dodany został tekst zarówno do treści skróconej jak i do treści głównej. W boxie wyświetlany jest tekst skrócony. Cała treść strony wraz z treścią główną zostanie wyświetlona jako osobna strona informacja po kliknięciu w przycisk <strong>przeczytaj całość</strong>.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n<img alt=\"alt\" src=\"obrazki/pomoc/strony_informacyjne_sklep_modul.jpg\" style=\"width: 600px; height: 286px; margin: 10px; float: right;\" />\r\n<div style=\"text-align: justify;\"><br />\r\nPowyżej przedstawiony jest przykład wyświetlania treści strony informacyjnej w module środkowym. W tym przykładzie tekst został dodany tylko do treści skróconej - bez definiowania tekstu w treści pełnej. Przy takim rozwiązaniu nie jest wyświetlany przycisk do przejścia do treści strony informacyjnej. Takie rozwiązanie umożliwia tworzenie dowolnej treści, która jest wyświetlana tylko w modułach czy boxach - bez przechodzenia do osobnych stron informacyjnych. Dzięki temu można tworzyć np moduł z bannerami, tekstami informacyjnymi, krótkimi opisami, które mają się znaleźć np tylko na stronie głównej sklepu.</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#FF0000;\"><strong>WAŻNA INFORMACJA:</strong></span><br />\r\nJeżeli strona informacyjna będzie użyta do wyświetlania jej treści w <span style=\"color:#FF0000;\"><strong>module lub boxie</strong></span> to w zależności od opisów jakie będą uzupełnione będzie w sklepie dostępny link do wyświetlania treści strony lub link nie będzie tworzony.</div>\r\n\r\n<ul>\r\n	<li style=\"text-align: justify;\">jeżeli zostanie wpisana tylko treść w <strong>głównym opisie</strong> to w sklepie będzie dostępny link do strony informacyjnej o ID utworzonej strony - np strona-info-pm-10.html - link do strony informacyjnej będzie także generowany w mapie strony XML</li>\r\n	<li style=\"text-align: justify;\">jeżeli zostanie wpisana treść w <strong>głównym opisie</strong> oraz w <strong>tekście skróconym</strong> w sklepie również będzie dostępny link do utworzonej strony - dodatkowo będzie wyświetlany przycisk do przeczytania całości - link do strony informacyjnej będzie także generowany w mapie strony XML</li>\r\n	<li style=\"text-align: justify;\">jeżeli zostanie wpisana treść tylko w <strong>tekście skróconym</strong> to link <span style=\"color:#FF0000;\"><strong>nie</strong></span> będzie dostępny w sklepie i nie będzie można otworzyć w sklepie osobnej podstrony z treścią strony - ma to na celu zablokowanie tworzenie niepotrzebnych linków w przypadku jeżeli treść strony jest wyświetlana tylko w module lub boxie - link do strony informacyjnej <span style=\"color:#FF0000;\"><strong>nie</strong></span> będzie także generowany w mapie strony XML</li>\r\n</ul>\r\n\r\n<div style=\"text-align: justify;\">Dlatego jeżeli treść strony ma być wyświetlana tylko w module lub boxie należy wpisywać tekst w zakładce Tekst skrócony, a tekst główny pozostawić pusty - w takim przypadku nie będzie w sklepie generowany link do strony informacyjnej.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nEdycja istniejącej strony informacyjnej w przypadku jeżeli jest to zwykła strona informacja (nie wyświetlana w module / boxie) jest identyczna jak jej dodawanie. Formularz edycji ma takie same pola i zakładki jak przy dodawaniu. Można również podczas edycji zmienić typ istniejącej strony z treści na link. Jeżeli strona jest wyświetlana jako moduł lub box to podczas edycji strony można zmienić tylko treść jaką wyświetla strona. Dostępne są zakładki w których można zmienić treść główną oraz tekst skrócony. Dodatkowo widoczny jest link, który umożliwia przejście do edycji modułu lub boxu i zmiany konfiguracji wyświetlania elementu (zmiana wyświetlania nagłówka, miejsce wyświetlania modułu / boxu. zmiany RWD etc).</div>\r\n"),
("107","455","0","instrukcja","Aktualności","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/aktualnosci_sklep.jpg\" style=\"width: 450px; height: 172px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Jednym ze sposobów wyświetlania informacji w sklepie - oprócz definiowania stron informacyjnych - jest dział aktualności. Aktualności pozwalają opisać najnowsze wydarzenia i wyświetlić je po stronie sklepu. Aktualności można grupować w kategorie, które mogą zawierać poszczególne artykuły. W porównaniu ze stronami informacyjnymi - aktualności (w zależności od konfiguracji) są w sklepie wyświetlane wraz z datą dodania oraz ilością wyświetleń danego artykułu. Dzięki temu można np w sklepie prowadzić blog - gdzie wpisy będą wyświetlane wg daty dodania.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/aktualnosci_gorne_menu.jpg\" style=\"width: 369px; height: 100px; margin-bottom: 10px; margin-right: 10px; float: left;\" />Linki do aktualności oraz aktualności mogą być wyświetlane górnym lub dolnym menu oraz w linkach stopki. Kliknięcie w taki link spowoduje otworzenie podstrony z danym artykułem lub artykułami z danej kategorii. Linki dodaje się w menu <strong>Wygląd / Ustawienia wyglądu</strong>.</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n<img alt=\"alt\" src=\"obrazki/pomoc/aktualnosci_strona_glowna.jpg\" style=\"width: 550px; height: 346px; float: left; margin-right: 15px; margin-top: 15px; margin-bottom: 15px;\" />\r\n<div style=\"text-align:justify;\"><br />\r\nArtykuły mogą być także wyświetlane na stronie głównej sklepu jako moduł środkowy. W menu <strong>Wygląd / Moduły środkowe</strong> są zdefiniowane moduły, które mogą wyświetlać artykuły wg daty dodania (ostatnio dodane artykuły) lub artykuły z wybranej kategorii artykułów.&nbsp; Podczas edycji modułów można w parametrach konfiguracji modułów ustawić ile artykułów ma być wyświetlanych jednocześnie, czy ma być wyświetlana data, ilość odwiedzin oraz w ilu kolumnach mają być wyświetlane artykuły.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"clear:both;text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/aktualnosci_listing.jpg\" style=\"width: 550px; height: 143px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Po stronie panelu zarządzania aktualnościami oraz kategoriami aktualności zarządza się poprzez menu <strong>Wygląd / Aktualności / Zarządzanie aktualnościami</strong>. W module tym w oknie po prawej stronie wyświetlane są <strong>wszystkie aktualności</strong> znajdujące się w bazie sklepu. Domyślnie są one posortowane wg daty dodania. W oknie po lewej stronie wyświetlane są <strong>kategorie aktualności</strong> - kategorie ułatwiają grupowanie aktualności i zarządzanie nimi. W porównaniu z grupami stron informacyjnych, których (grup) nie widać po stronie sklepu (nie można zrobić linku do danej grupy stron informacyjnych) - w przypadku aktualności w sklepie można dodać link do kategorii aktualności po kliknięciu w który wyświetlą się artykuły z danej kategorii. Klikając na wybraną kategorię w oknie po prawej stronie wyświetlone zostaną tylko artykuły z danej kategorii.<br />\r\n<br />\r\nPowyżej okien z artykułami i kategoriami znajdują się pole wyszukiwania. Umożliwia ono wyświetlanie tylko wybranych artykułów. Po wyszukaniu artykułów obok pola zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie warunków wyszukiwania i przywrócenie podstawowych opcji wyświetlania listingu. Opcja usuwa również wybór kategorii aktualności - nie usuwa wybranego sortowania. Poniżej filtrów znajduje się sekcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania aktualności w listingu.<br />\r\n<br />\r\nW oknie pole lewej stronie znajduje się lista kategorii aktualności. Pod listą znajduje się przycisk dodawania nowej kategorii. Listing kategorii aktualności wyświetla miniaturkę zdjęcia / obrazka reprezentującego kategorię, nazwę kategorii oraz ikony nawigacyjne umożliwiające usunięcie kategorii lub jej edycję. W przypadku usuwania kategorii aktualności zostają również usunięte artykuły przypisane do danej kategorii.<br />\r\n<br />\r\nPo prawej stronie znajduje się lista artykułów. W liście artykułów każdy artykuł jest wyświetlany w osobnym wierszu. Pierwsza kolumna umożliwia zaznaczenie artykułu (kilku artykułów z listy) i dokonanie na nich określonej operacji, np usunięcie wybranych artykułów - zadanie do wykonania można wybrać na dole listy produktów, a zatwierdzenie wykonania zadania następuje przez naciśnięcie przycisku <strong>Zapisz zmiany</strong>. Kolejna kolumna to id artykułu. W następnej kolumnie wyświetlany jest tytuł aktualności oraz nazwa kategorii do jakiej artykuł jest przypisany. Kolejna kolumna wyświetla datę dodania artykułu do bazy. Następna kolumna wyświetla ilość wyświetleń danego artykułu przez klientów (tylko dla domyślnego języka - w każdej wersji językowej jest oddzielny licznik odwiedzin). Kolejna kolumna wyświetla nazwy grup klientów dla jakich dostępny jest dany artykuł. Jeżeli wyświetlany jest znak - minusa - oznacza to, że treść artykułu jest dostępna dla wszystkich klientów, jeżeli są wyświetlone nazwy grup - oznacza to, że artykuł będzie widoczny tylko dla klientów przypisanych do określonych grup klientów. W kolejnej kolumnie zaznaczone jest czy artykuł jest aktywny czy wyłączony. Tą wartość także można zmienić odznaczając lub zaznaczając pole i zatwierdzając zmiany przyciskiem <strong>Zapisz zmiany</strong> na dole strony. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję artykułu lub jego usunięcie.</div>\r\n"),
("108","100","1","instrukcja","Dodawanie / edycja kategorii","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/kategorie_produktow_dodawanie.jpg\" style=\"width: 480px; height: 620px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Nową kategorie produktów dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową kategorię</strong>. Po kliknięciu zostanie wyświetlony formularz dodawania nowej kategorii.<br />\r\n<br />\r\nW części górnej formularza znajduję się okno wyboru kategorii nadrzędnej dla nowo dodawanej kategorii. Jeżeli dodawana kategoria ma być kategorią główną należy wybrać - brak kategorii nadrzędnej - jeżeli ma być podkategorią dla już istniejącej kategorii - należy wybrać jej nazwę. Kategorie są wyświetlone w formie drzewa - kliknięcie w ikonę z plusem lub minusem powoduje rozwinięcie lub zwinięcie podkategorii.<br />\r\n<br />\r\nPoniżej okna kategorii znajduje się pole Ścieżki zdjęcia. Umożliwia ono przypisanie do kategorii obrazka. 2-krotne kliknięcie w pole Ścieżka zdjęcia powoduje otworzenie przeglądarki zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta.<br />\r\n<br />\r\nKolejne pole to Grafika ikony. W tym polu definiuje się obrazek jaki będzie wyświetlany w boxie kategorii. Podobnie jak w w/w polu 2-krotne kliknięcie w pole spowoduje otworzenie przeglądarki zdjęć.<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/kategorie_box_ikonki.jpg\" style=\"width: 180px; height: 185px; margin-top: 15px; margin-bottom: 15px;margin-right: 15px; float: left;\" />Dodanie ikonek do kategorii nie jest obowiązkowe - jeżeli do kategorii zostaną przypisane ikonki i zostanie włączone wyświetlanie ikonek w konfiguracji boxu kategorii (menu Wygląd / Boxy - podczas edycji boxu kategorii) będą wyświetlane obok nazw kategorii. Ikonki przypisane do kategorii nie są skalowane w sklepie i są wyświetlane w oryginalnym rozmiarze - dlatego należy pamiętać, żeby nie wgrywać bardzo dużych grafik.<br />\r\n<br />\r\nPoniżej zdjęcia znajduje się pole sortowania - umożliwia ono wpisanie numeru kolejności wyświetlania kategorii w sklepie.<br />\r\n<br />\r\nNastępne pole to możliwość wyboru koloru kategorii. Przypisanie do kategorii koloru umożliwia wyświetlanie nazwy kategorii w boxie kategorii po stronie sklepu w kolorach. Dzięki temu można bardziej wyeksponować wybrane kategorie zmieniając im kolor wyświetlania. Aby nazwa kategorii była wyświetlana w kolorze należy oprócz wyboru koloru zaznaczyć pole: <strong>wyświetlaj tą kategorię w kolorze</strong>.<br />\r\n<br />\r\nKolejne pole to możliwość wyboru koloru <strong>tła</strong> kategorii. Funkcja działa podobnie jak opisana powyżej - z tą różnicą, że definiuje kolor tła, a nie kolor tekstu. Przypisanie do kategorii koloru tła umożliwia wyświetlanie kategorii w boxie kategorii po stronie sklepu w kolorach. Dzięki temu można bardziej wyeksponować wybrane kategorie zmieniając im kolor wyświetlania - można np ustawić czerwony kolor tła i biały tekst. Aby tło kategorii było wyświetlane w kolorze należy oprócz wyboru koloru zaznaczyć pole: <strong>wyświetlaj tło tej kategorii w kolorze</strong>.<br />\r\n<br />\r\nW dalszej części wyświetlane są pola nazwy kategorii, meta tagów (każda kategoria produktów może mieć indywidualne meta tagi - dokładny opis znaczenia meta tagów znajduje się w dalszej części instrukcji w dziale Produkty / Zakładka pozycjonowanie) oraz opisu kategorii. Są to dane, które uzupełnia się osobno dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Polem obowiązkowym jest pole nazwy kategorii. Jeżeli nie zostanie uzupełniona nazwa kategorii w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka. Opis nie jest wymagany - ale jest zalecany - jest on wyświetlany w sklepie nad produktami z danej kategorii po kliknięciu w link do kategorii. Dobrze napisany opis kategorii będzie poprawiał pozycjonowanie danej strony w wyszukiwarkach.<br />\r\n<br />\r\nPozycja to <strong>Adres URL</strong>. Umożliwia ona przygotowanie indywidualnego adresu URL dla kategorii. Sklep podczas tworzenia linków korzysta z tzw SEO - co oznacza przyjazne linki dla wyszukiwarek - nazwa linku do kategorii zawiera w sobie nazwę kategorii - dla przykładu kategoria o nazwie: Moja testowa będzie w sklepie miał link w postaci: moja-testowa-c-35.html - w treści linku wpisana jest nazwa kategorii oraz na końcu nr id kategorii dla identyfikacji w sklepie. Wpisując inną nazwę w pole Adres URL jako link będzie wyświetlana inna nazwa - sama kategoria w sklepie będzie dalej nazywała się tak jak powyżej ale np po wpisaniu w pole Adres URL: Moja ulubiona kategoria - link do kategorii będzie wyglądał tak: moja-ulubiona-kategoria-c-35.html - czyli będzie inny niż nazwa kategorii. Taka zmiana jest często stosowana przy pozycjonowaniu sklepu w wyszukiwarkach.<br />\r\n<br />\r\nPozycja <strong>Adres URL do kategorii w poprzednim sklepie</strong> jest przeznaczona dla klientów, którzy posiadali wcześniej sklep na innej platformie sklepowej i przenoszą produkty do platformy shopGold. Dzięki tej opcji możliwe jest przekierowanie starych linków z poprzedniego sklepu na nową platformę sklepu. W polu adresu trzeba wpisać adres kategorii jaki był w starym sklepie (sam link - bez adresu sklepu). Dzięki temu linki, które są dostępne np w wyszukiwarce google nie stracą swojej wartości, gdyż po ich kliknięciu w wynikach wyszukiwania klient zostanie przeniesiony na nowy adres w nowym sklepie. Do poprawnego działania przekierowań musi być włączony moduł przekierowań w menu Narzędzia / Przekierowanie URL.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/kategorie_zakladka.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 340px; height: 139px;\" />Podczas dodawania lub edycji istniejącej kategorii można także stworzyć <strong>dodatkową zakładkę </strong>dla produktów, która będzie wyświetlana na karcie produktu dla wszystkich produktów przypisanych dla danej kategorii. Dzięki temu można w prosty sposób przypisać identyczny opis dla wszystkich produktów, które są przypisane do kategorii. Żeby zakładka była wyświetlana w produktach musi być uzupełniona nazwa zakładki oraz treść zakładki. Jeżeli produkt jest przypisany do kilku kategorii i każda z kategorii będzie miała zdefiniowaną zakładkę to na karcie produktu będą wyświetlane zakładki dla wszystkich kategorii.</div>\r\n\r\n<div style=\"text-align:justify;\">Edycja istniejącej kategorii jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu - jedyna różnica jest taka, że nie ma okna wyboru kategorii nadrzędnej - ten parametr definiuje się tylko przy dodawaniu nowej kategorii.</div>\r\n"),
("109","102","1","instrukcja","Przenoszenie kategorii","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/kategorie_przenoszenie.jpg\" style=\"width: 380px; height: 239px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Jeżeli zajdzie potrzeba - możliwe jest w sklepie przeniesienie kategorii lub podkategorii do innej kategorii. W listingu kategorii znajduje się ikona nawigacyjna <img alt=\"alt\" src=\"obrazki/pomoc/ikona_przenoszenia.jpg\" style=\"width:18px;height:18px;\" />, która umożliwia przenoszenie wybranej kategorii. Po kliknięciu w ikonę zostanie wyświetlona podstrona, gdzie w oknie wyświetlone zostaną kategorie z opcją wyboru do której ma zostać przeniesiona wybrana kategoria. Aby przenieść kategorię należy zaznaczyć kategorię do której chcemy przenieść kategorię lub opcję - brak kategorii - jeżeli ma być kategorią główną. Po wciśnięciu przycisku <strong>Zapisz dane</strong> przeniesienie kategorii zostanie zapisane w bazie sklepu.<br />\r\n<br />\r\n<strong><span style=\"color:#ff0000;\">UWAGA</span></strong> Nie można przenieść kategorii nadrzędnej do jej podkategorii.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Po przeniesieniu kategorii do innej kategorii zmieni się adres danej kategorii w sklepie. Zmiana może wpłynąć na pozycjonowanie danego elementu w wyszukiwarkach.</div>\r\n"),
("110","456","0","instrukcja","Dodawanie / edycja kategorii aktualności","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/aktualnosci_kategorie_dodawanie.jpg\" style=\"width: 480px; height: 355px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Nową kategorie aktualności dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową kategorię</strong>. Po kliknięciu zostanie wyświetlony formularz dodawania nowej kategorii.<br />\r\n<br />\r\nW części górnej formularza znajduje się pole Ścieżki zdjęcia. Umożliwia ono przypisanie do kategorii obrazka. 2-krotne kliknięcie w pole Ścieżka zdjęcia powoduje otworzenie przeglądarki zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta.<br />\r\n<br />\r\nPoniżej można wybrać czy w listingu artykułów danej kategorii ma być wyświetlane pola do wyszukiwania informacji z artykułach. Włączone tej opcji będzie powodowało wyświetlanie nad listą artykułów pola wyszukiwarki:<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/aktualnosci_wyszukiwarka.jpg\" style=\"width: 301px; height: 131px;\" /><br />\r\n<br />\r\nKolejne pole to pole sortowania - umożliwia ono wpisanie numeru kolejności wyświetlania kategorii w sklepie.<br />\r\n<br />\r\nW dalszej części wyświetlane są pola nazwy kategorii, meta tagów (każda kategoria aktualności może mieć indywidualne meta tagi) oraz opisu kategorii. Są to dane, które uzupełnia się osobno dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Polem obowiązkowym jest pole nazwy kategorii. Jeżeli nie zostanie uzupełniona nazwa kategorii w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka. Opis nie jest wymagany - ale jest zalecany - jest on wyświetlany w sklepie nad artykułami z danej kategorii po kliknięciu w link do kategorii. Dobrze napisany opis kategorii będzie poprawiał pozycjonowanie danej strony w wyszukiwarkach.</div>\r\n\r\n<div style=\"text-align:justify;\">Edycja istniejącej kategorii jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.</div>\r\n"),
("111","457","0","instrukcja","Dodawanie / edycja artykułu","<div style=\"text-align:justify;\">Nowy artykuł dodaje się poprzez kliknięcie w przycisk <strong>dodaj nowy artykuł</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowego artykułu. Formularz dodawania jest podzielony na zakładki - w każdej zakładce definiuje się odpowiednie parametry.<br />\r\n<br />\r\nDostępne są 3 zakładki.<img alt=\"alt\" src=\"obrazki/pomoc/aktualnosci_artykul_dodawanie.jpg\" style=\"width: 600px; height: 345px; float: right; margin-left: 15px; margin-top: 15px; margin-bottom: 15px;\" /></div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\">Zakładka <strong>Podstawowe dane</strong> - w zakładce tej należy wybrać do jakiej kategorii będzie przypisany dodawany artykuł, można ustawić datę dodania artykułu (wg daty są wyświetlane artykuły w niektórych modułach - dzięki możliwości wpisania daty można ustawić artykuły w określonej kolejności), wpisać jej tytuł oraz treść strony. Tekst wpisywany w edytorze może mieć dowolną treść oraz może zawierać dowolne formatowania, obrazki itp. W edytorze należy wpisać pełną treść jaka ma być wyświetlana przez artykuł. Tytuł artykułu oraz treść wpisuje się osobno dla każdej wersji językowej sklepu. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniony tytuł artykułu w innych wersjach językowych - zostanie w te pola wstawiony tytuł z domyślnego języka. Dodatkowo można przypisać artykuł dla określonych grup klientów, dzięki czemu treść artykułu będzie widoczna tylko dla określonych klientów (przypisanych do określonych grup).</li>\r\n	<li style=\"text-align:justify;\">Zakładka <strong>Tekst skrócony</strong> - w tej zakładce można wpisać tekst skrócony artykułu. Może to być albo streszczenie albo początek tekstu. Tekst skrócony jest wyświetlany po kliknięciu w sklepie w kategorię aktualności i wyświetlaniu artykułów z danej kategorii. <img alt=\"alt\" src=\"obrazki/pomoc/aktualnosci_sklep_skroty.jpg\" style=\"width:400px;height:89px;margin-left:15px;margin-bottom:15px;float:right;\" />Jeżeli jest wprowadzony tekst skrócony wyświetla się on pod tytułem artykułu, a pod tekstem przycisk do przeczytania całości artykułu. Jeżeli tekst skrócony nie jest prowadzony wyświetla się tylko tytuł strony oraz przycisk do przeczytania całości artykułu. Po przejściu do wyświetlania artykułu w sklepie w zależności od ustawień konfiguracyjnych stron (menu <strong>Wygląd / Aktualności / Konfiguracja aktualności</strong>) - tekst skrócony może być wyświetlany na początku tekstu lub też nie - wtedy będzie widoczny tylko tekst pełny. Pole tekst skrócony nie jest wymagane.</li>\r\n	<li style=\"text-align:justify;\">Zakładka <strong>Pozycjonowanie</strong> - każdy artykuł podczas wyświetlania w sklepie może mieć indywidualne meta tagi. Zakładka umożliwia zdefiniowanie indywidualnych meta tagów dla danego artykułu. Meta tagi definiowane są dla każdej wersji językowej sklepu. Dodatkowo można zdefiniować tagi Open Graph dla poszczególnych artykułów.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Edycja istniejącego artykułu jest identyczna jak jej dodawanie. Formularz edycji ma takie same pola i zakładki jak przy dodawaniu.</div>\r\n"),
("112","575","1","instrukcja","Edycja - ustawienia ogólne","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/moduly_podsumowanie_edycja.jpg\" style=\"float: right; width: 391px; height: 190px; margin-left: 15px; margin-bottom: 15px;\" />Ustawienia modułów podsumowania zamówienie ograniczają się do podania nazwy jaka ma być wyświetlana klientowi w sklepie - należy ją wprowadzić we wszystkich występujących w sklepie językach oraz kolejności w jakiej dany moduł ma być wyświetlany w podsumowaniu zamówienia i jego wpływ na łączną wartość zamówienia.<br />\r\n<br />\r\nPodczas ustalania kolejności wyświetlania modułów należy kierować się następującymi zasadami:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\">Na pierwszym miejscu musi być wartość produktów</li>\r\n	<li style=\"text-align:justify;\">Na ostatnim miejscu w kolejności musi się znaleźć całkowita wartość zamówienia</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Wszystkie pozostałe moduły, które będą włączone muszą mieć kolejność wyświetlania zawartą pomiędzy dwoma powyższymi modułami - w przeciwnym wypadku całkowita wartość zamówienia może zostać błędnie wyliczana.<br />\r\n<br />\r\nKolejnym istotnym elementem dla obliczenia wartości zamówienia jest to jaki dany moduł ma wpływ na sumowanie zamówienia. Możliwe są trzy warianty: zwiększenie wartości, zmniejszenie wartości brak wpływu na wartość zamówienia. Łączna wartość zamówienia jest wynikiem zsumowania wszystkich włączonych w sklepie modułów podsumowania.<br />\r\n<br />\r\nUWAGA: moduły podsumowania zamówienia takie jak Punkty rabatowe - działają wówczas gdy odpowiednie opcje są włączone w programie (Konfiguracja / Konfiguracja sklepu / Ustawienia punktów rabatowych)</div>\r\n"),
("113","590","0","instrukcja","Konfiguracja połącznia Allegro","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/allegro_konfiguracja.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 570px; height: 600px;\" />Przed rozpoczęciem wystawiania aukcji ze sklepu na Allegro należy skonfigurować parametry połączenia. W tym celu przechodzimy do menu <strong>Integracje / Allegro / Parametry połączenia allegro</strong>. W zakładce tej wyświetlony zostanie formularz, w którym&nbsp; należy wprowadzić dane, które umożliwiają korzystanie z Allegro API i wystawianie towarów na aukcjach bezpośrednio ze sklepu.<br />\r\n<br />\r\nW pierwszej kolejności należy wybrać serwer allegro na którym będą wystawiane aukcji. Do wyboru są dwie możliwości: Serwer rzeczywisty oraz Serwer testowy. Serwer testowy umożliwia sprawdzenie poprawności wystawiania aukcji. Należy jednak zwrócić uwagę na to, że testowe środowisko allegro praktycznie nie odpowiada rzeczywistemu, więc część opcji może nie działać w nim prawidłowo.<br />\r\n<br />\r\nKolejnym polem niezbędnym do wystawiania aukcji jest <strong>klucz WebAPI</strong>. Klucz WebAPI należy wygenerować w serwisie allegro. Klucz WebAPI wygenerować może praktycznie każdy użytkownik Allegro. Takiej możliwości nie mają jedynie: użytkownicy kont bez pełnej aktywacji, posiadacze kont Junior, właściciele kont zarejestrowanych na zagranicznych odpowiednikach Allegro oraz Ci z nałożoną na konto blokadą.<br />\r\n<br />\r\nNastępne dwa pola nie są związane z wystawianiem aukcji, ale mogą zostać wykorzystane w szablonach - mogą zostać podstawione pod odpowiednie zmienne w celu utworzenia odpowiednich linków w szablonie. Są to pola Login - nazwa, jaką użytkownik loguje się do serwisu allegro oraz id użytkownika - jest to unikalny identyfikator użytkownika w serwisie allegro. Można go zobaczyć np. w linkach do strony użytkownika lub jego ofert, np. http://allegro.pl/listing/user/listing.php?us_id=<span style=\"color:#ff0000;\"><strong>3994488</strong></span><br />\r\n<br />\r\nW kolejnym oknie <strong> Parametry logowania (konto dodatkowe)</strong>&nbsp; - można wpisać dane drugiego konta allegro, które ma być używane do obsługi aukcji Allegro wystawianych z poziomu sklepu. Dzięki temu część aukcji może być wystawianych przy pomocy konta nr 1, a część przy pomocy konta nr 2. Po dodaniu danych drugiego konta i włączeniu aktywności tego konta we wszystkich miejscach gdzie następuję połączenie sklepu za allegro (wystawienie produktu na allegro, obsługa sprzedaży, zarządzanie aukcjami) będzie możliwość wyboru z jakiego konta mają być obsługiwane dane.<br />\r\n<br />\r\nW polach opisanych jako <strong>Status zamówienia</strong> i <strong>Domyślny komentarz</strong> można ustawić informacje, które będą wykorzystywane po zakończeniu aukcji. Status zamówienia - taki status jaki będzie ustawiony w tym miejscu otrzymają automatycznie zamówienia utworzone na podstawie zakończonych sprzedażą aukcji. Natomiast Domyślny komentarz - taka treść zostanie wstawiona podczas wystawiania komentarzy do zakończonych sprzedażą aukcji.<br />\r\n<br />\r\nOstatnia część formularza zawiera informację o tym jakie są aktualnie w wersje kategorii Allegro oraz struktury pól. Program generuje formularz wystawiania aukcji na podstawie pobranych z allegro definicji pól - w zależności od wybranej kategorii pola te mogą się zmieniać. Należy zwracać uwagę na to, żeby wersje kategorii i definicji pól, które są w sklepie były aktualne z tymi, które są obecnie na allegro.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/allegro_konfiguracja_import.jpg\" style=\"float:left;width:382px;height:111px;margin-right:15px;\" />Jeżeli wersje nie są aktualne należy kliknąć przycisk Aktualizuj - wówczas program pobierze i zapisze w bazie aktualne dane z serwisu allegro. Z uwagi na ilość danych proces aktualizacji może trwać kilkanaście minut.&nbsp;</div>\r\n"),
("114","0","0","pytanie","Dlaczego podczas wystawiania aukcji otrzymuję komunikat - Nie możesz wystawić przedmiotu w sklepie w tym kraju ?","Dzieje się tak ponieważ nie posiadają Państwo sklepu Allegro a zaznaczyli opcje Sklep (bez licytacji). Proszę w polu Typ Aukcji ustawić opcje Aukcja (z licytacją) lub Tylko Kup Teraz! (bez licytacji).<br />\r\nJeżeli mają być wystawiane aukcje typu Sklep, to użytkownik musi mieć założony sklep na Allegro."),
("115","465","0","instrukcja","Bannery - informacje ogólne","<div style=\"text-align:justify;\">Bannery - prezentacje graficzne - są ważnym elementem sklepu. Sklep składający się tylko z samych produktów nie będzie atrakcyjny dla klientów. Dlatego istotne jest, żeby dodatkowo w sklepie były dodawane różnego rodzaju prezentacje graficzne (bannery). Każdy banner w sklepie może przekierowywać do określonego linku (adresu w sklepie lub z poza sklepu). Bannery mogą być wyświetlane w różnych miejscach sklepu: w boxie z kolumnami lub modułach środkowych. Mogą mieć także różną postać - mogą być w formie statycznej lub animowanej. Bannery mogą wyświetlać zarówno statyczne obrazki jak i animacje flash lub kod html. Dzięki czemu można w sklepie wyświetlać kody bannerów przesłane np przez partnerów firmy.<br />\r\n<br />\r\nPoniżej przestawione są przykłady zastosowań bannerów w różnych miejscach sklepu.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_box.jpg\" style=\"width:100px;height:115px;float:right;margin-left:15px;\" />Wyświetlanie w <strong>boxie</strong> - bannery mogą być wyświetlane w boxie w kolumnie z boxami. W zależności od ustawień boxu (menu <strong>Wygląd / Boxy</strong>) może wyświetlać się jeden lub klika bannerów - box może także mieć wyłączony nagłówek - wtedy będzie wyświetlana tylko grafika. W boxie wyświetlane są bannery z określonej grupy bannerów - sama zasada wyświetlania boxów jest zależna od budowy boxu. Obrazki (bannery) wyświetlane w boxie nie są skalowane do wielkości boxu - należy pamiętać, żeby grafiki nie były większe niż box.\r\n\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_modul_srodkowy.jpg\" style=\"width:400px;height:134px;margin-left:15px;float:right;\" />Wyświetlanie w <strong>module środkowym</strong> - podobnie jak w boxie bannery mogą być wyświetlane w części środkowej sklepu - w zależności włączonego modułu (menu <strong>Wygląd / Moduły środkowe</strong>) i jego konfiguracji może wyświetlać się jeden lub kilka bannerów. Podobnie jak w boxie moduł wyświetlający bannery może mieć włączony nagłówek lub nie - wtedy będzie wyświetlana tylko grafika bannerów. Obrazki (bannery) wyświetlane w module nie są skalowane do wielkości modułu - należy pamiętać, żeby grafiki nie były większe niż cześć środkowa sklepu.\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_modul_srodkowy_animowany.jpg\" style=\"width:350px;height:136px;margin-left:15px;float:right;\" />Wyświetlanie w module środkowym w <strong>formie animowanej</strong> - w sklepie są dodane specjalne moduły (menu <strong>Wygląd / Moduły środkowe</strong>), które umożliwiają animowanie bannerów z określonej grupy. Moduły mają duże możliwości konfiguracyjne, m.in. ustawienie wysokości animacji, efektów animacji. W modułach animowanych bannerów mogą być wyświetlane tylko grafiki (zdjęcia) - nie mogą być dodawane do wyświetlania w postaci animowanej animacje flash ani kod html - takie elementy zostaną pominięte przy tworzeniu animacji bannerów.\r\n	<div style=\"clear:both\">&nbsp;</div>\r\n	</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_popup.jpg\" style=\"width:320px;height:164px;margin-left:15px;float:right;\" />Wyświetlanie bannerów w formie <strong>wyskakujących okien (popup)</strong> - taka forma bannerów wyświetla jeden banner przy pierwszym uruchomieniu sklepu (lub cyklicznie co kilka kliknięć). Banner jest wyświetlany na środku sklepu z przyciemnionym tłem (dokładne ustawienia zależą od konfiguracji bannerów popup - menu <strong>Wygląd / Bannery / Konfiguracja bannerów PopUp</strong>). Wyskakujące bannery mogą wyświetlać grafikę, animacje flash lub kod html (dzięki czemu można przygotować np kod zapisania się do newslettera).</li>\r\n</ol>\r\n"),
("116","591","0","instrukcja","Konfiguracja wystawiania aukcji Allegro","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/allegro_konfiguracja_wystawiania.jpg\" style=\"float: left; width: 500px; height: 1186px; margin-right: 15px;\" /> W tej opcji menu można zdefiniować domyślne wartości, które będą automatycznie wstawiane podczas wystawiania aukcji na allegro bezpośrednio ze sklepu. Formularz zawiera szereg pól określających parametry wystawianej aukcji.<br />\r\n<br />\r\nPrzy każdym polu jest szczegółowy opis dotyczący jego zawartości - opis jest generowany bezpośrednio z serwisu allegro.<br />\r\n<br />\r\nSą to dane adresowe sprzedającego, informacje oraz dane dotyczące wpłaty za wylicytowane towar.<br />\r\n<br />\r\nPodczas definiowania pola <strong>Format sprzedaży</strong> należy zwrócić uwagę na to, ze opcja Sklep (bez licytacji) dostępna jest tylko dla tych użytkowników, którzy posiadają zarejestrowany sklep w serwisie allegro. Jeżeli zostanie wybrana taka forma sprzedaży, a użytkownik nie posiada na allegro sklepu - wówczas podczas wystawiania aukcji zostanie zwrócony komunikat błędu <span style=\"color:#FF0000;\">Nie możesz wystawić przedmiotu w sklepie w tym kraju.</span> W takiej sytuacji można wystawiać tylko aukcje z licytacją lub w opcji <strong>Kup teraz</strong>.<br />\r\n<br />\r\nZaznaczenie opcji dodatkowych (pogrubienie, miniaturka, itp.) wiąże się z dodatkowymi opłatami podczas wystawiania aukcji - wszystkie opłaty są zgodne z cennikami allegro i ponoszone są na rzecz serwisu allegro.<br />\r\n<br />\r\nW przypadku zdjęć allegro na serwer allegro wysyłane jest tylko główne zdjęcie (jest ono wyświetlane także w listingu aukcji w allegro w postaci miniaturki). Za wysyłane główne zdjęcie ponosi się opłaty zgodnie z cennikiem allegro. Pozostałe zdjęcia aukcji, w tym zdjęcia wstawiane w treści aukcji poprzez znacznik [ZDJECIA] oraz użyte do tworzenia galerii przy użyciu znacznika [GALERIA] są zapisywane na serwerze na którym znajduje się sklep i nie są wysyłane na serwer allegro - przez to właściciel sklepu nie ponosi opłat z tytułu wyświetlania tych zdjęć. Podczas wyświetlania aukcji przez klientów na allegro zdjęcia są wyświetlane z serwera na którym zainstalowany jest sklep.<br />\r\n<br />\r\nKolejne części formularza umożliwiają zdefiniowanie wielkości zdjęć w galerii produktu oraz ilości wyświetlanych pozostałych aukcji. Galeria zdjęć jest wyświetlana w aukcji na podstawie zdjęć, które ma przypisane produkt w sklepie internetowym. Podczas wystawiania aukcji można wybrać, które zdjęcia mają zostać wykorzystane do stworzenia galerii zdjęć produktu. Pozostałe aukcje sprzedającego są wyświetlane w treści aukcji w formie grafik, które zawierają zdjęcie produktu, nazwę, cenę oraz ilość dni do zakończenia aukcji. Pozostałe aukcje są wyświetlane dynamicznie - czyli mogą się zmieniać w treści aukcji w zależności od innych wystawionych przez sprzedającego aukcji. Pozostałe aukcje są wyświetlane wg daty wystawienia. Zaleca się nie przekraczanie 12-15 pozostałych aukcji.<br />\r\n<br />\r\nW ostatniej części formularza dostępne są <strong>słowniki szablonów kosztów wysyłek</strong>. Opcja ta umożliwia tworzenie szablonów wysyłek (kosztów) i wykorzystywanie tych szablonów podczas wystawiania produktów na allegro. Standardowo w sklepie jest zdefiniowany podstawowy szablon wysyłek, który można dowolnie edytować - nie można go usunąć. Można tworzyć dowolną ilość nowych szablonów i definiować w nich indywidualne koszty dostaw. Podczas tworzenia nowych szablonów wysyłek należy wpisać dane dotyczące możliwych rodzajów wysyłek oraz ich kosztów. Jeżeli nie chcemy oferować niektórych wysyłek - należy wówczas pozostawić pola puste. W razie potrzeby można wpisać dane w trakcie wystawiania aukcji, jeżeli chcemy zaoferować jakąś wysyłkę sporadycznie tylko do wybranego produktu. Podczas wystawiania aukcji z poziomu sklepu w formularzu wystawiania aukcji będą dostępne w formie rozwijanej listy zdefiniowane szablony wysyłek - dzięki czemu można wybrać jaki szablon ma być użyty dla wystawianego produktu.</div>\r\n"),
("117","0","0","pytanie","Czy wystawianie aukcji na Allegro jest płatne ?","Koszt wystawienia aukcji na Allegro jest zgodny z cennikiem jaki aktualnie obowiązuje w serwisie Allegro. Wystawiający aukcje ponosi opłaty tylko i wyłącznie z tego tytułu."),
("118","593","0","instrukcja","Konfiguracja szablonów aukcji","<div style=\"text-align:justify;\"><img alt=\"alt\" height=\"183\" src=\"obrazki/pomoc/allegro_szablony.jpg\" style=\"margin-left:15px;margin-right:15px;float:right;\" width=\"575\" />W menu <strong>Integracje / Allegro / Konfiguracja szablonów aukcji</strong> jest możliwość zarządzania dostępnymi w programie szablonami aukcji. Po wybraniu tej opcji menu na ekranie jest wyświetlona lista zainstalowanych szablonów.<br />\r\n<br />\r\nNa liście znajduje się miniaturka szablonu, podkatalog w którym jest on umieszczony oraz informacja o tym, który szablon jest ustawiony jako domyślny.<br />\r\n<br />\r\nSzablony aukcji umieszczone są w katalogu <strong>/allegro</strong>. Budowa szablonu nie odbiega od standardowych szablonów aukcji, które są używane podczas wystawiania bezpośrednio z serwisu allegro. Jedyną różnicą jest zastosowanie dodatkowych tagów, które można używać w celu podstawiania odpowiednich zdefiniowanych wcześniej wartości podczas generowania aukcji ze sklepu.<br />\r\n<br />\r\nSzablony można edytować w edytorze HTML po kliknięciu w ikonkę edycji. Można również je modyfikować poza sklepem w dowolnym edytorze i później umieścić w katalogu /allegro w celu wykorzystania w sklepie.<br />\r\n<br />\r\nBudowa szablonu jest następująca :<br />\r\n&nbsp;\r\n<table align=\"center\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" height=\"163\" width=\"90%\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"text-align:left;\" width=\"30%\"><strong>/allegro</strong></td>\r\n			<td style=\"text-align:left;\">katalog w którym są umieszczone wszystkie szablony allegro - wspólny dla wszystkich szablonów</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>/allegro/nazwa_szablonu</strong></td>\r\n			<td style=\"text-align:left;\">podkatalog w którym jest umieszczony konkretny szablon</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>/allegro/nazwa_szablonu/obrazki</strong></td>\r\n			<td style=\"text-align:left;\">podkatalog w którym są umieszczone wszystkie grafiki wykorzystywane w danym szablonie</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>/allegro/nazwa_szablonu/szablon.txt</strong></td>\r\n			<td style=\"text-align:left;\">plik w formacie tekstowym w którym jest zapisany szablon allegro</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>/allegro/nazwa_szablonu/screen.jpg</strong></td>\r\n			<td style=\"text-align:left;\">plik zawierający podgląd szablonu</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<br />\r\nW szablonie mogą zostać wykorzystane następujące znaczniki :<br />\r\n&nbsp;\r\n<table align=\"center\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" height=\"163\" width=\"90%\">\r\n	<tbody>\r\n		<tr>\r\n			<td style=\"text-align:left;\" width=\"30%\"><b>[SERWER]</b></td>\r\n			<td style=\"text-align:left;\">Adres serwera, na którym jest zainstalowany sklep - adres sklepu w pełnej postaci z http://adres ....</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><b>[OPIS]</b></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla opis produktu - dane są zwracane w formie tekstu (formatowanie html takie jak podczas definiowania opisu w panelu zarządzania sklepu). W miejsce znacznika jest podstawiany opis zdefiniowany w menu <strong>Asortyment / Produkty</strong> - zakładka Opis lub jeżeli jest wypełniony indywidualny opis produktu dla allegro to zwracany jest opis z zakładki Dane Allegro.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><b>[NAZWA]</b></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla nazwę produktu - dane są zwracane w formie tekstu (bez formatowania html). W miejsce znacznika jest podstawiana nazwa zdefiniowana w menu<strong> Asortyment / Produkty</strong> - zakładka Podstawowe dane lub jeżeli jest wypełniona indywidualna nazwa produktu dla allegro to zwracana jest nazwa z zakładki Dane Allegro.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[DODATKOWA_NAZWA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla dodatkowy tekst do nazwy produktu (definiowany przy nazwie produktu podczas edycji produktu w panelu zarządzania w menu <strong>Asortyment / Produkty</strong>).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><b>[ZDJECIA]</b></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla zdjęcia produktu wybrane do wyświetlania podczas wystawiania aukcji produktu. Każde zdjęcie znajduje się w tagu html &lt;(div)&gt;. Wynik znacznika [ZDJECIA] jest zwracany w postaci:<br />\r\n			<br />\r\n			&lt;(div)&gt;&lt;(img src=&quot;..... nazwa obrazka .....&quot; /)&gt;&lt;(/div)&gt;<br />\r\n			&lt;(div)&gt;&lt;(img src=&quot;..... nazwa obrazka .....&quot; /)&gt;&lt;(/div)&gt;<br />\r\n			&lt;(div)&gt;&lt;(img src=&quot;..... nazwa obrazka .....&quot; /)&gt;&lt;(/div)&gt;<br />\r\n			<br />\r\n			W szablonie allegro poprzez zastosowanie stylów css można zdefiniować wygląd wyświetlanych zdjęć i elementu &lt;(div)&gt;.<br />\r\n			<br />\r\n			Poniżej prezentujemy przykład stylów css do wyświetlania zdjęć produktu jednego pod drugim z wyśrodkowaniem wyświetlanego zdjęcia oraz marginesem zdjęć 10px. Cały znacznik [ZDJECIA] należy wstawić w nadrzędny element div:<br />\r\n			<br />\r\n			&lt;(div id=&quot;ZdjeciaProduktu&quot;)&gt;[ZDJECIA]&lt;(/div)&gt;<br />\r\n			<br />\r\n			Kod css do w/w przykładu:<br />\r\n			<br />\r\n			#ZdjeciaProduktu div { margin:10px; text-align:center; }</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><b>[ID_ALLEGRO]</b></td>\r\n			<td style=\"text-align:left;\">Id użytkownika w serwisie Allegro - zwraca numer użytkownika zdefiniowany w menu <strong>Integracje / Allegro / Konfiguracja połączenia Allegro</strong>.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><b>[UZYTKOWNIK_ALLEGRO]</b></td>\r\n			<td style=\"text-align:left;\">Login użytkownika w serwisie Allegro - zwraca numer użytkownika zdefiniowany w menu <strong>Integracje / Allegro / Konfiguracja połączenia Allegro</strong>.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[CECHY_PRODUKTU]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla cechy produktu wystawianego produktu (wybrane podczas wystawiania aukcji - nie wszystkie cechy jakie ma produkt). Cechy są generowane w postaci kodu html. Każda cecha jest zawarta w tagu &lt;(span)&gt; oraz dodatkowo nazwa i wartość cechy w tagu &lt;(b)&gt;. Wynik znacznika [CECHY_PRODUKTU] jest zwracany w postaci:<br />\r\n			<br />\r\n			&lt;(span)&gt;&lt;(b)&gt;..... nazwa cechy .....&lt;(/b)&gt;&lt;(b)&gt;..... wartość cechy .....&lt;(/b)&gt;&lt;(/span)&gt;<br />\r\n			&lt;(span)&gt;&lt;(b)&gt;..... nazwa cechy .....&lt;(/b)&gt;&lt;(b)&gt;..... wartość cechy .....&lt;(/b)&gt;&lt;(/span)&gt;<br />\r\n			<br />\r\n			W szablonie allegro poprzez zastosowanie stylów css można zdefiniować wygląd wyświetlanych tagów html, np wyróżnić kolorem wartość cechy.<br />\r\n			<br />\r\n			Poniżej prezentujemy przykład stylów css do wyświetlania cech produktu jednej pod drugą z wyśrodkowaniem cech na ekranie, kolor nazwy cechy w kolorze czerwonym, margines pomiędzy cechami 5px, rozmiar czcionki wartości cechy 15px. Cały znacznik [CECHY_PRODUKTU] należy wstawić w nadrzędny element div:<br />\r\n			<br />\r\n			&lt;(div id=&quot;CechyProduktu&quot;)&gt;[CECHY_PRODUKTU]&lt;(/div)&gt;<br />\r\n			<br />\r\n			Kod css do w/w przykładu:<br />\r\n			<br />\r\n			#CechyProduktu span {<br />\r\n			&nbsp;&nbsp;&nbsp; display:block;<br />\r\n			&nbsp;&nbsp;&nbsp; text-align:center;<br />\r\n			&nbsp;&nbsp;&nbsp; margin:5px;<br />\r\n			}<br />\r\n			#CechyProduktu span b:first-child {<br />\r\n			&nbsp;&nbsp;&nbsp; color:#ff0000;<br />\r\n			}<br />\r\n			#CechyProduktu span b:last-child {<br />\r\n			&nbsp;&nbsp;&nbsp; font-size:15px;<br />\r\n			}</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[CENA_WYWOLAWCZA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla cenę wywoławczą produktu na aukcji - zwraca wartość wpisaną w formularzu przy wystawianiu aukcji. Wartość sformatowana w formie waluty np 10,00 zł</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[CENA_MINIMALNA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla cenę minimalną produktu na aukcji - zwraca wartość wpisaną w formularzu przy wystawianiu aukcji. Wartość sformatowana w formie waluty np 10,00 zł</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[CENA_KUP_TERAZ]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla cenę KUP TERAZ produktu na aukcji - zwraca wartość wpisaną w formularzu przy wystawianiu aukcji. Wartość sformatowana w formie waluty np 10,00 zł</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[LICZBA_SZTUK]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla ilość produktu wystawionego na aukcji - zwraca wartość liczbową wpisaną w formularzu przy wystawianiu aukcji.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[STAN_PRODUKTU]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla stan produktu zdefiniowany w słowniku stanów produktów - w formie tekstu (bez formatowania html).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[GWARANCJA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla informacje o gwarancji produktu zdefiniowaną w słowniku gwarancji produktu - w formie tekstu lub linku - w zależności od przypisanej do produktu gwarancji.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[CZAS_WYSYLKI]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla czas wysyłki produktu wystawionego na aukcji&nbsp; - zwraca wartość liczbową (ilość dni) wpisaną w formularzu przy wystawianiu aukcji. Wartość formatowana do ilości godzin lub dni, np 24 godziny lub 2 dni.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[NUMER_KATALOGOWY]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla numer katalogowy produktu - w formie tekstu (bez formatowania html).<br />\r\n			Jeżeli wystawiany na aukcji produkt posiada cechy i dana kombinacja cech posiada indywidualny numer katalogowy zostaje wyświetlony nr katalogowy wybranej kombinacji cech.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[KOD_PRODUCENTA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla kod producenta produktu - w formie tekstu (bez formatowania html).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[KOD_EAN]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla kod EAN - w formie tekstu (bez formatowania html).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[PKWIU]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla PKWiU - w formie tekstu (bez formatowania html).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[PRODUCENT]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla nazwę producenta produktu - w formie tekstu (bez formatowania html).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[LOGO_PRODUCENTA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla logo producenta produktu - w formie obrazka graficznego. Wielkość logotypu jest definiowana w menu<strong> Integracje / Allegro / Konfiguracja wystawiania aukcji</strong>. Grafika logotypu nie jest wysyłana na serwer allegro i jest wyświetlana z serwera na którym znajduje się sklep internetowy.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[WAGA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla wagę produktu w KG - w formie tekstu (bez formatowania html).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[DODATKOWA_ZAKLADKA_x_NAZWA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik zwraca tytuł dodatkowej zakładki o nr x - x to wartości od 1 do 4 - wyświetla nazwy zakładki definiowanej podczas edycji lub dodawania produktu w menu <strong>Asortyment / Produkty</strong>. Wynik wyświetlany jest w formie tekstu (bez formatowania html).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[DODATKOWA_ZAKLADKA_x_TRESC]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik zwraca treść dodatkowej zakładki o nr x - x to wartości od 1 do 4 - wyświetla treść zakładki definiowanej podczas edycji lub dodawania produktu w menu <strong>Asortyment / Produkty</strong>. Dane są zwracane w formie tekstu (formatowanie html takie jak podczas definiowania treści zakładki w panelu zarządzania sklepu).</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[DODATKOWE_POLA_OPISOWE]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla dodatkowe pola opisowe wystawianego produktu. Dodatkowe pola opisowe są generowane w postaci kodu html. Każde pole opisowe jest zawarte w tagu &lt;(span)&gt; oraz dodatkowo nazwa i wartość pola w tagu &lt;(b)&gt;. Wynik znacznika [DODATKOWE_POLA_OPISOWE] jest zwracany w postaci:<br />\r\n			<br />\r\n			&lt;(span)&gt;&lt;(b)&gt;..... nazwa pola .....&lt;(/b)&gt;&lt;(b)&gt;..... wartość pola .....&lt;(/b)&gt;&lt;(/span)&gt;<br />\r\n			&lt;(span)&gt;&lt;(b)&gt;..... nazwa pola .....&lt;(/b)&gt;&lt;(b)&gt;..... wartość pola .....&lt;(/b)&gt;&lt;(/span)&gt;<br />\r\n			<br />\r\n			W szablonie allegro poprzez zastosowanie stylów css można zdefiniować wygląd wyświetlanych tagów html, np wyróżnić kolorem wartość pola opisowego.<br />\r\n			<br />\r\n			Poniżej prezentujemy przykład stylów css do wyświetlania dodatkowych pól opisowych produktu jednego pod drugim z wyśrodkowaniem pól na ekranie, margines pomiędzy poszczególnymi polami 5px; szerokość nazwy pola 150px. Cały znacznik [DODATKOWE_POLA_OPISOWE] należy wstawić w nadrzędny element div:<br />\r\n			<br />\r\n			&lt;(div id=&quot;PolaOpisoweProduktu&quot;)&gt;[DODATKOWE_POLA_OPISOWE]&lt;(/div)&gt;<br />\r\n			<br />\r\n			Kod css do w/w przykładu:<br />\r\n			<br />\r\n			#PolaOpisoweProduktu {<br />\r\n			&nbsp;&nbsp;&nbsp; display:inline-block;<br />\r\n			&nbsp;&nbsp;&nbsp; margin:0px auto;<br />\r\n			}<br />\r\n			#PolaOpisoweProduktu span {<br />\r\n			&nbsp;&nbsp;&nbsp; display:block;<br />\r\n			&nbsp;&nbsp;&nbsp; text-align:center;<br />\r\n			&nbsp;&nbsp;&nbsp; margin:5px;<br />\r\n			}<br />\r\n			#PolaOpisoweProduktu span b {<br />\r\n			&nbsp;&nbsp;&nbsp; display:inline-block;<br />\r\n			&nbsp;&nbsp;&nbsp; vertical-align:middle;<br />\r\n			}<br />\r\n			#PolaOpisoweProduktu span b:first-child {<br />\r\n			&nbsp;&nbsp;&nbsp; width:150px;<br />\r\n			}<br />\r\n			<br />\r\n			WAŻNE: Pola opisowe mogą mogą być zarówno w formie tekstu jak i grafik. Tak samo jak wyświetlane dodatkowe pola w sklepie internetowym. Jeżeli w produkcie wartość pola ma postać graficzną to zostanie wyświetlony obrazek w miejscu wartości pola. Grafiki dodatkowych pól nie są wysyłane na serwer allegro i są wyświetlane z serwera na którym znajduje się sklep internetowy.<br />\r\n			<br />\r\n			W menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do produktów</strong> można zdefiniować, które pola opisowe mają być wyświetlane w aukcjach allegro. Do allegro są przesyłane tylko te pola, które mają zaznaczoną opcję wyświetlania w allegro.</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[GALERIA]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla galerię zdjęć produktu; <strong>galeria jest generowana w postaci gotowego kodu html do którego w aukcji trzeba umieścić style css</strong><br />\r\n			<br />\r\n			<img alt=\"alt\" height=\"327\" src=\"obrazki/pomoc/allegro_galeria.jpg\" style=\"margin-right:15px;margin-right:15px;float:left;\" />Obok na zdjęciu pokazany jest wygląd gotowej galerii zdjęć produktu; galeria składa się z dużego zdjęcia oraz miniaturek wyświetlanych pod dużym zdjęciem produktu. Po najechaniu kursorem myszy na miniaturkę zostaje wyświetlone duże zdjęcie produktu.<br />\r\n			<br />\r\n			Podczas wystawiania aukcji produktu można wybrać jakie zdjęcia będą wyświetlane w galerii zdjęć produktu. Domyślnie zaznaczone są wszystkie zdjęcia.<br />\r\n			<br />\r\n			W menu <strong>Integracje / Allegro / Konfiguracja wystawiania aukcji</strong> definiuje się wielkość miniaturek zdjęć oraz wielkość dużego zdjęcia (rozmiar w pikselach). Podczas ustawiania wielkości obrazków należy pamiętać, żeby szerokość dużego zdjęcia nie była większa niż szerokość kolumny w której jest wyświetlana galeria.<br />\r\n			<br />\r\n			Dla poprawnego działania galerii w kodzie szablonu w stylach css należy umieścić style (kolorystykę ramek czy innych elementów należy dopasować do własnego szablonu allegro; prosimy nie zmieniać nazw klas oraz obiektów - zmiana może spowodować błędne wyświetlanie galerii zdjęć):<br />\r\n			<br />\r\n			#GaleriaZdjeciaAllegro {<br />\r\n			&nbsp;&nbsp;&nbsp; position:relative;<br />\r\n			&nbsp;&nbsp;&nbsp; overflow:hidden;<br />\r\n			&nbsp;&nbsp;&nbsp; display:inline-block;<br />\r\n			&nbsp;&nbsp;&nbsp; padding:10px;<br />\r\n			&nbsp;&nbsp;&nbsp; border:1px solid #dbdbdb;<br />\r\n			}<br />\r\n			#GaleriaZdjeciaMiniaturki {<br />\r\n			&nbsp;&nbsp;&nbsp; text-align:center;<br />\r\n			&nbsp;&nbsp;&nbsp; padding:10px 0px 10px 0px;<br />\r\n			}<br />\r\n			#GaleriaZdjeciaMiniaturki .GaleriaZdjeciaMiniatura {<br />\r\n			&nbsp;&nbsp;&nbsp; display:inline-block;<br />\r\n			&nbsp;&nbsp;&nbsp; padding:5px;<br />\r\n			&nbsp;&nbsp;&nbsp; margin:5px;<br />\r\n			&nbsp;&nbsp;&nbsp; cursor:pointer;<br />\r\n			&nbsp;&nbsp;&nbsp; border:2px solid #cccccc;<br />\r\n			&nbsp;&nbsp;&nbsp; transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -moz-transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -webkit-transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -o-transition: all 0.50s ease-in-out;<br />\r\n			}<br />\r\n			#GaleriaZdjeciaMiniaturki .GaleriaZdjeciaMiniatura:hover {<br />\r\n			&nbsp;&nbsp;&nbsp; border:2px solid #000000;<br />\r\n			}<br />\r\n			#GaleriaZdjeciaMiniaturki .GaleriaZdjeciaMiniatura span {<br />\r\n			&nbsp;&nbsp;&nbsp; opacity:0;<br />\r\n			&nbsp;&nbsp;&nbsp; filter:alpha(opacity=0);<br />\r\n			&nbsp;&nbsp;&nbsp; position:absolute;<br />\r\n			&nbsp;&nbsp;&nbsp; left:0px;<br />\r\n			&nbsp;&nbsp;&nbsp; top:0px;<br />\r\n			&nbsp;&nbsp;&nbsp; text-align:center;<br />\r\n			&nbsp;&nbsp;&nbsp; width:100%;<br />\r\n			&nbsp;&nbsp;&nbsp; transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -moz-transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -webkit-transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -o-transition: all 0.50s ease-in-out;<br />\r\n			}<br />\r\n			#GaleriaZdjeciaMiniaturki .GaleriaZdjeciaMiniatura:hover span {<br />\r\n			&nbsp;&nbsp;&nbsp; opacity:1;<br />\r\n			&nbsp;&nbsp;&nbsp; filter:alpha(opacity=100);<br />\r\n			}<br />\r\n			#GaleriaZdjeciaMiniaturki .GaleriaZdjeciePierwsze {<br />\r\n			&nbsp;&nbsp;&nbsp; opacity:1;<br />\r\n			&nbsp;&nbsp;&nbsp; filter:alpha(opacity=100);<br />\r\n			&nbsp;&nbsp;&nbsp; position:absolute;<br />\r\n			&nbsp;&nbsp;&nbsp; left:0px;<br />\r\n			&nbsp;&nbsp;&nbsp; top:0px;<br />\r\n			&nbsp;&nbsp;&nbsp; text-align:center;<br />\r\n			&nbsp;&nbsp;&nbsp; width:100%;<br />\r\n			&nbsp;&nbsp;&nbsp; transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -moz-transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -webkit-transition: all 0.50s ease-in-out;<br />\r\n			&nbsp;&nbsp;&nbsp; -o-transition: all 0.50s ease-in-out;<br />\r\n			}<br />\r\n			#GaleriaZdjeciaMiniaturki:hover .GaleriaZdjeciePierwsze {<br />\r\n			&nbsp;&nbsp;&nbsp; opacity:0;<br />\r\n			&nbsp;&nbsp;&nbsp; filter:alpha(opacity=0);<br />\r\n			}<br />\r\n			#GaleriaZdjeciaDuze {<br />\r\n			&nbsp;&nbsp;&nbsp; position:relative;<br />\r\n			&nbsp;&nbsp;&nbsp; overflow:hidden;<br />\r\n			&nbsp;&nbsp;&nbsp; padding:10px 0px 10px 0px;<br />\r\n			}</td>\r\n		</tr>\r\n		<tr>\r\n			<td style=\"text-align:left;\"><strong>[INNE_AUKCJE]</strong></td>\r\n			<td style=\"text-align:left;\">Znacznik wyświetla pozostałe aukcje jakie są oferowane przez sprzedającego. Wynik jest zwracany w postaci linków do poszczególnych aukcji oraz obrazków z aukcjami (obrazek zawiera zdjęcie produktu, nazwę produktu, cenę produktu oraz datę zakończenia aukcji).<br />\r\n			<br />\r\n			<img alt=\"alt\" src=\"obrazki/pomoc/allegro_inne_aukcje.jpg\" style=\"margin-right: 15px; float: left; width: 280px; height: 170px;\" />Obok na zdjęciu pokazany jest wygląd innych aukcji oferowanych przez sprzedającego. Każdy obrazek jest jednocześnie linkiem do danej aukcji.<br />\r\n			<br />\r\n			W menu <strong>Integracje / Allegro / Konfiguracja wystawiania aukcji</strong> definiuje się ilość wyświetlanych na aukcji linków do pozostałych aukcji sprzedającego.<br />\r\n			<br />\r\n			Rozmiar obrazków prezentujących inne aukcje to 250px szerokości x 110px wysokości. Kod jaki zwraca znacznik jest wyświetlany w postaci:<br />\r\n			<br />\r\n			&lt;(a href=&quot;http://adres-sklepu.pl/allegro.php?link=x&quot;)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(img src=&quot;http://adres-sklepu.pl/allegro.php?aukcja=x,xx&quot;)&gt;<br />\r\n			&lt;(/a)&gt;<br />\r\n			<br />\r\n			Dla poprawnego wyświetlania obrazków innych aukcji w kodzie szablonu w stylach css należy umieścić odpowiednie style; poniżej zamieszczamy przykładowy kod css, który układa obrazki obok siebie z 5px marginesem. Cały znacznik [INNE_AUKCJE] należy wstawić w nadrzędny element div, np:<br />\r\n			<br />\r\n			&lt;(div id=&quot;InneAukcje&quot;)&gt;[INNE_AUKCJE]&lt;(/div)&gt;<br />\r\n			<br />\r\n			Kod css do w/w przykładu:<br />\r\n			<br />\r\n			#InneAukcje a {<br />\r\n			&nbsp;&nbsp;&nbsp; display:inline-block;<br />\r\n			&nbsp;&nbsp;&nbsp; margin:5px;<br />\r\n			}<br />\r\n			<br />\r\n			WAŻNE: Grafiki aukcji są zapisywane w katalogu w którym są przechowywane zdjęcia produktów w podkatalogu /allegro_foto - katalog ten musi posiadać prawa do zapisu i odczytu - bez pełnych praw sklep nie będzie mógł utworzyć grafik aukcji.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<br />\r\nPrzykłady wykorzystania znaczników w szablonie allegro:<br />\r\n<br />\r\n\#naglowek { background: url(&quot;[SERWER]/naglowek.jpg&quot;) repeat-x; height:170px; } - w definiowaniu stylu wyświetlanego elementu w miejsce [SERWER] zostanie podstawiony adres sklepu i w wystawionej aukcji powyższa definicja stylu przyjmie postać - #naglowek { background: url(&quot;[http://www.adres.sklepu.pl/allegro/nazwa_szablonu/obrazki/naglowek.jpg&quot;) repeat-x; height:170px; } i zostanie poprawnie wyświetlona grafika w szablonie.<br />\r\n<br />\r\n<code>http://www.allegro.pl/show_user_auctions.php?uid=[ID_ALLEGRO]</code> - w miejsce [ID_ALLEGRO] zostanie wstawiony znacznik zdefiniowany podczas konfiguracji połączenia allegro i kod w wystawionej aukcji będzie miał postać - <code>http://www.allegro.pl/show_user_auctions.php?uid=9877897</code> - kierując do listy aukcji danego użytkownika</div>\r\n"),
("119","594","0","instrukcja","Wystawianie aukcji","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/allegro_wystawianie.jpg\" style=\"float: right; width: 600px; height: 99px; margin-left: 15px; margin-bottom: 15px;\" />W celu wystawienia produktu na aukcji allegro należy przejść do menu <strong>Asortyment / Produkty</strong>. Na liście produktów w kolumnie z ikonami nawigacyjnymi dostępna jest ikona umożliwiająca wystawienie wybranego produktu na aukcji w serwisie allegro.<br />\r\n<br />\r\nNa samej górze formularza wyświetlane są informacje o tym do jakiego serwera allegro jesteśmy aktualnie zalogowani, jakie są aktualne wersje kategorii i definicje pól w serwisie allegro oraz w bazie danych w sklepie. Należy zwracać uwagę, aby zawsze posiadać aktualne wersje - aktualizacje można wykonać w menu <strong>Integracje / Allegro / Konfiguracja połączenia z allegro</strong>. Jeżeli w sklepie są aktywne 2 konta allegro - w tym miejscu można przełączyć się na drugie konto i wystawić aukcje poprzez inne wybrane konto allegro.<br />\r\n<br />\r\nPoniżej znajdują się wszystkie informacje, które należy wprowadzić podczas wystawiania aukcji. Część z nich jest automatycznie wypełniana na podstawie danych zapisanych w konfiguracji allegro oraz pobieranych z informacji o wystawianym produkcie.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/allegro_wystawianie2.jpg\" style=\"float: right; margin-left: 15px; width: 450px; height: 441px; margin-bottom: 10px;\" />Na początku należy wybrać kategorię, w której dana aukcja zostanie wystawiona. Jeżeli podczas dodawania czy edycji produktu w menu <strong>Asortyment / Produkty</strong> w zakładce Dane Allegro została zdefiniowana kategoria Allegro - zostanie ona automatycznie wstawiona w pole kategorii. W zależności od wybranej kategorii mogą zostać wczytane dodatkowe pola, które należy wybrać w celu poprawnego wystawienia aukcji.<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/allegro_wystawianie_dodatkowe_pola.jpg\" style=\"margin-top: 15px; margin-bottom: 15px; width: 365px; height: 130px;\" /><br />\r\nNiektóre z nich są obowiązkowe do wybrania - w przeciwnym razie jeżeli nie zostaną wybrane zostanie zwrócony komunikat błędu podczas wystawiania aukcji.<br />\r\n<br />\r\nPodczas wystawiania aukcji elementy takie jak nazwa produktu, opis, dostępna ilość czy cena są automatycznie pobierane z bazy danych i wstawiane do formularza. Użytkownik może te wartości samodzielnie modyfikować przed wystawieniem aukcji.<br />\r\n<br />\r\nDo aukcji można dołączyć zdjęcia produktu. Zdjęcie główne jest automatycznie dodawane jako podstawowe zdjęcie na wystawianej aukcji. Można również dołączyć zdjęcia dodatkowe - jeżeli zostały do produktu dopisane. Zdjęcia dodatkowe - w zależności od tego czy w ustawieniach wystawiania aukcji została określona opcja czy zdjęcia mają być wysyłane do allegro, czy zapisywane na własnym serwerze będą w aukcji odpowiednio wyświetlane w galerii zdjęć - jeżeli zostaną wysłane na serwer allegro lub w miejscu znacznika [ZDJECIA] w szablonie jeżeli będą wyświetlane z własnego serwera. Dodatkowo można wybrać które zdjęcia mają być wykorzystane do tworzenia galerii produktu. Domyślnie zaznaczone są wszystkie zdjęcia produktu. Zdjęcia do galerii nie są przesyłane na serwer allegro - w przypadku wyświetlania aukcji zdjęcia są wyświetlane z serwera na którym znajduje się sklep internetowy.<br />\r\n<br />\r\nWszystkie pozostałe pola formularza są zgodne z polami dostępnymi podczas wystawiania aukcji bezpośrednio w serwisie allegro. Wpisuje się w nie czas trwania, aukcji, formę aukcji, cenę licytowanego produktu, ilość oraz informacje o płatności i dostawie.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/allegro_wystawianie_wysylki.jpg\" style=\"float: left; margin-right: 15px; margin-bottom: 10px; width: 500px; height: 84px;\" />W ostatniej części formularza są informacje o sposobach wysyłki jakie chcemy udostępnić na aukcji. Podczas wystawiania aukcji należy wybrać szablon z jakiego mają być pobrane dane wysyłek (szablon definiuje się w menu <strong>Integracja / Allegro / Konfiguracja wystawiania aukcji</strong>). Po wybraniu z listy rozwijanej szablonu wysyłek zostanie wczytany odpowiedni szablon i podstawione nowe koszty wysyłek. Jeżeli zachodzi potrzeba udostępnienia innych opcji dla aktualnie wystawianego produktu - to wystarczy wpisać parametry w dodatkowych opcjach wysyłki. Jeżeli dodatkowe opcje zostaną wypełnione, to znajdą się one w aktualnie wystawianej aukcji.<br />\r\n<br />\r\nPoniżej pól wyboru wysyłek i dodatkowych opcji znajduje się pole wyboru szablonu jaki ma zostać użyty do wystawienia aukcji. Domyślnie wybrany jest szablon, który został ustawiony jako domyślny w menu <strong>Integracje / Allegro / Konfiguracja szablonów aukcji</strong>.<br />\r\n<br />\r\nPo poprawnym wypełnieniu wszystkich pól formularza, można jeszcze przed ostatecznym wystawieniem aukcji kliknąć na dole formularza przycisk <strong>Sprawdź poprawność</strong> - program wówczas przeprowadzi symulację wystawienia produktu na allegro. W przypadku wystąpienia błędów w formularzu zostanie wyświetlony komunikat informujący o przyczynie błędu. Natomiast jeżeli wszystko zostało wypełnione poprawnie - wówczas wyświetlona zostanie informacja o tym, ze aukcja jest przygotowana poprawnie i jakie są szacunkowe koszty jej wystawienia.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/allegro_poprawnosc.jpg\" style=\"float: left; margin-right: 15px; margin-bottom: 15px; width: 450px; height: 153px;\" />Po tym jak otrzymamy informację, że aukcja została przygotowana poprawnie - można kliknąć przycisk <strong>Wystaw aukcje</strong>.<br />\r\n<br />\r\nAukcja zostanie automatycznie wystawiona w serwisie allegro. W programie wyświetlona zostanie informacja o numerze aukcji oraz link do niej w serwisie allegro.</div>\r\n"),
("120","596","0","instrukcja","Zarządzanie aukcjami","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/allegro_lista.jpg\" style=\"margin-bottom: 15px; margin-right: 15px; float: left; width: 640px; height: 223px;\" />W tej opcji obsługa sklepu ma możliwość zarządzania aukcjami, które zostały wystawione na allegro ze sklepu.<br />\r\n<br />\r\nPo wybraniu z menu opcji <strong>Integracje / Allegro / Zarządzanie aukcjami</strong> wyświetlona zostanie lista aukcji, które zostały wystawione w serwisie Allegro.<br />\r\n<br />\r\nW celu uaktualnienia informacji o wystawionych aukcjach należy kliknąć znajdujący się na dole strony przycisk <strong>Pobierz wszystkie dane o aukcjach</strong>. Po wybraniu tej akcji program sklepu łączy się z serwisem allegro i uaktualnia zapisy o <u>wszystkich trwających aktualnie</u> aukcjach. Obok tego przycisku znajduje się drugi przycisk <strong>Pobierz dane od ostatniej synchronizacji</strong>. Po wybraniu tej akcji program sklepu łączy się z allegro i uaktualnia zapisy aukcji <u>od ostatniej synchronizacji</u> (nie pobiera danych wszystkich aukcji). Maksymalna ilość danych (operacji) jaka jest pobierana przy pomocy tego przycisku to 100. Dlatego też - jeżeli synchronizacja była wykonywana dość&nbsp; dawno (np kilka dni) - należy wykonać pełną synchronizację (ponieważ ilość operacji od ostatniej synchronizacji może przekroczyć 100 - są w to wliczane operacje wystawienia aukcji, sprzedaży, zmiany danych w aukcji etc). Dodatkowo można użyć przycisku <strong>Pobierz dane zaznaczonych aukcji</strong> - dzięki czemu są pobierane dane tylko zaznaczonych w listingu aukcji.<br />\r\n<br />\r\nW nagłówku modułu znajduje się informacja o dacie ostatniej synchronizacji z Allegro oraz opcje sortowania listingu aukcji. Poniżej opcji sortowania dostępny jest link umożliwiający <strong>dodanie nowej aukcji</strong> bezpośrednio z Allegro (moduł opisany na osobnej podstronie instrukcji). Poniżej dostępne są filtry, które umożliwiają wyświetlanie aukcji spełniających określone warunki. W nagłówku dostępny jest także filtr kategorii - jest on podzielony na dwa okna - w oknie po lewej stronie wyświetlane są kategorie wg allegro w jakich są wystawione produkty ze sklepu - w oknie po prawej kategorie sklepu. Wybranie jednej z kategorii powoduje wyświetlenie aukcji - tylko z danej kategorii.<br />\r\n<br />\r\nJeżeli w liście aukcji znajdują się aukcje, które posiadają nieaktualne dane (np świeżo wystawione) dodatkowo będzie wyświetlany komunikat nad listą aukcji oraz przycisk do pobrania aktualnych danych będzie się także wyświetlał nad listą aukcji.<br />\r\n<br />\r\nW poszczególnych kolumnach wyświetlone są następujące informacje: <strong>ID aukcji</strong> - jest to identyfikator aukcji nadawany podczas wystawiania przez allegro. Przy identyfikatorze aukcji mogą być wyświetlane ikonki - informujące o dodatkowych wariantach danej aukcji:<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/allegro_lista_legenda.jpg\" style=\"width: 601px; height: 35px;\" /><br />\r\n<br />\r\nNastępne kolumny to zdjęcie produktu oraz szczegóły dotyczące nazwy produktu, producenta i dodatkowych cech, które zostały wybrane podczas wystawiania aukcji.<br />\r\n<br />\r\nJeżeli pozycja aukcji posiada niepełne dane aukcji przy ID aukcji będzie wyświetlana dodatkowo ikona w kolorze żółtym informująca, że dana aukcja nie jest w pełni zsynchronizowana z danymi w allegro.<br />\r\n<br />\r\nW kolumnie <strong>Format</strong> wyświetlona jest ikonka informująca o formie sprzedaży. Dostępne opcje to <strong>Kup teraz</strong>, <strong>Sklep</strong> oraz <strong>Aukcja z licytacją</strong>. W następnych dwóch kolumnach wyświetlone są informacje o dacie rozpoczęcia i zakończenia danej aukcji. Kolejne kolumny to informacje statystyczne dotyczące ilości wystawionych produktów, ceny produktu, ilości złożonych ofert oraz wyświetleń aukcji. W kolumnie <strong>Status</strong> wyświetlona jest ikonka informująca o tym czy dana aukcja trwa, czy została już zakończona. Ikona wznowienia aukcji jest aktywna pomimo zakończenia aukcji tak długo jak długo dana aukcja nie jest przeniesiona do archiwum przez serwis Allegro.<br />\r\n<br />\r\nW ostatniej kolumnie znajdują się ikony nawigacyjne. Umożliwiają one przeglądanie szczegółowych informacji o wybranej aukcji, w tym również informacji o ewentualnych transakcjach jeżeli zostały w aukcji zawarte. Ponadto jest ikonka umożliwiająca ponowne wystawienie wybranej aukcji - po jej kliknięciu zostanie w serwisie Allegro wystawiona aukcja o identycznych parametrach jak aukcja źródłowa. Jeżeli aukcja w danej chwili trwa - aktywna jest również ikona zakończenia aukcji przed terminem. Po jej kliknięciu wyświetlane jest dodatkowe pytanie czy podczas kończenia aukcji odwołać oferty, które zostały w niej złożone. W tym miejscu znajdują się także ikony do aktualizowania stanu ilości wystawionych produktów, zmiany zdjęcia oraz ceny produktu bezpośrednio na allegro. Jeżeli w sklepie stan magazynowy jest mniejszy niż ilość wystawiona na allegro - przy użyciu tej ikony można zmniejszyć ilość produktów wystawionych na allegro (zostanie zmniejszona do ilości produktu w magazynie). Jeżeli w sklepie jest włączona kontrola stanów magazynowych (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu</strong>) to dodatkowo jeżeli stan magazynowy w sklepie jest niższy niż ilość na allegro - wartości ilości będą wyświetlane w kolorze czerwonym z ostrzeżeniem.<br />\r\n<br />\r\nWśród ikon nawigacyjnych dostępna jest także ikona edycji. Umożliwia ona zmianę niektórych danych dla trwającej aukcji. Dzięki edycji można zmienić nazwę produktu, opis lub szablon wysyłek. Po wejściu w edycję aukcji trzeba wybrać, który parametr aukcji będzie modyfikowany. Po wprowadzeniu zmian należy wcisnąć przycisk Zmień dane na aukcji - po czym dane w aukcji Allegro zostaną zmienione. Allegro ma pewne ograniczenia w zakresie edycji aukcji - nie można np zmieniać parametrów dla aukcji - dla których była dokonana sprzedaż.<br />\r\n<br />\r\nPoprzez ikony nawigacyjne można również usunąć z bazy danych zapis o wybranej aukcji klikając w ikonkę krzyżyka - usuwa to tylko zapis informacji o aukcji w bazie sklepu - nie wpływa w żaden sposób na informacje, które znajdują się w serwisie allegro.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"332\" src=\"obrazki/pomoc/allegro_aukcja_szczegoly.jpg\" style=\"margin-left:15px;float:right;margin-bottom:15px;\" width=\"578\" />Po wybraniu akcji wyświetlenia szczegółów danej aukcji pokaże się okno, w którym znajdują się dokładne informacje o wystawionej aukcji.<br />\r\n<br />\r\nJeżeli w wybranej aukcji były oferty kupna, to wyświetlona jest ich lista wraz z informacjami o kupującym, dacie transakcji, cenie za którą został sprzedany produkt.<br />\r\n<br />\r\nW ostatniej kolumnie jest informacja o tym, czy kupujący wypełnił po zakończeniu aukcji formularza pozakupowy. Jeżeli formularz został wypełniony, to wówczas podczas tworzenia w sklepie zamówienia na podstawie aukcji zostaną automatycznie pobrane informacje dotyczące wybranej przez kupującego formy dostawy i płatności. W przeciwnym wypadku dane te trzeba ręcznie uzupełnić w generowanym zamówieniu.<br />\r\n<br />\r\nW poszczególnych pozycjach listingu ikony nawigacyjne umożliwiają operacje na pojedynczej aukcji. Sklep umożliwia także operacje na <strong>wielu aukcjach na raz.</strong> Służy do tego pierwsza kolumna w listingu aukcji oznaczona jak <strong>Akcja</strong>. Zaznaczając wybrane pozycje (aukcje) można poprzez dostępną pod listingiem listę wyboru dokonać określonych operacji na wielu aukcjach na raz. Funkcja ta umożliwia masowe usunięcie, wznowienie czy aktualizacje stanu ilości dla wielu aukcji na raz. Po wyborze określonej aukcji do wykonania jest realizacja następuje poprzez zatwierdzenie przyciskiem <strong>Wykonaj</strong>, który znajduje się pod listą wyboru możliwych akcji do wykonania.</div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("121","466","0","instrukcja","Grupy bannerów","<div style=\"text-align:justify;\"><strong>Grupy bannerów</strong> ułatwiają zarządzanie bannerami i wyświetlanie tylko określonych bannerów. Każdy nowo dodawany banner można przypisać do konkretnej grupy bannerów dzięki czemu będzie od wyświetlany w sklepie w określonym przez administratora sklepie miejscu. <img alt=\"alt\" src=\"obrazki/pomoc/bannery_wybor_grupy.jpg\" style=\"width:350px;height:86px;margin-left:15px;margin-bottom:15px;float:right;\" />Można wybrać w boxie reklamy czy modułach animowanych bannerów z jakiej grupy mają wyświetlać się bannery.<br />\r\n<br />\r\nGrupy bannerów obsługuje się w menu <strong>Wygląd / Bannery Grupy bannerów</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu grup bannerów. Standardowo w sklepie jest zdefiniowane kilka najczęściej używanych grup bannerów wraz z opisami ich przeznaczenia. Powyżej listy znajduje się przycisk <strong>dodawania nowej grupy</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/bannery_grupy_lista.jpg\" style=\"width:550px;height:144px;margin-bottom:15px;margin-right:15px;float:left;\" />W liście każda grupa jest wyświetlana&nbsp;w osobnym wierszu. Sam listing jest bardzo prosty. Zawiera: id grupy, kod grupy oraz opis. Przy każdej pozycji wyświetlane są ikony nawigacyjne które umożliwiają usunięcie grupy lub jej edycję.<br />\r\n<br />\r\nDodawanie nowej grupy jest również bardzo proste. Ogranicza się do wpisania kodu nowo dodawanej grupy oraz opisu. Kod grupy nie może zawierać spacji i polskich znaków - musi być unikalny - np BANNERY_ANIMACJA. Podczas edycji grupy modyfikować można wyłącznie opis grupy, kod grupy jest nieedytowalny.</div>\r\n<br />\r\n<strong><span style=\"color:#ff0000;\">UWAGA</span></strong> W przypadku usuwania grupy zostają również usunięte strony informacyjne do niej przypisane."),
("122","467","0","instrukcja","Obsługa bannerów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_lista.jpg\" style=\"width:550px;height:250px;margin-left:15px;margin-bottom:15px;float:right;\" />Bannerami reklamowymi w panelu administracyjnym sklepu zarządza się w menu <strong>Wygląd / Bannery / Zarządzanie bannerami</strong>. Moduł wyświetla w oknie wszystkie bannery jakie zostały dodane do sklepu. Powyżej okna z listingiem znajdują się opcja filtrowania. Umożliwia ona wyświetlenie bannerów z określonej grupy. Po wybraniu określonej grupy obok filtru zostanie wyświetlony przycisk <strong>wyłącz filtry</strong> - kliknięcie w przycisk powoduje usunięcie warunku filtrowania i przywrócenie podstawowych opcji wyświetlania listingu.<br />\r\n<br />\r\nListing nie posiada modułu sortowania, bannery w listingu są posortowane wg nazwy grupy do jakiej należą oraz numeru sortowania.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">W liście każdy banner jest wyświetlany&nbsp;w osobnym wierszu. Pierwsza kolumna wyświetla nr id banneru w bazie sklepu. Kolejna kolumna wyświetla grupę do jakiej jest przypisany dany banner, a następna kolumna wyświetla opis grupy do jakiej jest przypisany banner - ma to na celu ułatwienie identyfikacji do czego wykorzystywany jest dany banner. W następnej kolumnie wyświetlana jest miniaturka grafiki banneru. Jeżeli banner jest animacją flash lub kodem html w miejscu obrazka wyświetlany jest znak minusa. Jeżeli banner jest grafiką to w kolejnej kolumnie wyświetlana jest rozdzielczość w pikselach grafiki banneru. Następna kolumna wyświetla nazwę banneru. Kolejna dla jakiego języka jest dostępny dany banner. Różne bannery mogą być widoczne w różnych wersjach językowych sklepu. Następna kolumna wyświetla datę dodania banneru do bazy, a kolejna ilość kliknięć - tzn ile razy klienci kliknęli w dany banner. Jeżeli banner jest grafiką lub animacją flash sklep zlicza ilość kliknięć przez klientów w dany banner. Dzięki czemu administrator sklepu może sprawdzić, które bannery mają największą klikalność. Kolejna kolumna wyświetla pole do wpisania numeru sortowania - wpisując odpowiednie wartości można ustawić kolejność wyświetlania bannerów w sklepie - jest to szczególnie przydane w modułach animowanych bannerów. Przedostatnia kolumna wyświetla status banneru - czy ma być wyświetlany w sklepie czy nie. Zielona ikonka oznacza, że banner jest wyświetlany w sklepie, szara, że jest nieaktywny. Zmianę aktywności (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę aktywności. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję banneru lub jego usunięcie.</div>\r\n"),
("123","468","0","instrukcja","Dodawanie / edycja bannerów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_dodawanie.jpg\" style=\"width: 480px; height: 121px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Nowe bannery dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem dodawania nowego banneru. W części górnej formularza należy wpisać nazwę banneru (jest to tekst, który będzie się wyświetlał przy kursorze myszy po najechaniu na dany banner w sklepie). Dalej trzeba wybrać do jakiej grupy będzie należał dodawany banner. Jeżeli chcemy utworzyć nową grupę dla bannerów należy kliknąć w przycisk <strong>dodaj nową grupę</strong>. Po wciśnięciu przycisku zostanie wyświetlony dodatkowy formularz gdzie należy wpisać nazwę nowej grupy oraz opis. Poniżej wyboru grupy trzeba wybrać wersję językową sklepu do jakiej ma być przypisany banner. Jeżeli banner nie ma być powiązany z żadnym językiem należy wybrać opcję - wszystkie dostępne.<br />\r\n<br />\r\nPoniżej w/w pól znajduje się opcja wyboru czy banner będzie obrazkiem czy kodem html. Od wyboru opcji zależy dalsza część formularza dodawania.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_dodawanie_grafika.jpg\" style=\"width: 400px; height: 133px; margin-left: 15px; margin-bottom: 15px; float: right;\" />jeżeli zostanie zaznaczona opcja <strong>w formie obrazka</strong> - to pozostaną trzy pola do uzupełnienia. Pierwsze pole do adres URL do jakiego ma kierować (przenosić) dany banner. Musi być podany pełen adres z http:// ... Następne pole to Ścieżka obrazka. W tym polu wybiera się jaki obrazek / zdjęcie będzie bannerem. <img alt=\"alt\" src=\"obrazki/pomoc/bannery_dodatkowy_tekst.jpg\" style=\"width:200px;height:54px;margin:10px;margin-left:0px;float:left;\" />2-krotne kliknięcie w pole Ścieżka obrazka powoduje otworzenie przeglądarki zdjęć z możliwością wybrania obrazka banneru lub wgrania nowego z komputera klienta. Kolejne pole to dodatkowy tekst. To pole jest wykorzystywane w niektórych modułach bannerów - tekst wprowadzony w tym polu jest wyświetlany / nałożony na banner.</li>\r\n	<li style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_dodawanie_html.jpg\" style=\"width:350px;height:98px;margin-left:15px;margin-bottom:15px;float:right;\" />jeżeli zostanie zaznaczona opcja <strong>jako kod HTML</strong> - to pojawi się tylko jedno pole do wstawienia kodu html. Może to być zarówno kod html jak i kod języka Javascript. Może to być także inny dowolny kod, który zostanie przetworzony przez przeglądarkę internetową i wyświetlony po stronie sklepu. Najczęściej takie bannery są stosowane przy współpracy sklepu z innymi sklepami czy portalami, które udostępniają swoje bannery właśnie w postaci kodu do wklejenia na stronę www.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Ostatnią opcją przy dodawaniu nowego banneru jest możliwość przypisania wyświetlania danego banneru tylko dla wybranych kategorii produktów. Jeżeli moduł bannerów zostanie ustawiony do wyświetlania również na podstronach sklepu (podczas edycji modułu bannerów w menu <strong>Wygląd / Moduły środkowe</strong>) i zostaną wybrane określone kategorie - to banner będzie wyświetlany w sliderze bannerów tylko po wejściu w określone kategorie produktów - dzięki czemu można dla różnych kategorii produktów stworzyć różne bannery reklamowe.<br />\r\n<br />\r\nEdycja istniejącego banneru jest identyczna jak jej dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.</div>\r\n"),
("124","597","0","instrukcja","Sprzedaż","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/allegro_sprzedaz.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 624px; height: 223px;\" />W tej opcji mamy możliwość tworzenia w sklepie zamówień na podstawie sprzedaży produktów na allegro.<br />\r\n<br />\r\nPo wybraniu w menu pozycji <strong>Integracje / Allegro / Sprzedaż </strong>wyświetlona zostanie lista ofert kupna złożonych w aukcja wystawionych ze sklepu na allegro. W celu pobrania aktualnych informacji o zakończonych sprzedażach należy kliknąć przycisk <strong>Pobierz aktualne dane o aukcjach z Allegro</strong>. W wyniku tego program połączy się z serwisem allegro i zaktualizuje w bazie dane o wszystkich operacjach sprzedaży dotyczących aukcji wystawionych poprzez sklep.<br />\r\n<br />\r\nW pierwszej kolumnie znajduje się ikonka po najechaniu na którą wyświetlone zostaną szczegóły dotyczące dane sprzedaży. W następnej kolumnie znajdują się chceckboxy umożliwiające zaznaczenie kilku transakcji i zbiorcze <strong>wystawienie do nich komentarzy</strong> lub <strong>utworzenie zamówień dla wybranych transakcji</strong>. W następnej kolumnie wyświetlona jest jest nazwa produktu, którego aukcja dotyczy.<br />\r\n<br />\r\nW dalszej kolejności wyświetlane są informacje dotyczące kupującego takie jak nick, adres e-mail, ilość zakupionych przedmiotów w jednej aukcji, data zakupu, cena za jaką został produkt zakupiony.<br />\r\n<br />\r\nW kolumnie o nazwie <strong>Formularz</strong> wyświetlona jest informacja o tym czy kupujący wypełnił formularz pozakupowy na allegro. Ma to wpływ na sposób generowania w sklepie zamówienia.<br />\r\n<br />\r\nJeżeli kupujący wypełnił formularz pozakupowy, to w trakcie generowania zamówienia automatycznie jest w nim wstawiany sposób wysyłki oraz płatności jakie kupujący wybrał w formularzu. Jeżeli natomiast formularz nie został wypełniony przez kupującego - wówczas informacje te należy w zamówieniu uzupełnić ręcznie.<br />\r\n<br />\r\nJeżeli w sklepie zostało już wygenerowane zamówienie - jego numer wyświetla się w kolumnie <strong>Numer zamówienia</strong>. W ostatniej kolumnie umieszczona została ikonka umożliwiająca wygenerowanie zamówienia na podstawie transakcji zawartej na allegro. W przypadku gdy ikona zostanie kliknięta, a zamówienie było już utworzone - wówczas program wyświetli informacje o tym fakcie i nie pozwoli na wygenerowanie kolejnego zamówienia.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/allegro_sprzedaz_komentarze.jpg\" style=\"float: left; margin-right: 15px; width: 489px; height: 115px;\" />W tym miejscu można również wystawić komentarze do transakcji na allegro. Po zaznaczeniu wybranych aukcji i wybraniu z listy w polu <strong>Wykonaj akcje</strong> na dole formularza opcji <strong>Napisz komentarz do zaznaczonych</strong> wyświetlone zostaną dodatkowe pola umożliwiające wystawienie komentarzy do aukcji.<br />\r\n<br />\r\nDomyślnie wpisany jest tekst, który został zdefiniowany w menu ustawień aukcji. W trakcie wystawiania komentarzy tekst ten może zostać zmieniony przez obsługę sklepu.<br />\r\n<br />\r\nPo wybraniu oceny oraz wpisaniu treści komentarza należy kliknąć przycisk <strong>Wykonaj</strong>. W tym momencie do zaznaczonych transakcji zostaną przesłane do allegro komentarze. Podobnie poprzez wybranie opcji <strong>utwórz zamówienia dla zaznaczonych aukcji</strong> można utworzyć masowo zamówienia dla wielu aukcji na raz.</div>\r\n"),
("125","611","0","instrukcja","Porównywarki cen","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/porownywarki.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 640px; height: 190px;\" />Po wybraniu z menu pozycji <strong>Integracje / Porównywarki</strong> wyświetlona zostanie lista wszystkich dostępnych w programie wtyczek dla porównywarek internetowych.<br />\r\n<br />\r\nLista zawiera podstawowe informacje o ustawieniach dla danej porównywarki, datę ostatniego wykonanego eksportu, ilość produktów jakie zostały zapisane do pliku XML.<br />\r\n<br />\r\nOstatnia kolumna zawiera ikony nawigacyjne umożliwiające wykonanie poszczególnych akcji takich jak: generowanie pliku XML, edycja parametrów generowanych plików oraz podgląd wygenerowanego pliku.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/porownywarki_konfiguracja.jpg\" style=\"width: 450px; height: 284px; float: left; margin-right: 15px; margin-bottom: 15px;\" />Przed rozpoczęciem generowania plików XML należy odpowiednio ustawić parametry dla danej porównywarki. Po wybraniu ikony edycji wyświetlony zostanie formularz umożliwiający zdefiniowanie opcji w jaki sposób ma być generowany plik. Zawartość formularza jest zależna od opcji, które zostaną w nim zaznaczone. Do podstawowego wygenerowania pliku - wystarczy tylko zaznaczyć opcje tak jak rysunku obok.<br />\r\n<br />\r\nPrzy takim ustawieniu program uwzględni wszystkie produkty znajdujące się w sklepie i wygeneruje plik XML według podstawowego schematu dla danej porównywarki określonego w jej dokumentacji.<br />\r\n<br />\r\nJeżeli nie chcemy, żeby do porównywarki były przesyłane wszystkie produkty znajdujące się w sklepie, to mamy do wyboru dodatkowe opcje: <strong>tylko zaznaczone produkty</strong> - eksportowane będą wówczas produkty, które w ustawieniach mają zaznaczoną opcję <strong>do porównywarek</strong> - dotyczy to wówczas każdego produktu indywidualnie. Inną możliwością jest zaznaczenie opcji <strong>tylko wybrane kategorie</strong>. Wówczas w formularzu zostanie wyświetlone dodatkowe okno, w którym mamy możliwość zaznaczenia kategorii z których produkty zostaną przesłane do porównywarki. <img alt=\"alt\" src=\"obrazki/pomoc/porownywarki_konfiguracja_kategorie.jpg\" style=\"width: 550px; height: 370px; margin: 15px; float: right;\" /><br />\r\n<br />\r\nPo wybraniu tej opcji i zaznaczeniu kategorii do pliku XML dla określonej porównywarki eksportowane będą tylko produkty, które należą do wybranych kategorii w sklepie. Ostatnią możliwą opcją jest <strong>tylko wybrani producenci</strong> - która daje możliwość zaznaczenia producentów z których produkty zostaną przesłane do porównywarki.<br />\r\n<br />\r\nJak napisano wcześniej - standardowo do pliku XML są zapisywane produkty zgodnie z ogólną strukturą pliku XML danej porównywarki przeznaczoną dla większości sklepów.<br />\r\n<br />\r\nW przypadku, gdy sklep prowadzi specyficzną sprzedaż określoną w dokumentacji porównywarki taką jak np. książki, perfumy, filmy, itp. może być wymagane zapisanie do pliku XML dodatkowych informacji o produktach. W takiej sytuacji można skorzystać z <em>dodatkowych pól do produktów</em> - pod warunkiem, że zostały one wcześniej zdefiniowane w menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do produktów</strong> oraz że zostały uzupełnione podczas wprowadzania produktów. Wówczas w ustawieniach dla danej porównywarki można skorzystać z opcji <strong>Format pliku: własny</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/porownywarki_konfiguracja_pola.jpg\" style=\"float: left; width: 430px; height: 103px; margin-right: 15px; margin-bottom: 15px;\" />Po wybraniu tej opcji w formularzu ustawień zostaną wyświetlone pola, które zostały wcześniej zdefiniowane do produktów.<br />\r\n<br />\r\nW formularzu należy zaznaczyć które pola mają zostać uwzględnione w generowanym pliku XML oraz wpisać ich nazwę pod jaką mają zostać umieszczone. Informacje dotyczące nazw pól dostępne są w dokumentacjach udostępnianych przez serwisy porównywarek.<br />\r\n<br />\r\nDla przykładu jeżeli generujemy plik dla porównywarki CENEO i w sklepie posiadamy w sprzedaży książki, to w pliku XML powinny znaleźć się następujące pola:&nbsp;<br />\r\n<br />\r\n<span style=\"color:#ff0000;\">Autor, ISBN, Ilosc_stron, Wydawnictwo, Rok_wydania, Oprawa, Format</span><br />\r\n<br />\r\nnazwy pól należy wpisać dokładnie w takiej formie jaka jest zapisana w dokumentacji (wielkość liter, podkreślenia, brak polskich znaków).<br />\r\n<br />\r\nPo takim zdefiniowaniu w generowanym pliku XML znajdą się dodatkowe informacje specyficzne dla określonej branży sklepu.</div>\r\n"),
("126","469","0","instrukcja","Bannery wyskakujące (popup)","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/bannery_popup_duzy.jpg\" style=\"width:400px;height:241px;float:right;margin-left:15px;margin-right:15px;\" />Bannery wyskakujące tzw popup to reklama graficzna wyświetlana w osobnym oknie przeglądarki, po wejściu klienta do sklepu. Banner popup wyświetla się &quot;na wierzchu&quot; okna przeglądarki - przykrywając część zawartości sklepu. Zaletami takiej formy bannerów są wysoka oglądalność, przyciąganie uwagi i wymuszenie na kliencie określonej akcji (klient musi zamknąć okno banneru popup, żeby przeglądać zawartość sklepu).<br />\r\n<br />\r\nStandardowe bannery w sklepie nie wymagają indywidualnej konfiguracji - ich konfiguracja znajduje się w modułach czy boxach, które mają wyświetlać bannery. Inaczej zarządzanie / konfiguracja wygląda w przypadku bannerów popup. Do tego typu bannerów przewidziany jest w sklepie osobny moduł konfiguracji, który znajduje się w menu <strong>Wygląd / Bannery / Ustawienia bannerów popup</strong>.<br />\r\n<br />\r\nW w/w menu można zdefiniować elementy bannerów popup. Poszczególne opcje to:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Przez ile dni mają być ważne cookies</strong> - sklep do wyświetlania bannerów popup wykorzystuje pliki cookies (tzw ciasteczka). Ten parametr określa czy ciasteczko banerów popup ma być pamiętane na komputerze klienta tylko przez okres do kiedy klient przebywa&nbsp; w sklepie i nie zamknie przeglądarki (wartość 0) lub czy ma być pamiętane również przez określoną ilość dni po zamknięciu przeglądarki.</li>\r\n	<li style=\"text-align:justify;\"><strong>Co ile kliknięć wyświetlać banner</strong> - określa czy banner popup ma się wyświetlić danemu klientowi tylko raz (wartość 0) po wejściu do sklepu lub czy banner ma się pojawiać do określoną ilość kliknięć.</li>\r\n	<li style=\"text-align:justify;\"><strong>Po ilu sekundach zamknąć automatycznie banner</strong> - określa ilość sekund po jakich ma się automatycznie sam zamknąć / zniknąć banner. Jeżeli będzie wpisana wartość 0 to banner sam się nie zamknie / zniknie i klient będzie musiał zamknąć go samemu.</li>\r\n	<li style=\"text-align:justify;\"><label><strong>Czy ściemniać ekran podczas wyświetlania banneru</strong> - definiuje czy przy wyświetlaniu banneru, pod bannerem ma się pokazywać ciemne tło - przy takim tle banner jest lepiej widoczny.</label></li>\r\n	<li style=\"text-align:justify;\"><label><strong>Czy kliknięcie na przyciemnionym obszarze ma zamykać banner</strong> - przy opcji na &quot;nie&quot; banner będzie można zamknąć tylko poprzez kliknięcie w krzyżyk (górny prawy narożnik banneru), opcja &quot;tak&quot; powoduje, że kliknięcie w dowolny obszar poza bannerem spowoduje zamknięcie okna banneru</label>.</li>\r\n	<li style=\"text-align:justify;\"><strong>W jaki sposób ma się pojawiać banner</strong> - dostępne są cztery formy pojawia się banneru: standard - normalnie wyświetlenie bez efektu animacji, rozjaśnienie - banner pojawi się z efektem rozjaśnienia - od pełnej przezroczystości do pełnego pojawienia się treści, rozwijanie - banner rozwinie się z góry na dół, spadanie - banner spadnie z góry.</li>\r\n	<li style=\"text-align:justify;\"><strong>W jaki sposób ma się zamykać banner</strong> - dostępne są trzy formy znikania banneru - na podobnej zasadzie jak przy pojawianiu się banneru.</li>\r\n</ol>\r\n"),
("127","612","0","instrukcja","Systemy śledzące i afiliacyjne, wysuwane zakładki","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/integracje_sledzenie.jpg\" style=\"float: left; width: 685px; height: 292px; margin-right: 15px;\" />Program posiada wbudowaną możliwość integracji z wieloma serwisami umożliwiającymi prowadzenie statystyk oraz kampanii reklamowych takich jak Google, Zaufane Opinie CENEO, Opineo Facebook, Nasza klasa i inne. Włączenie wybranych integracji sprowadza się do wpisania id lub kodu otrzymanego w danym serwisie i włączeniu wybranej opcji.<br />\r\n<br />\r\nPo wpisaniu tych parametrów w panelu administracyjnym sklepu kod dla danego systemu zostanie automatycznie umieszczony na stronach sklepu.\r\n<div class=\"cl\">&nbsp;</div>\r\n<span style=\"font-size:18px;\"><strong>Systemy śledzące.</strong></span><br />\r\n<br />\r\nAby korzystać z Google Analytics trzeba włączyć moduł oraz wpisać kod otrzymany w Google dla danej domeny sklepu. Numer powinien mieć postać np UA-2623593-4. Tylko ten fragment otrzymanego kodu należy wpisać w pole <strong>Identyfikator google</strong>. Google Analytics to bardzo przydatne narzędzie do analityki internetowej, które pomaga właścicielom stron uzyskać informacje, jak użytkownicy korzystają ze sklepu. Dzięki Google Analytics właściciel sklepu ma wgląd w najróżniejsze raporty dotyczące sposobu zachowywania się użytkowników odwiedzających sklep. W celu korzystania z opcji e-commerce Google Analytics należy dodatkowo opcję tę włączyć w serwisie Google w ustawieniach dla danej strony (po zalogowaniu się na swoje konto w Google Analytics).<br />\r\n<br />\r\nKolejny system to narzędzia Google dla Webmasterów, które są przydatne dla osób, które chcą analizować informacje na temat danych związanych z pozycjonowaniem sklepu. Jest to bardzo użyteczne narzędzie, które służy do zbierania informacji na temat swoich witryn internetowych. Umożliwia weryfikowanie indeksowania stron sklepu, optymalizowanie go pod kątem wyszukiwarek, dostarcza wielu innych danych interesujących z punktu widzenia SEO. Aby móc korzystać z funkcji narzędzi google, należy zweryfikować prawa do własności domeny (sklepu). W tym celu należy wprowadzić <strong>Kod weryfikacyjny</strong>, który otrzymuje się po rejestracji w Google dla Webmasterów. Po wpisaniu kodu i zapisaniu go - będzie można w Google dokonać weryfikacji witryny. Po poprawnej weryfikacji będzie można korzystać z funkcji, które udostępnia to narzędzie, np możliwość przesyłania mapy sklepu w formacie XML.<br />\r\n<br />\r\nKolejne systemy to system Ceneo Zaufane Opinie, Opineo oraz Wiarygodne Opinie okazje.info. Są to systemy służące do zbierania opinii o transakcjach w sklepach internetowych. Zasada działania systemów polega na wysyłaniu do klientów po złożeniu zamówienia (po określonym czasie) informacji z prośbą o wyrażenie opinii na temat sklepu oraz transakcji. Takie informacje są przydatne dla innych kupujących, który mogą zapoznać się opiniami o sklepie. Zebrane informacje mogą wyświetlać się w sklepie np w wysuwanych zakładkach, które można włączyć w menu <strong>Integracje / Wysuwane zakładki</strong>.<br />\r\n<br />\r\n<strong><span style=\"font-size:18px;\">Systemów afiliacyjne.</span></strong><br />\r\n<br />\r\nSą to systemy umożliwiające przesyłanie linków, informacji dotyczących produktów w sklepie do innych stron internetowych - na zasadzie polecania danego produktu czy informacji. W sklepie szczególny nacisk został położony na integrację z portalami społecznościowymi np Facebook, NaszaKlasa, Google. Włączenie odpowiedniego modułu powoduje wyświetlanie odpowiedniego dla danego portalu przycisku na stronie karty produktu. Klient wciskając dany przycisk może przesłać link produktu do wybranego portalu lub jak np w przypadku Facebook - &quot;polubić produkt&quot;. W ramach tego modułu sklep umożliwia dodatkowo integrację z WebePartners.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/integracja_fresmail.jpg\" style=\"width: 650px; height: 129px; float: left; margin-right: 15px; margin-bottom: 15px;\" />W ramach systemów afiliacyjnych sklep ma wbudowaną integrację z systemem FreshMail. Jest to system ułatwiający tworzenie newsletterów, wysyłanie do klientów mailingu. Włączenie w sklepie integracji powoduje, że każdy klient, który zapisze się w sklepie do newslettera będzie dodany do list mailingowych na Państwa koncie w systemie FreshMail. Do integracji z systemem FreshMail jest wymagany klucz API oraz klucz API sekret. Oba te klucze są dostępne w ustawieniach systemu na stronie FreshMail po zalogowaniu się na Państwa konto. Integracja umożliwia dodawaniu do określonej listy mailingowej klientów, którzy zapisali się do newslettera. Umożliwia utworzenie osobnych list mailingowych dla klientów, którzy zarejestrowali się w sklepie, złożyli zamówienia lub dokonali zakupów poszczególnych produktów. Dzięki temu w systemie FreshMail można tworzyć indywidualne newslettery dla konkretnych grup klientów. Jeżeli w sklepie jest włączona integracja to wypisanie się klienta z newslettera sklepu powoduje także wypisanie go z list mailingowych w systemie FreshMail.<br />\r\n<br />\r\n<strong><span style=\"font-size:18px;\">Wysuwane zakładki.</span></strong><br />\r\n<br />\r\nPoza integracją z systemami śledzącymi program umożliwia również wyświetlanie gotowych widgetów oferowanych przez różne systemy czy strony takie jak Facebook, Google, Ceneo, Okazje.info czy Opineo. Wyświetlenie widgetów nie wymaga żadnej ingerencji w kod strony sklepu. Wystarczy pobrać kod widgetu lub identyfikator z wybranej przez siebie platformy i wkleić go w menu <strong>Integracje / Wysuwane zakładki</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/integracje_widgety.jpg\" style=\"width: 600px; height: 161px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Po wklejeniu kodu, program automatycznie dołączy go w odpowiednim miejscu w kodzie strony sklepu i wyświetli zakładkę z widgetem.<br />\r\n<br />\r\nW analogiczny sposób można wstawić kod widgetów z innych serwisów.<br />\r\n<br />\r\n<strong>UWAGA: </strong>Zakładki widgetów Ceneo, Okazje.info i Opineo działa niezależnie od zakładek systemów społecznościowych, które również można włączyć w konfiguracji sklepu - ich zawartość konfiguruje się w panelu w wybranym serwisie - skąd należy pobrać gotowy kod do wklejenia w poniższy formularz.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/integracje_zakladki.jpg\" style=\"width: 340px; height: 174px; float: left; margin-right: 15px; margin-bottom: 15px;\" />Oddzielną grupę stanowią wysuwane zakładki serwisów społecznościowych takich jak Facebook, Nasza klasa, Twitter, Google+ itp. W menu <strong>Integracje / Wysuwane zakładki</strong> można je włączyć określając po której stronie ekranu mają się wyświetlać i w jakiej kolejności.<br />\r\n<br />\r\nDodatkowo jako niezależna wyświetlana jest zakładka <strong>Allegro</strong>. Umożliwia ona wyświetlanie losowych komentarzy z Allegro. Zakładka ma za zadanie zwiększenie zaufania do sklepu poprzez prezentację opinii klientów z portalu Allegro. Do działania zakładki jest wymagana integracja sklepu z Allegro poprzez aktywny klucz Webapi i poprawną konfigurację z Allegro w menu <strong>Integracje / Allegro / Konfiguracja połączenia z Allegro</strong>. Przed uruchomieniem zakładki należy pobrać komentarze z konta Allegro. Pobieranych jest 25 najnowszych komentarzy i na stronie wyświetlane są losowo. Zalecane jest pobieranie co pewien czas komentarzy w celu aktualizacji danych wyświetlanych na stronie sklepu. Sklep automatycznie nie pobiera nowych komentarzy (automat powodowałby zbyt duże, niepotrzebne obciążenie sklepu).<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/integracje_zakladki_wlasna.jpg\" style=\"width: 490px; height: 595px; float: left; margin-right: 15px; margin-bottom: 15px;\" />Oprócz zdefiniowanych w sklepie na stałe wysuwanych zakładek, użytkownik sklepu ma możliwość dodania do trzech własnych zdefiniowanych zakładek, które mogą mieć dowolną grafikę oraz wyświetlać dowolne informacje.<br />\r\n<br />\r\nW przypadku indywidualnych zakładek należy wybrać jaki obrazek będzie wyświetlany w sklepie jako zakładka (po najechaniu na ten obrazek nastąpi wysunięcie zakładki). 2-krotne kliknięcie w pole wyboru obrazka spowoduje otworzenie przeglądarki zdjęć z możliwością wybrania grafiki lub wgrania nowej z komputera klienta. Rozmiar obrazka nie powinien być duży - zalecamy żeby nie był szerszy niż 50 pikseli. W kolejnym kroku należy zdefiniować jaka treść ma się wyświetlać w oknie po wysunięciu zakładki. Treść wpisuje się w edytorze tekstu - może ona zawierać tekst, obrazki i mieć dowolne formatowania html. Kolejnym polem koniecznym do wyświetlania zakładki jest szerokość pola z treścią. W tym miejscu określa się jaką szerokość będzie miało okno wysuniętej zakładki (o ile pikseli ma się wysuwać zakładka po najechaniu na grafikę zakładki). Dodatkowo można także przypisać wyświetlanie zakładki tylko do określonego języka, a także podobnie jak w przypadku innych zakładek określić stronę ekranu po której ma się wyświetlać oraz kolejność wyświetlania.</div>\r\n"),
("128","652","1","instrukcja","Formy płatności","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_formy_platnosci.jpg\" style=\"width: 501px; height: 251px; float: right; margin-left: 15px;\" />Statystyka<strong> formy płatności</strong> wyświetla informacje na temat wybieranych podczas składania zamówień przez klientów form płatności. Raport prezentuje dane w formie graficznej (wykres kołowy) oraz w formie tabeli z nazwą formy płatności oraz ilością zamówień dla danej płatności. Dodatkowo można ograniczyć wyświetlanie danych wg określonego przedziału czasowego.</div>\r\n"),
("129","653","1","instrukcja","Formy dostawy","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_formy_dostawy.jpg\" style=\"width: 500px; height: 261px; float: right; margin-left: 15px;\" />Statystyka<strong> formy dostawy</strong> wyświetla informacje na temat wybieranych podczas składania zamówień przez klientów form dostawy (wysyłki). Raport prezentuje dane w formie graficznej (wykres kołowy) oraz w formie tabeli z nazwą formy dostawy oraz ilością zamówień dla danej wysyłki. Dodatkowo można ograniczyć wyświetlanie danych wg określonego przedziału czasowego.</div>\r\n"),
("130","654","1","instrukcja","Wykres sprzedaży","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_wykres_sprzedazy.jpg\" style=\"width: 500px; height: 406px; float: right; margin-left: 15px;\" />Statystyka <strong>wykres sprzedaży</strong> prezentuje w formie graficznej (wykresów) dane sprzedaży za ostatnie 17 miesięcy. Wykres prezentuje w formie wykresu wartość złożonych zamówień oraz ilość złożonych zamówień w poszczególnych miesiącach. Jeżeli w sklepie sprzedaż jest prowadzona w różnych walutach - dla każdej waluty jest generowany osobny wykres (tylko jeżeli dla danej waluty była sprzedaż w prezentowanym okresie).<br />\r\n<br />\r\nPowyżej wykresów sprzedaży wyświetlane są dwa wykresy wyświetlające prognozę sprzedaży na aktualny miesiąc rozliczeniowy. Wykres po lewej stronie prezentuje prognozę na podstawie sprzedaży z danego miesiąca (na podstawie sprzedaży z poszczególnych dni miesiąca), wykres z prawej strony wyświetla prognozę na podstawie sprzedaży z ostatnich trzech miesięcy.<br />\r\n<br />\r\nDane w prognozach są rozbite na poszczególne waluty, w zależności od sprzedaży w danej walucie.</div>\r\n"),
("131","651","0","instrukcja","Statystyki sprzedaży","<div style=\"text-align:justify;\">\r\n	Statystyki sprzedaży przedstawiają raporty dotyczące elementów, które mają wpływ na sprzedaż produktów w sklepie. Są to m.in. raporty dotyczące wybieranych form wysyłek, sposób płatności, raporty sprzedaży produktów czy zamówień wg typów. Analiza poszczególnych raportów umożliwia właścicielowi sklepu lepsze dopasowanie oferty sklepu, wysyłek czy płatności do oczekiwań klienta.</div>\r\n"),
("132","655","1","instrukcja","Raport sprzedaży produktów dla kategorii","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/raport_sprzedaz_kategorie.jpg\" style=\"width:498px;height:207px;margin-left:15px;margin-bottom:15px;float:right;\" />Raport <strong>sprzedaży produktów dla kategorii</strong> umożliwia wygenerowanie raportu sprzedaży produktów wraz z ich cechami (jeżeli dane produkty posiadają cechy) w określonym przedziale czasowym w podziale na kategorie produktów. Przy generowaniu raportu można wybrać za jaki okres mają być generowane dane oraz status zamówień jakie mają być uwzględniane do przygotowania danych.<br />\r\n	<br />\r\n	Wygenerowane dane są wyświetlane w formie tabeli. Tabela składa się z pięciu kolumn: nr katalogowy, nazwa produktu (razem z nazwami cech jeżeli produkt posiada cechy), ilość sprzedanych produktów oraz wartość netto i brutto sprzedaży danego produktu.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/raport_sprzedaz_kategorie_lista.jpg\" style=\"width:220px;height:162px;margin-right:10px;float:left;\" />Dane w tabeli są wyświetlane wg nazw kategorii i podkategorii, a wewnątrz kategorii wg nazw produktów. Jako nagłówki są wyświetlane nazwy kategorii, a poniżej znajduje się lista szczegółowa produktów wraz z cechami.<br />\r\n	<br />\r\n	<div style=\"text-align:justify;\">\r\n		<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Jeżeli do generowania raportu zostanie przyjęty zbyt duży przedział czasowy - przy dużej ilości zamówień - generowanie raportu może spowodować zbyt duże obciążenie sklepu i błąd w generowaniu danych. Dlatego zaleca się generowanie danych w niedużych przedziałach czasowych.</div>\r\n</div>\r\n"),
("133","615","0","instrukcja","Firmy kurierskie","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/integracje_kurierzy.jpg\" style=\"float: left; width: 600px; height: 353px; margin-right: 15px;margin-bottom:15px\" />Program sklepu oferuje integrację z firmami kurierskimi oraz pośredniczącymi w obsłudze firm kurierskich. W celu skorzystania z integracji należy mieć podpisaną umowę z wybraną firmą i skonfigurować odpowiednie parametry w menu <strong>Integracje / Firmy wysyłkowe</strong>. Po wybraniu określonej firmy wyświetlany jest formularz do wprowadzenie danych konfiguracyjnych. Ponieważ konfiguracja zależna jest od konkretnej firmy obsługującej przesyłki opiszemy tutaj moduł na przykładzie jednej wybranej przykładowo.<br />\r\n<br />\r\nPo wybraniu z menu <strong>Integracje / Firmy wysyłkowe</strong> opcji Paczkomaty inPost wyświetlony zostanie formularz, który umożliwia wprowadzenie danych do połączenia z API serwisu inPost oraz ustawienie domyślnych parametrów nadawanych przesyłek.<br />\r\n<br />\r\nDo sprawdzenia poprawności działania tego modułu można skorzystać z konta testowego. Do logowania do konta testowego w serwisie inPost można posłużyć się adresem: test@testowy.pl oraz hasłem: WqJevQy*X7. Przesyłki w tej opcji nie będą nadawane ani doręczane.<br />\r\n<br />\r\nJeżeli moduł jest włączony wówczas w edycji zamówienia w menu obsługi zamówień w zakładce <strong>Wysyłki</strong> wyświetlone zostanie logo operatora obsługującego dany serwis. Kliknięcie w nie umożliwi wygenerowanie poprzez API przesyłki, wydrukowanie etykiet oraz dokumentów przewozowych (zależne to jest również od konkretnego operatora - jakie akcje oferuje jego API).<br />\r\n<br />\r\n<img alt=\"alt\" height=\"340\" src=\"obrazki/pomoc/integracje_kurierzy_inpost.jpg\" style=\"margin-left:15px;margin-right:15px;float:right;\" width=\"544\" />Na rysunku przedstawiony został przykładowy formularz tworzenia wysyłki dla serwisu inPost Paczkomaty.<br />\r\n<br />\r\nPo wypełnieniu formularza wystarczy kliknąć przycisk <em>Utwórz przesyłkę</em> - co spowoduje wygenerowanie paczki w serwisie inPost. Po tej operacji można od razu wydrukować etykietę bezpośrednio do pliku PDF, którą można nakleić na przesyłkę.<br />\r\n<br />\r\nRozliczenie przesyłki następuje już na koncie użytkownika w serwisie obsługującym dany rodzaj wysyłek.</div>\r\n"),
("134","682","0","instrukcja","Mapa XML dla Google","<div style=\"text-align:justify;\">Mapy witryn pozwalają poinformować Google o stronach w witrynie, których nie udałoby się odnaleźć robotom. Mówiąc najprościej, mapa witryny w formacie XML &ndash; nazywana zazwyczaj po prostu mapą witryny &ndash; jest listą stron znajdujących się w Twojej witrynie. Tworząc i zgłaszając mapę witryny, zyskujesz pewność, że Google ma informacje o wszystkich stronach w Twojej witrynie, łącznie z adresami URL, których nie udałoby się wykryć w normalnym procesie indeksowania witryny.<br />\r\n<br />\r\nMapy witryn są szczególnie przydatne, gdy:\r\n<ol>\r\n	<li>Witryna zawiera treść generowaną dynamicznie.</li>\r\n	<li>Witryna zawiera strony, które nie są łatwo wykrywane przez Googlebota w trakcie procesu indeksowania, na przykład strony zawierające aplikacje AJAX lub grafiki.</li>\r\n	<li>Witryna jest nowa i prowadzi do niej niewiele linków (Googlebot indeksuje sieć, śledząc linki między stronami, dlatego jeśli Twoja witryna nie jest dobrze połączona z innymi, możemy mieć trudności z jej odnalezieniem).</li>\r\n	<li>Witryna zawiera pokaźne archiwum stron z treścią, które są ze sobą słabo połączone lub nie są połączone w ogóle.</li>\r\n</ol>\r\n</div>\r\n\r\n<div style=\"text-align:justify;\">Google nie gwarantuje pobrania ani zaindeksowania wszystkich adresów URL. Dane z mapy witryny umożliwiają jednak poznanie struktury witryny, dzięki czemu można lepiej zaindeksować daną witrynę w przyszłości. W większości przypadków webmasterzy odnoszą korzyści ze zgłoszenia mapy witryny, a w żadnym przypadku nie powoduje to negatywnych konsekwencji.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/pozycjonowanie_google.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 564px; height: 401px;\" />W celu wygenerowania mapy należy w menu wybrać opcję <strong>Integracje / Mapa XML dla Google</strong>. Po wybraniu tej opcji wyświetlony zostanie formularz, który umożliwi wprowadzenie indywidualnych ustawień do generowanej mapy - wartości ustawione domyślnie dobrane zostały w sposób optymalny dla wygenerowania poprawnego pliku mapy sklepu i nie wymaga zmiany ustawień.<br />\r\n<br />\r\nPo kliknięciu w przycisk <strong>Generuj plik XML</strong> program utworzy plik o nazwie sitemap.xml w katalogu głównym sklepu.<br />\r\n<br />\r\nPo wygenerowaniu mapy można bezpośrednio z poziomu panelu zarządzania poinformować Google o fakcie utworzenia mapy. Po zakończeniu generowania mapy sklep wyświetli informację o zapisaniu mapy oraz dodatkowo link, który umożliwi powiadomienie Google.<br />\r\n<br />\r\nInnym sposobem aby utworzoną mapę przesłać do Google jest skorzystanie z narzędzi Narzędzi Google dla Webmasterów.<br />\r\n&nbsp;\r\n<div><span style=\"color:#FF0000;\"><strong>Aby przesłać mapę witryny:</strong></span>\r\n\r\n<ol>\r\n	<li>Wygeneruj mapę strony w panelu administracyjnym sklepu.</li>\r\n	<li>Na stronie głównej Narzędzi dla webmasterów w serwisie Google kliknij wybraną witrynę.</li>\r\n	<li>W menu po lewej stronie kliknij&nbsp;<strong>Optymalizacja</strong>, a następnie <strong>Mapy witryn</strong>.</li>\r\n	<li>Kliknij <strong>Dodaj/testuj mapę witryny</strong>.</li>\r\n	<li>W polu tekstowym uzupełnij ścieżkę do mapy witryny (jeśli na przykład mapa witryny jest pod adresem http://www.adressklepu.pl/sitemap.xml, wpisz <strong>sitemap.xml</strong>).</li>\r\n	<li>Kliknij <strong>Zgłoś mapę witryny</strong>.</li>\r\n</ol>\r\nW obu przypadkach należy posiadać konto utworzone w Narzędzia Google dla Webmasterów. System ten jest bardzo przydatny dla osób, które chcą analizować informacje na temat danych związanych ze sklepem. Jest to bardzo użyteczne narzędzie, które służy do zbierania informacji na temat swoich witryn internetowych. Aby móc zarządzać mapą sklepu z poziomu Narzędzi Google należy zweryfikować stronę w Google. W tym celu należy wprowadzić odpowiedni kod otrzymany od Google w menu <strong>Integracje / Systemy afiliacyjne</strong>. Po wpisaniu kodu będzie można zweryfikować witrynę sklepu w Google i zarządzać informacjami zbieranymi przez Google, np sprawdzić kiedy była pobrana mapa XML sklepu.</div>\r\n</div>\r\n"),
("135","655","1","instrukcja","Raport sprzedaży produktów w przedziale czasowym","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/raport_sprzedaz_czasowy.jpg\" style=\"width:400px;height:135px;margin-left:15px;margin-bottom:15px;float:right;\" />Raport <strong>sprzedaży produktów w przedziale czasowym</strong> umożliwia wygenerowanie raportu sprzedaży produktów wraz z ich cechami (jeżeli dane produkty posiadają cechy) w określonym przedziale czasowym. Przy generowaniu raportu można wybrać za jaki okres mają być generowane dane oraz status zamówień jakie mają być uwzględniane do przygotowania danych.<br />\r\n	<br />\r\n	Wygenerowane dane są wyświetlane w formie tabeli. Tabela składa się z pięciu kolumn: nr katalogowy, nazwa produktu (razem z nazwami cech jeżeli produkt posiada cechy), ilość sprzedanych produktów oraz wartość netto i brutto sprzedaży danego produktu.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/raport_sprzedaz_czasowy_lista.jpg\" style=\"width:250px;height:161px;margin-right:10px;float:left;\" />Dane w tabeli są wyświetlane wg nazw produktów. Nazwy produktów są wyświetlane jako nagłówki, a poniżej znajduje się lista szczegółowa dane produktu wraz z poszczególnymi cechami.<br />\r\n	<br />\r\n	<div style=\"text-align:justify;\">\r\n		<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Jeżeli do generowania raportu zostanie przyjęty zbyt duży przedział czasowy - przy dużej ilości zamówień - generowanie raportu może spowodować zbyt duże obciążenie sklepu i błąd w generowaniu danych. Dlatego zaleca się generowanie danych w niedużych przedziałach czasowych.</div>\r\n</div>\r\n"),
("136","683","0","instrukcja","Meta Tagi / Open Graph","<div style=\"text-align:justify;\"><strong>Meta Tagi</strong> są doskonałym rozwiązaniem dla webmasterów, którzy chcą przekazywać wyszukiwarkom dodatkowe informacje na temat swoich witryn. Pozwalają one na dostarczanie informacji różnym systemom klienckim, z których każdy interpretuje tylko te meta tagi, które rozumie, natomiast pozostałe ignoruje. Meta Tagi są dodawane do sekcji strony HTML<br />\r\n<br />\r\nW sklepie można zdefiniować 3 podstawowe Meta Tagi dla różnych podstron. Są to :</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Tytuł strony</strong> - Choć z technicznego punktu widzenia nie jest to Meta Tag, często towarzyszy on tagowi &quot;opis&quot;. Jego zawartość jest zazwyczaj wyświetlana na liście wyników wyszukiwania jako tytuł strony (i naturalnie pojawia się też w przeglądarce użytkownika).</li>\r\n	<li style=\"text-align:justify;\"><strong>Opis strony</strong> - Ten tag zapewnia krótki opis strony. Czasami tekst ten jest wykorzystywany jako część krótkiego opisu strony pokazywanego na stronie z wynikami wyszukiwania</li>\r\n	<li style=\"text-align:justify;\"><strong>Słowa kluczowe</strong> - Znacznik jest elementem, którego nie wyświetlają ani przeglądarki, ani wyszukiwarki. Służy on do umieszczenia listy słów kluczowych, na które chcemy, by pojawiała się nasza strona internetowa. Frazy umieszczone w tym meta tagu należy rozdzielać przecinkami.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Należy pamiętać o tym, ze o ile Meta Tagi są jednym z elementów, które mogą pomóc zaistnieć naszej stronie w wyszukiwarkach - o tyle nie spowodują one, że zostanie ona od razu wyświetlona na pierwszych stronach wyników wyszukiwania. Dotyczy to zwłaszcza popularnych fraz, które mogą występować w bardzo wielu serwisach. Istotna jest treść zawarta w całym serwisie a nie tylko w Meta Tagach. Google dąży cały czas do tego, aby jako wynik wyszukiwania zwrócić najbardziej powiązane z wpisanym słowem kluczowym strony. W takiej sytuacji optymalizacja samych meta tagów nie wystarczy.<br />\r\n<br />\r\nPoniżej przedstawiamy kilka porad dotyczących tworzenia opisanych powyżej Meta Tagów.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>Tytuł strony</strong></span>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Zwięzły</strong> (zbyt długie nie będą poprawnie wyświetlane) i zrozumiały.</li>\r\n	<li style=\"text-align:justify;\">Dobry tytuł strony powinien <strong>opisywać tematykę strony</strong>, która jest wyświetlana.</li>\r\n	<li style=\"text-align:justify;\">Każda z podstron serwisu powinna mieć odrębny tytuł.</li>\r\n	<li style=\"text-align:justify;\">Nie może być dłuższy niż <strong>80 znaków</strong>.</li>\r\n	<li style=\"text-align:justify;\">Słowa najważniejsze z punktu widzenia pozycjonowania powinny znajdować się na początku tytułu.</li>\r\n	<li style=\"text-align:justify;\">Słowa najtrudniejsze, które uważasz za najtrudniejsze w pozycjonowaniu możesz napisać wielkimi literami.</li>\r\n	<li style=\"text-align:justify;\">Tytuł powinien zawierać <strong>nazwę strony lub firmy</strong>.</li>\r\n	<li style=\"text-align:justify;\">Jego treść powinna zachęcać użytkownika do odwiedzenia strony (tytuł strony jest wyświetlany w wynikach wyszukiwania).</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>Słowa kluczowe</strong></span></div>\r\n\r\n<div style=\"text-align:justify;\">\r\n<ol>\r\n	<li style=\"text-align:justify;\">Słowa kluczowe powinny dokładnie<strong> odzwierciedlać zawartość</strong> opisywanej strony,</li>\r\n	<li style=\"text-align:justify;\">Każda podstrona powinna posiadać swoje, <strong>odrębne słowa kluczowe</strong>,</li>\r\n	<li style=\"text-align:justify;\"><strong>Kolejność słów kluczowych</strong> jest bardzo ważna &ndash; na pierwszym miejscu powinno być wymienione słowo najtrudniejsze do wypozycjonowania lub najważniejsze z punktu widzenia sklepu,</li>\r\n	<li style=\"text-align:justify;\">Na wpisywanie słów kluczowych można użyć do <strong>100 znaków</strong>.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>Opis strony</strong></span></div>\r\n\r\n<div style=\"text-align:justify;\">\r\n<ol>\r\n	<li>Znacznik ten jest zatem ważny nie tyle z punktu widzenia pozycjonowania, ile <strong>z punktu widzenia użytkownika</strong>. Im ciekawszy opis i im bardziej odpowiada on informacjom poszukiwanym przez użytkownika, tym większe prawdopodobieństwo, że odwiedzi on stronę. Opis strony <strong>nie może być zbyt długi</strong>. Google wyświetla ok. <strong>200 znaków</strong> opisu. Jeśli zostanie przekroczony ten limit, nic strasznego się nie stanie &ndash; ponadprogramowa część opisu zostanie zastąpiona trzema kropkami.</li>\r\n</ol>\r\n<strong>Tagi Open Graph</strong> - protokół&nbsp;<strong>Open Graph</strong> pozwala na integrację serwisów internetowych z <strong>Facebookiem</strong>. Umożliwia kontrolę nad prezentacją&nbsp; treści w tym serwisie społecznościowym, a jednocześnie na lepszą ich interakcję z użytkownikami. Jest to w praktyce zestaw specjalnych znaczników, które umieszcza się w kodzie strony internetowej i które mają na celu dokładne opisanie tego, co się na tej stronie znajduje. Przekazywane w ten sposób informacje są później wyświetlane na tablicy użytkownika, który kliknął <strong>Lubię to</strong>, a także odpowiednio umieszczane w jego profilu - ogólnie rzecz biorąc opisują sposób, w jaki dana strona będzie widoczna w Facebooku. Więcej informacji na ten temat można znaleźć w <a href=\"https://developers.facebook.com/docs/opengraphprotocol/\">dokumentacji Facebooka</a>.</div>\r\n</div>\r\n\r\n<p>&nbsp;</p>\r\n</div>\r\n"),
("137","656","1","instrukcja","Raport sprzedaży produktów wg cech","<div style=\"text-align:justify;\">Raport <strong>sprzedaży produktów wg cech</strong> umożliwia wygenerowanie raportu sprzedaży dla poszczególnych produktów w rozbiciu na poszczególne cechy produktu. Raport jest przydatny tylko dla produktów, które posiadają cechy - umożliwia sprawdzenie jakie cechy produktów sprzedały się w poszczególnych produktach. Przy generowaniu raportu można wybrać za jaki okres mają być generowane dane oraz status zamówień jakie mają być uwzględniane do przygotowania danych.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/raport_cechy_wybor.jpg\" style=\"width: 550px; height: 203px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Ponieważ raport generuje dane dla wybranego produktu - najpierw należy wybrać produkt. Przy pierwszym uruchomieniu raportu zostaje wyświetlone okno drzewa kategorii. W oknie należy wybrać kategorię z jakiej będzie pobierany produkt. Po kliknięciu w wybraną kategorię po prawej stronie w oknie wyświetli się lista produktów z danej kategorii. Jest to skrócona forma listingu - zawiera podstawowe dane: id, zdjęcie, ceną, nr katalogowy oraz nazwę - wyświetla także stan produktu - czy produkt jest aktywny czy wyłączony. Z listy należy wybrać produkt dla którego będzie generowany raport poprzez zaznaczenie produktu w kolumnie o nazwie <strong>Wybór</strong>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/raport_cechy_lista.jpg\" style=\"width:500px;height:146px;margin-right:15px;margin-bottom:15px;margin-top:15px;float:left;\" />Po wybraniu produktu znikną okna wyboru kategorii i produktów, a w ich miejsce zostanie wyświetlony raport dla danego produktu. Wygenerowane dane są wyświetlane w formie tabeli. Tabela składa się z pięciu kolumn: nr katalogowy, nazwa produktu (razem z nazwami cech jeżeli produkt posiada cechy), ilość sprzedanych produktów oraz wartość netto i brutto sprzedaży danego produktu.<br />\r\n<br />\r\nKlikając na przycisk <strong>wybierz inny produkt </strong>- można wrócić do opcji wyboru produktów i wybrać inny produkt do wygenerowania raportu.</div>\r\n\r\n<div style=\"text-align:justify;\">\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Jeżeli do generowania raportu zostanie przyjęty zbyt duży przedział czasowy - przy dużej ilości zamówień - generowanie raportu może spowodować zbyt duże obciążenie sklepu i błąd w generowaniu danych. Dlatego zaleca się generowanie danych w niedużych przedziałach czasowych.</div>\r\n</div>\r\n"),
("138","657","1","instrukcja","Zamówienia wg typu","<img alt=\"alt\" src=\"obrazki/pomoc/raport_typ_zamowienia.jpg\" style=\"width: 420px; height: 388px; margin-left: 15px; float: right;\" />Statystyka<strong> zamówienia wg typu</strong> wyświetla informacje na temat ilości zamówień wg typów zamówień. Typy zamówień to:\r\n<ol>\r\n	<li>zamówienia złożone przez klientów z rejestracją konta</li>\r\n	<li>zamówienia złożone przez klientów bez rejestracji konta</li>\r\n	<li>zamówienia dodawane ręcznie przez administratora sklepu z poziomu panelu zarządzania</li>\r\n	<li>zamówienia z allegro</li>\r\n</ol>\r\nRaport prezentuje dane w formie graficznej (wykres kołowy i słupkowy) oraz w formie tabeli - ilość zamówień na poszczególne typy zamówień oraz wartość kwotową zamówień w rozbiciu na waluty. Dodatkowo można ograniczyć wyświetlanie danych wg określonego przedziału czasowego."),
("139","660","0","instrukcja","Statystyki klientów","<div style=\"text-align:justify;\">\r\n	Statystyki klientów przedstawiają raporty dotyczące zarejestrowanych w sklepie klientów. Są to m.in. raporty dotyczące <span class=\"maleInfo\">rejestracji klientów w sklepie w określonych przedziałach czasowych</span> oraz generujący <span class=\"maleInfo\">listę klientów sklepu wg ilości i wartości zamówień</span>. Dzięki raportom można sprawdzić czy np przeprowadzona kampania reklamowa miała wpływ na ilość zarejestrowanych klientów.</div>\r\n"),
("140","661","1","instrukcja","Rejestracje klientów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_rejestracja_klienci.jpg\" style=\"width: 420px; height: 289px; float: right; margin-left: 15px;\" />Raport <strong>rejestracje</strong> klientów prezentuje w formie graficznej (wykresów) ilość zarejestrowanych klientów w określonych przedziałach czasowych.<br />\r\n<br />\r\nGórny wykres wyświetla dane w rozbiciu na poszczególne dni za okres ostatnich 30 dni. Dolny wykres prezentuje dane za okres ostatnich 18 miesięcy w rozbiciu na poszczególne miesiące.</div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("141","662","1","instrukcja","Klienci wg zamówień","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_klienci.jpg\" style=\"width: 600px; height: 183px; margin-left: 15px; float: right;\" />Raport klienci wg zamówień przedstawia w formie tabeli listę klientów wg ilości lub wartości zamówień. Raport wyświetla tylko zarejestrowanych klientów sklepu. W tabeli każdy klient jest wyświetlany w osobnym wierszu. Tabela składa się z ośmiu kolumn, które przedstawiają po kolei:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\">liczbę porządkową - klienci są wyświetlani od najwyższej do najniższej wartości - wg wartości lub ilości zamówień</li>\r\n	<li style=\"text-align:justify;\">id klienta w bazie sklepu</li>\r\n	<li style=\"text-align:justify;\">dane klienta - imię i nazwisko - dane są linkiem do konta klienta</li>\r\n	<li style=\"text-align:justify;\">grupa klienta - do jakiej grupy rabatowej dany klient jest przypisany</li>\r\n	<li style=\"text-align:justify;\">ilość logowań - ile razy klient logował się do sklepu</li>\r\n	<li style=\"text-align:justify;\">ilość zamówień - ile zamówień złożył w sklepie klient</li>\r\n	<li style=\"text-align:justify;\">wartość zamówień - wyświetla ogólną wartość zamówień klienta</li>\r\n	<li style=\"text-align:justify;\">zniżki klienta - w ostatniej kolumnie wyświetlane są wszystkie zniżki jakie posiada dany klient</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Dodatkowo raport nad listingiem posiada opcję sortowania. Umożliwia ona wyświetlenie klientów wg wartości zamówień lub ilości zamówień. Obok sortowania znajduje się opcja zmiany waluty - przełączając się na inną walutę można wygenerować raport klientów dla innych walut.<br />\r\n<br />\r\nW raporcie można także ograniczyć zamówienia do złożonych w określonym przedziale czasowym oraz dla klientów z określonej grupy klientów. Dodatkowo dane z raportu można wyeksportować do pliku tekstowego.<br />\r\n<br />\r\nOpisywany raport umożliwia sprawdzenie, którzy klienci dokonują największych zakupów w sklepie i ewentualnie zmianę wybranym klientom grup rabatowych bądź zniżek. Poprzez ilość zamówień można sprawdzić także czy klient składa wiele mniejszych zamówień czy kilka o dużej wartości.</div>\r\n"),
("142","663","0","instrukcja","Asortyment","<div style=\"text-align:justify;\">\r\n	Statystyki asortymentu przedstawiają raporty dotyczące produktów sklepu. Umożliwiają przeprowadzenie inwentaryzacji sklepu, sprawdzenie jakie produkty są na wyczerpaniu, sprawdzić jakie produkty są najczęściej wyświetlane czy wyszukiwane w sklepie. Analiza poszczególnych raportów daje właścicielowi sklepu wiedzę jakie produkty w magazynie należy uzupełnić lub jakie produkty lepiej wypromować na stronie (np te które są za mało wyświetlane, a właścicielowi zależy na ich sprzedaży).</div>\r\n"),
("143","664","1","instrukcja","Wyświetlenia produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_najczesciej_wyswietlane.jpg\" style=\"width: 550px; height: 292px; margin-left: 15px; float: right;\" />Statystyka<strong> wyświetleń produktów</strong> przedstawia informacje na temat 100 najczęściej wyświetlanych w sklepie produktów. Raport prezentuje dane w formie graficznej (wykres słupkowy) oraz w formie tabeli gdzie wg ilości wyświetleń przedstawione są nazwy produktów wraz z ilością wyświetleń. Przy każdej pozycji znajduje się ikona krzyżyka, która umożliwia wyzerowanie licznika wyświetleń dla danego produktu. Na samym dole listingu znajduje się opcja wyzerowania wszystkich liczników. Wykres w formie graficznej przedstawia 20 najczęściej oglądanych produktów, tabela poniżej wykresu - 100 produktów.<br />\r\n<br />\r\nRaport przedstawia osobne dane dla poszczególnych wersji językowych. Zmiana języka następuje poprzez kliknięcie w ikonę flagi danego języka na wykresem. Każdy produkt ma osobne statystyki wyświetleń dla poszczególnych języków.</div>\r\n"),
("144","665","1","instrukcja","Najczęściej kupowane produkty","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_najczesciej_kupowane.jpg\" style=\"width: 550px; height: 299px; margin-left: 15px; float: right;\" />Statystyka<strong> najczęściej kupowane produkty</strong> przedstawia informacje na temat 100 najczęściej kupowanych w sklepie produktów. Raport prezentuje dane w formie graficznej (wykres słupkowy) oraz w formie tabeli gdzie wg ilości sprzedanych produktów przedstawione są nazwy produktów wraz z ilością sprzedaży. Wykres w formie graficznej przedstawia 20 najlepiej sprzedających się produktów, tabela poniżej wykresu - 100 produktów. Dodatkowo przy generowaniu raportu można ograniczyć wyświetlanie danych wg określonego przedziału czasowego.</div>\r\n"),
("145","685","1","instrukcja","Wartości domyślne","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/pozycjonowanie_meta_domyslne.jpg\" style=\"margin-left: 15px; float: right; width: 511px; height: 324px;\" />W menu <strong>Pozycjonowanie / Meta Tagi / Wartości domyślne</strong> należy wprowadzić ustawienia dla Meta Tagów, które będą używane dla wszystkich podstron sklepu, które nie mają swoich indywidualnych ustawień Meta Tagów.<br />\r\n<br />\r\nW formularzu należy wprowadzić osobne domyślne wartości wyświetlane na <strong>stronie głównej</strong> sklepu oraz domyślne wartości dla <strong>innych podstron</strong> sklepu.<br />\r\n<br />\r\nPrzy wpisywaniu treści należy kierować się wytycznymi opisanymi w instrukcji w części dotyczącej ogólnych zasad tworzenia sekcji META na stronie.<br />\r\n<br />\r\nW tym miejscu można wprowadzić także informacje dla tagów Open Graph dla strony głównej sklepu. Można wstawić tytuł strony, opis, nazwę sklepu oraz przypisać domyślny obrazek sklepu (np logo). Dane z tych tagów będą wyświetlane w portalach społecznościowych - Facebook.</div>\r\n"),
("146","666","1","instrukcja","Kończące się produkty","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_konczace_produkty.jpg\" style=\"width: 550px; height: 167px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Raport <strong>kończące się produkty</strong> umożliwia wygenerowanie raportu z produktami, które mają stan magazynowy poniżej określonego w parametrach raportu. Domyślnie wyświetlane są produkty, które mają stan magazynowy mniejszy od 2. Raport działa wyłącznie jeżeli w sklepie jest włączona kontrola stanów magazynowych produktów (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu / Kontrola stanów magazynowych produktów</strong>).<br />\r\n<br />\r\nWygenerowane dane są wyświetlane w formie tabeli. Tabela składa się z siedmiu kolumn: id produktu, zdjęcie produktu, nr katalogowy, nazwa produktu (bez cech produktu), cena brutto, ilość w magazynie oraz stan produktu - czy produkt jest aktywny czy wyłączony. Stan magazynowy (ilość w magazynie) jest wyświetlany dla całego produktu - tzn jeżeli w sklepie jest włączona kontrola stanu magazynowego cech to jako ilość jest wyświetlana suma wszystkich stanów magazynowych cech danego produktu, np bluza XL jest dostępna w 3 szt, rozmiar L w 2 szt - w polu Ilość zostanie wyświetlona wartość 5. Jeżeli produkt nie posiada cech lub jest wyłączona kontrola stanów magazynowych cech - będzie wyświetlony całościowy stan magazynowy danego produktu.<br />\r\n<br />\r\nNad tabelą z produktami znajduje się pole ilości produktów. Standardowo jest w tym miejscu wstawiona cyfra 2 - oznacza to, że będą wyświetlane produkty, które mają stan magazynowy mniejszy od 2. Wartość tą można zmienić - raport zostanie wygenerowany ponownie dla innej wartości liczbowej. Dodatkowo można zaznaczyć żeby w raporcie były wyświetlane tylko produkty aktywne.<br />\r\n<br />\r\nObok pola ilości znajduje się opcja wyboru: wszystkie produktu, tylko z wybranej kategorii lub tylko producenta. Po wybraniu tylko z wybranej kategorii - zostanie wyświetlona lista dostępnych w sklepie kategorii (w formie rozwijanego drzewa). Po kliknięciu w wybraną kategorię zostaną wyświetlone tylko produkty z danej kategorii ze stanem magazynowym poniżej ustalonego. Podobnie po wybraniu producenta, zostanie wyświetlona lista producentów i kliknięcie w wybranego spowoduje wyświetlenie produktów danego producenta.</div>\r\n"),
("147","687","1","instrukcja","Wartości dla podstron","<div style=\"text-align:justify;\">W menu <strong>Pozycjonowanie / Meta Tagi / Wartości dla podstron</strong> można wprowadzić indywidualne ustawienia Meta Tagów dla poszczególnych podstron sklepu. Opcja ta nie dotyczy stron związanych z produktami takich jak listing produktów, karta produktu czy strony informacyjne - dla tych stron wartości są ustawiane przy definiowaniu konkretnych pozycji.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/pozycjonowanie_meta_podstrony.jpg\" style=\"margin-right: 15px; margin-bottom: 15px; float: left; width: 634px; height: 143px;\" />Po wybraniu menu wyświetlona zostanie lista zdefiniowanych podstron, które mają ustawione indywidualne Meta Tagi.<br />\r\n<br />\r\nNa liście wyświetlona jest nazwa skryptu, który odpowiedzialny jest za generowanie danej strony sklepu (wraz z opisem co wyświetla dany skrypt), zdefiniowane wartości META: tytuł strony, opis i słowa kluczowe. W następnej kolumnie zawarta jest informacja, czy dla danej strony mają zostać dołączone również wartości domyślne zdefiniowane dla całego sklepu. W ostatniej kolumnie znajdują się ikony nawigacyjne umożliwiające edycję danej pozycji lub jej usunięcie. Jeżeli dana podstrona sklepu nie znajduje się na liście - oznacza to, że dla takiej podstrony wyświetlane są tylko wartości domyślne.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/pozycjonowanie_meta_podstrony_edycja.jpg\" style=\"width: 600px; height: 767px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Po kliknięciu linku <strong>dodaj nową pozycję</strong> lub ikony edycji wyświetlony zostanie formularz pozwalający na wprowadzenie poszczególnych informacji.<br />\r\n<br />\r\nInformacje należy wprowadzać we wszystkich językach jakie są używane w sklepie.<br />\r\n<br />\r\nW pierwszej część formularza wpisujemy treści, które znajdą się w znacznikach meta danej podstrony: tytuł, opis oraz słowa kluczowe.<br />\r\n<br />\r\nW następnej część formularza jest możliwość zaznaczenia opcji czy poza wartościami indywidualnymi dla danej strony mają zostać również dołączone wartości domyślne dla całego serwisu oraz ich ulokowanie - czy mają być wyświetlane przed czy po wartościach indywidualnych.<br />\r\n<br />\r\nOstatnim elementem formularza jest rozwijana lista podstron, dla których można zdefiniować wartości indywidualne.<br />\r\n<br />\r\nPo wprowadzeniu wszystkich niezbędnych danych i ich zapisaniu sekcja Meta Tagów dla zdefiniowanej strony w sklepie będzie zawierała wszystkie informacje, które zostały dla niej zdefiniowane. Na przykład jeżeli dodamy stronę wyszukiwania zaawansowanego i zdefiniujemy dla niej indywidualny tytuł oraz zaznaczymy wyświetlanie wartości domyślnych - wówczas tytuł tej strony w sklepie będzie miał postać np.: Domyślny tytuł tytuł podstrony (Sklep internetowy shopGold wyszukiwanie zaawansowane).<br />\r\n<br />\r\nPodczas definiowania elementów META można stosować także w treści znaczniki. W ich miejsce podczas wyświetlania danej podstrony w sklepie będą podstawiane odpowiednie wartości. Znaczniki są dostępne tylko dla niektórych podstron, np: karty produktu czy listingu produktów z kategorii. Jeżeli dana strona ma możliwość stosowania znaczników są one wyświetlane na dole formularza.<br />\r\n<br />\r\n<strong>UWAGA !!</strong><br />\r\nW przypadku stron, które mają możliwość definiowania indywidualnych meta tagów, np: produkty, artykuły aktualności - pierwszeństwo wyświetlania mają indywidualnie dodane (podczas dodawania czy edycji) wartości meta tagów - przed wprowadzonymi danymi w opisywanym powyżej module. Dla przykładu - jeżeli produkt X ma wpisane własne meta tagi (np tytuł - podczas edycji czy dodawania produktu w <strong>menu Asortyment / Produkty</strong>) to na karcie produktu będzie wyświetlany - wpisany tytuł indywidualnie dla tego produktu. Jeżeli nie będzie miał wpisanego np opisu meta to opis będzie pobierany opis z w/w formularza dla danej podstrony w sklepie. W przypadku jeżeli w w/w formularzu nie będzie podany np meta opis to sklep będzie podstawiał domyślny opis sklepu z menu <strong>Pozycjonowanie / Meta tagi / Wartości domyślne</strong>.</div>\r\n"),
("148","688","1","instrukcja","Automatyczne wypełnianie pól META","<div style=\"text-align:justify;\">Kolejnym elementem sklepu wspomagającym zarządzanie mata tagami jest funkcja automatycznego ich wypełniania. Dostępna jest w menu <strong>Pozycjonowanie / Meta Tagi / Automatyczne wypełnianie pól META</strong>. Standardowo podczas ręcznego wprowadzania produktów w formularzu jest dostępna zakładka <strong>Pozycjonowanie</strong>, w której można wprowadzić odpowiednie wartości do pol META. Jeżeli nie zostanie w nich nic wpisane, program automatycznie podczas zapisu wypełni je nazwą produktu. Jeżeli jednak sklep jest zintegrowany z zewnętrznymi programami lub hurtowniami wówczas pola te mogą być puste. W takiej sytuacji można skorzystać właśnie z opcji automatycznego wypełniania pól META. Funkcja ta wypełnia pola tytuł, opis oraz słowa kluczowe dla kategorii, produktów oraz producentów.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/pozycjonowanie_meta_automat.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 500px; height: 275px;\" />Po wybraniu tej opcji w menu wyświetlony zostanie formularz umożliwiający zdefiniowanie odpowiednich parametrów do wypełniania, Zawartość formularza zmienia się zależnie od wybieranych kolejno opcji.<br />\r\n<br />\r\nW pierwszej kolejności należy wybrać dla jakiego języka będą wypełniane pola. Następnie wybieramy opcję czy wypełnianie ma dotyczyć wszystkich pozycji w sklepie czy tylko wybranych kategorii. Po zaznaczeniu opcji <strong>tylko zaznaczone kategorie</strong> w formularzu zostanie wyświetlona lista kategorii produktów w sklepie, w której można zaznaczyć dla których z nich ma być wykonana operacja automatycznego wypełniania pól META.<br />\r\n<br />\r\nNastępną opcją w formularzu jest wybór w jaki sposób mają zostać wypełnione pola META. Dostępne są tutaj dwie opcje. Pierwsza z nich umożliwia wypełnienie danych nazwą i opisem produktu, kategorii lub producenta i nie wymaga ona żadnych dodatkowych ustawień.<br />\r\n<br />\r\nDrugą bardziej zaawansowaną opcją jest możliwość wypełnienia pół META własnymi, zdefiniowanymi informacjami. Po zaznaczeniu opcji <em>zdefiniowane wartości</em> w formularzu zostanie wyświetlony szereg dodatkowych pól, które umożliwiają zdefiniowanie własnych informacji, którymi zostaną wypełnione pola META.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/pozycjonowanie_meta_automat_wartosci.jpg\" style=\"width: 550px; height: 239px; margin-right: 25px; margin-bottom: 15px; float: left;\" />Formularz umożliwia wprowadzenie wartości dla poszczególnych pozycji sklepu: kategorii, produktów i producentów.<br />\r\n<br />\r\nPoza wpisaniem stałych tekstów w formularzu można używać wielu predefiniowanych stałych w miejsce których zostaną podstawione odpowiednie wartości z wypełnianych w danej chwili rekordów w bazie danych.<br />\r\n<br />\r\nDla zróżnicowania treści zawartych w Meta Tagach, można stosować różne warianty wprowadzania danych (duże litery, małe litery, itp.). Poniżej znajduje się lista predefiniowanych wartości, które można użyć podczas automatycznego wypełniania pól meta dla kategorii, producentów i produktów.\r\n<div class=\"objasnieniaTresc\">\r\n<ul>\r\n	<li><b>{NAZWA_KATEGORII}</b> - Nazwa kategorii (przy produktach - domyślnej dla produktu)</li>\r\n	<li><b>{SCIEZKA_KATEGORII}</b> - Ścieżka kategorii produktu (przy produktach - domyślnej dla produktu) w postaci: Nazwa - Nazwa - Nazwa</li>\r\n	<li><b>{DUZE_NAZWA_KATEGORII}</b> - Nazwa kategorii pisana dużymi literami (przy produktach - domyślnej dla produktu)</li>\r\n	<li><b>{MALE_NAZWA_KATEGORII}</b> - Nazwa kategorii pisana małymi literami (przy produktach - domyślnej dla produktu)</li>\r\n	<li><b>{Z_DUZEJ_NAZWA_KATEGORII}</b> - Nazwa kategorii pisana z dużej litery (przy produktach - domyślnej dla produktu)</li>\r\n	<li><b>{OPIS_KATEGORII}</b> - Opis kategorii (przy wypełnianiu meta produktów niedostępne, tekst zostanie przycięty do 255 znaków)</li>\r\n	<li><b>{NAZWA_PRODUCENTA}</b> - Nazwa producenta</li>\r\n	<li><b>{DUZE_NAZWA_PRODUCENTA}</b> - Nazwa producenta pisana dużymi literami</li>\r\n	<li><b>{MALE_NAZWA_PRODUCENTA}</b> - Nazwa producenta pisana małymi literami</li>\r\n	<li><b>{Z_DUZEJ_NAZWA_PRODUCENTA}</b> - Nazwa producenta pisana z dużej litery</li>\r\n	<li><b>{OPIS_PRODUCENTA}</b> - Opis producenta (przy wypełnianiu meta produktów niedostępne, tekst zostanie przycięty do 255 znaków)</li>\r\n	<li><b>{NAZWA_PRODUKTU}</b> - Nazwa produktu</li>\r\n	<li><b>{DUZE_NAZWA_PRODUKTU}</b> - Nazwa produktu pisana dużymi literami</li>\r\n	<li><b>{MALE_NAZWA_PRODUKTU}</b> - Nazwa produktu pisana małymi literami</li>\r\n	<li><b>{Z_DUZEJ_NAZWA_PRODUKTU}</b> - Nazwa produktu pisana z dużej litery</li>\r\n	<li><b>{OPIS_PRODUKTU}</b> - Opis produktu (przy wypełnianiu meta kategorii i producentów niedostępne, tekst zostanie przycięty do 255 znaków)</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<br />\r\nKolejnymi pozycjami formularza jest ustalenie zakresu w jakim zostaną wypełnione dane Meta. Możliwe jest automatyczne wypełnienie wszystkich rekordów zapisanych w bazie danych, tylko tych, które mają puste wartości oraz wyczyszczenie wszystkich zapisanych wcześniej informacji. Dodatkową opcją jest pozostawienie informacji <em>bez zmian</em>. Przydatne może to być w sytuacji, gdy chcemy np. zaktualizować tylko informacje dotyczące kategorii - wówczas dla producentów oraz produktów należy zaznaczyc właśnie opcje <em>bez zmian</em>.<br />\r\n<br />\r\nPo kliknięciu przycisku <strong>Aktualizuj dane</strong> - program przystąpi do zapisywania informacji w bazie danych.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\">UWAGA: ponieważ opcja ta wykonuje działania na bazie danych zalecamy wcześniejsze utworzenie kopii aktualnej bazy w menu <strong>Narzędzia / Archiwizacja danych</strong></span>"),
("149","667","1","instrukcja","Kończące się cechy produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_konczace_produkty_cechy.jpg\" style=\"width: 550px; height: 227px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Raport <strong>kończące się cechy produktów</strong> umożliwia wygenerowanie raportu z produktami, które mają niski stan magazynowy cech - poniżej określonego w parametrach raportu. Raport wyświetla wyłącznie produkty, które posiadają cechy oraz stany magazynowe tych cech były dodawane lub aktualizowane w produktach.</div>\r\n\r\n<div style=\"text-align:justify;\">Domyślnie wyświetlane są produkty, których cechy mają stan magazynowy mniejszy od 2. Raport działa wyłącznie jeżeli w sklepie jest włączona kontrola stanów magazynowych produktów oraz powiązanie cech produktów z magazynem (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu</strong>).<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Wygenerowane dane są wyświetlane w formie tabeli. Tabela składa się z siedmiu kolumn: id produktu, zdjęcie produktu, nr katalogowy, nazwa produktu, cena brutto, ilość w magazynie oraz stan produktu - czy produkt jest aktywny czy wyłączony. Stan magazynowy (ilość w magazynie) jest wyświetlany dla poszczególnych cech produktu.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nNad tabelą z produktami znajduje się pole ilości produktów. Standardowo jest w tym miejscu wstawiona cyfra 2 - oznacza to, że będą wyświetlane produkty, których cechy mają stan magazynowy mniejszy od 2. Wartość tą można zmienić - raport zostanie wygenerowany ponownie dla innej wartości liczbowej. Dodatkowo można zaznaczyć żeby w raporcie były wyświetlane tylko produkty aktywne.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\">Obok pola ilości znajduje się opcja wyboru: wszystkie produktu, tylko z wybranej kategorii lub tylko producenta. Po wybraniu tylko z wybranej kategorii - zostanie wyświetlona lista dostępnych w sklepie kategorii (w formie rozwijanego drzewa). Po kliknięciu w wybraną kategorię zostaną wyświetlone tylko produkty z danej kategorii ze stanem magazynowym poniżej ustalonego. Podobnie po wybraniu producenta, zostanie wyświetlona lista producentów i kliknięcie w wybranego spowoduje wyświetlenie produktów danego producenta.</div>\r\n"),
("150","668","1","instrukcja","Wyszukiwane frazy","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_wyszukiwane_frazy.jpg\" style=\"width: 550px; height: 293px; margin-left: 15px; float: right;\" />Statystyka<strong> wyszukiwane frazy</strong> przedstawia informacje na temat 100 najczęściej wyszukiwanych w sklepie fraz poprzez wyszukiwarkę. Raport prezentuje dane w formie graficznej (wykres kołowy) oraz w formie tabeli gdzie wg ilości wyszukań przedstawione są frazy wraz z ilością wyszukań. Przy każdej pozycji znajduje się ikona krzyżyka, która umożliwia wyzerowanie licznika dla danej frazy. Na samym dole listingu znajduje się opcja wyzerowania wszystkich liczników.</div>\r\n\r\n<div style=\"text-align:justify;\">Raport przedstawia osobne dane dla poszczególnych wersji językowych. Zmiana języka następuje poprzez kliknięcie w ikonę flagi danego języka na wykresem. Każda wersja językowa ma osobne statystyki wyszukań.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/box_chmura_tagow.jpg\" style=\"width:180px;height:113px;margin-right:10px;margin-bottom:10px;float:left;\" />Dane do raportu z poziomu sklepu dodają się automatycznie na podstawie wyszukiwań klientów. Jeżeli w wyszukiwarce w sklepie klient wpisze szukaną frazę i zostanie ona odnaleziona w wynikach wyszukiwania to automatycznie zostanie dodana do raportu. Na podstawie tego raportu jest również w sklepie tworzony box tzw &quot;chmury tagów&quot;.</div>\r\n"),
("151","669","1","instrukcja","Inwentaryzacja","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/raport_inwentaryzacja.jpg\" style=\"width:550px;height:230px;margin-left:15px;margin-bottom:15px;float:right;\" /><strong>Inwentaryzacja</strong> umożliwia wygenerowanie raportu ze wszystkimi produktami w sklepie (które mają stan magazynowy większy od 0) i ich stanami magazynowymi. Domyślnie wyświetlane są wszystkie produkty w kolejności wg ilości stanu magazynowego oraz nazwy. Raport działa wyłącznie jeżeli w sklepie jest włączona kontrola stanów magazynowych produktów (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu / Kontrola stanów magazynowych produktów</strong>). Jeżeli dodatkowo jest włączone w sklepie powiązanie cech produktów z magazynem to przy produktach, które posiadają cechy jest wyświetlony stan magazynowych poszczególnych cech.<br />\r\n<br />\r\nWygenerowane dane są wyświetlane w formie tabeli. Tabela składa się z siedmiu kolumn: id produktu, zdjęcie produktu, nr katalogowy, nazwa produktu, cena brutto, ilość w magazynie oraz stan produktu - czy produkt jest aktywny czy wyłączony. Stan magazynowy (ilość w magazynie) jest wyświetlany dla całego produktu oraz dla poszczególnych cech produktu.</div>\r\n\r\n<div style=\"text-align:justify;\">Nad tabelą z produktami znajduje się opcja wyboru: wszystkie produktu, tylko z wybranej kategorii lub tylko producenta. Po wybraniu tylko z wybranej kategorii - zostanie wyświetlona lista dostępnych w sklepie kategorii (w formie rozwijanego drzewa). Po kliknięciu w wybraną kategorię zostaną wyświetlone tylko produkty z danej kategorii ze stanem magazynowym poniżej ustalonego. Podobnie po wybraniu producenta, zostanie wyświetlona lista producentów i kliknięcie w wybranego spowoduje wyświetlenie produktów danego producenta.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/raport_inwentaryzacja_csv.jpg\" style=\"width:550px;height:91px;margin-bottom:15px;margin-right:15px;float:left;\" />Nad tabelą po prawej stronie znajduje się opcje eksportu danych do pliku. Umożliwia ona wygenerowanie pliku w formacie csv z danymi. Po wciśnięciu przycisku zostanie wygenerowany plik csv, który można pobrać i zapisać na dysku (plik zostaje również zapisany na serwerze w katalogu /export). Po otworzeniu pliku np w OpenOffice (zalecamy ten pakiet do obórki plików csv) można edytować pobrane dane. Plik posiada kodowanie polskich znaków w standardzie UTF-8, a pola są rozdzielone znakiem średnika (separator pól).<br />\r\n<br />\r\nWygenerowany plik po otworzeniu w arkuszu kalkulacyjnym wyświetla dane w formie kolumn. Poszczególne kolumny wyświetlają: numer katalogowy, nazwę produktu, cenę poprzednią oraz cenę netto i brutto, a także ilość w magazynie i status produktu. Słowo <strong>tak</strong> przy statusie oznacza, że produkt jest aktywny.</div>\r\n"),
("152","12","1","instrukcja","Dane firmy","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_dane_firmy.jpg\" style=\"margin-left: 15px; margin-right: 15px; float: right; width: 580px; height: 437px;\" />W menu <strong>Konfiguracja / Dane teleadresowe / Dane firmy</strong> znajduje się formularz umożliwiający wprowadzenie wszystkich danych firmowych, które będą drukowane na fakturach, zamówieniach, itp.<br />\r\n<br />\r\nCzęść z tych danych dotycząca adresu być wyświetlane w boxie <em>Kontakt </em>w kolumnie bocznej sklepu. Box ten można włączyć w menu <strong>Wygląd / Ustawienia sklepu</strong> - zakładka Boxy w kolumnach.<br />\r\n<br />\r\nDane, które są w tym miejscu wpisane nie są uwzględniane w znacznikach META. Dotyczy to w szczególności danych konta bankowego, które wpisane w tym miejscu nie jest tożsame z danymi do przelewu w module płatności przelewem.</div>\r\n"),
("153","11","0","instrukcja","Dane adresowe",""),
("154","13","1","instrukcja","Dane kontaktowe","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_dane_kontaktowe.jpg\" style=\"margin-left: 15px; margin-right: 15px; float: right; width: 600px; height: 388px;\" />W menu <strong>Konfiguracja / Dane teleadresowe / Dane kontaktowe</strong> znajduje się formularz umożliwiający wprowadzenie wszystkich danych kontaktowych, które mogą być wyświetlane w boxie <em>Kontakt </em>w kolumnie bocznej sklepu. Box ten można włączyć w menu <strong>Wygląd / Ustawienia sklepu</strong> - zakładka Boxy w kolumnach.</div>\r\n"),
("155","15","0","instrukcja","Konfiguracja sklepu",""),
("156","16","1","instrukcja","Ustawienia dla hurtowni","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_ustawienia_hurtowni.jpg\" style=\"float: right; width: 468px; height: 137px; margin-left: 15px; margin-bottom: 15px;\" />W programie istnieje możliwość prowadzenia sprzedaży zarówno detalicznej jak i hurtowej. Jeżeli ma być prowadzona sprzedaż w cenach hurtowych - innych niż ceny detaliczne wówczas można w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia dla hurtowni</strong> zdefiniować kilka różnych poziomów cen, które będą obowiązywały na produkty dla określonych grup użytkowników. Po wybraniu tej pozycje w menu wyświetlony zostanie formularz pozwalający na wprowadzenie odpowiednich ustawień.<br />\r\n<br />\r\nPierwszą opcją jest określenie ile będzie można wprowadzić cena dla każdego produktu (standardowo każdy produkt ma przypisaną tylko jedną cenę). Jeżeli zostanie zadeklarowana inna ilość, to wówczas podczas dodawania/edycji produktu będzie można wpisać kilka cen. Każdą grupę cenową można przypisać do innej grupy klientów w menu <strong>Sprzedaż / Klienci / Grupy klientów</strong>. Wówczas jeżeli klient należy do wybranej grupy klientów z innym poziomem cen niż cena podstawowa, to po zalogowaniu widzi przy każdym produkcie cenę ustaloną dla określonej grupy klientów.<br />\r\n<br />\r\nKolejną opcją w przypadku ustawień dla sprzedaży hurtowej jest możliwość wyłączenia wyświetlania w sklepie cen klientom, którzy nie są zalogowani. Po ustawieniu tej opcji, klient który nie jest w sklepie zalogowany nie widzi cen produktów oraz nie ma możliwości dokonywania zakupów.<br />\r\n<br />\r\nW programie można również ustawić narzut do cen dla klientów nie zalogowanych w sklepie. W takim przypadku klient widzi wyższe ceny do czasu zalogowania się na swoje konto w sklepie. Również jeżeli dokonuje zakupu bez zakładania konta - zamówienie jest realizowane po cenach z ustalonym narzutem.<br />\r\n<br />\r\nOstatnią opcją, którą można ustawić w przypadku prowadzenia sprzedaży hurtowej jest możliwość zablokowania automatycznej rejestracji klientów w sklepie. Po ustawieniu tej opcji, jeżeli klient się na stronie sklepu zarejestruje, to jego konto nie jest od razu aktywne i nie może dokonać zakupu. Konto musi zostać aktywowane przez obsługę sklepu. Dopiero po takiej aktywacji klient może się zalogować na konto i dokonywać zakupy.</div>\r\n"),
("157","17","1","instrukcja","Ustawienia cen","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_ustawienia_cen.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 441px; height: 49px;\" />W menu <strong>Konfiguracja / Ustawienia sklepu / Ustawienia cen</strong> można zadeklarować w jaki sposób ceny mają być wyświetlane w sklepie. Są tutaj do ustawienia dwie opcje. Pierwsza z nich to z jaką precyzją mają być wyświetlane ceny - zaokrąglone do pełnych jednostek lub z częściami dziesiętnymi.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_ustawienia_cen_przyklad.jpg\" style=\"float:left;width:303px;height:116px;margin-right:15px;margin-bottom:15px;\" />Druga opcja do ustawienia to czy ceny mają być wyświetlane tylko w wartościach brutto czy równocześnie brutto i netto. Ustawienia te mają wpływ tylko na sposób prezentacji cena klientowi w sklepie - nie mają wpływu na sposób realizacji zamówienia.<br />\r\n<br />\r\nOprócz dwóch w/w opcji dotyczących wyświetlania cen w sklepie w opisywanym menu konfiguracji są dodatkowo dostępne dwie opcje dotyczące klientów dokonujących zakupów z terenu EU.<br />\r\n<br />\r\nDotyczą one firm z terenu Unii Europejskiej z ważnym nr NIP z rozszerzeniem europejskim. Przy aktywnej opcji <strong>Dla klientów z UE (firm z NIP-em europejskim) stosować tylko ceny netto i VAT 0%</strong> - klienci z terenu będą mogli kupować w sklepie w cenach netto. Sklep podczas składania zamówienia sprawdza czy jest poprawny i aktywny nr NIP - jeżeli tak to ceny w sklepie i zamówienie będzie wyświetlane w kwotach netto. Taka sytuacja występuje wówczas jeżeli klient jest z innego kraju niż sklep sprzedawcy. Dla przykładu: sklep internetowy prowadzony jest na terenie Polski - kupujący to firma z Niemiec z europejskim NIPem. Sklep podczas zakupu sprawdza nr NIP i jeżeli jest poprawny aktywuje ceny netto. Dalsza sprzedaż następuje w cenach netto. Jeżeli opcja<strong> Sposób aktywacji cen netto dla klientów (na podstawie podanego NIPu)</strong>&nbsp; jest ustawiona na <strong>automatyczną</strong> to sklep sam sprawdza i aktywuje ceny netto. Jeżeli jest ustawiona <strong>ręczna</strong> aktywacja - właściciel sklepu w menu <strong>Sprzedaż / Klienci / Klienci</strong> sam ręcznie aktywuje ceny netto dla klienta.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/klienci_ceny_netto.jpg\" style=\"float: left; margin-right:15px; margin-bottom:15px; width: 80px; height: 207px;\" />Przy aktywnej opcji cen netto dla klientów z UE w menu <strong>Sprzedaż / Klienci / Klienci</strong> wyświetlana jest dodatkowa kolumna, w której widoczne jest czy dany klient ma przypisane ceny netto czy też nie. Klikając w ikonkę można zmienić dla danego klienta tą opcję (wł/wy ceny netto - tylko dla klientów z rejestracją).<br />\r\n<br />\r\n<span style=\"color:#FF0000;\"><strong>Sprawdzanie przez sklep poprawności nr NIP odbywa się za pośrednictwem strony: http://ec.europa.eu/taxation_customs/vies/vatResponse.html</strong></span></div>\r\n"),
("158","18","1","instrukcja","Ustawienia pól klientów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_ustawienia_pol_klientow.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 415px; height: 375px;\" />W menu <strong>Konfiguracja / Ustawienia sklepu / Ustawienia pól klientów</strong> można określić jakie pola mają być wyświetlane klientowi podczas rejestracji w sklepie. Jeżeli dane pole jest zaznaczone, ze ma być w formularzu rejestracyjnym, to wówczas automatycznie jest ono polem wymaganym i klient musi je podczas rejestracji wypełnić.<br />\r\n<br />\r\nPierwszą opcją w tym menu jest ustawienie, czy klienci mogą w sklepie robić zakupy bez zakładania konta. Jeżeli wyrażamy na to zgodę wówczas klient ma możliwość kupowania nie rejestrując się w sklepie. Wówczas podczas składania zamówienia musi podać tylko adres e-mail oraz dane do wysyłki. Natomiast jeżeli klient zakłada kont w sklepie wówczas poza danymi potrzebnymi do zalogowania musi wypełnić ewentualne zdefiniowane dodatkowe pola dla klientów (w menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do klientów</strong>). Ponadto ma możliwość zaznaczenia czy chce otrzymywać newsletter. Posiada wówczas również możliwość przeglądania historii swoich zamówień w sklepie.<br />\r\n<br />\r\nKolejne pozycje włączają / wyłączają poszczególne pola w formularzu rejestracji klienta.<br />\r\n<br />\r\nKolejną opcją jest możliwość ustawienia rodzaju klientów, którzy mogą się rejestrować w sklepie / dokonywać zakupów. Wybranie opcji <strong>dowolny</strong> powoduje, że w sklepie mogą się rejestrować zarówno osoby fizyczne jak i firmy. Wybranie opcji <strong>tylko firma</strong> powoduje, że w sklepie mogą rejestrować się tylko firmy - przy rejestracji oraz dokonywaniu zakupów konieczne jest podanie nazwy firmy oraz nr NIP.<br />\r\n<br />\r\nIstotną pozycją w formularzu jest także ustawienie <strong>domyślnie zaznaczonego dokumentu sprzedaży</strong> podczas składania zamówienia. Można wybrać domyślny dokument jako <strong>paragon</strong> lub <strong>faktura</strong> - lub ustawić, żeby żadna opcja nie była domyślnie zaznaczona. Przy takim ustawieniu jeżeli klient nie wybierze żadnej opcji - to przy potwierdzeniu zamówienia zostanie wyświetlone dodatkowe okno popup gdzie klient będzie musiał wybrać dokument sprzedaży jaki chce otrzymać za zakupione produkty.</div>\r\n"),
("159","19","1","instrukcja","Ustawienia magazynu","<div style=\"text-align:justify;\"><img alt=\"\" src=\"obrazki/pomoc/konfiguracja_ustawienia_magazynu.jpg\" style=\"width: 508px; height: 165px; float: right;\" />W menu <strong>Konfiguracja / Ustawienia sklepu / Ustawienia magazynu</strong> można zadeklarować w jaki sposób w sklepie będzie obsługiwany magazyn. Po wybraniu tej pozycji menu wyświetlony zostanie formularz umożliwiający ustawienie wybranych przez siebie parametrów w jaki sposób ma być obsługiwany magazyn.<br />\r\n<br />\r\nW pierwszej pozycji formularza należy określić czy program ma w ogóle sprawdzać stany magazynowe produktów podczas składania przez klientów zamówień. Jeżeli opcja ta zostanie wyłączona, wówczas pozostałe ustawienia nie mają znaczenia. Program wówczas nie kontroluje czy produkty są w magazynie i jaki jest aktualnie ich stan.<br />\r\n<br />\r\nJeżeli zostanie wybrana opcja sprawdzania stanów magazynowych produktów - wówczas można określić kolejne parametry. Czy klient może zakupić produkt pomimo jego braku w magazynie. Włączenie tej opcji powoduje, że pomimo iż w danej chwili towaru nie mamy w magazynie, to klient może go dodać do koszyka i kupić.<br />\r\n<br />\r\nNastępna opcja możliwa do ustawienia to działanie programu w przypadku zakupu przez klienta ostatniej sztuki produktu. Możliwe są tutaj dwie opcje. Pierwsza to automatyczne wyłączenie przez program produktu - wówczas produkt przestaje być widoczny w sklepie. W celu ponownego jego włączenia wymagana jest interwencja obsługi sklepu. Należy wówczas ręcznie aktywować produkt w menu <strong>Asortyment / Produkty</strong>. Jeżeli opcja to zostanie wyłączona - wówczas po zakupie ostatniej sztuki stan produktu się nie zmienia i jest on nadal widoczny w sklepie - natomiast możliwość jego zakupu zależy od wcześniejszych ustawień.<br />\r\n<br />\r\nKolejną Ostatnią opcją możliwą do ustawienia jest sprawdzanie stanów magazynowych cech produktów. Włączenie tej opcji wymaga późniejszego wprowadzenia stanów magazynowych dla wszystkich cech sprzedawanych produktów. Stany cech magazynowych wprowadza się w menu <strong>Asortyment / Produkty</strong> - edycja produktu w zakładce <em>Cechy produktów. </em>Jeżeli zostanie włączona opcja sprawdzania stanów magazynowych cech produktów a nie zostaną wprowadzone ich stany - wówczas nie będzie możliwości kupienia takiego produktu.<br />\r\n<br />\r\nDodatkowo można w konfiguracji ustawić minimalną ilość produktów znajdujących się w magazynie poniżej, której program będzie informował użytkownika o kończących się stanach magazynowych produktów.</div>\r\n"),
("160","701","0","instrukcja","Stawki VAT","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/stawki_vat.jpg\" style=\"width:500px;height:153px;margin-left:15px;margin-bottom:15px;float:right;\" />W sklepie można definiować dowolne stawki VAT do produktów. Standardowo w sklepie są zdefiniowane obowiązujące w Polsce stawki VAT. Podczas edycji czy dodawania produktu, można wybrać do jakiej grupy podatkowej należy produkt.<br />\r\n<br />\r\nObsługa stawek VAT w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Słowniki / Stawki VAT</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu stawek VAT. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji</strong>.<br />\r\n<br />\r\nW liście każda stawka jest wyświetlana&nbsp;w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest wartość procentowa danej stawki VAT. Następna kolumna to opis - jest on widoczny podczas edycji czy dodawania produktu - ten opis jest widoczny tylko w panelu zarządzania sklepu. W następnej kolumnie znajduje się nazwa skrócona stawki VAT. Teksty z tej kolumny są widoczne w generowanej dla klienta fakturze VAT. Kolejna kolumna to kolejność. Wg kolejności będą wyświetlane stawki VAT. Przedostatnia kolumna to status stawki podatku. W sklepie musi być ustawiona domyślna stawka podatku VAT. Zielona ikonka oznacza, że dana stawka jest domyślną. Podczas edycji czy dodawania stawek VAT można ustawić, która stawka w sklepie ma być domyślna.&nbsp; W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję stawki VAT.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/stawki_vat_dodawanie.jpg\" style=\"width:240px;height:174px;margin-bottom:15px;margin-right:15px;float:left;\" />Nową stawkę podatku dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji.<br />\r\n<br />\r\nPrzy dodawaniu nowego podatku należy wpisać w poszczególnych polach: wartość procentową podatku (od 0 do 100), kolejność wyświetlania, opis, opis skrócony (widoczny na fakturach) oraz ustawić czy dodawana stawka ma być domyślnym podatkiem.<br />\r\n<br />\r\nEdycja istniejącego podatku jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.<br />\r\n<br />\r\n&nbsp;</div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("161","702","0","instrukcja","Kraje","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/kraje.jpg\" style=\"width:550px;height:160px;margin-left:15px;margin-bottom:15px;float:right;\" />Klient podczas składania zamówienia lub podczas rejestracji w może wybrać w jakim kraju mieszka lub do jakiego kraju ma zostać wysłane zamówienie. W zależności od miejsca zamieszkania klienta (kraju) sklep może stosować różne koszty wysyłek. Podczas edycji modułów wysyłek (menu <strong>Moduły / Wysyłki</strong>) można przypisać dla jakich krajów dana wysyłka jest dostępna. Dzięki temu można zastosować zróżnicowane koszty wysyłek dla różnych krajów.<br />\r\n<br />\r\nStandardowo w sklepie są zdefiniowane kraje z których klienci najczęściej dokonują zakupów.<br />\r\n<br />\r\nObsługa krajów w panelu zarządzania odbywa się poprzez menu K<strong>onfiguracja / Słowniki / Kraje i regiony</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu krajów. W liście kraje są domyślnie posortowane wg nazwy. Powyżej okna z listą krajów znajduje się pole wyszukiwania. Umożliwia ono wyszukanie wybranego kraju. Poniżej znajduje się przycisk <strong>dodawania nowej pozycji</strong>.<br />\r\n<br />\r\nW liście każdy kraj jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest nazwa kraju. W kolejnych dwóch kolumnach jest wyświetlany kod ISO danego kraju. Kody są podawane wg standardu ISO 3166-1, który jest częścią standardu ISO 3166 - zawiera on 3 wersje kodów nazw państw oraz terytoriów. Przedostatnia kolumna to status kraju. W sklepie musi być ustawiony domyślny kraj - będzie on wyświetlany jako domyślny podczas rejestracji klienta w sklepie. Zielona ikonka oznacza, że dany kraj jest ustawiony jako domyślny. Podczas edycji czy dodawania kraju można ustawić, który kraj w sklepie ma być domyślny. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję oraz usunięcie danego kraju. Opcja usuwania państwo jest nieaktywna w przypadku kraju domyślnego. Aby usunąć kraj ustawiony jako domyślny trzeba najpierw ustawić inny kraj jako domyślny - po tym będzie można usunąć dane państwo. Pierwsza z ikon <img alt=\"alt\" src=\"obrazki/pomoc/kraje_regiony_ikona.png\" style=\"width:22px;height:20px;\" />umożliwia edycję województw (regionów danego kraju).<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/kraje_regiony.jpg\" style=\"width:500px;height:112px;margin-bottom:15px;margin-right:15px;float:left;\" />Po kliknięciu w ikonę województw zostanie wyświetlona lista województw (regionów) jakie są przypisane do danego kraju. Województwa dodane do krajów nie mają wpływu na koszty wysyłek produktów. Mają wyłącznie charakter informacyjny i jeżeli jest włączona opcja wyświetlania województw (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia pól klientów</strong>) to pole wyboru województwa wyświetla się podczas rejestracji klienta.<br />\r\n<br />\r\nListing województw wyświetla po kolei: id województwa w bazie sklepu, nazwę województwa (regionu), kod oraz ikony nawigacyjne. Nad listingiem znajduje się opcja dodawania nowego województwa. Podczas dodawania nowego województwa należy wpisać jego nazwę oraz kod. Kod musi być unikalny. Najlepiej jak będzie się składał z 3-4 dużych liter - kod nie musi być zgodny ze standardem ISO.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/kraje_dodawanie.jpg\" style=\"width: 350px; height: 203px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Nowy kraj dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję </strong>nad listingiem państw. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji.<br />\r\n<br />\r\nPrzy dodawaniu nowego kraju należy wpisać jego nazwę. Jest to pole obowiązkowe do wypełnienia. Nazwę trzeba wpisać we wszystkich dostępnych wersjach językowych. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa kraju w innych wersjach językowych - zostanie w to pole wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\nKolejne pola to kod wg ISO - te pola również są obowiązkowe. Ostatnie pole to opcja wyboru czy dany kraj ma być krajem domyślnym.<br />\r\n<br />\r\nEdycja istniejącego kraju jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Jeżeli sklep ma sprzedawać wyłącznie np na terenie Polski należy usunąć pozostałe kraje. Po usunięciu klient podczas rejestracji będzie mógł wybrać wyłącznie kraj, który pozostanie.<br />\r\n&nbsp;</div>\r\n"),
("162","703","0","instrukcja","Waluty","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/waluty.jpg\" style=\"width:470px;height:120px;margin-left:15px;margin-bottom:15px;float:right;\" />Waluty są w sklepie jednym z najważniejszych elementów. Każdy produkt ma swoją cenę, które jest wyrażona w określonej walucie. <img alt=\"alt\" src=\"obrazki/pomoc/waluty_wybor_przy_produkcie.jpg\" style=\"width: 220px; height: 79px; margin-top: 10px; margin-right: 10px; margin-bottom: 10px; float: left;\" />Sklep obsługuje dowolną ilość walut. Sklep standardowo ma zdefiniowane cztery główne waluty. Produkty mogą być wyświetlane po stronie sklepu w dowolnej walucie (dostępnej w sklepie) oraz ceny produktów po stronie panelu zarządzania mogą być także wprowadzone w dowolnych walutach. Jeżeli cena produktu będzie wprowadzona w innej walucie niż domyślna waluta sklepu - po stronie sklepu jej cena będzie przeliczona i wyświetlona w walucie domyślnej. <img alt=\"alt\" src=\"obrazki/pomoc/box_waluta.jpg\" style=\"width:200px;height:78px;float:right;margin-left:10px;margin-top:10px;margin-bottom:10px\" />Po stronie sklepu klient może zmienić walutę w jakiej będą wyświetlane ceny. Standardowo zmiana waluty następuje poprzez wybór z rozwijanej listy danej waluty w boxie walut - box umożliwiający zmianę walut można włączyć w menu <strong>Wygląd / Ustawienia wyglądu / Boxy w kolumnach</strong>.<br />\r\n<br />\r\nObsługa walut w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Słowniki / Waluty</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu walut. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji</strong>.<br />\r\n<br />\r\nW liście każda waluta jest wyświetlana w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest nazwa waluty. Kolejna kolumna to kod waluty - nie jest on widoczny po stronie sklepu - musi być unikalny. W następnej kolumnie wyświetlany jest symbol waluty - ta wartość będzie widoczna w sklepie przy cenach produktów. Kolejna kolumna to separator dziesiętny - różne waluty mają różne zapisy części ułamkowych. W przypadku złotego jest to przecinek, ale np już w euro stosuje się kropkę. Następna kolumna to przelicznik - określa ona przelicznik danej waluty w stosunku do waluty domyślnej. Waluta domyślna zawsze ma przelicznik równy 1. Dla przykładu: 1 euro to 4 zł. Przelicznikiem dla euro (jeżeli nie jest ustawione jako waluta domyślna) będzie 0.25 - wynika to z dzielenia 1/4 = 0.25. Następna kolumna to kurs danej waluty w stosunku do waluty domyślnej. Kursy mogą być aktualizowane na podstawie notowań NBP. Kolejna kolumna to marża (prowizja na walucie). Jest to wartość procentowa, której zadaniem jest niwelowanie wahań kursów walut. Np jeżeli kurs euro to 4 zł - można dodać marżę 10% - wtedy kurs euro w sklepie będzie miał wartość 4,4 zł - i np produkt który kosztuje 100 euro - będzie miał w sklepie cenę 440 zł. Jest to przydatne rozwiązanie w przypadku walut, które mają częste wahania w ciągu dnia. Kolejna kolumna to status (czy waluta jest domyślną). Zielona ikonka oznacza, że dana waluta jest domyślną. Domyślna waluta sklepu jest przyjmowana na podstawie domyślnego języka sklepu w którym definiuje się w jakiej walucie mają być wyświetlane produkty. Przedostatnia kolumna to data ostatniej aktualizacji waluty (kursu waluty). W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję oraz usunięcie waluty. Nie można w sklepie usunąć waluty z nr id 1.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/waluty_edycja.jpg\" style=\"width: 300px; height: 212px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Nową walutę dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji.<br />\r\n<br />\r\nPrzy dodawaniu nowej waluty należy wpisać w poszczególnych polach: nazwę waluty, kod (musi być unikalny), symbol waluty, trzeba wybrać separator dziesiętny (możliwe do wyboru to kropka albo przecinek) oraz wpisać przelicznik waluty. Dodatkowo jako opcję można wpisać prowizję na walucie (marżę).<br />\r\n<br />\r\nEdycja istniejącej waluty jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Sklep może dokonywać aktualizacji kursów walut na podstawie notowań NBP. W celu aktualizacji kursów należy kliknąć w link <strong>zaktualizuj kursy w oparciu o dane NBP</strong>, który znajduje się pod listingiem walut. Sklep posiada także mechanizm automatycznej (co określony czas) aktualizacji walut. Do tego jest używany mechanizm <strong>Harmonogramu zadań</strong> w menu <strong>Narzędzia / Harmonogram zadań</strong> (dokładniej opisany w dalszej części instrukcji).<br />\r\n<br />\r\n&nbsp;</div>\r\n"),
("163","704","0","instrukcja","Języki","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/jezyki.jpg\" style=\"width:500px;height:97px;margin-left:15px;margin-bottom:15px;float:right;\" />Sklep shopGold w swojej budowie umożliwia wielojęzyczność - sklep nie musi być dostępny dla klientów wyłącznie w języku polskim, ale może być także&nbsp; dostępny w wielu językach. Standardowo w sklepie są wbudowane dwie wersje językowe: polski i angielski. Sklep nie ma limitu obsługiwanych języków i można dodać do sklepu kolejne języki. Język polski jest głównym językiem sklepu i tego języka nie można usunąć ze sklepu. <img alt=\"alt\" src=\"obrazki/pomoc/box_jezyk.jpg\" style=\"width:190px;height:70px;margin-top:10px;margin-right:10px;float:left;\" />Można jednak zmienić, że inny język niż polski będzie językiem domyślnym sklepu (w tym języku będzie się domyślnie uruchamiał sklep dla klienta). Po stronie sklepu klient może zmienić język w jakim chce wyświetlać sklep. Standardowo zmiana języka następuje poprzez kliknięcie w ikonę flagi danego języka w boxie języków - box umożliwiający zmianę języków można włączyć w menu <strong>Wygląd / Ustawienia wyglądu / Boxy w kolumnach</strong>. Dodatkowo zmiana języka powoduje zmianę waluty sklepu na przypisaną do danego języka.<br />\r\n<br />\r\nObsługa języków w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Słowniki / Języki</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu wersji językowych. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji</strong>.<br />\r\n<br />\r\nW liście każdy język jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest nazwa języka. Następna kolumna to kod (złożony z małych liter, unikalny ciąg znaków). W następnej kolumnie wyświetlana jest ikona (flaga) danego języka. Obrazki flag wyświetlane są w boxie zmiany języka i są linkami do zmiany wersji językowej sklepu. Kolejna kolumna to status języka (czy język jest ustawiony jako domyślny). Zielona ikonka oznacza, że dany język jest ustawiony w sklepie jako domyślny. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję lub usunięcie wersji językowej. Nie można w sklepie usunąć języka z nr id 1.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/jezyki_dodawanie.jpg\" style=\"width:270px;height:166px;margin-bottom:15px;margin-right:15px;float:left;\" />Nową wersję językową sklepu dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji.<br />\r\n<br />\r\nPrzy dodawaniu nowej waluty należy wpisać w poszczególnych polach: nazwę języka, kod (musi być unikalny - napisany z małych liter bez spacji - jeden wyraz), ikonę (flagę) języka - 2-krotne kliknięcie w pole Ikona spowoduje otworzenie się przeglądarki zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta. Dodatkowo trzeba ustawić kolejność wyświetlania ikon w boxie oraz wybrać domyślną walutę dla języka. W ostatnim polu trzeba dokonać wyboru czy dany język ma być domyślny. Jeżeli zostanie ustawiony jako domyślny - zmieni się również w sklepie domyślna waluta - na taką jaka jest przypisana w danej wersji językowej.<br />\r\n<br />\r\nEdycja istniejącej wersji językowej jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu. Podczas edycji nie można dokonać modyfikacji (zmiany) nazwy języka oraz kodu.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE - dodawanie nowego języka:</strong></span> W sklepie przy dodawaniu produktów, kategorii, wysyłek, formularzy, treści maili etc - podczas wpisywania nazw i tekstów należy wpisywać treść we wszystkich dostępnych językach. Dlatego dodanie nowego języka zalecamy wykonać przed konfiguracją sklepu, dodaniem produktów czy kategorii. Dodanie języka w trakcie działania sklepu będzie powodowało konieczność edycji wszystkich elementów sklepu w których należy wpisywać tłumaczenia.<br />\r\n<br />\r\nPo dodaniu nowego języka do sklepu zaraz po instalacji (bez wprowadzonych produktów, kategorii itd) należy dokonać dodatkowych tłumaczeń w elementach sklepu, które są zdefiniowane tylko w standardowych językach w wersji instalacyjnej sklepu tj:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\">nazwy statusów zamówień&nbsp; - menu <strong>Sprzedaż / Zamówienia / Statusy zamówień</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy statusów reklamacji - menu <strong>Sprzedaż / Reklamacje / Statusy reklamacji</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy boxów - menu <strong>Wygląd / Boxy</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy modułów środkowych - menu <strong>Wygląd / Moduły środkowe</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy standardowych formularzy - menu <strong>Wygląd / Formularze</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy standardowych stron informacyjnych - menu <strong>Wygląd / Strony informacyjne / Zarządzanie stronami</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy państw - menu <strong>Konfiguracja / Słowniki / Kraje</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy terminów wysyłek - menu <strong>Konfiguracja / Słowniki / Terminy wysyłek</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy dostępności produktów - menu <strong>Konfiguracja / Słowniki / Dostępności produktów</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy statusów systemu punktów - menu <strong>Konfiguracja / Słowniki / Statusy punktów klientów</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy jednostek miar - menu <strong>Konfiguracja / Słowniki / Jednostki miary</strong></li>\r\n	<li style=\"text-align:justify;\">treść szablony e-maili - menu <strong>Konfiguracja / Słowniki / Szablony e-maili</strong></li>\r\n	<li style=\"text-align:justify;\">treść wiadomości e-maili - menu <strong>Konfiguracja / Słowniki / Treści wiadomości e-mail</strong></li>\r\n	<li style=\"text-align:justify;\">tłumaczenia tekstów sklepu - menu <strong>Konfiguracja / Tłumaczenia</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy wysyłek - menu <strong>Moduły / Wysyłki</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy metod płatności - menu <strong>Moduły / Płatności</strong></li>\r\n	<li style=\"text-align:justify;\">nazwy modułów podsumowania zamówienia - menu <strong>Moduły / Podsumowanie zamówienia</strong></li>\r\n</ol>\r\n"),
("164","19","1","instrukcja","Ustawienia systemu punktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_system_punktow.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 420px; height: 380px;\" />Program <strong>Systemu punktów</strong> umożliwia premiowanie klientów, którzy robią zakupy w sklepie, piszą opinie o produktach - punktami, przy pomocy których w późniejszym czasie, przy kolejnych zakupach mogą pomniejszać wartość zamówienia jaką muszą zapłacić lub mogą kupować produkty, które są dostępne tylko za punkty. System punktów działa wyłącznie dla klientów, którzy <strong>posiadają konto w sklepie</strong>. Punkty nie są naliczane ani nie można ich zrealizować bez założenia konta w sklepie. System punktów może być bardzo skutecznym sposobem na przywiązanie klientów do sklepu - klient po złożeniu zamówienia - jeżeli otrzyma określony pakiet punktów do wykorzystania przy następnych zakupach - będzie miał powód do powrotu w przyszłości do sklepu i dokonania kolejnych zakupów.<br />\r\n<br />\r\nPunkty klientów w panelu zarządzania są obsługiwane w menu <strong>Sprzedaż / Klienci / Klienci</strong>. Podczas edycji danych klienta jedna z zakładek jest przeznaczona do systemu punktów. Z poziomu tej zakładki można zatwierdzić punkty, usunąć lub dodać ręcznie punkty. Dokładny opis zakładki znajduje się w dziale o Klientach.<br />\r\n<br />\r\nPo wybraniu w menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia systemu punktów</strong> wyświetlany jest formularz, w którym można ustawić odpowiednie parametry tego systemu.<br />\r\n<br />\r\nPierwszą pozycją jest parametr czy system punktów ma być w sklepie włączony czy nie. Jeżeli użytkownik zdecyduje się na włączenie systemu punktów, to ma możliwość dowolnego zdefiniowania wielu jego parametrów:<br />\r\n<br />\r\n<strong>Czy w sklepie można kupować za punkty ?</strong> - włączenie tej opcji umożliwia klientom, którzy mają zebraną określoną ilość punktów dokonywania nimi &quot;zapłaty&quot; podczas składania zamówień. Przy składaniu zamówienia klient może zaznaczyć, że maja być wykorzystane do opłacenia zamówienia zebrane wcześniej punkty - w całości lub w części.<br />\r\n<br />\r\n<strong>Jeżeli w koszyku znajdują się produkty za punkty, to czy ma być możliwość zapłacenia za pozostałą część zamówienia punktami ? </strong>- jeżeli zostanie ustawiona ta opcja na - <strong>nie</strong> - to jeżeli klient doda do koszyka produkty, które można kupić tylko za punkty nie będzie miał możliwości wykorzystania pozostałej puli zgromadzonych punktów do zapłacenia za resztę zamówienia (na produkty, które są dostępne w normalnych cenach). Przy wariancie - <strong>tak</strong> - klient będzie mógł wykorzystać pozostałe dostępne punkty (punkty które ma na koncie minus punkty za produkty dostępne tylko za punkty) do zapłacenia za pozostałą część zamówienia.<br />\r\n<br />\r\n<strong>Ilość punktów otrzymanych za jednostkę płatniczą</strong> - określa ile klient otrzyma punktów podczas dokonywania zakupów za każdą wydaną złotówkę. W przypadku ustawienia wartości 1 - klient otrzyma 100 punktów za zakupiony produkt o wartości 100,00 złotych<br />\r\n<br />\r\n<strong>Ilość punktów wydanych podczas płacenia punktami </strong>- określa ile punktów klient musi wydać podczas realizacji zamówienia, żeby opłacić nimi określoną kwotę. W przypadku ustawienia wartości 50 - klient musi wydać 5000 punktów, żeby opłacić część zamówienia w kwocie 100,00 złotych.<br />\r\n<br />\r\n<strong>Czy naliczać punkty przy zamówieniach opłacanych punktami</strong> - parametr ten określa czy w przypadku, gdy klient realizuje zamówienie i opłaca je w całości lub części zebranymi wcześniej punktami mają mu być naliczone punkty z bieżącego zamówienia.<br />\r\n<br />\r\n<strong>Grupy klientów dla jakich ma być dostępny moduł systemu punktów (jeżeli nie zostanie wybrana żadna grupa system punktów będzie dostępny dla wszystkich klientów)</strong> - umożliwia udostępnienie systemu punktów tylko wybranym grupom klientów. Dzięki temu można wykluczyć wybrane grupy klientów z uczestnictwa w programie punktowym - np klientów hurtowych, którzy mają ustalone dodatkowe rabaty czy poziomy cen. Jeżeli klient będzie należał do grupy która nie jest objęta system punktów nie będzie otrzymywał punktów za zakupy, nie będzie mógł ich zrealizować oraz nie będzie mógł dokonać zakupu produktów które są dostępne tylko za punkty (w takim przypadku będzie widział normalną cenę produktu, a nie cenę w punktach). To ustawienie dotyczy także Programu Partnerskiego (konfiguracja w menu <strong>Sprzedaż / Program Partnerski / Konfiguracja PP</strong>). Punkty w ramach programu partnerskiego będą naliczane tylko tym partnerom, którzy należą do wybranych grup klientów.<br />\r\n<br />\r\nPozostałe pola formularza pozwalają na określenie wartości ilości punktów jakie klient otrzyma za napisanie recenzji oraz za zarejestrowanie się w sklepie. Ostatnie trzy pola określają minimalną oraz maksymalną ilość punktów jakie można wykorzystać podczas składania pojedynczego zamówienia oraz minimalną wartość zamówienia jaką musi osiągnąć klient aby móc wykorzystać punkty (wartość w domyślnej walucie sklepu).<br />\r\n<br />\r\n<span style=\"color:#FF0000;\"><strong>UWAGA</strong></span> Na stronie sklepu po skonfigurowaniu modułu zalecamy przygotowanie strony informacyjnej (np w stopce sklepu) z opisem jakie zasady zostały ustalone dla systemu punktów (jakie są poszczególne przeliczniki punktów). Dzięki temu klient będzie widział co i za ile otrzymuje oraz do czego służą punkty i kiedy będzie mógł je wykorzystać. W instrukcji w rozdziale Standardowe treści stron informacyjnych zamieszczamy przykładowy tekst strony informacyjnej, który możecie Państwo umieścić w sklepie.</div>\r\n"),
("165","20","1","instrukcja","Ustawienia rabatów i zniżek","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_znizki.jpg\" style=\"margin-left: 15px; margin-bottom: 15px; float: right; width: 420px; height: 337px;\" />Program oferuje dużą różnorodność stosowania rabatów i obniżek dla klientów.<br />\r\n<br />\r\nPonieważ połączenie wielu różnych rabatów mogłoby prowadzić do sytuacji, w której klienci płaciliby za produkty poniżej ich faktycznej wartości, to w menu <strong>Konfiguracja / Ustawienia sklepu / Ustawienia rabatów i zniżek</strong> wprowadzono możliwość ustawienia parametrów, które mogą ograniczyć wielkość rabatu w przypadku wystąpienia kumulacji wielu zniżek dla danego klienta czy produktu.<br />\r\n<br />\r\nMożna tu ustawić takie parametry jak to czy produkty będące aktualnie w promocji mają być objęte innymi zniżkami, które przysługują klientom np. z przynależności do określonej grupy, itp. Następnie, czy rabaty mają się sumować.<br />\r\n<br />\r\nIstotnym parametrem jest <strong>Maksymalna wartość rabatu</strong> - dzięki ustawieniu tego można ograniczyć maksymalną zniżkę jaka zostanie udzielona na dany produkt w przypadku wystąpienia kumulacji wielu różnych zniżek.<br />\r\n<br />\r\nOstatnie cztery parametry formularza dotyczą zniżek na produkty przy zakupie wielu sztuk towaru z jednego asortymentu. Zniżki te można definiować dla produktów podczas ich dodawania / edycji w zakładce <strong>Podstawowe dane</strong>, w sekcji <strong>Zniżki zależne od ilości produktów w koszyku</strong>. W tych ustawieniach można określić czy zniżki te mają występować w przypadku gdy na dany produkt zostają udzielone inne rabaty.</div>\r\n"),
("166","21","1","instrukcja","Ustawienia faktur VAT i paragonów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_faktury.jpg\" style=\"float: right; margin-left: 15px; margin-bottom: 15px; width: 460px; height: 356px;\" />W menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia faktur VAT i paragonów</strong> dostępny jest formularz umożliwiający ustalenie indywidualnych preferencji do generowania faktur i paragonów poprzez sklep.<br />\r\n<br />\r\n<strong>Zwolnienie z VAT</strong> - w sklepie istnieje możliwość wystawiania faktur zarówno dla firm które są płatnikami podatku VAT jak i dla firm, które są podmiotowo zwolnione z VAT. W przypadku jeżeli firma jest zwolniona z podatku VAT generowane faktury mają uproszczoną formę. Nie zawierają rozbicia na poszczególne stawki VAT oraz wyszczególnienia podatku VAT. Dodatkowo na dole faktury drukowana jest informacja o zwolnieniu podmiotowym z VAT (treść informacji można zmienić w tłumaczenia tekstów).<br />\r\n<br />\r\n<strong>Prefix</strong> - umożliwia zdefiniowanie stałego tekstu, który będzie wyświetlany przed numerem faktury lub paragonu. Mo ze to być dowolny tekst, np. FV/, Faktura numer, itp. Zależy to od indywidualnych preferencji użytkownika sklepu.<br />\r\n<br />\r\n<strong>Sufix</strong> - jest to ciąg znaków dodawany po numerze faktury lub paragonu. Wpisanie wartości /%Y spowoduje wyświetlenie bieżącego roku, natomiast wpisanie /%m/%Y spowoduje wyświetlenie po numerze faktury ciągu bieżącego miesiąca oraz bieżącego roku.<br />\r\n<br />\r\nKolejne pola pozwalają na ustalenie informacji, które będą wyświetlane na fakturze w każdej pozycji produktu takie jak numer katalogowy, producent, dodatkowe cechy<br />\r\n<br />\r\nPrzedostatnim parametrem jaki można ustalić jest dopełnianie numeru faktury do określonej ilości znaków, np. jeżeli zostanie tu ustawiona wartość 5, a numer wystawianej aktualnie faktury jest 100, to na wydruku będzie on zaprezentowany w postaci 00100 - długość zostanie uzupełniona z przodu zerami do tej ustawionej w konfiguracji.<br />\r\n<br />\r\nOstatnia opcja umożliwia wyłączenie możliwości pobierania faktur proform (dokumentów sprzedaży) dla klientów. Przy włączonej opcji klienci będą mogli pobrać proformę, przy wyłączonej nie będą mieli takiej możliwości.<br />\r\n<br />\r\nWg parametrów podanych w formularzu na obrazku obok numer faktury będzie wyglądał w sposób następujący: <strong>FV/0100/2013</strong></div>\r\n"),
("167","22","1","instrukcja","Ustawienia SSL","<div style=\"text-align:justify;\"><img alt=\"alt\" height=\"257\" src=\"obrazki/pomoc/konfiguracja_https.jpg\" style=\"margin-bottom:15px;float:left;margin-right:15px;\" width=\"299\" />Prowadząc sklep, konieczne jest uzyskiwanie od klientów ich danych, np. w przypadku subskrypcji newslettera lub składania zamówienia. W ochronie informacji klientów pomaga technologia zwana &bdquo;protokołem SSL&rdquo; (Secure Sockets Layer), która szyfruje dane przesyłane między przeglądarką a serwerem sieciowym. Adresy internetowe zabezpieczone przy użyciu protokołu SSL zaczynają się od liter <span class=\"courier\">https:</span>, a nie <span class=\"courier\">http:</span>, dlatego protokół SSL jest też określany jako &bdquo;HTTPS&rdquo;. Gdy połączenie SSL jest aktywne, większość przeglądarek wyświetla ikonę kłódki.<br />\r\n<br />\r\nUżywanie protokołu SSL zapewnia większą prywatność i bezpieczeństwo niż nieszyfrowane połączenie sieciowe. Ogranicza ryzyko przechwycenia informacji i wykorzystania ich do niewłaściwych celów przez osoby trzecie. Wielu internautów czuje się bardziej komfortowo, kiedy udostępniają dane dotyczące płatności lub inne dane osobiste, korzystając z połączenia SSL<br />\r\n<br />\r\nAby bezpośrednio sprawdzić, czy połączenie jest zabezpieczone protokołem SSL, należy wpisać adres w przeglądarce i dodać na początku <span class=\"courier\">https://</span>, np. <span class=\"courier\">https://www.adres.sklepu.pl</span>. Jeśli zobaczysz ikonę kłódki w przeglądarce, kliknij ją, aby wyświetlić dodatkowe informacje i upewnić się, że połączenie jest bezpieczne. Jeśli nie widzisz kłódki, oznacza to, że strona nie jest zabezpieczona przy użyciu protokołu SSL.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nProgram może funkcjonować korzystając z połączeń szyfrowanych za pośrednictwem protokołu SSL. W menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia SSL</strong> - można włączyć opcję szyfrowania danych. Można ustawić także czy szyfrowany ma być cały sklep czy tylko strony, gdzie przesyłane są dane wrażliwe.<br />\r\n<br />\r\nW przypadku ustawienia SSL tylko dla stron wrażliwych w połączeniu szyfrowanym są uruchamiane tylko strony, na których są przesyłane dane - takie jak rejestracja, logowanie, zamówienie, panel klienta itp. Nie ma potrzeby szyfrowania stron, na których są wyświetlane tylko i wyłącznie informacje o produktach.<br />\r\n<br />\r\nW przypadku ustawienia SSL dla całego sklepu szyfrowane są wszystkie strony sklepu - w tym także cały panel zarządzania sklepu.<br />\r\n<br />\r\nŻeby sklep poprawnie funkcjonował z protokołem SSL musi być <strong>wykupiony certyfikat dla domeny</strong>, na której jest zainstalowany sklep - w przeciwnym wypadku przeglądarka będzie zgłaszała błąd o niewłaściwym podpisie lub w ogóle uniemożliwi wyświetlenie strony.<br />\r\n<br />\r\nPonadto podczas korzystania z szyfrowania stron należy zwrócić szczególną uwagę, aby sklep nie zawierał żadnych grafik i innych elementów wyświetlanych z zewnętrznych serwerów, które nie mają połączenia szyfrowanego - dotyczy to w szczególności bannerów reklamowych, różnego rodzaju widgetów, itp. W takiej sytuacji przeglądarka może wyświetlać ostrzeżenia, ze nie wszystkie elementy danej strony są bezpieczne.</div>\r\n"),
("168","705","0","instrukcja","Terminy wysyłek","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/termin_wysylki_karta_produktu.jpg\" style=\"width:250px;height:80px;margin-right:15px;margin-bottom:15px;float:left;\" />Terminy wysyłek są to informacje tekstowe, które mają charakter informacyjny. W sklepie można zdefiniować w słowniku wysyłek dostępne czasy wysyłek i podczas dodawania czy edycji produktu (menu <strong>Asortyment / Produkty</strong>) przypisać do niego czas wysyłki danego produktu. Czas wysyłki do produktów można przypisać także w menu <strong>Asortyment / Magazyn produktów</strong>. Pole terminu wysyłki przy produkcie nie jest obowiązkowe i produkt nie musi mieć wypełnionego tego pola. Po stronie sklepu informacja o czasie dostawy jest wyświetlana na karcie produktu - po wejściu przez klienta w szczegóły produktu. Informacja o terminie wysyłek nie jest powiązana z magazynem sklepu ani z dostępnością produktu - jest to informacja stała.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/termin_wysylki_podsumowanie_zamowienia.jpg\" style=\"width:420px;height:82px;margin-left:15px;margin-bottom:15px;float:right;\" />Informacja o czasie wysyłki jest także wyświetlana w potwierdzeniu zamówienia - w ostatnim kroku realizacji zamówienia - ma ona charakter informacyjny i ma informować klienta w jakim czasie zostanie do niego dostarczony zamówiony towar. Dodatkowo jeżeli wszystkie produkty dodane przez klienta do zamówienia mają uzupełniony czas wysyłki - sklep określi maksymalny czas wysyłki dla wszystkich produktów i poniżej listy produktów wyświetli dodatkową informację o szacowanym czasie wysyłki całego zamówienia. Dla przykładu jeżeli do koszyka są dodane 2 produkty, jeden ma czas wysyłki 2 dni, drugi 5 dni to sklep wyświetli informację: <em>Szacowany czas wysyłki zamówienia to 5 dni.</em> Treść wyświetlanej informacji można zmienić w menu <strong>Konfiguracja / Tłumaczenia</strong> - do wyświetlanego tekstu można dodać informację, że czas wysyłki będzie liczony od dokonania płatności przez klienta.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/termin_wysylki_lista.jpg\" style=\"width:500px;height:114px;margin-left:15px;margin-bottom:15px;float:right;\" />Obsługa terminów wysyłek w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Słowniki / Terminy wysyłek</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu czasów wysyłek. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji</strong>. Sklep standardowo ma zdefiniowane najczęściej stosowane czasy dostawy.<br />\r\n<br />\r\nW liście każdy termin wysyłki jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest nazwa terminu wysyłki. Kolejna kolumna określa ilość dni w jakim czasie zostanie wysłany towar.&nbsp; W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję oraz usunięcie terminu wysyłek.<br />\r\n<br />\r\nNowy termin wysyłki dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji. Przy dodawaniu nowego terminu wysyłki należy wpisać w poszczególnych polach: nazwę terminu wysyłki oraz ilość dni.&nbsp; Nazwę trzeba wpisać we wszystkich dostępnych wersjach językowych. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa w innych wersjach językowych - zostanie w to pole wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\nEdycja istniejącego terminu wysyłki jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.</div>\r\n"),
("169","706","0","instrukcja","Dostępności produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dostepnosci_produktow_karta_produktu.jpg\" style=\"width:240px;height:78px;margin-bottom:15px;margin-right:15px;float:left;\" />Dostępności produktów to informacja tekstowa lub graficzna informująca klienta czy dany produkt jest aktualnie dostępny w sklepie - ewentualnie w jakim czasie będzie dostępny. W sklepie można zdefiniować dostępności produktów, które podczas dodawania czy edycji produktu można przypisać do danego produktu. Dostępności produktów można przypisać także w menu <strong>Asortyment / Magazyn produktów</strong>. Pole dostępności produktu przy produkcie nie jest obowiązkowe i produkt nie musi mieć wypełnionego tego pola. Po stronie sklepu informacja o dostępności produktu jest wyświetlana na karcie produktu - po wejściu przez klienta w szczegóły produktu. Informacja o dostępności produktu może być powiązana z magazynem sklepu i zmieniać się zależnie od aktualnego stanu magazynowego produktu (w tym również poszczególnych wariantów / cech produktu - cechom produktu można przypisywać indywidualne dostępności oraz jeżeli jest włączone połączenie stanu magazynowego z cechami to przy wyborze różnych cech produktu przez klienta może się zmieniać dostępność produktu).<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/dostepnosci_produktow.jpg\" style=\"width: 550px; height: 181px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Obsługa dostępności produktów w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Słowniki / Dostępności produktów</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu dostępności. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji</strong>. Sklep standardowo ma zdefiniowane najczęściej stosowane dostępności produktów.<br />\r\n<br />\r\nW liście każda dostępność jest wyświetlana w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest nazwa dostępności produktu. Następna kolumna wyświetla tryb działania dostępności. Są dwa rodzaje dostępności produktu. Dostępność <strong>ręczna</strong> - oznacza, że przypisana do produktu będzie stała - niezależna od stanu magazynowego produktu. Druga to dostępność <span style=\"color:#ff0000;\"><strong>automatyczna</strong></span> - przypisanie do produktu dostępności automatycznej powoduje, że na karcie produktu jest wyświetlana dostępność zależna od stanu magazynowego produktu. Opcje te działają jeżeli w sklepie jest włączona kontrola stanów magazynowych (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia magazynu</strong>). Następna kolumna jest powiązana z dostępnościami automatycznymi - określa od jakiej ilości produktów dana dostępność jest widoczna.<br />\r\n<br />\r\nPrzykład użycia dostępności <span style=\"color:#ff0000;\"><strong>automatycznych</strong></span>:<br />\r\nW sklepie dodane są trzy dostępności automatyczne:</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><em>niedostępny</em> - od ilości 0</li>\r\n	<li style=\"text-align:justify;\"><em>zapytaj o dostępność</em> - od ilości 1</li>\r\n	<li style=\"text-align:justify;\"><em>dostępny</em> - od ilości 5</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Produkt ma stan magazynowy 8 szt. Przy takim stanie magazynowym na karcie produktu wyświetli się, że produkt jest <em>dostępny</em>. Jeżeli zostanie zakupione 5 szt produktu to stan magazynowy zmniejszy się do 3 szt. Przy takim stanie dostępność produktu zmieni się na <em>zapytaj o dostępność</em>. Gdy zostaną zakupione kolejne 3 szt i stan magazynowy zmniejszy się do 0 - to dostępność zmieni się na <em>niedostępny</em>.</div>\r\n\r\n<div style=\"text-align:justify;\"><br />\r\nKolejna kolumna listingu to informacja czy można kupować produkt przy danej dostępności. Zielona ikonka oznacza, że przy danej dostępności klienci mogą kupować produkty. Na podstawie powyższego przykładu można przypisać do statusu <em>niedostępny</em> - brak możliwości kupowania - i jeżeli produkt przyjmie dostępność <em>niedostępny</em> to nie będzie można zakupić produktu. Następna kolumna to obrazek - dostępności w sklepie oprócz formy tekstowej mogą być także obrazkowe. Czyli zamiast tekstu na karcie produktu wyświetli się obrazek informujący o dostępności produktu. Kolejne cztery kolumny to nr id dla porównywarek cen. Są one używane do generowania oferty w formacie XML dla porównywarek cen. Pod tabelą z listingiem znajduje się legenda z opisami poszczególnych id dla poszczególnych porównywarek. Przy dodawaniu czy edycji dostępności trzeba wybrać jakim dostępnościom w porównywarkach odpowiada dostępność ze sklepu. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję oraz usunięcie dostępności.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/dostepnosci_produktow_dodawanie.jpg\" style=\"width: 400px; height: 294px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Nową dostępność dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji.<br />\r\n<br />\r\nPrzy dodawaniu nowej dostępności należy wpisać jej nazwę. Jest to pole obowiązkowe do wypełnienia. Nazwę trzeba wpisać we wszystkich dostępnych wersjach językowych. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa dostępności w innych wersjach językowych - zostanie w to pole wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\nKolejne pola to wybór trybu wyświetlania, dostępne opcje to tryb automatyczny lub ręczny (szczegółowo opisane powyżej).<br />\r\n<br />\r\nNastępne pole - od jakiej ilości produktów dostępność jest widoczna - jest powiązane z dostępnością automatyczną i znika jeżeli zostanie wybrana dostępność ręczna. W pole to należy wpisać ilość produktów od jakiej będzie widoczna dostępność - przykłady opisane powyżej.<br />\r\n<br />\r\nKolejne pole wyboru to pytanie czy można przy danej dostępności kupić produkt. Jeżeli zostanie wybrana opcja - nie - to jeżeli produkt będzie miał daną dostępność - nie będzie go można zakupić (nie będzie opcji koszyka)<br />\r\n<br />\r\nNastępne pole to ścieżka zdjęcia - umożliwia ono przypisanie do danej dostępności obrazka zamiast tekstu. 2-krotne kliknięcie w to pole spowoduje otworzenie się przeglądarki zdjęć z możliwością wybrania zdjęcia lub wgrania nowego z komputera klienta. Jeżeli pole pozostanie puste to dostępność będzie wyświetlana w formie tekstowej.<br />\r\n<br />\r\nOstatnie pola wyboru to dopasowanie danej dostępności do dostępności stosowanych w porównywarkach cen. Jest to istotne - ponieważ przy złym dopasowaniu dostępności, jeżeli zostanie wysłany do porównywarki cen plik&nbsp; XML ze złymi dostępnościami - w porównywarkach będą zafałszowane dane, które mogą wpłynąć na sprzedaż w sklepie.<br />\r\n<br />\r\nEdycja istniejącej dostępności jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu. Podczas edycji nie można zmienić trybu dostępności.<br />\r\n<br />\r\n<span style=\"color:#FF0000;\"><strong>WAŻNE</strong> Dostępności produktów mają pierwszeństwo przed stanem magazynowym produktów. Jeżeli produkt ma przypisaną dostępność, która ma <strong>wyłączone kupowanie</strong> - to pomimo tego, że jego stan magazynowy pozwala na zakup produktu - produktu <strong>nie będzie można kupić</strong> (dodać do koszyka). Również w przypadku jeżeli jest włączona możliwość kupowanie pomimo braku w magazynie lub jest wyłączona kontrola stanu magazynowego - w przypadku w/w opisanej dostępności - produktu nie będzie można zakupić.</span></div>\r\n"),
("170","23","1","instrukcja","Ustawienia listingów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_listing.jpg\" style=\"float: right; width: 450px; height: 843px; margin-left: 15px;\" />Program oferuje wiele różnych możliwości zdefiniowania listingu produktów. Po wybraniu określonej kategorii produkty mogą być wyświetlane w formie okien, wierszy ze zdjęciami lub formie listy - nie są wyświetlane wówczas zdjęcia produktów. Po wybraniu w menu pozycji <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia listingu produktów, kategorii, producentów</strong> wyświetlany jest formularz pozwalający na zdefiniowanie wielu domyślnych ustawień dotyczących wyświetlania listingu produktów.<br />\r\n<br />\r\n<strong>Ilość produktów w kategorii</strong> - opcja to umożliwia wyświetlenie liczby podającej ilość produktów znajdujących się w poszczególnych kategoriach. Opcja ta działa zarówno w boxie wyświetlającym kategorie jak i w listingu. Po wejściu w wybraną kategorię produktów wyświetlana jest liczba produktów jakie znajdują się w każdej podkategorii należącej do wybranej kategorii.<br />\r\n<br />\r\n<strong><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_listing_paginacja.jpg\" style=\"width:190px;float:left;margin-right:15px;margin-bottom:15px;height:49px;\" />Ilość produktów wyświetlanych na listingach</strong> - określa ile produktów ma być wyświetlonych jednorazowo na stronie. Jeżeli w wybranej kategorii jest więcej produktów niż zostało to zadeklarowane w konfiguracji - wówczas listing jest stronicowany i klient może się dowolnie przemieszczać pomiędzy kolejnymi podstronami danej kategorii.<br />\r\n<br />\r\nUstawienia dotyczące filtrów umożliwiają określenie jakie filtry znajdą się na listingu produktów. Wybór poszczególnych filtrów umożliwia klientowi zawężanie wyników i ilości wyświetlonych produktów w wybranej kategorii. Jako filtry w listingu produktów mogą być stosowane m.in. cechy produktów oraz zdefiniowane dodatkowe pola do produktów (w menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do produktów</strong>).<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_listing_filtry.jpg\" style=\"float:left;width:542px;height:226px;margin-right:15px;margin-top:15px;\" /> Ilość wyświetlanych na listingu filtrów zależy od ustawień w konfiguracji oraz od ilości zdefiniowanych cech produktów oraz dodatkowych pól. Filtry mogą być wyświetlane w boxie (jeżeli zostanie włączony w menu <strong>Wygląd / Ustawienia wyglądu</strong>) lub nad listingiem produktów.<br />\r\n<br />\r\n<strong>Ilość kolumn</strong> - ten parametr definiuje w ilu kolumnach mają się wyświetlać produkty po przełączeniu w widok w postaci kolumn. Dla zachowania estetyki wyglądu należy zwrócić uwagę na to, żeby ilość produktów wyświetlanych na jednej stronie była wielokrotnością liczby kolumn - wówczas nie będą pozostawały na listingu puste miejsca.<br />\r\n<br />\r\nKolejny parametr określa czy na listingu produktów ma być dostępna opcja <strong>Porównywania - </strong><span style=\"color:#ff0000;\">UWAGA: standardowo opcja porównywania jest dostępna tylko na listingu w formie wierszy i w formie listy</span>.<br />\r\n<br />\r\nNastępna opcja w formularzu to <strong>Domyślny sposób wyświetlania produktów</strong> - po wybrani udanej kategorii produkty są wyświetlane domyślnie według tego parametru. Dostępne są opcje: wiersz, kolumny, lista.<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_listing_format.jpg\" style=\"width:230px;height:74px;float:left;margin-right:15px;margin-top:15px;\" /><br />\r\nKlient po wybraniu listingu może samodzielnie zmienić format wyświetlania produktów i jest to przez program zapamiętywane do czas, aż klient sam nie zmieni sposobu wyświetlania lub nie zamknie okna przeglądarki.</div>\r\n"),
("171","707","0","instrukcja","Statusy systemu punktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/system_punktow_statusy.jpg\" style=\"width: 549px; height: 169px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Podczas zarządzania systemem punktów jedną z opcji jest zmiana statusu punktów klienta.&nbsp; Zmiany statusu punktów klienta można dokonać podczas edycji zamówienia lub podczas edycji konta klienta. W menu <strong>Konfiguracja / Słowniki / Statusy systemu punktów</strong> - administrator sklepu może zarządzać statusami punktów - definiować jakie statusy będzie można stosować podczas obsługi punktów klientów.<br />\r\n<br />\r\nStandardowo w sklepie są zdefiniowane najczęściej stosowane statusy systemu punktów. Po dokonaniu przez klienta zakupów w sklepie - punkty, które klient otrzymuje za zakupy standardowo otrzymują status: <strong>oczekujące</strong>. Jeżeli punkty zostały wykorzystane przy zakupach klienta - otrzymają status: <strong>wykorzystane</strong>. Punkty ze statusem - oczekiwane - administrator sklepu może zmienić status na <strong>zatwierdzone</strong> - wtedy klient będzie mógł wykorzystać punkty przy zakupach. Te trzy statusy są głównymi statusami, którymi obsługuje się system punktów. Administrator sklepu może dodać własne - nowe statusy - będą one pełniły rolę stanów pośrednich pomiędzy zdefiniowanymi statusami. Listing statusów wyświetla wszystkie dostępne statusy. Pierwsza kolumna listingu wyświetla id danego statusu w bazie, druga kolumna to nazwa statusu. W kolejnej kolumnie wyświetlany jest kolor - w poszczególnych statusach można definiować kolory w jakich będą się wyświetlać (tylko w panelu zarządzania). Kolejna kolumna wyświetla informację, który status jest dostępny dla nowych punktów, a który dla wykorzystanych na zakupy. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję statusu lub jego usunięcie. Ze sklepu nie można usunąć czterech podstawowych statusów. Można jednak zmienić ich nazwy.<br />\r\n<br />\r\nDodawanie i edycja statusu to prosty formularz, który wyświetla pola do wypełnienia. Pierwsze pole to nazwa statusu (nazwa jaka będzie widoczna dla klienta). Nazwę należy wprowadzić we wszystkich językach jakie są włączone w sklepie - przełączenie na inną wersję językową następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa statusu w innych wersjach językowych - zostanie w te pola wstawiona nazwa z domyślnego języka. Następnie należy wybrać typ statusu, kolor (po kliknięciu w pole koloru wyświetli się tablica kolorów).</div>\r\n"),
("172","708","0","instrukcja","Definicje etykiet adresowych","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/etykiety_adresowe_lista.jpg\" style=\"width:550px;height:163px;margin-left:15px;margin-bottom:15px;float:right;\" />Program posiada możliwość drukowania etykiet adresowych bezpośrednio na podstawie złożonych zamówień. Wydruk może się odbywać na gotowych dostępnych w handlu arkuszach zawierających pocięte naklejki adresowe. W programie zostało zdefiniowane kilkanaście standardowych formatów etykiet zgodnych z produktami firmy AVERY.<br />\r\n	<br />\r\n	W menu <strong>Konfiguracja / Słowniki / Definicje etykiet adresowych</strong> istnieje możliwość zmodyfikowania dostępnych formatów lub dodania swoich własnych w przypadku, gdy użytkownik posiada naklejki w innym formacie niż zostały zdefiniowane domyślnie.<br />\r\n	<br />\r\n	<img alt=\"alt\" height=\"467\" src=\"obrazki/pomoc/slowniki_etykiety_adresowe.jpg\" style=\"float:left;margin-right:15px;\" width=\"442\" />Po wybraniu opcji edycji lub dodania nowego formatu etykiet wyświetlony zostanie formularz, w którym należy wprowadzić parametry posiadanych arkuszy z gotowymi naklejkami.<br />\r\n	<br />\r\n	Pierwsze trzy pola formularza są polami informacyjnymi - i mają na celu tylko łatwiejsze zidentyfikowanie typu wybranego arkusza.<br />\r\n	<br />\r\n	Pozostałe pola należy wypełnić dokładnymi parametrami posiadanych etykiet, takimi jak marginesy, odstępy pomiędzy poszczególnymi naklejkami, ilość kolumn i ilość wierszy w jakich są pocięte naklejki.<br />\r\n	<br />\r\n	Jeżeli naklejki są standardowe, wówczas można spróbować poszukać informacji o nich na stronie producenta. Jeżeli nie to należy pomierzyć wszystkie parametry linijką na posiadanym arkuszu i wpisać odpowiednie dane w formularzu.<br />\r\n	<br />\r\n	Dodatkowym parametrem jest możliwość drukowania ramek wokół każdej etykiety. Można tę opcje wykorzystać np. jeżeli posiadamy tylko całe arkusze papieru bez zaznaczonych naklejek (wystarczy wówczas zwykła kartka papieru),  na których można wydrukować etykiety a następnie je pociąć i nakleić na przesyłki.</div>\r\n"),
("173","24","1","instrukcja","Ustawienia produktów / podstron sklepu","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_karta_produktu.jpg\" style=\"float: right; width: 400px; height: 316px; margin-left: 15px;\" />W menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia produktów</strong> użytkownik ma możliwość zdefiniowania wyświetlania elementów produktów oraz informacji na karcie produktu. Po wybraniu tej opcji menu wyświetlany jest formularz, który umożliwia konfigurację niektórych elementów, które są wyświetlane po wybraniu konkretnego, znalezionego produktu w sklepie.<br />\r\n<br />\r\n<strong>Czy ma być aktywna opcja schowka</strong> - w zależności od ustawienia tego parametru klient będzie mógł dodać produkty do schowka lub nie. Schowek zawiera produkty, które klient chce zapamiętać i wrócić do ich oglądania później. Jeżeli klient jest zalogowany, to zawartość schowka jest pamiętana po każdym jego ponownym zalogowaniu.<br />\r\n<br />\r\n<strong>Czy ma być aktywna opcja kupowania</strong> -&nbsp; wyłączenie tej opcji przełącza sklep w tryb katalogu produktów. Klienci mogą wszystkie produkty przeglądać - nie ma jednak możliwości dodania ich do koszyka i kupowania.<br />\r\n<br />\r\n<strong>Mechanizm nowości</strong> - określa wg jakich zasad mają być wyświetlane w sklepie nowości. Możliwe jest ręczne wybieranie produktów, które będą wyświetlane w sklepie jako nowości lub sklep może automatycznie wyświetlać produkty jako nowości wg daty dodania produktu.<br />\r\n<br />\r\nPozostałe ustawienia formularza dotyczą zawartości karty produktu. Umożliwiają ustawienie wyświetlania produktów podobnych, pozostałych produktów z wybranej kategorii. Umożliwiają także wyłączenie lub włączenie niektórych elementów na karcie produktu.<br />\r\n<br />\r\nW menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia podstron sklepu</strong> użytkownik ma możliwość zdefiniowania wyświetlania elementów na innych podstronach sklepu. Po wybraniu tej opcji menu wyświetlany jest formularz, który umożliwia konfigurację niektórych elementów, które są dostępne na poszczególnych podstronach sklepu, np w koszyku.</div>\r\n"),
("174","709","0","instrukcja","Jednostki miary","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/jednostki_miary_sklep.jpg\" style=\"width:140px;height:169px;margin-bottom:15px;margin-right:15px;float:left;\" />Jednostki miary są to informacje tekstowe, które określają w jakiej jednostce miary jest sprzedawany dany produkt. W sklepie można zdefiniować w słowniku dostępne jednostki i podczas dodawania czy edycji produktu przypisać do niego określoną jednostkę miary. Pole jednostki miary jest obowiązkowe i podczas edycji czy dodawania produktu trzeba wybrać określoną jednostkę miary z listy dostępnych. Jednostki miary w sklepie oprócz typowo informacyjnej funkcji umożliwiają także podział produktów na kupowane w ilościach całkowitych lub ułamkowych. Przy wybranych jednostkach miary można zaznaczyć opcję zakupu ułamkowego co oznacza, że produkty z tą jednostką miary będzie można zakupić w ułamkach - tzn np 1,5. Jednostki miary w sklepie standardowo są wyświetlane przy polu ilości obok ikony dodania do koszyka oraz w informacjach na karcie produktu - po wejściu przez klienta w szczegóły produktu.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/jednostki_miary.jpg\" style=\"width:520px;height:140px;margin-left:15px;margin-bottom:15px;float:right;\" />Obsługa jednostek miar w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Słowniki / Jednostki miary</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu jednostek. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji</strong>. Sklep standardowo ma zdefiniowane najczęściej stosowane jednostki miary.<br />\r\n<br />\r\nW liście każda jednostka miary jest wyświetlana w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest nazwa jednostki miary. Kolejna kolumna wyświetla typ pola ilości - czy przy danej jednostce miary można zakupić produkt w ilości ułamkowej czy całkowitej. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję oraz usunięcie jednostek miar. Opcja usuwania jest nieaktywna w przypadku jednostki miary ze statusem domyślny. Aby usunąć jednostkę miary ustawioną jako domyślna trzeba najpierw ustawić inną pozycję jako domyślną - po tym będzie można usunąć daną jednostkę miary.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/jednostki_miary_dodawanie.jpg\" style=\"width: 350px; height: 196px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Nową jednostkę miary dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji. Przy dodawaniu nowej jednostki miary należy wpisać w poszczególnych polach: nazwę jednostki miary, wybrać czy format ilości produktu ma być liczbą całkowitą czy może być ułamkowy oraz trzeba wybrać czy jednostka ma być domyślną.&nbsp; Nazwę jednostki trzeba wpisać we wszystkich dostępnych wersjach językowych. Zmiana formularza dla poszczególnych języków następuje poprzez kliknięcie na zakładkę z nazwą języka. Jeżeli nie zostanie uzupełniona nazwa w innych wersjach językowych - zostanie w to pole wstawiona nazwa z domyślnego języka.<br />\r\n<br />\r\nEdycja istniejącej jednostki miary jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.</div>\r\n"),
("175","710","0","instrukcja","Szablony e-maili","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/slowniki_szablony_maili.jpg\" style=\"float:right;width:612px;height:90px;margin-left:15px;margin-bottom:15px;\" />W programie można zdefiniować dowolne własne szablony wiadomości e-mail. Po wybraniu w menu opcji <strong>Konfiguracja / Słowniki / Szablony e-maili</strong> wyświetlona zostaje lista zdefiniowanych szablonów wiadomości.<br />\r\n<br />\r\nSzablony e-maili pozwalają na stworzenie własnego szablonu układu wiadomości wysyłanych ze sklepu. W definiowanym szablonie można umieścić dowolne treści takie jak grafiki czy elementy HTML. Szablony maili mogą być definiowane we wszystkich działających w sklepie wersjach językowych - dla każdej mogą one mieć inny układ i wygląd. Dodatkowo w definiowaniu szablonu wiadomości e-mail można stosować wiele innych znaczników. Znaczniki to ciągi znaków, które podczas wysyłania maila są zamieniane na odpowiednie wartości (inne teksty). Dla przykładu jeżeli w treści tekstu wpiszemy znacznik {ADRES_URL_SKLEPU} to podczas wysyłania maila zostanie ten ciąg znaków zamieniony na adres internetowy naszego sklepu - lista tych znaczników wraz z ich opisami jest wyświetlana na stronie dodawania/edycji szablonu.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/slowniki_szablony_maili_edycja.jpg\" style=\"float:left;width:607px;height:422px;margin-right:15px;\" />Po wybraniu opcji dodania/edycji szablonu wiadomości e-mail wyświetlony zostanie edytor umożliwiający wizualne tworzenie szablonu.<br />\r\n<br />\r\nW szablonie można umieszczać grafiki, stałe teksty oraz znaczniki, pod które będą podstawiane zdefiniowane wartości.<br />\r\n<br />\r\nMożna również przygotować szablon w dowolnym zewnętrznym edytorze, a następnie jego źródło wkleić w edytorze szablonów w sklepie po przełączeniu go w tryb wyświetlania <em>źródła dokumentu</em>.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\">UWAGA: Jedynym wymaganym w szablonie elementem jest znacznik <strong>{CONTENT}</strong> - w jego miejsce program będzie podstawiał treść wiadomości zależną od kontekstu wysyłanego maila - same treści wiadomości są definiowane w osobnym menu.</span></div>\r\n"),
("176","711","0","instrukcja","Treści wiadomości e-mail","<div style=\"text-align:justify;\">Program wyposażony jest w możliwość samodzielnego definiowania niektórych treści przesyłanych w wiadomościach e-mail generowanych przez sklep. W menu <strong>Konfiguracja / Słowniki / Treści wiadomości e-mail</strong> dostępna jest możliwość edycji wstępnie zdefiniowanych treści. Treść zdefiniowanej wiadomości może składać się ze stałych tekstów oraz znaczników. Znaczniki to ciągi znaków, które podczas wysyłania wiadomości są zamieniane na odpowiednie wartości (inne teksty). Dla przykładu jeżeli w treści tekstu wpiszemy znacznik {ADRES_URL_SKLEPU} to podczas wysyłania maila zostanie ten ciąg znaków zamieniony na adres internetowy naszego sklepu.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"174\" src=\"obrazki/pomoc/slowniki_tresci_maili.jpg\" style=\"margin-left:15px;margin-bottom:15px;float:right;\" width=\"628\" />Po wybraniu menu na stronie zostanie wyświetlona lista zdefiniowanych w programie treści wiadomości e-mail. W kolumnach wyświetlona jest nazwa opisowa danego szablonu, do jakiego typu szablonów on należy oraz ikona umożliwiająca edycję danego szablonu.<br />\r\n<br />\r\nZdefiniowane w tej opcji treści szablonów wiadomości są w trakcie wysyłania wstawiane w miejsce znacznika <strong>{CONTENT}</strong> do zdefiniowanych wcześniej szablonów e-maili. Dla każdego maila wysyłanego przez sklep jest zdefiniowany osobny szablon treści wiadomości.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/slowniki_tresci_maili_edycja.jpg\" style=\"float: left; width: 595px; height: 488px; margin-right: 15px;\" />Po kliknięciu ikony edycji treści wiadomości wyświetlony zostanie formularz, w którym znajduje się edytor umożliwiający na wizualne definiowanie treści oraz pola formularza ustalające dodatkowe parametry wysyłanej wiadomości.<br />\r\n<br />\r\nTreści wiadomości mogą być zdefiniowane różnie dla każdego języka osobno w programie - wystarczy przełączyć zakładkę w edytorze, aby modyfikować treść w wybranym języku.<br />\r\n<br />\r\nWszystkie znaczniki, które mogą być użyte w danym szablonie są opisane w dolnej części strony zawierającej formularz edycji szablonu - są one różne dla poszczególnych wiadomości.<br />\r\n<br />\r\nPodczas edycji treści wiadomości można zdefiniować również informację czy dany mail ma być przesłany do wiadomości innej osoby. Można to wykorzystać np. w wiadomościach o nowym zamówieniu wpisując adres e-mail sklepu w polu <strong>Prześlij do wiadomości</strong> - wówczas wiadomość o złożeniu nowego zamówienia zostanie przesłana również na adres mailowy sklepu. Podobnie można zrobić w przypadku rejestracji nowego klienta.<br />\r\n<br />\r\nKolejnym parametrem jaki można ustawić jest szablon maila, który zostanie wykorzystany przy wysyłaniu wiadomości. Szablony e-maili definiuje się w menu <strong>Konfiguracja / Słowniki / Szablony e-maili</strong>. Różne treści maili mogą być wysyłane przy użyciu różnych szablonów - bardziej lub mniej złożonych.<br />\r\n<br />\r\nOstatnim parametrem jest możliwość dodania do maila załącznika. Po kliknięciu w przycisk <span class=\"dodaj\" style=\"cursor:pointer\"><strong>dodaj plik do dołączenia do maila</strong> zostanie wyświetlone dodatkowe pole.</span> Po dwukrotnym kliknięciu w pole zostanie wyświetlona przeglądarka plików i w oknie przeglądarki będzie można wybrać plik jaki ma być dołączany do danego maila. Do każdego maila wysyłanego ze sklepu można dodać kilka załączników. Opcja ta może być szczególnie przydatna dla maila o nowym zamówieniu. Jako plik może zostać dodany plik w formacie PDF np z regulaminem sklepu czy formularzem zwrotu towaru - w zależności od tego czego wymagają przepisy prawne.</div>\r\n"),
("177","752","0","instrukcja","Dodatkowe pola do produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/dodatkowe_pola_opis.jpg\" style=\"width:240px;height:117px;margin-left:15px;margin-bottom:15px;float:right;\" />Dodatkowe pola do produktów spełniają ważną funkcję informacyjną przy produktach - uzupełniając opis produktu. Czym są dodatkowe pola opisowe ? Są to wartości które są definiowane i wspólne dla niektórych produktów. Dokładny opis funkcjonowania dodatkowych pól opisowych produktów znajduje się w instrukcji dotyczącej dodawania / edycji produktu - Asortyment / Produkty / Zakładka Dodatkowe pola opisowe. Są tam podane przykłady stosowania oraz zasada działania pól opisowych.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/dodatkowe_pola.jpg\" style=\"width: 450px; height: 125px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Obsługa dodatkowych pól produktów w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do produktów</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu dodatkowych pól. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji </strong>oraz opcja <strong>sortowania</strong>, która umożliwia ustawienie żądanej kolejności wyświetlania dodatkowych pól w listingu. Powyżej opcji sortowania znajduje się pole wyszukiwania. Umożliwia ono wyszukanie wybranego pola..<br />\r\n<br />\r\nW liście każde dodatkowe pole jest wyświetlane w osobnym wierszu. Pierwsza kolumna wyświetla nr id pozycji w bazie sklepu. W kolejnej kolumnie wyświetlana jest nazwa dodatkowego pola (nazwa jest wyświetlana w sklepie i jest widoczna dla klientów). Następna kolumna to przypisanie do języka. Określa ona w jakim języku dane pole będzie widoczne. Pola mogą być przypisane do poszczególnych wersji językowych sklepu lub mogą być wspólne dla wszystkich języków. Kolejna kolumna wyświetla informację czy dane pole dodatkowe jest wyświetlane w formie obrazka czy tekstu. Jeżeli pole jest wyświetlane w formie obrazka to wyświetlana jest ikonka obrazka - jeżeli w formie tekstu wyświetlany jest znak &quot;minus&quot;. Kolejna kolumna wyświetla pole do wpisania numeru sortowania - wpisując odpowiednie wartości można ustawić kolejność wyświetlania pol opisowych na karcie produktu. Po wpisaniu nowych wartości zatwierdzenie następuje poprzez naciśnięcie przycisku <strong>Zapisz zmiany</strong> na dole strony. Następna kolumna wyświetla informację czy dane pole opisowe jest używane przy filtrach produktów w listingach. Zielona ikonka oznacza, że przy dane pole jest używane do generowania filtrów. Następnie wyświetlana jest informacja czy dane pole ma być uwzględniane jako parametry wyszukiwania w wyszukiwaniu zaawansowanym w sklepie. Włączenie tej opcji umożliwia zaznaczenie wybranego pola w warunkach wyszukiwania. W kolejnej kolumnie wyświetlana jest informacja czy dane pole ma być wykorzystywane przy porównywaniu danych w porównywarce produktów. Jeżeli ta opcja jest aktywna - w przypadku porównywania produktów - pole jest wyświetlane jako osobny wiersz dla każdego produktu - dzięki czemu w łatwy sposób użytkownik może porównać wybrane parametry produktów. Kolejna kolumna wyświetla położenie danego pola na karcie produktu, standardowo są to dwie możliwości: obok zdjęcia głównego produktu lub pod opisem produktu. Następna kolumna wyświetla informację czy dane pole ma być wyświetlane na karcie produktu. Nie wszystkie dodatkowe pola muszą być widoczne w produktach. Wyłączenie widoczności danego pola powoduje, że nie będzie ono wyświetlane na karcie produktu. Wyłączenie widoczności może być połączone z użyciem danego pola w filtrach listingów. Dzięki temu klienci będą mogli wyszukiwać (filtrować) produkty również w oparciu o dane pole opisowe - ale sama treść pola nie będzie widoczna po wejściu w produkt - taka opcja umożliwia tworzenie dowolnych filtrów produktów. Kolejna kolumna wyświetla informację czy dane pole jest używane w aukcjach Allegro. Przy wystawianiu aukcji Allegro z poziomu panelu zarządzania sklepu wraz z opisem produktu mogą być przekazywane do allegro także dodatkowe pola produktu. Jednak do aukcji nie muszą być przekazywane wszystkie dodatkowe pola jakie posiada dany produkt. Czy dane pole jest przekazywane do Allegro jest sygnalizowane przez ikonkę. Zielony kolor ikonki oznacza, że dane pole jest przekazywane do Allegro, szary - że pole nie będzie przekazywane do Allegro przy wystawianiu produktu na portalu aukcyjnym Allegro. Przedostatnia kolumna wyświetla informację o statusie pola opisowego. Status jest sygnalizowany poprzez ikonkę. Jeżeli ikona ma kolor zielony, znaczy to, że pole jest wyświetlane w sklepie, jeżeli szary - pole jest niewidoczne. Zmianę aktywności (włączenie / wyłączenie) dokonuje się poprzez kliknięcie na ikonę aktywności. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one edycję oraz usunięcie dodatkowego pola opisowego.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/dodatkowe_pola_slownik.jpg\" style=\"width: 450px; height: 212px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Wśród ikon nawigacyjnych znajduje się także ikona <strong>słownika dodatkowych pól</strong> <img alt=\"alt\" src=\"obrazki/pomoc/standardowe_komentarze.jpg\" style=\"width:20px;height:22px;\" />. Po kliknięciu w ikonę otworzy się kolejna podstrona z listą zdefiniowanych pozycji słownika dla danego pola.<br />\r\n<br />\r\nW module słownika dodatkowych pol można wpisać wartości jakie będzie później można wybrać podczas edycji czy dodawania produktu w menu <strong>Asortyment / Produkty</strong> w zakładce <strong>Dodatkowe pola opisowe</strong>. Dzięki temu uzupełnianie treści dodatkowych pól jest znacznie szybsze i nie powoduje konieczności wprowadzania za każdym razem ręcznie tekstu w pole dodatkowego pola podczas dodawania czy edycji produktu.<br />\r\n<br />\r\nW module słownika dodatkowych pol wartości pola mogą mieć wartość tekstową lub być w formie obrazka - w zależności od tego jaką formę ma dodatkowe pole (czy jest tekstowe czy obrazkowe).<br />\r\n<br />\r\nObsługa dodatkowych pól produktów w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do produktów</strong>. Po wejściu w menu wyświetlana jest lista dodanych do sklepu dodatkowych pól. Powyżej okna z listingiem znajduje się przycisk <strong>dodawania nowej pozycji </strong>oraz o<br />\r\n<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/dodatkowe_pola_dodawanie.jpg\" style=\"width: 500px; height: 381px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Nowe dodatkowe pole opisowe dodaje się poprzez kliknięcie w przycisk <strong>dodaj nową pozycję</strong>. Po kliknięciu zostanie wyświetlona strona z formularzem do dodania nowej pozycji. Przy dodawaniu nowego pola należy wpisać w poszczególnych polach: nazwę pola, z listy rozwijanej trzeba wybrać w jakiej wersji językowej pole będzie dostępne, następnie należy wybrać czy pole ma być wyświetlane w formie obrazka czy tekstu. Jeżeli zostanie wybrana opcja wyświetlania w formie obrazka - znikną pola wyświetlania pola w filtrach, w wyszukiwaniu zaawansowanym oraz w porównywarce produktów. W filtrach oraz wyszukiwaniu mogą być wyświetlane wyłącznie pola tekstowe. Następnie można wybrać czy dane pole ma być wyświetlane na karcie produktu oraz czy ma być przekazywane do Allegro przy wystawianiu aukcji produktu. Poniżej znajduje się pole wyboru miejsca wyświetlania pola - możliwe opcje to: obok głównego zdjęcia produktu lub pod opisem. Są to standardowe możliwości - mogą one być inne w indywidualnych szablonach. Ostatnie pole to pole kolejności wyświetlania. Umożliwia ono ustawienie określonej kolejności wyświetlania dodatkowych pol na stronie sklepu.<br />\r\n<br />\r\nEdycja istniejącego pola opisowego jest identyczna jak dodawanie. Formularz edycji ma takie same pola jak przy dodawaniu.<br />\r\n<br />\r\n<strong>UWAGA</strong> Dodatkowe pola do produktów będą wyświetlane w filtrach listingu dopiero po włączeniu wyświetlania filtrów dodatkowych pól w menu <strong>Konfiguracja / Ustawienia listingu produktów, kategorii i producentów</strong>.</div>\r\n"),
("178","751","0","instrukcja","Dodatkowe pola do klientów","<div style=\"text-align:justify;\">Poza standardowymi polami w formularzu rejestracyjnym klientów w sklepie, program umożliwia definiowanie dodatkowych własnych pól, które klient będzie musiał wypełnić w formularzu rejestracyjnym. W menu <strong>Konfiguracja / Dodatkowe pola / Dodatkowe pola do klientów</strong> jest możliwość definiowania takich dodatkowych pól.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_dodatkowe_pol_klienci.jpg\" style=\"float:left;width:658px;height:153px;margin-right:15px;margin-bottom:15px;\" />Po wybraniu tej opcji w menu wyświetlana jest lista zdefiniowanych aktualnie dodatkowych pól dla klientów.<br />\r\n<br />\r\nNa liście pól kolejne kolumny zawierają informacje na temat zdefiniowanych pól takie jak nazwa pola, typ, kolejność wyświetlania na formularzu rejestracyjnym klienta, czy pole jest wymagane i czy jest w danej chwili aktywne. W ostatniej kolumnie znajdują się ikony nawigacyjne umożliwiające edycję lub usunięcie danego pola. <span style=\"color:#ff0000;\">UWAGA: usunięcie dodatkowego pola do klientów - powoduje, że z bazy są usuwane wszystkie dotychczas wpisane przez klientów informacje związane z tym polem</span>.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_dodatkowe_pola_klienci_edycja.jpg\" style=\"margin-left: 15px; margin-right: 15px; float: right; width: 490px; height: 206px;\" />Po wybraniu linku <strong>dodaj nową pozycję</strong> lub ikony edycji pola, wyświetlony zostanie formularz umożliwiający wprowadzenie informacji niezbędnych do wyświetlenia pola w formularzu rejestracyjnym.<br />\r\n<br />\r\nFormularz składa się z kilku pól, w których można określić format dodatkowego pola na formularzu rejestracyjnym.<br />\r\n<br />\r\n<strong>Nazwa pola</strong> - nazwa wyświetlana na formularzu, należy ją wprowadzić we wszystkich językach występujących w sklepie.<br />\r\n<br />\r\n<strong>Wartość pola</strong> - zależna jest od typu pola jaki będzie prezentowany klientowi. W przypadku pól typu input i textarea pole to nie będzie wyświetlane - klient będzie jego zawartość wypełniał podczas rejestracji. W przypadku pozostałych typów pól należy wprowadzić wartości, będące etykietami pola na formularzu. Każdą wartość należy wpisać w osobnej linii - tak jak to jest podane na przykładowym zdjęciu zamieszczonym obok. Po takim wprowadzeniu danych każdy kolejny wiersz będzie osobną opcją którą klient będzie mógł wybrać podczas rejestracji.<br />\r\n<br />\r\n<strong>Wymagane</strong> - ta opcja określa czy wypełnienie danego pola (dotyczy to pól tekstowych oraz wyboru) będzie wymagane w formularzu.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_dodatkowe_pola_klienci_przyklad.jpg\" style=\"width:273px;height:71px;margin-bottom:15px;margin-right:15px;float:left;\" />Dodatkowe pole zdefiniowane według parametrów tak jak na przykładowym obrazku powyżej będzie dla klienta w sklepie tak jak na screenie zamieszczonym obok.<br />\r\n<br />\r\nInformacje wprowadzone przez klienta widoczne są dla obsługi sklepu podczas edycji klienta w menu <strong>Sprzedaż / Klienci / Klienci</strong> w zakładce <strong>Podstawowe dane.</strong></div>\r\n"),
("179","26","1","instrukcja","Ustawienia cache i kompresji","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_cache.jpg\" style=\"width: 450px; height: 286px; float: right; margin-left: 15px; margin-bottom: 15px;\" />W menu <strong>Konfiguracja / Ustawienia sklepu / Ustawienia cache i kompresji</strong> można zdefiniować parametry cache sklepu oraz kompresji części danych. Cache jest to sposób zapamiętywania danych sklepu w formie plików bezpośrednio na serwerze (w miejscu gdzie jest zainstalowany sklep). Dzięki temu dane są odczytywane szybciej i sklep nie musi często łączyć się z bazą sklepu - częste łącznie się z bazą wpływa na szybkość działania sklepu. Każde łączenie z bazą, która znajduje się na serwerze nazywa się zapytaniem. Im więcej zapytań do bazy tym gorsze działanie sklepu. Dlatego zapisanie części zapytań do plików pozwala na zwiększenie szybkości działania sklepu. Wadą tego rozwiązania jest to, że dane odczytywane z cache są aktualne na chwilę zapisania do cache - dlatego co pewien czas dane w cache powinny być aktualizowane, np jeżeli w sklepie często są aktualizowane produkty. Sklep sam dba o aktualizację cache w przypadku np zmiany stanów magazynowych produktów, aktywności produktów czy kategorii. W opisywanym menu można włączyć czy ma być w sklepie używane cache oraz ustawić co ile minut mają być automatycznie odświeżane dane w cache. W poszczególnych pola podane są wartości w minutach co ile ma się odświeżać / aktualizować dane cache.<br />\r\n<br />\r\nDodatkowo oprócz cache zapytań do bazy można włączyć cache plików języka JavaScript. Sklep posiada wiele plików JavaScript, które są odpowiedzialne na poszczególne funkcje sklepu - zapisanie ich w formie cache - jako jednego pliku znacznie wpływa na szybkość działania sklepu. W przypadku cache plików JavaScript nie ustawia się ilości minut ponieważ dane nie wymagają aktualizacji. Modyfikacji mogą jedynie wymagać w przypadku modyfikacji plików JavaScript przed webmastera (np tworzenia modyfikacji sklepu) - wtedy należy usunąć ręcznie cache JavaScript z katalogu /cache/js<br />\r\n<br />\r\nDane cache są również automatycznie usuwane w przypadku operacji dodawania/edycji danych w panelu zarządzania - zarówno dane zapytań do bazy jak i plików JavaScript.<br />\r\n<br />\r\nDodatkowymi opcjami w menu jest możliwość włączenia kompresji kodu wynikowego HTML sklepu oraz danych plików CSS. Kompresja polega na zmianie sposobu zapisu informacji tak, aby zmniejszyć objętość wyniku. W przypadku aplikacji internetowych istotne jest, aby dane które są wysyłane do przeglądarki (to co wyświetla przeglądarka klientowi) były jak najmniejsze - czym więcej danych (w kilobajtach) zostanie przesłane tym wolniej będzie się u klienta otwierał sklep. Dlatego przy działaniu sklepu można włączyć kompresję poszczególnych elementów. W przypadku kompresji kodu HTML oraz CSS dane są kompresowane &quot;w locie&quot; przed wysłaniem do przeglądarki i nie są zapisywane.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Opcje opisane w tym menu przeznaczone są dla osób posiadających minimalną wiedzę z zakresu działania aplikacji internetowych. Wprowadzenie złych wartości w poszczególnych opcjach może spowodować błędne działanie sklepu.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong> W przypadku korzystania z zewnętrznych programów do aktualizacji danych w sklepie lub importu / eksportu danych poprzez pliki CSV lub XML należy zawsze bezwzględnie <strong>wyczyścić cache</strong> za pomocą opcji na stronie głównej panelu zarządzania - nie usunięcie cache po synchronizacji będzie powodowało wyświetlaniem w sklepie złych danych.</span></div>\r\n"),
("180","35","1","instrukcja","Ustawienia e-mail","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_komunikacja_email.jpg\" style=\"margin-left: 15px; margin-right: 15px; float: right; width: 590px; height: 391px;\" />Program umożliwia wysyłanie wiadomości e-mail dwoma sposobami. Pierwszy z nich to wykorzystanie funkcji mail() oraz programu sendmail zainstalowanego na serwerze. Ten sposób wysyłania jest szybszy i łatwiejszy do skonfigurowania. Jednakże wymaga ona działającej na serwerze funkcji mail(). Większość serwerów ma to włączone - jednak może się zdarzyć że serwer nie posiada tej funkcji . Wówczas należy skonfigurować wysyłanie wiadomości poprzez SMTP.<br />\r\n<br />\r\nW przypadku wysyłania wiadomości e-mail poprzez SMTP należy tę opcję ustawić jako aktywną w konfiguracji e-mail. Następnie należy wprowadzić wszystkie parametry niezbędne do połączenia z serwerem SMTP na którym znajduje się skrzynka pocztowa, która będzie obsługiwała wysyłkę maili ze sklepu. Informacje te można uzyskać w ustawieniach konta pocztowego w firmie, gdzie jest założona poczta.<br />\r\n<br />\r\nDodatkowymi opcjami, które można skonfigurować w ustawieniach wysyłania wiadomości jest forma dołączania plików graficznych. Można je do wiadomości dodawać jako załączniki lub jako zawartość zdalną. Wówczas klientowi w programie pocztowym zostanie wyświetlony komunikat czy chce wyświetlić zdalną zawartość wiadomości. Należy zwrócić uwagę na to, iż w przypadku osadzania grafiki w wiadomości taka wiadomość ma większą objętość.<br />\r\n<br />\r\nOstatnie dwie opcje ustawień dotyczą załączników do wiadomości e-mail. Można zdefiniować maksymalną ilość dołączanych załączników oraz forma plików jakie można załączać. Wiadomości z załącznikami można wysyłać bezpośrednio do klientów w opcji wysyłania maila do klienta w menu <strong>Sprzedaż / Klienci / Wyślij e-mail</strong></div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("181","34","0","instrukcja","Komunikacja",""),
("182","36","1","instrukcja","Ustawienia SMS","<div style=\"text-align:justify;\">W programie można korzystać z funkcji wysyłania do klientów powiadomień SMS o zmianie statusu zamówienia. Do korzystania z tego niezbędne jest posiadanie aktywnego konta w serwisie smsAPI.pl Koszty wysyłania SMS-ów są zgodne z cennikiem serwisu smsAPI.pl.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_komunikacja_sms.jpg\" style=\"float: right; width: 571px; height: 344px; margin-left: 15px;\" />Po wybraniu w menu opcji <strong>Konfiguracja / Komunikacja / Ustawienia SMS</strong> można wpisać parametry do połączenia z serwisem smsPAI.pl umożliwiającego wysyłanie wiadomości SMS.<br />\r\n<br />\r\nTreść wysyłanej wiadomości można zdefiniować w menu <strong>Konfiguracja / Słowniki / Treści wiadomości e-mail</strong> w ustawieniach wiadomości o zmianie statusu zamówienia. W treści sms-a mogą zostać użyte stałe teksty oraz znaczniki w miejsce których zostaną przez program podstawione odpowiednie dane.<br />\r\n<br />\r\nJeżeli została włączona obsługa wysyłania powiadomień SMS i klient podczas realizacji zakupów podał numer telefonu GSM wówczas podczas edycji zamówienia w zakładce gdzie zmienia się statusy zamówień wyświetlana jest dodatkowa opcja umożliwiająca prócz wysłania informacji w wiadomości e-mail również wysłanie powiadomienia sms-em do klienta.<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/zamowienia_powiadom_sms.jpg\" style=\"margin-top: 15px; margin-bottom: 15px; margin-right: 15px; float: left; width: 260px; height: 165px;\" /><br />\r\nPo zaznaczeniu opcji - klient otrzyma sms-em powiadomienie o zmianie statusu jego zamówienia.<br />\r\n<br />\r\nDodatkowo jest również możliwość wysłania do klienta dowolnej wiadomości SMS. W menu <strong>Sprzedaż / Klienci</strong> na liście klientów w kolumnie zawierającej ikony nawigacyjne jest ikonka po kliknięciu której jest wyświetlany formularz umożliwiający wprowadzenie dowolnej treści i wysłania wiadomości do klienta, na numer telefonu podany przez niego podczas rejestracji. <img alt=\"alt\" height=\"104\" src=\"obrazki/pomoc/klienci_wysylanie_sms.jpg\" style=\"margin-top:15px;margin-bottom:15px;float:right;\" width=\"621\" /></div>\r\n"),
("183","40","0","instrukcja","Obrazki i dokumenty",""),
("184","41","1","instrukcja","Obrazki - ustawienia ogólne","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_obrazki_ogolne.jpg\" style=\"margin-left: 15px; margin-right: 15px; float: right; width: 460px; height: 849px;\" />Program posiada rozbudowane możliwości konfiguracji zdjęć przypisanych do kategorii, producentów oraz produktów. W menu <strong>Konfiguracja / Obrazki i dokumenty / Obrazki ustawienia ogólne</strong> znajduje się formularz, w którym można zdefiniować parametry wyświetlania obrazków na stronach sklepu.<br />\r\n<br />\r\nWielkość zdjęć, które są wgrywane do sklepu nie ma znaczenia - program posiada mechanizm tworzący miniaturki o zdefiniowanych rozmiarach podczas pierwszego wyświetlenia zdjęcia w sklepie. Należy jednak zwrócić uwagę na to, aby oryginalne zdjęcia nie były zbyt duże z uwagi na obciążenie transferu serwera przy wyświetlaniu powiększeń. Najlepiej kierować się zasadą, żeby zdjęcia miały rozmiary nie większe niż rozmiary monitora oraz ich wielkość nie przekraczała 200kb - wówczas można zachować poprawną jakość grafik i nie spowalniać ich ładowania w przeglądarkach klientów.<br />\r\n<br />\r\n<strong>Obrazek domyślny</strong> - jeżeli ta opcja jest włączona a dany produkt nie ma przypisanego żadnego zdjęcia - wówczas na stronie sklepu zostanie wyświetlony domyślny obrazek, np. <em>brak zdjęcia</em><br />\r\n<br />\r\n<strong>Kolor tła</strong> - program tworzy automatycznie miniaturki zdjęć. Utworzona miniaturka ma wymiary dopasowane do zdefiniowanej długości lub wysokości w przypadku proporcje oryginalnego zdjęcia są inne niż zdefiniowany wymiar miniaturki. Opcja ustawienia koloru tła pozwala na dopasowanie dopełnienia tła do zdefiniowanego rozmiaru miniaturki. Ma to znaczenie szczególnie w przypadku używania ciemnego szablonu sklepu. Jeżeli zostanie podany kolor w formacie RGB wówczas dopełnienie będzie w tym kolorze. Jeżeli pole pozostanie puste program uzupełni dopełnienie kolorem z narożnika zdjęcia.<br />\r\n<br />\r\n<strong>Szerokość, wysokość</strong> - są to pola, w których można zdefiniować wymiary wyświetlanych zdjęć na poszczególnych strona sklepu takich jak listing produktów, karta produktu, moduły na stronie głównej sklepu.<br />\r\n<br />\r\n<strong>Obrazek domyślny, gdy nie ma zdjęcia</strong> - w tym miejscu można określić zachowanie sklepu w przypadku, gdy produkt ma przypisane zdjęcie, a pliku nie ma fizycznie na serwerze. Jeżeli opcja jest włączona, to zostanie wyświetlony obrazek domyślny - w przeciwnym razie nie będzie nic wyświetlane w miejscu przeznaczonym na zdjęcie.<br />\r\n<br />\r\n<strong>Skalowanie powiększenia</strong> - zalecamy ustawienie tej opcji jako włączonej. Wówczas jeżeli rozmiary oryginalnego zdjęcia są większe nic rozdzielczość monitora klienta, który przegląda sklep, wówczas kliknięciu powiększenia zdjęcia zostanie ono przeskalowane w taki sposób, aby się zmieściło na ekranie.<br />\r\n<br />\r\n<strong>Preloader</strong> - włączenie tej opcji powoduje, że zdjęcia są ładowane i wyświetlane dopiero wówczas, gdy zostanie wyświetlona dana część strony. Ma to znaczenie szczególnie w przypadku listingów produktów i powoduje mniejsze obciążenie łącza. Jeżeli listing jest długi i nie mieści się na ekranie monitora - wówczas wyświetlone są tylko te zdjęcia, które w danej chwili są widoczne na monitorze. Po przewinięciu strony w dół dopiero są ładowane kolejne obrazki.<br />\r\n<br />\r\n<strong>Katalog zdjęć</strong> - określa katalog w którym są zapisywane zdjęcia dodawane do produktów. Katalog ten musi mieć uprawnienia do zapisu. Można w nim tworzyć kolejne podkatalogi, np. podzielone według kategorii produktów. Tworzenie podkatalogów ułatwia zarządzanie zdjęciami i ich odnajdowanie podczas edycji.</div>\r\n"),
("185","41","1","instrukcja","Obrazki - ikony na zdjęciach","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_obrazki_ikonki.jpg\" style=\"float: right; margin-left: 15px; width: 440px; height: 179px;\" />Program umożliwia wyświetlanie na zdjęciach produktów ikonek informujących, że jest to <span style=\"color:#008000;\"><strong>nowość, produkt polecany, promocja</strong></span>, itp. W menu <strong>Konfiguracja / Obrazki i dokumenty / Obrazki - ikony na zdjęciach</strong> można ustawić dla jakich opcji mają być wyświetlane ikonki.<br />\r\n<br />\r\nPierwsza opcja określa czy w ogóle mają być stosowane ikonki na zdjęciach. Przy wyłączonej opcji na zdjęciach nie będą wyświetlane żadne ikonki.<br />\r\n<br />\r\nKolejna pozycja to pytanie - ile ikonek ma być wyświetlanych na zdjęciu produktu. Dostępne możliwości to jedna ikonka - w taki przypadku jest wyświetlana tylko jedna ikona. Pomimo tego, że produkt może być jednocześnie promocją i nowością - ikona będzie wyświetlana tylko jedna. Ikony są wyświetlane w następującej kolejności: nowość, promocja, polecany, hit, darmowa dostawa. Np jeżeli produkt jest jednocześnie nowością i hitem - będzie wyświetlana tylko ikona hitu. Przy ustawieniu wyświetlania wszystkich ikon na zdjęciu będą wyświetlane wszystkie ikony jakie są przypisane do produktu - jedna pod drugą - w kolejności jak powyżej.<br />\r\n<br />\r\nPozostałe pola umożliwiają włączenie bądź wyłączenie ikonek dla poszczególnych opcji produktu. Jeżeli opcja jest włączona to wyświetla się na zdjęciach tych produktów, które podczas dodawania/edycji mają zaznaczoną opcje, ze dany produkt jest promocją nowością, itp.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_obrazki_ikonki_produkt.jpg\" style=\"float: right; margin-left: 15px; width: 495px; height: 123px;\" />Jeżeli produkt ma zaznaczoną przynajmniej jedną z opcji nowość, nasz hit, promocja, polecany lub darmowa dostawa, to wówczas po włączeniu opcji wyświetlania na zdjęciach produktów ikonek zostanie w sklepie wyświetlony obrazek informujący o statusie produktu.<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_obrazki_ikonki_widok.jpg\" style=\"float:left;margin-top:15px;margin-bottom:15px;width:395px;height:222px;margin-left:0px;\" /></div>\r\n"),
("186","43","1","instrukcja","Obrazki - znak wodny","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_obrazki_watermark.jpg\" style=\"float: right; margin-left: 15px; margin-right: 15px; width: 569px; height: 511px;\" />Publikacja zdjęć, czy to ilustracji w internecie niesie za sobą niebezpieczeństwo wykorzystania tych materiałów przez inne osoby. Jednym z rozwiązań, pozwalających zminimalizować powstałe wówczas szkody, jest umieszczanie na zdjęciach znaku wodnego.<br />\r\n<br />\r\nProgram umożliwia automatyczne tworzenie znaków wodnych ma zdjęciach produktów. Po wybraniu w menu opcji <strong>Konfiguracja / Obrazki i dokumenty / Obrazki - znak wodny</strong> zostanie wyświetlony formularz umożliwiający określenie parametrów znaku wodnego. Zdjęcia mogą zostać oznaczone znakiem wodnym poprzez nałożenie na nie zdefiniowanego tekstu lub przygotowanego wcześniej obrazka.<br />\r\n<br />\r\nFormularz składa się niejako z dwóch części. W pierwszej można określić parametry nakładanego tekstu, a drugiej obrazków.<br />\r\n<br />\r\nW przypadku nakładania tekstu znaku wodnego można wybrać ustawienia czy znak wodny ma być nakładany tylko na miniaturki czy także na oryginalne zdjęcia. Następnie należy wpisać tekst jaki ma być wyświetlany, jego położenie na zdjęciu. Do wyliczania położenia przyjmuje się szerokość obrazka 100% i wysokość 100%. W podanym na screenie przykładzie 50% 80% tekst będzie nałożony w poziome centralnie na obrazku oraz w pinoe będzie przesunięty w dół względem jego środka o 30%.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_obrazki_watermark_przyklad.jpg\" style=\"float:left;margin-right:15px;width:182px;height:172px;\" />Przykład nałożonego w taki sposób tekstu znajduje się na obrazku obok. Tekst może być tworzony dowolną czcionką true type. Wybrana czcionka musi być wgrana do katalogu <span style=\"color:#ff0000;\"><strong>/programy/font</strong></span> znajdującego się w sklepie. Dodatkowo można określić rozmiar oraz kolor czcionki.<br />\r\n<br />\r\nNastępna część formularza umożliwia ustawienie obrazka jako znaku wodnego. Skonfigurować można parametry czy znak wodny ma być tylko na zdjęciu powiększonym czy również na wszystkich miniaturkach w sklepie. Jeżeli jako znak wodny ma być na zdjęcie nakładany obrazek, to należy przygotować odpowiednie pliki graficzne. Powinny być to przeźroczyste obrazki w formacie PNG. Najlepiej jest przygotować kilka plików w różnych rozmiarach - zależnie od tego do czego mają być używane. Do powiększonych zdjęć plik może być większy, natomiast do miniaturek powinien być mniejszy.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_obrazki_watermark_przyklad1.jpg\" style=\"width:183px;height:170px;margin-left:15px;margin-right:15px;float:right;\" />Podobnie jak w przypadku nakładanego tekstu, można ustalić położenie w jakim ma być nakładany obrazek znaku wodnego na zdjęcie. Pozycję ustala się w analogiczny sposób jak w przypadku tekstu. Dodatkowym parametrem jest przeźroczystość znaku wodnego.</div>\r\n"),
("187","761","0","instrukcja","Masowa zmiana parametrów produktów",""),
("188","762","1","instrukcja","Zmiana cen produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/masowa_zmiana_cen.jpg\" style=\"width: 550px; height: 316px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Moduł służy do masowej zmiany cen produktów oraz masowej zmiany zniżek zależnych do ilości produktów w koszyku (procentowych). Umożliwia manipulowanie cenami produktów bez wchodzenia i edycji każdego produktu po kolei. Zmiany cen dokonuje się wg określonych wzorów, które można wpisywać w pole zmiany cen.<br />\r\n<br />\r\nPo uruchomieniu modułu w górnym lewym narożniku wyświetlane są pola do wpisania wzoru wg jakiego mają być zmienione ceny w sklepie.<br />\r\n<br />\r\nMożna dokonać zmian we wszystkich lub tylko w określonych cenach. Jeżeli określone ceny mają pozostać niezmienione - pola ich dotyczące należy pozostawić puste.<br />\r\n<br />\r\nW module można dokonać operacji na głównych cenach produktu oraz cenie poprzedniej (używanej przy promocjach).<br />\r\n<br />\r\nW tabeli po prawej stronie pokazane są przykłady wzorów jakie można stosować podczas modyfikacji cen. Jeżeli ceny mają być zmienione na określoną wartość liczbową wystarczy wpisać w pola tylko same liczby. Wtedy wszystkie ceny zostaną zamienione na podaną wartość. Jeżeli ceny mają być np obniżone o określoną wartość trzeba użyć wzoru, dla przykładu: x - 10. W miejsce x sklep podstawi cenę produktu i efektem działania będzie obniżenie ceny o 10. W przypadku wpisywania wzorów nie można w tekście stosować spacji, a jako separator dziesiętny należy stosować kropkę - zgodnie z przykładami podanym w tabeli opisu.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/masowa_zmiana_cen_filtry.jpg\" style=\"width: 550px; height: 290px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Poniżej definiowania cen znajdują się dodatkowe parametry dla zmiany cen. Umożliwiają one ograniczenie aktualizacji cen do produktów, które spełniają określone parametry. W parametrach można zaznaczyć, żeby były aktualizowane ceny z określonych kategorii lub określonych producentów. Można także dodatkowo zaktualizować np tylko nowości czy promocje lub ceny w określonej walucie.<br />\r\n<br />\r\nModuł daje bardzo duże możliwości manipulowania cenami i duże możliwości parametryzowania - dzięki czemu można dokonać modyfikacji ściśle określonych cen produktów.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/masowa_zmiana_cen_wynik.jpg\" style=\"margin: 10px; float: right;\" />Po ustawieniu odpowiednich parametrów zmiany cen - w celu wykonania aktualizacji należy wcisnąć przycisk <strong>Aktualizuj dane</strong>. Po wykonanej aktualizacji zostanie wyświetlony komunikat o ilości zaktualizowanych produktów.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Operacje na cenach są wykonywane bezpośrednio na bazie sklepu - dokonanych modyfikacji nie można odwrócić (cofnąć). Dlatego zawsze przed dokonaniem aktualizacji cen zalecamy wykonanie kopii bazy danych w menu <strong>Narzędzia / Archiwizacja danych</strong></div>\r\n"),
("189","763","1","instrukcja","Zmiana statusu produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/masowa_zmiana_statusow.jpg\" style=\"width: 550px; height: 295px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Moduł służy do masowej zmiany statusu produktów, usuwania produktów nieaktywnych lub wyłączenia kupowania produktów.<br />\r\n<br />\r\nPo uruchomieniu modułu w górnym lewym narożniku wyświetlane są możliwe do wybrania opcje / operacje jakie można wykonać na produktach. Wybór operacji jaka ma być wykonana odbywa się poprzez zaznaczenie wybranej pozycji.<br />\r\n<br />\r\nPoniżej opcji możliwych zmian - podobnie jak przy masowej zmianie cen produktów - znajdują się dodatkowe parametry dla zmiany statusów. Umożliwiają one ograniczenie aktualizacji produktów do tych, które spełniają określone parametry. W parametrach można zaznaczyć, żeby były aktualizowane statusy z określonych kategorii lub określonych producentów. Można także dodatkowo zaktualizować np tylko nowości czy promocje lub ceny w określonej walucie.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/masowa_zmiana_cen_wynik.jpg\" style=\"margin: 10px; float: left;\" />Po ustawieniu odpowiednich parametrów zmiany statusów - w celu wykonania aktualizacji należy wcisnąć przycisk <strong>Aktualizuj dane</strong>. Po wykonanej aktualizacji zostanie wyświetlony komunikat o ilości zaktualizowanych produktów.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Operacje na produktach są wykonywane bezpośrednio na bazie sklepu - dokonanych modyfikacji nie można odwrócić (cofnąć). Dlatego zawsze przed dokonaniem aktualizacji produktów zalecamy wykonanie kopii bazy danych w menu <strong>Narzędzia / Archiwizacja danych</strong></div>\r\n"),
("190","764","0","instrukcja","Przeglądarka plików","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/przegladarka_zdjec_narzedzia.jpg\" style=\"width: 450px; height: 238px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Przeglądarka plików umożliwia zarządzanie (usuwanie lub podgląd) plikami z tzw katalogów (folderów) operacyjnych sklepu. Są to katalogi w których są zapisywane lub mogą być zapisywane na bieżąco podczas działania sklepu pliki. Zadaniem głównym przeglądarki jest możliwość utrzymywania porządku w plikach na serwerze poprzez usuwanie niepotrzebnych plików - bez konieczności łączenia się z serwerem poprzez połączenie ftp.<br />\r\n<br />\r\nW sklepie jest 9 głównych katalogów, które służą do przechowywania plików operacyjnych sklepu. Nie są to katalogi w których znajdują się pliki samego sklepu, które są odpowiedzialne za działanie sklepu.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align:justify;\"><strong>Zdjęcia</strong> - zawiera zdjęcia produktów, pliki mp3, filmy flv, bannery. Jest to najczęściej używany katalog w sklepie przechowujący pliki. Katalog zdjęć jest definiowany w menu <strong>Konfiguracja / Obrazki i dokumenty / Obrazki - ustawienia ogólne</strong>. W menu tym definiuje się jak nazywa się katalog do przechowywania zdjęć, bannerów etc.</li>\r\n	<li style=\"text-align:justify;\"><strong>Pliki do importu</strong> - jest to katalog w którym są przechowywane pliki służące do importu - aktualizowania danych w sklepie - pliki do tego katalogu są wgrywane podczas importu w menu <strong>Narzędzia / Import i eksport danych</strong>.</li>\r\n	<li style=\"text-align:justify;\"><strong>Pliki wyeksportowane</strong> - jest to katalog w którym są przechowywane pliki, które zostały wyeksportowane ze sklepu (pliki z danymi) - pliki te są generowane przez opcje eksportu w menu <strong>Narzędzia / Import i eksport danych</strong>.</li>\r\n	<li style=\"text-align:justify;\"><strong>Pliki do pobierania</strong> - zawiera pliki, które mogą być pobierane przez klientów z karty produktu (jeżeli do produktu zostały dodane pliki do pobrania) - pliki do tego katalogu są dodawane podczas przypisywania do produktu plików do pobrania - menu <strong>Asortyment / Produkty</strong> - edycja lub dodawanie produktu - zakładka Pliki.</li>\r\n	<li style=\"text-align:justify;\"><strong>Pliki wgrywane </strong>- zawiera pliki, które są dodawane do produktów przez klientów - dotyczy możliwości wgrywania zdjęć do produktów poprzez dodatkowe pola tekstowe - menu <strong>Konfiguracja / Słowniki / Dodatkowe pola tekstowe do produktów</strong>.</li>\r\n	<li style=\"text-align:justify;\"><strong>Bannery programu partnerskiego</strong> - zawiera bannery, które są używane do programu partnerskiego sklepu - menu <strong>Sprzedaż / Program partnerski</strong> - bannery są dodawane poprzez menu <strong>Sprzedaż / Program partnerski / Bannery reklamowe</strong>.</li>\r\n	<li style=\"text-align:justify;\"><strong>Pliki xml</strong> - katalog zawiera pliki wygenerowane dla porównywarek cen w menu <strong>Integracje / Porównywarki</strong>.</li>\r\n	<li style=\"text-align:justify;\">Pliki szablonu sklepu - zawiera pliki aktualnie używanego szablonu graficznego sklepu. Podczas przeglądania katalogu szablonu można z poziomu przeglądarki dokonać edycji wybranych plików szablonu.</li>\r\n	<li style=\"text-align:justify;\"><strong>Pliki podstron szablonów</strong> - zawiera pliki znajdujące się w katalogu szablony/__tresc&nbsp; - są to pliki odpowiedzialne za wygląd poszczególnych podstron sklepu w szablonach.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Zmiana katalogu z jakiego maja być wyświetlane pliki następuje poprzez kliknięci w dużą ikonę z nazwą katalogu. Przy ikonie aktualnie wyświetlanego folderu zostanie wyświetlona ikona lupy. Po kliknięciu w ikonę w oknie poniżej zostanie wyświetlona lista plików oraz katalogów jaką zawiera dany folder. Poruszanie się po danym katalogu jest podobne jak w przypadku folderów Windows (wejście w podkatalog następuje poprzez kliknięcie w jego nazwę). Z poziomu przeglądarki można usunąć wybrane pliki - klikając na znak X przy pliku lub folderze. Jeżeli usuwany jest katalog - to wraz z nim są usuwane pliki które zawiera. W przypadku plików zdjęć (oznaczonymi ikonką obrazka) istnieje możliwość podglądu miniaturki zdjęcia w oknie po prawej stronie. Po kliknięciu w dany plik po prawej stronie zostanie wyświetlona jego miniatura oraz dane o pliku: rozmiar, rozdzielczość oraz data utworzenia.<br />\r\n<br />\r\nZe względów bezpieczeństwa w przeglądarce nie można przeglądać innych folderów, np z plikami źródłowymi sklepu. Taką operację można wykonać wyłącznie poprzez połączenie ftp bezpośrednio na serwerze sklepu. Nie można także wgrywać ani tworzyć nowych plików - przeglądarka ma możliwość wyłącznie usuwania plików oraz edycji w przypadku plików szablonów.</div>\r\n"),
("191","765","0","instrukcja","Archiwizacja danych","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/archiwizacja_danych.jpg\" style=\"width: 520px; height: 119px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Sklep umożliwia stworzenie kopii bazy danych.&nbsp; Dzięki temu modułowi możemy stworzyć kopię bazy SQL i w razie awarii serwera można łatwo przywrócić dane sklepu. Baza danych zawiera ustawienia sklepu wraz z produktami i kategoriami, zamówieniami i klientami. Ze względów bezpieczeństwa zaleca się tworzenie kopii bezpieczeństwa minimum raz w tygodniu. Większość serwerów wykonuje kopię bezpieczeństwa (tzw backup) co określony czas ale dodatkowo zalecamy również wykonywanie kopii bazy i pobieranie jej bezpośrednio na własny komputer jako dodatkowe zabezpieczenie danych.<br />\r\n<br />\r\nObsługa archiwizacji bazy danych w panelu zarządzania odbywa się poprzez menu <strong>Konfiguracja / Narzędzia / Archiwizacja danych</strong>. Po wejściu w menu wyświetlana jest lista plików baz danych, które zostały zarchiwizowane. Pliki baz danych są to pliki tekstowe zapisywane w formacie SQL. SQL jest to rodzaj baz danych - z takiego rozwiązania korzysta sklep.<br />\r\n<br />\r\nW liście każdy plik bazy danych jest wyświetlany w osobnym wierszu. Pierwsza kolumna wyświetla nazwę pliku. Nazwa zapisanego pliku składa się z tekstu, daty utworzenia oraz losowego ciągu - uniemożliwiającego pobranie bazy danych przez osoby niepowołane. Następna kolumna wyświetla informację o wersji sklepu dla jakiej była tworzona kopia bazy danych (tylko w przypadku jeżeli taka informacja była zapisana podczas tworzenia kopii). Kolejna kolumna wyświetla wielkość danego pliku (bazy danych). Następna kolumna to data utworzenia. W ostatniej kolumnie wyświetlane są ikony nawigacyjne. Umożliwiają one pobranie pliku bazy i zapisanie na komputerze lokalnym, wczytanie zapisanej bazy do sklepu (zastąpienie istniejącej bazy) oraz usunięcie pliku bazy z serwera. Zalecamy, żeby co pewien czas usuwać stare pliki baz, gdyż zajmują one niepotrzebnie miejsce na serwerze.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/archiwizacja_danych_postep.jpg\" style=\"width:320px;height:49px;margin-right:15px;margin-bottom:15px;float:left;\" />Nad listą z plikami baz znajduje się przycisk <strong>tworzenia kopii bazy danych</strong>. Po kliknięciu w przycisk zostanie wyświetlone nowe okno i rozpocznie się proces zapisu kopii bazy do pliku. Proces generowania pliku archiwizacji może trwa od kliku sekund do kilku minut - w zależności od wielkości bazy. Po zakończeniu zapisu wyświetlony zostaje komunikat o zakończeniu archiwizacji zawierający nazwę pliku pod jaką została zapisana baza. Po powrocie do listy można pobrać zarchiwizowany plik.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/archiwizacja_danych_odczyt.jpg\" style=\"width:300px;height:41px;float:right;margin-left:15px;margin-bottom:15px;\" />Podobnie wygląda wczytywanie bazy danych. Wczytanie bazy danych odbywa się poprzez kliknięcie w ikonę <img alt=\"alt\" src=\"obrazki/pomoc/ikona_wczytanie.png\" style=\"width:19px;height:21px;\" />. Po kliknięciu w ikonę przy pozycji, <strong>która ma być wczytywana</strong> - rozpocznie się proces wczytywania bazy danych. Proces odtwarzania bazy danych może trwa do kliku minut - w zależności od wielkości bazy. <span style=\"color:#ff0000;\">Nie wolno przerywać procesu odtwarzania gdyż spowoduje do uszkodzenie bazy danych</span>. Po zakończeniu przywracania bazy zostanie wyświetlony komunikat o zakończeniu procesu przywracania. Po kliknięciu w przycisk Powrót administrator sklepu zostanie wylogowany ze sklepu i musi zalogować się ponownie.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>UWAGA</strong></span> Podczas przywracania bazy są usuwane wszystkie dotychczasowe dane, które znajdowały się w bazie i w ich miejsce wstawiane są dane z bazy (pliku), która jest wczytywana. Procesu przywracania nie można odwrócić (cofnąć). Zalecamy bardzo uważne i ostrożne przywracanie plików bazy danych.</div>\r\n"),
("192","44","1","instrukcja","Dokumenty PDF","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_doumenty.jpg\" style=\"float: right; width: 560px; height: 161px; margin-left: 15px; margin-bottom: 15px;\" />W menu <strong>Konfiguracja / Obrazki i dokumenty / Dokumenty PDF</strong> definiuje się parametry poszczególnych elementów na wydrukach PDF dostępnych w sklepie. Formularz zawiera m.in. pola umożliwiające wybranie pliku obrazka logo oraz podanie jego długości w milimetrach. Długość ta określa jak duży będzie obrazek i od którego miejsca zacznie się tekst znajdujący się w nagłówku dokumentu. Należy do nagłówka dokumentów PDF dobrać obrazek o takich wymiarach jakie są w rzeczywistości, gdyż przeskalowana grafika może być nieostra na wydruku. Poza wyborem obrazka i jego ustawień pozostałe opcje umożliwiają włączenie lub wyłączenie poszczególnych opcji w różnych wydrukach PDF.<br />\r\n<br />\r\nW polu <strong>Dane podmiotu prowadzącego sklep wyświetlane w nagłówku dokumentów PDF</strong> definiuje się dane firmy jakie mają być drukowane w dokumentach PDF. Można tutaj wpisać nazwę firmy oraz dane kontaktowe, które będą generowane na wydrukach PDF.<br />\r\n<br />\r\nW polu <strong>Dowolny tekst drukowany w wybranych dokumentach PDF</strong> można zdefiniować dodatkowy tekst, który może być dodatkowo drukowany na wybranych dokumentach PDF. Tekst jest generowany na dole wybranych dokumentów PDF. Poniżej edytora tekstu dostępny jest wybór w jakich dokumentach ma być generowany tekst.<br />\r\n<br />\r\nOstatnie dwie opcje ustawień to <strong>Czy podczas zamówienia zapisywać plik PDF ?</strong> oraz <strong>Katalog do zapisywania plików PDF zamówień</strong>. Opcje te dotyczą możliwości zapisywania przez sklep dokumentu PDF ze szczegółami zamówienia po złożeniu przez klienta zamówienia w sklepie. Jeżeli klient złoży zamówienie, a opcja zapisu jest włączono to w wybranym katalogu zostanie zapisany plik PDF ze szczegółami złożonego zamówienia.</div>\r\n"),
("193","50","0","instrukcja","Tłumaczenia","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/konfiguracja_tlumaczenia.jpg\" style=\"float:right;width:657px;height:286px;margin-bottom:15px;margin-left:15px;\" />Program umożliwia samodzielne modyfikowanie tekstów znajdujących się na stronie sklepu. Zarówno jeżeli chodzi w wszystkie teksty interfejsu, przycisków jak i opisów metod wysyłek i płatności. Standardowo program zawiera dwie wersje językowe: polską i angielską. Po wybraniu w menu opcji <strong>Konfiguracja / Tłumaczenia</strong> zostanie wyświetlona lista wszystkich tekstów używanych w sklepie.<br />\r\n	 </div>\r\n<div style=\"text-align:justify;\">\r\n	Wszystkie teksty podzielone zostały na sekcje, które umożliwiają łatwiejsze odnalezienie szukanej frazy. Ponadto na liście tłumaczeń znajduje się wyszukiwarka, w której po wpisaniu ciągu znaków program podpowiada znajdujące się w bazie podobne teksty.<br />\r\n	<br />\r\n	Na liście tłumaczeń w kolejnych kolumnach podane są informacje dotyczące sekcji w której znajduje się dany tekst, nazwa stałej (jest to ciąg znaków, który jest umieszczony w kodzie programu - w jego miejsce jest podstawiany tekst, który został do niego przypisany). Następnie jest treść tłumaczenia. Ostatnia kolumna zawiera ikonę umożliwiającą edycję tekstu. Tekst można edytować pojedynczo bezpośrednio w panelu administracyjnym lub można wyeksportować dane do pliku tekstowego w którym można wprowadzić modyfikacje, a następnie ponownie wczytać go do sklepu. Umożliwiają to dwa linki znajdujące się nad listą tłumaczeń: <span style=\"color:#008000;\">importuj dane</span> oraz <span style=\"color:#008000;\">eksportuj dane do pliku</span>.<br />\r\n	<br />\r\n	<img alt=\"alt\" height=\"288\" src=\"obrazki/pomoc/konfiguracja_tlumaczenia_edycja.jpg\" style=\"float:right;margin-left:15px;\" width=\"489\" />Po kliknięciu ikony edycji tłumaczenia wyświetlany jest formularz, w którym można wprowadzić zmiany tekstów we wszystkich uruchomionych w sklepie wersjach językowych.<br />\r\n	<br />\r\n	Użytkownik może zmienić tylko tekst tłumaczenia - nie ma możliwości zmiany nazwy zmiennej, która ten tekst zawiera.<br />\r\n	<br />\r\n	W analogiczny sposób można w programie dodać swoje własne teksty i wykorzystać je na stronach sklepu. Dodając swój własny tekst należy podać nazwę zmiennej, która będzie wykorzystywana w kodzie strony i która będzie zastąpiona nowym tekstem.<br />\r\n	<br />\r\n	Do programu można dodać swoje własne wersje językowe. W tym celu należy najpierw zdefiniować nowy język w menu <strong>Konfiguracja / Słowniki / Języki</strong> (szczegóły opisane są w części instrukcji poświęconej temu działowi). Jeżeli zostanie dodany nowy język - wówczas podczas edycji tłumaczeń automatycznie zostanie wyświetlona kolejna zakładka na wprowadzanie danych w tym języku.</div>\r\n"),
("194","766","0","instrukcja","Harmonogram zadań","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/harmonogram_zadan.jpg\" style=\"width: 550px; height: 218px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Harmonogram zadań umożliwia planowane automatycznie wykonywanie określonych skryptów sklepu, których zadaniem jest wykonanie określonych czynności. Sklep umożliwia dodanie do czterech dowolnych skryptów, które mogą być wykonywane co określony czas.<br />\r\n<br />\r\nKażde zadanie dodaje się w osobnym oknie. W opcjach zadania znajdują się opcje: możliwość włączenia czy zadanie ma być wykonywane, pole nazwy skryptu jaki ma być uruchamiany (pliki do harmonogramu zadań muszą znajdować w katalogu o nazwie /harmonogram), opis zadania (widoczny tylko dla administratora sklepu jako informacja) oraz pole wyboru - co ile godzin ma się uruchamiać skrypt. Po wypełnieniu pól i zaznaczeniu odpowiednich opcji należy zapisać dane przyciskiem <strong>Zapisz dane</strong> (osobno dla każdego zadania harmonogramu)<br />\r\n<br />\r\nStandardowo w harmonogramie zadań dodany jest jeden skrypt służący do aktualizacji walut. Jest on uruchamiany co określony czas i aktualizuje kursy walut wg notowań NBP.<br />\r\n<br />\r\nCzas który ustawia się do wykonywania skryptu jest to minimalny czas jaki musi upłynąć od ostatniego wykonania, aby zadanie było wykonane ponownie. Harmonogram nie działa automatycznie w tle - nie odlicza czasu który upłynął od ostatniego wykonania (budowa aplikacji internetowych na to nie pozwala). Harmonogram zadań zadziała w momencie kiedy sklep zostanie wyświetlony przez jakiegokolwiek klienta. Dla przykładu: skrypt jest ustawiony, że ma się wykonywać co 12 godzin. Następne wykonanie jest zaplanowane na godz. 20.00. Skrypt zostanie uruchomiony automatycznie przez pierwszego klienta, który wejdzie do sklepu po godz 20.00. Oczywiście klient nie odczuje tego, że cokolwiek zostało wykonane, ale zanim wyświetli mu się strona sklepu - harmonogram zadań najpierw sprawdzi czy nie ma do wykonania jakiegoś zadania - jeżeli tak - wykona je - dlatego w przypadku aktualizacji walut - wykona się skrypt aktualizacji i klientowi wyświetli się sklep już z zaktualizowanymi cenami. Od momentu uruchomienia przez klienta harmonogramu zadań zostanie doliczone kolejne np 12 godzin. Jeżeli dowolny klient w w/w przykładzie uruchomi sklep dopiero o godz 22.00 to do tej godziny zostanie doliczone 12 godzin i następne uruchomienie nastąpi dopiero o godzinie minimum 10.00 następnego dnia.<br />\r\n<br />\r\nHarmonogram działa w oparciu o wejścia / uruchomienia sklepu przez klientów. Z założenia każdy sklep zostaje minimum kilka razy dziennie uruchomiony przez klientów co spowoduje zadziałanie harmonogramu. W skrajnych przypadkach jeżeli nikt z klientów nie odwiedzi sklepu - harmonogram może się nie uruchamiać przez dłuższy czas - pierwsze wejście dowolnego klienta automatycznie uruchomi skrypty harmonogramu.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>UWAGA</strong></span> Opisana funkcja jest przeznaczona dla zaawansowanych użytkowników sklepu. Jeżeli ktoś z Państwa będzie chciał dodać własny skrypt do automatycznego wykonywania proszę wzorować się na budowie skryptu do aktualizacji walut lub o kontakt z autorami oprogramowania sklepu.</div>\r\n"),
("195","0","0","pytanie","Jak dodać ikonkę w pasku adresu przeglądarki ?","<div class=\"tresc_opis\">\r\n<div class=\"panel\">\r\n<div style=\"text-align:justify;\">Favicon (ang. favorites icon: ikona ulubionych) &ndash; ikona, która pojawia się przed adresem w polu adresowym przeglądarki internetowej. Ikona ta ma postać obrazka 16x16 lub 32x32 pikseli.</div>\r\n</div>\r\n</div>\r\n\r\n<div class=\"tresc_opis\">\r\n<div class=\"panel\">Przeglądarki wyświetlają ikonę favicon:\r\n<ol>\r\n	<li>zdefiniowaną w kodzie HTML znacznikiem &quot;link&quot;, np. gdzie &#39;icon.png&#39; oznacza względny lub absolutny adres URL pliku favicon</li>\r\n	<li>umieszczoną w głównym katalogu, w którym znajduje się strona internetowa, bez potrzeby definiowania adresu favicon w kodzie strony, np. http://pl.wikipedia.org/favicon.ico</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Obie metody (czyli definiowanie adresu favicon w kodzie oraz umieszczanie pliku favicon.ico w katalogu głównym) mogą być stosowane równocześnie. Niektóre przeglądarki wyświetlają ikonę tylko wtedy, gdy strona została dodana do folderu Ulubione/Łącza/Zakładki (np. Internet Explorer 6).<br />\r\n<br />\r\nSam plik ikony o nazwie favicon.ico należy wgrać do głównego katalogu sklepu. W internecie znajduje się wiele stron gdzie można wygenerować ikonę na podstawie plików bmp, jpg czy gif. Przykładowy generator: <a href=\"http://favicon-generator.org\">http://favicon-generator.org</a></div>\r\n</div>\r\n</div>\r\n"),
("196","767","0","instrukcja","Przekierowania URL","<div style=\"text-align:justify;\">\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/przekierowania.jpg\" style=\"width:650px;height:172px;margin-left:15px;margin-bottom:15px;float:right;\" />Moduł przekierowań służy do automatycznego poinformowania przeglądarki internetowej, że ma wyświetlić inny adres niż wpisany w przeglądarce. Moduł jest szczególnie przydatny jeżeli Państwa sklep został przeniesiony z innej platformy gdzie część linków była inna niż w aktualnym sklepie. Jest także bardzo przydatny dla linków produktów, które zostały wycofane ze sprzedaży, a w ich miejsce trafiły np nowe wersje. Jeżeli takie linki były zaindeksowane przez wyszukiwarkę Google (i były to mocne linki - np na wysokich pozycja w wyszukiwarce), to zaleca się przekierowanie takich adresów (linków) poprzez użycie przekierowania na nowe linki (tzw przekierowanie 301 - oznacza, że strona została na stałe przeniesiona do nowej lokalizacji). Jest to najlepszy sposób, aby zapewnić, że użytkownicy i wyszukiwarki są kierowani do właściwej strony.<br />\r\n	<br />\r\n	W module można dodać dowolną ilość przekierowań. Sklep przy każdym uruchomieniu sprawdza czy link który jest aktualnie uruchamiany w sklepie nie musi zostać przekierowany na inny adres - jeżeli znajdzie link - dokonuje przekierowania.<br />\r\n	<br />\r\n	Obsługa modułu jest bardzo prosta. Pierwsza główna opcja to ustawienie czy moduł ma być aktywny czy wyłączony. Poniżej znajdują się pola do wpisywania adresów. W każdym wierszu znajdują się dwa pola. W pierwsze wpisuje się adres jaki ma być przekierowywany, a w drugim adres na jaki ma być przekierowany. W każdym wierszu znajduje się ikona kasowania, która umożliwia usunięcie danego przekierowania. Zapisu wszystkich przekierowań dokonuje się poprzez naciśnięcie na przycisk <strong>Zapisz dane</strong>.<br />\r\n	<br />\r\n	Adresy wpisywane do pól linków nie mogą zawierać http:// - muszą to być same nazwy linków. Np. adres produkt?id=3 zostanie przekierowany na canon-eos-p-3.html</div>\r\n<br />\r\n"),
("197","802","0","instrukcja","Grupy użytkowników","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/narzedzia_grupy_uzytkownikow.jpg\" style=\"float: right; width: 640px; height: 127px; margin-bottom: 15px; margin-left: 15px;\" />Uprawnienia do uruchamiania poszczególnych pozycji menu w panelu administracyjnym opierają się na nadawaniu odpowiednich uprawnień poszczególnym grupom użytkowników. Użytkownik przypisany do określonej grupy posiada w panelu administracyjnym takie uprawnienia jakie zostały zdefiniowane dla grupy.<br />\r\n<br />\r\nProgram pozwala na tworzenie grup użytkowników panelu administracyjnego sklepu. Każda grupa może mięć przypisany inny zakres uprawnień do uruchamiania poszczególnych pozycji w menu panelu (z wyjątkiem grupy Administratorów, gdzie uprawnienia są zdefiniowane na stałe). Uprawnienia mogą być ustalane do pojedynczej pozycji menu. Po wybraniu w menu opcji <strong>Narzędzia / Grupy użytkowników</strong> wyświetlona zostanie lista zdefiniowanych w programie grup. W kolejnych kolumnach listy wyświetlane są informacje dotyczące poszczególnych grup użytkowników: id grupy, ilość użytkowników, która jest do danej grupy przypisana, nazwa grupy oraz w ostatniej kolumnie znajdują się ikony nawigacyjne.<br />\r\n<br />\r\nIkony nawigacyjne pozwalają na przeglądanie listy użytkowników należących do wybranej grupy, zarządzanie uprawnieniami, edycję oraz usunięcie grupy. Klikając w edycję można zmienić nazwę grupy oraz krótki opis - opis służy tylko do celów informacyjnych np. dla administratora sklepu. Program nie daje możliwości usunięcia grupy <strong>Administratorzy</strong> - jest to grupa w której użytkownicy mają uprawnienia do wszystkich opcji menu w programie. W przypadku gdyby została usunięta mogłaby zostać zablokowana funkcjonalność panelu administracyjnego sklepu. Nie można również usunąć grupy <strong>Obsługa sprzedaży</strong> - należący do niej użytkownicy są powiązani z funkcjonalnością opiekunów zamówień i reklamacji.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/narzedzia_grupy_uzytkownikow_uprawnienia.jpg\" style=\"float: left; margin-right: 15px; width: 520px; height: 138px;\" /><img alt=\"alt\" src=\"obrazki/pomoc/narzedzia_grupy_uzytkownikow_uprawnienia_edycja.jpg\" style=\"float:right;width:347px;height:52px;margin-top:15px;margin-bottom:15px;margin-left:15px;\" />Po wybraniu ikony zarządzania uprawnieniami danej grupy, wyświetlona zostanie lista odpowiadająca strukturze menu w sklepie. Przy każdej pozycji znajduję się znacznik określający czy grupa ma uprawnienia do uruchamiania tej opcji czy nie. Klikając w ikonę edycji uzyskujemy dostęp do możliwości zmiany uprawnień.<br />\r\n<br />\r\nUstawienia można modyfikować dla każdej pozycji menu dostosowując je do potrzeb wybranej grupy użytkowników.<br />\r\n<br />\r\nProgram ma dodatkowe zabezpieczenie przed wywołaniem skryptów bezpośrednio z adresu przeglądarki jeżeli użytkownik nie ma ich w menu.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/grupy_klientow_ikonki.jpg\" style=\"float:right;margin-bottom:15px;margin-left:15px;\" />Dodatkowo w ramach tego modułu dostępna jest możliwość definiowania <strong>szybkich ikon dostępu</strong>, które wyświetlane są nad głównym menu panelu zarządzania. Ta funkcja jest dostępna tylko dla grupy Administratorów. W listingu grup w ikonach nawigacyjnych (dla grupy Administratorów) jest dostępna ikona umożliwiająca zarządzanie ikonami szybkiego dostępu (w miejscu ikony umożliwiającej edycję uprawnień do modułów dostępnej dla innych grup użytkowników). Po wejściu w edycję ikon można wybrać, które moduły mają być wyświetlane w formie przycisków nad górnym menu. Edycji dokonuje się w takim sam sposób jak zmiany uprawnień do modułów.</div>\r\n"),
("198","769","0","instrukcja","Wyłączenia sklepu","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/wylaczenie_sklepu.jpg\" style=\"width: 500px; height: 153px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Sklep posiada możliwość wyłączenia. Po wyłączeniu zamiast sklepu będzie wyświetlana stosowna informacja.<br />\r\n<br />\r\nW menu <strong>Narzędzia / Wyłączanie sklepu</strong> można wyłączyć sklep. Można w tym miejscu zdefiniować jaki komunikat ma wyświetlać się na stronie sklepu oraz nr IP dla jakich sklep ma być widoczny. Takie rozwiązanie umożliwia wyłączenie sklepu dla klientów - a poprzez ustawienie odpowiedniego nr IP - sklep będzie widoczny dla administratora sklepu. Można wpisać kilka nr IP - numeru należy rozdzielić przecinkami. Pozostawienie pola pustego spowoduje, że sklep będzie wyłączony dla wszystkich.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/wylaczanie_sklepu_informacja.jpg\" style=\"width:270px;height:83px;margin-bottom:15px;margin-right:15px;float:left;\" />Obrazek obok prezentuje jak będzie wyglądała informacja która wyświetli się klientom sklepu. Wygląd strony wyłączenia jest definiowany w szablonie - jest za nią odpowiedzialny plik wylaczony_sklep.tp (kod HTML) - plik znajduje się w katalogu szablony/nazwa_szablonu/tresc. Edytując plik można dopasować wygląd strony wyłączenia sklepu do własnych potrzeb.</div>\r\n"),
("199","803","0","instrukcja","Użytkownicy","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/narzedzia_uzytkownicy.jpg\" style=\"float:right;width:619px;height:122px;margin-left:15px;\" />Program umożliwia dodawanie dowolnej liczby użytkowników panelu administracyjnego sklepu. Każdy użytkownik musi należeć do określonej grupy użytkowników. Posiada on uprawnienia do wykonywania tych funkcji z menu, które są przypisane dla danej grupy. Po wybraniu w menu <strong>Narzędzia / Grupy użytkowników</strong> i następnie kliknięciu ikony użytkownicy - wyświetlona zostanie lista użytkowników należących do danej grupy.<br />\r\n<br />\r\nW pierwszej kolumnie jest wyświetlane id użytkownika. <strong>UWAGA:</strong> użytkownika posiadającego id o numerze 1 nie można usunąć z bazy danych - jest to użytkownik, który posiada uprawnienia do wszystkich opcji menu. Jego konto jest generowane podczas instalacji programu.<br />\r\n<br />\r\nNastępna kolumna to imię i nazwisko użytkownika. Dalej wyświetlony jest jego adres e-mail - adres ten jest jednocześnie adresem do logowania do panelu administracyjnego sklepu. W kolejnej kolumnie wyświetlona jest data ostatniego logowania danego użytkownika. Kolumna <strong>Dozwolone IP</strong> umożliwia określenie adresów komputerów z których dany użytkownik może się zalogować do panelu. Dozwolone adresy IP można definiować w następujący sposób:<br />\r\n&nbsp;\r\n<table align=\"center\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\" style=\"width:500px;\">\r\n	<tbody>\r\n		<tr>\r\n			<td>192.168.1.1</td>\r\n			<td>konkretny adres</td>\r\n		</tr>\r\n		<tr>\r\n			<td>192.168.1.*</td>\r\n			<td>pula adresów z konkretnej podsieci</td>\r\n		</tr>\r\n		<tr>\r\n			<td>192.*.*.*</td>\r\n			<td>pula adresów</td>\r\n		</tr>\r\n		<tr>\r\n			<td>*.*.*.*</td>\r\n			<td>dowolny adres</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\nW ostatniej kolumnie znajdują się ikony nawigacyjne. Pozwalają one na edycję lub usunięcie konta oraz ewentualnie zmianę hasła. Jeżeli zalogowany jest użytkownik o ID=1 - wówczas ma on możliwość zmiany hasła wszystkim użytkownikom programu. W przeciwnym razie można zmienić tylko swoje hasło - czyli użytkownika aktualnie zalogowanego.<br />\r\n<br />\r\n<img alt=\"alt\" height=\"172\" src=\"obrazki/pomoc/narzedzia_uzytkownicy_edycja.jpg\" style=\"float:left;margin-right:15px;\" width=\"387\" />Po kliknięciu edycji wyświetlony zostanie formularz umożliwiający wprowadzenie zmian w danych użytkownika. Przy zmianie adresu e-mail należy pamiętać o tym, że służy on nie tylko do wysyłania maili ale jest także loginem do panelu administracyjnego sklepu.<br />\r\n<br />\r\nZmiana przynależności do grupy użytkowników wiąże się ze zmianą uprawnień danego użytkownika, ponieważ automatycznie przejmuje on takie uprawnienia jakie ma nadane wybrana grupa.</div>\r\n"),
("200","0","0","pytanie","Zapomnialem hasła do panelu administracyjnego - co zrobić ?","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/przypomnienie_hasla.jpg\" style=\"margin-left: 15px; margin-right: 15px; float: right; width: 275px; height: 213px;\" />W przypadku gdy użytkownik zapomniał swojego hasła do panelu administracyjnego sklepu, można skorzystać z opcji przypominania hasła. Link znajduje się na stronie logowania do panelu. Po kliknięciu w link <strong>Przypomnienie hasła</strong> wyświetli się formularz, a którym należy wprowadzić swoje imię oraz adres e-mail służący do logowania do sklepu (istotne jest żeby był to prawdziwy i działający adres ponieważ na niego zostanie wysłana wiadomość umożliwiająca zmianę hasła). Po wpisaniu poprawnych danych i kliknięciu przycisku <strong>Zatwierdź</strong> na podany adres zostanie wysłana wiadomość, w której znajduje się link umożliwiający zmianę hasła do panelu administracyjnego sklepu. Jeżeli link zawarty w wiadomości nie zostanie kliknięty - hasło nie zostanie zmienione. Jest to zabezpieczenie przed ewentualnym wygenerowaniem hasła przez osoby do tego niepowołane.</div>\r\n");
INSERT INTO `help_instruction` (`id`, `sort`, `submenu`, `type`, `title`, `info`) VALUES ("201","821","0","instrukcja","Eksport i import - informacje ogólne","<div style=\"text-align:justify;\">Istotną funkcją w sklepie internetowym jest możliwość wymiany danych pomiędzy różnymi programami oraz szybka edycja danych poza sklepem. Możliwość szybkiego zarządzania bazą produktów w sklepie jest ważną sprawą dla właścicieli sklepów, którzy prowadząc sklep chcą importować lub eksportować duże ilości produktów. Sklep shopGold posiada wbudowaną możliwość obsługi importu i eksportu poprzez dwa rodzaje plików.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align: justify;\">Pierwszy format importu i eksportu danych do pliki w <span style=\"font-size:14px;\"><strong>formacie CSV</strong></span> - są to pliki tekstowe w których poszczególne pola do importu są rozdzielone odpowiednim separatorem. Najczęściej stosowany separator w sklepie to średnik (taki separator jest stosowany podczas eksportu danych). Pliki CSV posiadają strukturę podobną do arkusza kalkulacyjnego. Plik CSV zawiera odpowiednio zapisane kolumny, które zawierają dane. Każdy wiersz w pliku to kolejny wiersz arkusza kalkulacyjnego, a poszczególne kolumny w wierszu są oddzielone separatorem. Każdy plik CSV musi zawierać sformatowane nagłówki / tytuły kolumn (informacje co oznacza dana kolumna w pliku / arkuszu). Nagłówki muszą być zawsze zawarte w pierwszej linii pliku CSV. Bez poprawnych nagłówków kolumn sklep nie będzie widział gdzie ma zaimportować dane z poszczególnych kolumn arkusza. Plik CSV jest to zwykły plik tekstowy, który można edytować przy pomocy edytorów tekstowych np. Notepad++. Jednak dużo łatwiejszy jest odczyt i obróbka pliku CSV w arkuszu kalkulacyjnym - np pakiecie OpenOffice.<br />\r\n	<br />\r\n	Poniżej pokazany jest przykład w jaki sposób wyświetlane są dane w arkuszu kalkulacyjnym.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/csv_przyklad.jpg\" style=\"width:402px;height:70px;margin-bottom:15px;margin-right:15px;float:left;\" />W linii nr 1 są zdefiniowane nagłówki / tytuły poszczególnych kolumn. Dzięki temu sklep będzie wiedział, że kolumna A dotyczy numeru katalogowego, a kolumna B - nazwy produktu. Sklep posiada zdefiniowane nagłówki poszczególnych kolumn, które są opisane w dalszej części instrukcji dotyczącej importu i eksportu plików CSV.<br />\r\n	<br />\r\n	Plik CSV otworzony bezpośrednio w edytorze tekstowym będzie wyglądał tak:<br />\r\n	<br />\r\n	<span style=\"font-family:couriernew,courier,monospace;\">Nr_katalogowy;Nazwa_produktu,Cena_brutto<br />\r\n	CDE;Bluza męska;90.00<br />\r\n	EFG;Rower damski:1450.00</span><br />\r\n	<br />\r\n	Plik może być także zapisany ze znakami specjalnymi, gdzie każda wartość znajduje się pomiędzy cudzysłowami:<br />\r\n	<br />\r\n	<span style=\"font-family:couriernew,courier,monospace;\">Nr_katalogowy;Nazwa_produktu,Cena_brutto<br />\r\n	&quot;CDE&quot;;&quot;Bluza męska&quot;;&quot;90.00&quot;<br />\r\n	&quot;EFG&quot;;&quot;Rower damski&quot;;&quot;1450.00&quot;</span><br />\r\n	<br />\r\n	<span style=\"color:#FF0000;\"><strong>Uwagi do plików CSV:</strong></span><br />\r\n	1. Każdy produkt musi być zapisany w <strong>osobnym wierszu</strong>.<br />\r\n	2. Każdy produkt musi zawierać <strong>numer katalogowy</strong>.<br />\r\n	3. Pierwszy wiersz w pliku zawierać <strong>nagłówki kolumn</strong>.<br />\r\n	4. Wartości pól mogą być ujęte w cudzysłowy.<br />\r\n	3. Wartości zawierające używany znak separatora (przecinek, średnik, znak tabulacji lub znaki końca linii) <b>muszą</b> być ujęte w cudzysłowy.<br />\r\n	4. Aby w treści pola umieścić cudzysłów należy wpisać znak cudzysłowu dwukrotnie, całą wartość ujmując w cudzysłowy, np zdanie: <em>on powiedział &quot;tak&quot;</em> należy zapisać &quot;<em>on powiedział &quot;&quot;tak&quot;&quot; &quot;</em> - zamieniając jeden cudzysłów przy słowie <em>tak</em> na dwa.<br />\r\n	5. Podczas eksportu plików CSV w sklepie każdy wiersz jest zakończony słowem KONIEC. Przy imporcie plików - importowane pliki - nie muszą posiadać takiego elementu.<br />\r\n	<br />\r\n	Dane w pliku tekstowym są dość trudne do edycji - ze względu na to, że trudno jest rozpoznać gdzie zaczynają się i kończą poszczególne kolumny. Dlatego najlepiej jest dokonywać ewentualnych modyfikacji danych w arkuszu kalkulacyjnym (polecamy OpenOffice) i po obróbce danych zapisać plik do formatu CSV. Przy zapisie należy wybierać kodowanie polskich znaków UTF-8, separator - najlepiej średnik. Dzięki możliwości edycji danych można łatwo zmodyfikować dane wielu produktów lub przystosować plik otrzymany np od dostawcy produktów do formatu CSV jaki używa sklep.<br />\r\n	<br />\r\n	<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Pliki CSV mają określoną - wspólną budowę - ale każdy plik CSV jest inny (ma np inne nazwy nagłówków). Oznacza to, że nie da się zaimportować pliku CSV otrzymanego np od dowolnego dostawcy produktów bez odpowiedniego dopasowania nagłówków. Właśnie edycja pliku w arkuszu kalkulacyjnym pozwala łatwo zmodyfikować nazwy nagłówków oraz kolumny - tak żeby dopasować je do pliku odczytywanego przez sklep.</li>\r\n	<li style=\"text-align:justify;\">Drugi format importu i eksportu danych do pliki w <span style=\"font-size:14px;\"><strong>formacie XML</strong></span>. XML to język formalny przeznaczony do reprezentowania różnych danych. Pliki w formacie XML obsługiwane są między innymi przez przeglądarki internetowe, które traktują zapisane w nim dane jako zwykły tekst. Pliki XML podobnie jak pliki CSV są zapisywane w formacie tekstowym jako pliki tekstowe - mają jednak zupełnie inną budowę - przypominającą trochę zasady programowania komputera. W plikach XML nie ma kolumn, dane są zawarte pomiędzy określonymi znacznikami, a zapisane dane po odczycie pliku są bardziej czytelne - pliki można edytować każdym edytorem dla programistów lub większością edytorów tekstowych.<br />\r\n	<br />\r\n	Poniżej pokazany jest przykładowy plik XML.<br />\r\n	<br />\r\n	<img alt=\"alt\" src=\"obrazki/pomoc/przyklad_xml.jpg\" style=\"width:506px;height:152px;margin-bottom:15px;margin-right:15px;float:left;\" />Plik rozpoczyna się instrukcją sterującą, która zawiera informacje o wersji XML, z jakim jest zgodny oraz o sposobie kodowania polskich znaków. Główną częścią dokumentu są linie poniżej, które zawierają poszczególne dane do importu. Każdy produkt w pliku zawiera się pomiędzy znacznikami o nazwie <strong>&lt;(Produkt</strong><produkt></produkt><strong>)&gt;</strong>. Niektóre dane w pliku zaczynają się od &lt;(![CDATA ... ]] - oznacza to, że dane zawarte w tym miejscu są to dane znakowe i nie będą przetwarzane przez analizator składni XML.<br />\r\n	<br />\r\n	Sklep posiada zdefiniowane poszczególne elementy XML, które składają się na produkt. Są one opisane w dalszej części instrukcji dotyczącej importu i eksportu plików XML.<br />\r\n	<br />\r\n	<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> Pliki XML mają określoną - wspólną budowę - ale każdy plik XML jest inny (ma np inne nazwy pól). Oznacza to, że nie da się zaimportować pliku XML otrzymanego np od dowolnego dostawcy produktów bez napisania odpowiedniego modułu importu (moduł będzie odczytywał poszczególne elementy pliku i dopasowywał je do sklepu).&nbsp; Generalnie każdy dostawca ma własny format plików XML i nie ma jednego wspólnego rozwiązania.</li>\r\n</ol>\r\n\r\n<div style=\"text-align:justify;\">Korzystając z obu rodzajów plików można dodać do sklepu lub zmodyfikować produkty oraz kategorie (w opcji CSV także klientów). W sklepie cechą wspólną importu i eksportu produktów jest <strong>numer katalogowy</strong>. Każdy produkt, który będzie importowany (aktualizowany) musi posiadać unikalny numer katalogowy - odpowiadający produktowi, który będzie aktualizowany w sklepie. Po numerze katalogowym sklep rozpoznaje, który produkt ma zaktualizować. Plików bez numeru katalogowego nie można zaimportować - sklep nie widziałby gdzie ma wstawić poszczególne dane i nie zaimportuje pliku. Każdy numer katalogowy musi być unikalny, numery nie mogą się powtarzać.</div>\r\n"),
("202","822","0","instrukcja","Pliki CSV",""),
("203","823","1","instrukcja","Obsługa plików CSV","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/obsluga_csv.jpg\" style=\"width: 580px; height: 383px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Eksportu oraz importu produktów oraz kategorii poprzez pliki CSV można dokonać poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików CSV</strong>. Po wejściu w menu zostaną wyświetlone okna w których poszczególne opcje umożliwiają import oraz eksport danych poprzez pliki CSV.<br />\r\n<br />\r\nLewa strona dotyczy <strong>importu i aktualizacji danych</strong>. W oknie znajduje się lista plików z których można dokonać importu. Są to pliki, które znajdują się w katalogu /import na serwerze. Pliki do importu można wgrać do katalogu bezpośrednio poprzez połączenie z serwerem (ftp) lub można wykorzystać opcję wgrywania plików, która znajduje się na dole po prawej stronie.<br />\r\n<br />\r\nAby wgrać nowy plik należy wcisnąć przycisk<strong> Przeglądaj</strong>. Po tym otworzy się okno w którym zostaną wyświetlone pliki z Państwa komputera. W oknie trzeba wybrać plik, który ma zostać wgrany oraz wcisnąć przycisk <strong>wgraj wybrany plik</strong>. Sklep rozpocznie wgrywanie pliku - po poprawnym wgraniu wyświetli się on w oknie listy plików opisanym powyżej. Maksymalna wielkość pliku jaki można wgrać poprzez moduł sklepu to 15MB (lub mniej jeżeli ograniczenie ma serwer na którym znajduje się sklep). Czas wgrywania pliku zależy od jego wielkości - nie wolno przerywać procesu wgrywania, gdyż spowoduje to uszkodzenie pliku.<br />\r\n<br />\r\nPliki z katalogu /import (niepotrzebne) można usunąć poprzez <strong>Przeglądarkę plików</strong> - menu <strong>Narzędzia / Przeglądarka plików</strong>.<br />\r\n<br />\r\nPoniżej listy plików do importu znajdują się opcje importu. Pierwsza pozycja to <strong>separator pól</strong>. W tym miejscu trzeba wybrać jakim separatorem są oddzielone poszczególne kolumny w pliku. Domyślnie jest to średnik. W plikach CSV należy pamiętać, żeby jeżeli w importowanym tekście występuje znak separatora to cały tekst musi być ujęty w cudzysłowy - dokładny opis w poprzednim dziale Informacji ogólnych.<br />\r\n<br />\r\nKolejna pozycja to <strong>zakres importu</strong>. Możliwe opcje to <strong>import produktów i kategorii lub samych produktów</strong> (w zależności od danych zawartych w pliku -&nbsp; jeżeli zawiera tylko produkty zostaną zaimportowane tylko produkty, jeżeli zawiera kategorie i produkty - zostaną zaimportowane wszystkie dane). Kolejna opcja to <strong>tylko kategorie</strong> - z pliku zostaną pobrane i zaimportowane tylko kategorie. Ostatnia opcja to tylko <strong>aktualizacja stanów magazynowych i dostępności cech produktów</strong>. Służy ona wyłączenie do aktualizacji i przy tej opcji dane nie będą dodawane. W przypadku dwóch pierwszych opcji jest możliwe wybranie jako rodzaju importu <strong>dodawanie</strong> lub <strong>aktualizacja</strong> - w przypadku dodawania zostaną dodane nowe produkty, jeżeli nie będzie w bazie importowanego produktu o danym numerze katalogowym. W przypadku aktualizacji - jeżeli nie będzie produktu o danym numerze katalogowym - zostanie on pominięty.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/postep_eksportu.jpg\" style=\"width:250px;height:37px;margin-right:15px;margin-bottom:15px;float:left;\" /><img alt=\"alt\" src=\"obrazki/pomoc/eksport_csv_koniec.jpg\" style=\"width:270px;height:80px;margin-left:15px;margin-bottom:15px;float:right;\" />W oknie po prawej stronie znajdują się opcje <strong>eksportu</strong>. W opcjach można zaznaczyć jakie dane mają zostać wyeksportowane oraz można wybrać czy mają być eksportowane wszystkie produkty lub tylko danego producenta czy wybranej kategorii. Po wybraniu odpowiedniej opcji i zakresu eksportowanych danych trzeba wcisnąć przycisk <strong>Eksportuj dane CSV</strong>. Po tym nastąpi eksport danych (na ekranie zostanie wyświetlony pasek postępu). Po zakończeniu procesu eksportu zostanie wyświetlona informacja oraz nazwa pliku do jakiego zostały wyeksportowane dane. Nazwa pliku jest jednocześnie linkiem - kliknięcie w nazwę umożliwia pobranie pliku na dysk lokalny. Plik zostaje także zapisany na serwerze w katalogu /eksport.<br />\r\n<br />\r\n<span style=\"color:#FF0000;\"><strong>WAŻNE:</strong> Obsługa plików CSV dotyczy formatu CSV (struktury pliku) sklepu shopGold. Nie można przy pomocy tego modułu zaimportować dowolnego pliku CSV - plik musi posiadać odpowiednią strukturę (nagłówki) opisaną w instrukcji do sklepu. Moduł obsługi CSV służy do wymiany danych pomiędzy sklepami shopGold lub dostawcami oferującymi CSV zgodny ze strukturą sklepu.</span></div>\r\n"),
("204","824","1","instrukcja","Struktura plików CSV","<div style=\"text-align:justify;\">Pliki CSV do poprawnego importu muszą zawierać odpowiednie <strong>nagłówki</strong> - czyli informacje co oznacza dana kolumna w pliku / arkuszu. Nagłówki muszą być zawsze zawarte w pierwszej linii pliku CSV. Bez poprawnych nagłówków kolumn sklep nie będzie widział gdzie ma zaimportować dane z poszczególnych kolumn arkusza. Poniżej opisane są nagłówki jakie mogą być zastosowane podczas importu plików CSV w sklepie. W nagłówkach bardzo ważny jest zapis oraz wielkość liter. Zamiana np znaku _ na spację lub małych liter na duże i odwrotnie spowoduje, że nagłówek nie zostanie odczytany.<br />\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Nagłówki produktów:</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Nr_katalogowy</td>\r\n			<td>Określa numer katalogowy produktu - jest to <strong>główny nagłówek</strong> każdego pliku importu produktów. Bez tego nagłówka żaden produkt nie zostanie zaktualizowany lub dodany do sklepu. Cały import produktów w sklepie opiera się na numerach katalogowych, które muszą być unikalne dla każdego produktu. Po numerze katalogowym sklep rozpoznaje produkt i go aktualizuje.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kod_producenta</td>\r\n			<td>Określa kod producenta produktu.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Id_produktu_magazyn</td>\r\n			<td>Określa id produktu w zewnętrznym programie magazynowym. Pole może być użyte do powiązania sklepu z programem magazynowym / fakturującym w którym produkty mają inne id niż w sklepie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kod_ean</td>\r\n			<td>Określa kod EAN produktu.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Waga</td>\r\n			<td>Określa wagę produktu w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 4 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Ilosc_produktow</td>\r\n			<td>Określa ilość produktów w magazynie (ogólną ilość) w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Data_dostepnosci</td>\r\n			<td>Określa datę dostępności produktu w formacie ROK-MIESIĄC-DZIEŃ - rok w pełnym formacie liczbowym - np 2017-07-15. Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Notatki_produktu</td>\r\n			<td>Notatki właściciela sklepu do produktu (niewidoczne dla klientów sklepu). Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Sortowanie</td>\r\n			<td>Określa kolejność wyświetlania produktu w listingach produktów w formacie liczbowym xx (liczba całkowita). Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Min_ilosc_zakupu</td>\r\n			<td>Określa ilość produktów jaką można minimalnie zakupić. Ilość w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Opcje po przecinku należy stosować tylko jeżeli produkt można zakupić w formacie dziesiętnym. Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Max_ilosc_zakupu</td>\r\n			<td>Określa ilość produktów jaką można maksymalnie zakupić. Ilość w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Opcje po przecinku należy stosować tylko jeżeli produkt można zakupić w formacie dziesiętnym. Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Przyrost_ilosci</td>\r\n			<td>Określa jaką wielokrotność ilości jaką klient może zakupić, np podanie liczby 2 spowoduje, że klient będzie mógł zakupić tylko 2, 4, 6 itd szt.&nbsp;Ilość w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Opcje po przecinku należy stosować tylko jeżeli produkt można zakupić w formacie dziesiętnym. Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kontrola_magazynu</td>\r\n			<td>Określa czy produkt ma mieć kontrolę stanu magazynowego - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Gabaryt</td>\r\n			<td>Określa czy produkt jest produktem gabarytowym - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Paczkomaty_gabaryt</td>\r\n			<td>Określa rozmiar gabarytu paczkomatów dla produktu - dostępne formy duża litera: A, B lub C.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Paczkomaty_ilosc</td>\r\n			<td>Określa ilość sztuk z paczce dla paczkomatu dla w/w gabarytu w formacie liczbowym xxxx (bez ułamków).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Podatek_Vat</td>\r\n			<td>Określa stawkę podatku VAT w formacie liczbowym np 23 - jeżeli wpisana stawka podatku nie występuje w sklepie zostanie do produktu przypisana domyślna stawka podatku VAT.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_brutto</td>\r\n			<td>Określa cenę produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_brutto_x</td>\r\n			<td>Określa kolejne ceny produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Znak x trzeba zastąpić numerem ceny, czyli: Cena_brutto_2, Cena_brutto_3 itd - w zależności ile w sklepie włączonych jest poziomów cen (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia dla hurtowni</strong>).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_zakupu</td>\r\n			<td>Określa cenę zakupu produktu - format liczbowy xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_poprzednia</td>\r\n			<td>Określa cenę jaka będzie wyświetlana w sklepie jako przekreślona - format liczbowy xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Jeżeli produkt jest dodawany jako promocja to pole jest wymagane.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_poprzednia_x</td>\r\n			<td>Określa kolejne ceny poprzednie produktu w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Jeżeli produkt jest dodawany jako promocja to pole jest wymagane. Cena umożliwia ustawienie innych cen poprzednich dla różnych poziomów cen. Opcja używana jeżeli w sklepie jest włączone kilka poziomów cen produktów. Znak x trzeba zastąpić numerem ceny, czyli: Cena_poprzednia_2.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_katalogowa</td>\r\n			<td>Określa cenę katalogową produktu - format liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Cena katalogowa nie jest wymagana.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_katalogowa_x</td>\r\n			<td>Określa kolejne ceny katalogowe produktu w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Cena katalogowa nie jest wymagana. Cena umożliwia ustawienie innych cen katalogowych dla różnych poziomów cen. Opcja używana jeżeli w sklepie jest włączone kilka poziomów cen produktów. Znak x trzeba zastąpić numerem ceny, czyli: Cena_katalogowa_2.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Nowosc</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak nowość - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Nasz_hit</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak hit - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Polecany</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak polecany - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Promocja</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak promocja - dostępne formy słowo: tak lub nie. Do tego pola konieczne jest wypełnienie pola ceny poprzedniej.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Do_porownywarek</td>\r\n			<td>Określa czy produkt będzie eksportowany do porównywarek cen - dostępne formy słowo: tak lub nie. Opcja nie jest wymagana jeżeli w opcjach eksportu do porównywarek nie będzie wybrana opcja - tylko zaznaczone produkty.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Negocjacja</td>\r\n			<td>Określa czy ma być możliwość negocjacji ceny produktu - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Darmowa_wysylka</td>\r\n			<td>Określa czy produkt ma być objęty darmową wysyłką - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Wykluczona_darmowa_dostawa</td>\r\n			<td>Określa czy produkt ma być wykluczony z darmowej wysyłki - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Zdjecie_glowne</td>\r\n			<td>Określa ścieżkę oraz nazwę głównego zdjęcia produktu - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia produktu to produkt.jpg. Wartość musi być podana jako produkt.jpg, a nie jako obrazki/produkt.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.<br />\r\n			<br />\r\n			Podczas importu sklep doda do bazy wyłącznie nazwę zdjęcia wraz ze ścieżką. Żeby zdjęcie wyświetlało się w sklepie musi zostać wgrane do miejsca gdzie będzie wskazywała ścieżka zdjęcia. Import danych CSV nie importuje zdjęć produktów.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Zdjecie_glowne_opis</td>\r\n			<td>Określa tytuł (dla znacznika alt/title) głównego zdjęcia produktu. Pole nieobowiązkowe. Pole importowane tylko w połączeniu ze znacznikiem Zdjecie_glowne_opis.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Status</td>\r\n			<td>Określa czy produkt ma być włączony czy wyłączony - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Nazwa_produktu</td>\r\n			<td>Określa nazwę produktu. Jest to pole wielojęzyczne. Nazwa nagłówka bez dodatkowych oznaczeń językowych powoduje dodanie nazwy i przypisanie jej do domyślnego języka. Jeżeli ma być dodana nazwa np do języka angielskiego należy zastosować nazwę nagłówka w postaci Nazwa_produktu_en. Jeżeli sklep jest wielojęzyczny należy dodać nazwę we wszystkich językach czyli muszą być nagłówki: Nazwa_produktu oraz Nazwa_produktu_en</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Dodatkowa_nazwa_produktu</td>\r\n			<td>Dodatkowa informacja dodawana do nazwy produktu przy eksporcie do porównywarek. Nazwa nagłówka bez dodatkowych oznaczeń językowych powoduje dodanie nazwy i przypisanie jej do domyślnego języka. Jeżeli ma być dodana nazwa np do języka angielskiego należy zastosować nazwę nagłówka w postaci Dodatkowa_nazwa_produktu_en. Jeżeli sklep jest wielojęzyczny należy dodać nazwę we wszystkich językach czyli muszą być nagłówki: Dodatkowa_nazwa_produktu oraz Dodatkowa_nazwa_produktu_en</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Opis</td>\r\n			<td>Określa opis produktu. Podobnie jak w przypadku nazwy produktu jest to pole wielojęzyczne. Nagłówek opisu do wersji angielskiej będzie miał nazwę: Opis_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Opis_krotki</td>\r\n			<td>Określa krótki opis produktu. Pole wielojęzyczne. Wersja angielska Opis_krotki_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Meta_tytul</td>\r\n			<td>Określa tytuł produktu w meta tagach. Pole wielojęzyczne. Wersja angielska Meta_tytul_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Meta_opis</td>\r\n			<td>Określa opis produktu w meta tagach. Pole wielojęzyczne. Wersja angielska Meta_opis_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Meta_slowa</td>\r\n			<td>Określa słowa kluczowe produktu w meta tagach. Pole wielojęzyczne. Wersja angielska Meta_slowa_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Stary_URL</td>\r\n			<td>Określa link do produktu w poprzednim sklepie (w innym oprogramowaniu)</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Jednostka_miary</td>\r\n			<td>Określa jednostkę miary produktu. To pole jest również wielojęzyczne. Wersja angielska Jednostka_miary_en. Sklep przy imporcie sprawdzi czy dana jednostka jest w bazie sklepu (wielkość liter w nazwie ma znaczenie ! - np szt. i Szt. będą w sklepie traktowane jako osobne jednostki). Jeżeli danej jednostki nie ma w bazie zostanie ona dodana. Nazwę należy podawać w formie tekstowej np: szt. Nowa jednostki jest dodawana z typem pola ilości - wartości całkowite (możliwość kupowania tylko w wartościach całkowitych - po imporcie w słownikach jednostek miar można zmienić tą wartość).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Dostepnosc</td>\r\n			<td>Określa dostępność produktu. Jest to pole wielojęzyczne. Wersja angielska ma postać Dostepnosc_en. Podobnie jak przy jednostce miary sklep sprawdzi przy imporcie czy dana dostępność znajduje się w słownikach dostępności - jeżeli nie - zostanie dodana (wielkość liter w nazwie ma znaczenie !). Nowo dodana dostępność będzie dodawana jako tryb ręczny. Jeżeli importowany produkt ma mieć dostępność automatyczną to pole musi mieć wartość: AUTOMATYCZNY</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Termin_wysylki</td>\r\n			<td>Określa termin wysyłki produktu. Przy imporcie sklep sprawdzi czy podany termin wysyłki znajduje się w słownikach sklepu. Jeżeli sklep nie znajdzie terminu wysyłki w słowniku - to do produktu nie zostanie dodany termin wysyłki. W przeciwieństwie do w/w pól nowy termin nie zostanie dodany do słownika sklepu jeżeli nie zostanie znaleziony w słowniku - przez to nagłówek nie jest wielojęzyczny.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Stan_produktu</td>\r\n			<td>Określa stan produktu. Jest to pole wielojęzyczne. Wersja angielska ma postać Stan_produktu_en. Podobnie jak przy terminie wysyłki sklep sprawdzi przy imporcie czy dany stan produktu znajduje się w słownikach - jeżeli nie - zostanie dodany do słownika i przypisany do produktu (wielkość liter w nazwie ma znaczenie !).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Gwarancja</td>\r\n			<td>Określa gwarancję produktu. Jest to pole wielojęzyczne. Wersja angielska ma postać Gwarancja_en. Podobnie jak przy stanie produktu sklep sprawdzi przy imporcie czy dana nazwa gwarancji znajduje się w słownikach - jeżeli nie - zostanie dodana do słownika i przypisana do produktu (wielkość liter w nazwie ma znaczenie !).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Rodzaj_produktu</td>\r\n			<td>Określa rodzaj produktu - dostępne formy słowo: standard, indywidualny, usluga, online (wielkość liter w nazwie oraz brak polskich znaków ma znaczenie !)</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Producent</td>\r\n			<td>Określa producenta produktu. Przy imporcie sklep sprawdzi czy jest dany producent w bazie sklepu (wielkość liter w nazwie ma znaczenie !). Jeżeli nie ma to zostanie dodany do bazy.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Waluta</td>\r\n			<td>Określa walutę produktu. Pole musi zawierać kod waluty zgodny ze słownikiem walut w sklepie - menu <strong>Konfiguracja / Słowniki / Waluty</strong> - np PLN czy EUR. Jeżeli produkt jest dodawany podczas importu i nie będzie posiadał zdefiniowanego tego nagłówka zostanie do produktu przypisana domyślna waluta sklepu.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Link_kanoniczny</td>\r\n			<td>Określa link kanoniczny produktu. Sam adres produktu - np moj-produkt-p-1.html - bez adresu sklepu z http:\\\\</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Tagi_szukania</td>\r\n			<td>Określa tagi produktu. Słowa / frazy rozdzielone przecinkiem.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Zdjecie_dodatkowe_x</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęć dodatkowych do produktu. Znak x trzeba zastąpić numerem zdjęcia, czyli: Zdjecie_dodatkowe_1, Zdjecie_dodatkowe_2 itd.&nbsp; Zapis (ścieżki i nazwy katalogów) podobny jak w przypadku zdjęcia głównego. Można dodać maksymalnie 10 dodatkowych zdjęć poprzez plik CSV - czyli maksymalna wartość to: Zdjecie_dodatkowe_10. W przypadku aktualizacji produktu wszystkie dodatkowe zdjęcia produktu są usuwane i dodawane do bazy nowe wg pliku CSV (tylko jeżeli plik CSV zawiera dane o dodatkowych zdjęciach).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Zdjecie_dodatkowe_opis_x</td>\r\n			<td>Określa tytuł (dla znacznika alt/title) dodatkowego zdjęcia produktu. Znak x trzeba zastąpić numerem zdjęcia, czyli: Zdjecie_dodatkowe_opis_1, Zdjecie_dodatkowe_opis_2 itd Pole nieobowiązkowe. Pole importowane tylko w połączeniu ze znacznikiem Zdjecie_dodatkowe_x.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Dodatkowa_zakladka_x_nazwa<br />\r\n			Dodatkowa_zakladka_x_opis</td>\r\n			<td>Określa nazwę oraz opis dodatkowej zakładki do produktu. Znak x trzeba zastąpić numerem zakładki - dopuszczalne wartości 1,2,3 lub 4. Pole jest wielojęzyczne. Wersja angielska to: Dodatkowa_zakladka_x_nazwa_en oraz&nbsp; Dodatkowa_zakladka_x_opis_en. Oba pola - nazwa oraz opis są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał zakładkę,</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Link_x_nazwa<br />\r\n			Link_x_url<br />\r\n			Link_x_opis</td>\r\n			<td>Określa link do produktu (do zakładki Linki). Znak x trzeba zastąpić numerem linku - dopuszczalne wartości 1,2,3 lub 4. Pola Link_x_nazwa oraz Link_x_opis są wielojęzyczne. Wersja angielska Link_x_nazwa_en oraz Link_x_opis_en. Pola nazwa i url są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał link.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Plik_x_nazwa<br />\r\n			Plik_x_plik<br />\r\n			Plik_x_opis<br />\r\n			Plik_x_logowanie</td>\r\n			<td>Określa plik do pobrania (do zakładki Do pobrania). Znak x trzeba zastąpić numerem pliku - dopuszczalne wartości 1,2,3,4 lub 5. Pola Plik_x_nazwa oraz Plik_x_opis są wielojęzyczne. Wersja angielska Plik_x_nazwa_en oraz Plik_x_opis_en. Pola nazwa i plik są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał plik. Pole Plik_x_logowanie określa czy plik ma być dostępny dla klientów niezalogowanych - dostępne formy słowo: tak lub nie. Pole Plik_x_plik określa ścieżkę oraz nazwę pliku. Pliki do pobrania muszą być wgrywane do katalogu /pobieranie. Czyli ścieżka musi wyglądać np tak: pobieranie/nazwa_pliku.zip</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Plik_elektroniczny_x_nazwa<br />\r\n			Plik_elektroniczny_x_plik</td>\r\n			<td>Określa plik do sprzedaży w formie elektronicznej. Do produktu można przypisać pliki, które klient będzie mógł pobrać po zakupie produktu w formie elektronicznej. Znak x trzeba zastąpić numerem pliku - dopuszczalne wartości od 1 do 10. Przy pomocy pliku csv można przypisać do produktu maksymalnie 10 plików. Oba pola są wielojęzyczne - tzn że mogą być osobne pliki dla języka polskiego i innych języków. Wersja angielska Plik_elektroniczny_x_nazwa_en oraz Plik_elektroniczny_x_plik_en. Pola nazwa i plik są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał plik. Pliki do pobrania muszą być wgrywane do katalogu /pobieranie. Czyli ścieżka musi wyglądać np tak: pobieranie/nazwa_pliku.zip</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Youtube_x_nazwa<br />\r\n			Youtube_x_url<br />\r\n			Youtube_x_opis<br />\r\n			Youtube_x_szerokosc<br />\r\n			Youtube_x_wysokosc</td>\r\n			<td>Określa film Youtube (do zakładki Klipy filmowe). Znak x trzeba zastąpić numerem filmu - dopuszczalne wartości 1,2,3 lub 4. Pola Youtube_x_nazwa oraz Youtube_x_opis są wielojęzyczne. Wersja angielska Youtube_x_nazwa_en oraz Youtube_x_opis_en. Pola nazwa i url są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał film. Przy dodawaniu adresu URL należy wkleić tylko nr id filmu, np. z linku http://www.youtube.com/watch?v=BvtXXXAF8 będzie to BvtXXXAF8. Pola szerokość i wysokość są to pola liczbowe (tylko liczby bez dodatkowych znaków).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Film_x_nazwa<br />\r\n			Film_x_plik<br />\r\n			Film_x_opis<br />\r\n			Film_x_ekran<br />\r\n			Film_x_szerokosc<br />\r\n			Film_x_wysokosc</td>\r\n			<td>Określa film w formacie FLV (do zakładki Klipy filmowe). Znak x trzeba zastąpić numerem filmu - dopuszczalne wartości 1,2,3 lub 4. Pola Film_x_nazwa oraz Film_x_opis są wielojęzyczne. Wersja angielska Film_x_nazwa_en oraz Film_x_opis_en. Pola nazwa i plik są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał film. Film_x_plik określa scieżkę oraz nazwę pliku filmu. Pliki muszą się znajdować w katalogu w którym są przechowywane zdjęcia do produktów. - dlatego podobnie jak w przypadku zdjęcia głównego do produktu - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa filmu to przyklad.flv. Wartość w polu pliku musi być podana jako przyklad.flv, a nie jako obrazki/przyklad.flv. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki. Pole Film_x_ekran określa czy film może być odtwarzany na pełnym ekranie - dostępne formy słowo: tak lub nie. Pola szerokość i wysokość są to pola liczbowe (tylko liczby bez dodatkowych znaków).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Nazwa_mp3_x<br />\r\n			Plik_mp3_x</td>\r\n			<td>Określa plik Mp3 (do zakładki Muzyka). Znak x trzeba zastąpić numerem pliku. W pliku CSV maksymalnie można dodać do 15 plików Mp3. Oba pola są powiązane ze sobą powiązane podczas importu - muszą być oba aby sklep dodał plik muzyczny do produktu. Plik_mp3_x określa ścieżkę oraz nazwę pliku muzycznego. Pliki muszą się znajdować w katalogu w którym są przechowywane zdjęcia do produktów. - dlatego podobnie jak w przypadku zdjęcia głównego do produktu - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa filmu to przyklad.mp3. Wartość w polu pliku musi być podana jako przyklad.mp3, a nie jako obrazki/przyklad.mp3. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cecha_nazwa_x<br />\r\n			Cecha_wartosc_x<br />\r\n			Cecha_cena_x<br />\r\n			Cecha_waga_x</td>\r\n			<td>Określa cechę (atrybut) produktu. Znak x trzeba zastąpić numerem. W pliku CSV może być maksymalnie do 100 cech. Czyli maksymalna wartość to Cecha_nazwa_100. Pola Cecha_nazwa_x oraz Cecha_wartosc_x są wielojęzyczne. Wersja angielska Cecha_nazwa_x_en oraz Cecha_wartosc_x_en. Pola nazwa oraz wartość są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał cechę do produktu. Przy imporcie sklep sprawdza czy dana cecha - jej nazwa oraz wartość są już w bazie cech. Jeżeli nie ma to cecha lub wartość zostanie dodana (wielkość liter w nazwie ma znaczenie !). Cena cechy zapisywana jest w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Waga cechy jest również zapisywana w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 4 miejsc po przecinku). Pola ceny i wagi są opcjonalne - cecha przy produkcie nie musi mieć wagi oraz ceny. Jeżeli cena cechy ma mieć wartość ujemną należy podać wartość ze znakiem minusa. W przypadku aktualizacji produktu wszystkie cechy produktu są usuwane i dodawane do bazy nowe wg pliku CSV (tylko jeżeli plik CSV zawiera dane o cechach). Ceny cech są uwzględniane tylko w przypadku jeżeli cena produktu jest obliczana wg wartości cech i nie są definiowane końcowe ceny dla poszczególnych wartości kombinacji cech produktu.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Dodatkowe_pole_x_nazwa<br />\r\n			Dodatkowe_pole_x_wartosc</td>\r\n			<td>Określa dodatkowe pole do produktu. Znak x trzeba zastąpić numerem. W pliku CSV może być maksymalnie do 100 dodatkowych pól do produktu. Czyli maksymalna wartość to Dodatkowe_pola_100_nazwa. Oba pola są wielojęzyczne. W wersji angielskiej do nazwy pola trzeba dodać _en. Pole nazwa oraz wartość są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał pole do produktu. Przy imporcie sklep sprawdza czy dane pole jest już w bazie sklepu. Jeżeli nie ma to dodatkowe pole zostanie dodane do słownika dodatkowych pól&nbsp;- zostanie przypisane do języka domyślnego sklepu (wielkość liter w nazwie ma znaczenie !). W przypadku aktualizacji produktu wszystkie dodatkowe pola produktu są usuwane i dodawane do bazy nowe wg pliku CSV (tylko jeżeli plik CSV zawiera dane o dodatkowych pola produktu).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Akcesoria_x_nr_katalogowy</td>\r\n			<td>Określa nr katalogowe produktów przypisanych do produktu jako akcesoria dodatkowe. Znak x trzeba zastąpić numerem, czyli: Akcesoria_1_nr_katalogowy , Akcesoria_2 _nr_katalogowy itd.&nbsp; Można dodać maksymalnie 50 produktów (jako akcesoria dodatkowe) poprzez plik CSV - czyli maksymalna wartość to: Akcesoria_50_nr_katalogowy. W przypadku aktualizacji produktu wszystkie akcesoria dodatkowe dla danego produktu są usuwane i dodawane do bazy nowe wg pliku CSV (tylko jeżeli plik CSV zawiera dane o akcesoriach dodatkowych).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Allegro_id_kategoria</td>\r\n			<td>Określa nr id kategorii Allegro dla aukcji Allegro. Jest to pole numeryczne - id kategorii w formie liczbowej, np 12345</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Allegro_nazwa_produktu</td>\r\n			<td>Określa nazwę produktu dla aukcji Allegro.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Allegro_zdjecie</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęcia produktu dla aukcji Allegro - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia produktu to produkt.jpg. Wartość musi być podana jako produkt.jpg, a nie jako obrazki/produkt.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.<br />\r\n			<br />\r\n			Podczas importu sklep doda do bazy wyłącznie nazwę zdjęcia wraz ze ścieżką. Żeby zdjęcie wyświetlało się w sklepie musi zostać wgrane do miejsca gdzie będzie wskazywała ścieżka zdjęcia. Import danych CSV nie importuje zdjęć produktów.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Allegro_cena</td>\r\n			<td>Określa cenę produktu brutto dla aukcji Allegro w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Allegro_opis</td>\r\n			<td>Określa opis produktu dla aukcji Allegro.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Nagłówki kategorii produktów:</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Kategoria_x_nazwa</td>\r\n			<td>Określa nazwę kategorii. Jest to pole wielojęzyczne. W wersji angielskiej do nazwy pola trzeba dodać _en.&nbsp; Plik CSV może zawierać maksymalnie do 10 kategorii - tzn drzewo kategorii produktu może być do maksymalnie 10 podkategorii.<br />\r\n			<br />\r\n			Dla przykładu: produkt będzie znajdował się w kategorii - Odzież / Męska / Bluzy / Zielone<br />\r\n			<br />\r\n			W pliku CSV musi być taki zapis:<br />\r\n			<span style=\"font-family:couriernew,courier,monospace;\">Kategoria_1_nazwa;Kategoria_2_nazwa;Kategoria_3_nazwa;Kategoria_4_nazwa<br />\r\n			Odzież;Męska;Bluzy;Zielone</span><br />\r\n			<br />\r\n			Numer 1 zamiast x oznacza nazwę głównej kategorii, kolejne numery do kolejne podkategorie dla głównej kategorii.<br />\r\n			<br />\r\n			Przy imporcie sklep sprawdza czy dana kategoria znajduje się już w bazie. Jeżeli nie ma to zostanie dodana do bazy sklepu (wielkość liter w nazwie ma znaczenie !).<br />\r\n			<br />\r\n			Ten nagłówek jest wymagany, żeby kategoria została zaimportowana.<br />\r\n			<br />\r\n			<strong>Poprzez plik CSV można przypisać produkt tylko do jednej kategorii. Przy eksporcie jest także zapisywana tylko jedna - główna - kategoria produktu. Nie są zapisywane wszystkie kategorie do jakich należy produkt.</strong></td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kategoria_x_opis</td>\r\n			<td>Określa opis kategorii. Pole jest również wielojęzyczne. W wersji angielskiej do nazwy pola trzeba dodać _en. Podobnie jak w przypadku nazwy kategorii numer 1 zamiast x oznacza główną kategorię, kolejne numery do podkategorie dla głównej kategorii.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kategoria_x_zdjecie</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęcia kategorii - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia kategorii to kategoria.jpg. Wartość musi być podana jako kategoria.jpg, a nie jako obrazki/kategoria.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kategoria_x_meta_tytul</td>\r\n			<td>Określa tytuł kategorii w meta tagach. Pole wielojęzyczne. Wersja angielska Kategoria_x_meta_tytul_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kategoria_x_meta_opis</td>\r\n			<td>Określa opis kategorii w meta tagach. Pole wielojęzyczne. Wersja angielska Kategoria_x_meta_opis_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kategoria_x_meta_slowa</td>\r\n			<td>Określa słowa kluczowe kategorii w meta tagach. Pole wielojęzyczne. Wersja angielska Kategoria_x_meta_slowa_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kategoria_x_adres_url</td>\r\n			<td>Określa nazwę kategorii do wygenerowania linku SEO. Pole wielojęzyczne. Wersja angielska Kategoria_x_adres_url_en.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kategorie_id</td>\r\n			<td>Określa ID kategorii do jakich należy produkt. ID kategorii są rozdzielone przecinkami. Pole to jest alternatywne dla w/w pól kategorii i podczas <u><strong>aktualizacji</strong></u> umożliwia przypisanie produktu do <strong>wielu kategorii</strong>. Wymienione w znaczniku ID muszą się pokrywać z ID kategoriami w sklepie.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\nPrzy imporcie produktów pola kategorii - opis, zdjecie, tytul meta, opis meta oraz slowa meta - są uzględnianie tylko jeżeli kategoria jest dodawana do sklepu (nie ma takiej kategorii w sklepie). Jeżeli produkt jest aktualizowany lub dodawany - a kategoria w sklepie już istnieje w/w pola są pomijane. W takim przypadku do produktu jest przypisywane id kategorii już istniejącej w sklepie. Pol są używane zarówno przy aktualizacji jak i dodawaniu samych kategorii (bez produktów - przy tworzeniu drzewa kategorii produktów).</div>\r\n"),
("205","826","1","instrukcja","Import kategorii poprzez CSV","<div style=\"text-align:justify;\">Sklep umożliwia import samych <strong>kategorii</strong> produktów. Zanim zostaną do sklepu dodane produkty można przygotować sam plik kategorii wraz z opisami, meta tagami oraz definicją zdjęć kategorii. Takie rozwiązanie pozwoli na ograniczenie wielkości pliku importu produktów (nie będzie musiał zawierać pozostałych pól kategorii oprócz nazw kategorii do jakich mają być przypisane produkty).<br />\r\n<br />\r\nDo przygotowania pliku importu kategorii trzeba wykorzystać nagłówki kategorii opisane w instrukcji w pozycji Struktura plików CSV. Najlepszym sposobem zaprezentowania importu będzie przedstawienie przykładu pliku. Poniżej przedstawiamy przykład pliku importu <strong>nowych</strong> kategorii (ponieważ w jednej linii nie zmieszczą się wszystkie dane każda kolumna jest wyświetlana w osobnym wierszu - poprawny zapis to pozycja;pozycja;pozycja itd)<br />\r\n<br />\r\n-------------------------- wiersz nr 1 z definicjami nagłówków kolumn ---------------------<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Kategoria_1_nazwa;<br />\r\nKategoria_1_nazwa_en;<br />\r\nKategoria_1_opis;<br />\r\nKategoria_1_zdjecie;<br />\r\nKategoria_1_opis_en;<br />\r\nKategoria_2_nazwa;<br />\r\nKategoria_2_nazwa_en</span><br />\r\n<br />\r\n-------------------------- wiersz nr 2 z danymi ---------------------<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">&quot;Odzież&quot;;<br />\r\n<span class=\"short_text\" id=\"result_box\" lang=\"en\"><span class=\"hps\">&quot;Clothing&quot;</span></span>;<br />\r\n&quot;Tutaj prezentujemy sprzedawaną przez nas odzież&quot;;<br />\r\n&quot;kategorie/odziez.jpg&quot;;<br />\r\n<span class=\"short_text\" id=\"result_box\" lang=\"en\"><span class=\"hps\">&quot;Here</span> <span class=\"hps\">we present the</span> <span class=\"hps\">clothing</span> <span class=\"hps\">sold by</span> <span class=\"hps\">us</span><span>&quot;;<br />\r\n&quot;Męska&quot;;</span></span><br />\r\n<span class=\"short_text\" id=\"result_box\" lang=\"en\"><span class=\"hps\">&quot;Men</span></span></span>&quot;<br />\r\n<br />\r\nW podanym przykładzie do sklepu zostaną dodane 2 kategorie (tylko jeżeli w sklepie nie będą istniały importowane kategorie). Główna o nazwie <strong>Odzież</strong> oraz podkategoria o nazwie <strong>Męska</strong>. Dodatkowo do głównej kategorii zostanie dodany opis oraz zdjęcie. Obie kategorie zostaną dodane w polskiej i angielskiej wersji językowej. W podkategorii zostanie dodana tylko nazwa, bez opisu, zdjęcia itd - ponieważ nie ma pól definiujących te wartości. Do pliku można dodać także inne pola z kategorii, np meta tagi lub dodać opis do każdej kategorii. Przy imporcie wymaganym nagłówkiem jest wyłącznie nazwa - pozostałe nagłówki są opcjonalne i nie są wymagane do importu kategorii.<br />\r\n<br />\r\nNajprostszy import kategorii będzie wyglądał tak jak poniżej w zapisie tekstowym oraz w arkuszu kalkulacyjnym.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/csv_kategorie.jpg\" style=\"width:500px;height:82px;margin-bottom:15px;margin-right:15px;\" /><span style=\"font-family:couriernew,courier,monospace;\">Kategoria_1_nazwa;</span><span style=\"font-family:couriernew,courier,monospace;\">Kategoria_2_nazwa;</span><span style=\"font-family:couriernew,courier,monospace;\">Kategoria_3_nazwa;</span><span style=\"font-family:couriernew,courier,monospace;\">Kategoria_4_nazwa</span><br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">&quot;Odzież&quot;;&quot;Męska&quot;;&quot;Bluzy&quot;;&quot;Zielona</span>&quot;<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">&quot;Odzież&quot;;&quot;Damska&quot;;&quot;Bluzki&quot;;</span><br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">&quot;Aparaty&quot;;&quot;Cyfrowe&quot;;;</span><br />\r\n<br />\r\nW podanym przykładzie zostaną dodane kategorie w postaci:<br />\r\n<br />\r\nOdzież / Męska / Bluzy / Zielona<br />\r\nOdzież / Damska / Bluzki<br />\r\nAparaty / Cyfrowe<br />\r\n<br />\r\nJak widać pierwsza pozycja ma trzy podkategorie, druga dwie, a trzecia tylko jedną. W przypadku drugiej kategorii pole Kategoria_4_nazwa pozostało puste, w przypadku trzeciej pozycji puste pozostały pola z nagłówków 3 i 4. W pliku importu pola mogą pozostawać puste jeżeli nie są konieczne lub nie mają wartości. Część kategorii może mieć opis, a część nie - podobnie z zdjęciami czy meta tagami.<br />\r\n<br />\r\nMając przygotowany plik importu kategorii można dokonać importu poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików CSV</strong>. W oknie po lewej stronie należy wybrać plik do importu (lub wgrać jeżeli pliku nie ma na liście). Następnie należy wybrać <strong>separator pól</strong> (jakim znakiem są rozdzielone kolumny w pliku), zaznaczyć w <strong>zakresie importu</strong> - tylko <strong>kategorie</strong>. Rodzaj importu - <strong>dodawanie danych</strong>. Po wciśnięciu przycisku <strong>Importuj dane CSV</strong> rozpocznie się proces importu. Sam proces importu można trwać od kilku sekund do kilkunastu minut - w zależności od ilości danych. Nie wolno przerywać procesu importu, gdyż spowoduje to uszkodzenie danych.<br />\r\n<br />\r\nW podobny sposób można dokonać<strong> aktualizacji</strong> kategorii (podczas rodzaju importu trzeba wybrać - aktualizacja danych). Podczas aktualizacji można zmodyfikować opis, zdjęcie kategorii, meta tagi oraz nazwy kategorii w innych językach. Nie można zmienić nazwy kategorii w języku domyślnym - ponieważ sklep wyszukuje kategorię do aktualizacji po tej właśnie nazwie. W przykładzie poniżej została dodana kolumna z opisem kategorii.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/csv_kategorie_aktualizacja.jpg\" style=\"width:600px;height:82px;margin-bottom:15px;margin-right:15px;float:left;\" />Po imporcie takiego pliku w kategorii Aparaty zostanie dodany opis kategorii.</div>\r\n\r\n<div style=\"clear:both\">&nbsp;</div>\r\n\r\n<div style=\"text-align:justify;\"><span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> W przypadku importu pliku CSV zalecamy wykonanie kopii aktualnej bazy danych (menu <strong>Narzędzia / Archiwizacja danych</strong>). Dzięki temu w przypadku niepowodzenia importu lub błędów w pliku importu będzie można przywrócić wprowadzone wcześniej dane bez ich utraty.</div>\r\n"),
("206","827","1","instrukcja","Import produktów poprzez CSV","<div style=\"text-align:justify;\">Do przygotowania pliku importu produktów trzeba wykorzystać nagłówki produktów opisane w instrukcji w pozycji Struktura plików CSV. Plik do importu może zawierać różne nagłówki / kolumny. W przypadku dodawania produktów plik może być bardziej lub mniej złożony. Każdy plik musi zawierać <strong>numer katalogowy</strong> produktu - bez tego produkt nie będzie dodany do sklepu.<br />\r\n<br />\r\nPoniżej przedstawiamy najprostszy plik importu <strong>nowego</strong> produktu (w formacie tekstowym oraz widok w arkuszu kalkulacyjnym):</div>\r\n<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Nr_katalogowy;Nazwa_produktu;Ilosc_produktow;Cena_brutto;Zdjecie_glowne;Kategoria_1_nazwa;Kategoria_2_nazwa<br />\r\n&quot;ABC123&quot;;&quot;Aparat fotograficzny&quot;;&quot;1&quot;;&quot;145.00&quot;;&quot;aparaty/aparat.jpg&quot;;&quot;Aparaty&quot;;&quot;Cyfrowe&quot;<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/csv_produkt.jpg\" style=\"width:750px;height:50px;\" /></span><br />\r\n<br />\r\nJest to najprostsza struktura pliku CSV, która doda do sklepu nowy produkt.<br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\">Do sklepu zostanie dodany produkt o nazwie <strong>Aparat fotograficzny</strong>, numerze katalogowym <strong>ABC123</strong>. Ilość produktów w magazynie zostanie określona na <strong>1</strong>, cena brutto na <strong>145.00 zł</strong> (zostanie przyjęta domyślna waluta sklepu). Do produktu zostanie przypisane zdjęcie znajdujące się w katalogu głównym zdjęć produktów w podkatalogu <strong>aparaty/aparat.jpg</strong>. Produkt będzie widoczny w kategorii <strong>Aparaty / Cyfrowe</strong>. Jeżeli w sklepie nie istnieje kategoria Aparaty lub podkategoria Cyfrowe - zostaną one utworzone. Jeżeli plik nie zawiera kolumny ze statusem produktu - zostanie on dodany jako <strong>wyłączony</strong>.<br />\r\n<br />\r\nPodany przykład jest najmniej skomplikowanym przykładem dodawania nowego produktu. Oczywiście można dodać kolejne kolumny z danymi wg Struktury plików CSV. Np mogą to być kolumny:<br />\r\n<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Waga;Nowosc;Status;Opis;Producent<br />\r\n&quot;5&quot;;&quot;tak&quot;;&quot;tak&quot;;&quot;Jest to najnowszy aparat fotograficzny&quot;;&quot;Canon&quot;</span><br />\r\n<br />\r\nW podanym przykładzie jeżeli zostaną dodane do przykładowego pliku CSV w/w kolumny to dodatkowo produkt zostanie zaimportowany z <strong>wagą</strong>, jako <strong>nowość</strong>, ze statusem <strong>włączony</strong>, <strong>opisem</strong> oraz przypisany do producenta <strong>Canon</strong>.<br />\r\n<br />\r\nPrzy dodawaniu produktu jest także istotne aby plik zawierał kategorię do jakiej będzie przypisany produkt. Plik może być tak przygotowany, że przy imporcie nastąpi także dodanie nowych kategorii lub kategorie mogą zostać dodane wcześniej osobnym plikiem CSV, a przy imporcie produktów nastąpi tylko wskazanie do jakiej kategorii będzie przypisany produkt. Poprzez pliki CSV można przypisać produkt tylko do jednej kategorii. Jeżeli dodawany produkt nie będzie miał określonych nagłówków z kategoriami - zostanie dodany - ale bez przypisania do kategorii nie będzie wyświetlany w sklepie (można po imporcie ręcznie w edycji produktu przypisać kategorie).<br />\r\n<br />\r\nPrzy dodawaniu produktu można wykorzystać dowolne z dostępnych nagłówków danych. W pliku CSV nie muszą mieć one określonej kolejności, kolumny mogą mieć dowolną kolejność.<br />\r\n<br />\r\nJeżeli nowo dodawany produkt ma mieć cechy (atrybuty) można wykorzystać nagłówki cech, dla przykładu dodawany, który produkt będzie miał cechę: Rozmiar w opcjach L i XL, a opcja XL będzie zwiększała cenę produktu o 10 zł. Do pliku CSV w tym przypadku trzeba dodać:<br />\r\n<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Cecha_nazwa_1;Cecha_wartosc_1;Cecha_cena_1<br />\r\n&quot;Rozmiar&quot;;&quot;L&quot;;&quot;0&quot;<br />\r\n&quot;Rozmiar&quot;;&quot;XL&quot;;&quot;10&quot;</span><br />\r\n<br />\r\nJeżeli produkt będzie miał dwie cechy - oprócz podanego wyżej rozmiaru dodatkowo Kolor: zielony oraz niebieski (który nie będzie miał wpływu na wartość produktu) trzeba dodać:<br />\r\n<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Cecha_nazwa_1;Cecha_wartosc_1;Cecha_cena_1;Cecha_nazwa_2;Cecha_wartosc_2<br />\r\n&quot;Rozmiar&quot;;&quot;L&quot;;&quot;0&quot;;&quot;Kolor&quot;;&quot;zielony&quot;<br />\r\n&quot;Rozmiar&quot;;&quot;XL&quot;;&quot;10&quot;;&quot;Kolor&quot;;&quot;niebieski&quot;</span><br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/csv_cechy_produktu.jpg\" style=\"width:520px;margin-right:15px;margin-bottom:15px;float:left;height:48px;\" />W arkuszu kalkulacyjnym będzie to wyglądało tak jak obok na zdjęciu. W podobny sposób można dodać do produktu dodatkowe zdjęcia, dodatkowe pola, zakładki, przypisać pliki do pobrania i wiele innych. Oczywiście czym więcej danych tym plik staje się mniej czytelny - jednak odczytanie i obróbka w arkuszu kalkulacyjnym ułatwia edycję - dobrze przygotowany plik CSV pozwala na dodanie wielu produktów z pełnymi danymi w krótkim czasie - bez konieczności ręcznego dodawania każdego produktu w sklepie.<br />\r\n<br />\r\nW przypadku jeżeli sklep jest wielojęzyczny zalecamy dodawanie danych w pliku we wszystkich językach (nagłówki z rozszerzeniem _en w przypadku języka angielskiego). Jeżeli zostaną dodane dane tylko w języku domyślnym to po przełączeniu na inny język w sklepie cześć danych może być źle wyświetlana lub niewidoczna.<br />\r\n<br />\r\nMając przygotowany plik importu produktów można dokonać importu poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików CSV</strong>. W oknie po lewej stronie należy wybrać plik do importu (lub wgrać jeżeli pliku nie ma na liście). Następnie należy wybrać <strong>separator pól</strong> (jakim znakiem są rozdzielone kolumny w pliku), zaznaczyć w <strong>zakresie importu</strong> - <strong>produkty i kategorie</strong>. Rodzaj importu - <strong>dodawanie danych</strong>. Po wciśnięciu przycisku <strong>Importuj dane CSV</strong> rozpocznie się proces importu. Sam proces importu można trwać od kilku sekund do kilkunastu minut - w zależności od ilości danych. Nie wolno przerywać procesu importu, gdyż spowoduje to uszkodzenie danych.<br />\r\n<br />\r\nW przypadku <strong>aktualizacji</strong> produktów sam plik może być dużo mniejszy - tzn może zawierać dużo mniej kolumn. Aby zaktualizować dane produktów podczas rodzaju importu trzeba wybrać - <strong>aktualizacja danych</strong>. Jeżeli mają być zaktualizowane tylko ceny produktów wystarczy, że plik CSV będzie miał dwie kolumny:<br />\r\n<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Nr_katalogowy;Cena_brutto<br />\r\n&quot;ABC&quot;;&quot;100&quot;<br />\r\n&quot;CBD&quot;;&quot;200&quot;<br />\r\n&quot;DFD&quot;:&quot;300&quot;</span><br />\r\n<br />\r\nW podanym powyżej przykładzie zostaną w sklepie zaktualizowane trzy produkty o numerach katalogowych ABC, CBD i DFD. Zostaną w produktach zmienione ceny brutto. Jeżeli dodatkowo miałby być zmieniony stan magazynowy można dodać kolumnę ilości:<br />\r\n<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Nr_katalogowy;Cena_brutto;Ilosc_produktu<br />\r\n&quot;ABC&quot;;&quot;100&quot;;&quot;10&quot;<br />\r\n&quot;CBD&quot;;&quot;200&quot;;&quot;4&quot;<br />\r\n&quot;DFD&quot;:&quot;300&quot;;&quot;6&quot;</span><br />\r\n<br />\r\nW podobny sposób można zaktualizować zdjęcia, opisy i inne dowolne dane zgodne ze strukturą nagłówków plików CSV.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> W przypadku importu pliku CSV zalecamy wykonanie kopii aktualnej bazy danych (menu <strong>Narzędzia / Archiwizacja danych</strong>). Dzięki temu w przypadku niepowodzenia importu lub błędów w pliku importu będzie można przywrócić wprowadzone wcześniej dane bez ich utraty.</div>\r\n"),
("207","828","1","instrukcja","Aktualizacja danych cech produktów","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/cechy_stany_magazynowe.jpg\" style=\"width:620px;height:151px;margin-left:15px;margin-bottom:15px;float:right;\" />Poprzez pliki CSV można w sklepie zaktualizować stany magazynowe poszczególnych cech produktów oraz ich dostępności. Jeżeli w sklepie jest włączone powiązanie cech produktów z magazynem sklepu każda kombinacja cech produktu (jako kombinacja będą dalej nazywane cechy gdyż stan magazynowy nie dotyczy jednej cechy, a danej kombinacji np Kolor zielony - Rozmiar XL) ma indywidualny stan magazynowy. Dzięki temu modułowi można dokonać szybkiej aktualizacji stanów magazynowych. Jeżeli cechy nie są powiązane z magazynem można zmienić tylko dostępność cech.<br />\r\n<br />\r\nDodatkowo jeżeli cechy w produkcie są ustalane końcowo dla danej kombinacji cech - w liście wyświetlane są pola umożliwiające wpisanie końcowej wartości ceny netto oraz brutto produktu dla danej kombinacji cech produktu.<br />\r\n<br />\r\nAby można było dokonać aktualizacji stanów magazynowych, dostępności cech oraz cen każda kombinacja cech musi posiadać unikalny <strong>numer katalogowy</strong> - musi on być unikalny dla całej bazy - dla wszystkich produktów - nie tylko dla danego produktu. Na obrazku powyżej pokazany jest przykład cech produktu - każda kombinacja cech ma podaną ilość w magazynie oraz dostępność. Przy każdej jest także wpisany numer katalogowy. Wg tego numeru będą aktualizowane stany. Jeżeli kombinacje cech nie będą miały numerów katalogowych - aktualizacja nie będzie mogła być wykonana.<br />\r\n<br />\r\nPliki CSV służące do aktualizacji dostępności oraz ilości w magazynie muszą zawierać odpowiednie nagłówki. Są one inne niż w przypadku importu produktów. W przypadku importu produktów można zaimportować cechy do produktu - ale nie można dodać stanów magazynowych. Wynika to z tego, że przy imporcie produktu nie da się wprowadzić kombinacji cech.<br />\r\n<br />\r\nNagłówki muszą być zawsze zawarte w pierwszej linii pliku CSV. Bez poprawnych nagłówków kolumn sklep nie będzie widział gdzie ma zaimportować dane z poszczególnych kolumn arkusza. Poniżej opisane są nagłówki jakie mogą być zastosowane podczas aktualizacji. W nagłówkach bardzo ważny jest zapis oraz wielkość liter. Zamiana np znaku _ na spację lub małych liter na duże i odwrotnie spowoduje, że nagłówek nie zostanie odczytany. Jeżeli plik importu / aktualizacji będzie zawierał dodatkowo inne nagłówki - zostaną one pominięte podczas importu.<br />\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Nagłówki cech produktów:</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Nr_katalogowy_cechy</td>\r\n			<td>Określa numer katalogowy kombinacji cech - jest to <strong>główny nagłówek</strong> każdego pliku aktualizacji cech produktów. Bez tego nagłówka żadna cecha nie zostanie zaktualizowana.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Ilosc_produktow</td>\r\n			<td>Określa stan magazynowy dalej kombinacji cech w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Dostepnosc</td>\r\n			<td>Określa dostępność danej kombinacji cech. Przy aktualizacji sklep sprawdzi czy dana dostępność znajduje się w słownikach dostępności - jeżeli nie - zostanie dodana (wielkość liter w nazwie ma znaczenie !). Nowo dodana dostępność będzie dodawana jako tryb ręczny. Jeżeli dana kombinacja cech ma mieć dostępność automatyczną to pole musi mieć wartość: AUTOMATYCZNY</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Zdjecie</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęcia dla danej kombinacji cech - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia produktu to produkt.jpg. Wartość musi być podana jako produkt.jpg, a nie jako obrazki/produkt.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.<br />\r\n			<br />\r\n			Podczas importu sklep doda do bazy wyłącznie nazwę zdjęcia wraz ze ścieżką. Żeby zdjęcie wyświetlało się w sklepie musi zostać wgrane do miejsca gdzie będzie wskazywała ścieżka zdjęcia. Import danych CSV nie importuje zdjęć produktów.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_brutto_cechy</td>\r\n			<td>Określa cenę produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Jest to cena dla danej kombinacji cech produktu. Parametr ceny jest OPCJONALNY i uwzględniany tylko w przypadku jeżeli cena produktu jest ustalana indywidualnie dla poszczególnych kombinacji cech produktu.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Cena_brutto_cechy_x</td>\r\n			<td>Określa kolejne ceny produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Znak x trzeba zastąpić numerem ceny, czyli: Cena_brutto_cechy_2, Cena_brutto_cechy_3 itd - w zależności ile w sklepie włączonych jest poziomów cen (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia dla hurtowni</strong>). Jest to cena dla danej kombinacji cech produktu. Parametr ceny jest OPCJONALNY i uwzględniany tylko w przypadku jeżeli cena produktu jest ustalana indywidualnie dla poszczególnych kombinacji cech produktu.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>\r\n<br />\r\nŻeby zaktualizować kombinacje cech pokazane na grafice powyżej trzeba przygotować plik w postaci:<br />\r\n<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">Nr_katalogowy_cechy;Ilosc_produktow;Dostepnosc<br />\r\n&quot;ABC12&quot;;&quot;3&quot;;&quot;Dostępny&quot;<br />\r\n&quot;ABC13&quot;;&quot;6&quot;;&quot;AUTOMATYCZNY&quot;</span><br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">&quot;ABC14&quot;;&quot;1&quot;;&quot;Niedostępny&quot;</span><br />\r\n&nbsp;\r\n<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/cechy_stany_magazynowe_aktualizacja.jpg\" style=\"width:500px;height:120px;margin-bottom:15px;margin-right:15px;float:left;\" />Zaimportowany plik zaktualizuje stany magazynowe oraz dostępności trzech kombinacji cech o numerach katalogowych <strong>ABC12, ABC13, ABC14</strong>. Po imporcie dane będą wyglądały jak na obrazku obok.<br />\r\n<br />\r\nPlik CSV może zawierać tylko dane stanu magazynowego, tylko dane dostępności dla kombinacji cech lub tylko ceny końcowe produktu dla danej kombinacji cech. Jeżeli importowana wartość będzie pusta (komórka w tabeli nie będzie miała wartości) to zostanie pominięta podczas importu.<br />\r\n<br />\r\nPodczas <strong>eksportu</strong> stanów magazynowych i dostępności cech w menu <strong>Narzędzia / Import i eksport danych / Obsługa plików CSV</strong> wygenerowany plik zawiera dodatkowo kolumny z nagłówkami: Nr_katalogowy, Nazwa_produktu oraz Nazwa_wartosc_cechy<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/csv_aktualizacja_cech_eksport.jpg\" style=\"width: 700px; height: 60px; margin-left: 15px; margin-top: 15px; margin-bottom: 15px; float: right;\" />Mają one za zadanie ułatwić orientacje w danych zawartych w pliku, same nagłówki z numerem katalogowym cech były mało czytelne. Dodatkowe znaczniki ułatwiają edycję pliku (rozpoznanie do jakiego produktu należy dana pozycja) i zmianę poszczególnych parametrów (ilości i dostępności). Nagłówki te mogą się również znajdować w pliku importu - podczas importu / aktualizacji zostaną pominięte, a pobrane do aktualizacji zostaną tylko trzy główne kolumny z nagłówkami wymienionymi powyżej.<br />\r\n<br />\r\nMając przygotowany plik aktualizacyjny można dokonać <strong>importu</strong> poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików CSV</strong>. W oknie po lewej stronie należy wybrać plik do importu (lub wgrać jeżeli pliku nie ma na liście). Następnie należy wybrać <strong>separator pól</strong> (jakim znakiem są rozdzielone kolumny w pliku), zaznaczyć w <strong>zakresie importu</strong> -<strong> tylko aktualizacja cech produktów</strong>. Rodzaj importu zostanie automatycznie zmieniony na - <strong>aktualizacja danych</strong>. Po wciśnięciu przycisku <strong>Importuj dane CSV</strong> rozpocznie się proces aktualizacji. Sam proces importu można trwać od kilku sekund do kilkunastu minut - w zależności od ilości danych. Nie wolno przerywać procesu importu, gdyż spowoduje to uszkodzenie danych.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> W przypadku importu pliku CSV zalecamy wykonanie kopii aktualnej bazy danych (menu <strong>Narzędzia / Archiwizacja danych</strong>). Dzięki temu w przypadku niepowodzenia importu lub błędów w pliku importu będzie można przywrócić wprowadzone wcześniej dane bez ich utraty.</div>\r\n"),
("208","830","0","instrukcja","Pliki XML",""),
("209","831","1","instrukcja","Obsługa plików XML","<div style=\"text-align:justify;\"><img alt=\"alt\" src=\"obrazki/pomoc/obsluga_xml.jpg\" style=\"width: 580px; height: 379px; margin-left: 15px; margin-right: 15px; float: right;\" />Eksportu oraz importu produktów oraz kategorii poprzez pliki XML można dokonać poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików XML</strong>. Po wejściu w menu zostaną wyświetlone okna w których poszczególne opcje umożliwiają import oraz eksport danych poprzez pliki XML.<br />\r\n<br />\r\nLewa strona dotyczy <strong>importu i aktualizacji danych</strong> - jest ona zbliżona do działania obsługi plików CSV. W oknie znajduje się lista plików z których można dokonać importu. Są to pliki, które znajdują się w katalogu /import na serwerze. Pliki do importu można wgrać do katalogu bezpośrednio poprzez połączenie z serwerem (ftp) lub można wykorzystać opcję wgrywania plików, która znajduje się na dole po prawej stronie.<br />\r\n<br />\r\nAby wgrać nowy plik należy wcisnąć przycisk <strong>Przeglądaj</strong>. Po tym otworzy się okno w którym zostaną wyświetlone pliki z Państwa komputera. W oknie trzeba wybrać plik, który ma zostać wgrany oraz wcisnąć przycisk <strong>Wgraj wybrany plik</strong>. Sklep rozpocznie wgrywanie pliku - po poprawnym wgraniu wyświetli się on w oknie listy plików opisanym powyżej. Maksymalna wielkość pliku jaki można wgrać poprzez moduł sklepu to 15MB (lub mniej jeżeli ograniczenie ma serwer na którym znajduje się sklep). Czas wgrywania pliku zależy od jego wielkości - nie wolno przerywać procesu wgrywania, gdyż spowoduje to uszkodzenie pliku.<br />\r\n<br />\r\nDodatkową opcją w porównaniu z plikami CSV jest możliwość importu danych z zewnętrznego pliku XML. Pod listą plików XML znajdujących się na serwerze - w ostatniej pozycji - znajduje się pole do wpisania zewnętrznego adresu sklepu. Trzeba wpisać kompletny adres do pliku (z http) - np http://www.sklep.pl/pliki/import.xml Dane do importu zostaną pobrane z pliku, który znajduje się w innej lokalizacji niż sklep i dodane do sklepu. Opcja ta działa dużo wolniej (szczególnie przy dużej ilości produktów) niż pobieranie danych z pliku XML znajdującego się na serwerze (sklep musi pobierać dane z innego adresu co jest dużo wolniejsze) - dlatego zalecamy dokonywanie importu z plików znajdujących się na serwerze.<br />\r\n<br />\r\nPliki z katalogu /import (niepotrzebne) można usunąć poprzez <strong>Przeglądarkę plików</strong> - menu <strong>Narzędzia / Przeglądarka plików</strong>.<br />\r\n<br />\r\nPoniżej listy plików do importu znajdują się opcje importu. Pierwsza pozycja to <strong>marża dla cen</strong>. W tym miejscu można wpisać o ile procent mają być podwyższone ceny produktów, które zostaną zaimportowane do sklepu. Jeżeli ceny mają pozostać bez zmian - pole należy pozostawić puste.<br />\r\n<br />\r\nKolejna pozycja to <strong>zakres importu</strong>. Możliwe opcje to <strong>import produktów i kategorii lub samych produktów</strong> (w zależności od danych zawartych w pliku -&nbsp; jeżeli zawiera tylko produkty zostaną zaimportowane tylko produkty, jeżeli zawiera kategorie i produkty - zostaną zaimportowane wszystkie dane). Kolejna opcja to <strong>tylko kategorie</strong> - z pliku zostaną pobrane i zaimportowane tylko kategorie. Ostatnia opcja to tylko <strong>aktualizacja stanów magazynowych i dostępności cech produktów</strong>. Służy ona wyłączenie do aktualizacji i przy tej opcji dane nie będą dodawane. W przypadku dwóch pierwszych opcji jest możliwe wybranie jako rodzaju importu <strong>dodawanie</strong> lub <strong>aktualizacja</strong> - w przypadku dodawania zostaną dodane nowe produkty, jeżeli nie będzie w bazie importowanego produktu o danym numerze katalogowym. W przypadku aktualizacji - jeżeli nie będzie produktu o danym numerze katalogowym - zostanie on pominięty.<br />\r\n<br />\r\n<img alt=\"alt\" src=\"obrazki/pomoc/postep_eksportu.jpg\" style=\"width:250px;height:37px;margin-right:15px;margin-bottom:15px;float:left;\" />W oknie po prawej stronie znajdują się opcje <strong>eksportu</strong>. W opcjach można zaznaczyć jakie dane mają zostać wyeksportowane oraz można wybrać czy mają być eksportowane wszystkie produkty lub tylko danego producenta czy wybranej kategorii. Po wybraniu odpowiedniej opcji i zakresu eksportowanych danych trzeba wcisnąć przycisk <strong>Eksportuj dane XML</strong>. Po tym nastąpi eksport danych (na ekranie zostanie wyświetlony pasek postępu). Po zakończeniu procesu eksportu zostanie wyświetlona informacja oraz nazwa pliku do jakiego zostały wyeksportowane dane. Nazwa pliku jest jednocześnie linkiem - kliknięcie w nazwę umożliwia pobranie pliku na dysk lokalny. Plik zostaje także zapisany na serwerze w katalogu /eksport.<br />\r\n<br />\r\n<span style=\"color:#FF0000;\"><strong>WAŻNE:</strong> Obsługa plików XML dotyczy formatu XML (struktury pliku) sklepu shopGold. Nie można przy pomocy tego modułu zaimportować dowolnego pliku XML - plik musi posiadać odpowiednią strukturę opisaną w instrukcji do sklepu. Moduł obsługi XML służy do wymiany danych pomiędzy sklepami shopGold lub dostawcami oferującymi XML zgodny ze strukturą sklepu. Do importu danych z innych formatów XML należy przygotować odpowiedni moduł.</span></div>\r\n"),
("210","832","1","instrukcja","Import kategorii poprzez XML","<div style=\"text-align:justify\"><img alt=\"\" src=\"obrazki/pomoc/xml_kategorie.jpg\" style=\"float:left; height:274px; margin-bottom:15px; margin-right:15px; width:600px\" />Sklep umożliwia import samych <strong>kategorii</strong> produktów poprzez plik XML. Poprzez plik można dodać kategorie wraz z opisami, meta tagami oraz definicją zdjęć kategorii. W przypadku plików XML trzeba osobno zaimportować kategorie (jeżeli mają mieć opisy, zdjęcia) i osobno produkty. W plikach CSV można przygotować jeden plik, który będzie zawierał zarówno kategorie wraz z opisami jak i produkty. W XML jeżeli mają zostać dodane kategorie wraz z opisami muszą być dwa osobne pliki - plik XML z kategoriami oraz plik XML z produktami, który zawiera tylko nazwę kategorii do jakiej będzie należał produkt (nie można dodać opisu kategorii, zdjęcia, meta tagów). Jeżeli jednak kategorie nie mają zawierać opisów, zdjęć, meta tagów to wystarczy przygotowanie jednego pliku produktów. Sklep przy dodawaniu produktów sprawdzi czy kategorie do których ma należeć istnieją - jeżeli nie to utworzy odpowiednie kategorie (jednak bez opisów, zdjęć).<br />\r\n<br />\r\nPoprzez pliki XML można zaimportować wyłącznie dane w języku domyślnym sklepu. Nie można dodać danych w innych językach.<br />\r\n<br />\r\nDo przygotowania pliku importu kategorii trzeba wykorzystać znaczniki kategorii opisane w instrukcji w pozycji Struktura plików XML. Powyżej na grafice przedstawiony jest przykładowy plik XML importu kategorii oraz sposób zapisu znaczników i danych. Plik musi się zaczynać od instrukcji sterującej, która zawiera informacje o wersji XML, z jakim jest zgodny oraz o sposobie kodowania polskich znaków. W dalszej części całość pliku musi być zawarta pomiędzy znacznikami <strong>&lt;(Kategorie)&gt; ,,,,,, &lt;(/Kategorie)&gt;</strong>. Każda kategoria musi znajdować się pomiędzy znacznikiem <strong>&lt;(Kategoria)&gt; ... &lt;(/Kategoria)&gt;</strong>. Pomiędzy znacznikiem kategorii mogą znajdować się inne znaczniki dotyczące poszczególnych elementów kategorii:</div>\r\n&nbsp;\r\n\r\n<div style=\"text-align: justify;\"><img alt=\"\" src=\"obrazki/pomoc/xml_kategorie_drzewo.jpg\" style=\"width: 350px; height: 386px; margin-bottom: 15px; margin-top:15px; margin-right: 15px; float: left;\" />Poprzez import kategorii XML można dodać do sklepu nieograniczoną ilość kategorii i każda z nich może mieć dowolną ilość podkategorii - sama głębokość drzewa kategorii nie może być większa niż 10. Podkategorie dla nadrzędnej kategorii muszą być umieszczone pomiędzy znacznikiem danej kategorii nadrzędnej. Najlepiej przedstawi to zamieszczona po lewej stronie grafika.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/xml_kategorie_drzewo_sklep.jpg\" style=\"width: 220px; height: 247px; float: right; margin-left: 15px; margin-bottom: 15px;\" />Zaimportowanie pliku w postaci przedstawionej na grafice spowoduje dodanie do sklepu sześciu kategorii, jednej głównej o nazwie <strong>Testowa nr 1</strong> i kolejnych jako podkategorii dla głównej. Jak będzie to wyglądało w sklepie przedstawiono na grafice po prawej stronie.<br />\r\n<br />\r\nPlik XML jest łatwiejszy do obróbki i bardziej czytelny niż plik CSV. Można w łatwy sposób zbudować skomplikowane drzewo kategorii. Oprócz nazw - tak ja w pokazanym po lewej przykładzie można dodać do każdej kategorii opis, zdjęcie i meta tagi.<br />\r\n<br />\r\nW przypadku plików XML bardzo ważna jest poprawność pliku, tzn poprawne nazwy znaczników oraz podomykane wszystkie znaczniki. Jeżeli w pliku rozpoczyna się znacznik np &lt;(Nazwa)&gt; to treści nazwy musi nastąpić zamknięcie poprzez &lt;(/Nazwa)&gt;. Jakikolwiek błąd w pliku może spowodować błędny proces importu i jego niepowodzenie.<br />\r\n<br />\r\nMając przygotowany plik importu kategorii można dokonać importu poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików XML</strong>. W oknie po lewej stronie należy wybrać plik do importu (lub wgrać jeżeli pliku nie ma na liście). Następnie należy&nbsp; zaznaczyć w <strong>zakresie importu</strong> - tylko <strong>kategorie</strong>. Rodzaj importu - <strong>dodawanie danych</strong>. Po wciśnięciu przycisku <strong>Importuj dane XML</strong> rozpocznie się proces importu. Sam proces importu można trwać od kilku sekund do kilkunastu minut - w zależności od ilości danych. Nie wolno przerywać procesu importu, gdyż spowoduje to uszkodzenie danych.<br />\r\n<br />\r\nW podobny sposób można dokonać<strong> aktualizacji</strong> kategorii (podczas rodzaju importu trzeba wybrać - aktualizacja danych). Podczas aktualizacji można zmodyfikować opis, zdjęcie kategorii, meta tagi. Nie można zmienić nazwy kategorii w języku domyślnym - ponieważ sklep wyszukuje kategorię do aktualizacji po tej właśnie nazwie.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> W przypadku importu pliku XML zalecamy wykonanie kopii aktualnej bazy danych (menu <strong>Narzędzia / Archiwizacja danych</strong>). Dzięki temu w przypadku niepowodzenia importu lub błędów w pliku importu będzie można przywrócić wprowadzone wcześniej dane bez ich utraty.</div>\r\n"),
("211","832","1","instrukcja","Struktura plików XML","<div style=\"text-align:justify;\">Pliki XML do poprawnego importu muszą mieć odpowiednią budowę. W plikach CSV są to nagłówki kolumn. W plikach XML są to odpowiednie <strong>znaczniki</strong> dzięki którym sklep wie gdzie ma dodać odpowiednie dane. Poniżej opisane są znaczniki jakie mogą być zastosowane podczas importu plików XML w sklepie. W nagłówkach bardzo ważny jest zapis oraz wielkość liter. Zamiana np znaku _ na spację lub małych liter na duże i odwrotnie spowoduje, że znacznik nie zostanie odczytany.<br />\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Znaczniki produktów (do importu produktów):</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>&lt;(Nr_katalogowy)&gt;</td>\r\n			<td>Określa numer katalogowy produktu - jest to <strong>główny znacznik</strong> każdego pliku importu produktów. Bez tego znacznika żaden produkt nie zostanie zaktualizowany lub dodany do sklepu. Cały import produktów w sklepie opiera się na numerach katalogowych, które muszą być unikalne dla każdego produktu. Po numerze katalogowym sklep rozpoznaje produkt i go aktualizuje - numer musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Kod_producenta)&gt;</td>\r\n			<td>Określa kod producenta produktu - kod musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Id_produktu_magazyn)&gt;</td>\r\n			<td>Określa id produktu w zewnętrznym programie magazynowym. Pole może być użyte do powiązania sklepu z programem magazynowym / fakturującym w którym produkty mają inne id niż w sklepie - kod musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Kod_ean)&gt;</td>\r\n			<td>Określa kod EAN produktu - kod musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Waga)&gt;</td>\r\n			<td>Określa wagę produktu w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 4 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Ilosc_produktow)&gt;</td>\r\n			<td>Określa ilość produktów w magazynie (ogólną ilość) w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Data_dostepnosci)&gt;</td>\r\n			<td>Określa datę dostępności produktu w formacie ROK-MIESIĄC-DZIEŃ - rok w pełnym formacie liczbowym - np 2017-07-15. Pole nieobowiązkowe. Tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Notatki_produktu)&gt;</td>\r\n			<td>Notatki właściciela sklepu do produktu (niewidoczne dla klientów sklepu). Pole nieobowiązkowe. Tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Sortowanie)&gt;</td>\r\n			<td>Określa kolejność wyświetlania produktu w listingach produktów w formacie liczbowym xx (liczba całkowita). Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Min_ilosc_zakupu)&gt;</td>\r\n			<td>Określa ilość produktów jaką można minimalnie zakupić. Ilość w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Opcje po przecinku należy stosować tylko jeżeli produkt można zakupić w formacie dziesiętnym. Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Max_ilosc_zakupu)&gt;</td>\r\n			<td>Określa ilość produktów jaką można maksymalnie zakupić. Ilość w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Opcje po przecinku należy stosować tylko jeżeli produkt można zakupić w formacie dziesiętnym. Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Przyrost_ilosci)&gt;</td>\r\n			<td>Określa jaką wielokrotność ilości jaką klient może zakupić, np podanie liczby 2 spowoduje, że klient będzie mógł zakupić tylko 2, 4, 6 itd szt.&nbsp;Ilość w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Opcje po przecinku należy stosować tylko jeżeli produkt można zakupić w formacie dziesiętnym. Pole nieobowiązkowe.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Kontrola_magazynu)&gt;</td>\r\n			<td>Określa czy produkt ma mieć kontrolę stanu magazynowego - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Gabaryt)&gt;</td>\r\n			<td>Określa czy produkt jest produktem gabarytowym - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Paczkomaty_gabaryt)&gt;</td>\r\n			<td>Określa rozmiar gabarytu paczkomatów dla produktu - dostępne formy duża litera: A, B lub C - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Paczkomaty_ilosc)&gt;</td>\r\n			<td>Określa ilość sztuk z paczce dla paczkomatu dla w/w gabarytu w formacie liczbowym xxxx (bez ułamków).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Podatek_Vat)&gt;</td>\r\n			<td>Określa stawkę podatku VAT w formacie liczbowym np 23 - jeżeli wpisana stawka podatku nie występuje w sklepie zostanie do produktu przypisana domyślna stawka podatku VAT.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_brutto)&gt;</td>\r\n			<td>Określa cenę produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_brutto_x)&gt;</td>\r\n			<td>Określa kolejne ceny produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Znak x trzeba zastąpić numerem ceny, czyli: &lt;(Cena_brutto_2)&gt;, &lt;(Cena_brutto_3)&gt; itd - w zależności ile w sklepie włączonych jest poziomów cen (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia dla hurtowni</strong>).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_zakupu)&gt;</td>\r\n			<td>Określa cenę zakupu produktu - format liczbowy xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_poprzednia)&gt;</td>\r\n			<td>Określa cenę jaka będzie wyświetlana w sklepie jako przekreślona (będzie to tylko wartość informacyjna obrazująca, że produkt tyle kosztował przed przeceną) - format liczbowy xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Jeżeli produkt jest dodawany jako promocja to pole jest wymagane.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_poprzednia_x)&gt;</td>\r\n			<td>Określa kolejne ceny poprzednie produktu w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Jeżeli produkt jest dodawany jako promocja to pole jest wymagane. Cena umożliwia ustawienie innych cen poprzednich dla różnych poziomów cen. Opcja używana jeżeli w sklepie jest włączone kilka poziomów cen produktów. Znak x trzeba zastąpić numerem ceny, czyli: &lt;(Cena_poprzednia_2)&gt;.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_katalogowa)&gt;</td>\r\n			<td>Określa cenę katalogową produktu - format liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Cena katalogowa nie jest wymagana.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_katalogowa_x)&gt;</td>\r\n			<td>Określa kolejne ceny katalogowe produktu w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Cena katalogowa nie jest wymagana. Cena umożliwia ustawienie innych cen katalogowych dla różnych poziomów cen. Opcja używana jeżeli w sklepie jest włączone kilka poziomów cen produktów. Znak x trzeba zastąpić numerem ceny, czyli: &lt;(Cena_katalogowa_2)&gt;.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Nowosc)&gt;</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak nowość - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Nasz_hit)&gt;</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak hit - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Polecany)&gt;</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak polecany - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Promocja)&gt;</td>\r\n			<td>Określa czy produkt będzie wyświetlany jak promocja - dostępne formy słowo: tak lub nie. Do tego pola konieczne jest wypełnienie pola ceny poprzedniej.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Do_porownywarek)&gt;</td>\r\n			<td>Określa czy produkt będzie eksportowany do porównywarek cen - dostępne formy słowo: tak lub nie. Opcja nie jest wymagana jeżeli w opcjach eksportu do porównywarek nie będzie wybrana opcja - tylko zaznaczone produkty.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Negocjacja)&gt;</td>\r\n			<td>Określa czy ma być możliwość negocjacji ceny produktu - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Darmowa_dostawa)&gt;</td>\r\n			<td>Określa czy produkt ma być objęty darmową wysyłką - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Wykluczona_darmowa_dostawa)&gt;</td>\r\n			<td>Określa czy produkt ma być wykluczony z darmowej wysyłki - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Zdjecie_glowne)&gt;</td>\r\n			<td>Określa ścieżkę oraz nazwę głównego zdjęcia produktu - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia produktu to produkt.jpg. Wartość musi być podana jako produkt.jpg, a nie jako obrazki/produkt.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.<br />\r\n			<br />\r\n			Podczas importu sklep doda do bazy wyłącznie nazwę zdjęcia wraz ze ścieżką. Żeby zdjęcie wyświetlało się w sklepie musi zostać wgrane do miejsca gdzie będzie wskazywała ścieżka zdjęcia. Import danych XML nie importuje zdjęć produktów.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Zdjecie_glowne_opis)&gt;</td>\r\n			<td>Określa tytuł (dla znacznika alt/title) głównego zdjęcia produktu. Pole nieobowiązkowe. Pole importowane tylko w połączeniu ze znacznikiem Zdjecie_glowne_opis - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Status)&gt;</td>\r\n			<td>Określa czy produkt ma być włączony czy wyłączony - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Nazwa_produktu)&gt;</td>\r\n			<td>Określa nazwę produktu - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Dodatkowa_nazwa_produktu)&gt;</td>\r\n			<td>Dodatkowa informacja dodawana do nazwy produktu przy eksporcie do porównywarek - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Opis)&gt;</td>\r\n			<td>Określa opis produktu - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Opis_krotki)&gt;</td>\r\n			<td>Określa krótki opis produktu - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Meta_tytul)&gt;</td>\r\n			<td>Określa tytuł produktu w meta tagach - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Meta_opis)&gt;</td>\r\n			<td>Określa opis produktu w meta tagach - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Meta_slowa)&gt;</td>\r\n			<td>Określa słowa kluczowe produktu w meta tagach - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Stary_URL)&gt;</td>\r\n			<td>Określa link do produktu w poprzednim sklepie (w innym oprogramowaniu)</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Jednostka_miary)&gt;</td>\r\n			<td>Określa jednostkę miary produktu. Sklep przy imporcie sprawdzi czy dana jednostka jest w bazie sklepu (wielkość liter w nazwie ma znaczenie ! - np szt. i Szt. będą w sklepie traktowane jako osobne jednostki). Jeżeli danej jednostki nie ma w bazie zostanie ona dodana. Nazwę należy podawać w formie tekstowej np: szt. Nowa jednostki jest dodawana z typem pola ilości - wartości całkowite (możliwość kupowania tylko w wartościach całkowitych - po imporcie w słownikach jednostek miar można zmienić tą wartość). Tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Dostepnosc)&gt;</td>\r\n			<td>Określa dostępność produktu. Podobnie jak przy jednostce miary sklep sprawdzi przy imporcie czy dana dostępność znajduje się w słownikach dostępności - jeżeli nie - zostanie dodana (wielkość liter w nazwie ma znaczenie !). Nowo dodana dostępność będzie dodawana jako tryb ręczny. Jeżeli importowany produkt ma mieć dostępność automatyczną to pole musi mieć wartość: AUTOMATYCZNY - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Termin_wysylki)&gt;</td>\r\n			<td>Określa termin wysyłki produktu. Przy imporcie sklep sprawdzi czy podany termin wysyłki znajduje się w słownikach sklepu. Jeżeli sklep nie znajdzie terminu wysyłki w słowniku - to do produktu nie zostanie dodany termin wysyłki. W przeciwieństwie do w/w pól nowy termin nie zostanie dodany do słownika sklepu jeżeli nie zostanie znaleziony w słowniku - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Stan_produktu)&gt;</td>\r\n			<td>Określa stan produktu. Podobnie jak przy terminie wysyłki sklep sprawdzi przy imporcie czy dany stan produktu znajduje się w słownikach - jeżeli nie - zostanie dodany do słownika i przypisany do produktu (wielkość liter w nazwie ma znaczenie !) - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Gwarancja)&gt;</td>\r\n			<td>Określa gwarancję produktu. Podobnie jak przy stanie produktu sklep sprawdzi przy imporcie czy dana nazwa gwarancji znajduje się w słownikach - jeżeli nie - zostanie dodana do słownika i przypisana do produktu (wielkość liter w nazwie ma znaczenie !) - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Rodzaj_produktu)&gt;</td>\r\n			<td>Określa rodzaj produktu - dostępne formy słowo: standard, indywidualny, usluga, online (wielkość liter w nazwie oraz brak polskich znaków ma znaczenie !) - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Producent)&gt;</td>\r\n			<td>Określa producenta produktu. Przy imporcie sklep sprawdzi czy jest dany producent w bazie sklepu (wielkość liter w nazwie ma znaczenie !). Jeżeli nie ma to zostanie dodany do bazy. Tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Waluta)&gt;</td>\r\n			<td>Określa walutę produktu. Pole musi zawierać kod waluty zgodny ze słownikiem walut w sklepie - menu <strong>Konfiguracja / Słowniki / Waluty</strong> - np PLN czy EUR. Jeżeli produkt jest dodawany podczas importu i nie będzie posiadał zdefiniowanego tego nagłówka zostanie do produktu przypisana domyślna waluta sklepu. Tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Link_kanoniczny)&gt;</td>\r\n			<td>Określa link kanoniczny produktu. Sam adres produktu - np moj-produkt-p-1.html - bez adresu sklepu z http:\\\\ - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Tagi_szukania)&gt;</td>\r\n			<td>Określa tagi produktu. Słowa / frazy rozdzielone przecinkiem - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Zdjecia_dodatkowe)&gt;<br />\r\n			&nbsp; &nbsp; &lt;(Zdjecie)&gt;<br />\r\n			<!--(Zdjecie)-->&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <zdjecie_link>...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <zdjecie_opis>....<br />\r\n			&nbsp; &nbsp; &lt;(/Zdjecie)&gt;...<!--(Zdjecie)--><br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Zdjecia_dodatkowe)&gt;</zdjecie_opis></zdjecie_link></td>\r\n			<td>Określa ścieżkę oraz nazwę i tytuł zdjęć dodatkowych do produktu. Wszystkie dodatkowe zdjęcia muszą być zawarte pomiędzy znacznikami &lt;(Zdjecia_dodatkowe)&gt; ..... &lt;(/Zdjecia_dodatkowe)&gt;<!--(Zdjecia_dodatkowe)-->. Każde zdjęcie musi być zawarte pomiędzy znacznikami &lt;(Zdjecie)&gt; ..... &lt;(/Zdjecie)&gt;<!--(Zdjecie)-->. Dodatkowo wewnątrz każdej zakładki są dodatkowe dwa znaczniki: ścieżka zdjęcia oraz tytuł (alt/title). Pole opisu nie jest obowiązkowe - tekst opisu musi być zawarty pomiędzy &lt;(![CDATA ... ]]. Pole opisu jest importowane tylko jeżeli jest podana ścieżka zdjęcia.&nbsp;Można dodać maksymalnie 10 dodatkowych zdjęć. W przypadku aktualizacji produktu wszystkie dodatkowe zdjęcia produktu są usuwane i dodawane do bazy nowe wg pliku XML (tylko jeżeli plik&nbsp; XML zawiera dane o dodatkowych zdjęciach).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Dodatkowe_zakladki)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Dodatkowa_zakladka)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Opis)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Dodatkowa_zakladka)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Dodatkowe_zakladki)&gt;</td>\r\n			<td>Określa nazwę oraz opis dodatkowej zakładki do produktu. Wszystkie dodatkowe zakładki muszą być zawarte pomiędzy znacznikami &lt;(Dodatkowe_zakladki)&gt; ..... &lt;(/Dodatkowe_zakladki)&gt;<!--(Dodatkowe_zakladki)-->. Każda zakładka musi być zawarta pomiędzy znacznikami &lt;(Dodatkowa_zakladka)&gt; ..... &lt;(/Dodatkowa_zakladka)&gt;<!--(Dodatkowa_zakladka)-->. Dodatkowo wewnątrz każdej zakładki muszą być dwa znaczniki: nazwy oraz opisu. Pola nazwa i opis są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał zakładkę. Tekst zawarty w tych znacznikach musi być&nbsp; zawarty pomiędzy &lt;(![CDATA ... ]] Można dodać maksymalnie 4 dodatkowe zakładki.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Linki)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Link)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Url)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Opis)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Link)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Linki)&gt;</td>\r\n			<td>Określa link do produktu (do zakładki Linki). Wszystkie linki muszą być zawarte pomiędzy znacznikami &lt;(Linki)&gt; ..... &lt;(/Linki)&gt;. Każdy link musi być zawarty pomiędzy znacznikami &lt;(Link)&gt; ..... &lt;(/Link)&gt;. Dodatkowo wewnątrz każdego linku są trzy znaczniki: nazwy, opisu oraz adresu url. Pola nazwa i url są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał link. Tekst zawarty w znacznikach nazwy i opisu musi być&nbsp; zawarty pomiędzy &lt;(![CDATA ... ]] Można dodać maksymalnie 4 linki.<br />\r\n			&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Pliki)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Plik)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Plik)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Opis)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Logowanie)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Plik)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Pliki)&gt;</td>\r\n			<td>Określa plik do pobrania (do zakładki Do pobrania). Wszystkie pliki muszą być zawarte pomiędzy znacznikami &lt;(Pliki)&gt; ..... &lt;(/Pliki)&gt;. Każdy plik musi być zawarty pomiędzy znacznikami &lt;(Plik)&gt; ..... &lt;(/Plik)&gt;. Dodatkowo wewnątrz każdego pliku są cztery znaczniki: nazwy, opisu, pliku oraz logowania. Pola nazwa i plik są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał plik. Tekst zawarty w znacznikach nazwy i opisu musi być&nbsp; zawarty pomiędzy &lt;(![CDATA ... ]] Można dodać maksymalnie 4 pliki. Pliki do pobrania muszą być wgrywane do katalogu /pobieranie. Czyli ścieżka musi wyglądać np tak: pobieranie/nazwa_pliku.zip. Znacznik logowania określa czy plik ma być dostępny dla klientów niezalogowanych &nbsp; - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Pliki_elektroniczne)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Plik_elektroniczny)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Plik)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Plik_elektroniczny)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Pliki_elektroniczne)&gt;</td>\r\n			<td>Określa plik do sprzedaży w formie elektronicznej. Do produktu można przypisać pliki, które klient będzie mógł pobrać po zakupie produktu w formie elektronicznej. Wszystkie pliki muszą być zawarte pomiędzy znacznikami &lt;(Pliki_elektroniczne)&gt; ..... &lt;(/Pliki_elektroniczne)&gt;. Każdy plik musi być zawarty pomiędzy znacznikami &lt;(Plik_elektroniczny)&gt; ..... &lt;(/Plik_elektroniczny)&gt;. Dodatkowo wewnątrz każdego pliku są dwa znaczniki: nazwy oraz pliku. Pola nazwa i plik są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał plik. Tekst zawarty w znaczniku nazwy musi być&nbsp; zawarty pomiędzy &lt;(![CDATA ... ]] Można dodać maksymalnie 10 plików. Pliki do pobrania muszą być wgrywane do katalogu /pobieranie. Czyli ścieżka musi wyglądać np tak: pobieranie/nazwa_pliku.zip.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Filmy_youtube)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Youtube)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Url)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Opis)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Szerokosc)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Wysokosc)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Youtube)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Filmy_youtube)&gt;</td>\r\n			<td>Określa film Youtube (do zakładki Klipy filmowe). Wszystkie filmy muszą być zawarte pomiędzy znacznikami &lt;(Filmy_youtube)&gt; ..... &lt;(/Filmy_youtube)&gt;. Każdy plik musi być zawarty pomiędzy znacznikami &lt;(Youtube)&gt; ..... &lt;(/Youtube)&gt;. Dodatkowo wewnątrz każdego filmu jest pięć znaczników: nazwy, url, opis, szerokość oraz wysokość filmu. Pola nazwa i url są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał film. Tekst zawarty w znacznikach nazwy, url oraz opisu musi być&nbsp; zawarty pomiędzy &lt;(![CDATA ... ]] Można dodać maksymalnie 4 filmy Youtube. Przy dodawaniu adresu URL należy wkleić tylko nr ID filmu, np. z linku http://www.youtube.com/watch?v=BvtXXXAF8 będzie to BvtXXXAF8. Pola szerokość i wysokość są to pola liczbowe (tylko liczby bez dodatkowych znaków).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Filmy)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Film)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Plik)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Opis)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Pelen_ekran)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Szerokosc)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Wysokosc)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Film)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Filmy)&gt;</td>\r\n			<td>Określa film w formacie FLV (do zakładki Klipy filmowe). Wszystkie filmy muszą być zawarte pomiędzy znacznikami &lt;(Filmy)&gt; ..... &lt;(/Filmy)&gt;. Każdy plik musi być zawarty pomiędzy znacznikami &lt;(Film)&gt; ..... &lt;(/Film)&gt;. Dodatkowo wewnątrz każdego filmu jest sześć znaczników: nazwy, plik, opis, ekran, szerokość oraz wysokość filmu. Pola nazwa i plik są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał film. Tekst zawarty w znacznikach nazwy oraz opisu musi być&nbsp; zawarty pomiędzy &lt;(![CDATA ... ]] Można dodać maksymalnie 4 filmy FLV. Znacznik &lt;(Plik)&gt; określa scieżkę oraz nazwę pliku filmu. Pliki muszą się znajdować w katalogu w którym są przechowywane zdjęcia do produktów. - dlatego podobnie jak w przypadku zdjęcia głównego do produktu - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa filmu to przyklad.flv. Wartość w polu pliku musi być podana jako przyklad.flv, a nie jako obrazki/przyklad.flv. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki. Znacznik &lt;(Pelen_ekran)&gt; określa czy film może być odtwarzany na pełnym ekranie - dostępne formy słowo: tak lub nie. Pola szerokość i wysokość są to pola liczbowe (tylko liczby bez dodatkowych znaków).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Pliki_mp3)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Plik_mp3)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Plik)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Plik_mp3)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Pliki_mp3)&gt;</td>\r\n			<td>Określa plik Mp3 (do zakładki Muzyka). Wszystkie pliki muzyczne muszą być zawarte pomiędzy znacznikami &lt;(Pliki_mp3)&gt; ..... &lt;(/Pliki_mp)&gt;. Każdy plik musi być zawarty pomiędzy znacznikami &lt;(Plik_mp3)&gt; ..... &lt;(/Plik_mp3)&gt;. Dodatkowo wewnątrz każdego pliku są dwa znaczniki: nazwa oraz plik. Pola nazwa i pliku są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał plik. Tekst zawarty w znaczniku nazwy musi być&nbsp; zawarty pomiędzy &lt;(![CDATA ... ]] Można dodać maksymalnie do 15 plików muzycznych mp3. Znacznik &lt;(Plik)&gt; określa ścieżkę oraz nazwę pliku muzycznego. Pliki muszą się znajdować w katalogu w którym są przechowywane zdjęcia do produktów. - dlatego podobnie jak w przypadku zdjęcia głównego do produktu - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa filmu to przyklad.mp3. Wartość w polu pliku musi być podana jako przyklad.mp3, a nie jako obrazki/przyklad.mp3. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cechy)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Cecha)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Wartosc)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Waga)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Cena)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Cecha)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Cechy)&gt;</td>\r\n			<td>Określa cechę (atrybut) produktu. Wszystkie cechy muszą być zawarte pomiędzy znacznikami &lt;(Cechy)&gt; ..... &lt;(/Cechy)&gt;. Każdy plik musi być zawarty pomiędzy znacznikami &lt;(Cecha)&gt; ..... &lt;(/Cecha)&gt;. Dodatkowo wewnątrz każdej cechy są cztery znaczniki: nazwa, wartość, waga oraz cena. Pola nazwa oraz wartość są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał cechę do produktu. Przy imporcie sklep sprawdza czy dana cecha - jej nazwa oraz wartość są już w bazie cech. Jeżeli nie ma to cecha lub wartość zostanie dodana (wielkość liter w nazwie ma znaczenie !). Cena cechy zapisywana jest w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Waga cechy jest również zapisywana w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 4 miejsc po przecinku). Pola ceny i wagi są opcjonalne - cecha przy produkcie nie musi mieć wagi oraz ceny. Jeżeli cena cechy ma mieć wartość ujemną należy podać wartość ze znakiem minusa. W przypadku aktualizacji produktu wszystkie cechy produktu są usuwane i dodawane do bazy nowe wg pliku XML (tylko jeżeli plik XML zawiera dane o cechach). Ceny cech są uwzględniane tylko w przypadku jeżeli cena produktu jest obliczana wg wartości cech i nie są definiowane końcowe ceny dla poszczególnych wartości kombinacji cech produktu.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Dodatkowe_pola)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Dodatkowe_pole)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Nazwa)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;(Wartosc)&gt;...<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(/Dodatkowe_pole)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&nbsp;&nbsp;&nbsp; ......<br />\r\n			&lt;(/Dodatkowe_pola)&gt;</td>\r\n			<td>Określa dodatkowe pole do produktu. Wszystkie cechy muszą być zawarte pomiędzy znacznikami &lt;(Dodatkowe_pola)&gt; ..... &lt;(/Dodatkowe_pola)&gt;. Każde dodatkowe pole musi być zawarte pomiędzy znacznikami &lt;(Dodatkowe_pole)&gt; ..... &lt;(/Dodatkowe_pole)&gt;. Dodatkowo wewnątrz każdego pola są dwa znaczniki: nazwa oraz wartość. Poprzez plik XML można dodać maksymalnie do 100 dodatkowych pól do produktu. Pole nazwa oraz wartość są ze sobą powiązane podczas importu - muszą być oba aby sklep dodał pole do produktu. Przy imporcie sklep sprawdza czy dane pole jest już w bazie sklepu. Jeżeli nie ma to dodatkowe pole zostanie dodane do słownika dodatkowych pól - zostanie przypisane do języka domyślnego sklepu (wielkość liter w nazwie ma znaczenie !). W przypadku aktualizacji produktu wszystkie dodatkowe pola produktu są usuwane i dodawane do bazy nowe wg pliku XML (tylko jeżeli plik XML zawiera dane o dodatkowych pola produktu).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Akcesoria)&gt;<br />\r\n			&nbsp;&nbsp;&nbsp; &lt;(Akcesoria_nr_katalogowy)&gt;...<br />\r\n			&lt;(/Akcesoria)&gt;</td>\r\n			<td>Określa nr katalogowe produktów przypisanych do produktu jako akcesoria dodatkowe. Wszystkie pozycje muszą być zawarte pomiędzy znacznikami &lt;(Akcesoria)&gt; ..... &lt;(/Akcesoria)&gt;.&nbsp; Każdy nr katalogowy musi być zawarty pomiędzy znacznikami &lt;(Akcesoria_nr_katalogowy)&gt; ..... &lt;(/Akcesoria_nr_katalogowy)&gt;<!--(Zdjecie)-->. Nr katalogowy musi być zawarty pomiędzy &lt;(![CDATA ... ]]. Można dodać maksymalnie 50 produktów (jako akcesoria dodatkowe). W przypadku aktualizacji produktu wszystkie akcesoria dodatkowe dla danego produktu są usuwane i dodawane do bazy nowe wg pliku XML (tylko jeżeli plik&nbsp; XML zawiera dane o akcesoriach dodatkowych).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Allegro_id_kategoria)&gt;</td>\r\n			<td>Określa nr id kategorii Allegro dla aukcji Allegro. Jest to pole numeryczne - id kategorii w formie liczbowej, np 12345</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Allegro_nazwa_produktu)&gt;</td>\r\n			<td>Określa nazwę produktu dla aukcji Allegro - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Allegro_zdjecie)&gt;</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęcia produktu dla aukcji Allegro - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia produktu to produkt.jpg. Wartość musi być podana jako produkt.jpg, a nie jako obrazki/produkt.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.<br />\r\n			<br />\r\n			Podczas importu sklep doda do bazy wyłącznie nazwę zdjęcia wraz ze ścieżką. Żeby zdjęcie wyświetlało się w sklepie musi zostać wgrane do miejsca gdzie będzie wskazywała ścieżka zdjęcia. Import danych CSV nie importuje zdjęć produktów.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Allegro_cena)&gt;</td>\r\n			<td>Określa cenę produktu brutto dla aukcji Allegro w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Allegro_opis)&gt;</td>\r\n			<td>Określa opis produktu dla aukcji Allegro - tekst musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Znacznik kategorii produktów (do imporcie produktów):</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>&lt;(Kategoria)&gt;</td>\r\n			<td>Określa nazwy kategorii do jakich będzie należał produkt. Poszczególne kategorie do jakich będzie przypisany produkt muszą być rozdzielone znakiem /<br />\r\n			<br />\r\n			Dla przykładu: Fotografia/Lustrzanki cyfrowe - produkt zostanie przypisany do kategorii Lustrzanki cyfrowe, która jest podkategorią do kategorii Fotografia.<br />\r\n			<br />\r\n			W przypadku dodawania produktów sklep sprawdza czy dana kategoria jest już w bazie sklepu (wielkość liter w nazwie ma znaczenie !). Jeżeli nie ma to kategoria zostanie dodana do sklepu (bez opisu, zdjęcia, meta tagów).<br />\r\n			<br />\r\n			Nazwy kategorii muszą być zawarte pomiędzy &lt;(![CDATA ... ]]<br />\r\n			<br />\r\n			<strong>Poprzez plik XML można przypisać produkt tylko do jednej kategorii. Przy eksporcie jest także zapisywana tylko jedna - główna - kategoria produktu. Nie są zapisywane wszystkie kategorie do jakich należy produkt.</strong></td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Kategorie_id)&gt;</td>\r\n			<td>Określa ID kategorii do jakich należy produkt. ID kategorii są rozdzielone przecinkami. Pole to jest alternatywne dla w/w pól kategorii i podczas <u><strong>aktualizacji</strong></u> umożliwia przypisanie produktu do <strong>wielu kategorii</strong>. Wymienione w znaczniku ID muszą się pokrywać z ID kategoriami w sklepie.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Znaczniki kategorii produktów (do importu kategorii):</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>&lt;(Nazwa)&gt;</td>\r\n			<td>Określa nazwę kategorii - treść musi być zawarta pomiędzy &lt;(![CDATA ... ]] - to pole jest wymagane, żeby kategoria została zaimportowana.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Zdjecie)&gt;</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęcia kategorii - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia kategorii to kategoria.jpg. Wartość musi być podana jako kategoria.jpg, a nie jako obrazki/kategoria.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Opis)&gt;</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęcia kategorii - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia kategorii to kategoria.jpg. Wartość musi być podana jako kategoria.jpg, a nie jako obrazki/kategoria.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki. Treść musi być zawarta pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Meta_Tytul)&gt;</td>\r\n			<td>Określa tytuł produktu w meta tagach - treść musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Meta_Opis)&gt;</td>\r\n			<td>Określa opis produktu w meta tagach - treść musi być zawarty pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Meta_Slowa)&gt;</td>\r\n			<td>Określa słowa kluczowe produktu w meta tagach - treść muszą być zawarte pomiędzy &lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Adres_Url)&gt;</td>\r\n			<td>Określa nazwę kategorii do wygenerowania linku SEO.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>\r\n"),
("212","833","1","instrukcja","Import produktów poprzez XML","<div style=\"text-align: justify;\"><img alt=\"\" src=\"obrazki/pomoc/xml_produkt.jpg\" style=\"width: 500px; height: 1390px; margin-right: 15px; float: left;\" />Do przygotowania pliku importu produktów trzeba wykorzystać znaczniki produktów opisane w instrukcji w pozycji Struktura plików XML. Plik do importu może zawierać różne znaczniki. W przypadku dodawania produktów plik może być bardziej lub mniej złożony. Każdy plik musi zawierać <strong>numer katalogowy</strong> produktu - bez tego produkt nie będzie dodany do sklepu. Po lewej stronie przedstawiony jest kompletny przykład pliku XML przy pomocy którego można dodać do sklepu nowy produkt.<br />\r\n<br />\r\nW pliku są zawarte wszystkie możliwe znaczniki jakie można użyć przy dodawaniu produktu - zgodnie z opisem struktury plików XML.<br />\r\n<br />\r\nWymaganym polem podczas dodawania produktu jest pole numeru katalogowego. Pozostałe pola są opcjonalne w zależności od potrzeb. Jednak każdy nowo dodawany produkt powinien posiadać nazwę, cenę, przypisanie do kategorii, status (włączony czy wyłączony) oraz ewentualnie stan magazynowy. Jest minimalna ilość pól do dodania produktu.<br />\r\n<br />\r\nPrzy dodawaniu produktu jest istotne aby plik zawierał kategorię do jakiej będzie przypisany produkt. Jeżeli dodawany produkt nie będzie miał określonych nagłówków z kategoriami - zostanie dodany - ale bez przypisania do kategorii nie będzie wyświetlany w sklepie (można po imporcie ręcznie w edycji produktu przypisać kategorie).<br />\r\n<br />\r\nMając przygotowany plik importu produktów można dokonać importu poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików XML</strong>. W oknie po lewej stronie należy wybrać plik do importu (lub wgrać jeżeli pliku nie ma na liście). Poniżej można ustawić marżę cen - tzn wpisać o ile procent mają być podwyższone ceny produktów, które zostaną zaimportowane do sklepu. Jeżeli ceny mają pozostać bez zmian - pole należy pozostawić puste. W kolejnym polu zaznaczyć w <strong>zakresie importu</strong> - <strong>produkty i kategorie</strong>. Rodzaj importu - <strong>dodawanie danych</strong>. Po wciśnięciu przycisku <strong>Importuj dane XML</strong> rozpocznie się proces importu. Sam proces importu można trwać od kilku sekund do kilkunastu minut - w zależności od ilości danych. Nie wolno przerywać procesu importu, gdyż spowoduje to uszkodzenie danych.<br />\r\n<br />\r\nW przypadku <strong>aktualizacji</strong> produktów sam plik może być dużo mniejszy - tzn może zawierać dużo mniej znaczników. Aby zaktualizować dane produktów podczas rodzaju importu trzeba wybrać - <strong>aktualizacja danych</strong>. Jeżeli mają być zaktualizowane tylko ceny produktów wystarczy, że plik XML będzie następująco:<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/xml_produkt_aktualizacja_ceny.jpg\" style=\"width: 370px; height: 92px; margin-top: 10px; margin-bottom: 10px;\" /><br />\r\nJeżeli dodatkowo miałby być zmieniony stan magazynowy można dodać kolumnę ilości:<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/xml_produkt_aktualizacja_ilosc.jpg\" style=\"width: 370px; height: 107px; margin-top: 10px; margin-bottom: 10px;\" /><br />\r\nW podobny sposób można zaktualizować zdjęcia, opisy i inne dowolne dane zgodne ze strukturą znaczników plików XML.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> W przypadku importu pliku XML zalecamy wykonanie kopii aktualnej bazy danych (menu <strong>Narzędzia / Archiwizacja danych</strong>). Dzięki temu w przypadku niepowodzenia importu lub błędów w pliku importu będzie można przywrócić wprowadzone wcześniej dane bez ich utraty.</div>\r\n"),
("213","834","1","instrukcja","Aktualizacja danych cech produktów","<div style=\"text-align: justify;\"><img alt=\"\" src=\"obrazki/pomoc/cechy_stany_magazynowe.jpg\" style=\"width: 620px; height: 151px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Poprzez pliki XML podobnie jak w przypadku plików CSV można w sklepie zaktualizować stany magazynowe poszczególnych cech produktów oraz ich dostępności. Jeżeli w sklepie jest włączone powiązanie cech produktów z magazynem sklepu każda kombinacja cech produktu (jako kombinacja będą dalej nazywane cechy gdyż stan magazynowy nie dotyczy jednej cechy, a danej kombinacji np Kolor zielony - Rozmiar XL) ma indywidualny stan magazynowy. Dzięki temu modułowi można dokonać szybkiej aktualizacji stanów magazynowych. Jeżeli cechy nie są powiązane z magazynem można zmienić tylko dostępność cech.<br />\r\n<br />\r\nDodatkowo jeżeli cechy w produkcie są ustalane końcowo dla danej kombinacji cech - w liście wyświetlane są pola umożliwiające wpisanie końcowej wartości ceny netto oraz brutto produktu dla danej kombinacji cech produktu.<br />\r\n<br />\r\nAby można było dokonać aktualizacji stanów magazynowych oraz dostępności cech każda kombinacja cech musi posiadać unikalny <strong>numer katalogowy</strong> - musi on być unikalny dla całej bazy - dla wszystkich produktów - nie tylko dla danego produktu. Na obrazku powyżej pokazany jest przykład cech produktu - każda kombinacja cech ma podaną ilość w magazynie oraz dostępność. Przy każdej jest także wpisany numer katalogowy. Wg tego numeru będą aktualizowane stany. Jeżeli kombinacje cech nie będą miały numerów katalogowych - aktualizacja nie będzie mogła być wykonana.<br />\r\n<br />\r\nPliki XML służące do aktualizacji dostępności oraz ilości w magazynie muszą zawierać odpowiednie znaczniki. Są one inne niż w przypadku importu produktów. W przypadku importu produktów można zaimportować cechy do produktu - ale nie można dodać stanów magazynowych. Wynika to z tego, że przy imporcie produktu nie da się wprowadzić kombinacji cech. Jeżeli plik importu / aktualizacji będzie zawierał dodatkowo inne znaczniki - zostaną one pominięte podczas importu. W znacznikach bardzo ważny jest zapis oraz wielkość liter. Zamiana np znaku _ na spację lub małych liter na duże i odwrotnie spowoduje, że znacznik nie zostanie odczytany.<br />\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Znaczniki cech produktów:</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>&lt;(Nr_katalogowy_cechy)&gt;</td>\r\n			<td>Określa numer katalogowy kombinacji cech - jest to <strong>główny znacznik</strong> każdego pliku aktualizacji cech produktów. Bez tego znacznika żadna cecha nie zostanie zaktualizowana - numer musi być zawarty pomiędzy <!--[CDATA ... ]]</td-->&lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Ilosc_produktow)&gt;</td>\r\n			<td>Określa stan magazynowy dalej kombinacji cech w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Dostepnosc)&gt;</td>\r\n			<td>Określa dostępność danej kombinacji cech. Przy aktualizacji sklep sprawdzi przy imporcie czy dana dostępność znajduje się w słownikach dostępności - jeżeli nie - zostanie dodana (wielkość liter w nazwie ma znaczenie !). Nowo dodana dostępność będzie dodawana jako tryb ręczny. Jeżeli importowany produkt ma mieć dostępność automatyczną to pole musi mieć wartość: AUTOMATYCZNY - tekst musi być zawarty pomiędzy <!--[CDATA ... ]]</td-->&lt;(![CDATA ... ]]</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Zdjecie)&gt;</td>\r\n			<td>Określa ścieżkę oraz nazwę zdjęcia dla danej kombinacji cech - ścieżka nie może zawierać nazwy głównego katalogu zdjęć. Dla przykładu - katalog w którym znajdują się wszystkie zdjęcia w sklepie nazywa się: obrazki. Nazwa zdjęcia produktu to produkt.jpg. Wartość musi być podana jako produkt.jpg, a nie jako obrazki/produkt.jpg. Sklep automatycznie sam dodaje nazwę głównego katalogu zdjęć do ścieżki.<br />\r\n			<br />\r\n			Podczas importu sklep doda do bazy wyłącznie nazwę zdjęcia wraz ze ścieżką. Żeby zdjęcie wyświetlało się w sklepie musi zostać wgrane do miejsca gdzie będzie wskazywała ścieżka zdjęcia. Import danych XML nie importuje zdjęć produktów.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_brutto_cechy)&gt;</td>\r\n			<td>Określa cenę produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Jest to cena dla danej kombinacji cech produktu. Parametr ceny jest OPCJONALNY i uwzględniany tylko w przypadku jeżeli cena produktu jest ustalana indywidualnie dla poszczególnych kombinacji cech produktu.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>&lt;(Cena_brutto_cechy_x)&gt;</td>\r\n			<td>Określa kolejne ceny produktu brutto w formacie liczbowym xxxx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku). Znak x trzeba zastąpić numerem ceny, czyli: Cena_brutto_cechy_2, Cena_brutto_cechy_3 itd - w zależności ile w sklepie włączonych jest poziomów cen (menu <strong>Konfiguracja / Konfiguracja sklepu / Ustawienia dla hurtowni</strong>). Jest to cena dla danej kombinacji cech produktu. Parametr ceny jest OPCJONALNY i uwzględniany tylko w przypadku jeżeli cena produktu jest ustalana indywidualnie dla poszczególnych kombinacji cech produktu.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\nŻeby zaktualizować kombinacje cech pokazane na grafice powyżej trzeba przygotować plik w postaci:<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/xml_aktualizacja_cech.jpg\" style=\"width: 420px; height: 261px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Zaimportowany plik zaktualizuje stany magazynowe oraz dostępności trzech kombinacji cech o numerach katalogowych <strong>ABC12, ABC13, ABC14</strong>.<br />\r\n<br />\r\nPlik XML może zawierać tylko dane stanu magazynowego, tylko dane dostępności dla kombinacji cech lub tylko ceny końcowe produktu dla danej kombinacji cech. Jeżeli importowana wartość będzie pusta to zostanie pominięta podczas importu.\r\n<div style=\"clear:both\">&nbsp;</div>\r\nPodczas <strong>eksportu</strong> stanów magazynowych i dostępności cech w menu <strong>Narzędzia / Import i eksport danych / Obsługa plików XML</strong> wygenerowany plik zawiera dodatkowo znaczniki &lt;(Nr_katalogowy)&gt;, &lt;(Nazwa_produktu)&gt; oraz &lt;(Nazwa_wartosc_cech)&gt;.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/xml_aktualizacja_cech_eksport.jpg\" style=\"width: 650px; height: 139px; margin-left: 15px; margin-top: 15px; margin-bottom:15px; float: right;\" />Mają one za zadanie ułatwić orientacje w danych zawartych w pliku, same pola z numerem katalogowym cech były mało czytelne. Dodatkowe znaczniki ułatwiają edycję pliku (rozpoznanie do jakiego produktu należy dana pozycja) i zmianę poszczególnych parametrów (ilości i dostępności). Znaczniki te mogą się również znajdować w pliku importu - podczas importu / aktualizacji zostaną pominięte, a pobrane do aktualizacji zostaną tylko trzy główne znaczniki wymienione powyżej.<br />\r\n<br />\r\nMając przygotowany plik aktualizacyjny można dokonać <strong>importu</strong> poprzez menu <strong>Narzędzia / Import i eksport danych / Obsługa plików XML</strong>. W oknie po lewej stronie należy wybrać plik do importu (lub wgrać jeżeli pliku nie ma na liście). W <strong>zakresie importu </strong>trzeba zaznaczyć -<strong> </strong><strong>tylko aktualizacja cech produktów</strong>. Rodzaj importu zostanie automatycznie zmieniony na - <strong>aktualizacja danych</strong>. Po wciśnięciu przycisku <strong>Importuj dane XML</strong> rozpocznie się proces aktualizacji. Sam proces importu można trwać od kilku sekund do kilkunastu minut - w zależności od ilości danych. Nie wolno przerywać procesu importu, gdyż spowoduje to uszkodzenie danych.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> W przypadku importu pliku XML zalecamy wykonanie kopii aktualnej bazy danych (menu <strong>Narzędzia / Archiwizacja danych</strong>). Dzięki temu w przypadku niepowodzenia importu lub błędów w pliku importu będzie można przywrócić wprowadzone wcześniej dane bez ich utraty.</div>\r\n"),
("214","835","0","instrukcja","Eksport i import klientów","<div style=\"text-align: justify;\"><img alt=\"\" src=\"obrazki/pomoc/obsluga_klientow.jpg\" style=\"width: 600px; height: 200px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Sklep oprócz importu i eksportu produktów umożliwia także import i eksport <strong>danych klientów</strong>. Import i eksport danych klientów oparty jest o pliki CSV.<br />\r\n<br />\r\nEksportu oraz importu klientów poprzez pliki CSV można dokonać poprzez menu <strong>Narzędzia / Import i eksport danych / Import i eksport klientów</strong>. Po wejściu w menu zostaną wyświetlone okna w których poszczególne opcje umożliwiają import oraz eksport danych klientów poprzez pliki CSV.<br />\r\n<br />\r\nLewa strona dotyczy <strong>importu danych</strong>. W oknie znajduje się lista plików z których można dokonać importu. Są to pliki, które znajdują się w katalogu /import na serwerze. Pliki do importu można wgrać do katalogu bezpośrednio poprzez połączenie z serwerem (ftp) lub można wykorzystać opcję wgrywania plików, która znajduje się na dole po prawej stronie.<br />\r\n<br />\r\nAby wgrać nowy plik należy wcisnąć przycisk <strong>Przeglądaj</strong>. Po tym otworzy się okno w którym zostaną wyświetlone pliki z Państwa komputera. W oknie trzeba wybrać plik, który ma zostać wgrany oraz wcisnąć przycisk <strong>Wgraj wybrany plik</strong>. Sklep rozpocznie wgrywanie pliku - po poprawnym wgraniu wyświetli się on w oknie listy plików opisanym powyżej. Maksymalne wielkość pliku jaki można wgrać poprzez moduł sklepu to 15MB (lub mniej jeżeli ograniczenie ma serwer na którym znajduje się sklep). Czas wgrywania pliku zależy od jego wielkości - nie wolno przerywać procesu wgrywania, gdyż spowoduje to uszkodzenie pliku.<br />\r\n<br />\r\nPliki z katalogu /import (niepotrzebne) można usunąć poprzez <strong>Przeglądarkę plików</strong> - menu <strong>Narzędzia / Przeglądarka plików</strong>.<br />\r\n<br />\r\nPoniżej listy plików do importu znajduje się opcja <strong>separatora pól</strong>. W tym miejscu trzeba wybrać jakim separatorem są oddzielone poszczególne kolumny w pliku. Domyślnie jest to średnik. W plikach CSV należy pamiętać, żeby jeżeli w importowanym tekście występuje znak separatora to cały tekst musi być ujęty w cudzysłowy - dokładny opis w poprzednim dziale Informacji ogólnych o plikach CSV.<br />\r\n<br />\r\nW przypadku importu klientów - sklep ma możliwość wyłączenie <strong>dodania</strong> nowych klientów. Poprzez import <strong>nie można zaktualizować</strong> danych klientów.<br />\r\n<br />\r\nW oknie po prawej stronie znajdują się opcje <strong>eksportu</strong>. Eksport danych do pliku odbywa się poprzez kliknięci w przycisk <strong>Eksportuj dane CSV</strong>. Po tym nastąpi eksport danych (na ekranie zostanie wyświetlony pasek postępu). Po zakończeniu procesu eksportu zostanie wyświetlona informacja oraz nazwa pliku do jakiego zostały wyeksportowane dane. Nazwa pliku jest jednocześnie linkiem - kliknięcie w nazwę umożliwia pobranie pliku na dysk lokalny. Plik zostaje także zapisany na serwerze w katalogu /eksport.</div>\r\n"),
("215","836","1","instrukcja","Struktura pliku importu CSV","<div style=\"text-align: justify;\">Podobnie jak w przypadku produktów, plik CSV przeznaczony do importu klientów musi mieć odpowiednie <strong>nagłówki</strong>. Nagłówki muszą być zawsze zawarte w pierwszej linii pliku CSV. Bez poprawnych nagłówków kolumn sklep nie będzie widział gdzie ma zaimportować dane z poszczególnych kolumn arkusza. Poniżej opisane są nagłówki jakie mogą być zastosowane podczas importu klientów. W nagłówkach bardzo ważny jest zapis oraz wielkość liter. Zamiana np znaku _ na spację lub małych liter na duże i odwrotnie spowoduje, że nagłówek nie zostanie odczytany. Jeżeli plik importu będzie zawierał dodatkowo inne nagłówki - zostaną one pominięte podczas importu.<br />\r\n<br />\r\n<span style=\"font-size:14px;\"><strong>Nagłówki importu CSV dla klientów:</strong></span><br />\r\n&nbsp;\r\n<table class=\"impeks\">\r\n	<tbody>\r\n		<tr>\r\n			<td>Nick</td>\r\n			<td>Nick klienta, podczas dodawania klienta sklep sprawdza czy dany Nick nie istnieje już w bazie (wielkość liter w nazwie ma znaczenie !) - jeżeli nie istnieje zostanie dodany, jeżeli Nick już jest przypisany do innego klienta - nie zostanie dodany. Nick w sklepie służy do logowania klienta.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>IdMagazyn</td>\r\n			<td>Unikalny id klienta w zewnętrznym programie magazynowym lub fakturującym. Pole może być użyte do powiązania sklepu z programem magazynowym / fakturującym w którym klienci mają inne id niż w sklepie. Pole nie jest wymagane - może zostać pominięte w imporcie danych klientów.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Imie</td>\r\n			<td>Imię klienta.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Nazwisko</td>\r\n			<td>Nazwisko klienta.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Adres_email</td>\r\n			<td>Adres e-mail klienta. Podczas dodawania klienta sklep sprawdza czy dany adres mailowy nie istnieje już w bazie (wielkość liter w nazwie ma znaczenie !) - jeżeli podany adres istnieje to klient <strong>nie zostanie dodany</strong> do sklepu. Ponieważ adres e-mail służy do logowania musi być unikalny w sklepie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Telefon</td>\r\n			<td>Telefon klienta.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Haslo</td>\r\n			<td>Hasło do konta klienta. Hasło powinno być zakodowane systemem MD5 (np 199336156adef16d71f6f6ca8d5b5aca:45). Jeżeli dane są importowane z innych systemów nie będzie można dopasować hasła do sklepu - nie będzie zgodne z systemem szyfrowania sklepu. Klient przy pierwszym logowaniu będzie musiał wygenerować nowe hasło. Jeżeli dane są importowane ze starszej wersji sklepu lub przenoszone z innego sklepu na tej samej platformie - hasła będą odczytywane poprawnie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Newsletter</td>\r\n			<td>Określa czy klient jest zapisany do newslettera - dostępne formy słowo: tak lub nie.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Znizka</td>\r\n			<td>Określa zniżkę klienta w formacie liczbowym xx.xx - separatorem dziesiętnym jest kropka (do 2 miejsc po przecinku).. Jeżeli klient ma zniżkę wartość musi być wpisana ze znakiem minusa.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Grupa_klientow</td>\r\n			<td>Nazwa grupy klientów (menu <strong>Sprzedaż / Klienci / Grupy klientów</strong>) do jakiej ma być przypisany klient (wielkość liter w nazwie ma znaczenie !). Jeżeli podana grupa nie istnieje w sklepie, klient zostanie przypisany do grupy podstawowej.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Status</td>\r\n			<td>Określa czy konto klienta ma być aktywne - dostępne formy słowo: aktywny lub nieaktywny.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Firma</td>\r\n			<td>Nazwa firmy klienta.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Nip</td>\r\n			<td>NIP firmy klienta.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Pesel</td>\r\n			<td>Numer PESEL.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Ulica</td>\r\n			<td>Ulica adresu zamieszkania klienta.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kod_pocztowy</td>\r\n			<td>Kod pocztowy adresu zamieszkania.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Miasto</td>\r\n			<td>Miasto adresu zamieszkania.</td>\r\n		</tr>\r\n		<tr>\r\n			<td>Kraj</td>\r\n			<td>Kraj adresu zamieszkania klienta. Jeżeli podany kraj nie istnieje w sklepie, jako kraj klienta zostanie przyjęty kraj domyślny sklepu.</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<br />\r\nDane klientów muszą być importowane w języku domyślnym sklepu.</div>\r\n"),
("216","837","1","instrukcja","Import klientów","<div style=\"text-align: justify;\">Do przygotowania pliku importu klientów trzeba wykorzystać nagłówki produktów opisane w instrukcji w pozycji Struktura pliku importu CSV. Plik do importu powinien zawierać wszystkie nagłówki (kolumny) jakie są opisane w strukturze. Inaczej dane klientów nie będą poprawne - np będzie brakowało adresów - dlatego trzeba przygotować plik ze wszystkimi danymi. Każdy plik musi zawierać adres <strong>e-mail</strong> klienta - bez tego klient nie będzie dodany do sklepu.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align: justify;\">Poniżej przedstawiamy przykładowy plik importu <strong>nowego</strong> klienta - w formacie tekstowym oraz widok w arkuszu kalkulacyjnym (ponieważ w jednej linii nie zmieszczą się wszystkie dane są one podzielone na linie - poprawny zapis to pozycja;pozycja;pozycja itd):</div>\r\n<br />\r\n-------------------------- wiersz nr 1 z definicjami nagłówków kolumn ---------------------<br />\r\n<span style=\"font-family:courier new,courier,monospace;\">Nick;Imie;Nazwisko;Adres_email;Telefon;Haslo;Newsletter;Znizka;Grupa_klientow;Status;<br />\r\nFirma;Nip;Pesel;Ulica;Kod_pocztowy;Miasto;Kraj</span><br />\r\n<br />\r\n-------------------------- wiersz nr 2 z danymi ---------------------<br />\r\n<span style=\"font-family:couriernew,courier,monospace;\">&quot;</span><span style=\"font-family:courier new,courier,monospace;\">Jack</span><span style=\"font-family:couriernew,courier,monospace;\">&quot;</span><span style=\"font-family:courier new,courier,monospace;\">;</span><span style=\"font-family:couriernew,courier,monospace;\">&quot;</span><span style=\"font-family:courier new,courier,monospace;\">Jacek</span><span style=\"font-family:couriernew,courier,monospace;\">&quot;</span><span style=\"font-family:courier new,courier,monospace;\">;</span><span style=\"font-family:couriernew,courier,monospace;\">&quot;</span><span style=\"font-family:courier new,courier,monospace;\">Krysiak;&quot;biuro@kamelia-net.pl&quot;;&quot;664-760-394&quot;;&quot;0c985d4f90747&quot;;&quot;nie&quot;;&quot;0.00&quot;;&quot;Podstawowa&quot;;<br />\r\n&quot;aktywny&quot;;&quot;Studio komputerowe KAMELIA-NET&quot;;&quot;888-002-25-34&quot;;&quot;&quot;;&quot;Letnia 28g&quot;;&quot;87-809&quot;;&quot;Włocławek&quot;;&quot;Polska&quot;</span><br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/klienci_arkusz.jpg\" style=\"width: 900px; height: 33px;\" />\r\n<div style=\"text-align: justify;\"><br />\r\nMając przygotowany plik importu klientów można dokonać importu poprzez menu <strong>Narzędzia / Import i eksport danych / Import i eksport klientów</strong>. W oknie po lewej stronie należy wybrać plik do importu (lub wgrać jeżeli pliku nie ma na liście). Następnie należy wybrać <strong>separator pól</strong> (jakim znakiem są rozdzielone kolumny w pliku). Po wciśnięciu przycisku <strong>Importuj dane CSV</strong> rozpocznie się proces importu. Sam proces importu można trwać od kilku sekund do kilkunastu minut - w zależności od ilości danych. Nie wolno przerywać procesu importu, gdyż spowoduje to uszkodzenie danych.<br />\r\n<br />\r\n<span style=\"color:#ff0000;\"><strong>WAŻNE</strong></span> W przypadku importu pliku CSV zalecamy wykonanie kopii aktualnej bazy danych (menu <strong>Narzędzia / Archiwizacja danych</strong>). Dzięki temu w przypadku niepowodzenia importu lub błędów w pliku importu będzie można przywrócić wprowadzone wcześniej dane bez ich utraty.</div>\r\n"),
("217","840","0","instrukcja","Szablony importu XML","<div style=\"text-align: justify;\"><img alt=\"\" src=\"obrazki/pomoc/szablony_xml.jpg\" style=\"width: 550px; height: 83px; margin-left: 15px; margin-bottom: 15px; float: right;\" />Moduł szablonów XML umożliwia ograniczenie importowania wybranych kategorii z zewnętrznych plików XML (szczególnie formatu Ceneo oraz Nokaut) oraz ograniczenie zakresu importowanych danych.<br />\r\n<br />\r\nSzablony XML można zdefiniować w menu <strong>Narzędzia / Import i eksport danych / Szablony plików XML</strong>. Można dodać wiele różnych szablonów w różnych konfiguracjach - dla różnych plików importów.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/szablony_xml_dodawanie.jpg\" style=\"width: 450px; height: 192px; margin-bottom: 15px; margin-right: 15px; float: left;\" />Dodawanie nowego szablonu odbywa się poprzez kliknięcie w link <strong>dodaj nową pozycję</strong>. Po uruchomieniu modułu dodawania zostanie wyświetlony formularz dodania nowego szablonu.<br />\r\n<br />\r\nNa górze formularza znajduje się pole do wpisania nazwy szablonu. Ma ono tylko charakter informacyjny dla administratora sklepu.<br />\r\n<br />\r\nPoniżej znajdują się pola do wpisania nazwy/ścieżki kategorii. Wpisane kategorie mogą służyć (w zależności od ustawionego zakresu importu na dole formularza):</div>\r\n\r\n<div style=\"text-align: justify;\"><br />\r\n1. do importu produktów tylko z określonych kategorii<br />\r\n2. do dodania marży do produktów z określonych kategorii</div>\r\n\r\n<div style=\"text-align: justify;\">3. do importu produktów tylko z określonych kategorii wraz z dodaniem marży.<br />\r\n&nbsp;</div>\r\n\r\n<div style=\"text-align: justify;\">W polach tych w formie tekstu trzeba wpisać nazwy kategorii - zgodne z nazwami w pliku XML. Dla przykładu: w pliku XML znajduje się wpis: &lt;(cat)&gt;&lt;(![CDATA[Art. biurowe/Papiery]])&gt;<!--(cat)-->. Oznacza to, że dany produkt jest przypisany do kategorii Art. biurowe i podkategorii Papiery. Jeżeli produkty należące do tej kategorii mają zostać dodane do sklepu (lub ma być dodana marża) to w polu nazwy kategorii trzeba wpisać: Art. biurowe/Papiery. Nie wystarczy wpisanie samej nazwy podkategorii (Papiery). Musi być podana cała ścieżka kategorii - tak jak w pliku XML. Bardzo ważna jest wielkość liter oraz inne znaki w nazwach (np spacje) - jeżeli tekst nie będzie identyczny jak w pliku XML - kategoria zostanie pominięta. W szablonie XML można zdefiniować nieograniczoną ilość nazw/ścieżek kategorii jakie mają być importowane. Dodatkową opcją przy kategoriach jest ustalenie marży na importowane produkty. Dla wybranych kategorii można wpisać o ile procent mają być podwyższone ceny w importowanych kategoriach. Jeżeli ceny mają pozostać bez zmian - należy pozostawić pole marży puste. Dzięki tym opcjom można do sklepu zaimportować tylko produkty z wybranych kategorii produktów lub dla wybranych kategorii dodać określoną marżę do cen produktów.</div>\r\n\r\n<div style=\"text-align: justify;\"><br />\r\nOstatnia opcja jest połączona z listą kategorii. Określa się w niej czy mają być importowane produkty ze wszystkich kategorii czy tylko te ze zdefiniowanych w polach. Zaznaczenie opcji <strong>wszystkie kategorie</strong> spowoduje, że będą importowane wszystkie produkty, a z podanej listy kategorii będzie pobierana tylko marża - czyli dla wybranych kategorii ceny zostaną podniesione o ustalony procent. Wybranie opcji <strong>tylko wymienione kategorie</strong> spowoduje, że będą importowane produkty tylko z wymienionych kategorii wraz z marżą.<br />\r\n<br />\r\nZapisany szablon można wykorzystać przy importowaniu danych z plików XML np porównywarki Ceneo.</div>\r\n"),
("218","841","0","instrukcja","Import zewnętrzny XML","<div style=\"text-align: justify;\">Sklep umożliwia importowanie danych produktów do sklepu w oparciu o pliki XML z innych formatów niż sklepu shopGold - np formatu Ceneo. Posiadając plik XML można do sklepu dodać w prosty i szybki sposób produkty lub zaktualizować np stany magazynowe czy ceny.<br />\r\n<br />\r\n<img alt=\"\" src=\"obrazki/pomoc/xml_zewnetrzny.jpg\" style=\"width: 320px; height: 346px; margin-left: 15px; margin-right: 15px; float: right;\" />Importu produktów oraz kategorii poprzez pliki zewnętrzne XML można dokonać poprzez menu <strong>Narzędzia / Import i eksport danych / Import zewnętrznych XML</strong>. Po wejściu w menu zostaną wyświetlone okna w których poszczególne opcje umożliwiają import danych.<br />\r\n<br />\r\nW górnym oknie znajduje się lista plików z których można dokonać importu. Są to pliki, które znajdują się w katalogu /import na serwerze. Pliki do importu można wgrać do katalogu bezpośrednio poprzez połączenie z serwerem (ftp) lub można wykorzystać opcję wgrywania plików, która znajduje się na dole strony.<br />\r\n<br />\r\nAby wgrać nowy plik należy wcisnąć przycisk <strong>Przeglądaj</strong>. Po tym otworzy się okno w którym zostaną wyświetlone pliki z Państwa komputera. W oknie trzeba wybrać plik, który ma zostać wgrany oraz wcisnąć przycisk <strong>Wgraj wybrany plik</strong>. Sklep rozpocznie wgrywanie pliku - po poprawnym wgraniu wyświetli się on w oknie listy plików opisanym powyżej. Maksymalne wielkość pliku jaki można wgrać poprzez moduł sklepu to 15MB (lub mniej jeżeli ograniczenie ma serwer na którym znajduje się sklep). Czas wgrywania pliku zależy od jego wielkości - nie wolno przerywać procesu wgrywania, gdyż spowoduje to uszkodzenie pliku.<br />\r\n<br />\r\nDodatkową opcją jest możliwość importu danych z zewnętrznego pliku XML. Pod listą plików XML znajdujących się na serwerze - w ostatniej pozycji - znajduje się pole do wpisania zewnętrznego adresu sklepu. Trzeba wpisać kompletny adres do pliku (z http) - np http://www.sklep.pl/pliki/import.xml Dane do importu zostaną pobrane z pliku, który znajduje się w innej lokalizacji niż sklep i dodane do sklepu. Opcja ta działa dużo wolniej (szczególnie przy dużej ilości produktów) niż pobieranie danych z pliku XML znajdującego się na serwerze (sklep musi pobierać dane z innego adresu co jest dużo wolniejsze) - dlatego zalecamy dokonywanie importu z plików znajdujących się na serwerze.<br />\r\n<br />\r\nPoniżej znajduje się opcja <strong>wyboru struktury pliku</strong>. Sklep ma zdefiniowane przykładowe struktury, które można użyć do importu danych produktów. Po wybraniu odpowiedniej struktury zostaną wyświetlone pozostałe pola importu - zależne od wybranej struktury. Jeżeli posiadacie Państwo plik XML, który nie jest obsługiwany przez sklep prosimy o kontakt z autorami sklepu w celu rozpoznania możliwości dodania struktury pliku XML do sklepu.<br />\r\n&nbsp;</div>\r\n"),
("219","8","0","instrukcja","Obsługa edytora tekstu","<div style=\"text-align: justify;\">Edytor tekstu używany podczas dodawania opisów, definiowania treści maili i innych tekstów w panelu zarządzania posiada możliwość formatowania tekstu, dodawania kolorów, tworzenia tabel, wstawiania zdjęć czy grafik. Dzięki możliwościom jakie posiada, tekst wprowadzany w edytorze może być bardziej czytelny i lepiej rozplanowany. Poniżej opisane zostały najważniejsze i najczęściej używane funkcje edytora.</div>\r\n\r\n<ol>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_zrodlo.jpg\" style=\"width: 377px; height: 59px; margin-left: 15px; margin-right: 15px; float: right;\" />Źródło dokumentu</strong> - pozwala zmienić tryb wyświetlania wprowadzonego tekstu na kod html. Cały tekst wprowadzony w edytorze, jego formatowanie, linki, tabele są zapisywane jako kod html (edytor zmienia wprowadzone dane na kod html). Przełączenie edytora na źródło spowoduje wyświetlenie kodu html jaki został wygenerowany na podstawie wprowadzonych danych.</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_kopiuj.jpg\" style=\"width: 253px; height: 65px; margin-left: 15px; margin-right: 15px; float: right;\" />Opcje kopiuj, wklej, wytnij </strong>- umożliwiają skopiowanie tekstu (po zaznaczeniu określonego fragmentu) i wstawienie w inne miejsce w dokumencie. Są one identyczne jak opcje kopiuj / wklej z Windowsa (opcja schowka). Można także używać skróty klawiszowe do kopiowania i wstawiania tekstu - opcja kopiuj wciśnięty przycisk Ctrl plus litera C - opcja wklej - przycisk Ctrl plus litera V.</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_znajdz.jpg\" style=\"width: 255px; height: 67px; margin-left: 15px; margin-right: 15px; float: right;\" />Opcja zamień / znajdź</strong> - umożliwia wyszukanie określonego tekstu lub zmianę określonego tekstu na inny. Po kliknięciu na ikonkę zostanie wyświetlone okno z dwoma opcjami - wyszukania tekstu lub zamiany. Opcja zamiany tekstu nie wymaga zaznaczenia tekstu, który ma być modyfikowany. Edytor przeszukuje cały tekst.</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_czyszczenie.jpg\" style=\"width: 308px; height: 42px; float: right; margin-left: 15px; margin-right: 15px;\" />Opcja czyszczenia tekstu (usuwania formatowania)</strong> - umożliwia usunięcie całego formatowania z zaznaczonego tekstu - pogrubienia, kursywy, wyrównywania. Z tekstu zostają usunięte wszystkie tagi html i pozostaje sam czysty tekst.</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_bold.jpg\" style=\"width: 339px; height: 72px; margin-left: 15px; margin-right: 15px; float: right;\" />Opcje pogrubienia, podkreślenia, kursywy</strong> - umożliwiają zmianę wyglądu zaznaczonego tekstu, można np pogrubić lub podkreślić zaznaczony tekst. Wybraną ikonę trzeba kliknąć po zaznaczeniu tekstu, który ma być zmieniony. Aby usunąć formatowanie należy użyć funkcji czyszczenia formatowania tekstu.</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_lista.jpg\" style=\"width: 302px; height: 40px; margin-left: 15px; margin-right: 15px; float: right;\" />Tworzenie listy</strong> - umożliwia utworzenie listy (wypunktowania) w której każda pozycja będzie zaczynała się od cyfry lub znaku graficznego.</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_wyrownanie.jpg\" style=\"width: 314px; height: 41px; float: right; margin-left: 15px; margin-right: 15px;\" />Opcje wyrównywania tekstu</strong> - umożliwiają odpowiednie wyrównywanie tekstu, możliwe opcje: do lewej strony, do prawej, wyrównywanie tekstu do środka oraz justowanie (równanie do lewej i prawej strony).</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_link.jpg\" style=\"width: 341px; height: 41px; float: right; margin-left: 15px; margin-right: 15px;\" />Tworzenie linku</strong> - umożliwia utworzenie linku do innej strony. Aby utworzyć link trzeba zaznaczyć tekst który ma być linkiem, a następnie kliknąć na ikonkę tworzenia linku (na obrazku z lewej strony). Po kliknięciu otworzy się okno w trzema zakładkami. Pierwsza zakładka umożliwia wybranie typu odnośnika (linku) - najczęściej to Adres URL. W polu poniżej trzeba wpisać adres do którego będzie przenosił link. Kolejna zakładka umożliwia ustawienie gdzie ma być otwierany link - w aktualnym czy nowym oknie przeglądarki. Ostatnia zakładka standardowo nie jest wykorzystywana podczas edycji tekstów w panelu zarządzania. Ikona usunięcia linku (na obrazku po prawej stronie) umożliwia usunięcie linku. W celu usunięcia trzeba ustawić kursor myszy na linku, który ma zostać usunięty i następnie kliknąć ikonę usuwania linku.</li>\r\n	<li style=\"text-align: justify;\"><strong><img alt=\"\" src=\"obrazki/pomoc/edytor_obrazek.jpg\" style=\"width: 233px; height: 41px; margin-left: 15px; margin-right: 15px; float: right;\" /><img alt=\"\" src=\"obrazki/pomoc/edytor_obrazek_okno.jpg\" style=\"margin-right: 15px; width: 300px; height: 246px; float: left;\" />Dodawanie i edycja obrazka</strong> - umożliwia dodanie do strony obrazka / zdjęcia. Po kliknięciu w ikonę otworzy się dodatkowe okno z możliwością wybrania obrazka oraz wpisania parametrów obrazka. Pierwsza pozycja to adres URL obrazka - po kliknięciu w przycisk <strong>P