<?php
chdir('../');            

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {
  
    $allegro = new Allegro(true);

    if (isset($_POST['akcja']) && $_POST['akcja'] == 'zapisz') {

      $db->truncate_query('allegro_settings');
      
      reset($_POST);
      while (list($key, $value) = each($_POST)) {
        if ( $key != 'akcja' ) {
          if ( stripos($key, 'conf') === false ) {
            if (is_array($value)) $value = array_sum($value);

            $pola = array(
                    array('params',strtoupper($key)),
                    array('value',$value)
            );
            $db->insert_query('allegro_settings' , $pola);
          } else {
            $pola = array(
                    array('value',$value)
            );
            $db->update_query('allegro_connect' , $pola, " params = '".strtoupper($key)."'");	
          }
        }
        unset($pola);
      }

      Funkcje::PrzekierowanieURL('konfiguracja_wystawiania.php');

    }

    // wczytanie naglowka HTML
    include('naglowek.inc.php');

    $parametry = $allegro->TablicaDefinicjiPol();
    ?>

    <div id="naglowek_cont">Konfiguracja wystawiania aukcji Allegro</div>
    <div id="cont">

      <?php 
      if ( count($parametry) > 0  ) {

        $TablicaPanstw = $allegro->doGetCountries();
        ?>

        <script>
        $(document).ready(function() {
          $("#allegroForm").validate();
        });
        </script>        

        <form action="allegro/konfiguracja_wystawiania.php<?php echo Funkcje::Zwroc_Get(); ?>" method="post" id="allegroForm" class="cmxform"> 
        
          <input type="hidden" name="akcja" value="zapisz" />

          <div class="poleForm">
            <div class="naglowek">Edycja danych</div>

            <div class="pozycja_edytowana">

              <div class="info_content">
              
                <div class="ObramowanieForm" style="margin-top:10px;">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Parametry ogólne</td>
                    </tr>
                    
                    <?php
                    $opcje_ogolne = array(4,5,9,10,11,32,29,28,15);

                    for ( $i=0, $c = count($opcje_ogolne); $i < $c; $i++ ) {
                      $fid = $opcje_ogolne[$i];

                      if ( isset($parametry[$fid]) ) {

                        if ( $parametry[$fid]['sell_form_id'] == '9' ) {
                            
                            $parametry[$fid]['sell_form_type'] = '4';

                            if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                            foreach ( $TablicaPanstw as $Panstwo ) {
                                $P = (array)$Panstwo;
                                $parametry[$fid]['sell_form_desc'] .= $P['country-name'] . '|';
                                $parametry[$fid]['sell_form_opts_values'] .= $P['country-id'] . '|';
                                unset($P);
                            }
                            
                        }

                        echo '<tr class="PozycjaAllegroForm"><td>';
                        echo '<div class="TipIkona"><div class="Chmura">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div></div>';

                        $identyfikator = '';
                        if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                            $identyfikator = 'for="pole_id_'.$parametry[$fid]['sell_form_id'].'"';
                        }

                        echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' '. $identyfikator.' >' .$parametry[$fid]['sell_form_title'].': ' . (isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ) . '</label></td><td>';

                        $default = '';
                        if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                        echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="pole_id_'.$parametry[$fid]['sell_form_id'].'"');
                            echo '</td></tr>';
                      }
                    }
                    ?>
                    
                  </table>

                </div>
                
                <div class="ObramowanieForm" style="margin-top:10px;">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Sposób definiowania opisu produktu na aukcji</td>
                    </tr>
                    
                    <?php

                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Sposób definiowania opisu produktu na aukcji</b></em>';
                    echo '<label for="pole_nowy_opis_tak">Opis produktu na aukcji:</label></td>';
                    
                    echo '<td>';
                    echo '<input type="radio" ' . ($allegro->polaczenie['CONF_NEW_DESCRIPTION'] == 'tak' ? 'checked="checked"' : '' ) . ' value="tak" name="conf_new_description" id="pole_nowy_opis_tak"><label for="pole_nowy_opis_tak" class="OpisFor" onclick="$(\'.KonfiguracjaStaryOpis\').slideUp()">Nowy opis</label> <br />';
                    echo '<input type="radio" ' . ($allegro->polaczenie['CONF_NEW_DESCRIPTION'] == 'nie' ? 'checked="checked"' : '' ) . ' value="nie" name="conf_new_description" id="pole_nowy_opis_nie"><label for="pole_nowy_opis_nie" class="OpisFor" onclick="$(\'.KonfiguracjaStaryOpis\').slideDown()">Stary opis (z dowolnym kodem html)</label></td></tr>';

                    ?>
                    
                  </table>

                </div>             
                

                <div class="ObramowanieForm KonfiguracjaStaryOpis" style="margin-top:10px;<?php echo (($allegro->polaczenie['CONF_NEW_DESCRIPTION'] == 'tak') ? 'display:none' : ''); ?>">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Zdjęcia</td>
                    </tr>
                    
                    <?php
                    
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Maksymalna szerokość zdjęcia umieszczonego w opisie aukcji - należy dopasować do szerokości używanego szablonu aukcji</b></em>';
                    echo '<label for="conf_foto_width">Szerokość zdjęcia w pikselach:</label></td><td><input class="calkowita" type="text" value="' . (int)$allegro->polaczenie['CONF_FOTO_WIDTH'].'" size="20" name="conf_foto_width" id="conf_foto_width" /></td></tr>';

                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Maksymalna wysokość zdjęcia umieszczonego w opisie aukcji. Jeżeli nie zostanie podana żadna wartość zdjęcia będą wysyłane w oryginalnym rozmiarze</b></em>';
                    echo '<label for="conf_foto_height">Wysokość zdjęcia w pikselach:</label></td><td><input class="calkowita" type="text" value="' . (int)$allegro->polaczenie['CONF_FOTO_HEIGHT'].'" size="20" name="conf_foto_height" id="conf_foto_height" /></td></tr>';
                    
                    echo '<tr class="PozycjaAllegroForm"><td colspan="2"><span class="maleInfo" style="margin-left:0px">Jeżeli nie zostanie podana wartość wysokości i szerokości zdjęcia będą wysyłane w oryginalnym rozmiarze.</span></td></tr>';
                    
                    // rozmiar logo producenta
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Szerokość / wysokość logo producenta w szablonie aukcji wyświetlanego przez kod [LOGO_PRODUCENTA] - należy dopasować do szerokości używanego szablonu aukcji. Jeżeli nie zostanie podana żadna wartość logo będzie wyświetlae w oryginalnym rozmiarze</b></em>';
                    echo '<label for="conf_manufacturers_image_width">Szerokość / wysokość logotypu producenta w pikselach:</label></td><td>
                    <input type="text" value="' . $allegro->polaczenie['CONF_MANUFACTURERS_IMAGE_WIDTH'] . '" size="20" name="conf_manufacturers_image_width" id="conf_manufacturers_image_width" /></td></tr>';
                    
                    // znak wodny - czy stosowac
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Znak wodny na zdjęciach w aukcjach Allegro</b></em>';
                    echo '<label for="pole_watermark_tak">Czy stosować znak wodny:</label></td>';
                    
                    echo '<td>
                    <input type="radio" ' . ($allegro->polaczenie['CONF_IMAGE_WATERMARK'] == 'tak' ? 'checked="checked"' : '' ) . '  value="tak" name="conf_image_watermark" id="pole_watermark_tak"><label for="pole_watermark_tak" class="OpisFor">Tak</label>
                    <input type="radio" ' . ($allegro->polaczenie['CONF_IMAGE_WATERMARK'] == 'nie' ? 'checked="checked"' : '' ) . ' value="nie" name="conf_image_watermark" id="pole_watermark_nie"><label for="pole_watermark_nie" class="OpisFor">Nie</label></td></tr>';

                    // znak wodny plik
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Plik nakładanego znaku wodnego - musi to być przeźroczysty plik w formacie PNG</b></em>';
                    echo '<label for="conf_image_watermark_file">Plik znaku wodnego:</label></td><td>
                    <input class="obrazek" type="text" value="' . $allegro->polaczenie['CONF_IMAGE_WATERMARK_FILE'] . '" size="53" name="conf_image_watermark_file" id="conf_image_watermark_file" ondblclick="openFileBrowser(\'CONF_IMAGE_WATERMARK_FILE\',\'\',\'images\')" /><em class="TipIkona"><b>Kliknij dwukrotnie w pole obok żeby otworzyć okno przeglądarki zdjęć</b></em>
                      <span class="PrzegladarkaZdjec TipChmurka" onclick="openFileBrowser(\'conf_image_watermark_file\',\'\',\'images\')"><b>Kliknij żeby otworzyć okno przeglądarki zdjęć</b></span></td></tr>';
                    ?>
                    
                  </table>

                </div>
                
                <div class="ObramowanieForm KonfiguracjaStaryOpis" style="margin-top:10px;<?php echo (($allegro->polaczenie['CONF_NEW_DESCRIPTION'] == 'tak') ? 'display:none' : ''); ?>">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Galeria zdjęć</td>
                    </tr>
                    
                    <?php

                    // domyslne zaznaczenie
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Domyślne zaznaczenie dodatkowych zdjęć podczas wystawiania aukcji</b></em>';
                    echo '<label for="pole_zdjecia">Domyślne zaznaczenie dodatkowych zdjęć</label></td>';
                    
                    echo '<td>
                    <input type="radio" ' . ($allegro->polaczenie['CONF_DODATKOWE_FOTO'] == 'zdjecia' ? 'checked="checked"' : '' ) . '  value="zdjecia" name="conf_dodatkowe_foto" id="pole_zdjecia"><label for="pole_zdjecia" class="OpisFor">Zdjęcia</label>
                    <input type="radio" ' . ($allegro->polaczenie['CONF_DODATKOWE_FOTO'] == 'galeria' ? 'checked="checked"' : '' ) . ' value="galeria" name="conf_dodatkowe_foto" id="pole_galeria"><label for="pole_galeria" class="OpisFor">Galeria</label></td>';

                    // szerokosc miniaturek
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Szerokość / wysokość zdjęć miniaturek w galerii zdjęć produktu. Minimalna wartość to 30px. Maksymalna wartość to 200px</b></em>';
                    echo '<label for="conf_gallery_small_image_width">Szerokość / wysokość miniaturek zdjęć w galerii w pikselach:</label></td><td><input class="calkowita" type="text" value="' . (int)$allegro->polaczenie['CONF_GALLERY_SMALL_IMAGE_WIDTH'].'" size="20" name="conf_gallery_small_image_width" id="conf_gallery_small_image_width" /></td></tr>';

                    // szerokosc duzego zdjecia
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Szerokość / wysokość dużego zdjęcia w galerii zdjęć produktu. Minimalna wartość to 400px. Maksymalna wartość to 800px</b></em>';
                    echo '<label for="conf_gallery_big_image_width">Szerokość / wysokość dużego zdjęcia w galerii w pikselach:</label></td><td><input class="calkowita" type="text" value="' . (int)$allegro->polaczenie['CONF_GALLERY_BIG_IMAGE_WIDTH'].'" size="20" name="conf_gallery_big_image_width" id="conf_gallery_big_image_width" /></td></tr>';

                    ?>
                    
                  </table>

                </div>  

                <div class="ObramowanieForm KonfiguracjaStaryOpis" style="margin-top:10px;<?php echo (($allegro->polaczenie['CONF_NEW_DESCRIPTION'] == 'tak') ? 'display:none' : ''); ?>">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Pozostałe aukcje sprzedającego</td>
                    </tr>
                    
                    <?php

                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Ilość wyświetlanych na aukcji pozostałych aukcji oferowanych przez sprzedającego. Zmiana będzie widoczna tylko dla nowo wystawionych aukcji</b></em>';
                    echo '<label for="conf_other_image_count">Ilość wyświetlanych pozostałych aukcji:</label></td><td><input class="calkowita" type="text" value="' . (int)$allegro->polaczenie['CONF_OTHER_IMAGE_COUNT'].'" size="20" name="conf_other_image_count" id="conf_other_image_count" /></td></tr>';
                    ?>
                    
                  </table>

                </div>             

                <div class="ObramowanieForm" style="margin-top:10px;">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Parametry wysyłki</td>
                    </tr>
                    
                    <?php
                    $opcje_wysylki = array(12,13,35,340);

                    for ( $i=0, $c = count($opcje_wysylki); $i < $c; $i++ ) {
                      $fid = $opcje_wysylki[$i];

                      if ( isset($parametry[$fid]) ) {

                        $identyfikator = '';
                        if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                            $identyfikator = 'for="pole_id_'.$parametry[$fid]['sell_form_id'].'"';
                        }

                        echo '<tr class="PozycjaAllegroForm"><td>';

                        //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                        echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                        echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .$parametry[$fid]['sell_form_title'].': ' . (isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ) . '</label></td><td>';

                        $default = '';
                        if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                        echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="pole_id_'.$parametry[$fid]['sell_form_id'].'"');
                        echo '</td></tr>';

                      }
                    }
                    ?>
                    
                  </table>

                </div>
            

                <div class="ObramowanieForm" style="margin-top:10px;">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Parametry płatności</td>
                    </tr>
                    
                    <?php
                    $opcje_platnosci = array(14,33,34,27);

                    for ( $i=0, $c = count($opcje_platnosci); $i < $c; $i++ ) {
                      $fid = $opcje_platnosci[$i];

                      if ( isset($parametry[$fid]) ) {

                        $identyfikator = '';
                        if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                            $identyfikator = 'for="pole_id_'.$parametry[$fid]['sell_form_id'].'"';
                        }

                        if ( $parametry[$fid]['sell_form_id'] == '33' || $parametry[$fid]['sell_form_id'] == '34' ) {
                          $parametry[$fid]['sell_form_field_desc'] = 'Format 26 cyfr pisanych łącznie';
                        }
                        echo '<tr class="PozycjaAllegroForm"><td>';
                        //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                        echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                        echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .$parametry[$fid]['sell_form_title'].': ' . (isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ) . '</label></td><td>';
                        $default = '';
                        if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                        echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="pole_id_'.$parametry[$fid]['sell_form_id'].'"');
                        echo '</td></tr>';

                      }
                    }
                    ?>
                    
                  </table>

                </div>

                <div class="ObramowanieForm" style="margin-top:10px;">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td colspan="2" style="padding-left:10px;">Parametry zamówień tworzonych ze sprzedaży allegro</td>
                    </tr>
                    
                    <?php

                    // domyslne zaznaczenie
                    echo '<tr class="PozycjaAllegroForm"><td>';
                    echo '<em class="TipIkona"><b>Nazwa produktu jaka ma być użyta do tworzenia zamówienia dla produktu z allegro</b></em>';
                    echo '<label for="nazwa_tak">Nazwa produktu dla zamówienia</label></td>';
                    
                    echo '<td>
                    <input type="radio" ' . ($allegro->polaczenie['CONF_INVOICE_PRODUCTS_NAME'] == 'tak' ? 'checked="checked"' : '' ) . ' value="tak" name="conf_invoice_products_name" id="nazwa_tak"><label for="nazwa_tak" class="OpisFor">Nazwa produktu dla allegro <em class="TipIkona"><b>Przy tworzeniu zamówienia na podstawie aukcji zostanie wstawiona nazwa produktu jak w allegro</b></em></label> <br />
                    <input type="radio" ' . ($allegro->polaczenie['CONF_INVOICE_PRODUCTS_NAME'] == 'nie' ? 'checked="checked"' : '' ) . ' value="nie" name="conf_invoice_products_name" id="nazwa_nie"><label for="nazwa_nie" class="OpisFor">Nazwa produktu w sklepie <em class="TipIkona"><b>Przy tworzeniu zamówienia na podstawie aukcji zostanie wstawiona nazwa produktu jaka jest w sklepie</b></em></label></td>';

                    ?>
                    
                  </table>

                </div>                  

                <div class="ObramowanieForm" style="margin-top:10px;">

                  <table>
                  
                    <tr class="div_naglowek">
                      <td style="padding-left:10px;">Koszty wysyłek - słownik szablonów kosztów wysyłek</td>
                    </tr>
                    
                    <tr>
                      <td>
                      
                          <table class="SlownikWysylek">
                          
                              <?php
                              $zapytanie = "select distinct * from allegro_shipping";
                              $sqls = $db->open_query($zapytanie);
                              
                              while ($info = $sqls->fetch_assoc()) {
                              
                                  echo '<tr>
                                            <td>' . $info['template_name'] . '</td>
                                            <td>' . $info['template_description'] . '</td>
                                            <td>
                                                <a class="TipChmurka" href="allegro/allegro_wysylki.php?id_wysylki=' . $info['id'] . '"><b>Edytuj szablon kosztów wysyłek</b><img src="obrazki/edytuj.png" alt="Edytuj" /></a>
                                                ' . (($info['id'] > 1) ? '<a class="TipChmurka" href="allegro/allegro_wysylki_usun.php?id_wysylki=' . $info['id'] . '"><b>Usuń szablon kosztów wysyłek</b><img src="obrazki/kasuj.png" alt="Usuń" /></a>' : '') . '
                                            </td>
                                        </tr>';  
                              
                              }
                              
                              $db->close_query($sqls);
                              unset($zapytanie);                                
                              ?>

                          </table>
                          
                          <a class="dodaj" style="margin:15px 0px 10px 5px" href="allegro/allegro_wysylki.php">dodaj nowy szablon wysyłek</a>                    
                      
                      </td>
                    </tr>

                    
                  </table>

                </div>                  

              </div>              

              <div class="przyciski_dolne">
                <input type="submit" class="przyciskNon" value="Zapisz dane" />
              </div>

            </div>
          </div>
        </form>

      <?php } else {
        
        echo '<div class="pozycja_edytowana"><span class="ostrzezenie">Nie zostały wczytane definicje pól z serwisu Allegro.</span></div>';
        
      }
      ?>
    </div>
    
    <?php
    include('stopka.inc.php');    
    
} 
?>
