<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

    Listing::postGet(basename($_SERVER['SCRIPT_NAME']));

    $zapytanie = "SELECT *
                    FROM allegro_after_sales ORDER BY login, document_type";

    $sql = $db->open_query($zapytanie);

    // tworzenie paska do nastepnych okien - obliczanie ile bedzie podstron
    $ile_pozycji = (int)$db->ile_rekordow($sql); // ile jest wszystkich produktow
    $ile_licznika = ($ile_pozycji / ILOSC_WYNIKOW_NA_STRONIE);
    if ($ile_licznika == (int)$ile_licznika) { $ile_licznika = (int)$ile_licznika; } else { $ile_licznika = (int)$ile_licznika+1; }
    $db->close_query($sql);

    // ******************************************************************************************************************************************************************
    // obsluga listingu AJAX
    if (isset($_GET['parametr'])) {

        if ($ile_pozycji > 0) {
            
            $zapytanie .= " limit ".$_GET['parametr'];
            $sql = $db->open_query($zapytanie);

            $listing_danych = new Listing();
            
            $tablica_naglowek = array(array('ID','center'),
                                      array('Nazwa dokumentu'),
                                      array('UID dokumentu','center'),
                                      array('Rodzaj','center'),
                                      array('Użytkownik','center'),
                                      array('Status','center')
                );
                                      
            echo $listing_danych->naglowek($tablica_naglowek);
            
            $tekst = '';
            while ($info = $sql->fetch_assoc()) {
            
                  if (isset($_GET['id_poz']) && (int)$_GET['id_poz'] == $info['document_id']) {
                     $tekst .= '<tr class="pozycja_on" id="sk_'.$info['document_id'].'">';
                   } else {
                     $tekst .= '<tr class="pozycja_off" id="sk_'.$info['document_id'].'">';
                  }       

                  // typ pola
                  switch( $info['document_type'] ) {
                      case 'g': $typ_pola = 'Gwarancja'; break;
                      case 'r': $typ_pola = 'Warunki reklamacji'; break;
                      case 'z': $typ_pola = 'Warunki zwrotu'; break;
                      default: $typ_pola = 'Gwarancja'; break;
                  }

                  $tablica = array(array($info['document_id'] . '<input type="hidden" name="id[]" value="'.$info['document_id'].'" />','center'),
                                   array($info['document_name'],'left'),
                                   array($info['document_uid'],'center'),
                                   array($typ_pola,'center'),
                                   array($info['login'],'center')
                  ); 

                  // aktywana czy nieaktywna
                  if ($info['status'] == '1') { $obraz = 'aktywny_on.png'; $alt = 'Ten dokument jest nieaktywny'; } else { $obraz = 'aktywny_off.png'; $alt = 'Ten dokument jest nieaktywny'; }               
                  $tablica[] = array('<img src="obrazki/'.$obraz.'" alt="'.$alt.'" />','center');

                  $tekst .= $listing_danych->pozycje($tablica);
                  
                  $tekst .= '<td class="rg_right IkonyPionowo">';
                  
                  $zmienne_do_przekazania = '?id_poz='.$info['document_id'];
                  $tekst .= '<a class="TipChmurka" href="allegro/konfiguracja_pozakupowa_edytuj.php'.$zmienne_do_przekazania.'"><b>Edytuj</b><img src="obrazki/edytuj.png" alt="Edytuj" /></a>';
                  $tekst .= '<a class="TipChmurka" href="allegro/konfiguracja_pozakupowa_usun.php'.$zmienne_do_przekazania.'"><b>Skasuj</b><img src="obrazki/kasuj.png" alt="Skasuj" /></a>';
                  
                  $tekst .= '</td></tr>';
                  
            } 
            $tekst .= '</table>';
            //
            echo $tekst;
            //
            $db->close_query($sql);
            unset($listing_danych,$tekst,$tablica,$tablica_naglowek);        

        }
    }  
    
    // ******************************************************************************************************************************************************************
    // wyswietlanie listingu
    if (!isset($_GET['parametr'])) { 

        // wczytanie naglowka HTML
        include('naglowek.inc.php');
        ?>

        <div id="caly_listing">
        
            <div id="ajax"></div>
            
            <div id="naglowek_cont">Zdefiniowane warunki ofert w Allegro</div>     

            <div id="PozycjeIkon">
                <div>
                    <a class="dodaj" href="allegro/konfiguracja_pozakupowa_dodaj.php">dodaj nową pozycję</a>
                </div>            
            </div>
            
            <div style="clear:both;"></div>      

            <form action="allegro/konfiguracja_pozakupowa_akcja.php" method="post" class="cmxform">            
        
            <div id="wynik_zapytania"></div>
            <div id="aktualna_pozycja">1</div>
            <div id="dolny_pasek_stron"></div>
            <div id="pokaz_ile_pozycji"></div>
            <div id="ile_rekordow"><?php echo $ile_pozycji; ?></div>
            
            <script>
            $("#wynik_zapytania").html('<div style="padding:10px">Trwa ładowanie danych ...</div>');
            <?php Listing::pokazAjax('allegro/konfiguracja_pozakupowa.php', $zapytanie, $ile_licznika, $ile_pozycji, 'document_id'); ?>
            </script>             

            <div class="cl"></div>
            
            </form>
            
        </div>
                    
        <?php include('stopka.inc.php'); ?>

    <?php }

}
