<?php
chdir('../');

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

//$_POST['limit'] = 5;
//$_POST['offset'] = 0;

if ($prot->wyswietlStrone && Sesje::TokenSpr()) {

  $wynikDoAjaxa = '';
  $wynik = Array();

  $allegro = new Allegro(true, true);
  
  $TranzakcjeTabelaCala = array();
  //
  if ( isset($_POST['tranzakcja']) ) {
       //
       $TranzakcjeTabelaCala = @unserialize($_POST['tranzakcja']);
       //
  }
  
  //#############################################
  // utworzenie tablicy krajow - do wstawiania nazwy kraju z formularzy pozakupowych
  $TablicaKrajowObj = $allegro->doGetCountries();
  $TablicaKrajow = array();

  foreach($TablicaKrajowObj as $country) {
    $TablicaKrajow[$country->{'country-id'}] = $country->{'country-name'};
  }
  //#############################################


  //#############################################
  // wybranie porcji aukcji z bazy do synchronizacji 
  $zapytanie = "SELECT allegro_id, auction_id, products_id, auction_status, auction_date_end FROM allegro_auctions WHERE (auction_seller = '' || auction_seller = '" . $_SESSION['allegro_user_login'] . "')";
  
  if ( isset($_POST['journal']) ) {
       //
       $tb = @unserialize($_POST['aukcje']);
       //
       $zapytanie .= " and (auction_id in (" . ((count($tb) == 0) ? '0' : implode(',', $tb)) . ") || auction_status = -1)";   
       //
       unset($tb);
       //
  }
  
  if ( isset($_POST['wybrane']) ) {
       //
       $tb = @unserialize($_POST['wybrane']);
       //
       $zapytanie .= " and (auction_id in (" . ((count($tb) == 0) ? '0' : implode(',', $tb)) . ") || auction_status = -1)";   
       //
       unset($tb);
       //                
  } else {
       //
       $zapytanie .= " and archiwum_allegro = '0'";
       //       
  }
  
  $zapytanie .= " LIMIT " . (int)$_POST['limit'] . " OFFSET " . (int)$_POST['offset'];

  $sql = $db->open_query($zapytanie);

  // utworzenie tablicy aukcji do pobrania z Allegro
  $Aukcje = array();
  $AukcjeDataZakonczenia = array();

  if ( $db->ile_rekordow($sql) > 0 ) {

    while ($info = $sql->fetch_assoc()) {
    
      //#############################################
      // aktualizacja informacji jezeli aukcja nie byla dotychczas synchronizowana w tabeli ALLEGRO_AUCTIONS
      if ( $info['auction_status'] == '-1' ) {
      
        $NumerAukcjiOczekujacej = $allegro->doVerifyItem( $info['auction_id'] );
        
        if ( is_array($NumerAukcjiOczekujacej) ) {
        
          if ( $NumerAukcjiOczekujacej['item-id'] != '-1' ) {
              $pola = array(
                      array('auction_id',$NumerAukcjiOczekujacej['item-id']),
                      array('auction_status','1'));
                      
              $db->update_query('allegro_auctions' , $pola, " allegro_id = '".$info['allegro_id']."'");	
              unset($pola);
              
              $Aukcje[] = floatval($NumerAukcjiOczekujacej['item-id']);
              $AukcjeDataZakonczenia[ $info['auction_id'] ] = strtotime($info['auction_date_end']);
          }

          unset($NumerAukcjiOczekujacej);

        }
        
      } else {
      
        $Aukcje[] = floatval($info['auction_id']);
        $AukcjeDataZakonczenia[ $info['auction_id'] ] = strtotime($info['auction_date_end']);
        
      }
    }

  }

  $db->close_query($sql);
  unset($zapytanie, $info, $sql);

  //#############################################
  // pobranie szczegolow aukcji oraz tranzakcji
  $PrzetwarzaneAukcje = array();

  if ( count($Aukcje) > 0 ) {
    
    $PrzetwarzaneAukcje = $allegro->doGetItemsInfo( $Aukcje );

    // usuniecie z tablicy aukcji tych, ktorych nie mozna odnalezc w Allegro
    $Aukcje = array_diff($Aukcje, $PrzetwarzaneAukcje['array-items-not-found']);

    if ( count($Aukcje) > 0 ) {
        $Tranzakcje = $allegro->doGetTransactionsIDs( $Aukcje, 'seller' );
        //
        if ( count($TranzakcjeTabelaCala) > 0 ) {
             //
             // usuwa niepotrzebne tranzakcje
             foreach ( $Tranzakcje as $Klucz => $Pozycja ) {
                 //
                 // sprawdza czy jest tranzakcja w tabeli journal tranzakcji
                 $Byl = false;
                 foreach ( $TranzakcjeTabelaCala as $PozTrnz ) {
                     //
                     if ( $PozTrnz['tranzakcja'] == $Pozycja ) {
                          //
                          $Byl = true;
                          //
                     }
                     //
                 }
                 if ( $Byl == false ) {
                      //
                      unset( $Tranzakcje[$Klucz] );
                      //
                 }
                 unset($Byl);
                 //
             }
             //
        }
        //
    }

    if ( count($PrzetwarzaneAukcje['array-items-not-found']) > 0 ) {

        for ( $i = 0, $c = count($PrzetwarzaneAukcje['array-items-not-found']); $i < $c; $i++ ) {

            $wynikDoAjaxa .= '<a>' . $PrzetwarzaneAukcje['array-items-not-found'][$i] . '</a> - aukcja nie znaleziona w Allegro';

            if ( isset($AukcjeDataZakonczenia[ (string)$PrzetwarzaneAukcje['array-items-not-found'][$i] ]) && time() > $AukcjeDataZakonczenia[ (string)$PrzetwarzaneAukcje['array-items-not-found'][$i] ] ) {
            
                $pola = array(
                        array('archiwum_allegro','1'));
                      
                $db->update_query('allegro_auctions' , $pola, " auction_id = '".$PrzetwarzaneAukcje['array-items-not-found'][$i]."' AND synchronization != '1'");	
                unset($pola);
                
                if ( $db->last_query_effect() > 0 ) {
                     $wynikDoAjaxa .= ' - <b style="color:#12af0a">przeniesiona do ARCHIWUM</b>';
                }
                
            } else if ( isset($AukcjeDataZakonczenia[ (string)$PrzetwarzaneAukcje['array-items-not-found'][$i] ]) ) {
              
                $wynikDoAjaxa .= ' - <b style="color:#ff0000">data zakończenia aukcji ' . date('d-m-Y G:i:s', $AukcjeDataZakonczenia[ (string)$PrzetwarzaneAukcje['array-items-not-found'][$i] ]) . '</b>';
              
            }

            $wynikDoAjaxa .= '<br />';

        }

    }

  }
  
  unset($AukcjeDataZakonczenia);

  if ( count($Aukcje) > 0 ) {

      //#############################################
      // jezeli zostaly zwrocone dane o aukcjach
      if ( count($PrzetwarzaneAukcje['array-item-list-info']) > 0 ) {
        
        // pobranie formularzy pozakupowych do tranzakcji w wybranych aukcjach
        if ( count($Tranzakcje) > 0 ) {
          
            $FormularzePozakupowe = array();

            foreach ( array_chunk( $Tranzakcje, 25 ) as $TranzakcjePorcja ) {

                if ( count($TranzakcjePorcja) > 0 ) {
                    $FormularzePozakupowe[] = $allegro->doGetPostBuyFormsDataForSellers( $TranzakcjePorcja );
                }

            }

        }

        $TablicaAukcjiSprzedanych = array();

        //#############################################
        // aktualizacja informacji o aukcjach w bazie danych w tabeli ALLEGRO_AUCTIONS
        foreach ( $PrzetwarzaneAukcje['array-item-list-info'] as $PrzetwarzanaAukcja ) {

            $pola = array(
                  array('auction_quantity',(int)$PrzetwarzanaAukcja->{'item-info'}->{'it-quantity'}),
                  array('auction_date_start',date("Y-m-d H:i:s",$PrzetwarzanaAukcja->{'item-info'}->{'it-starting-time'})),
                  array('auction_date_end',date("Y-m-d H:i:s",$PrzetwarzanaAukcja->{'item-info'}->{'it-ending-time'})),
                  array('products_start_price',$PrzetwarzanaAukcja->{'item-info'}->{'it-starting-price'}),
                  array('products_now_price',$PrzetwarzanaAukcja->{'item-info'}->{'it-price'}),
                  array('products_min_price',$PrzetwarzanaAukcja->{'item-info'}->{'it-reserve-price'}),
                  array('products_buy_now_price',$PrzetwarzanaAukcja->{'item-info'}->{'it-buy-now-price'}),
                  array('auction_bids',(int)$PrzetwarzanaAukcja->{'item-info'}->{'it-bid-count'}),
                  array('auction_hits',(int)$PrzetwarzanaAukcja->{'item-info'}->{'it-hit-count'}),
                  array('auction_status',(int)$PrzetwarzanaAukcja->{'item-info'}->{'it-ending-info'}),
                  array('products_sold',$PrzetwarzanaAukcja->{'item-info'}->{'it-starting-quantity'} - $PrzetwarzanaAukcja->{'item-info'}->{'it-quantity'}),
                  array('synchronization',0));
                  
            if ( $PrzetwarzanaAukcja->{'item-info'}->{'it-ending-info'} == '1' ) {
              $pola[] = array('auction_buy_now',(int)$PrzetwarzanaAukcja->{'item-info'}->{'it-buy-now-active'});
            }

            $db->update_query('allegro_auctions' , $pola, " auction_id = '".$PrzetwarzanaAukcja->{'item-info'}->{'it-id'}."'");	
            unset($pola);

            $link = '';
            if ( isset($_POST['serwer']) && $_POST['serwer'] == 'nie' ) {
              $link = 'http://allegro.pl/item' .  $PrzetwarzanaAukcja->{'item-info'}->{'it-id'} . '_webapi.html';
            } else {
              $link = 'http://allegro.pl.webapisandbox.pl/show_item.php?item='.$PrzetwarzanaAukcja->{'item-info'}->{'it-id'};
            }                          
            
            $wynikDoAjaxa .= '<a href="' . $link . '">' . $PrzetwarzanaAukcja->{'item-info'}->{'it-id'} . '</a> - aukcja została przetworzona<br />';
            
            unset($link); 
            
            //#############################################
            // pobranie informacji o kupujacych w danej aukcji i zapisanie w bazie informacji o sprzedazy dla danej aukcji w tabeli ALLEGRO_AUCTIONS_SOLD
            
            // sprawdza czy jest tranzakcja w tabeli journal tranzakcji
            $Byl = false;
            if ( count($TranzakcjeTabelaCala) > 0 ) { 
                 //
                 foreach ( $TranzakcjeTabelaCala as $PozTrnz ) {
                   //
                   if ( $PozTrnz['aukcja'] == (string)$PrzetwarzanaAukcja->{'item-info'}->{'it-id'} ) {
                        //
                        $Byl = true;
                        //
                   }
                   //
                 }     
              } else {
                 //
                 $Byl = true;
                 //              
            }
            
            if ( $PrzetwarzanaAukcja->{'item-info'}->{'it-bid-count'} > 0 && $Byl == true ) {
            
              $TablicaOfertAukcji = $allegro->doGetBidItem2( $PrzetwarzanaAukcja->{'item-info'}->{'it-id'} );

              $TablicaAukcjiSprzedanych[] = floatval($PrzetwarzanaAukcja->{'item-info'}->{'it-id'});

              foreach ( $TablicaOfertAukcji as $OfertaAukcji ) {

                  $id_aukcji     = $OfertaAukcji->{'bids-array'}['0'];
                  $id_kupujacego = $OfertaAukcji->{'bids-array'}['1'];
                  $data_zakupu   = $OfertaAukcji->{'bids-array'}['7'];
                  $zapytanie_k = "SELECT allegro_auction_id, auction_id, buyer_id FROM allegro_auctions_sold WHERE auction_id = '".$id_aukcji."' AND buyer_id = '".$id_kupujacego."'";
                  $sqlk = $db->open_query($zapytanie_k);

                  if ( $db->ile_rekordow($sqlk) == 0 ) {
                  
                    $pola = array(
                            array('auction_id',$OfertaAukcji->{'bids-array'}['0']),
                            array('buyer_id',$OfertaAukcji->{'bids-array'}['1']),
                            array('buyer_name',$OfertaAukcji->{'bids-array'}['2']),
                            array('buyer_status',(int)$OfertaAukcji->{'bids-array'}['4']),
                            array('auction_quantity',(int)$OfertaAukcji->{'bids-array'}['5']),
                            array('auction_price',$OfertaAukcji->{'bids-array'}['6']),
                            array('auction_buy_date',$OfertaAukcji->{'bids-array'}['7']),
                            array('auction_status',(int)$OfertaAukcji->{'bids-array'}['8']),
                            array('auction_lost_date',$OfertaAukcji->{'bids-array'}['9']),
                            array('auction_lost_status',$OfertaAukcji->{'bids-array'}['11']),
                            array('auction_lost_text',$OfertaAukcji->{'bids-array'}['10']),
                            array('date_last_modified','now()'));
                            
                    $db->insert_query('allegro_auctions_sold' , $pola);
                    
                  } else {
                  
                    $infok = $sqlk->fetch_assoc();
                    
                    $pola = array(
                            array('buyer_status',(int)$OfertaAukcji->{'bids-array'}['4']),
                            array('auction_status',(int)$OfertaAukcji->{'bids-array'}['8']),
                            array('auction_quantity',(int)$OfertaAukcji->{'bids-array'}['5']),
                            array('auction_price',$OfertaAukcji->{'bids-array'}['6']),
                            array('auction_buy_date',$OfertaAukcji->{'bids-array'}['7']),
                            array('auction_lost_date',$OfertaAukcji->{'bids-array'}['9']),
                            array('auction_lost_status',$OfertaAukcji->{'bids-array'}['11']),
                            array('auction_lost_text',$OfertaAukcji->{'bids-array'}['10']),
                            array('date_last_modified','now()'));
                            
                    $db->update_query('allegro_auctions_sold' , $pola, " allegro_auction_id = '".$infok['allegro_auction_id']."'");	

                  }
                  unset($sqlk, $infok, $pola);

                  unset($id_aukcji, $id_kupujacego, $data_zakupu);

              }

              unset($TablicaOfertAukcji);
              
            }  

            unset($Byl);
            //             

        }

        //#############################################
        // pobranie adresu kupujacych do aukcji ze sprzedaza
        if ( count($TablicaAukcjiSprzedanych) > 0 ) {
        
          foreach ( array_chunk( $TablicaAukcjiSprzedanych, 25 ) as $TablicaAukcjiSprzedanychPorcja ) {
          
            if ( count($TablicaAukcjiSprzedanychPorcja) > 0 ) {

              // wynikiem jest tablica zawierajaca oferty dla wszystkich wybranych aukcji
              $TablicaKupujacychWAukcji = $allegro->doGetPostBuyData( $TablicaAukcjiSprzedanychPorcja );

              // dla kazdej kolejnej aukcji wybiera tablice ofert
              foreach ( $TablicaKupujacychWAukcji as $KupujacyWAukcjiSzczegoly ) {

                // jezeli oferta jest do aukcji odnalezionej w Allegro
                if ( count($KupujacyWAukcjiSzczegoly->{'users-post-buy-data'}) > 0 ) {

                    // numer aukcji do ktorej sa przetwarzane oferty
                    $NumerAukcji = $KupujacyWAukcjiSzczegoly->{'item-id'};

                    // dla kazdej oferty w wybranej aukcji sprawdza dane kupujacego i aktualizuje informacje w tabeli ALLEGRO_AUCTIONS_SOLD
                    foreach ( $KupujacyWAukcjiSzczegoly->{'users-post-buy-data'} as $KupujacySzczegoly ) {

                      $pola = array(
                              array('buyer_email_address',$KupujacySzczegoly->{'user-data'}->{'user-email'}),
                              array('buyer_first_name',$KupujacySzczegoly->{'user-data'}->{'user-first-name'}),
                              array('buyer_last_name',$KupujacySzczegoly->{'user-data'}->{'user-last-name'}),
                              array('buyer_company',$KupujacySzczegoly->{'user-data'}->{'user-company'}),
                              array('buyer_street',$KupujacySzczegoly->{'user-data'}->{'user-address'}),
                              array('buyer_postcode',$KupujacySzczegoly->{'user-data'}->{'user-postcode'}),
                              array('buyer_city',$KupujacySzczegoly->{'user-data'}->{'user-city'}),
                              array('buyer_phone',$KupujacySzczegoly->{'user-data'}->{'user-phone'}),
                              array('buyer_state_id',$KupujacySzczegoly->{'user-data'}->{'user-state-id'}),
                              array('buyer_country',$TablicaKrajow[$KupujacySzczegoly->{'user-data'}->{'user-country-id'}]),
                              array('buyer_shipping_first_name',$KupujacySzczegoly->{'user-sent-to-data'}->{'user-first-name'}),
                              array('buyer_shipping_last_name',$KupujacySzczegoly->{'user-sent-to-data'}->{'user-last-name'}),
                              array('buyer_shipping_company',$KupujacySzczegoly->{'user-sent-to-data'}->{'user-company'}),
                              array('buyer_shipping_street',$KupujacySzczegoly->{'user-sent-to-data'}->{'user-address'}),
                              array('buyer_shipping_postcode',$KupujacySzczegoly->{'user-sent-to-data'}->{'user-postcode'}),
                              array('buyer_shipping_city',$KupujacySzczegoly->{'user-sent-to-data'}->{'user-city'}),
                              array('buyer_shipping_country',( $KupujacySzczegoly->{'user-sent-to-data'}->{'user-country-id'} != '' && $KupujacySzczegoly->{'user-sent-to-data'}->{'user-country-id'} != '0' ? $TablicaKrajow[$KupujacySzczegoly->{'user-sent-to-data'}->{'user-country-id'}] : '' )));
                                  
                      $db->update_query('allegro_auctions_sold' , $pola, "  buyer_id = '".$KupujacySzczegoly->{'user-data'}->{'user-id'}."' and auction_id = '".$NumerAukcji."'");	

                    }

                    unset($NumerAukcji);

                }

              }

              unset($TablicaKupujacychWAukcji, $KupujacyWAukcjiSzczegoly, $KupujacySzczegoly);

            }

          }

        }

        // pobranie formularzy pozakupowych wypelnionych przez kupujacych
        if ( count($FormularzePozakupowe) > 0 ) {

            $TablicaDostaw = $allegro->tablicaDostaw();
            $TablicaPlatnosci = $allegro->tablicaPlatnosci();

            foreach ( $FormularzePozakupowe as $Formularz ) {

              // dla kazdego formularza pozakupowego
              foreach ( $Formularz as $FormularzPozakupowy ) {

                $kupujacy_id = $FormularzPozakupowy->{'post-buy-form-buyer-id'};

                // dla kazdego produktu w formularzu
                foreach ( $FormularzPozakupowy->{'post-buy-form-items'} as $Produkt ) {

                    if ( in_array($Produkt->{'post-buy-form-it-id'}, $Aukcje) ) {

                        $pola = array(
                                array('auction_postbuy_forms','1'));
                              
                        $db->update_query('allegro_auctions_sold' , $pola, " auction_id = '".$Produkt->{'post-buy-form-it-id'}."' AND buyer_id = '".$kupujacy_id."'");
                        unset($pola);

                        // sprawdzenie czy w bazie sa juz informacje o takim formularzu
                        $zapytanie_t = "SELECT auction_id, transaction_id, buyer_id FROM allegro_transactions WHERE transaction_id = '".$FormularzPozakupowy->{'post-buy-form-id'}."' AND buyer_id = '".$FormularzPozakupowy->{'post-buy-form-buyer-id'}."' AND auction_id = '".$Produkt->{'post-buy-form-it-id'}."'";

                        $sqlt = $db->open_query($zapytanie_t);

                        $dostawa = '';
                        $dostawa = $TablicaDostaw[$FormularzPozakupowy->{'post-buy-form-shipment-id'}];

                        if ( isset($FormularzPozakupowy->{'post-buy-form-gd-address'}) ) {
                            if ( isset($FormularzPozakupowy->{'post-buy-form-gd-address'}->{'post-buy-form-adr-full-name'}) && $FormularzPozakupowy->{'post-buy-form-gd-address'}->{'post-buy-form-adr-full-name'} != '') {
                                $dostawa .= ' (' . $FormularzPozakupowy->{'post-buy-form-gd-address'}->{'post-buy-form-adr-full-name'} . ', ' . $FormularzPozakupowy->{'post-buy-form-gd-address'}->{'post-buy-form-adr-street'} . ', ' . $FormularzPozakupowy->{'post-buy-form-gd-address'}->{'post-buy-form-adr-city'} . ')';
                            }
                        }

                        $pola = array(
                                array('auction_id',$Produkt->{'post-buy-form-it-id'}),
                                array('transaction_id',$FormularzPozakupowy->{'post-buy-form-id'}),
                                array('buyer_id',$FormularzPozakupowy->{'post-buy-form-buyer-id'}),
                                array('post_buy_form_amount',$FormularzPozakupowy->{'post-buy-form-amount'}),

                                array('post_buy_form_created_date',strtotime($FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-created-date'})),

                                array('post_buy_form_it_quantity',$Produkt->{'post-buy-form-it-quantity'}),
                                array('post_buy_form_it_amount',$Produkt->{'post-buy-form-it-amount'}),

                                array('post_buy_form_postage_amount',$FormularzPozakupowy->{'post-buy-form-postage-amount'}),
                                array('post_buy_form_invoice_option',$FormularzPozakupowy->{'post-buy-form-invoice-option'}),
                                array('post_buy_form_msg_to_seller',$FormularzPozakupowy->{'post-buy-form-msg-to-seller'}),

                                array('billing_post_buy_form_adr_country',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-country'}),
                                array('billing_post_buy_form_adr_street',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-street'}),
                                array('billing_post_buy_form_adr_postcode',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-postcode'}),
                                array('billing_post_buy_form_adr_city',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-city'}),
                                array('billing_post_buy_form_adr_full_name',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-full-name'}),
                                array('billing_post_buy_form_adr_company',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-company'}),
                                array('billing_post_buy_form_adr_phone',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-phone'}),
                                array('billing_post_buy_form_adr_nip',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-nip'}),
                                array('billing_post_buy_form_adr_type',$FormularzPozakupowy->{'post-buy-form-invoice-data'}->{'post-buy-form-adr-type'}),

                                array('shipping_post_buy_form_adr_country',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-country'}),
                                array('shipping_post_buy_form_adr_street',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-street'}),
                                array('shipping_post_buy_form_adr_postcode',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-postcode'}),
                                array('shipping_post_buy_form_adr_city',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-city'}),
                                array('shipping_post_buy_form_adr_full_name',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-full-name'}),
                                array('shipping_post_buy_form_adr_company',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-company'}),
                                array('shipping_post_buy_form_adr_phone',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-phone'}),
                                array('shipping_post_buy_form_adr_nip',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-nip'}),
                                array('shipping_post_buy_form_adr_type',$FormularzPozakupowy->{'post-buy-form-shipment-address'}->{'post-buy-form-adr-type'}),

                                array('post_buy_form_pay_type',$TablicaPlatnosci[$FormularzPozakupowy->{'post-buy-form-pay-type'}]),
                                array('post_buy_form_pay_id',$FormularzPozakupowy->{'post-buy-form-pay-id'}),
                                array('post_buy_form_pay_status',$FormularzPozakupowy->{'post-buy-form-pay-status'}),
                                array('post_buy_form_date_init',$FormularzPozakupowy->{'post-buy-form-date-init'}),
                                array('post_buy_form_date_recv',$FormularzPozakupowy->{'post-buy-form-date-recv'}),
                                array('post_buy_form_date_cancel',$FormularzPozakupowy->{'post-buy-form-date-cancel'}),
                                array('post_buy_form_payment_amount',$FormularzPozakupowy->{'post-buy-form-payment-amount'}),
                                array('post_buy_form_shipment_id',$dostawa)
                        );

                        if ( $db->ile_rekordow($sqlt) == 0 ) {

                          $db->insert_query('allegro_transactions' , $pola);

                        } else {
                          $infot = $sqlt->fetch_assoc();

                          //if ( $FormularzPozakupowy->{'post-buy-form-id'} > $infot['transaction_id'] ) {
                              $db->update_query('allegro_transactions' , $pola, " transaction_id = '".$FormularzPozakupowy->{'post-buy-form-id'}."' AND buyer_id = '".$FormularzPozakupowy->{'post-buy-form-buyer-id'}."' AND auction_id = '".$Produkt->{'post-buy-form-it-id'}."'");
                          //}

                        }

                        unset($pola, $infot);

                    }

                }

              }
            }

            unset($TablicaDostaw, $TablicaPlatnosci);

        }

      }

  }
  
  echo $wynikDoAjaxa;
}
?>