<?php

if(!class_exists('wysylka_inpost')) {
  class wysylka_inpost {

    var $inpost_api_url  = 'http://api.paczkomaty.pl';

    // class constructor
    function __construct( $parametry = array(), $kraj = '', $idProduktu = '', $WagaProduktu = '', $CenaProduktu = '', $WysylkiProduktu = '', $GabarytProduktu = '', $KosztWysylkiProduktu = '0', $WykluczonaDarmowaWysylka = 'nie' ) {
      global $zamowienie, $Tlumaczenie;

        $Tlumaczenie = $GLOBALS['tlumacz'];

        $this->paramatery  = $parametry;

        // czy przesylka ma byc liczona dla produktu czy koszyka
        $this->produktId           = $idProduktu;
        $this->produktWaga         = $WagaProduktu;
        $this->produktCena         = $CenaProduktu;
        $this->produktWysylki      = $WysylkiProduktu;
        $this->produktGabaryt      = $GabarytProduktu;
        $this->produktKosztWysylki = $KosztWysylkiProduktu;
        $this->wykluczonaDarmowaWysylka = $WykluczonaDarmowaWysylka;

        $this->tytul                = ( isset($Tlumaczenie['WYSYLKA_'.$this->paramatery['id'].'_TYTUL']) ? $Tlumaczenie['WYSYLKA_'.$this->paramatery['id'].'_TYTUL'] : '' );
        $this->objasnienie          = ( isset($Tlumaczenie['WYSYLKA_'.$this->paramatery['id'].'_OBJASNIENIE']) ? $Tlumaczenie['WYSYLKA_'.$this->paramatery['id'].'_OBJASNIENIE'] : '' );
        $this->kolejnosc            = $this->paramatery['sortowanie'];
        $this->klasa                = $this->paramatery['klasa'];
        $this->ikona                = '';
        $this->wyswietl             = false;
        $this->id                   = $this->paramatery['id'];
        $this->ilosc_paczek_wg_wagi = 1;
        $this->ilosc_paczek_wg_szt  = 1;        

        $this->gabaryt          = $this->paramatery['parametry']['WYSYLKA_GABARYT'];
        $this->stawka_vat       = $this->paramatery['parametry']['WYSYLKA_STAWKA_VAT'];
        $this->pkwiu            = $this->paramatery['parametry']['WYSYLKA_PKWIU'];
        $this->max_waga         = $this->paramatery['parametry']['WYSYLKA_MAKSYMALNA_WAGA'];
        $this->max_waga_tryb    = $this->paramatery['parametry']['WYSYLKA_MAKSYMALNA_WAGA_TRYB'];
        $this->max_ilosc_prod   = $this->paramatery['parametry']['WYSYLKA_MAKSYMALNA_ILOSC_W_PACZCE'];        
        $this->max_wartosc      = $GLOBALS['waluty']->PokazCeneBezSymbolu($this->paramatery['parametry']['WYSYLKA_MAKSYMALNA_WARTOSC'],'',true);
        $this->darmowa          = $GLOBALS['waluty']->PokazCeneBezSymbolu($this->paramatery['parametry']['WYSYLKA_DARMOWA_WYSYLKA'],'',true);
        $this->darmowa_promocje = $this->paramatery['parametry']['WYSYLKA_DARMOWA_PROMOCJE'];
        $this->rodzaj_oplaty    = $this->paramatery['parametry']['WYSYLKA_RODZAJ_OPLATY'];
        $this->kraje            = $this->paramatery['parametry']['WYSYLKA_KRAJE_DOSTAWY'];
        $this->koszty           = $this->paramatery['parametry']['WYSYLKA_KOSZT_WYSYLKI'];
        $this->platnosci        = $this->paramatery['parametry']['WYSYLKA_DOSTEPNE_PLATNOSCI'];
        $this->grupa            = $this->paramatery['parametry']['WYSYLKA_GRUPA_KLIENTOW'];
        $this->grupa_wylacz     = $this->paramatery['parametry']['WYSYLKA_GRUPA_KLIENTOW_WYLACZENIE'];
        $this->ikona            = $this->paramatery['parametry']['WYSYLKA_IKONA'];

        $this->waga_zamowienia    = $this->paramatery['waga_zamowienia'];
        $this->ilosc_produktow    = $this->paramatery['ilosc_produktow'];
        $this->wartosc_zamowienia = $this->paramatery['wartosc_zamowienia'];
        $this->wartosc_zamowienia_bez_promocji = $this->paramatery['wartosc_zamowienia_bez_promocji']; 

        unset($Tlumaczenie);

    }

    function przetwarzanie() {

      $wynik = array();
      $koszt_wysylki = 0;

      if ( isset($_SESSION['adresDostawy']) ) {
          if ( !Funkcje::CzyNumerGSM($_SESSION['adresDostawy']['telefon']) ) {
              return;
          }
      }

      if ( $this->grupa != '' && $_SESSION['gosc'] == '1' ) {
          return;
      }

      // ustalenie czy przesylka zawiera sie w dopuszczalnej wartości zamowienia
      if ( $this->max_wartosc != '0' && $this->max_wartosc != '' && $this->wartosc_zamowienia > $this->max_wartosc ) {
          return;
      }

      // ustalenie czy klient nalezy do grupy dla ktorej dostepna jest wysylka
      if ( $this->grupa != '' ) {

            if ( isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0' ) {

                $tablica_grup = explode(';',$this->grupa);
                if ( !in_array($_SESSION['customers_groups_id'], $tablica_grup) ) {
                    return;
                }

            }
      }
      
      // ustalenie czy klient nalezy do grupy ktora nie jest dostepna dla tej wysylki
      if ( $this->grupa_wylacz != '' ) {

            if ( isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0' ) {

                $tablica_grup = explode(';',$this->grupa_wylacz);
                if ( in_array($_SESSION['customers_groups_id'], $tablica_grup) ) {
                    return;
                }
                unset($tablica_grup);

            }
      }      

      // sprawdzenie czy dostawa jest dostepna dla wszystkich produktow w koszyku
      if ( $this->produktId == '' && $this->produktWaga == '' && $this->produktCena == '' ) {
           foreach ( $_SESSION['koszyk'] as $rekord ) {
            // sprawdza czy jest indywidualny koszt wysylki
            if ( $rekord['koszt_wysylki'] > 0 ) {
                return;
            }
            // sprawdza czy sa ustawione indywidualne metody wysylki
            if ( $rekord['wysylki'] != '' ) {
              $dostepne = explode(';',$rekord['wysylki']);
              if (!in_array($this->id, $dostepne) ) {
                return;
              }
            }
            // sprawdza czy jest gabaryt
            if ( $this->gabaryt == '0' ) {
                if ( $rekord['gabaryt'] == '1' ) {
                    return;
                }
            }
          }
      } else {
          // sprawdza czy jest indywidualny koszt wysylki
          if ( $this->produktKosztWysylki > 0 ) {
              return;
          }
          if ( $this->produktWysylki != '' ) {
              $dostepne = explode(';',$this->produktWysylki);
              if (!in_array($this->id, $dostepne) ) {
                return;
              }
          }
          if ( $this->gabaryt == '0' ) {
              if ( $this->produktGabaryt == '1' ) {
                  return;
              }
          }
      }

      $tablica_kosztow = preg_split("/[:;]/" , $this->koszty);
      
      // jezeli ilosc produktow jest wieksza niz maksymalna
      if ( $this->ilosc_produktow > $this->max_ilosc_prod ) {
           $this->ilosc_paczek_wg_szt = ceil($this->ilosc_produktow/$this->max_ilosc_prod);
      }      

      switch ($this->rodzaj_oplaty) {

          // jezeli jest stala oplata
          case '1':
            $koszt_wysylki = $tablica_kosztow[count($tablica_kosztow)-1];
            
            // jezeli laczna waga zamowienia przekracza maksymalna wage to robi wieksza ilosc paczek
            $dostepnosc = $this->przeliczPaczki();            
            
            if ( $dostepnosc == false ) {
                return;
            }            

            $this->wyswietl = true;
            break;

          // jezeli oplata jest wg wagi zamowienia
          case '2':
            $dostepnosc = false;
            
            // jezeli laczna waga zamowienia przekracza maksymalna wage to robi wieksza ilosc paczek
            if ( $this->waga_zamowienia > $this->max_waga ) {
                if ( $this->max_waga_tryb == 'paczki' ) {
                  $this->ilosc_paczek_wg_wagi = ceil($this->waga_zamowienia/$this->max_waga);
                  $this->waga_zamowienia = $this->max_waga;
                } else {
                  return;
                }
            }                   

            for ($i = 0, $c = count($tablica_kosztow); $i < $c; $i+=2) {
              if ( $this->waga_zamowienia <= $tablica_kosztow[$i] ) {
                $koszt_wysylki = $tablica_kosztow[$i+1];
                $dostepnosc = true;
                break;
              }
            }

            if ( $dostepnosc == false ) {
                return;
            }
            $this->wyswietl = true;
            break;

          // jezeli oplata jest wg wartosci zamowienia
          case '3':
            $dostepnosc = false;
            for ($i = 0, $c = count($tablica_kosztow); $i < $c; $i+=2) {
              if ( $this->wartosc_zamowienia <= $GLOBALS['waluty']->PokazCeneBezSymbolu($tablica_kosztow[$i],'',true) ) {
                $koszt_wysylki = $tablica_kosztow[$i+1];
                $dostepnosc = true;
                break;
              }
            }
            
            if ( $dostepnosc == false ) {
                return;
            }

            // jezeli laczna waga zamowienia przekracza maksymalna wage to robi wieksza ilosc paczek
            $dostepnosc = $this->przeliczPaczki();        
            
            if ( $dostepnosc == false ) {
                return;
            }

            $this->wyswietl = true;
            break;

          // jezeli oplata jest wg ilosci produktow w zamowieniu
          case '4':
            $dostepnosc = false;
            for ($i = 0, $c = count($tablica_kosztow); $i < $c; $i+=2) {
              if ( $this->ilosc_produktow <= $tablica_kosztow[$i] ) {
                $koszt_wysylki = $tablica_kosztow[$i+1];
                $dostepnosc = true;
                break;
              }
            }
            
            if ( $dostepnosc == false ) {
                return;
            }            

            // jezeli laczna waga zamowienia przekracza maksymalna wage to robi wieksza ilosc paczek
            $dostepnosc = $this->przeliczPaczki();
            
            if ( $dostepnosc == false ) {
                return;
            }

            $this->wyswietl = true;
            break;
            
          // jezeli oplata jest wg gabarytu przesylki
          case '5':
            $dostepnosc = false;
            $wszystkieInpost = true;
            
            // sprawdzi czy w koszyku wszystkie produkty maja przypisany gabaryt
            foreach ( $_SESSION['koszyk'] as $rekord ) {
                //
                if ( $rekord['inpost_gabaryt'] == 'x' ) {
                     $wszystkieInpost = false;
                }
                //
            }
            
            if ( $this->produktId != '' ) {
                //
                $Produkt = new Produkt($this->produktId);
                if ( $Produkt->info['inpost_gabaryt'] == 'x' ) {
                     $wszystkieInpost = false;
                }
                unset($Produkt);
                //              
            }
            
            if ( $wszystkieInpost == true && $tablica_kosztow[0] == 'GABARYT' ) {
                //
                // koszty dla gabarytow
                $koszt_gabaryt_a = $tablica_kosztow[2]; 
                $koszt_gabaryt_b = $tablica_kosztow[4]; // wchodzi 2 razy A
                $koszt_gabaryt_c = $tablica_kosztow[6]; // wchodzi 5 razy A
                //
                $ilosc_max_a = 0;
                $ilosc_max_b = 0;
                $ilosc_max_c = 0;
                //
                
                // dla pojedynczego produktu
                if ( $this->produktId != '' ) {
                    //
                    $Produkt = new Produkt($this->produktId);
                    //
                    if ( $Produkt->info['inpost_gabaryt'] == 'a' ) {
                         //
                         $ilosc_max_a = 1 / $Produkt->info['inpost_ilosc'];
                         //
                    }
                    if ( $Produkt->info['inpost_gabaryt'] == 'b' ) {
                         //
                         $ilosc_max_b = 1 / $Produkt->info['inpost_ilosc'];
                         //
                    }
                    if ( $Produkt->info['inpost_gabaryt'] == 'c' ) {
                         //
                         $ilosc_max_c = 1 / $Produkt->info['inpost_ilosc'];
                         //
                    }                     
                    //                    
                    unset($Produkt);
                    //
                } else {      
                    //
                    // ustali jaka paczka
                    foreach ( $_SESSION['koszyk'] as $rekord ) {
                        //
                        if ( $rekord['inpost_gabaryt'] == 'a' ) {
                             //
                             $ilosc_max_a += $rekord['ilosc'] / $rekord['inpost_ilosc'];
                             //
                        }
                        if ( $rekord['inpost_gabaryt'] == 'b' ) {
                             //
                             $ilosc_max_b += $rekord['ilosc'] / $rekord['inpost_ilosc'];
                             //
                        }
                        if ( $rekord['inpost_gabaryt'] == 'c' ) {
                             //
                             $ilosc_max_c += $rekord['ilosc'] / $rekord['inpost_ilosc'];
                             //
                        }                     
                        //
                    }
                }
                
                //
                $ilosc_max = ceil($ilosc_max_a) + ceil($ilosc_max_b * 2) + ceil($ilosc_max_c * 5);

                //
                // wielkosc paczki
                if ( $ilosc_max == 1 ) {
                     $koszt_wysylki = $koszt_gabaryt_a;
                     $dostepnosc = true;
                }
                if ( $ilosc_max > 1 && $ilosc_max <= 2 ) {
                     $koszt_wysylki = $koszt_gabaryt_b;
                     $dostepnosc = true;
                }
                if ( $ilosc_max > 2 ) {
                     $koszt_wysylki = $koszt_gabaryt_c;
                     $dostepnosc = true;
                }                
                if ( $ilosc_max > 5 ) {
                     $dostepnosc = false;
                }       

                unset($koszt_gabaryt_a, $koszt_gabaryt_b, $koszt_gabaryt_c, $ilosc_max_a, $ilosc_max_b, $ilosc_max_c, $ilosc_max);

            }
            
            unset($wszystkieInpost);

            if ( $dostepnosc == false ) {
                return;
            }            

            // jezeli laczna waga zamowienia przekracza maksymalna wage to robi wieksza ilosc paczek
            $dostepnosc = $this->przeliczPaczki();
            
            if ( $dostepnosc == false ) {
                return;
            }

            $this->wyswietl = true;
            break;            

      }
      
      // sprawdza czy jest wiecej paczek niz 1
      if ( $this->ilosc_paczek_wg_wagi > 1 || $this->ilosc_paczek_wg_szt > 1 ) {
           //
           if ( $this->ilosc_paczek_wg_wagi > $this->ilosc_paczek_wg_szt ) {
                $koszt_wysylki = $this->ilosc_paczek_wg_wagi * $koszt_wysylki;
            } else {
                for ($i = 0, $c = count($tablica_kosztow); $i < $c; $i+=2) {
                  if ( $this->max_ilosc_prod <= $tablica_kosztow[$i] ) {
                    $koszt_wysylki = $tablica_kosztow[$i+1];
                    break;
                  }
                }
                $koszt_wysylki = $this->ilosc_paczek_wg_szt * $koszt_wysylki;
           }
           //
      }      
      
      // sprawdzi czy w koszyku nie ma produktu z wykluczona darmowa wysylka
      $wykluczona_darmowa = false;
      foreach ( $_SESSION['koszyk'] as $rekord ) {
          //
          if ( $rekord['wykluczona_darmowa_wysylka'] == 'tak' ) {
               $wykluczona_darmowa = true;
          }
          //
      }
      
      if ( $this->produktId != '' ) {
          //
          if ( $this->wykluczonaDarmowaWysylka == 'tak' ) {
               $wykluczona_darmowa = true;
          }
          //
      }      
      
      if ( $wykluczona_darmowa == true ) {
           $this->darmowa = 0;
      }      

      // jezeli jest darmowa wysylka
      if ( $this->darmowa != '0' && $this->darmowa != '' && (($this->darmowa_promocje == 'nie') ? $this->wartosc_zamowienia_bez_promocji : $this->wartosc_zamowienia) >= $this->darmowa && $wykluczona_darmowa == false ) {
        $koszt_wysylki = 0;
      }

      if ( $this->wyswietl ) {
      
        $vat_tb = explode('|', $this->stawka_vat);
        if ( count($vat_tb) == 2 ) {
            //
            $vat_id = $vat_tb[1];
            $vat_stawka = $vat_tb[0];
            //
          } else {
            //
            $vat_tb = Funkcje::domyslnyPodatekVat();
            $vat_id = $vat_tb['id'];
            $vat_stawka = $vat_tb['stawka'];        
            //
        }
        unset($vat_tb);    

        // dzien darmowej dostawy
        if ( DZIEN_DARMOWEJ_DOSTAWY == 'tak' && (( DZIEN_DARMOWEJ_DOSTAWY_KRAJE == 'domyślny' && isset($_SESSION['krajDostawy']) && isset($_SESSION['krajDostawyDomyslny']) && $_SESSION['krajDostawy']['id'] == $_SESSION['krajDostawyDomyslny']['id'] ) || DZIEN_DARMOWEJ_DOSTAWY_KRAJE == 'wszystkie kraje' ) ) {
            $koszt_wysylki = 0;
        }  
      
        if ( isset($_SESSION['netto']) && $_SESSION['netto'] == 'tak' ) {
             //
             // obliczy netto wysylki
             if ( $koszt_wysylki > 0 ) {
                  $koszt_wysylki = $koszt_wysylki / ((100 + $vat_stawka) / 100);
             }
             //
             $vat_id = $_SESSION['vat_zwolniony_id'];
             $vat_stawka = $_SESSION['vat_zwolniony_wartosc'];
             //
        }
        
        $wynik = array('id' => $this->id,
                       'klasa' => $this->klasa,
                       'text' => $this->tytul,
                       'wartosc' => $koszt_wysylki,
                       'vat_id' => $vat_id,
                       'vat_stawka' => $vat_stawka,                        
                       'dostepne_platnosci' => $this->platnosci,
                       'objasnienie' => $this->objasnienie,
                       'wysylka_free' => $this->darmowa,
                       'free_promocje' => $this->darmowa_promocje,
                       'ikona' => $this->ikona);
                       
      }

      return $wynik;
    }

    function potwierdzenie() {
        global $Tlumaczenie;

        $tekst = '';
        $paczkomaty = array();

        $paczkomaty = $this->pobierz_paczkomaty($_SESSION['adresDostawy']['kod_pocztowy']);
        $paczkomatyAll = $this->pobierz_paczkomaty_wszystkie();

        $domyslny = true;
        $zaznaczonyPunktOdbioru = '';

        $tekst .= '
            <h3>'.$Tlumaczenie['INPOST_WYBIERZ_PACZKOMAT'].'</h3>
            <div class="ListaWyboru"><div id="ListaOpcjiWysylki">
            <select id="wybor_paczkomatu" name="lokalizacjaPaczkomat">';
            if ( is_array($paczkomaty) && count($paczkomaty) > 0 ) {
                $paczkomatPodstawowy = reset($paczkomaty);

                if ( !isset($_SESSION['rodzajDostawy']['opis']) ) {
                    $_SESSION['rodzajDostawy']['opis'] = 'Paczkomat '.$paczkomatPodstawowy['kodPaczkomatu'].', '.$paczkomatPodstawowy['adresPaczkomatu'];
                }
                if ( !isset($_SESSION['rodzajDostawy']['punktodbioru']) ) {
                    $_SESSION['rodzajDostawy']['punktodbioru'] = $paczkomatPodstawowy['kodPaczkomatu'];
                    $zaznaczonyPunktOdbioru = $paczkomatPodstawowy['kodPaczkomatu'];
                }

                $tekst .= '<optgroup label="Paczkomaty najbliżej kodu pocztowego">';

                foreach ($paczkomaty as $paczkomat) {
                    $zaznaczony = '';
                    if ( isset($_SESSION['rodzajDostawy']['opis']) ) {
                        if ( $_SESSION['rodzajDostawy']['opis'] == 'Paczkomat '.$paczkomat['kodPaczkomatu'].', '.$paczkomat['adresPaczkomatu'] ) {
                            $zaznaczony = ' selected="selected" ';
                            $zaznaczonyPunktOdbioru = $paczkomat['kodPaczkomatu'];
                        }
                    }

                    $tekst .= '<option id="'.$paczkomat['kodPaczkomatu'].'" '.$zaznaczony. ' value="Paczkomat '.$paczkomat['kodPaczkomatu'].', '.$paczkomat['adresPaczkomatu'].'">'.$paczkomat['kodPaczkomatu'].', '.$paczkomat['adresPaczkomatu'].', ('.$paczkomat['odleglosc'].'km od '.$_SESSION['adresDostawy']['kod_pocztowy'].')</option>';

                    unset($paczkomatyAll[$paczkomat['kodPaczkomatu']]);
                }
            }
            
            if ( is_array($paczkomatyAll) && count($paczkomatyAll) > 0 ) {
                $tekst .= '<optgroup label="Wszystkie paczkomaty">';
                foreach ($paczkomatyAll as $paczkomat) {
                    $zaznaczony = '';
                    $zaznaczonyPunktOdbioru = '';
                    if ( isset($_SESSION['rodzajDostawy']['opis']) ) {
                        if ( $_SESSION['rodzajDostawy']['opis'] == 'Paczkomat '.$paczkomat['kodPaczkomatu'].', '.$paczkomat['adresPaczkomatu'] ) {
                            $zaznaczony = ' selected="selected" ';
                            $zaznaczonyPunktOdbioru = $paczkomat['kodPaczkomatu'];
                        }
                    }
                    if ( $paczkomat['miasto'] != '' ) {
                        $tekst .= '<option id="'.$paczkomat['kodPaczkomatu'].'" '.$zaznaczony. ' value="Paczkomat '.$paczkomat['kodPaczkomatu'].', '.$paczkomat['adresPaczkomatu'].'">'.$paczkomat['miasto'] . ', ' . $paczkomat['ulica'] . ', ' . $paczkomat['kodPaczkomatu'].'</option>';
                    }
                }
            }
            
        $tekst .= '</select>';
        $tekst .= '<input type="hidden" id="ShippingDestinationCode" value="'.$zaznaczonyPunktOdbioru.'" name="ShippingDestinationCode" />';

        $tekst .= '</div></div>';

        return $tekst;
    }

    //pobranie listy najblizszych paczkomatow
    function pobierz_paczkomaty($postcode) {

        if ( strpos($postcode, '-') === false ) {
            $postcode = substr($postcode,0,2).'-'.substr($postcode,2,5);
        }

        if ($machinesContents = $this->file_get_contents_curl("$this->inpost_api_url/?do=findnearestmachines_csv&postcode=$postcode")) {
        
          if ($machinesContents=='Error') return 0;
          $machinesArray = preg_split("/\n/",$machinesContents);
          
          if (count($machinesArray)) {
          
            foreach ($machinesArray as $machine) {
            
              $machine = preg_split("/;/",$machine);
              
              $paczkomat = array('kodPaczkomatu'   => (isset($machine[0]) ? $machine[0] : '' ),
                                 'adresPaczkomatu' => (isset($machine[1]) ? $machine[1] : '' ),
                                 'kodPocztowy'     => (isset($machine[2]) ? $machine[2] : '' ),
                                 'odleglosc'       => (isset($machine[3]) ? $machine[3] : '' ),
                                 'pobranie'        => (isset($machine[4]) ? $machine[4] : '' ),
                                 'miasto'          => '',
                                 'ulica'           => '');
                                 
              $data[$machine[0]] = $paczkomat;
            }      
            
            return $data;   
            
          } 
          
        }
        
        return 0;
      
    }

    //pobranie listy wszystkich paczkomatow
    function pobierz_paczkomaty_wszystkie() {

        if ($machinesContents = $this->file_get_contents_curl("$this->inpost_api_url/?do=listmachines_csv")) {
          if ($machinesContents=='Error') return 0;
          $machinesArray = preg_split("/\n/",$machinesContents);
          
          if (count($machinesArray)) {
          
            foreach ($machinesArray as $machine) {
            
              $machine = preg_split("/;/",$machine);
              
              $paczkomat = array();
              
              $paczkomat = array('kodPaczkomatu'   => (isset($machine[0]) ? $machine[0] : '' ),
                                 'adresPaczkomatu' => (isset($machine[1]) ? $machine[1] : '' ) . ' ' . (isset($machine[2]) ? $machine[2] : '' ) . ', ' . (isset($machine[4]) ? $machine[4] : '' ),
                                 'kodPocztowy'     => (isset($machine[3]) ? $machine[3] : '' ),
                                 'odleglosc'       => '0',
                                 'pobranie'        => (isset($machine[12]) ? $machine[12] : '' ),
                                 'miasto'          => (isset($machine[4]) ? $machine[4] : '' ),
                                 'ulica'           => (isset($machine[1]) ? $machine[1] : '' ) . ' ' .( isset($machine[2]) ? $machine[2] : '' ));
                                 
              $data[$machine[0]] = $paczkomat;
              unset($paczkomat);
              
            }            
            
            return $data;   
          } 
          
        }
        
        return 0;
      
    }

    public function file_get_contents_curl($url) {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);

        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }
    
    function przeliczPaczki() {

        // jezeli laczna waga zamowienia przekracza maksymalna wage to robi wieksza ilosc paczek
        if ( $this->waga_zamowienia > $this->max_waga ) {
            if ( $this->max_waga_tryb == 'paczki' ) {
              //
              $this->ilosc_paczek_wg_wagi = ceil($this->waga_zamowienia/$this->max_waga);
              return true;
              //
            } else {
              //
              return false;
              //
            }
        }  
        
        return true;

    }    

  }
}
?>