<?php

// plik
$WywolanyPlik = 'kategoria_artykulow';

include('start.php');

$KategoriaArtykulu = Aktualnosci::KategoriaAktualnoscId( (int)$_GET['idkatart'] );

if (!empty($KategoriaArtykulu)) {    
    //
    // sprawdzenie linku SEO z linkiem w przegladarce
    
    $LinkDoPrzenoszenia = $KategoriaArtykulu['seo'];
    
    Seo::link_Spr($KategoriaArtykulu['seo']);
    
    $Meta = MetaTagi::ZwrocMetaTagi( basename(__FILE__) );
    // meta tagi
    $tpl->dodaj('__META_TYTUL', ((empty($KategoriaArtykulu['meta_tytul'])) ? $Meta['tytul'] : $KategoriaArtykulu['meta_tytul']));
    $tpl->dodaj('__META_SLOWA_KLUCZOWE', ((empty($KategoriaArtykulu['meta_slowa'])) ? $Meta['slowa'] : $KategoriaArtykulu['meta_slowa']));
    $tpl->dodaj('__META_OPIS', ((empty($KategoriaArtykulu['meta_opis'])) ? $Meta['opis'] : $KategoriaArtykulu['meta_opis']));
    unset($Meta);

    // Breadcrumb dla kategorii artykulow
    $nawigacja->dodaj($KategoriaArtykulu['nazwa'], $KategoriaArtykulu['seo']);
    $tpl->dodaj('__BREADCRUMB', $nawigacja->sciezka(' ' . $GLOBALS['tlumacz']['NAWIGACJA_SEPARATOR'] . ' '));
    
    // style css
    $tpl->dodaj('__CSS_PLIK', ',listingi');   

    if (isset($_GET['szukaj']) && trim($_GET['szukaj']) != '' && $KategoriaArtykulu['wyszukiwanie'] == 'tak') {    
        //
        $_GET['szukaj'] = strip_tags( rawurldecode($filtr->process($_GET['szukaj'])) );    
        //
        // zamienia zmienne na poprawne znaki
        $_GET['szukaj'] = str_replace(array('[back]', '[proc]'), array('/', '%'), $_GET['szukaj']);
        //
        // zabezpieczenie przez hackiem
        $_GET['szukaj'] = str_replace(array('_', '%'), array('\\_','\\%'), $_GET['szukaj']);
        //
        // usuwanie '
        // sprawdza czy jest wylaczone magic_quotes_gpc
        if (!get_magic_quotes_gpc()) {
            $_GET['szukaj'] = str_replace("'", "\'", $_GET['szukaj']);
        }        
    }

    // wyszukiwanie artykulow
    $TablicaArtykulow = Aktualnosci::TablicaAktualnosciKategoria( (int)$_GET['idkatart'], 9999, array(), ((isset($_GET['szukaj']) && $KategoriaArtykulu['wyszukiwanie'] == 'tak') ? $_GET['szukaj'] : '') );
    
    $IloscArtykulow = count($TablicaArtykulow);
 
    // wyglad srodkowy
    $srodek = new Szablony($Wyglad->TrescLokalna($WywolanyPlik), $IloscArtykulow, $KategoriaArtykulu['wyszukiwanie']);    
    //
    $srodek->dodaj('__NAGLOWEK_KATEGORII_ARTYKULU', $KategoriaArtykulu['nazwa']);
    $srodek->dodaj('__OPIS_KATEGORII_ARTYKULU', $KategoriaArtykulu['opis'] . ((AKTUALNOSCI_STRONICOWANIE == 'tak') ? '<br />' : ''));
    
    $srodek->dodaj('__ZDJECIE_KATEGORII_ARTYKULU', '');
    if ( strlen($KategoriaArtykulu['opis']) > 10 && $KategoriaArtykulu['foto'] != '' ) {
         $srodek->dodaj('__ZDJECIE_KATEGORII_ARTYKULU', Funkcje::pokazObrazek($KategoriaArtykulu['foto'], $KategoriaArtykulu['nazwa'], SZEROKOSC_OBRAZEK_MALY, WYSOKOSC_OBRAZEK_MALY, array(), 'class="ZdjecieKategAktualnosci"'));   
    }
    // 

    $srodek->dodaj('__ILOSC_WYNIKOW_WYSZUKIWANIA',$IloscArtykulow);
    $srodek->dodaj('__WARUNKI_SZUKANIA','<p><span>' . $GLOBALS['tlumacz']['NAGLOWEK_WYNIKI_SZUKANIA'] . ':</span> <b>' . ((isset($_GET['szukaj'])) ? $_GET['szukaj'] : '') . '</b></p>');
    $srodek->dodaj('__LINK_STRONY',$LinkDoPrzenoszenia);
    
    // stronicowanie
    $srodek->dodaj('__STRONICOWANIE', '');
    //
    $LinkPrev = '';
    $LinkNext = '';
    //  
    
    if ( AKTUALNOSCI_STRONICOWANIE == 'tak' && $IloscArtykulow > (int)AKTUALNOSCI_ILOSC_NA_STRONIE ) {

        if ($IloscArtykulow > 0) { 
            //
            $Strony = Stronicowanie::PokazStrony($IloscArtykulow, $LinkDoPrzenoszenia, (int)AKTUALNOSCI_ILOSC_NA_STRONIE);
            //
            $LinkPrev = ((!empty($Strony[2])) ? "\n" . $Strony[2] : '');
            $LinkNext = ((!empty($Strony[3])) ? "\n" . $Strony[3] : '');    
            //    
            $LinkiDoStron = $Strony[0];
            $LimitSql = $Strony[1];
            //
            $srodek->dodaj('__STRONICOWANIE', $LinkiDoStron);
            //
            $TablicaArtykulow = Aktualnosci::TablicaAktualnosciKategoria( (int)$_GET['idkatart'], 9999, array($LimitSql, (int)AKTUALNOSCI_ILOSC_NA_STRONIE), ((isset($_GET['szukaj'])) ? $_GET['szukaj'] : '') );
            //
            unset($Strony, $LinkiDoStron, $LimitSql);
        }
        //       
    
    }
    
    ob_start();
    
    // listing wersji mobilnej
    if ( $_SESSION['mobile'] == 'tak' ) {       

        if (in_array( 'listing_artykuly_kategorii.mobilne.php', $Wyglad->PlikiListingiLokalne )) {
            require('szablony/'.DOMYSLNY_SZABLON.'/listingi_lokalne/listing_artykuly_kategorii.mobilne.php');
        }
        
      } else {
     
        if (in_array( 'listing_artykuly_kategorii.php', $Wyglad->PlikiListingiLokalne )) {
            require('szablony/'.DOMYSLNY_SZABLON.'/listingi_lokalne/listing_artykuly_kategorii.php');
          } else {
            require('listingi/listing_artykuly_kategorii.php');
        }     
      
    }

    $ListaArtykulow = ob_get_contents();
    ob_end_clean(); 

    //
    $srodek->dodaj('__ARTYKULY_KATEGORII', $ListaArtykulow);
    
    $tpl->dodaj('__LINK_CANONICAL', '<link rel="canonical" href="' . ADRES_URL_SKLEPU . '/' . $LinkDoPrzenoszenia . '" />' . $LinkPrev . $LinkNext);
    //
    unset($IloscArtykulow, $ListaArtykulow, $TablicaArtykulow, $LinkDoPrzenoszenia);    
    //
  } else {
    //
    unset($WywolanyPlik);
    //
    Funkcje::PrzekierowanieURL('brak-strony.html'); 
    //    
}

$tpl->dodaj('__SRODKOWA_KOLUMNA', $srodek->uruchom());
unset($srodek, $WywolanyPlik, $KategoriaArtykulu);

include('koniec.php');

?>