<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

require_once('../tcpdf/config/lang/pol.php');
require_once('../tcpdf/tcpdf.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

  if ( isset($_GET['id_poz']) && (int)$_GET['id_poz'] > 0 ) {
    $zamowienie = new Zamowienie((int)$_GET['id_poz']);
  } else {
    exit;
  }
  
  if ( isset($zamowienie->klient['id']) && !empty($zamowienie->klient['id']) ) {
  
  $i18n = new Translator($db, $_SESSION['domyslny_jezyk']['id']);
  $tlumacz = $i18n->tlumacz( array('WYGLAD', 'KLIENCI', 'KLIENCI_PANEL', 'PRODUKT', 'FAKTURA') );

  class MYPDF extends TCPDF {
    // Stopka
    public function Footer() {
      global $tlumacz;
      // Position at 15 mm from bottom
      $this->SetY(-15);
      // Set font
      $this->SetFont('helvetica', 'I', 6);
      // Page number
      $this->Cell(0, 0, $tlumacz['WYGENEROWANO_W_PROGRAMIE'], 'T', false, 'L', 0, '', 0, false, 'T', 'M');
    }

    public function Header() {

              if ( PDF_PLIK_NAGLOWKA != '' && file_exists(KATALOG_SKLEPU . KATALOG_ZDJEC . '/'.PDF_PLIK_NAGLOWKA)) {
                $plik_naglowka = KATALOG_SKLEPU . KATALOG_ZDJEC . '/'.PDF_PLIK_NAGLOWKA;
                $offsetX = PDF_PLIK_NAGLOWKA_SZEROKOSC * 1.8;
                $szerokosc_pliku_naglowka = PDF_PLIK_NAGLOWKA_SZEROKOSC;
              } else {
                $plik_naglowka = '';
                $offsetX = '';
                $szerokosc_pliku_naglowka = '';
              }

              $daneFirmy = explode(PHP_EOL, PDF_DANE_FIRMY);
              $pozostaleDaneFirmy = '';
              for ( $y = 0; $y < count($daneFirmy); $y++ ) {  
                  $pozostaleDaneFirmy .= $daneFirmy[$y] . "<br />";
              }
              
              if ( $plik_naglowka != '' ) {

                $this->Image($plik_naglowka, '', '', $szerokosc_pliku_naglowka, 0, '', '', '', true, 150, '', false, false, 0);

              }

              $html = '<table cellspacing="0" cellpadding="0" border="0"><tr><td align="left">'.$pozostaleDaneFirmy.'</td></tr></table>';

              $this->writeHTMLCell($w = 0, $h = 0, $x = $offsetX, $y = '', $html, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);
              $html = '<br /><hr>';
              $this->writeHTMLCell($w = 0, $h = 0, $x = '', $y = '', $html, $border = 0, $ln = 1, $fill = 0, $reseth = true, $align = '', $autopadding = true);

              unset($daneFirmy, $pozostaleDaneFirmy);

              // Znak wodny
              /*
              if (file_exists(KATALOG_SKLEPU . KATALOG_ZDJEC . '/watermark/watermark-pdf.png')) {

                  list($width, $height) = getimagesize(KATALOG_SKLEPU . KATALOG_ZDJEC . '/watermark/watermark-pdf.png');

                  $ImageW = $width / 3.779528; //WaterMark Size
                  $ImageH = $height / 3.779528;

                  $myPageWidth = $this->getPageWidth();
                  $myPageHeight = $this->getPageHeight();
                  $myX = ( $myPageWidth / 2 ) - ($ImageW/2);  //WaterMark Positioning
                  $myY = ( $myPageHeight / 2 ) - ($ImageH/2);

                  // get the current page break margin
                  $bMargin = $this->getBreakMargin();
                  // get current auto-page-break mode
                  $auto_page_break = $this->getAutoPageBreak();
                  // disable auto-page-break
                  $this->SetAutoPageBreak(false, 0);
                  // set bacground image
                  $img_file = KATALOG_SKLEPU . KATALOG_ZDJEC . '/watermark/watermark-pdf.png';
                  $this->Image($img_file, $myX, $myY, $ImageW, $ImageH, '', '', '', false, 150, '', false, false, 0);
                  // restore auto-page-break status
                  $this->SetAutoPageBreak($auto_page_break, $bMargin);
                  // set the starting point for the page content
                  $this->setPageMark();
              }
              */

    }

  }

  // create new PDF document
  $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

  // set document information
  $pdf->SetCreator('shopGold');
  $pdf->SetAuthor('shopGold');
  $pdf->SetTitle($tlumacz['FAKTURA']);
  $pdf->SetSubject($tlumacz['FAKTURA']);
  $pdf->SetKeywords($tlumacz['FAKTURA']);

  $pdf->SetFont('dejavusans', '', 6);

  // set header and footer fonts
  $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', '6'));
  $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

  // set default monospaced font
  $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

  //set margins
  $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
  $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
  $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

  //set auto page breaks
  $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

  //set image scale factor
  $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

  //set some language-dependent strings
  //$pdf->setLanguageArray($l);

  // ---------------------------------------------------------


  $pdf->AddPage();

  $pdf->SetFont('dejavusans', '', 8);

  $text = PDFFakturaProforma::WydrukFakturyPDF($filtr->process($_GET['id_poz']), '', '1', '');
  $pdf->writeHTML($text, true, false, false, false, '');

  //Close and output PDF document
  $pdf->Output('faktura_proforma_'.$filtr->process($_GET['id_poz']).'_'.time().'.pdf', 'D');
  
  }

}  

?>