<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

if ( isset($_GET['zakladka']) ) unset($_GET['zakladka']);
if ( isset($_SESSION['waluta_zamowienia']) ) unset($_SESSION['waluta_zamowienia']);
if ( isset($_SESSION['waluta_zamowienia_symbol']) ) unset($_SESSION['waluta_zamowienia_symbol']);

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

// wyswietla tylko nowe zamowienia
if ( isset($_GET['nowe']) ) {
     //
     unset($_SESSION['filtry']['zamowienia.php']);
     //
     $_SESSION['filtry']['zamowienia.php']['rodzaj_zam'] = '1';
     //
     Funkcje::PrzekierowanieURL('zamowienia.php');
}

if ($prot->wyswietlStrone) {
  
    // sprawdzanie zamowien czarnej listy
    $zapytanie_czarna_lista = "SELECT orders_id FROM orders WHERE orders_black_list = 0";
    $sql_czarna_lista = $db->open_query($zapytanie_czarna_lista);    
    
    if ( (int)$db->ile_rekordow($sql_czarna_lista) > 0) {
      
        while ( $info_czarna_lista = $sql_czarna_lista->fetch_assoc() ) {
          
            $pola = array();
            
            if ( Klienci::SprawdzZamowienieCzarnaLista($info_czarna_lista['orders_id']) != false ) {
              
                $pola[] = array('orders_black_list',2);

            } else {
              
                $pola[] =  array('orders_black_list',1);
              
            }
            
            $db->update_query('orders', $pola, "orders_id = '" . $info_czarna_lista['orders_id'] . "'");              
            
            unset($pola);
          
        }
        
        unset($info_czarna_lista);
      
    }
    
    $db->close_query($sql_czarna_lista);
    unset($zapytanie_czarna_lista);    

    Listing::postGet(basename($_SERVER['SCRIPT_NAME']));
        
    // id zamowien
    $ZamowieniaId = array();
    $ZamowieniaId[] = 0;
    
    // jezeli jest wyszukiwanie zamowien ze zmiana statusu
    if ( ( isset($_GET['szukaj_data_statusu_od']) && $_GET['szukaj_data_statusu_od'] != '' ) || ( isset($_GET['szukaj_data_statusu_do']) && $_GET['szukaj_data_statusu_do'] != '' ) ) {
    
         $warunki_szukania = '';

         if ( isset($_GET['szukaj_data_statusu_od']) && $_GET['szukaj_data_statusu_od'] != '' ) {
            $szukana_wartosc = date('Y-m-d H:i:s', strtotime($filtr->process($_GET['szukaj_data_statusu_od'] . ' 00:00:00')));
            $warunki_szukania .= " and date_added >= '".$szukana_wartosc."'";
         }

         if ( isset($_GET['szukaj_data_statusu_do']) && $_GET['szukaj_data_statusu_do'] != '' ) {
            $szukana_wartosc = date('Y-m-d H:i:s', strtotime($filtr->process($_GET['szukaj_data_statusu_do'] . ' 23:59:59')));
            $warunki_szukania .= " and date_added <= '".$szukana_wartosc."'";
         }      

         if ( isset($_GET['szukaj_status']) && $_GET['szukaj_status'] != '0' ) {
            $warunki_szukania .= " and orders_status_id = '".(int)$_GET['szukaj_status']."'";
         }

         $warunki_szukania = preg_replace('/and/i', 'WHERE', $warunki_szukania, 1);
         
         $zapytanie = "SELECT orders_id FROM orders_status_history" . $warunki_szukania;
         $sql = $db->open_query($zapytanie);

         while ($info = $sql->fetch_assoc()) {
            $ZamowieniaId[] = $info['orders_id'];
         }
         
         $db->close_query($sql);
         unset($szukana_wartosc, $warunki_szukania, $zapytanie, $sql);
         
    }

    
    $warunki_szukania = '';
    // jezeli jest szukanie
    if (isset($_GET['szukaj']) && $_GET['szukaj'] != '' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj']);
        $warunki_szukania = " and (o.customers_telephone LIKE '%".$szukana_wartosc."%' OR o.customers_email_address LIKE '%".$szukana_wartosc."%' OR o.customers_name LIKE '%".$szukana_wartosc."%' OR o.customers_company LIKE '%".$szukana_wartosc."%' OR o.customers_nip LIKE '%".$szukana_wartosc."%' OR o.delivery_name LIKE '%".$szukana_wartosc."%' OR o.delivery_company LIKE '%".$szukana_wartosc."%' OR o.billing_name LIKE '%".$szukana_wartosc."%' OR o.billing_company LIKE '%".$szukana_wartosc."%')";
        unset($szukana_wartosc);
    }
    
    if (isset($_GET['szukaj_produkt']) && $_GET['szukaj_produkt'] != '' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_produkt']);
        $warunki_szukania .= " and (op.products_name LIKE '%".$szukana_wartosc."%' or op.products_model LIKE '%".$szukana_wartosc."%')";
        unset($szukana_wartosc);
    }    
    
    if (isset($_GET['nick_allegro']) && $_GET['nick_allegro'] != '' ) {
        $szukana_wartosc = $filtr->process($_GET['nick_allegro']);
        $warunki_szukania .= " and o.allegro_nick = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }    

    if (isset($_GET['nr_aukcji']) && $_GET['nr_aukcji'] != '' ) {
        $szukana_wartosc = $filtr->process($_GET['nr_aukcji']);
        $warunki_szukania .= " and o.allegro_id LIKE '%".$szukana_wartosc."%'";
        unset($szukana_wartosc);
    }      

    if ( isset($_GET['szukaj_data_zamowienia_od']) && $_GET['szukaj_data_zamowienia_od'] != '' ) {
        $szukana_wartosc = date('Y-m-d H:i:s', strtotime($filtr->process($_GET['szukaj_data_zamowienia_od'] . ' 00:00:00')));
        $warunki_szukania .= " and o.date_purchased >= '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_data_zamowienia_do']) && $_GET['szukaj_data_zamowienia_do'] != '' ) {
        $szukana_wartosc = date('Y-m-d H:i:s', strtotime($filtr->process($_GET['szukaj_data_zamowienia_do'] . ' 23:59:59')));
        $warunki_szukania .= " and o.date_purchased <= '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_status']) && $_GET['szukaj_status'] != '0' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_status']);
        $warunki_szukania .= " and o.orders_status = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }
    
    if ( ZAPLACONE_LISTING == 'tak' ) {
        if ( isset($_GET['zaplacone']) && $_GET['zaplacone'] != '0' ) {
            $szukana_wartosc = (int)$_GET['zaplacone'];
            $warunki_szukania .= " and o.paid_info = '".(($szukana_wartosc == 2) ? 0 : $szukana_wartosc)."'";
            unset($szukana_wartosc);
        }    
    }
    
    if ( isset($_GET['rodzaj_zam']) && (int)$_GET['rodzaj_zam'] != '0' ) {
        $szukana_wartosc = (int)$_GET['rodzaj_zam'];
        $warunki_szukania .= " and os.orders_status_type = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }    

    if ( isset($_GET['szukaj_wysylka']) && $_GET['szukaj_wysylka'] != '0' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_wysylka']);
        $warunki_szukania .= " and o.shipping_module = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_platnosc']) && $_GET['szukaj_platnosc'] != '0' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_platnosc']);
        $warunki_szukania .= " and o.payment_method = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['klient_id']) && (int)$_GET['klient_id'] != '' ) {
        $szukana_wartosc = (int)$_GET['klient_id'];
        $warunki_szukania .= " and o.customers_id = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }
    
    if ( isset($_GET['szukaj_wartosc_zamowienia_od']) && (float)$_GET['szukaj_wartosc_zamowienia_od'] > 0 ) {
        $szukana_wartosc = (float)$_GET['szukaj_wartosc_zamowienia_od'];
        $warunki_szukania .= " and (ot.class = 'ot_total' and ot.value >= '".$szukana_wartosc."')";
        unset($szukana_wartosc);
    }  

    if ( isset($_GET['szukaj_wartosc_zamowienia_do']) && (float)$_GET['szukaj_wartosc_zamowienia_do'] > 0 ) {
        $szukana_wartosc = (float)$_GET['szukaj_wartosc_zamowienia_do'];
        $warunki_szukania .= " and (ot.class = 'ot_total' and ot.value <= '".$szukana_wartosc."')";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['opiekun']) && (int)$_GET['opiekun'] > 0 ) {
        $szukana_wartosc = (int)$_GET['opiekun'];
        $warunki_szukania .= " and o.service = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }   

    if ( isset($_GET['typ_zam']) && (int)$_GET['typ_zam'] > 0 ) {
        $szukana_wartosc = (int)$_GET['typ_zam'];
        if ( $szukana_wartosc < 5 ) {
             $warunki_szukania .= " and o.orders_source = '".$szukana_wartosc."'";
          } else if ( $szukana_wartosc == 5 ) {
             $warunki_szukania .= " and o.orders_source != '3'";
        }
        unset($szukana_wartosc);
    }
    
    if ( isset($_GET['szukaj_numer']) && (int)$_GET['szukaj_numer'] > 0 ) {
        $szukana_wartosc = (int)$_GET['szukaj_numer'];
        $warunki_szukania .= " and o.orders_id = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }
    
    if ( count($ZamowieniaId) > 1 ) {
        $warunki_szukania .= " and o.orders_id in (" . implode(',', $ZamowieniaId) . ")";
    } else {
        if ( ( isset($_GET['szukaj_data_statusu_od']) && $_GET['szukaj_data_statusu_od'] != '' ) || ( isset($_GET['szukaj_data_statusu_do']) && $_GET['szukaj_data_statusu_do'] != '' ) ) {
            $warunki_szukania .= " and o.orders_id in (0)";
        }
    }

    if ( $warunki_szukania != '' ) {
      //$warunki_szukania = preg_replace('/and/i', 'WHERE', $warunki_szukania, 1);
    }

    $zapytanie = "SELECT o.orders_id, o.invoice_proforma_date, o.customers_email_address, o.customers_telephone, o.paid_info, o.customers_name, o.customers_id, o.payment_method, o.date_purchased, o.allegro_nick, o.last_modified, o.currency, o.currency_value, o.customers_dummy_account, o.customers_company, o.customers_street_address, o.customers_postcode, o.customers_city, o.orders_status, o.orders_source, o.service, o.shipping_module, o.orders_adminnotes, o.review_date, o.review_date_customer, o.reviews_products_date, o.orders_black_list, ot.value, ot.class, ot.text as order_total, c.customers_dod_info,
                         r.receipts_id, r.receipts_nr as nr_paragonu, r.receipts_date_generated, f.invoices_id, f.invoices_nr as nr_faktury, f.invoices_date_generated, os.orders_status_type
                  FROM orders_total ot
                  RIGHT JOIN orders o ON o.orders_id = ot.orders_id 
                  LEFT JOIN orders_status os ON os.orders_status_id = o.orders_status
                  LEFT JOIN customers c ON c.customers_id = o.customers_id
                  LEFT JOIN receipts r ON r.orders_id = o.orders_id
                  LEFT JOIN invoices f ON f.orders_id = o.orders_id AND f.invoices_type = '2'
                  " . ((isset($_GET['szukaj_produkt'])) ? 'LEFT JOIN orders_products op ON op.orders_id = o.orders_id' : '') . "
                  WHERE ot.class = 'ot_total' " . $warunki_szukania . ' GROUP BY o.orders_id'; 

    // tworzenie paska do nastepnych okien - obliczanie ile bedzie podstron
    $ZapytanieDlaPozycji = "SELECT o.orders_id
                            FROM orders o 
                            LEFT JOIN orders_total ot ON o.orders_id = ot.orders_id AND ot.class = 'ot_total' LEFT JOIN orders_status os ON os.orders_status_id = o.orders_status
                            " . ((isset($_GET['szukaj_produkt'])) ? 'LEFT JOIN orders_products op ON op.orders_id = o.orders_id' : '') . "
                            " . $warunki_szukania;
    $sql = $db->open_query($ZapytanieDlaPozycji);
    $ile_pozycji = (int)$db->ile_rekordow($sql);

    $sql = $db->open_query($zapytanie);

    $ile_pozycji = (int)$db->ile_rekordow($sql); // ile jest wszystkich produktow
    $ile_licznika = ($ile_pozycji / ILOSC_WYNIKOW_NA_STRONIE);
    if ($ile_licznika == (int)$ile_licznika) { $ile_licznika = (int)$ile_licznika; } else { $ile_licznika = (int)$ile_licznika+1; }

    $db->close_query($sql);
    
    // jezeli jest sortowanie
    if (isset($_GET['sort'])) {
        switch ($_GET['sort']) {
            case "sort_a1":
                $sortowanie = 'o.orders_id desc';
                break;
            case "sort_a2":
                $sortowanie = 'o.orders_id asc';
                break;                 
            case "sort_a3":
                $sortowanie = 'o.date_purchased desc';
                break;
            case "sort_a4":
                $sortowanie = 'o.date_purchased asc';
                break;                 
        }            
    } else { $sortowanie = 'orders_id desc'; }    
    
    $zapytanie .= " ORDER BY ".$sortowanie;    

    // ******************************************************************************************************************************************************************
    // obsluga listingu AJAX
    if (isset($_GET['parametr'])) {

        if ($ile_pozycji > 0) {
            
            $zapytanie .= " limit ".$_GET['parametr'];    

            $sql = $db->open_query($zapytanie);

            $listing_danych = new Listing();
            
            $tablica_naglowek = array(array('Info', 'center', '', 'class="ListingSchowajMobile"'),
                                      array('Akcja', 'center'),
                                      array('ID', 'center'));
            
            if (FAKTURA_PARAGON_LISTING == 'tak') {
                $tablica_naglowek[] = array('Faktura <br /> Paragon', 'center', '', 'class="ListingSchowajMobile"');
            }
        
            $tablica_naglowek[] = array('Klient');
            $tablica_naglowek[] = array('Data zamówienia', 'center');
            $tablica_naglowek[] = array('Wartość', 'center');
            $tablica_naglowek[] = array('Płatność', 'center', '', 'class="ListingSchowaj"');
            $tablica_naglowek[] = array('Dostawa', 'center', '', 'class="ListingSchowaj"');
            $tablica_naglowek[] = array('Status', 'center');
            $tablica_naglowek[] = array('Typ', 'center', 'white-space:nowrap;');
                                      
            if ( OPINIE_STATUS == 'tak' || RECENZJE_STATUS == 'tak' ) {
                 $tablica_naglowek[] = array('Opinia <br /> Recenzje', 'center');
            }

            echo $listing_danych->naglowek($tablica_naglowek);
            
            $tekst = '';
            
            $statusy = Sprzedaz::ListaStatusowZamowienKolor();
            
            while ($info = $sql->fetch_assoc()) {
              
                  if (isset($_GET['id_poz']) && (int)$_GET['id_poz'] == $info['orders_id']) {
                     $tekst .= '<tr class="pozycja_on' . (($info['orders_black_list'] == 2) ? ' CzarnaLista' : '') . '" id="sk_'.$info['orders_id'].'">';
                   } else {
                     $tekst .= '<tr class="pozycja_off' . (($info['orders_black_list'] == 2) ? ' CzarnaLista' : '') . '" id="sk_'.$info['orders_id'].'">';
                  }         

                  $tablica = array();

                  // informacje o uwagach na koncie klienta
                  $uwagi = '';
                  if ( $info['customers_dod_info'] != '' || $info['orders_adminnotes'] != '' ) {

                      $uwagi = '<em class="TipChmurka"><b>Dodatkowa informacja obsługi sklepu</b><img style="float:none" src="obrazki/uwaga_mala.png" alt="Informacja" /></em>';

                  }

                  $tablica[] = array((($info['orders_black_list'] == 2) ? '<div class="CzarnaListaId"><em class="TipChmurka"><b>Zamówienie zostało zakwalifikowane jako "podejrzane"</b><img src="obrazki/czarna_lista.png" alt="Czarna lista" /></em></div>' : '') . '<div id="zamowienie_'.$info['orders_id'].'" class="zmzoom_zamowienie"><div class="podglad_zoom"></div><img src="obrazki/info_duze.png" alt="Szczegóły" /></div>' . $uwagi, 'center', '', 'class="ListingSchowajMobile"');
  
                  unset($uwagi);
                  
                  $tablica[] = array('<input type="checkbox" style="border:0px" name="opcja[]" id="opcja_'.$info['orders_id'].'" value="'.$info['orders_id'].'" /><label class="OpisForPustyLabel" for="opcja_'.$info['orders_id'].'"></label><input type="hidden" name="id[]" value="'.$info['orders_id'].'" />','center');

                  // pobranie faktury proforma
                  $proforma = '';
                  if ( $info['invoice_proforma_date'] > 0 ) {

                      $proforma = '<div class="MalaProforma"><em class="TipChmurka"><b>Proforma pobrana przez klienta: ' . date('d-m-Y H:i', $info['invoice_proforma_date']) . '</b><img src="obrazki/maly_dolar.png" alt="Proforma" /></em></div>';

                  }

                  $tablica[] = array($info['orders_id'] . $proforma,'center');   

                  if ( FAKTURA_PARAGON_LISTING == 'tak' ) {

                      $nr_faktura_paragon = '';
                      if ( !empty($info['nr_paragonu']) ) {
                           //
                           $nr_faktura_paragon = '<span>paragon</span>' . $info['nr_paragonu'] . strftime(NUMER_PARAGONU_SUFFIX, strtotime($info['receipts_date_generated']));
                           $nr_faktura_paragon .= '<br /><a href="sprzedaz/zamowienia_paragon_pdf.php?id_poz=' . $info['orders_id'] . '&amp;id=' . $info['receipts_id'] . '"><img src="obrazki/pdf.png" alt="Wydrukuj" /></a>';
                           //
                      }
                      if ( !empty($info['nr_faktury']) ) {
                           //
                           $nr_faktura_paragon = '<span>faktura</span>' . $info['nr_faktury'] . strftime(NUMER_FAKTURY_SUFFIX, strtotime($info['invoices_date_generated']));
                           $nr_faktura_paragon .= '<br /><a href="sprzedaz/zamowienia_faktura_pdf.php?id_poz=' . $info['orders_id'] . '&amp;id=' . $info['invoices_id'] . '"><img src="obrazki/pdf.png" alt="Wydrukuj" /></a>';
                           //
                      }                  
                      $tablica[] = array($nr_faktura_paragon, 'center', '', 'class="ListingSchowajMobile FakturaPragon"');
                      unset($nr_faktura_paragon);
                  
                  }
                  
                  $wyswietlana_nazwa = '';
                  if ( $info['customers_id'] > 0 ) {
                       $wyswietlana_nazwa = '<a class="KontoKlienta" href="klienci/klienci_edytuj.php?id_poz=' . $info['customers_id'] . '">';
                  }
                  
                  if ( $info['customers_company'] != '' ) {
                       $wyswietlana_nazwa .= '<span class="Firma">'.$info['customers_company'] . '</span><br />';
                  }
                  
                  $wyswietlana_nazwa .= $info['customers_name'] . '<br />';
                  $wyswietlana_nazwa .= $info['customers_street_address']. '<br />';
                  $wyswietlana_nazwa .= $info['customers_postcode']. ' ' . $info['customers_city'] . '<br />';
                  
                  if (!empty($info['customers_email_address'])) {
                      $wyswietlana_nazwa .= '<span class="MalyMail">' . $info['customers_email_address'] . '</span>';
                  }
                  if (!empty($info['customers_telephone'])) {
                      $wyswietlana_nazwa .= '<span class="MalyTelefon">' . $info['customers_telephone'] . '</span>';
                  }                 

                  if ( $info['customers_id'] > 0 ) {
                       $wyswietlana_nazwa .= '</a>';
                  }    
                  
                  // jezeli staly klient
                  $iloscZam = (int)Klienci::pokazIloscZamowienKlienta($info['customers_id']);
                  if ( $iloscZam > 1 ) {

                       $wyswietlana_nazwa = '<em class="TipChmurka" style="float:right"><b>Stały klient - ilość zamówień: ' . $iloscZam . '</b><img src="obrazki/medal.png" alt="Stały klient" /></em>' . $wyswietlana_nazwa;

                  }
                  unset($iloscZam);

                  // jezeli jest gosc wyswietli ikonke
                  if ( $info['customers_dummy_account'] == '1' ) { 

                       $wyswietlana_nazwa = '<em class="TipChmurka" style="float:right"><b>Klient bez rejestracji</b><img src="obrazki/gosc.png" alt="Klient bez rejestracji" /></em>' . $wyswietlana_nazwa;

                  }
                  
                  // jezeli zamowienie z allegro wyswietli NICK
                  if ( $info['orders_source'] == 3 && $info['allegro_nick'] != '' ) {
                       $wyswietlana_nazwa .= '<div class="NickAllegro">Allegro: <b>' . $info['allegro_nick'] . '</b></div>';
                  }
                  
                  $tablica[] = array($wyswietlana_nazwa,'','line-height:1.5');        
                  unset($wyswietlana_nazwa);

                  $tablica[] = array(date('d-m-Y H:i',strtotime($info['date_purchased'])),'center');
                  $tablica[] = array('<span class="InfoCena">'.$info['order_total'].'</span>','right', 'white-space:nowrap;');
                  
                  // zaplacone
                  $tgh = '';
                  if ( ZAPLACONE_LISTING == 'tak' ) {
                       if ($info['paid_info'] == '1') { $tgh = '<a href="sprzedaz/zamowienia_zaplacone.php?id_poz='.(int)$info['orders_id'].'" class="Zaplacone">zapłacone</a>'; } else { $tgh = '<a href="sprzedaz/zamowienia_zaplacone.php?id_poz='.(int)$info['orders_id'].'" class="Niezaplacone">niezapłacone</a>'; }   
                  }
                  $tablica[] = array($info['payment_method'] . '<br />' . $tgh,'center', '', 'class="ListingSchowaj"');
                  unset($tgh);

                  $wysylka   = $info['shipping_module'];
                  $zapytanie_dostawy = "SELECT * FROM orders_shipping WHERE orders_id = '" . (int)$info['orders_id'] . "'";
                  $sql_dostawy = $db->open_query($zapytanie_dostawy);
                  if ((int)$db->ile_rekordow($sql_dostawy) > 0) {
                    $wysylka = $wysylka . '<em class="TipChmurka"><b>Utworzono wysyłki</b><img class="UtworzonaWysylka" src="obrazki/tak.png" alt="Utworzono wysyłki" /></em>';
                  }
                  $db->close_query($sql_dostawy);
                  unset($sql_dostawy, $zapytanie_dostawy);           

                  $tablica[] = array($wysylka,'center', '', 'class="ListingSchowaj"');
                  
                  // opiekun zamowienia
                  $zapytanie_tmp = "select distinct * from admin where admin_id = '".(int)$info['service']."'";
                  $sqls = $db->open_query($zapytanie_tmp);
                  if ((int)$db->ile_rekordow($sqls) > 0) {
                      $infs = $sqls->fetch_assoc();
                      $opiekun = '<span class="Opiekun">Opiekun:<span>'.$infs['admin_firstname'] . ' ' . $infs['admin_lastname'] . '</span></span>';
                      $db->close_query($sqls);
                     } else {
                      $opiekun = '';
                  }
                  unset($zapytanie_tmp, $infs);    
                  //
                                  
                  //$tablica[] = array(Sprzedaz::pokazNazweStatusuZamowienia($info['orders_status'], $_SESSION['domyslny_jezyk']['id']) . $Opiekun,'center');
                  
                  $selectStatus = '';
                  $kolorDomyslny = '';
                  foreach ($statusy as $status) {
                      $selectStatus .= '<option value="' . $status['id'] . '"' . (($status['kolor'] != '') ? ' data-kolor="' . $status['kolor'] . '" style="color:#' . $status['kolor'] . '"' : '') . (($status['id'] == $info['orders_status']) ? ' selected="selected"' : '') . '>' . $status['text'] . '</option>';
                      //
                      if ( $status['id'] == $info['orders_status'] && $status['kolor'] != '' ) {
                           $kolorDomyslny = 'style="color:#' . $status['kolor'] . '"';
                      }
                      //
                  }
                  $selectStatus = '<div class="ZmianaStatusu" id="zmiana_'.$info['orders_id'].'" data-id="'.$info['orders_id'].'"><select data-id="'.$info['orders_id'].'" ' . $kolorDomyslny . '>' . $selectStatus . '</select><div><table><tr><td><input type="checkbox" value="1" id="mail_'.$info['orders_id'].'" /> <label class="OpisFor" for="mail_'.$info['orders_id'].'">e-mail</label></td> ' . (( SMS_WLACZONE == 'tak' && SMS_ZMIANA_STATUSU_ZAMOWIENIA == 'tak' ) ? '<td><input type="checkbox" value="1" id="sms_'.$info['orders_id'].'" /> <label class="OpisFor" for="sms_'.$info['orders_id'].'">SMS</label></td>' : '') . '</tr></table></div></div>';                  
                  
                  $tablica[] = array($selectStatus . $opiekun,'center');

                  unset($opiekun, $kolorDomyslny, $selectStatus);
                  
                  // 1 - zamowienie ze sklepu z rejestracja
                  // 2 - zamowienie ze sklepu bez rejestracji
                  // 3 - zamowienie z Allegro
                  // 4 - zamowienie dodane przez admina
                  
                  $TypZamowienia = '';
                  switch ($info['orders_source']) {
                    case "3":
                        $TypZamowienia = '<em class="TipChmurka"><b>Zamówienie z Allegro</b><img src="obrazki/allegro_lapka.png" alt="Zamówienie z Allegro" /></em>';
                        break;                 
                    case "4":
                        $TypZamowienia = '<em class="TipChmurka"><b>Zamówienie ręczne</b><img src="obrazki/raczka.png" alt="Zamówienie ręczne" /></em>';
                        break;             
                  }                     

                  $tablica[] = array($TypZamowienia,'center');
                  
                  // zmienne do przekazania
                  $zmienne_do_przekazania = '?id_poz='.(int)$info['orders_id']; 
                  $tgm = '';
                  
                  if ( OPINIE_STATUS == 'tak' ) {
                       //
                       $tgm = '<div class="OpiniaRecenzja">';
                       if ( Funkcje::CzyNiePuste($info['review_date_customer']) ) {
                             $tgm .= '<div class="KlientOpinia"><em class="TipChmurka"><b>Maila wysłano ' . date('d-m-Y H:i',strtotime($info['review_date'])) . ', klient napisał opinie ' . date('d-m-Y H:i',strtotime($info['review_date_customer'])) . '</b><img src="obrazki/klient.png" alt="Klient napisał opinie" /></em></div>';
                       } else if ( Funkcje::CzyNiePuste($info['review_date']) ) {
                             $tgm .= '<div><em class="TipChmurka"><b>Maila wysłano ' . date('d-m-Y H:i',strtotime($info['review_date'])) . '</b><img src="obrazki/tak.png" alt="Wysłano" /></em></div>';
                       }                      
                       $tgm .= '<a class="TipChmurka" href="sprzedaz/zamowienia_wyslij_email_o_opinie.php'.$zmienne_do_przekazania.'"><b>Wyślij e-mail z prośbą o opinie o sklepie</b><img src="obrazki/opinia.png" alt="Wyślij o opinie" /></a>';
                       $tgm .= '</div>';
                       //
 
                  }      

                  if ( RECENZJE_STATUS == 'tak' ) {
                       //
                       if ( OPINIE_STATUS == 'tak' ) {
                            $tgm .= '<div class="LiniaOpinie"></div>';
                       }
                       //
                       if ( Funkcje::CzyNiePuste($info['reviews_products_date']) ) {
                             $tgm .= '<div class="OpiniaRecenzja"><div><em class="TipChmurka"><b>Maila wysłano ' . date('d-m-Y H:i',strtotime($info['reviews_products_date'])) . '</b><img src="obrazki/tak.png" alt="Wysłano" /></em></div>';
                       }
                       $tgm .= '<a class="TipChmurka" href="sprzedaz/zamowienia_wyslij_email_o_recenzje.php'.$zmienne_do_przekazania.'"><b>Wyślij e-mail z prośbą o recenzje o produktach</b><img src="obrazki/opinie_produkty.gif" alt="Wyślij o recenzje" /></a>';
                       $tgm .= '</div>';
                       //
                  }     

                  if ( OPINIE_STATUS == 'tak' || RECENZJE_STATUS == 'tak' ) {
                       $tablica[] = array($tgm, 'center');
                  }
                  
                  unset($tgm);
                  
                  $tekst .= $listing_danych->pozycje($tablica);
                  
                  $tekst .= '<td class="rg_right IkonyPionowo">';
                  
                  $tekst .= '<div class="ZakladkiSzczegolowe">';
                  $tekst .= '<a class="TipChmurka" href="sprzedaz/zamowienia_szczegoly.php'.$zmienne_do_przekazania.'"><b>Szczegóły zamówienia</b><img src="obrazki/zobacz.png" alt="Szczegóły zamówienia" /></a>';
                  $tekst .= '<a class="ListingSchowajMobile TipChmurka" href="sprzedaz/zamowienia_szczegoly.php'.$zmienne_do_przekazania.'&zakladka=1"><b>Generowanie wysyłek</b><img src="obrazki/wysylki.png" alt="Generowanie wysyłek" /></a>';
                  $tekst .= '<a class="ListingSchowajMobile TipChmurka" href="sprzedaz/zamowienia_szczegoly.php'.$zmienne_do_przekazania.'&zakladka=2"><b>Zakupione produkty</b><img src="obrazki/produkty.png" alt="Zakupione produkty" /></a>';
                  $tekst .= '<a class="ListingSchowajMobile TipChmurka" href="sprzedaz/zamowienia_szczegoly.php'.$zmienne_do_przekazania.'&zakladka=3"><b>Historia zamówień</b><img src="obrazki/historia.png" alt="Historia zamówień" /></a>';
                  $tekst .= '<a class="TipChmurka" href="sprzedaz/zamowienia_wyslij_email.php'.$zmienne_do_przekazania.'"><b>Wyślij e-mail z zamówieniem</b><img src="obrazki/wyslij_mail.png" alt="Wyślij e-mail z zamówieniem" /></a>';                  
                  $tekst .= '</div>';
                  
                  $tekst .= '<div class="ZakladkiOdstep">';
                  $tekst .= '<a class="ListingSchowajMobile TipChmurka" href="sprzedaz/zamowienia_wz_pdf.php'.$zmienne_do_przekazania.'"><b>Wydane z magazynu</b><img src="obrazki/pdf_2.png" alt="Wz" /></a>';
                  $tekst .= '<a class="ListingSchowajMobile TipChmurka" href="sprzedaz/zamowienia_zamowienie_pdf.php'.$zmienne_do_przekazania.'"><b>Wydruk zamówienia</b><img src="obrazki/zamowienie_pdf.png" alt="Wydruk zamówienia" /></a>';
                  $tekst .= '<a class="ListingSchowajMobile TipChmurka" href="sprzedaz/zamowienia_faktura_proforma.php'.$zmienne_do_przekazania.'"><b>Wydruk faktury proforma</b><img src="obrazki/proforma_pdf.png" alt="Wydruk faktury proforma" /></a>'; 
                  $tekst .= '</div>';
                  
                  $tekst .= '<a class="TipChmurka" href="sprzedaz/zamowienia_usun.php'.$zmienne_do_przekazania.'"><b>Skasuj</b><img src="obrazki/kasuj.png" alt="Skasuj" /></a>';                  
                  $tekst .= '<a class="ListingSchowajMobile TipChmurka" href="sprzedaz/zamowienia_pobierz.php'.$zmienne_do_przekazania.'"><b>Pobierz</b><img src="obrazki/export.png" alt="Pobierz" /></a>'; 
                  $tekst .= '<em class="TipChmurka" style="cursor:pointer" id="widok_' . $info['orders_id'] . '" onclick="produkty(' . $info['orders_id'] . ')"><b>Rozwiń listę <br /> zakupionych <br /> produktów</b><img src="obrazki/rozwin.png" alt="Lista produktów" /></em>'; 
                  
                  $tekst .= '</td></tr>';
                  
                  $ColSpan = 12;
                  
                  if ( FAKTURA_PARAGON_LISTING == 'nie' ) {
                       $ColSpan -= 1;
                  }
                  if ( OPINIE_STATUS == 'tak' || RECENZJE_STATUS == 'tak' ) {
                       $ColSpan += 1;
                  }
                  
                  $tekst .= '<tr><td colspan="' . $ColSpan . '"><div id="produkty_' . $info['orders_id'] . '"></div></td></tr>';
                  
                  unset($ColSpan);
                  
            } 
            $tekst .= '</table>';
            //
            echo $tekst;
            //
            $db->close_query($sql);
            unset($listing_danych,$tekst,$tablica,$tablica_naglowek,$statusy);        

        }
    }  
    
    // ******************************************************************************************************************************************************************
    // wyswietlanie listingu
    if (!isset($_GET['parametr'])) { 

        // wczytanie naglowka HTML
        include('naglowek.inc.php');
        ?>
          
        <script>
        $(document).ready(function() {
            $.AutoUzupelnienie( 'szukaj', 'Podpowiedzi', 'ajax/autouzupelnienie_zamowienia.php', 50, 400 );
            
            $.AutoUzupelnienie( 'szukaj_produkt', 'PodpowiedziMale', 'ajax/autouzupelnienie_produkty_zamowienie.php', 50, 300 );
            
            $('input.datepicker').Zebra_DatePicker({
              format: 'd-m-Y',
              inside: false,
              readonly_element: false
            });             

            $('#akcja_dolna').change(function() {
               if ( this.value == '0' || this.value == '2' ) {
                 $("#page").hide();
                 $("#page").load('sprzedaz/blank.php');
               }
               if ( this.value == '1' ) {
                 $("#page").load('sprzedaz/zamowienia_zmien_status_multi.php', function() {
                    //
                    $("#page").show();
                    pokazChmurki();
                    //
                 });                 
               }
            });

        });
        
        function produkty(id) {
            //
            if ( $('#produkty_' + id).html() != '' ) {
                 //
                 $('#widok_' + id).find('img').attr('src','obrazki/rozwin.png');
                 $('#widok_' + id).find('b').html('Rozwiń listę <br /> zakupionych <br /> produktów');
                 //              
                 $('#produkty_' + id).slideUp('fast', function() {
                    $('#produkty_' + id).html('');
                 });
              } else {
                $('#produkty_' + id).html('<div class="TloObramowania"><img src="obrazki/_loader_small.gif" alt="" /></div>');
                $.post("ajax/zamowienie_produkty.php?tok=" + $('#tok').val(),
                    { id: id },
                    function(data) { 
                      //
                      $('#widok_' + id).find('img').attr('src','obrazki/zwin.png');
                      $('#widok_' + id).find('b').html('Zwiń listę <br /> zakupionych <br /> produktów');
                      //
                      $('#produkty_' + id).hide()
                      $('#produkty_' + id).html(data);
                      $('#produkty_' + id).slideDown('fast');
                      //
                      $(".ZdjecieProduktu").colorbox({ maxWidth:'90%', maxHeight:'90%' });
                    }           
                );  
            }
            //
        }          
        </script>

        <div id="caly_listing">
        
            <div id="ajax"></div>
            
            <div id="naglowek_cont">Zamówienia</div>

            <div id="wyszukaj">
                <form action="sprzedaz/zamowienia.php" method="post" id="zamowieniaForm" class="cmxform">

                <div id="wyszukaj_text">
                    <span>Wyszukaj: <em class="TipIkona"><b>Wyszukiwanie po danych klienta, firmy, danych adresowych, adresie email</b></em></span>
                    <input type="text" name="szukaj" id="szukaj" value="<?php echo ((isset($_GET['szukaj'])) ? Funkcje::formatujTekstInput($filtr->process($_GET['szukaj'])) : ''); ?>" size="30" />
                </div>  
                
                <div class="wyszukaj_select">
                    <span>Wyszukaj produkt: <em class="TipIkona"><b>Wyszukiwanie zamówień z szukanym produktem (po nazwie produktu lub numerze katalogowym)</b></em></span>
                    <input type="text" name="szukaj_produkt" id="szukaj_produkt" value="<?php echo ((isset($_GET['szukaj_produkt'])) ? Funkcje::formatujTekstInput($filtr->process($_GET['szukaj_produkt'])) : ''); ?>" size="30" />
                </div>                
                
                <div class="wyszukaj_select">
                    <span>Numer zamówienia:</span>
                    <input type="text" id="numer" name="szukaj_numer" value="<?php echo ((isset($_GET['szukaj_numer'])) ? $filtr->process($_GET['szukaj_numer']) : ''); ?>" size="10" />
                </div>  

                <div class="wyszukaj_select">
                    <span>Data złożenia:</span>
                    <input type="text" id="data_zamowienia_od" name="szukaj_data_zamowienia_od" value="<?php echo ((isset($_GET['szukaj_data_zamowienia_od'])) ? $filtr->process($_GET['szukaj_data_zamowienia_od']) : ''); ?>" size="10" class="datepicker" />&nbsp;do&nbsp;
                    <input type="text" id="data_zamowienia_do" name="szukaj_data_zamowienia_do" value="<?php echo ((isset($_GET['szukaj_data_zamowienia_do'])) ? $filtr->process($_GET['szukaj_data_zamowienia_do']) : ''); ?>" size="10" class="datepicker" />
                </div>  

                <div class="wyszukaj_select">
                    <span>Status:</span>
                    <?php
                    $tablica_status= Array();
                    $tablica_status = Sprzedaz::ListaStatusowZamowien(true);
                    echo Funkcje::RozwijaneMenu('szukaj_status', $tablica_status, ((isset($_GET['szukaj_status'])) ? $filtr->process($_GET['szukaj_status']) : ''), ' style="max-width:200px"'); ?>
                </div>                 
                
                <?php if ( ZAPLACONE_LISTING == 'tak' ) { ?>

                <div class="wyszukaj_select">
                    <span>Zapłacone:</span>
                    <?php
                    $tablica_zaplacone = Array();
                    $tablica_zaplacone[] = array('id' => '0', 'text' => 'dowolne');
                    $tablica_zaplacone[] = array('id' => '1', 'text' => 'zapłacone');
                    $tablica_zaplacone[] = array('id' => '2', 'text' => 'niezapłacone');
                    echo Funkcje::RozwijaneMenu('zaplacone', $tablica_zaplacone, ((isset($_GET['zaplacone'])) ? $filtr->process($_GET['zaplacone']) : '0'), ' style="max-width:150px"'); ?>
                </div>                  
                
                <?php } ?>
                
                <div class="wyszukaj_select">
                    <span>Rodzaj wysyłki:</span>
                    <?php
                    $tablica_typ = Array();
                    $tablica_typ = Sprzedaz::ListaWysylekZamowien( true );
                    echo Funkcje::RozwijaneMenu('szukaj_wysylka', $tablica_typ, ((isset($_GET['szukaj_wysylka'])) ? $filtr->process($_GET['szukaj_wysylka']) : ''), ' style="max-width:230px"'); ?>
                </div>  

                <div class="wyszukaj_select">
                    <span>Rodzaj płatności:</span>
                    <?php
                    $tablica_typ = Array();
                    $tablica_typ = Sprzedaz::ListaPlatnosciZamowien( true );
                    echo Funkcje::RozwijaneMenu('szukaj_platnosc', $tablica_typ, ((isset($_GET['szukaj_platnosc'])) ? $filtr->process($_GET['szukaj_platnosc']) : ''), ' style="max-width:200px"'); ?>
                </div>  
                
                <div class="wyszukaj_select">
                    <span>Opiekun:</span>
                    <?php
                    // pobieranie informacji od uzytkownikach
                    $zapytanie_tmp = "select * from admin where admin_groups_id = '2' order by admin_lastname";
                    $sqls = $db->open_query($zapytanie_tmp);
                    //
                    $tablica_user = array();
                    $tablica_user[] = array('id' => 0, 'text' => 'dowolny');
                    while ($infs = $sqls->fetch_assoc()) { 
                    $tablica_user[] = array('id' => $infs['admin_id'], 'text' => $infs['admin_firstname'] . ' ' . $infs['admin_lastname']);
                    }
                    $db->close_query($sqls); 
                    unset($zapytanie_tmp, $infs);    
                    //
                    echo Funkcje::RozwijaneMenu('opiekun', $tablica_user, ((isset($_GET['opiekun'])) ? $filtr->process($_GET['opiekun']) : ''), ' style="max-width:150px"'); ?>
                </div>

                <div class="wyszukaj_select">
                    <span>Typ zamówienia:</span>
                    <?php
                    $tablica_typ = Array();
                    $tablica_typ = Sprzedaz::TypyZamowien( true );
                    $tablica_typ[] = array('id' => '5', 'text' => 'zamówienia bez zamówień z Allegro');
                    echo Funkcje::RozwijaneMenu('typ_zam', $tablica_typ, ((isset($_GET['typ_zam'])) ? $filtr->process($_GET['typ_zam']) : '99'), ' style="max-width:220px"'); ?>
                </div>
                
                <div class="wyszukaj_select">
                    <span>Rodzaj zamówienia:</span>
                    <?php
                    $tablica_rodzaj = Array();
                    $tablica_rodzaj[] = array('id' => '0', 'text' => 'dowolny');
                    $tablica_rodzaj[] = array('id' => '1', 'text' => 'Nowe');
                    $tablica_rodzaj[] = array('id' => '2', 'text' => 'W realizacji');
                    $tablica_rodzaj[] = array('id' => '3', 'text' => 'Zamknięte (zrealizowane)');
                    $tablica_rodzaj[] = array('id' => '4', 'text' => 'Zamknięte (niezrealizowane)');
                    echo Funkcje::RozwijaneMenu('rodzaj_zam', $tablica_rodzaj, ((isset($_GET['rodzaj_zam'])) ? $filtr->process($_GET['rodzaj_zam']) : '0'), ' style="max-width:220px"'); ?>
                </div>     

                <div class="wyszukaj_select">
                    <span>Wartość zamówienia:</span>
                    <input type="text" name="szukaj_wartosc_zamowienia_od" value="<?php echo ((isset($_GET['szukaj_wartosc_zamowienia_od'])) ? $filtr->process($_GET['szukaj_wartosc_zamowienia_od']) : ''); ?>" size="6" /> do
                    <input type="text" name="szukaj_wartosc_zamowienia_do" value="<?php echo ((isset($_GET['szukaj_wartosc_zamowienia_do'])) ? $filtr->process($_GET['szukaj_wartosc_zamowienia_do']) : ''); ?>" size="6" />
                </div> 

                <div class="wyszukaj_select">
                    <span>Zmiana statusu:</span>
                    <input type="text" id="data_statusu_od" name="szukaj_data_statusu_od" value="<?php echo ((isset($_GET['szukaj_data_statusu_od'])) ? $filtr->process($_GET['szukaj_data_statusu_od']) : ''); ?>" size="10" class="datepicker" /> do 
                    <input type="text" id="data_dodania_do" name="szukaj_data_statusu_do" value="<?php echo ((isset($_GET['szukaj_data_statusu_do'])) ? $filtr->process($_GET['szukaj_data_statusu_do']) : ''); ?>" size="10" class="datepicker" />
                </div>     

                <div class="wyszukaj_select">
                    <span>Nr aukcji: <em class="TipIkona"><b>Nr aukcji Allegro - jeżeli zamówienie pochodzi z Allegro</b></em></span>
                    <input type="text" name="nr_aukcji" id="nr_aukcji" value="<?php echo ((isset($_GET['nr_aukcji'])) ? $filtr->process($_GET['nr_aukcji']) : ''); ?>" size="20" />
                </div> 

                <div class="wyszukaj_select">
                    <span>Nick allegro:</span>
                    <input type="text" name="nick_allegro" id="nick_allegro" value="<?php echo ((isset($_GET['nick_allegro'])) ? $filtr->process($_GET['nick_allegro']) : ''); ?>" size="15" />
                </div>                 
                
                <?php 
                // tworzy ukryte pola hidden do wyszukiwania - filtra 
                if (isset($_GET['sort'])) { 
                    echo '<div><input type="hidden" name="sort" value="'.$filtr->process($_GET['sort']).'" /></div>';
                }                
                ?>                

                <div class="wyszukaj_przycisk"><input type="image" alt="Szukaj" src="obrazki/ok.png" /></div>
                </form>
                
                <?php
                if ( Listing::wylaczFiltr(basename($_SERVER['SCRIPT_NAME'])) == true ) {
                  echo '<div id="wyszukaj_ikona"><a href="sprzedaz/zamowienia.php?filtr=nie"><img src="obrazki/reset_szukaj.png" alt="Anuluj wyszukiwanie" /></a></div>';
                }
                ?> 

                <div style="clear:both"></div>
            </div>        
            
            <form action="sprzedaz/zamowienia_akcja.php" method="post" class="cmxform">

            <div id="sortowanie">
            
                <span>Sortowanie: </span>
                
                <a id="sort_a1" class="sortowanie" href="sprzedaz/zamowienia.php?sort=sort_a1">numeru malejąco</a>
                <a id="sort_a2" class="sortowanie" href="sprzedaz/zamowienia.php?sort=sort_a2">numeru rosnąco</a>
                <a id="sort_a3" class="sortowanie" href="sprzedaz/zamowienia.php?sort=sort_a3">daty malejąco</a>
                <a id="sort_a4" class="sortowanie" href="sprzedaz/zamowienia.php?sort=sort_a4">daty rosnąco</a>
            
            </div>             

            <div id="PozycjeIkon">
            
                <div>
                  <a class="dodaj" href="sprzedaz/zamowienia_dodaj.php<?php echo Funkcje::Zwroc_Wybrane_Get(array('klient_id')); ?>">dodaj nowe zamówienie</a>
                </div>    
                
                <div id="Legenda" style="float:right">
                  <span class="PobranaProforma"> klient pobrał proformę</span>
                  <span class="StalyKlient"> stały klient</span>
                  <span class="Gosc"> klient bez rejestracji</span>
                  <span class="ZamowienieAllegro"> zamówienie z Allegro</span>
                  <span class="ZamowienieReczne"> zamówienie ręczne</span>
                </div> 
                
            </div>

            <div class="cl"></div>               
        
            <div id="wynik_zapytania"></div>
            <div id="aktualna_pozycja">1</div>

            <div id="akcja">
            
                <div class="lf"><img src="obrazki/strzalka.png" alt="" /></div>
                
                <div class="lf" style="padding-right:20px">
                  <span onclick="akcja(1)">zaznacz wszystkie</span>
                  <span onclick="akcja(2)">odznacz wszystkie</span>
                </div>
                
                <div id="akc">
                  Wykonaj akcje: 
                  <select name="akcja_dolna" id="akcja_dolna">
                    <option value="0"></option>
                    <option value="1">zmień status zaznaczonych</option>
                    <option value="2">wydruk zamówienia PDF</option>
                    <option value="3">połącz wybrane zamowienia</option>
                    <option value="4">pobierz zamówienia w formacie CSV</option>
                  </select>
                </div>
                
                <div class="cl"></div>
              
            </div>
            
            <div class="cl"></div>
                      
            <div id="page" class="RamkaAkcji"></div>
            
            <div class="cl"></div>

            <div id="dolny_pasek_stron"></div>
            <div id="pokaz_ile_pozycji"></div>
            <div id="ile_rekordow"><?php echo $ile_pozycji; ?></div>

            <?php if ($ile_pozycji > 0) { ?>
            
                <?php if (isset($_GET['klient_id']) && $_GET['klient_id'] != '' ) { ?>
                  <div class="lf"><button type="button" class="przyciskNon" onclick="cofnij('klienci','?id_poz=<?php echo (int)$_GET['klient_id']; ?><?php echo Funkcje::Zwroc_Get(array('x','y','id_poz','klient_id')); ?>', 'klienci');">Powrót</button></div>
                <?php } ?>                
                
                <div class="rg"><input type="submit" class="przyciskBut" value="Zapisz zmiany" /></div>

            <?php } else { ?> 
            
              <?php if (isset($_GET['klient_id']) && $_GET['klient_id'] != '' ) { ?>
                <div class="lf"><button type="button" class="przyciskNon" onclick="cofnij('klienci','?id_poz=<?php echo (int)$_GET['klient_id']; ?><?php echo Funkcje::Zwroc_Get(array('x','y','id_poz','klient_id')); ?>', 'klienci');">Powrót</button></div>             
              <?php } ?> 
              
            <?php } ?> 

            <div class="cl"></div>

            </form>

            <script>
            $("#wynik_zapytania").html('<div style="padding:10px">Trwa ładowanie danych ...</div>');
            var skocz = '<?php echo ((isset($_GET['id_poz']) && (int)$_GET['id_poz'] > 0) ? (int)$_GET['id_poz'] : ''); ?>';
            <?php Listing::pokazAjax('sprzedaz/zamowienia.php', $zapytanie, $ile_licznika, $ile_pozycji, 'orders_id'); ?>
            </script>              
            
        </div>

        <?php include('stopka.inc.php'); ?>

    <?php }

}
?>
