<?php
chdir('../../');

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

if (isset($_POST['plugin']) && !empty($_POST['plugin']) && isset($_POST['offset']) && (int)$_POST['offset'] > -1 && Sesje::TokenSpr()) {

    $porownywarki = new Porownywarki($_POST['plugin'], $_POST['offset'], $_POST['limit']);

    if ( count($porownywarki->produkty) > 0 ) {
      
        $tablica_dostepnosci = Porownywarki::TablicaDostepnosci( '', true );

        $CoDoZapisania = '';
        $DoZapisaniaXML = '';
        $plik = KATALOG_SKLEPU . 'xml/' . $filtr->process($_POST['plugin']) . '.xml';

        // uchwyt pliku, otwarcie do dopisania
        $fp = fopen($plik, "a");
        // blokada pliku do zapisu
        flock($fp, 2);

        // dane do zapisania do pliku START

        for ( $i = 0, $c = count($porownywarki->produkty); $i < $c; $i++ ) {

            if ( $tablica_dostepnosci[ $porownywarki->produkty[$i]['dostepnosc_id'] ] == '1' ) {
                 $dostepnosc = '1';
              } else {
                 $dostepnosc = '99';
            }
            
            $DoZapisaniaXML .= "<offer>\n"; 
            $DoZapisaniaXML .= "<id><![CDATA[" . $porownywarki->produkty[$i]['id_produktu'] . "]]></id>\n";
            $DoZapisaniaXML .= "<url><![CDATA[" . $porownywarki->produkty[$i]['url_produktu'] . "]]></url>\n";
            $DoZapisaniaXML .= "<price><![CDATA[" . $porownywarki->produkty[$i]['cena_brutto_produktu'] . "]]></price>\n";
            $DoZapisaniaXML .= "<brand><![CDATA[" . $porownywarki->produkty[$i]['producent_produktu'] . "]]></brand>\n";
            $DoZapisaniaXML .= "<avail><![CDATA[" . $dostepnosc . "]]></avail>\n";
            $DoZapisaniaXML .= "<cat><![CDATA[" . $porownywarki->produkty[$i]['kategoria_produktu'] . "]]></cat>\n";
            $DoZapisaniaXML .= "<name><![CDATA[" . $porownywarki->produkty[$i]['nazwa_produktu'] . "]]></name>\n";
            
            $DoZapisaniaXML .= "<imgs>\n";
            $DoZapisaniaXML .= "    <img default=\"true\">\n";
            $DoZapisaniaXML .= "         <![CDATA[" . $porownywarki->produkty[$i]['zdjecie_produktu'] . "]]>\n";
            $DoZapisaniaXML .= "    </img>\n";

            // dodatkowe zdjecia
            if ( count($porownywarki->produkty[$i]['dodatkowe_zdjecia']) > 0 ) {
                 //
                 $DodatkoweZdjecia = $porownywarki->produkty[$i]['dodatkowe_zdjecia'];
                 //
                 foreach ( $DodatkoweZdjecia as $Zdjecie ) {
                    //
                    $DoZapisaniaXML .= "    <img>\n";
                    $DoZapisaniaXML .= "         <![CDATA[" . $Zdjecie . "]]>\n";
                    $DoZapisaniaXML .= "    </img>\n"; 
                    //
                 }
                 //
                 unset($DodatkoweZdjecia);
                 //
            }             
            
            $DoZapisaniaXML .= "</imgs>\n";

            // promocja
            if ( $porownywarki->produkty[$i]['promocja'] == 'tak' ) {
                 //
                 $DoZapisaniaXML .= "<isPromoted>1</isPromoted>\n";
                 $DoZapisaniaXML .= "<oldprice><![CDATA[" . $porownywarki->produkty[$i]['cena_stara_produktu'] . "]]></oldprice>\n";
                 //
              } else {
                 //
                 $DoZapisaniaXML .= "<isPromoted>0</isPromoted>\n";
                 $DoZapisaniaXML .= "<oldprice><![CDATA[0]]></oldprice>\n";
                 //
            }
                 
            $DoZapisaniaXML .= "<desc>\n";
            $DoZapisaniaXML .= "    <![CDATA[" . $porownywarki->produkty[$i]['opis_produktu'] . "]]>\n";
            $DoZapisaniaXML .= "</desc>\n";

            $DoZapisaniaXML .= "<attrs>\n";
            $DoZapisaniaXML .= "    <attr name=\"Kod_producenta\">\n";
            $DoZapisaniaXML .= "        <![CDATA[" . $porownywarki->produkty[$i]['kod_producenta_produktu'] . "]]>\n";
            $DoZapisaniaXML .= "    </attr>\n";
            
            // cechy produktu
            if ( count($porownywarki->produkty[$i]['cechy']) > 0 ) {

                foreach ( $porownywarki->produkty[$i]['cechy'] as $key => $value ) {
                    //
                    $wartosc_txt = array();
                    $wartosci = explode(',', $value[1]);
                    foreach ( $wartosci as $wartosc ) {
                        //
                        $wartosc_txt[] = Porownywarki::TekstZamienEncje(Funkcje::WartoscCechy($wartosc));
                        //
                    }
                    //
                    if ( count($wartosc_txt) > 0 ) {
                         $DoZapisaniaXML .= "    <attr name=\"" . $key . "\">\n";
                         $DoZapisaniaXML .= "        <![CDATA[" . implode(';', $wartosc_txt) . "]]>\n";
                         $DoZapisaniaXML .= "    </attr>\n";               
                    }            
                    //
                    unset($wartosc_txt, $wartosci);
                    //
                }
                //
            }

            // dodatkowe pola do produktu
            if ( count($porownywarki->produkty[$i]['pola']) > 0 ) {
                //
                foreach ( $porownywarki->produkty[$i]['pola'] as $key => $value ) {
                    //        
                    if ( !empty($value) ) {
                         $DoZapisaniaXML .= "    <attr name=\"" . $key . "\">\n";
                         $DoZapisaniaXML .= "        <![CDATA[" . Porownywarki::TekstZamienEncje($value) . "]]>\n";
                         $DoZapisaniaXML .= "    </attr>\n";
                    }
                    //
                }
                //
            }               

            $DoZapisaniaXML .= "</attrs>\n";

            $DoZapisaniaXML .= "</offer>\n";


        }
        // dane do zapisania do pliku END

        // jezeli poczatek pliku
        if ((int)$_POST['offset'] == 0) {
            ///
            $CoDoZapisania = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            $CoDoZapisania .= "<offers>\n";

            $CoDoZapisania .= $DoZapisaniaXML;
            //
        } else {
            //
            $CoDoZapisania = $DoZapisaniaXML;
            //
        }
        //
        // koniec pliku
        if (isset($_POST['limit_max']) && (int)$_POST['limit_max'] <= (int)$_POST['offset'] + (int)$_POST['limit']) {
            $CoDoZapisania .= "</offers>";
        }
    }
 
    fwrite($fp, $CoDoZapisania);

    // zapisanie danych do pliku
    flock($fp, 3);
    // zamkniecie pliku
    fclose($fp);

    unset($CoDoZapisania);

}
echo 'OK';

?>