<?php
chdir('../');            

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {

  // wczytanie klasy do obslugi Allegro
  $allegro = new Allegro(true, true);
  $komunikat = '';

  if (isset($_POST['akcja']) && $_POST['akcja'] == 'zapisz') {
    Funkcje::PrzekierowanieURL('allegro_wystaw_aukcje.php?id_poz'.$_POST['id'].'');
  }

  //jezeli nie ma ustawionego ID produktu przekierowanie na strone listy produktow
  if ( isset($_GET['id_poz']) && $_GET['id_poz'] == '0' ) {
    Funkcje::PrzekierowanieURL('../produkty/produkty.php');
  }

  // wczytanie naglowka HTML
  include('naglowek.inc.php');

  if ( $komunikat != '' ) {
    echo $komunikat;
  }

  $id_produktu = $filtr->process($_GET['id_poz']);

  $zapytanie = 'SELECT DISTINCT
                p.products_id, 
                p.products_image,
                p.products_model,
                p.products_price_tax,
                p.products_quantity,
                p.products_price_tax,
                p.products_pkwiu,
                p.products_tax_class_id,
                p.products_currencies_id,
                pd.products_id, 
                pd.language_id, 
                pd.products_name,
                pd.products_description
                FROM products p, products_description pd
                WHERE pd.products_id = p.products_id AND pd.language_id = "' . $_SESSION['domyslny_jezyk']['id'] . '" AND p.products_id = "'.$id_produktu.'"'; 

  $sql = $db->open_query($zapytanie);

  $parametry = $allegro->TablicaDefinicjiPol( false );

  ?>
    
    <div id="naglowek_cont">Obsługa Allegro</div>
    <div id="cont">

      <?php if ( count($parametry) > 0  ) { ?>

        <script src="/zarzadzanie/allegro/allegro_opis.js"></script>     
        
        <script>
        $(document).ready(function() {

            $("#allegroForm").validate({
             rules: {
              fid_5: {range: [1, 1000],number: true}
             }
            });
              
            // wystawienie aukcji	
            $('#form_submit').click(function(){

                for ( instance in CKEDITOR.instances )
                    CKEDITOR.instances[instance].updateElement();

                var frm = $("#allegroForm");
                var response_text = $('#wystawianie');
                var response_form = $('#wynik');
                var response_dalej = $('#kontynuuj');
                var dane = frm.serialize();
                var daneTbl = frm.serializeArray();
                var proceed = true;

                response_text.hide();

                if (proceed == true) {
                  response_text.html('<img src="obrazki/_loader.gif">').show();

                  $.post('ajax/allegro_wystaw_aukcje.php?tok=' + $('#tok').val(), dane, function(data){
                    response_form.slideUp();
                    response_text.html(data);
                    response_dalej.slideDown();
                  });
                }

                return false;
              
            });

            // test aukcji
            $('#form_test').click(function(){

                for ( instance in CKEDITOR.instances )
                    CKEDITOR.instances[instance].updateElement();

                var frm = $("#allegroForm");
                var response_text = $('#wystawianie');
                var response_form = $('#wynik');
                var dane = frm.serialize();
                var daneTbl = frm.serializeArray();
                var proceed = true;

                response_text.hide();

                if (proceed == true) {
                
                  response_text.html('<img src="obrazki/_loader.gif">').show();

                  $.post('ajax/allegro_sprawdz_aukcje.php?tok=' + $('#tok').val(), dane, function(data){
                    response_form.slideUp();
                    response_text.html(data);
                  });
                }

                return false;
              
            });
            
            <?php if ( $allegro->polaczenie['CONF_NEW_DESCRIPTION'] != 'tak' ) { ?>

            // podglad aukcji
            $('#form_preview').click(function(){

                for ( instance in CKEDITOR.instances )
                    CKEDITOR.instances[instance].updateElement();

                var frm = $("#allegroForm");
                var response_text = $('#wystawianie');
                var response_form = $('#wynik');
                var dane = frm.serialize();
                var daneTbl = frm.serializeArray();
                var proceed = true;

                response_text.hide();

                if (proceed == true) {

                  response_text.html('<img src="obrazki/_loader.gif">').show();

                  $.post('ajax/allegro_podglad_aukcji.php?tok=' + $('#tok').val(), dane, function(data){
                    response_form.slideUp();
                    response_text.hide();
                    $.colorbox( { html:data, maxWidth:"98%", maxHeight:"98%", open:true, initialWidth:50, initialHeight:50, speed: 200, overlayClose:false, escKey:true, onLoad: function() {
                      $("#cboxClose").show();
                    }});

                  });
                }

                return false;
              
            });
            
            // podglad zrodla aukcji
            $('#form_source').click(function(){

                for ( instance in CKEDITOR.instances )
                    CKEDITOR.instances[instance].updateElement();

                var frm = $("#allegroForm");
                var response_text = $('#wystawianie');
                var response_form = $('#wynik');
                var dane = frm.serialize();
                var daneTbl = frm.serializeArray();
                var proceed = true;

                response_text.hide();

                if (proceed == true) {

                  response_text.html('<img src="obrazki/_loader.gif">').show();

                  $.post('ajax/allegro_podglad_aukcji.php?tok=<?php echo Sesje::Token(); ?>&zrodlo', dane, function(data){
                    response_form.slideUp();
                    response_text.hide();
                    $.colorbox( { html:data, maxWidth:"98%", maxHeight:"98%", open:true, initialWidth:50, initialHeight:50, speed: 200, overlayClose:false, escKey:true, onLoad: function() {
                      $("#cboxClose").show();
                    }});

                  });
                }

                return false;
              
            });     
            
            <?php } ?>

            var $research = $('.koszt_wysylki_dodatkowe');
            $research.find("tr").not('.accordion').hide();
            $research.find(".zwin").toggleClass("rozwin");            
          
        });
        
        function pokazKategorieSklepu(wartosc) {
            var id = $(wartosc).val();
            if (id == '1') {
              $('#kategorieSklep').slideDown();
            } else {
              $('#kategorieSklep').slideUp();
            }
        }

        function rozwin(typ) {
            var $research = $('.'+typ);
            $research.find(".accordion").siblings("tr").fadeToggle(200);
            $research.find(".zwin").toggleClass("rozwin");
        };
        </script>
        
        <div class="poleForm cmxform" style="margin-bottom:10px">
          <div class="naglowek">Ustawienia konfiguracji do wystawienia aukcji</div>

          <div class="pozycja_edytowana">
          
            <?php require_once('allegro_naglowek.php'); ?>
            
          </div>          
        </div>
        
        <form action="ajax/allegro_wystaw_aukcje.php" method="post" id="allegroForm" class="cmxform"> 

          <div>
              <input type="hidden" name="akcja" value="zapisz" />
              <input type="hidden" name="produkt_id" id="produkt_id" value="<?php echo $id_produktu; ?>" />
              <input type="hidden" name="fid_9" value="<?php echo $allegro->polaczenie['CONF_COUNTRY']; ?>" />
          </div>
          
          <div class="poleForm">
            <div class="naglowek">Wystawianie aukcji</div>

            <div class="pozycja_edytowana">

              <?php
              $rodzaj_opisu = 'stary';
              
              if ((int)$db->ile_rekordow($sql) > 0) {

                $info = $sql->fetch_assoc();
                
                $zdjecie_glowne =  $info['products_image'];
                $id_kategorii = 0;
                
                // dodatkowe parametry allegro dla produktu
                $zapytanie_tmp = "select * from products_allegro_info where products_id = '".(int)$_GET['id_poz']."'";
                $sqls = $db->open_query($zapytanie_tmp);

                if ((int)$db->ile_rekordow($sql) > 0) {
                
                    $dane_allegro = $sqls->fetch_assoc();
                    //
                    if ( strlen($dane_allegro['products_description_allegro']) > 5 ) {
                         $info['products_description'] = $dane_allegro['products_description_allegro'];
                    } 
                    
                    // rodzaj opisu
                    if ( $dane_allegro['products_description_type'] == 'nowy' ) {
                         $rodzaj_opisu = 'nowy';
                    }
                    
                    if ( $dane_allegro['products_price_allegro'] > 0 ) {
                         $info['products_price_tax'] = $dane_allegro['products_price_allegro'];
                      } else {
                         $info['products_price_tax'] = $waluty->FormatujCeneBezSymbolu($info['products_price_tax'], true, '', '', '2', $info['products_currencies_id']);
                    }
                    if ( !empty($dane_allegro['products_name_allegro']) ) {
                         $info['products_name'] = Funkcje::formatujTekstInput($dane_allegro['products_name_allegro']);
                    }
                    if ( !empty($dane_allegro['products_image_allegro']) ) {
                         $zdjecie_glowne = $dane_allegro['products_image_allegro'];
                    } 
                    //
                    $id_kategorii = $dane_allegro['products_cat_id_allegro'];
                    
                }
                                             
                //  
                // echo ukryte id kategorii
                echo '<div id="ukryte_id">' . $id_kategorii . '</div>';  
                
                $db->close_query($sqls);
                unset($zapytanie_tmp, $dane_allegro, $id_kategorii);

                ?>
                <div class="info_content">

                    <div class="ObramowanieForm" style="margin-top:10px;">

                      <!-- Dane ogolne -->
                      <table>
                      
                        <tr class="accordion">
                          <td colspan="2" style="padding-left:10px; text-align:left">Wystawiany produkt</td>
                        </tr>
                        
                        <?php
                        // FID-1 Nazwa produktu
                        $fid = '1';
                        $default = mb_substr($info['products_name'],0,50);

                        $identyfikator = '';
                        if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                            $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                        }

                        echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                        //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                        echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                        echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' '. $identyfikator.' >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';

                        echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="fid_'.$parametry[$fid]['sell_form_id'].'" maxlength="50" onkeyup="licznik_znakow(this,\'iloscZnakowNazwa\',50)"', true);                        
                        echo '<br /><span style="display:inline-block;margin:4px;">Ilość znaków do wpisania: <span class="iloscZnakow" id="iloscZnakowNazwa">' . (50-strlen(utf8_decode($default))) . '</span></span>';
                        echo '</td></tr>';

                        $ilosc_wystawiana = $info['products_quantity'];
                        $cechy_poczatkowe = '';
                        // wyswietlenie cech produktu START
                        $i = 0;
                        $zapytanie_cechy = "SELECT DISTINCT popt.products_options_id, popt.products_options_name 
                                            FROM products_options popt, products_attributes patrib where patrib.products_id='" . (int)$id_produktu . "' and patrib.options_id = popt.products_options_id and popt.language_id = '".$_SESSION['domyslny_jezyk']['id']."' and patrib.options_values_id != '0' ORDER BY popt.products_options_sort_order asc";

                        $sql_cechy = $db->open_query($zapytanie_cechy);

                        if ((int)$db->ile_rekordow($sql_cechy) > 0) {

                          $dostepne_cechy = array();
                          while ( $info_cechy = $sql_cechy->fetch_assoc() ) {

                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">&nbsp;</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( '' ).'</b></em>';

                            echo '<label for="cecha_'.$info_cechy['products_options_id'].'">'.$info_cechy['products_options_name'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                            $tablica = Funkcje::lista_wartosci_cechy_produktu_allegro($info['products_id'], $info_cechy['products_options_id']);
                            $cechy_poczatkowe .= $info_cechy['products_options_id'] .'-'.$tablica['0']['id'].',';
                            echo Funkcje::RozwijaneMenu('cecha['.$info_cechy['products_options_id'].']', $tablica, '', 'id="cecha_'.$info_cechy['products_options_id'].'" style="width:250px;" onchange="stan()" ');
                            echo '</td></tr>';
                            $dostepne_cechy[] = $info_cechy['products_options_id'];
                            $i++;
                            
                          }

                          $cechy_poczatkowe = substr($cechy_poczatkowe,0,-1);

                          if (CECHY_MAGAZYN == 'tak') {
                            
                            $cec = "select distinct * from products_stock where products_id = '".$id_produktu ."' and products_stock_attributes = '".$cechy_poczatkowe."'";
                            $sqlw = $db->open_query($cec);
                            if ((int)$db->ile_rekordow($sqlw) > 0) {
                              $ilosc_cechy = $sqlw->fetch_assoc(); 
                              $ilosc_wystawiana = $ilosc_cechy['products_stock_quantity'];
                            } else {
                              $ilosc_wystawiana = 0;
                            }
                            $db->close_query($sqlw);

                            print "<script type=\"text/javascript\"  language=\"javascript\">";
                            print "//<![CDATA[\n";
                            print "var zmienna          = new Array()\n";
                            print "var tablica_wartosci = new Array()\n";

                            foreach($dostepne_cechy as $tym) print "zmienna.push('$tym')\n";

                            print "function stan() {\n";
                            print "for ( x=0; x < zmienna.length; x++) {\n";
                            print "  tablica_wartosci.push(zmienna[x]+'-'+$('#cecha_'+zmienna[x]+'').val());\n";
                            print "}\n";

                            print "$.post( \"ajax/sprawdz_ilosc_produktu.php?tok=" . Sesje::Token() . "\",\n";
                            print "{\n";
                            print "cechy             :tablica_wartosci,\n";
                            print "id_produktu       :'$id_produktu',\n";
                            print "},\n";
                            print "function(data){\n";
                            print "if ( data < 1 ) {\n";
                            print "$('#stanMagazyn').slideDown();\n";
                            print "}\n";
                            print "if ( data > 0 ) {\n";
                            print "$('#stanMagazyn').slideUp();\n";
                            print "}\n";
                            print "$('#fid_5').val(data);\n";

                            print "});\n";
                            print "tablica_wartosci = [];\n";
                            print "};\n";
                            print "//]]>\n";
                            print "</script>";

                          }

                        }

                        // wyswietlenie cech produktu END
                        echo '<tr id="stanMagazyn" class="PozycjaAllegroForm" '.( $ilosc_wystawiana == 0 ? '' : 'style="display:none;"' ) .'><td colspan="2"><div class="ostrzezenie">Ostrzeżenie - wybranego produktu nie ma obecnie w magazynie - mimo to możesz go wystawić</div></td></tr>';

                        // FID-2 Kategoria
                        $fid = '2';
                        $default = '';
                        $identyfikator = '';
                        if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                            $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                        }


                        echo '<tr class="PozycjaAllegroForm" id="idKategorii"><td class="pozycjaAllegro">';
                        //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                        echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';


                        echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' '. $identyfikator.' >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                        echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="fid_'.$parametry[$fid]['sell_form_id'].'"', true);
                        echo '</td></tr>';

                        ?>
                      </table>
                      
                      <div id="catsPL">
                        <div id="treePL" class="treeBox"></div>
                      </div> 

                      <p id="drzewo_allegro_cont">
                        <span id="drzewo_allegro" class="DrzewoAllegro">pokaż drzewo kategorii Allegro</span>
                      </p>                       

                      <!-- Dane dla wybranej kategorii -->
                      <div id="dodatkowe_opcje_kategorii" style="display: none;"></div>
                      
                    </div>
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">

                      <!-- Opis produktu -->
                      <table class="opis">
                      
                        <tr class="accordion">
                          <td style="text-align:right">
                            <div class="zwin" onclick="rozwin('opis');"></div><div>Opis produktu</div>
                          </td>
                        </tr>
                        
                        <?php                        
                        // FID-341 - nowy opis produktu
                        if ( $allegro->polaczenie['CONF_NEW_DESCRIPTION'] == 'tak' ) {
                          
                            $tablica_allegro = '';
                            
                            if ( strpos($info['products_description'], '{') > -1 ) {
                                 $tablica_allegro = @unserialize($info['products_description']);
                            }
                            
                            if ( is_array($tablica_allegro) ) {
                          
                                for ( $x = 1; $x < 9; $x++ ) {
                                
                                    echo '<tr><td style="padding:10px 15px 10px 10px">';
                                    
                                        echo '<div id="NaglowekSekcja_' . $x . '" class="NaglowekSekcja Sekcja' . (($x > 1 && !isset($tablica_allegro[$x][0])) ? 'Zwin' : 'Rozwin') . '" onclick="rozwin_opis(\'' . $x . '\')">Wiersz nr ' . $x . '</div>';
                                    
                                        echo '<div id="Sekcja_' . $x . '"' . (($x > 1 && !isset($tablica_allegro[$x][0])) ? ' style="display:none"' : '') . '>';
                                    
                                            echo '<ul class="WyborOpisu">';
                                            echo '  <li>Wybierz sposób wyświetlania</li>';                            
                                            echo '  <li class="DomyslnyListing SposobWyswietlania' . ((!isset($tablica_allegro[$x][0]) || $tablica_allegro[$x][0] == 'listing') ? ' Wl' : '') . '" data-kasuj="0" data-nr="' . $x . '" data-typ="listing"><img src="/zarzadzanie/obrazki/allegro_opis_listing.png" alt="Tylko tekst" /></li>';
                                            echo '  <li class="SposobWyswietlania' . ((isset($tablica_allegro[$x][0]) && $tablica_allegro[$x][0] == 'zdjecie') ? ' Wl' : '') . '" data-kasuj="0" data-nr="' . $x . '" data-typ="zdjecie"><img src="/zarzadzanie/obrazki/allegro_opis_zdjecie.png" alt="Tylko zdjęcie" /></li>';
                                            echo '  <li class="SposobWyswietlania' . ((isset($tablica_allegro[$x][0]) && $tablica_allegro[$x][0] == 'zdjecie_listing') ? ' Wl' : '') . '" data-kasuj="0" data-nr="' . $x . '" data-typ="zdjecie_listing"><img src="/zarzadzanie/obrazki/allegro_opis_zdjecie_listing.png" alt="Zdjęcie i tekst" /></li>';
                                            echo '  <li class="SposobWyswietlania' . ((isset($tablica_allegro[$x][0]) && $tablica_allegro[$x][0] == 'listing_zdjecie') ? ' Wl' : '') . '" data-kasuj="0" data-nr="' . $x . '" data-typ="listing_zdjecie"><img src="/zarzadzanie/obrazki/allegro_opis_listing_zdjecie.png" alt="Tekst i zdjecie" /></li>';
                                            echo '  <li class="SposobWyswietlania' . ((isset($tablica_allegro[$x][0]) && $tablica_allegro[$x][0] == 'zdjecie_zdjecie') ? ' Wl' : '') . '" data-kasuj="0" data-nr="' . $x . '" data-typ="zdjecie_zdjecie"><img src="/zarzadzanie/obrazki/allegro_opis_zdjecie_zdjecie.png" alt="Dwa zdjecia" /></li>';
                                            echo '  <li class="SposobWyswietlania' . ((isset($tablica_allegro[$x][0]) && $tablica_allegro[$x][0] == 'listing_listing') ? ' Wl' : '') . '" data-kasuj="0" data-nr="' . $x . '" data-typ="listing_listing"><img src="/zarzadzanie/obrazki/allegro_opis_listing_listing.png" alt="Dwa teksty" /></li>';
                                            echo '  <li class="SposobWyswietlania" data-kasuj="' . $x . '" data-nr="' . $x . '" data-typ="listing" style="margin:14px 0px 0px 30px"><img src="/zarzadzanie/obrazki/kasuj.png" alt="Tylko tekst" /></li>';
                                            echo '</ul>';

                                            if ( isset($tablica_allegro[$x]) ) {
                                              
                                                echo '<div id="ListaOpis_' . $x . '">';
                                            
                                                    echo '<input type="hidden" name="opis_sekcja_' . $x . '" value="' . $tablica_allegro[$x][0] . '" />';

                                                    // tylko listing
                                                    if ( $tablica_allegro[$x][0] == 'listing' ) {

                                                        echo '<table class="OpisFoto"><tr>';
                                                        
                                                            echo '<td><textarea id="opis_txt_' . $x . '" name="opis_txt_' . $x . '" cols="90" rows="10">' . $tablica_allegro[$x][1][0] . '</textarea></td>';
                                                            
                                                        echo '</tr></table>';
                                                        
                                                        echo '<script>ckedit_allegro(\'opis_txt_' . $x . '\',\'99%\',\'200\')</script>';

                                                    }
                                                    
                                                    // tylko zdjecie
                                                    if ( $tablica_allegro[$x][0] == 'zdjecie' ) {
                                                    
                                                        echo '<table class="OpisFoto"><tr>';
                                                        
                                                            echo '<td class="ListaFoto" id="kont_opis_img_' . $x . '">
                                                            
                                                                <input type="hidden" id="opis_img_' . $x . '" name="opis_img_' . $x . '" value="' . $tablica_allegro[$x][1][0] . '" />
                                                                <img onclick="wybierz_foto(\'opis_img_' . $x . '\')" src="/' . KATALOG_ZDJEC . '/' . $tablica_allegro[$x][1][0] . '" alt="" />
                    
                                                            </td>';

                                                        echo '</tr></table>';

                                                    }        
                                                    
                                                    // zdjecie i listing
                                                    if ( $tablica_allegro[$x][0] == 'zdjecie_listing' ) {
                                                    
                                                        echo '<table class="OpisFoto"><tr>';
                                                        
                                                            echo '<td class="ListaFoto" id="kont_opis_img_' . $x . '">
                                                            
                                                                <input type="hidden" id="opis_img_' . $x . '" name="opis_img_' . $x . '" value="' . $tablica_allegro[$x][1][0] . '" />
                                                                <img onclick="wybierz_foto(\'opis_img_' . $x . '\')" src="/' . KATALOG_ZDJEC . '/' . $tablica_allegro[$x][1][0] . '" alt="" />
                                                                
                                                            </td>';
                                                        
                                                            echo '<td><textarea id="opis_txt_' . $x . '" name="opis_txt_' . $x . '" cols="90" rows="10">' . $tablica_allegro[$x][1][1] . '</textarea></td>';
                                                            
                                                        echo '</tr></table>';
                                                        
                                                        echo '<script>ckedit_allegro(\'opis_txt_' . $x . '\',\'100%\',\'200\')</script>';

                                                    }
                                                    
                                                    // listing i zdjecie
                                                    if ( $tablica_allegro[$x][0] == 'listing_zdjecie' ) {
                                                    
                                                        echo '<table class="OpisFoto"><tr>';
                                                        
                                                            echo '<td><textarea id="opis_txt_' . $x . '" name="opis_txt_' . $x . '" cols="90" rows="10">' . $tablica_allegro[$x][1][0] . '</textarea></td>';
                                                                    
                                                            echo '<td class="ListaFoto" id="kont_opis_img_' . $x . '">
                                                            
                                                                <input type="hidden" id="opis_img_' . $x . '" name="opis_img_' . $x . '" value="' . $tablica_allegro[$x][1][1] . '" />
                                                                <img onclick="wybierz_foto(\'opis_img_' . $x . '\')" src="/' . KATALOG_ZDJEC . '/' . $tablica_allegro[$x][1][1] . '" alt="" />
                                                                
                                                            </td>';

                                                            
                                                        echo '</tr></table>';
                                                        
                                                        echo '<script>ckedit_allegro(\'opis_txt_' . $x . '\',\'100%\',\'200\')</script>';

                                                    }    

                                                    // zdjecie i zdjecie
                                                    if ( $tablica_allegro[$x][0] == 'zdjecie_zdjecie' ) {
                                                    
                                                        echo '<table class="OpisFoto"><tr>';
                                                        
                                                            echo '<td class="ListaFoto" id="kont_opis_img_a_' . $x . '">
                                                            
                                                                <input type="hidden" id="opis_img_a_' . $x . '" name="opis_img_a_' . $x . '" value="' . $tablica_allegro[$x][1][0] . '" />
                                                                <img onclick="wybierz_foto(\'opis_img_a_' . $x . '\')" src="/' . KATALOG_ZDJEC . '/' . $tablica_allegro[$x][1][0] . '" alt="" />
                                                                
                                                            </td>';
                                                        
                                                            echo '<td class="ListaFoto" id="kont_opis_img_b_' . $x . '">
                                                            
                                                                <input type="hidden" id="opis_img_b_' . $x . '" name="opis_img_b_' . $x . '" value="' . $tablica_allegro[$x][1][1] . '" />
                                                                <img onclick="wybierz_foto(\'opis_img_b_' . $x . '\')" src="/' . KATALOG_ZDJEC . '/' . $tablica_allegro[$x][1][1] . '" alt="" />
                                                                
                                                            </td>';

                                                        echo '</tr></table>';

                                                    }     

                                                    // listing i listing
                                                    if ( $tablica_allegro[$x][0] == 'listing_listing' ) {

                                                        echo '<table class="OpisFoto"><tr>';
                                                        
                                                            echo '<td><textarea id="opis_txt_a_' . $x . '" name="opis_txt_a_' . $x . '" cols="90" rows="10">' . $tablica_allegro[$x][1][0] . '</textarea></td>';
                                                            
                                                            echo '<td style="width:10px">&nbsp;</td>';
                                                            
                                                            echo '<td><textarea id="opis_txt_b_' . $x . '" name="opis_txt_b_' . $x . '" cols="90" rows="10">' . $tablica_allegro[$x][1][1] . '</textarea></td>';
                                                            
                                                        echo '</tr></table>';
                                                        
                                                        echo '<script>ckedit_allegro(\'opis_txt_a_' . $x . '\',\'98%\',\'200\'); ckedit_allegro(\'opis_txt_b_' . $x . '\',\'98%\',\'200\')</script>';

                                                    }           

                                                echo '</div>';                            
                                            
                                            } else {

                                                echo '<div id="ListaOpis_' . $x . '">';
                                                
                                                    echo '<input type="hidden" name="opis_sekcja_' . $x . '" value="listing" />';
                                                
                                                    echo '<table class="OpisFoto"><tr>';
                                                    
                                                        echo '<td><textarea id="opis_txt_' . $x . '" name="opis_txt_' . $x . '" cols="90" rows="10"></textarea></td>';
                                                        
                                                        unset($opis);
                                                        
                                                    echo '</tr></table>';
                                                    
                                                    echo '<script>ckedit_allegro(\'opis_txt_' . $x . '\',\'100%\',\'200\')</script>';
                                                
                                                echo '</div>';
                                                
                                            }
                                        
                                        echo '</div>';
                                    
                                    echo '</td></tr>';

                                }  

                            } else {
                              
                                for ( $x = 1; $x < 9; $x++ ) {
                                
                                    echo '<tr><td style="padding:10px 15px 10px 10px">';
                                    
                                        echo '<div id="NaglowekSekcja_' . $x . '" class="NaglowekSekcja Sekcja' . (($x > 1) ? 'Zwin' : 'Rozwin') . '" onclick="rozwin_opis(\'' . $x . '\')">Wiersz nr ' . $x . '</div>';
                                    
                                        echo '<div id="Sekcja_' . $x . '"' . (($x > 1) ? ' style="display:none"' : '') . '>';
                                    
                                            echo '<ul class="WyborOpisu">';
                                            echo '  <li>Wybierz sposób wyświetlania</li>';
                                            echo '  <li class="DomyslnyListing SposobWyswietlania Wl" data-kasuj="0" data-nr="' . $x . '" data-typ="listing"><img src="/zarzadzanie/obrazki/allegro_opis_listing.png" alt="Tylko tekst" /></li>';
                                            echo '  <li class="SposobWyswietlania" data-nr="' . $x . '" data-kasuj="0" data-typ="zdjecie"><img src="/zarzadzanie/obrazki/allegro_opis_zdjecie.png" alt="Tylko zdjęcie" /></li>';
                                            echo '  <li class="SposobWyswietlania" data-nr="' . $x . '" data-kasuj="0" data-typ="zdjecie_listing"><img src="/zarzadzanie/obrazki/allegro_opis_zdjecie_listing.png" alt="Zdjęcie i tekst" /></li>';
                                            echo '  <li class="SposobWyswietlania" data-nr="' . $x . '" data-kasuj="0" data-typ="listing_zdjecie"><img src="/zarzadzanie/obrazki/allegro_opis_listing_zdjecie.png" alt="Tekst i zdjecie" /></li>';
                                            echo '  <li class="SposobWyswietlania" data-nr="' . $x . '" data-kasuj="0" data-typ="zdjecie_zdjecie"><img src="/zarzadzanie/obrazki/allegro_opis_zdjecie_zdjecie.png" alt="Dwa zdjecia" /></li>';
                                            echo '  <li class="SposobWyswietlania" data-nr="' . $x . '" data-kasuj="0" data-typ="listing_listing"><img src="/zarzadzanie/obrazki/allegro_opis_listing_listing.png" alt="Dwa teksty" /></li>';
                                            echo '  <li class="SposobWyswietlania" data-kasuj="' . $x . '" data-nr="' . $x . '" data-typ="listing" style="margin:14px 0px 0px 30px"><img src="/zarzadzanie/obrazki/kasuj.png" alt="Tylko tekst" /></li>';
                                            echo '</ul>';

                                            echo '<div id="ListaOpis_' . $x . '">';
                                            
                                                echo '<input type="hidden" name="opis_sekcja_' . $x . '" value="listing" />';
                                            
                                                echo '<table class="OpisFoto"><tr>';
                                                
                                                    $opis = '';
                                                    //
                                                    if ( $x == 1 ) {
                                                         $opis = preg_replace('/([\r\n\t])/', '', strip_tags($info['products_description']));
                                                    }
                                                
                                                    echo '<td><textarea id="opis_txt_' . $x . '" name="opis_txt_' . $x . '" cols="90" rows="10">' . $opis . '</textarea></td>';
                                                    
                                                    unset($opis);
                                                    
                                                echo '</tr></table>';
                                                
                                                echo '<script>ckedit_allegro(\'opis_txt_' . $x . '\',\'100%\',\'200\')</script>';
                                            
                                            echo '</div>';
                                        
                                        echo '</div>';
                                    
                                    echo '</td></tr>';

                                }                
                              
                            }                          

                            echo '<input type="hidden" name="fid_24" value="Brak opisu" />';
                            
                        } else {
                          
                            // FID-24 - stary opis produktu
                            
                            echo '<tr><td style="padding:10px 15px 10px 10px">';
                            
                            echo '<textarea id="fid_24" name="fid_24" cols="90" rows="10">' . (($rodzaj_opisu == 'nowy') ? '' : $info['products_description']) . '</textarea>';
                            
                            echo '<script>$(document).ready(function() { ckedit(\'fid_24\',\'100%\',\'400\') })</script>';
                            
                            echo '</td></tr>';
                          
                        }
                        ?>
                        
                      </table>
                      
                    </div>
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">                            

                      <!-- Zdjecia produktu -->
                      <table class="foto">
                      
                        <tr class="accordion">
                          <td colspan="2">
                            <div class="zwin" onclick="rozwin('foto');"></div><div>Zdjęcia produktu</div>
                          </td>
                        </tr>
                        
                        <?php
                        // FID-16 Zdjecie glowne produktu                        
                        $fid = 16;
                        
                        echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                        echo '<em class="TipIkona"><b>' . $allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ) . '</b></em>';

                        echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . '>' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                        
                        echo '<div style="padding:10px"><input type="checkbox" value="1" name="fid_' . $fid . '" id="fid_' . $fid . '" checked="checked" /><label class="OpisFor" for="fid_' . $fid . '">dodaj do aukcji zdjęcie produktu (wybierz poniżej, które zdjęcie ma być zdjęciem głównym) '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></div>';
                        
                        echo '<table class="ZdjeciaAllegro"><tr>';
                        
                            $nr_foto = 1;
                            $tablica_zdjec = array();
                            $tablica_zdjec_input = array();
                        
                            // pierwsze zdjecie - zdjecie przypisane do produktu allegro
                            if ( $zdjecie_glowne != '' && $zdjecie_glowne != $info['products_image'] ) {
                                //
                                $tablica_zdjec[] = '<td>' . Funkcje::pokazObrazek($zdjecie_glowne, $info['products_name'], '50', '50') . '<br /><input type="radio" id="foto_allegro_' . $nr_foto . '" value="' . $zdjecie_glowne . '" name="foto_allegro" checked="checked" /><label class="OpisFor" for="foto_allegro_' . $nr_foto . '">wybierz</label></td>';                              
                                $tablica_zdjec_input[] = $zdjecie_glowne;
                                $nr_foto++;
                                //
                            }
                            
                            // drugie zdjecie - glowne zdjecie produktu
                            if ( $info['products_image'] != '' ) {
                                 //                                   
                                 $tablica_zdjec[] = '<td>' . Funkcje::pokazObrazek($info['products_image'], $info['products_name'], '50', '50') . '<br /><input type="radio" id="foto_allegro_' . $nr_foto . '" value="' . $info['products_image'] . '" name="foto_allegro" ' . (($nr_foto == 1) ? 'checked="checked"' : '') . ' /><label class="OpisFor" for="foto_allegro_' . $nr_foto . '">wybierz</label></td>';
                                 $tablica_zdjec_input[] = $info['products_image'];
                                 $nr_foto++;
                                 // 
                            }                                
                            
                            $zapytanie_zdjecia = "SELECT * FROM additional_images WHERE products_id = '".$id_produktu."' order by sort_order";
                            $sql_zdjecia = $db->open_query($zapytanie_zdjecia); 

                            if ((int)$db->ile_rekordow($sql_zdjecia) > 0 || $info['products_image'] != '') {
                              
                                while ( $info_zdjecia = $sql_zdjecia->fetch_assoc()) {
                                
                                    if ( is_file('../' . KATALOG_ZDJEC . '/' . $info_zdjecia['popup_images']) ) {
                                         //
                                         $tablica_zdjec[] = '<td>' . Funkcje::pokazObrazek($info_zdjecia['popup_images'], $info['products_name'], '50', '50') . '<br /><input type="radio" id="foto_allegro_' . $nr_foto . '" value="' . $info_zdjecia['popup_images'] . '" name="foto_allegro" ' . (($nr_foto == 1) ? 'checked="checked"' : '') . ' /><label class="OpisFor" for="foto_allegro_' . $nr_foto . '">wybierz</label></td>';                              
                                         $tablica_zdjec_input[] = $info_zdjecia['popup_images'];
                                         $nr_foto++;                                         
                                         //
                                    }
                                    
                                }                       
                        
                            }
                                                          
                            $db->close_query($sql_zdjecia);
                            unset($zapytanie_zdjecia, $info_zdjecia);                              

                            for ($x = 0; $x < count($tablica_zdjec); $x++) {
                                 //
                                 echo $tablica_zdjec[$x];
                                 //
                                 if ( $x == 6 || $x == 13 || $x == 20 ) {
                                      echo '</tr><tr>';
                                 }                                   
                                 //
                            }                              
                        
                        echo '</tr></table>';
                        
                        foreach ( $tablica_zdjec_input as $tmp ) {
                            echo '<input type="hidden" name="zdjecia_tmp[]" value="' . $tmp . '" />';
                        }
                        
                        echo '</td></tr>';
                        
                        unset($fid);
                        
                        // dla starego opisu produktu
                        if ( $allegro->polaczenie['CONF_NEW_DESCRIPTION'] != 'tak' ) {
                          
                            $zapytanie_zdjecia = "SELECT * FROM additional_images WHERE products_id = '".$id_produktu."' order by sort_order";
                            $sql_zdjecia = $db->open_query($zapytanie_zdjecia);
                            
                            $wynik_dodatkowe_zdjecia = '';
                            $wynik_zdjecia_galeria = '';
                            
                            if ((int)$db->ile_rekordow($sql_zdjecia) > 0 || $info['products_image'] != '') {

                              $wynik_dodatkowe_zdjecia .= '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                              $wynik_dodatkowe_zdjecia .= '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( '' ).'</b></em>';

                              $wynik_zdjecia_galeria = $wynik_dodatkowe_zdjecia;
                              
                              $wynik_dodatkowe_zdjecia .= '<label>Zdjęcia w treści aukcji: <span class="szare">wyświetlane za pomocą znacznika [ZDJECIA] w szablonie aukcji</span></label></td><td class="pozycjaAllegro">';
                              $wynik_dodatkowe_zdjecia .= '<table class="ZdjeciaAllegro"><tr>';
                              
                              // pierwsze zdjecie w dodatkowych zdjeciach - glowne zdjecie produktu
                              $wynik_dodatkowe_zdjecia.= '<td>' . Funkcje::pokazObrazek($info['products_image'], $info['products_name'], '50', '50') . '<br /><input type="checkbox" id="foto_dodatkowe" value="'.$info['products_image'].'" name="dodatkowe_foto[]" ' . ($allegro->polaczenie['CONF_DODATKOWE_FOTO'] == 'zdjecia' ? 'checked="checked"' : '' ) . ' /><label class="OpisFor" for="foto_dodatkowe">wybierz</label></td>';
                              
                              $wynik_zdjecia_galeria .= '<label>Zdjęcia do galerii: <span class="szare">wyświetlane za pomocą znacznika [GALERIA] w szablonie aukcji</span> '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                              $wynik_zdjecia_galeria .= '<table class="ZdjeciaAllegro"><tr>';                          
                              
                              // pierwsze zdjecie w galerii - glowne zdjecie produktu
                              $wynik_zdjecia_galeria .= '<td>' . Funkcje::pokazObrazek($info['products_image'], $info['products_name'], '50', '50') . '<br /><input type="checkbox" id="foto_galeria" value="'.$info['products_image'].'" name="galeria_foto[]" ' . ($allegro->polaczenie['CONF_DODATKOWE_FOTO'] == 'galeria' ? 'checked="checked"' : '' ) . ' /><label class="OpisFor" for="foto_galeria" >wybierz</label></td>';

                              $col = 1;
                              $j = 1;
                              while ( $info_zdjecia = $sql_zdjecia->fetch_assoc()) {
                              
                                if ( is_file('../' . KATALOG_ZDJEC . '/' . $info_zdjecia['popup_images']) ) {
                                  $wynik_dodatkowe_zdjecia .= '<td>' . Funkcje::pokazObrazek($info_zdjecia['popup_images'], $info['products_name'], '50', '50') . '<br /><input type="checkbox" id="foto_dodatkowe_' . $j . '" value="'.$info_zdjecia['popup_images'].'" name="dodatkowe_foto[]" ' . ($allegro->polaczenie['CONF_DODATKOWE_FOTO'] == 'zdjecia' ? 'checked="checked"' : '' ) . ' /><label class="OpisFor" for="foto_dodatkowe_' . $j . '">wybierz</label></td>';
                                  $wynik_zdjecia_galeria .= '<td>' . Funkcje::pokazObrazek($info_zdjecia['popup_images'], $info['products_name'], '50', '50') . '<br /><input type="checkbox" id="foto_galeria_' . $j . '" value="'.$info_zdjecia['popup_images'].'" name="galeria_foto[]" ' . ($allegro->polaczenie['CONF_DODATKOWE_FOTO'] == 'galeria' ? 'checked="checked"' : '' ) . ' /><label class="OpisFor" for="foto_galeria_' . $j . '">wybierz</label></td>';
                                  $j++;
                                  $col++;
                                }
                                
                                if ( $col == 7 || $col == 14 || $col == 21 ) {
                                    $wynik_dodatkowe_zdjecia .= '</tr><tr>';
                                    $wynik_zdjecia_galeria .= '</tr><tr>';
                                }
                                
                              }

                              $wynik_dodatkowe_zdjecia .= '</tr></table>';
                              $wynik_dodatkowe_zdjecia .= '</td></tr>';
                              
                              $wynik_zdjecia_galeria .= '</tr></table>';
                              $wynik_zdjecia_galeria .= '</td></tr>';                          
                              
                            }
                            
                            echo $wynik_dodatkowe_zdjecia;
                            
                            if ( (int)$db->ile_rekordow($sql_zdjecia) > 0 && $info['products_image'] != '') {
                                echo $wynik_zdjecia_galeria;
                            }
                            
                            $db->close_query($sql_zdjecia);
                            unset($zapytanie_zdjecia, $wynik_dodatkowe_zdjecia, $wynik_zdjecia_galeria);
                            
                        }
                        ?>
                      </table>
                      
                    </div>
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">                            

                      <!-- Dane ogolne -->
                      <table>
                      
                        <tr class="accordion">
                          <td colspan="2" style="text-align:left; padding-left:10px;">Dane dotyczące sprzedaży</td>
                        </tr>
                        
                        <?php
                        // FID-29 Format sprzedazy
                        $opcje_ogolne = array(29);
                        for ( $i = 0, $c = count($opcje_ogolne); $i < $c; $i++ ) {
                          $fid = $opcje_ogolne[$i];

                          if ( isset($parametry[$fid]) ) {

                            $identyfikator = '';
                            if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                                $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                            }

                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                            $default = '';
                            if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                            echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'onchange="pokazKategorieSklepu(this);" id="fid_'.$parametry[$fid]['sell_form_id'].'"', true);
                            echo '</td></tr>';
                          }
                        }
                        
                        // FID-31 Kategoria w sklepie Allegro
                        $fid = '31';
                        $default = '';
                        echo '<tr id="kategorieSklep" class="PozycjaAllegroForm" style="display:none"><td class="pozycjaAllegro">';
                        //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                        echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                        echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . '>' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                        echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, '', true);
                        echo '</td></tr>';


                        // FID-3  Data rozpoczecia aukcji
                        $opcje_ogolne = array(3);
                        for ( $i = 0, $c = count($opcje_ogolne); $i < $c; $i++ ) {
                          $fid = $opcje_ogolne[$i];

                          if ( isset($parametry[$fid]) ) {

                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' for="datetimepicker" >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';

                            echo '<input name="fid_3" type="text" value="" id="datetimepicker"/>';
                            echo '</td></tr>';
                          }
                        }

                        // FID-4  Czas trwania aukcji
                        // FID-5  Liczba sztuk
                        // FID-28 Sztuki/komplety/pary
                        $opcje_ogolne = array(4,5,28);
                        for ( $i = 0, $c = count($opcje_ogolne); $i < $c; $i++ ) {
                          $fid = $opcje_ogolne[$i];
                          $default = '';

                          if ( isset($parametry[$fid]) ) {

                            $identyfikator = '';
                            if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                                $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                            }


                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                            if ( $fid == '5' ) {
                              $default = $ilosc_wystawiana;
                            } else {
                              if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];
                            }

                            echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="fid_'.$parametry[$fid]['sell_form_id'].'"', true);
                            echo '</td></tr>';
                          }
                        }

                        // FID-6 Cena wywolawcza
                        // FID-7 Cena minimalna
                        // FID-8 Cena Kup Teraz
                        $opcje_ogolne = array(6,7,8);
                        for ( $i = 0, $c = count($opcje_ogolne); $i < $c; $i++ ) {
                          $fid = $opcje_ogolne[$i];
                          $default = '';

                          if ( isset($parametry[$fid]) ) {

                            $identyfikator = '';
                            if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                                $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                            }


                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .str_replace('\\','',$parametry[$fid]['sell_form_title']).': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                            if ( $fid == '8' ) {
                              $default = $info['products_price_tax'];
                            } else {
                              if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];
                            }

                            echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="fid_'.$parametry[$fid]['sell_form_id'].'"', true);
                            echo '</td></tr>';
                          }
                        }

                        // FID-9 Kraj
                        // FID-10 Wojewodztwo
                        // FID-11 Miejscowosc
                        // FID-32 Kod pocztowy
                        $opcje_ogolne = array(9,10,11,32);
                        for ( $i = 0, $c = count($opcje_ogolne); $i < $c; $i++ ) {
                          $fid = $opcje_ogolne[$i];
                          $default = '';

                          if ( isset($parametry[$fid]) ) {

                            $identyfikator = '';
                            if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                                $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                            }

                            if ( $parametry[$fid]['sell_form_id'] == '9') {

                                $TablicaPanstw = $allegro->doGetCountries();
                                $parametry[$fid]['sell_form_type'] = '4';
                                $default = '';
                                if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                                foreach ( $TablicaPanstw as $Panstwo ) {
                                    $P = (array)$Panstwo;
                                    if ( $P['country-name'] != '' && $P['country-id'] != '' ) {
                                        $parametry[$fid]['sell_form_desc'] .= $P['country-name'] . '|';
                                        $parametry[$fid]['sell_form_opts_values'] .= $P['country-id'] . '|';
                                    }
                                    unset($P);
                                }

                            }

                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                            if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                            echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="fid_'.$parametry[$fid]['sell_form_id'].'"', true);
                            echo '</td></tr>';
                          }
                        }
                        ?>
                        
                      </table>
                      
                    </div>
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">                            

                      <!-- Dane dotyczace transportu -->
                      <table class="transport">
                      
                        <tr class="accordion">
                          <td colspan="2">
                            <div class="zwin" onclick="rozwin('transport');"></div><div>Dane dotyczące transportu</div>
                          </td>
                        </tr>
                        
                        <?php
                        // FID-12 Koszt wysylki pokrywa
                        // FID-13 Dodatkowe informacje
                        // FID-35 Darmowa wysylka
                        // FID-340 Termin wysylki
                        $opcje_wysylki = array(12,13,35,340);

                        for ( $i = 0, $c = count($opcje_wysylki); $i < $c; $i++ ) {
                          $fid = $opcje_wysylki[$i];
                          $default = '';

                          if ( isset($parametry[$fid]) ) {

                            $identyfikator = '';
                            if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                                $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                            }

                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';

                            if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];
                            echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="fid_'.$parametry[$fid]['sell_form_id'].'"', true);
                            echo '</td></tr>';
                          }
                        }
                        ?>
                        
                      </table>
                      
                    </div>
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">                            

                      <!-- Dane dotyczace platnosci -->
                      <table class="platnosc">
                      
                        <tr class="accordion">
                          <td colspan="2">
                            <div class="zwin" onclick="rozwin('platnosc');"></div><div>Dane dotyczące płatności</div>
                          </td>
                        </tr>
                        
                        <?php
                        // FID-14 Formy platnosci
                        // FID-33 Pierwsze konto bankowe
                        // FID-34 Drugie konto bankowe
                        // FID-27 Dodatkowe uwagi
                        $opcje_platnosci = array(14,33,34,27);
                        $default = '';

                        for ( $i = 0, $c = count($opcje_platnosci); $i < $c; $i++ ) {
                          $fid = $opcje_platnosci[$i];

                          if ( isset($parametry[$fid]) ) {

                            $identyfikator = '';
                            if ( $parametry[$fid]['sell_form_type'] == '1' || $parametry[$fid]['sell_form_type'] == '2' || $parametry[$fid]['sell_form_type'] == '3' || $parametry[$fid]['sell_form_type'] == '4' || $parametry[$fid]['sell_form_type'] == '8' ) {
                                $identyfikator = 'for="fid_'.$parametry[$fid]['sell_form_id'].'"';
                            }

                            if ( $parametry[$fid]['sell_form_id'] == '33' || $parametry[$fid]['sell_form_id'] == '34' ) {
                              $parametry[$fid]['sell_form_field_desc'] = 'Format 26 cyfr pisanych łącznie';
                            }
                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . ' ' . $identyfikator . ' >' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                            if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                            echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, 'id="fid_'.$parametry[$fid]['sell_form_id'].'"', true);
                            echo '</td></tr>';
                          }

                        }
                        ?>
                        
                      </table>
                      
                    </div>
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">                            

                      <!-- Dodatkowe opcje aukcji -->
                      <table class="opcje">
                      
                        <tr class="accordion">
                          <td colspan="2">
                            <div class="zwin" onclick="rozwin('opcje');"></div><div>Dodatkowe opcje</div>
                          </td>
                        </tr>
                        
                        <?php
                        // FID-15 Dodatkowe opcje wystawiania aukcji
                        $opcje_platnosci = array(15);
                        $default = '';

                        for ( $i = 0, $c = count($opcje_platnosci); $i < $c; $i++ ) {
                          $fid = $opcje_platnosci[$i];

                          if ( isset($parametry[$fid]) ) {
                            if ( $parametry[$fid]['sell_form_id'] == '33' || $parametry[$fid]['sell_form_id'] == '34' ) {
                              $parametry[$fid]['sell_form_field_desc'] = 'Format 26 cyfr pisanych łącznie';
                            }
                            echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                            //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</div>';
                            echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( $parametry[$fid]['sell_form_field_desc'] ).'</b></em>';

                            echo '<label '.($parametry[$fid]['sell_form_opt'] == '1' ? 'class="required"' : '' ) . '>' .$parametry[$fid]['sell_form_title'].': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$fid.')' : '' ).'</label></td><td class="pozycjaAllegro">';
                            if (isset($allegro->parametry[$fid])) $default = $allegro->parametry[$fid];

                            echo $allegro->StworzPole($parametry[$fid]['sell_form_id'], $parametry[$fid]['sell_form_title'], $parametry[$fid]['sell_form_type'], $parametry[$fid]['sell_form_opts_values'], $parametry[$fid]['sell_form_desc'], $parametry[$fid]['sell_form_opt'], $default, '', true);
                            echo '</td></tr>';
                          }

                        }
                        ?>
                        
                      </table>
                      
                    </div>
                    
                    <script>
                    $(document).ready(function() {
                      
                        $("#szablon_wysylek").change(function () {		
                        
                            $('#KosztyWysylekKontener').html('<div style="padding:10px"><img src="obrazki/_loader_small.gif" alt="" /></div>');
                            $.get("ajax/allegro_szablon_wysylek.php", { id: $(this).val(), tok: $('#tok').val() }, function(data) { 
                                $('#KosztyWysylekKontener').html(data);
                                //
                                var $research = $('.koszt_wysylki_dodatkowe');
                                $research.find("tr").not('.accordion').hide();
                                $research.find(".zwin").toggleClass("rozwin");
                                //
                                $(".kropkaPustaZero").change(		
                                  function () {
                                    var type = this.type;
                                    var tag = this.tagName.toLowerCase();
                                    if (type == 'text' && tag != 'textarea' && tag != 'radio' && tag != 'checkbox') {
                                        //
                                        if ($(this).val() != '') {
                                            zamien_krp($(this), '0.00');
                                        }
                                        //
                                    }
                                  }
                                );                                 
                                //
                            });
                        
                        });
                      
                    });
                    </script>
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">
                    
                      <!-- szablon kosztow dostawy -->
                      <table>
                      
                        <tr class="accordion">
                          <td colspan="2">
                            Koszty wysyłek - szablony kosztów wysyłek
                          </td>
                        </tr>
                        
                        <?php
                        echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                        echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( 'Wybierz szablon który kosztów wysyłek jeżeli ma być inny niż domyślny' ).'</b></em>';

                        echo '<label for="szablon">Szablon kosztów wysyłek:</label></td><td class="pozycjaAllegro">';
                        echo Allegro::SzablonyKosztowWysylek();
                        echo '</td></tr>';
                        ?>
                        
                      </table>                        
                    
                    </div>
                    
                    <?php
                    $tablicaWysylek = array();
                    //
                    $zapytanie = "select distinct * from allegro_shipping_params where id = '1'";
                    $sqls = $db->open_query($zapytanie);
                    while ($info = $sqls->fetch_assoc()) {
                      //
                      $tablicaWysylek[$info['params']] = $info['value'];
                      //
                    }
                    //
                    $db->close_query($sqls);
                    unset($zapytanie);   

                    $wysylkiAktywne = '';
                    $wysylkiPuste = '';
                    
                    foreach ( $tablicaWysylek as $klucz => $wysylkaPozycja ) {
                    
                        if ( $klucz < 100 ) {
                          
                            if ( $wysylkaPozycja > 0 || $wysylkaPozycja == '0.00' ) {
                              
                                $wysylkiAktywne .= '<tr class="PozycjaAllegroForm"><td><label class="PozycjaAllegroFormLabel" for="fid_' . $parametry[$klucz]['sell_form_id'] . '">' . str_replace(" (pierwsza sztuka)", '', $parametry[$klucz]['sell_form_title']).': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$klucz.')' : '' ).'</label></td>';
                              
                            } else {
                              
                                $wysylkiPuste .= '<tr class="PozycjaAllegroForm"><td><label class="PozycjaAllegroFormLabel" for="fid_' . $parametry[$klucz]['sell_form_id'] . '">' . str_replace(" (pierwsza sztuka)", '', $parametry[$klucz]['sell_form_title']).': '.(isset($_SESSION['programista']) && $_SESSION['programista'] == '1' ? '('.$klucz.')' : '' ).'</label></td>';
                                
                            }
                              
                            for ( $x = 0; $x < 3; $x++ ) {
                              
                                $wartosc = '';
                                
                                if ( isset($tablicaWysylek[($klucz + ($x * 100))]) ) {
                                  
                                     if ( $tablicaWysylek[($klucz + ($x * 100))] > 0 ) {
                                       
                                          $wartosc = number_format($tablicaWysylek[($klucz + ($x * 100))], 2);
                                          
                                     } elseif ( $tablicaWysylek[($klucz + ($x * 100))] == '0.00' ) {

                                          $wartosc = number_format(0, 2);

                                     }

                                }                                     

                                if ( $wysylkaPozycja > 0 || $wysylkaPozycja == '0.00' ) {
                              
                                    $wysylkiAktywne .= '<td class="pozycjaAllegro PozycjaDostawy"><input id="fid_' . ($klucz + ($x * 100)) . '" class="kropkaPustaZero" type="text" value="' . $wartosc . '" size="20" name="fid_' . ($klucz + ($x * 100)) . '"></td>';
                                    
                                } else {
                                  
                                    $wysylkiPuste .= '<td class="pozycjaAllegro PozycjaDostawy"><input id="fid_' . ($klucz + ($x * 100)) . '" class="kropkaPustaZero" type="text" value="" size="20" name="fid_' . ($klucz + ($x * 100)) . '"></td>';
                                   
                                }                                   
                                
                                unset($wartosc);
                                
                            }                              
                            
                            if ( $wysylkaPozycja > 0 || $wysylkaPozycja == '0.00' ) {
                              
                                $wysylkiAktywne .= '</tr>';
                                
                            } else {
                              
                                $wysylkiPuste .= '</tr>';
                                
                            }

                        }
                    
                    }                    
                    ?>
                    
                    <div id="KosztyWysylekKontener">
                    
                        <div class="ObramowanieForm" style="margin-top:10px;">                            

                          <!-- Koszty wysylki -->
                          <table class="koszt_wysylki KosztWysylkiBezRamki">
                          
                            <tr class="accordion">
                              <td>
                                Koszty wysyłki
                              </td>
                              <td class="PozycjaDostawy">Pierwsza sztuka</td>
                              <td class="PozycjaDostawy">Druga sztuka</td>
                              <td class="PozycjaDostawy">Ilość w paczce</td>
                            </tr>
                            
                            <?php echo $wysylkiAktywne; ?>
                            
                          </table>
                          
                        </div>
                        
                        <div class="ObramowanieForm" style="margin-top:10px;">                            

                          <!-- Dodatkowe koszty wysylki -->
                          <table class="koszt_wysylki_dodatkowe KosztWysylkiBezRamki">
                          
                            <tr class="accordion">
                              <td>
                                <div class="PozycjaAllegroFormLabel">
                                    <div class="zwin" onclick="rozwin('koszt_wysylki_dodatkowe');"></div><div>Dodatkowe wysyłki</div>
                                </div>
                              </td>
                              <td class="PozycjaDostawy">Pierwsza sztuka</td>
                              <td class="PozycjaDostawy">Druga sztuka</td>
                              <td class="PozycjaDostawy">Ilość w paczce</td>
                            </tr>
                            
                            <?php echo $wysylkiPuste; ?>
                            
                          </table>

                        </div>
                        
                    </div>
                    
                    <?php unset($wysylkiAktywne, $wysylkiPuste, $tablicaWysylek); ?>
                    

                    <div class="ObramowanieForm" style="margin-top:10px;">                            

                      <!-- Dane dotyczace platnosci -->
                      <table class="aftersales">
                      
                        <tr class="accordion">
                          <td colspan="2">
                            <div class="zwin" onclick="rozwin('aftersales');"></div><div>Warunki oferty</div>
                          </td>
                        </tr>

                        <tr class="PozycjaAllegroForm">
                            <td class="pozycjaAllegro"><em class="TipIkona"><b>Gwarancje zdefiniowane w serwisie Allegro - można odczytać z paska przeglądarki wchodząc na nie przez stronę Allegro w edycje</b></em><label>Informacje o gwarancjach:</label></td>
                            <td class="pozycjaAllegro"><?php echo Allegro::AfterSalesConditions( (isset($_SESSION['allegro_user_login']) ? $_SESSION['allegro_user_login'] : ''), 'g' ); ?></td>
                        </tr>

                        <tr class="PozycjaAllegroForm">
                            <td class="pozycjaAllegro"><em class="TipIkona"><b>Warunki reklamacji zdefiniowane w serwisie Allegro - można odczytać z paska przeglądarki wchodząc na nie przez stronę Allegro w edycje</b></em><label>Warunki reklamacji:</label></td>
                            <td class="pozycjaAllegro"><?php echo Allegro::AfterSalesConditions( (isset($_SESSION['allegro_user_login']) ? $_SESSION['allegro_user_login'] : ''), 'r' ); ?></td>
                        </tr>

                        <tr class="PozycjaAllegroForm">
                            <td class="pozycjaAllegro"><em class="TipIkona"><b>Polityki zwrotów zdefiniowane w serwisie Allegro - można odczytać z paska przeglądarki wchodząc na nie przez stronę Allegro w edycje</b></em><label>Polityka zwrotów:</label></td>
                            <td class="pozycjaAllegro"><?php echo Allegro::AfterSalesConditions( (isset($_SESSION['allegro_user_login']) ? $_SESSION['allegro_user_login'] : ''), 'z' ); ?></td>
                        </tr>

                      </table>
                      
                    </div>
                    
                    
                    <div class="ObramowanieForm" style="margin-top:10px;">

                      <!-- Szablon aukcji -->
                      <table class="szablon">
                      
                        <tr class="accordion">
                          <td colspan="2">
                            <div class="zwin" onclick="rozwin('szablon');"></div><div>Szablon aukcji</div>
                          </td>
                        </tr>
                        
                        <?php
                        echo '<tr class="PozycjaAllegroForm"><td class="pozycjaAllegro">';
                        //echo '<div class="Pomoc">'.$allegro->FormatujOpisPola('Wybierz szablon który ma być użyty do wystawienia aukcji').'</div>';
                        echo '<em class="TipIkona"><b>'.$allegro->FormatujOpisPola( 'Wybierz szablon który ma być użyty do wystawienia aukcji' ).'</b></em>';

                        echo '<label for="szablon">Szablon aukcji:</label></td><td class="pozycjaAllegro">';
                        echo Allegro::SzablonyAllegro( $allegro->polaczenie['CONF_DEFAULT_TEMPLATE'] );
                        echo '</td></tr>';
                        ?>
                        
                      </table>
                      
                    </div>                    
                          
                </div>

                <?php 
              }
              ?>

            </div>
            
            <script src="javascript/jquery.KategorieAllegro.js" type="text/javascript"></script>
            <script type="text/javascript" src="programy/datetimepicker/jquery.datetimepicker.js"></script>
            <link rel="stylesheet" type="text/css" href="programy/datetimepicker/jquery.datetimepicker.css" />

            <script>
            var currentDate = new Date();
            var MinutesLater = new Date(currentDate.getTime() + (1 * 60 * 1000));

            $('#datetimepicker').datetimepicker({
                dayOfWeekStart : 1,
                lang:'pl'
            });
            
            $('#datetimepicker').datetimepicker({value:MinutesLater,minDate:0,minTime:0,format:'d-m-Y H:i',step:5});

            $(document).ready( function() {
            
              function dodatkoweOpcje(file,lisc) {

                $('#dodatkowe_opcje_kategorii').slideUp();
                var response_form = $('#dodatkowe_opcje_kategorii');
                var dane = file;
                var dzialaj = lisc;

                if (dzialaj == true) {
                  //
                  $('#ekr_preloader').css('display','block');
                  //
                  $.post('ajax/allegro_wczytaj_opcje_kategorii.php?tok=<?php echo Sesje::Token(); ?>', { kategoria: dane }, function(data) {
                    //
                    $('#ekr_preloader').css('display','none');
                    //
                    if ( data != '') {
                      response_form.html(data);
                      response_form.slideDown( $.scrollTo('#dodatkowe_opcje_kategorii',400) );
                    } else {
                      response_form.slideUp();
                      response_form.empty();
                    }
                  });
                }
                
              }              
            
              $('#drzewo_allegro').click( function() {
              
                  $('#drzewo_allegro_cont').slideUp();
                  $('#catsPL').slideDown();                
            
                  $('#treePL').fileTree({
                    root: '0',
                    script: 'ajax/drzewo_allegro.php',
                    expandSpeed: 500,
                    collapseSpeed: 500,
                    multiFolder: false
                  },
                  function(file,name,lisc) {
                    $('#fid_2').val(file);
                    if ( file != '' ) {
                        $('#drzewo_allegro_cont').slideDown();
                        $('#catsPL').slideUp();
                    }
                    dodatkoweOpcje(file,lisc);
                  });
                  
              });
              
              $('#idKategorii input').removeClass('kropkaPustaZero').addClass('calkowita');
              
              $('#idKategorii input').change(function() {
                  $(this).val( parseInt($(this).val()) );
                  //
                  if (isNaN($(this).val())) {
                      $(this).val( '' );
                    } else {
                      $(this).val( parseInt($(this).val()) );
                  }
                  dodatkoweOpcje($(this).val(),true);
              });
              
              if ( parseInt($('#ukryte_id').html()) > 0 ) {
                  $('#idKategorii input').val($('#ukryte_id').html());
              }
              dodatkoweOpcje($('#ukryte_id').html(),true);                                
              
            });
            </script>        

            <div class="info_content">
              <div id="wystawianie" style="display:none;"></div>
              <div id="wynik" style="padding-bottom:20px;display:none;"></div>
            </div>

            <?php 
            if ((int)$db->ile_rekordow($sql) > 0) {
              
              $pochodzenie = explode('/', $_SERVER['HTTP_REFERER']);?>
              
              <div class="przyciski_dolne">
                <div id="przycisk_wystaw" style="float:left"><input id="form_submit" type="submit" class="przyciskNon" value="Wystaw aukcje" /></div>
                <div id="przycisk_sprawdz" style="float:left"><input id="form_test" type="submit" class="przyciskNon" value="Sprawdź poprawność" /></div>
                
                <?php if ( $allegro->polaczenie['CONF_NEW_DESCRIPTION'] != 'tak' ) { ?>
                
                    <div id="przycisk_podglad" style="float:left"><input id="form_preview" type="submit" class="przyciskNon" value="Podgląd aukcji" /></div>
                    <div id="przycisk_podglad_zrodla" style="float:left"><input id="form_source" type="submit" class="przyciskNon" value="Podgląd źródła Html aukcji" /></div>
                    
                <?php } ?>
                
                <button type="button" class="przyciskNon" onclick="cofnij('allegro_aukcje','<?php echo Funkcje::Zwroc_Get(array('x','y')); ?>','allegro');">Lista aukcji</button>     
                <button type="button" class="przyciskNon" onclick="cofnij('produkty','<?php echo Funkcje::Zwroc_Get(array('x','y')); ?>','produkty');">Powrót</button>                
              </div>
              
            <?php } else { ?>
            
              <div class="przyciski_dolne">
                <button type="button" class="przyciskNon" onclick="cofnij('index','<?php echo Funkcje::Zwroc_Get(array('x','y')); ?>','');">Powrót</button>
              </div>
              
            <?php } ?>
            
          </div>
          
        </form>

      <?php } ?>

    </div>
    
    <div id="WygladPop">

        <div id="ekr_edit" class="EkranEdycjiAllegro">
        
            <div id="edit_tlo" class="TloEdycjiAllegro"></div>
            
            <div id="edytuj_stale" class="EdytujWygladAllegro">
            
                <div id="edytuj_okno" class="OknoEdycjiWygladu">
                
                    <img class="ZamknijBox" onclick="zamknij_edycje()" src="obrazki/zamknij.png" alt="Zamknij okno" />
                    
                    <div id="glowne_okno_edycji"></div>
                    
                </div>
                
            </div>
            
        </div>

    </div>    
    
    <?php
    include('stopka.inc.php');

}

?>