// edytor w wersji okrojonej dla nowego opisu allegro
function ckedit_allegro(id, szerokosc, wysokosc) {
    CKEDITOR.replace( id, {
        width: szerokosc,
        height: wysokosc,
        autoGrow_minHeight : wysokosc,
        filebrowserWindowFeatures : 'menubar=no,toolbar=no,minimizable=no,resizable=no,scrollbars=no',
        coreStyles_bold: { element: 'b' },
        toolbar_cms: [[ 'Source','Format','Bold','NumberedList','BulletedList' ]],
        format_tags: 'p;h1;h2',
        enterMode: CKEDITOR.ENTER_P
      }
    );
}     

// wybor zdjecia dla nowego opisu allegro
function wybierz_foto( id ) {
    //
    $('#ekr_preloader').css('display','block');
    //
    $.get('ajax/allegro_wybor_foto.php', { tok: $('#tok').val(), id_produktu: $('#produkt_id').val(), id_pola: id }, function(data) {

        $('#ekr_preloader').fadeOut();
        //
        $('#ekr_edit').css('display','none');
        $('#glowne_okno_edycji').html(data);
        //
        $('#ekr_edit').show();
        $('#ekr_edit').css({'visibility':'hidden'});
        var margines = $(window).height() - $('#edytuj_okno').height() - 50;
        //
        if ( margines < 10 ) {
             margines = 40;
        }
        if ( $('#StrGlowna').width() < 900 ) {
             margines = 80;
        }        
        //
        $('#edytuj_stale').css({ 'top' : margines / 2 });
        
        if ( $('#edytuj_okno').outerHeight() > $(window).height() ) {
             $('#edytuj_okno').css({ 'max-height' : $(window).height() - 100, 'overflow-y' : 'scroll' });
        }
        
        $('#ekr_edit').css({'visibility':'visible'});
        $('#ekr_edit').hide();
        //
        $('#ekr_edit').fadeIn();
    });
} 

// wybor zdjecia dla nowego opisu allegro - podczas produktu
function wybierz_foto_produkt( id ) {
    //
    przegladarka( $('#opis_typ').attr('data-images'), id, 'strona', '', '' );
    //
}      

// zamkniecie okna edycji
function zamknij_edycje() {
    $('#ekr_edit').fadeOut( function(data) { $('#glowne_okno_edycji').html(''); } );
}        

$(document).ready(function() {

    if ( $('#WygladPop').length ) {
         $('#WygladPop').insertBefore('#ekr_preloader');
    }
  
    // skalowanie okna wyboru zdjecia w opisie aukcji
    $(window).resize(function() {
      
        if ( $('#edytuj_stale').length ) {
          
            var margines = $(window).height() - $('#edytuj_okno').height() - 50;
            //
            if ( margines < 10 ) {
                 margines = 40;
            }
            if ( $('#StrGlowna').width() < 900 ) {
                 margines = 80;
            }        
            //        
            $('#edytuj_stale').css({ 'top' : margines / 2 });
            
            if ( $('#edytuj_okno').outerHeight() > $(window).height() ) {
                 $('#edytuj_okno').css({ 'max-height' : $(window).height() - 100, 'overflow-y' : 'scroll' });
              } else {
                 $('#edytuj_okno').css({ 'max-height' : 'none', 'overflow-y' : 'auto' });
              }
            
        }
        
    });          
  
    // zmiana sposobu wyswietlania opisu
    $('.SposobWyswietlania').click(function() {
      
        $('#ekr_preloader').css('display','block');
        
        $('#Sekcja_' + $(this).attr('data-nr') + ' .WyborOpisu li').removeClass('Wl');
        
        if ( parseInt($(this).attr('data-kasuj')) > 0 ) {
             $('#Sekcja_' + $(this).attr('data-kasuj') + ' .DomyslnyListing').addClass('Wl');
          } else {        
             $(this).addClass('Wl');
        }
        
        var nr = $(this).attr('data-nr');
        
        var produkt = 'nie';
        
        if ( $('#opis_typ').length ) {
             produkt = 'tak';
        }

        $.get('ajax/allegro_opis.php', { nr: nr, typ: $(this).attr('data-typ'), produkt: produkt, tok: $('#tok').val() }, function(data) {
            //
            $('#ekr_preloader').fadeOut();
            $('#ListaOpis_' + nr).html(data);
            //  
        });                            

    });
    
});

function rozwin_opis(nr) {
    if ( $('#Sekcja_' + nr).css('display') == 'none' ) {
         $('#Sekcja_' + nr).fadeIn(200);
         $('#NaglowekSekcja_' + nr).removeClass('SekcjaZwin').addClass('SekcjaRozwin');
      } else { 
         $('#Sekcja_' + nr).fadeOut(200);
         $('#NaglowekSekcja_' + nr).removeClass('SekcjaRozwin').addClass('SekcjaZwin');
    }
};
