<?php
chdir('../'); 

// wczytanie ustawien inicjujacych system
require_once('ustawienia/init.php');

// zainicjowanie klasy sprawdzajacej czy uzytkownik ma dostep do modulu
$prot = new Dostep($db);

if ($prot->wyswietlStrone) {
     
    // id waluty PLN
    $IdPLN = 1;
    //
    if ( isset($_SESSION['tablica_walut_kod']) ) {
        //
        $IdWalut = $_SESSION['tablica_walut_kod'];
        foreach ( $IdWalut as $WalutaSklepu ) {
            //
            if ( $WalutaSklepu['kod'] == 'PLN' ) {
                 $IdPLN = $WalutaSklepu['id'];
            }
            //
        }
        unset($IdWalut);  
        //
    }

    if (isset($_GET['kategoria_id']) && (int)$_GET['kategoria_id'] > 0) {
        unset($_SESSION['filtry']['allegro_aukcje.php']['kategoria_allegro']);
    }
    
    if (isset($_GET['kategoria_allegro']) && (int)$_GET['kategoria_allegro'] > 0) {
        unset($_SESSION['filtry']['allegro_aukcje.php']['kategoria_id']);
    }
    
    Listing::postGet(basename($_SERVER['SCRIPT_NAME']));

    $allegro = new Allegro();

    $warunki_szukania = '';
    // jezeli jest szukanie
    if (isset($_GET['szukaj']) && $_GET['szukaj'] != '' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj']);
        $warunki_szukania = " AND ( ap.auction_id LIKE '%".$szukana_wartosc."%' OR ap.products_name LIKE '%".$szukana_wartosc."%' ) ";
        unset($szukana_wartosc);
    }
    
    // jezeli jest nr kat 
    if (isset($_GET['nrkat']) && !empty($_GET['nrkat'])) {   
        $szukana_wartosc = $filtr->process($_GET['nrkat']);
        $warunki_szukania = " and (p.products_model like '%".$szukana_wartosc."%' or p.products_man_code like '%".$szukana_wartosc."%')";
        unset($szukana_wartosc);
    }    

    if ( isset($_GET['szukaj_status']) && $_GET['szukaj_status'] != '0' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_status']);
        $warunki_szukania .= " and ap.auction_status = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_status_produktu']) && $_GET['szukaj_status_produktu'] != '0' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_status_produktu']);
        if ( $szukana_wartosc == '2' ) $szukana_wartosc = '0';
        $warunki_szukania .= " and p.products_status = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_archiwum_allegro']) && $_GET['szukaj_archiwum_allegro'] != '0' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_archiwum_allegro']);
        if ( $szukana_wartosc == '2' ) $szukana_wartosc = '0';
        $warunki_szukania .= " and ap.archiwum_allegro = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_format']) && $_GET['szukaj_format'] != '0' ) {
        $szukana_wartosc = $filtr->process($_GET['szukaj_format']);
        if ( $szukana_wartosc == '2' ) $szukana_wartosc = '0';
        $warunki_szukania .= " and ap.auction_buy_now = '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_data_zakonczenia_od']) && $_GET['szukaj_data_zakonczenia_od'] != '' ) {
        $szukana_wartosc = date('Y-m-d H:i:s', strtotime($filtr->process($_GET['szukaj_data_zakonczenia_od'] . ' 00:00:00')));
        $warunki_szukania .= " and ap.auction_date_end >= '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }

    if ( isset($_GET['szukaj_data_zakonczenia_do']) && $_GET['szukaj_data_zakonczenia_do'] != '' ) {
        $szukana_wartosc = date('Y-m-d H:i:s', strtotime($filtr->process($_GET['szukaj_data_zakonczenia_do'] . ' 23:59:59')));
        $warunki_szukania .= " and ap.auction_date_end <= '".$szukana_wartosc."'";
        unset($szukana_wartosc);
    }
    
    if ( isset($_GET['szukaj_opcja']) && $_GET['szukaj_opcja'] != '0' ) {
        $szukana_wartosc = (int)$_GET['szukaj_opcja'];
        $warunki_szukania .= " and ap.allegro_options LIKE '%,".$szukana_wartosc.",%'";
        unset($szukana_wartosc);
    }    
    
    // jezeli jest wybrana kategoria allegro
    if (isset($_GET['kategoria_allegro']) && (int)$_GET['kategoria_allegro'] > 0) {
        $id_kategorii = (int)$_GET['kategoria_allegro'];
        $warunki_szukania .= " and ap.allegro_category = '".$id_kategorii."'";
        unset($id_kategorii);
    }
    
    // jezeli jest wybrana kategoria sklepu
    if (isset($_GET['kategoria_id']) && (int)$_GET['kategoria_id'] > 0) {
        $id_kategorii = (int)$_GET['kategoria_id'];
        $warunki_szukania .= " and ptc.categories_id = '".$id_kategorii."'";
        unset($id_kategorii);
    }    
    
    // jezeli jest wybrane konto allegro
    if (isset($_GET['login_aukcji']) && (int)$_GET['login_aukcji'] > 0) {
        if ( (int)$_GET['login_aukcji'] == 1 ) {             
              $warunki_szukania .= " and ap.auction_seller = '".$allegro->polaczenie['CONF_LOGIN']."'";
        }
        if ( (int)$_GET['login_aukcji'] == 2 ) {             
              $warunki_szukania .= " and ap.auction_seller = '".$allegro->polaczenie['CONF_LOGIN_2']."'";
        } 
        if ( (int)$_GET['login_aukcji'] == 3 ) {             
              $warunki_szukania .= " and ap.auction_seller = '".$allegro->polaczenie['CONF_LOGIN_3']."'";
        }               
    }    

    // jezeli jest wybrana roznica magazynow
    if (isset($_GET['szukaj_stan_mag'])) {
        if ((int)$_GET['szukaj_stan_mag'] == 1) {
           $warunki_szukania .= " and ((ap.auction_quantity < p.products_quantity) || (ap.products_stock_attributes != '' and ap.auction_quantity < ps.products_stock_quantity))";
        }
        if ((int)$_GET['szukaj_stan_mag'] == 2) {
           $warunki_szukania .= " and ((ap.auction_quantity > p.products_quantity) || (ap.products_stock_attributes != '' and ap.auction_quantity > ps.products_stock_quantity))";
        }
        if ((int)$_GET['szukaj_stan_mag'] == 3) {
           $warunki_szukania .= " and ((p.products_quantity <= 0) || (ap.products_stock_attributes != '' and ps.products_stock_quantity <= 0))";
        }        
    }  

    // jezeli jest wybrana roznica cen
    if (isset($_GET['szukaj_stan_cen']) && ((int)$_GET['szukaj_stan_cen'] == 1 || (int)$_GET['szukaj_stan_cen'] == 2)) {
        //
        $tab_produktow = array();
        //
        $zapytanieTmp = "SELECT ap.allegro_id, ap.auction_id, ap.products_id, ap.products_buy_now_price, ap.products_stock_attributes, 
                                ps.products_stock_price_tax,
                                p.products_price_tax,
                                p.products_currencies_id, 
                                p.products_points_only,     
                                p.options_type
                           FROM allegro_auctions ap 
                      LEFT JOIN products p ON p.products_id = ap.products_id 
                      LEFT JOIN products_stock ps ON ps.products_id = ap.products_id AND ps.products_stock_attributes = replace(ap.products_stock_attributes,';', ',')
                       GROUP BY ap.auction_id";
                      
        $sqlTmp = $db->open_query($zapytanieTmp);              
        
        while ($info = $sqlTmp->fetch_assoc()) {
            //
            if ( $info['products_points_only'] == 0 ) {
              
                $cena_allegro = 0;
                $cena_sklep = 0;
                          
                if ( $info['products_buy_now_price'] > 0 ) {
                     $cena_allegro = (float)$waluty->FormatujCeneBezSymbolu($info['products_buy_now_price'], false, '', '', 2, $IdPLN);
                }
            
                if ( $info['options_type'] == 'ceny' && $info['products_stock_price_tax'] > 0 ) {
                     $cena_sklep = (float)$waluty->FormatujCeneBezSymbolu($info['products_stock_price_tax'], true, '', '', 2, $info['products_currencies_id']);
                  } else {
                     $cena_sklep = (float)$waluty->FormatujCeneBezSymbolu(Produkt::ProduktCenaCechy($info['products_id'], $info['products_price_tax'], str_replace(';', ',', $info['products_stock_attributes'])), true, '', '', 2, $info['products_currencies_id']);
                }
                
                // jezeli cena w sklepie wieksza od allegro
                if ( (int)$_GET['szukaj_stan_cen'] == 1 ) {
            
                    if ($cena_sklep > $cena_allegro && $cena_allegro > 0 && $cena_sklep > 0) {
                        $tab_produktow[$info['products_id']] = $info['products_id'];
                    }
                    
                }
                // jezeli cena w sklepie mniejsza od allegro
                if ( (int)$_GET['szukaj_stan_cen'] == 2 ) {
            
                    if ($cena_sklep < $cena_allegro && $cena_allegro > 0 && $cena_sklep > 0) {
                        $tab_produktow[$info['products_id']] = $info['products_id'];
                    }
                    
                }                
                            
                unset($cena_allegro, $cena_sklep);
                
            }
            //
        }

        $db->close_query($sqlTmp);
        unset($infoTmp, $zapytanieTmp);
              
        if ( count($tab_produktow) > 0 ) {
             $warunki_szukania .= " and ap.products_id in (" . implode(',', $tab_produktow) . ")";
        }
        unset($tab_produktow);
    }     

    // jezeli jest wybrana opcja braku zamowien
    if (isset($_GET['szukaj_stan_zamowien']) && (int)$_GET['szukaj_stan_zamowien'] == 1) {
        //
        $tab_aukcji = array();
        //
        $zapytanieTmp = "SELECT ap.allegro_id, ap.auction_id, ap.auction_bids, count(distinct oa.orders_id) as iloscZamowienSprzedane, count(distinct at.orders_id) as iloscZamowienTransakcje
                           FROM allegro_auctions ap 
                      LEFT JOIN allegro_auctions_sold oa ON oa.orders_id != '0' AND oa.auction_id = ap.auction_id
                      LEFT JOIN allegro_transactions at ON at.orders_id != '0' AND at.auction_id = ap.auction_id
                       GROUP BY ap.auction_id";  
   
        $sqlTmp = $db->open_query($zapytanieTmp);              
        
        while ($info = $sqlTmp->fetch_assoc()) {
            //
            if ( $info['iloscZamowienSprzedane'] + $info['iloscZamowienTransakcje'] < $info['auction_bids'] ) {
              
                $tab_aukcji[] = $info['allegro_id'];

            }
            //
        }

        $db->close_query($sqlTmp);
        unset($infoTmp, $zapytanieTmp);
              
        if ( count($tab_aukcji) > 0 ) {
             $warunki_szukania .= " and ap.allegro_id in (" . implode(',', $tab_aukcji) . ")";
        }
        unset($tab_aukcji);
    }    
    
    if ( $warunki_szukania != '' ) {
      $warunki_szukania = preg_replace('/and/i', 'WHERE', $warunki_szukania, 1);
    }

    /*
    $zapytanie = "SELECT ap.*, p.products_image, p.products_model, p.products_quantity AS iloscMagazyn, count(distinct oa.orders_id) as iloscZamowienSprzedane, count(distinct at.orders_id) as iloscZamowienTransakcje, p.products_control_storage, p.products_jm_id, p.products_status, pj.products_jm_quantity_type, m.manufacturers_name 
                  FROM allegro_auctions ap 
                  LEFT JOIN products p ON p.products_id = ap.products_id 
                  LEFT JOIN products_to_categories ptc ON p.products_id = ptc.products_id 
                  LEFT JOIN manufacturers m ON p.manufacturers_id = m.manufacturers_id
                  LEFT JOIN products_jm pj ON p.products_jm_id = pj.products_jm_id
                  LEFT JOIN allegro_auctions_sold oa ON oa.orders_id != '0' AND oa.auction_id = ap.auction_id
                  LEFT JOIN allegro_transactions at ON at.orders_id != '0' AND at.auction_id = ap.auction_id
                  " . $warunki_szukania . ' GROUP BY ap.auction_id';
    */
    
    $zapytanie = "SELECT ap.*, 
                         ps.products_stock_quantity as iloscMagazynCech, 
                         ps.products_stock_price_tax,
                         p.products_image as zdjecieOryginal, 
                         p.products_model, 
                         p.products_quantity AS iloscMagazyn, 
                         p.products_price_tax,
                         p.products_old_price, 
                         p.products_currencies_id, 
                         p.products_points_only,     
                         p.options_type,
                         count(distinct oa.orders_id) as iloscZamowienSprzedane, 
                         count(distinct at.orders_id) as iloscZamowienTransakcje, 
                         p.products_control_storage, 
                         p.products_jm_id, 
                         p.products_status, 
                         pj.products_jm_quantity_type, 
                         m.manufacturers_name 
                   FROM allegro_auctions ap 
              LEFT JOIN products p ON p.products_id = ap.products_id 
              LEFT JOIN products_to_categories ptc ON p.products_id = ptc.products_id 
              LEFT JOIN manufacturers m ON p.manufacturers_id = m.manufacturers_id
              LEFT JOIN products_jm pj ON p.products_jm_id = pj.products_jm_id
              LEFT JOIN allegro_auctions_sold oa ON oa.orders_id != '0' AND oa.auction_id = ap.auction_id
              LEFT JOIN allegro_transactions at ON at.orders_id != '0' AND at.auction_id = ap.auction_id
              LEFT JOIN products_stock ps ON ps.products_id = ap.products_id AND ps.products_stock_attributes = replace(ap.products_stock_attributes,';', ',')
              " . $warunki_szukania . ' GROUP BY ap.auction_id';                 

    $sql = $db->open_query($zapytanie);

    // tworzenie paska do nastepnych okien - obliczanie ile bedzie podstron
    $ile_pozycji = (int)$db->ile_rekordow($sql); // ile jest wszystkich produktow
    $ile_licznika = ($ile_pozycji / ILOSC_WYNIKOW_NA_STRONIE);
    if ($ile_licznika == (int)$ile_licznika) { $ile_licznika = (int)$ile_licznika; } else { $ile_licznika = (int)$ile_licznika+1; }
    $db->close_query($sql);
    
    // jezeli jest sortowanie
    if (isset($_GET['sort'])) {
        switch ($_GET['sort']) {
            case "sort_a1":
                $sortowanie = 'ap.synchronization desc, ap.products_date_end DESC';
                break;
            case "sort_a2":
                $sortowanie = 'ap.synchronization desc, ap.products_date_end ASC';
                break;                 
            case "sort_a3":
                $sortowanie = 'ap.auction_id desc';
                break;
            case "sort_a4":
                $sortowanie = 'ap.auction_id asc';
                break;     
            case "sort_a5":
                $sortowanie = 'ap.auction_hits desc';
                break;
            case "sort_a6":
                $sortowanie = 'ap.auction_hits asc';
                break; 
            case "sort_a7":
                $sortowanie = 'ap.products_sold desc';
                break;
            case "sort_a8":
                $sortowanie = 'ap.products_sold asc';
                break;                   
        }            
    } else { $sortowanie = 'ap.synchronization desc, ap.products_date_end DESC'; }    

    // informacje o produktach - zakres
    $zapytanie .= " ORDER BY ".$sortowanie;    

    // ******************************************************************************************************************************************************************
    // obsluga listingu AJAX
    if (isset($_GET['parametr'])) {

        if ($ile_pozycji > 0) {
            
            $zapytanie .= " limit ".$_GET['parametr'];  

            $sql = $db->open_query($zapytanie);

            $listing_danych = new Listing();
            
            $tablica_naglowek = array(array('Akcja','center'),
                                      array('ID aukcji','center'),
                                      array('Foto','center', '', 'class="ListingSchowaj"'),
                                      array('Nazwa produktu' ),
                                      array('Format','center'),
                                      array('Data rozpoczęcia','center', '', 'class="ListingSchowaj"'),
                                      array('Data zakończenia','center', '', 'class="ListingSchowaj"'),
                                      array('Ilość wystawiona / magazyn / cena','center'),
                                      array('Status produktu','center', '', 'class="ListingSchowaj"'),
                                      array('Ofert','center'),
                                      array('Zamówienia','center'),
                                      array('Sprzedaż','center'),
                                      array('Wyświetleń','center', '', 'class="ListingSchowaj"'),
                                      array('Warianty','center', '', 'class="ListingRwdSzeroki"'),
                                      array('Status','center'));
                                      
            echo $listing_danych->naglowek($tablica_naglowek);
            
            $tekst = '';

            while ($info = $sql->fetch_assoc()) {
          
                $ilosc_magazyn = $info['iloscMagazyn'];

                if (isset($_GET['id_poz']) && (int)$_GET['id_poz'] == $info['allegro_id']) {
                   $tekst .= '<tr class="pozycja_on" id="sk_'.$info['allegro_id'].'">';
                 } else {
                   $tekst .= '<tr class="pozycja_off" id="sk_'.$info['allegro_id'].'">';
                }      

                $link = '';
                if ( Allegro::SerwerAllegro() == 'nie' ) {
                  $link = 'http://allegro.pl/item' .  $info['auction_id'] . '_webapi.html';
                } else {
                  $link = 'http://allegro.pl.webapisandbox.pl/show_item.php?item='.$info['auction_id'];
                }

                $nazwa_produktu = '<b><a href="produkty/produkty_edytuj.php?id_poz='.$info['products_id'].'">'.$info['products_name'].'</a></b>';
                if (trim($info['products_model']) != '') {
                  $nazwa_produktu .= '<span class="MaleInfoKat">Nr kat: <b>'.$info['products_model'].'</b></span>';
                }
                // pobieranie danych o producencie
                if (trim($info['manufacturers_name']) != '') {                     
                  $nazwa_produktu .= '<span class="MaleProducent">Producent: <b>'.$info['manufacturers_name'].'</b></span>';
                }                  

                $wyswietl_cechy = '';

                if ( isset($info['products_stock_attributes']) && $info['products_stock_attributes'] != '' ) {

                  $tablica_kombinacji_cech = explode(';', $info['products_stock_attributes']);
                  
                  for ( $t = 0, $c = count($tablica_kombinacji_cech); $t < $c; $t++ ) {
                  
                    $tablica_wartosc_cechy = explode('-', $tablica_kombinacji_cech[$t]);

                    $nazwa_cechy = Funkcje::NazwaCechy( (int)$tablica_wartosc_cechy['0'] );
                    $nazwa_wartosci_cechy = Funkcje::WartoscCechy( (int)$tablica_wartosc_cechy['1'] );

                    $wyswietl_cechy .= '<span class="MaleInfoCecha">'.$nazwa_cechy . ': <b>' . $nazwa_wartosci_cechy . '</b></span>';
                    
                    unset($tablica_wartosc_cechy);
                    
                  }
                  
                  unset($tablica_kombinacji_cech);
                  
                  // jezeli jest powiazanie cech z magazynem
                  if ( CECHY_MAGAZYN == 'tak' ) {

                      /*
                      $cechy_produktu = str_replace(';', ',' , $info['products_stock_attributes']);
                      
                      $zapytanie_ilosc_cechy = "SELECT products_stock_quantity 
                                                  FROM products_stock
                                                 WHERE products_id = '" . (int)$info['products_id']. "' 
                                                   AND products_stock_attributes = '".$cechy_produktu."'";
                                                   
                      $sql_ilosc_cechy = $db->open_query($zapytanie_ilosc_cechy);

                      if ((int)$db->ile_rekordow($sql_ilosc_cechy) > 0) {
                      
                          $info_ilosc_cechy = $sql_ilosc_cechy->fetch_assoc();
                          $ilosc_magazyn = $info_ilosc_cechy['products_stock_quantity'];
                          
                      }
                      
                      $db->close_query($sql_ilosc_cechy);
                      
                      unset($zapytanie_ilosc_cechy, $info_ilosc_cechy, $cechy_produktu);
                      */
                      
                      if ( $info['products_stock_attributes'] != '' ) {
                        
                           $ilosc_magazyn = (float)$info['iloscMagazynCech'];
                           
                      }
                      
                  }

                }
                
                if (!empty($wyswietl_cechy)) {                     
                  $nazwa_produktu .= $wyswietl_cechy;
                }
                
                if ( $info['auction_status'] == '1' ) {
                  $status_img = '<em class="TipChmurka"><b>Aukcja trwa</b><img src="obrazki/allegro_trwa.png" alt="Aukcja trwa" /></em>';
                } elseif ( $info['auction_status'] == '2' ) {
                  $status_img = '<em class="TipChmurka"><b>Aukcja zakończona</b><img src="obrazki/allegro_zakonczona.png" alt="Aukcja zakończona" /></em>';
                } elseif ( $info['auction_status'] == '-1' ) {
                  $status_img = '<em class="TipChmurka"><b>Aukcja czeka na wystawienie</b><img src="obrazki/allegro_czeka.png" alt="Aukcja czeka na wystawienie" /></em>';
                } elseif ( $info['auction_status'] == '3' ) {
                  $status_img = '<em class="TipChmurka"><b>Aukcja zakończona przed czasem</b><img src="obrazki/allegro_zakonczona.png" alt="Aukcja zakończona przed czasem" /></em>';
                }

                if ( $info['archiwum_allegro'] == '1' ) {
                  $status_img = '<em class="TipChmurka"><b>Aukcja przeniesiona do archiwum Allegro</b><img src="obrazki/allegro_archiwum.png" alt="Aukcja przeniesiona do archiwum Allegro" /></em>';
                  $status_img .= '<br /><a class="TipChmurka" href="allegro/allegro_akcja_status.php?id_poz='.$info['allegro_id'].'"><b>Zmień status na AUKCJA TRWA</b><img src="obrazki/kasuj_male.png" alt="Zmień status" /></a>';
                }
                
                if ( $info['auction_buy_now'] == '1' ) {
                  $format_img = '<em class="TipChmurka"><b>Aukcja Kup teraz</b><img src="obrazki/allegro_kup_teraz.png" alt="Aukcja Kup teraz" /></em>';
                } elseif ( $info['auction_buy_now'] == '0' ) {
                  $format_img = '<em class="TipChmurka"><b>Aukcja z Licytacją</b><img src="obrazki/allegro_licytacja.png" alt="Aukcja z Licytacją" /></em>';
                }
                if ( $info['auction_type'] == '1' ) {
                  $format_img = '<em class="TipChmurka"><b>Aukcja - Sklep</b><img src="obrazki/allegro_sklep.png" alt="Aukcja - Sklep" /></em>';
                }
                
                if ( $info['variants'] == '1' ) {
                  $warianty_img = '<em class="TipChmurka"><b>Aukcja - wielowariantowa</b><img src="obrazki/allegro_warianty.png" alt="Aukcja - wielowariantowa" /></em>';
                } else {
                  $warianty_img = '-';
                }

                if ( $info['synchronization'] != '1' ) {
                  $akcja = '<input type="checkbox" style="border:0px" name="opcja[]" value="'.$info['allegro_id'].'" id="opcja_'.$info['allegro_id'].'" /><label class="OpisForPustyLabel" for="opcja_'.$info['allegro_id'].'"></label><input type="hidden" name="id[]" value="'.$info['allegro_id'].'" />';
                } else {
                  $akcja = '<input type="checkbox" style="border:0px" name="opcja[]" value="'.$info['allegro_id'].'" disabled="disabled" id="opcja_'.$info['allegro_id'].'" /><label class="OpisForPustyLabel" for="opcja_'.$info['allegro_id'].'"></label><input type="hidden" name="id[]" value="'.$info['allegro_id'].'" />';
                }
                
                // nr aukcji rzeczywisty
                $nr_aukcji = $info['auction_id'];
                if ( $info['auction_id'] < (time() + 100 *86400) ) {
                     $nr_aukcji = '';
                }
                
                // jezeli jednostka miary calkowita
                if ( $info['products_jm_quantity_type'] == 1 ) {
                     $ilosc_magazyn = (int)$ilosc_magazyn;
                }           

                if ( !empty($info['zdjecieOryginal']) || !empty($info['products_image']) ) {
                     //
                     $tgm = '<div id="zoom'.rand(1,99999).'" class="imgzoom" onmouseover="ZoomIn(this,event)" onmouseout="ZoomOut(this)">';
                     //
                     if ( $info['products_image'] != '' ) {
                          //
                          $tgm .= '<div class="zoom">' . Funkcje::pokazObrazek($info['products_image'], $info['products_name'], '250', '250') . '</div>';
                          $tgm .= Funkcje::pokazObrazek($info['products_image'], $info['products_name'], '40', '40', ' class="Reload"', true); 
                          //
                     } else {                          
                          //
                          $tgm .= '<div class="zoom">' . Funkcje::pokazObrazek($info['zdjecieOryginal'], $info['products_name'], '250', '250') . '</div>';
                          $tgm .= Funkcje::pokazObrazek($info['zdjecieOryginal'], $info['products_name'], '40', '40', ' class="Reload"', true); 
                          //
                     }
                     //
                     $tgm .= '</div>';
                     //
                   } else { 
                     //
                     $tgm = '-';
                     //
                }              
                
                // sprawdzanie czy ilosc w magazynie nie jest mniejsza niz na allegro
                $magazyn_cena = $info['auction_quantity'] . ' / ' . $ilosc_magazyn;
                if ( MAGAZYN_SPRAWDZ_STANY == 'tak' && $info['auction_quantity'] > $ilosc_magazyn && $info['products_control_storage'] == 1 ) {
                    $magazyn_cena = '<em class="TipChmurka"><b>Ilość produktów na Allegro jest większa niż stan magazynowy w sklepie</b><span class="MagazynBlad">' . $magazyn_cena . '</span></em>';
                }
                
                $cena_txt_allegro = '';
                $cena_txt_sklep = '';
                $cena_allegro = 0;
                $cena_sklep = 0;

                if ( $info['products_buy_now_price'] > 0 ) {
                     $cena_txt_allegro .= '<div class="CenaAllegro">' . $waluty->FormatujCene($info['products_buy_now_price'], false, $IdPLN) . '</div>';
                     $cena_allegro = (float)$waluty->FormatujCeneBezSymbolu($info['products_buy_now_price'], false, '', '', 2, $IdPLN);
                }
                
                if ( $info['products_points_only'] == 0 ) {
                     //
                     if ( $info['options_type'] == 'ceny' && $info['products_stock_price_tax'] > 0 ) {
                          $cena_txt_sklep = '<div class="CenaSklep">'.$waluty->FormatujCene($info['products_stock_price_tax'], true, $IdPLN, '', 2, $info['products_currencies_id']).'</div>';                                        
                          $cena_sklep = (float)$waluty->FormatujCeneBezSymbolu($info['products_stock_price_tax'], true, '', '', 2, $info['products_currencies_id']);
                       } else {
                          $cena_txt_sklep = '<div class="CenaSklep">'.$waluty->FormatujCene(Produkt::ProduktCenaCechy($info['products_id'], $info['products_price_tax'], str_replace(';', ',', $info['products_stock_attributes'])), true, $IdPLN, '', 2, $info['products_currencies_id']).'</div>';              
                          $cena_sklep = (float)$waluty->FormatujCeneBezSymbolu(Produkt::ProduktCenaCechy($info['products_id'], $info['products_price_tax'], str_replace(';', ',', $info['products_stock_attributes'])), true, '', '', 2, $info['products_currencies_id']);
                     }
                     //
                }
                
                if ($cena_sklep > $cena_allegro && $cena_allegro > 0 && $cena_sklep > 0) {
                    $cena_txt_sklep = '<div class="RoznicaCenSklep TipChmurka"><b>Cena produktu w sklepie jest wyższa niż na Allegro</b>' . $cena_txt_sklep . '</div>';
                }
                                
                $magazyn_cena = $magazyn_cena . (($cena_txt_allegro != '' || $cena_txt_sklep != '') ? '<br /><div class="CenyProdukty">' . $cena_txt_allegro . $cena_txt_sklep . '</div>' : '');

                unset($cena_txt_allegro, $cena_txt_sklep, $cena_allegro, $cena_sklep);
                
                $data_zakonczenia_allegro = '-';
                if ( !empty($info['auction_date_end']) && strtotime($info['auction_date_end']) > 0 ) {
                    $data_zakonczenia_allegro = date('d-m-Y H:i:s',strtotime($info['auction_date_end']));
                    //
                    // za ile dni
                    $zaIleDni = (strtotime($info['auction_date_end']) - time()) / 86400;
                    if ( $zaIleDni > 0 && $info['auction_status'] != '2' && $info['auction_status'] != '3' ) {
                         if ( $zaIleDni < 1 ) {
                              if ( date('G',(strtotime($info['auction_date_end']) - time())) > 1 ) {
                                   $zaIleGodzin = date('G',(strtotime($info['auction_date_end']) - time())) . ' godz ' . date('i',(strtotime($info['auction_date_end']) - time())) . ' min';
                                } else {
                                   $zaIleGodzin = date('i',(strtotime($info['auction_date_end']) - time())) . ' min';
                              }
                              $data_zakonczenia_allegro .= '<div class="KoniecAukcjiNiedlugo">koniec za: <b>' . $zaIleGodzin . '</b></div>';
                              unset($zaIleGodzin);
                         } else {
                             $zaIleDni = ceil($zaIleDni);
                             if ( $zaIleDni < 4 ) {
                                  $data_zakonczenia_allegro .= '<div class="KoniecAukcjiNiedlugo">koniec za: <b>' . $zaIleDni . ((($zaIleDni) == 1) ? ' dzień' : ' dni') . '</b></div>';
                              } else {
                                  $data_zakonczenia_allegro .= '<div class="KoniecAukcji">koniec za: <b>' . $zaIleDni . ((($zaIleDni) == 1) ? ' dzień' : ' dni') . '</b></div>';
                             }
                         }
                    } else {
                         $data_zakonczenia_allegro .= '<div class="KoniecAukcjiZakonczona">zakończona</div>';
                    }
                    //
                } else {
                    $data_zakonczenia_allegro = 'do wyczerpania';
                }

                if ( $info['products_status'] == '1' ) {
                  $status_prd = '<em class="TipChmurka"><b>Produkt w sklepie jest aktywny</b><img src="obrazki/aktywny_on.png" alt="Produkt w sklepie jest aktywny" /></em>';
                } elseif ( $info['products_status'] == '0' ) {
                  $status_prd = '<em class="TipChmurka"><b>Produkt w sklepie jest nieaktywny</b><img src="obrazki/aktywny_off.png" alt="Produkt w sklepie jest nieaktywny" /></em>';
                }

                // opcje aukcji
                $tablica_opcji = explode(',', $info['allegro_options']);
                
                if ( count($tablica_opcji) > 0 ) {
                  
                    $opcje = '<div class="Opcje">';
                    foreach ( $tablica_opcji as $opcja ) {
                        if ( (int)$opcja > 0 ) {
                              $opcje .= '<div class="Opcja_' . $opcja . ' OpcjaTlo">';
                              switch ((int)$opcja) {
                                  case 1:
                                      $opcje .= 'P';
                                      break;
                                  case 2:
                                      $opcje .= 'M';
                                      break;                 
                                  case 4:
                                      $opcje .= 'Ś';
                                      break;
                                  case 8:
                                      $opcje .= 'W';
                                      break;
                                  case 16:
                                      $opcje .= 'D';
                                      break;
                                  case 32:
                                      $opcje .= 'I';
                                      break;                                  
                              }                            
                              $opcje .= '</div>';
                        }
                    }
                    $opcje .= '</div>';
                    
                }
                unset($tablica_opcji);

                $tablica = array(array($akcja,'center'),
                                 array((($info['synchronization'] == 1) ? '<em class="TipChmurka"><b>Nie zostały pobrane dane aukcji z Allegro</b><span class="brakSynch"></span></em><br />' : '') . (($nr_aukcji != '') ? '<a href="'.$link.'">'.$info['auction_id'].'</a>' : '') . $opcje . (($info['auction_seller'] != '') ? '<div class="LoginKonta">' . Funkcje::przytnijTekst($info['auction_seller'],10) . '</div>' : ''),'center'),
                                 array($tgm, 'center', '', 'class="ListingSchowaj"'),
                                 array($nazwa_produktu,'left'),
                                 array( $format_img,'center'),
                                 array(((!empty($info['auction_date_start'])) ? date('d-m-Y H:i:s',strtotime($info['auction_date_start'])) : '-'),'center', '', 'class="ListingSchowaj"'),
                                 array($data_zakonczenia_allegro,'center', '', 'class="ListingSchowaj"'),
                                 array($magazyn_cena,'center'),
                                 array($status_prd,'center', '', 'class="ListingSchowaj"'),
                                 array($info['auction_bids'],'center'),
                                 array(($info['iloscZamowienSprzedane'] + $info['iloscZamowienTransakcje'] < $info['auction_bids'] ? '<span class="MagazynBlad TipChmurka"><b>Dla sprzedaży produktu nie zostało utworzone zamówienie</b>' . ($info['iloscZamowienSprzedane'] + $info['iloscZamowienTransakcje']) . '</span> <br /><br /> <a class="TipChmurka" href="allegro/allegro_sprzedaz.php?filtr=' . $info['auction_id'] . '"><b>Przejdź do sprzedaży allegro</b><img src="obrazki/import.png" alt="Przejdź" /></a>' : ($info['iloscZamowienSprzedane'] + $info['iloscZamowienTransakcje'])),'center'),
                                 array($info['products_sold'],'center'),
                                 array($info['auction_hits'],'center', '', 'class="ListingSchowaj"'),
                                 array($warianty_img,'center', '', 'class="ListingRwdSzeroki"'),
                                 array($status_img,'center'));
                                 
                unset($nr_aukcji, $tgm, $magazyn_cena, $opcje);
                
                $tekst .= $listing_danych->pozycje($tablica);
                
                $tekst .= '<td class="rg_right IkonyPionowo">';
                
                $zmienne_do_przekazania = '?id_poz='.$info['allegro_id'];

                $tekst .= '<a class="TipChmurka" href="allegro/allegro_aukcja_szczegoly.php'.$zmienne_do_przekazania.'"><b>Szczegóły aukcji</b><img src="obrazki/zobacz.png" alt="Szczegóły aukcji" /></a>';
                
                if ($info['synchronization'] == 0 && ((isset($_SESSION['allegro_user_login']) && $_SESSION['allegro_user_login'] == $info['auction_seller']) || empty($info['auction_seller']))) {

                    if ( $info['archiwum_allegro'] == '0' ) {
                      $tekst .= '<a class="TipChmurka" href="allegro/allegro_duplikuj_aukcje.php'.$zmienne_do_przekazania.'"><b>Wystaw kolejną aukcję tego przedmiotu</b><img src="obrazki/allegro_lapka.png" alt="Wystaw kolejną aukcję tego przedmiotu" /></a>';                      
                      
                      // usuniecie tylko dla zakonczonych
                      if ( $info['auction_status'] == '2' || $info['auction_status'] == '3' ) {
                           $tekst .= '<a class="TipChmurka" href="allegro/allegro_duplikuj_aukcje.php'.$zmienne_do_przekazania.'&usun=tak"><b>Wystaw kolejną aukcję tego przedmiotu i usuń starą z bazy danych</b><img src="obrazki/allegro_lapka_usun.png" alt="Wystaw kolejną aukcję tego przedmiotu i usuń starą z bazy danych" /></a>';
                      }
                      
                    } else {
                      $tekst .= '<em class="TipChmurka"><b>Aukcja jest przeniesiona do archiwum Allegro</b><img src="obrazki/allegro_lapka_off.png" alt="Aukcja jest przeniesiona do archiwum Allegro" /></em>';
                    }

                    if ( $info['auction_status'] == '1' ) {
                      $tekst .= '<a class="TipChmurka" href="allegro/allegro_aukcja_zakoncz.php'.$zmienne_do_przekazania.'"><b>Zakończ aukcje na Allegro</b><img src="obrazki/wyloguj.png" alt="Zakończ aukcje na Allegro" /></a>';
                    } else {
                      $tekst .= '<em class="TipChmurka"><b>Aukcja zakończona</b><img src="obrazki/wyloguj_off.png" alt="Aukcja zakończona" /></em>';
                    }
                    
                    $tekst .= '<br /><br />';
                    
                    $dodaj_br = false;

                    if ( $info['variants'] == '0' ) {
                      $tekst .= '<a class="TipChmurka" href="allegro/allegro_aukcja_zaktualizuj_ilosc.php'.$zmienne_do_przekazania.'&ilosc='.$ilosc_magazyn.'"><b>Zaktualizuj ilość przedmiotów na aukcji</b><img src="obrazki/powrot.png" alt="Zaktualizuj ilość przedmiotów na aukcji" /></a>';
                    }

                    if ( $info['auction_status'] == '1' && $info['auction_buy_now'] == '1' ) {
                      $tekst .= '<a class="TipChmurka" href="allegro/allegro_aukcja_zaktualizuj_parametry.php'.$zmienne_do_przekazania.'"><b>Zaktualizuj parametry aukcji</b><img src="obrazki/edytuj.png" alt="Zaktualizuj parametry aukcji" /></a>';
                      $dodaj_br = true;
                    }                       
                    
                    if ( $info['auction_status'] == '1' && $info['auction_buy_now'] == '1' ) {
                      $tekst .= '<a class="TipChmurka" href="allegro/allegro_aukcja_zaktualizuj_parametry.php'.$zmienne_do_przekazania.'&zdjecie"><b>Zaktualizuj zdjecie aukcji</b><img src="obrazki/zdjecie.png" alt="Zaktualizuj zdjęcie aukcji" /></a>';
                      $tekst .= '<a class="TipChmurka" href="allegro/allegro_aukcja_zaktualizuj_parametry.php'.$zmienne_do_przekazania.'&cena"><b>Zaktualizuj cenę na aukcji</b><img src="obrazki/cena.png" alt="Zaktualizuj cenę na aukcji" /></a>';
                      $dodaj_br = true;
                    }                        
                    
                }
                
                if ( $dodaj_br == true ) {
                     $tekst .= '<br /><br />';
                }

                if ( $info['archiwum_allegro'] == '1' || $info['auction_bids'] == '0' ) {
                    $tekst .= '<a class="TipChmurka" href="allegro/allegro_aukcja_usun.php'.$zmienne_do_przekazania.'"><b>Usuń aukcję z bazy danych</b><img src="obrazki/kasuj.png" alt="Usuń aukcję z bazy danych" /></a>';
                }
                $tekst .= '<a class="TipChmurka" href="allegro/allegro_sprzedaz_tranzakcja.php?aukcja_id='.$info['allegro_id'].'"><b>Lista ofert</b><img src="obrazki/historia.png" alt="Lista ofert" /></a>';
                $tekst .= '</td></tr>';
                
            } 
            $tekst .= '</table>';
            //
            echo $tekst;
            //
            $db->close_query($sql);
            unset($listing_danych,$tekst,$tablica,$tablica_naglowek);        

        }
    }  
    
    // ******************************************************************************************************************************************************************
    // wyswietlanie listingu
    if (!isset($_GET['parametr'])) { 

        // wczytanie naglowka HTML
        include('naglowek.inc.php');
        ?>

        <script>
        $(document).ready(function() {
          $('input.datepicker').Zebra_DatePicker({
            format: 'd-m-Y',
            inside: false,
            readonly_element: false
          });                
        });
        </script>

        <div id="caly_listing">
        
            <div id="ajax"></div>

            <div id="naglowek_cont">Obsługa aukcji - data ostatniej synchronizacji : <?php echo date("d-m-Y H:i:s", $allegro->polaczenie['CONF_LAST_SYNCHRONIZATION']); ?></div> 
            
            <div class="cl"></div>

            <div id="wyszukaj">
                <form action="allegro/allegro_aukcje.php" method="post" id="allegroForm" class="cmxform">

                    <div id="wyszukaj_text">
                        <span>Wyszukaj aukcje:</span>
                        <input type="text" name="szukaj" id="szukaj" value="<?php echo ((isset($_GET['szukaj'])) ? $filtr->process($_GET['szukaj']) : ''); ?>" size="40" />
                    </div>  
                    
                    <div class="wyszukaj_select">
                        <span>Nr kat produktu:</span>
                        <input type="text" name="nrkat" value="<?php echo ((isset($_GET['nrkat'])) ? Funkcje::formatujTekstInput($filtr->process($_GET['nrkat'])) : ''); ?>" size="20" />
                    </div>                           
                    
                    <div class="wyszukaj_select">
                        <span>Status:</span>
                        <?php
                        $tablica_status = Array();
                        $tablica_status[] = array('id' => '0', 'text' => '-- dowolny --');
                        $tablica_status[] = array('id' => '1', 'text' => 'trwająca');
                        $tablica_status[] = array('id' => '2', 'text' => 'zakończona');
                        $tablica_status[] = array('id' => '3', 'text' => 'zakończona przed czasem');
                        echo Funkcje::RozwijaneMenu('szukaj_status', $tablica_status, ((isset($_GET['szukaj_status'])) ? $filtr->process($_GET['szukaj_status']) : '')); 
                        unset($tablica_status);
                        ?>
                    </div>  

                    <div class="wyszukaj_select">
                        <span>Status produktu:</span>
                        <?php   
                        $tablica_status_produktu = array();
                        $tablica_status_produktu[] = array('id' => '0', 'text' => '-- dowolny --');
                        $tablica_status_produktu[] = array('id' => '1', 'text' => 'aktywne');
                        $tablica_status_produktu[] = array('id' => '2', 'text' => 'nieaktywne');                        
                        echo Funkcje::RozwijaneMenu('szukaj_status_produktu', $tablica_status_produktu, ((isset($_GET['szukaj_status_produktu'])) ? $filtr->process($_GET['szukaj_status_produktu']) : '')); 
                        unset($tablica_status_produktu)
                        ?>
                    </div>                 

                    <div class="wyszukaj_select">
                        <span>Format:</span>
                        <?php
                        $tablica_zrodlo = Array();
                        $tablica_zrodlo[] = array('id' => '0', 'text' => '-- dowolny --');
                        $tablica_zrodlo[] = array('id' => '1', 'text' => 'kup teraz');
                        $tablica_zrodlo[] = array('id' => '2', 'text' => 'licytacja');
                        echo Funkcje::RozwijaneMenu('szukaj_format', $tablica_zrodlo, ((isset($_GET['szukaj_format'])) ? $filtr->process($_GET['szukaj_format']) : '')); 
                        unset($tablica_zrodlo);
                        ?>
                    </div>  

                    <div class="wyszukaj_select">
                        <span>Data końca:</span>
                        <input type="text" id="data_zakonczenia_od" name="szukaj_data_zakonczenia_od" value="<?php echo ((isset($_GET['szukaj_data_zakonczenia_od'])) ? $filtr->process($_GET['szukaj_data_zakonczenia_od']) : ''); ?>" size="10" class="datepicker" />&nbsp;do&nbsp;
                        <input type="text" id="data_zakonczenia_do" name="szukaj_data_zakonczenia_do" value="<?php echo ((isset($_GET['szukaj_data_zakonczenia_do'])) ? $filtr->process($_GET['szukaj_data_zakonczenia_do']) : ''); ?>" size="10" class="datepicker" />
                    </div>  

                    <div class="wyszukaj_select">
                        <span>Archiwum Allegro:</span>
                        <?php      
                        $tablica_archiwum_allegro = array();
                        $tablica_archiwum_allegro[] = array('id' => '0', 'text' => '-- dowolny --');
                        $tablica_archiwum_allegro[] = array('id' => '1', 'text' => 'tak');
                        $tablica_archiwum_allegro[] = array('id' => '2', 'text' => 'nie');                        
                        echo Funkcje::RozwijaneMenu('szukaj_archiwum_allegro', $tablica_archiwum_allegro, ((isset($_GET['szukaj_archiwum_allegro'])) ? $filtr->process($_GET['szukaj_archiwum_allegro']) : '')); 
                        unset($tablica_archiwum_allegro);
                        ?>
                    </div>      

                    <div class="wyszukaj_select">
                        <span>Opcja dodatkowa:</span>
                        <?php
                        $tablica_opcja = Array();
                        $tablica_opcja[] = array('id' => '0', 'text' => '-- dowolna --');
                        $tablica_opcja[] = array('id' => '1', 'text' => 'pogrubienie');
                        $tablica_opcja[] = array('id' => '2', 'text' => 'miniaturka');
                        $tablica_opcja[] = array('id' => '4', 'text' => 'podświetlenie');
                        $tablica_opcja[] = array('id' => '8', 'text' => 'wyróżnienie');
                        $tablica_opcja[] = array('id' => '32', 'text' => 'strona działu');
                        $tablica_opcja[] = array('id' => '64', 'text' => 'znak wodny');
                        echo Funkcje::RozwijaneMenu('szukaj_opcja', $tablica_opcja, ((isset($_GET['szukaj_opcja'])) ? $filtr->process($_GET['szukaj_opcja']) : '')); 
                        unset($tablica_opcja);
                        ?>
                    </div> 
                    
                    <?php if ( $allegro->polaczenie['CONF_USER_2_STATUS'] == 'tak' || $allegro->polaczenie['CONF_USER_3_STATUS'] == 'tak' ) { ?>
                    
                    <div class="wyszukaj_select">
                        <span>Konto:</span>
                        <?php
                        $tablica_opcja = Array();
                        $tablica_opcja[] = array('id' => '0', 'text' => '-- dowolne --');
                        $tablica_opcja[] = array('id' => '1', 'text' => $allegro->polaczenie['CONF_LOGIN']);
                        if ( $allegro->polaczenie['CONF_USER_2_STATUS'] == 'tak' ) {
                             $tablica_opcja[] = array('id' => '2', 'text' => $allegro->polaczenie['CONF_LOGIN_2']);
                        }
                        if ( $allegro->polaczenie['CONF_USER_3_STATUS'] == 'tak' ) {
                             $tablica_opcja[] = array('id' => '3', 'text' => $allegro->polaczenie['CONF_LOGIN_3']);
                        }                        
                        echo Funkcje::RozwijaneMenu('login_aukcji', $tablica_opcja, ((isset($_GET['login_aukcji'])) ? $filtr->process($_GET['login_aukcji']) : '')); 
                        unset($tablica_opcja);
                        ?>
                    </div>                     
                    
                    <?php } ?>

                    <div class="wyszukaj_select">
                        <span style="color:#ff0000">Aukcje z różnicą magazynów:</span>
                        <?php      
                        $tablica_stan_mag = array();
                        $tablica_stan_mag[] = array('id' => '0', 'text' => '-- wszystkie --');
                        $tablica_stan_mag[] = array('id' => '1', 'text' => 'ilość na aukcji mniejsza od stanu w sklepie');                      
                        $tablica_stan_mag[] = array('id' => '2', 'text' => 'ilość na aukcji większa od stanu w sklepie');                      
                        $tablica_stan_mag[] = array('id' => '3', 'text' => 'stan magazynowy produktów w sklepie równy lub mniejszy od 0'); 
                        echo Funkcje::RozwijaneMenu('szukaj_stan_mag', $tablica_stan_mag, ((isset($_GET['szukaj_stan_mag'])) ? $filtr->process($_GET['szukaj_stan_mag']) : ''), ' style="width:180px"'); 
                        unset($tablica_stan_mag);
                        ?>
                    </div>  

                    <div class="wyszukaj_select">
                        <span style="color:#ff0000">Aukcje z różnicą cen:</span>
                        <?php      
                        $tablica_stan_cen = array();
                        $tablica_stan_cen[] = array('id' => '0', 'text' => '-- wszystkie --');
                        $tablica_stan_cen[] = array('id' => '1', 'text' => 'cena w sklepie większa niż na aukcji');                      
                        $tablica_stan_cen[] = array('id' => '2', 'text' => 'cena w sklepie mniejsza niż na aukcji');
                        echo Funkcje::RozwijaneMenu('szukaj_stan_cen', $tablica_stan_cen, ((isset($_GET['szukaj_stan_cen'])) ? $filtr->process($_GET['szukaj_stan_cen']) : ''), ' style="width:180px"'); 
                        unset($tablica_stan_cen);
                        ?>
                    </div>   

                    <div class="wyszukaj_select">
                        <span style="color:#ff0000">Sprzedaż bez zamówień:</span>
                        <?php      
                        $tablica_stan_zamowien = array();
                        $tablica_stan_zamowien[] = array('id' => '0', 'text' => '-- wszystkie --');
                        $tablica_stan_zamowien[] = array('id' => '1', 'text' => 'aukcje ze sprzedażą bez utworzonych zamówień');                      
                        echo Funkcje::RozwijaneMenu('szukaj_stan_zamowien', $tablica_stan_zamowien, ((isset($_GET['szukaj_stan_zamowien'])) ? $filtr->process($_GET['szukaj_stan_zamowien']) : ''), ' style="width:180px"'); 
                        unset($tablica_stan_zamowien);
                        ?>
                    </div>                      
                    
                    <?php                       
                    // tworzy ukryte pola hidden do wyszukiwania - filtra 
                    if (isset($_GET['kategoria_allegro'])) { 
                        echo '<div><input type="hidden" name="kategoria_allegro" value="'.(int)$_GET['kategoria_allegro'].'" /></div>';
                    } 
                    if (isset($_GET['kategoria_id'])) { 
                        echo '<div><input type="hidden" name="kategoria_id" value="'.(int)$_GET['kategoria_id'].'" /></div>';
                    }                         
                    if (isset($_GET['sort'])) { 
                        echo '<div><input type="hidden" name="sort" value="'.$filtr->process($_GET['sort']).'" /></div>';
                    }                
                    ?>                

                    <div class="wyszukaj_przycisk"><input type="image" alt="Szukaj" src="obrazki/ok.png" /></div>
                </form>
                
                <?php
                if ( Listing::wylaczFiltr(basename($_SERVER['SCRIPT_NAME'])) == true ) {
                  echo '<div id="wyszukaj_ikona"><a href="allegro/allegro_aukcje.php?filtr=nie"><img src="obrazki/reset_szukaj.png" alt="Anuluj wyszukiwanie" /></a></div>';
                }
                ?>                 

                <div style="clear:both"></div>
                
            </div> 

            <?php
            $NazwaKonta = '';
            if ( isset($_SESSION['hash']) && isset($_SESSION['allegro_user_login']) ) {
                 $NazwaKonta = $_SESSION['allegro_user_login'];
            }
                
            // sprawdza czy sa jakies aukcjie niezsynchronizowane
            $zapytanieSynch = "SELECT synchronization FROM allegro_auctions WHERE synchronization = 1";
            $sqlSynch = $db->open_query($zapytanieSynch);
            
            if ((int)$db->ile_rekordow($sqlSynch) > 0) { ?>
                
                <div id="BrakSynchronizacji">      
                
                    <form action="allegro/allegro_synchronizuj.php<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz')); ?>" method="post" class="cmxform">
                      <input type="hidden" name="akcja" value="synchronizuj" />
                      <input type="hidden" name="powrot" value="allegro_aukcje" />
                      <input type="submit" class="przyciskBut" value="Pobierz wszystkie dane o aukcjach z Allegro<?php echo (($NazwaKonta != '') ? ' dla konta ' . $NazwaKonta : ''); ?>" />
                    </form>     
                    
                    <form action="allegro/allegro_synchronizuj.php?journal=tak<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz'), true); ?>" method="post" class="cmxform">
                      <input type="hidden" name="akcja" value="synchronizuj" />
                      <input type="hidden" name="powrot" value="allegro_aukcje" />
                      <input type="submit" class="przyciskBut" value="Pobierz dane od ostatniej synchronizacji<?php echo (($NazwaKonta != '') ? ' dla konta ' . $NazwaKonta : ''); ?>" />
                    </form>  
                    
                    <span>Należy wykonać synchronizację z Allegro - nie wszystkie aukcje mają aktualne dane</span>
                    
                </div>
 
            <?php }
            
            $db->close_query($sqlSynch);
            unset($zapytanieSynch);        
            ?>              
            
            <div style="clear:both"></div>

            <div id="sortowanie">
            
                <span>Sortowanie: </span>
                
                <a id="sort_a1" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a1">daty końca malejąco</a>
                <a id="sort_a2" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a2">daty końca rosnąco</a>
                <a id="sort_a3" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a3">numeru malejąco</a>
                <a id="sort_a4" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a4">numeru rosnąco</a>
                <a id="sort_a5" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a5">wyświetleń malejąco</a>
                <a id="sort_a6" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a6">wyświetleń rosnąco</a>
                <a id="sort_a7" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a7">sprzedaż malejąco</a>
                <a id="sort_a8" class="sortowanie" href="allegro/allegro_aukcje.php?sort=sort_a8">sprzedaż rosnąco</a>
                
            </div> 
            
            <div id="PrzyciskiAukcji">
            
                <div class="lf">
                    <a class="dodaj" href="allegro/allegro_dodaj_aukcje.php">dodaj nową aukcję</a>     
                    <span class="SynchronizujPole">synchronizuj aukcje z pliku lub listy</span>                      
                </div>  
                
                <div style="clear:both"></div>

                <div id="PolaSynchronizacji">
                
                    <script>
                    $(function(){
                       $('#upload').MultiFile({
                        max: 1,
                        accept:'txt',
                        STRING: {
                         denied:'Nie można przesłać pliku w tym formacie $ext!',
                         selected:'Wybrany plik: $file',
                        }
                       }); 
                       
                       $('.SynchronizujPole').click(function() {
                          if ( $('#PolaSynchronizacji').css('display') == 'none' ) {
                               $('#PolaSynchronizacji').slideDown();
                            } else {
                               $('#PolaSynchronizacji').slideUp();
                          }
                       })
                    });
                    </script>                
                
                    <form action="allegro/allegro_synchronizuj.php?wybrane=tak<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz'), true); ?>" method="post" class="cmxform" enctype="multipart/form-data">  
                    
                       <input type="hidden" name="akcja" value="synchronizuj" />
                       <input type="hidden" name="lista" value="tak" />
                       <input type="hidden" name="powrot" value="allegro_aukcje" />
                       
                       <div class="PoleSynch">
                          Podaje numery aukcji (każdy nr w osobnej linii):
                          <textarea name="wybrane" cols="50" rows="10"></textarea>
                       </div>
                       
                       <div class="PoleSynch">
                         Plik do importu (z numerami aukcji): <input type="file" name="file" id="upload" size="53" />
                       </div>                       
                       
                       <span class="maleInfo" style="margin-left:0px">Maksymalna wielkość pliku do wczytania: <?php echo Funkcje::MaxUpload(); ?> Mb</span>
                       
                       <input type="submit" class="przyciskBut" value="Pobierz dane aukcji <?php echo (($NazwaKonta != '') ? ' (dla konta ' . $NazwaKonta . ')' : ''); ?>" />   
                       
                    </form>                  
                
                </div>
                
                <div style="clear:both"></div>
                
                <?php if ( $allegro->polaczenie['CONF_USER_2_STATUS'] == 'tak' || $allegro->polaczenie['CONF_USER_3_STATUS'] == 'tak' ) { ?>
                
                <div class="ZmianaKontaAllegro">
                
                    <form action="allegro/allegro_aukcje_logowanie.php" method="post" class="cmxform">
                    
                        <input type="hidden" value="zmiana" name="zmiana_logowania" />
                    
                        <select name="login_allegro">
                           <option value="1" <?php echo ((isset($_SESSION['allegro_user_login']) && $_SESSION['allegro_user_login'] == $allegro->polaczenie['CONF_LOGIN']) ? 'selected="selected"' : ''); ?>><?php echo $allegro->polaczenie['CONF_LOGIN']; ?></option>
                           <?php if ( $allegro->polaczenie['CONF_USER_2_STATUS'] == 'tak' ) { ?>
                               <option value="2" <?php echo ((isset($_SESSION['allegro_user_login']) && $_SESSION['allegro_user_login'] == $allegro->polaczenie['CONF_LOGIN_2']) ? 'selected="selected"' : ''); ?>><?php echo $allegro->polaczenie['CONF_LOGIN_2']; ?></option>
                           <?php } ?>
                           <?php if ( $allegro->polaczenie['CONF_USER_3_STATUS'] == 'tak' ) { ?>
                               <option value="3" <?php echo ((isset($_SESSION['allegro_user_login']) && $_SESSION['allegro_user_login'] == $allegro->polaczenie['CONF_LOGIN_3']) ? 'selected="selected"' : ''); ?>><?php echo $allegro->polaczenie['CONF_LOGIN_3']; ?></option>
                           <?php } ?>
                        </select>
                    
                    </form>
                    
                    <script>
                    $(document).ready(function() {
                        $('.ZmianaKontaAllegro select').change(function() {
                            $(this).parents('form:first').submit()
                        });  
                    });                       
                    </script>
                    
                </div>
                
                <?php } ?>
                
                <?php
                if ( isset($_SESSION['hash']) && isset($_SESSION['allegro_user_login']) ) {
                     echo '<div class="JestesZalogowanyAllegro">Jesteś zalogowany w Allegro - <span>' . $_SESSION['allegro_user_login'] . '</span></div>';
                  } else {
                     echo '<div class="NieJestesZalogowanyAllegro">Nie jesteś zalogowany w Allegro - <a href="allegro/allegro_aukcje_logowanie.php">zaloguj się</a></div>';
                }
                ?> 

                <div style="clear:both"></div>
            
            </div>
                
            <form action="allegro/allegro_aukcje_akcja.php" method="post" class="cmxform">
                
                <script>
                $(document).ready(function() {
                  
                    $('#RozwijanieKategorii').off('click').click(function() {
                        //
                        if ($('#KategorieAllegro').css('display') != 'none') { 
                            //
                            $('#KategorieAllegro').slideUp();
                            $('#KategorieSklepu').slideUp();
                            //
                          } else {
                            //
                            $('#KategorieAllegro').slideDown();
                            $('#KategorieSklepu').slideDown();
                            //
                        }     
                        //   
                    }); 

                });
                </script>
                
                <div id="RozwijanieKategorii">
                
                    <span>FILTRY KATEGORII</span>
                
                </div>
                
                <div id="KategorieAllegro" <?php echo (((isset($_GET['kategoria_id']) && (int)isset($_GET['kategoria_id']) > 0) || (isset($_GET['kategoria_allegro']) && (int)isset($_GET['kategoria_allegro']) > 0)) ? 'style="display:block"' : ''); ?>>
                
                    <div class="OknoNaglowek">Kategorie Allegro</div>
                    
                    <?php                    
                    //
                    $zapytanieKat = "SELECT * FROM allegro_categories";
                    $sqlKat = $db->open_query($zapytanieKat); 
                    //
                    $DrzewoKategorii = array();
                    //
                    while ( $info = $sqlKat->fetch_assoc() ) {
                        //
                        $DrzewoKategorii[$info['cat_id']] = array('id' => $info['cat_id'],
                                                                  'parent' => $info['cat_parent'],
                                                                  'nazwa' => $info['cat_name']);
                        //
                    }
                    //
                    $db->close_query($sqlKat);
                    unset($zapytanieKat, $info);                    
                    //
                    $TablicaNazw = array();
                    //
                    $sql = $db->open_query("SELECT allegro_category FROM allegro_auctions");                    
                    while ($info = $sql->fetch_assoc()) {
                        //
                        if ( isset( $DrzewoKategorii[$info['allegro_category']]) ) {
                            //
                            // $Nazwa = Allegro::SciezkaKategoriiAllegro($info['allegro_category']);
                            $Nazwa = $DrzewoKategorii[$info['allegro_category']]['nazwa'];
                            //
                            if ( $DrzewoKategorii[$info['allegro_category']]['parent'] > 0 ) {
                                 //
                                 $Nazwa = $DrzewoKategorii[ $DrzewoKategorii[$info['allegro_category']]['parent'] ]['nazwa'] . ' / ' . $Nazwa;
                                 //
                            }
                            //
                            $NazwaKlucz = $DrzewoKategorii[$info['allegro_category']]['id'] . '_' . iconv('UTF-8', 'ASCII//TRANSLIT',str_replace(array('#', '$', ' ', '/', "'" ,'"', '`'), '', $Nazwa));
                            //
                            if ( isset($TablicaNazw[$NazwaKlucz]) ) {
                                 //
                                 $TablicaNazw[$NazwaKlucz]['ilosc'] += 1;
                                 //
                              } else {
                                 //
                                 $TablicaNazw[$NazwaKlucz] = array('id' => $info['allegro_category'], 'ilosc' => 1, 'nazwa' => $Nazwa);
                                 //
                            }
                            //
                            unset($Nazwa, $NazwaKlucz);
                            //
                        }
                        //
                    }    
                    $db->close_query($sql);                   

                    sort($TablicaNazw);
                    
                    echo '<ul>';                    
                    foreach ( $TablicaNazw as $KategorieAllegro ) {
                        //
                        $TmpTekst = '';
                        $DanaKategoria = explode('/', $KategorieAllegro['nazwa']);
                        //
                        for ($x = 0; $x < count($DanaKategoria); $x++) {
                            //
                            if ( $x < count($DanaKategoria) - 1 ) {
                                 $TmpTekst .= $DanaKategoria[$x] . ' > ';
                              } else {
                                 $TmpTekst .= '<b>' . $DanaKategoria[$x] . '</b>';
                            }
                            //
                        }
                        //
                        if (isset($_GET['kategoria_allegro']) && (int)$_GET['kategoria_allegro'] > 0 && (int)$_GET['kategoria_allegro'] == $KategorieAllegro['id']) {
                            echo '<li class="AktywnaKategoria">';
                          } else {
                            echo '<li>';
                        }
                        echo '<a href="allegro/allegro_aukcje.php?kategoria_allegro=' . $KategorieAllegro['id'] . '">' . $TmpTekst . ' <span>(' . $KategorieAllegro['ilosc'] . ')</span></a></li>';
                        //
                        unset($DanaKategoria, $TmpTekst);
                        //
                    }
                    echo '</ul>';
                    ?>

                </div>
                
                <div id="KategorieSklepu" <?php echo (((isset($_GET['kategoria_id']) && (int)isset($_GET['kategoria_id']) > 0) || (isset($_GET['kategoria_allegro']) && (int)isset($_GET['kategoria_allegro']) > 0)) ? 'style="display:block"' : ''); ?>>
                
                    <div class="OknoNaglowek">Kategorie wg sklepu</div>
                    
                    <?php
                    echo '<div class="OknoKategoriiAllegro"><table class="pkc">';
                    $tablica_kat = Kategorie::DrzewoKategorii('0', '', '', '', false, true);
                    for ($w = 0, $c = count($tablica_kat); $w < $c; $w++) {
                        $podkategorie = false;
                        if ($tablica_kat[$w]['podkategorie'] == 'true') { $podkategorie = true; }
                        // sprawdza czy nie jest wybrana
                        $style = '';
                        if (isset($_GET['kategoria_id']) && (int)$_GET['kategoria_id'] > 0) {
                            if ((int)$_GET['kategoria_id'] == $tablica_kat[$w]['id']) {
                                $style = ' style="color:#ff0000"';
                            }
                        }
                        //
                        echo '<tr>
                                <td class="lfp"><a href="allegro/allegro_aukcje.php?kategoria_id='.$tablica_kat[$w]['id'].'" '.$style.'>'.$tablica_kat[$w]['text'].'</a></td>
                                <td class="rgp" '.(($podkategorie) ? 'id="img_'.$tablica_kat[$w]['id'].'"' : '').'>'.(($podkategorie) ? '<img src="obrazki/rozwin.png" alt="Rozwiń" onclick="podkat(\''.$tablica_kat[$w]['id'].'\',\'\',\'\',\'\',\'allegro\')" />' : '').'</td>
                              </tr>
                              '.(($podkategorie) ? '<tr><td colspan="2"><div id="p_'.$tablica_kat[$w]['id'].'"></div></td></tr>' : '').'';
                    }
                    if ( count($tablica_kat) == 0 ) {
                         echo '<tr><td colspan="9" style="padding:10px">Brak wyników do wyświetlania</td></tr>';
                    }
                    echo '</table></div>';
                    unset($tablica_kat,$podkategorie,$style);
                    ?>        

                    <?php 
                    if (isset($_GET['kategoria_id']) && (int)$_GET['kategoria_id'] > 0) {
                        $sciezka = Kategorie::SciezkaKategoriiId((int)$_GET['kategoria_id'], 'categories');
                        $cSciezka = explode("_",$sciezka);                    
                        if (count($cSciezka) > 1) {
                            //
                            $ostatnie = strRpos($sciezka,'_');
                            $analiza_sciezki = str_replace("_",",",substr($sciezka,0,$ostatnie));
                            ?>
                            
                            <script>         
                            podkat('<?php echo $analiza_sciezki; ?>', '<?php echo $cSciezka[count($cSciezka)-1]; ?>','','','allegro');
                            </script>
                            
                        <?php
                        unset($sciezka,$cSciezka);
                        }
                    } 
                    ?>                    

                </div>
            
                <div class="cl"></div>

                <div id="wynik_zapytania"></div>
                <div id="aktualna_pozycja">1</div>

                <div id="akcja">
                
                  <div class="lf"><img src="obrazki/strzalka.png" alt="" /></div>
                  
                  <div class="lf" style="padding-right:20px">
                  
                    <span onclick="akcja(1)">zaznacz wszystkie</span>
                    <span onclick="akcja(2)">odznacz wszystkie</span>
                  </div>
                  
                  <div id="akc">
                  
                    Wykonaj akcje: 
                    
                    <select name="akcja_dolna" id="akcja_dolna">
                      <option value="0"></option>
                      <option value="1">usuń zaznaczone aukcje z bazy</option>
                      <option value="2">usuń zaznaczone aukcje z bazy i zakończ aukcje przed czasem</option>
                      <option value="3">wystaw kolejne aukcje dla zaznaczonych produktów</option>
                      <option value="8">wystaw kolejne aukcje dla zaznaczonych produktów i usuń aukcje z bazy</option>
                      <option value="4">zakończ zaznaczone aukcje przed czasem</option>
                      <option value="5">zaktualizuj ilość produktów na aukcjach</option>
                      <option value="6">zaktualizuj ceny produktów na aukcjach</option>
                      <option value="7">zmień status na AUKCJA TRWA (tylko dla przeniesionych do archiwum)</option>
                    </select>
                    
                  </div>
                  
                  <div style="clear:both;"></div>
                  
                </div>

                <div id="page"></div>

                <div id="dolny_pasek_stron"></div>
                <div id="pokaz_ile_pozycji"></div>
                <div id="ile_rekordow"><?php echo $ile_pozycji; ?></div>
            
                <?php if ($ile_pozycji > 0) { ?>
                <div style="text-align:right" id="zapisz_zmiany"><input type="submit" class="przyciskBut" value="Wykonaj" /></div>
                <?php } ?>                

            </form>

            <div id="LegendaOpcji">
                            
                <span class="Opcja_1 OpcjaTlo">P</span> pogrubienie
                <span class="Opcja_2 OpcjaTlo">M</span> miniaturka
                <span class="Opcja_4 OpcjaTlo">Ś</span> podświetlenie
                <span class="Opcja_8 OpcjaTlo">W</span> wyróżnienie
                <span class="Opcja_16 OpcjaTlo">D</span> strona działu
                <span class="Opcja_32 OpcjaTlo">I</span> znak wodny
            
            </div>
            
            <?php if ($ile_pozycji > 0 ) { ?>
            
            <div style="clear:both;"></div>
            
            <div class="DolnaSynchronizacja">
            
                <form action="allegro/allegro_synchronizuj.php<?php echo Funkcje::Zwroc_Get(array('id_poz')); ?>" method="post" class="cmxform">
                   <input type="hidden" name="akcja" value="synchronizuj" />
                   <input type="hidden" name="powrot" value="allegro_aukcje" />
                   <input type="hidden" name="strona" value="<?php echo str_replace(".php", "", basename($_SERVER["SCRIPT_NAME"])); ?>" />
                   <input type="submit" class="przyciskBut" value="Pobierz wszystkie dane o aukcjach z Allegro<?php echo (($NazwaKonta != '') ? ' dla konta ' . $NazwaKonta : ''); ?>" />            
                </form>
                
                <form action="allegro/allegro_synchronizuj.php?journal=tak<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz'), true); ?>" method="post" class="cmxform">
                   <input type="hidden" name="akcja" value="synchronizuj" />
                   <input type="hidden" name="powrot" value="allegro_aukcje" />
                   <input type="submit" class="przyciskBut" value="Pobierz dane od ostatniej synchronizacji<?php echo (($NazwaKonta != '') ? ' dla konta ' . $NazwaKonta : ''); ?>" />
                </form> 
                
                <script>
                function sprawdzWybrane() {
                  //
                  var idt = [];
                  $("input[type='checkbox'][name='opcja[]']").each(function(){
                      if ( $(this).prop('checked') ) {
                           var str = $(this).val();
                           idt.push(str);
                      }
                  });
                  //
                  $('#wybrane').val(idt.join(";"));
                  //
                }
                </script>

                <form action="allegro/allegro_synchronizuj.php?wybrane=tak<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz'), true); ?>" method="post" class="cmxform">
                   <input type="hidden" name="akcja" value="synchronizuj" />
                   <input type="hidden" name="powrot" value="allegro_aukcje" />
                   <input type="hidden" name="wybrane" id="wybrane" value="" />
                   <input type="submit" class="przyciskBut" onclick="sprawdzWybrane()" value="Pobierz dane zaznaczonych aukcji<?php echo (($NazwaKonta != '') ? ' dla konta ' . $NazwaKonta : ''); ?>" />                
                </form>        

            </div>
            
            <?php } ?>
            
            <div style="clear:both;"></div>

            <script>
            $("#wynik_zapytania").html('<div style="padding:10px">Trwa ładowanie danych ...</div>');
            var skocz = '<?php echo ((isset($_GET['id_poz']) && (int)$_GET['id_poz'] > 0) ? (int)$_GET['id_poz'] : ''); ?>';
            <?php Listing::pokazAjax('allegro/allegro_aukcje.php', $zapytanie, $ile_licznika, $ile_pozycji, 'allegro_id'); ?>
            </script>                

        </div>

        <?php
        /*
        <?php if ($ile_pozycji < 1 && Listing::wylaczFiltr(basename($_SERVER['SCRIPT_NAME'])) == false) { ?>
        
        <form action="allegro/allegro_synchronizuj.php<?php echo Funkcje::Zwroc_Wybrane_Get(array('id_poz')); ?>" method="post" class="cmxform">
          <input type="hidden" name="akcja" value="synchronizuj" />
          <input type="hidden" name="powrot" value="allegro_aukcje" />
          <input type="submit" class="przyciskBut" value="Pobierz wszystkie dane o aukcjach z Allegro" />
        </form>
          
        <?php } ?>
        */
        ?>
        
        <?php include('stopka.inc.php'); ?>

    <?php }

} ?>
