<?php

  // plik
  $WywolanyPlik = 'zamowienia_szczegoly';

  include('start.php');
  
  $AktywnyHash = false;
  $hashKod = '';
  
  if ( isset($_GET['zamowienie']) && STR_PANELU_KLIENTA_BEZ_LOGOWANIA == 'tak' && isset($_GET['id']) && (int)$_GET['id'] > 0) {
    
      $zamowienie = new Zamowienie((int)$_GET['id']);
      
      $hashKod = hash("sha1", $zamowienie->info['id_zamowienia'] . ';' . $zamowienie->info['data_zamowienia'] . ';' . $zamowienie->klient['adres_email'] . ';' . $zamowienie->klient['id']);
      
      if ( $_GET['zamowienie'] === $hashKod ) {
           $AktywnyHash = true;
           if ( !isset($_SESSION['customer_email']) ) {
                $_SESSION['customer_email'] = $zamowienie->klient['adres_email'];
           }
      }

      unset($zamowienie);
    
  }

  if ( ((isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0') || $AktywnyHash == true) && isset($_GET['id']) && (int)$_GET['id'] > 0 ) {
  
    $blad = false;
    if ( isset($_GET['id']) && (int)$_GET['id'] > 0 ) {
    
        $zapytanie = "SELECT customers_id FROM orders WHERE orders_id = '" . (int)$_GET['id'] . "' LIMIT 1";
        $sql = $GLOBALS['db']->open_query($zapytanie);

        if ((int)$GLOBALS['db']->ile_rekordow($sql) > 0) {
            $info = $sql->fetch_assoc();
            if ( (int)$info['customers_id'] == (int)$_SESSION['customer_id'] || $AktywnyHash == true ) {
                $blad = false;
            } else {
                $blad = true;
            }
            unset($info);
        } else {
            $blad = true;
        }

        $GLOBALS['db']->close_query($sql);
        unset($zapytanie);

    } else {
        $blad = true;
    }

    if ( $blad ) {
        Funkcje::PrzekierowanieURL('brak-strony.html'); 
    }

    unset($blad);  

    $GLOBALS['tlumacz'] = array_merge( $i18n->tlumacz( array('KLIENCI', 'KLIENCI_PANEL', 'PLATNOSCI', 'PRZYCISKI', 'REKLAMACJE') ), $GLOBALS['tlumacz'] );

    // meta tagi
    $Meta = MetaTagi::ZwrocMetaTagi( basename(__FILE__) );
    $tpl->dodaj('__META_TYTUL', $Meta['tytul']);
    $tpl->dodaj('__META_SLOWA_KLUCZOWE', $Meta['slowa']);
    $tpl->dodaj('__META_OPIS', $Meta['opis']);
    unset($Meta);

    // breadcrumb
    $nawigacja->dodaj($GLOBALS['tlumacz']['PANEL_KLIENTA'],Seo::link_SEO('panel_klienta.php', '', 'inna'));
    $nawigacja->dodaj($GLOBALS['tlumacz']['NAGLOWEK_HISTORIA_ZAMOWIEN'],Seo::link_SEO('zamowienia_przegladaj.php', '', 'inna'));
    $nawigacja->dodaj($GLOBALS['tlumacz']['KLIENT_SZCZEGOLY_ZAMOWIENIA']);
    $tpl->dodaj('__BREADCRUMB', $nawigacja->sciezka(' ' . $GLOBALS['tlumacz']['NAWIGACJA_SEPARATOR'] . ' '));

    $zamowienie = new Zamowienie((int)$_GET['id']);
    
    $DodatkoweInformacje = array();
    
    // dodatkowe dane klienta
    $zapytanie = "SELECT * FROM customers c, customers_info ci where c.customers_id = '" . $zamowienie->klient['id'] . "' and c.customers_id = ci.customers_info_id";
    $sql = $db->open_query($zapytanie);  

    $DaneKlienta = $sql->fetch_assoc();

    $GLOBALS['db']->close_query($sql); 
    unset($zapytanie);     
    
    // dodatkowe informacje w panelu klienta
    $zapytanie = "SELECT cafd.orders_account_fields_id,
                         cafd.orders_account_fields_name, 
                         cafd.orders_account_fields_text, 
                         caf.orders_account_fields_type
                    FROM orders_account_fields caf, 
                         orders_account_fields_description cafd 
                   WHERE caf.orders_id = '" . $zamowienie->info['id_zamowienia'] . "' AND caf.orders_account_fields_id = cafd.orders_account_fields_id AND cafd.language_id = '" . $_SESSION['domyslnyJezyk']['id'] . "'";
     
    $sql = $db->open_query($zapytanie);  

    while ( $info = $sql->fetch_assoc() ) {    
        //
        $Tytul = '<b>' . $info['orders_account_fields_name'] . '</b>';
        $Wartosc = $info['orders_account_fields_text'];
        //
        if ( $info['orders_account_fields_type'] == 1 ) {
             //
             $Tytul = '';
             $Wartosc = '<a href="' . $Wartosc . '" target="_blank"><b>' . $info['orders_account_fields_name'] . '</b></a>';
             //
        }
        if ( $info['orders_account_fields_type'] == 2 ) {
             //
             $Tytul = '';
             //
             $UniqId = ($info['orders_account_fields_id'] * $info['orders_account_fields_id']);
             //
             $KluczSesji = base64_encode(serialize(array('tok' => Sesje::Token(), 'data' => $DaneKlienta['customers_info_date_account_created'], 'id' => $DaneKlienta['customers_id'], 'nr' => $UniqId, 'zamowienie' => true)));
             //
             $LinkPobierz = 'panel-klienta-pobierz-' . $KluczSesji . '.html';
             //
             unset($UniqId, $KluczSesji);             
             //
             $Wartosc = '<a href="' . $LinkPobierz . '" target="_blank"><b>' . $info['orders_account_fields_name'] . '</b></a>';
             //
             unset($LinkPobierz);
             //
        }
        //
        $DodatkoweInformacje[] = array('tytul' => $Tytul,
                                       'wartosc' => $Wartosc);
        //
        unset($Tytul, $Wartosc);
        //
    }

    $GLOBALS['db']->close_query($sql); 
    unset($zapytanie, $info, $DaneKlienta);    

    // wyglad srodkowy
    $srodek = new Szablony($Wyglad->TrescLokalna($WywolanyPlik), $zamowienie, $DodatkoweInformacje, $AktywnyHash);
    
    $infoPlatnosc = $zamowienie->info['platnosc_info'];

    if ( $zamowienie->info['platnosc_klasa'] == 'platnosc_payu' || 
         $zamowienie->info['platnosc_klasa'] == 'platnosc_dotpay' || 
         $zamowienie->info['platnosc_klasa'] == 'platnosc_przelewy24' || 
         $zamowienie->info['platnosc_klasa'] == 'platnosc_pbn' || 
         $zamowienie->info['platnosc_klasa'] == 'platnosc_payeezy' ||  
         $zamowienie->info['platnosc_klasa'] == 'platnosc_paypal' || 
         $zamowienie->info['platnosc_klasa'] == 'platnosc_cashbill' || 
         $zamowienie->info['platnosc_klasa'] == 'platnosc_transferuj' || 
         $zamowienie->info['platnosc_klasa'] == 'platnosc_eservice') {    
    
         if ( $zamowienie->info['platnosc_tablica'] != '#' ) {
           
            $platnosci = new Platnosci( 1, $zamowienie->info['id_zamowienia'] );
            $platnosci->Podsumowanie( 0, $zamowienie->info['platnosc_klasa'], $zamowienie->info['id_zamowienia'] );
            
            // po aktualizacji trzeba odnowic w klasie ciag tablicy
            $sqlTablica = $GLOBALS['db']->open_query("SELECT payment_method_array FROM orders WHERE orders_id = '" . (int)$zamowienie->info['id_zamowienia'] . "'");
            //
            $platnoscTablica = $sqlTablica->fetch_assoc();              
            $zamowienie->info['platnosc_tablica'] = $platnoscTablica['payment_method_array'];
            //
            $GLOBALS['db']->close_query($sqlTablica);
            unset($platnoscTablica);
        
            require_once('moduly/platnosc/raporty/' . str_replace('platnosc_', '', $zamowienie->info['platnosc_klasa']) . '/formularz.php');
            
            $platnoscTablica = @unserialize($zamowienie->info['platnosc_tablica']);            
            $formularzPlatnosci = PowtorzPlatnosc($platnoscTablica, (int)$_GET['id']);
            unset($platnoscTablica);

            $infoPlatnosc .= ((trim($zamowienie->info['platnosc_info']) != '') ? '<br /><br />' : '') . $formularzPlatnosci;
            
            unset($formularzPlatnosci);
            
         }
         
    }
    
    $srodek->dodaj('__PLATNOSC_INFO', $infoPlatnosc);

    $srodek->dodaj('__NUMER_ZAMOWIENIA', (int)$_GET['id']);
    $srodek->dodaj('__METODA_PLATNOSCI', $zamowienie->info['metoda_platnosci']);
    $srodek->dodaj('__WYSYLKA_MODUL', $zamowienie->info['wysylka_modul'] . ( $zamowienie->info['wysylka_info'] != '' ? ' ('.$zamowienie->info['wysylka_info'].')' : ''));
    $srodek->dodaj('__DATA_ZAMOWIENIA', date('d-m-Y H:i:s',strtotime($zamowienie->info['data_zamowienia'])));
    $srodek->dodaj('__STATUS_ZAMOWIENIA', Funkcje::pokazNazweStatusuZamowienia($zamowienie->info['status_zamowienia'],$_SESSION['domyslnyJezyk']['id']));
    $srodek->dodaj('__OPIEKUN_ZAMOWIENIA', Funkcje::PokazOpiekuna($zamowienie->info['opiekun']));
    
    $srodek->dodaj('__NR_PRZESYLKI', (($zamowienie->dostawy_nr_przesylki != '') ? ', ' . $GLOBALS['tlumacz']['NR_PRZESYLKI'] . ' ' . $zamowienie->dostawy_nr_przesylki : ''));

    foreach ($zamowienie->dostawa as $key => $value) {
        $srodek->dodaj('__DOSTAWA_'.strtoupper($key), $value);
    }
    
    foreach ($zamowienie->platnik as $key => $value) {
        $srodek->dodaj('__PLATNIK_'.strtoupper($key), $value);
    }
    
    $hashKod = '';    
    if ( STR_PANELU_KLIENTA_BEZ_LOGOWANIA == 'tak' ) {
         $hashKod = '/zamowienie=' . hash("sha1", $zamowienie->info['id_zamowienia'] . ';' . $zamowienie->info['data_zamowienia'] . ';' . $zamowienie->klient['adres_email'] . ';' . $zamowienie->klient['id']);
    }    
    // jezeli klient jest zalogowany to nie potrzeba hasha
    if (isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0') {
         $hashKod = '';
    }

    $srodek->dodaj('__PDF_ZAMOWIENIE', '<a class="pdf" href="zamowienia-szczegoly-pdf-' . (int)$_GET['id'] . '.html' . $hashKod . '"><img alt="' . $GLOBALS['tlumacz']['DRUKUJ_ZAMOWIENIE'] . '" title="' . $GLOBALS['tlumacz']['DRUKUJ_ZAMOWIENIE'] . '" src="szablony/' . DOMYSLNY_SZABLON . '/obrazki/pdf/zamowienie.png" /></a>');
    
    $srodek->dodaj('__PDF_FAKTURA', '');
    if ( FAKTURA_POBIERANIE == 'tak' ) { 
         $srodek->dodaj('__PDF_FAKTURA', '<a class="pdf" href="zamowienia-faktura-pdf-' . (int)$_GET['id'] . '.html' . $hashKod . '"><img alt="' . $GLOBALS['tlumacz']['DRUKUJ_FAKTURE'] . '" title="' . $GLOBALS['tlumacz']['DRUKUJ_FAKTURE'] . '" src="szablony/' . DOMYSLNY_SZABLON . '/obrazki/pdf/faktura.png" /></a>');
    }
    
    $srodek->dodaj('__NAPISANIE_REKLAMACJI', ((WLACZENIE_SSL == 'tak') ? ADRES_URL_SKLEPU_SSL . '/' : '') . 'reklamacje-napisz.html/id=' . $zamowienie->info['id_zamowienia'] . $hashKod);
    
    // sprzedaz elektroniczna
    $srodek->dodaj('__LINK_POBRANIA_PLIKOW', $zamowienie->sprzedaz_online_link . $hashKod);    
    
    // lista reklamacji do zamowienia 
    $zapytanieReklamacja = "SELECT * FROM complaints where complaints_customers_orders_id = '" . (int)$_GET['id'] . "'";
    $sqlReklamacja = $db->open_query($zapytanieReklamacja);  

    $ZlozoneReklamacje = '';
    while ($info = $sqlReklamacja->fetch_assoc()) {
        //
        $hashReklamacja = '';
        if ( STR_PANELU_KLIENTA_BEZ_LOGOWANIA == 'tak' ) {
             //
             $hashReklamacja = '/reklamacja=' . hash("sha1", $info['complaints_rand_id'] . ';' . $info['complaints_date_created'] . ';' . $info['complaints_customers_email'] . ';' . $info['complaints_customers_id'] . ';' . $info['complaints_customers_orders_id']);
             //
        }
        // jezeli klient jest zalogowany nie jest potrzebny hash
        if (isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0') {
            $hashReklamacja = '';
        }
        //
        $ReklamacjaSzczegoly = '<a href="' . ( WLACZENIE_SSL == 'tak' ? ADRES_URL_SKLEPU_SSL : ADRES_URL_SKLEPU )."/reklamacje-szczegoly-rs-" . $info['complaints_rand_id'] . ".html" . $hashReklamacja . '"><b>' . $info['complaints_rand_id'] . '</b></a>';         
        //
        $ZlozoneReklamacje .= '<div class="TrescSekcji">' . $GLOBALS['tlumacz']['BYLA_REKLAMACJA_NR'] . ' ' . $ReklamacjaSzczegoly . '</div>';
        //
        unset($ReklamacjaSzczegoly, $hashReklamacja);
        //
    }
    
    $srodek->dodaj('__LISTA_REKLAMACJI', $ZlozoneReklamacje);    

    $GLOBALS['db']->close_query($sqlReklamacja); 
    unset($zapytanieReklamacja);     
    
    unset($hashKod, $ZlozoneReklamacje);

    $tpl->dodaj('__SRODKOWA_KOLUMNA', $srodek->uruchom());

    unset($srodek, $WywolanyPlik, $DodatkoweInformacje);

    include('koniec.php');

  } else {

    Funkcje::PrzekierowanieSSL( 'logowanie.html' );

  }
?>