<?php
// wczytanie ustawien inicjujacych system
require_once(dirname(__FILE__).'/ustawienia/init.php');

// jezeli sklep jest wylaczony
if ( INFO_WYLACZ_SKLEP == 'tak') {
     Wylaczenie::WylaczSklep();
}

// zmienna do okreslania ze nie jest aktualnie wyswietlana strona glowna
if (isset($WywolanyPlik) && $WywolanyPlik == 'strona_glowna') {
    $GLOBALS['stronaGlowna'] = true;
}

// Wczytanie skryptu js na stronie glownej do cash4free
if ( INTEGRACJA_OPENRATE_WLACZONY == 'tak' ) {
    if (isset($WywolanyPlik) && $WywolanyPlik == 'strona_glowna') {
        $_SESSION['stronaGlowna'] = true;
    } else {
        $_SESSION['stronaGlowna'] = false;
    }
}

// zmiana ustawienia jezeli jest pusty koszyk
if ( isset($_SESSION['koszyk']) && count($_SESSION['koszyk']) < 1 && $WywolanyPlik == 'koszyk' ) {
  unset($GLOBALS['kolumny']);
  $GLOBALS['kolumny'] = 'wszystkie';
}

// sprawdzi czy nie zmienil sie stan magazynowy produktu lub produkt nie jest wylaczony - musi wtedy zmienic wartosc koszyka
if ( isset($_SESSION['koszyk']) && count($_SESSION['koszyk']) > 0 && $WywolanyPlik != 'zamowienie_podsumowanie' ) {
    //
    $stanKoszyka = false;
    $stanKoszykaOgolne = false;
    foreach ($_SESSION['koszyk'] AS $TablicaZawartosci) {
        //
        $stanKoszyka = $GLOBALS['koszykKlienta']->SprawdzIloscProduktuMagazyn( $TablicaZawartosci['id'], true );
        //
        if ( $stanKoszyka == true ) {
             $stanKoszykaOgolne = true;
        }
        //
    }
    if ( $stanKoszykaOgolne == true ) {
        //
        Funkcje::PrzekierowanieURL('koszyk.html');
        //
    }
    unset($stanKoszyka, $stanKoszykaOgolne);
    //
}

// definiowanie szablonu
$tpl = new Szablony('szablony/'.DOMYSLNY_SZABLON.'/strona_glowna.tp');

// pusta deklaracja
$tpl->dodaj('__LINK_CANONICAL', '');

// glowne definicje z sekcji head
$tpl->dodaj('__DOMYSLNY_SZABLON', DOMYSLNY_SZABLON);

$tpl->dodaj('__JEZYK_STRONY', $_SESSION['domyslnyJezyk']['kod']);

// strona glowna
$isHTTPS = false;
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
    $isHTTPS = true;
} elseif ((!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && strpos($_SERVER['HTTP_X_FORWARDED_PROTO'], 'https') > -1) || (!empty($_SERVER['HTTP_X_FORWARDED_SSL']) && $_SERVER['HTTP_X_FORWARDED_SSL'] == 'on')) {
    $isHTTPS = true;
}
if ( $isHTTPS ) {
    $tpl->dodaj('__DOMENA', ADRES_URL_SKLEPU_SSL);
} else {
    $tpl->dodaj('__DOMENA', ADRES_URL_SKLEPU);
}


// plik javascript do wyswietlanego pliku
if (file_exists('javascript/'.$WywolanyPlik.'.jcs')) {
    $tpl->dodaj('__JS_PLIK', '<script type="text/javascript" src="javascript/' . $WywolanyPlik . '.php"></script>');
  } else {
    $tpl->dodaj('__JS_PLIK', '');
}

$kod_google_header  = "";

// kod weryfikacyjny Google dla webmasterow
if ( INTEGRACJA_GOOGLE_WERYFIKACJA != '' ) {
    $kod_google_header .= "<meta name=\"google-site-verification\" content=\"".INTEGRACJA_GOOGLE_WERYFIKACJA."\" />\n" . $kod_google_header;
}

$tpl->dodaj('__GOOGLE_WERYFIKACJA', $kod_google_header);

unset($kod_google_header);

// modul Google Analytics
$kod_google_header  = "";
if ( INTEGRACJA_GOOGLE_WLACZONY == 'tak' && INTEGRACJA_GOOGLE_ID != '' ) {

    $ex = pathinfo($_SERVER['PHP_SELF']);
    if ( basename($_SERVER['PHP_SELF'],'.'.$ex['extension']) != 'zamowienie_podsumowanie' ) {

        if ( INTEGRACJA_GOOGLE_RODZAJ == 'universal' ) {

            $kod_google_header .= "<!-- Google Analytics -->\n";
            $kod_google_header .= "<script>\n";
            $kod_google_header .= "(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script','//www.google-analytics.com/analytics.js','ga');\n";

            $kod_google_header .= "ga('create', '".INTEGRACJA_GOOGLE_ID."', 'auto');\n";
            $kod_google_header .= "ga('require', 'displayfeatures');\n";
            $kod_google_header .= "ga('send', 'pageview');\n";

            $kod_google_header .= "</script>\n";
            $kod_google_header .= "<!-- End Google Analytics -->\n";
        
        } else {

            $kod_google_header .= "<script type=\"text/javascript\">\n";

            $kod_google_header .= "    var _gaq = _gaq || [];\n";
            $kod_google_header .= "    _gaq.push(['_setAccount', '".INTEGRACJA_GOOGLE_ID."']);\n";
            $kod_google_header .= "    _gaq.push(['_setDomainName', '".str_replace('http://', '', ADRES_URL_SKLEPU)."']);\n";
            $kod_google_header .= "    _gaq.push(['_trackPageview']);\n\n";

            $kod_google_header .= "    (function() {\n";
            $kod_google_header .= "    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;\n";
            if ( INTEGRACJA_GOOGLE_ADWORDS == 'tak' ) {
                $kod_google_header .= "    ga.src = ('https:' == document.location.protocol ? 'https://' : 'http://') + 'stats.g.doubleclick.net/dc.js';\n";
            } else {
                $kod_google_header .= "    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';\n";
            }
            $kod_google_header .= "    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);\n";
            $kod_google_header .= "    })();\n";
            $kod_google_header .= "</script>\n";
        }

    }
    unset($ex);

}
$tpl->dodaj('__GOOGLE_ANALYTICS', $kod_google_header);
unset($kod_google_header);

// widget Trusted Shops
$kod_trustedshops = "";
if ( INTEGRACJA_TRUSTEDSHOPS_WLACZONY == 'tak' && INTEGRACJA_TRUSTEDSHOPS_PARTNERID != '' ) {

    //$ex = pathinfo($_SERVER['PHP_SELF']);
    //if ( basename($_SERVER['PHP_SELF'],'.'.$ex['extension']) != 'zamowienie_podsumowanie' ) {

        $kod_trustedshops .= "<script type=\"text/javascript\">\n";
        $kod_trustedshops .= "(function () {\n"; 
        $kod_trustedshops .= "var _tsid = '".INTEGRACJA_TRUSTEDSHOPS_PARTNERID."';\n"; 
        $kod_trustedshops .= "_tsConfig = {\n"; 
        $kod_trustedshops .= "'yOffset': '".INTEGRACJA_TRUSTEDSHOPS_PRZESUNIECIE."', /* offset from page bottom */\n";
        $kod_trustedshops .= "'variant': '".INTEGRACJA_TRUSTEDSHOPS_FORMAT."', /* text, default, small, reviews, custom, custom_reviews */\n";
        $kod_trustedshops .= "'customElementId': '', /* required for variants custom and custom_reviews */\n";
        $kod_trustedshops .= "'trustcardDirection': '', /* for custom variants: topRight, topLeft, bottomRight, bottomLeft */\n";
        $kod_trustedshops .= "'customBadgeWidth': '', /* for custom variants: 40 - 90 (in pixels) */\n";
        $kod_trustedshops .= "'customBadgeHeight': '', /* for custom variants: 40 - 90 (in pixels) */\n";
        $kod_trustedshops .= "'disableResponsive': 'false', /* deactivate responsive behaviour */\n";
        $kod_trustedshops .= "'disableTrustbadge': 'false', /* deactivate trustbadge */\n";
        $kod_trustedshops .= "'trustCardTrigger': 'mouseenter' /* set to 'click' if you want the trustcard to be opened on click instead */\n";
        $kod_trustedshops .= "};\n";
        $kod_trustedshops .= "var _ts = document.createElement('script');\n";
        $kod_trustedshops .= "_ts.type = 'text/javascript'; \n";
        $kod_trustedshops .= "_ts.charset = 'utf-8'; \n";
        $kod_trustedshops .= "_ts.async = true; \n";
        $kod_trustedshops .= "_ts.src = 'https://widgets.trustedshops.com/js/' + _tsid + '.js'; \n";
        $kod_trustedshops .= "var __ts = document.getElementsByTagName('script')[0];\n";
        $kod_trustedshops .= "__ts.parentNode.insertBefore(_ts, __ts);\n";
        $kod_trustedshops .= "})();\n";
        $kod_trustedshops .= "</script>\n";

    //}
    //unset($ex);

}
$tpl->dodaj('__WIDGET_TRUSTEDSHOPS', $kod_trustedshops);
unset($kod_trustedshops);

// pixel Facebook
$pixel_facebook = "";
if ( INTEGRACJA_FB_PIXEL_WLACZONY == 'tak' && INTEGRACJA_FB_PIXEL_ID != '' ) {
  
    $ex = pathinfo($_SERVER['PHP_SELF']);

    $pixel_facebook .= "<script>\n";
    $pixel_facebook .= "!function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?\n";
    $pixel_facebook .= "n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;\n";
    $pixel_facebook .= "n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;\n";
    $pixel_facebook .= "t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,\n";
    $pixel_facebook .= "document,'script','https://connect.facebook.net/en_US/fbevents.js');\n";
    $pixel_facebook .= "fbq('init', '" . INTEGRACJA_FB_PIXEL_ID . "');\n";
    $pixel_facebook .= "fbq('track', 'PageView');\n";
    
    // koszyk - rozpoczęcie realizacji transakcji zakupu
    if ( basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'koszyk' ) {
        $pixel_facebook .= "fbq('track', \"InitiateCheckout\");\n";
    }
    // produkt
    if ( basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'produkt' ) {
        $pixel_facebook .= "fbq('track', \"ViewContent\");\n";
    }    
    // wyszukiwanie
    if ( basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'szukaj' || basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'wyszukiwanie_zaawansowane' ) {
        $pixel_facebook .= "fbq('track', \"Search\");\n";
    }
    
    $pixel_facebook .= "</script>\n";
    
    unset($ex);

}
$tpl->dodaj('__PIKSEL_FB', $pixel_facebook);

// integracja z CRITEO
$criteo = "";

if ( INTEGRACJA_CRITEO_WLACZONY == 'tak' && INTEGRACJA_CRITEO_ID != '' ) {

    $ex = pathinfo($_SERVER['PHP_SELF']);
  
    if ( $GLOBALS['stronaGlowna'] == true || basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'produkt' || basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'koszyk' ) {

        $typ = 'd';
        $AdresEmail = '';

        if ( isset($_SESSION['customer_email']) ) {
            $AdresEmail = $_SESSION['customer_email'];
        }

        $detect = new MobileDetect;
         
        if ( $detect->isMobile() ) {
            $typ = 'm';
        } elseif ( $detect->isTablet() ) {
            $typ = 't';
        } else {
            $typ = 'd';
        }

        $criteo .= "<script type=\"text/javascript\" src=\"//static.criteo.net/js/ld/ld.js\" async=\"true\"></script>\n";
        $criteo .= "<script type=\"text/javascript\">\n";
        $criteo .= "window.criteo_q = window.criteo_q || [];\n";
        $criteo .= "window.criteo_q.push(\n";
        $criteo .= "{ event: \"setAccount\", account: ".INTEGRACJA_CRITEO_ID." },\n";
        $criteo .= "{ event: \"setEmail\", email: \"".$AdresEmail."\" },\n";
        $criteo .= "{ event: \"setSiteType\", type: \"".$typ."\" },\n";

        // produkt
        if ( basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'produkt' ) {
            $criteo .= "{ event: \"viewItem\", item: \"".(isset($_GET['idprod']) ? $_GET['idprod'] : '')."\" },\n";
        }

        // koszyk - rozpoczęcie realizacji transakcji zakupu
        if ( basename($_SERVER['PHP_SELF'],'.' . $ex['extension']) == 'koszyk' ) {
            if ( isset($_SESSION['koszyk']) && count($_SESSION['koszyk']) > 0 && $WywolanyPlik == 'koszyk' ) {

                $criteo .= "{ event: \"viewBasket\", item: [\n";

                $i = 1;
                foreach ($_SESSION['koszyk'] as $ProduktKoszyka) {
                    $criteo .= "{ id: \"".$ProduktKoszyka['id']."\", price: ".$ProduktKoszyka['cena_brutto'].", quantity: ".$ProduktKoszyka['ilosc']." }".($i < count($_SESSION['koszyk']) ? ',' : '' )."\n";
                    $i++;
                }

                $criteo .= "]}\n";

            }

        }

        // strona glowna
        if ( $GLOBALS['stronaGlowna'] == true ) {
            $criteo .= "{ event: \"viewHome\" }\n";
        }
        $criteo .= ");\n";
        $criteo .= "</script>\n";

        unset($AdresEmail, $typ, $ex);
    }
}

$tpl->dodaj('__CRITEO', $criteo);

// integracja z edrone
$edrone = "";
if ( INTEGRACJA_EDRONE_WLACZONY == 'tak' && INTEGRACJA_EDRONE_API != '' ) {

    $edrone .= '<script type="text/javascript">' . "\n";
    $edrone .= '   (function (srcjs) {' . "\n";
    $edrone .= '   window._edrone = window._edrone || {};' . "\n";
    $edrone .= '   _edrone.app_id = \'' . INTEGRACJA_EDRONE_API . '\';' . "\n";
    $edrone .= '   var doc = document.createElement(\'script\');' . "\n";
    $edrone .= '   doc.type = \'text/javascript\';' . "\n";
    $edrone .= '   doc.async = true;' . "\n";
    $edrone .= '   doc.src = (\'https:\' == document.location.protocol ? \'https:\' : \'http:\') + srcjs;' . "\n";
    $edrone .= '   var s = document.getElementsByTagName(\'script\')[0];' . "\n";
    $edrone .= '   s.parentNode.insertBefore(doc, s);' . "\n";
    $edrone .= '   })("//d3bo67muzbfgtl.cloudfront.net/edrone_2_0.js");' . "\n";
    $edrone .= '</script>' . "\n"; 

    if ( isset($_COOKIE['edrone']) ) {

         $AkcjaEdrone = explode('-', str_replace("'", "", $_COOKIE['edrone']));

         //
         // dodanie produktu do koszyka
         if ( $AkcjaEdrone[0] == 'add_to_cart' ) {
              //
              $Produkt = new Produkt( $AkcjaEdrone[1] );
              //
              if ($Produkt->CzyJestProdukt == true) {
                  //
                  $IdKategoriiProduktuWyswietlanego = $Produkt->ProduktKategoriaGlowna();
 
                  $edrone .= '<script type="text/javascript">' . "\n";
                  $edrone .= '   _edrone.app_id = \'' . INTEGRACJA_EDRONE_API . '\';' . "\n";
                  $edrone .= '   _edrone.version = \'1.0.0\';' . "\n";
                  $edrone .= '   _edrone.action_type = \'' . $AkcjaEdrone[0] . '\';' . "\n";
                  $edrone .= '   _edrone.platform_version = \'' . WERSJA . '\';' . "\n";
                  $edrone .= '   _edrone.platform = \'shopgold\';' . "\n";
                  $edrone .= '   _edrone.product_skus = \'' . $Produkt->info['nr_katalogowy'] . '\';' . "\n";
                  $edrone .= '   _edrone.product_ids = \'' . $Produkt->info['id'] . '\';' . "\n";
                  $edrone .= '   _edrone.product_titles = \'' . $Produkt->info['nazwa'] . '\';' . "\n";
                  $edrone .= '   _edrone.product_images = \'' . ADRES_URL_SKLEPU . '/' . KATALOG_ZDJEC . '/' . $Produkt->fotoGlowne['plik_zdjecia'] . '\';' . "\n";
                  $edrone .= '   _edrone.product_urls = \'' . ADRES_URL_SKLEPU . '/' . $Produkt->info['adres_seo'] . '\';' . "\n";
                  $edrone .= '   _edrone.product_category_ids = \'' . Kategorie::SciezkaKategoriiId($IdKategoriiProduktuWyswietlanego['id'], 'id', '~') . '\';' . "\n";
                  $edrone .= '   _edrone.product_category_names = \'' . Kategorie::SciezkaKategoriiId($IdKategoriiProduktuWyswietlanego['id'], 'nazwy', '~') . '\';' . "\n";
                  $edrone .= '   _edrone.shop_lang = \'' . $_SESSION['domyslnyJezyk']['nazwa'] . '\';' . "\n";
                  
                  if ( isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0' ) {
                       //
                       $TablicaKlienta = Klient::daneKlienta((int)$_SESSION['customer_id']);
                       //
                       if ( isset($TablicaKlienta['Imie']) && !empty($TablicaKlienta['Imie']) ) {
                            $edrone .= '   _edrone.first_name = \'' . str_replace("'", "", $TablicaKlienta['Imie']) . '\';' . "\n";
                       }
                       if ( isset($TablicaKlienta['Nazwisko']) && !empty($TablicaKlienta['Nazwisko']) ) {
                            $edrone .= '   _edrone.last_name = \'' . str_replace("'", "", $TablicaKlienta['Nazwisko']) . '\';' . "\n";
                       }   
                       if ( isset($TablicaKlienta['Email']) && !empty($TablicaKlienta['Email']) ) {
                            $edrone .= '   _edrone.email = \'' . str_replace("'", "", $TablicaKlienta['Email']) . '\';' . "\n";
                       }     
                       if ( isset($TablicaKlienta['Kraj']) && !empty($TablicaKlienta['Kraj']) ) {
                            $edrone .= '   _edrone.country = \'' . str_replace("'", "", $TablicaKlienta['Kraj']) . '\';' . "\n";
                       }    
                       if ( isset($TablicaKlienta['Miasto']) && !empty($TablicaKlienta['Miasto']) ) {
                            $edrone .= '   _edrone.city = \'' . str_replace("'", "", $TablicaKlienta['Miasto']) . '\';' . "\n";
                       }      
                       if ( isset($TablicaKlienta['Telefon']) && !empty($TablicaKlienta['Telefon']) && KLIENT_POKAZ_TELEFON == 'tak' ) {
                            $edrone .= '   _edrone.phone = \'' . str_replace("'", "", $TablicaKlienta['Telefon']) . '\';' . "\n";
                       }    
                       //
                       unset($TablicaKlienta);
                       //                    
                  }
                  
                  $edrone .= '</script>' . "\n";
                
                  unset($IdKategoriiProduktuWyswietlanego);         
 
              }
              //
              unset($Produkt);
              //
         }
         
         // newsletter
         if ( $AkcjaEdrone[0] == 'subscribe' ) {    
              //
              $edrone .= '<script type="text/javascript">' . "\n";
              $edrone .= '   _edrone.app_id = \'' . INTEGRACJA_EDRONE_API . '\';' . "\n";
              $edrone .= '   _edrone.version = \'1.0.0\';' . "\n";
              $edrone .= '   _edrone.action_type = \'subscribe\';' . "\n";
              $edrone .= '   _edrone.platform_version = \'' . WERSJA . '\';' . "\n";
              $edrone .= '   _edrone.platform = \'shopgold\';' . "\n";
              $edrone .= '   _edrone.email = \'' . $AkcjaEdrone[2] . '\';' . "\n";
              $edrone .= '   _edrone.subscriber_status = \'' . $AkcjaEdrone[1] . '\';' . "\n";
              $edrone .= '   _edrone.shop_lang = \'' . $_SESSION['domyslnyJezyk']['nazwa'] . '\';' . "\n";
              
              if ( isset($AkcjaEdrone[3]) ) {
                   $edrone .= '   _edrone.customer_tags = \'' . $AkcjaEdrone[3] . '\';' . "\n";
              }
              
              if ( isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0' ) {
                   //
                   $TablicaKlienta = Klient::daneKlienta((int)$_SESSION['customer_id']);
                   //
                   if ( isset($TablicaKlienta['Imie']) && !empty($TablicaKlienta['Imie']) ) {
                        $edrone .= '   _edrone.first_name = \'' . str_replace("'", "", $TablicaKlienta['Imie']) . '\';' . "\n";
                   }
                   if ( isset($TablicaKlienta['Nazwisko']) && !empty($TablicaKlienta['Nazwisko']) ) {
                        $edrone .= '   _edrone.last_name = \'' . str_replace("'", "", $TablicaKlienta['Nazwisko']) . '\';' . "\n";
                   }    
                   if ( isset($TablicaKlienta['Kraj']) && !empty($TablicaKlienta['Kraj']) ) {
                        $edrone .= '   _edrone.country = \'' . str_replace("'", "", $TablicaKlienta['Kraj']) . '\';' . "\n";
                   }    
                   if ( isset($TablicaKlienta['Miasto']) && !empty($TablicaKlienta['Miasto']) ) {
                        $edrone .= '   _edrone.city = \'' . str_replace("'", "", $TablicaKlienta['Miasto']) . '\';' . "\n";
                   }      
                   if ( isset($TablicaKlienta['Telefon']) && !empty($TablicaKlienta['Telefon']) && KLIENT_POKAZ_TELEFON == 'tak' ) {
                        $edrone .= '   _edrone.phone = \'' . str_replace("'", "", $TablicaKlienta['Telefon']) . '\';' . "\n";
                   }  
                   //
                   unset($TablicaKlienta);
                   //                    
              }              
              
              $edrone .= '</script>' . "\n";           
              //
         }  

         // zamowienie bez rejestracji - newsletter - przekazanie maila
         if ( $AkcjaEdrone[0] == 'newsletter_bez_rejestracji' ) {    
              //
              $edrone .= '<script type="text/javascript">' . "\n";
              $edrone .= '   _edrone.app_id = \'' . INTEGRACJA_EDRONE_API . '\';' . "\n";
              $edrone .= '   _edrone.version = \'1.0.0\';' . "\n";
              $edrone .= '   _edrone.action_type = \'subscribe\';' . "\n";
              $edrone .= '   _edrone.platform_version = \'' . WERSJA . '\';' . "\n";
              $edrone .= '   _edrone.platform = \'shopgold\';' . "\n";
              $edrone .= '   _edrone.email = \'' . $AkcjaEdrone[2] . '\';' . "\n";
              $edrone .= '   _edrone.subscriber_status = \'' . $AkcjaEdrone[1] . '\';' . "\n";
              $edrone .= '   _edrone.shop_lang = \'' . $_SESSION['domyslnyJezyk']['nazwa'] . '\';' . "\n";
              
              if ( isset($AkcjaEdrone[3]) ) {
                   $edrone .= '   _edrone.customer_tags = \'' . $AkcjaEdrone[3] . '\';' . "\n";
              }            
              
              $edrone .= '</script>' . "\n";           
              //
         }         

         // zamowienie z rejestracja lub rejestracja - newsletter - przekazanie maila
         if ( $AkcjaEdrone[0] == 'newsletter_z_rejestracja' ) {    
              //
              $edrone .= '<script type="text/javascript">' . "\n";
              $edrone .= '   _edrone.app_id = \'' . INTEGRACJA_EDRONE_API . '\';' . "\n";
              $edrone .= '   _edrone.version = \'1.0.0\';' . "\n";
              $edrone .= '   _edrone.action_type = \'subscribe\';' . "\n";
              $edrone .= '   _edrone.platform_version = \'' . WERSJA . '\';' . "\n";
              $edrone .= '   _edrone.platform = \'shopgold\';' . "\n";
              $edrone .= '   _edrone.email = \'' . $AkcjaEdrone[2] . '\';' . "\n";
              $edrone .= '   _edrone.subscriber_status = \'' . $AkcjaEdrone[1] . '\';' . "\n";
              $edrone .= '   _edrone.shop_lang = \'' . $_SESSION['domyslnyJezyk']['nazwa'] . '\';' . "\n";
              
              if ( isset($AkcjaEdrone[3]) ) {
                   $edrone .= '   _edrone.customer_tags = \'' . $AkcjaEdrone[3] . '\';' . "\n";
              }
              
              if ( isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0' ) {
                   //
                   $TablicaKlienta = Klient::daneKlienta((int)$_SESSION['customer_id']);
                   //
                   if ( isset($TablicaKlienta['Imie']) && !empty($TablicaKlienta['Imie']) ) {
                        $edrone .= '   _edrone.first_name = \'' . str_replace("'", "", $TablicaKlienta['Imie']) . '\';' . "\n";
                   }
                   if ( isset($TablicaKlienta['Nazwisko']) && !empty($TablicaKlienta['Nazwisko']) ) {
                        $edrone .= '   _edrone.last_name = \'' . str_replace("'", "", $TablicaKlienta['Nazwisko']) . '\';' . "\n";
                   }   
                   if ( isset($TablicaKlienta['Kraj']) && !empty($TablicaKlienta['Kraj']) ) {
                        $edrone .= '   _edrone.country = \'' . str_replace("'", "", $TablicaKlienta['Kraj']) . '\';' . "\n";
                   }    
                   if ( isset($TablicaKlienta['Miasto']) && !empty($TablicaKlienta['Miasto']) ) {
                        $edrone .= '   _edrone.city = \'' . str_replace("'", "", $TablicaKlienta['Miasto']) . '\';' . "\n";
                   }      
                   if ( isset($TablicaKlienta['Telefon']) && !empty($TablicaKlienta['Telefon']) && KLIENT_POKAZ_TELEFON == 'tak' ) {
                        $edrone .= '   _edrone.phone = \'' . str_replace("'", "", $TablicaKlienta['Telefon']) . '\';' . "\n";
                   } 
                   //
                   unset($TablicaKlienta);
                   //                    
              }              
              
              $edrone .= '</script>' . "\n";           
              //
         }      

    } else {
      
         if ( $WywolanyPlik != 'zamowienie_podsumowanie' ) {

             $edrone .= '<script type="text/javascript">' . "\n";
             $edrone .= '   _edrone.app_id = \'' . INTEGRACJA_EDRONE_API . '\';' . "\n";
             $edrone .= '   _edrone.version = \'1.0.0\';' . "\n";
             $edrone .= '   _edrone.action_type = \'other\';' . "\n";
             $edrone .= '   _edrone.platform_version = \'' . WERSJA . '\';' . "\n";
             $edrone .= '   _edrone.platform = \'shopgold\';' . "\n";
             $edrone .= '   _edrone.shop_lang = \'' . $_SESSION['domyslnyJezyk']['nazwa'] . '\';' . "\n";
             
             if ( isset($_SESSION['customer_id']) && (int)$_SESSION['customer_id'] > 0 && $_SESSION['gosc'] == '0' ) {
                 
                 $TablicaKlienta = Klient::daneKlienta((int)$_SESSION['customer_id']);
                 //
                 if ( isset($TablicaKlienta['Email']) && !empty($TablicaKlienta['Email']) ) {
                      $edrone .= '   _edrone.email = \'' . str_replace("'", "", $TablicaKlienta['Email']) . '\';' . "\n";
                 }                   
                 if ( isset($TablicaKlienta['Newsletter']) ) {
                      $edrone .= '   _edrone.subscriber_status = \'' . (int)$TablicaKlienta['Newsletter'] . '\';' . "\n";
                 }                     
                 if ( isset($TablicaKlienta['Imie']) && !empty($TablicaKlienta['Imie']) ) {
                      $edrone .= '   _edrone.first_name = \'' . str_replace("'", "", $TablicaKlienta['Imie']) . '\';' . "\n";
                 }
                 if ( isset($TablicaKlienta['Nazwisko']) && !empty($TablicaKlienta['Nazwisko']) ) {
                      $edrone .= '   _edrone.last_name = \'' . str_replace("'", "", $TablicaKlienta['Nazwisko']) . '\';' . "\n";
                 }   
                 if ( isset($TablicaKlienta['Kraj']) && !empty($TablicaKlienta['Kraj']) ) {
                      $edrone .= '   _edrone.country = \'' . str_replace("'", "", $TablicaKlienta['Kraj']) . '\';' . "\n";
                 }    
                 if ( isset($TablicaKlienta['Miasto']) && !empty($TablicaKlienta['Miasto']) ) {
                      $edrone .= '   _edrone.city = \'' . str_replace("'", "", $TablicaKlienta['Miasto']) . '\';' . "\n";
                 }      
                 if ( isset($TablicaKlienta['Telefon']) && !empty($TablicaKlienta['Telefon']) && KLIENT_POKAZ_TELEFON == 'tak' ) {
                      $edrone .= '   _edrone.phone = \'' . str_replace("'", "", $TablicaKlienta['Telefon']) . '\';' . "\n";
                 }    
                 //
                 unset($TablicaKlienta);
                 //                
            }        

            $edrone .= '</script>' . "\n"; 
            
       }

    }
 
}
$tpl->dodaj('__EDRONE', $edrone);
unset($edrone);

// plik css do kalendarza - tylko dla wersji mobilnej
$tpl->dodaj('__CSS_KALENDARZ', '');

// Breadcrumb
$nawigacja = new Nawigacja;
$nawigacja->dodaj($GLOBALS['tlumacz']['STRONA_GLOWNA'], ADRES_URL_SKLEPU, 0);

$Wyglad = new Wyglad();

// jezeli nie jest urzadzanie mobilne
if ( $_SESSION['mobile'] == 'nie' ) {

    // baner popup
    if (( isset($GLOBALS['bannery']->info['POPUP']) && count($GLOBALS['bannery']->info['POPUP']) > 0 ) && ( !isset($_COOKIE['popup_shopGold']) || (int)$_COOKIE['popup_shopGold'] == 1 ))  {

      $tpl->dodaj('__JS_POPUP', '<script type="text/javascript" src="javascript/banner_popup.php"></script>');
      $tpl->dodaj('__CSS_POPUP', ',banner_popup');
      $tpl->dodaj('__TRESC_POPUP', $GLOBALS['bannery']->bannerWyswietlPopUp());
      
    } else {
      //
      if ( ( isset($GLOBALS['bannery']->info['POPUP']) && count($GLOBALS['bannery']->info['POPUP']) > 0 ) ) {
             //
             $WaznoscCookie = '0';
             if ( BANNER_POPUP_WAZNOSC_COOKIE > 0 && isset($_COOKIE['popup_shopGold_time']) && (int)$_COOKIE['popup_shopGold_time'] > 0 ) {
                  $WaznoscCookie = (int)$_COOKIE['popup_shopGold_time'];
             }
             //
             if ( (int)$_COOKIE['popup_shopGold'] > 0 ) {
                 setcookie("popup_shopGold", (int)$_COOKIE['popup_shopGold'] - 1, $WaznoscCookie, '/');
             }
             //
             unset($WaznoscCookie);
             //
      }
      //
      $tpl->dodaj('__JS_POPUP', '');
      $tpl->dodaj('__CSS_POPUP', '');
      $tpl->dodaj('__TRESC_POPUP', '');
    }

    // style css
    // style dodatkowe np listingow
    $tpl->dodaj('__CSS_PLIK', '');
    // jezeli nie jest strona glowna laduje css z podstronami
    $tpl->dodaj('__CSS_PLIK_GLOWNY', '');
    if ($GLOBALS['stronaGlowna'] == false) {
        $tpl->dodaj('__CSS_PLIK_GLOWNY', ',podstrony');
    }
    
    // wysuwany widget CENEO
    if ( ZAKLADKA_CENEO_WLACZONA == 'tak' && ZAKLADKA_CENEO_KOD != '') {
        $tpl->dodaj('__WIDGET_CENEO', ZAKLADKA_CENEO_KOD);
    } else {
        $tpl->dodaj('__WIDGET_CENEO', '');
    }

    // wysuwany widget Okazje.info
    if ( ZAKLADKA_OKAZJE_INFO_WLACZONA == 'tak' && ZAKLADKA_OKAZJE_INFO_KOD != '') {
        $tpl->dodaj('__WIDGET_OKAZJE_INFO', ZAKLADKA_OKAZJE_INFO_KOD);
    } else {
        $tpl->dodaj('__WIDGET_OKAZJE_INFO', '');
    }

    // wysuwany widget OPINEO
    if ( ZAKLADKA_OPINEO_WLACZONA == 'tak' && ZAKLADKA_OPINEO_KOD != '') {
        $tpl->dodaj('__WIDGET_OPINEO', ZAKLADKA_OPINEO_KOD);
    } else {
        $tpl->dodaj('__WIDGET_OPINEO', '');
    }

    // --------------------- definicje wygladu -----------------------------
    // ustalanie tla sklepu
    if (TLO_SKLEPU_RODZAJ == 'obraz') {
        $tpl->dodaj('__TLO_SKLEPU', "style=\"background:url('" . KATALOG_ZDJEC . "/" . TLO_SKLEPU . "') " . TLO_SKLEPU_POWTARZANIE . "; background-attachment:fixed;\"");
      } else { 
        $tpl->dodaj('__TLO_SKLEPU', 'style="background:#' . strtolower(TLO_SKLEPU) . '"');
    }

    // szerokosc sklepu
    $tpl->dodaj('__SZEROKOSC_SKLEPU', SZEROKOSC_SKLEPU);
    // szerokosc lewej kolumny + 15 na margines
    $tpl->dodaj('__SZEROKOSC_LEWEJ_KOLUMNY', SZEROKOSC_LEWEJ_KOLUMNY + 15);
    // szerokosc prawej kolumny + 15 na margines
    $tpl->dodaj('__SZEROKOSC_PRAWEJ_KOLUMNY', SZEROKOSC_PRAWEJ_KOLUMNY + 15);
    
    $SzerokoscSrodek = SZEROKOSC_SKLEPU;
    
    // moduly srodkowe nad czescia glowna sklepu z boxami   
    $tpl->dodaj('__MODULY_SRODKOWE_GORA', $Wyglad->SrodekSklepu( 'gora', (( $GLOBALS['stronaGlowna'] == true ) ? array(1,2) : array(1,3) ) ));
    
    // moduly srodkowe pod czescia glowna sklepu z boxami  
    $tpl->dodaj('__MODULY_SRODKOWE_DOL', $Wyglad->SrodekSklepu( 'dol', (( $GLOBALS['stronaGlowna'] == true ) ? array(1,2) : array(1,3) ) ));
    
    // moduly srodkowe w czesci glownej sklepu na podstronach
    $tpl->dodaj('__MODULY_SRODKOWE_PODSTRONA_GORA', '');
    $tpl->dodaj('__MODULY_SRODKOWE_PODSTRONA_DOL', '');
    
    if ($GLOBALS['stronaGlowna'] != true ) {
        //
        $tpl->dodaj('__MODULY_SRODKOWE_PODSTRONA_GORA', $Wyglad->SrodekSklepu( 'srodek', array(1,3), 'gora' ));
        $tpl->dodaj('__MODULY_SRODKOWE_PODSTRONA_DOL', $Wyglad->SrodekSklepu( 'srodek', array(1,3), 'dol' ));
        //
    }
    
    $tpl->dodaj('__LEWA_KOLUMNA', '');  
    
    $LewaKolumnaWlaczona = false;
    $PrawaKolumnaWlaczona = false;
    
    // sprawdzi czy wywolana strona nie jest do wyswietlania bez boxow
    $SprStrony = explode(';', STRONY_KOLUMNY_BOX);
    if ( isset($WywolanyPlik) && in_array($WywolanyPlik, $SprStrony) ) {
         unset($GLOBALS['kolumny']);
         $GLOBALS['kolumny'] = 'srodkowa';
    }         

    // czy tylko na podstronach
    if ($GLOBALS['stronaGlowna'] != true || ($GLOBALS['stronaGlowna'] == true && CZY_WLACZONA_LEWA_WSZEDZIE == 'nie')) {
    
        if (CZY_WLACZONA_LEWA_KOLUMNA == 'tak' && ($GLOBALS['kolumny'] == 'wszystkie' || $GLOBALS['kolumny'] == 'wszystkie_lewa')) {
            $SzerokoscSrodek = $SzerokoscSrodek - (SZEROKOSC_LEWEJ_KOLUMNY + 15);
            // boxy lewa kolumna
            $BoxyLewe = $Wyglad->KolumnaBoxu('lewa');
            if ( $BoxyLewe != '' ) {
                 $tpl->dodaj('__LEWA_KOLUMNA', $BoxyLewe);
                 $LewaKolumnaWlaczona = true;
              } else {
                 $LewaKolumnaWlaczona = false;
            }
            unset($BoxyLewe);
        }
        
    }
    
    $tpl->dodaj('__PRAWA_KOLUMNA', '');

    // czy tylko na podstronach
    if ($GLOBALS['stronaGlowna'] != true || ($GLOBALS['stronaGlowna'] == true && CZY_WLACZONA_PRAWA_WSZEDZIE == 'nie')) {
    
        if (CZY_WLACZONA_PRAWA_KOLUMNA == 'tak' && ($GLOBALS['kolumny'] == 'wszystkie' || $GLOBALS['kolumny'] == 'wszystkie_prawa')) {
            $SzerokoscSrodek = $SzerokoscSrodek - (SZEROKOSC_PRAWEJ_KOLUMNY + 15);
            // boxy prawa kolumna
            $BoxyPrawe = $Wyglad->KolumnaBoxu('prawa');
            if ( $BoxyPrawe != '' ) {
                 $tpl->dodaj('__PRAWA_KOLUMNA', $BoxyPrawe);
                 $PrawaKolumnaWlaczona = true;
              } else {
                 $PrawaKolumnaWlaczona = false;
            }
            unset($BoxyPrawe);            
        }
        
    }
    
    if ( $LewaKolumnaWlaczona == false && $PrawaKolumnaWlaczona == false ) {
         $GLOBALS['kolumny'] = 'srodkowa';
    }
    if ( $LewaKolumnaWlaczona == false && $PrawaKolumnaWlaczona == true ) {
         $GLOBALS['kolumny'] = 'wszystkie_prawa';
    }
    if ( $LewaKolumnaWlaczona == true && $PrawaKolumnaWlaczona == false ) {
         $GLOBALS['kolumny'] = 'wszystkie_lewa';
    }
    
    unset($LewaKolumnaWlaczona, $PrawaKolumnaWlaczona);

    $tpl->dodaj('__SZEROKOSC_SRODKOWEJ_KOLUMNY', $SzerokoscSrodek);

    // uzywane w niektorych szablonach jezeli srodek ma miec margines w stosunku do sklepu
    $tpl->dodaj('__SZEROKOSC_SRODKOWEJ_KOLUMNY_MINUS_10', $SzerokoscSrodek - 10);
    $tpl->dodaj('__SZEROKOSC_SRODKOWEJ_KOLUMNY_MINUS_20', $SzerokoscSrodek - 20);
    
    // preloader obrazkow
    $tpl->dodaj('__FUNKCJA_PRELOADERA', '');
    if ( PRELOAD_OBRAZKOW == 'tak' && WygladMobilny::UrzadzanieMobilne() == false ) {
        // ladowanie obrazkow
        $tpl->dodaj('__FUNKCJA_PRELOADERA', $Wyglad->PrzegladarkaJavaScript( "$.ZaladujObrazki(false);" ));   
    }
    
    // ikony jezykow
    $tpl->dodaj('__ZMIANA_JEZYKA', $Wyglad->ZmianaJezyka());
    
} else {

    $tpl->dodaj('__LOGO_SKLEPU_MOBILNE', '<a id="LinkLogo" href="/"><img src="' . KATALOG_ZDJEC . '/' . NAGLOWEK_MOBILNY . '" alt="' . htmlentities(DANE_NAZWA_FIRMY_SKROCONA) . '" title="' . htmlentities(DANE_NAZWA_FIRMY_SKROCONA) . '" /></a>');

    $WygladMobilny = new WygladMobilny();
    
    // jezyki
    $tpl->dodaj('__MOBILE_JEZYKI', $WygladMobilny->MobilnyZmianaJezyka());    

    // box kategorii
    $tpl->dodaj('__MOBILE_BOX_KATEGORIE', $WygladMobilny->BoxKategorie());  
    
    // box producentow
    $tpl->dodaj('__MOBILE_BOX_PRODUCENCI', $WygladMobilny->BoxProducenci());  
    
    // modul aktualnosci
    $tpl->dodaj('__MOBILE_MODUL_AKTUALNOSCI', $WygladMobilny->ModulAktualnosci());     
    
    // modul nowosci
    $tpl->dodaj('__MOBILE_MODUL_NOWOSCI', $WygladMobilny->ModulProduktow('nowosci', MOBILNY_ILE_NOWOSCI)); 

    // modul promocje
    $tpl->dodaj('__MOBILE_MODUL_PROMOCJE', $WygladMobilny->ModulProduktow('promocje', MOBILNY_ILE_PROMOCJI)); 

    // modul polecane
    $tpl->dodaj('__MOBILE_MODUL_POLECANE', $WygladMobilny->ModulProduktow('polecane', MOBILNY_ILE_POLECANE)); 
    
    // modul hity
    $tpl->dodaj('__MOBILE_MODUL_HITY', $WygladMobilny->ModulProduktow('hity', MOBILNY_ILE_HITOW));    
    
}    

// moduly stale
$ModulyStale = $Wyglad->ModulyStale();

// wyswietlanie wiadomosci z kto jest online
if ( WIADOMOSCI_POPUP == 'tak') {
     $ModulyStale .= "\n\n" . '<script>InformacjaOnline()</script>';
}

$tpl->dodaj('__MODULY_STALE', $ModulyStale);
unset($ModulyStale);

// logo/naglowek
if (NAGLOWEK_RODZAJ == 'kod') {
    $tpl->dodaj('__LOGO_SKLEPU', htmlspecialchars_decode(NAGLOWEK));
  } else {   
    if ( WLACZENIE_SSL == 'tak' ) {
        $tpl->dodaj('__LOGO_SKLEPU', '<a id="LinkLogo" href="'.ADRES_URL_SKLEPU.'"><img src="' . KATALOG_ZDJEC . '/' . NAGLOWEK . '" alt="' . htmlentities(DANE_NAZWA_FIRMY_SKROCONA) . '" title="' . htmlentities(DANE_NAZWA_FIRMY_SKROCONA) . '" /></a>');
    } else {
        $tpl->dodaj('__LOGO_SKLEPU', '<a id="LinkLogo" href="/"><img src="' . KATALOG_ZDJEC . '/' . NAGLOWEK . '" alt="' . htmlentities(DANE_NAZWA_FIRMY_SKROCONA) . '" title="' . htmlentities(DANE_NAZWA_FIRMY_SKROCONA) . '" /></a>');
    }
}

// gorne menu
$tpl->dodaj('__GORNE_MENU', '<ul>' . $Wyglad->Linki('gorne_menu', '<li aria-haspopup="true">', '</li>') . '</ul>');

// dolne menu
$tpl->dodaj('__DOLNE_MENU', '<ul>' . $Wyglad->Linki('dolne_menu') . '</ul>');

// stopka

// pierwsza kolumna stopki
$tpl->dodaj('__PIERWSZA_KOLUMNA_STOPKI_NAGLOWEK', $GLOBALS['tlumacz']['STOPKA_NAGLOWEK_PIERWSZA']);
$tpl->dodaj('__PIERWSZA_KOLUMNA_STOPKI_LINKI', (($GLOBALS['tlumacz']['STOPKA_TEKST_PIERWSZA'] != '') ? '<div>' . $GLOBALS['tlumacz']['STOPKA_TEKST_PIERWSZA'] . '</div>' : '') . '<ul>' . $Wyglad->Linki('pierwsza_stopka') . '</ul>');

// druga kolumna stopki
$tpl->dodaj('__DRUGA_KOLUMNA_STOPKI_NAGLOWEK', $GLOBALS['tlumacz']['STOPKA_NAGLOWEK_DRUGA']);
$tpl->dodaj('__DRUGA_KOLUMNA_STOPKI_LINKI', (($GLOBALS['tlumacz']['STOPKA_TEKST_DRUGA'] != '') ? '<div>' . $GLOBALS['tlumacz']['STOPKA_TEKST_DRUGA'] . '</div>' : '') . '<ul>' . $Wyglad->Linki('druga_stopka') . '</ul>');

// trzecia kolumna stopki
$tpl->dodaj('__TRZECIA_KOLUMNA_STOPKI_NAGLOWEK', $GLOBALS['tlumacz']['STOPKA_NAGLOWEK_TRZECIA']);
$tpl->dodaj('__TRZECIA_KOLUMNA_STOPKI_LINKI', (($GLOBALS['tlumacz']['STOPKA_TEKST_TRZECIA'] != '') ? '<div>' . $GLOBALS['tlumacz']['STOPKA_TEKST_TRZECIA'] . '</div>' : '') . '<ul>' . $Wyglad->Linki('trzecia_stopka') . '</ul>');

// czwarta kolumna stopki
$tpl->dodaj('__CZWARTA_KOLUMNA_STOPKI_NAGLOWEK', $GLOBALS['tlumacz']['STOPKA_NAGLOWEK_CZWARTA']);
$tpl->dodaj('__CZWARTA_KOLUMNA_STOPKI_LINKI', (($GLOBALS['tlumacz']['STOPKA_TEKST_CZWARTA'] != '') ? '<div>' . $GLOBALS['tlumacz']['STOPKA_TEKST_CZWARTA'] . '</div>' : '') . '<ul>' . $Wyglad->Linki('czwarta_stopka') . '</ul>');

// piata kolumna stopki
$tpl->dodaj('__PIATA_KOLUMNA_STOPKI_NAGLOWEK', $GLOBALS['tlumacz']['STOPKA_NAGLOWEK_PIATA']);
$tpl->dodaj('__PIATA_KOLUMNA_STOPKI_LINKI', (($GLOBALS['tlumacz']['STOPKA_TEKST_PIATA'] != '') ? '<div>' . $GLOBALS['tlumacz']['STOPKA_TEKST_PIATA'] . '</div>' : '') . '<ul>' . $Wyglad->Linki('piata_stopka') . '</ul>');

// schowek
$tpl->dodaj('__ILOSC_PRODUKTOW_SCHOWKA', (isset($GLOBALS['schowekKlienta']->IloscProduktow) ? $GLOBALS['schowekKlienta']->IloscProduktow: ''));

// koszyk
$ZawartoscKoszyka = $GLOBALS['koszykKlienta']->ZawartoscKoszyka();
$tpl->dodaj('__ILOSC_PRODUKTOW_KOSZYKA', $ZawartoscKoszyka['ilosc']);
$tpl->dodaj('__WARTOSC_KOSZYKA_BRUTTO', $GLOBALS['waluty']->WyswietlFormatCeny($ZawartoscKoszyka['brutto'], $_SESSION['domyslnaWaluta']['id'], true, false));  

// kompresja styli css
$tpl->dodaj('__KOMPRESJA_CSS', (( KOMPRESJA_CSS == 'tak' ) ? 'css' : 'ncss' ));

// jezeli aktywne opinie o sklepie
$tpl->dodaj('__CSS_OPINIE', ((OPINIE_STATUS == 'tak') ? ',opinie' : ''));

// liczniki odwiedzin
$tpl->dodaj('__ILOSC_ODWIEDZIN', $GLOBALS['licznikOdwiedzinSklepu']);
unset($GLOBALS['licznikOdwiedzinSklepu']);

if ( LICZNIK_ODWIEDZIN_DATA == '' ) {
    $GLOBALS['db']->open_query("UPDATE settings SET value = '" . time() . "' WHERE code = 'LICZNIK_ODWIEDZIN_DATA'");
    $tpl->dodaj('__DATA_LICZNIKA_ODWIEDZIN', date('d-m-Y',time()));
} else {
    $tpl->dodaj('__DATA_LICZNIKA_ODWIEDZIN', date('d-m-Y',LICZNIK_ODWIEDZIN_DATA));
}

$tpl->dodaj('__TAGI_OPEN_GRAPH', '');

$tpl->dodaj('__INTEGRACJE_WLASNE_HEAD', ((KOD_HEAD != '') ? base64_decode(KOD_HEAD) : ''));
$tpl->dodaj('__INTEGRACJE_WLASNE_BODY', ((KOD_BODY != '') ? base64_decode(KOD_BODY) : ''));

// kod Google remarketing dynamiczny
if ( INTEGRACJA_GOOGLE_KONWERSJA_WLACZONY == 'tak' && INTEGRACJA_GOOGLE_KONWERSJA != '' ) {

    if ( $WywolanyPlik != 'koszyk' ) {

        $kod_google_konwersja = Google::GoogleWyswietlKod();
        $tpl->dodaj('__GOOGLE_KONWERSJA', $kod_google_konwersja);

    }

} else {
    $tpl->dodaj('__GOOGLE_KONWERSJA', '');
}

$tpl->dodaj('__INFO_SG',Funkcje::Sg('PGEgaHJlZj0iaHR0cHM6Ly93d3cuc2hvcGdvbGQucGwiIHRhcmdldD0iX2JsYW5rIj5PcHJvZ3JhbW93YW5pZSBza2xlcHUgc2hvcEdvbGQucGw8L2E+'));
?>