<?php

class MetaTagi {

  // funkcja zwraca meta tagi dla wybranej strony
  public static function ZwrocMetaTagi( $link = '' ) {
    global $filtr;
    
    $link = str_replace('/', '', $link);

    // pobieranie wartosci domyslnych
    
    // cache zapytania
    $WynikCache = $GLOBALS['cache']->odczytaj('MetaTagiDomyslne_' . $_SESSION['domyslnyJezyk']['kod'], CACHE_INNE);   
    
    if ( !$WynikCache ) {  
    
        $zapytanieDomyslne = "SELECT default_title, 
                                     default_keywords, 
                                     default_description, 
                                     default_index_title, 
                                     default_index_keywords, 
                                     default_index_description 
                                FROM headertags_default 
                               WHERE language_id = '" . $_SESSION['domyslnyJezyk']['id'] . "'";
                               
        $sqlDomyslne = $GLOBALS['db']->open_query($zapytanieDomyslne);
        
        $Domyslne = $sqlDomyslne->fetch_assoc();
        
        $GLOBALS['db']->close_query($sqlDomyslne);
        unset($zapytanieDomyslne, $sqlDomyslne);
        
        $GLOBALS['cache']->zapisz('MetaTagiDomyslne_' . $_SESSION['domyslnyJezyk']['kod'], $Domyslne, CACHE_INNE);   
  
      } else {
      
        $Domyslne = $WynikCache;
        
    }    
    
    unset($WynikCache);
    
    // jezeli jest to strona glowna sklepu
    
    if ( $link == 'strona_glowna' ) {
    
        $metaTytul = $Domyslne['default_index_title'];
        $metaSlowa = $Domyslne['default_index_keywords'];
        $metaOpis = $Domyslne['default_index_description']; 
        
      } else {
      
        $metaTytul = $Domyslne['default_title'];
        $metaSlowa = $Domyslne['default_keywords'];
        $metaOpis = $Domyslne['default_description']; 

    }
    
    $ZdefiniowaneMeta = false;

    if ( $link != '' ) {
    
        // cache zapytania 
        $WynikCache = $GLOBALS['cache']->odczytaj('MetaTagiPodstrony_' . $_SESSION['domyslnyJezyk']['kod'], CACHE_INNE);   
        
        $Podstrony = array();
        
        if ( !$WynikCache ) {
    
            $zapytanie = "SELECT page_name, page_title, page_keywords, page_description, append_default, sortorder FROM headertags WHERE language_id = '" . $_SESSION['domyslnyJezyk']['id'] . "'";
            $sql = $GLOBALS['db']->open_query($zapytanie);
            
            $Podstrony = array();
            while ( $info = $sql->fetch_assoc() ) {
                //
                $Podstrony[] = array('nazwa_pliku' => $info['page_name'],
                                     'tytul' => $info['page_title'],
                                     'slowa_kluczowe' => $info['page_keywords'],
                                     'opis' => $info['page_description'],
                                     'domyslne' => $info['append_default'],
                                     'sort' => $info['sortorder']);
                //
            }
            $GLOBALS['db']->close_query($sql);  
            unset($zapytanie, $info);
            
            $GLOBALS['cache']->zapisz('MetaTagiPodstrony_' . $_SESSION['domyslnyJezyk']['kod'], $Podstrony, CACHE_INNE);   
            
        } else {
        
            $Podstrony = $WynikCache;
            
        }            

        foreach ( $Podstrony as $Podstrona) {
            //
            if ( $Podstrona['nazwa_pliku'] == $filtr->process($link) ) {
                //
                // jezeli ma dodawac wartosc domyslna
                if ($Podstrona['domyslne'] == 1) {
                    //
                    // czy na poczatku czy na koncu
                    if ($Podstrona['sort'] == 1) {
                        //
                        $metaTytul = $Domyslne['default_title'] . ' ' . $Podstrona['tytul'];
                        $metaSlowa = $Domyslne['default_keywords'] . ' ' . $Podstrona['slowa_kluczowe'];
                        $metaOpis = $Domyslne['default_description'] . ' ' . $Podstrona['opis'];
                        //
                      } else {
                        //
                        $metaTytul = $Podstrona['tytul'] . ' ' . $Domyslne['default_title'];
                        $metaSlowa = $Podstrona['slowa_kluczowe'] . ' ' . $Domyslne['default_keywords'];
                        $metaOpis = $Podstrona['opis'] . ' ' . $Domyslne['default_description'];
                        //
                    }
                    //
                } else {
                    //
                    $metaTytul = $Podstrona['tytul'];
                    $metaSlowa = $Podstrona['slowa_kluczowe'];
                    $metaOpis = $Podstrona['opis'];            
                    //
                }
                //
                $ZdefiniowaneMeta = true;
                //
            }
            //
        }
        
        unset($Podstrony);

    }

    $tablica = array( 'nazwa_pliku' => (($ZdefiniowaneMeta == true) ? $link : null),
                      'tytul' => $metaTytul,
                      'opis' => $metaOpis,
                      'slowa' => $metaSlowa );
    
    unset($metaTytul, $metaSlowa, $metaOpis, $Domyslne);    

    return $tablica;
  }  
  
  public static function MetaTagiProduktPodmien( $Rodzaj = '', $Produkt, $Meta ) {
    
    // tytul produktu meta
    if ( $Rodzaj == 'tytul' ) {
      
        if ( $Produkt->metaTagi['tytul_uzupelniony'] == false && trim($Meta['tytul']) != '' ) {
            $TrescMeta = $Meta['tytul'];
         } else {
            $TrescMeta = ((empty($Produkt->metaTagi['tytul'])) ? $Meta['tytul'] : $Produkt->metaTagi['tytul']);
        }
         
    }
    
    // slowa kluczowe produktu meta
    if ( $Rodzaj == 'slowa' ) {
      
        if ( $Produkt->metaTagi['slowa_uzupelnione'] == false && trim($Meta['slowa']) != '' ) {
            $TrescMeta = $Meta['slowa'];
         } else {
            $TrescMeta = ((empty($Produkt->metaTagi['slowa'])) ? $Meta['slowa'] : $Produkt->metaTagi['slowa']);
        }
         
    }

    // opis produktu meta
    if ( $Rodzaj == 'opis' ) {
      
        if ( $Produkt->metaTagi['opis_uzupelniony'] == false && trim($Meta['opis']) != '' ) {
            $TrescMeta = $Meta['opis'];
         } else {
            $TrescMeta = ((empty($Produkt->metaTagi['opis'])) ? $Meta['opis'] : $Produkt->metaTagi['opis']);
        }
         
    }    
    
    // podmiana zmiennych
    $TrescMeta = str_replace('{NAZWA_PRODUKTU}', strip_tags($Produkt->info['nazwa']), $TrescMeta);         
    $TrescMeta = str_replace('{DUZE_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);   

    $TrescMeta = str_replace('{NAZWA_PRODUCENTA}', strip_tags($Produkt->info['nazwa_producenta']), $TrescMeta);
    $TrescMeta = str_replace('{DUZE_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);

    //
    $KategorieProduktu = $Produkt->ProduktKategoriaGlowna();
    
    if ( isset($KategorieProduktu['id']) ) {
        //
        $NazwaKategorii = Kategorie::NazwaKategoriiId($KategorieProduktu['id']);
        //
        $TrescMeta = str_replace('{NAZWA_KATEGORII}', strip_tags($NazwaKategorii), $TrescMeta);
        $TrescMeta = str_replace('{DUZE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
        $TrescMeta = str_replace('{MALE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_LOWER, "UTF-8"), $TrescMeta);            
        $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_TITLE, "UTF-8"), $TrescMeta);
        
        // sciezka kategorii
        $KategoriaSciezka = Kategorie::SciezkaKategoriiId($KategorieProduktu['id'], 'nazwy', ' - ');
        $TrescMeta = str_replace('{SCIEZKA_KATEGORII}', strip_tags($KategoriaSciezka), $TrescMeta);
        
        unset($KategoriaSciezka, $NazwaKategorii);
    }
    
    //
    unset($KategorieProduktu);
    //
    $TrescMeta = str_replace('{NR_KATALOGOWY}', strip_tags($Produkt->info['nr_katalogowy']), $TrescMeta);
    $TrescMeta = str_replace('{KOD_PRODUCENTA}', strip_tags($Produkt->info['kod_producenta']), $TrescMeta);
    $TrescMeta = str_replace('{KOD_EAN}', strip_tags($Produkt->info['ean']), $TrescMeta);    
    
    // opis krotki
    $TrescMeta = str_replace('{OPIS_PRODUKTU}', Funkcje::UsunFormatowanie($Produkt->info['opis_krotki']), $TrescMeta);    
  
    return $TrescMeta;
  
  }
  
  public static function MetaTagiListingKategoriePodmien( $Rodzaj = '', $TrescMeta, $info ) {

    $TrescMeta = str_replace('{NAZWA_KATEGORII}', strip_tags($info['categories_name']), $TrescMeta);
    $TrescMeta = str_replace('{DUZE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($info['categories_name']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($info['categories_name']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);            
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_KATEGORII}', mb_convert_case(strip_tags($info['categories_name']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);
    
    // sciezka kategorii
    $KategoriaSciezka = Kategorie::SciezkaKategoriiId($info['categories_id'], 'nazwy', ' - ');
    $TrescMeta = str_replace('{SCIEZKA_KATEGORII}', strip_tags($KategoriaSciezka), $TrescMeta);
    
    unset($KategoriaSciezka);

    // opis krotki
    $TrescMeta = str_replace('{OPIS_KATEGORII}', Funkcje::UsunFormatowanie($info['categories_description']), $TrescMeta);    
  
    return $TrescMeta;
  
  } 
  
  public static function MetaTagiRecenzjaPodmien( $Rodzaj = '', $Produkt, $TrescMeta, $IdRecenzji ) {
     
    // podmiana zmiennych
    $TrescMeta = str_replace('{NAZWA_PRODUKTU}', strip_tags($Produkt->info['nazwa']), $TrescMeta);         
    $TrescMeta = str_replace('{DUZE_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);   

    $TrescMeta = str_replace('{NAZWA_PRODUCENTA}', strip_tags($Produkt->info['nazwa_producenta']), $TrescMeta);
    $TrescMeta = str_replace('{DUZE_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);

    //
    $KategorieProduktu = $Produkt->ProduktKategoriaGlowna();
    
    if ( isset($KategorieProduktu['id']) ) {
        //
        $NazwaKategorii = Kategorie::NazwaKategoriiId($KategorieProduktu['id']);
        //
        $TrescMeta = str_replace('{NAZWA_KATEGORII}', strip_tags($NazwaKategorii), $TrescMeta);
        $TrescMeta = str_replace('{DUZE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
        $TrescMeta = str_replace('{MALE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_LOWER, "UTF-8"), $TrescMeta);            
        $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_TITLE, "UTF-8"), $TrescMeta);
        
        // sciezka kategorii
        $KategoriaSciezka = Kategorie::SciezkaKategoriiId($KategorieProduktu['id'], 'nazwy', ' - ');
        $TrescMeta = str_replace('{SCIEZKA_KATEGORII}', strip_tags($KategoriaSciezka), $TrescMeta);
        
        unset($KategoriaSciezka, $NazwaKategorii);
    }
    
    //
    unset($KategorieProduktu);
    //
    $TrescMeta = str_replace('{NR_KATALOGOWY}', strip_tags($Produkt->info['nr_katalogowy']), $TrescMeta);
    $TrescMeta = str_replace('{KOD_PRODUCENTA}', strip_tags($Produkt->info['kod_producenta']), $TrescMeta);
    $TrescMeta = str_replace('{KOD_EAN}', strip_tags($Produkt->info['ean']), $TrescMeta);    
    
    // opis krotki
    $TrescMeta = str_replace('{OPIS_PRODUKTU}', Funkcje::UsunFormatowanie($Produkt->info['opis_krotki']), $TrescMeta);    
    
    // dane recenzji
    $TrescMeta = str_replace('{AUTOR_RECENZJI}', strip_tags($Produkt->recenzje[$IdRecenzji]['recenzja_oceniajacy']), $TrescMeta);    
    $TrescMeta = str_replace('{DATA_RECENZJI}', strip_tags($Produkt->recenzje[$IdRecenzji]['recenzja_data_dodania']), $TrescMeta);  
    $TrescMeta = str_replace('{TRESC_RECENZJI}', Funkcje::UsunFormatowanie($Produkt->recenzje[$IdRecenzji]['recenzja_tekst']), $TrescMeta); 
    
    return $TrescMeta;
  
  }  
  
  public static function MetaTagiRecenzjeNapiszPodmien( $Rodzaj = '', $Produkt, $TrescMeta ) {
    
    // podmiana zmiennych
    $TrescMeta = str_replace('{NAZWA_PRODUKTU}', strip_tags($Produkt->info['nazwa']), $TrescMeta);         
    $TrescMeta = str_replace('{DUZE_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_PRODUKTU}', mb_convert_case(strip_tags($Produkt->info['nazwa']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);   

    $TrescMeta = str_replace('{NAZWA_PRODUCENTA}', strip_tags($Produkt->info['nazwa_producenta']), $TrescMeta);
    $TrescMeta = str_replace('{DUZE_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_PRODUCENTA}', mb_convert_case(strip_tags($Produkt->info['nazwa_producenta']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);

    //
    $KategorieProduktu = $Produkt->ProduktKategoriaGlowna();
    
    if ( isset($KategorieProduktu['id']) ) {
        //
        $NazwaKategorii = Kategorie::NazwaKategoriiId($KategorieProduktu['id']);
        //
        $TrescMeta = str_replace('{NAZWA_KATEGORII}', strip_tags($NazwaKategorii), $TrescMeta);
        $TrescMeta = str_replace('{DUZE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
        $TrescMeta = str_replace('{MALE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_LOWER, "UTF-8"), $TrescMeta);            
        $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_KATEGORII}', mb_convert_case(strip_tags($NazwaKategorii), MB_CASE_TITLE, "UTF-8"), $TrescMeta);
        
        // sciezka kategorii
        $KategoriaSciezka = Kategorie::SciezkaKategoriiId($KategorieProduktu['id'], 'nazwy', ' - ');
        $TrescMeta = str_replace('{SCIEZKA_KATEGORII}', strip_tags($KategoriaSciezka), $TrescMeta);
        
        unset($KategoriaSciezka, $NazwaKategorii);
    }
    
    //
    unset($KategorieProduktu);
    //
    $TrescMeta = str_replace('{NR_KATALOGOWY}', strip_tags($Produkt->info['nr_katalogowy']), $TrescMeta);
    $TrescMeta = str_replace('{KOD_PRODUCENTA}', strip_tags($Produkt->info['kod_producenta']), $TrescMeta);
    $TrescMeta = str_replace('{KOD_EAN}', strip_tags($Produkt->info['ean']), $TrescMeta);    
    
    // opis krotki
    $TrescMeta = str_replace('{OPIS_PRODUKTU}', Funkcje::UsunFormatowanie($Produkt->info['opis_krotki']), $TrescMeta);    
  
    return $TrescMeta;
  
  }  
  
  public static function MetaTagiArtykulPodmien( $Rodzaj = '', $Artykul, $Meta ) {
    
    // tytul produktu meta
    if ( $Rodzaj == 'tytul' ) {
      
        if ( $Artykul['meta_tytul_uzupelniony'] == false && trim($Meta['tytul']) != '' ) {
            $TrescMeta = $Meta['tytul'];
         } else {
            $TrescMeta = ((empty($Artykul['meta_tytul'])) ? $Meta['tytul'] : $Artykul['meta_tytul']);
        }
         
    }
    
    // slowa kluczowe produktu meta
    if ( $Rodzaj == 'slowa' ) {
      
        if ( $Artykul['meta_slowa_uzupelnione'] == false && trim($Meta['slowa']) != '' ) {
            $TrescMeta = $Meta['slowa'];
         } else {
            $TrescMeta = ((empty($Artykul['meta_slowa'])) ? $Meta['slowa'] : $Artykul['meta_slowa']);
        }
         
    }

    // opis produktu meta
    if ( $Rodzaj == 'opis' ) {
      
        if ( $Artykul['meta_opis_uzupelniony'] == false && trim($Meta['opis']) != '' ) {
            $TrescMeta = $Meta['opis'];
         } else {
            $TrescMeta = ((empty($Artykul['meta_opis'])) ? $Meta['opis'] : $Artykul['meta_opis']);
        }
         
    }    
    
    // podmiana zmiennych
    $TrescMeta = str_replace('{TYTUL_ARTYKULU}', strip_tags($Artykul['tytul']), $TrescMeta);         
    $TrescMeta = str_replace('{DUZE_TYTUL_ARTYKULU}', mb_convert_case(strip_tags($Artykul['tytul']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_TYTUL_ARTYKULU}', mb_convert_case(strip_tags($Artykul['tytul']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{Z_DUZEJ_TYTUL_ARTYKULU}', mb_convert_case(strip_tags($Artykul['tytul']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);   
    
    $TrescMeta = str_replace('{TRESC_ARTYKULU}', Funkcje::UsunFormatowanie($Artykul['opis_krotki']), $TrescMeta); 

    $TrescMeta = str_replace('{NAZWA_KATEGORII}', strip_tags($Artykul['nazwa_kategorii']), $TrescMeta);
    $TrescMeta = str_replace('{DUZE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($Artykul['nazwa_kategorii']), MB_CASE_UPPER, "UTF-8"), $TrescMeta);
    $TrescMeta = str_replace('{MALE_NAZWA_KATEGORII}', mb_convert_case(strip_tags($Artykul['nazwa_kategorii']), MB_CASE_LOWER, "UTF-8"), $TrescMeta);            
    $TrescMeta = str_replace('{Z_DUZEJ_NAZWA_KATEGORII}', mb_convert_case(strip_tags($Artykul['nazwa_kategorii']), MB_CASE_TITLE, "UTF-8"), $TrescMeta);

    return $TrescMeta;
  
  }  
  
  // funkcja zwraca tagi open graph dla strony glownej
  public static function ZwrocTagiOpenGraph() {
    
    // cache zapytania
    $WynikCache = $GLOBALS['cache']->odczytaj('OpenGraphDomyslne_' . $_SESSION['domyslnyJezyk']['kod'], CACHE_INNE);   
    
    if ( !$WynikCache ) {  
    
        $zapytanie = "SELECT og_title, 
                             og_site_name, 
                             og_description, 
                             og_image
                        FROM headertags_default 
                       WHERE language_id = '" . $_SESSION['domyslnyJezyk']['id'] . "'";
                               
        $sqlOpenGraph = $GLOBALS['db']->open_query($zapytanie);
        
        $TagiOpenGraph = $sqlOpenGraph->fetch_assoc();
        
        $GLOBALS['db']->close_query($sqlOpenGraph);
        unset($zapytanie, $sqlOpenGraph);
        
        $GLOBALS['cache']->zapisz('OpenGraphDomyslne_' . $_SESSION['domyslnyJezyk']['kod'], $TagiOpenGraph, CACHE_INNE);   
  
      } else {
      
        $TagiOpenGraph = $WynikCache;
        
    }    
    
    unset($WynikCache);
    
    $tablica = array();
    
    if ( trim($TagiOpenGraph['og_title']) != '' && trim($TagiOpenGraph['og_site_name']) != '' && trim($TagiOpenGraph['og_description']) != '' && trim($TagiOpenGraph['og_image']) != '' ) {
    
        $tablica = array( 'og_title' => $TagiOpenGraph['og_title'],
                          'og_site_name' => $TagiOpenGraph['og_site_name'],
                          'og_description' => $TagiOpenGraph['og_description'],
                          'og_image' => ADRES_URL_SKLEPU . '/' . KATALOG_ZDJEC . '/' . $TagiOpenGraph['og_image'] );
                          
    }

    return $tablica;
  }    

} 

?>