<?php

class FreshMail {

    private $key = INTEGRACJA_FRESHMAIL_KEY; 
    private $secret = INTEGRACJA_FRESHMAIL_SEKRET; 
    
    // zapisanie do newslettera
    public function ZapiszSubskrybenta( $adres_email = '', $aktywacja = 1, $nazwaListy = '', $bezPowrotu = false ) {
      
        $mailing = new FmRestApi();
        $mailing->setApiKey( $this->key );
        $mailing->setApiSecret( $this->secret );      
        
        $hash = FreshMail::ListaOdbiorcowHash( $nazwaListy );
      
        // 'confirm' => 1 - wyslanie linku aktywacyjnego - dziala tylko ze state = 2
        $data = array(
            'email' => $adres_email,
            'list' => $hash,
            'state' => $aktywacja  // 1 - aktywny , 2 - do aktywacji, 4 - wypisany
        );      
        
        // wynik
        // [status] == OK
        
        // error - jezeli nie doda
        // [status] == ERROR
        // [kod_bledu] = 1304 - subskrybent już istnieje w tej liście subskrypcyjnej i ma status Aktywny lub Do aktywacji       
                
        try {
            //
            $wynik = $mailing->doRequest('subscriber/add', $data);
            return $wynik;
            //
        } catch (Exception $e) {
            //
            if ( $bezPowrotu == false ) {
                //
                // usuwa subskrybenta
                FreshMail::UsunSubskrybenta( $adres_email, $nazwaListy );
                //
                // dodaje
                FreshMail::ZapiszSubskrybenta( $adres_email, 1, $nazwaListy, true );
                //
            }
            //
            return array('status' => 'ERROR',
                         'info' => $e->getMessage(),
                         'kod_bledu' => $e->getCode(),
                         'kod_http' => $mailing->getHttpCode());
            //
        }        
      
    }
    
    // wypisanie z newslettera
    public function UsunSubskrybenta( $adres_email = '', $nazwaListy = '', $ustalHash = true ) {
      
        $mailing = new FmRestApi();
        $mailing->setApiKey( $this->key );
        $mailing->setApiSecret( $this->secret );   
        
        if ( $nazwaListy != '' ) {

            if ( $ustalHash == true ) {
                 //
                 $hash = FreshMail::ListaOdbiorcowHash( $nazwaListy );
                 //
              } else {
                 //
                 $hash = $nazwaListy;
                 //
            }
          
            $data = array(
                'email' => $adres_email,
                'list' => $hash
            );      
            
            // wynik
            // [status] == OK
            
            // error - jezeli nie usunie
            // [status] == ERROR
            // [kod_bledu] = 1321 - adres email nie istnieje w tej liście subskrypcyjnej             
                    
            try {
                //
                $wynik = $mailing->doRequest('subscriber/delete', $data);
                return $wynik;
                //
            } catch (Exception $e) {
                //
                return array('status' => 'ERROR',
                             'info' => $e->getMessage(),
                             'kod_bledu' => $e->getCode(),
                             'kod_http' => $mailing->getHttpCode());
                //
            }  

        }
        
        // usuwa ze wszystkich list
        $TablicaList = FreshMail::ListyOdbiorcow();
        //
        if ( isset($TablicaList['lists']) && count($TablicaList['lists']) > 0 ) {
            //
            foreach ( $TablicaList['lists'] as $Lista ) {
                //
                FreshMail::UsunSubskrybenta( $adres_email, $Lista['subscriberListHash'], false );
                //
            }
            //
        }        
      
    }    
    
    // zapisanie do newslettera wielu subskrybentow
    public function ZapiszWieluSubskrybentow( $adresy_email = array(), $aktywacja = 1, $nazwaListy = '' ) {
      
        $mailing = new FmRestApi();
        $mailing->setApiKey( $this->key );
        $mailing->setApiSecret( $this->secret ); 
        
        $hash = FreshMail::ListaOdbiorcowHash( $nazwaListy );

        $emails = array();
        foreach ( $adresy_email as $adres ) {
            //
            $emails[] = array( 'email' => $adres );
            //
        }

        // 'confirm' => 1 - wyslanie linku aktywacyjnego - dziala tylko ze state = 2
        $data = array('subscribers' => $emails,
                      'list' => $hash,
                      'state' => $aktywacja  // 1 - aktywny , 2 - do aktywacji, 4 - wypisany
        );      
        
        // wynik
        // [status] == OK
        // [data][inserted]
        // [data][not_inserted]
        
        // error - jezeli nic nie usunie
        // [status] == ERROR
        // [kod_bledu] = 1331 - nie udało się dodać/aktualizować żadnego subskrybenta       
                
        try {
            //
            $wynik = $mailing->doRequest('subscriber/addMultiple', $data);
            return $wynik;
            //
        } catch (Exception $e) {
            //
            return array('status' => 'ERROR',
                         'info' => $e->getMessage(),
                         'kod_bledu' => $e->getCode(),
                         'kod_http' => $mailing->getHttpCode());
            //
        }        
      
    }    
    
    // usuniecie newslettera wielu subskrybentow
    public function UsunWieluSubskrybentow( $adresy_email = array(), $nazwaListy = '' ) {
      
        $mailing = new FmRestApi();
        $mailing->setApiKey( $this->key );
        $mailing->setApiSecret( $this->secret ); 
        
        $hash = FreshMail::ListaOdbiorcowHash( $nazwaListy );

        $emails = array();
        foreach ( $adresy_email as $adres ) {
            //
            $emails[] = array( 'email' => $adres );
            //
        }

        $data = array('subscribers' => $emails,
                      'list' => $hash
        );      
                
        // wynik
        // [status] == OK
        // [data][deleted]
        // [data][not_deleted]
        
        // error - jezeli nic nie usunie
        // [status] == ERROR
        // [kod_bledu] = 1352 - zaden z subskrybentów nie istnieje/nie został skasowany
        
        try {
            //
            $wynik = $mailing->doRequest('subscriber/deleteMultiple', $data);
            return $wynik;
            //
        } catch (Exception $e) {
            //
            return array('status' => 'ERROR',
                         'info' => $e->getMessage(),
                         'kod_bledu' => $e->getCode(),
                         'kod_http' => $mailing->getHttpCode());
            //
        }        
      
    }     
    
    // pobranie list odbiorcow
    public function ListyOdbiorcow() {
      
        $mailing = new FmRestApi();
        $mailing->setApiKey( $this->key );
        $mailing->setApiSecret( $this->secret );

        // wynik        
        // [status] = OK
        // [lists] = array(
        
        // [subscriberListHash] => xxxxx
        // [name] => Testowa lista z Twoim adresem email
        // [description] => 
        // [creation_date] => 2015-09-11 13:59:16
        // [subscribers_number] => 2        
        
        try {
            //
            $wynik = $mailing->doRequest('subscribers_list/lists');
            return $wynik;
            //
        } catch (Exception $e) {
            //
            return array('status' => 'ERROR',
                         'info' => $e->getMessage(),
                         'kod_bledu' => $e->getCode(),
                         'kod_http' => $mailing->getHttpCode());
            //
        }        
      
    }    
    
    // zwraca hash listy
    public function ListaOdbiorcowHash( $nazwa = '' ) {
        //
        $TablicaList = FreshMail::ListyOdbiorcow();
        //
        $JestLista = false;
        $HashListy = '';
        //
        // szuka czy dana lista istnieje
        if ( isset($TablicaList['lists']) && count($TablicaList['lists']) > 0 ) {
            //
            foreach ( $TablicaList['lists'] as $Lista ) {
                //
                if ( $Lista['name'] == trim($nazwa) ) {
                     //
                     $JestLista = true;
                     $HashListy = $Lista['subscriberListHash'];
                     //
                }
                //
            }
            //
        }
        //
        // jezeli nie znalazl listy utworzy nowa
        if ( $JestLista == false ) {
            //
            $HashNowejListy = FreshMail::ListaOdbiorcowDodaj( trim($nazwa) );
            //
            if ( isset($HashNowejListy['hash']) && trim($HashNowejListy['hash']) != '' ) {
                //
                $HashListy = $HashNowejListy['hash'];
                //
            }
            //
        }
        //
        return $HashListy;
        //
      
    }
    
    // dodaje nowa liste odbiorcow
    public function ListaOdbiorcowDodaj( $nazwa = '' ) {
        //
        $mailing = new FmRestApi();
        $mailing->setApiKey( $this->key );
        $mailing->setApiSecret( $this->secret );
        
        $data = array('name' => $nazwa);         

        // wynik        
        // [status] = OK
        // [hash] = dk3dtnwu6kdd

        try {
            //
            $wynik = $mailing->doRequest('subscribers_list/create', $data);
            return $wynik;
            //
        } catch (Exception $e) {
            //
            return array('status' => 'ERROR',
                         'info' => $e->getMessage(),
                         'kod_bledu' => $e->getCode(),
                         'kod_http' => $mailing->getHttpCode());
            //
        }           
        //
    }
    
    // sprawdzenie zgodności z filtrami SpamAssassin
    public function TestSpam( $mail ) {
      
        $mailing = new FmRestApi();
        $mailing->setApiKey( $this->key );
        $mailing->setApiSecret( $this->secret );

        // wynik        
        // [status] = OK
        // [lists] = array(
        
        // [subscriberListHash] => xxxxx
        // [name] => Testowa lista z Twoim adresem email
        // [description] => 
        // [creation_date] => 2015-09-11 13:59:16
        // [subscribers_number] => 2       

        $data = array('subject' => $mail['temat'],
                      'from' => $mail['adres_nadawcy'],
                      'from_name' => $mail['nazwa_nadawcy'],
                      'html' => $mail['html']
        );           
        
        try {
            //
            $wynik = $mailing->doRequest('spam_test/check', $data);
            return $wynik;
            //
        } catch (Exception $e) {
            //
            return array('status' => 'ERROR',
                         'info' => $e->getMessage(),
                         'kod_bledu' => $e->getCode(),
                         'kod_http' => $mailing->getHttpCode());
            //
        }        
      
    }        

} 

?>